// This file has been generated by the SAPUI5 'AllInOne' Builder
/*!
 * @copyright@
 */

sap.ui.getCore().attachInit(function () {
	"use strict";

	/*global jQuery */
	jQuery.sap.includeStyleSheet(jQuery.sap.getResourcePath("sap/ui/demokit/demoapps/css/style.css"));

	sap.ui.require(["sap/ui/core/ComponentContainer"], function (ComponentContainer) {
		new ComponentContainer({
			name : "sap.ui.demokit.demoapps"
		}).placeAt("content");
	});

});
jQuery.sap.declare('sap.ui.demokit.library-all');
jQuery.sap.declare('sap.ui.demokit.demoapps.all'); // raw module, declared by SAPUI5 'AllInOne' Builder
if ( !jQuery.sap.isDeclared('sap.ui.demokit.CodeSampleContainerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.CodeSampleContainer
jQuery.sap.declare('sap.ui.demokit.CodeSampleContainerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/CodeSampleContainerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * CodeSampleContainer renderer.
	 * @namespace
	 * @alias sap.ui.demokit.CodeSampleContainerRenderer
	 */
	var CodeSampleContainerRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	CodeSampleContainerRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;

		rm.write("<div");
		rm.writeControlData(oControl);
		rm.write(" class='sapUiDKitCSample sapUiShd'");
		var sWidth = oControl.getWidth();
		if (sWidth) {
			rm.addStyle("width", sWidth);
		}
		rm.writeStyles();
		rm.write(">");

		rm.write("<div id='", jQuery.sap.encodeHTML(oControl.getUiAreaId()), "'");
		rm.write(" class='sapUiBody'");
		rm.write(">");
		var aContent = oControl._oUIArea.getContent();
		for (var i = 0; i < aContent.length; i++) {
			rm.renderControl(aContent[i]);
		}
		rm.write("</div>");

		rm.write("<div class='sapUiDKitCSampleBorder'>");
		rm.renderControl(oControl._oShowCodeLink);
		rm.write(" ");
		rm.renderControl(oControl._oApplyCodeLink);
		rm.write(" ");
		rm.renderControl(oControl._oCodeViewer);
		rm.write("</div>");

		rm.write("</div>");

	};


	return CodeSampleContainerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/CodeSampleContainerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.CodeViewerRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.CodeViewer
jQuery.sap.declare('sap.ui.demokit.CodeViewerRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/CodeViewerRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * CodeViewer renderer.
	 * @namespace
	 * @alias sap.ui.demokit.CodeViewerRenderer
	 */
	var CodeViewerRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	CodeViewerRenderer.render = function(oRM, oControl){

		if ( !oControl.getVisible() ) {
			return;
		}

		// write the HTML into the render manager
		oRM.write("<pre");
		oRM.writeControlData(oControl);
		if ( oControl.getEditable() ) {
			oRM.addClass("sapUiCodeViewer");
			oRM.addClass("editable");
			oRM.writeAttribute("contentEditable", "true");
		} else {
			oRM.addClass("prettyprint"); // this class acts as a 'TODO' for the pretty printer!
		}
		if (oControl.getLineNumbering()) {
			oRM.addClass("linenums");
		}

		var sHeight = oControl.getHeight();
		if (sHeight) {
			oRM.addStyle("height", sHeight);
		}
		var sWidth = oControl.getWidth();
		if (sWidth) {
			oRM.addStyle("width", sWidth);
		}
		oRM.writeClasses();
		oRM.writeStyles();
		oRM.write(">");
		if ( oControl.getSource() ) {
			oRM.write(jQuery.sap.encodeHTML(oControl.getSource()));
		}
		oRM.write("</pre>");
	};


	return CodeViewerRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/CodeViewerRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.FeedbackClient') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.FeedbackClient'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.HorizontalLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.VerticalLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.SimpleForm'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.SimpleFormLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.CheckBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.FormattedTextView'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Label'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Link'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.SegmentedButton'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.TextArea'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.TextView'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.ToolPopup'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/FeedbackClient",['jquery.sap.global', 'sap/ui/core/IconPool', 'sap/ui/core/library',
		'sap/ui/layout/HorizontalLayout', 'sap/ui/layout/VerticalLayout', 'sap/ui/layout/form/SimpleForm', 'sap/ui/layout/form/SimpleFormLayout',
		'sap/ui/commons/Button', 'sap/ui/commons/CheckBox', 'sap/ui/commons/FormattedTextView', 'sap/ui/commons/Label', 'sap/ui/commons/Link',
		'sap/ui/commons/SegmentedButton', 'sap/ui/commons/TextArea', 'sap/ui/commons/TextView',
		'sap/ui/ux3/ToolPopup'],
	function (jQuery, IconPool, coreLibrary,
			HorizontalLayout, VerticalLayout, SimpleForm, SimpleFormLayout,
			Button, CheckBox, FormattedTextView, Label, Link,
			SegmentedButton, TextArea, TextView,
			ToolPopup) {

		"use strict";

		var ValueState = coreLibrary.ValueState;

		var FeedbackClient = function () {
		};

		FeedbackClient.prototype.updateFeedbackContextText = function () {
			if (this._oIncludeFeedbackContextCB.getChecked()) {
			   updateFeedbackContextTextWithLink.call(this);
			} else {
				updateFeedbackContextTextNoLink.call(this);
			}

			function updateFeedbackContextTextWithLink() {
				this._oFeedbackContextText.setText("Location: " + this._getCurrentPageRelativeURL() + "\n" + this._getUI5Distribution() + " Version: " + sap.ui.getVersionInfo().version);
			}

			function updateFeedbackContextTextNoLink() {
				this._oFeedbackContextText.setText(this._getUI5Distribution() + " Version: " + sap.ui.getVersionInfo().version);
			}

		};

		FeedbackClient.prototype._getUI5Distribution = function () {
			var oVersionInfo = sap.ui.getVersionInfo();
			var sUI5Distribution = "SAPUI5";
			if (oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav)) {
				sUI5Distribution = "OpenUI5";
			}
			return sUI5Distribution;
		};

		FeedbackClient.prototype._getCurrentPageRelativeURL = function () {
			var parser = window.location;
			return parser.pathname + parser.hash + parser.search;
		};

		FeedbackClient.prototype.createFeedbackPopup = function () {
			this._oFeedbackContextText = new TextView("oFeedbackContextText");
			this._oIncludeFeedbackContextCB = new CheckBox("includePageCB");

			var that = this;

			var oConfigResponse = jQuery.sap.loadResource('sap/ui/demokit/configuration/properties.json');
			var sFeedbackServiceURL = oConfigResponse["FeedbackServiceURL"];

			var FEEDBACK_INPUT_PLACEHOLDER = 'Describe what you like or what needs to be improved. You can share your feedback for the overall Demokit experience or for the specific page you are currently viewing.';

			var oFeedbackPopup, feedbackSubmitSuccessLayout, feedbackSubmitErrorLayout, oFeedbackRatingLabel, iRatingValue, oFeedbackRatingButton, oFeedbackInput, oContextDataLink, oCloseFeedbackButton, oSendFeedbackButton;

			function setFeedbackPopupContent(oLayout){
				resetFeedbackPopupState();
				oLayout.addContent(oCloseFeedbackButton);
				oFeedbackPopup.removeAllContent();
				oFeedbackPopup.addContent(oLayout);
			}

			function setFeedbackPopupBusyState() {
				oFeedbackPopup.setBusyIndicatorDelay(0);
				oFeedbackPopup.setBusy(true);
				oFeedbackInput.setValueState(ValueState.None);
				oFeedbackInput.setPlaceholder(FEEDBACK_INPUT_PLACEHOLDER);
			}

			function resetFeedbackPopupState() {
				oFeedbackPopup.setBusy(false);
				oFeedbackRatingLabel.setText("");
				oFeedbackRatingButton.setSelectedButton();
				oFeedbackInput.setValue('');
				that._oIncludeFeedbackContextCB.setChecked(false);
				that._oIncludeFeedbackContextCB.fireChange();
				that._oFeedbackContextText.setVisible(false);
				oContextDataLink.setText("Show context data");
				oContextDataLink.setTooltip("Show context data");
				oSendFeedbackButton.setEnabled(false);
			}

			function registerFeedbackRatingIcons() {
				IconPool.addIcon("icon-face-very-bad", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E086",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-bad", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E087",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-neutral", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E089",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-happy", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E08B",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-very-happy", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E08C",
					suppressMirroring: true
				});
			}

			function createFeedbackRatingHeader() {
				var oRateYourExperienceLabel = new FormattedTextView("feedbackRateYourExperienceLabel");
				oRateYourExperienceLabel.setHtmlText("<span class='feedbackAsterisk'>*</span>Rate your experience:");
				oFeedbackRatingLabel = new Label("feedbackRatingLabel", {});

				return new HorizontalLayout('feedbackRatingHeader', { content:[
							  oRateYourExperienceLabel, oFeedbackRatingLabel]});
			}

			function createFeedbackRatingSegmentedButton() {
				registerFeedbackRatingIcons();

				oFeedbackRatingButton = new SegmentedButton({id: "feedbackRatingButton", buttons:[
					createFeedbackRatingButton("icon-face-very-bad", "Very Poor", 1),
					createFeedbackRatingButton("icon-face-bad", "Poor", 2),
					createFeedbackRatingButton("icon-face-neutral", "Average", 3),
					createFeedbackRatingButton("icon-face-happy", "Good", 4),
					createFeedbackRatingButton("icon-face-very-happy", "Excellent", 5)
				]});

				function createFeedbackRatingButton(sIcon, sLabel, iValue) {
					var sIconFullName = "sap-icon://FeedbackRatingFaces/" + sIcon;
					return new Button({icon: sIconFullName, width: "20%", press: feedbackRatingButtonAction.bind(this, sLabel, iValue)});
				}

				function feedbackRatingButtonAction(sLabel, iValue) {
					oFeedbackRatingLabel.setText(sLabel);
					iRatingValue = iValue;
					oSendFeedbackButton.setEnabled(true);
				}

				return oFeedbackRatingButton;
			}

			function createFeedbackInput() {
				oFeedbackInput = new TextArea("demokitFeedbackInput", {rows: 13});
				oFeedbackInput.setPlaceholder(FEEDBACK_INPUT_PLACEHOLDER);
				return oFeedbackInput;
			}

			function createContextDataFunctionalRow() {
				that._oIncludeFeedbackContextCB.setText('Feedback is related to the current page');
				that._oIncludeFeedbackContextCB.attachChange(that.updateFeedbackContextText.bind(that));

				oContextDataLink = new Link("feedbackContextDataLink",{
					wrapping: "false",
					text: "Show context data",
					tooltip: "Show context data",
					press: function() {
						if (that._oFeedbackContextText.getVisible() === false) {
							oContextDataLink.setText("Hide context data");
							oContextDataLink.setTooltip("Hide context data");
							that._oFeedbackContextText.setVisible(true);
						} else {
							oContextDataLink.setText("Show context data");
							oContextDataLink.setTooltip("Show context data");
							that._oFeedbackContextText.setVisible(false);
						}
					}
				});

				return new HorizontalLayout("feedbackContextButtons", { content:[
					that._oIncludeFeedbackContextCB, oContextDataLink]});
			}

			function initializeFeedbackContextData() {
				that._oFeedbackContextText.addStyleClass("feedbackContextData");
				that._oFeedbackContextText.setVisible(false);
				that.updateFeedbackContextText();
				return that._oFeedbackContextText;
			}

			function createLicenseLinks() {
				var oLicenseLinkPrivacy = new Link({
					text: "Privacy",
					tooltip: "Privacy",
					target: "_blank",
					href: "https://help.hana.ondemand.com/privacy.htm"
				});

				var oLicenseLinkTerms = new Link({
					text: "Terms of Use",
					tooltip: "Terms of Use",
					target: "_blank",
					href: "https://help.hana.ondemand.com/terms_of_use.html"
				});

				var oLegalAgreement = new Link({
					text: "Legal Agreement",
					tooltip: "Legal Agreement",
					target: "_blank",
					href: "./legal_agreement_with_privacy.html"
				});

				var oFeedbackLicenseLinks = new FormattedTextView();
				var sFeedbackLicenseLinksText = 'Your feedback is anonymous, we do not collect any personal data. For more information see <embed data-index=\"0\">, <embed data-index=\"1\"> & <embed data-index=\"2\">.';
				oFeedbackLicenseLinks.addStyleClass("feedbackLicenseText");
				oFeedbackLicenseLinks.setHtmlText(sFeedbackLicenseLinksText);
				oFeedbackLicenseLinks.addControl(oLicenseLinkPrivacy);
				oFeedbackLicenseLinks.addControl(oLicenseLinkTerms);
				oFeedbackLicenseLinks.addControl(oLegalAgreement);

				return oFeedbackLicenseLinks;
			}

			function createFooterButtons() {
				var oCancelFeedbackButton = new Button({
					text:"Cancel",
					tooltip:"Cancel",
					press: function() {
						resetFeedbackPopupState();
						oFeedbackPopup.close();
					}
				});

				oCloseFeedbackButton = new Button('closeBtn', {
					text:"Close",
					tooltip:"Close",
					press: function() {
						oFeedbackPopup.close();
					}
				});

				oSendFeedbackButton = new Button('sendBtn', {text:"Send", tooltip:"Send feedback", enabled: false,
					press : function() {
						var data = {};
						if (that._oIncludeFeedbackContextCB.getChecked()) {
							data = {
								"texts": {
									"t1": oFeedbackInput.getValue()
								},
								"ratings":{
									"r1": {"value":iRatingValue}
								},
							"context": {"page": that._getCurrentPageRelativeURL(), "attr1": that._getUI5Distribution() + ":" + sap.ui.version}
							};
						} else {
							data = {
								"texts": {
									"t1": oFeedbackInput.getValue()
								},
								"ratings":{
									"r1": {"value":iRatingValue}
								},
								"context": {"attr1": that._getUI5Distribution() + ":" + sap.ui.version}
							};
						}

						setFeedbackPopupBusyState();

						jQuery.ajax({
							url: sFeedbackServiceURL,
							type: "POST",
							contentType: "application/json",
							data: JSON.stringify(data)
						}).
						done(
							function () {
								setFeedbackPopupContent(feedbackSubmitSuccessLayout);
							}
						).
						fail(
							function () {
								setFeedbackPopupContent(feedbackSubmitErrorLayout);
							}
						);
					}
				});

				feedbackSubmitSuccessLayout = new VerticalLayout({
					content:[new FormattedTextView('successMsg', {htmlText: '<h4>Your feedback was sent successfully.</h4>'})]
				});

				feedbackSubmitErrorLayout = new VerticalLayout({
					content:[new FormattedTextView('errorMsg', {htmlText: '<h4>Your feedback was not sent.</h4>'})]
				});

				return new HorizontalLayout('feedbackButtons', { content:[
								 oSendFeedbackButton, oCancelFeedbackButton]});
			}

			var oFeedbackForm = new SimpleForm({
				maxContainerCols: 1,
				width: '400px',
				editable: true,
				layout: SimpleFormLayout.ResponsiveGridLayout,
				content: [
					new Label({text: 'Send us your feedback!'}),
					createFeedbackRatingHeader(),
					createFeedbackRatingSegmentedButton(),
					createFeedbackInput(),
					createContextDataFunctionalRow(),
					initializeFeedbackContextData(),
					createLicenseLinks(),
					createFooterButtons()
				]
			});

			var sIconPrefix = "theme/img/themeswitch_";
			oFeedbackPopup = new ToolPopup('feedBackPopup', {
				icon: 'sap-icon://comment',
				iconHover: sIconPrefix + 'hover.png',
				iconSelected: sIconPrefix + 'selected.png',
				content: [oFeedbackForm],
				defaultButton: oSendFeedbackButton,
				closed: function (){
					this.removeAllContent();
					this.addContent(oFeedbackForm);
				}
			});
			oFeedbackPopup.setTooltip("Send us your feedback!");
			return oFeedbackPopup;
		};

		return FeedbackClient;

	});

}; // end of sap/ui/demokit/FeedbackClient.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.FileUploadIntrospectorRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.FileUploadIntrospector
jQuery.sap.declare('sap.ui.demokit.FileUploadIntrospectorRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/demokit/FileUploadIntrospectorRenderer",function() {
	"use strict";


	/**
	 * FileUploadIntrospector renderer.
	 * @namespace
	 * @alias sap.ui.demokit.FileUploadIntrospectorRenderer
	 */
	var FileUploadIntrospectorRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	FileUploadIntrospectorRenderer.render = function(oRenderManager, oControl) {

		// convenience variable
		var rm = oRenderManager;

		function format(iDate) {
		  var oDate = new Date(iDate),
			sMonth = (oDate.getMonth() + 1) < 10 ? "0" + (oDate.getMonth() + 1) : "" + (oDate.getMonth() + 1),
			sYear = oDate.getFullYear() < 10 ? "0" + oDate.getFullYear() : "" + oDate.getFullYear(),
			sDate = oDate.getDate() < 10 ? "0" + oDate.getDate() : "" + oDate.getDate(),
			sHours = oDate.getHours() < 10 ? "0" + oDate.getHours() : "" + oDate.getHours(),
			sMinutes = oDate.getMinutes() < 10 ? "0" + oDate.getMinutes() : "" + oDate.getMinutes(),
			sSeconds = oDate.getSeconds() < 10 ? "0" + oDate.getSeconds() : "" + oDate.getSeconds();
			return sYear + "-" + sMonth + "-" + sDate + " " + sHours + ":" + sMinutes + ":" + sSeconds;
		}

		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.write(" class='sapUiDkitFileList'");
		if ( oControl.getWidth() ) {
			rm.addStyle("width", oControl.getWidth());
		}
		rm.writeStyles();
		rm.write(">");
		var aFiles = oControl._aFiles || [];
		rm.write("<div");
		if ( oControl.getHeight() ) {
			rm.addStyle("height", oControl.getHeight());
			rm.addStyle("overflow-y", "auto");
		}
		rm.writeStyles();
		rm.write(">");
		rm.write("<table border='0'>");
		rm.write("<tr class='sapUiDkitFileItem'>");
		rm.write("<th>Filename</th>");
		rm.write("<th>Date</th>");
		rm.write("<th>Size</th>");
		rm.write("</tr>");
		for (var i = 0; i < aFiles.length; i++) {
			rm.write("<tr class='sapUiDkitFileItem'>");
			rm.write("<td style='padding:1px 3px;'><span style='white-space:nowrap'>" + aFiles[i].name + "</span></td>");
			rm.write("<td style='border-left:1px solid #ccc;padding:1px 3px;width:12ex'><span style='white-space:nowrap'>" + format(aFiles[i].time) + "</span></td>");
			rm.write("<td style='border-left:1px solid #ccc;padding:1px 3px;width:8ex;text-align:right'><span style='white-space:nowrap'>" + aFiles[i].size + "</span></td>");
			rm.write("</tr>");
		}
		rm.write("</table>");
		rm.write("</div>");
		rm.write("<div class='sapUiDkitBottomLine'>");
		rm.write("Last Refresh: " + (format(new Date().getTime())));
		rm.write("</div>");

		rm.write("</div>");

	};


	return FileUploadIntrospectorRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/FileUploadIntrospectorRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.HexagonButtonGroupRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.HexagonButtonGroup
jQuery.sap.declare('sap.ui.demokit.HexagonButtonGroupRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/demokit/HexagonButtonGroupRenderer",function() {
	"use strict";


	/**
	 * HexagonButtonGroup renderer.
	 * @namespace
	 * @alias sap.ui.demokit.HexagonButtonGroupRenderer
	 */
	var HexagonButtonGroupRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	HexagonButtonGroupRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;

		// write the HTML into the render manager
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.writeAttribute("class","sapUiHexGroup");
		rm.write(">");
		var iColspan = oControl.getColspan();
		var aButtons = oControl.getButtons();
		for (var i = 0; i < aButtons.length; i++) {
			// TODO fix layouting, needs relative positioning
			var ix = i % iColspan;
			var iy = Math.floor(i / iColspan);
			if ( ix < Math.floor(iColspan / 2) ) {
				ix = 1 + 2 * ix;
			} else {
				ix = 2 * (ix - Math.floor(iColspan / 2));
			}
			var x = 100 +  90 * ix;
			var y = 100 + 100 * iy + 100 - 50 * (ix % 2);
			var oButton = aButtons[i];
			oButton.setPosition("position:absolute;left:" + x + "px;top:" + y + "px;");
			oRenderManager.renderControl(oButton);
		}
		rm.write("</div>");
	};


	return HexagonButtonGroupRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/HexagonButtonGroupRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.HexagonButtonRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.HexagonButton
jQuery.sap.declare('sap.ui.demokit.HexagonButtonRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/HexagonButtonRenderer",['jquery.sap.encoder'],
	function(jQuery) {
	"use strict";


	/**
	 * HexagonButton renderer.
	 * @namespace
	 * @alias sap.ui.demokit.HexagonButtonRenderer
	 */
	var HexagonButtonRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	HexagonButtonRenderer.render = function(oRenderManager, oControl){
		// convenience variable
		var rm = oRenderManager;

		// write the HTML into the render manager
		rm.write("<div ");
		rm.writeControlData(oControl);
		rm.addClass("sapUiHexBtn");
		rm.addClass("sapUiHexBtn" + jQuery.sap.encodeHTML(oControl.getEnabled() ? oControl.getColor() : "Gray"));
		if ( oControl.getEnabled() && oControl.hasListeners('press') ) {
			rm.addClass("sapUiHexBtnActive");
		}
		rm.writeClasses();
		rm.write(" style='" + jQuery.sap.encodeHTML(oControl.getPosition()) + "'");
		if (oControl.getTooltip_AsString()) {
			rm.writeAttributeEscaped("title", oControl.getTooltip_AsString());
		}
		rm.write(">");
		if ( oControl.getIcon() ) {
			rm.write("<IMG ");
			rm.writeAttributeEscaped("src", oControl.getIcon());
			var sImagePosition = oControl.getImagePosition();
			if (sImagePosition) {
				rm.write(" style='" + jQuery.sap.encodeHTML(sImagePosition) + "'");
			} else {
				rm.write(" style='position:relative;left:40px;top:45px;'");
			}
			rm.write(" border='0'");
			rm.write("/>");
		}
		rm.write("</div>");
	};


	return HexagonButtonRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/HexagonButtonRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.IndexLayoutRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.IndexLayout
jQuery.sap.declare('sap.ui.demokit.IndexLayoutRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/IndexLayoutRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * IndexLayout renderer.
	 * @namespace
	 * @alias sap.ui.demokit.IndexLayoutRenderer
	 */
	var IndexLayoutRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oLyt an object representation of the control that should be rendered
	 */
	IndexLayoutRenderer.render = function(rm, oLyt){
		var id = oLyt.getId();

		rm.write("<div");
		rm.writeControlData(oLyt);
		rm.addClass("sapDkIdxLayout");
		rm.addClass("sapDkIdxLayoutHidden");
		if (oLyt.getEnableScaling()) {
			rm.addClass("sapDkIdxLayoutScale");
		}
		rm.writeClasses();
		rm.write("><div id=\"", id, "-cntnt\">");

		var aContent = oLyt.getContent();
		for (var i = 0; i < aContent.length; i++) {
			rm.write("<div class=\"sapDkIdxLayoutItem\" style=\"width:", oLyt._scale(oLyt._itemWidth), "px;height:", oLyt._scale(oLyt._itemHeight), "px;\"><div>");
			rm.renderControl(aContent[i]);
			rm.write("</div></div>");
		}

		rm.write("</div></div>");
	};

	return IndexLayoutRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/IndexLayoutRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.SimpleTree') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// This is internal control dedicated for Demo Kit application usage
jQuery.sap.declare('sap.ui.demokit.SimpleTree'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
jQuery.sap.require('sap.m.SearchField'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/SimpleTree",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/model/Filter', 'sap/ui/model/FilterOperator', 'sap/m/SearchField'],
	function(jQuery, Control, ItemNavigation, Filter, FilterOperator, SearchField) {
		"use strict";

		var SimpleTree = Control.extend("sap.ui.demokit.SimpleTree", { metadata : {
			library : "sap.ui.demokit",

			properties : {

				title : {type : "string", defaultValue : null},

				width : {type : "sap.ui.core.CSSSize", defaultValue : 'auto'},

				height : {type : "sap.ui.core.CSSSize", defaultValue : 'auto'},

				showFilter : {type : "boolean", defaultValue : true},

				filterAttribute : {type : "string", defaultValue : 'text'}
			},

			defaultAggregation : "nodes",

			aggregations : {
				nodes : {type : "sap.ui.demokit.SimpleTreeNode", multiple : true, singularName : "node", bindable : "bindable"},

				_searchField : {type : "sap.m.SearchField", multiple : false, visibility : "hidden"}
			}

		}});

		//***********************************************************************************
		//* PUBLIC METHODS
		//***********************************************************************************
		SimpleTree.prototype.init = function() {
			this._initializeSearchField();
			this._createNodesFocusHandling();
		};

		SimpleTree.prototype.expandAll = function() {
			var aChildNodes = this.getNodes();
			for (var i = 0; i < aChildNodes.length; i++) {
				aChildNodes[i].expand(true);
			}
		};

		SimpleTree.prototype.collapseAll = function() {
			var aChildNodes = this.getNodes();
			for (var i = 0; i < aChildNodes.length; i++) {
				aChildNodes[i].collapse(true);
			}
		};

		SimpleTree.prototype.isTreeBinding = function(sName) {
			return (sName == "nodes");
		};

		SimpleTree.prototype.onAfterRendering = function() {
			var selectedNode = jQuery(this.getDomRef()).find('.sapDkSimpleTreeNodeSelected'),
				nodeIndex = this._itemNavigation.getItemDomRefs().indexOf(selectedNode.parent()[0]);
			this._initializeNodesFocusHandling();

			this.sSelectedNodeId = selectedNode.parent().attr('id');
			this._itemNavigation.setSelectedIndex(nodeIndex);
			selectedNode.focus();
		};

		SimpleTree.prototype.exit = function () {
			this._destroyNodesFocusHandling();
		};

		//***********************************************************************************
		//* PRIVATE METHODS
		//***********************************************************************************

		SimpleTree.prototype._initializeSearchField = function() {
			var that = this;
			var oSearchField = this.getAggregation("_searchField");
			oSearchField = new SearchField({
				selectOnFocus: false,
				showSearchButton : false,
				liveChange : function(oEvent) {
					_filterTreeContent.call(that, oEvent.getParameter("newValue"));
				}
			});
			oSearchField.addStyleClass("sapDkSimpleTreeSearchField");
			this.setAggregation("_searchField", oSearchField, true);

			function _filterTreeContent(sFilterArgument) {
				var aFilters = [];
				var oNameFilter = new Filter(this.getFilterAttribute(), FilterOperator.Contains, sFilterArgument);
				aFilters.push(oNameFilter);
				var oBinding = this.getBinding("nodes");
				oBinding.filter(aFilters);
				this.expandAll();
			}
		};

		SimpleTree.prototype._createNodesFocusHandling = function() {
			this._itemNavigation = new ItemNavigation();
			this._itemNavigation.setCycling(false);
			this.addEventDelegate(this._itemNavigation);
		};

		SimpleTree.prototype._initializeNodesFocusHandling = function() {
			this._itemNavigation.setRootDomRef(this.$().children("ul")[0]);
			this._itemNavigation.setItemDomRefs(this._getDomRefs());
		};

		SimpleTree.prototype._destroyNodesFocusHandling = function() {
			if (this._itemNavigation) {
				this._itemNavigation.destroy();
			}
		};

		//***********************************************************************************
		//* HELPER METHODS - FOCUS MANAGEMENT
		//***********************************************************************************

		SimpleTree.prototype._getDomRefs = function() {
			var aDomRefs = [];
			var aNodes = this.getNodes();
			for (var i = 0; i < aNodes.length; i++) {
				aNodes[i]._getDomRefs(aDomRefs);
			}
			return aDomRefs;
		};


		return SimpleTree;
	});

}; // end of sap/ui/demokit/SimpleTree.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.SimpleTreeNode') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// This is internal control dedicated for Demo Kit application usage
jQuery.sap.declare('sap.ui.demokit.SimpleTreeNode'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Icon'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/SimpleTreeNode",['jquery.sap.global', 'sap/ui/core/Element', 'sap/ui/core/Icon'],
	function(jQuery, Element, Icon) {
		"use strict";

		var SimpleTreeNode = Element.extend("sap.ui.demokit.SimpleTreeNode", { metadata : {
			library : "sap.ui.demokit",

			properties : {
				text : {type : "string", defaultValue : null},

				ref : {type : "string", defaultValue : null},

				expanded : {type : "boolean", defaultValue : false},

				isSelected : {type : "boolean", defaultValue : false}
			},

			defaultAggregation : "nodes",

			aggregations : {
				nodes : {type : "sap.ui.demokit.SimpleTreeNode", multiple : true, singularName : "node", bindable : "bindable"},

				_iconControl : {type : "sap.ui.core.Icon", multiple : false, visibility : "hidden"}
			},

			events : {

				selected : {}

			}

		}});

		SimpleTreeNode.ANIMATION_DURATION = 600;

		//***********************************************************************************
		//* PUBLIC METHODS
		//***********************************************************************************

		SimpleTreeNode.prototype.init = function() {
			this._bIsRTL = sap.ui.getCore().getConfiguration().getRTL();

			var oIcon = new Icon({useIconTooltip: false}).addStyleClass('sapDkSimpleTreeNodeIconCol');
			if (this._bIsRTL) {
				oIcon.setSrc("sap-icon://navigation-left-arrow");
			} else {
				oIcon.setSrc("sap-icon://navigation-right-arrow");
			}

			this.setAggregation("_iconControl", oIcon, true);
		};

		SimpleTreeNode.prototype.expand = function(bExpandChildren){
			this._executeExpandCollapse(true, bExpandChildren);
		};

		SimpleTreeNode.prototype.collapse = function(bCollapseChildren){
			this._executeExpandCollapse(false, bCollapseChildren);
		};

		SimpleTreeNode.prototype.setExpanded = function(bExpanded) {
			if (this.getExpanded() !== bExpanded) {
				this.setProperty("expanded", bExpanded, false);

				this._toggleNodeArrow(bExpanded);
			}

		};

		//***********************************************************************************
		//* PRIVATE METHODS
		//***********************************************************************************

		SimpleTreeNode.prototype._executeExpandCollapse = function(bShouldExpand, bRecursive) {
			this._toggleNodeExpandedProperty(bShouldExpand);
			this._toggleNodeArrow(bShouldExpand);
			this._toggleDirectChildrenVisibility(this.$(), bShouldExpand);
			this._toggleNodeBottomBorder(this.$(), bShouldExpand);

			if (bRecursive) {
				this._expandCollapseChildrenRecursively(bShouldExpand);
			}
		};

		SimpleTreeNode.prototype._toggleNodeExpandedProperty = function(bShouldExpand) {
			this.setProperty("expanded", false, true);
			if (bShouldExpand && !this.getExpanded() && this.getNodes().length > 0 ) {
				this.setProperty("expanded", true, true);
			}
		};


		SimpleTreeNode.prototype._toggleNodeArrow = function(bShouldExpand) {
			var oIcon = this.getAggregation("_iconControl");

			if (bShouldExpand && ((oIcon.getSrc().indexOf("navigation-right-arrow") > -1)
				|| (oIcon.getSrc().indexOf("navigation-left-arrow") > -1))) {
				oIcon.removeStyleClass("sapDkSimpleTreeNodeIconCol");
				oIcon.addStyleClass("sapDkSimpleTreeNodeIconExp");
				oIcon.setSrc("navigation-down-arrow");
			} else if (!bShouldExpand && oIcon.getSrc().indexOf("navigation-down-arrow") > -1) {
				oIcon.removeStyleClass("sapDkSimpleTreeNodeIconExp");
				oIcon.addStyleClass("sapDkSimpleTreeNodeIconCol");
				if (this._bIsRTL) {
					oIcon.setSrc("navigation-left-arrow");
				} else {
					oIcon.setSrc("navigation-right-arrow");
				}
			}
		};

		SimpleTreeNode.prototype._toggleDirectChildrenVisibility = function(oDomNode, bShouldExpand) {
			var oListDomNode = oDomNode.children("ul");
			if ((bShouldExpand && oListDomNode.hasClass("sapDkSimpleTreeHiddenChildrenNodes"))
				|| (!bShouldExpand && oListDomNode.hasClass("sapDkSimpleTreeVisibleChildrenNodes"))) {

				oListDomNode.toggleClass("sapDkSimpleTreeHiddenChildrenNodes");
				oListDomNode.toggleClass("sapDkSimpleTreeVisibleChildrenNodes");

				this._executeExpandCollapseAnimation(oListDomNode, bShouldExpand);
			}
			//ARIA
			if (!bShouldExpand && oDomNode.children("a").last().attr("aria-expanded") === "true") {
				oDomNode.children("a").last().attr("aria-expanded", "false");
			} else if (bShouldExpand && this.getNodes().length > 0) {
				oDomNode.children("a").last().attr("aria-expanded", "true");
			}

		};

		SimpleTreeNode.prototype._executeExpandCollapseAnimation = function(oDomNode, bShouldExpand) {
			if (bShouldExpand) {
				//JQuery show/hide methods are not working if 'display' style is not already presented.
				oDomNode.css({display:'none'});
				oDomNode.show(SimpleTreeNode.ANIMATION_DURATION);
			} else {
				oDomNode.css({display:'block'});
				oDomNode.hide(SimpleTreeNode.ANIMATION_DURATION);
			}

		};

		SimpleTreeNode.prototype._toggleNodeBottomBorder = function(oDomNode, bShouldExpand) {
			if ((bShouldExpand && oDomNode.hasClass("sapDkSimpleTreeNodeFirstLvlRootCol")) ||
				(!bShouldExpand && oDomNode.hasClass("sapDkSimpleTreeNodeFirstLvlRootExp"))) {

				oDomNode.toggleClass("sapDkSimpleTreeNodeFirstLvlRootCol sapDkSimpleTreeNodeFirstLvlRootExp");
			}
		};

		SimpleTreeNode.prototype._expandCollapseChildrenRecursively = function(bShouldExpand) {
			var aChildNodes = this.getNodes();
			for (var i = 0; i < aChildNodes.length; i++) {
				if (bShouldExpand) {
					aChildNodes[i].expand(true);
				} else {
					aChildNodes[i].collapse(true);
				}
			}
		};

		SimpleTreeNode.prototype._selectNode = function(bShouldExpand, oEvent) {
			if (!oEvent.target.classList.contains("sapUiIcon")) {
				this.fireSelected();

				this._refreshNodeSelection(this.$());
			} else if (bShouldExpand) {
				this.expand();
			} else {
				this.collapse();
			}

			oEvent.preventDefault();
			oEvent.stopPropagation();
		};

		SimpleTreeNode.prototype._refreshNodeSelection = function(oDomNode) {
			var oTree = this._getTree();
			this._clearPreviousNodeSelection(oTree);
			this._setNodeSelection(oDomNode, oTree);
		};

		SimpleTreeNode.prototype._getTree = function() {
			var oParent = this.getParent();
			while (oParent instanceof SimpleTreeNode) {
				oParent = oParent.getParent();
			}
			return oParent;
		};

		SimpleTreeNode.prototype._clearPreviousNodeSelection = function(oTree) {
			if (oTree.sSelectedNodeId === null) {
				return;
			}

			var oPreviouslySelectedNode = sap.ui.getCore().byId(oTree.sSelectedNodeId);
			if (oPreviouslySelectedNode) {
				oPreviouslySelectedNode.setProperty("isSelected", false, true);
				oPreviouslySelectedNode.$().children("a").removeClass("sapDkSimpleTreeNodeSelected");
				//ARIA
				oPreviouslySelectedNode.$().children("a").removeAttr("aria-selected");
			}
		};

		SimpleTreeNode.prototype._setNodeSelection = function(oDomNode, oTree) {
			this.setProperty("isSelected", true, true);

			oTree.sSelectedNodeId = this.getId();
			oDomNode.children("a").last().addClass("sapDkSimpleTreeNodeSelected");
			//ARIA
			oDomNode.children("a").last().attr("aria-selected", "true");
		};

		//***********************************************************************************
		//* EVENTS HANDLING
		//***********************************************************************************

		SimpleTreeNode.prototype.onclick = function(oEvent) {
			this._selectNode(!this.getExpanded(), oEvent);
		};

		SimpleTreeNode.prototype.ontap = function(oEvent) {
			oEvent.preventDefault();
		};

		SimpleTreeNode.prototype.onsapselect = function(oEvent) {
			this._selectNode(!this.getExpanded(), oEvent);
		};

		SimpleTreeNode.prototype.onsapleft = function(oEvent) {
			this._selectNode(this._bIsRTL ? true : false, oEvent);
		};

		SimpleTreeNode.prototype.onsapright = function(oEvent) {
			this._selectNode(this._bIsRTL ? false : true, oEvent);
		};

		//***********************************************************************************
		//* HELPER METHODS - FOCUS MANAGEMENT
		//***********************************************************************************

		SimpleTreeNode.prototype._getDomRefs = function(aDomRefs) {
			aDomRefs.push(this.$().children("a")[0]);
			var aNodes = this.getNodes();
			for (var i = 0; i < aNodes.length; i++) {
				aNodes[i]._getDomRefs(aDomRefs);
			}
		};


		return SimpleTreeNode;
	});

}; // end of sap/ui/demokit/SimpleTreeNode.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.SimpleTreeRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.SimpleTreeRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/SimpleTreeRenderer",["jquery.sap.encoder", "sap/ui/demokit/SimpleTreeNode"],
	function(jQuery, SimpleTreeNode) {
		"use strict";

		var SimpleTreeRenderer = {};

		SimpleTreeRenderer.render = function(oRenderManager, oTree) {
			var rm = oRenderManager;

			var oSelectedNode = _findSelectedNode(oTree.getNodes());
			_expandParentNodes(oSelectedNode);

			_startTree();
			if (oTree.getTitle()) {
				_createHeaderTitle();
			}
			if (oTree.getShowFilter() && oTree.getModel()) {
				_createFilter();
			}
			_startTreeContent();
			_writeTreeItems(oTree.getNodes());
			_endTreeContent();
			_endTree();

			function _findSelectedNode(aNodes) {
				if (!aNodes) {
					return null;
				}
				for (var i = 0; i < aNodes.length; i++) {
					if (aNodes[i].getIsSelected()) {
						return aNodes[i];
					}
					var aChildNodes = aNodes[i].getNodes();
					var selectedNode = _findSelectedNode(aChildNodes);
					if (selectedNode) {
						return selectedNode;
					}
				}
				return null;
			}

			function _expandParentNodes(oNode) {
				if (oNode instanceof SimpleTreeNode) {
					oNode.setExpanded(true);
					var oNodeParent = oNode.getParent();
					_expandParentNodes(oNodeParent);
				}
			}

			function _startTree() {
				rm.write("<div");
				rm.writeControlData(oTree);
				rm.addClass("sapDkSimpleTree sapUiSizeCompact");
				rm.writeClasses();
				rm.addStyle("width", oTree.getWidth() || "auto");
				rm.addStyle("height", oTree.getHeight() || "auto");
				rm.writeStyles();
				//ARIA
				rm.writeAttribute("role", "tree");
				rm.write(">");
			}

			function _createHeaderTitle() {
				rm.write("<div");
				rm.addClass("sapDkSimpleTreeTitle");
				rm.writeClasses();
				rm.writeAttribute("role", "heading");
				rm.write(">");
				rm.writeEscaped(oTree.getTitle());
				rm.write("</div>");
			}

			function _createFilter() {
				rm.renderControl(oTree.getAggregation("_searchField"));
			}

			function _startTreeContent() {
				rm.write("<ul");
				rm.addClass("sapDkSimpleTreeRootList");
				rm.writeClasses();
				rm.write(">");
			}

			function _writeTreeItems(nodes) {
				for (var i = 0; i < nodes.length; i++) {
					SimpleTreeRenderer.renderNode(rm, nodes[i], nodes.length, i);
				}
			}

			function _endTreeContent() {
				rm.write("</ul>");
			}

			function _endTree() {
				rm.write("</div>");
			}

		};

		SimpleTreeRenderer.renderNode = function(rm, oTreeNode, iRootLevelNodesNumber, iRootNodePosition) {
			var BASE_NODE_OFFSET = 7;
			var NODE_STEP_OFFSET = 15;
			var ROOT_NESTED_LEVEL = 0;

			_writeNodes(oTreeNode, ROOT_NESTED_LEVEL, iRootLevelNodesNumber, iRootNodePosition);

			function _writeNodes(oNode, iNestedLevel, iSameLevelNodesNumber, iNodePosition) {
				_startNode(oNode, iNestedLevel, iSameLevelNodesNumber, iNodePosition);

				var aChildNodes = oNode.getNodes();
				if (aChildNodes && aChildNodes.length > 0) {
					iNestedLevel++;
					_startNodeList(oNode.getExpanded());
					for (var i = 0; i < aChildNodes.length; i++) {
						_writeNodes(aChildNodes[i], iNestedLevel, aChildNodes.length, i);
					}
					iNestedLevel--;
					_endNodeList();
				}
				_endNode(oNode);
			}

			function _startNode(oNode, iNestedLevel, iSameLevelNodesNumber, iNodePosition) {
				var nodes = oNode.getNodes(),
					bHasChildren = (nodes && nodes.length > 0);

				rm.write("<li");
				rm.writeElementData(oNode);
				rm.addClass("sapDkSimpleTreeNode");

				if (iNestedLevel === 0) {
					if (oNode.getExpanded()) {
						rm.addClass("sapDkSimpleTreeNodeFirstLvlRootExp");
					} else if (bHasChildren) {
						rm.addClass("sapDkSimpleTreeNodeFirstLvlRootCol");
					}
				}
				rm.writeClasses();
				rm.write(">");

				rm.write("<a href=\"" + jQuery.sap.encodeHTML(oNode.getRef() || "") + "\"");
				var bIsRTL = sap.ui.getCore().getConfiguration().getRTL();

				rm.addStyle(bIsRTL ? "padding-right" : "padding-left", ((iNestedLevel * NODE_STEP_OFFSET) + BASE_NODE_OFFSET) + "px");
				rm.writeStyles();
				rm.writeAttribute("tabindex", "-1");

				if (oNode.getIsSelected()) {
					rm.addClass("sapDkSimpleTreeNodeSelected");
				}

				if (iNestedLevel === 0) {
					rm.addClass("sapDkSimpleTreeNodeFirstLvl");
				}

				rm.writeClasses();

				//ARIA
				var mProps = {role: 'treeitem', level: iNestedLevel + 1, setsize: iSameLevelNodesNumber, posinset: iNodePosition + 1};
				if (oNode.getExpanded()) {
					mProps["expanded"] = true;
				} else if (bHasChildren) {
					mProps["expanded"] = false;
				}

				rm.writeAccessibilityState(oNode, mProps);

				rm.write(">");
				if (bHasChildren) {
					rm.renderControl(oNode.getAggregation("_iconControl"));
				} else {
					rm.write("<span");
					rm.addClass("sapDkSimpleTreeNodeNoChildren");
					rm.writeClasses();
					rm.write(">");
					rm.write("</span>");
				}


				rm.write("<span");
				rm.addClass("sapDkSimpleTreeNodeLabel");
				rm.writeClasses();
				rm.write(">");
				rm.writeEscaped(oNode.getText());
				rm.write("</span>");
				rm.write("</a>");
			}

			function _endNode() {
				rm.write("</li>");
			}

			function _startNodeList(bIsExpanded) {
				rm.write("<ul");
				if (bIsExpanded) {
					rm.addClass("sapDkSimpleTreeVisibleChildrenNodes");
				} else {
					rm.addClass("sapDkSimpleTreeHiddenChildrenNodes");
				}
				rm.writeClasses();
				rm.write(">");
			}

			function _endNodeList() {
				rm.write("</ul>");
			}

		};

		return SimpleTreeRenderer;

	}, /* bExport= */ true);

}; // end of sap/ui/demokit/SimpleTreeRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.TagCloudRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.TagCloud
jQuery.sap.declare('sap.ui.demokit.TagCloudRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/demokit/TagCloudRenderer",function() {
	"use strict";


	/**
	 * TagCloud renderer.
	 * @namespace
	 * @alias sap.ui.demokit.TagCloudRenderer
	 */
	var TagCloudRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} oRenderManager the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	TagCloudRenderer.render = function(oRenderManager, oControl){
		var rm = oRenderManager;
		rm.write("<div");
		rm.writeControlData(oControl);
		rm.addClass("sapUiTagCloud");
		rm.writeClasses();
		rm.write(">"); // div element

		var tags = oControl.getTags();
		if ( !tags || !tags.length ) {
			return;
		}

		//Compute min / max weight
		var fsMin = oControl.getMinFontSize(),
			fsScale = oControl.getMaxFontSize() - fsMin,
			wMinMax = this.computeWeightRange(tags),
			wMin = wMinMax.min,
			wScale = wMinMax.max - wMin;

		var fontsize = wScale === 0 ? function(w) { return fsMin; } : function(w) {
			return fsMin + (w - wMin) / wScale * fsScale;
		};

		// render each tag.
		for (var i = 0; i < tags.length; i++) {
			var tag = tags[i];
			rm.write("<span");
			rm.writeElementData(tag);
			rm.writeAttribute("class","sapUiTagCloudTextNormal");
			if (tag.getTooltip_AsString()) {
				rm.writeAttributeEscaped("title",tag.getTooltip_AsString());
			}
			//Compute font size relative to weight
			rm.writeAttribute("style","font-size:" + fontsize(tag.getWeight()) + "px;");
			rm.write(">"); // span element
			rm.writeEscaped(tag.getText());
			rm.write("</span>");
		}

		rm.write("</div>");
	};

	TagCloudRenderer.computeWeightRange = function(tags){
		var min = tags[0].getWeight(), max = min;
		for (var i = 1; i < tags.length; i++) {
			var w = tags[i].getWeight();
			if (w > max) {max = w;}
			if (w < min) {min = w;}
		}
		return {min:min, max:max};
	};


	return TagCloudRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/TagCloudRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.demoapps.model.formatter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.demoapps.model.formatter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/demokit/demoapps/model/formatter",[], function () {
	"use strict";

	return {
		/**
		 * Formats a library namespace to link to the API reference if it starts with sap.
		 *
		 * @public
		 * @param {string} sNamespace value to be formatted
		 * @returns {string} formatted link
		 */
		crossLink: function (sLink) {
			if (sLink[0] === "#") {
				sLink = document.location.href.substring(0,document.location.href.search("demoapps\.html")) + sLink;
			}
			return sLink;
		},

		/**
		 * Formats a library namespace to link to the API reference if it starts with sap.
		 *
		 * @public
		 * @param {string} sNamespace value to be formatted
		 * @returns {string} formatted link
		 */
		libraryLink: function (sNamespace) {
			if (sNamespace && sNamespace.search("sap\\.") === 0) {
				return this.formatter.crossLink("#docs/api/symbols/" + sNamespace + ".html");
			} else {
				return "";
			}
		},

		/**
		 * Formats a library namespace to true if it starts with sap.
		 *
		 * @public
		 * @param {string} sNamespace value to be formatted
		 * @returns {boolean} true or false
		 */
		libraryLinkEnabled: function (sNamespace) {
			return !!this.formatter.libraryLink.bind(this)(sNamespace);
		},

		/**
		 * Formats a category id to a category name.
		 *
		 * @public
		 * @param {string} sCategoryId the value to be formatted
		 * @returns {string} the formatted text
		 */
		categoryName: function (sCategoryId) {
			var oResourceBundle = this.getView().getModel("i18n").getResourceBundle();

			return oResourceBundle.getText("demoAppCategory" + sCategoryId);
		}
	};
});
}; // end of sap/ui/demokit/demoapps/model/formatter.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.demoapps.model.sourceFileDownloader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global Promise*/
jQuery.sap.declare('sap.ui.demokit.demoapps.model.sourceFileDownloader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/demoapps/model/sourceFileDownloader",['jquery.sap.global'], function (jQuery) {
	"use strict";

	var oCodeCache = {};
	return function (sUrl) {
		return new Promise(function (fnResolve) {
			var fnSuccess = function (result) {
				oCodeCache[sUrl] = result;
				fnResolve(result);
			};
			var fnError = function () {
				fnResolve({errorMessage: "File not found: '" + sUrl + "'"});
			};

			if (!(sUrl in oCodeCache)) {
				jQuery.ajax({
					url: sUrl,
					type: "GET",
					dataType: "text",
					beforeSend: function(request) {
						request.overrideMimeType("text/plain; charset=x-user-defined");
					}
				}).done(fnSuccess).fail(fnError);
			} else {
				fnResolve(oCodeCache[sUrl]);
			}
		});
	};
});

}; // end of sap/ui/demokit/demoapps/model/sourceFileDownloader.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.data') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.data'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/demokit/explored/data",function() {
	"use strict";

	// return an empty object (will be filled in Bootstrap.js)
	return {};

}, /* bExport = */ true);
}; // end of sap/ui/demokit/explored/data.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.util.MyRouter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides acustomized router class for the 'explored' app.
jQuery.sap.declare('sap.ui.demokit.explored.util.MyRouter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.Router'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/util/MyRouter",['jquery.sap.global', 'sap/ui/core/routing/History', 'sap/ui/core/routing/Router', 'sap/ui/core/Core'],
	function(jQuery, History, Router, Core) {
	"use strict";



	var MyRouter = Router.extend("sap.ui.demokit.explored.util.MyRouter", {

		/**
		 * mobile nav back handling
		 */
		myNavBack : function (sRoute, oData) {
			var oHistory = History.getInstance();
			var oPrevHash = oHistory.getPreviousHash();
			if (oPrevHash !== undefined) {
				window.history.go(-1);
			} else {
				var bReplace = true; // otherwise we go backwards with a forward history
				this.navTo(sRoute, oData, bReplace);
			}
		},

		/**
		 * a nav to method that does not write hashes but load the views properly
		 */
		myNavToWithoutHash : function (viewName, viewType, master, data) {
			var app = sap.ui.getCore().byId("splitApp");
			var view = this.getView(viewName, viewType);
			app.addPage(view, master);
			app.toDetail(view.getId(), "show", data);
		}
	});

	return MyRouter;

});

}; // end of sap/ui/demokit/explored/util/MyRouter.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.util.ObjectSearch') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a simple search feature
jQuery.sap.declare('sap.ui.demokit.explored.util.ObjectSearch'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/util/ObjectSearch",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	var ObjectSearch = {

		getEntityPath : function (oData, sId) {
			if (!oData.entities) {
				return null;
			}
			var oResult = null;
			jQuery.each(oData.entities, function (i, oEnt) {
				if (oEnt.id === sId) {
					oResult = "/entities/" + i + "/";
					return false;
				}
			});
			return oResult;
		}
	};

	return ObjectSearch;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/explored/util/ObjectSearch.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.util.ToggleFullScreenHandler') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a simple search feature
jQuery.sap.declare('sap.ui.demokit.explored.util.ToggleFullScreenHandler'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/util/ToggleFullScreenHandler",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	var ToggleFullScreenHandler = {

		updateMode : function(oEvt, oView) {
			if (!this._oShell) {
				this._oShell = sap.ui.getCore().byId('Shell');
			}
			var bSwitchToFullScreen = (this._getSplitApp().getMode() === "ShowHideMode");
			if (bSwitchToFullScreen) {
				this._getSplitApp().setMode('HideMode');
				this._oShell.setAppWidthLimited(false);
			} else {
				this._getSplitApp().setMode('ShowHideMode');
				this._oShell.setAppWidthLimited(true);
			}
			this.updateControl(oEvt.getSource(), oView, bSwitchToFullScreen);
		},


		_getSplitApp : function () {
			if (!this._oSplitApp) {
				this._oSplitApp = sap.ui.getCore().byId('splitApp');
			}
			return this._oSplitApp;
		},

		updateControl : function (oButton, oView, bFullScreen) {
			if (arguments.length === 2) {
				bFullScreen = !(this._getSplitApp().getMode() === "ShowHideMode");
			}
			var i18nModel = oView.getModel('i18n');
			if (!bFullScreen) {
				oButton.setTooltip(i18nModel.getProperty('sampleFullScreenTooltip'));
				oButton.setIcon('sap-icon://full-screen');
			} else {
				oButton.setTooltip(i18nModel.getProperty('sampleExitFullScreenTooltip'));
				oButton.setIcon('sap-icon://exit-full-screen');
			}
		},

		cleanUp : function() {
			this._oSplitApp = null;
			this._oShell = null;
		}
	};

	return ToggleFullScreenHandler;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/explored/util/ToggleFullScreenHandler.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.app.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.app.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/app.controller",["jquery.sap.global", "sap/ui/core/Core", "sap/ui/core/Component", "sap/ui/core/mvc/Controller"], function (jQuery, Core, Component, Controller) {
	"use strict";

	return Controller.extend("sap.ui.demokit.explored.view.app", {

		onInit : function () {

			this._afterRenderingDone = false;

			// subscribe to app events
			this._component = Component.getOwnerComponentFor(this.getView());
			this._component.getEventBus().subscribe("app", "applyAppConfiguration", this._applyAppConfiguration, this);
		},

		onAfterRendering : function () {
			if (this.hasOwnProperty("_compactOn")) {
				jQuery('body').toggleClass("sapUiSizeCompact", this._compactOn).toggleClass("sapUiSizeCozy", !this._compactOn);
			}
			if (this.hasOwnProperty("_themeActive") && !jQuery.sap.getUriParameters().get("sap-theme") && !jQuery.sap.getUriParameters().get("sap-ui-theme")) {
				sap.ui.getCore().applyTheme(this._themeActive);
			}
			this._afterRenderingDone = true;

		},

		_applyAppConfiguration : function(sChannel, sEvent, oData){
			if (this._afterRenderingDone){
				//handle themeChange
				sap.ui.getCore().applyTheme(oData.themeActive);
				//handle compact mode
				jQuery('body').toggleClass("sapUiSizeCompact", oData.compactOn).toggleClass("sapUiSizeCozy", !oData.compactOn);

				// apply theme and compact mode also to iframe samples
				var oSampleFrame = sap.ui.getCore().byId("sampleFrame");
				if (oSampleFrame && oSampleFrame.$()[0]) {
					var oSampleFrameContent = oSampleFrame.$()[0].contentWindow;
					if (oSampleFrameContent) {
						oSampleFrameContent.sap.ui.getCore().applyTheme(oData.themeActive);
						oSampleFrameContent.jQuery('body').toggleClass("sapUiSizeCompact", oData.compactOn).toggleClass("sapUiSizeCozy", !oData.compactOn);
					}
				}
			} else {
				this._themeActive = oData.themeActive;
				this._compactOn = oData.compactOn;
			}
		}
	});

});

}; // end of sap/ui/demokit/explored/view/app.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.app.view') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.app.view'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.JSView'); // unlisted dependency retained
jQuery.sap.require('sap.m.SplitApp'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/app.view",["sap/ui/core/mvc/JSView", "sap/m/SplitApp"], function (JSView, SplitApp) {
	"use strict";

	sap.ui.jsview("sap.ui.demokit.explored.view.app", {

		getControllerName : function () {
			return "sap.ui.demokit.explored.view.app";
		},

		createContent : function (oController) {

			// to avoid scrollbars on desktop the root view must be set to block display
			this.setDisplayBlock(true);

			// create split app
			return new SplitApp("splitApp", {
				afterDetailNavigate: function () {
					this.hideMaster();
				}
			});
		}
	});
});

}; // end of sap/ui/demokit/explored/view/app.view.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.base.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.base.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.storage'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/base.controller",[
	"sap/ui/core/mvc/Controller",
	"jquery.sap.storage"
	], function (Controller, jQuery) {
	"use strict";

	return Controller.extend("sap.ui.demokit.explored.view.base", {

		//========= members =======================================================================

		_oViewSettings: null, // set on init

		_oStorage: jQuery.sap.storage(jQuery.sap.storage.Type.local),

		_sStorageKey: "UI5_EXPLORED_VIEW_SETTINGS",

		_oDefaultSettings: {
			filter: {},
			groupProperty: "category",
			groupDescending: false,
			compactOn: false,
			themeActive: "sap_belize",
			rtl: false,
			version: jQuery.sap.Version(sap.ui.version).getMajor() + "." + jQuery.sap.Version(sap.ui.version).getMinor()
		},


		// ========= internal ===========================================================================

		/**
		 * Makes sure the view settings are initialized and updates the filter bar dispay and list binding
		 */
		_applyViewConfigurations: function () {
			if (!this._oViewSettings) {

				// init the view settings
				this._initViewSettings();

				// apply app settings
				this.getOwnerComponent().getEventBus().publish("app", "applyAppConfiguration", {
					themeActive: this._oViewSettings.themeActive,
					compactOn: this._oViewSettings.compactOn
				});

			}
		},

		/**
		 * Inits the view settings. At first local storage is checked. If this is empty defaults are applied.
		 */
		_initViewSettings: function () {

			var sJson = this._oStorage.get(this._sStorageKey);
			if (!sJson) {

				// local storage is empty, apply defaults
				this._oViewSettings = this._oDefaultSettings;

			} else {
				// parse
				this._oViewSettings = JSON.parse(sJson);

				// clean filter and remove values that do not exist any longer in the data model
				// (the cleaned filter are not written back to local storage, this only happens on changing the view settings)
				//var oFilterData = this.getView().getModel("filter").getData();
				var oFilterData = this.getOwnerComponent().getModel("filter").getData();
				var oCleanFilter = {};
				jQuery.each(this._oViewSettings.filter, function (sProperty, aValues) {
					var aNewValues = [];
					jQuery.each(aValues, function (i, aValue) {
						var bValueIsClean = false;
						jQuery.each(oFilterData[sProperty], function (i, oValue) {
							if (oValue.id === aValue) {
								bValueIsClean = true;
								return false;
							}
						});
						if (bValueIsClean) {
							aNewValues.push(aValue);
						}
					});
					if (aNewValues.length > 0) {
						oCleanFilter[sProperty] = aNewValues;
					}
				});
				this._oViewSettings.filter = oCleanFilter;

				// handling data stored with an older explored versions
				if (!this._oViewSettings.hasOwnProperty("compactOn")) { // compactOn was introduced later
					this._oViewSettings.compactOn = false;
				}

				if (!this._oViewSettings.hasOwnProperty("themeActive")) { // themeActive was introduced later
					this._oViewSettings.themeActive = "sap_bluecrystal";
				} else if (this._oViewSettings.version !== this._oDefaultSettings.version) {
					var oVersion = jQuery.sap.Version(sap.ui.version);
					if (oVersion.compareTo("1.40.0") >= 0) { 	// Belize theme is available since 1.40
						this._oViewSettings.themeActive = "sap_belize";
					} else { // Fallback to BlueCrystal for older versions
						this._oViewSettings.themeActive = "sap_bluecrystal";
					}
				}

				if (!this._oViewSettings.hasOwnProperty("rtl")) { // rtl was introduced later
					this._oViewSettings.rtl = false;
				}

				// handle RTL-on in settings as this need a reload
				if (this._oViewSettings.rtl && !jQuery.sap.getUriParameters().get('sap-ui-rtl')) {
					this._handleRTL(true);
				}
			}
		},

		// trigger reload w/o URL-Parameter;
		_handleRTL: function (bSwitch) {

			jQuery.sap.require("sap.ui.core.routing.HashChanger");
			var HashChanger = sap.ui.require("sap/ui/core/routing/HashChanger");
			var oHashChanger = new HashChanger();
			var sHash = oHashChanger.getHash();
			var oUri = window.location;

			// TODO: remove this fix when microsoft fix this under IE11 on Win 10
			if (!window.location.origin) {
				window.location.origin = window.location.protocol + "//" +
					window.location.hostname +
					(window.location.port ? ':' + window.location.port : '');
			}

			if (bSwitch) {
				// add the parameter
				window.location = oUri.origin + oUri.pathname + "?sap-ui-rtl=true#" + sHash;
			} else {
				// or remove it
				window.location = oUri.origin + oUri.pathname + "#/" + sHash;
			}

		}

	});
});

}; // end of sap/ui/demokit/explored/view/base.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.code.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global JSZip, URI *///declare unusual global vars for JSLint/SAPUI5 validation
jQuery.sap.declare('sap.ui.demokit.explored.view.code.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/code.controller",['jquery.sap.global', 'sap/ui/Device',
	'sap/ui/core/routing/History',
	'sap/ui/core/Component', 'sap/ui/core/UIComponent', 'sap/ui/core/mvc/Controller',
	'sap/ui/model/json/JSONModel',
	'sap/m/MessageToast',
	'../data'],
	function (jQuery, Device, History, Component, UIComponent, Controller, JSONModel, MessageToast, data) {
	"use strict";

	return Controller.extend("sap.ui.demokit.explored.view.code", {

		_aMockFiles : ["products.json", "supplier.json", "img.json"],

		onInit : function () {
			this.router = UIComponent.getRouterFor(this);
			this.router.attachRoutePatternMatched(this.onRouteMatched, this);
			this._viewData = sap.ui.getCore().byId("app").getViewData();
			this._viewData.component.codeCache = {};
		},

		onRouteMatched : function (oEvt) {

			// get params
			if (oEvt.getParameter("name") !== "code" && oEvt.getParameter("name") !== "code_file") {
				return;
			}

			this._sId = oEvt.getParameter("arguments").id;
			var sFileName = decodeURIComponent(oEvt.getParameter("arguments").fileName);

			// retrieve sample object
			var oSample = data.samples[this._sId];
			if (!oSample) {
				this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound", "XML", false, { path: this._sId });
				return;
			}

			// cache the data to be reused
			if (!this._oData || oSample.id !== this._oData.id) {

				// get component and data when sample is changed or nothing exists so far
				var sCompId = 'sampleComp-' + this._sId;
				var sCompName = this._sId;
				var oComp = sap.ui.component(sCompId);
				if (!oComp) {
					oComp = sap.ui.getCore().createComponent({
						id : sCompId,
						name : sCompName
					});
				}

				// create data object
				var oMetadata = oComp.getMetadata();
				var oConfig = (oMetadata) ? oMetadata.getConfig() : null;
				this._oData = {
					id : oSample.id,
					title : "Code: " + oSample.name,
					name : oSample.name,
					stretch : oConfig.sample ? oConfig.sample.stretch : false,
					files : [],
					iframe : oConfig.sample.iframe,
					fileName: sFileName,
					includeInDownload: oConfig.sample.additionalDownloadFiles
				};

				// retrieve files
				// (via the 'Orcish maneuver': Use XHR to retrieve and cache code)
				if (oConfig && oConfig.sample && oConfig.sample.files) {
					var sRef = jQuery.sap.getModulePath(oSample.id);
					for (var i = 0; i < oConfig.sample.files.length; i++) {
						var sFile = oConfig.sample.files[i];
						var sContent = this.fetchSourceFile(sRef, sFile);

						this._oData.files.push({
							name : sFile,
							raw : sContent,
							code : this._convertCodeToHtml(sContent)
						});
					}
				}
			} else {
				this._oData.fileName = sFileName;
			}
			// set model
			var oJSONModel = new JSONModel(this._oData);
			this.getView().setModel(oJSONModel);
			oJSONModel.refresh(true);

			// scroll to top of page
			var page = this.getView().byId("page");
			page.scrollTo(0);
		},

		fetchSourceFile : function (sRef, sFile) {
			var that = this;
			var sUrl = sRef + "/" + sFile;

			var fnSuccess = function (result) {
				that._viewData.component.codeCache[sUrl] = result;
			};
			var fnError = function (result) {
				that._viewData.component.codeCache[sUrl] = "not found: '" + sUrl + "'";
			};

			if (!(sUrl in this._viewData.component.codeCache)) {
				this._viewData.component.codeCache[sUrl] = "";
				jQuery.ajax({
					url: sUrl,
					type: "GET",
					async: false,
					dataType: "text",
					success: fnSuccess,
					error: fnError,
					beforeSend: function(request) {
						request.overrideMimeType("text/plain; charset=x-user-defined");
					}
				});
			}

			return that._viewData.component.codeCache[sUrl];
		},

		onDownload : function (evt) {

			jQuery.sap.require("sap.ui.thirdparty.jszip");
			var oZipFile = new JSZip();

			// zip files
			var oData = this.getView().getModel().getData(),
				iRequiredParentLevels = 0;
			for (var i = 0; i < oData.files.length; i++) {
				var oFile = oData.files[i],
					sRawFileContent = oFile.raw,
					iFileNestedLevel = oFile.name.split("../").length - 1,
					sFileNameCloned = oFile.name.slice();

				if (iFileNestedLevel > iRequiredParentLevels) {
					iRequiredParentLevels = iFileNestedLevel;
				}

				if (iFileNestedLevel > 0 ) {
					sFileNameCloned = oFile.name.slice(oFile.name.lastIndexOf("../") + 3);
				}

				// change the bootstrap URL to the current server for all HTML files of the sample
				if (sFileNameCloned && (sFileNameCloned === oData.iframe || sFileNameCloned.split(".").pop() === "html")) {
					sRawFileContent = this._changeIframeBootstrapToCloud(sRawFileContent);
				}

				oZipFile.file(sFileNameCloned, sRawFileContent, { base64: false, binary: true });

				// mock files
				for (var j = 0; j < this._aMockFiles.length; j++) {
					var sMockFile = this._aMockFiles[j];
					if (oFile.raw.indexOf(sMockFile) > -1){
						oZipFile.file("mockdata/" + sMockFile, this.downloadMockFile(sMockFile));
					}
				}
			}

			var sRef = jQuery.sap.getModulePath(this._sId),
				aExtraFiles = oData.includeInDownload || [],
				that = this;

			// iframe examples have a separate index file and a component file to describe it
			if (!oData.iframe) {
				oZipFile.file("Component.js", this.fetchSourceFile(sRef, "Component.js"), { base64: false, binary: true });
				oZipFile.file("index.html", this._changeIframeBootstrapToCloud(this.createIndexFile(oData, iRequiredParentLevels)));
			}

			// add extra download files
			aExtraFiles.forEach(function(sFileName, index) {
				oZipFile.file(sFileName, that.fetchSourceFile(sRef, sFileName), { base64: false, binary: true });
			});

			var oContent = oZipFile.generate({type:"blob"});

			this._openGeneratedFile(oContent);
		},

		_openGeneratedFile : function (oContent) {
			jQuery.sap.require("sap.ui.core.util.File");
			var File = sap.ui.require("sap/ui/core/util/File");
			File.save(oContent, this._sId, "zip", "application/zip");
		},

		createIndexFile : function(oData, iRequiredParentLevels) {

			var sHeight,
				bScrolling;

			var sRef = jQuery.sap.getModulePath("sap.ui.demokit.explored.tmpl");
			var sIndexFile = this.fetchSourceFile(sRef, "index.html.tmpl");

			sIndexFile = sIndexFile.replace(/{{TITLE}}/g, oData.name);

			sIndexFile = sIndexFile.replace(/{{SAMPLE_ID}}/g, oData.id);

			var sParentResourcesRoots = "",
				sODataIdCloned = oData.id.slice();
			for (var i = 0; i < iRequiredParentLevels; i++) {
				sODataIdCloned = sODataIdCloned.substring(0, sODataIdCloned.lastIndexOf("."));
				sParentResourcesRoots += "\"" + sODataIdCloned  + "\" : \"./\", ";
			}
			sIndexFile = sIndexFile.replace(/{{PARENT_RESOURCES}}/g, sParentResourcesRoots);

			sHeight = oData.stretch ? 'height : "100%", ' : "";
			sIndexFile = sIndexFile.replace(/{{HEIGHT}}/g, sHeight);

			bScrolling = !oData.stretch;
			sIndexFile = sIndexFile.replace(/{{SCROLLING}}/g, bScrolling);

			return sIndexFile;
		},

		downloadMockFile : function(sFile) {

			var sRef = jQuery.sap.getModulePath("sap.ui.demo.mock");
			var sWrongPath = "test-resources/sap/ui/demokit/explored/img/";
			var sCorrectPath = "https://openui5.hana.ondemand.com/test-resources/sap/ui/demokit/explored/img/";
			var oRegExp = new RegExp(sWrongPath,"g");
			var sMockData = this.fetchSourceFile(sRef, sFile);

			if (sMockData) {
				sMockData = sMockData.replace(oRegExp, sCorrectPath);
			}

			return sMockData;
		},

		onNavBack : function () {
			var oHistory, sPreviousHash;
			oHistory = History.getInstance();
			sPreviousHash = oHistory.getPreviousHash();
			if (sPreviousHash !== undefined) {
				window.history.go(-1);
			} else {
				this.router.navTo("home", {}, true /*no history*/);
			}
		},

		/**
		 *
		 */
		_convertCodeToHtml : function (code) {

			jQuery.sap.require("jquery.sap.encoder");

			code = code.toString();

			// Get rid of function around code
			code = code.replace(/^function.+{/, "");

			//code = code.replace(/return \[[\s\S]*/, "");
			code = code.replace(/}[!}]*$/, "");

			// Get rid of unwanted code if CODESNIP tags are used
			code = code.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/, "");
			code = code.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/, "");

			// Improve indentation for display
			code = code.replace(/\t/g, "  ");

			return code;
		},

		_changeIframeBootstrapToCloud : function (sRawIndexFileHtml) {
			var rReplaceIndex = /src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/;
			var oCurrentURI = new URI(window.location.href).search("");
			var oRelativeBootstrapURI = new URI(jQuery.sap.getResourcePath("", "/sap-ui-core.js"));
			var sBootstrapURI = oRelativeBootstrapURI.absoluteTo(oCurrentURI).toString();

			// replace the bootstrap path of the sample with the current to the core
			return sRawIndexFileHtml.replace(rReplaceIndex, 'src="' + sBootstrapURI + '"');
		},

		handleTabSelectEvent: function(oEvent) {
			var sFileName = oEvent.getParameter("selectedKey");
			this.router.navTo("code_file", {
				id : this._sId,
				fileName: encodeURIComponent(sFileName)
			}, true);
		}


	});

}, /* export= */true);

}; // end of sap/ui/demokit/explored/view/code.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.master.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.master.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Fragment'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Sorter'); // unlisted dependency retained
jQuery.sap.require('sap.m.GroupHeaderListItem'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.storage'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/master.controller",[
	"sap/ui/Device", "sap/ui/core/Component", "sap/ui/core/Fragment", "sap/ui/core/UIComponent", "sap/ui/core/mvc/Controller",
	"sap/ui/model/Filter", "sap/ui/model/Sorter",
	"sap/m/GroupHeaderListItem",
	"../util/ToggleFullScreenHandler",
	"jquery.sap.storage",
	"sap/ui/demokit/explored/view/base.controller"
	], function (Device, Component, Fragment, UIComponent, Controller, Filter, Sorter, GroupHeaderListItem, ToggleFullScreenHandler, jQuery, Base) {
	"use strict";

	return Base.extend("sap.ui.demokit.explored.view.master", {

		//========= members =======================================================================

		_bIsViewUpdatedAtLeastOnce: false,

		_oVSDialog: null, // set on demand

		_mGroupFunctions: {
			"name": function (oContext) {
				var sKey = oContext.getProperty("name").charAt(0);
				return {
					key: sKey,
					text: sKey
				};
			},
			"namespace": true,
			"category": true,
			"since": true,
			"formFactors": true
		},

		// ====== init ====================================================================

		onInit : function () {
			// subscribe to routing
			this.router = UIComponent.getRouterFor(this);
			this.router.attachRoutePatternMatched(this.onRouteMatched, this);

			// subscribe to app events
			this._component = Component.getOwnerComponentFor(this.getView());
			this._component.getEventBus().subscribe("app", "selectEntity", this.onSelectEntity, this);

			// set the group to the default used in the view
			this._sCurrentGroup = this._oDefaultSettings.groupProperty;

			// subscribe to nav container events
			this.getView().addEventDelegate({
				onBeforeFirstShow: jQuery.proxy(this.onBeforeFirstShow, this)
			});
		},

		// ====== event handling ====================================================================

		onBeforeFirstShow: function () {
			if (!this._bIsViewUpdatedAtLeastOnce) {
				this._updateView();
			}
		},

		onRouteMatched: function (oEvt) {

			var sRouteName = oEvt.getParameter("name");
			if (sRouteName !== "home" && sRouteName != "notFound") {
				var oView = oEvt.getParameter('view');
				if (oView) {
					var oToggleFullScreenBtn = oView.byId("toggleFullScreenBtn");
					if (oToggleFullScreenBtn) {
						ToggleFullScreenHandler.updateControl(oToggleFullScreenBtn, oView);
					}
				}
				return;
			}

			// update view
			this._updateView();
		},

		onOpenAppSettings: function (oEvent) {

			if (!this._oSettingsDialog) {
				this._oSettingsDialog = sap.ui.xmlfragment("sap.ui.demokit.explored.view.appSettingsDialog", this);
				this.getView().addDependent(this._oSettingsDialog);
			}

	//		var oCaller = oEvent.getSource();
			jQuery.sap.delayedCall(0, this, function () {

				// variable for convenience
				var oAppSettings = sap.ui.getCore().getConfiguration();
				var bCompactMode = this._oViewSettings.compactOn;
				var bRTL = this._oViewSettings.rtl;

				// handling of URI parameters
				var sUriParamTheme = jQuery.sap.getUriParameters().get("sap-theme");
				var sUriParamRTL = jQuery.sap.getUriParameters().get("sap-ui-rtl");

				// setting the button for Theme
				if (sUriParamTheme) {
					sap.ui.getCore().byId("ThemeButtons").setSelectedKey(sUriParamTheme);
				} else {
					sap.ui.getCore().byId("ThemeButtons").setSelectedKey(oAppSettings.getTheme());
				}

				// setting the button for Compact Mode
				sap.ui.getCore().byId("CompactModeButtons").setState(bCompactMode);

				// setting the RTL Button
				if (sUriParamRTL) {
					sap.ui.getCore().byId("RTLButtons").setState(sUriParamRTL === "true" ? true : false);
				} else {
					sap.ui.getCore().byId("RTLButtons").setState(bRTL);
				}


				this._oSettingsDialog.open();
			});

		},

		onSaveAppSettings: function (oEvent) {

			this._oSettingsDialog.close();

			if (!this._oBusyDialog) {
				jQuery.sap.require("sap.m.BusyDialog");
				var BusyDialog = sap.ui.require("sap/m/BusyDialog");
				this._oBusyDialog = new BusyDialog();
				this.getView().addDependent(this._oBusyDialog);
			}
			var bCompact = sap.ui.getCore().byId('CompactModeButtons').getState();
			var sTheme = sap.ui.getCore().byId('ThemeButtons').getSelectedKey();
			var bRTL = sap.ui.getCore().byId('RTLButtons').getState();

			var bRTLChanged = (bRTL !== this._oViewSettings.rtl);

			// busy dialog
			this._oBusyDialog.open();
			jQuery.sap.delayedCall(1000, this, function () {
				this._oBusyDialog.close();
			});

			// write new settings into local storage
			this._oViewSettings.compactOn = bCompact;
			this._oViewSettings.themeActive = sTheme;
			this._oViewSettings.rtl = bRTL;
			this._oViewSettings.version = this._oDefaultSettings.version;
			var s = JSON.stringify(this._oViewSettings);
			this._oStorage.put(this._sStorageKey, s);

			// handle settings change
			this._component.getEventBus().publish("app", "applyAppConfiguration", {
				themeActive: sTheme,
				compactOn: bCompact
			});

			if (bRTLChanged) {
				this._handleRTL(bRTL);
			}
		},

		onDialogCloseButton: function () {

			this._oSettingsDialog.close();
		},

		onSelectEntity: function (sChannel, sEvent, oData) {

			var oView = this.getView(),
				oList = oView.byId("list"),
				oModel = oView.getModel("entity");

			// find item to select
			var oSelectItem = null;
			var aItems = oList.getItems();
			jQuery.each(aItems, function (i, oItem) {
				var oContext = oItem.getBindingContext("entity");
				if (oContext) {
					var sPath = oContext.getPath();
					var oEntity = oModel.getProperty(sPath);
					if (oEntity.id === oData.id) {
						oSelectItem = oItem;
						return false;
					}
				}
			});

			// select
			if (oSelectItem) {
				oList.setSelectedItem(oSelectItem);
			} else {
				oList.removeSelections();
			}

			// TODO scroll to list item
		},

		onOpenViewSettings: function () {

			// create dialog on demand
			if (!this._oVSDialog) {
				this._oVSDialog = sap.ui.xmlfragment(this.getView().getId() ,"sap.ui.demokit.explored.view.viewSettingsDialog", this);
				this.getView().addDependent(this._oVSDialog);
			}

			// delay because addDependent is async
			jQuery.sap.delayedCall(0, this, function () {

				// apply user selection
				var aFilterKeys = {};
				jQuery.each(this._oViewSettings.filter, function (sPropery, aValues) {
					jQuery.each(aValues, function (i, aValue) {
						aFilterKeys[aValue] = true;
					});
				});
				this._oVSDialog.setSelectedFilterKeys(aFilterKeys);
				this._oVSDialog.setSelectedGroupItem(this._oViewSettings.groupProperty);
				this._oVSDialog.setGroupDescending(this._oViewSettings.groupDescending);
				jQuery('body').toggleClass("sapUiSizeCompact", this._oViewSettings.compactOn).toggleClass("sapUiSizeCozy", !this._oViewSettings.compactOn);

				// open
				this._oVSDialog.open();
			});
		},

		onConfirmViewSettings: function (oEvt) {

			// store filter settings
			var that = this;
			this._oViewSettings.filter = {};
			var aFilterItems = oEvt.getParameter("filterItems");
			jQuery.each(aFilterItems, function (i, oItem) {
				var sKey = oItem.getKey();
				var sParentKey = oItem.getParent().getKey();
				if (!that._oViewSettings.filter.hasOwnProperty(sParentKey)) {
					that._oViewSettings.filter[sParentKey] = [];
				}
				that._oViewSettings.filter[sParentKey].push(sKey);
			});

			// store group settings
			var oGroupItem = oEvt.getParameter("groupItem");
			var sNewGroup = (oGroupItem) ? oGroupItem.getKey() : null;
			this._oViewSettings.groupProperty = sNewGroup;
			this._oViewSettings.groupDescending = oEvt.getParameter("groupDescending");

			// update local storage
			var s = JSON.stringify(this._oViewSettings);
			this._oStorage.put(this._sStorageKey, s);

			// update view
			this._updateView();
		},

		onSearch: function () {
			this._updateView(); // yes this function does a bit too much for search but it makes my life easier and I see no delay
		},

		onNavToEntity: function (oEvt) {
			var oItemParam = oEvt.getParameter("listItem");
			var oItem = (oItemParam) ? oItemParam : oEvt.getSource();
			var sPath = oItem.getBindingContext("entity").getPath();
			var oEnt = this.getView().getModel("entity").getProperty(sPath);
			var bReplace = !Device.system.phone;
			this.router.navTo("entity", {
				id: oEnt.id,
				part: "samples"
			}, bReplace);
		},

		// ========= internal ===========================================================================

		/**
		 * Makes sure the view settings are initialized and updates the filter bar dispay and list binding
		 */
		_updateView: function () {
			this._applyViewConfigurations();

			// update the filter bar
			this._updateFilterBarDisplay();

			// update the master list binding
			this._updateListBinding();
		},

		/**
		 * Updates the filter bar in the view
		 */
		_updateFilterBarDisplay: function () {

			// calculate text
			var sFilterText = "";
			jQuery.each(this._oViewSettings.filter, function (sProperty, aValues) {
				jQuery.each(aValues, function (i, aValue) {
					sFilterText += aValue + ", ";
				});
			});
			if (sFilterText.length > 0) {
				var iIndex = sFilterText.lastIndexOf(", ");
				sFilterText = sFilterText.substring(0, iIndex);
			}

			// update view
			var oView = this.getView();
			oView.byId("vsFilterBar").setVisible(sFilterText.length > 0);
			oView.byId("vsFilterLabel").setText(sFilterText);
		},

		/**
		 * Updates the binding of the master list and applies filters and groups
		 *
		 * Dear maintainer having more time than i currently have -
		 * this function does way too much and gets called everywhere the list gets rerendered a lot of times.
		 * So i build in some very small detection to at least reduce the rerenderings when starting the app.
		 * For future refactorings this has to be split up into functions responsible for filtering sorting and only
		 * trigger those filters if a user really changed them. currently everytime the list items will be destroyed.
		 */
		_updateListBinding: function () {

			var aFilters = [],
				aSorters = [],
				bFilterChanged = false,
				bGroupChanged = false,
				oSearchField = this.getView().byId("searchField"),
				oList = this.getView().byId("list"),
				oBinding = oList.getBinding("items");

			// add filter for search
			var sQuery = oSearchField.getValue().trim();

			bFilterChanged = true;
			aFilters.push(new Filter("searchTags", "Contains", sQuery));

			// add filters for view settings
			jQuery.each(this._oViewSettings.filter, function (sProperty, aValues) {
				var aPropertyFilters = [];
				jQuery.each(aValues, function (i, aValue) {
					var sOperator = (sProperty === "formFactors") ? "Contains" : "EQ";
					aPropertyFilters.push(new Filter(sProperty, sOperator, aValue));
				});
				var oFilter = new Filter(aPropertyFilters, false); // second parameter stands for "or"
				bFilterChanged = true;
				aFilters.push(oFilter);
			});

			// filter
			if (bFilterChanged && aFilters.length === 0) {
				oBinding.filter(aFilters, "Application");
			} else if (bFilterChanged && aFilters.length > 0) {
				var oFilter = new Filter(aFilters, true); // second parameter stands for "and"
				oBinding.filter(oFilter, "Application");
			}

			if (this._oViewSettings.groupProperty && this._oViewSettings.groupProperty !== this._sCurrentGroup) {
				bGroupChanged = true;
			} else if (this._oViewSettings.groupProperty && this._oViewSettings.groupDescending !== this._bCurrentlyGroupedDescending) {
				bGroupChanged = true;
			}

			// group
			if (bGroupChanged) {
				var oSorter = new Sorter(
					this._oViewSettings.groupProperty,
					this._oViewSettings.groupDescending,
					this._mGroupFunctions[this._oViewSettings.groupProperty]);
				aSorters.push(oSorter);
				aSorters.push(new Sorter("name", false));
				oBinding.sort(aSorters);
			}

			this._sCurrentGroup = this._oViewSettings.groupProperty;
			this._bCurrentlyGroupedDescending = this._oViewSettings.groupDescending;

			// memorize that this function was executed at least once
			this._bIsViewUpdatedAtLeastOnce = true;
		},

		getGroupHeader: function (oGroup) {
			return new GroupHeaderListItem({
				title: oGroup.key,
				upperCase: false
			});
		}
	});
});

}; // end of sap/ui/demokit/explored/view/master.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.notFound.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.notFound.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/notFound.controller",["sap/ui/core/mvc/Controller", "sap/ui/core/UIComponent", "sap/ui/model/json/JSONModel"], function (Controller, UIComponent, JSONModel) {
	"use strict";

	return Controller.extend("sap.ui.demokit.explored.view.notFound", {

		onInit : function () {
			this.router = UIComponent.getRouterFor(this);
			this.router.attachRoutePatternMatched(this.onRouteMatched, this);
			this.getView().addEventDelegate(this);
			this.getView().setModel(new JSONModel({
				entityName: ""
			}));
		},

		onRouteMatched : function (evt) {
			if (evt.getParameter("name") !== "notFound") {
				return;
			}
			var params = evt.getParameter("arguments")["all*"];
			this.getView().getModel().setProperty("/entityName", params);
		},

		onBeforeShow : function (evt) {
			if (evt.data.path) {
				this.getView().getModel().setProperty("/entityName", evt.data.path);
			}
		},

		onNavBack : function () {
			this.router.myNavBack("home", {});
		}
	});
});

}; // end of sap/ui/demokit/explored/view/notFound.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.sample.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.sample.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.HTML'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.FakeLrepConnectorLocalStorage'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.Utils'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/sample.controller",[
	'jquery.sap.global',
	'sap/ui/Device',
	'sap/ui/core/Component',
	'sap/ui/core/ComponentContainer',
	'sap/ui/core/HTML',
	'sap/ui/core/UIComponent',
	'sap/ui/core/mvc/Controller',
	'sap/ui/core/routing/History',
	'sap/ui/model/json/JSONModel',
	'sap/m/library',
	'sap/m/Text',
	'../util/ToggleFullScreenHandler',
	'../data',
	'sap/ui/demokit/explored/view/base.controller',
	"sap/ui/fl/FakeLrepConnectorLocalStorage",
	"sap/ui/fl/Utils"
],
function (jQuery, Device, Component, ComponentContainer, HTML, UIComponent, Controller, History, JSONModel, mobileLibrary, Text, ToggleFullScreenHandler, data, Base, FakeLrepConnectorLocalStorage, Utils) {
	"use strict";

	var SampleController = Base.extend("sap.ui.demokit.explored.view.sample", {

		onInit : function () {
			this.router = UIComponent.getRouterFor(this);
			this.router.attachRoutePatternMatched(this.onRouteMatched, this);
			this._viewModel = new JSONModel({
				showNavButton : true,
				showNewTab: false
			});
			this._initFakeLREP();
			this._loadRuntimeAuthoring();
			this.getView().setModel(this._viewModel);

			this.getView().addEventDelegate({
				onBeforeFirstShow: jQuery.proxy(this._applyViewConfigurations, this)
			});
		},
		onRouteMatched : function (oEvt) {

			if (this._oRTA) {
				this._oRTA.destroy();
				this._oRTA = null;
			}

			if (oEvt.getParameter("name") !== "sample") {
				return;
			}

			var oModelData = this._viewModel.getData();
			this._sId = oEvt.getParameter("arguments").id;

			// retrieve sample object
			var oSample = data.samples[this._sId];
			if (!oSample) {
				this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound", "XML", false, { path: this._sId });
				return;
			}

			// set nav button visibility
			var oPage = this.getView().byId("page");
			var oHistory = History.getInstance();
			var oPrevHash = oHistory.getPreviousHash();
			oModelData.showNavButton = Device.system.phone || !!oPrevHash;
			oModelData.previousSampleId = oSample.previousSampleId;
			oModelData.nextSampleId = oSample.nextSampleId;

			// set page title
			oPage.setTitle("Sample: " + oSample.name);

			var oContent;
			try {
				oContent = this._createComponent();
			} catch (ex) {
				oPage.removeAllContent();
				oPage.addContent(new Text({ text : "Error while loading the sample: " + ex }));
				return;
			}

			//get config
			var oConfig = (this._oComp.getMetadata()) ? this._oComp.getMetadata().getConfig() : null;
			var oSampleConfig = oConfig && oConfig.sample || {};

			// only have the option to run standalone if there is an iframe
			oModelData.showNewTab = !!oSampleConfig.iframe;

			if (oSampleConfig.iframe) {
				oContent = this._createIframe(oSampleConfig.iframe);
			} else {
				this.sIFrameUrl = null;
			}

			// handle stretch content
			var bStretch = !!oSampleConfig.stretch;
			var sHeight = bStretch ? "100%" : null;
			oPage.setEnableScrolling(!bStretch);
			if (oContent.setHeight) {
				oContent.setHeight(sHeight);
			}
			// add content
			oPage.removeAllContent();
			oPage.addContent(oContent);

			// scroll to top of page
			oPage.scrollTo(0);
			this._viewModel.setData(oModelData);
		},

		onNewTab : function () {
			mobileLibrary.URLHelper.redirect(this.sIFrameUrl, true);
		},

		onPreviousSample: function (oEvent) {
			this.router.navTo("sample", {
				id: this._viewModel.getProperty("/previousSampleId")
			}, true);
		},

		onNextSample: function (oEvent) {
			this.router.navTo("sample", {
				id: this._viewModel.getProperty("/nextSampleId")
			}, true);
		},

		_createIframe : function (vIframe) {
			var sSampleId = this._sId;

			if (typeof vIframe === "string") {
				this.sIFrameUrl = SampleController._createIFrameURL(vIframe, sSampleId);
			} else {
				jQuery.sap.log.error("no iframe source was provided");
				return null;
			}

			// destroy previous sample iframe
			var oHtmlControl = sap.ui.getCore().byId("sampleFrame");
			if (oHtmlControl) {
				oHtmlControl.destroy();
			}

			oHtmlControl = new HTML({
				id : "sampleFrame",
				content : '<iframe src="' + this.sIFrameUrl + '" id="sampleFrame" frameBorder="0"></iframe>'
			}).addEventDelegate({
				onAfterRendering : function () {
					oHtmlControl.$().on("load", function () {
						var oSampleFrame = oHtmlControl.$()[0].contentWindow;

						// Some samples don't have the framework loaded (f.e. hello world)
						if (!oSampleFrame.sap) {
							return;
						}

						oSampleFrame.sap.ui.getCore().attachInit(function() {
							var oSampleFrame = oHtmlControl.$()[0].contentWindow;
							oSampleFrame.sap.ui.getCore().applyTheme(sap.ui.getCore().getConfiguration().getTheme());
							oSampleFrame.jQuery('body').toggleClass("sapUiSizeCompact", jQuery("body").hasClass("sapUiSizeCompact")).toggleClass("sapUiSizeCozy", jQuery("body").hasClass("sapUiSizeCozy"));
						});
					});
				}
			});

			return oHtmlControl;
		},

		_createComponent : function () {
			// create component only once
			var sCompId = 'sampleComp-' + this._sId;
			var sCompName = this._sId;

			this._oComp = sap.ui.component(sCompId);

			if (this._oComp) {
				this._oComp.destroy();
			}

			this._oComp = sap.ui.getCore().createComponent({
				id : sCompId,
				name : sCompName
			});
			// create component container
			return new ComponentContainer({
				component: this._oComp
			});
		},

		onNavBack : function (oEvt) {
			if (this._oComp && this._oComp.exit) {
				this._oComp.exit();
			}
			this.router.myNavBack("home", {});
		},

		onNavToCode : function (evt) {
			this.router.navTo("code", {
				id : this._sId
			}, false);
		},

		onToggleFullScreen : function (oEvt) {
			ToggleFullScreenHandler.updateMode(oEvt, this.getView());
		},

		_initFakeLREP : function(){
			// fake stable IDs
			Utils.checkControlId = function() {
				return true;
			};

			FakeLrepConnectorLocalStorage.enableFakeConnector({
				"isProductiveSystem": true
			});
		},

		/*
		* Loades runtime authoring asynchronously (will fail if the rta library is not loaded)
		*/
		_loadRuntimeAuthoring : function() {
			try {
				sap.ui.require(["sap/ui/rta/RuntimeAuthoring"], function (RuntimeAuthoring) {
					this.getView().byId("toggleRTA").setVisible(true);
				}.bind(this));
			} catch (oException) {
				jQuery.sap.log.info("sap.ui.rta.RuntimeAuthoring could not be loaded, UI adaptation mode is disabled");
			}
		},

		onAdaptUI : function(oEvent) {
			sap.ui.require([
				"sap/ui/rta/RuntimeAuthoring"
			], function (
				RuntimeAuthoring
			) {
				if (!this._oRTA) {
					// default developerMode for CUSTOMER-layer is 'true'
					this._oRTA = new RuntimeAuthoring({flexSettings: {
						developerMode: false
					}});
					this._oRTA.setRootControl(this.getView().byId("page").getContent()[0]);
					this._oRTA.start();
				}
			}.bind(this));
		}
	});

	var R_EXTRACT_FILENAME = /\/([^\/]*)$/,// extracts everything after the last slash (e.g. some/path/index.html -> index.html)
		R_STRIP_UI5_ENDING = /\..+$/;// removes everything after the first dot in the filename (e.g. someFile.qunit.html -> .qunit.html)

	SampleController._createIFrameURL = function (sIFrameUrl, sSampleId) {
		// strip the file extension to be able to use jQuery.sap.getModulePath
		var aFileNameMatches = R_EXTRACT_FILENAME.exec(sIFrameUrl);
		var sFileName = (aFileNameMatches && aFileNameMatches.length > 1 ? aFileNameMatches[1] : sIFrameUrl);
		var sFileEnding = R_STRIP_UI5_ENDING.exec(sFileName)[0];
		var sIFrameWithoutUI5Ending = sIFrameUrl.replace(R_STRIP_UI5_ENDING, "");

		// combine namespace with the file name again
		sIFrameWithoutUI5Ending = jQuery.sap.getModulePath(sSampleId + "." + sIFrameWithoutUI5Ending, sFileEnding || ".html");

		// construct iFrame URL based on the index file and the current query parameters
		var sSearch = window.location.search,
			sThemeUrlParameter = "sap-ui-theme=" + sap.ui.getCore().getConfiguration().getTheme();

		// applying the theme after the bootstrap causes flickering, so we inject a URL parameter
		// to override the bootstrap parameter of the iFrame example
		if (sSearch && sSearch !== "?") {
			var oRegExp = /sap-ui-theme=[a-z0-9\-\_]+/;
			if (sSearch.match(oRegExp)) {
				sSearch = sSearch.replace(oRegExp, sThemeUrlParameter);
			} else {
				sSearch += "&" + sThemeUrlParameter;
			}
		} else {
			sSearch = "?" + sThemeUrlParameter;
		}

		if (sIFrameUrl.indexOf("?") > -1) {
			sSearch = sSearch.replace("?",  "&");
		}

		return sIFrameWithoutUI5Ending + sSearch;
	};

	return SampleController;
});

}; // end of sap/ui/demokit/explored/view/sample.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.demokit.
 */
jQuery.sap.declare('sap.ui.demokit.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Core'); // unlisted dependency retained
jQuery.sap.require('sap.ui.demokit.js.highlight-query-terms'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.library'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/library",['jquery.sap.global', 'sap/ui/Global', 'sap/ui/core/Core', './js/highlight-query-terms',
	'sap/ui/core/library',  // library dependency
	'sap/ui/commons/library'], // library dependency
	function(jQuery, Global, Core) {

	"use strict";


	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.demokit",
		version: "1.50.6",
		dependencies : ["sap.ui.core","sap.ui.commons"],
		types: [
			"sap.ui.demokit.UI5EntityCueCardStyle"
		],
		interfaces: [],
		controls: [
			"sap.ui.demokit.CodeSampleContainer",
			"sap.ui.demokit.CodeViewer",
			"sap.ui.demokit.FileUploadIntrospector",
			"sap.ui.demokit.HexagonButton",
			"sap.ui.demokit.HexagonButtonGroup",
			"sap.ui.demokit.IndexLayout",
			"sap.ui.demokit.SimpleTree",
			"sap.ui.demokit.TagCloud",
			"sap.ui.demokit.UI5EntityCueCard"
		],
		elements: [
			"sap.ui.demokit.SimpleTreeNode",
			"sap.ui.demokit.Tag",
			"sap.ui.demokit.UIAreaSubstitute"
		]
	});

	/* eslint-disable no-undef */
	/**
	 * SAPUI5 library with non-public controls, used in the UI5 demokit (SDK)
	 *
	 * @namespace
	 * @alias sap.ui.demokit
	 * @author SAP SE
	 * @version 1.50.6
	 * @private
	 * @sap-restricted sdk
	 */
	var thisLibrary = sap.ui.demokit;
	/* eslint-enable no-undef */

	/**
	 * Different styles for an entity cue card.
	 *
	 * @enum {string}
	 * @private
	 * @sap-restricted sdk
	 */
	thisLibrary.UI5EntityCueCardStyle = {

		/**
		 * default style (no special styling).
		 * @public
		 */
		Standard : "Standard",

		/**
		 * Demokit style
		 * @public
		 */
		Demokit : "Demokit"

	};

	sap.ui.lazyRequire("sap.ui.demokit.UI5EntityCueCard", "attachToContextMenu detachFromContextMenu");
	sap.ui.lazyRequire("sap.ui.demokit.DemokitApp", "new getInstance");
	sap.ui.lazyRequire("sap.ui.demokit.IndexPage");

	sap.ui.getCore().attachInit( function () {

		if ( jQuery("body").hasClass("sapUiDemokitBody") ) {

			var CodeSampleContainer = sap.ui.requireSync('sap/ui/demokit/CodeSampleContainer');
			var HexagonButton = sap.ui.requireSync('sap/ui/demokit/HexagonButton');
			var UI5EntityCueCard = sap.ui.requireSync('sap/ui/demokit/UI5EntityCueCard');

			// replace h1 headers with our title
			jQuery("h1").each(function() {
				var $ = jQuery(this),
				sTitle = $.text(),
				sColor = "Gray",//$.attr('color'),
				sIcon  = $.attr('icon'),
				sIconPos = $.attr('iconPos') || 'left:40px;top:20px;',
				$title = jQuery("<div class='sapUiDemokitTitle'><span>" + sTitle + "</span></div>");

				// first attach new content to DOM
				$.replaceWith($title);
				// only then enrich it with a HexButton (otherwise placeAt() will not find the UIArea)
				if ( sColor || sIcon) {
					$title.prepend("<div id='sap-demokit-icon'></div>");
					new HexagonButton({color:sColor, imagePosition:'position: relative;' + sIconPos, icon:sIcon}).placeAt("sap-demokit-icon");
				}

			});

			var $h2 = jQuery("h2");
			var $settings = jQuery('h2[id="settings"]');
			var sControls = jQuery("html").attr('data-sap-ui-dk-controls');
			if ( $settings.size() === 0 && $h2.size() >= 2 && sControls) {
				jQuery($h2[1]).before(jQuery("<h2 id='settings'>Settings (Overview)</h2><div cue-card='" + sControls.split(',')[0] + "'></div>"));
				$h2 = jQuery("h2");
			}
			var $tln = jQuery("ul.sapDkTLN");
			if ( $h2.size() > 0 && $tln.size() == 0 ) {
				$h2.first().before($tln = jQuery("<ul class='sapDkTLN'></ul>"));
			}

			$h2.each(function(idx) {
				var $ = jQuery(this);
				// Skip hidden sections. Can be used to suppress sections (e.g. settings) in a page
				if ( $.css('display') === 'none' ) {
					return;
				}
				if ( !$.attr('id') ) {
					$.attr('id', '__' + idx);
				}
				var a = jQuery("<a></a>").attr("href", "#" + $.attr('id')).text($.text()).addClass('sapDkLnk');
				var li = jQuery("<li></li>").append(a);
				$tln.append(li);
			});

			// create CodeSampleContainers
			jQuery("[code-sample]").each(function() {
				var $ = jQuery(this),
				sUiAreaId = $.attr('code-sample'),
				sScriptId = $.attr('script') || $.children('script').attr('id') || sUiAreaId + "-script";
				$.addClass("sapUiDemokitSampleCont");
				new CodeSampleContainer("code-sample-" + sUiAreaId, { scriptElementId : sScriptId, uiAreaId : sUiAreaId}).placeAt(this);
			});

			// create CueCards
			jQuery("[cue-card]").each(function() {
				var $ = jQuery(this),
					sEntityName = $.attr('cue-card');

				new UI5EntityCueCard({
					entityName : sEntityName,
					collapsible : false,
					expanded : true,
					style: 'Demokit',
					navigable: true,
					navigate: function(oEvent) {
						top.sap.ui.demokit.DemokitApp.getInstance().navigateToType(oEvent.getParameter("entityName"));
						oEvent.preventDefault();
					},
					title: 'Settings (Overview)'
				}).placeAt(this);
			});

		}

	});

	thisLibrary._getAppInfo = function(fnCallback) {
		var sUrl = sap.ui.resource("", "sap-ui-version.json");

		jQuery.ajax({
			url: sUrl,
			dataType: "json",
			error: function(xhr, status, e) {
				jQuery.sap.log.error("failed to load library list from '" + sUrl + "': " + status + ", " + e);
				fnCallback(null);
			},
			success : function(oAppInfo, sStatus, oXHR) {
				if (!oAppInfo) {
					jQuery.sap.log.error("failed to load library list from '" + sUrl + "': " + sStatus + ", Data: " + oAppInfo);
					fnCallback(null);
					return;
				}

				fnCallback(oAppInfo);
			}
		});
	};

	thisLibrary._loadAllLibInfo = function(sAppRoot, sInfoType /*"_getDocuIndex", "_getThirdPartyInfo", "_getLibraryInfo", "_getReleaseNotes", "_getLibraryInfoAndReleaseNotes"*/, sReqVersion, fnCallback) {

		// parameter fallback for compatibility: if the version is a function
		// then it is the old signature: (sAppRoot, sInfoType, fnCallback)
		if (typeof sReqVersion === "function") {
			fnCallback = sReqVersion;
			sReqVersion = undefined;
		}

		jQuery.sap.require("sap.ui.core.util.LibraryInfo");
		var LibraryInfo = sap.ui.require("sap/ui/core/util/LibraryInfo");
		var libInfo = new LibraryInfo();

		// special case: fetching library info and release notes in one cycle
		// this will use the _getLibraryInfo functionality and
		var bFetchReleaseNotes = sInfoType == "_getLibraryInfoAndReleaseNotes";
		if (bFetchReleaseNotes) {
			sInfoType = "_getLibraryInfo";
		}

		thisLibrary._getAppInfo(function(oAppInfo) {
			if (!(oAppInfo && oAppInfo.libraries)) {
				fnCallback(null, null);
				return;
			}

			var count = 0,
				aLibraries = oAppInfo.libraries,
				len = aLibraries.length,
				oLibInfos = {},
				oLibVersions = {},
				aLibs = [],
				libName,
				libVersion;
			for (var i = 0; i < len; i++) {
				libName = aLibraries[i].name;
				libVersion = aLibraries[i].version;
				aLibs.push(libName);
				oLibVersions[libName] = libVersion;

				/*eslint-disable no-loop-func */
				libInfo[sInfoType](libName, function(oExtensionData){
					var fnDone = function() {
						count++;
						if (count == len) {
							fnCallback(aLibs, oLibInfos, oAppInfo);
						}
					};
					oLibInfos[oExtensionData.library] = oExtensionData;
					// fallback to version coming from version info file
					// (in case of ABAP we always should refer to the libVersion if available!)
					if (!oLibInfos[oExtensionData.library].version) {
						oLibInfos[oExtensionData.library].version = oLibVersions[oExtensionData.library];
					}
					// fetch the release notes if defined - in case of no version
					// is specified we fallback to the current library version
					if (bFetchReleaseNotes) {
						if (!sReqVersion) {
							sReqVersion = oLibVersions[oExtensionData.library];
						}
						libInfo._getReleaseNotes(oExtensionData.library, sReqVersion, function(oReleaseNotes) {
							oLibInfos[oExtensionData.library].relnotes = oReleaseNotes;
							fnDone();
						});
					} else {
						fnDone();
					}
				});
				/*eslint-enable no-loop-func */
			}
		});
	};

	return thisLibrary;

});

}; // end of sap/ui/demokit/library.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.util.APIInfo') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides reuse functionality for reading documentation from api.json files (as created by the UI5 JSDoc3 template/plugin)
jQuery.sap.declare('sap.ui.demokit.util.APIInfo'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/util/APIInfo",['jquery.sap.global'],
	function(jQuery) {
	"use strict";

	/**
	 * Root path to read api.json files from
	 */
	var sTestResourcesRoot;

	/**
	 * Cached content of api.json files per library.
	 */

	var oLibraryDocumentation;

	function findLibrary(sEntityName) {
		var oVersionInfo = sap.ui.getVersionInfo();
		if ( oVersionInfo && Array.isArray(oVersionInfo.libraries) ) {
			for ( var i = 0; i < oVersionInfo.libraries.length; i++) {
				var library = oVersionInfo.libraries[i];
				if ( sEntityName === library.name || sEntityName.indexOf(library.name + ".") === 0 ) {
					return library.name;
				}
			}
		}

		// fallback to core (this ensures that the extraordinary packages of sap.ui.core are found, but doesn't work as soon as other libs do the same)
		return "sap.ui.core";

		/*
		// TODO: avoid hard coded knowledge about the extraordinary packages of sap.ui.core
		if ( /^sap\.ui\.(base|model|test|thirdparty)(\.|$)/.test(sEntityName) // sibling packages of sap.ui.cor
			 || /^sap\.ui(\.[^.]+)?$/.test(sEntityName) // sap.ui package and its content (without sub packages - won't find sap.ui.component.load)
			 || /^jQuery\.sap\./.test(sEntityName) ) { // jQuery plugin stuff
			return 'sap.ui.core';
		}

		return undefined;
		*/
	}

	function getAPIJSON(sLibrary) {

		if ( !sLibrary ) {
			return undefined;
		}

		var oLibraryDoc = oLibraryDocumentation[sLibrary];

		if ( oLibraryDoc === undefined ) {
			jQuery.ajax({
				async: false,
				url : sTestResourcesRoot + sLibrary.replace(/\./g, '/') + '/designtime/api.json',
				dataType : 'json',
				success : function(vResponse) {
					oLibraryDoc = oLibraryDocumentation[sLibrary] = vResponse;
				},
				error : function (err) {
					jQuery.sap.log.debug("failed to load api.json for: " + sLibrary);
					oLibraryDocumentation[sLibrary] = null; // avoid future loading
				}
			});
		}

		return oLibraryDoc;
	}

	function findSymbol(oLibDoc, sEntityName) {

		var i,j;

		if ( !oLibDoc ) {
			return undefined;
		}

		var symbols = oLibDoc.symbols;
		for ( i = 0; i < symbols.length; i++) {
			if ( symbols[i].name === sEntityName ) {
				return symbols[i];
			}
			if ( sEntityName.indexOf(symbols[i].name + '.') === 0 ) {
				if ( symbols[i].properties ) {
					for ( j = 0; j < symbols[i].properties.length; j++ ) {
						if ( symbols[i].properties[j].static && sEntityName === symbols[i].name + "." + symbols[i].properties[j].name ) {
							return symbols[i].properties[j];
						}
					}
				}
				if ( symbols[i].methods ) {
					for ( j = 0; j < symbols[i].methods.length; j++ ) {
						if ( symbols[i].methods[j].static && sEntityName === symbols[i].name + "." + symbols[i].methods[j].name ) {
							return symbols[i].methods[j];
						}
					}
				}
			}
		}
	}

	function convertSymbolAPI(json) {

		var ui5 = json['ui5-metadata'],
			oEntityDoc = {
				metatype : ui5 && ui5.stereotype,
				name : json.name,
				module : json.module,
				baseType : json.extends || undefined,
				doc : json.description,
				deprecation : json.deprecated && json.deprecated.text,
				since : json.since,
				experimental : json.experimental && json.experimental.text,
				specialSettings: {},
				properties : {},
				aggregations : {},
				associations : {},
				events : {},
				values : {},
				methods : {}
			},
			generatedMethods = {},
			generatedStaticMethods = {
				getMetadata: true,
				extend: true
			},
			HUNGARIAN_PREFIX = /^(?:fn|a|b|d|f|i|j|m|o|r|s|v)([A-Z])(.*)$/;

		function removeHungarianNotation(s) {
			var match = HUNGARIAN_PREFIX.exec(s);
			if ( match ) {
				return match[1].toLowerCase() + match[2];
			}
			return s;
		}

		function collectMethods(methods) {
			if ( methods ) {
				if ( typeof methods === 'string' ) {
					methods = methods.split(' ');
				}
				methods.forEach(function(method) {
					generatedMethods[method] = true;
				});
			}
			return methods;
		}

		function pushNestedParameters(oNestedParameters, aParameters, sParameterName) {
			for (var key in oNestedParameters) {
				if (oNestedParameters.hasOwnProperty(key)) {
					var sNestedParameterFullName = sParameterName + "." + oNestedParameters[key].name;
					aParameters.push({
						kind: 8,
						name : removeHungarianNotation(sNestedParameterFullName),
						type : oNestedParameters[key].type,
						doc : oNestedParameters[key].description,
						since : oNestedParameters[key].since,
						deprecation : oNestedParameters[key].deprecated && oNestedParameters[key].deprecated.text
					});
					if (oNestedParameters[key].parameterProperties) {
						pushNestedParameters(oNestedParameters[key].parameterProperties, aParameters, sNestedParameterFullName);
					}
				}
			}
		}

		if ( ui5 ) {
			if ( ui5.specialSettings ) {
				ui5.specialSettings.forEach(function(oSpecialSetting) {
					oEntityDoc.specialSettings[oSpecialSetting.name] = {
						kind : -1,
						name : oSpecialSetting.name,
						type : oSpecialSetting.type || 'any'
					};
				});
			}
			if ( ui5.properties ) {
				ui5.properties.forEach(function(oProperty) {
					oEntityDoc.properties[oProperty.name] = {
						kind : 0,
						name : oProperty.name,
						visibility: oProperty.visibility || "public",
						type : oProperty.type,
						defaultValue : oProperty.defaultValue,
						doc : oProperty.description,
						deprecation : oProperty.deprecated && oProperty.deprecated.text,
						deprecationSince : oProperty.deprecated && oProperty.deprecated.since,
						experimental : oProperty.experimental && oProperty.experimental.text,
						since : oProperty.since,
						bindable: oProperty.bindable || false,
						methods: collectMethods(oProperty.methods)
					};
				});
			}
			if ( ui5.aggregations ) {
				ui5.aggregations.forEach(function(oAggregation) {
					oEntityDoc.aggregations[oAggregation.name] = {
						kind : oAggregation.cardinality === "0..1" ? 1 : 2,
						name : oAggregation.name,
						type : oAggregation.type,
						cardinality: oAggregation.cardinality || "0..n",
						visibility: oAggregation.visibility || "public",
						doc : oAggregation.description,
						deprecation : oAggregation.deprecated && oAggregation.deprecated.text,
						experimental : oAggregation.experimental && oAggregation.experimental.text,
						since : oAggregation.since,
						bindable: oAggregation.bindable || false,
						methods: collectMethods(oAggregation.methods)
					};
				});
			}
			if ( ui5.associations ) {
				ui5.associations.forEach(function(oAssociation) {
					oEntityDoc.associations[oAssociation.name] = {
						kind : oAssociation.cardinality === "0..n" ? 4 : 3,
						name : oAssociation.name,
						type : oAssociation.type,
						cardinality: oAssociation.cardinality || "0..1",
						visibility: oAssociation.visibility || "public",
						doc : oAssociation.description,
						deprecation : oAssociation.deprecated && oAssociation.deprecated.text,
						experimental : oAssociation.experimental && oAssociation.experimental.text,
						since : oAssociation.since,
						methods: collectMethods(oAssociation.methods)
					};
				});
			}
			if ( ui5.events ) {
				ui5.events.forEach(function(oEvent) {
					oEntityDoc.events[oEvent.name] = {
						kind : 5,
						doc : oEvent.description,
						deprecation : oEvent.deprecated && oEvent.deprecated.text,
						since : oEvent.since,
						parameters : {},
						methods: collectMethods(oEvent.methods)
					};
					if ( oEvent.parameters ) {
						jQuery.each(oEvent.parameters, function(sName, oParameter) {
							oEntityDoc.events[oEvent.name].parameters[oParameter.name] = {
								kind: 6,
								name : oParameter.name,
								type : oParameter.type,
								doc : oParameter.description,
								since : oParameter.since,
								deprecation : oParameter.deprecated && oParameter.deprecated.text
							};
						});
					}
				});
			}
		}

		if ( json.properties ) {
			json.properties.forEach(function (oField) {
				oEntityDoc.values[oField.name] = {
					kind : 9,
					type : oField.type,
					module : oField.module,
					visibility : oField.visibility || 'public',
					'static' : oField['static'] || false,
					doc : oField.description,
					deprecation : oField.deprecated && oField.deprecated.text,
					experimental : oField.experimental && oField.experimental.text,
					since : oField.since
				};
			});
		}
		if ( json.methods ) {
			json.methods.slice().sort(function(a,b) {
				if ( !a.static && b.static ) {
					return -1;
				} else if ( a.static && !b.static ) {
					return 1;
				} else if ( a.name !== b.name ) {
					return a.name < b.name ? -1 : 1;
				} else {
					return 0;
				}
			}).forEach(function (oMethod) {
				oEntityDoc.methods[oMethod.name] = {
					kind : 7,
					type : oMethod.returnValue && oMethod.returnValue.type  || "sap.ui.core.void",
					module : oMethod.module,
					visibility : oMethod.visibility || 'public',
					'static' : oMethod['static'] || false,
					doc : oMethod.description,
					deprecation : oMethod.deprecated && oMethod.deprecated.text,
					since : oMethod.since,
					parameters : [],
					synthetic: generatedMethods.hasOwnProperty(oMethod.name) || (oMethod['static'] && generatedStaticMethods.hasOwnProperty(oMethod.name))
				};
				if ( oMethod.parameters ) {
					oMethod.parameters.forEach(function (oParameter) {
						oEntityDoc.methods[oMethod.name].parameters.push({
							kind: 8,
							name : removeHungarianNotation(oParameter.name),
							type : oParameter.type,
							doc : oParameter.description,
							since : oParameter.since,
							deprecation : oParameter.deprecated && oParameter.deprecated.text
						});
						if (oParameter.parameterProperties) {
							pushNestedParameters(oParameter.parameterProperties, oEntityDoc.methods[oMethod.name].parameters, oParameter.name);
						}
					});
				}
			});
		}

		return oEntityDoc;
	}

	function setRoot(sRoot) {
		sRoot = sRoot == null ? jQuery.sap.getModulePath('', '/') + '../test-resources/' : sRoot;
		if ( sRoot.slice(-1) != '/' ) {
			sRoot += '/';
		}
		sTestResourcesRoot = sRoot;
		oLibraryDocumentation = {}; // clear cache
	}

	function getFromAPIJSON(sEntityName) {
		var oLibDoc = getAPIJSON(findLibrary(sEntityName));
		var oSymbolAPIJSON = findSymbol(oLibDoc, sEntityName);
		return oSymbolAPIJSON ? convertSymbolAPI(oSymbolAPIJSON) : undefined;
	}

	setRoot();

	return {
		_setRoot : setRoot,
		getEntityInfo : getFromAPIJSON
	};

});

}; // end of sap/ui/demokit/util/APIInfo.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.util.JSDocUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides reuse functionality for reading documentation from api.json files (as created by the UI5 JSDoc3 template/plugin)
jQuery.sap.declare('sap.ui.demokit.util.JSDocUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.strings'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/util/JSDocUtil",['jquery.sap.strings'], function(jQuery) {

	"use strict";

	function defaultLinkFormatter(target, text) {
		return "<code>" + (text || target) + "</code>";
	}

	function format(src, options) {

		options = options || {};
		var beforeParagraph = options.beforeParagraph == null ? '<p>' : options.beforeParagraph;
		var afterParagraph = options.afterParagraph == null ? '</p>' : options.afterParagraph;
		var beforeFirstParagraph = options.beforeFirstParagraph == null ? beforeParagraph : options.beforeFirstParagraph;
		var afterLastParagraph = options.afterLastParagraph == null ? afterParagraph : options.afterLastParagraph;
		var linkFormatter = typeof options.linkFormatter === 'function' ? options.linkFormatter : defaultLinkFormatter;

		/*
		 * regexp to recognize important places in the text
		 *
		 * Capturing groups of the RegExp:
		 *   group 1: begin of a pre block
		 *   group 2: end of a pre block
		 *   group 3: begin of a header, implicitly ends a paragraph
		 *   group 4: end of a header, implicitly starts a new paragraph
		 *   group 5: target portion of an inline @link tag
		 *   group 6: (optional) text portion of an inline link tag
		 *   group 7: an empty line which implicitly starts a new paragraph
		 *
		 *      [-- <pre> block -] [---- some header ----] [---- an inline [@link ...} tag ----] [---------- an empty line ---------]  */
		var r = /(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;
		var inpre = false;

		src = src || '';
		linkFormatter = linkFormatter || defaultLinkFormatter;

		src = beforeFirstParagraph + src.replace(r, function(match, pre, endpre, header, endheader, linkTarget, linkText, emptyline) {
			if ( pre ) {
				inpre = true;
			} else if ( endpre ) {
				inpre = false;
			} else if ( header ) {
				if ( !inpre ) {
					return afterParagraph + match;
				}
			} else if ( endheader ) {
				if ( !inpre ) {
					return match + beforeParagraph;
				}
			} else if ( emptyline ) {
				if ( !inpre ) {
					return afterParagraph + beforeParagraph;
				}
			} else if ( linkTarget ) {
				if ( !inpre ) {
					return linkFormatter(linkTarget, linkText);
				}
			}
			return match;
		}) + afterLastParagraph;

		// remove empty paragraphs
		src = src.replace(new RegExp(jQuery.sap.escapeRegExp(beforeParagraph) + "\s*" + jQuery.sap.escapeRegExp(afterParagraph), "g"), "");

		return src;
	}

	return {
		formatTextBlock: format
	};

});

}; // end of sap/ui/demokit/util/JSDocUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.util.jsanalyzer.ASTUtils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides implementation of sap.ui.demokit.util.jsanalyzer.ASTUtils
jQuery.sap.declare('sap.ui.demokit.util.jsanalyzer.ASTUtils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.demokit.js.esprima'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/util/jsanalyzer/ASTUtils",['jquery.sap.global', 'sap/ui/demokit/js/esprima'],
	function(jQuery, esprima_) {
	"use strict";

	/*global esprima */

	var Syntax = esprima.Syntax;

	function unlend(node) {
		if ( node.type == Syntax.AssignmentExpression && node.left.type == Syntax.Identifier && node.right.type == Syntax.ObjectExpression ) {
			//console.log("lends found, skipped to " + node.type);
			return node.right;
		}
		return node;
	}

	/**
	 * Creates a map of property values from an AST 'object literal' node.
	 *
	 * The values in the map are again AST 'property' nodes (representing key/value pairs).
	 * It would be more convenient to just return the values, but the property node is needed
	 * to find the corresponding (preceding) documentation comment.
	 *
	 * If a defaultKey is given, then a simple literal value instead of an object literal is also accepted.
	 * It will be interpreted as the value of a property with the name specified as defaultKey.
	 * <pre>
	 *    "value"
	 * </pre>
	 * is a shorthand notation of
	 * <pre>
	 *   {
	 *     'defaultKey': "value"
	 *   }
	 * </pre>
	 * @param {object} node Esprima compatible node of a syntax tree
	 * @param {string} defaultKey When no object is given but only a literla, then the literal is assumed to be the value of the defaultKey
	 * @returns {Map<string,Property>} Map of "Property" objects keyed by the property key
	 */
	function createPropertyMap(node, defaultKey) {

		var result;

		if ( node != null ) {

			//if ( node.type === Syntax.Property ) {
			//	node = node.value;
			//	//console.log("property found, skipped to " + node.type);
			//}

			// special handling of the synthetic ___ = {} assignments that JSDoc3 creates for @lends statements -> reduce them to the object literal (right hand side of assignment)
			node = unlend(node);

			// if, instead of an object literal only a literal is given and there is a defaultKey, then wrap the literal in a map
			if ( node.type === Syntax.Literal && defaultKey != null ) {
				result = {};
				result[defaultKey] = { type: Syntax.Property, value: node };
				return result;
			}

			if ( node.type != Syntax.ObjectExpression ) {
				// something went wrong, it's not an object literal
				jQuery.sap.log.error("not an object literal:" + node.type + ":" + node.value);
				// console.log(node.toSource());
				return;
			}

			// invariant: node.type == Syntax.ObjectExpression
			result = {};
			for (var i = 0; i < node.properties.length; i++) {
				var prop = node.properties[i];
				var name;
				//console.log("objectproperty " + prop.type);
				if ( prop.key.type === Syntax.Identifier ) {
					name = prop.key.name;
				} else if ( prop.key.type === Syntax.Literal ) {
					name = String(prop.key.value);
				} else {
					name = prop.key.toSource();
				}
				//console.log("objectproperty " + prop.type + ":" + name);
				result[name] = prop;
			}
		}
		return result;
	}

	var astNodeInfos = {
		AssignmentExpression: [ 'left', 'right' ],
		ArrayExpression: [ 'elements' ],
		BlockStatement: [ 'body' ],
		BinaryExpression: [ 'left', 'right' ],
		BreakStatement: [],
		CallExpression: [ 'callee', 'arguments' ],
		CatchClause: [],
		ConditionalExpression: [ 'test', 'consequent', 'alternate' ],
		ContinueStatement: [],
		DoWhileStatement: [ 'body', 'test' ],
		DebuggerStatement: [],
		EmptyStatement: [],
		ExpressionStatement: [ 'expression' ],
		ForStatement: [ 'init', 'test', 'update', 'body' ],
		ForInStatement: [ 'left', 'right', 'body' ],
		FunctionDeclaration: [ 'id', 'params', 'body' ],
		FunctionExpression: [ 'id', 'params', 'body' ],
		Identifier: [],
		IfStatement: [ 'test', 'consequent', 'alternate' ],
		Literal: [],
		LabeledStatement: [ 'body' ],
		LogicalExpression: [ 'left', 'right' ],
		MemberExpression: [ 'object', 'property' ],
		NewExpression: [ 'callee', 'arguments' ],
		ObjectExpression: [ 'properties' ],
		Program: [ 'body' ],
		Property: [ 'key', 'value' ],
		ReturnStatement: [ 'argument' ],
		SequenceExpression: [ 'expressions' ],
		SwitchStatement: [ 'discriminant', 'cases' ],
		SwitchCase: [ 'test', 'consequent' ],
		ThisExpression: [],
		ThrowStatement: [ 'argument' ],
		TryStatement: [ '' ], // TODO
		UnaryExpression: [ 'argument' ],
		UpdateExpression: [ 'argument' ],
		VariableDeclaration: [ 'declarations' ],
		VariableDeclarator: [ 'id', 'init' ],
		WhileStatement: [ 'test', 'body' ],
		WithStatement: [ 'object', 'body' ]
	};

	function visit(root, delegate, args) {

		function _visit(node) {

			// call the delegate before the children
			if ( delegate["*"] ) {
				delegate["*"].call(delegate, node, args);
			}
			if ( delegate[node.type] ) {
				delegate[node.type].call(delegate, node, args);
			}

			// visit children
			var aChildNames = astNodeInfos[node.type];
			if ( aChildNames ) {
				for (var i = 0; i < aChildNames.length; i++) {
					var aChildNodes = node[aChildNames[i]];
					if ( jQuery.isArray(aChildNodes) ) {
						for ( var j = 0; j < aChildNodes.length; j++) {
							if ( aChildNodes[j] ) {
								_visit(aChildNodes[j]);
							}
						}
					} else if ( aChildNodes ) {
						_visit(aChildNodes);
					}
				}
			} else {
				jQuery.sap.log.warning("don't know how to handle " + node.type);
			}

			// call the delegate
			if ( delegate["after:" + node.type] ) {
				delegate["after:" + node.type].call(delegate, node, args);
			}
			if ( delegate["after:*"] ) {
				delegate["after:*"].call(delegate, node, args);
			}

		}

		_visit(root);
	}

	return {
		createPropertyMap: createPropertyMap,
		unlend: unlend,
		visit : visit
	};

}, /* export= */ true);


}; // end of sap/ui/demokit/util/jsanalyzer/ASTUtils.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.util.jsanalyzer.Doclet') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides implementation of sap.ui.demokit.util.jsanalyzer.Doclet
jQuery.sap.declare('sap.ui.demokit.util.jsanalyzer.Doclet'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/util/jsanalyzer/Doclet",['jquery.sap.global'],
	function (jQuery, esprima_) {

		"use strict";

		/* ---- private functions ---- */

		/**
		 * Removes the mandatory comment markers and the optional but common asterisks at the beginning of each line.
		 *
		 * The result is easier to parse/analyze.
		 *
		 * @param {string} comment Comment to unwrap
		 * @return {string} Unwrapped comment
		 * @private
		 */
		function unwrap(comment) {

			if (!comment) {
				return '';
			}

			return comment.replace(/^\/\*\*+/, '')                // remove opening slash+stars
				.replace(/\*+\/$/, '')                            // remove closing star+slash
				.replace(/(^|\r\n|\r|\n)([ \t*]*[ \t]*)/g, '$1'); // remove left margin

		}

		var rtag = /((?:^|\r\n|\r|\n)[ \t]*@)([a-zA-Z][-_a-zA-Z0-9]*)/g;

		/**
		 * Creates a Doclet from the given comment string
		 * @param {string} comment Comment string.
		 * @constructor
		 * @private
		 */
		function Doclet(comment) {

			this.comment = comment = unwrap(comment);
			this.tags = [];

			var m;
			var lastContent = 0;
			var lastTag = "description";
			while ((m = rtag.exec(comment)) != null) {
				this._addTag(lastTag, comment.slice(lastContent, m.index));
				lastTag = m[2];
				lastContent = rtag.lastIndex;
			}
			this._addTag(lastTag, comment.slice(lastContent));
		}

		Doclet.prototype._addTag = function (tag, content) {
			if (/^(public|private|protected)$/.test(tag)) {
				this.visibility = tag;
			} else if (/^(classdesc|description|deprecated|experimental|since|name|alias|type)$/.test(tag)) {
				this[tag] = jQuery.trim(content);
			} else if (tag === "class") {
				content = jQuery.trim(content);
				if (content.split(/\s+/).length > 1) {
					this.classdesc = content;
				}
			} else {
				this.tags.push({tag: tag, content: jQuery.trim(content)});
			}
		};

		Doclet.prototype.isPublic = function () {
			return this.visibility === 'public';
		};

		Doclet.get = function (node) {
			var comment = null;
			var leadingComments = node.leadingComments;

			if (jQuery.isArray(leadingComments)) {
				for (var i = 0; i < leadingComments.length; i++) {
					if (leadingComments[i].value && /^\*/.test(leadingComments[i].value)) {
						comment = leadingComments[i].value;
					}
				}
			}

			return comment ? new Doclet(comment) : null;
		};

		return Doclet;

	}, true);

}; // end of sap/ui/demokit/util/jsanalyzer/Doclet.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.util.jsanalyzer.ModuleAnalyzer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides implementation of sap.ui.demokit.util.jsanalyzer.EntityParser
jQuery.sap.declare('sap.ui.demokit.util.jsanalyzer.ModuleAnalyzer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObjectMetadata'); // unlisted dependency retained
jQuery.sap.require('sap.ui.demokit.js.esprima'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/util/jsanalyzer/ModuleAnalyzer",['jquery.sap.global', 'sap/ui/base/ManagedObjectMetadata', './ASTUtils', './Doclet', 'sap/ui/demokit/js/esprima'],
	function (jQuery, MOMetadata, ASTUtils, Doclet, esprima_) {

		"use strict";

		/*global esprima */

		var Syntax = esprima.Syntax;

		/* ---- private functions ---- */

		/**
		 * Name of the package in which the currently analyzed entity resides.
		 *
		 * Used to resolve relative dependencies in sap.ui.define calls.
		 *
		 * @type {string}
		 * @private
		 */
		var currentPackage;

		/**
		 * List of collected info objects. A JS file might contain multiple class and/or type definitions.
		 *
		 * @type {object[]}
		 * @private
		 */
		var aInfos;

		/**
		 * Object with all the parsed public functions
		 * type {Object}
		 */
		var oPublicFunctions;

		/**
		 * Name of the current control
		 * type {string}
		 */
		var sControlName;

		/**
		 * Cumulated scope information for the currently analyzed module.
		 *
		 * This is not the same as the Javascript scope of any of the functions in the module but it is a projection
		 * of all scopes. It is only maintained to properly recognize sa.ui.base.DataType and some other core classes
		 * with a specific meaning for the class / type analysis (e.g. jQuery).
		 *
		 * Keys in the map are names of local variables, values are their corresponding global name (if known).
		 *
		 * For a full fledged scope analysis, either the StaticAnalyzer needs to be migrated or an opensource
		 * component like 'escope' could be integrated.
		 *
		 * @type {Map<string,string>}
		 * @private
		 */
		var scope; // TODO implement scope properly using escope

		// some shortcuts
		var createPropertyMap = ASTUtils.createPropertyMap;
		var unlend = ASTUtils.unlend;
		var guessSingularName = MOMetadata._guessSingularName;
		var getLeadingDoclet = Doclet.get;
		var error = jQuery.sap.log.error;
		var warning = jQuery.sap.log.warning;
		var verbose = jQuery.sap.log.debug;

		function isExtendCall(node) {

			return (
				node
				&& node.type === Syntax.CallExpression
				&& node.callee.type === Syntax.MemberExpression
				&& node.callee.property.type === Syntax.Identifier
				&& node.callee.property.name === 'extend'
				&& node.arguments.length >= 2
				&& node.arguments[0].type === Syntax.Literal
				&& typeof node.arguments[0].value === "string"
				&& unlend(node.arguments[1]).type === Syntax.ObjectExpression
			);

		}

		function isSapUiDefineCall(node) {

			return (
				node
				&& node.type === Syntax.CallExpression
				&& node.callee.type === Syntax.MemberExpression
				&& /* TODO currentScope.getContext(). */ getObjectName(node.callee) === 'sap.ui.define'
			);

		}

		function getObjectName(node) {
			if ( node.type === Syntax.MemberExpression ) {
				var prefix = getObjectName(node.object);
				return prefix ? prefix + "." + node.property.name : null;
			} else if ( node.type === Syntax.Identifier ) {
				return scope[node.name] ? scope[node.name] : node.name;
			} else {
				return null;
			}
		}

		function convertValue(node, type) {

			var value;

			if ( node.type === Syntax.Literal ) {

				// 'string' or number or true or false
				return node.value;

			} else if ( node.type === Syntax.UnaryExpression
				&& node.prefix
				&& node.argument.type === Syntax.Literal
				&& typeof node.argument.value === 'number'
				&& ( node.operator === '-' || node.operator === '+' )) {

				// -n or +n
				value = node.argument.value;
				return node.operator === '-' ? -value : value;

			} else if ( node.type === Syntax.MemberExpression && type ) {

				// enum value (a.b.c)
				value = getObjectName(node);
				if ( value.indexOf(type + ".") === 0 ) {
					// fully qualified enum name
					return value.slice(type.length + 1);
				} else if ( value.indexOf(type.split(".").slice(-1)[0] + ".") === 0 ) {
					// local name (just a guess - needs static code analysis)
					return value.slice(type.split(".").slice(-1)[0].length + 1);
				} else {
					warning("did not understand default value '%s', falling back to source", value);
					return value;
				}

			} else if ( node.type === Syntax.Identifier
				&& node.name === 'undefined') {

				// undefined
				return undefined;

			} else if ( node.type === Syntax.ArrayExpression
				&& node.elements.length === 0 ) {

				// empty array literal
				return "[]"; // TODO return this string or an empty array
			}

			error("unexpected type of default value (type='%s', source='%s'), falling back to '???'", node.type, JSON.stringify(node, null, "\t"));
			return '???';
		}

		function collectClassInfo(extendCall, classDoclet) {

			var baseType = getObjectName(extendCall.callee.object);

			var oClassInfo = {
				metatype: 'control',
				name: extendCall.arguments[0].value,
				baseType: baseType,
				doc: classDoclet && (classDoclet.classdesc || classDoclet.description),
				deprecation: classDoclet && classDoclet.deprecated,
				since: classDoclet && classDoclet.since,
				experimental: classDoclet && classDoclet.experimental,
				specialSettings : {},
				properties: {},
				aggregations: {},
				associations: {},
				events: {},
				methods: {}
			};

			function upper(n) {
				return n.slice(0,1).toUpperCase() + n.slice(1);
			}

			function each(node, defaultKey, callback) {
				var map, n, settings, doclet;

				map = node && createPropertyMap(node.value);
				if ( map ) {
					for (n in map) {
						if ( map.hasOwnProperty(n) ) {
							doclet = getLeadingDoclet(map[n]);
							settings = createPropertyMap(map[n].value, defaultKey);
							if ( settings == null ) {
								error("no valid metadata for " + n + " (AST type '" + map[n].value.type + "')");
								continue;
							}

							callback(n, settings, doclet, map[n]);
						}
					}
				}
			}

			var classInfoNode = unlend(extendCall.arguments[1]);
			var classInfoMap = createPropertyMap(classInfoNode);
			if ( classInfoMap && classInfoMap.metadata && classInfoMap.metadata.value.type !== Syntax.ObjectExpression ) {
				warning("class metadata exists but can't be analyzed. It is not of type 'ObjectExpression', but a '" + classInfoMap.metadata.value.type + "'.");
				return null;
			}

			var metadata = classInfoMap && classInfoMap.metadata && createPropertyMap(classInfoMap.metadata.value);
			if ( metadata ) {

				verbose("  analyzing metadata for '" + oClassInfo.name + "'");

				oClassInfo["abstract"] = !!(metadata["abstract"] && metadata["abstract"].value.value);
				oClassInfo["final"] = !!(metadata["final"] && metadata["final"].value.value);

				each(metadata.specialSettings, "readonly", function(n, settings, doclet) {
					oClassInfo.specialSettings[n] = {
						name : n,
						doc : doclet && doclet.description,
						since : doclet && doclet.since,
						deprecation : doclet && doclet.deprecated,
						experimental : doclet && doclet.experimental,
						visibility : (settings.visibility && settings.visibility.value.value) || "public",
						type : settings.type ? settings.type.value.value : "any",
						readonly : (settings.readyonly && settings.readonly.value.value) || true
					};
				});

				each(metadata.properties, "type", function (n, settings, doclet) {
				var type;
					var N = upper(n);
					var methods;
					oClassInfo.properties[n] = {
						name: n,
						doc: doclet && doclet.description,
						since: doclet && doclet.since,
						deprecation: doclet && doclet.deprecated,
						experimental: doclet && doclet.experimental,
						visibility: (settings.visibility && settings.visibility.value.value) || "public",
						type: (type = settings.type ? settings.type.value.value : "string"),
						defaultValue: settings.defaultValue ? convertValue(settings.defaultValue.value, type) : null,
						group : settings.group ? settings.group.value.value : 'Misc',
						bindable : settings.bindable ? !!convertValue(settings.bindable.value) : false,
						methods: (methods = {
							"get": "get" + N,
							"set": "set" + N
						})
					};
					if ( oClassInfo.properties[n].bindable ) {
						methods["bind"] = "bind" + N;
						methods["unbind"] = "unbind" + N;
					}
				});

				oClassInfo.defaultAggregation = (metadata.defaultAggregation && metadata.defaultAggregation.value.value) || undefined;

				each(metadata.aggregations, "type", function (n, settings, doclet) {
					var N = upper(n);
					var methods;
					oClassInfo.aggregations[n] = {
						name: n,
						doc: doclet && doclet.description,
						deprecation: doclet && doclet.deprecated,
						since: doclet && doclet.since,
						experimental: doclet && doclet.experimental,
						visibility: (settings.visibility && settings.visibility.value.value) || "public",
						type: settings.type ? settings.type.value.value : "sap.ui.core.Control",
						singularName: settings.singularName ? settings.singularName.value.value : guessSingularName(n),
						cardinality: (settings.multiple && !settings.multiple.value.value) ? "0..1" : "0..n",
						bindable : settings.bindable ? !!convertValue(settings.bindable.value) : false,
						methods: (methods = {
							"get": "get" + N,
							"destroy": "destroy" + N
						})
					};
					if ( oClassInfo.aggregations[n].cardinality === "0..1" ) {
						methods["set"] = "set" + N;
					} else {
						var N1 = upper(oClassInfo.aggregations[n].singularName);
						methods["insert"] = "insert" + N1;
						methods["add"] = "add" + N1;
						methods["remove"] = "remove" + N1;
						methods["indexOf"] = "indexOf" + N1;
						methods["removeAll"] = "removeAll" + N;
					}
					if ( oClassInfo.aggregations[n].bindable ) {
						methods["bind"] = "bind" + N;
						methods["unbind"] = "unbind" + N;
					}
				});

				each(metadata.associations, "type", function (n, settings, doclet) {
					var N = upper(n);
					var methods;
					oClassInfo.associations[n] = {
						name: n,
						doc: doclet && doclet.description,
						deprecation: doclet && doclet.deprecated,
						since: doclet && doclet.since,
						experimental: doclet && doclet.experimental,
						visibility: (settings.visibility && settings.visibility.value.value) || "public",
						type: settings.type ? settings.type.value.value : "sap.ui.core.Control",
						singularName: settings.singularName ? settings.singularName.value.value : guessSingularName(n),
						cardinality : (settings.multiple && settings.multiple.value.value) ? "0..n" : "0..1",
						methods: (methods = {
							"get": "get" + N
						})
					};
					if ( oClassInfo.associations[n].cardinality === "0..1" ) {
						methods["set"] = "set" + N;
					} else {
						var N1 = upper(oClassInfo.associations[n].singularName);
						methods["add"] = "add" + N1;
						methods["remove"] = "remove" + N1;
						methods["removeAll"] = "removeAll" + N;
					}
				});

				each(metadata.events, null, function (n, settings, doclet) {
					var N = upper(n);
					var info = oClassInfo.events[n] = {
						name: n,
						doc: doclet && doclet.description,
						deprecation: doclet && doclet.deprecated,
						since: doclet && doclet.since,
						experimental: doclet && doclet.experimental,
						allowPreventDefault: !!(settings.allowPreventDefault && settings.allowPreventDefault.value.value),
						parameters : {},
						methods: {
							"attach": "attach" + N,
							"detach": "detach" + N,
							"fire": "fire" + N
						}
					};
					each(settings.parameters, null, function (pName, pSettings, pDoclet) {
						info.parameters[pName] = {
							name: pName,
							doc: pDoclet && pDoclet.description,
							deprecation: pDoclet && pDoclet.deprecated,
							since: pDoclet && pDoclet.since,
							experimental: pDoclet && pDoclet.experimental,
							type: pSettings && pSettings.type ? pSettings.type.value.value : ""
						};
					});
				});
			}

			return oClassInfo;
		}

		function collectEnumInfo(node) {

			var doclet = Doclet.get(node);
			var name = /* TODO currentScope.getContext(). */ getObjectName(node.expression.left);

			if ( name && doclet && doclet.isPublic() ) {

				var oTypeDoc = {
					metatype: "type",
					doc: undefined,
					deprecation: false,
					visibility: 'public'
				};

				oTypeDoc.name = name;
				if ( doclet ) {
					oTypeDoc.doc = doclet.description;
					oTypeDoc.deprecation = doclet.deprecation;
					oTypeDoc.since = doclet.since;
					oTypeDoc.experimental = doclet.experimental;
					// TODO oTypeDoc["final"] = doclet.hasTatypeDocumentation.hasTag("final") ? new SimpleType.Final() : null);
					// TODO simpleType.setDefaultValue(typeDocumentation.getTagContent("defaultvalue"));
				}

				var properties = node.expression.right.properties || [];
				oTypeDoc.values = {};
				for (var i = 0; i < properties.length; i++) {

					// documentation must precede the name/value pair
					var propDoclet = Doclet.get(properties[i]);
					var key = properties[i].key;
					var value = properties[i].value;

					var valueInfo = {};
					// the name of the enum value equals the name in the name/value pair
					if ( key.type == Syntax.Identifier ) {
						valueInfo.name = key.name;
					} else if ( key.type == Syntax.Literal ) {
						valueInfo.name = key.value;
					} else {
						throw new Error();
					}

					// the value equals the value in the name/value pair
					if ( value.type == Syntax.Literal ) {
						valueInfo.value = value.value;
					} else {
						throw new Error();
					}

					if ( propDoclet != null ) {
						valueInfo.doc = propDoclet.description;
						valueInfo.deprecation = propDoclet.deprecation;
						valueInfo.since = propDoclet.since;
						valueInfo.experimental = propDoclet.experimental;
					}

					oTypeDoc.values[valueInfo.name] = valueInfo;

				}

				aInfos.push(oTypeDoc);

			}

		}

		function collectRegExTypeInfo(node) {

			var doclet = Doclet.get(node);
			var name = node.expression.right.arguments[0].value;
			var settings = ASTUtils.createPropertyMap(node.expression.right.arguments[1]);
			var baseType = null;
			if ( node.expression.right.arguments.length > 2
				&& node.expression.right.arguments[2].type == Syntax.CallExpression
				&& node.expression.right.arguments[2].callee.type == Syntax.MemberExpression
				&& /* TODO currentScope.getContext().*/ getObjectName(node.expression.right.arguments[2].callee) == "sap.ui.base.DataType.getType"
				&& node.expression.right.arguments[2].arguments.length > 0
				&& node.expression.right.arguments[2].arguments[0].type == Syntax.Literal ) {
				baseType = node.expression.right.arguments[2].arguments[0].value;
			}

			if ( name && doclet && doclet.isPublic() ) {

				var oTypeDoc = {
					metatype: "type",
					doc: undefined,
					deprecation: false,
					visibility: 'public'
				};

				oTypeDoc.name = name;

				if ( doclet ) {
					oTypeDoc.doc = doclet.description;
					oTypeDoc.deprecation = doclet.deprecation;
					oTypeDoc.since = doclet.since;
					oTypeDoc.experimental = doclet.experimental;
					// TODO oTypeDoc["final"] = doclet.hasTatypeDocumentation.hasTag("final") ? new SimpleType.Final() : null);
				}

				var defaultValue = settings.defaultValue;
				if ( defaultValue ) {
					oTypeDoc.defaultValue = convertValue(defaultValue.value, name);
				}

				var isValid = settings.isValid;
				if ( isValid
					&& isValid.value.type == Syntax.FunctionExpression
					&& isValid.value.body
					&& isValid.value.body.body.length > 0
					&& isValid.value.body.body[0].type == Syntax.ReturnStatement
					&& isValid.value.body.body[0].argument.type == Syntax.CallExpression
					&& isValid.value.body.body[0].argument.callee.type == Syntax.MemberExpression
					&& isValid.value.body.body[0].argument.callee.object.type == Syntax.Literal
					&& isValid.value.body.body[0].argument.callee.object.value instanceof RegExp ) {

					var pattern = isValid.value.body.body[0].argument.callee.object.value.source;
					if ( /^\^\(.*\)\$$/.test(pattern) ) {
						pattern = pattern.slice(2, -2);
					}
					oTypeDoc.pattern = pattern;
				}

				oTypeDoc.baseType = baseType;

				aInfos.push(oTypeDoc);
			}

		}

		function resolveRelativeDependency(dep) {
			return /^\.\//.test(dep) ? currentPackage + dep.slice(1) : dep;
		}

		/**
		 * Get the documentation information needed for a given parameter
		 * @param {string} sParamName Name of the parameter to be fetched
		 * @param {array} aDocTags With documentation tags
		 * @return {Object} Parameter information
		 */
		function getParamInfo(sParamName, aDocTags) {

			//set default parameter type if there are no @ definitions for the type
			var sParamType = '',
				sParamDescription = '',
				iParamNameIndex,
				iDocStartIndex,
				rEgexMatchType = /{(.*)}/,
				aMatch;

			for (var i = 0; i < aDocTags.length; i++) {

				if ( aDocTags[i].tag !== 'param' ) {
					continue;
				}

				aMatch = rEgexMatchType.exec(aDocTags[i].content);
				iParamNameIndex = aDocTags[i].content.indexOf(sParamName);

				if ( aMatch && iParamNameIndex > -1 ) {
					//get the match without the curly brackets
					sParamType = aMatch[1];

					iDocStartIndex = iParamNameIndex + sParamName.length;
					sParamDescription = aDocTags[i].content.substr(iDocStartIndex);

					//clean the doc from - symbol if they come after the param name and trim the extra whitespace
					sParamDescription = sParamDescription.replace(/[-]/, '').trim();

					// prevent unnecessary looping!
					break;
				}
			}

			return {
				name: sParamName,
				type: sParamType,
				doc: sParamDescription
			};
		}

		var delegate = {

			"ExpressionStatement": function (node) {

				if ( isSapUiDefineCall(node.expression) ) {

					var i = 0;
					var dependencies, factory;
					if ( i < node.expression.arguments.length && node.expression.arguments[i].type === Syntax.Literal ) {
						/* name = */
						node.expression.arguments[i++].value;
					}
					if ( i < node.expression.arguments.length && node.expression.arguments[i].type === Syntax.ArrayExpression ) {
						dependencies = node.expression.arguments[i++].elements;
					}
					if ( i < node.expression.arguments.length && node.expression.arguments[i].type === Syntax.FunctionExpression ) {
						factory = node.expression.arguments[i++];
					}
					//			// unused
					//			if ( i < node.expression.arguments.length && node.expression.arguments[i].type === Syntax.FunctionExpression ) {
					//				export_ = node.expression.arguments[i++];
					//			}

					if ( dependencies && factory && factory.params ) {
						for (var j = 0; j < dependencies.length; j++) {
							var dep = dependencies[j].type === Syntax.Literal ? resolveRelativeDependency(dependencies[j].value) : null;
							var paramName = j < factory.params.length ? factory.params[j].name : null;
							if ( dep && paramName ) {
								// TODO this is only a hack. For a proper scope and constant value handling
								// much more needs to be done (e.g. migration of StaticAnalyzer.java)
								scope[paramName] = dep.replace(/\//g, '.');
							}
						}
					}
				}

				// ---- Something = { ... } ----
				if ( node.expression.type == Syntax.AssignmentExpression
					&& node.expression.right.type == Syntax.ObjectExpression
					&& node.expression.left.type == Syntax.MemberExpression ) {

					collectEnumInfo(node);

				}

				// ---- sap.ui.base.DataType.createType ----

				if ( node.expression.type === Syntax.AssignmentExpression
					&& node.expression.right.type === Syntax.CallExpression
					&& node.expression.right.callee.type === Syntax.MemberExpression
					&& node.expression.right.callee.property.type === Syntax.Identifier
					&& node.expression.right.callee.property.name === 'createType'
					&& /* TODO currentScope.getContext().*/ getObjectName(node.expression.right.callee.object) == 'sap.ui.base.DataType'
					&& node.expression.right.arguments.length >= 2
					&& node.expression.right.arguments[0].type === Syntax.Literal
					&& node.expression.right.arguments[1].type === Syntax.ObjectExpression ) {

					collectRegExTypeInfo(node);
				}

				// ---- Something.extend() ----

				if ( isExtendCall(node.expression) ) {

					var doclet = Doclet.get(node) || Doclet.get(node.expression);
					var oClassInfo = collectClassInfo(node.expression, doclet);
					if ( oClassInfo ) {
						aInfos.push(oClassInfo);
					}

				}

			},

			"VariableDeclaration": function (node) {

				if ( node.declarations.length == 1
					&& node.declarations[0].init
					&& isExtendCall(node.declarations[0].init) ) {

					var doclet = Doclet.get(node) || Doclet.get(node.declarations[0]);
					var oClassInfo = collectClassInfo(node.declarations[0].init, doclet);
					if ( oClassInfo ) {
						aInfos.push(oClassInfo);
					}

				}

			},

			"FunctionExpression": function (node) {
				var aFunctions = node.body.body;

				aFunctions.forEach(function (functionNode) {
					if ( functionNode.expression
						&& functionNode.expression.type !== Syntax.AssignmentExpression ) {
						return;
					}
					var oParsed = functionNode;
					var oFuncDoc = Doclet.get(functionNode);

					if ( oFuncDoc && oFuncDoc.isPublic()
						&& oParsed.expression
						&& oParsed.expression.left
						&& oParsed.expression.left.property
						&& oParsed.expression.left.object
						&& oParsed.expression.left.object.object
						&& oParsed.expression.left.object.object.name === sControlName ) {

						var oPublicMethod = {},
							parsedParams = oParsed.expression.right.params ? oParsed.expression.right.params : [];

						oPublicMethod.name = oParsed.expression.left.property.name;
						oPublicMethod.doc = oFuncDoc.description;
						oPublicMethod.since = oFuncDoc.since;
						oPublicMethod.experimental = oFuncDoc.experimental;
						oPublicMethod.deprecation = oFuncDoc.deprecated;
						oPublicMethod.type = oFuncDoc.type ? oFuncDoc.type : '';
						oPublicMethod.parameters = [];

						parsedParams.forEach(function (oParam) {
							var oParamData = getParamInfo(oParam.name, oFuncDoc.tags);
							oPublicMethod.parameters.push(oParamData);
						});

						oPublicFunctions[oPublicMethod.name] = oPublicMethod;
					}
				});
			}

		};

		/**
		 * Adds the methods section to the metadata
		 * @param {Object} metadata
		 */

		// it should be done at the latest because sometimes it is empty on collectClassInfo
		// and it does not call collectClassInfo or createPropertyMap by itself
		function addMethodsToMetadata(metadata) {
			metadata.methods = oPublicFunctions;
		}

		function analyze(oData, sEntityName, sModuleName) {

			currentPackage = sModuleName.split('/').slice(0, -1).join('/');
			aInfos = [];
			oPublicFunctions = {};
			scope = {};
			sControlName = sEntityName.split('.').pop();

			var ast = esprima.parse(oData, {comment: true, attachComment: true});
			ASTUtils.visit(ast, delegate);

			for (var i = 0; i < aInfos.length; i++) {
				if ( aInfos[i].name === sEntityName ) {
					addMethodsToMetadata(aInfos[i]);
					return aInfos[i];
				}
			}
		}

		return {
			analyze: analyze
		};

	}, false);

}; // end of sap/ui/demokit/util/jsanalyzer/ModuleAnalyzer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.CodeViewer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.CodeViewer.
jQuery.sap.declare('sap.ui.demokit.CodeViewer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/CodeViewer",['jquery.sap.global', 'sap/ui/commons/Button', 'sap/ui/commons/Dialog', 'sap/ui/core/Control', './library'],
	function(jQuery, Button, Dialog, Control, library) {
	"use strict";



	/**
	 * Constructor for a new CodeViewer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Shows a piece of (Javascript) code and allows to edit it
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.CodeViewer
	 */
	var CodeViewer = Control.extend("sap.ui.demokit.CodeViewer", /** @lends sap.ui.demokit.CodeViewer.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * The source code to display.
			 */
			source : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The CSS width property
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},

			/**
			 * The CSS height property
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},

			/**
			 * Whether the code can be edited or not
			 */
			editable : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Whether the code to have line numbering or not
			 */
			lineNumbering : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Whether the code viewer should be visible
			 */
			visible : {type : "boolean", group : "Misc", defaultValue : true}
		},
		events : {

			/**
			 * Called when the mouse button is clicked over the non-editable(!) control
			 */
			press : {},

			/**
			 * Called when the editor is active and should be saved
			 */
			save : {}
		}
	}});

	/*global prettyPrint *///declare unusual global vars for JSLint/SAPUI5 validation

	CodeViewer.load = function() {
		if ( !window.prettyPrint ) {
			jQuery.sap.require("sap.ui.demokit.js.google-code-prettify.prettify");
		}
	};

	CodeViewer.load();

	/**
	 * Adapts size settings of the rendered HTML in special situations
	 */
	CodeViewer.prototype.onAfterRendering = function () {
		var oDomRef = this.getDomRef();
		if ( !this.getEditable() && oDomRef && oDomRef.className.indexOf("prettyprint") !== -1 && window.prettyPrint ) {
			// TODO a call to prettyPrint() will also pretty print other CodeViewer controls -> avoid double pretty printing
			prettyPrint();
			oDomRef.className = 'sapUiCodeViewer sapUiCodeViewerRO ' + (this.aCustomStyleClasses || []).join(' ');
		}
	};

	/**
	 * Function is called when code viewer is clicked.
	 *
	 * @param oBrowserEvent the forwarded sap.ui.core.BrowserEvent
	 * @private
	 */
	CodeViewer.prototype.onclick = function(oBrowserEvent) {
		if (!this.getEditable()) {
			this.firePress({id:this.getId()});
			oBrowserEvent.preventDefault();
			oBrowserEvent.stopPropagation();
		}
	};

	/**
	 * Handles the sapescape event... triggers return to non-editable mode (revert)
	 * @private
	 */
	CodeViewer.prototype.onsapescape = function() {
		if ( this.getEditable() ) {
			// we do not update the source from the PRE tag, so this acts as a 'revert'
			this.setEditable(false);
		}
	};

	CodeViewer.prototype.onkeydown = function(e) {
		if ( this.getEditable() &&
			 ((e.keyCode == jQuery.sap.KeyCodes.S && e.ctrlKey && !e.shiftKey && !e.altKey) ||
			  (e.keyCode == jQuery.sap.KeyCodes.F2)) ) {
			e.preventDefault();
			e.stopPropagation();
			this.fireSave();
		}
	};

	CodeViewer.prototype.getCurrentSource = (function() {

		var SIMPLE_HTML_REGEXP = /<(\/?[^ >]+)[^>]*>|(&[^;]+;)/g,
			TAG_REPLACEMENTS = {
				"/p" : "\n",
				"br" : "\n",
				"div" : "\n"
			},
			ENTITY_REPLACEMENTS = {
				"&nbsp;" : " ",
				"&lt;" : "<",
				"&gt;" : ">",
				"&amp;" : "&"
			};

		return function() {
			var code = '',
				oDomRef = this.getDomRef();

			if ( oDomRef ) {
				// retrieve the edited source via innerHTML as this seems to be the only way to detect line breaks
				code = oDomRef.innerHTML;
				//var code = oDomRef.textContent;
				//if (!code) {
				//	// IE version
				//	code = oDomRef.innerText;
				//}

				// convert some well known tags and entities, remove all others
				code = code.replace(SIMPLE_HTML_REGEXP, function(m,m1,m2) {
					if ( m1 ) {
						m1 = m1.toLowerCase();
						if ( TAG_REPLACEMENTS[m1] ) {
							return TAG_REPLACEMENTS[m1];
						}
					} else if ( m2 ) {
						m2 = m2.toLowerCase();
						if ( ENTITY_REPLACEMENTS[m2] ) {
							return ENTITY_REPLACEMENTS[m2];
						}
					}
					return "";
				});
			}
			return code;
		};
	})();



	CodeViewer.showScript = function(sId) {
		var oDomRef = document.getElementById(sId);
		var sSource = oDomRef.innerHTML;

		if ( !oDomRef || !sSource ) {
			return;
		}

		var oClose = new Button({text:"Close", press: function() { oDialog.close();}});
		var oDialog = new Dialog({
			applyContentPadding : false,
			title : "Source Code for '" + sId + "'",
			resizable: true,
			minWidth:"400px", minHeight:"200px",
			buttons : [oClose],
			content : new CodeViewer({
				source:sSource,
				press: function() { jQuery.sap.log.info('clicked into code viewer');}}),
			defaultButton: oClose});
		oDialog.center();
		oDialog.open();
	};


	return CodeViewer;

});

}; // end of sap/ui/demokit/CodeViewer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.EntityInfo') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides reuse functionality for reading documentation from metamodel entities
jQuery.sap.declare('sap.ui.demokit.EntityInfo'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/EntityInfo",['jquery.sap.global', './util/jsanalyzer/ModuleAnalyzer', './util/APIInfo'],
	function(jQuery, analyzer, APIInfo) {
	"use strict";

	var oRootPackageInfo = {};

	function getPackageInfo(sName) {
		var aParts = sName.split('.');
		var oPackageInfo = oRootPackageInfo;
		var l = aParts.length - 1;
		for (var i = 0; i < l && !oPackageInfo.__noMetamodel && !oPackageInfo.__noSource; i++ ) {
			oPackageInfo = oPackageInfo[aParts[i]] || (oPackageInfo[aParts[i]] = {});
		}
		return oPackageInfo;
	}

	// just a hack, needs proper type resolution
	var CORE_TYPES = "boolean int float number function object string void any Element Control Component";

	function resolve(sType, sContextName) {
		if ( sType.indexOf("/") >= 0 ) {
			return sType.replace(/\//g, ".");
		} else if ( sType && sType.indexOf(".") < 0 && CORE_TYPES.indexOf(sType) >= 0 ) {
			return "sap.ui.core." + sType;
		} else {
			return sContextName.split(".").slice(0, -1).concat([sType.replace(/\//g, ".")]).join(".");
		}
	}

	function parseControlMetamodel(oData, sEntityName) {

		var $control = jQuery(oData.documentElement);
		var oEntityDoc = {
			metatype : 'control',
			baseType : undefined,
			doc : undefined,
			deprecation : undefined,
			properties : {},
			aggregations : {},
			associations : {},
			events : {},
			methods : {}
		};

		var sBaseType = $control.children("baseType").text();
		oEntityDoc.baseType = (sBaseType) ? resolve(sBaseType, sEntityName) : null;

		oEntityDoc.doc = doc($control);
		oEntityDoc.deprecation = depr($control);

		each($control, "properties/property", function($prop) {
			oEntityDoc.properties[$prop.attr("name")] = {
				kind : 0,
				type : resolve($prop.attr("type") || "string", sEntityName),
				defaultValue : $prop.attr("defaultValue") || "empty/undefined",
				doc : doc($prop),
				deprecation : depr($prop),
				since : $prop.attr("since") || null
			};
		});

		oEntityDoc.defaultAggregation = oEntityDoc.defaultAggregation || $control.children("aggregations").attr("default");
		each($control, "aggregations/aggregation", function($aggr) {
			oEntityDoc.aggregations[$aggr.attr("name")] = {
				kind : $aggr.attr("cardinality") === "0..1" ? 1 : 2,
				type : resolve($aggr.attr("type") || "sap.ui.core/Control", sEntityName),
				cardinality : $aggr.attr("cardinality") || "0..n",
				visibility : $aggr.attr("visibility") || null,
				doc : doc($aggr),
				deprecation : depr($aggr),
				since : $aggr.attr("since") || null
			};
		});

		each($control, "associations/association", function($assoc) {
			oEntityDoc.associations[$assoc.attr("name")] = {
				kind : $assoc.attr("cardinality") === "0..n" ? 4 : 3,
				type : resolve($assoc.attr("type") || "sap.ui.core/Control", sEntityName),
				cardinality : $assoc.attr("cardinality") || "0..1",
				doc : doc($assoc),
				deprecation : depr($assoc),
				since : $assoc.attr("since") || null
			};
		});

		each($control, "events/event", function($event) {
			var sName = $event.attr("name");
			oEntityDoc.events[sName] = {
				kind : 5,
				doc : doc($event),
				deprecation : depr($event),
				since : $event.attr("since") || null,
				parameters : []
			};
			each($event, "parameters/parameter", function($param) {
				oEntityDoc.events[sName].parameters[$param.attr("name")] = {
					kind : 6,
					type : resolve($param.attr("type") || "string", sEntityName),
					doc : doc($param),
					since : $param.attr("since") || null,
					deprecation : depr($param)
				};
			});
		});

		each($control, "methods/method", function($method) {
			var sName = $method.attr("name");
			oEntityDoc.methods[sName] = {
				kind : 7,
				type : resolve($method.attr("type") || "sap.ui.core/void", sEntityName),
				doc : doc($method),
				deprecation : depr($method),
				since : $method.attr("since") || null,
				parameters : []
			};
			each($method, "parameters/parameter", function($param) {
				oEntityDoc.methods[sName].parameters.push({
					kind: 8,
					name : $param.attr("name"),
					type : resolve($param.attr("type") || "sap.ui.core/Control", sEntityName),
					doc : doc($param),
					since : $param.attr("since") || null,
					deprecation : depr($param)
				});
			});
		});

		return oEntityDoc;
	}

	function parseTypeMetamodel(oData, sEntityName) {

		var $type = jQuery(oData.documentElement);
		var oEntityDoc = {
			metatype : 'type',
			doc : undefined,
			deprecation : false,
			values : {}
		};

		oEntityDoc.doc = doc($type);
		oEntityDoc.deprecation = depr($type);

		each($type, "enumeration/value", function($value) {
			var sName = $value.attr("name");
			oEntityDoc.values[sName] = {
				value : $value.attr("value") || sName,
				doc : doc($value),
				deprecation : depr($value)
			};
		});

		oEntityDoc.pattern = $type.children("pattern").text();
		oEntityDoc.baseType = resolve($type.children("baseType").text(), sEntityName);

		return oEntityDoc;
	}

	function parseJavascript(oData, sEntityName, sModuleName) {

		// delegate Javascript parsing to ModuleAnalyzer
		return analyzer.analyze(oData, sEntityName, sModuleName);

	}

	function each($,sNames,fnCallback) {
		jQuery.each(sNames.split("/"), function(i,n) {
			$ = $.children(n);
		});
		$.each(function(i,e) {
			fnCallback(jQuery(e));
		});
	}

	function doc($) {
		return $.children("documentation").text();
	}

	function depr($) {
		return $.children("deprecation").text();
	}

	function load(sName, sType, sDataType, fnParser, sEntityName) {

		var oEntityDoc;

		jQuery.ajax({
			async: false,
			url : jQuery.sap.getModulePath(sName, sType),
			dataType : sDataType,
			success : function(vResponse) {
				oEntityDoc = fnParser(vResponse, sEntityName, sName.replace(/\./g,'/'));
			},
			error : function (err) {
				jQuery.sap.log.debug("tried to load entity docu for: " + sName + sType);
			}
		});

		return oEntityDoc;

	}

	function get(sEntityName, sType) {

		var bControl = !sType || sType === "control";
		var bType = !sType || sType === "type";
		var oPackageInfo = getPackageInfo(sEntityName);
		var oEntityDoc;

		// api.json per library
		if ( !oEntityDoc && !oPackageInfo.__noAPIJson ) {
			oEntityDoc = APIInfo.getEntityInfo(sEntityName);
			if ( oEntityDoc ) {
				oPackageInfo.__noSource = true;
				oPackageInfo.__noMetamodel = true;
			}
		} else if ( oPackageInfo.__noAPIJson ) {
			jQuery.sap.log.debug("ancestor package for " + sEntityName + " is marked with 'noMetamodel'");
		}

		// legacy metamodel files
		if ( !oEntityDoc && !oPackageInfo.__noMetamodel ) {
			if ( !oEntityDoc && bControl ) {
				oEntityDoc = load(sEntityName, ".control", "xml", parseControlMetamodel, sEntityName);
			}
			if ( !oEntityDoc && bType ) {
				oEntityDoc = load(sEntityName, ".type", "xml", parseTypeMetamodel, sEntityName);
			}
			if ( oEntityDoc ) {
				oPackageInfo.__noSource = true;
			}
		} else if ( oPackageInfo.__noMetamodel ) {
			jQuery.sap.log.debug("ancestor package for " + sEntityName + " is marked with 'noMetamodel'");
		}

		// source code analysis
		if ( !oEntityDoc && !oPackageInfo.noSource ) {
			if ( !oEntityDoc && bType ) {
				var sLibraryName = sEntityName.replace(/\.[^.]+$/, ".library");
				oEntityDoc = load(sLibraryName, ".js", "text", parseJavascript, sEntityName);
			}
			if ( !oEntityDoc ) {
				oEntityDoc = load(sEntityName, ".js", "text", parseJavascript, sEntityName);
			}
			if ( oEntityDoc ) {
				oPackageInfo.__noMetamodel = true;
			}
		} else if ( oPackageInfo.__noSource ) {
			jQuery.sap.log.debug("ancestor package for " + sEntityName + " is marked with 'noSource'");
		}

		return oEntityDoc;

	}

	var EntityInfo = {

		getEntityDocu : function (sEntityName, sType, bResolveInheritance) {

			function merge(a,b) {
				for (var n in b) {
					if ( b.hasOwnProperty(n) && !a.hasOwnProperty(n) ) { // do not overwrite existing entries
						a[n] = b[n];
					}
				}
			}

			// read info from first document
			var oEntityDoc = get(sEntityName, sType);

			// collect entries from base types
			if ( bResolveInheritance ) {
				var oDoc = oEntityDoc;
				while ( oDoc && oDoc.baseType ) {
					oDoc = get(oDoc.baseType, oDoc.metatype);
					if ( oDoc ) {
						merge(oEntityDoc.properties, oDoc.properties);
						merge(oEntityDoc.aggregations, oDoc.aggregations);
						merge(oEntityDoc.associations, oDoc.assocations);
						merge(oEntityDoc.events, oDoc.events);
						merge(oEntityDoc.methods, oDoc.methods);
					}
				}
			}

			return oEntityDoc;

		}

	};

	return EntityInfo;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/EntityInfo.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.FileUploadIntrospector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.FileUploadIntrospector.
jQuery.sap.declare('sap.ui.demokit.FileUploadIntrospector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/FileUploadIntrospector",['jquery.sap.global', 'sap/ui/core/Control', './library'],
	function(jQuery, Control, library) {
	"use strict";



	/**
	 * Constructor for a new FileUploadIntrospector.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Control that allows to monitor uploaded files in a demo scenario. This is not a general purpose monitor but only works with the demo fileupload service.
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.FileUploadIntrospector
	 */
	var FileUploadIntrospector = Control.extend("sap.ui.demokit.FileUploadIntrospector", /** @lends sap.ui.demokit.FileUploadIntrospector.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * The URL to check the upload content with....
			 */
			uploadUrl : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Interval in milliseconds after which the content is checked again. values lower or equal to 0 mean 'no automatic refresh'.
			 */
			autoRefreshInterval : {type : "string", group : "Misc", defaultValue : '0'},

			/**
			 * (CSS) Height of the control
			 */
			height : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null},

			/**
			 * Width of the file list
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : null}
		}
	}});


	FileUploadIntrospector.prototype.init = function() {
		this._aFiles = [];
		this._iHash = 0;

		jQuery.sap.act.attachActivate(this._activate, this);
	};

	FileUploadIntrospector.prototype.exit = function() {
		jQuery.sap.act.detachActivate(this._activate, this);
	};

	FileUploadIntrospector.prototype._activate = function() {
		// trigger the auto refresh once the user interacts again with the UI
		// by reusing the setter functionality of the autoRefreshInterval property
		this.setAutoRefreshInterval(this.getAutoRefreshInterval());
	};

	FileUploadIntrospector.prototype.setAutoRefreshInterval = function(iInterval) {
		this.setProperty("autoRefreshInterval", iInterval);
		if ( this.oTimer ) {
			jQuery.sap.clearDelayedCall(this.oTimer);
			this.oTimer = undefined;
		}
		if ( iInterval > 0 ) {
			this.oTimer = jQuery.sap.delayedCall(iInterval, this, "_autoRefresh");
		}
	};

	/**
	 * Trigger an explicit refresh of the displayed information
	 *
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	FileUploadIntrospector.prototype.refresh = function() {
		var that = this;
		jQuery.getJSON(this.getUploadUrl(), function(data) { that._receiveFileList(data); });
	};

	FileUploadIntrospector.prototype._autoRefresh = function() {
		if ( this.oTimer ) {
			jQuery.sap.clearDelayedCall(this.oTimer);
			this.oTimer = undefined;
		}
		this.refresh();
		// TODO reinitialize timer only after response has been received (requires separate receive methods)
		var iInterval = this.getAutoRefreshInterval();
		// only set timer again if activity is detected
		if ( iInterval > 0  && jQuery.sap.act.isActive() ) {
			this.oTimer = jQuery.sap.delayedCall(iInterval, this, "_autoRefresh");
		}
	};

	FileUploadIntrospector.prototype._receiveFileList = function(oResult) {
		if ( !this._aFiles || this._iHash !== oResult.hash ) {
			this._aFiles = oResult.files;
			this._iHash = oResult.hash;
			this.invalidate();
		}
	};

	return FileUploadIntrospector;

});

}; // end of sap/ui/demokit/FileUploadIntrospector.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.HexagonButton') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.HexagonButton.
jQuery.sap.declare('sap.ui.demokit.HexagonButton'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/HexagonButton",['sap/ui/core/Control', './library'],
	function(Control, library) {
	"use strict";


	/**
	 * Constructor for a new HexagonButton.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A custom button with a 'hexagon' shape
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.HexagonButton
	 */
	var HexagonButton = Control.extend("sap.ui.demokit.HexagonButton", /** @lends sap.ui.demokit.HexagonButton.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * Icon to display
			 */
			icon : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The color of the hexagon
			 */
			color : {type : "string", group : "Misc", defaultValue : 'blue'},

			/**
			 * The position. If set, the button is rendered with an absolute position.
			 */
			position : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Whether the button is enabled or not.
			 */
			enabled : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * The position of the contained image. If not set the image is rendered with a fixed relative position.
			 */
			imagePosition : {type : "string", group : "Misc", defaultValue : null}
		},
		events : {

			/**
			 * Fired when the user clicks the hex button
			 */
			press : {}
		}
	}});

	/**
	 * Function is called when hexagon is clicked.
	 *
	 * @param oBrowserEvent the forwarded sap.ui.core.BrowserEvent
	 * @private
	 */
	HexagonButton.prototype.onclick = function(oBrowserEvent) {
		// TODO check for the hexagon
		if ( this.getEnabled() ) {
			this.firePress({id:this.getId()});
		}
		oBrowserEvent.preventDefault();
		oBrowserEvent.stopPropagation();
	};

	// intercept attach/detachPress to be able to rerender (renderer behaves differently for purely "decorative" buttons)
	HexagonButton.prototype._attachPress = HexagonButton.prototype.attachPress;
	HexagonButton.prototype.attachPress = function() {
		this._attachPress.apply(this, arguments);
		this.invalidate();
	};

	HexagonButton.prototype._detachPress = HexagonButton.prototype.detachPress;
	HexagonButton.prototype.detachPress = function() {
		this._detachPress.apply(this, arguments);
		this.invalidate();
	};

	return HexagonButton;

});

}; // end of sap/ui/demokit/HexagonButton.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.HexagonButtonGroup') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.HexagonButtonGroup.
jQuery.sap.declare('sap.ui.demokit.HexagonButtonGroup'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/HexagonButtonGroup",['sap/ui/core/Control', './library'],
	function(Control, library) {
	"use strict";

	/**
	 * Constructor for a new HexagonButtonGroup.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A group of HexagonButtons, aligned in a packed grid
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.HexagonButtonGroup
	 */
	var HexagonButtonGroup = Control.extend("sap.ui.demokit.HexagonButtonGroup", /** @lends sap.ui.demokit.HexagonButtonGroup.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * How many buttons might be placed in the same row of the grid
			 */
			colspan : {type : "int", group : "Misc", defaultValue : 3}
		},
		aggregations : {

			/**
			 * The buttons to layout in a grid
			 */
			buttons : {type : "sap.ui.demokit.HexagonButton", multiple : true, singularName : "button"}
		}
	}});

	return HexagonButtonGroup;

});

}; // end of sap/ui/demokit/HexagonButtonGroup.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.IndexLayout') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.IndexLayout.
jQuery.sap.declare('sap.ui.demokit.IndexLayout'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/IndexLayout",['jquery.sap.global', 'sap/ui/Device', 'sap/ui/core/Control', 'sap/ui/core/IntervalTrigger', './library'],
	function(jQuery, Device, Control, IntervalTrigger, library) {
	"use strict";



	/**
	 * Constructor for a new IndexLayout.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Layout which renders content items with equal width and height. The items are arranged in rows.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @since 1.17.0
	 * @experimental Since version 1.17.0.
	 * API is not yet finished and might change completely
	 * @alias sap.ui.demokit.IndexLayout
	 */
	var IndexLayout = Control.extend("sap.ui.demokit.IndexLayout", /** @lends sap.ui.demokit.IndexLayout.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * The width of a content item. Only px values are allowed.
			 */
			itemWidth : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '200px'},

			/**
			 * The height of a content item. Only px values are allowed.
			 */
			itemHeight : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : '200px'},

			/**
			 * Whether the given item width/height should be scaled according to the screen size.
			 */
			enableScaling : {type : "boolean", group : "Appearance", defaultValue : true}
		},
		defaultAggregation : "content",
		aggregations : {

			/**
			 * The content items
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
		}
	}});


	IndexLayout._MINMARGIN = 18;
	IndexLayout._DEFAULT_ITEM_HEIGHT = 200;
	IndexLayout._DEFAULT_ITEM_WIDTH = 200;
	IndexLayout._pos = null;

	(function(){

	IndexLayout._IntervalTrigger = new IntervalTrigger(300);

	IndexLayout.prototype.init = function(){
		this._itemWidth = IndexLayout._DEFAULT_ITEM_WIDTH;
		this._itemHeight = IndexLayout._DEFAULT_ITEM_HEIGHT;
		this._tilesPerRow;
		this._width;
		this._registered = false;
		this._itemScaleFactor = 1;
		Device.media.attachHandler(setScaleFactor, this, Device.media.RANGESETS.SAP_STANDARD);
	};


	IndexLayout.prototype.exit = function(){
		this.onBeforeRendering();
		Device.media.detachHandler(setScaleFactor, this, Device.media.RANGESETS.SAP_STANDARD);
	};


	IndexLayout.prototype.setItemWidth = function(sItemWidth){
		this.setProperty("itemWidth", sItemWidth, true);
		if (!sItemWidth || sItemWidth.indexOf("px") < 0) {
			this._itemWidth = IndexLayout._DEFAULT_ITEM_WIDTH;
			this.setProperty("itemWidth", this._itemWidth, true);
		} else {
			this._itemWidth = parseInt(sItemWidth, 10);
		}
		_refresh(this);
		return this;
	};


	IndexLayout.prototype.setItemHeight = function(sItemHeight){
		this.setProperty("itemHeight", sItemHeight, true);
		if (!sItemHeight || sItemHeight.indexOf("px") < 0) {
			this._itemHeight = IndexLayout._DEFAULT_ITEM_HEIGHT;
			this.setProperty("itemHeight", this._itemHeight, true);
		} else {
			this._itemHeight = parseInt(sItemHeight, 10);
		}
		_refresh(this);
		return this;
	};


	IndexLayout.prototype.setEnableScaling = function(bEnableScaling){
		this.setProperty("enableScaling", bEnableScaling, true);
		_refresh(this);
		return this;
	};


	IndexLayout.prototype.onBeforeRendering = function(){
		if (this._registered) {
			IndexLayout._IntervalTrigger.removeListener(refresh, this);
			this._registered = false;
		}

		var mMediaParams = Device.media.getCurrentRange(Device.media.RANGESETS.SAP_STANDARD);
		setScaleFactor.apply(this, [mMediaParams, true]);
	};

	IndexLayout.prototype.onThemeChanged = function(){
		if (this.getDomRef()) {
			this.invalidate();
		}
	};

	IndexLayout.prototype.onAfterRendering = function(){
		if (!IndexLayout._pos) {
			var transform = null;
			var oStyle = this.getDomRef().style;
			if ("webkitTransform" in oStyle) {
				  transform = "-webkit-transform";
			} else if ("transform" in oStyle) {
				  transform = "transform";
			} else if ("msTransform" in oStyle) {
				  transform = "-ms-transform";
			} else if ("MozTransform" in oStyle) {
				  transform = "-moz-transform";
			}
			if (transform) {
				IndexLayout._pos = function($ref, x, y){
					$ref.css(transform, "translate(" + x + "px," + y + "px)");
				};
			} else {
				IndexLayout._pos = function($ref, x, y){
					$ref.css({top: y + "px", left: x + "px"});
				};
			}
		}

		if (!this._registered) {
			IndexLayout._IntervalTrigger.addListener(refresh, this);
			this._registered = true;
		}
		this.$().toggleClass("sapDkIdxLayoutHidden", false);
	};


	IndexLayout.prototype._scale = function(iVal){
		if (!this.getEnableScaling()) {
			return iVal;
		}
		return Math.floor(iVal * this._itemScaleFactor);
	};


	function _refresh(oLyt, bNoForce){
		refresh.apply(oLyt, [!bNoForce]);
	}


	function refresh(bInitial){
		if (!this.getDomRef()) {
			this.onBeforeRendering();
			return;
		}

		bInitial = bInitial || !this._registered;

		var $Layout = this.$(),
			w = $Layout.outerWidth(),
			h = $Layout.outerHeight(),
			heightChanged = this._height != h;

		if (this._width === w && !heightChanged && !bInitial) {
			return;
		}

		this._width = w;
		this._height = h;

		var itemCount = this.getContent().length,
			itemWidth = this._scale(this._itemWidth),
			itemHeight = this._scale(this._itemHeight),
			t = getOptimalTilesPerRow(this._width, itemCount, itemWidth),
			//leftpad = Math.max(sap.ui.demokit.IndexLayout._MINMARGIN, Math.floor((this._width - t*itemWidth)/2)),
			tilesPerRowChanged = this._tilesPerRow != t;

		this._tilesPerRow = t;

		if (!bInitial) {
			$Layout.toggleClass("sapDkIdxLayoutAnim", true);
		}

		//$Layout.css("padding-left", leftpad+"px");

		if (!tilesPerRowChanged && !bInitial && !heightChanged) {
			return;
		}

		var top = 0,
			left = 0;

		this.$("cntnt").css({
			"padding-left": IndexLayout._MINMARGIN + "px",
			"width": (t * itemWidth + IndexLayout._MINMARGIN * 2) + "px",
			"height": Math.ceil(itemCount / t) * itemHeight
		}).children().each(function(index){
			if (index > 0 && index % t === 0) {
				top = top + itemHeight;
				left = 0;
			}
			IndexLayout._pos(jQuery(this), left, top);
			left = left + itemWidth;
		});

		if (bInitial) {
			$Layout.css({
				"padding-top": IndexLayout._MINMARGIN + "px",
				"padding-bottom": IndexLayout._MINMARGIN + "px"
			});
		}
	}


	function getOptimalTilesPerRow(width, itemCount, itemWidth){
		var t = Math.min(Math.floor((width - 2 * IndexLayout._MINMARGIN) / itemWidth), itemCount);
		var mod = itemCount % t;
		if (mod == 0 || itemCount <= t) {
			return t;
		}

		function weight(x){
			var n = itemCount % x;
			return (t - x) * Math.floor(itemCount / x) + (n != 0 ? (t - n) : 0);
		}

		var best = weight(t);
		var candidates = [t];
		var i;

		for (i = t - 1; i >= 1; i--) {
			var w = weight(i);
			if (w < best) {
				candidates = [i];
				best = w;
			} else if (w == best) {
				candidates.push(i);
			}
		}

		for (i = 0; i < candidates.length; i++) {
			var m = itemCount % candidates[i];
			if (m == 0) {
				return candidates[i];
			} else if (i == 0 || m > best) {
				best = m;
				t = candidates[i];
			}
		}

		return t;
	}

	function setScaleFactor(mMediaParams, bSkipUpdate){
		switch (mMediaParams.name) {
			case "Tablet":
				this._itemScaleFactor = 0.75;
				break;
			case "Phone":
				this._itemScaleFactor = 0.5;
				break;
			default:
				this._itemScaleFactor = 1;
		}

		if (!this.getDomRef() || bSkipUpdate) {
			return;
		}

		var width = this._scale(this._itemWidth);
		var height = this._scale(this._itemHeight);

		this.$("cntnt").children().each(function(){
			jQuery(this).css({width: width, height: height});
		});

		_refresh(this);
	}


	//**********************************************

	Control.extend("sap.ui.demokit.IndexLayout._Tile", {

		metadata : {
			properties : {
				"title" : "string",
				"description" : "string",
				"target" : "string",
				"icon": "sap.ui.core.URI",
				"href": "sap.ui.core.URI"
			},
			events : {
				"press": {}
			}
		},

		onclick : function(oEvent) {
			if (!this.getHref()) {
				this.firePress();

				oEvent.preventDefault();
			}
		},

		renderer: function(oRm, oControl) {
			oRm.write("<a");
			oRm.addClass("sapDkIdxLayout_Tile");
			oRm.writeClasses();
			oRm.writeControlData(oControl);
			if (oControl.getHref()) {
				oRm.writeAttributeEscaped("href", oControl.getHref());
				if (oControl.getTarget()) {
					oRm.writeAttributeEscaped("target", oControl.getTarget());
				}
			}	else {
				oRm.writeAttribute("href", "#");
			}
			oRm.writeAttributeEscaped("title", oControl.getDescription());
			oRm.write(">");

			oRm.write("<span class='sapDkIdxLayout_TileIcon'>");
			oRm.writeIcon(oControl.getIcon());
			oRm.write("</span>");

			oRm.write("<span class='sapDkIdxLayout_TileLabel'");
			oRm.writeAttributeEscaped("title", oControl.getTitle());
			oRm.write(">");
			oRm.writeEscaped(oControl.getTitle());
			oRm.write("</span>");

			oRm.write("<span class='sapDkIdxLayout_TileDesc'");
			oRm.writeAttributeEscaped("title", oControl.getDescription());
			oRm.write(">");
			oRm.writeEscaped(oControl.getDescription());
			oRm.write("</span>");

			oRm.write("</a>");
		}
	});

	})();


	return IndexLayout;

});

}; // end of sap/ui/demokit/IndexLayout.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.IndexLayoutPage') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
// Creates Index Page within the Demokit
jQuery.sap.declare('sap.ui.demokit.IndexLayoutPage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.encoder'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/IndexLayoutPage",['jquery.sap.global', 'sap/ui/core/IconPool', './IndexLayout', 'sap/ui/model/json/JSONModel', 'sap/ui/core/Control', 'sap/ui/core/Element', 'jquery.sap.encoder'],
	function(jQuery, IconPool, IndexLayout, JSONModel, Control, Element/* , jQuerySap */) {
	"use strict";


	var IndexLayoutPage = function IndexPage(oData, sTarget, sBaseUrl, bCustomFont) {

		var oModel = new JSONModel(oData);
		sap.ui.getCore().setModel(oModel);

		var oCatIndex = new IndexLayoutPage.Repeat({
			categories: {
				path: "/categories",
				template: new IndexLayoutPage.Cat({
					title: "{text}",
					layout: new IndexLayout({
						enableScaling: true,
						content: {
							path: "links",
							template: new IndexLayout._Tile({
								title: "{text}",
								description: "{desc}",
								target: sTarget,
								icon: {
									path: "icon",
									formatter: function(ico){
										if (!ico) {
											ico = "learning-assistant";
										}
										return "sap-icon://" + ico;
									}
								},
								href: "{ref}"
							})
						}
					})
				})
			}
		});

		if (bCustomFont) {
			IconPool.addIcon("explored", "custom", "brandico", "e001", true);
			IconPool.addIcon("cart", "custom", "brandico", "e002", true); //Obsolete?
			IconPool.addIcon("makit", "custom", "brandico", "e005", true); //Obsolete?
			IconPool.addIcon("helloworld", "custom", "brandico", "e003", true); //Obsolete?
			IconPool.addIcon("poa", "custom", "brandico", "e007", true); //Obsolete?
			IconPool.addIcon("flexbox", "custom", "brandico", "e00A", true); //Obsolete?
			IconPool.addIcon("crud", "custom", "brandico", "e009", true); //Obsolete?
			IconPool.addIcon("icon-explorer", "custom", "brandico", "e006", true); //Obsolete?
			IconPool.addIcon("splitapp", "custom", "brandico", "e00C", true);
			IconPool.addIcon("mvc", "custom", "brandico", "e00B", true); //Obsolete?
		}

		sap.ui.getCore().attachInit(function(){
			if (bCustomFont) {
				var sFontBaseUrl = jQuery.sap.getModulePath("", "/../test-resources/sap/m/demokit/demokit-home/");
				IndexLayoutPage._introduceCustomFont("brandico", sFontBaseUrl, "demoAppsIconFont");
			}

			jQuery("body").append("<div id='root'></div>");
			oCatIndex.placeAt("root");
		});
	};


	Element.extend("sap.ui.demokit.IndexLayoutPage.Cat", {
		metadata : {
			properties : {
				"title" : "string"
			},
			aggregations : {
				"layout": {type : "sap.ui.demokit.IndexLayout", multiple : false}
			}
		}
	});


	Control.extend("sap.ui.demokit.IndexLayoutPage.Repeat", {
		metadata : {
			aggregations : {
				"categories" : {type : "sap.ui.demokit.IndexLayoutPage.Cat", multiple : true}
			}
		},

		renderer: function(oRm, oControl) {
			oRm.write("<div");
			oRm.writeControlData(oControl);
			oRm.write(">");

			var aCats = oControl.getCategories();
			for (var i = 0; i < aCats.length; i++) {
				oRm.write("<div");
				oRm.writeElementData(aCats[i]);
				oRm.write(">");
				if (aCats[i].getTitle()) {
					oRm.write("<h2>");
					oRm.writeEscaped(aCats[i].getTitle());
					oRm.write("</h2>");
				}
				oRm.renderControl(aCats[i].getLayout());
				oRm.write("</div>");
			}

			oRm.write("</div>");
		}
	});


	IndexLayoutPage._introduceCustomFont = function(sFamilyName, sFontPath, sFontFile){
		var sFontFace = "@font-face {" +
			"font-family: '" + sFamilyName + "';" +
			"src: url('" + sFontPath + sFontFile + ".eot');" +
			"src: url('" + sFontPath + sFontFile + ".eot?#iefix') format('embedded-opentype'), url('" + sFontPath + sFontFile + ".ttf') format('truetype');" +
			"font-weight: normal;" +
			"font-style: normal;" +
			"}";
		jQuery('head').append('<style type="text/css">' + sFontFace + '</style>');
	};

	return IndexLayoutPage;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/IndexLayoutPage.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.Tag') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.Tag.
jQuery.sap.declare('sap.ui.demokit.Tag'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/Tag",['sap/ui/core/Element', './library'],
	function(Element, library) {
	"use strict";



	/**
	 * Constructor for a new Tag.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A Tag in a TagCloud
	 * @extends sap.ui.core.Element
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.Tag
	 */
	var Tag = Element.extend("sap.ui.demokit.Tag", /** @lends sap.ui.demokit.Tag.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * The text to be disaplyed for this tag.
			 */
			text : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The weight for this tag. Can be any integer value.
			 */
			weight : {type : "int", group : "Misc", defaultValue : 1}
		}
	}});

	Tag.prototype.onclick = function(oEvent){
		//Inform the parent about the onclick event
		this.oParent.firePressEvent(this);
	};


	return Tag;

});

}; // end of sap/ui/demokit/Tag.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.TagCloud') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.TagCloud.
jQuery.sap.declare('sap.ui.demokit.TagCloud'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/TagCloud",['sap/ui/core/Control', './library'],
	function(Control, library) {
	"use strict";



	/**
	 * Constructor for a new TagCloud.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A simple TagCloud representing a set of weighted tags
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.TagCloud
	 */
	var TagCloud = Control.extend("sap.ui.demokit.TagCloud", /** @lends sap.ui.demokit.TagCloud.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * Maximum font size that may be chosen for a tag in this cloud
			 */
			maxFontSize : {type : "int", group : "Misc", defaultValue : 30},

			/**
			 * Minimum font size that must be used for a tag in this cloud
			 */
			minFontSize : {type : "int", group : "Misc", defaultValue : 10}
		},
		defaultAggregation : "tags",
		aggregations : {

			/**
			 * The tags displayed in this tag cloud
			 */
			tags : {type : "sap.ui.demokit.Tag", multiple : true, singularName : "tag"}
		},
		events : {

			/**
			 * Fired when a Tag is clicked.
			 */
			press : {
				parameters : {

					/**
					 * Id of the selected Tag.
					 */
					tagId : {type : "string"}
				}
			}
		}
	}});

	//Called by a tag when an onclick event is triggered there.
	//The event is forwarded to the application coding.
	TagCloud.prototype.firePressEvent = function(tag){
	  this.firePress({tagId:tag.getId()});
	};


	return TagCloud;

});

}; // end of sap/ui/demokit/TagCloud.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.UI5EntityCueCard') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.UI5EntityCueCard.
jQuery.sap.declare('sap.ui.demokit.UI5EntityCueCard'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Link'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/UI5EntityCueCard",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/commons/Link', './EntityInfo', './library'],
	function(jQuery, Control, Link, EntityInfo, library) {
	"use strict";



	/**
	 * Constructor for a new UI5EntityCueCard.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Displays documentation for a UI5 entity (control or type).
	 *
	 * The documentation will be read from a UI5 metamodel file that by default is loaded from the same resource location
	 * where the control or type would be loaded from (using the UI5 resource loading). This control displays all properties,
	 * aggregations, associations, events and methods that are described in the metamodel. For each part, it lists the name,
	 * type (where applicable) and documentation. If the navigable property is set to true, all types are shown as links
	 * and when pressed, the navigate event is fired. This allows consumers to react on a user click on such a type
	 * (and to e.g. navigate to the underlying type of a property or aggregation)
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.UI5EntityCueCard
	 */
	var UI5EntityCueCard = Control.extend("sap.ui.demokit.UI5EntityCueCard", /** @lends sap.ui.demokit.UI5EntityCueCard.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * Whether the cue card can be collapsed at all. When set to true, the value of property expanded determines the current collapsed/expanded state. When false, the control is always expanded.
			 */
			collapsible : {type : "boolean", group : "Misc", defaultValue : true},

			/**
			 * Whether the cue card is currently expanded.
			 */
			expanded : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Whether type information is navigable. Also see event 'navigate'.
			 */
			navigable : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Qualified name of the control or type to show the documentation for. The name can be specified in the metamodel notation ('sap.ui.core/Control' or in the UI5 resource notation (sap.ui.core.Control).
			 */
			entityName : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Style of the cue card.
			 */
			style : {type : "sap.ui.demokit.UI5EntityCueCardStyle", group : "Misc", defaultValue : null}
		},
		events : {

			/**
			 * Fired when a link for a type is activated (clicked) by the user.
			 *
			 * When property "navigable" is set to true, type links are created for the types of properties, aggregations and associations, for the types of event or method parameters and for the return types of methods (if not void).
			 *
			 * The default behavior for this event is to set the entityName property to the clicked entityName. Applications can prevent the default by calling the corresponding method on the event object.
			 */
			navigate : {allowPreventDefault : true,
				parameters : {

					/**
					 * Name of the entity (control or type) that has been clicked.
					 */
					entityName : {type : "string"}
				}
			}
		}
	}});


	UI5EntityCueCard.prototype.init = function() {
		this._oShowCueCardLink = new Link({	text : "Show All Settings", press : [this._toggleExpanded, this]});
		this._oShowCueCardLink.setParent(this); //TODO provide sAggregationName?
		this._aHistory = [];
		/**
		 * Active position in the history. Moved by back/forward and setEntityName
		 */
		this._iHistory = -1;
	};

	UI5EntityCueCard.prototype.setEntityName = function(sEntityName) {
		if ( sEntityName !== this.getEntityName() ) {
			this.setProperty("entityName", sEntityName);
			this._aHistory[++this._iHistory] = sEntityName;
			this._aHistory.length = this._iHistory + 1; // cut off any dangling entries
		}
	};

	UI5EntityCueCard.prototype.back = function() {
		if ( this._iHistory > 0 ) {
			this.setProperty("entityName", this._aHistory[--this._iHistory]);
		}
	};

	UI5EntityCueCard.prototype.forward = function() {
		if ( this._iHistory + 1 < this._aHistory.length ) {
			this.setProperty("entityName", this._aHistory[++this._iHistory]);
		}
	};

	UI5EntityCueCard.prototype.setExpanded = function(bExpanded) {
		this.setProperty("expanded", bExpanded);
		this._oShowCueCardLink && this._oShowCueCardLink.setText(this.getExpanded() ? "Hide Settings" : "Show All Settings");
	};

	UI5EntityCueCard.prototype.onclick = function(oEvent) {
		/*if ( oEvent.target && oEvent.target.nodeName == "A" ) {
			oEvent.preventDefault();
		}*/
		if ( this.getNavigable() ) {
			var sEntity = jQuery(oEvent.target).attr("data-sap-ui-entity");
			if ( sEntity && this.fireNavigate({entityName : sEntity}) ) {
				this.setEntityName(sEntity);
			}
		}
	};

	UI5EntityCueCard.prototype._toggleExpanded = function() {
		this.setExpanded(!this.getExpanded());
	};

	UI5EntityCueCard.prototype._getDoc = function() {
		var sName = this.getEntityName();
		return EntityInfo.getEntityDocu(sName);
	};

	UI5EntityCueCard.createDialog = function() {

		return new Promise(function(resolve, reject) {

			sap.ui.require(['sap/ui/commons/Button', 'sap/ui/commons/Dialog', 'sap/ui/commons/Toolbar'], function(Button, Dialog, Toolbar) {

				var oCueCard = new UI5EntityCueCard({
					collapsible : false,
					expanded : true,
					navigable: true
				});

				var oDialog = new Dialog({
					title : "Cue Card",
					minWidth : "200px",
					minHeight : "200px",
					maxWidth : "75%",
					maxHeight : "75%",
					content : [
						new Toolbar({
							standalone : false,
							items : [
								new Button({
									text : "Back",
									press : function() {
										oCueCard.back();
									}
								}),
								new Button({
									text : "Fwd",
									press : function() {
										oCueCard.forward();
									}
								})
							]
						}),
						oCueCard
					]
				});

				oDialog.openForClass = function(sClassName) {
					oCueCard.setEntityName(sClassName);
					this.rerender();
					this.open();
				};

				resolve(oDialog);
			});

		});

	};

	UI5EntityCueCard.attachToContextMenu = function(oNode) {
		var oDialog;

		function dialogCreated() {
			return oDialog ? Promise.resolve(oDialog) : UI5EntityCueCard.createDialog().then(function(oResult) {
				oDialog = oResult;
				return oResult;
			});
		}

		jQuery(oNode || window.document).bind("contextmenu.sapDkCueCd", function(e) {
			if ( e.shiftKey && e.ctrlKey )  {
				var oCtrl = jQuery(e.target).control(0);
				// if there is a control and if the control is not part of the cue card dialog
				if ( oCtrl && (!oDialog || !oDialog.getDomRef() || (oDialog.getDomRef() !== e.target && !jQuery.contains(oDialog.getDomRef(), e.target)) ) ) {
					dialogCreated().then(function(oDialog) {
						oDialog.openForClass(oCtrl.getMetadata().getName());
						e.preventDefault();
						e.stopPropagation();
					});
				}
			}
		});
	};

	UI5EntityCueCard.detachFromContextMenu = function(oNode) {
		jQuery(oNode || window.document).unbind("contextmenu.sapDkCueCd");
	};


	/*
	 * TODOs
	 *
	 * - defaultValues
	 * - method & event parameters
	 * - styling
	 * - integrate into snippix itself
	 * - initial size
	 */

	return UI5EntityCueCard;

});

}; // end of sap/ui/demokit/UI5EntityCueCard.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.UI5EntityCueCardRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.demokit.UI5EntityCueCard
jQuery.sap.declare('sap.ui.demokit.UI5EntityCueCardRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/UI5EntityCueCardRenderer",['jquery.sap.global', './library'],
	function(jQuery, library) {
	"use strict";


	/**
	 * UI5EntityCueCard renderer.
	 * @namespace
	 * @alias sap.ui.demokit.UI5EntityCueCardRenderer
	 */
	var UI5EntityCueCardRenderer = {
	};


	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oControl an object representation of the control that should be rendered
	 */
	UI5EntityCueCardRenderer.render = function(rm, oControl){

		var bNavigable = oControl.getNavigable();
		var bDemokit = oControl.getStyle() == library.UI5EntityCueCardStyle.Demokit;

		function isPrimitive(sType) {
			while ( sType.slice(-2) == "[]" ) {
				sType = sType.slice(0, -2);
			}
			if ( sType.indexOf("sap.ui.core.") == 0 ) {
				sType = sType.slice("sap.ui.core.".length);
			}
			return /^(any|boolean|float|int|object|string|void)$/.test(sType);
		}

		rm.write("<div");
		rm.writeControlData(oControl);
		rm.writeAttribute("class","sapDkCueCd");
		rm.write(">");

		var child = 0;

		function names(o) {
			var r = [];
			for (var s in o) {
				r.push(s);
			}
			r.sort(function(a,b) {
				var a_depr = o[a].deprecation ? 1 : 0;
				var b_depr = o[b].deprecation ? 1 : 0;
				var c = a_depr - b_depr;
				if ( c === 0 && a !== b ) {
					c = a < b ? -1 : 1;
				} // if c === 0 && a === b, c remains 0
				return c;
			});
			return r;
		}

		function alternate(i) {
			return " class='" + ((i % 2) ? "sapDkCueCdOdd" : "sapDkCueCdEven") + "'";
		}

		function kind(k) {
			if ( k === 0 ) {
				return "Property of type ";
			} else if ( k === 1 || k === 2 ) {
				return "Aggregation of type ";
			} else if ( k === 3 || k === 4 ) {
				return "Association of type ";
			} else if ( k === 6 ) {
				return "Event parameter of type ";
			} else if ( k === 7 ) {
				return "Return value of type ";
			} else if ( k === 6 ) {
				return "Method parameter of type ";
			} else {
				return "";
			}
		}

		function crossref(p, t, card) {
			if ( t ) {
				if ( card === "0..n" ) {
					return crossref(p, t) + "[]";
				}
				var bPrimitive = isPrimitive(t);
				var sShort = jQuery.sap.encodeHTML(t.split(".").slice(-1)[0]);
				var tfull = jQuery.sap.encodeHTML(kind(p.kind) + t);
				if ( bNavigable && (!bDemokit || !bPrimitive ) ) {
					return "<a class='sapDkLnk' id='" + oControl.getId() + "-l-" + (child++) + "' data-sap-ui-entity='" + t + "' title='" + tfull + "'>" + sShort + "</a>";
				} else {
					return "<span title='" + t + "'>" + sShort + "</span>";
				}
			}
			return '';
		}

		function deprClass(o) {
			return o.deprecation ? " sapDkCueCdDeprct" : "";
		}

		function deprDoc(o) {
			return o.deprecation ? "<br><i><b>Deprecated</b>: " + o.deprecation + "</i>" : "";
		}

		function defaultAggrClass(bIsDefault) {
			return bIsDefault ? " sapDkCueCdDfltAggr" : "";
		}

		function defaultAggrDoc(bIsDefault) {
			return bIsDefault ? "<br><b>Note</b>: This is the default aggregation." : "";
		}

		if ( !oControl.getCollapsible() || oControl.getExpanded() ) {

			var oDoc = oControl._getDoc();

			if ( oDoc ) {

				var n, i, j, oParam;

				rm.write("<table>");
				if ( !bDemokit ) {
					rm.write("<tr><td colspan='3' class='sapDkCueCdHd0", deprClass(oDoc), "'>", oControl.getEntityName(), "</td></tr>");
					rm.write("<tr><td colspan='3' class='sapDkCueCdDoc'>", oDoc.doc || '', deprDoc(oDoc), "</td></tr>");
				}
				if ( oDoc.metatype === 'control' ) {

					var settings = jQuery.extend({}, oDoc.properties, oDoc.aggregations, oDoc.associations);
					n = names(settings);
					if ( n.length > 0 ) {
						rm.write("<tr><td colspan='3' class='sapDkCueCdHd'>", "Properties, Aggregations, Associations", "</td></tr>");
						for (i = 0; i < n.length; i++) {
							var oProp = settings[n[i]];
							rm.write("<tr", alternate(i), "><td class='sapDkCueCdName", deprClass(oProp), defaultAggrClass(n[i] === oDoc.defaultAggregation), "'>", n[i], "</td>", "<td class='sapDkCueCdType'>", crossref(oProp, oProp.type, oProp.cardinality), "</td>", "<td class='sapDkCueCdDoc'>", oProp.doc, deprDoc(oProp), defaultAggrDoc(n[i] === oDoc.defaultAggregation), "</td></tr>");
						}
					}

					n = names(oDoc.events);
					if ( n.length > 0 ) {
						rm.write("<tr><td colspan='3' class='sapDkCueCdHd'>", "Events", "</td></tr>");
						for (i = 0; i < n.length; i++) {
							var oEvent = oDoc.events[n[i]];
							rm.write("<tr", alternate(i), "><td class='sapDkCueCdName", deprClass(oEvent), "'>", n[i], "</td>", "<td class='sapDkCueCdType'>", "&nbsp", "</td>", "<td class='sapDkCueCdDoc'>", oEvent.doc, deprDoc(oEvent), "</td></tr>");
							var pnames = names(oEvent.parameters);
							for (j = 0; j < pnames.length; j++) {
								var pn = pnames[j];
								oParam = oEvent.parameters[pn];
								rm.write("<tr", alternate(i), "><td class='sapDkCueCdSubName", deprClass(oParam), "'>", pn, "</td>", "<td class='sapDkCueCdType'>", crossref(oParam, oParam.type), "</td>", "<td class='sapDkCueCdDoc'>", oParam.doc, deprDoc(oParam), "</td></tr>");
							}
						}
					}

					n = names(oDoc.methods);
					if ( n.length > 0 ) {
						rm.write("<tr><td colspan='3' class='sapDkCueCdHd'>", "Methods", "</td></tr>");
						for (i = 0; i < n.length; i++) {
							var oMethod = oDoc.methods[n[i]];
							if ( oMethod.synthetic ) {
								continue;
							}
							var signature = n[i] + "(";
							for (j = 0; j < oMethod.parameters.length; j++) {
								if ( j > 0 ) {
									signature += ",";
								}
								signature += oMethod.parameters[j].name;
							}
							signature += ")";
							rm.write("<tr", alternate(i), "><td class='sapDkCueCdName", deprClass(oMethod), "' colspan='2'>", signature, "</td>", "<td class='sapDkCueCdDoc'>", oMethod.doc, deprDoc(oMethod), "</td></tr>");
							for (j = 0; j < oMethod.parameters.length; j++) {
								oParam = oMethod.parameters[j];
								rm.write("<tr", alternate(i), "><td class='sapDkCueCdSubName", deprClass(oParam), "'>", oParam.name, "</td>", "<td class='sapDkCueCdType'>", crossref(oParam, oParam.type), "</td>", "<td class='sapDkCueCdDoc'>", oParam.doc, deprDoc(oParam), "</td></tr>");
							}
							if ( oMethod.type !== "sap.ui.core/void" ) {
								rm.write("<tr", alternate(i), "><td class='sapDkCueCdSubName'>", "<i>returns</i>", "</td>", "<td class='sapDkCueCdType'>", crossref(oMethod, oMethod.type), "</td>", "<td class='sapDkCueCdDoc'>", "&nbsp;", "</td></tr>");
							}
						}
					}
				}
				if ( oDoc.metatype === 'type' ) {
					n = names(oDoc.values);
					if ( n.length > 0 ) {
						rm.write("<tr><td colspan='3' class='sapDkCueCdHd", deprClass(oDoc), "'>", "Values", "</td></tr>");
						for (i = 0; i < n.length; i++) {
							var oValue = oDoc.values[n[i]];
							rm.write("<tr", alternate(i), "><td class='sapDkCueCdName", deprClass(oValue), "'>", n[i], "</td>", "<td class='sapDkCueCdType'>", "&nbsp;", "</td>", "<td class='sapDkCueCdDoc'>", oValue.doc, deprDoc(oValue), "</td></tr>");
						}
					}
					if ( oDoc.pattern ) {
						rm.write("<tr><td colspan='3' class='sapDkCueCdHd'>", "Constraints", "</td></tr>");
						rm.write("<tr", alternate(i), "><td class='sapDkCueCdName'>", "pattern", "</td>", "<td>", "&nbsp;", "</td>", "<td class='sapDkCueCdDoc'>", oDoc.pattern, "</td></tr>");
					}
				}
				rm.write("</table>");
			}

		}
		if ( oControl.getCollapsible() ) {
			rm.renderControl(oControl._oShowCueCardLink);
		}
		rm.write("</div>");
	};


	return UI5EntityCueCardRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/UI5EntityCueCardRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.UIAreaSubstitute') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.UIAreaSubstitute.
jQuery.sap.declare('sap.ui.demokit.UIAreaSubstitute'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/UIAreaSubstitute",['sap/ui/core/Element', './library'],
	function(Element, library) {
	"use strict";

	/**
	 * Constructor for a new UIAreaSubstitute.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A substitute for a UIArea that can be embedded in the control tree.
	 * @extends sap.ui.core.Element
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.UIAreaSubstitute
	 */
	var UIAreaSubstitute = Element.extend("sap.ui.demokit.UIAreaSubstitute", /** @lends sap.ui.demokit.UIAreaSubstitute.prototype */ { metadata : {

		library : "sap.ui.demokit",
		aggregatingType : "sap.ui.demokit.CodeSampleContainer",
		aggregations : {

			/**
			 * Content Area used for the running sample code
			 */
			content : {type : "sap.ui.core.Control", multiple : true, singularName : "content"}
		}
	}});

	return UIAreaSubstitute;

});

}; // end of sap/ui/demokit/UIAreaSubstitute.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.demoapps.controller.App.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global JSZip, Promise*/
jQuery.sap.declare('sap.ui.demokit.demoapps.controller.App.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/demoapps/controller/App.controller",[
	"sap/ui/core/mvc/Controller",
	"jquery.sap.global",
	"sap/ui/demokit/demoapps/model/sourceFileDownloader",
	"sap/ui/demokit/demoapps/model/formatter",
	"sap/m/MessageBox",
	"sap/m/MessageToast",
	"sap/ui/model/Filter",
	"sap/ui/model/FilterOperator",
	"sap/m/library"
], function (Controller, $, sourceFileDownloader, formatter, MessageBox, MessageToast, Filter, FilterOperator) {
	"use strict";

	return Controller.extend("sap.ui.demokit.demoapps.controller.App", {

		formatter: formatter,

		/* =========================================================== */
		/* event handlers                                              */
		/* =========================================================== */

		/**
		 * Opens the download dialog
		 * @param {sap.ui.base.Event} oEvent the Button press event
		 * @public
		 */
		onDownloadButtonPress: function (oEvent) {
			var oDownloadDialog = this.byId("downloadDialog");
			this._oDownloadButton = oEvent.getSource();

			oDownloadDialog.getBinding("items").filter([]);
			oDownloadDialog.open();
			// hack: override of the SelectDialog's internal dialog height
			oDownloadDialog._oDialog.setContentHeight("");
		},

		/**
		 * Filters the download dialog
		 * @param {sap.ui.base.Event} oEvent the SearchField liveChange event
		 * @public
		 */
		onSearch: function (oEvent) {
			oEvent.getParameters().itemsBinding.filter([
				new Filter("name", FilterOperator.Contains, oEvent.getParameters().value)
			]);
		},

		/**
		 * Downloads a demo app
		 * @param {sap.ui.base.Event} oEvent the Button press event
		 * @public
		 */
		onDownloadPress: function (oEvent) {
			var oSelectedItem = oEvent.getParameters().selectedItem,
				oListItem = oSelectedItem ? oSelectedItem : oEvent.getSource().getParent();

			this._oDownloadButton.setBusy(true);
			sap.ui.require([
				"sap/ui/core/util/File",
				"sap/ui/thirdparty/jszip"
			], function (oFile) {
				var oZipFile = new JSZip();

				// load the config file from the custom data attached to the list item
				$.getJSON(oListItem.data("config"), function (oConfig) {
					var aFiles = oConfig.files,
						aPromises = [],
						aFails = [];

					// add extra download files
					aFiles.forEach(function(sFilePath) {
						var oPromise = sourceFileDownloader(oConfig.cwd + sFilePath);

						oPromise.then(function (oContent) {
							if (oContent.errorMessage) {
								// promise gets resolved in error case since Promise.all will not wait for all fails
								aFails.push(oContent.errorMessage);
							} else {
								oZipFile.file(sFilePath, oContent, { base64: false, binary: true });
							}
						});
						aPromises.push(oPromise);
					});

					Promise.all(aPromises).then(function () {
						// collect errors and show them
						if (aFails.length) {
							var sCompleteErrorMessage = aFails.reduce(function (sErrorMessage, sError) {
								return sErrorMessage + sError + "\n";
							}, "Could not locate the following download files:\n");
							this._handleError(sCompleteErrorMessage);
						}

						// show success message
						this._oDownloadButton.setBusy(false);
						MessageToast.show("Downloading for app \"" + oListItem.getLabel() + "\" has been started");

						// still make the available files ready for download
						var oContent = oZipFile.generate({type:"blob"});
						this._createArchive(oFile, oContent, oListItem.getLabel());
					}.bind(this));
				}.bind(this));
			}.bind(this));
		},

		/* =========================================================== */
		/* lifecycle methods                                           */
		/* =========================================================== */

		/**
		 * Factory function for creating the demo app cells
		 *
		 * @param {string} sId the id for the current cell
		 * @param {sap.ui.model.Context} oBindingContext the context for the current cell
		 * @return {sap.ui.layout.BlockLayoutCell} either a header cell or a demo app cell based on the metadata in the model
		 * @public
		 */
		createDemoAppRow: function (sId, oBindingContext) {
			var oBlockLayoutCell;
			if (!oBindingContext.getObject().categoryId) { // demo app tile
				if (oBindingContext.getObject().teaser) { // teaser cell (loads fragment from demo app)
					try {
						jQuery.sap.registerResourcePath("test-resources","test-resources");
						var sRelativePath = jQuery.sap.getResourcePath(oBindingContext.getObject().teaser);
						var oTeaser = sap.ui.xmlfragment(sId, sRelativePath);
						oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.demokit.demoapps.view.BlockLayoutTeaserCell", this);
						oBlockLayoutCell.getContent()[0].addContent(oTeaser);
						jQuery.sap.registerResourcePath("test-resources",null);
					} catch (oException) {
						jQuery.sap.log.warning("Teaser for demo app \"" + oBindingContext.getObject().name + "\" could not be loaded: " + oException);
						oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.demokit.demoapps.view.BlockLayoutCell", this);
					}
				} else { // normal cell
					oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.demokit.demoapps.view.BlockLayoutCell", this);
				}
			} else { // headline tile
				oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.demokit.demoapps.view.BlockLayoutHeadlineCell", this);
			}
			oBlockLayoutCell.setBindingContext(oBindingContext);

			return oBlockLayoutCell;
		},

		/* =========================================================== */
		/* helper methods                                              */
		/* =========================================================== */

		/**
		 * Archive creation function that can be stubbed easily in tests
		 * @param {object} oFile the jszip file handle
		 * @param {object} oContent the blob for the zip file
		 * @param {string} sFilename the file name
		 * @private
		 */
		_createArchive: function (oFile, oContent, sFilename) {
			oFile.save(oContent, sFilename, "zip", "application/zip");
		},

		/**
		 * Error handler function that can be stubbed easily in tests
		 * @param {string} sError the error message
		 * @private
		 */
		_handleError: function (sError) {
			MessageBox.error(sError);
		}
	});
});

}; // end of sap/ui/demokit/demoapps/controller/App.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.demoapps.model.libraryData') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.demoapps.model.libraryData'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/demoapps/model/libraryData",[
	'jquery.sap.global',
	'sap/ui/demokit/library'
],function (jQuery, library) {
	"use strict";

	// function to compute the app objects for a demo object
	function createDemoAppData(oDemoAppMetadata, sLibUrl, sLibNamespace) {
		// transform simple demo app link to a configuration object
		var aLinks = [];
		// transform link object to a bindable array of objects
		if (jQuery.isPlainObject(oDemoAppMetadata.links)) {
			aLinks = Object.keys(oDemoAppMetadata.links).map(function (sKey) {
				return {
					name: sKey,
					ref: oDemoAppMetadata.links[sKey]
				};
			});
		}

		var oApp = {
			lib : oDemoAppMetadata.namespace || sLibNamespace,
			name : oDemoAppMetadata.text,
			icon : oDemoAppMetadata.icon,
			desc : oDemoAppMetadata.desc,
			config : oDemoAppMetadata.config,
			teaser : oDemoAppMetadata.teaser,
			category : oDemoAppMetadata.category,
			ref : (oDemoAppMetadata.resolve === "lib" ? sLibUrl : "") + oDemoAppMetadata.ref,
			links : aLinks
		};

		return oApp;
	}

	/**
	 * Creates a JSON model structure for both all demo apps in a flat list and demo apps by category
	 * Each library contains a metadata section for demo apps with the following structure (example):
	 * demo: {
	 * 	text: "sap.m", // legacy entry, name of the library
	 * 	links: {
	 *		icon: an index of the icon font
	 *		text: the name of the app
	 *		description: a short description text
	 *		ref: a link to the demo app entry point
	 *		links: an object of links with a key (title) and value (link) each
	 *		category: one of the demo app categories (Showcase/Tool/Tutorial/Template/RTA/Misc)
	 *		config: the URL to the demo app configuration for downloading the app
	 * 	}
	 *
	 * Under path /demoApps the following properties can be found: lib, name, icon, desc, type, ref
	 * Under path /demoApps by category the apps are structured by the entry "category" and grouped in batches
	 * of 4 items so that they can be bound to the BlockLayoutRow control directly
	 * @param {array} aLibs an array of the currently loaded UI5 libraries
	 * @param {object} oDocIndicies an object of the currently loaded UI5 library docu metadata
	 * @private
	 */
	function createModelData (aLibs, oDocIndicies) {
		// generate the global model structure
		var aCategories = ["Showcase", "Tool", "Tutorial", "Template", "RTA", "Misc"];
		var oDemoAppsByCategory = {};

		// create a helper structure for demo apps by category
		aCategories.forEach(function (sCategoryName) {
			oDemoAppsByCategory[sCategoryName] = [];
		});

		// create a model structure that can be bound in the view
		var oData = {
			// all demo apps in the order they were read by the metadata
			demoApps: [],
			// generated rows and cells matching for for the BlockLayout
			demoAppsByCategory: []
		};

		// loop over all libraries and add model data for each demo app
		for (var i = 0; i < aLibs.length; i++) {
			var oDemo = oDocIndicies[aLibs[i]].demo;
			if (!oDemo) {
				continue;
			}

			if (oDemo.links && oDemo.links.length > 0) {
				for (var j = 0; j < oDemo.links.length; j++) {
					var oDemoAppData = createDemoAppData(oDemo.links[j], oDocIndicies[aLibs[i]].libraryUrl, oDemo.text);
					oData.demoApps.push(oDemoAppData);

					// push demo app into helper structure
					if (aCategories.indexOf(oDemoAppData.category) < 0) {
						jQuery.sap.log.warning("Demo app category \"" + oDemoAppData.category + "\" not found, correcting demo app \"" + oDemoAppData.name + "\" to \"Misc\"");
						oDemoAppData.category = "Misc";
					}
					oDemoAppsByCategory[oDemoAppData.category].push(oDemoAppData);
				}
			}
		}

		// create a structure in the model data that can be bound to the block layout (an array of rows)
		// each row contains an array with a headline or a maximum of 4 demo apps
		Object.keys(oDemoAppsByCategory).forEach(function (sKey) {
			// early out if category is empty
			if (oDemoAppsByCategory[sKey].length === 0) {
				return;
			}

			// push a row for the headline
			oData.demoAppsByCategory.push([{
				categoryId : sKey
			}]);
			// push n rows for the demo apps itself (start a new row every 4 cells)
			var iCurrentLength = oData.demoAppsByCategory.push([]);
			var iCellCounter = 0;
			for (var i = 0; i < oDemoAppsByCategory[sKey].length; i++) {
				iCellCounter++;
				if (oDemoAppsByCategory[sKey][i].teaser) { // teaser apps take two cells
					iCellCounter++;
				}
				if (iCellCounter > 4) {
					iCurrentLength = oData.demoAppsByCategory.push([]);
					iCellCounter = 0;
				}
				oData.demoAppsByCategory[iCurrentLength - 1].push(oDemoAppsByCategory[sKey][i]);
			}
		});

		return oData;
	}

	return {
		/**
		 * Fills a JSON model with the demo apps metadata of all available libraries
		 * under path /demoApps the following properties can be found: lib, name, icon, desc, config, category, refs
		 * @param {sap.ui.model.json.JSONModel} oModel the helper JSON model passed in as a reference
		 * @public
		 */
		fillJSONModel: function (oModel) {
			function fnHandleLibInfoLoaded  (aLibs, oDocIndicies) {
				if (!aLibs) {
					return;
				}

				// set model
				var oModelData = oModel.getData();
				oModel.setData(jQuery.extend(oModelData, createModelData(aLibs, oDocIndicies)));
			}

			// load and process all lib info
			library._loadAllLibInfo("", "_getDocuIndex", fnHandleLibInfoLoaded);
		}
	};


});

}; // end of sap/ui/demokit/demoapps/model/libraryData.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.Bootstrap') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Bootstrap for the 'explored' app.
jQuery.sap.declare('sap.ui.demokit.explored.Bootstrap'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Shell'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/Bootstrap",['jquery.sap.global', 'sap/ui/core/ComponentContainer', 'sap/m/Shell', 'sap/ui/demokit/library', './data'],
	function(jQuery, ComponentContainer, Shell, library, data) {
	"use strict";

	jQuery("#busyIndicator").css({
		"margin-top": "8em",
		"text-align": "center",
		color: "#555555"
	});

	var Bootstrap = {

		run : function () {
			library._loadAllLibInfo(
				"", "_getDocuIndex",
				function (aLibs, oDocIndicies) {
					Bootstrap._processAndStoreIndices(aLibs, oDocIndicies);
					Bootstrap._loadUi();
				});
		},

		_processAndStoreIndices : function (aLibs, oDocIndicies) {

			var aCategoryWhiteList = [
				"Action",
				"Application",
				"Chart",
				"Container",
				"Data Binding",
				"Data Visualization",
				"Display",
				"Layout",
				"List",
				"Map",
				"Mini Chart",
				"Popup",
				"Routing",
				"Testing",
				"Theming",
				"Tile",
				"Tutorial",
				"User Input"
			];
			var afilterProps = [ "namespace", "since", "category"]; // content density are set manually
			var oFilterSets = {
				namespace : {},
				since : {},
				category : {},
				formFactors : { // content density are set manually
					"Independent" : true,
					"Condensed" : true,
					"Compact" : true,
					"Cozy" : true
				}
			};
			var mFormFactorsMap = {
				"-" : "Independent",
				"S" : "Condensed",
				"SM" : "Condensed, Compact",
				"SL" : "Condensed, Cozy",
				"SML" : "Condensed, Compact, Cozy",
				"M" : "Compact",
				"ML" : "Compact, Cozy",
				"L" : "Cozy"
			};

			// init data structures
			data.entityCount = 0;
			data.entities = [];
			data.filter = {};
			data.samples = {};

			// iterate docu indices
			jQuery.each(oDocIndicies, function (i, oDoc) {

				// check data
				if (!oDoc.explored) {
					return;
				} else if (!oDoc.explored.samplesRef) {
					jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef'");
					return;
				} else if (Array.isArray(oDoc.explored.samplesRef) && oDoc.explored.samplesRef.length !== oDoc.explored.samplesRef.filter(function (oItem) {
						return oItem.namespace && oItem.ref;
					}).length) {
					jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");
					return;
				} else if (!Array.isArray(oDoc.explored.samplesRef) && !oDoc.explored.samplesRef.namespace) {
					jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef.namespace'");
					return;
				} else if (!Array.isArray(oDoc.explored.samplesRef) && !oDoc.explored.samplesRef.ref) {
					jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef.ref'");
					return;
				} else if (!oDoc.explored.entities) {
					jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.entities'");
					return;
				} else {
					jQuery.sap.log.info("explored: now reading lib '" + oDoc.library + "'");
				}

				// register sample resources
				if (Array.isArray(oDoc.explored.samplesRef)) {
					// register an array of namespaces
					oDoc.explored.samplesRef.forEach(function (oItem) {
						jQuery.sap.registerModulePath(oItem.namespace, "" + oItem.ref);
					});
				} else {
					// register a single namespace
					jQuery.sap.registerModulePath(oDoc.explored.samplesRef.namespace, "" + oDoc.explored.samplesRef.ref);
				}

				// build sample map
				jQuery.each(oDoc.explored.samples, function (i, oSample) {
					if (!oSample.id)  {
						jQuery.sap.log.error("explored: cannot register sample '?'. missing 'id'");
					} else if (!oSample.name)  {
						jQuery.sap.log.error("explored: cannot register sample '" + oSample.id + "'. missing 'name'");
					} else {
						data.samples[oSample.id] = oSample;
					}
				});

				// iterate entities
				jQuery.each(oDoc.explored.entities, function (j, oEnt) {

					// check id property
					if (!oEnt.id)  {
						jQuery.sap.log.error("explored: cannot register entity '?'. missing 'id'");
						return;
					}

					// apply default properties
					if (oDoc.explored.entitiesDefaults) {
						jQuery.each(oDoc.explored.entitiesDefaults, function (key, value) {
							if (!oEnt.hasOwnProperty(key)) {
								oEnt[key] = value;
							}
						});
					}

					// apply namespace property
					var iIndex = oEnt.id.lastIndexOf(".");
					var sNamespace = (iIndex !== -1) ? oEnt.id.substring(0, iIndex) : oEnt.id;
					oEnt.namespace = sNamespace;

					// check name property
					if (!oEnt.name)  {
						jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. missing 'name'");
						return;
					}

					// check category white list
					if (aCategoryWhiteList.indexOf(oEnt.category) === -1)  {
						jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. category '" + oEnt.category + "' is not allowed");
						return;
					}

					// convert content density
					if (!oEnt.formFactors)  {
						jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. missing 'formFactors'");
						return;
					}
					if (!mFormFactorsMap[oEnt.formFactors]) {
						jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. formFactors '" + oEnt.formFactors + "' is not allowed");
						return;
					}
					oEnt.formFactors = mFormFactorsMap[oEnt.formFactors];

					// check filter properties
					var bAbortEntity = false;
					jQuery.each(afilterProps, function (i, sProp) {
						if (!oEnt[sProp])  {
							jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. missing '" + sProp + "'");
							bAbortEntity = true;
							return false;
						}
					});
					if (bAbortEntity) {
						return;
					}

					// add filter properties to sets
					jQuery.each(afilterProps, function (i, sProp) {
						oFilterSets[sProp][oEnt[sProp]] = true;
					});

					// add entity
					data.entities.push(oEnt);
				});
			});

			// iterate entities one more time and add the sample data
			// (this must be done in a separate loop in order to map samples across libraries/docIndizes)
			jQuery.each(data.entities, function (sNamespace, oEnt) {
				var i = 0,
					oStep,
					fnPrependZero;

				// define search tags
				oEnt.searchTags = oEnt.name + " " + oEnt.name.replace(/ /g, "") + " " + oEnt.category;

				// check samples property
				if (oEnt.samples && !(oEnt.samples instanceof Array)) {
					oEnt.samples = [];
					jQuery.sap.log.error("explored: cannot register samples for entity '" + oEnt.id + "'. 'samples' is not an array");
					return;
				}
				if (!oEnt.samples) {
					oEnt.samples = [];
				}

				// add samples to entity
				if (oEnt.samplesAsSteps) {
					// step-based entities: generate a sample based on the name of the step and the position in the array
					if (!(oEnt.samplesAsSteps instanceof Array)) {
						jQuery.sap.log.error("explored: cannot register samples for entity '" + oEnt.id + "'. 'samplesAsSteps' is not an array");
						return;
					}

					// helper function to add a leading 0 for all samples (folders will start with 01)
					fnPrependZero = function (iNumber) {
						if (iNumber.toString().length === 1) {
							return "0" + iNumber;
						}
						return iNumber;
					};

					for (; i < oEnt.samplesAsSteps.length; i++) {
						oStep = {
							"id": oEnt.id + "." + fnPrependZero(i + 1),
							"name": oEnt.name + " - Step " + (i + 1) + " - " + oEnt.samplesAsSteps[i]
						};

						// dynamically add a prev / next pointer to be able to cross-navigate between the samples of the same type
						if (i > 0) {
							oStep.previousSampleId = oEnt.id + "." + fnPrependZero(i);
						}
						if (i < oEnt.samplesAsSteps.length - 1) {
							oStep.nextSampleId = oEnt.id + "." + fnPrependZero(i + 2);
						}

						// add generated sample to this entity and to the samples array
						oEnt.samples.push(oStep);
						data.samples[oStep.id] = oStep;
						oEnt.searchTags += " " + oStep.name;
					}
				} else {
					// other entities: lookup samples and build search tags
					var aSamples = [],
						oPreviousSample;

					jQuery.each(oEnt.samples, function (j, sId) {
						var oSample = data.samples[sId];

						if (!oSample) {
							jQuery.sap.log.warning("explored: cannot register sample '" + sId + "' for '" + oEnt.id + "'. not found in the available docu indizes");
						} else {
							// dynamically add a prev / next pointer to be able to cross-navigate between the samples of the same type
							oSample.previousSampleId = (oPreviousSample ? oPreviousSample.id : undefined);
							if (oPreviousSample) {
								oPreviousSample.nextSampleId = oSample.id;
							}
							oPreviousSample = oSample;

							// add the sample to the local store
							aSamples.push(oSample);
							oEnt.searchTags += " " + oSample.name;
						}
					});
					oEnt.samples = aSamples;
				}

				// set count
				oEnt.sampleCount = oEnt.samples.length;
			});

			// set count
			data.entityCount = data.entities.length;

			// convert filter sets to arrays
			jQuery.each(oFilterSets, function (setKey, setValue) {
				data.filter[setKey] = [];
				jQuery.each(setValue, function (key, value) {
					data.filter[setKey].push({ id: key });
				});
			});

			// call LibraryInfo API method for collecting all component info from the .library files
			jQuery.sap.require("sap.ui.core.util.LibraryInfo");
			var LibraryInfo = sap.ui.require("sap/ui/core/util/LibraryInfo");
			var oLibInfo = new LibraryInfo();
			var oLibComponents = {};
			var oLibraryComponentInfo = function(oComponent) {
				oLibComponents[oComponent.library] = oComponent.componentInfo;
			};
			for (var i = 0; i < aLibs.length; i++) {
				oLibInfo._getLibraryInfo(aLibs[i], oLibraryComponentInfo);
			}
			data.libComponentInfos = oLibComponents;
		},

		_loadUi : function () {
			var sPath = jQuery.sap.getModulePath("sap.ui.demokit.explored");
			new Shell("Shell", {
				title : "SAPUI5 Explored",
				showLogout : false,
				app : new ComponentContainer({
					name : 'sap.ui.demokit.explored'
				}),
				homeIcon : {
					'phone' : sPath + '/img/57_iPhone_Desktop_Launch.png',
					'phone@2' : sPath + '/img/114_iPhone-Retina_Web_Clip.png',
					'tablet' : sPath + '/img/72_iPad_Desktop_Launch.png',
					'tablet@2' : sPath + '/img/144_iPad_Retina_Web_Clip.png',
					'favicon' : sPath + '/img/favicon.ico',
					'precomposed': false
				}
			}).placeAt('content');
		}
	};


	return Bootstrap;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/explored/Bootstrap.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.Component') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Root component for the 'explored' app.
jQuery.sap.declare('sap.ui.demokit.explored.Component'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.View'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.resource.ResourceModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.InstanceManager'); // unlisted dependency retained
jQuery.sap.require('sap.m.routing.RouteMatchedHandler'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/Component",['jquery.sap.global', 'sap/ui/Device',
	'sap/ui/core/UIComponent', 'sap/ui/core/mvc/View', 'sap/ui/core/routing/History',
	'sap/ui/model/json/JSONModel', 'sap/ui/model/resource/ResourceModel',
	'sap/m/InstanceManager', 'sap/m/routing/RouteMatchedHandler',
	'./util/ObjectSearch', './util/MyRouter', './util/ToggleFullScreenHandler', './data'],
	function(jQuery, Device, UIComponent, View, History, JSONModel, ResourceModel, InstanceManager, RouteMatchedHandler, ObjectSearch, MyRouter, ToggleFullScreenHandler, data) {
	"use strict";


	var Component = UIComponent.extend("sap.ui.demokit.explored.Component", {

		metadata : {
			includes : [
				"css/style.css"
			],
			routing : {
				config : {
					routerClass : MyRouter,
					viewType : "XML",
					viewPath : "sap.ui.demokit.explored.view",
					targetControl : "splitApp",
					clearTarget : false,
					async: true
				},
				routes : [
					{
						pattern : "entity/{id}/{part}",
						name : "entity",
						view : "entity",
						viewLevel : 3,
						targetAggregation : "detailPages"
					},
					{
						pattern : "sample/{id}/preview",
						name : "sample",
						view : "sample",
						viewLevel : 4,
						targetAggregation : "detailPages"
					},
					{
						pattern : "sample/{id}/code/{fileName}",
						name : "code_file",
						view : "code",
						viewLevel : 6,
						targetAggregation : "detailPages",
						transition: "flip"
					},
					{
						pattern : "sample/{id}/code",
						name : "code",
						view : "code",
						viewLevel : 5,
						targetAggregation : "detailPages",
						transition: "flip"
					},
					{
						pattern : "",
						name : "home",
						view : "master",
						viewLevel : 1,
						targetAggregation : "masterPages",
						subroutes : [
							{
								pattern : "{all*}",
								name : "notFound",
								view : "notFound",
								viewLevel : 2,
								targetAggregation : "detailPages"
							}
						]
					}
				]
			}
		},

		/**
		 * !!! The steps in here are sequence dependent !!!
		 */
		init : function () {

			// 1. call overridden init (calls createContent)
			UIComponent.prototype.init.apply(this, arguments);

			// 2. nav to initial pages
			var router = this.getRouter();
			if (!Device.system.phone) {
				router.myNavToWithoutHash("sap.ui.demokit.explored.view.master", "XML", true);
				router.myNavToWithoutHash("sap.ui.demokit.explored.view.welcome", "XML", false);
			}

			// 3. initialize the router
			this.routeHandler = new RouteMatchedHandler(router);
			router.initialize();
		},

		destroy : function () {

			if (this.routeHandler) {
				this.routeHandler.destroy();
			}
			ToggleFullScreenHandler.cleanUp();

			// call overridden destroy
			UIComponent.prototype.destroy.apply(this, arguments);
		},

		/**
		 *
		 */
		createContent : function () {

			// create root view
			var oView = sap.ui.view({
				id : "app",
				viewName : "sap.ui.demokit.explored.view.app",
				type : "JS",
				viewData : { component : this }
			});

			// set i18n model (must be done before data)
			var sPath = jQuery.sap.getModulePath("sap.ui.demokit.explored");
			var i18nModel = new ResourceModel({
				bundleUrl : sPath + "/i18n/messageBundle.properties"
			});
			oView.setModel(i18nModel, "i18n");

			// set entity model
			var oEntData = {
				entityCount : data.entityCount,
				entities : data.entities
			};
			var oEntModel = new JSONModel(oEntData);
			oEntModel.setSizeLimit(100000);
			oView.setModel(oEntModel, "entity");

			// set filter model
			var oFilterData = data.filter;
			var oFilterModel = new JSONModel(oFilterData);
			oFilterModel.setSizeLimit(100000);
			this.setModel(oFilterModel, "filter");

			// set device model
			var deviceModel = new JSONModel({
				isTouch : Device.support.touch,
				isNoTouch : !Device.support.touch,
				isPhone : Device.system.phone,
				isNoPhone : !Device.system.phone,
				listMode : (Device.system.phone) ? "None" : "SingleSelectMaster",
				listItemType : (Device.system.phone) ? "Active" : "Inactive"
			});
			deviceModel.setDefaultBindingMode("OneWay");
			oView.setModel(deviceModel, "device");

			// done
			return oView;
		}
	});

	return Component;

});

}; // end of sap/ui/demokit/explored/Component.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.explored.view.entity.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.explored.view.entity.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/explored/view/entity.controller",[
	"jquery.sap.global",
	"sap/ui/Device",
	"sap/ui/core/Component",
	"sap/ui/core/UIComponent",
	"sap/ui/core/routing/History",
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/ui/demokit/EntityInfo",
	"sap/ui/demokit/util/JSDocUtil",
	"../util/ObjectSearch",
	"../util/ToggleFullScreenHandler",
	"../data",
	"sap/ui/demokit/explored/view/base.controller"
], function (jQuery, Device, Component, UIComponent, History, Controller, JSONModel, EntityInfo, JSDocUtil, ObjectSearch, ToggleFullScreenHandler, data, Base) {
	"use strict";

	return Base.extend("sap.ui.demokit.explored.view.entity", {

		descriptionText: function (text) {
			var html;
			if (text) {
				html = "<span>" + text + "</span>";
			}
			return html;
		},

		// ====== event handling ====================================================================
		onInit: function () {
			this.router = UIComponent.getRouterFor(this);
			this.router.attachRoutePatternMatched(this.onRouteMatched, this);
			this._component = Component.getOwnerComponentFor(this.getView());
			// click handler for @link tags in JSdoc fragments
			this.getView().attachBrowserEvent("click", this.onJSDocLinkClick, this);

			this.getView().addEventDelegate({
				onBeforeFirstShow: jQuery.proxy(this._applyViewConfigurations, this)
			});
		},

		onExit: function() {
			this.getView().detachBrowserEvent("click", this.onJSDocLinkClick, this);
		},

		onTypeLinkPress: function (oEvt) {

			// navigate to entity
			var sType = oEvt.getSource().data("type");
			this.router.navTo("entity", {
				id: sType,
				part: "samples"
			}, false);

			// notify master of selection change
			this._component.getEventBus().publish("app", "selectEntity", {id: sType});
		},

		onJSDocLinkClick: function (oEvt) {

			// get target
			var sType = oEvt.target.getAttribute("data-sap-ui-target");
			if ( sType && sType.indexOf('#') >= 0 ) {
				sType = sType.slice(0, sType.indexOf('#'));
			}

			if ( sType ) {

				this.router.navTo("entity", {
					id: sType,
					part: "samples"
				}, false);

				// notify master of selection change
				this._component.getEventBus().publish("app", "selectEntity", {id: sType});

				oEvt.preventDefault();
			}

		},

		onIntroLinkPress: function (oEvt) {
			// remove explored.html from URL
			var aParts = document.location.pathname.split("/"),
				sBaseLink = document.location.origin + aParts.splice(0, aParts.length - 1).join("/") + "/";

			// open a relative documentation window
			window.open(sBaseLink + this.getView().getModel().getProperty("/docuLink"), "_blank");
		},

		onTabSelect: function (oEvt) {
			// update URL without updating history
			var sTab = oEvt.getParameter("key");
			this.router.navTo("entity", {
				id: this._sId,
				part: sTab
			}, true);
		},

		onNavBack: function (oEvt) {
			this.router.myNavBack("home", {});
		},

		onNavToSample: function (oEvt) {
			var sPath = oEvt.getSource().getBindingContext("entity").getPath();
			var oSample = this.getView().getModel("entity").getProperty(sPath);
			this.router.navTo("sample", {
				id: oSample.id
			});
		},

		_TAB_KEYS: ["samples", "about", "properties", "aggregations", "associations", "events", "methods"],

		onRouteMatched: function (oEvt) {

			var sRouteName = oEvt.getParameter("name"),
				sNewId = oEvt.getParameter("arguments").id,
				sNewTab = oEvt.getParameter("arguments").part;

			// check route
			if (sRouteName !== "entity") {
				return;
			}

			// find entity in index
			// (can be null if the entity is not in the index, e.g. for base classes and types)
			var oEntModel = this.getView().getModel("entity");
			var sPath = ObjectSearch.getEntityPath(oEntModel.getData(), sNewId);
			var oEntity = (sPath) ? oEntModel.getProperty(sPath) : null;

			// set nav button visibility
			var bEntityIsInIndex = !!sPath;
			var oHistory = History.getInstance();
			var oPrevHash = oHistory.getPreviousHash();
			var bShowNavButton = Device.system.phone || (!bEntityIsInIndex && !!oPrevHash);
			this.getView().byId("page").setShowNavButton(bShowNavButton);

			// set data model
			var oModel,
				oData;
			if (this._sId !== sNewId) {

				// retrieve entity docu from server
				var oDoc = EntityInfo.getEntityDocu(sNewId);

				// route to not found page IF there is NO index entry AND NO docu from server
				if (!oEntity && !oDoc) {
					this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound", "XML", false, {path: sNewId});
					return;
				}

				// get view data
				oData = this._getViewData(sNewId, oDoc, oEntity);

				// set view model
				oModel = new JSONModel(oData);
				this.getView().setModel(oModel);

				// set also the binding context for entity data
				this.getView().bindElement("entity>" + sPath);

				// done, we can now switch the id
				this._sId = sNewId;

			} else {
				oModel = this.getView().getModel();
				oModel.refresh(true);
				// get existing data model
				oData = oModel.getData();
			}

			// handle unknown tab
			if (this._TAB_KEYS.indexOf(sNewTab) === -1) {
				sNewTab = "samples";
			}
			// handle invisible tab
			if (!oData.show[sNewTab]) {
				sNewTab = "samples";
			}
			var oTab = this.getView().byId("tabBar");
			if (sNewTab !== oTab.getSelectedKey() && oTab.getExpanded()) {
				oTab.setSelectedKey(sNewTab);
			}
		},

		onToggleFullScreen: function (oEvt) {
			ToggleFullScreenHandler.updateMode(oEvt, this.getView());
		},

		// ========= internal ===========================================================================
		_getViewData: function (sId, oDoc, oEntity) {

			// convert docu
			var oData = this._convertEntityInfo(sId, oDoc),
				bShouldShowSamplesSection = false,
				iSamplesCount = 0;

			if (oEntity) {

				// show the description as intro text if the entity is not deprecated
				if (!oData.shortDescription && oEntity.description) {
					oData.shortDescription = oEntity.description;
				}

				// make intro text active if a documentation link is set
				if (oEntity.docuLink) {
					oData.show.introLink = true;
					oData.docuLink = oEntity.docuLink;
				}

				bShouldShowSamplesSection = oEntity.samples.length > 0;
				iSamplesCount = oEntity.samples.length;
			}

			// apply entity related stuff
			oData.show.samples = bShouldShowSamplesSection;
			oData.count.samples = iSamplesCount;

			// done
			return oData;
		},

		_convertEntityInfo: function (sId, oDoc) {

			// create skeleton data structure
			var oData = {
				name: sId,
				deprecated: (oDoc) ? this._formatDeprecated(oDoc.deprecation) : null,
				deprecatedMark: (oDoc) ? this._createDeprecatedMark(oDoc.deprecation) : null,
				baseType: (oDoc) ? this._formatType(oDoc.baseType) : null,
				baseTypeText: (oDoc) ? this._formatTypeText(oDoc.baseType) : "-",
				baseTypeNav: (oDoc) ? this._formatTypeNav(oDoc.baseType) : null,
				shortDescription: (oDoc) ? this._formatDeprecatedDescription(oDoc.deprecation) : null,
				description: (oDoc) ? this._wrapInSpanTag(oDoc.doc) : null,
				docuLink: null,
				properties: [],
				events: [],
				methods: [],
				aggregations: [],
				associations: [],
				values: [], // for enums!
				show: {
					baseType: (oDoc) ? !!oDoc.baseType : false,
					about: !!oDoc,
					// computed later in this function
					properties: false,
					events: false,
					methods: false,
					aggregations: false,
					associations: false,
					values: false,
					introActive: false
				},
				count: {
					properties: 0,
					events: 0,
					methods: 0,
					aggregations: 0,
					associations: 0
				},
				appComponent: this._takeControlComponent(sId)
			};

			var methodsCount = 0,
				eventsCount = 0;

			var sBaseName = sId.slice(sId.lastIndexOf('.') + 1);

			// no documentation !
			if (!oDoc) {
				return oData;
			}

			// fill data
			var key = null;
			for (key in oDoc.properties) {
				if (oDoc.properties.hasOwnProperty(key) && key.indexOf("_") !== 0) {
					var oProp = oDoc.properties[key];
					oProp.name = key;
					oProp.deprecatedDescription = this._formatDeprecatedSinceDescription(oProp.deprecation, oProp.deprecationSince);
					oProp.deprecated = this._formatDeprecated(oProp.deprecation);
					oProp.doc = this._wrapInSpanTag(oProp.doc);
					oProp.typeText = this._formatTypeText(oProp.type);
					oProp.typeNav = this._formatTypeNav(oProp.type);
					oProp.type = this._formatType(oProp.type);
					oProp.defaultValue = (oProp.defaultValue) ? String(oProp.defaultValue).replace("empty/undefined", "-") : "";
					oData.properties.push(oProp);
				}
			}
			for (key in oDoc.events) {
				if (oDoc.events.hasOwnProperty(key) && key.indexOf("_") !== 0) {
					var oEvent = oDoc.events[key];
					oEvent.name = key;
					oEvent.deprecatedDescription = this._formatDeprecatedDescription(oEvent.deprecation);
					oEvent.deprecated = this._formatDeprecated(oEvent.deprecation);
					oEvent.doc = this._wrapInSpanTag(oEvent.doc);
					oData.events.push(oEvent);
					eventsCount++;
					for (var p in oEvent.parameters) { // TODO why is parameters not an array ???
						if (oEvent.parameters.hasOwnProperty(p) && p.indexOf("_") !== 0) {
							oData.events.push({
								param: p,
								since: oEvent.parameters[p].since,
								typeText: this._formatTypeText(oEvent.parameters[p].type),
								typeNav: this._formatTypeNav(oEvent.parameters[p].type),
								type: this._formatType(oEvent.parameters[p].type),
								doc: this._wrapInSpanTag(oEvent.parameters[p].doc),
								deprecatedDescription: this._formatDeprecatedDescription(oEvent.parameters[p].deprecation),
								deprecated: this._formatDeprecated(oEvent.parameters[p].deprecation)
							});
						}
					}
				}
			}
			for (key in oDoc.methods) {
				if (oDoc.methods.hasOwnProperty(key) && key.indexOf("_") !== 0 && !oDoc.methods[key].synthetic ) {
					var oMethod = oDoc.methods[key];
					oMethod.name = oDoc.methods[key].static ? sBaseName + "." + key : key;
					oMethod.deprecatedDescription = this._formatDeprecatedDescription(oMethod.deprecation);
					oMethod.deprecated = this._formatDeprecated(oMethod.deprecation);
					oMethod.doc = this._wrapInSpanTag(oMethod.doc);
					oMethod.param = "returnValue";
					oMethod.typeText = this._formatTypeText(oMethod.type);
					oMethod.typeNav = this._formatTypeNav(oMethod.type);
					oMethod.type = this._formatType(oMethod.type);
					oData.methods.push(oMethod);
					methodsCount++;
					for (var i = 0; i < oMethod.parameters.length; i++) {
						var sParamName = oMethod.parameters[i].name;
						if (sParamName.indexOf("_") !== 0) {
							oData.methods.push({
								param: sParamName,
								since: oMethod.parameters[i].since,
								typeText: this._formatTypeText(oMethod.parameters[i].type),
								typeNav: this._formatTypeNav(oMethod.parameters[i].type),
								type: this._formatType(oMethod.parameters[i].type),
								doc: this._wrapInSpanTag(oMethod.parameters[i].doc),
								deprecatedDescription: this._formatDeprecatedDescription(oMethod.parameters[i].deprecation),
								deprecated: this._formatDeprecated(oMethod.parameters[i].deprecation)
							});
						}
					}
				}
			}
			for (key in oDoc.aggregations) {

				var oAggr = oDoc.aggregations[key];
				var bNotHidden = (!oAggr.hasOwnProperty("visibility") || oAggr.visibility !== "hidden");
				if (oDoc.aggregations.hasOwnProperty(key) && key.indexOf("_") !== 0 && bNotHidden) {
					oAggr.name = key;
					oAggr.deprecated = this._formatDeprecated(oAggr.deprecation);
					oAggr.deprecatedDescription = this._formatDeprecatedDescription(oAggr.deprecation);
					oAggr.doc = this._wrapInSpanTag(oAggr.doc);
					oAggr.typeText = this._formatTypeText(oAggr.type);
					oAggr.typeNav = this._formatTypeNav(oAggr.type);
					oAggr.type = this._formatType(oAggr.type);
					oData.aggregations.push(oAggr);
				}
			}
			for (key in oDoc.associations) {
				if (oDoc.associations.hasOwnProperty(key) && key.indexOf("_") !== 0) {
					var oAssoc = oDoc.associations[key];
					oAssoc.name = key;
					oAssoc.deprecatedDescription = this._formatDeprecatedDescription(oAssoc.deprecation);
					oAssoc.deprecated = this._formatDeprecated(oAssoc.deprecation);
					oAssoc.doc = this._wrapInSpanTag(oAssoc.doc);
					oAssoc.typeText = this._formatTypeText(oAssoc.type);
					oAssoc.typeNav = this._formatTypeNav(oAssoc.type);
					oAssoc.type = this._formatType(oAssoc.type);
					oData.associations.push(oAssoc);
				}
			}
			for (key in oDoc.values) {
				if (oDoc.values.hasOwnProperty(key) && key.indexOf("_") !== 0) {
					var oValue = oDoc.values[key];
					oValue.name = key;
					oValue.deprecatedDescription = this._formatDeprecatedDescription(oValue.deprecation);
					oValue.deprecated = this._formatDeprecated(oValue.deprecation);
					oData.values.push(oValue);
				}
			}

			// determine if the parts shall be shown
			oData.show.properties = oData.properties.length > 0;
			oData.show.events = eventsCount > 0;
			oData.show.methods = methodsCount > 0;
			oData.show.aggregations = oData.aggregations.length > 0;
			oData.show.associations = oData.associations.length > 0;
			oData.show.values = oData.values.length > 0;

			// set counts
			oData.count.properties = oData.properties.length;
			oData.count.events = eventsCount;
			oData.count.methods = methodsCount;
			oData.count.aggregations = oData.aggregations.length;
			oData.count.associations = oData.associations.length;

			return oData;
		},

		/**
		 * This function wraps a text in a span tag so that it can be represented in an HTML control.
		 * @param {string} sText
		 * @returns {string}
		 * @private
		 */
		_wrapInSpanTag: function (sText) {
			return '<span class="fs0875">' + JSDocUtil.formatTextBlock(sText, {
				linkFormatter: function (target, text) {

					var p;

					target = target.trim().replace(/\.prototype\./g, "#");
					p = target.indexOf("#");
					if ( p === 0 ) {
						// a relative reference - we can't support that
						return "<code>" + target.slice(1) + "</code>";
					}

					if ( p > 0 ) {
						text = text || target; // keep the full target in the fallback text
						target = target.slice(0, p);
					}

					return "<a class=\"jsdoclink\" href=\"#\" data-sap-ui-target=\"" + target + "\">" + (text || target) + "</a>";

				}
			}) + '</span>';
		},

		/**
		 * Sets the boolean-as-string flag
		 */
		_formatDeprecated: function (sDeprecation) {
			return (sDeprecation && sDeprecation.length > 0) ? "true" : "false";
		},

		/**
		 * Adds the string "Deprecated" in front of the deprecation description.
		 */
		_formatDeprecatedDescription: function (sDeprecation) {
			return (this._isDeprecated(sDeprecation)) ? (this._createDeprecatedMark(sDeprecation) + ": " + sDeprecation) : null;
		},

		/**
		 * Adds "Deprecated Since" release in front of the deprecation description.
		 */
		_formatDeprecatedSinceDescription: function (sDeprecation, sDeprecationSince) {
			return (this._isDeprecated(sDeprecation)) ? (this._createDeprecatedSinceMark() + " " + sDeprecationSince + ": " + sDeprecation) : null;
		},

		/**
		 * Checks if object is deprecated.
		 */
		_isDeprecated: function (sDeprecation) {
			return (sDeprecation && sDeprecation.length > 0);
		},

		/**
		 * Converts the type to navigable type
		 */
		_formatType: function (sType) {
			if (!sType) {
				return null;
			} else {
				// remove arrays
				return sType.replace("[]", "");
			}
		},

		/**
		 * Converts the type to a friendly readable text
		 */
		_formatTypeText: function (sType) {
			if (!sType) {
				return null;
			} else {
				// remove core prefix
				sType = sType.replace("sap.ui.core.", "");
				// only take text after last dot
				var index = sType.lastIndexOf(".");
				return (index !== -1) ? sType.substr(index + 1) : sType;
			}
		},

		/**
		 * Converts the deprecated boolean to a human readable text
		 */
		_createDeprecatedMark: function (sDeprecated) {
			return (sDeprecated) ? this._getI18nModel().getProperty("deprecated") : "";
		},

		/**
		 * Fetch deprecatedSince translatable label
		 */
		_createDeprecatedSinceMark: function () {
			return this._getI18nModel().getProperty("deprecatedSince");
		},

		/**
		 * Get i18n model
		 */
		_getI18nModel: function () {
			return this.getView().getModel("i18n");
		},

		/**
		 * Determines if the type can be navigated to
		 */
		_baseTypes: [
			"sap.ui.core.any",
			"sap.ui.core.object",
			"sap.ui.core.function",
			"sap.ui.core.number", // TODO discuss with Thomas, type does not exist
			"sap.ui.core.float",
			"sap.ui.core.int",
			"sap.ui.core.boolean",
			"sap.ui.core.string",
			"sap.ui.core.URI", // TODO discuss with Thomas, type is not a base type (it has documentation)
			"sap.ui.core.ID", // TODO discuss with Thomas, type is not a base type (it has documentation)
			"sap.ui.core.void",
			"sap.ui.core.CSSSize", // TODO discuss with Thomas, type is not a base type (it has documentation)
			"any",
			"object",
			"function",
			"float",
			"int",
			"boolean",
			"string"
		],
		_formatTypeNav: function (sType) {
			return this._baseTypes.indexOf(sType) === -1;
		},

		/**
		 * the actual component for the control
		 * @param {string} controlName
		 * @return {string} sActualControlComponent
		 */
		_takeControlComponent: function (controlName) {
			var oLibComponentModel = data.libComponentInfos;
			jQuery.sap.require("sap.ui.core.util.LibraryInfo");
			var LibraryInfo = sap.ui.require("sap/ui/core/util/LibraryInfo");
			var oLibInfo = new LibraryInfo();
			var sActualControlComponent = oLibInfo._getActualComponent(oLibComponentModel, controlName);
			return sActualControlComponent;
		}
	});
});

}; // end of sap/ui/demokit/explored/view/entity.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.CodeSampleContainer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.demokit.CodeSampleContainer.
jQuery.sap.declare('sap.ui.demokit.CodeSampleContainer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Link'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/CodeSampleContainer",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/commons/Link', './library', './CodeViewer', './UIAreaSubstitute'],
	function(jQuery, Control, Link, library, CodeViewer, UIAreaSubstitute) {
	"use strict";



	/**
	 * Constructor for a new CodeSampleContainer.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A container for both the source and the runtime results of a CodeSample. By default, only the runtime results are shown. There are additional controls that allow the user to display the source, modify and run it.
	 *
	 * The container provides a sub container that can be used in calls to sap.ui.setRoot() as if it would be a normal UIArea. So the sample code doesn't have to know that it runs in a CodeSample container.
	 * @extends sap.ui.core.Control
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @sap-restricted sdk
	 * @alias sap.ui.demokit.CodeSampleContainer
	 */
	var CodeSampleContainer = Control.extend("sap.ui.demokit.CodeSampleContainer", /** @lends sap.ui.demokit.CodeSampleContainer.prototype */ { metadata : {

		library : "sap.ui.demokit",
		properties : {

			/**
			 * Id of the script element that contains the initial sample code for this code sample.
			 */
			scriptElementId : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Id of the container for the running code. This Id can be used in calls to sap.ui.setRoot as if it would be a normal UIArea. Internally, a container UIElement is created with that Id.
			 */
			uiAreaId : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * A title to be displayed above the code.
			 */
			title : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * Whether the source code is visible or not.
			 */
			sourceVisible : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Width of the CodeSample container.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Misc", defaultValue : '90%'}
		},
		aggregations : {

			/**
			 * The UIAreaSubstitute used by this code sample container
			 */
			_uiarea : {type : "sap.ui.demokit.UIAreaSubstitute", multiple : false, visibility : "hidden"}
		},
		events : {

			/**
			 * Fired when the user decides to apply his/her changes to the sample code
			 */
			apply : {
				parameters : {

					/**
					 * the current code that will be applied
					 */
					code : {type : "string"}
				}
			}
		}
	}});


	CodeSampleContainer.prototype.init = function(){

		this._oUIArea = new UIAreaSubstitute(this.getUiAreaId());
		this.setAggregation("_uiarea", this._oUIArea);
		this._oCodeViewer = new CodeViewer({
			visible : false,
			source : "",
			press : [this._setCodeEditable, this],
			save : [this._saveAndApplyCode, this]
		});
		this._oCodeViewer.setParent(this); //TODO provide sAggregationName?
		this._oShowCodeLink = new Link({	text : "Show Source", press : [this._toggleCodeDisplay, this]});
		this._oShowCodeLink.setParent(this); //TODO provide sAggregationName?
		this._oApplyCodeLink = new Link({ visible: false, text : 'Apply', press : [this._saveAndApplyCode, this]});
		this._oApplyCodeLink.setParent(this); //TODO provide sAggregationName?

	};

	CodeSampleContainer.prototype.setSourceVisible = function(bSourceVisible) {
		this.setProperty("sourceVisible", bSourceVisible);
		this._oCodeViewer && this._oCodeViewer.setVisible(this.getSourceVisible());
		this._oShowCodeLink && this._oShowCodeLink.setText(this.getSourceVisible() ? "Hide Source" : "Show Source");
		this._oApplyCodeLink && this._oApplyCodeLink.setVisible(this.getSourceVisible());
	};

	CodeSampleContainer.prototype.setUiAreaId = function(sId) {
		this.setProperty("uiAreaId", sId);
		var aContent;
		if ( this._oUIArea ) {
			aContent = this._oUIArea.removeAllContent();
			this._oUIArea.destroy();
		}
		this._oUIArea = new UIAreaSubstitute(this.getUiAreaId());
		this.setAggregation("_uiarea", this._oUIArea);
		if ( aContent ) {
			for (var i = 0; i < aContent.length; i++) {
				this._oUIArea.addContent(aContent[i]);
			}
		}
	};

	CodeSampleContainer.prototype.setScriptElementId = function(sId) {
		this.setProperty("scriptElementId", sId);
		this._oCodeViewer.setSource(this._getSource());
		if ( sId && !this._oScriptRef ) {
			var that = this;
			sap.ui.getCore().attachInitEvent(function() { that._oCodeViewer.setSource(that._getSource()); });
		}
	};

	CodeSampleContainer.prototype._getSource = function() {
		var sSource = "!source not found! (" + this.getScriptElementId() + ")";
		if ( this.getScriptElementId() ) {
			this._oScriptRef = jQuery.sap.domById(this.getScriptElementId());
			if ( this._oScriptRef ) {
				sSource = this._oScriptRef.innerHTML;
			}
		}
		return sSource;
	};

	CodeSampleContainer.prototype._setCodeEditable = function() {
		this._oCodeViewer.setEditable(true);
		var that = this;
		setTimeout(function() { that._oCodeViewer.focus(); }, 50);
	};

	CodeSampleContainer.prototype._toggleCodeDisplay = function() {
		this.setSourceVisible(!this.getSourceVisible());
	};

	CodeSampleContainer.prototype._saveAndApplyCode = function() {
		var sCode = this._oCodeViewer.getSource();
		if ( this._oCodeViewer.getEditable() ) {
			sCode = this._oCodeViewer.getCurrentSource();
			this._oCodeViewer.setSource(sCode);
			this._oCodeViewer.setEditable(false);
		}

		// before executing the new code, we discard the old UIArea content
		// Otherwise, invalidation might fail (due to the bPrerendered logic in Control)
		this._oUIArea.destroyContent();

		// now execute the code
		if ( !this.hasListeners("apply") ) {
			jQuery.sap.globalEval(sCode);
		} else {
			this.fireApply({ code : sCode });
		}

	};


	return CodeSampleContainer;

});

}; // end of sap/ui/demokit/CodeSampleContainer.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.DemokitApp') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Main class for Demokit-like applications
jQuery.sap.declare('sap.ui.demokit.DemokitApp'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.CustomData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.HTML'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ListItem'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Title'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.View'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.search.OpenSearchProvider'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.util.LibraryInfo'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.Form'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.FormContainer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.FormElement'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.GridLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.GridElementData'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.VerticalLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Button'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.DropdownBox'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.FormattedTextView'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Image'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Label'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Link'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.TextView'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Splitter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.Tree'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.TreeNode'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.layout.AbsoluteLayout'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.DataSet'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.DataSetItem'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.DataSetSimpleView'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.NavigationItem'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.Shell'); // unlisted dependency retained
jQuery.sap.require('sap.ui.ux3.ToolPopup'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.script'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/DemokitApp",['jquery.sap.global', 'sap/ui/Device',
	'sap/ui/core/CustomData', 'sap/ui/core/HTML', 'sap/ui/core/library', 'sap/ui/core/ListItem', 'sap/ui/core/Title', 'sap/ui/core/mvc/View', 'sap/ui/core/search/OpenSearchProvider', 'sap/ui/core/util/LibraryInfo',
	'sap/ui/model/Filter', 'sap/ui/model/FilterOperator', 'sap/ui/model/json/JSONModel',
	'sap/ui/layout/form/Form', 'sap/ui/layout/form/FormContainer', 'sap/ui/layout/form/FormElement', 'sap/ui/layout/form/GridLayout', 'sap/ui/layout/form/GridElementData', 'sap/ui/layout/VerticalLayout',
	'sap/ui/commons/Button', 'sap/ui/commons/Dialog', 'sap/ui/commons/DropdownBox', 'sap/ui/commons/FormattedTextView', 'sap/ui/commons/Image', 'sap/ui/commons/Label', 'sap/ui/commons/library',
	'sap/ui/commons/Link', 'sap/ui/commons/TextView', 'sap/ui/commons/SearchField', 'sap/ui/commons/Splitter', 'sap/ui/commons/Tree', 'sap/ui/commons/TreeNode', 'sap/ui/commons/layout/AbsoluteLayout',
	'sap/ui/ux3/DataSet', 'sap/ui/ux3/DataSetItem', 'sap/ui/ux3/DataSetSimpleView', 'sap/ui/ux3/NavigationItem', 'sap/ui/ux3/Shell', 'sap/ui/ux3/ToolPopup',
	'./FeedbackClient', './library', './Tag', './TagCloud',
	'jquery.sap.script'
	],
	function (jQuery, Device,
	CustomData, HTML, coreLibrary, ListItem, Title, View, OpenSearchProvider, LibraryInfo,
	Filter, FilterOperator, JSONModel,
	Form, FormContainer, FormElement, GridLayout, GridElementData, VerticalLayout,
	Button, Dialog, DropdownBox, FormattedTextView, Image, Label, commonsLibrary,
	Link, TextView, SearchField, Splitter, Tree, TreeNode, AbsoluteLayout,
	DataSet, DataSetItem, DataSetSimpleView, NavigationItem, Shell, ToolPopup,
	FeedbackClient, library, Tag, TagCloud) {

	"use strict";

		var TextViewColor = commonsLibrary.TextViewColor,
			TextViewDesign = commonsLibrary.TextViewDesign,
			ViewType = coreLibrary.mvc.ViewType;

		var DemokitApp = function (sTitle, sVersion, aThemes) {

			var that = this;

			function basename(sPath) {
				return sPath.split('/').slice(0, -1).join('/') + '/';
			}

			// Calculate Application Base HRef and Pathname
			var sBaseUrl = window.location.href;
			if (sBaseUrl.indexOf('#') >= 0) {
				// remove the hash from the URL (otherwise the URL + hash is used as base URL)
				sBaseUrl = sBaseUrl.slice(0, sBaseUrl.indexOf('#'));
			}
			this.sBaseUrl = basename(sBaseUrl);
			this.sBasePathname = basename(window.location.pathname);
			this._iPendingCalls = 0;
			this._mBestMatchingPage = {};
			this._aTopLevelNavItems = [];
			this._aThemes = aThemes || ["sap_belize", "sap_belize_plus", "sap_belize_hcb", "sap_belize_hcw", "sap_bluecrystal", "sap_hcb"];
			this._sTheme = this._aThemes[0]; // 'aThemes' must contain at least one theme
			this._sCurrentContent = null;
			this._mAliases = {};
			this._bIgnoreIFrameOnLoad = false;

			// view state
			this._sTitleStr = sTitle;
			this._sVersionStr = sVersion;
			this._sSelectedWorkSetItem = null;

			// make this instance available statically
			DemokitApp.getInstance = jQuery.sap.getter(this);

			jQuery(window).bind('hashchange', function () {
				var sHash = window.location.hash;
				jQuery.sap.log.debug("hashchange occured, current='" + that._sCurrentContent + "', new='" + sHash + "'");
				if (sHash && sHash != "#" + that._sCurrentContent) {
					jQuery.sap.log.info("navigate to " + sHash);
					that.navigateTo(sHash, true);
				}
			});

		};

		DemokitApp.getInstance = function () {
			var oTopDemokit = jQuery.sap.getObject("top.sap.ui.demokit.DemokitApp");
			if (oTopDemokit && oTopDemokit != DemokitApp) {
				return oTopDemokit.getInstance();
			}
		};

		/**
		 * Checks whether the given URL references a page within the demokit app.
		 * If so, only the internal part of the path is returned, otherwise null.
		 */
		DemokitApp.prototype.calcRelativeUrl = function (sUrl) {
			return sUrl.indexOf(this.sBaseUrl) == 0 ? sUrl.substring(this.sBaseUrl.length) : null;
		};

		DemokitApp.prototype.registerPageForType = function (sUrl, aControls) {
			this._mBestMatchingPage[aControls[0]] = sUrl;
		};

		DemokitApp.prototype.findPageForType = function (sType) {
			return this._mBestMatchingPage[sType] || "docs/api/symbols/" + sType + ".html";
		};

		DemokitApp.prototype._addPendingCall = function () {
			this._iPendingCalls++;
		};

		DemokitApp.prototype._removePendingCall = function () {
			this._iPendingCalls--;
		};

		DemokitApp.prototype.addIndex = function (sId, oSettings) {
			oSettings = oSettings || {};

			var that = this;

			var oTLNItem = {
				id: "mi-" + sId,
				text: oSettings.caption || sId,
				newWindow: oSettings.newWindow,
				visible: (typeof oSettings.visible === "boolean") ? oSettings.visible : true,
				themable: oSettings.themable || false
			};
			this._aTopLevelNavItems.push(oTLNItem);
			this._createWorksetItem(oTLNItem);
			if (oSettings.index) {
				if (oSettings.extend) {
					oSettings.extend(oSettings.index, function (oData) {
						that._setIndexData(sId, oData);
					});
				} else {
					that._setIndexData(sId, oSettings.index);
				}
			} else if (oSettings.url) {
				this._loadIndexFromUrl(sId, oSettings.url, oSettings.transformer, oSettings.extend);
			}
		};

		DemokitApp.prototype._loadIndexFromUrl = function (sId, sUrl, fnTransformer, fnExtend) {
			var that = this;

			jQuery.ajax({
				url: sUrl,
				dataType: sUrl.slice(-4) == ".xml" ? "xml" : "json",
				error: function (xhr, status, e) {
					that._removePendingCall();
					jQuery.sap.log.error("failed to load index '" + sId + "' from '" + sUrl + "': " + status + ", " + e);
					var oTopLevelNavItem = that._findIndexById(sId);
					if (oTopLevelNavItem) {
						// TODO find better way to handle errors... NavigationItem unfortunately has no 'enabled'
						oTopLevelNavItem.navItem.setVisible(false);
					}
				},
				success: function (oData, sStatus, oXHR) {
					var oIndex = fnTransformer ? fnTransformer.call(this, oData) : oData;
					if (fnExtend) {
						fnExtend(oIndex, function (oData) {
							that._removePendingCall();
							that._setIndexData(sId, oData);
						});
					} else {
						that._removePendingCall();
						that._setIndexData(sId, oIndex);
					}
				}
			});
			this._addPendingCall();
		};

		DemokitApp.prototype._setIndexData = function (sId, oIndex) {
			var that = this,
			oTopLevelNavItem, iNodes;

			function processNode(oNode) {
				var i;

				iNodes++;
				if (oNode.ref && oNode.controls) {
					var aControls = jQuery.isArray(oNode.controls) ? oNode.controls : oNode.controls.split(/,/);
					that.registerPageForType(oNode.ref, aControls);
				}
				if (oNode.alias && oNode.ref) {
					var aAliases = oNode.alias.split(",");
					for (i = 0; i < aAliases.length; i++) {
						that._mAliases[aAliases[i]] = oNode.ref;
					}
				}
				if (oNode.links) {
					for (i = 0; i < oNode.links.length; i++) {
						processNode(oNode.links[i]);
					}
				}
			}

			oTopLevelNavItem = this._findIndexById(sId);
			if (oTopLevelNavItem) {
				oTopLevelNavItem.ref = oIndex.ref;
				oTopLevelNavItem.links = oIndex;

				iNodes = 0;

				processNode(oIndex);
				oTopLevelNavItem._iTreeSize = iNodes;
				this._createNavigationTree(oTopLevelNavItem);
				oTopLevelNavItem.navItem.setEnabled(!!oTopLevelNavItem._oTree);
				oTopLevelNavItem.navItem.setHref(oIndex.ref);
			}
		};

		DemokitApp.prototype._findIndexById = function (sId) {
			for (var i = 0; i < this._aTopLevelNavItems.length; i++) {
				var oTopLevelNavItem = this._aTopLevelNavItems[i];
				if (oTopLevelNavItem.id === "mi-" + sId) {
					return oTopLevelNavItem;
				}
			}
		};

		DemokitApp.prototype.getInitialPage = function (sDefaultPage, bSupportModuleSets) {

			var sInitialPage = sDefaultPage,
				sHash = window.location.hash,
				sModuleSet = jQuery.sap.getUriParameters().get("optimized-module-set");

			/**
			 * Checks whether the given URL is a valid relative URL within the current app
			 */
			function isRelativeUrl(sUrl) {
				return /^([a-zA-Z0-9-_]+\/)*[a-zA-Z0-9-_.]+\.(?:html|txt)(#.*)?$/.test(sUrl);
			}

			if (sHash) {
				sHash = sHash.indexOf("#") === 0 ? sHash.substring(1) : sHash;
				if (isRelativeUrl(sHash)) {
					sInitialPage = sHash;
				}
			}

			if (bSupportModuleSets && sModuleSet) {
				sInitialPage = "customize.html?data=" + sModuleSet;
			}

			return sInitialPage;
		};

		DemokitApp.prototype.getPagesForCategory = function (sCategory) {
			var oTopLevelNavItem = this._findIndexById("controls"); // TODO get rid of hard coded index id
			if (!oTopLevelNavItem || !oTopLevelNavItem.links) {
				return DemokitApp.RETRY_LATER;
			}
			var aPaths = sCategory.split('/');
			var o = oTopLevelNavItem.links;
			for (var i = 0; i < aPaths.length; i++) {
				var sPath = aPaths[i],
					j;
				for (j = 0; j < o.links.length; j++) {
					if (sPath == o.links[j].text) {
						break;
					}
				}
				if (j == o.links.length) {
					return [];
				}
				o = o.links[j];
			}
			return o.links || [];
		};

		DemokitApp.RETRY_LATER = -2;

		DemokitApp.prototype.findIndexForPage = function (sUrl) {

			function findURL(oNode, sUrl) {
				if (sUrl && oNode.ref && sUrl.indexOf(oNode.ref) === 0) {
					return true;
				}
				if (oNode.links) {
					for (var j = 0; j < oNode.links.length; j++) {
						if (findURL(oNode.links[j], sUrl)) {
							return true;
						}
					}
				}
				return false;
			}

			for (var i = 0; i < this._aTopLevelNavItems.length; i++) {
				if (this._aTopLevelNavItems[i].links && findURL(this._aTopLevelNavItems[i].links, sUrl)) {
					return i;
				}
			}

			if (this._aTopLevelNavItems.length === 0 || this._iPendingCalls > 0) {
				// either no indexes have been added yet or some of them are still pending
				return DemokitApp.RETRY_LATER;
			} else {
				jQuery.sap.log.error("could not find " + sUrl + " in nav tree");
				return -1;
			}
		};

		DemokitApp.DEFAULT_TLN_ITEM = 0;

		// ---- View ------------------------------------------------------

		DemokitApp.prototype._createNavigationTree = function (oTopLevelNavItem) {

			var that = this;
			var iNodes = 0;

			function selected(oEvent) {
				var aCustomData = oEvent.getSource().getCustomData();
				for (var i in aCustomData) {
					if (aCustomData[i].getKey() == "_ref_") {
						that.navigateTo(aCustomData[i].getValue());
					}
				}
			}

			function initTreeNodes(oTarget, aLinks, iLevel, parentName) {
				for (var i = 0; i < aLinks.length; i++) {
					var oCurrentTreeNode = {
						text: aLinks[i].text,
						tooltip: aLinks[i].tooltip,
						expanded: iLevel < 1,
						selectable: !!aLinks[i].ref,
						selected: selected
					};
					oCurrentTreeNode._ref_ = aLinks[i].ref;
					oCurrentTreeNode.parentName = (iLevel < 1) ? aLinks[i].text : parentName + "." + aLinks[i].text;

					oTarget.push(oCurrentTreeNode);
					iNodes++;

					if (aLinks[i].links && aLinks[i].links.length > 0) {
						oCurrentTreeNode.nodes = [];
						initTreeNodes(oCurrentTreeNode.nodes, aLinks[i].links, iLevel + 1, oCurrentTreeNode.parentName);
					}
				}
			}

			function collapseDevGuideTree(sTopLevelNavItemId, oTree) {
				if (sTopLevelNavItemId === "mi-devguidekm") {
					oTree.collapseAll();
					var aTreeNodes = oTree.getNodes();
					for (var i = 0; i < aTreeNodes.length; i++) {
						var aNodeCustomData = aTreeNodes[i].getCustomData();
						for (var p = 0; p < aNodeCustomData.length; p++) {
							// "95d113be50ae40d5b0b562b84d715227" is the guide id of "SAPUI5: UI Development Toolkit for HTML5" root node which should be expanded.
							if (aNodeCustomData[p].getKey() === "_ref_" && aNodeCustomData[p].getValue() && aNodeCustomData[p].getValue().indexOf("95d113be50ae40d5b0b562b84d715227") !== -1) {
								aTreeNodes[i].expand();
							}
						}
					}
				}
			}

			if (oTopLevelNavItem._oTree) {
				return;
			}

			var oTree = new Tree(oTopLevelNavItem.id + "-index", {
				showHeader: false,
				width: "100%",
				height: "100%",
				showHorizontalScrollbar: true,
				selectionMode: "Single"
			});
			oTree.addStyleClass("sapUiTreeWithHeader");
			var oTreeNode = new TreeNode({
				text: "{text}",
				tooltip: "{tooltip}",
				expanded: "{expanded}",
				selectable: "{selectable}",
				selected: selected
			});
			var oTreeNodeCustomDataRef = new CustomData({
				key: "_ref_",
				value: "{_ref_}"
			});
			oTreeNode.addCustomData(oTreeNodeCustomDataRef);

			var oTreeNodeCustomDataParent = new CustomData({
				key: "parentName",
				value: "{parentName}"
			});
			oTreeNode.addCustomData(oTreeNodeCustomDataParent);

			var aTreeData = [];
			initTreeNodes(aTreeData, oTopLevelNavItem.links.links, 0, "");

			var oJSONModel = new JSONModel();
			oJSONModel.setSizeLimit(iNodes);
			oTree.setModel(oJSONModel);
			oJSONModel.setData(aTreeData);
			oTree.bindNodes("/", oTreeNode);

			collapseDevGuideTree(oTopLevelNavItem.id, oTree);

			if (aTreeData.length > 25) {
				oTree.collapseAll();
			}

			oTopLevelNavItem._oTree = oTree;
			oTopLevelNavItem._iTreeSize = iNodes;
			oTopLevelNavItem._oEmptyTreeLabel = new Label({
				text: "No matching entry found.",
				visible: false,
				width: "100%",
				textAlign: "Center"
			});
		};

		DemokitApp.prototype._createWorksetItem = function (oTLNItem) {
			var oNavItem = oTLNItem.navItem = new NavigationItem({
				key: oTLNItem.id,
				text: oTLNItem.text,
				href: "#" + oTLNItem.ref,
				visible: oTLNItem.visible,
				enabled: false
			});
			oNavItem._itemData_ = oTLNItem;
			if (this._oShell) {
				this._oShell.addWorksetItem(oNavItem);
			}
		};

		DemokitApp.prototype.createUI = function (bSearchSupported, sInitialPage) {
			var bShowScrollBars;
			var that = this;
			var sIconPrefix = "theme/img/themeswitch_";
			var THEMES = DemokitApp.THEMES;

			this._oThemeSwitch = new DropdownBox({
				change: [this._handleThemeChanged, this],
				items: jQuery.map(this._aThemes, function (sThemeId) {
					return new ListItem({text: THEMES[sThemeId], key: sThemeId});
				}),
				value: THEMES[this._sTheme]
			});

			this._oThemeSwitchPopup = new ToolPopup({
				title: "Select a theme",
				icon: sIconPrefix + "regular.png", //TODO find a proper icon
				iconHover: sIconPrefix + "hover.png", //TODO find a proper icon
				iconSelected: sIconPrefix + "selected.png", //TODO find a proper icon
				content: [this._oThemeSwitch],
				initialFocus: this._oThemeSwitch
			});

			var oContent = new HTML("content", {
				content: "<iframe id=\"content\" name=\"content\" src=\"about:blank\" frameborder=\"0\" onload=\"sap.ui.demokit.DemokitApp.getInstance().onContentLoaded();\"></iframe>"
			});

			var oSidePanelLayout = this._oSidePanelLayout = new AbsoluteLayout();

			// TODO oSidePanelLayout.addContent(oDemokit._aTopLevelNavItems[0]._oTree, {top:"0", bottom:"0", left:"0", right:"0"});
			Device.os.name == Device.os.OS.IOS ? bShowScrollBars = true : bShowScrollBars = false;

			// Display a warning in the demokit header in case we have a dev version (either with "SNAPSHOT" in the version string or an odd minor version number)
			var oDevWarning;
			if (!this._sVersionStr
				|| (this._sVersionStr.indexOf("SNAPSHOT") > -1)
				|| (this._sVersionStr.split(".").length > 1 && parseInt(this._sVersionStr.split(".")[1], 10) % 2 === 1)) {
				oDevWarning = new TextView({
					text: "Development version! Work in Progress!",
					semanticColor: TextViewColor.Negative,
					design: TextViewDesign.Bold
				});
			}

			var oVersionInfoMainPage = new TextView({
			  text: this._sVersionStr,
			  tooltip: "Used SAPUI5 Version is " + this._sVersionStr
			});

			var oVersionInfoDialog = new TextView({
				text: this._sVersionStr,
				tooltip: "SAPUI5 Version"
			  });

			var fnCreateAboutDialogContent = function() {
				 var oDialog;
				 var renderedDialog = sap.ui.getCore().byId('aboutDlg');
				 var oLayout;

				 if (renderedDialog instanceof Dialog) {
					 oDialog = renderedDialog;
					 oDialog.open();
					 return;
				 }

				var oBtnBack = new Button({
					text : "Back",
					visible : false,
					press : function() {
						fnShowMainContent();
					}
				});

				var oBtnCancel = new Button({
					text : "Close",
					press : function() {
						oDialog.close();
					}
				});

				var fnShowMainContent = function () {
					oDialog.removeAllContent();
					oDialog.addContent(oLayout);
					oBtnBack.setVisible(false);
				};

				var oSAPUI5Logo = new Image();
				var sAboutDialogContentHtml;

				//check if it is internal or external version of Demokit and set the dialog content according to it
				var oVersionInfo = sap.ui.getVersionInfo();
				if (oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav) ) {
					oSAPUI5Logo.setSrc("resources/sap/ui/demokit/themes/base/images/OpenUI5_new_small_size.png");
					oSAPUI5Logo.setTooltip("OpenUI5 logo blue");
					oSAPUI5Logo.setWidth("446px");
					oSAPUI5Logo.addStyleClass("extraLeftPadding");

					sAboutDialogContentHtml  = '<h2>OpenUI5 - Demo Kit</h2>';
					sAboutDialogContentHtml += '<span>&copy; 2009-2017 SAP SE or an SAP affiliate company.</span><br>';
					sAboutDialogContentHtml += '<span>Licensed under the Apache License, Version 2.0 – <embed data-index="3"><br><br><br></span>';
					sAboutDialogContentHtml += '<span>OpenUI5 Version <embed data-index="0"></span><br>';
				} else {
					oSAPUI5Logo.setSrc("resources/sap/ui/demokit/themes/base/images/logo-SAPUI5-blue-446x140.png");
					oSAPUI5Logo.setTooltip("SAPUI5 logo blue");
					oSAPUI5Logo.addStyleClass("extraLeftPadding");

					sAboutDialogContentHtml  = '<h2>SAP UI Development Toolkit for HTML5 (SAPUI5) - Demo Kit</h2>';
					sAboutDialogContentHtml += '<span>&copy; Copyright 2009-2017 SAP SE. All rights reserved.</span><br><br><br>';
					sAboutDialogContentHtml += '<span>SAPUI5 Version <embed data-index="0"></span><br>';
				}

				sAboutDialogContentHtml += '<span>This software includes the following library versions</span><br>';
				sAboutDialogContentHtml += '<span>(a full change log for all libraries can be found <embed data-index="1">).</span><br>';
				sAboutDialogContentHtml += '<embed data-index="2"><br><br><br>';

				var sAboutDialogContentHtmlOnlyForUI5 = '<span>This software includes third-party open source software.</span><br>';
				sAboutDialogContentHtmlOnlyForUI5 += '<embed data-index="0"><br>';

				var oLinkToVersionChangeLog = new Link({
					text : "here",
					tooltip: "Go to Version Change Log",
					press: function() {
						oDialog.close();
					},
					href: "releasenotes.html",
					target: "content"
				});

				var oLinkToVersionInfo = new Link({
					text : "Version Details",
					tooltip: "Go to Version Details",
					press: function() {
						oDialog.removeAllContent();
						oDialog.addContent(fnParseLibInformationVersionInfo());

						oBtnBack.setVisible(true);
					}
				});

				var oLinkToCredits = new Link({
					text : "Included Third-Party Software",
					tooltip: "Go to Included Third-Party Software list",
					press: function() {
						oDialog.removeAllContent();
						oDialog.addContent(fnParseLibInformationCredits());

						oBtnBack.setVisible(true);
					}
				});

				var oLinkToLicenseTxt = new Link({
					text : "see LICENSE.txt",
					tooltip: "Go to LICENSE.txt",
					press: function() {
						oDialog.close();
					},
					href: "LICENSE.txt",
					target: "content"
				});

				var oDialogInitialPageContent = new FormattedTextView();
				oDialogInitialPageContent.setContent(sAboutDialogContentHtml, [oVersionInfoDialog, oLinkToVersionChangeLog, oLinkToVersionInfo, oLinkToLicenseTxt]);
				oDialogInitialPageContent.addStyleClass("extraLeftPadding");

				var oDialogInitialPageContentOnlyForUI5 = new FormattedTextView();
				oDialogInitialPageContentOnlyForUI5.setContent(sAboutDialogContentHtmlOnlyForUI5, [oLinkToCredits]);
				oDialogInitialPageContentOnlyForUI5.addStyleClass("extraLeftPadding");

				//check if it is internal or external version of Demokit and set the dialog content according to it
				if ( oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav) ) {
					oLayout = new VerticalLayout({
						content : [oSAPUI5Logo, oDialogInitialPageContent]
					});
				} else {
					oLayout = new VerticalLayout({
						content : [oSAPUI5Logo, oDialogInitialPageContent, oDialogInitialPageContentOnlyForUI5]
					});
				}

				oDialog = new Dialog('aboutDlg', {
					title: "About",
					modal: true,
					buttons : [oBtnBack, oBtnCancel],
					content: [oLayout],
					showCloseButton: false,
					width: "550px",
					height: "800px",
					maxHeight: "100%"
				});

				oDialog.attachClosed(fnShowMainContent);

				oDialog.open();
			};

			var fnParseLibInformationVersionInfo = function() {
				jQuery.sap.registerModulePath("versioninfo", "./versioninfo/");
				var oModelVersionInfo = new JSONModel();

				library._loadAllLibInfo("", "_getLibraryInfo","", function(aLibs, oLibInfos){
					var data = {};
					var oLibInfo = new LibraryInfo();

					for (var i = 0, l = aLibs.length; i < l; i++) {
						aLibs[i] = oLibInfos[aLibs[i]];
						aLibs[i].libDefaultComponent = oLibInfo._getDefaultComponent(aLibs[i]);
					}
					data.libs = aLibs;
					oModelVersionInfo.setData(data);
				});

				var fnOpenReleaseDialog = function openReleaseDialog() {

					var oNotesModel;
					var oText;
					var oNotesView = sap.ui.getCore().byId("notesView");
					var oNotesDialog = sap.ui.getCore().byId("notesDialog");
					if (!oNotesDialog) {
						oText = new TextView({text: "No changes for this library!", id: "noRelNote"});
						oNotesView = sap.ui.view({id:"notesView", viewName:"versioninfo.notes", type:ViewType.Template});
						oNotesModel = new JSONModel();
						oNotesView.setModel(oNotesModel);
						oNotesDialog = new Dialog("notesDialog");
						oNotesDialog.addButton(new Button({
							text: "OK",
							press: function(){
								oNotesDialog.close();
							}
						}));
						oNotesDialog.setModal(true);
						oNotesDialog.setHeight("40%");
						oNotesDialog.setWidth("40%");
						oNotesView.addStyleClass("myReleaseNotes");
						oNotesDialog.setResizable(true);
					}

					var oLibInfo = new LibraryInfo();
					oNotesDialog.setTitle("Change log for: " + this.getBindingContext().getProperty("library"));

					var oVersion = jQuery.sap.Version(this.getBindingContext().getProperty("version"));
					var sVersion = oVersion.getMajor() + "." + oVersion.getMinor() + "." + oVersion.getPatch() + oVersion.getSuffix();

					oLibInfo._getReleaseNotes(this.getBindingContext().getProperty("library"), sVersion, function(oRelNotes, sVersion) {
						oNotesDialog.removeAllContent();

						if (oRelNotes && oRelNotes[sVersion] && oRelNotes[sVersion].notes && oRelNotes[sVersion].notes.length > 0) {
							oNotesDialog.addContent(oNotesView);
							oNotesView.getModel().setData(oRelNotes);
							oNotesView.bindObject("/" + sVersion);
							oNotesDialog.open();
						} else {

						if (oText) {
							oNotesDialog.addContent(oText);
						} else {
							oNotesDialog.addContent(sap.ui.getCore().byId("noRelNote"));
						}
							oNotesDialog.open();
						}

					});
				};

				var oDataSetVersionInfo = new DataSet({
					items : {
						path : "/libs",
						template : new DataSetItem({
							title : "{library}"
						})
					},
					views : [ new DataSetSimpleView({
						floating : false,
						template : new Form({
							title : new Title({text : "{library}"}),
							width : "100%",
							layout : new GridLayout(),
							formContainers : [ new FormContainer({
								formElements : [
									new FormElement({
										label : new Label({text : "Version:", layoutData : new GridElementData({hCells : "3"})}),
										fields : [ new TextView({text : "{version}"})]
									}),
									/*new FormElement({
										label : new Label({text : "Vendor:", layoutData : new GridElementData({hCells : "3"})}),
										fields : [ new sap.ui.commons.TextView({text : "{vendor}"})]
									}),*/
									new FormElement({
										label : new Label({text : "Description:", layoutData : new GridElementData({hCells : "3"})}),
										fields : [ new TextView({text : "{documentation}"})]
									}),
									new FormElement({
										label : new Label({text : "Change Log:", layoutData : new GridElementData({hCells : "3"})}),
										fields : [ new Link({text : "Open Change Log", press : fnOpenReleaseDialog})],
										visible : {
											path: "releasenotes",
											formatter: function(oValue) {
												return !!oValue;
											}
										}
									}),
									new FormElement({
										label : new Label({text : "Component:", layoutData : new GridElementData({hCells : "3"})}),
										fields : [ new TextView({text : "{libDefaultComponent}"})],
										visible : {
											path: "libDefaultComponent",
											formatter: function(oValue) {
												return !!oValue;
											}
										}
									})
								]
							})]
						})
					})],
					showToolbar: false,
					selectionChanged: function(){
						oDataSetVersionInfo.setLeadSelection(-1);
					}
				});

				oDataSetVersionInfo.setModel(oModelVersionInfo);

				var oLayoutVersionInfo = new VerticalLayout({
					content : [oDataSetVersionInfo]
				});

				return oLayoutVersionInfo;
			};

			var fnParseLibInformationCredits = function() {
				var oModelCredits = new JSONModel();

				library._loadAllLibInfo("", "_getThirdPartyInfo", function(aLibs, oLibInfos){
					if (!aLibs){
						return;
					}
					var data = {};
					data.thirdparty = [];
					for (var j = 0; j < aLibs.length; j++) {
						var oData = oLibInfos[aLibs[j]];
						for (var i = 0; i < oData.libs.length; i++) {
							var oOpenSourceLib = oData.libs[i];
							oOpenSourceLib._lib = aLibs[j];
							data.thirdparty.push(oOpenSourceLib);
						}
					}

					data.thirdparty.sort(function(a,b){
						var aName = (a.displayName || "").toUpperCase();
						var bName = (b.displayName || "").toUpperCase();

						if (aName > bName){
							return 1;
						} else if (aName < bName){
							return -1;
						} else {
							return 0;
						}
					});

					oModelCredits.setData(data);
				});

				var oDataSetCredits = new DataSet({
					items : {
						path : "/thirdparty",
						template : new DataSetItem({
							title : "{displayName}"
						})
					},
					views : [ new DataSetSimpleView({
						floating : false,
						template : new Form({
							title : new Title({text : "{displayName}"}),
							width : "100%",
							layout : new GridLayout(),
							formContainers : [ new FormContainer({
								formElements : [
									new FormElement({
										fields : [
											new Link({text : "Web Site", target : "_blank", href : "{homepage}",layoutData: new GridElementData({hCells: "auto"})}),
											new Link({text : "License Conditions", target : "_blank", href : "{license/url}",layoutData: new GridElementData({hCells: "5"})})
										]
									}),

									new FormElement({
										fields : [
											new Link({text : "Licensed by SAP under '{license/type}'", target : "_blank", href : "{license/file}"})
										]
									})
								]
							})]
						})
					})],
					//end old
					showToolbar: false,
					selectionChanged: function(){
						oModelCredits.setLeadSelection(-1);
					}
				});

				var sDebug = jQuery.sap.getUriParameters().get("sap-ui-debug");
				if (sDebug === "x" || sDebug === "X" || sDebug === "true"){
					oModelCredits.getViews()[0].getTemplate().getFormContainers()[0].addFormElement(new FormElement({
						label : new Label({text : "Requested by UI Library:", layoutData : new GridElementData({hCells : "3"})}),
						fields : [ new TextView({text : "{_lib}"})]
					}));
				}

				oDataSetCredits.setModel(oModelCredits);

				var oLayoutCredits = new VerticalLayout({
					content : [oDataSetCredits]
				});

				return oLayoutCredits;
			};

			var oAboutDialogLink = new Link({
				text : "About",
				tooltip: "About",
				press : function() {
					 fnCreateAboutDialogContent();
				}
			});

			this._oFeedbackClient = new FeedbackClient();
			this._oFeedbackPopup = this._oFeedbackClient.createFeedbackPopup();

			var oShell = this._oShell = new Shell({
				appTitle: this._sTitleStr,
				showLogoutButton: false,
				showFeederTool: false,
				applyContentPadding: false,
				showSearchTool: bSearchSupported,
				fullHeightContent: true,
				toolPopups: [this._oFeedbackPopup, this._oThemeSwitchPopup],
				search: function (oEvent) {
					that.navigateTo("search.html?q=" + encodeURIComponent(oEvent.getParameter("text")));
					that._oShell._getSearchTool().close();
				},
				worksetItemSelected: function (oEvent) {
					var oNavItem = oEvent.getParameter("item");
					if (oNavItem.getEnabled()) {
						var oItem = oNavItem._itemData_;
						// skip update of shell for new windows
						if (oItem.newWindow) {
							oEvent.preventDefault();
						}
						// navigate to the default reference
						that.navigateTo(oItem.ref, null, null, oItem.newWindow);
					} else {
						oEvent.preventDefault();
					}
				},
				content: [
					new Splitter("demokitSplitter", {
						width: "100%",
						height: "100%",
						splitterPosition: "0%",
						splitterBarVisible: false,
						firstPaneContent: [oSidePanelLayout],
						secondPaneContent: [oContent],
						showScrollBars: bShowScrollBars
					})
				],
				headerItems: oDevWarning ? [oAboutDialogLink, oDevWarning, oVersionInfoMainPage] : [oAboutDialogLink, oVersionInfoMainPage]
			});

			this._oShell.addStyleClass("sapDkShell");

			function addTagCloud(aKeywords) {

				var oTagCloud = new TagCloud({
					minFontSize: 15,
					maxFontSize: 30,
					press: function (oEvent) {
						var term = sap.ui.getCore().byId(oEvent.getParameter("tagId")).getText();
						oShell.fireSearch({text: term});
					}
				}).addStyleClass("grTagCloud");
				for (var i = 0; i < aKeywords.length; i++) {
					oTagCloud.addTag(new Tag({text: aKeywords[i].tag, weight: aKeywords[i].score}));
				}

				// enhance the original search tool
				oShell._getSearchTool && oShell._getSearchTool().addContent(oTagCloud);
			}

			if (bSearchSupported) {

				var oSearchField = oShell.getSearchField();
				oSearchField.setEnableListSuggest(true);
				oSearchField.setShowListExpander(false);
				oSearchField.setVisibleItemCount(5);
				oSearchField.setSearchProvider(new OpenSearchProvider({
					suggestType: "json",
					suggestUrl: "suggest?q={searchTerms}"
				}));

				// request top keywords
				jQuery.ajax({
					url: "keywords?kind=tags&max=50",
					dataType: "json",
					success: function (data, status, xhr) {
						if (data && data[0] && data[0].success && data[0].keywords && data[0].keywords.length) {
							addTagCloud(data[0].keywords);
							oSearchField.setWidth("80%");
						}
					}
				});

			}

			jQuery.each(this._aTopLevelNavItems, function (i, oTLNItem) {
				oShell.addWorksetItem(oTLNItem.navItem);
			});

			this.navigateTo(sInitialPage);

			sap.ui.getCore().addPrerenderingTask(function () {
				jQuery("body").append("<div id=\"logo\"><img id=\"logoico\"><img id=\"logotxt\"></div>");
			  //check if it is internal or external version of Demokit and set the dialog content according to it
				var oVersionInfo = sap.ui.getVersionInfo();
				if (oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav) ) {
					jQuery("#logoico").attr("src", "resources/sap/ui/demokit/themes/base/images/OpenUI5_new_small_size.png").addClass("sapUiImg");
				} else {
					jQuery("#logoico").attr("src", "resources/sap/ui/core/mimes/logo/icotxt_white_220x72_blue.png").addClass("sapUiImg");
				}
				//jQuery("#logotxt").attr("src", "resources/sap/ui/core/mimes/logo/txtonly_32x32.png").addClass("sapUiImg");
			});
		};

		DemokitApp.prototype.placeAt = function (sId) {
			this._oShell.placeAt(sId);
		};

		// ---- controller ----------------------------------------------------

		// Listen to IFrame load
		DemokitApp.prototype.onContentLoaded = function (e) {

			var that = this;
			var oContentWindow = jQuery("#content")[0].contentWindow;
			var sIFrameContent = this.calcRelativeUrl(oContentWindow.location.href);
			if (sIFrameContent && !this._bIgnoreIFrameOnLoad) {
				this.navigateTo(sIFrameContent, true, true);
				window.location.replace("#" + sIFrameContent);
			}
			this._applyTheme();
			this._bIgnoreIFrameOnLoad = false;

			jQuery(oContentWindow).bind("hashchange", function () {
				var sIFrameContent = that.calcRelativeUrl(oContentWindow.location.href);
				if (sIFrameContent && !that._bIgnoreIFrameOnLoad) {
					that.navigateTo(sIFrameContent, true, true);
					window.location.hash = sIFrameContent;
				}
				that._bIgnoreIFrameOnLoad = false;
			});

		};


		DemokitApp.prototype.navigateTo = function (sName, bSkipSetHash, bSkipSwitchLocation, bNewWindow) {
			var that = this;
			var TREE_ABSOLUTE_LOCATION_LEFT = "0px";
			// TREE_ABSOLUTE_LOCATION_TOP should be keeped in sync with .sapUiTreeWithHeader > div:first-child bottom property
			var TREE_ABSOLUTE_LOCATION_TOP = "32px";
			var TREE_EXPAND_BUTTON_LOCATION_RIGHT = "30px";
			var TREE_COLLAPSE_BUTTON_LOCATION_RIGHT = "0px";
			var TREE_BUTTONS_LOCATION_TOP = "0px";

			// normalize page name (from hash)
			var sPageName = sName.indexOf("#") === 0 ? sName.substring(1) : sName;
			// resolve aliases
			var sResolvedPageName = this._mAliases[sPageName];
			if (sResolvedPageName && sPageName != sResolvedPageName) {
				bSkipSwitchLocation = false;
				sPageName = sResolvedPageName;
			}

			if (this._sCurrentContent == sPageName) {
				return;
			}

			var oContent = jQuery("#content")[0];
			var oContentWindow = oContent && oContent.contentWindow;
			var topNavIdx = this.findIndexForPage(sPageName);

			// open in new window and do nothing else
			if (bNewWindow) {
				window.open(sPageName, "_blank");
				return;
			}

			// postpone navigation if either rendering did not happen yet or indexes are not yet loaded
			if (!oContentWindow || topNavIdx === DemokitApp.RETRY_LATER) {
				setTimeout(function () {
					that.navigateTo(sPageName, bSkipSetHash, bSkipSwitchLocation);
				}, 200);
				return;
			}

			var oNewTLNItem = this._aTopLevelNavItems[topNavIdx >= 0 ? topNavIdx : 0];
			var oShell = this._oShell;
			var oSplitter = sap.ui.getCore().byId("demokitSplitter");
			var sOldPos;
			if (oNewTLNItem && oNewTLNItem._iTreeSize <= 1) {
				if (oSplitter.getSplitterBarVisible()) {
					sOldPos = oSplitter.getSplitterPosition();
					if (sOldPos !== "0%") {
						oSplitter._oldPos = sOldPos;
						oSplitter.setSplitterPosition("0%");
					}
					oSplitter.setSplitterBarVisible(false);
				}
			} else if (!oSplitter.getSplitterBarVisible()) {
				sOldPos = oSplitter._oldPos || "20%";
				oSplitter.setSplitterPosition(sOldPos);
				oSplitter.setSplitterBarVisible(true);
			}

			this._sCurrentContent = sPageName;

			function findAndSelectTreeNode(sPageName, oParent, bClearSelection) {
				if (oParent) {
					if (bClearSelection && oParent.getSelectedNode && oParent.getSelectedNode()) {
						oParent.getSelectedNode().setIsSelected(false);
					}
					var aNodes = oParent.getNodes();
					for (var i = 0; i < aNodes.length; i++) {
						var aCustomData = aNodes[i].getCustomData();
						var bTreeNodeFound = false;
						for (var j in aCustomData) {
							if (aCustomData[j].getKey() == "_ref_" && aCustomData[j].getValue() && aCustomData[j].getValue().indexOf(sPageName) >= 0) {
								bTreeNodeFound = true;
								break;
							}
						}

						if (bTreeNodeFound) {
							var par = oParent;
							while (par instanceof TreeNode) {
								par.expand();
								par = par.getParent();
							}
							aNodes[i].setIsSelected(true);
							return aNodes[i];
						} else {
							var node = findAndSelectTreeNode(sPageName, aNodes[i], false);
							if (node) {
								return node;
							}
						}
					}
				}
				return null;
			}

			function createTreeFilter(oTree, oEmptyLabel) {
				var updateTree = function (oTree, sFilter, oEmptyLabel) {
					var filters = [];
					var nameFilter = new Filter("parentName", FilterOperator.Contains, sFilter);
					filters.push(nameFilter);
					var binding = oTree.getBinding("nodes");
					binding.filter(filters);
					if (sFilter !== "") {
						oTree.expandAll();
					}
					var bNoNodes = (oTree.getNodes().length === 0);
					oTree.setVisible(!bNoNodes);
					oEmptyLabel.setVisible(bNoNodes);

				};

				var oSearch = new SearchField({
					enableListSuggest: false,
					enableClear: true,
					enableFilterMode: true,
					startSuggestion: 0,
					suggest: function (oEvent) {
						updateTree(oTree, oEvent.getParameter("value"), oEmptyLabel);
					}
				});

				oSearch.addEventDelegate({
					onAfterRendering: function () {
						oSearch._ctrl.$("searchico").addClass('sapUiIcon sapUiSearchFieldFilterIcon');
						oSearch._ctrl.$("searchico").attr('style', 'font-family: SAP-icons; cursor: default;');
						oSearch._ctrl.$("searchico").attr('data-sap-ui-icon-content', '');
					}
				});

				oSearch._ctrl.setPlaceholder("Filter");

				oSearch.addStyleClass("sapUiDemokitAbsLayoutFirtsRow sapUiDemokitSearchField");
				return oSearch;
			}

			function createTreeButtons(oTree, fTreeAction, sIcon, sTooltip, sStyle) {
				var oButton = new Button({
					lite: true,
					icon : sIcon,
					press : fTreeAction.bind(oTree)
				});
				oButton.addStyleClass("sapUiDemokitExpandCollapseButtons sapUiDemokitAbsLayoutFirtsRow");
				if (sStyle) {
					oButton.addStyleClass(sStyle);
				}
				oButton.setTooltip(sTooltip);

				oButton.addEventDelegate({
					onAfterRendering: function () {
						oButton.$("icon").attr("title", sTooltip);
						oButton.$("icon").attr("aria-label", sTooltip);
					}
				});

				return oButton;
			}

			function createCollapseButton(oTree) {
				return createTreeButtons(oTree, oTree.collapseAll, "sap-icon://collapse-group", "Collapse All", "sapUiDemokitCollapseButton");
			}

			function createExpandButton(oTree) {
				return createTreeButtons(oTree, oTree.expandAll, "sap-icon://expand-group", "Expand All");
			}

			//Update Top Level Navigation and Navigation Tree
			var oSelectedNavEntry = null;
			var oNewNavItem = oNewTLNItem && oNewTLNItem.navItem;
			if (oNewNavItem && this._sSelectedWorkSetItem != oNewNavItem.getId()) {
				oNewNavItem.setVisible(true);
				oShell.setSelectedWorksetItem(oNewNavItem);
				this._oSidePanelLayout.removeAllContent();
				if (oNewTLNItem._oTree) {
					this._oSidePanelLayout.addContent(createTreeFilter(oNewTLNItem._oTree, oNewTLNItem._oEmptyTreeLabel));
					this._oSidePanelLayout.addContent(createCollapseButton(oNewTLNItem._oTree), {
						right: TREE_COLLAPSE_BUTTON_LOCATION_RIGHT,
						top: TREE_BUTTONS_LOCATION_TOP
					});
					this._oSidePanelLayout.addContent(createExpandButton(oNewTLNItem._oTree), {
						right: TREE_EXPAND_BUTTON_LOCATION_RIGHT,
						top: TREE_BUTTONS_LOCATION_TOP
					});
					this._oSidePanelLayout.addContent(oNewTLNItem._oTree, {
						left: TREE_ABSOLUTE_LOCATION_LEFT,
						top: TREE_ABSOLUTE_LOCATION_TOP
					});
					this._oSidePanelLayout.addContent(oNewTLNItem._oEmptyTreeLabel, {
						left: TREE_ABSOLUTE_LOCATION_LEFT,
						top: TREE_ABSOLUTE_LOCATION_TOP
					});
				}

				oSelectedNavEntry = findAndSelectTreeNode(sPageName, oNewTLNItem._oTree, true);

				if (oNewTLNItem.themable && oShell.indexOfToolPopup(this._oThemeSwitchPopup) == -1 ) {
					oShell.addToolPopup(this._oThemeSwitchPopup);
				} else if ((!oNewTLNItem.themable) && oShell.indexOfToolPopup(this._oThemeSwitchPopup) != -1) {
					oShell.removeToolPopup(this._oThemeSwitchPopup);
				}

			} else {
				var aSidePanelContent = this._oSidePanelLayout.getContent();
				var oTree;
				for (var i in aSidePanelContent) {
					if (aSidePanelContent[i].getId().indexOf("index") > -1) {
						oTree = aSidePanelContent[i];
					}
				}
				oSelectedNavEntry = findAndSelectTreeNode(sPageName, oTree, true);
				//If no entry is found, try again without hash
				if (!oSelectedNavEntry && sPageName.indexOf("#") > 0) {
					var sShortName = sPageName.substr(0, sPageName.indexOf("#") - 1);
					oSelectedNavEntry = findAndSelectTreeNode(sShortName, oTree);
				}
			}

			sap.ui.getCore().applyChanges();
			this._sSelectedWorkSetItem = oShell.getSelectedWorksetItem();

			// Update IFrame content and URL hash
			if (!bSkipSetHash) {
				window.location.hash = sPageName;
			}

			if (!bSkipSwitchLocation) {

				this._bIgnoreIFrameOnLoad = true;

				// set fakeOS for mobile test pages (BUT not for mobile demo apps)
				var isMobilePage = sPageName && sPageName.match(/\/sap\/me?\//);
				var isMobileDemoApp = sPageName && sPageName.indexOf("sap/m/demokit") !== -1;
				var sFakeOS = (isMobilePage && !isMobileDemoApp) ? "?sap-ui-xx-fakeOS=ios" : "";

				oContentWindow.location.replace((sPageName.indexOf("/") == 0 ? "" : this.sBasePathname) + sPageName + sFakeOS);
			}

			this._oFeedbackClient.updateFeedbackContextText();
		};

		DemokitApp.THEMES = {
			"sap_bluecrystal": "Blue Crystal",
			"sap_belize": "Belize",
			"sap_belize_plus": "Belize Plus",
			"sap_belize_hcb": "Belize High Contrast Black",
			"sap_belize_hcw": "Belize High Contrast White",
			"sap_hcb": "High Contrast Black"
		};

		DemokitApp.prototype._handleThemeChanged = function (oEvent) {
			var newTheme = oEvent.getParameter("newValue");
			for (var x in DemokitApp.THEMES) {
				if (DemokitApp.THEMES[x] == newTheme) {
					this._sTheme = x;
					this._applyTheme();
					oEvent.getSource().getParent().close();
					break;
				}
			}
		};

		DemokitApp.prototype._applyTheme = function () {
			var oContentWindow = jQuery("#content")[0].contentWindow;
			var sIFrameContent = this.calcRelativeUrl(oContentWindow.location.href);
			var topNavIdx = sIFrameContent ? this.findIndexForPage(sIFrameContent) : -1;

			if (sIFrameContent
				&& topNavIdx >= 0 && this._aTopLevelNavItems[topNavIdx].themable
				&& oContentWindow
				&& oContentWindow.sap
				&& oContentWindow.sap.ui
				&& oContentWindow.sap.ui.getCore) {

				//Find supported themes
				var isMobilePage = sIFrameContent.match(/\/sap\/me?\//);
				var aMySupportedThemes = isMobilePage ? ["sap_bluecrystal", "sap_belize", "sap_belize_plus", "sap_belize_hcb", "sap_belize_hcw"] : this._aThemes;
				var aSupportedThemes = oContentWindow.sap.ui.demokit && oContentWindow.sap.ui.demokit._supportedThemes ? oContentWindow.sap.ui.demokit._supportedThemes : aMySupportedThemes;

				//Update theme switch
				var aItems = this._oThemeSwitch.getItems();
				for (var i = 0; i < aItems.length; i++) {
					aItems[i].setEnabled(jQuery.inArray(aItems[i].getKey(), aSupportedThemes) >= 0);
				}

				//Current theme is not supported -> Use a different one
				if (jQuery.inArray(this._sTheme, aSupportedThemes) < 0) {
					this._sTheme = aSupportedThemes[0];
					this._oThemeSwitch.setValue(DemokitApp.THEMES[this._sTheme]);
				}

				oContentWindow.sap.ui.getCore().applyTheme(this._sTheme);
			}
		};

		(function () {

			function resolve(oLink, sLibUrl) {
				if (oLink.ref && oLink.resolve === "lib") {
					oLink.ref = sLibUrl + oLink.ref;
				}
				if (oLink.links) {
					for (var i = 0; i < oLink.links.length; i++) {
						resolve(oLink.links[i], sLibUrl);
					}
				}
			}

			function merge(oNode1, oNode2) {
				if (oNode1.key != oNode2.key || !oNode2.links || oNode2.links.length == 0) {
					return;
				}
				if (!oNode1.links) {
					oNode1.links = oNode2.links;
					return;
				}

				function findNodeWithKey(oNode, key) {
					for (var j = 0; j < oNode.links.length; j++) {
						if (oNode.links[j].key === key) {
							return oNode.links[j];
						}
					}
					return null;
				}

				var oSubNode;

				for (var i = 0; i < oNode2.links.length; i++) {
					oSubNode = oNode2.links[i];
					if (!oSubNode.key) {
						oNode1.links.push(oSubNode);
					} else {
						var oNode = findNodeWithKey(oNode1, oSubNode.key);
						if (oNode) {
							merge(oNode, oSubNode);
						} else {
							oNode1.links.push(oSubNode);
						}
					}
				}
			}

			function finalize(oIndexData, fnCallback, aLibs, oDocIndices) {
				for (var j = 0; j < aLibs.length; j++) {
					var oData = oDocIndices[aLibs[j]];
					if (oData && oData.docu) {
						resolve(oData.docu, oData.libraryUrl);
						merge(oIndexData, oData.docu);
					}
				}

				fnCallback(oIndexData);
			}

			DemokitApp.addReleaseNotesToDevGuide = function (oIndexData, sUrl, sTitle, iLevel) {
				if (!sUrl) {
					sUrl = "releasenotes.html";
				}
				if (!sTitle) {
					sTitle = "Release Notes";
				}
				if (!iLevel) {
					iLevel = 1;
				}

				function firstChild(node) {
					if (node && node.links && node.links.length > 0) {
						return node.links[0];
					}
					return null;
				}

				var oIndex = oIndexData;
				for (var i = 0; i < iLevel; i++) {
					oIndex = firstChild(oIndex);
				}

				if (oIndex) {
					oIndex.links = oIndex.links || [];
					oIndex.links.push({ref: sUrl, text: sTitle, alias: "releasenotes.html"});
				}

				return oIndexData;
			};

			DemokitApp.extendDevGuide = function (oIndexData, fnCallback) {
				var libInfo = new LibraryInfo();
				var sUrl = "discovery/all_libs";

				jQuery.ajax({
					url: sUrl,
					dataType: "json",
					error: function (xhr, status, e) {
						jQuery.sap.log.error("failed to load library list from '" + sUrl + "': " + status + ", " + e);
						fnCallback(oIndexData);
					},
					success: function (oData, sStatus, oXHR) {
						var libs = oData["all_libs"];
						if (!libs) {
							jQuery.sap.log.error("failed to load library list from '" + sUrl + "': " + sStatus + ", Data: " + libs);
							fnCallback(oIndexData);
							return;
						}

						var count = 0,
							len = libs.length,
							oDocIndices = {},
							aLibs = [],
							libName;
						for (var i = 0; i < len; i++) {
							libName = libs[i].entry.replace(/\//g, ".");
							aLibs.push(libName);
							/*eslint-disable no-loop-func */
							libInfo._getDocuIndex(libName, function (oExtensionData) {
								oDocIndices[oExtensionData.library] = oExtensionData;
								count++;
								if (count == len) {
									finalize(oIndexData, fnCallback, aLibs, oDocIndices);
								}
							});
							/*eslint-enable no-loop-func */
						}
					}
				});
			};

		})();


		return DemokitApp;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/DemokitApp.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.IndexPage') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
// Provides a pseudo control for index pages within the Demokit
jQuery.sap.declare('sap.ui.demokit.IndexPage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.commons.RichTooltip'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/IndexPage",['jquery.sap.global', 'sap/ui/commons/RichTooltip', './DemokitApp', './HexagonButton', './HexagonButtonGroup'],
	function(jQuery, RichTooltip, DemokitApp, HexagonButton, HexagonButtonGroup) {
	"use strict";


	var IndexPage = function(sCategory) {
		var oDemokit = DemokitApp.getInstance(),
			iHierarchyLevel = 3,
			iCols;

		function suffix(s,n) {
			return s.split('/').slice(-n - 1).join('/');
		}

		this.oDemokit = oDemokit;
		this.sPathToRoot = suffix("../../../../../../../", iHierarchyLevel);
		this.sRootUrl = window.location.pathname.split('/').slice(-iHierarchyLevel - 1, -1).join('/') + '/';
		this.sColor = "Blue";
		this.oHexGroup = new HexagonButtonGroup({colspan: (iCols || 5)});
		if ( sCategory && oDemokit ) {
			var aPages = oDemokit.getPagesForCategory(sCategory);
			for (var i = 0; i < aPages.length; i++) {
				this.add(true, aPages[i].text, '', this.sPathToRoot + aPages[i].ico, undefined, aPages[i].ref);
			}
		}
	};

	IndexPage.prototype.add = function add(bEnabled, sControl, sTooltip, sIcon, sLibrary, sRef) {

		var that = this,
			oButton;

		if ( typeof bEnabled !== "boolean" ) {
			sRef = sLibrary;
			sLibrary = sIcon;
			sIcon = sTooltip;
			sTooltip = sControl;
			sControl = bEnabled;
			bEnabled = true;
		}

		sRef = sRef || this.sRootUrl + sControl + '.html';
		if ( !sLibrary ) {
			sLibrary = "sap.ui.commons";
		}

		if ( !sTooltip ) {
			if ( bEnabled ) {
				sTooltip = "A short tutorial that explains how to use the " + sControl + ". Click to start it.";
			} else {
				sTooltip = "Here you should find a tutorial for the " + sControl + ". Unfortunately we didn't write it in time. Please hover back soon ;-)";
			}
		}

		oButton = new HexagonButton({
			enabled: bEnabled,
			color: "Gray",//this.sColor,
			tooltip : new RichTooltip({
				title : sControl, // TODO + " - " + sLibrary,
				imageSrc : sIcon || (bEnabled ? "" : this.sPathToRoot + "theme/img/Under-construction.png"),
				text : sTooltip
			}),
			press: function() {
				that.oDemokit.navigateTo(sRef);
			}
		});
		if ( sIcon ) {
			oButton.setIcon(sIcon);
		}
		this.oHexGroup.addButton(oButton);

		return this;
	};

	IndexPage.prototype.placeAt = function(sId) {
		this.oHexGroup.placeAt(sId);
		jQuery(function() {
			if ( jQuery("#vistaico-license").size() == 0 ) {
				jQuery("body").append('<div id="vistaico-license" class="license">Some icon(s) created by <a class="sapUiDemokitLink" href="http://VistaICO.com" target="_blank">VistaICO.com</a> and <a class="sapUiDemokitLink" href="http://www.iconarchive.com/artist/fatcow.html" target="_blank">Fatcow Web Hosting</a>,	used under Creative Commons 3.0 Attribution Unported license</div>');
			}
		});
	};


	return IndexPage;

}, /* bExport= */ true);

}; // end of sap/ui/demokit/IndexPage.js
if ( !jQuery.sap.isDeclared('sap.ui.demokit.demoapps.Component') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.demokit.demoapps.Component'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/demokit/demoapps/Component",[
	'sap/ui/core/UIComponent',
	'sap/ui/model/json/JSONModel',
	'sap/ui/demokit/demoapps/model/libraryData'
], function(UIComponent, JSONModel, libraryData) {
	"use strict";

	return UIComponent.extend("sap.ui.demokit.demoapps.Component", {
		metadata : {
			manifest:"json"
		},

		init : function () {
			// call base class constructor
			UIComponent.prototype.init.apply(this, arguments);

			// load demo app metadata from docuindex of all available libraries
			var oModel = new JSONModel();
			libraryData.fillJSONModel(oModel);
			this.setModel(oModel);
		}
	});
});

}; // end of sap/ui/demokit/demoapps/Component.js
