/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/documentation/demoapps/Component',['sap/ui/core/UIComponent','sap/ui/model/json/JSONModel','sap/ui/documentation/demoapps/model/libraryData',"sap/ui/documentation/demoapps/model/models"],function(U,J,l,m){"use strict";return U.extend("sap.ui.documentation.demoapps.Component",{metadata:{manifest:"json"},init:function(){U.prototype.init.apply(this,arguments);this.setModel(m.createDeviceModel(),"device");var M=new J();l.fillJSONModel(M);this.setModel(M);}});});
sap.ui.predefine('sap/ui/documentation/demoapps/controller/App.controller',["sap/ui/core/mvc/Controller","sap/ui/Device","sap/ui/model/json/JSONModel","jquery.sap.global","sap/ui/documentation/demoapps/model/sourceFileDownloader","sap/ui/documentation/demoapps/model/formatter","sap/m/MessageBox","sap/m/MessageToast","sap/ui/model/Filter","sap/ui/model/FilterOperator","sap/m/library"],function(C,D,J,$,s,f,M,a,F,b){"use strict";return C.extend("sap.ui.documentation.demoapps.controller.App",{formatter:f,onInit:function(){var v=sap.ui.getVersionInfo(),V=new J({isOpenUI5:v&&v.gav&&/openui5/i.test(v.gav)});this.getView().setModel(V,"appView");this._onOrientationChange({landscape:D.orientation.landscape});this._onResize({name:(D.resize.width<=600?"Phone":"NoPhone")});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();this._registerResize();},onExit:function(){this._deregisterOrientationChange();this._deregisterResize();},_registerOrientationChange:function(){D.orientation.attachHandler(this._onOrientationChange,this);},_deregisterOrientationChange:function(){D.media.detachHandler(this._onOrientationChange,this);},_registerResize:function(){D.media.attachHandler(this._onResize,this);},_deregisterResize:function(){D.orientation.detachHandler(this._onResize,this);},_onOrientationChange:function(e){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape);},_onResize:function(e){this.byId("phoneImage").setVisible(e.name==="Phone");this.byId("desktopImage").setVisible(e.name!=="Phone");this.byId("phoneImage").toggleStyleClass("phoneHeaderImageDesktop",e.name==="Phone");},onDownloadButtonPress:function(e){var d=this.byId("downloadDialog");this._oDownloadButton=e.getSource();d.getBinding("items").filter([]);d.open();d._oDialog.setContentHeight("");},onSearch:function(e){e.getParameters().itemsBinding.filter([new F("name",b.Contains,e.getParameters().value)]);},onDownloadPress:function(e){var S=e.getParameters().selectedItem,l=S?S:e.getSource().getParent();this._oDownloadButton.setBusy(true);sap.ui.require(["sap/ui/core/util/File","sap/ui/thirdparty/jszip"],function(c,d){var z=new d();$.getJSON(l.data("config"),function(o){var g=o.files,p=[],h=[];g.forEach(function(i){var P=s(o.cwd+i);P.then(function(j){if(j.errorMessage){h.push(j.errorMessage);}else{z.file(i,j,{base64:false,binary:true});}});p.push(P);});Promise.all(p).then(function(){if(h.length){var i=h.reduce(function(E,k){return E+k+"\n";},"Could not locate the following download files:\n");this._handleError(i);}this._oDownloadButton.setBusy(false);a.show("Downloading for app \""+l.getLabel()+"\" has been started");var j=z.generate({type:"blob"});this._createArchive(c,j,l.getLabel());}.bind(this));}.bind(this));}.bind(this));},createDemoAppRow:function(i,B){var o;if(!B.getObject().categoryId){if(B.getObject().teaser){try{jQuery.sap.registerResourcePath("test-resources","test-resources");var r=jQuery.sap.getResourcePath(B.getObject().teaser);var t=sap.ui.xmlfragment(i,r);o=sap.ui.xmlfragment(i,"sap.ui.documentation.demoapps.view.BlockLayoutTeaserCell",this);o.getContent()[0].addContent(t);jQuery.sap.registerResourcePath("test-resources",null);}catch(e){jQuery.sap.log.warning("Teaser for demo app \""+B.getObject().name+"\" could not be loaded: "+e);o=sap.ui.xmlfragment(i,"sap.ui.documentation.demoapps.view.BlockLayoutCell",this);}}else{o=sap.ui.xmlfragment(i,"sap.ui.documentation.demoapps.view.BlockLayoutCell",this);}}else{o=sap.ui.xmlfragment(i,"sap.ui.documentation.demoapps.view.BlockLayoutHeadlineCell",this);}o.setBindingContext(B);return o;},_createArchive:function(c,o,d){c.save(o,d,"zip","application/zip");},_handleError:function(e){M.error(e);},handleLandingImageLoad:function(){this.getView().byId("landingImageHeadline").setVisible(true);}});});
sap.ui.predefine('sap/ui/documentation/demoapps/model/formatter',[],function(){"use strict";return{crossLink:function(l){if(l[0]==="#"){l=document.location.href.substring(0,document.location.href.search("demoapps\.html"))+l;}return l;},libraryLink:function(n){if(n&&n.search("sap\\.")===0){return this.formatter.crossLink("#docs/api/symbols/"+n+".html");}else{return"";}},libraryLinkEnabled:function(n){return!!this.formatter.libraryLink.bind(this)(n);},categoryName:function(c){var r=this.getView().getModel("i18n").getResourceBundle();return r.getText("demoAppCategory"+c);}};});
sap.ui.predefine('sap/ui/documentation/demoapps/model/libraryData',['jquery.sap.global','sap/ui/documentation/library'],function(q,l){"use strict";
function c(d,L,s){var b=[];if(q.isPlainObject(d.links)){b=Object.keys(d.links).map(function(k){return{name:k,ref:d.links[k]};});}var A={lib:d.namespace||s,name:d.text,icon:d.icon,desc:d.desc,config:d.config,teaser:d.teaser,category:d.category,ref:(d.resolve==="lib"?L:"")+d.ref,links:b};return A;}
function a(L,d){var C=["Showcase","Tool","Tutorial","Template","RTA","Misc"];var D={};C.forEach(function(s){D[s]=[];});var o={demoApps:[],demoAppsByCategory:[]};for(var i=0;i<L.length;i++){var b=d[L[i]].demo;if(!b){continue;}if(b.links&&b.links.length>0){for(var j=0;j<b.links.length;j++){var e=c(b.links[j],d[L[i]].libraryUrl,b.text);o.demoApps.push(e);if(C.indexOf(e.category)<0){q.sap.log.warning("Demo app category \""+e.category+"\" not found, correcting demo app \""+e.name+"\" to \"Misc\"");e.category="Misc";}D[e.category].push(e);}}}Object.keys(D).forEach(function(k){if(D[k].length===0){return;}o.demoAppsByCategory.push([{categoryId:k}]);var f=o.demoAppsByCategory.push([]);var g=0;for(var i=0;i<D[k].length;i++){g++;if(D[k][i].teaser){g++;}if(g>4){f=o.demoAppsByCategory.push([]);g=0;}o.demoAppsByCategory[f-1].push(D[k][i]);}});return o;}
return{fillJSONModel:function(m){function h(L,d){m.setProperty("/bFooterVisible",true);if(!L){return;}var M=m.getData();m.setData(q.extend(M,a(L,d)));}m.setProperty("/bFooterVisible",false);l._loadAllLibInfo("","_getDocuIndex",h);}};});
sap.ui.predefine('sap/ui/documentation/demoapps/model/models',["sap/ui/model/json/JSONModel","sap/ui/Device"],function(J,D){"use strict";return{createDeviceModel:function(){var m=new J(D);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/documentation/demoapps/model/sourceFileDownloader',['jquery.sap.global'],function(q){"use strict";var c={};return function(u){return new Promise(function(r){var s=function(a){c[u]=a;r(a);};var e=function(){r({errorMessage:"FIle not found: '"+u+"'"});};if(!(u in c)){q.ajax(u,{dataType:"text",success:s,error:e});}else{r(c[u]);}});};});
sap.ui.predefine('sap/ui/documentation/library',['jquery.sap.global','sap/ui/core/util/LibraryInfo','sap/ui/core/library','sap/m/library'],function(q,L){'use strict';sap.ui.getCore().initLibrary({name:'sap.ui.documentation',version:'1.50.6',dependencies:['sap.ui.core','sap.m'],types:[],interfaces:[],controls:["sap.ui.documentation.sdk.controls.Search"],elements:[]});var t=sap.ui.documentation;var _;
t._getAppInfo=function(c){var u=sap.ui.resource("","sap-ui-version.json");q.ajax({url:u,dataType:"json",error:function(x,s,e){q.sap.log.error("failed to load library list from '"+u+"': "+s+", "+e);c(null);},success:function(a,s,x){if(!a){q.sap.log.error("failed to load library list from '"+u+"': "+s+", Data: "+a);c(null);return;}c(a);}});};
t._getLibraryInfoSingleton=function(){if(!_){_=new L();}return _;};
t._loadAllLibInfo=function(a,I,r,c){if(typeof r==="function"){c=r;r=undefined;}var l=t._getLibraryInfoSingleton();var f=I=="_getLibraryInfoAndReleaseNotes";if(f){I="_getLibraryInfo";}t._getAppInfo(function(A){if(!(A&&A.libraries)){c(null,null);return;}var b=0,d=A.libraries,e=d.length,o={},g={},h=[],j,k;for(var i=0;i<e;i++){j=d[i].name;k=d[i].version;h.push(j);g[j]=k;l[I](j,function(E){var D=function(){b++;if(b==e){c(h,o,A);}};o[E.library]=E;if(!o[E.library].version){o[E.library].version=g[E.library];}if(f){if(!r){r=g[E.library];}l._getReleaseNotes(E.library,r,function(R){o[E.library].relnotes=R;D();});}else{D();}});}});};
return t;});
sap.ui.predefine('sap/ui/documentation/sdk/Component',["jquery.sap.global","sap/ui/core/UIComponent","sap/ui/Device","sap/ui/documentation/sdk/model/models","sap/ui/documentation/sdk/controller/ErrorHandler","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ConfigUtil","sap/ui/documentation/sdk/controller/util/APIInfo","sap/ui/documentation/sdk/util/DocumentationRouter","sap/m/ColumnListItem"],function(q,U,D,m,E,J,C,A){"use strict";var t=[],l={},T=1000000;return U.extend("sap.ui.documentation.sdk.Component",{metadata:{manifest:"json",includes:["css/style.css"]},init:function(){this._oErrorHandler=new E(this);this.setModel(m.createDeviceModel(),"device");this.setModel(new J(),"treeData");this.setModel(new J(),"libsData");this.setModel(new J(),"versionData");U.prototype.init.apply(this,arguments);this.loadVersionInfo();this.getRouter().initialize();sap.m.TablePopin.prototype.onfocusin=function(){};},destroy:function(){this._oErrorHandler.destroy();this._oConfigUtil.destroy();this._oConfigUtil=null;U.prototype.destroy.apply(this,arguments);},getContentDensityClass:function(){if(this._sContentDensityClass===undefined){if(q(document.body).hasClass("sapUiSizeCozy")||q(document.body).hasClass("sapUiSizeCompact")){this._sContentDensityClass="";}this._sContentDensityClass="sapUiSizeCompact";}return this._sContentDensityClass;},getConfigUtil:function(){if(!this._oConfigUtil){this._oConfigUtil=new C(this);}return this._oConfigUtil;},loadVersionInfo:function(){if(!this._oVersionInfoPromise){this._oVersionInfoPromise=sap.ui.getVersionInfo({async:true}).then(this._bindVersionModel.bind(this));}return this._oVersionInfoPromise;},fetchAPIIndex:function(){if(this._indexPromise){return this._indexPromise;}this._indexPromise=new Promise(function(r,a){A.getIndexJsonPromise().then(function(d){this._parseLibraryElements(d);this._bindTreeModel(t);r(d);}.bind(this));}.bind(this));return this._indexPromise;},_parseLibraryElements:function(L){for(var i=0;i<L.length;i++){if(!L[i].children){l[L[i].name]=L[i];}this._addElementToTreeData(L[i]);if(L[i].children){this._parseLibraryElements(L[i].children,true);}}},_addElementToTreeData:function(j){var n,a=this.aAllowedMembers;if(a.indexOf(j.visibility)!==-1){if(j.kind!=="namespace"){var N=j.name.split("."),b=N.pop(),s=N.join("."),o=this._createTreeNode(b,j.name,j.name===this._topicId,j.lib),e=this._findNodeNamespaceInTreeStructure(s);if(e){if(!e.nodes){e.nodes=[];}e.nodes.push(o);}else if(s){n=this._createTreeNode(s,s,s===this._topicId,j.lib);n.nodes=[];n.nodes.push(o);t.push(n);this._removeDuplicatedNodeFromTree(s);}else{n=this._createTreeNode(j.name,j.name,j.name===this._topicId,j.lib);t.push(n);}}else{n=this._createTreeNode(j.name,j.name,j.name===this._topicId,j.lib);t.push(n);}}},_createTreeNode:function(a,n,i,L){var o={};o.text=a;o.name=n;o.ref="#/api/"+n;o.isSelected=i;o.lib=L;return o;},_findNodeNamespaceInTreeStructure:function(n,a){a=a||t;for(var i=0;i<a.length;i++){var o=a[i];if(o.name===n){return o;}if(o.nodes){var c=this._findNodeNamespaceInTreeStructure(n,o.nodes);if(c){return c;}}}},_removeNodeFromNamespace:function(n,N){for(var i=0;i<N.nodes.length;i++){if(N.nodes[i].text===n){N.nodes.splice(i,1);return;}}},_removeDuplicatedNodeFromTree:function(n){if(l[n]){var N=n.substring(0,n.lastIndexOf("."));var o=this._findNodeNamespaceInTreeStructure(N);var s=n.substring(n.lastIndexOf(".")+1,n.lenght);this._removeNodeFromNamespace(s,o);}},_bindTreeModel:function(t){var a=this.getModel("treeData");a.setSizeLimit(T);if(t.length>0){t.push({isSelected:false,name:"experimental",ref:"#/api/experimental",text:"Experimental APIs"},{isSelected:false,name:"deprecated",ref:"#/api/deprecated",text:"Deprecated APIs"});}a.setData(t,false);},_bindVersionModel:function(v){var V,o,i=false;this.aAllowedMembers=["public","protected"];if(!v){return;}V=v.version;if(/internal/i.test(v.name)){i=true;this.aAllowedMembers.push("restricted");}o={versionGav:v.gav,version:q.sap.Version(sap.ui.version).getMajor()+"."+q.sap.Version(sap.ui.version).getMinor(),fullVersion:sap.ui.version,isOpenUI5:v&&v.gav&&/openui5/i.test(v.gav),isSnapshotVersion:v&&v.gav&&/snapshot/i.test(v.gav),isDevVersion:V.indexOf("SNAPSHOT")>-1||(V.split(".").length>1&&parseInt(V.split(".")[1],10)%2===1),isInternal:i,libraries:v.libraries,allowedMembers:this.aAllowedMembers};this.getModel("versionData").setData(o,false);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetail.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/uxap/ObjectPageSubSection","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/ui/documentation/sdk/controller/util/APIInfo"],function(q,B,J,C,T,O,a,A){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{METHOD:'method',EVENT:'event',PARAM:'param',NOT_AVAILABLE:'N/A',NOT_FOUND:'Not found',ANNOTATIONS_LINK:'http://docs.oasis-open.org/odata/odata/v4.0/odata-v4.0-part3-csdl.html',ANNOTATIONS_NAMESPACE_LINK:'http://docs.oasis-open.org/odata/odata/v4.0/errata02/os/complete/vocabularies/',ANNOTATION_DESCRIPTION_STRIP_REGEX:/<i>XML[\s\S].*Example/,_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","null","any","any[]","array","element","object","object[]","object|object[]","function","float","int","boolean","string","string[]","number","map","promise","undefined"],onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this._oLibsModel=new J();this._oLibsModel.setSizeLimit(1000000);this.setModel(new J(),"topics");this.setModel(new J(),"constructorParams");this.setModel(new J(),'methods');this.setModel(new J(),'events');this.setModel(new J(),"entity");this.setModel(new J(),"borrowedMethods");this.setModel(new J(),"borrowedEvents");this._objectPage.attachEvent("_sectionChange",function(e){var s=e.getParameter("section").getTitle().toLowerCase(),S=(e.getParameter("subsection")&&e.getParameter("subsection").getTitle()!=='Overview')?e.getParameter("subsection").getTitle():'';if(s==='properties'){s='controlProperties';}if(s==='fields'){s='properties';}this.getRouter().stop();this.getRouter().navTo("apiId",{id:this._sTopicid,entityType:s,entityId:S},true);this.getRouter().initialize(true);},this);},onAfterRendering:function(){this._createMethodsSummary();this._createEventsSummary();this._createAnnotationsSummary();this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},onJSDocLinkClick:function(e){var c=e.target.classList,j=c.contains("jsdoclink"),E;if(!j){return;}if(c.contains("scrollToMethod")){E="methods";}else if(c.contains("scrollToEvent")){E="events";}else{return;}this._scrollToEntity(E,e.target.getAttribute("data-sap-ui-target"));},_onTopicMatched:function(e){var c=this.getOwnerComponent();this._objectPage.setBusy(true);this._sTopicid=e.getParameter("arguments").id;this._sEntityType=e.getParameter("arguments").entityType;this._sEntityId=e.getParameter("arguments").entityId;c.loadVersionInfo().then(c.fetchAPIIndex.bind(c)).then(function(d){var E,f=false,l,i;this._aApiIndex=d;for(i=0,l=d.length;i<l;i++){if(d[i].name===this._sTopicid||d[i].name.indexOf(this._sTopicid)===0){E=d[i];this._oEntityData=E;f=true;break;}}if(f){return A.getLibraryElementsJSONPromise(E.lib).then(function(d){this._aLibsData=d;return Promise.resolve();}.bind(this));}return Promise.reject(this.NOT_FOUND);}.bind(this)).then(function(){var l=this._aLibsData,o,L,i;for(i=0,L=l.length;i<L;i++){if(l[i].name===this._sTopicid){o=l[i];break;}}this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");this.buildBorrowedModel(o).then(function(d){this.getModel('borrowedMethods').setData(d.methods,false);this.getModel('borrowedEvents').setData(d.events,false);}.bind(this)).then(function(){this._bindData(this._sTopicid);this._bindEntityData(this._sTopicid);this._createMethodsSummary();this._createEventsSummary();this._createAnnotationsSummary();if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}else{this._scrollContentToTop();}q.sap.delayedCall(0,this,function(){this._prettify();this._objectPage.setBusy(false);q.sap.delayedCall(0,this,function(){if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}});});this.searchResultsButtonVisibilitySwitch(this.getView().byId("apiDetailBackToSearch"));}.bind(this));}.bind(this)).catch(function(r){if(r===this.NOT_FOUND){this._objectPage.setBusy(false);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}}.bind(this));},_prettify:function(){q('pre').addClass('prettyprint');window.prettyPrint();},_createMethodsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-methodsSummary","sap.ui.documentation.sdk.view.ApiDetailMethodsSummary",this),S=this.getView().byId("methods"),b=S.getSubSections(),c=this.getModel("topics").getData(),d=c.hasMethods&&!c.hasOwnMethods;if(b.length>0&&(b[0].getTitle()==="Summary"||b[0].getTitle()==="Methods"||d)){b[0].setTitle(d?"Methods":"Summary");return;}S.insertSubSection(new O({title:d?"Methods":"Summary",blocks:[s]}),0);},_createEventsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-eventsSummary","sap.ui.documentation.sdk.view.ApiDetailEventsSummary",this),S=this.getView().byId("events"),b=S.getSubSections(),c=this.getModel("topics").getData(),d=c.hasEvents&&!c.hasOwnEvents;if(b.length>0&&(b[0].getTitle()==="Summary"||b[0].getTitle()==="Events"||d)){b[0].setTitle(d?"Events":"Summary");return;}S.insertSubSection(new O({title:d?"Events":"Summary",blocks:[s]}),0);},_createAnnotationsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-annotationsSummary","sap.ui.documentation.sdk.view.ApiDetailAnnotationsSummary",this);var S=this.getView().byId("annotations");var b=S.getSubSections();if(b.length>0&&b[0].getTitle()==="Summary"){return;}S.insertSubSection(new O({title:"Summary",blocks:[s]}),0);},scrollToMethod:function(e){this._scrollToEntity("methods",e.getSource().getText());},scrollToEvent:function(e){this._scrollToEntity("events",e.getSource().getText());},scrollToAnnotation:function(e){this._scrollToEntity("annotations",e.getSource().getText());},_scrollToEntity:function(s,S){var f,b,o;if(!s){return;}s=s.toLowerCase();o=this.getView().byId(s);if(!o){return;}if(S){S=S.toLowerCase();b=o.getSubSections();f=b.filter(function(c){return c.getTitle().toLowerCase()===S;});if(f.length){this.getRouter().stop();q.sap.delayedCall(0,this,function(){this.getRouter().initialize(true);});this.getView().byId("apiDetailObjectPage").scrollToSection(f[0].getId(),250);}}else{this.getView().byId("apiDetailObjectPage").scrollToSection(o.getId(),250);}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0);}},_bindEntityData:function(t){C.loadData().then(function(c){var e,E=this._getEntitySampleData(t,c);e=q.extend({},this._oEntityData,E);this.getModel("entity").setData(e,false);this._buildHeaderLayout(this.getModel("topics").getData(),e);}.bind(this));},_bindData:function(t){var l=this._aLibsData,c,b=this.getOwnerComponent().getModel("treeData").getData(),d=this._getControlChildren(b,t),m,o={parameters:[]},e,M={methods:[]},f,E={events:[]},u,L,i;for(i=0,L=l.length;i<L;i++){if(l[i].name===this._sTopicid){c=l[i];break;}}if(d){if(!c){c={};}c.controlChildren=d;this._addChildrenDescription(l,c.controlChildren);}u=c['ui5-metadata'];if(c.controlChildren){c.hasChildren=true;}else{c.hasChildren=false;}if(c.hasOwnProperty('properties')&&this.hasVisibleElement(c.properties)){c.hasProperties=true;}else{c.hasProperties=false;}c.hasConstructor=c.hasOwnProperty('constructor');if(u&&u.properties&&this.hasVisibleElement(u.properties)){c.hasControlProperties=true;}else{c.hasControlProperties=false;}if(c&&c.events){c.hasOwnEvents=true;}else{c.hasOwnEvents=false;}c.hasOwnMethods=c.hasOwnProperty('methods')&&this.hasVisibleElement(c.methods);c.hasEvents=c.hasOwnEvents||this.getModel("borrowedEvents").getData().length>0;c.hasMethods=c.hasOwnMethods||this.getModel("borrowedMethods").getData().length>0;if(u&&u.associations&&this.hasVisibleElement(u.associations)){c.hasAssociations=true;}else{c.hasAssociations=false;}if(u&&u.aggregations&&this.hasVisibleElement(u.aggregations)){c.hasAggregations=true;}else{c.hasAggregations=false;}if(u&&u.specialSettings&&this.hasVisibleElement(u.specialSettings)){c.hasSpecialSettings=true;}else{c.hasSpecialSettings=false;}if(u&&u.annotations&&Object.keys(u.annotations).length>0){if(!c.hasAnnotations){u.annotations.unshift({});}c.hasAnnotations=true;}else{c.hasAnnotations=false;}if(c.hasConstructor&&c.constructor.parameters){for(i=0;i<c.constructor.parameters.length;i++){this.subParamPhoneName=c.constructor.parameters[i].name;o.parameters=o.parameters.concat(this._getParameters(c.constructor.parameters[i]));}this.subParamPhoneName='';}if(c.hasOwnMethods){M.methods=this.buildMethodsModel(c.methods);}if(c.hasOwnEvents){E.events=this.buildEventsModel(c.events);}if(c.implements&&c.implements.length){c.implementsParsed=c.implements.map(function(g,h,j){var D=g.split("."),s=D[D.length-1];return{href:g,name:s,isLast:h===j.length-1};});c.hasImplementsData=true;}else{c.hasImplementsData=false;}c.isClass=c.kind==="class";c.isDerived=!!c.extends;c.extendsText=c.extends||this.NOT_AVAILABLE;c.sinceText=c.since||this.NOT_AVAILABLE;c.module=c.module||this.NOT_AVAILABLE;this._modifyReferences(c);f=this.getModel("methods");e=this.getModel("borrowedMethods");f.setSizeLimit(1000);e.setSizeLimit(1000);this.getModel("topics").setSizeLimit(1000);this.getModel("topics").setData(c,false);this.getModel("constructorParams").setData(o,false);f.setData(M,false);f.setDefaultBindingMode("OneWay");this.getModel('events').setData(E,false);this.getModel('events').setDefaultBindingMode("OneWay");if(this.extHookbindData){this.extHookbindData(t,m);}},_modifyReferences:function(c){var h=false,r=c.constructor.references,R,p,l,i;c.references=[];if(r){for(i=0,l=r.length;i<l;i++){R=r[i];if(!h){p=R.match(/^{@link\s+topic:(\w{32})(\s.+)?}$|^topic:(\w{32})$/);if(p){if(p[3]){c.docuLink=p[3];c.docuLinkText=c.basename;}else if(p[1]){c.docuLink=p[1];c.docuLinkText=p[2]?p[2]:c.basename;}h=true;}else{c.references.push(R);}}else{c.references.push(R);}}}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var _=function(t,s){return new sap.m.ObjectAttribute({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},b=function(o){return new sap.m.Link(o||{});},c=function(o){return new sap.m.Text(o||{});},d=function(o){return new sap.m.Label(o||{});},e=function(o,f){var h=new sap.m.HBox(o||{});if(f){h.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return h;};this._oHeaderLayoutUtil={_getControlSampleBlock:function(o,E){return e({items:[d({design:"Bold",text:"Control Sample:"}),b({emphasized:true,text:E.sample,visible:E.hasSample,href:"#/entity/"+o.name}),c({text:E.sample,visible:!E.hasSample})]},true);},_getDocumentationBlock:function(o,E){return e({items:[d({design:"Bold",text:"Documentation:"}),b({emphasized:true,text:o.docuLinkText,href:"#/topic/"+o.docuLink})]},true);},_getExtendsBlock:function(o,E){return e({items:[d({text:"Extends:"}),b({text:o.extendsText,href:"#/api/"+o.extendsText,visible:o.isDerived}),c({text:o.extendsText,visible:!o.isDerived})]},true);},_getSubclassesBlock:function(o,E){var s=E.extendedBy||E.implementedBy,S;this._aSubClasses=s;if(s.length===1){S=b({text:s[0],href:"#/api/"+s[0]});}else{S=b({text:o.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});}return e({items:[d({text:o.isClass?"Known direct subclasses:":"Known direct implementations:"}),S]},true);},_getImplementsBlock:function(o,E){var i=[];o.implementsParsed.forEach(function(f){i.push(e({items:[b({text:f.name,href:"#/api/"+f.href}),c({text:",",visible:!f.isLast})]}));});return e({items:[d({text:"Implements:"}),new sap.m.HBox({items:i})]},true);},_getModuleBlock:function(o,E){return _("Module",o.module);},_getLibraryBlock:function(o,E){return _("Library",E.lib);},_getVisibilityBlock:function(o,E){return _("Visibility",o.visibility);},_getAvailableSinceBlock:function(o,E){return _("Available since",o.sinceText);},_getApplicationComponentBlock:function(o,E){return _("Application Component",E.appComponent);}};}return this._oHeaderLayoutUtil;},_openSubclassesImplementationsPopover:function(e){var p=this._aSubClasses.map(function(E){return new sap.m.Link({text:E,href:"#/api/"+E}).addStyleClass("sapUiTinyMarginBottom sapUiTinyMarginEnd");}),P=this._getSubClassesAndImplementationsPopover(p);P.openBy(e.getSource());},_getSubClassesAndImplementationsPopover:function(c){var p=this._getPopover();if(p.getContent().length>0){p.destroyContent();}(c||[]).forEach(p.addContent,p);return p;},_getPopover:function(){if(!this._oPopover){this._oPopover=new sap.m.Popover({placement:"Bottom",showHeader:false}).addStyleClass("sapUiDocumentationSubclassesPopover");}return this._oPopover;},_buildHeaderLayout:function(c,e){var h=[[],[],[]],H=this._getHeaderLayoutUtil(),s=e.extendedBy||e.implementedBy||[],b=[{creator:"_getControlSampleBlock",exists:c.isClass},{creator:"_getDocumentationBlock",exists:c.docuLink!==undefined},{creator:"_getExtendsBlock",exists:c.isClass},{creator:"_getSubclassesBlock",exists:s.length>0},{creator:"_getImplementsBlock",exists:c.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:c.kind==="namespace"&&e.lib},{creator:"_getVisibilityBlock",exists:c.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],f=function(){var i=0,I,g=function(i){if(i<=3){return 0;}else if(i<=6){return 1;}return 2;};b.forEach(function(o){var d;if(o.exists){d=H[o.creator].call(this,c,e);I=g(++i);h[I].push(d);}},this);}.bind(this);f();h.forEach(function(d,i){var v=this.byId("headerColumn"+i);v.removeAllContent();if(d.length>0){v.setVisible(true);d.forEach(v.addContent,v);}},this);},_getControlChildren:function(t,s){for(var i=0;i<t.length;i++){if(t[i].name===s){return t[i].nodes;}}},_addChildrenDescription:function(l,c){function g(n){var L,i;for(i=0,L=l.length;i<L;i++){if(l[i].name===n){return l[i];}}return false;}for(var i=0;i<c.length;i++){c[i].description=g(c[i].name).description;c[i].link="{@link "+c[i].name+"}";}},_getEntitySampleData:function(e,c){var f=c.entities.filter(function(b){return b.id===e;});var E=f.length?f[0]:undefined;var s=this._getControlComponent(e,c);return{appComponent:s||this.NOT_AVAILABLE,sample:(E&&e)||this.NOT_AVAILABLE,hasSample:!!(E&&E.sampleCount>0)};},buildMethodsModel:function(m){var I=this.getModel("versionData").getProperty("/isInternal");if(!m.length){return m;}var r=m.filter(function(b){return I?true:b.visibility!=="restricted";}).map(function(b){var s=[];b.parameters=b.parameters||[];b.parameters=b.parameters.map(function(p){var c,d;var t=(p.type||"").split("|");p.types=[];for(var i=0;i<t.length;i++){p.types.push({value:t[i],isLast:i===t.length-1});}if(p.parameterProperties&&!b.subParametersInjected){c=p.parameterProperties;for(var e in c){d=(c[e].type||"").split("|");c[e].types=[];c[e].types=d.map(function(f,g,h){return{value:f,isLast:g===h.length-1};});c[e].isSubProperty=true;c[e].phoneName=p.name+'.'+c[e].name;s.push(c[e]);}}return p;});if(b.returnValue){var t=(b.returnValue.type||"").split("|");b.returnValue.types=[];for(var i=0;i<t.length;i++){b.returnValue.types.push({value:t[i],isLast:i===t.length-1});}}if(!b.subParametersInjected){b.parameters=b.parameters.concat(s);b.subParametersInjected=true;}return b;});r.unshift({});return r;},buildBorrowedModel:function(c){var b,d,s,e,m,M,I,r=[],o,i;if(!c){return Promise.resolve({events:[],methods:[]});}e={methods:[],events:[]};s=c.extends;var v=function(g){return this._aAllowedMembers.indexOf(g.visibility)!==-1;}.bind(this);m=c.aMethods||[];M=m.map(function(g){return g.name;});var f=function(g){return M.indexOf(g.name)===-1;};I=[s];while(s){i=this._aApiIndex.length;while(i--){o=this._aApiIndex[i];if(o.name===s){s=o.extends;if(s){I.push(s);}if(r.indexOf(o.lib)===-1){r.push(o.lib);}break;}}if(i===-1){break;}}var p=r.map(function(l){return A.getLibraryElementsJSONPromise(l);});return Promise.all(p).then(function(R){var g=[];R.forEach(function(S){g=g.concat(S);});I.forEach(function(s){var h,i=g.length;while(i--){if(g[i].name===s){h=g[i];break;}}var j=function(k){return{name:k.name,link:"#/api/"+s+"/methods/"+k.name};};var E=function(k){return{name:k.name,link:"#/api/"+s+"/events/"+k.name};};if(h){b=(h.methods||[]).filter(v).filter(f).map(j);if(b.length){e.methods.push({name:s,methods:b});}d=(h.events||[]).filter(v).map(E);if(d.length){e.events.push({name:s,events:d});}}});return e;});},buildEventsModel:function(e){if(e.length===0){return e;}var r=e.map(function(b){if(b.parameters&&!b.subParametersInjected){var p=[];b.parameters.map(function(P){this.subParamPhoneName=P.name;p=p.concat(this._getParameters(P));},this);this.subParamPhoneName='';b.parameters=p;b.subParametersInjected=true;}return b;},this);r.unshift({});return r;},subParamLevel:0,subParamPhoneName:'',_getParameters:function(p){var r=[p];var t=(p.type||"").split("|"),b;p.types=[];for(var i=0;i<t.length;i++){p.types.push({value:t[i],isLast:i===t.length-1});}if(p.parameterProperties){this.subParamLevel++;for(var s in p.parameterProperties){var c='is';for(var i=0;i<this.subParamLevel;i++){c+='Sub';}c+='Property';this.subParamPhoneName+='.'+s;p.parameterProperties[s][c]=true;p.parameterProperties[s].phoneName=this.subParamPhoneName;b=(p.parameterProperties[s].type||"").split("|");p.parameterProperties[s].types=[];p.parameterProperties[s].types=b.map(function(d,e,f){return{value:d,isLast:e===f.length-1};});r=r.concat(this._getParameters(p.parameterProperties[s]));if(this.subParamPhoneName.indexOf('.')>-1){this.subParamPhoneName=this.subParamPhoneName.substring(0,this.subParamPhoneName.lastIndexOf('.'));}else{this.subParamPhoneName='';}}this.subParamLevel--;}return r;},formatSubtitle:function(d){var r="";if(d){r+="Deprecated in version: "+d.since;}return r;},formatConstructor:function(n,p){var r='<pre class="sapUiDocumentationAPICode">new ';if(n){r+=n+'(';}if(p){p.forEach(function(e,i,b){r+=e.name;if(e.optional){r+='?';}if(i<b.length-1){r+=', ';}});}if(n){r+=')</pre>';}return r;},_formatChildDescription:function(d){if(d){d=this._extractFirstSentence(d);d=this._wrapInSpanTag(d);return"<div>"+d+"<\div>";}},_extractFirstSentence:function(d){var b=d.slice(),s;if(d.lastIndexOf("}")>d.lastIndexOf(".")){return"";}b=this._sliceSpecialTags(b,"{","}");b=this._sliceSpecialTags(b,"<code>","</code>");s=d.length-b.length;d=d.slice(0,b.indexOf(".")+".".length+s);return d;},_sliceSpecialTags:function(d,s,e){var b,c;while(d.indexOf(s)!==-1&&d.indexOf(s)<d.indexOf(".")){b=d.indexOf(s);c=d.indexOf(e);d=d.slice(0,b)+d.slice(c+e.length,d.length);}return d;},formatDefaultValue:function(d){switch(d){case null:return'';case undefined:return'';case'':return'empty string';default:return d;}},formatEntityName:function(n,c,s){return(s===true)?c+"."+n:n;},formatDeprecated:function(s,d,e){var r;if(d){d=d.replace(/{@link\s+([^}\s]+)(?:\s+([^}]*))?}|<code>(\S+)<\/code>/gi,function(m,E,n,c){var t;if(c){return['<em>',c,'</em>'].join("");}else{if(e){E=E[0]==="#"?E.substring(1,E.length):E;t=[this._sTopicid,"/",e,"/",E].join("");}else{t=E;}return['<a href="#/api/',t,'">',(n?n:E),'</a>'].join("");}}.bind(this));}r=["Deprecated"];if(s){r.push(" since "+s);}if(d){r.push(". "+d);}return r.join("");},formatMethodDeprecated:function(s,d){return this.formatDeprecated(s,d,"methods");},formatEventDeprecated:function(s,d){return this.formatDeprecated(s,d,"events");},formatExample:function(c,t){return this.formatDescription(["<span><strong>Example: </strong>",c,"<pre class='sapUiSmallMarginTop'>",t,"</pre></span>"].join(""));},formatOverviewDescription:function(d,r){var l,i;if(r&&r.length>0){d+="<br/><br/><span>Documentation links:</span><ul>";l=r.length;for(i=0;i<l;i++){if(/{@link.*}/.test(r[i])){d+="<li>"+r[i]+"</li>";}else{d+="<li>{@link "+r[i]+"}</li>";}}d+="</ul>";}return this.formatDescription(d);},formatDescription:function(d,b,c){if(!d&&!b&&!c){return"<span/>";}var r=d||"";if(c||b){r+="<span class=\"sapUiDocumentationDeprecated\">";if(c){r+='<br/>Deprecated since version '+c+'.';}if(b){if(c){r+=' '+b;}else{r+='<br/>'+b;}}r+="</span>";}r=this._wrapInSpanTag(r);return r;},formatDescriptionSince:function(d,s){var r=d||"";if(s){r+='<br/><br/><i>Since: '+s+'.</i>';}r=this._wrapInSpanTag(r);return r;},formatAnnotationDescription:function(d,s){var r=d||"";r+='<br/>For more information, see '+'<a target="_blank" href="'+this.ANNOTATIONS_LINK+'">OData v4 Annotations</a>';if(s){r+='<br/><br/><i>Since: '+s+'.</i>';}r=this._wrapInSpanTag(r);return r;},formatAnnotationDescriptionSummary:function(d){var r=d||"";r=r.split(this.ANNOTATION_DESCRIPTION_STRIP_REGEX)[0];r=this._wrapInSpanTag(r);return r;},formatAnnotationTarget:function(t){var r="";if(t){t.forEach(function(e){r+=e+'<br/>';});}r=this._wrapInSpanTag(r);return r;},formatAnnotationNamespace:function(n){var r,N=n.split(".");if(N[0]==="Org"&&N[1]==="OData"){r='<a target="_blank" href="'+this.ANNOTATIONS_NAMESPACE_LINK+n+'.xml">'+n+'</a>';}else{r=n;}r=this._wrapInSpanTag(r);return r;},hasVisibleElement:function(e){for(var i=0;i<e.length;i++){if(this._aAllowedMembers.indexOf(e[i].visibility)!==-1){return true;}}return false;},formatEventsName:function(e){return e?e.name:"";},formatEventsParam:function(e){if(e&&e.type!=this.EVENT){return e.name;}else{return"";}},formatMethodCode:function(n,p,r){var b='<pre class="sapUiDocumentationAPICode">'+n+'(';if(p&&p.length>0){p.forEach(function(e,i,c){if(e.isSubProperty||e.isSubSubProperty){return;}b+=e.name;if(e.optional){b+='?';}if(i<c.length-1){b+=', ';}});}b+=') : ';if(r){b+=r.type;}else{b+='void';}b+="</pre>";return b;},formatMethodsParam:function(m){if(m&&m.type!=this.METHOD){return m.name;}else{return"";}},formatLinkEnabled:function(l){return this._baseTypes.indexOf(l.toLowerCase())===-1;},formatExceptionLink:function(l){l=l||'';return l.indexOf('sap.ui.')!==-1;},formatEventClassName:function(i,b,p){if(p&&(i||b)){return"sapUiDocumentationParamPhone";}else if(b){return"sapUiDocumentationParamSubSub";}else if(i){return"sapUiDocumentationParamSub";}else{return"sapUiDocumentationParamBold";}},formatMethodClassName:function(i,p){if(p&&i){return"sapUiDocumentationParamPhone";}else if(i){return"sapUiDocumentationParamSub";}else{return"sapUiDocumentationParamBold";}},onAnnotationsLinkPress:function(e){this._scrollToEntity("annotations","Summary");},backToSearch:function(){this.onNavBack();},_wrapInSpanTag:function(t){var b=this.getModel('topics').oData,c=b.name||"",d=b.methods||[];var f=a.formatTextBlock(t,{linkFormatter:function(e,g){var h,H,i,m,r="api",s,S="scrollToMethod",E,l;g=g||e;if(e.match("://")){return'<a target="_blank" href="'+e+'">'+g+'</a>';}e=e.trim().replace(/\.prototype\./g,"#");h=e.indexOf('#');H=e.indexOf('#.');i=e.indexOf('#event:');if(h===-1){var j=e.lastIndexOf('.'),k=E=e.substring(j+1),n=d.filter(function(o){if(o.name===k){return o;}})[0];if(n){if(n.static===true){E=e;s=e.replace("."+k,"");if(s.length>0&&s!==c){e=s+"/methods/"+e;S=false;}else{e=c+'/methods/'+e;}}else{e=c+'/methods/'+k;}}else{m=e.match(/^topic:(\w{32})$/);if(m){e=E=m[1];r="topic";}}}if(H===0){e=e.slice(2);e=c+'/methods/'+c+'.'+e;}else if(i===0){e=e.slice('#event:'.length);E=e;e=c+'/events/'+e;S="scrollToEvent";}else if(h===0){e=e.slice(1);E=e;e=c+'/methods/'+e;}if(h>0){e=e.replace('#','/methods/');E=e;}l='<a class="jsdoclink';if(S){l+=' '+S;}l+='" href="#/'+r+'/'+e+'" data-sap-ui-target="'+E+'">'+g+'</a>';return l;}});return'<span class="sapUiDocumentationJsDoc">'+f+'</span>';}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetailDeprecatedExperimental.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/ui/documentation/sdk/controller/util/APIInfo"],function(q,B,J,a,A){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetailDeprecatedExperimental",{onInit:function(){this.setModel(new J(),"deprecatedAPIs");this.setModel(new J(),"experimentalAPIs");this.getRouter().getRoute("deprecated").attachPatternMatched(this._onTopicDeprecatedMatched,this);this.getRouter().getRoute("experimental").attachPatternMatched(this._onTopicExperimentalMatched,this);this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);this._currentMedia=this.getView()._getCurrentMediaContainerRange();this._hasMatched=false;},onBeforeRendering:function(){this.getView()._detachMediaContainerWidthChange(this._resizeMessageStrip,this);},onAfterRendering:function(){this._resizeMessageStrip();this.getView()._attachMediaContainerWidthChange(this._resizeMessageStrip,this);},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);this.getView()._detachMediaContainerWidthChange(this._resizeMessageStrip,this);},_onTopicDeprecatedMatched:function(e){if(this._hasMatched){return;}this._hasMatched=true;A.getDeprecatedPromise().then(function(d){this.getModel("deprecatedAPIs").setData(d);q.sap.delayedCall(0,this,this._prettify);}.bind(this));},_onTopicExperimentalMatched:function(e){if(this._hasMatched){return;}this._hasMatched=true;A.getExperimentalPromise().then(function(d){this.getModel("experimentalAPIs").setData(d);q.sap.delayedCall(0,this,this._prettify);}.bind(this));},_prettify:function(){q('pre').addClass('prettyprint');window.prettyPrint();},compareVersions:function(v,b){var w="WITHOUT VERSION";if(v===w||!v){return-1;}if(b===w||!b){return 1;}var c=v.split(".");var d=b.split(".");var e=parseInt(c[0],10);var f=parseInt(c[1],10);var g=parseInt(d[0],10);var h=parseInt(d[1],10);if(e>g||(e===g&&f>h)){return-1;}if(g>e||(g===e&&h>f)){return 1;}return 0;},formatTitle:function(t){if(t==="Without Version"){return t;}else{return"As of "+t;}},formatDescription:function(t,s){if(s){t="As of version "+s+", "+t;}t=this.formatLinks(t);t=t.replace("<p>",'');t=t.replace("</p>",'');return t;},formatSenderLink:function(c,e,E){if(E==="methods"){return c+"#"+e;}if(E==="events"){return c+"#events:"+e;}if(E==="class"){return c;}return"";},onApiPress:function(c){var C=c.getSource().getCustomData(),s=C[0].getValue(),e=C[1].getValue();if(C[3].getValue()){e=s+"."+e;}this.getRouter().navTo("apiId",{id:s,entityId:e,entityType:C[2].getValue()},false);},formatLinks:function(t){return a.formatTextBlock(t,{linkFormatter:function(b,c){var h;if(b.match("://")){return'<a target="_blank" href="'+b+'">'+(c||b)+'</a>';}b=b.trim().replace(/\.prototype\./g,"#");h=b.indexOf("#");c=c||b;if(h<0){var l=b.lastIndexOf("."),C=b.substring(0,l),m=b.substring(l+1),d=m;if(d){if(d.static===true){b=C+'/methods/'+C+'.'+m;}else{b=C+'/methods/'+m;}}}if(h===0){return"<code>"+b.slice(1)+"</code>";}if(h>0){b=b.slice(0,h)+'/methods/'+b.slice(h+1);}return"<a class=\"jsdoclink\" href=\"javascript:void(0);\" target=\""+b+"\">"+c+"</a>";}});},onJSDocLinkClick:function(e){var r="apiId",j=e.target.classList.contains("jsdoclink"),c=this.getOwnerComponent(),t=e.target.getAttribute("target"),n;if(!j||!t){return;}if(t.indexOf('/')>=0){n=t.split('/');c.getRouter().navTo(r,{id:n[0],entityType:n[1],entityId:n[2]},false);}else{c.getRouter().navTo(r,{id:t},false);}e.preventDefault();},_resizeMessageStrip:function(m){var v=this.getView();m=m||v._getCurrentMediaContainerRange();var n=m.name,M=this.getView().byId("deprecatedAPIStripContainer")||this.getView().byId("experimentalAPIStripContainer");if(!M){return;}if(n==="Desktop"||n==="LargeDesktop"){M.setWidth("calc(100% - 3rem)");}else if(n==="Tablet"||n==="Phone"){M.setWidth("calc(100% - 2rem)");}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiDetailInitial.controller',["sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController"],function(D,B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetailInitial",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ApiMaster.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/m/library"],function(q,M,m){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.ApiMaster",{onInit:function(){var c=this.getOwnerComponent();c.loadVersionInfo().then(c.fetchAPIIndex.bind(c)).then(function(){this._expandTreeToNode(this._topicId,this.getOwnerComponent().getModel("treeData"));}.bind(this));this._initTreeUtil("name","nodes");this.getRouter().getRoute("api").attachPatternMatched(this._onMatched,this);this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("deprecated").attachPatternMatched(this._onTopicMatched,this);this.getRouter().getRoute("experimental").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(a){try{this.showMasterSide();}catch(e){q.sap.log.error(e);}this._topicId=a.getParameter("arguments").id||a.getParameter("name");this._expandTreeToNode(this._topicId,this.getOwnerComponent().getModel("treeData"));},_onMatched:function(){var s=this.getView().getParent().getParent(),a=this.byId('tree'),b;s.setMode(S.ShowHideMode);if(a){b=a.getSelectedItem();b&&b.setSelected(false);}},compareTreeNodes:function(n,N){if(n==="EXPERIMENTAL"){return 1;}if(N==="EXPERIMENTAL"){return-1;}if(n==="DEPRECATED"){return 1;}if(N==="DEPRECATED"){return-1;}if(n<N){return-1;}if(n>N){return 1;}if(n===N){return 0;}},onNodeSelect:function(e){var n=e.getParameter("listItem");var a=n.getCustomData()[0].getValue();if(!a){q.sap.log.warning("Missing name for entity: "+n.getId()+" - cannot navigate to API ref");return;}this.getRouter().navTo("apiId",{id:a},false);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/App.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/ResizeHandler","sap/ui/Device","sap/ui/core/Fragment","sap/ui/documentation/library","sap/ui/core/IconPool","sap/m/SplitAppMode","sap/m/MessageBox","sap/m/library"],function(q,B,J,R,D,F,c,I,S,M,m){"use strict";var U=m.URLHelper;return B.extend("sap.ui.documentation.sdk.controller.App",{onInit:function(){B.prototype.onInit.call(this);var v=new J({busy:false,delay:0,bPhoneSize:false,bLandscape:D.orientation.landscape,bHasMaster:false,bSearchMode:false,bHideEmptySections:window['sap-ui-documentation-hideEmptySections'],sAboutInfoSAPUI5:"Looking for the Demo Kit for a specific SAPUI5 version? "+"Check at <a href = 'https://sapui5.hana.ondemand.com/versionoverview.html'>https://sapui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://sapui5.hana.ondemand.com/1.44.16/'>https://sapui5.hana.ondemand.com/1.44.16/</a>",sAboutInfoOpenUI5:"Looking for the Demo Kit for a specific OpenUI5 version? "+"Check at <a href = 'https://openui5.hana.ondemand.com/versionoverview.html'>https://openui5.hana.ondemand.com/versionoverview.html</a> "+"which versions are available. "+"You can view the version-specific Demo Kit by adding the version number to the URL, e.g. "+"<a href='https://openui5.hana.ondemand.com/1.44.16/'>https://openui5.hana.ondemand.com/1.44.16/</a>"});this.MENU_LINKS_MAP={"Legal":"https://www.sap.com/corporate/en/legal/impressum.html","Privacy":"https://www.sap.com/corporate/en/legal/privacy.html","Terms of Use":"https://www.sap.com/corporate/en/legal/terms-of-use.html","Copyright":"https://www.sap.com/corporate/en/legal/copyright.html","Trademark":"https://www.sap.com/corporate/en/legal/copyright.html#trademark","Disclaimer":"https://help.sap.com/viewer/disclaimer"};this.FEEDBACK_SERVICE_URL="https://feedback-sapuisofiaprod.hana.ondemand.com:443/api/v2/apps/5bb7d7ff-bab9-477a-a4c7-309fa84dc652/posts";this.OLD_DOC_LINK_SUFFIX=".html";this._oView=this.getView();this.setModel(v,"appView");this.oTabNavigation=this._oView.byId("tabHeader");this.oHeader=this._oView.byId("headerToolbar");this.oRouter=this.getRouter();R.register(this.oHeader,this.onHeaderResize.bind(this));this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));this.oRouter.attachBypassed(this.onRouteNotFound.bind(this));this.getRouter().getRoute("topicIdLegacyRoute").attachPatternMatched(this._onTopicOldRouteMatched,this);this.getRouter().getRoute("apiIdLegacyRoute").attachPatternMatched(this._onApiOldRouteMatched,this);this.oRouter.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onEntityOldRouteMatched,this);this.oRouter.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onEntityOldRouteMatched,this);this.oRouter.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType:"properties"},this._forwardToAPIRef,this);this.oRouter.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType:"aggregations"},this._forwardToAPIRef,this);this.oRouter.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType:"associations"},this._forwardToAPIRef,this);this.oRouter.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"},this._forwardToAPIRef,this);this.oRouter.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"},this._forwardToAPIRef,this);this._registerFeedbackRatingIcons();},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){q(document.body).addClass(this.getOwnerComponent().getContentDensityClass());D.orientation.attachHandler(this._onOrientationChange,this);},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);},_onTopicOldRouteMatched:function(e){var i=e.getParameter("arguments").id;if(i){i=this._trimOldDocSuffix(i);}this.getRouter().navTo("topicId",{id:i});},_onApiOldRouteMatched:function(e){var i=e.getParameter("arguments").id,E,s,a;if(i){a=i.split("#");if(a.length===2){i=a[0];E=a[1];a=E.split(":");if(a.length===2){E=a[0];s=a[1];}}i=this._trimOldDocSuffix(i);if(E==='event'){E="events";}}this.getRouter().navTo("apiId",{id:i,entityType:E,entityId:s});},_trimOldDocSuffix:function(l){if(l&&l.endsWith(this.OLD_DOC_LINK_SUFFIX)){l=l.slice(0,-this.OLD_DOC_LINK_SUFFIX.length);}return l;},_forwardToAPIRef:function(e,d){d||(d={});d['id']=e.getParameter("arguments").id;this.oRouter.navTo("apiId",d);},_onEntityOldRouteMatched:function(e){this.oRouter.navTo("entity",{id:e.getParameter("arguments").id});},onRouteChange:function(e){if(!this.oRouter.getRoute(e.getParameter("name"))._oConfig.target){return;}var r=e.getParameter("name"),t=this.oRouter.getRoute(r)._oConfig.target[0]+"Tab",T=this._oView.byId(t),k=T?T.getKey():"home",p=D.system.phone,v=this.getModel("appView"),h=this.getOwnerComponent().getConfigUtil().hasMasterView(r),o,s;this.oTabNavigation.setSelectedKey(k);v.setProperty("/bHasMaster",h);this._toggleTabHeaderClass();if(p&&h){o=this.getOwnerComponent().getConfigUtil().getMasterView(r);s=o&&o.getId();v.setProperty("/sMasterViewId",s);}this.getView().byId("splitApp").hideMaster();v.setProperty("/bIsShownMaster",false);},onRouteNotFound:function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;},toggleMaster:function(e){var p=e.getParameter("pressed"),P=D.system.phone,s=this.getView().byId("splitApp"),i=s.getMode()===S.ShowHideMode,a=s.getMode()===S.HideMode,b=this.getModel("appView").getProperty("/sMasterViewId"),t;if(!P&&(i||a)){t=(p)?s.showMaster:s.hideMaster;t.call(s);return;}if(P){if(p){s.to(b);}else{s.backDetail();}}},navigateToSection:function(e){var k=e.getParameter("key");e.preventDefault();if(k&&k!=="home"){this.getRouter().navTo(k,{},true);}else{this.getRouter().navTo("",{},true);this.oTabNavigation.setSelectedKey("home");}},handleMenuItemClick:function(e){var t=e.getParameter("item").getText(),T=this.MENU_LINKS_MAP[t];if(t==="About"){this.aboutDialogOpen();}else if(t==="Feedback"){this.feedbackDialogOpen();}else if(T){U.redirect(T,true);}},aboutDialogOpen:function(){if(!this._oAboutDialog){this._oAboutDialog=new sap.ui.xmlfragment("aboutDialogFragment","sap.ui.documentation.sdk.view.AboutDialog",this);this._oView.addDependent(this._oAboutDialog);}this._oAboutDialog.open();},aboutDialogClose:function(e){this._oAboutDialog.close();},onAboutVersionDetails:function(e){var v=this.getModel("appView"),V=v.getData(),t=this;c._loadAllLibInfo("","_getLibraryInfo","",function(L,o){var a={};var b=c._getLibraryInfoSingleton();for(var i=0,l=L.length;i<l;i++){L[i]=o[L[i]];L[i].libDefaultComponent=b._getDefaultComponent(L[i]);}a.libs=L;V.oVersionInfo=a;v.setData(V);t.setModel(v,"appView");});var n=F.byId("aboutDialogFragment","aboutNavCon"),d=F.byId("aboutDialogFragment","aboutDetail");n.to(d);},onAboutThirdParty:function(e){var v=this.getModel("appView"),V=v.getData(),t=this;c._loadAllLibInfo("","_getThirdPartyInfo",function(l,L){if(!l){return;}var f={};f.thirdparty=[];for(var j=0;j<l.length;j++){var o=L[l[j]];for(var i=0;i<o.libs.length;i++){var O=o.libs[i];O._lib=l[j];f.thirdparty.push(O);}}f.thirdparty.sort(function(a,b){var N=(a.displayName||"").toUpperCase();var g=(b.displayName||"").toUpperCase();if(N>g){return 1;}else if(N<g){return-1;}else{return 0;}});V.oThirdPartyInfo=f;v.setData(V);t.setModel(v,"appView");});var n=F.byId("aboutDialogFragment","aboutNavCon"),d=F.byId("aboutDialogFragment","aboutThirdParty");n.to(d);},onReleaseDialogOpen:function(e){var l=c._getLibraryInfoSingleton(),v=e.getSource().data("version"),L=e.getSource().data("library"),n=new J(),d=new J(),t=this;if(!this._oReleaseDialog){this._oReleaseDialog=new sap.ui.xmlfragment("releaseDialogFragment","sap.ui.documentation.sdk.view.ReleaseDialog",this);this._oView.addDependent(this._oReleaseDialog);}if(!this._oNotesView){this._oNotesView=sap.ui.view({id:"notesView",viewName:"sap.ui.documentation.sdk.view.ReleaseNotesView",type:"Template"});this._oNotesView.setModel(n);}l._getReleaseNotes(L,v,function(r,v){var o={};if(r&&r[v]&&r[v].notes&&r[v].notes.length>0){t._oNotesView.getModel().setData(r);t._oNotesView.bindObject("/"+v);}else{o.noDataMessage="No changes for this library!";}o.library=L;d.setData(o);});this._oReleaseDialog.setModel(d);this._oReleaseDialog.addContent(this._oNotesView);this._oReleaseDialog.open();},onReleaseDialogClose:function(e){this._oReleaseDialog.close();},onAboutNavBack:function(e){var n=F.byId("aboutDialogFragment","aboutNavCon");n.back();},feedbackDialogOpen:function(){var t=this;if(!this._oFeedbackDialog){this._oFeedbackDialog=new sap.ui.xmlfragment("feedbackDialogFragment","sap.ui.documentation.sdk.view.FeedbackDialog",this);this._oView.addDependent(this._oFeedbackDialog);this._oFeedbackDialog.textInput=F.byId("feedbackDialogFragment","feedbackInput");this._oFeedbackDialog.contextCheckBox=F.byId("feedbackDialogFragment","pageContext");this._oFeedbackDialog.contextData=F.byId("feedbackDialogFragment","contextData");this._oFeedbackDialog.ratingStatus=F.byId("feedbackDialogFragment","ratingStatus");this._oFeedbackDialog.ratingStatus.value=0;this._oFeedbackDialog.sendButton=F.byId("feedbackDialogFragment","sendButton");this._oFeedbackDialog.ratingBar=[{button:F.byId("feedbackDialogFragment","excellent"),status:"Excellent"},{button:F.byId("feedbackDialogFragment","good"),status:"Good"},{button:F.byId("feedbackDialogFragment","average"),status:"Average"},{button:F.byId("feedbackDialogFragment","poor"),status:"Poor"},{button:F.byId("feedbackDialogFragment","veryPoor"),status:"Very Poor"}];this._oFeedbackDialog.reset=function(){this.sendButton.setEnabled(false);this.textInput.setValue("");this.contextCheckBox.setSelected(true);this.ratingStatus.setText("");this.ratingStatus.setState("None");this.ratingStatus.value=0;this.contextData.setVisible(false);this.ratingBar.forEach(function(r){if(r.button.getPressed()){r.button.setPressed(false);}});};this._oFeedbackDialog.updateContextData=function(){var v=t._getUI5Version(),u=t._getUI5Distribution();if(this.contextCheckBox.getSelected()){this.contextData.setValue("Location: "+t._getCurrentPageRelativeURL()+"\n"+u+" Version: "+v);}else{this.contextData.setValue(u+" Version: "+v);}};this._oFeedbackDialog.updateContextData();}this._oFeedbackDialog.updateContextData();if(!this._oFeedbackDialog.isOpen()){q.sap.syncStyleClass("sapUiSizeCompact",this.getView(),this._oFeedbackDialog);this._oFeedbackDialog.open();}},onFeedbackDialogSend:function(){var d={};if(this._oFeedbackDialog.contextCheckBox.getSelected()){d={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"page":this._getCurrentPageRelativeURL(),"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}else{d={"texts":{"t1":this._oFeedbackDialog.textInput.getValue()},"ratings":{"r1":{"value":this._oFeedbackDialog.ratingStatus.value}},"context":{"attr1":this._getUI5Distribution()+":"+sap.ui.version}};}this._oFeedbackDialog.setBusyIndicatorDelay(0);this._oFeedbackDialog.setBusy(true);q.ajax({url:this.FEEDBACK_SERVICE_URL,type:"POST",contentType:"application/json",data:JSON.stringify(d)}).done(function(){M.success("Your feedback has been sent.",{title:"Thank you!"});this._oFeedbackDialog.reset();this._oFeedbackDialog.close();this._oFeedbackDialog.setBusy(false);}.bind(this)).fail(function(r,s,e){var E=e;M.error("An error occurred sending your feedback:\n"+E,{title:"Sorry!"});this._oFeedbackDialog.setBusy(false);}.bind(this));},onFeedbackDialogCancel:function(){this._oFeedbackDialog.reset();this._oFeedbackDialog.close();},onShowHideContextData:function(){this._oFeedbackDialog.contextData.setVisible(!this._oFeedbackDialog.contextData.getVisible());},onContextSelect:function(){this._oFeedbackDialog.updateContextData();},onPressRatingButton:function(e){var t=this;var p=e.getSource();t._oFeedbackDialog.ratingBar.forEach(function(r){if(p!==r.button){r.button.setPressed(false);}else{if(!r.button.getPressed()){s("None","",0);}else{switch(r.status){case"Excellent":s("Success",r.status,5);break;case"Good":s("Success",r.status,4);break;case"Average":s("None",r.status,3);break;case"Poor":s("Warning",r.status,2);break;case"Very Poor":s("Error",r.status,1);}}}});function s(a,T,v){t._oFeedbackDialog.ratingStatus.setState(a);t._oFeedbackDialog.ratingStatus.setText(T);t._oFeedbackDialog.ratingStatus.value=v;if(v){t._oFeedbackDialog.sendButton.setEnabled(true);}else{t._oFeedbackDialog.sendButton.setEnabled(false);}}},onSearch:function(e){var Q=e.getParameter("query");if(!Q){return;}this.getRouter().navTo("search",{searchParam:Q},false);},onHeaderResize:function(e){var w=e.size.width,p=D.system.phone||w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this.getModel("appView").setProperty("/bPhoneSize",p);this._toggleTabHeaderClass();},_onOrientationChange:function(){this.getModel("appView").setProperty("/bLandscape",D.orientation.landscape);this._toggleTabHeaderClass();},onToggleSearchMode:function(e){var s=e.getParameter("isOpen"),v=this.getModel("appView");v.setProperty("/bSearchMode",s);this._toggleTabHeaderClass();if(s){q.sap.delayedCall(0,this,function(){this._oView.byId("searchControl").getAggregation("_searchField").getFocusDomRef().focus();});}},_registerFeedbackRatingIcons:function(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});},_getUI5Version:function(){return this.getModel("versionData").getProperty("/version");},_getUI5VersionGav:function(){return this.getModel("versionData").getProperty("/versionGav");},_getUI5Distribution:function(){var v=this._getUI5VersionGav();var u="SAPUI5";if(v&&/openui5/i.test(v)){u="OpenUI5";}return u;},_getCurrentPageRelativeURL:function(){var p=window.location;return p.pathname+p.hash+p.search;},_isToggleButtonVisible:function(){var v=this.getModel("appView"),h=v.getProperty("/bHasMaster"),p=v.getProperty("/bPhoneSize"),l=v.getProperty("/bLandscape"),s=v.getProperty("/bSearchMode");return h&&(p||!l)&&!s;},_toggleTabHeaderClass:function(){var t=this.getView().byId("tabHeader");if(this._isToggleButtonVisible()){t.addStyleClass("tabHeaderNoLeftMargin");}else{t.removeStyleClass("tabHeaderNoLeftMargin");}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/BaseController',["sap/ui/documentation/library","sap/ui/core/mvc/Controller","sap/ui/core/routing/History","sap/ui/Device","sap/m/library"],function(l,C,H,D,m){"use strict";var S=m.SplitAppMode;return C.extend("sap.ui.documentation.sdk.controller.BaseController",{_oCore:sap.ui.getCore(),onInit:function(){if(D.system.phone||D.system.tablet){this.getOwnerComponent().loadVersionInfo();}},hideMasterSide:function(){var s=this.getSplitApp();s.setMode(S.HideMode);},showMasterSide:function(){var s=this.getSplitApp();s.setMode(S.ShowHideMode);},getSplitApp:function(){return this.getView().getParent().getParent();},getRouter:function(){return this.getOwnerComponent().getRouter();},getModel:function(n){return this.getView().getModel(n);},setModel:function(M,n){return this.getView().setModel(M,n);},getConfig:function(){return this.getOwnerComponent().getMetadata().getConfig();},onNavBack:function(e){var p=H.getInstance().getPreviousHash();if(p!==undefined){history.go(-1);}else{var c=window.location.hash;if(c.indexOf("#/topic/")==0){this.getRouter().navTo("topic",{},true);}else if(c.indexOf("#/api/")==0){this.getRouter().navTo("api",{},true);}}},searchResultsButtonVisibilitySwitch:function(b){var p=H.getInstance().getPreviousHash();if(p&&p.indexOf("search/")===0){b.setVisible(true);}else{b.setVisible(false);}},getRootView:function(){var c=this.getOwnerComponent();return c.byId(c.getManifestEntry("/sap.ui5/rootView").id);},_getControlComponent:function(c,o){var L=o.libComponentInfos,a=l._getLibraryInfoSingleton();return a._getActualComponent(L,c);},_onOrientationChange:function(e){if(D.system.phone){this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape",e.landscape);}},_registerOrientationChange:function(){D.orientation.attachHandler(this._onOrientationChange,this);},_deregisterOrientationChange:function(){D.orientation.detachHandler(this._onOrientationChange,this);},handleLandingImageLoad:function(){this.getView().byId("landingImageHeadline").setVisible(true);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Code.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/model/json/JSONModel","sap/ui/core/Component"],function(q,B,C,J){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Code",{_aMockFiles:["products.json","supplier.json","img.json"],onInit:function(){this.oModel=new J();this.getView().setModel(this.oModel);this.router=this.getRouter();this.router.getRoute("code").attachPatternMatched(this.onRouteMatched,this);this.router.getRoute("code_file").attachPatternMatched(this.onRouteMatched,this);this._codeCache={};this._aFilesAvailable=[];this._bFirstLoad=true;},onRouteMatched:function(e){this.showMasterSide();this._sId=e.getParameter("arguments").id;this._sFileName=decodeURIComponent(e.getParameter("arguments").fileName);C.loadData().then(function(d){this._loadCode(d);}.bind(this));},_loadCode:function(d){var f=this._sFileName;var s=d.samples[this._sId];if(!s){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}if(!this._oData||s.id!==this._oData.id){var c='sampleComp-'+this._sId;var a=this._sId;var o=sap.ui.component(c);if(!o){o=sap.ui.getCore().createComponent({id:c,name:a});}var m=o.getMetadata();var b=(m)?m.getConfig():null;this._oData={id:s.id,title:"Code: "+s.name,name:s.name,stretch:b.sample?b.sample.stretch:false,files:[],iframe:b.sample.iframe,fileName:f,includeInDownload:b.sample.additionalDownloadFiles};if(b&&b.sample&&b.sample.files){var r=q.sap.getModulePath(s.id);for(var i=0;i<b.sample.files.length;i++){var F=b.sample.files[i];var e=this.fetchSourceFile(r,F);this._oData.files.push({name:F,raw:e,code:this._convertCodeToHtml(e)});this._aFilesAvailable.push(F);}}}else{this._oData.fileName=f;}this.oModel.setData(this._oData);if(f==="undefined"){f=this._getInitialFileName();}if(this._aFilesAvailable.indexOf(f)===-1){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}this._updateCodeEditor(f);this._getTabHeader().setSelectedKey(f);var p=this.getView().byId("page");p.scrollTo(0);},fetchSourceFile:function(r,f){var t=this;var u=r+"/"+f;var s=function(a){t._codeCache[u]=a;};var e=function(a){t._codeCache[u]="not found: '"+u+"'";};if(!(u in this._codeCache)){this._codeCache[u]="";q.ajax(u,{async:false,dataType:"text",success:s,error:e});}return t._codeCache[u];},onDownload:function(e){q.sap.require("sap.ui.thirdparty.jszip");var a=sap.ui.require("sap/ui/thirdparty/jszip");var z=new a();var d=this.oModel.getData();for(var i=0;i<d.files.length;i++){var f=d.files[i],r=f.raw;if(f.name&&(f.name===d.iframe||f.name.split(".").pop()==="html")){r=this._changeIframeBootstrapToCloud(r);}z.file(f.name,r);for(var j=0;j<this._aMockFiles.length;j++){var m=this._aMockFiles[j];if(f.raw.indexOf(m)>-1){z.file("mockdata/"+m,this.downloadMockFile(m));}}}var R=q.sap.getModulePath(this._sId),E=d.includeInDownload||[],t=this;if(!d.iframe){z.file("Component.js",this.fetchSourceFile(R,"Component.js"));z.file("index.html",this._changeIframeBootstrapToCloud(this.createIndexFile(d)));}E.forEach(function(F){z.file(F,t.fetchSourceFile(R,F));});var c=z.generate({type:"blob"});this._openGeneratedFile(c);},_openGeneratedFile:function(c){q.sap.require("sap.ui.core.util.File");var F=sap.ui.require("sap/ui/core/util/File");F.save(c,this._sId,"zip","application/zip");},createIndexFile:function(d){var h,s;var r=q.sap.getModulePath("sap.ui.documentation.sdk.tmpl");var i=this.fetchSourceFile(r,"index.html.tmpl");i=i.replace(/{{TITLE}}/g,d.name);i=i.replace(/{{SAMPLE_ID}}/g,d.id);h=d.stretch?'height : "100%", ':"";i=i.replace(/{{HEIGHT}}/g,h);s=!d.stretch;i=i.replace(/{{SCROLLING}}/g,s);return i;},downloadMockFile:function(f){var r=q.sap.getModulePath("sap.ui.demo.mock");var w="test-resources/sap/ui/documentation/sdk/images/";var c="https://openui5.hana.ondemand.com/test-resources/sap/ui/documentation/sdk/images/";var R=new RegExp(w,"g");var m=this.fetchSourceFile(r,f);if(m){m=m.replace(R,c);}return m;},onNavBack:function(){this.router.navTo("sample",{id:this._sId},true);},_convertCodeToHtml:function(c){q.sap.require("jquery.sap.encoder");c=c.toString();c=c.replace(/^function.+{/,"");c=c.replace(/}[!}]*$/,"");c=c.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/,"");c=c.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/,"");c=c.replace(/\t/g,"  ");return c;},_changeIframeBootstrapToCloud:function(r){q.sap.require("sap.ui.thirdparty.URI");var U=sap.ui.require("sap/ui/thirdparty/URI");var a=/src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/;var c=new U(window.location.href).search("");var R=new U(q.sap.getResourcePath("","/sap-ui-core.js"));var b=R.absoluteTo(c).toString();return r.replace(a,'src="'+b+'"');},handleTabSelectEvent:function(e){var f=e.getParameter("selectedKey");this._bFirstLoad=false;this.router.navTo("code_file",{id:this._sId,fileName:encodeURIComponent(f)},false);},_updateCodeEditor:function(f){var c=this._getCodeEditor(),a=c._getEditorInstance(),A=a.renderer;c.setValue(this._getCode(f));c.setType(this._getFileType(f));a.gotoLine(0,0,false);if(this._bFirstLoad){q.sap.delayedCall(0,this,function(){A.onResize();});}},_getCode:function(f){var F=this.getModel().getData().files,c="";F.forEach(function(o){if(o.name===f){c=o.raw;return true;}});return c;},_getFileType:function(f){var F=f.split('.').pop();return F==="js"?"javascript":F;},_getInitialFileName:function(){return(this._oData&&this._oData.files&&this._oData.files.length>0&&this._oData.files[0].name)||null;},_getCodeEditor:function(){if(!this.oCodeEditor){this.oCodeEditor=this.getView().byId("codeEditor");}return this.oCodeEditor;},_getTabHeader:function(){if(!this.oTabHeader){this.oTabHeader=this.getView().byId("tabHeader");}return this.oTabHeader;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Controls.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device"],function(q,B,D){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Controls",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},onPress:function(e){var f=e.oSource.getFilter(),s=this.getOwnerComponent().byId("controlsMaster").byId("searchField");s.setValue(f).fireLiveChange({newValue:f});q.sap.delayedCall(0,this,function(){this.getSplitApp().showMaster();});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ControlsMaster.controller',["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/m/GroupHeaderListItem","sap/ui/model/Filter","sap/ui/model/Sorter","jquery.sap.storage"],function(q,D,B,J,C,G,F,S,Q){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ControlsMaster",{_oStorage:Q.sap.storage(Q.sap.storage.Type.local),_sStorageKey:"UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",_oViewSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oDefaultSettings:{compactOn:false,themeActive:"sap_belize",rtl:false},_oListSettings:{filter:{},groupProperty:"category",groupDescending:false,version:q.sap.Version(sap.ui.version).getMajor()+"."+q.sap.Version(sap.ui.version).getMinor()},_mGroupFunctions:{"name":function(c){var k=c.getProperty("name").charAt(0);return{key:k,text:k};},"namespace":true,"category":true,"since":true,"formFactors":true},_sFilterValue:"",onInit:function(){var e,d,f,o=function(c){this._oView.getModel().setData({entityCount:c.entityCount,entities:c.entities});this.getModel("filter").setData(c.filter);this._toggleListItem(this._getItemToSelect(),true);}.bind(this);this._oRouter=this.getRouter();this._bNavToEntityViaList=false;this._oView=this.getView();C.loadData().then(o);e=new J();e.setSizeLimit(100000);this._oView.setModel(e);d=new J({listMode:(D.system.phone)?"None":"SingleSelectMaster",listItemType:(D.system.phone)?"Active":"Inactive"});d.setDefaultBindingMode("OneWay");this._oView.setModel(d,"viewModel");f=new J();f.setSizeLimit(100000);this.setModel(f,"filter");this._vsFilterBar=this._oView.byId("vsFilterBar");this._vsFilterLabel=this._oView.byId("vsFilterLabel");this._oRouter.getRoute("listFilter").attachPatternMatched(this._onFilterMatched,this);this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched,this);this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched,this);this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched,this);this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched,this);this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched,this);this.LIST_SCROLL_DURATION=0;this._iDomRenderingDelay=0;this._getList().addEventDelegate({onAfterRendering:function(){q.sap.delayedCall(this._iDomRenderingDelay,this,this._scrollToSelectedListItem);}},this);this._oCore.attachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.attachLocalizationChanged(this._onLocalizationChange,this);this._oView.addEventDelegate({onBeforeFirstShow:this.onBeforeFirstShow.bind(this)});this._oComponent=this.getOwnerComponent();this._oRootView=this.getRootView();this._oViewSettings.compactOn=this._oComponent.getContentDensityClass()==="sapUiSizeCompact";this._oViewSettings.rtl=this._oCore.getConfiguration().getRTL();this._oDefaultSettings.compactOn=this._oViewSettings.compactOn;this._oDefaultSettings.rtl=this._oViewSettings.rtl;this._initListSettings();},_viewSettingsResetOnNavigation:function(e){var r=e.getParameter("name");if(["group","entity","sample","code","code_file","controls","controlsMaster","listFilter"].indexOf(r)===-1){this._applyAppConfiguration(this._oDefaultSettings.themeActive,this._oDefaultSettings.compactOn,this._oDefaultSettings.rtl);this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}},_initListSettings:function(){var j=this._oStorage.get(this._sStorageKey);if(j){this._oListSettings=JSON.parse(j);}},_applyAppConfiguration:function(t,c,r){var s,$,o,a;this._oCore.applyTheme(t);q(document.body).toggleClass("sapUiSizeCompact",c);q(document.body).toggleClass("sapUiSizeCozy",!c);this._oCore.getConfiguration().setRTL(r);if(this._oComponent._oCurrentOpenedSample){o=this._oComponent._oCurrentOpenedSample.getComponentInstance().getRootControl();if(o){a=o.getContent()[0];if(a){a.invalidate();}}}$=q("#sampleFrame");if($.length>0){s=$[0].contentWindow;if(s){s.sap.ui.getCore().applyTheme(t);s.sap.ui.getCore().getConfiguration().setRTL(r);s.jQuery('body').toggleClass("sapUiSizeCompact",c).toggleClass("sapUiSizeCozy",!c);}}},_onGroupMatched:function(e){this._onMatched('#/group/',e);},_onEntityMatched:function(e){this._onMatched('#/entity/',e);},_onSampleMatched:function(e){this._onMatched('#/sample/',e);},_onMatched:function(n,e){var E=this._getList().getModel(),s=e.getParameter("arguments").id;this.showMasterSide();this._topicId=n+s;this._entityId=s;E.refresh();this._updateListSelection();},_onControlsMasterMatched:function(e){this.showMasterSide();if(!D.system.phone){this.getRouter().navTo("controls");}},_onFilterMatched:function(e){var f=e.getParameter("arguments").value,s;if(f){s=this.getView().byId("searchField");s.setValue(f).fireLiveChange({newValue:f});q.sap.delayedCall(0,this,function(){this.getSplitApp().showMaster();});if(D.system.phone){this.getRouter().navTo("controlsMaster",{});}}this._onControlsMatched(e);},_onControlsMatched:function(){this.showMasterSide();this._resetListSelection();},_onLocalizationChange:function(e){this._iDomRenderingDelay=3000;q.sap.delayedCall(this._iDomRenderingDelay,this,function(){this._iDomRenderingDelay=0;});},onNavToEntity:function(e){var i=e.getParameter("listItem"),I=(i)?i:e.getSource(),p=I.getBindingContext().getPath(),E=this.getView().getModel().getProperty(p),r=!D.system.phone;this._bNavToEntityViaList=true;this.getRouter().navTo("entity",{id:E.id,part:"samples"},r);},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},_updateListSelection:function(){var i=this._getItemToSelect();if(!i){return;}this._toggleListItem(i,true);if(!this._bNavToEntityViaList){q.sap.delayedCall(0,this,this._scrollToSelectedListItem);}this._bNavToEntityViaList=false;},_resetListSelection:function(){var s=this._getList().getSelectedItem();if(s){this._toggleListItem(s,false);q.sap.delayedCall(0,this,this._scrollPageTo,[0,0]);}},_toggleListItem:function(i,s){this._getList().setSelectedItem(i,s,false);},_scrollToSelectedListItem:function(){var i=this._getList().getSelectedItem();if(i){this._getPage().scrollToElement(i,this.LIST_SCROLL_DURATION);}},_scrollPageTo:function(p,d){this._getPage().scrollTo(p,d);},_getItemToSelect:function(){var l=this._getList(),e=l.getModel(),E,i,I,L=this._entityId,o=null;l.getItems().forEach(function(a){i=a.getBindingContext();if(i){I=i.getPath();E=e.getProperty(I);if(E.id===L){o=a;return false;}}});return o;},_getPage:function(){if(!this.oPage){this.oPage=this.byId("exploredMasterPage");}return this.oPage;},_getList:function(){if(!this.oList){this.oList=this.byId("exploredMasterList");}return this.oList;},onBeforeFirstShow:function(){this._updateView();},onExit:function(){this._oCore.detachThemeChanged(this._scrollToSelectedListItem,this);this._oCore.detachLocalizationChanged(this._onLocalizationChange,this);},onConfirmViewSettings:function(e){var g=e.getParameter("groupItem");this._oListSettings.filter=e.getParameter("filterCompoundKeys");this._oListSettings.groupProperty=g?g.getKey():null;this._oListSettings.groupDescending=e.getParameter("groupDescending");this._oStorage.put(this._sStorageKey,JSON.stringify(this._oListSettings));this._updateView();},handleListSettings:function(){if(!this._oVSDialog){this._oVSDialog=sap.ui.xmlfragment(this.getView().getId(),"sap.ui.documentation.sdk.view.viewSettingsDialog",this);this.getView().addDependent(this._oVSDialog);}this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);this._oVSDialog.open();},handleListFilter:function(e){this._sFilterValue=e.getParameter("newValue").trim();this._updateView();},_updateListBinding:function(){var f,s,a=[],b=[],c=false,g=false,l=this._oView.byId("exploredMasterList"),o=l.getBinding("items");c=true;a.push(new F("searchTags","Contains",this._sFilterValue));q.each(this._oListSettings.filter,function(p,v){var P=[];q.each(v,function(k,V){var O=(p==="formFactors")?"Contains":"EQ";P.push(new F(p,O,k));});c=true;a.push(new F(P,false));});if(c&&a.length===0){o.filter(a,"Application");}else if(c&&a.length>0){f=new F(a,true);o.filter(f,"Application");}if(this._oListSettings.groupProperty&&this._oListSettings.groupProperty!==this._sCurrentGroup){g=true;}else if(this._oListSettings.groupProperty&&this._oListSettings.groupDescending!==this._bCurrentlyGroupedDescending){g=true;}if(g){s=new S(this._oListSettings.groupProperty,this._oListSettings.groupDescending,this._mGroupFunctions[this._oListSettings.groupProperty]);b.push(s);b.push(new S("name",false));o.sort(b);}this._sCurrentGroup=this._oListSettings.groupProperty;this._bCurrentlyGroupedDescending=this._oListSettings.groupDescending;this._bIsViewUpdatedAtLeastOnce=true;},_updateView:function(){this._updateFilterBarDisplay();this._updateListBinding();},_updateFilterBarDisplay:function(){var f=[];q.each(this._oListSettings.filter,function(p,v){f=f.concat(Object.keys(v));});if(f.length>0){this._vsFilterBar.setVisible(true);this._vsFilterLabel.setText(f.join(", "));}else{this._vsFilterBar.setVisible(false);}},handleSettings:function(){if(!this._oSettingsDialog){this._oSettingsDialog=new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog",this);this._oView.addDependent(this._oSettingsDialog);}q.sap.delayedCall(0,this,function(){var a=this._oCore.getConfiguration(),t=this._oCore.byId("ThemeSelect"),u=q.sap.getUriParameters().get("sap-theme"),c=this._oViewSettings.compactOn;t.setSelectedKey(u?u:a.getTheme());this._oCore.byId("RTLSwitch").setState(a.getRTL());this._oCore.byId("CompactModeSwitch").setState(c);this._oSettingsDialog.open();});},handleCloseAppSettings:function(){this._oSettingsDialog.close();},handleSaveAppSettings:function(){var a,c=this._oCore.byId('CompactModeSwitch').getState(),t=this._oCore.byId('ThemeSelect').getSelectedKey(),r=this._oCore.byId('RTLSwitch').getState();this._oSettingsDialog.close();if(!this._oBusyDialog){q.sap.require("sap.m.BusyDialog");a=sap.ui.require("sap/m/BusyDialog");this._oBusyDialog=new a();this.getView().addDependent(this._oBusyDialog);}this._oBusyDialog.open();q.sap.delayedCall(1000,this,function(){this._oBusyDialog.close();});this._oViewSettings.compactOn=c;this._oViewSettings.themeActive=t;this._oViewSettings.rtl=r;this._applyAppConfiguration(t,c,r);this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation,this);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/DemoApps.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController"],function(q,B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.DemoApps",{onInit:function(){this.getRouter().getRoute("demoapps").attachPatternMatched(this._onMatched,this);},_onMatched:function(){try{this.hideMasterSide();}catch(e){q.sap.log.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Downloads.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Downloads",{onInit:function(){this.getRouter().getRoute("downloads").attachPatternMatched(this._onMatched,this);},_onMatched:function(){this.hideMasterSide();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Entity.controller',["sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/BaseController","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/controller/util/EntityInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/ui/documentation/sdk/controller/util/JSDocUtil"],function(J,B,C,E,T,a){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Entity",{onInit:function(){this.router=this.getRouter();this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched,this);this._oObjectPage=this.getView().byId("ObjectPageLayout");this.getView().setModel(new J());},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.getRouter().navTo("entity",{id:t},false);},onAPIRefPress:function(e){var s=e.getSource().data("name");this.getRouter().navTo("apiId",{id:s},false);},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true);},onNavBack:function(e){this.router.myNavBack("home",{});},onNavToSample:function(e){var p=e.getSource().getBindingContext().getPath();var s=this.getView().getModel().getProperty(p);this.router.navTo("sample",{id:s.id});},_wrapInSpanTag:function(t){var f=a.formatTextBlock(t,{linkFormatter:function(s,t){var r="entity",b,m,p;t=t||s;if(s.match("://")){return'<a target="_blank" href="'+s+'">'+t+'</a>';}s=s.trim().replace(/\.prototype\./g,"#");p=s.indexOf("#");if(p===0){return"<code>"+s.slice(1)+"</code>";}else if(p>0){s=s.slice(0,p);}m=s.match(/^topic:(\w{32})$/);if(m){s=m[1];r="topic";}b=s.split('/');if(b.length>1&&["methods","events"].indexOf(b[1].toLowerCase())!==-1){r="api";}return'<a class="jsdoclink" href="#/'+r+'/'+s+'">'+t+'</a>';}});return'<span class="sapUiDocumentationJsDoc">'+f+'</span>';},_TAB_KEYS:["samples","about"],_loadSample:function(c){var n=this._sNewId;var f=c.entities.filter(function(b){return b.id===n;});var e=f.length?f[0]:undefined;function u(){if(this._TAB_KEYS.indexOf(this._sNewTab)===-1){this._sNewTab="samples";}if(!d.show[this._sNewTab]){this._sNewTab="samples";}this._switchPageTab();jQuery.sap.delayedCall(0,this,function(){this._oObjectPage.setBusy(false);});}var d;if(this._sId!==n){E.getEntityDocuAsync(n,e&&e.namespace).then(function(D){if(!e&&!D){this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}d=this._getViewData(n,D,e,c);this.getView().getModel().setData(d,false);this._sId=n;u.call(this);}.bind(this));}else{d=this.getView().getModel().getData();u.call(this);}},onRouteMatched:function(e){this._oObjectPage.setBusy(true);this._sNewId=e.getParameter("arguments").id;this._sNewTab=e.getParameter("arguments").sectionTab;C.loadData().then(function(d){this._loadSample(d);}.bind(this));this.searchResultsButtonVisibilitySwitch(this.getView().byId("entityBackToSearch"));},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_getViewData:function(i,d,e,c){var D=this._convertEntityInfo(i,d,c),s=false,S=0;if(e){if(!D.shortDescription&&e.description){D.shortDescription=e.description;}if(e.docuLink){D.show.introLink=true;D.docuLink=e.docuLink.replace("docs/guide","topic").replace(/\.html$/,"");}else{D.show.introLink=false;}if(!D.baseName){D.baseName=e.name;}s=e.samples.length>0;S=e.samples.length;}D.show.samples=s;D.count.samples=S;D.entity=e;return D;},_convertEntityInfo:function(i,d,c){var D={name:i,deprecated:(d)?this._formatDeprecated(d.deprecation):null,deprecatedMark:(d)?this._createDeprecatedMark(d.deprecation):null,baseType:(d)?this._formatType(d.baseType):null,baseTypeText:(d)?this._formatTypeText(d.baseType):"-",baseTypeNav:(d)?this._formatTypeNav(d.baseType):null,shortDescription:(d)?this._formatDeprecatedDescription(d.deprecation):null,description:(d)?this._wrapInSpanTag(d.doc):null,docuLink:null,values:d?d.values:[],show:{baseType:(d)?!!d.baseType:false,about:!!d,values:false,introActive:false},count:{samples:0},appComponent:this._getControlComponent(i,c)};if(!d){return D;}D.show.values=Array.isArray(D.values)&&D.values.length>0;return D;},_formatDeprecated:function(d){return(d&&d.length>0)?"true":"false";},_formatDeprecatedDescription:function(d){return(d&&d.length>0)?(this._createDeprecatedMark(d)+": "+d):null;},_formatType:function(t){if(!t){return null;}else{return t.replace("[]","");}},_formatTypeText:function(t){if(!t){return null;}else{t=t.replace("sap.ui.core.","");var i=t.lastIndexOf(".");return(i!==-1)?t.substr(i+1):t;}},_createDeprecatedMark:function(d){return(d)?"Deprecated":"";},_switchPageTab:function(){var s=this.getView().byId(this._sNewTab);if(!s){return;}if(this._oObjectPage){this._oObjectPage.attachEvent("onAfterRenderingDOMReady",function(){this._oObjectPage.setSelectedSection(s.getId());},this);}},backToSearch:function(){this.onNavBack();},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string"],_formatTypeNav:function(t){return this._baseTypes.indexOf(t)===-1;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ErrorHandler',["sap/ui/base/Object","sap/m/MessageBox"],function(U,M){"use strict";return U.extend("sap.ui.documentation.sdk.controller.ErrorHandler",{constructor:function(c){this._oComponent=c;this._oModel=c.getModel();this._bMessageOpen=false;this._sErrorText="Sorry, a technical error occurred! Please try again later.";},_showMetadataError:function(d){M.error(this._sErrorText,{id:"metadataErrorMessageBox",details:d,styleClass:this._oComponent.getContentDensityClass(),actions:[M.Action.RETRY,M.Action.CLOSE],onClose:function(a){if(a===M.Action.RETRY){this._oModel.refreshMetadata();}}.bind(this)});},_showServiceError:function(d){if(this._bMessageOpen){return;}this._bMessageOpen=true;M.error(this._sErrorText,{id:"serviceErrorMessageBox",details:d,styleClass:this._oComponent.getContentDensityClass(),actions:[M.Action.CLOSE],onClose:function(){this._bMessageOpen=false;}.bind(this)});}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Group.controller',["sap/ui/documentation/sdk/controller/BaseController"],function(B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Group",{onInit:function(){this.getRouter().getRoute("group").attachPatternMatched(this._onGroupMatched,this);},_onGroupMatched:function(e){this._id=e.getParameter("arguments").id;}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/MasterTreeBaseController',["jquery.sap.global","./BaseController","./util/TreeUtil","sap/ui/model/Filter","sap/ui/model/FilterOperator"],function(q,B,T,F,a){"use strict";var b=300;
var M=B.extend("sap.ui.documentation.sdk.controller.MasterTreeBaseController",{
_initTreeUtil:function(n,d){this._oTreeUtil=new T(n,d);},
_expandTreeToNode:function(t,m){var o=this.byId("tree"),d=m.getData();var e=this._oTreeUtil.getPathToNode(t,d);var l;e.forEach(function(i){var I=this._findTreeItem(i);if(I){o.getBinding("items").expand(o.indexOfItem(I));l=I;}},this);if(l){l.setSelected(true);q.sap.delayedCall(0,this,function(){if(l.getDomRef()&&!c(l.getDomRef())){this._scrollTreeItemIntoView(l);}});}},
_findTreeItem:function(I){var t=this.byId("tree");var o=t.getItems();for(var i=0;i<o.length;i++){var C=o[i].getCustomData()[0];if(C.getKey()==="nodeId"&&C.getValue()===I){return o[i];}}return null;},
_scrollTreeItemIntoView:function(i){var p=this.byId("page");p.scrollToElement(i.getDomRef(),b);},
onTreeFilter:function(e){var t=this.byId("tree");var f=e.getParameter("newValue").trim();var o=t.getBinding("items");if(this._filterTimeout){q.sap.clearDelayedCall(this._filterTimeout);}this._filterTimeout=q.sap.delayedCall(250,this,function(){if(f.length===0){o.filter([]);this._collapseAllNodes();return;}var d=[];if(f){var n=new F("name",a.Contains,f);d.push(n);}o.filter(d);this._expandAllNodes();this._filterTimeout=null;});},
_expandAllNodes:function(){var t=this.byId("tree");t.expandToLevel(10);},
_collapseAllNodes:function(){var t=this.byId("tree");t.collapseAll();},
_clearSelection:function(){var t=this.byId("tree"),i=t.getItems();if(i.length){i[0].setSelected(false);}},
_expandFirstNodeOnly:function(){var t=this.byId("tree");this._collapseAllNodes();t.getBinding("items").expand(0);},
onTreeExpandAll:function(e){this._expandAllNodes();},
onTreeCollapseAll:function(e){this._collapseAllNodes();}
});
function c(d){var r=d.getBoundingClientRect();return(r.top>=0&&r.left>=0&&r.bottom<=q(document).height()&&r.right<=q(document).width());}
return M;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/ReleaseNotes.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/library"],function(q,B,J,l){"use strict";var n="neo-app.json",s="resources/sap-ui-version.json";return B.extend("sap.ui.documentation.sdk.controller.ReleaseNotes",{onInit:function(){this._oView=this.getView();this._requestResources();this._resourceAvailabilityHandler();this._oModel=new J();this._oVersionModel=new J();this._oView.setModel(this._oModel);this._oView.setModel(this._oVersionModel,"select");l._loadAllLibInfo("","_getLibraryInfoAndReleaseNotes","",this._processLibInfo.bind(this));l._getAppInfo(this._processAppInfo.bind(this));},_processAppInfo:function(a){var v,m,M,V,o;if(!(a)){return;}v=q.sap.Version(a.version);m=v.getMajor();M=v.getMinor();if(v.getSuffix()!==""){if(M%2!==0){M=(M+1);}}V=m+"."+M;o={items:[]};while(M>=28){V=m+"."+M;o.items.push({key:V,value:V});M=M-2;}this._oVersionModel.setData(o);},_processLibInfo:function(L,o){var r,R=[],c=L.length,p,i;p=function(v,V){r+=V.notes.length;L[i].versions.push({version:v,notes:V.notes});L[i].versions.sort(function(a,b){return q.sap.Version(b.version).compareTo(a.version);});};for(i=0;i<c;i++){L[i]=o[L[i]];L[i].versions=[];if(L[i].relnotes){r=0;q.each(L[i].relnotes,p);if(r>0){R.push(L[i]);}}}this._oModel.setData({libs:R});this._hideBusyIndicator();},_requestResources:function(){this._oNeoAppJsonPromise=q.ajax(n);this._oSapUiVersionJsonPromise=q.ajax(s);},_resourceAvailabilityHandler:function(){q.when(this._oNeoAppJsonPromise,this._oSapUiVersionJsonPromise).then(function(N,S){this._oNeoAppVersions=N[0].routes;this._sSapUiVersion=S[0].version;this._oView.byId("VersionSelect").setVisible(true);}.bind(this),function(){q.sap.log.warning("No neo-app.json was detected");});},_compareUI5Versions:function(v,V){var o=q.sap.Version(v),a=q.sap.Version(V);return(o.getMajor()+"."+o.getMinor())===(a.getMajor()+"."+a.getMinor());},_updateLastReleasedVersion:function(v){if(this._compareUI5Versions(v,this._sSapUiVersion)&&parseFloat(this._sLastReleasedVersion)>parseFloat(this._sSapUiVersion)){this._sLastReleasedVersion=this._sSapUiVersion;}},_getLastVersionFromNeoAppJson:function(S){var L=this._oNeoAppVersions?this._oNeoAppVersions.length:0,v,i;for(i=0;i<L;i++){v=this._oNeoAppVersions[i].target.version;if(this._compareUI5Versions(v,S)){return v;}}},handleVersionChange:function(e){var i=e.getParameter("selectedItem"),S=i.getKey(),v;this._sLastReleasedVersion=this._getLastVersionFromNeoAppJson(S);this._updateLastReleasedVersion(S);v=this._sLastReleasedVersion?this._sLastReleasedVersion:S;this._showBusyIndicator();l._loadAllLibInfo("","_getLibraryInfoAndReleaseNotes",v,this._processLibInfo.bind(this));},_showBusyIndicator:function(){this.getView().byId("releaseNotesObjectPage").setBusy(true);},_hideBusyIndicator:function(){this.getView().byId("releaseNotesObjectPage").setBusy(false);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Sample.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/core/Component","sap/ui/core/ComponentContainer","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/m/Text","sap/ui/core/HTML","sap/ui/Device","sap/ui/core/routing/History","sap/m/library"],function(q,B,J,C,a,b,T,c,H,D,d,m){"use strict";var U=m.URLHelper;return B.extend("sap.ui.documentation.sdk.controller.Sample",{onInit:function(){this.getRouter().getRoute("sample").attachPatternMatched(this._onSampleMatched,this);this._viewModel=new J({showNavButton:true,showNewTab:false});Promise.all([sap.ui.getCore().loadLibrary("sap.ui.fl",{async:true}),sap.ui.getCore().loadLibrary("sap.ui.rta",{async:true})]).then(this._loadRTA.bind(this));this.getView().setModel(this._viewModel);},_onSampleMatched:function(e){var p=this.getView().byId("page");p.setBusy(true);this._sId=e.getParameter("arguments").id;b.loadData().then(function(o){this._loadSample(o);}.bind(this));},_loadSample:function(o){var p=this.getView().byId("page"),h=d.getInstance(),P=h.getPreviousHash(),M=this._viewModel.getData(),s=o.samples[this._sId],e;if(!s){q.sap.delayedCall(0,this,function(){p.setBusy(false);});this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);return;}M.showNavButton=D.system.phone||!!P;M.previousSampleId=s.previousSampleId;M.nextSampleId=s.nextSampleId;p.setTitle("Sample: "+s.name);try{e=this._createComponent();}catch(f){p.removeAllContent();p.addContent(new c({text:"Error while loading the sample: "+f}));q.sap.delayedCall(0,this,function(){p.setBusy(false);});return;}this.getOwnerComponent()._oCurrentOpenedSample=e?e:undefined;var g=(this._oComp.getMetadata())?this._oComp.getMetadata().getConfig():null;var S=g&&g.sample||{};M.showNewTab=!!S.iframe;if(S.iframe){e=this._createIframe(e,S.iframe);}else{this.sIFrameUrl=null;}var i=!!S.stretch;var j=i?"100%":null;p.setEnableScrolling(!i);if(e.setHeight){e.setHeight(j);}p.removeAllContent();p.addContent(e);p.scrollTo(0);this._viewModel.setData(M);q.sap.delayedCall(0,this,function(){p.setBusy(false);});},onNewTab:function(){U.redirect(this.sIFrameUrl,true);},onPreviousSample:function(e){this.getRouter().navTo("sample",{id:this._viewModel.getProperty("/previousSampleId")},true);},onNextSample:function(e){this.getRouter().navTo("sample",{id:this._viewModel.getProperty("/nextSampleId")},true);},_createIframe:function(i,I){var s=this._sId,r=/\/([^\/]*)$/,e=/\..+$/,f,F,g;if(typeof I==="string"){f=r.exec(I);F=(f&&f.length>1?f[1]:I);g=e.exec(F)[0];var h=I.replace(e,"");this.sIFrameUrl=q.sap.getModulePath(s+"."+h,g||".html");}else{q.sap.log.error("no iframe source was provided");return;}if(!this._oHtmlControl){this._oHtmlControl=new H({id:"sampleFrame",content:'<iframe src="'+this.sIFrameUrl+'" id="sampleFrame" frameBorder="0"></iframe>'}).addEventDelegate({onAfterRendering:function(){if(!this._oHtmlControl._jQueryHTMLControlLoadEventAttached){this._oHtmlControl.$().on("load",function(){var S=this._oHtmlControl.$()[0].contentWindow;S.sap.ui.getCore().attachInit(function(){var j=this.getRootView().hasStyleClass("sapUiSizeCompact");S.sap.ui.getCore().applyTheme(this._oCore.getConfiguration().getTheme());S.sap.ui.getCore().getConfiguration().setRTL(this._oCore.getConfiguration().getRTL());S.jQuery('body').toggleClass("sapUiSizeCompact",j).toggleClass("sapUiSizeCozy",j);}.bind(this));}.bind(this));this._oHtmlControl._jQueryHTMLControlLoadEventAttached=true;}}.bind(this)});}else{this._oHtmlControl.getDomRef().src=this.sIFrameUrl;}return this._oHtmlControl;},_createComponent:function(){var s='sampleComp-'+this._sId;var e=this._sId;var M=this.getOwnerComponent();this._oComp=sap.ui.component(s);if(this._oComp){this._oComp.destroy();}return M.runAsOwner(function(){this._oComp=sap.ui.getCore().createComponent({id:s,name:e});return new a({component:this._oComp});}.bind(this));},onNavBack:function(e){this.getRouter().myNavBack("home",{});},onNavToCode:function(e){this.getRouter().navTo("code",{id:this._sId},false);},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},_oRTA:null,_loadRTA:function(){sap.ui.require(["sap/ui/fl/Utils","sap/ui/fl/FakeLrepConnectorLocalStorage"],function(e,F){e.checkControlId=function(){return true;};F.enableFakeConnector({"isProductiveSystem":true});this.getView().byId("toggleRTA").setVisible(true);this.getRouter().attachRouteMatched(function(){if(this._oRTA){this._oRTA.destroy();this._oRTA=null;}},this);}.bind(this));},onToggleAdaptationMode:function(e){sap.ui.require(["sap/ui/rta/RuntimeAuthoring"],function(R){if(!this._oRTA){this._oRTA=new R({flexSettings:{developerMode:false}});this._oRTA.setRootControl(this.getView().byId("page").getContent()[0]);this._oRTA.attachStop(function(){this._oRTA.destroy();delete this._oRTA;}.bind(this));this._oRTA.start();}}.bind(this));}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/SearchPage.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/m/GroupHeaderListItem"],function(q,B,J,G){"use strict";return B.extend("sap.ui.documentation.sdk.controller.SearchPage",{onInit:function(){this.setModel(new J());this.bindListResults();this.getRouter().getRoute("search").attachPatternMatched(this._onTopicMatched,this);},bindListResults:function(){this.dataObject={data:[]};this.getModel().setData(this.dataObject);},_onTopicMatched:function(a){var t=this,Q=a.getParameter("arguments").searchParam;this.dataObject.searchTerm=Q;this._modelRefresh();try{this.hideMasterSide();}catch(e){q.sap.log.error(e);}var s="(category:topics) AND ("+encodeURIComponent(Q)+")";var b="(category:apiref) AND ("+encodeURIComponent(Q)+")";var c="(category:entity) AND ("+encodeURIComponent(Q)+")";var P=new Promise(function(r){q.ajax({url:"search?q="+s,dataType:"json",success:function(D,S,x){r(D,S,x);},error:function(){r([]);}});});var d=new Promise(function(r){q.ajax({url:"search?q="+b,dataType:"json",success:function(D,S,x){r(D,S,x);},error:function(){r([]);}});});var f=new Promise(function(r){q.ajax({url:"search?q="+c,dataType:"json",success:function(D,S,x){r(D,S,x);},error:function(){r([]);}});});Promise.all([P,d,f]).then(function(r){var D={},R=r[0][0]||{},o=r[1][0]||{},g=r[2][0]||{};R.matches=R.matches||[];o.matches=o.matches||[];g.matches=g.matches||[];D.success=R.success||o.success||g.success||false;D.totalHits=(R.totalHits+o.totalHits+g.totalHits)||0;D.matches=R.matches.concat(o.matches).concat(g.matches);t.processResult(D);}).catch(function(r){});},processResult:function(d){this.dataObject.data=[];this.dataObject.dataAPI=[];this.dataObject.dataDoc=[];this.dataObject.dataExplored=[];this.dataObject.AllLength=0;this.dataObject.APILength=0;this.dataObject.DocLength=0;this.dataObject.ExploredLength=0;if(d&&d.success){if(d.totalHits==0){q(".sapUiRrNoData").html("No matches found.");}else{for(var i=0;i<d.matches.length;i++){var D=d.matches[i];D.modifiedStr=D.modified+"";var m=D.modifiedStr.substring(0,4)+"/"+D.modifiedStr.substring(4,6)+"/"+D.modifiedStr.substring(6,8)+", "+D.modifiedStr.substring(8,10)+":"+D.modifiedStr.substring(10),n=D.path,s=false,c;if(n.indexOf("topic/")===0){n=n.substring(0,n.lastIndexOf(".html"));s=true;c="Documentation";this.dataObject.dataDoc.push({index:this.dataObject.DocLength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.DocLength++;}else if(n.indexOf("entity/")===0){s=true;c="Samples";this.dataObject.dataExplored.push({index:this.dataObject.ExploredLength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.ExploredLength++;}else if(n.indexOf("docs/api/symbols/")===0){n=n.substring("docs/api/symbols/".length,n.lastIndexOf(".html"));n="api/"+n;s=true;c="API Reference";this.dataObject.dataAPI.push({index:this.dataObject.APILength,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.APILength++;}if(s){this.dataObject.data.push({index:i,title:D.title?D.title:"Untitled",path:n,summary:D.summary?(D.summary+"..."):"",score:D.score,modified:m,category:c});this.dataObject.AllLength++;}}}}else{q(".sapUiRrNoData").html("Search failed, please retry ...");}this._modelRefresh();},_modifyLinks:function(){var v=this.getView(),i=[].concat(v.byId("allList").getItems(),v.byId("apiList").getItems(),v.byId("documentationList").getItems(),v.byId("samplesList").getItems()),l=i.length,I;while(l--){I=i[l];if(I._getLinkSender){I._getLinkSender().setHref("#/"+I.getCustomData()[0].getValue());}}},_modelRefresh:function(){this.getModel().refresh();this._modifyLinks();},getGroupHeader:function(g){return new G({title:g.key,upperCase:false});},categoryAPIFormatter:function(c){return c==="API Reference";},categoryDocFormatter:function(c){return c==="Documentation";},categoryExploredFormatter:function(c){return c==="Samples";},onAllLoadMore:function(e){this.dataObject.visibleAllLength=e.getParameter("actual");this._modelRefresh();},onAPILoadMore:function(e){this.dataObject.visibleAPILength=e.getParameter("actual");this._modelRefresh();},onDocLoadMore:function(e){this.dataObject.visibleDocLength=e.getParameter("actual");this._modelRefresh();},onExploredLoadMore:function(e){this.dataObject.visibleExploredLength=e.getParameter("actual");this._modelRefresh();}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Tools.controller',["jquery.sap.global","sap/ui/Device","sap/ui/documentation/sdk/controller/BaseController"],function(q,D,B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Tools",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});this.getRouter().getRoute("tools").attachPatternMatched(this._onMatched,this);},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},_onMatched:function(){try{this.hideMasterSide();}catch(e){q.sap.log.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicDetail.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/XML2JSONUtils","sap/ui/Device","sap/ui/documentation/sdk/util/ToggleFullScreenHandler"],function(q,B,J,X,D,T){"use strict";return B.extend("sap.ui.documentation.sdk.controller.TopicDetail",{onInit:function(){this.oPage=this.byId("topicDetailPage");this.oPage.addStyleClass('docuPage');if(!window.prettyPrint){q.sap.require("sap.ui.documentation.sdk.thirdparty.google-code-prettify.prettify");}this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);this._oConfig=this.getConfig();this.jsonDefModel=new J();this.getView().setModel(this.jsonDefModel);},onBeforeRendering:function(){D.orientation.detachHandler(this._onOrientationChange,this);},onAfterRendering:function(){D.orientation.attachHandler(this._onOrientationChange,this);},onExit:function(){D.orientation.detachHandler(this._onOrientationChange,this);},_onTopicMatched:function(e){var t=e.getParameter("arguments").id,a=this._oConfig.docuPath+t+(t.match(/\.html/)?"":".html"),h=q.sap.syncGetText(a).data,j;if(!h){q.sap.delayedCall(0,this,function(){this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);});return;}j=X.XML2JSON(h,this._oConfig);j.topicURL=a;this.jsonDefModel.setData(j);this._scrollContentToTop();setTimeout(window.prettyPrint,0);this.searchResultsButtonVisibilitySwitch(this.getView().byId("topicDetailBackToSearch"));if(this.extHookonTopicMatched){this.extHookonTopicMatched(t);}},_scrollContentToTop:function(){if(this.oPage&&this.oPage.$().length>0){this.oPage.getScrollDelegate().scrollTo(0,1);}},_formatHTML:function(h){return'<div>'+h+'</div>';},_onOrientationChange:function(e){var p=this.getView().byId("topicDetailPage");if(e.landscape){p.setShowHeader(false);}else{p.setShowHeader(true);}},backToSearch:function(t){this.onNavBack();},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicDetailInitial.controller',["sap/ui/documentation/sdk/controller/BaseController","sap/ui/Device"],function(B,D){"use strict";return B.extend("sap.ui.documentation.sdk.controller.TopicDetailInitial",{onInit:function(){B.prototype.onInit.call(this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},onDownloadButtonPress:function(){window.open(this._determineFileLocation(),"_blank");},_determineFileLocation:function(){var v=this.getModel("versionData"),i=v.getProperty('/isDevVersion'),I=v.getProperty('/isOpenUI5');if(I){return'https://help.sap.com/OpenUI5_PDF/OpenUI5.pdf';}return i?'https://help.sap.com/DRAFT/SAPUI5_Internal_PDF/SAPUI5_Internal.pdf':'https://help.sap.com/SAPUI5_PDF/SAPUI5.pdf';}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/TopicMaster.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/MasterTreeBaseController","sap/ui/model/json/JSONModel","sap/m/library"],function(q,M,J,m){"use strict";var S=m.SplitAppMode;return M.extend("sap.ui.documentation.sdk.controller.TopicMaster",{onInit:function(){this.oJSONContent=this._fetchDocuIndex();var o=new J(this.oJSONContent);o.setSizeLimit(10000);this.getView().setModel(o);this._initTreeUtil("key","links");this.getRouter().getRoute("topic").attachPatternMatched(this._onMatched,this);this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched,this);},_onTopicMatched:function(a){try{this.showMasterSide();}catch(e){q.sap.log.error(e);}this._topicId=a.getParameter("arguments").id;this._expandTreeToNode(this._topicId,this.getModel());},_onMatched:function(){var s=this.getView().getParent().getParent();s.setMode(S.ShowHideMode);this._collapseAllNodes();this._clearSelection();},_fetchDocuIndex:function(){var r=q.sap.syncGetJSON(this.getConfig().docuPath+"index.json");if(r.data===undefined){return[];}var d=r.data.links;d=this._reorderDocuIndex(d);d=this._addSearchMetadata(d,"");return d;},_reorderDocuIndex:function(d){var s="95d113be50ae40d5b0b562b84d715227",t="1b4124400a764ec0a8623d0d5c585321",p=[],T,o;for(var i=0;i<d.length;i++){if(d[i].key===s){o=d[i];}else if(d[i].key===t){T=d[i];}}if(o){p=o.links;if(T){p.push(T);}}return p;},_addSearchMetadata:function(d,p){for(var i=0;i<d.length;i++){d[i].name=p?p+" "+d[i].text:d[i].text;if(d[i].links){d[i].links=this._addSearchMetadata(d[i].links,d[i].text);}}return d;},onNodeSelect:function(e){var n=e.getParameter("listItem"),t=n.getCustomData()[0].getValue(),r;if(!t){q.sap.log.warning("Missing key for entity: "+n.getId()+" - cannot navigate to topic");return;}r=this.getRouter();if(t==="a6a78b7e104348b4bb94fb8bcf003480"){r.navTo("releaseNotes");return;}r.navTo("topicId",{id:t},false);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/Welcome.controller',["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/m/library","sap/ui/Device"],function(q,B,m,D){"use strict";return B.extend("sap.ui.documentation.sdk.controller.Welcome",{onInit:function(){this.getRouter().getRoute("welcome").attachPatternMatched(this._onMatched,this);this._onOrientationChange({landscape:D.orientation.landscape});},onBeforeRendering:function(){this._deregisterOrientationChange();},onAfterRendering:function(){this._registerOrientationChange();},onExit:function(){this._deregisterOrientationChange();},navigateToDetails:function(e){var h=e.oSource.getHref()||e.oSource.getTarget();h=h.replace("#/","").split('/');var p=h[0];var a=h[1];e.preventDefault();this.getRouter().navTo(p,{id:a},true);},onGetStarted:function(){m.URLHelper.redirect("#/topic/8b49fc198bf04b2d9800fc37fecbb218");},_onMatched:function(){try{this.hideMasterSide();}catch(e){q.sap.log.error(e);}}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/APIInfo',['jquery.sap.global'],function(q){"use strict";var t;var l={};var a=null;var L=["sap.ui.demokit","sap.ui.documentation"];var b=["themelib_"];
function g(){if(l["index"]){return l["index"];}return new Promise(function(r,j){q.ajax({async:true,url:"./docs/api/api-index.json",dataType:'json',success:function(R){var k=R.symbols||[];l["index"]=k;r(k);},error:function(){q.sap.log.error("failed to load api-index.json");l["index"]=[];r([]);}});});}
function c(){if(l["deprecated"]){return l["deprecated"];}return new Promise(function(r,j){q.ajax({async:true,url:"./docs/api/api-index-deprecated.json",dataType:'json',success:function(R){l["deprecated"]=R;r(R);},error:function(){j();}});});}
function d(){if(l["experimental"]){return l["experimental"];}return new Promise(function(r,j){q.ajax({async:true,url:"./docs/api/api-index-experimental.json",dataType:'json',success:function(R){l["experimental"]=R;r(R);},error:function(){j();}});});}
function e(j){var r=[];if(!j){return r;}if(l[j]){return l[j];}q.ajax({async:false,url:t+j.replace(/\./g,'/')+'/designtime/api.json',dataType:'json',success:function(R){r=R.symbols;},error:function(){r=[];q.sap.log.error("failed to load api.json for: "+j);}});l[j]=r;return r;}
function f(j){if(!j){return Promise.resolve([]);}if(l[j]){return Promise.resolve(l[j]);}return new Promise(function(r){q.ajax({async:true,url:t+j.replace(/\./g,'/')+'/designtime/api.json',dataType:'json',success:function(R){var k=R.symbols||[];l[j]=k;r(k);},error:function(k){q.sap.log.error("failed to load api.json for: "+j);l[j]=[];r([]);}});});}
function i(o){var I=L.indexOf(o.name)!==-1;var S=b.some(function(p){return o.name.indexOf(p)===0;});return!I&&!S;}
function h(j){if(a){return a;}j=j||sap.ui.getVersionInfo().libraries||[];j=j.filter(i);var p=j.map(function(o){return f(o.name);});a=Promise.all(p);return a;}
function s(r){r=r==null?q.sap.getModulePath('','/')+'../test-resources/':r;if(r.slice(-1)!='/'){r+='/';}t=r;}
s();return{_setRoot:s,getIndexJsonPromise:g,getDeprecatedPromise:c,getExperimentalPromise:d,getLibraryElementsJSONSync:e,getLibraryElementsJSONPromise:f,getAllLibrariesElementsJSONPromise:h};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ConfigUtil',["jquery.sap.global","sap/ui/base/Object"],function(q,B){"use strict";return B.extend("sap.ui.documentation.sdk.controller.util.ConfigUtil",{constructor:function(c){this._oComponent=c;},hasMasterView:function(r){var R=this._getRouteConfig(r),i=R&&R.target.length===2;return!!i;},getMasterView:function(r){var m=this._getMasterTargetName(r),t=this._getTargetConfig(m),v=t.viewName;v="sap.ui.documentation.sdk.view."+q.sap.charToUpperCase(v,0);return this._oComponent.getRouter().getView(v);},_getMasterTargetName:function(r){var R=this._getRouteConfig(r),i=R&&R.target.length===2,m=i&&R.target[0];return m;},_getRouteConfig:function(r){var c=this._getSapUI5ConfigEntry(),R=c.routing.routes,a=q.grep(R,function(o){return o.name===r;}),o=a.length&&a[0];return o;},_getSapUI5ConfigEntry:function(){return this._oComponent.getMetadata().getManifestObject().getEntry("sap.ui5");},_getTargetConfig:function(t){return this._getSapUI5ConfigEntry().routing.targets[t];},destroy:function(){this._oComponent=null;return B.prototype.destroy.apply(this,arguments);}});});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/ControlsInfo',['jquery.sap.global','sap/ui/documentation/library'],function(q,l){"use strict";var p;var C={loadData:function(){if(!p){p=new Promise(function(r,a){l._loadAllLibInfo("","_getDocuIndex",function(L,d){var D=C._getIndices(L,d,function(){r(D);});});});}return p;},_getIndices:function(L,d,c){var a=["Action","Application","Container","Display","Chart","Mini Chart","Layout","List","Popup","Tile","User Input","Testing","Theming","Tutorial","Routing","Data Binding","Data Visualization","Map"];var b=["namespace","since","category"];var f={namespace:{},since:{},category:{},formFactors:{"Independent":true,"Condensed":true,"Compact":true,"Cozy":true}};var F={"-":"Independent","S":"Condensed","SM":"Condensed, Compact","SL":"Condensed, Cozy","SML":"Condensed, Compact, Cozy","M":"Compact","ML":"Compact, Cozy","L":"Cozy"};var e={};e={};e.entityCount=0;e.entities=[];e.filter={};e.samples={};q.each(d,function(i,D){if(!D.explored){return;}else if(!D.explored.samplesRef){q.sap.log.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef'");return;}else if(Array.isArray(D.explored.samplesRef)&&D.explored.samplesRef.length!==D.explored.samplesRef.filter(function(I){return I.namespace&&I.ref;}).length){q.sap.log.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");return;}else if(!Array.isArray(D.explored.samplesRef)&&!D.explored.samplesRef.namespace){q.sap.log.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.namespace'");return;}else if(!Array.isArray(D.explored.samplesRef)&&!D.explored.samplesRef.ref){q.sap.log.error("explored: cannot register lib '"+D.library+"'. missing 'explored.samplesRef.ref'");return;}else if(!D.explored.entities){q.sap.log.error("explored: cannot register lib '"+D.library+"'. missing 'explored.entities'");return;}else{q.sap.log.info("explored: now reading lib '"+D.library+"'");}if(Array.isArray(D.explored.samplesRef)){D.explored.samplesRef.forEach(function(I){q.sap.registerModulePath(I.namespace,""+I.ref);});}else{q.sap.registerModulePath(D.explored.samplesRef.namespace,""+D.explored.samplesRef.ref);}q.each(D.explored.samples,function(i,s){if(!s.id){q.sap.log.error("explored: cannot register sample '?'. missing 'id'");}else if(!s.name){q.sap.log.error("explored: cannot register sample '"+s.id+"'. missing 'name'");}else{e.samples[s.id]=s;}});q.each(D.explored.entities,function(j,E){if(!E.id){q.sap.log.error("explored: cannot register entity '?'. missing 'id'");return;}if(D.explored.entitiesDefaults){q.each(D.explored.entitiesDefaults,function(k,v){if(!E.hasOwnProperty(k)){E[k]=v;}});}var I=E.id.lastIndexOf(".");var n=(I!==-1)?E.id.substring(0,I):E.id;E.namespace=n;if(!E.name){q.sap.log.error("explored: cannot register entity '"+E.id+"'. missing 'name'");return;}if(a.indexOf(E.category)===-1){q.sap.log.error("explored: cannot register entity '"+E.id+"'. category '"+E.category+"' is not allowed");return;}if(!E.formFactors){q.sap.log.error("explored: cannot register entity '"+E.id+"'. missing 'formFactors'");return;}if(!F[E.formFactors]){q.sap.log.error("explored: cannot register entity '"+E.id+"'. formFactors '"+E.formFactors+"' is not allowed");return;}E.formFactors=F[E.formFactors];var A=false;q.each(b,function(i,s){if(!E[s]){q.sap.log.error("explored: cannot register entity '"+E.id+"'. missing '"+s+"'");A=true;return false;}});if(A){return;}q.each(b,function(i,s){f[s][E[s]]=true;});e.entities.push(E);});});q.each(e.entities,function(n,E){var i=0,s,h;E.searchTags=E.name+" "+E.name.replace(" ","")+" "+E.category;if(E.samples&&!(E.samples instanceof Array)){E.samples=[];q.sap.log.error("explored: cannot register samples for entity '"+E.id+"'. 'samples' is not an array");return;}if(!E.samples){E.samples=[];}if(E.samplesAsSteps){if(!(E.samplesAsSteps instanceof Array)){q.sap.log.error("explored: cannot register samples for entity '"+E.id+"'. 'samplesAsSteps' is not an array");return;}h=function(N){if(N.toString().length===1){return"0"+N;}return N;};for(;i<E.samplesAsSteps.length;i++){s={"id":E.id+"."+h(i+1),"name":E.name+" - Step "+(i+1)+" - "+E.samplesAsSteps[i]};if(i>0){s.previousSampleId=E.id+"."+h(i);}if(i<E.samplesAsSteps.length-1){s.nextSampleId=E.id+"."+h(i+2);}E.samples.push(s);e.samples[s.id]=s;E.searchTags+=" "+s.name;}}else{var S=[],k;q.each(E.samples,function(j,I){var m=e.samples[I];if(!m){q.sap.log.warning("explored: cannot register sample '"+I+"' for '"+E.id+"'. not found in the available docu indizes");}else{m.previousSampleId=(k?k.id:undefined);if(k){k.nextSampleId=m.id;}k=m;S.push(m);E.searchTags+=" "+m.name;}});E.samples=S;}E.sampleCount=E.samples.length;});e.entityCount=e.entities.length;q.each(f,function(s,h){e.filter[s]=[];q.each(h,function(k,v){e.filter[s].push({id:k});});});var o=l._getLibraryInfoSingleton();var g={};var P=[];for(var i=0;i<L.length;i++){P.push(new Promise(function(r){var h=function(j){g[j.library]=j.componentInfo;r();};o._getLibraryInfo(L[i],h);}));}Promise.all(P).then(function(){c&&c();});e.libComponentInfos=g;e.groups=this.getGroups(e.entities);return e;},findGroup:function(g,n){var a;for(var i=0;i<g.length;i++){a=g[i];if(a.name==n){return a;}}},getGroups:function(e){var g=[],a,b,s,c,i,j;for(i=0;i<e.length;i++){a=e[i];a.key='#/entity/'+a.id;s=a.samples;for(j=0;j<s.length;j++){c=s[j];c.key='#/sample/'+c.id+"/preview";}b=this.findGroup(g,a.category);if(!b){b={name:a.category,key:'#/group/'+a.category,controls:[a]};g.push(b);}else{b.controls.push(a);}}return g;}};return C;},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/EntityInfo',['jquery.sap.global','sap/ui/documentation/sdk/thirdparty/jsanalyzer/ModuleAnalyzer','./APIInfo'],function(q,a,A){"use strict";var r={};
function g(n){var P=n.split('.');var e=r;var l=P.length-1;for(var i=0;i<l&&!e.__noMetamodel&&!e.__noSource;i++){e=e[P[i]]||(e[P[i]]={});}return e;}
var C="boolean int float number function object string void any Element Control Component";
function b(t,s){if(t.indexOf("/")>=0){return t.replace(/\//g,".");}else if(t&&t.indexOf(".")<0&&C.indexOf(t)>=0){return"sap.ui.core."+t;}else{return s.split(".").slice(0,-1).concat([t.replace(/\//g,".")]).join(".");}}
function p(D,e){var $=q(D.documentElement);var E={metatype:'control',baseType:undefined,doc:undefined,deprecation:undefined,properties:{},aggregations:{},associations:{},events:{},methods:{}};var B=$.children("baseType").text();E.baseType=(B)?b(B,e):null;E.doc=h($);E.deprecation=j($);f($,"properties/property",function(i){E.properties[i.attr("name")]={kind:0,type:b(i.attr("type")||"string",e),defaultValue:i.attr("defaultValue")||"empty/undefined",doc:h(i),deprecation:j(i),since:i.attr("since")||null};});E.defaultAggregation=E.defaultAggregation||$.children("aggregations").attr("default");f($,"aggregations/aggregation",function(i){E.aggregations[i.attr("name")]={kind:i.attr("cardinality")==="0..1"?1:2,type:b(i.attr("type")||"sap.ui.core/Control",e),cardinality:i.attr("cardinality")||"0..n",visibility:i.attr("visibility")||null,doc:h(i),deprecation:j(i),since:i.attr("since")||null};});f($,"associations/association",function(i){E.associations[i.attr("name")]={kind:i.attr("cardinality")==="0..n"?4:3,type:b(i.attr("type")||"sap.ui.core/Control",e),cardinality:i.attr("cardinality")||"0..1",doc:h(i),deprecation:j(i),since:i.attr("since")||null};});f($,"events/event",function(i){var n=i.attr("name");E.events[n]={kind:5,doc:h(i),deprecation:j(i),since:i.attr("since")||null,parameters:[]};f(i,"parameters/parameter",function(l){E.events[n].parameters[l.attr("name")]={kind:6,type:b(l.attr("type")||"string",e),doc:h(l),since:l.attr("since")||null,deprecation:j(l)};});});f($,"methods/method",function(i){var n=i.attr("name");E.methods[n]={kind:7,type:b(i.attr("type")||"sap.ui.core/void",e),doc:h(i),deprecation:j(i),since:i.attr("since")||null,parameters:[]};f(i,"parameters/parameter",function(l){E.methods[n].parameters.push({kind:8,name:l.attr("name"),type:b(l.attr("type")||"sap.ui.core/Control",e),doc:h(l),since:l.attr("since")||null,deprecation:j(l)});});});return E;}
function c(D,e){var $=q(D.documentElement);var E={metatype:'type',doc:undefined,deprecation:false,values:{}};E.doc=h($);E.deprecation=j($);f($,"enumeration/value",function(i){var n=i.attr("name");E.values[n]={value:i.attr("value")||n,doc:h(i),deprecation:j(i)};});E.pattern=$.children("pattern").text();E.baseType=b($.children("baseType").text(),e);return E;}
function d(D,e,M){return a.analyze(D,e,M);}
function f($,N,l){q.each(N.split("/"),function(i,n){$=$.children(n);});$.each(function(i,e){l(q(e));});}
function h($){return $.children("documentation").text();}
function j($){return $.children("deprecation").text();}
function k(n,t,D,P,e){var E;q.ajax({async:false,url:q.sap.getModulePath(n,t),dataType:D,success:function(R){E=P(R,e,n.replace(/\./g,'/'));},error:function(i){q.sap.log.debug("tried to load entity docu for: "+n+t);}});return E;}
function m(e){var v=sap.ui.getVersionInfo(),l,L,i;if(v&&Array.isArray(v.libraries)){L=v.libraries.length;for(i=0;i<L;i++){l=v.libraries[i];if(e===l.name||e.indexOf(l.name+".")===0){return l.name;}}}return"sap.ui.core";}
function o(e,l){var P=g(e);var E;if(!l){var n=q.sap.getObject(e);if(n&&n.getMetadata){var M=n.getMetadata();if(M.getLibraryName){l=M.getLibraryName();}else{l="sap.ui.core";}}else{l=m(e);}}if(!E&&!P.__noAPIJson){return A.getLibraryElementsJSONPromise(l).then(function(s){var t;for(var i=0,u=s.length;i<u;i++){if(s[i].name===e){t=s[i];break;}}if(t){E={baseType:t.extends,deprecation:t.deprecated?t.deprecated.text:null,doc:t.description,module:t.module,name:t.name,since:t.since,values:t.properties};P.__noSource=true;P.__noMetamodel=true;}return E;});}else if(P.__noAPIJson){q.sap.log.debug("ancestor package for "+e+" is marked with 'noMetamodel'");}if(!E&&!P.__noMetamodel){E=k(e,".control","xml",p,e);if(!E){E=k(e,".type","xml",c,e);}if(!E){E=k(e,".js","text",d,e);}if(E){P.__noSource=true;}}else if(P.__noMetamodel){q.sap.log.debug("ancestor package for "+e+" is marked with 'noMetamodel'");}if(!E&&!P.noSource){var L=e.replace(/\.[^.]+$/,".library");E=k(L,".js","text",d,e);if(!E){E=k(L,".js","text",d,e);}if(E){P.__noMetamodel=true;}}else if(P.__noSource){q.sap.log.debug("ancestor package for "+e+" is marked with 'noSource'");}return E;}
return{getEntityDocuAsync:function(e,l){return o(e,l);}};},true);
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/JSDocUtil',['jquery.sap.global','jquery.sap.strings'],function(q){"use strict";
function d(t,a){return"<code>"+(a||t)+"</code>";}
function f(s,o){o=o||{};var b=o.beforeParagraph==null?'<p>':o.beforeParagraph;var a=o.afterParagraph==null?'</p>':o.afterParagraph;var c=o.beforeFirstParagraph==null?b:o.beforeFirstParagraph;var e=o.afterLastParagraph==null?a:o.afterLastParagraph;var l=typeof o.linkFormatter==='function'?o.linkFormatter:d;var r=/(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;var i=false;s=s||'';l=l||d;s=c+s.replace(r,function(m,p,g,h,j,k,n,t){if(p){i=true;}else if(g){i=false;}else if(h){if(!i){return a+m;}}else if(j){if(!i){return m+b;}}else if(t){if(!i){return a+b;}}else if(k){if(!i){return l(k,n);}}return m;})+e;s=s.replace(new RegExp(q.sap.escapeRegExp(b)+"\s*"+q.sap.escapeRegExp(a),"g"),"");return s;}
return{formatTextBlock:f};});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/TreeUtil',[],function(){"use strict";var T=function(n,c){this.nodeIdField=n;this.childrenField=c;};
T.prototype.getPathToNode=function(n,t){var s=[];this._walkTree(n,t,s);return s;};
T.prototype._walkTree=function(n,t,s){var f=this._findLeaf(t,n);if(f){s.push(n);return true;}for(var i=0;i<t.length;i++){if(t[i][this.childrenField]){s.push(t[i][this.nodeIdField]);if(this._walkTree(n,t[i][this.childrenField],s)){return true;}s.pop();}}};
T.prototype._findLeaf=function(t,n){for(var i=0;i<t.length;i++){if(t[i][this.nodeIdField]===n){return t[i];}}return null;};
return T;});
sap.ui.predefine('sap/ui/documentation/sdk/controller/util/XML2JSONUtils',['jquery.sap.global'],function(q){"use strict";
function b(a,c){var d=x(a,c);var s=["topictitle1","shortdesc"];var p=function(h,i){var X=i||d;var n=X.getElementsByClassName(h);if(n.length===0){return'';}var k=q("<div/>").html(r(n[0].innerHTML)).text();return n&&n.length>0&&("innerHTML"in n[0])&&k||'';};var r=function(t){return t.replace(/<[^>]*>/g," ").replace(/\s{2,}/g,' ');};var f=function(h){var l=h.querySelectorAll("a.xref, a.link, area"),i,k,m,n,o;for(i=0;i<l.length;i++){k=l[i];m=k.getAttribute("href");n=m.indexOf("#")==0;o=m.indexOf("http")==0;if(o){k.setAttribute('target','_blank');}if(o||n){continue;}if(m.indexOf("/docs/api/")>-1){m=m.substr(0,m.lastIndexOf(".html"));m=m.substr(m.lastIndexOf('/')+1);m="#/api/"+m;}else if(m.indexOf("explored.html")>-1){m=m.split("../").join("");m=c.exploredURI+m;}else{m=m.substr(0,m.lastIndexOf(".html"));m="#/topic/"+m;}k.setAttribute("href",m);}};var e=function(h){var k=h.querySelectorAll("img");for(var i=0;i<k.length;i++){k[i].setAttribute("src",c.docuPath+k[i].getAttribute("src"));}return h.innerHTML;};var g=function(){var w=d,h=w.querySelectorAll("script, .topictitle1, .shortdesc, #local-navigation, header, #footer-container, nav.mobile-nav, #breadcrumb-container, #content-toolbar"),k,i;for(var i=0;i<h.length;i++){k=h[i].parentElement;k.removeChild(h[i]);}f(w);e(w);j['html']=w.innerHTML;};var j={};s.forEach(function(h,i){j[h]=p(h);});g();return j;}
function x(a,c){var d=q.parseHTML(a);var m=c.topicHtmlMainDivId;for(var i=0;i<d.length;i++){if(d[i].getAttribute&&d[i].getAttribute("id")===m){var n='<div id ="'+m+'">'+d[i].innerHTML+'</div>';d[i].innerHTML=n;return d[i];}}}
return{DomXml2JSON:b,XML2DOM:x,XML2JSON:b};});
sap.ui.predefine('sap/ui/documentation/sdk/controls/ParamText',['sap/m/Text'],function(T){"use strict";
var P=T.extend("sap.ui.documentation.sdk.controls.ParamText",{
metadata:{properties:{customClass:{type:"string",group:"Behavior",defaultValue:"sapUiDocumentationParamBold"}}},
onAfterRendering:function(){this.$().addClass(this.getCustomClass());},
renderer:T.prototype.getRenderer().render
});
return P;});
sap.ui.predefine('sap/ui/documentation/sdk/controls/Search',['sap/ui/core/Control','sap/m/Button','sap/m/SearchField','sap/m/library'],function(C,B,S,m){"use strict";
var a=C.extend("sap.ui.documentation.sdk.controls.Search",{
metadata:{properties:{isOpen:{type:"boolean",group:"Appearance",defaultValue:false},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{_openingButton:{type:"sap.m.Button",multiple:false},_closingButton:{type:"sap.m.Button",multiple:false},_searchField:{type:"sap.m.SearchField",multiple:false}},events:{toggle:{isOpen:{type:"boolean"}},search:{parameters:{query:{type:"string"},suggestionItem:{type:"sap.m.SuggestionItem"},refreshButtonPressed:{type:"boolean"},clearButtonPressed:{type:"boolean"}}}}},
renderer:function(r,c){var w=c.getWidth(),o,b,s;r.write("<div");r.writeControlData(c);if(w){r.writeAttribute("style","width:"+w+";");}r.addClass("sapUiDocumentationSearch");r.writeClasses();r.write(">");if(c.getIsOpen()){s=c._lazyLoadSearchField(true);b=c._lazyLoadClosingButton(true);r.renderControl(s);r.renderControl(b);}else{o=c._lazyLoadOpeningButton(true);r.renderControl(o);}r.write("</div>");}
});
a.prototype.onAfterRendering=function(){if(this.getIsOpen()){this._maximizeSearchField();}};
a.prototype._maximizeSearchField=function(){return this._resizeSearchField("100%");};
a.prototype._minimizeSearchField=function(){return this._resizeSearchField("10%");};
a.prototype._resizeSearchField=function(w){return new Promise(function(r,b){var $=this.$("searchField");if(!$.length){b();}if($.css("max-width")===w){r();}$.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend",function(){r();});$.css("max-width",w);}.bind(this));};
a.prototype._toggleOpen=function(o){this.setIsOpen(o);this.fireToggle({isOpen:o});};
a.prototype._lazyLoadOpeningButton=function(s){if(!this.getAggregation("_openingButton")){var b=new B(this.getId()+"-openingBtn",{icon:"sap-icon://search",type:m.ButtonType.Transparent,press:function(){this._toggleOpen(true);}.bind(this)});b.addStyleClass("sdkHeaderSearchButton");this.setAggregation("_openingButton",b,s);}return this.getAggregation("_openingButton");};
a.prototype._lazyLoadClosingButton=function(s){if(!this.getAggregation("_closingButton")){var b=new B(this.getId()+"-closingBtn",{text:"Close",type:m.ButtonType.Transparent,press:function(){this._minimizeSearchField().then(function(){this._toggleOpen(false);}.bind(this));}.bind(this)});this.setAggregation("_closingButton",b,s);}return this.getAggregation("_closingButton");};
a.prototype._lazyLoadSearchField=function(s){if(!this.getAggregation("_searchField")){var o=new S(this.getId()+"-searchField",{showSearchButton:true,search:function(e){var p=e.getParameters();p.id=this.getId();this.fireSearch(p);}.bind(this)});o.addStyleClass("sdkHeaderSearchField");this.setAggregation("_searchField",o,s);}return this.getAggregation("_searchField");};
return a;});
sap.ui.predefine('sap/ui/documentation/sdk/controls/TitleLink',['sap/ui/core/library','sap/ui/Device','sap/m/Toolbar','sap/m/Title'],function(c,D,T,a){"use strict";var b=c.TextAlign;var d=c.TitleLevel;
var e=a.extend("sap.ui.documentation.sdk.controls.TitleLink",{
metadata:{properties:{target:{type:"string",group:"Behavior",defaultValue:null},href:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},filter:{type:"string",group:"Data",defaultValue:""},wrap:{type:"boolean",group:"Behavior",defaultValue:true}},events:{press:{allowPreventDefault:true}}},
init:function(){if(D.support.touch){this.ontap=this._handlePress;}else{this.onclick=this._handlePress;}this.ontouchstart=function(E){if(this.getHref()){E.setMarked();}};},
onsapspace:function(E){this._handlePress(E);if(this.getHref()&&!E.isDefaultPrevented()){E.preventDefault();E.setMarked();var C=document.createEvent('MouseEvents');C.initEvent('click',false,true);this.getDomRef().dispatchEvent(C);}},
_handlePress:function(E){E.setMarked();if(!this.firePress()||!this.getHref()){E.preventDefault();}},
setHref:function(u){this.setProperty("href",u,true);u=this.getProperty("href");this.$().attr("href",u);return this;},
setTarget:function(t){this.setProperty("target",t,true);if(!t){this.$().removeAttr("target");}else{this.$().attr("target",t);}return this;},
renderer:function(r,t){var A=t._getTitle(),l=(A?A.getLevel():t.getLevel())||c.TitleLevel.Auto,f=l==d.Auto,s=f?"div":l;r.write("<",s);r.writeControlData(t);r.addClass("sapUiDocTitleLink");r.addClass("sapMTitle");r.addClass("sapMTitleStyle"+(t.getTitleStyle()||c.TitleLevel.Auto));r.addClass("sapUiSelectable");if(t.getWrap()){r.addClass("wrap");}else{r.addClass("sapMTitleNoWrap");}var w=t.getWidth();if(!w){r.addClass("sapMTitleMaxWidth");}else{r.addStyle("width",w);}var g=t.getTextAlign();if(g&&g!=b.Initial){r.addClass("sapMTitleAlign"+g);}if(t.getParent()instanceof T){r.addClass("sapMTitleTB");}var h=A?A.getTooltip_AsString():t.getTooltip_AsString();if(h){r.writeAttributeEscaped("title",h);}if(f){r.writeAttribute("role","heading");}r.writeClasses();r.writeStyles();r.write(">");r.write("<a");r.addClass("sapMLnk");if(t.getText()){r.writeAttribute("tabIndex","0");}else{r.writeAttribute("tabIndex","-1");}r.writeAttributeEscaped("href",t.getHref());if(t.getTarget()){r.writeAttributeEscaped("target",t.getTarget());}r.writeClasses();r.write(">");r.write("<span");r.writeAttribute("id",t.getId()+"-inner");r.write(">");r.writeEscaped(A?A.getText():t.getText());r.write("</span></",s,">");r.write("</a>");}
});
return e;});
sap.ui.predefine('sap/ui/documentation/sdk/model/models',["sap/ui/model/json/JSONModel","sap/ui/Device"],function(J,D){"use strict";return{createDeviceModel:function(){var m=new J(D);m.setDefaultBindingMode("OneWay");return m;}};});
sap.ui.predefine('sap/ui/documentation/sdk/util/DocumentationRouter',['sap/m/routing/Router','sap/ui/core/routing/History'],function(R,H){"use strict";
var D=R.extend("sap.ui.documentation.sdk.util.DocumentationRouter",{
myNavBack:function(r,d){var h=H.getInstance();var p=h.getPreviousHash();if(p!==undefined){window.history.go(-1);}else{var b=true;this.navTo(r,d,b);}},
myNavToWithoutHash:function(v,a,m,d){var c=this._getOwnerComponent(),r=c.byId(c.getManifestEntry("/sap.ui5/rootView").id),A=r.byId("splitApp"),V=this.getView(v,a);A.addPage(V,m);A.toDetail(V.getId(),"show",d);},
_getOwnerComponent:function(){return this._oOwner;}
});
return D;});
sap.ui.predefine('sap/ui/documentation/sdk/util/ToggleFullScreenHandler',[],function(){"use strict";var T={updateMode:function(e,v,c){var s=(this._getSplitApp(c).getMode()==="ShowHideMode");if(s){this._getSplitApp(c).setMode('HideMode');}else{this._getSplitApp(c).setMode('ShowHideMode');}this.updateControl(e.getSource(),v,s,c);},_getSplitApp:function(c){if(!this._oSplitApp){this._oSplitApp=c.getSplitApp();}return this._oSplitApp;},updateControl:function(b,v,f,c){if(arguments.length===2){f=!(this._getSplitApp(c).getMode()==="ShowHideMode");}if(!f){b.setTooltip("Show this sample in full screen mode");b.setIcon('sap-icon://full-screen');}else{b.setTooltip("Show this sample in the detail view of a split container.");b.setIcon('sap-icon://exit-full-screen');}},cleanUp:function(){this._oSplitApp=null;}};return T;},true);
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/documentation/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/documentation/demoapps/manifest.json":'{\n\t"_version": "1.4.0",\n\t"sap.app": {\n\t\t"id": "sap.ui.documentation.demoapps",\n\t\t"type": "application",\n\t\t"i18n": "i18n/i18n.properties",\n\t\t"title": "{{appTitle}}",\n\t\t"description": "{{appDescription}}",\n\t\t"applicationVersion": {\n\t\t\t"version": "1.0.0"\n\t\t}\n\t},\n\t"sap.ui": {\n\t\t"technology": "UI5",\n\t\t"icons": {\n\t\t\t"icon": "sap-icon://detail-view",\n\t\t\t"favIcon": "",\n\t\t\t"phone": "",\n\t\t\t"phone@2": "",\n\t\t\t"tablet": "",\n\t\t\t"tablet@2": ""\n\t\t},\n\t\t"deviceTypes": {\n\t\t\t"desktop": true,\n\t\t\t"tablet": true,\n\t\t\t"phone": true\n\t\t},\n\t\t"supportedThemes": [\n\t\t\t"sap_hcb",\n\t\t\t"sap_belize"\n\t\t]\n\t},\n\t"sap.ui5": {\n\t\t"rootView": {\n\t\t\t"viewName": "sap.ui.documentation.demoapps.view.App",\n\t\t\t"type": "XML",\n\t\t\t"id": "app"\n\t\t},\n\t\t"resources": {\n\t\t\t"css": [\n\t\t\t\t{\n\t\t\t\t\t"uri": "css/style.css"\n\t\t\t\t}\n\t\t\t]\n\t\t},\n\t\t"dependencies": {\n\t\t\t"minUI5Version": "1.30",\n\t\t\t"libs": {\n\t\t\t\t"sap.ui.core": {},\n\t\t\t\t"sap.m": {},\n\t\t\t\t"sap.ui.layout": {}\n\t\t\t}\n\t\t},\n\t\t"contentDensities": {\n\t\t\t"compact": true,\n\t\t\t"cozy": true\n\t\t},\n\t\t"models": {\n\t\t\t"i18n": {\n\t\t\t\t"type": "sap.ui.model.resource.ResourceModel",\n\t\t\t\t"settings": {\n\t\t\t\t\t"bundleName": "sap.ui.documentation.demoapps.i18n.i18n"\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}',
	"sap/ui/documentation/demoapps/view/App.view.xml":'<mvc:View\n\tcontrollerName="sap.ui.documentation.demoapps.controller.App"\n\txmlns="sap.m"\n\txmlns:mvc="sap.ui.core.mvc"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:custom="sap.ui.documentation.sdk.controls"\n\tdisplayBlock="true">\n\t<App\n\t\tid="app"\n\t\tclass="sapUiDemoApps">\n\t\t<Page showHeader="false" enableScrolling="false">\n\t\t\t<ScrollContainer vertical="true" width="100%" height="100%">\n\t\t\t\t<l:BlockLayout\n\t\t\t\t\tid="headerLayout"\n\t\t\t\t\tbackground="Light">\n\t\t\t\t\t<l:BlockLayoutRow>\n\t\t\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\t\t\tclass="sapUiDemokitLandingImageCell sapUiNoContentPadding welcomeImageCell">\n\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/demoapps/img/DemoApps_S_cropped.jpg"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\t\t\tvisible="{device>/system/phone}"\n\t\t\t\t\t\t\t\t\tdensityAware="false"/>\n\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\t\tid="desktopImage"\n\t\t\t\t\t\t\t\t\tclass="desktopImage welcomeImage"\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/demoapps/img/DemoApps_M_and_L_cropped.jpg"\n\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"\n\t\t\t\t\t\t\t\t\twidth="100%"/>\n\t\t\t\t\t\t\t<l:Grid\n\t\t\t\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\t\t\tclass="headerGrid"\n\t\t\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\t\t\tdefaultSpan="L6 M6 S12">\n\t\t\t\t\t\t\t\t<l:VerticalLayout width="100%" class="sapUiTinyMarginTop sapUiTinyMarginEnd">\n\t\t\t\t\t\t\t\t\t<Text class="headerText" text="{i18n>pageTitle}" width="100%" textAlign="Left"/>\n\t\t\t\t\t\t\t\t\t<Button\n\t\t\t\t\t\t\t\t\t\t\tclass="actionButton headerButton"\n\t\t\t\t\t\t\t\t\t\t\tid="download"\n\t\t\t\t\t\t\t\t\t\t\ttext="{i18n>downloadButtonText}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\t\t\t\t\tpress="onDownloadButtonPress">\n\t\t\t\t\t\t\t\t\t</Button>\n\t\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\t\t\tsrc="resources/sap/ui/documentation/demoapps/img/demoAppsTeaser.png"\n\t\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"\n\t\t\t\t\t\t\t\t\t\twidth="100%"/>\n\t\t\t\t\t\t\t</l:Grid>\n\t\t\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t\t</l:BlockLayoutRow>\n\t\t\t\t</l:BlockLayout>\n\t\t\t\t<l:BlockLayout\n\t\t\t\t\tid="demoAppsLayout"\n\t\t\t\t\tcontent="{\n\t\t\t\t\t\tpath: \'/demoAppsByCategory\'\n\t\t\t\t\t}"\n\t\t\t\t\tbackground="Light">\n\t\t\t\t\t<l:BlockLayoutRow content="{\n\t\t\t\t\t\tpath: \'\',\n\t\t\t\t\t\tfactory: \'.createDemoAppRow\'\n\t\t\t\t\t}"/>\n\t\t\t\t</l:BlockLayout>\n\t\t\t\t<l:BlockLayout\n\t\t\t\t\tid="demoAppsFooter"\n\t\t\t\t\tvisible="{/bFooterVisible}">\n\t\t\t\t\t<l:BlockLayoutRow>\n\t\t\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesColorPatternFContrast">\n\t\t\t\t\t\t\t<HBox\n\t\t\t\t\t\t\t\t\tjustifyContent="SpaceBetween"\n\t\t\t\t\t\t\t\t\talignItems="Center">\n\t\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_sap.png"\n\t\t\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\t\t\theight="2.5rem">\n\t\t\t\t\t\t\t\t</Image>\n\t\t\t\t\t\t\t\t<HBox\n\t\t\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\t\t\tjustifyContent="End"\n\t\t\t\t\t\t\t\t\t\twrap="Wrap"\n\t\t\t\t\t\t\t\t\t\tvisible="{=!${appView>/isOpenUI5}}">\n\t\t\t\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesBrightLink sapUiLargeMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\ttext="Legal Disclosure"\n\t\t\t\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/impressum.html"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesBrightLink sapUiLargeMarginEnd"\n\t\t\t\t\t\t\t\t\t\t\ttext="Privacy"\n\t\t\t\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/privacy.html"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesBrightLink"\n\t\t\t\t\t\t\t\t\t\t\ttext="Terms of Use"\n\t\t\t\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/terms-of-use.html"\n\t\t\t\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t\t</l:BlockLayoutRow>\n\t\t\t\t</l:BlockLayout>\n\t\t\t</ScrollContainer>\n\t\t\t<dependents>\n\t\t\t\t<SelectDialog id="downloadDialog"\n\t\t\t\t\titems="{/demoApps}"\n\t\t\t\t\ttitle="{i18n>downloadDialogTitle}"\n\t\t\t\t\tliveChange="onSearch"\n\t\t\t\t\tconfirm="onDownloadPress">\n\t\t\t\t\t<InputListItem\n\t\t\t\t\t\tvisible="{= !!${config} }"\n\t\t\t\t\t\tlabel="{name}"\n\t\t\t\t\t\ttype="Active">\n\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t<core:CustomData key="config" value="{config}"/>\n\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t<Button\n\t\t\t\t\t\t\ttext="{i18n>downloadButtonText}"\n\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\tpress="onDownloadPress"/>\n\t\t\t\t\t</InputListItem>\n\t\t\t\t</SelectDialog>\n\t\t\t</dependents>\n\t\t</Page>\n\t</App>\n</mvc:View>\n',
	"sap/ui/documentation/demoapps/view/BlockLayoutCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:custom="sap.ui.documentation.sdk.controls">\n\t<l:BlockLayoutCell\n\t\twidth="2">\n\t\t<l:VerticalLayout width="100%">\n\t\t\t<core:Icon\n\t\t\t\tsrc="{icon}"\n\t\t\t\tsize="2rem"\n\t\t\t\tcolor="Default">\n\t\t\t</core:Icon>\n\t\t\t<custom:TitleLink\n\t\t\t\tlevel="H1"\n\t\t\t\ttitleStyle="H1"\n\t\t\t\ttext="{name}"\n\t\t\t\thref="{ref}"\n\t\t\t\ttarget="_blank"\n\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t<Text\n\t\t\t\ttext="{desc}"\n\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t<l:VerticalLayout\n\t\t\t\tcontent="{links}"\n\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }">\n\t\t\t\t<Link\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'ref\',\n\t\t\t\t\t\tformatter: \'.formatter.crossLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\ttext="{name}"/>\n\t\t\t</l:VerticalLayout>\n\t\t\t<l:HorizontalLayout>\n\t\t\t\t<Label\n\t\t\t\t\tdesign="Bold"\n\t\t\t\t\ttext="{i18n>demoAppTileLibrary}"\n\t\t\t\t\tclass="sapUiTinyMarginEnd"/>\n\t\t\t\t<Link\n\t\t\t\t\ttext="{lib}"\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\tenabled="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLinkEnabled\'\n\t\t\t\t\t}"\n\t\t\t\t\tclass="namespaceLink"\n\t\t\t\t\temphasized="true"/>\n\t\t\t</l:HorizontalLayout>\n\t\t</l:VerticalLayout>\n\t</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/documentation/demoapps/view/BlockLayoutHeadlineCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout">\n\t<l:BlockLayoutCell\n\t\tclass="headlineCell"\n\t\ttitle="{\n\t\t\tpath: \'categoryId\',\n\t\t\tformatter: \'.formatter.categoryName\'\n\t\t}"\n\t\twidth="2">\n\t</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/documentation/demoapps/view/BlockLayoutTeaserCell.fragment.xml":'<core:FragmentDefinition\n\txmlns="sap.m"\n\txmlns:core="sap.ui.core"\n\txmlns:l="sap.ui.layout"\n\txmlns:custom="sap.ui.documentation.sdk.controls">\n<l:BlockLayoutCell\n\twidth="4">\n\t<l:Grid\n\t\thSpacing="0"\n\t\tdefaultSpan="L6 M12 S12">\n\t\t<l:VerticalLayout class="sapUiTinyMarginEnd" width="100%">\n\t\t\t<core:Icon\n\t\t\t\tsrc="{icon}"\n\t\t\t\tsize="2rem"\n\t\t\t\tcolor="Default">\n\t\t\t</core:Icon>\n\t\t\t<custom:TitleLink\n\t\t\t\tlevel="H1"\n\t\t\t\ttitleStyle="H1"\n\t\t\t\ttext="{name}"\n\t\t\t\thref="{ref}"\n\t\t\t\ttarget="_blank"\n\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t<Text\n\t\t\t\ttext="{desc}"\n\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t<l:VerticalLayout\n\t\t\t\tcontent="{links}"\n\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\tvisible="{= ${links}.length === 0 ? false : true }">\n\t\t\t\t<Link\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'ref\',\n\t\t\t\t\t\tformatter: \'.formatter.crossLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\ttext="{name}"/>\n\t\t\t</l:VerticalLayout>\n\t\t\t<l:HorizontalLayout>\n\t\t\t\t<Label\n\t\t\t\t\tdesign="Bold"\n\t\t\t\t\ttext="{i18n>demoAppTileLibrary}"\n\t\t\t\t\tclass="sapUiTinyMarginEnd"/>\n\t\t\t\t<Link\n\t\t\t\t\ttext="sap.m"\n\t\t\t\t\thref="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLink\'\n\t\t\t\t\t}"\n\t\t\t\t\ttarget="_blank"\n\t\t\t\t\tenabled="{\n\t\t\t\t\t\tpath: \'lib\',\n\t\t\t\t\t\tformatter: \'.formatter.libraryLinkEnabled\'\n\t\t\t\t\t}"\n\t\t\t\t\tclass="namespaceLink"\n\t\t\t\t\temphasized="true"/>\n\t\t\t</l:HorizontalLayout>\n\t\t</l:VerticalLayout>\n\t</l:Grid>\n</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/documentation/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.ui.documentation",\n    "type": "library",\n    "embeds": [\n      "demoapps",\n      "sdk"\n    ],\n    "applicationVersion": {\n      "version": "1.50.6"\n    },\n    "title": "SAPUI5 library for the Demokit 2.0.",\n    "description": "SAPUI5 library for the Demokit 2.0.",\n    "resources": "resources.json",\n    "offline": true,\n    "openSourceComponents": [\n      {\n        "name": "esprima",\n        "packagedWithMySelf": true,\n        "version": "0.0.0"\n      },\n      {\n        "name": "google-code-prettify",\n        "packagedWithMySelf": true,\n        "version": "0.0.0"\n      }\n    ]\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_belize",\n      "sap_belize_hcb",\n      "sap_belize_hcw",\n      "sap_belize_plus"\n    ]\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.50",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.50.6"\n        },\n        "sap.ui.layout": {\n          "minVersion": "1.50.6"\n        },\n        "sap.m": {\n          "minVersion": "1.50.6"\n        }\n      }\n    }\n  }\n}',
	"sap/ui/documentation/sdk/manifest.json":'{\n\t"_version": "1.8.0",\n\n\t"sap.app": {\n\t"id": "sap.ui.documentation.sdk",\n\t\t"type": "application",\n\t\t"title": "OpenUI5 SDK - Demo Kit v2.0",\n\t\t"applicationVersion": {\n\t\t\t"version": "1.0.0"\n\t\t}\n\t},\n\n\t"sap.ui": {\n\t"technology": "UI5",\n\t\t"icons": {\n\t\t\t"icon": "sap-icon://detail-view",\n\t\t\t"favIcon": "",\n\t\t\t"phone": "",\n\t\t\t"phone@2": "",\n\t\t\t"tablet": "",\n\t\t\t"tablet@2": ""\n\t\t},\n\t\t"deviceTypes": {\n\t\t\t"desktop": true,\n\t\t\t"tablet": true,\n\t\t\t"phone": true\n\t\t},\n\t\t"supportedThemes": [\n\t\t\t"sap_belize",\n\t\t\t"sap_belize_plus",\n\t\t\t"sap_belize_hcb",\n\t\t\t"sap_belize_hcw"\n\t\t]\n\t},\n\n\t"sap.ui5": {\n\t"rootView": {\n\t\t\t"viewName": "sap.ui.documentation.sdk.view.App",\n\t\t\t"type": "XML",\n\t\t\t"id": "app"\n\t\t},\n\n\t\t"dependencies": {\n\t\t\t"minUI5Version": "1.46.0",\n\t\t\t"libs": {\n\t\t\t\t"sap.ui.core": {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t},\n\t\t\t\t"sap.m": {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t},\n\t\t\t\t"sap.ui.layout" : {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t},\n\t\t\t\t"sap.f" : {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t},\n\t\t\t\t"sap.uxap" : {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t},\n\t\t\t\t"sap.tnt" : {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t},\n\t\t\t\t"sap.ui.codeeditor" : {\n\t\t\t\t\t"minVersion": "1.46.0"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\n\t\t"contentDensities": {\n\t\t\t"compact": true,\n\t\t\t"cozy": true\n\t\t},\n\n\t\t"config": {\n\t\t\t"docuPath": "./docs/topics/",\n\t\t\t"exploredURI": "./",\n\t\t\t"topicHtmlMainDivId": "d4h5-main-container"\n\t\t},\n\n\t  "routing": {\n\t\t"config": {\n\t\t  "routerClass": "sap.ui.documentation.sdk.util.DocumentationRouter",\n\t\t  "viewType": "XML",\n\t\t  "viewPath": "sap.ui.documentation.sdk.view",\n\t\t  "controlId": "splitApp",\n\t\t  "controlAggregation": "detailPages",\n\t\t  "bypassed": {\n\t\t\t"target": ["welcome"]\n\t\t  },\n\t\t  "async": true,\n\t\t  "clearTarget" : false\n\t\t},\n\n\t\t"routes": [\n\t\t  {\n\t\t\t"pattern": "",\n\t\t\t"name": "welcome",\n\t\t\t"target": ["welcome"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "controlsMaster",\n\t\t\t"name": "controlsMaster",\n\t\t\t"target": ["controlsMaster"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "controls",\n\t\t\t"name": "controls",\n\t\t\t"target": ["controlsMaster", "controls"],\n\t\t\t  "subroutes": [\n\t\t\t\t  {\n\t\t\t\t\t  "pattern": "controls/filter/{value}",\n\t\t\t\t\t  "name": "listFilter",\n\t\t\t\t\t  "target": ["controlsMaster", "controls"]\n\t\t\t\t  }\n\t\t\t  ]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "group/{id}",\n\t\t\t"name": "group",\n\t\t\t"target": ["controlsMaster", "group"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/samples",\n\t\t\t"name": "entitySamplesLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/about",\n\t\t\t"name": "entityAboutLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/properties",\n\t\t\t"name": "entityPropertiesLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/aggregations",\n\t\t\t"name": "entityAggregationsLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/associations",\n\t\t\t"name": "entityAssociationsLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/events",\n\t\t\t"name": "entityEventsLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/methods",\n\t\t\t"name": "entityMethodsLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "entity/{id}/:sectionTab:",\n\t\t\t"name": "entity",\n\t\t\t"target": ["controlsMaster", "entity"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "sample/{id}/preview",\n\t\t\t"name": "sample",\n\t\t\t"target": ["controlsMaster", "sample"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "sample/{id}/code",\n\t\t\t"name": "code",\n\t\t\t"target": ["controlsMaster", "code"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "sample/{id}/code/{fileName}",\n\t\t\t"name": "code_file",\n\t\t\t"target": ["controlsMaster", "code"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "downloads",\n\t\t\t"name": "downloads",\n\t\t\t"target": ["downloads"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "api",\n\t\t\t"name": "api",\n\t\t\t"target": ["apiMaster", "apiDetailInitial"]\n\t\t  },\n\t\t  {\n\t\t    "pattern": "api/deprecated",\n\t\t\t"name": "deprecated",\n\t\t\t"target": ["apiMaster", "apiDetailDeprecated"]\n\t\t  },\n\t\t  {\n\t\t    "pattern": "api/experimental",\n\t\t\t"name": "experimental",\n\t\t\t"target": ["apiMaster", "apiDetailExperimental"]\n\t\t  },\n\t\t  {\n\t\t    "pattern": "api/{id}/:entityType:/:entityId:",\n\t\t\t"name": "apiId",\n\t\t\t"target": ["apiMaster", "apiDetail"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "topic",\n\t\t\t"name": "topic",\n\t\t\t"target": ["topicMaster", "topicDetailInitial"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "topic/{id}",\n\t\t\t"name": "topicId",\n\t\t\t"target": ["topicMaster", "topicDetail"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "demoapps",\n\t\t\t"name": "demoapps",\n\t\t\t"target": ["demoApps"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "tools",\n\t\t\t"name": "tools",\n\t\t\t"target": ["tools"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "search/{searchParam}",\n\t\t\t"name": "search",\n\t\t\t"target": ["searchPage"]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "releasenotes.html",\n\t\t\t"name": "releaseNotes",\n\t\t\t"target": [\n\t\t\t\t"topicMaster",\n\t\t\t\t"releaseNotes"\n\t\t\t]\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "docs/guide/{id}",\n\t\t\t"name": "topicIdLegacyRoute"\n\t\t  },\n\t\t  {\n\t\t\t"pattern": "docs/api/symbols/{id}",\n\t\t\t"name": "apiIdLegacyRoute"\n\t\t  }\n\t\t],\n\n\t\t"targets": {\n\t\t  "empty": {\n\t\t\t"viewName": "Empty",\n\t\t\t"viewLevel": 1,\n\t\t\t"viewId": "empty",\n\t\t\t"controlAggregation": "masterPages"\n\t\t  },\n\t\t  "welcome": {\n\t\t\t"viewName": "Welcome",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "welcome"\n\t\t  },\n\t\t  "controls": {\n\t\t\t"viewName": "Controls",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "controls"\n\t\t  },\n\t\t  "controlsMaster": {\n\t\t\t"viewName": "ControlsMaster",\n\t\t\t"viewLevel": 1,\n\t\t\t"viewId": "controlsMaster",\n\t\t\t"controlAggregation": "masterPages"\n\t\t  },\n\t\t  "group": {\n\t\t\t"viewName": "Group",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "group"\n\t\t  },\n\t\t  "entity": {\n\t\t\t"viewName": "Entity",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "entity"\n\t\t  },\n\t\t   "sample": {\n\t\t\t"viewName": "Sample",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "sample"\n\t\t  },\n\t\t  "code": {\n\t\t\t"viewName": "Code",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "code",\n\t\t\t"transition": "flip"\n\t\t  },\n\t\t  "downloads": {\n\t\t\t"viewName": "Downloads",\n\t\t\t"viewLevel": 2,\n\t\t\t"viewId": "downloads"\n\t\t  },\n\t\t  "apiMaster": {\n\t\t\t"viewName": "ApiMaster",\n\t\t\t"viewLevel": 1,\n\t\t\t"viewId": "apiMaster",\n\t\t\t"controlAggregation": "masterPages"\n\t\t  },\n\t\t  "demoApps": {\n\t\t\t\t"viewName": "DemoApps",\n\t\t\t\t"viewLevel": 2,\n\t\t\t\t"viewId": "demoApps"\n\t\t  },\n\t\t  "tools": {\n\t\t\t\t"viewName": "Tools",\n\t\t\t\t"viewLevel": 2,\n\t\t\t\t"viewId": "tools"\n\t\t  },\n\t\t  "apiDetailInitial": {\n\t\t\t"viewName": "ApiDetailInitial",\n\t\t\t"viewId": "apiDetailInitial",\n\t\t\t"viewLevel": 2\n\t\t  },\n\t\t  "apiDetail": {\n\t\t\t"viewName": "ApiDetail",\n\t\t\t"viewId": "apiDetail",\n\t\t\t"viewLevel": 2\n\t\t  },\n\t\t  "apiDetailDeprecated": {\n\t\t\t"viewName": "ApiDetailDeprecated",\n\t\t\t"viewId": "apiDetailDeprecated",\n\t\t\t"viewLevel": 2\n\t\t  },\n\t\t  "apiDetailExperimental": {\n\t\t\t"viewName": "ApiDetailExperimental",\n\t\t\t"viewId": "apiDetailExperimental",\n\t\t\t"viewLevel": 2\n\t\t  },\n\t\t  "topicMaster": {\n\t\t\t"viewName": "TopicMaster",\n\t\t\t"viewLevel": 1,\n\t\t\t"viewId": "topicMaster",\n\t\t\t"controlAggregation": "masterPages"\n\t\t  },\n\t\t  "topicDetailInitial": {\n\t\t\t"viewName": "TopicDetailInitial",\n\t\t\t"viewId": "topicDetailInitial",\n\t\t\t"viewLevel": 2\n\t\t  },\n\t\t  "topicDetail": {\n\t\t\t"viewName": "TopicDetail",\n\t\t\t"viewId": "topicDetail",\n\t\t\t"viewLevel": 2\n\t\t  },\n\t\t  "searchPage": {\n\t\t\t"viewName": "SearchPage",\n\t\t\t"viewId": "searchPage",\n\t\t\t"viewLevel": 2,\n\t\t\t"controlAggregation": "detailPages"\n\t\t  },\n\t\t  "notFound": {\n\t\t\t"viewName": "NotFound",\n\t\t\t"viewId": "notFound"\n\t\t  },\n\t\t\t"releaseNotes": {\n\t\t\t\t"viewName": "ReleaseNotes",\n\t\t\t\t"viewLevel": 2,\n\t\t\t\t"viewId": "releaseNotes",\n\t\t\t\t"controlAggregation": "detailPages"\n\t\t  }\n\t\t}\n\t  }\n\t}\n}\n',
	"sap/ui/documentation/sdk/view/AboutDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:f="sap.ui.layout.form"\n\t\txmlns:core="sap.ui.core">\n\t<Dialog\n\t\t\tid="aboutDialog"\n\t\t\tresizable="true"\n\t\t\tdraggable="true"\n\t\t\ttitle="About"\n\t\t\tcontentWidth="36rem"\n\t\t\tcontentHeight="50rem"\n\t\t\tshowHeader="false"\n\t\t\tstretch="{appView>/bPhoneSize}">\n\t\t<NavContainer\n\t\t\tid="aboutNavCon">\n\t\t\t<Page\n\t\t\t\tid="aboutMaster"\n\t\t\t\ttitle="About">\n\t\t\t\t<VBox class="sapUiSmallMargin">\n\t\t\t\t\t<Image id="aboutLogoSAP" src="./resources/sap/ui/documentation/sdk/images/Logo_B_SAPUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/>\n\t\t\t\t\t<Image id="aboutLogoUI5" src="./resources/sap/ui/documentation/sdk/images/Logo_B_OpenUI5_H.png" densityAware="false" width="100%" class="sapUiSmallMarginBottom" visible="{versionData>/isOpenUI5}"/>\n\t\t\t\t\t<Text text="UI5 Demo Kit - UI Development Toolkit for HTML5" class="sapMTitleStyleH2 sapUiSmallMarginBottom" />\n\t\t\t\t\t<Text text="© Copyright 2009-2017 SAP SE. All rights reserved." class="sapUiMediumMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/>\n\t\t\t\t\t<Text text="© 2009-2017 SAP SE or an SAP affiliate company." visible="{versionData>/isOpenUI5}"/>\n\t\t\t\t\t<HBox class="sapUiMediumMarginBottom" visible="{versionData>/isOpenUI5}" allowWrapping="true">\n\t\t\t\t\t\t<Text text="Licensed under the Apache License, Version 2.0 – see"/>\n\t\t\t\t\t\t<Link text="LICENSE.txt" href="LICENSE.txt" target="_blank" class="aboutLink"/>\n\t\t\t\t\t</HBox>\n\t\t\t\t\t<Text text="UI5 Version {versionData>/fullVersion}" class="sapMTitleStyleH4 sapUiSmallMarginBottom"/>\n\t\t\t\t\t<Text text="This software includes the folloing library versions"/>\n\t\t\t\t\t<HBox class="sapUiTinyMarginBottom" allowWrapping="true">\n\t\t\t\t\t\t<Text text="(a full change log for all libraries can be found"/>\n\t\t\t\t\t\t<Link text="here" href="releasenotes.html" target="_blank" class="aboutLink"/>\n\t\t\t\t\t\t<Text text=")."/>\n\t\t\t\t\t</HBox>\n\t\t\t\t\t<Link text="Version Details" press="onAboutVersionDetails" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t<Text text="This software includes third-party open source software." class="sapUiTinyMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/>\n\t\t\t\t\t<Link text="Included Third-Party Software" press="onAboutThirdParty" class="sapUiSmallMarginBottom" visible="{=!${versionData>/isOpenUI5}}"/>\n\t\t\t\t\t<MessageStrip showIcon="true" text="{= ${versionData>/isOpenUI5} ? ${appView>/sAboutInfoOpenUI5} : ${appView>/sAboutInfoSAPUI5}}" class="sapUiSmallMarginBottom" enableFormattedText="true"/>\n\t\t\t\t</VBox>\n\t\t\t</Page>\n\t\t\t<Page\n\t\t\t\tid="aboutDetail"\n\t\t\t\tshowNavButton="true"\n\t\t\t\tnavButtonPress="onAboutNavBack"\n\t\t\t\ttitle="Version Details">\n\t\t\t\t<l:VerticalLayout class="sapUiSmallMargin" content="{path: \'appView>/oVersionInfo/libs\'}">\n\t\t\t\t\t<f:Form width="100%" editable="false">\n\t\t\t\t\t\t<f:title>\n\t\t\t\t\t\t\t<core:Title text="{appView>library}"/>\n\t\t\t\t\t\t</f:title>\n\t\t\t\t\t\t<f:layout>\n\t\t\t\t\t\t\t<f:GridLayout/>\n\t\t\t\t\t\t</f:layout>\n\t\t\t\t\t\t<f:formContainers>\n\t\t\t\t\t\t\t<f:FormContainer>\n\t\t\t\t\t\t\t\t<f:formElements>\n\t\t\t\t\t\t\t\t\t<f:FormElement label="Version">\n\t\t\t\t\t\t\t\t\t\t<f:fields>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{versionData>/version}" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t\t\t</f:fields>\n\t\t\t\t\t\t\t\t\t</f:FormElement>\n\t\t\t\t\t\t\t\t\t<f:FormElement label="Description">\n\t\t\t\t\t\t\t\t\t\t<f:fields>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{appView>documentation}" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t\t\t</f:fields>\n\t\t\t\t\t\t\t\t\t</f:FormElement>\n\t\t\t\t\t\t\t\t\t<f:FormElement label="Change Log" visible="{=!!${appView>releasenotes}}">\n\t\t\t\t\t\t\t\t\t\t<f:fields>\n\t\t\t\t\t\t\t\t\t\t\t<Link text="Open Change Log" press="onReleaseDialogOpen" class="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t\t\t\t<customData>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="library" value="{appView>library}" />\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:CustomData key="version" value="{versionData>/version}" />\n\t\t\t\t\t\t\t\t\t\t\t\t</customData>\n\t\t\t\t\t\t\t\t\t\t\t</Link>\n\t\t\t\t\t\t\t\t\t\t</f:fields>\n\t\t\t\t\t\t\t\t\t</f:FormElement>\n\t\t\t\t\t\t\t\t\t<f:FormElement label="Component" visible="{=!!${appView>libDefaultComponent}}">\n\t\t\t\t\t\t\t\t\t\t<f:fields>\n\t\t\t\t\t\t\t\t\t\t\t<Text text="{appView>libDefaultComponent}" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t\t\t</f:fields>\n\t\t\t\t\t\t\t\t\t</f:FormElement>\n\t\t\t\t\t\t\t\t</f:formElements>\n\t\t\t\t\t\t\t</f:FormContainer>\n\t\t\t\t\t\t</f:formContainers>\n\t\t\t\t\t</f:Form>\n\t\t\t\t</l:VerticalLayout>\n\t\t\t</Page>\n\t\t\t<Page\n\t\t\t\tid="aboutThirdParty"\n\t\t\t\tshowNavButton="true"\n\t\t\t\tnavButtonPress="onAboutNavBack"\n\t\t\t\ttitle="Included Third-Party Software">\n\t\t\t\t<l:VerticalLayout class="sapUiSmallMargin" content="{path: \'appView>/oThirdPartyInfo/thirdparty\'}">\n\t\t\t\t\t<f:Form width="100%" editable="false">\n\t\t\t\t\t\t<f:title>\n\t\t\t\t\t\t\t<core:Title text="{appView>displayName}"/>\n\t\t\t\t\t\t</f:title>\n\t\t\t\t\t\t<f:layout>\n\t\t\t\t\t\t\t<f:GridLayout/>\n\t\t\t\t\t\t</f:layout>\n\t\t\t\t\t\t<f:formContainers>\n\t\t\t\t\t\t\t<f:FormContainer>\n\t\t\t\t\t\t\t\t<f:formElements>\n\t\t\t\t\t\t\t\t\t<f:FormElement>\n\t\t\t\t\t\t\t\t\t\t<f:fields>\n\t\t\t\t\t\t\t\t\t\t\t<Link text="Web Site" target="_blank" href="{appView>homepage}" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t\t\t\t<Link text="License Conditions" target="_blank" href="{appView>license/url}" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t\t\t</f:fields>\n\t\t\t\t\t\t\t\t\t</f:FormElement>\n\t\t\t\t\t\t\t\t\t<f:FormElement>\n\t\t\t\t\t\t\t\t\t\t<f:fields>\n\t\t\t\t\t\t\t\t\t\t\t<Link text="Licensed by SAP under \'{appView>license/type}\'" target="_blank" href="{appView>license/file}" class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t\t\t</f:fields>\n\t\t\t\t\t\t\t\t\t</f:FormElement>\n\t\t\t\t\t\t\t\t</f:formElements>\n\t\t\t\t\t\t\t</f:FormContainer>\n\t\t\t\t\t\t</f:formContainers>\n\t\t\t\t\t</f:Form>\n\t\t\t\t</l:VerticalLayout>\n\t\t\t</Page>\n\t\t</NavContainer>\n\t\t<beginButton>\n\t\t\t<Button text="Close" press="aboutDialogClose"/>\n\t\t</beginButton>\n\t</Dialog>\n\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiDetail.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ApiDetail"\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls">\n\n\t<m:Page\n\t\t\tid="apiDetailPage"\n\t\t\tshowHeader="false"\n\t\t\tshowSubHeader="false"\n\t\t\tshowFooter="false"\n\t\t\tclass="apiDetailPage">\n\n\t\t<m:content>\n\t\t\t<ObjectPageLayout id="apiDetailObjectPage"\n\t\t\t\t\t\t\t  enableLazyLoading="false"\n\t\t\t\t\t\t\t  showAnchorBarPopover="true"\n\t\t\t\t\t\t\t  upperCaseAnchorBar="false"\n\t\t\t\t\t\t\t  busyIndicatorDelay="0">\n\t\t\t\t<headerTitle>\n\t\t\t\t\t<ObjectPageHeader id="title" objectTitle="{=${topics>/abstract} ? \'abstract\' : \'\'} {topics>/kind} {topics>/name}"\n\t\t\t\t\t\t\t\t\t  objectSubtitle="{parts : [{path: \'topics>/deprecated\'}],\n\t\t\t\t\t\t\t\t\t                   formatter: \'.formatSubtitle\'}">\n\t\t\t\t\t\t<actions>\n\t\t\t\t\t\t\t<ObjectPageHeaderActionButton id="apiDetailBackToSearch" text="Back to search results" hideIcon="true" hideText="false" press="backToSearch" visible="false"/>\n\t\t\t\t\t\t\t<ObjectPageHeaderActionButton\n\t\t\t\t\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"\n\t\t\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\t\t\ttooltip="Show this sample in full screen mode"\n\t\t\t\t\t\t\t\t\tpress="onToggleFullScreen" />\n\t\t\t\t\t\t</actions>\n\t\t\t\t\t</ObjectPageHeader>\n\t\t\t\t\t<core:ExtensionPoint name="customTitle" />\n\t\t\t\t</headerTitle>\n\n\t\t\t\t<headerContent>\n\t\t\t\t\t<layout:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0">\n\t\t\t\t\t\t<layout:VerticalLayout width="98%" id="headerColumn0"></layout:VerticalLayout>\n\t\t\t\t\t\t<layout:VerticalLayout width="100%" id="headerColumn1" visible="false"></layout:VerticalLayout>\n\t\t\t\t\t\t<layout:VerticalLayout width="100%" id="headerColumn2" visible="false"></layout:VerticalLayout>\n\t\t\t\t\t</layout:Grid>\n\t\t\t\t</headerContent>\n\n\t\t\t\t<sections>\n\t\t\t\t\t<ObjectPageSection id="overview" title="Overview" titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<layout:VerticalLayout width="100%">\n\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\tvisible="{=${topics>/deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\ttext="{parts: [{path: \'topics>/deprecated/since\'}, {path: \'topics>/deprecated/text\'}],\n\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatDeprecated\'}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>/description\'}, {path: \'topics>/references\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatOverviewDescription\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t<layout:HorizontalLayout class="sapUiTinyMarginTop sapUiDocumentationAnnotationsText" visible="{topics>/hasAnnotations}">\n\t\t\t\t\t\t\t\t\t\t\t<m:Text text="A detailed description of the OData annotations handled by this control is available"/>\n\t\t\t\t\t\t\t\t\t\t\t<m:Link text="here" press="onAnnotationsLinkPress"/>\n\t\t\t\t\t\t\t\t\t\t\t<m:Text text="."/>\n\t\t\t\t\t\t\t\t\t\t</layout:HorizontalLayout>\n\t\t\t\t\t\t\t\t\t\t<layout:HorizontalLayout class="sapUiDocumentationAnnotationsText" visible="{topics>/hasAnnotations}">\n\t\t\t\t\t\t\t\t\t\t\t<m:Label text="Annotation Limitations:" design="Bold"/>\n\t\t\t\t\t\t\t\t\t\t\t<m:Text text="Qualifier support for entity types is limited for this control."/>\n\t\t\t\t\t\t\t\t\t\t</layout:HorizontalLayout>\n\n\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\tvisible="{=${topics>/experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since version {topics>/experimental/since} {topics>/experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table visible="{topics>/hasChildren}"\n\t\t\t\t\t\t\t\t\t\t\t\t items="{ path : \'topics>/controlChildren\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t\t fixedLayout="false"\n\t\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Namespaces &amp; Classes"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader">\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Label text="Description"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>link\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'._formatChildDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="properties"\n\t\t\t\t\t\t\t\t\t   title="Fields"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasProperties}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'topics>/properties\'}"\n\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t fixedLayout="true"\n\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Name"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader" vAlign="Top"><m:Label text=""/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="10000px" demandPopin="true" popinDisplay="WithoutHeader"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem visible="{= ${topics>visibility} === \'public\'}">\n\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationParamBold" text="{parts: [\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>name\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>/name\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>static\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatEntityName\'}" wrapping="false"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<layout:VerticalLayout visible="{= ${topics>deprecated} !== undefined }">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus icon="sap-icon://message-error" state="Error" text="Deprecated"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>deprecated/text\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>deprecated/since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="constructor"\n\t\t\t\t\t\t\t\t\t   title="Constructor"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasConstructor}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<layout:VerticalLayout width="100%">\n\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>/constructor/description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatDescription\'}{}"/>\n\n\t\t\t\t\t\t\t\t\t\t<layout:VerticalLayout visible="{= ${topics>/constructor/examples} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   content="{ path : \'topics>/constructor/examples\', templateShareable: \'false\'}">\n\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>caption\'}, {path: \'topics>text\'}],\n\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatExample\'}"/>\n\t\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t<core:HTML visible="{topics>/hasConstructor}"\n\t\t\t\t\t\t\t\t\t\t\t\t   class="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\t\t\t\t\t   content="{parts: [{path: \'topics>/name\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>/constructor/parameters\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t   formatter: \'.formatConstructor\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table items="{ path: \'constructorParams>/parameters\'}"\n\t\t\t\t\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t \t\t\t\t\t\t\t\t\t\tfixedLayout="true"\n\t\t \t\t\t\t\t\t\t\t\t\tvisible="{= ${constructorParams>/parameters}.length > 0}">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Param"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Default Value"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="50%"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<custom:ParamText customClass="{parts: [{path: \'constructorParams>isSubProperty\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'constructorParams>isSubSubProperty\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'appView>/bPhoneSize\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatEventClassName\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  text="{= ${constructorParams>name}}{= ${constructorParams>optional} ? \'?\' : \'\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  wrapping="false"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<layout:VerticalLayout content="{path: \'constructorParams>types\', templateShareable: \'false\'}">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:HBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{constructorParams>value}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{constructorParams>value}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'constructorParams>value\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationOrText" text="or" visible="{= ${constructorParams>isLast} === false}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:HBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{parts: [{path: \'constructorParams>defaultValue\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   formatter: \'.formatDefaultValue\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twrapping="false"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'constructorParams>description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'topics>/constructor/throws\', templateShareable: \'false\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t\t class="sapUiDocumentationReturnsTable"\n\t\t\t\t\t\t\t\t\t\t\t\t fixedLayout="true"\n\t\t\t\t\t\t\t\t\t\t\t\t visible="{= ${topics>/constructor/throws} !== undefined}">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Throws"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="50%"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'topics>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatExceptionLink\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="controlproperties"\n\t\t\t\t\t\t\t\t\t   title="Properties"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasControlProperties}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'topics>/ui5-metadata/properties\'}"\n\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t fixedLayout="false"\n\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Name"/></m:Column>\n\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Default Value"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Tablet" demandPopin="true"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationParamBold" text="{topics>name}" wrapping="false"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{= ${topics>type}.replace(\'[]\', \'\') }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'topics>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{parts: [{path: \'topics>defaultValue\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   formatter: \'.formatDefaultValue\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twrapping="false"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:VBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'}, {path: \'topics>since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatDescriptionSince\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus text="Visibility: {topics>visibility}" state="{= ${topics>visibility} === \'public\' ? \'Success\' : \'Warning\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${topics>deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Deprecated since version {topics>deprecated/since}. {topics>deprecated/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tvisible="{=${topics>experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {topics>experimental/since} {topics>experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom sapUiTinyMarginTop">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:VBox>\n\n\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="aggregations"\n\t\t\t\t\t\t\t\t\t   title="Aggregations"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasAggregations}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'topics>/ui5-metadata/aggregations\'}"\n\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t fixedLayout="false"\n\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Name"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Cardinality"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Tablet" demandPopin="true"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem visible="{= ${topics>visibility} === \'public\'}">\n\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:VBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationParamBold" text="{topics>name}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus visible="{= ${topics>deprecated} !== undefined }" icon="sap-icon://message-error" state="Error" text="Deprecated"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:VBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{topics>cardinality}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'topics>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t      formatter: \'.formatLinkEnabled\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'topics>deprecated/text\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'topics>deprecated/since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="associations"\n\t\t\t\t\t\t\t\t\t   title="Associations"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasAssociations}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'topics>/ui5-metadata/associations\'}"\n\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t fixedLayout="false"\n\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Name"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Cardinality"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader" vAlign="Top"><m:Label text=""/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Tablet" demandPopin="true"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem visible="{topics>visibility === \'public\'}">\n\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:VBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationParamBold" text="{topics>name}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus visible="{= ${topics>deprecated} !== undefined }" icon="sap-icon://message-error" state="Error" text="Deprecated"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:VBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{topics>cardinality}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'topics>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'topics>deprecated/text\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'topics>deprecated/since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="events"\n\t\t\t\t\t\t\t\t\t   title="Events"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasEvents}"\n\t\t\t\t\t\t\t\t\t   subSections="{ path : \'events>/events\'}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection title="{ parts: [{path: \'events>\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatEventsName\'}">\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'events>description\'}, {path: \'events>since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescriptionSince\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus text="Visibility: {events>visibility}" state="{= ${events>visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiSmallMarginBottom"/>\n\n\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\tvisible="{=${events>deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\ttext="{parts: [{path: \'events>deprecated/since\'}, {path: \'events>deprecated/text\'}],\n\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatEventDeprecated\'}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\tvisible="{=${events>experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {events>experimental/since} {events>experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'events>parameters\', templateShareable: \'false\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t\t fixedLayout="true">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Param"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<custom:ParamText customClass="{parts: [{path: \'events>isSubProperty\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'events>isSubSubProperty\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'appView>/bPhoneSize\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatEventClassName\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  text="{= ${appView>/bPhoneSize} &amp;&amp; ${events>phoneName} ? ${events>phoneName} : ${events>name} }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{events>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{events>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'events>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'events>description\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'events>deprecated/text\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'events>deprecated/since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="methods"\n\t\t\t\t\t\t\t\t\t   title="Methods"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasMethods}"\n\t\t\t\t\t\t\t\t\t   subSections="{ path : \'methods>/methods\'}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\n\t\t\t\t\t\t\t<ObjectPageSubSection title="{parts: [\n\t\t\t\t\t\t\t\t\t\t\t\t{path: \'methods>name\'},\n\t\t\t\t\t\t\t\t\t\t\t\t{path: \'topics>/name\'},\n\t\t\t\t\t\t\t\t\t\t\t\t{path: \'methods>static\'}\n\t\t\t\t\t\t\t\t\t\t\t], formatter: \'.formatEntityName\'}">\n\t\t\t\t\t\t\t\t<blocks>\n\n\t\t\t\t\t\t\t\t\t<layout:VerticalLayout width="100%">\n\n\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t<layout:VerticalLayout visible="{= ${methods>examples} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   content="{ path : \'methods>examples\', templateShareable: \'false\'}">\n\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>caption\'}, {path: \'methods>text\'}],\n\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatExample\'}"/>\n\t\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t<layout:HorizontalLayout class="sapUiTinyMarginBottom">\n\t\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus text="Visibility: {methods>visibility}" state="{= ${methods>visibility} === \'public\' ? \'Success\' : \'Warning\'}" class="sapUiTinyMarginEnd"/>\n\t\t\t\t\t\t\t\t\t\t\t<m:ObjectStatus visible="{=${methods>since} !== undefined}" text="Since: {methods>since}" />\n\t\t\t\t\t\t\t\t\t\t</layout:HorizontalLayout>\n\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\tvisible="{=${methods>deprecated} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\ttext="{parts: [{path: \'methods>deprecated/since\'}, {path: \'methods>deprecated/text\'}],\n\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatMethodDeprecated\'}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Error"\n\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\t\t\t\t\t\t\t\t\t\t<m:MessageStrip\n\t\t\t\t\t\t\t\t\t\t\tvisible="{=${methods>experimental} !== undefined}"\n\t\t\t\t\t\t\t\t\t\t\ttext="Experimental API since {methods>experimental/since} {methods>experimental/text}"\n\t\t\t\t\t\t\t\t\t\t\ttype="Warning"\n\t\t\t\t\t\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\t\t\t\t\t\tshowCloseButton="false"\n\t\t\t\t\t\t\t\t\t\t\tenableFormattedText="true"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t\t\t\t</m:MessageStrip>\n\n\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>name\' },\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'methods>parameters\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'methods>returnValue\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatMethodCode\'}"\n\t\t\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom" />\n\n\t\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'methods>parameters\', templateShareable: \'false\'}"\n\t\t\t\t\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t\tfixedLayout="true"\n\t\t\t\t\t\t\t\t\t\t\t\tvisible="{= ${methods>parameters}.length > 0}">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Param"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Default Value"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="50%"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<custom:ParamText customClass="{parts: [{path: \'methods>isSubProperty\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t{path: \'appView>/bPhoneSize\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatMethodClassName\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  text="{= ${appView>/bPhoneSize} &amp;&amp; ${methods>phoneName} ? ${methods>phoneName} : ${methods>name} }{= ${methods>optional} ? \'?\' : \'\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  wrapping="false"/>\n\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<layout:VerticalLayout content="{path: \'methods>types\', templateShareable: \'false\'}">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:HBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{methods>value}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{= ${methods>value}.replace(\'[]\', \'\') }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'methods>value\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationOrText" text="or" visible="{= ${methods>isLast} === false}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:HBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{parts: [{path: \'methods>defaultValue\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t   formatter: \'.formatDefaultValue\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\twrapping="false"/>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>description\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'methods>deprecated/text\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'methods>deprecated/since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t\t class="sapUiDocumentationReturnsTable"\n\t\t\t\t\t\t\t\t\t\t\t\t fixedLayout="true"\n\t\t\t\t\t\t\t\t\t\t\t\t visible="{= ${methods>returnValue} !== undefined}">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Returns"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="50%"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<layout:VerticalLayout content="{path: \'methods>returnValue/types\', templateShareable: \'false\'}">\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:HBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{methods>value}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{= ${methods>value}.replace(\'[]\', \'\') }"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'methods>value\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationOrText" text="or" visible="{= ${methods>isLast} === false}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t</m:HBox>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>returnValue/description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'methods>throws\', templateShareable: \'false\'}"\n\t\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t\t class="sapUiDocumentationReturnsTable"\n\t\t\t\t\t\t\t\t\t\t\t\t fixedLayout="true"\n\t\t\t\t\t\t\t\t\t\t\t\t visible="{= ${methods>throws} !== undefined}">\n\t\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Throws"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="50%"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{methods>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{methods>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'methods>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatExceptionLink\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>description\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="specialsettings"\n\t\t\t\t\t\t\t\t\t   title="Special Settings"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasSpecialSettings}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<m:Table items="{ path : \'topics>/ui5-metadata/specialSettings\'}"\n\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t fixedLayout="false"\n\t\t\t\t\t\t\t\t\t\t\t class="sapUiSmallMarginTop">\n\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top"><m:Label text="Name"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Tablet" demandPopin="true"><m:Label text="Description"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Text class="sapUiDocumentationParamBold" text="{topics>name}" wrapping="false"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<m:Link text="{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\thref="#/api/{topics>type}"\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tenabled="{parts: [{path: \'topics>type\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  formatter: \'.formatLinkEnabled\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'topics>deprecated/text\'},\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t {path: \'topics>deprecated/since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\tformatter: \'.formatDescription\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<ObjectPageSection id="annotations"\n\t\t\t\t\t\t\t\t\t   title="Annotations"\n\t\t\t\t\t\t\t\t\t   visible="{topics>/hasAnnotations}"\n\t\t\t\t\t\t\t\t\t   subSections="{ path : \'topics>/ui5-metadata/annotations\'}"\n\t\t\t\t\t\t\t\t\t   titleUppercase="false">\n\t\t\t\t\t\t<subSections>\n\t\t\t\t\t\t\t<ObjectPageSubSection title="{= ${topics>annotation} !== \'undefined\' ? ${topics>annotation} : \'(\' + ${topics>namespace} + \')\' }">\n\t\t\t\t\t\t\t\t<blocks>\n\t\t\t\t\t\t\t\t\t<layout:VerticalLayout width="100%">\n\n\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'}, {path: \'topics>since\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatAnnotationDescription\'}"/>\n\n\t\t\t\t\t\t\t\t\t\t<m:Table\n\t\t\t\t\t\t\t\t\t\t\t showSeparators="Inner"\n\t\t\t\t\t\t\t\t\t\t\t fixedLayout="true">\n\t\t\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column vAlign="Top" width="45%"><m:Label text="Namespace"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Target Type"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" vAlign="Top"><m:Label text="Applies To"/></m:Column>\n\t\t\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>namespace\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatAnnotationNamespace\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>target\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatAnnotationTarget\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>appliesTo\'}],\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t formatter: \'.formatAnnotationTarget\'}"/>\n\t\t\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t\t\t</m:Table>\n\n\t\t\t\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t\t\t</blocks>\n\t\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t\t</subSections>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t\t<core:ExtensionPoint name="customSections" />\n\n\t\t\t\t</sections>\n\n\t\t\t</ObjectPageLayout>\n\n\t\t</m:content>\n\n\t</m:Page>\n\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/ApiDetailAnnotationsSummary.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\n\t<layout:VerticalLayout width="100%">\n\t\t<m:Table items="{ path : \'topics>/ui5-metadata/annotations\'}"\n\t\t\t\t showSeparators="Inner"\n\t\t\t\t fixedLayout="true">\n\t\t\t<m:columns>\n\t\t\t\t<m:Column vAlign="Top" width="25%"><m:Label text="Annotation"/></m:Column>\n\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="75%"><m:Label text="Description"/></m:Column>\n\t\t\t</m:columns>\n\t\t\t<m:items>\n\t\t\t\t<m:ColumnListItem visible="{= !!${topics>annotation} }">\n\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t<m:Link text="{= ${topics>annotation} !== \'undefined\' ? ${topics>annotation} : \'(\' + ${topics>namespace} + \')\' }" press="scrollToAnnotation" wrapping="false" />\n\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'topics>description\'}], formatter: \'.formatAnnotationDescriptionSummary\'}"/>\n\t\t\t\t\t</m:cells>\n\t\t\t\t</m:ColumnListItem>\n\t\t\t</m:items>\n\t\t</m:Table>\n\n\t</layout:VerticalLayout>\n\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiDetailDeprecated.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailDeprecatedExperimental"\n          xmlns="sap.uxap"\n          xmlns:m="sap.m"\n          xmlns:mvc="sap.ui.core.mvc"\n          xmlns:layout="sap.ui.layout"\n          xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1">\n\n    <m:Page id="deprecatedAPIsPage"\n            showHeader="false"\n            showSubHeader="false"\n            showFooter="false">\n        <m:content>\n            <ObjectPageLayout enableLazyLoading="false"\n                              showAnchorBarPopover="true"\n                              upperCaseAnchorBar="false"\n                              sections="{path : \'deprecatedAPIs>/\',\n                                         sorter : {path : \'name\',\n                                                   comparator : \'.compareVersions\'} }">\n                <headerTitle>\n                    <ObjectPageHeader id="title" objectTitle="Index of Deprecated APIs"/>\n                </headerTitle>\n                <headerContent>\n                    <layout:VerticalLayout id="deprecatedAPIStripContainer">\n                        <m:MessageStrip\n                                text="For general information about Deprecated features, please check the Compatibility Rules."\n                                type="Error"\n                                showIcon="true"/>\n                    </layout:VerticalLayout>\n                </headerContent>\n                <sections>\n                    <ObjectPageSection\n                            titleUppercase="false"\n                            title="{parts : [{ path : \'deprecatedAPIs>name\'}],\n                                               formatter : \'.formatTitle\' }">\n                        <subSections>\n                            <ObjectPageSubSection>\n                                <blocks>\n                                    <m:List\n                                            items="{ path : \'deprecatedAPIs>apis\', templateShareable: \'false\'}"\n                                            showSeparators="Inner">\n                                        <m:items>\n                                            <m:FeedListItem\n                                                    showIcon="false"\n                                                    sender="{parts : [{path : \'deprecatedAPIs>control\'}, {path : \'deprecatedAPIs>entityName\'}, {path: \'deprecatedAPIs>type\'}],\n                                                              formatter : \'.formatSenderLink\'}"\n                                                    text="{parts : [{path : \'deprecatedAPIs>text\'}, {path : \'deprecatedAPIs>since\'}],\n                                                           formatter: \'.formatDescription\'}"\n                                                    senderPress="onApiPress"\n                                                    app:control="{deprecatedAPIs>control}"\n                                                    app:entity="{deprecatedAPIs>entityName}"\n                                                    app:type="{deprecatedAPIs>type}"\n                                                    app:static="{deprecatedAPIs>static}"/>\n                                        </m:items>\n                                    </m:List>\n                                </blocks>\n                            </ObjectPageSubSection>\n                        </subSections>\n                    </ObjectPageSection>\n                </sections>\n            </ObjectPageLayout>\n        </m:content>\n    </m:Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailEventsSummary.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\n\t<layout:VerticalLayout width="100%">\n\n\t\t<m:Table items="{ path : \'events>/events\'}"\n\t\t\t\t showSeparators="Inner"\n\t\t\t\t fixedLayout="false"\n\t\t\t\t visible="{topics>/hasOwnEvents}">\n\t\t\t<m:columns>\n\t\t\t\t<m:Column vAlign="Top"><m:Label text="Event"/></m:Column>\n\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><m:Label text="Description"/></m:Column>\n\t\t\t</m:columns>\n\t\t\t<m:items>\n\t\t\t\t<m:ColumnListItem visible="{= !!${events>name} }">\n\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t<layout:VerticalLayout>\n\t\t\t\t\t\t\t<m:Link text="{events>name}" href="#/api/{topics>/name}/events/{events>name}" press="scrollToEvent" wrapping="false" />\n\t\t\t\t\t\t\t<m:ObjectStatus icon="sap-icon://message-error" state="Error" text="Deprecated" visible="{= ${events>deprecated} !== undefined }"/>\n\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'events>description\'}], formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t</m:cells>\n\t\t\t\t</m:ColumnListItem>\n\t\t\t</m:items>\n\t\t</m:Table>\n\n\t\t<m:Title visible="{= ${borrowedEvents>/}.length > 0 }" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle" text="Borrowed from:"></m:Title>\n\t\t<layout:VerticalLayout visible="{= ${borrowedEvents>/}.length > 0 }" width="100%" content="{ path : \'borrowedEvents>/\'}">\n\t\t\t<m:Panel expandable="true" expanded="true" headerText="{borrowedEvents>name}" width="100%" content="{ path: \'borrowedEvents>events\', templateShareable: \'false\'}">\n\t\t\t\t<m:Link class="sapUiTinyMargin" text="{borrowedEvents>name}" href="{borrowedEvents>link}" />\n\t\t\t</m:Panel>\n\t\t</layout:VerticalLayout>\n\n\t</layout:VerticalLayout>\n\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiDetailExperimental.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ApiDetailDeprecatedExperimental"\n          xmlns="sap.uxap"\n          xmlns:layout="sap.ui.layout"\n          xmlns:m="sap.m"\n          xmlns:mvc="sap.ui.core.mvc"\n          xmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1">\n\n    <m:Page\n            showHeader="false"\n            showSubHeader="false"\n            showFooter="false">\n        <m:content>\n            <ObjectPageLayout enableLazyLoading="false"\n                              showAnchorBarPopover="true"\n                              upperCaseAnchorBar="false"\n                              sections="{path : \'experimentalAPIs>/\',\n                                         sorter : {\n                                           path : \'name\',\n                                           comparator : \'.compareVersions\'\n                                         }\n                                        }">\n                <headerTitle>\n                    <ObjectPageHeader id="title" objectTitle="Index of Experimental APIs"/>\n                </headerTitle>\n                <headerContent>\n                    <layout:VerticalLayout id="experimentalAPIStripContainer">\n                        <m:MessageStrip\n                                text="Experimental features are not part of the officially delivered scope that SAP is going to guarantee for future releases – means experimental Features may be changed by SAP at any time for any reason without notice. The Experimental features are NOT FOR PRODUCTION USE. You may not demonstrate, test, examine, evaluate or otherwise use the Experimental Features in a live operating environment or with data that has not been sufficiently backed up. The purpose of Experimental features is to get feedback at an early point of time allowing customers/partners to influence the future product accordingly. Please use the SDN Developer Center http://scn.sap.com/community/developer-center/front-end to provide feedback accepting that Intellectual Property rights of the contributions or derivative works shall remain the exclusive property of SAP. For general information about Experimental features, please check the Compatibility Rules"\n                                type="Warning"\n                                showIcon="true"/>\n                    </layout:VerticalLayout>\n                </headerContent>\n                <sections>\n                    <ObjectPageSection\n                            titleUppercase="false"\n                            title="{parts : [{path : \'experimentalAPIs>name\'}],\n                                              formatter : \'.formatTitle\'}">\n                        <subSections>\n                            <ObjectPageSubSection>\n                                <blocks>\n                                    <m:List items="{ path: \'experimentalAPIs>apis\', templateShareable: \'false\'}"\n                                            showSeparators="Inner">\n                                        <m:items>\n                                            <m:FeedListItem\n                                                    showIcon="false"\n                                                    sender="{parts : [{path : \'experimentalAPIs>control\'}, {path : \'experimentalAPIs>entityName\'}, {path: \'experimentalAPIs>type\'}],\n                                                             formatter : \'.formatSenderLink\'}"\n                                                    text="{parts : [{path : \'experimentalAPIs>text\'}, {path : \'experimentalAPIs>since\'}],\n                                                           formatter: \'.formatDescription\'}"\n                                                    senderPress="onApiPress"\n                                                    app:control="{experimentalAPIs>control}"\n                                                    app:entity="{experimentalAPIs>entityName}"\n                                                    app:type="{experimentalAPIs>type}"\n                                                    app:static="{experimentalAPIs>static}"/>\n                                        </m:items>\n                                    </m:List>\n                                </blocks>\n                            </ObjectPageSubSection>\n                        </subSections>\n                    </ObjectPageSection>\n                </sections>\n            </ObjectPageLayout>\n        </m:content>\n    </m:Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailInitial.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ApiDetailInitial"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls">\n\n\t<Page showHeader="false">\n\t\t<l:BlockLayout>\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding">\n\t\t\t\t\t<Image\n\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/API_ref_S_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{device>/system/phone}"/>\n\t\t\t\t\t<Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/API_ref_M_and_L_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/>\n\n\t\t\t\t\t<Text id="landingImageHeadline"\n\t\t\t\t\t\tclass="sapUiDocumentationApiHeaderText sapUiDocumentationApiHeaderTitleText"\n\t\t\t\t\t\ttext="API Reference"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\ttextAlign="Left"/>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\ttitle="Featured Namespaces"\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternA sapUiDemokitLandingBlockHeadline"/>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\twidth="2"\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternB" >\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Main Controls"\n\t\t\t\t\t\t\t\thref="#/api/sap.m"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Responsive controls for touch-enabled devices and desktop browsers"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.m"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Layout"\n\t\t\t\t\t\t\t\thref="#/api/sap.ui.layout.form.Form"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.layout"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Tables"\n\t\t\t\t\t\t\t\thref="#/api/sap.ui.table"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Tables for desktop-type scenarios"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.table"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="SAP Fiori"\n\t\t\t\t\t\t\t\thref="#/api/sap.f"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Controls specialized for SAP Fiori applications"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.f"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="SAP Fiori for Tools"\n\t\t\t\t\t\t\t\thref="#/api/sap.tnt"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Controls specialized for administrative applications"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.tnt"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternB"\n\t\t\t\t\t\twidth="2">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="UI5 Core Runtime"\n\t\t\t\t\t\t\t\thref="#/api/sap.ui.core"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Boots the core framework and makes it available for the application via method sap.ui.getCore()"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.core"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternE"\n\t\t\t\t\t\twidth="2">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Object Page"\n\t\t\t\t\t\t\t\thref="#/api/sap.uxap"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Controls for displaying, creating and editing objects"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.uxap"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternC"\n\t\t\t\t\t\twidth="2">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Models"\n\t\t\t\t\t\t\t\thref="#/api/sap.ui.model"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Data binding utilities"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.model"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow visible="{= !${versionData>/isOpenUI5}}">\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternB"\n\t\t\t\t\t\twidth="2">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Smart Controls"\n\t\t\t\t\t\t\t\thref="#/api/sap.ui.comp"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Metadata-driven controls"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.ui.comp"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Micro Charts"\n\t\t\t\t\t\t\t\thref="#/api/sap.suite.ui.microchart"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Lightweight diagrams"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.suite.ui.microchart"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Charts"\n\t\t\t\t\t\t\t\thref="#/api/sap.viz"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Data visualization"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Label\n\t\t\t\t\t\t\t\ttext="Namespace: sap.viz"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" />\n\t\t\t</l:BlockLayoutRow>\n\n\t\t</l:BlockLayout>\n\t</Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/ApiDetailMethodsSummary.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\n\t<layout:VerticalLayout width="100%">\n\n\t\t<m:Table items="{ path : \'methods>/methods\'}"\n\t\t\t\t showSeparators="Inner"\n\t\t\t\t fixedLayout="false"\n\t\t\t\t visible="{topics>/hasOwnMethods}">\n\t\t\t<m:columns>\n\t\t\t\t<m:Column vAlign="Top" width="25%"><m:Label text="Method"/></m:Column>\n\t\t\t\t<m:Column vAlign="Top" minScreenWidth="Desktop" demandPopin="true" popinDisplay="WithoutHeader" width="75%"><m:Label text="Description"/></m:Column>\n\t\t\t</m:columns>\n\t\t\t<m:items>\n\t\t\t\t<m:ColumnListItem visible="{= !!${methods>name} }">\n\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t<layout:VerticalLayout>\n\t\t\t\t\t\t\t<m:Link text="{parts: [\n\t\t\t\t\t\t\t\t\t{path: \'methods>name\'},\n\t\t\t\t\t\t\t\t\t{path: \'topics>/name\'},\n\t\t\t\t\t\t\t\t\t{path: \'methods>static\'}\n\t\t\t\t\t\t\t\t\t], formatter: \'.formatEntityName\'}"\n\t\t\t\t\t\t\t\t\thref="#/api/{topics>/name}/methods/{parts: [\n\t\t\t\t\t\t\t\t\t{path: \'methods>name\'},\n\t\t\t\t\t\t\t\t\t{path: \'topics>/name\'},\n\t\t\t\t\t\t\t\t\t{path: \'methods>static\'}\n\t\t\t\t\t\t\t\t\t], formatter: \'.formatEntityName\'}" press="scrollToMethod" wrapping="false"/>\n\t\t\t\t\t\t\t<m:ObjectStatus icon="sap-icon://message-error" state="Error" text="Deprecated" visible="{= ${methods>deprecated} !== undefined }"/>\n\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t<core:HTML content="{parts: [{path: \'methods>description\'}], formatter: \'.formatDescription\'}"/>\n\t\t\t\t\t</m:cells>\n\t\t\t\t</m:ColumnListItem>\n\t\t\t</m:items>\n\t\t</m:Table>\n\n\t\t<m:Title visible="{= ${borrowedMethods>/}.length > 0 }" class="sapUiSmallMarginTop sapUiDocumentationBorrowedTitle" text="Borrowed from:"/>\n\t\t<layout:VerticalLayout visible="{= ${borrowedMethods>/}.length > 0 }" width="100%" content="{ path : \'borrowedMethods>/\'}">\n\t\t\t<m:Panel expandable="true" expanded="true" class="borrowedMethodsPanel" headerText="{borrowedMethods>name}" width="100%" content="{ path: \'borrowedMethods>methods\', templateShareable: \'false\'}">\n\t\t\t\t<m:Link class="sapUiTinyMargin" text="{borrowedMethods>name}" href="{borrowedMethods>link}" />\n\t\t\t</m:Panel>\n\t\t</layout:VerticalLayout>\n\n\t</layout:VerticalLayout>\n\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ApiMaster.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ApiMaster"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\tclass="sapContrast sapContrastPlus">\n\n\t<Page\n\t\t\tid="page"\n\t\t\tenableScrolling="true"\n\t\t\tshowFooter="false"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowNavButton="false"\n\t\t\tclass="sapUiDocumentationMasterPage">\n\n\t\t<customHeader>\n\t\t\t<Toolbar width="100%">\n\t\t\t\t<SearchField placeholder="Filter" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"></SearchField>\n\t\t\t\t<Button icon="sap-icon://expand-group" press="onTreeExpandAll"></Button>\n\t\t\t\t<Button icon="sap-icon://collapse-group" press="onTreeCollapseAll"></Button>\n\t\t\t</Toolbar>\n\t\t</customHeader>\n\n\t\t<content>\n\n\t\t\t<Tree\n\t\t\t\t\tid="tree"\n\t\t\t\t\tmode="SingleSelectMaster"\n\t\t\t\t\tselectionChange="onNodeSelect"\n\t\t\t\t\titems="{\n\t\t\t\t\t\tpath: \'treeData>/\',\n\t\t\t\t\t\tsorter : {\n\t\t\t\t\t\t\tpath : \'name\',\n\t\t\t\t\t\t\tcomparator : \'.compareTreeNodes\'\n\t\t\t\t\t\t}\n\t\t\t\t\t}">\n\t\t\t\t<StandardTreeItem\n\t\t\t\t\t\ttitle="{treeData>text}">\n\t\t\t\t\t<customData>\n\t\t\t\t\t\t<core:CustomData key="nodeId" value="{treeData>name}" />\n\t\t\t\t\t</customData>\n\t\t\t\t</StandardTreeItem>\n\t\t\t</Tree>\n\n\t\t</content>\n\n\t</Page>\n\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/App.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.App"\n\t\txmlns="sap.m"\n\t\txmlns:tnt="sap.tnt"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls"\n\t\tdisplayBlock="true"\n\t\tbusy="{appView>/busy}"\n\t\tbusyIndicatorDelay="{appView>/delay}">\n\t<Page\n\t\tshowHeader="false"\n\t\tenableScrolling="false"\n\t\tshowNavButton="false"\n\t\tclass="sapUiDemokit">\n\t\t<content>\n\t\t\t<tnt:ToolHeader id="headerToolbar">\n\t\t\t\t<ToggleButton icon="sap-icon://menu2" type="Transparent" visible="{= ${appView>/bHasMaster} &amp;&amp; ( ${appView>/bPhoneSize} || !${appView>/bLandscape} ) &amp;&amp; !${appView>/bSearchMode} }" press="toggleMaster" pressed="{appView>/bIsShownMaster}">\n\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t<OverflowToolbarLayoutData priority="NeverOverflow" />\n\t\t\t\t\t</layoutData>\n\t\t\t\t</ToggleButton>\n\t\t\t\t<Image id="sap_logo" src="./resources/sap/ui/documentation/sdk/images/logo_ui5.png"\n\t\t\t\t\tvisible="{=!${appView>/bPhoneSize}}"\n\t\t\t\t\tdensityAware="false"\n\t\t\t\t\theight="2rem"\n\t\t\t\t\tclass="sapLogo"\n\t\t\t\t\tdecorative="false"\n\t\t\t\t\tpress="navigateToSection" />\n\t\t\t\t<core:ExtensionPoint name="customStartLinks" />\n\t\t\t\t<IconTabHeader id="tabHeader"\n\t\t\t\t\t\tselectedKey="home"\n\t\t\t\t\t\tshowOverflowSelectList="true"\n\t\t\t\t\t\tbackgroundDesign="Transparent"\n\t\t\t\t\t\tmode="Inline"\n\t\t\t\t\t\tselect="navigateToSection"\n\t\t\t\t\t\tvisible="{=!${appView>/bPhoneSize} || !${appView>/bSearchMode}}">\n\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t<OverflowToolbarLayoutData priority="NeverOverflow" shrinkable="true" />\n\t\t\t\t\t</layoutData>\n\t\t\t\t\t<items>\n\t\t\t\t\t\t<IconTabFilter id="welcomeTab" text="Home" key="home" visible="{=${appView>/bPhoneSize}}">\n\t\t\t\t\t\t</IconTabFilter>\n\t\t\t\t\t\t<IconTabFilter id="topicMasterTab" text="Documentation" key="topic" visible="{= !${appView>/bHideEmptySections}}">\n\t\t\t\t\t\t</IconTabFilter>\n\t\t\t\t\t\t<IconTabFilter id="apiMasterTab" text="API Reference" key="api" visible="{= !${appView>/bHideEmptySections}}">\n\t\t\t\t\t\t</IconTabFilter>\n\t\t\t\t\t\t<IconTabFilter id="controlsMasterTab" text="Samples" key="controls">\n\t\t\t\t\t\t</IconTabFilter>\n\t\t\t\t\t\t<IconTabFilter id="demoAppsTab" text="Demo Apps" key="demoapps">\n\t\t\t\t\t\t</IconTabFilter>\n\t\t\t\t\t\t<IconTabFilter id="toolsTab" text="Tools" key="tools">\n\t\t\t\t\t\t</IconTabFilter>\n\t\t\t\t\t</items>\n\t\t\t\t</IconTabHeader>\n\n\t\t\t\t<ToolbarSpacer visible="{=!${appView>/bPhoneSize}}">\n\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t<OverflowToolbarLayoutData priority="NeverOverflow" minWidth="{= ${device>/system/tablet} ? \'\' : \'1rem\'}" />\n\t\t\t\t\t</layoutData>\n\t\t\t\t</ToolbarSpacer>\n\n\t\t\t\t<ObjectStatus text="Version {versionData>/version} {= ${versionData>/isDevVersion} ? \'- development in progress!\' : \'\'}" state="{= ${versionData>/isDevVersion} ? \'Warning\' : \'None\'}" visible="{=!${appView>/bPhoneSize}}" />\n\n\t\t\t\t<custom:Search id="searchControl" toggle="onToggleSearchMode" search="onSearch" width="{= (${appView>/bPhoneSize} &amp;&amp; ${appView>/bSearchMode}) ? \'100%\' : \'\'}"/>\n\n\t\t\t\t<Button press="feedbackDialogOpen" icon="sap-icon://comment" type="Transparent" visible="{=!${appView>/bPhoneSize} &amp;&amp; !${appView>/bSearchMode}}">\n\n\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t<OverflowToolbarLayoutData priority="NeverOverflow" />\n\t\t\t\t\t</layoutData>\n\t\t\t\t</Button>\n\n\t\t\t\t<MenuButton icon="sap-icon://hint" type="Transparent" visible="{=!${appView>/bSearchMode}}">\n\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t<OverflowToolbarLayoutData priority="NeverOverflow" />\n\t\t\t\t\t</layoutData>\n\t\t\t\t\t<menu>\n\t\t\t\t\t\t<Menu class="sapContrast sapContrastPlus" itemSelected="handleMenuItemClick">\n\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t<MenuItem text="Version {versionData>/version}" visible="{appView>/bPhoneSize}" />\n\t\t\t\t\t\t\t\t<MenuItem text="Feedback" visible="{appView>/bPhoneSize}" />\n\t\t\t\t\t\t\t\t<MenuItem text="About" />\n\t\t\t\t\t\t\t\t<MenuItem text="Legal" visible="{=!${versionData>/isOpenUI5}}"/>\n\t\t\t\t\t\t\t\t<MenuItem text="Privacy" visible="{=!${versionData>/isOpenUI5}}"/>\n\t\t\t\t\t\t\t\t<MenuItem text="Terms of Use" visible="{=!${versionData>/isOpenUI5}}">\n\t\t\t\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t\t\t\t<MenuItem text="Terms of Use" />\n\t\t\t\t\t\t\t\t\t\t<MenuItem text="Copyright" />\n\t\t\t\t\t\t\t\t\t\t<MenuItem text="Trademark" />\n\t\t\t\t\t\t\t\t\t\t<MenuItem text="Disclaimer" />\n\t\t\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t\t\t</MenuItem>\n\t\t\t\t\t\t\t</items>\n\t\t\t\t\t\t</Menu>\n\t\t\t\t\t</menu>\n\t\t\t\t</MenuButton>\n\t\t\t\t<core:ExtensionPoint name="customLinks" />\n\t\t\t</tnt:ToolHeader>\n\n\t\t\t<core:ExtensionPoint name="customControls" />\n\t\t\t<ScrollContainer\n\t\t\t\t\tid="contentId"\n\t\t\t\t\twidth="100%"\n\t\t\t\t\theight="calc(100% - 3rem)"\n\t\t\t\t\thorizontal="false"\n\t\t\t\t\tvertical="false">\n\t\t\t\t<SplitApp id="splitApp"\n\t\t\t\t\t\t  mode="HideMode"\n\t\t\t\t\t\t  defaultTransitionNameDetail="show"\n\t\t\t\t\t\t  defaultTransitionNameMaster="fade">\n\t\t\t\t</SplitApp>\n\t\t\t</ScrollContainer>\n\t\t</content>\n\t\t<footer>\n\t\t\t<core:ExtensionPoint name="footer" />\n\t\t</footer>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/Code.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Code"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns="sap.m"\n\t\txmlns:ce="sap.ui.codeeditor" height="100%">\n\t<Page\n\t\t\tid="page"\n\t\t\tshowNavButton="true"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\ttitle="{/title}"\n\t\t\ticon="img/144_iPad_Retina_Web_Clip.png"\n\t\t\tenableScrolling="false">\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<headerContent>\n\t\t\t<Button\n\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\ttext="Download"\n\t\t\t\t\ticon="sap-icon://download"\n\t\t\t\t\tpress="onDownload" />\n\t\t\t<Button\n\t\t\t\t\tclass="sapUiVisibleOnlyOnPhone"\n\t\t\t\t\ticon="sap-icon://download"\n\t\t\t\t\tpress="onDownload" />\n\t\t</headerContent>\n\t\t<content>\n\t\t\t<l:FixFlex>\n\t\t\t\t<l:fixContent>\n\t\t\t\t\t<IconTabHeader\n\t\t\t\t\t\t\tid="tabHeader"\n\t\t\t\t\t\t\tshowOverflowSelectList="true"\n\t\t\t\t\t\t\tmode="Inline"\n\t\t\t\t\t\t\titems="{/files}"\n\t\t\t\t\t\t\tselect="handleTabSelectEvent"\n\t\t\t\t\t\t\tselectedKey="{/fileName}">\n\t\t\t\t\t\t<items>\n\t\t\t\t\t\t\t<IconTabFilter\n\t\t\t\t\t\t\t\tkey="{name}"\n\t\t\t\t\t\t\t\ttext="{name}"/>\n\t\t\t\t\t\t</items>\n\t\t\t\t\t</IconTabHeader>\n\t\t\t\t</l:fixContent>\n\t\t\t\t<l:flexContent>\n\t\t\t\t\t<ce:CodeEditor\n\t\t\t\t\t\tid="codeEditor"\n\t\t\t\t\t\teditable="false"/>\n\t\t\t\t</l:flexContent>\n\t\t\t</l:FixFlex>\n\t\t</content>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/Controls.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Controls"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls">\n\t<ScrollContainer\n\t\t\twidth="100%"\n\t\t\theight="100%"\n\t\t\thorizontal="false"\n\t\t\tvertical="true">\n\n\t\t<l:BlockLayout>\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding">\n\t\t\t\t\t<Image\n\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Explored_S_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{device>/system/phone}"/>\n\n\t\t\t\t\t<Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Explored_M_and_L_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/>\n\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<Text class="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredHeaderTitleText"\n\t\t\t\t\t\t\ttext="Samples"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttextAlign="Left"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\tclass="sapUiDocumentationExploredHeaderText sapUiDocumentationExploredSubText"\n\t\t\t\t\t\t\ttext="Explore and download code samples"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttextAlign="Left"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\ttitle="Featured Controls"\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternA sapUiDemokitLandingBlockHeadline"/>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://edit"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Input"\n\t\t\t\t\t\t\t\tfilter="Input"\n\t\t\t\t\t\t\t\ttext="Input"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="User interaction"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://list"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/List"\n\t\t\t\t\t\t\t\tfilter="List"\n\t\t\t\t\t\t\t\ttext="Lists"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Various list structures"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://table-view"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Table"\n\t\t\t\t\t\t\t\tfilter="Table"\n\t\t\t\t\t\t\t\ttext="Tables"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Simple or more powerful tables"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://popup-window"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Popup"\n\t\t\t\t\t\t\t\tfilter="Popup"\n\t\t\t\t\t\t\t\ttext="Pop-Ups"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Dialogs and popovers"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://grid"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Tile"\n\t\t\t\t\t\t\t\tfilter="Tile"\n\t\t\t\t\t\t\t\ttext="Tiles"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Tiles for e.g. texts, images or charts"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://message-popup"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Message"\n\t\t\t\t\t\t\t\tfilter="Message"\n\t\t\t\t\t\t\t\ttext="Messages"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="User notification"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://header"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Bar"\n\t\t\t\t\t\t\t\tfilter="Bar"\n\t\t\t\t\t\t\t\ttext="Bars"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Toolbars and headers"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://tree"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Tree"\n\t\t\t\t\t\t\t\tfilter="Tree"\n\t\t\t\t\t\t\t\ttext="Trees"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Hierarchical data representation"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\t\t\t<l:BlockLayoutRow visible="{= !${versionData>/isOpenUI5}}">\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://lightbulb"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Smart"\n\t\t\t\t\t\t\t\tfilter="Smart"\n\t\t\t\t\t\t\t\ttext="Smart Controls"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Metadata-driven controls"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://map-2"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Map"\n\t\t\t\t\t\t\t\tfilter="Map"\n\t\t\t\t\t\t\t\ttext="Maps"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Location visualization"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://filter-analytics"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Chart"\n\t\t\t\t\t\t\t\tfilter="Chart"\n\t\t\t\t\t\t\t\ttext="Charts"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Data visualization"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://process"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Process"\n\t\t\t\t\t\t\t\tfilter="Process"\n\t\t\t\t\t\t\t\ttext="Processes"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text text="Step-based Interactions"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\ttitle="Layout &amp; Pages"\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternA sapUiDemokitLandingBlockHeadline"/>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://write-new"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Object Page"\n\t\t\t\t\t\t\t\tfilter="Object Page"\n\t\t\t\t\t\t\t\ttext="Object Page"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Displaying, creating, or editing objects"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://chart-table-view"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Dynamic Page"\n\t\t\t\t\t\t\t\tfilter="Dynamic Page"\n\t\t\t\t\t\t\t\ttext="Dynamic Page"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Page with title, header, and content area"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://screen-split-three"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Flexible Column Layout"\n\t\t\t\t\t\t\t\tfilter="Flexible Column Layout"\n\t\t\t\t\t\t\t\ttext="Flexible Column Layout"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Page with up to 3 columns"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell class="largeCell demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://screen-split-one"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tpress="onPress"\n\t\t\t\t\t\t\t\thref="#controls/filter/Split App"\n\t\t\t\t\t\t\t\tfilter="Split App"\n\t\t\t\t\t\t\t\ttext="Split App"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Two-column layout"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" />\n\t\t\t</l:BlockLayoutRow>\n\n\t\t</l:BlockLayout>\n\t</ScrollContainer>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/ControlsMaster.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.ControlsMaster"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\tclass="sapContrast sapContrastPlus">\n\t<Page\n\t\t\tid="exploredMasterPage"\n\t\t\tshowFooter="false"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowNavButton="false"\n\t\t\tshowHeader="false"\n\t\t\tclass="sapUiDocumentationMasterPage">\n\n\t\t<!-- Header -->\n\t\t<subHeader>\n\t\t\t<Toolbar>\n\t\t\t\t<ToolbarSpacer/>\n\t\t\t\t<SearchField\n\t\t\t\t\t\tid="searchField"\n\t\t\t\t\t\tplaceholder="Filter"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tliveChange="handleListFilter">\n\t\t\t\t</SearchField>\n\t\t\t\t<ToolbarSpacer/>\n\t\t\t\t<Button icon="sap-icon://drop-down-list" press="handleListSettings" />\n\t\t\t\t<ToolbarSpacer/>\n\t\t\t\t<Button icon="sap-icon://action-settings" press="handleSettings" />\n\t\t\t</Toolbar>\n\t\t</subHeader>\n\n\t\t<!-- Navigation List -->\n\t\t<content>\n\t\t\t<List id="exploredMasterList"\n\t\t\t\t  mode="{viewModel>/listMode}"\n\t\t\t\t  selectionChange="onNavToEntity"\n\t\t\t\t  items="{path: \'/entities\',\n\t\t\t\t  groupHeaderFactory: \'.getGroupHeader\',\n\t\t\t\t  sorter: [{\n\t\t\t\t\t\tpath: \'category\',\n\t\t\t\t\t\tdescending: false,\n\t\t\t\t\t\tgroup: true\n\t\t\t\t\t},{\n\t\t\t\t\t\tpath: \'name\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}]}">\n\t\t\t\t<infoToolbar>\n\t\t\t\t\t<Toolbar id="vsFilterBar"\n\t\t\t\t\t\t\tactive="true"\n\t\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\t\tpress="handleListSettings">\n\t\t\t\t\t\t<Label id="vsFilterLabel" />\n\t\t\t\t\t</Toolbar>\n\t\t\t\t</infoToolbar>\n\t\t\t\t<items>\n\t\t\t\t\t<StandardListItem\n\t\t\t\t\t\t\ttitle="{name}"\n\t\t\t\t\t\t\tcounter="{sampleCount}"\n\t\t\t\t\t\t\ttype="{viewModel>/listItemType}"\n\t\t\t\t\t\t\tpress="onNavToEntity" />\n\t\t\t\t</items>\n\t\t\t</List>\n\t\t</content>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/DemoApps.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.DemoApps"\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc">\n\t<Page\n\t\tid="demoAppsPage"\n\t\tnavButtonPress="onNavBack"\n\t\tshowSubHeader="false"\n\t\tshowFooter="false"\n\t\tshowHeader="false">\n\t\t<content>\n\t\t\t<core:ComponentContainer name="sap.ui.documentation.demoapps" />\n\t\t</content>\n\t</Page>\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/Downloads.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Downloads"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m">\n\t<Label text="Downloads" />\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/Empty.view.xml":'<mvc:View\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m">\n\t<Label text="Empty" />\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/Entity.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Entity"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:m="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns="sap.uxap">\n\t<ObjectPageLayout\n\t\t\tid="ObjectPageLayout"\n\t\t\tuseIconTabBar="true"\n\t\t\tselectedSection="samples"\n\t\t\tupperCaseAnchorBar="false"\n\t\t\tbusyIndicatorDelay="0">\n\t\t<headerTitle>\n\t\t\t<ObjectPageHeader\n\t\t\t\t\tid="entityHeader"\n\t\t\t\t\tobjectTitle="{/name}">\n\t\t\t\t<actions>\n\t\t\t\t\t<ObjectPageHeaderActionButton id="entityBackToSearch" text="Back to search results" hideIcon="true" hideText="false" press="backToSearch" visible="false"/>\n\t\t\t\t\t<ObjectPageHeaderActionButton\n\t\t\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"\n\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\ttooltip="Show this sample in full screen mode"\n\t\t\t\t\t\t\tpress="onToggleFullScreen" />\n\t\t\t\t</actions>\n\t\t\t</ObjectPageHeader>\n\t\t</headerTitle>\n\n\t\t<headerContent>\n\t\t\t<l:Grid defaultSpan="L4 M6 S12" class="sapUiNoMargin" hSpacing="0">\n\t\t\t\t<l:VerticalLayout class="sapUiLargeMarginEnd" width="98%">\n\n\t\t\t\t\t<m:HBox visible="{= ${/entity/category} !== \'Tutorial\'}" class="sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom">\n\t\t\t\t\t\t<m:Label design="Bold" text="API Reference:"/>\n\t\t\t\t\t\t<m:Link emphasized="true" text="{/name}" enabled="true" href="#/api/{/name}"/>\n\t\t\t\t\t</m:HBox>\n\n\t\t\t\t\t<m:HBox visible="{/show/introLink}" class="sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom">\n\t\t\t\t\t\t<m:Label design="Bold" text="Documentation:"/>\n\t\t\t\t\t\t<m:Link emphasized="true" text="{/baseName}" enabled="true" href="{/docuLink}"/>\n\t\t\t\t\t</m:HBox>\n\n\t\t\t\t\t<m:HBox class="sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom">\n\t\t\t\t\t\t<m:Label text="Extends:"/>\n\t\t\t\t\t\t<m:Link text="{/baseTypeText}" enabled="true" href="#/entity/{/baseType}"\n\t\t\t\t\t\t\t\tvisible="{=!!${/baseTypeNav}}"/>\n\t\t\t\t\t\t<m:Text text="N/A" visible="{=!${/baseTypeNav}}"/>\n\t\t\t\t\t</m:HBox>\n\n\t\t\t\t\t<m:ObjectAttribute\n\t\t\t\t\t\t\ttitle="Application Component"\n\t\t\t\t\t\t\ttext="{/appComponent}" />\n\t\t\t\t</l:VerticalLayout>\n\n\t\t\t\t<l:VerticalLayout class="sapUiLargeMarginLeft" width="100%">\n\t\t\t\t\t<m:ObjectAttribute\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\t\t\t\ttitle="Available since"\n\t\t\t\t\t\t\ttext="{/entity/since}" />\n\n\t\t\t\t\t<m:ObjectAttribute\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\t\t\t\ttitle="Category"\n\t\t\t\t\t\t\ttext="{/entity/category}" />\n\n\t\t\t\t\t<m:ObjectAttribute\n\t\t\t\t\t\t\ttitle="Content Density"\n\t\t\t\t\t\t\ttext="{/entity/formFactors}" />\n\t\t\t\t</l:VerticalLayout>\n\t\t\t</l:Grid>\n\t\t</headerContent>\n\n\t\t<sections>\n\t\t\t<ObjectPageSection id="about" title="About">\n\t\t\t\t<subSections>\n\t\t\t\t\t<ObjectPageSubSection>\n\n\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t<core:HTML content="{/description}" />\n\n\t\t\t\t\t\t\t<l:VerticalLayout visible="{/show/introLink}">\n\t\t\t\t\t\t\t\t<m:Text text="{/shortDescription}"/>\n\t\t\t\t\t\t\t</l:VerticalLayout>\n\n\t\t\t\t\t\t\t<m:Table\n\t\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\t\tvisible="{/show/values}"\n\t\t\t\t\t\t\t\t\tshowSeparators="Inner"\n\t\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\t\titems="{/values}" >\n\t\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t\t<m:Column><m:Label text="Name" /></m:Column>\n\t\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet" demandPopin="true" popinDisplay="WithoutHeader"><m:Label text="Description" /></m:Column>\n\t\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t\t<m:ColumnListItem>\n\t\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{name}" class="docuKey" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t\t<m:Text text="{description}" />\n\t\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t\t</l:VerticalLayout>\n\n\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t</subSections>\n\t\t\t</ObjectPageSection>\n\n\t\t\t<ObjectPageSection id="samples" title="Samples ({/count/samples})" visible="{= ${/count/samples} > 0 }">\n\t\t\t\t<subSections>\n\t\t\t\t\t<ObjectPageSubSection>\n\t\t\t\t\t\t<m:Table\n\t\t\t\t\t\t\t\tclass="myTable"\n\t\t\t\t\t\t\t\tid="table"\n\t\t\t\t\t\t\t\titems="{/entity/samples}"\n\t\t\t\t\t\t\t\tfixedLayout="false"\n\t\t\t\t\t\t\t\tshowSeparators="Inner" >\n\t\t\t\t\t\t\t<m:columns>\n\t\t\t\t\t\t\t\t<m:Column><m:Label text="Name" /></m:Column>\n\t\t\t\t\t\t\t\t<m:Column minScreenWidth="Tablet"><m:Label text="Description" /></m:Column>\n\t\t\t\t\t\t\t</m:columns>\n\t\t\t\t\t\t\t<m:items>\n\t\t\t\t\t\t\t\t<m:ColumnListItem type="Navigation" press="onNavToSample" vAlign="Middle">\n\t\t\t\t\t\t\t\t\t<m:cells>\n\t\t\t\t\t\t\t\t\t\t<m:Text text="{name}" class="entitySampleName" wrapping="false" />\n\t\t\t\t\t\t\t\t\t\t<m:FormattedText htmlText="{= ${path: \'description\'} ? ${path: \'description\'} : \'\'}" />\n\t\t\t\t\t\t\t\t\t</m:cells>\n\t\t\t\t\t\t\t\t</m:ColumnListItem>\n\t\t\t\t\t\t\t</m:items>\n\t\t\t\t\t\t</m:Table>\n\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t</subSections>\n\t\t\t</ObjectPageSection>\n\t\t</sections>\n\t</ObjectPageLayout>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/FeedbackDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:html="http://www.w3.org/1999/xhtml">\n\t<Dialog\n\t\ttitle="Give Feedback"\n\t\tclass="sapUiContentPadding"\n\t\tid="feedbackDialog"\n\t\tresizable="true"\n\t\tdraggable="true"\n\t\tcontentHeight="35rem"\n\t\tcontentWidth="32rem"\n\t\tverticalScrolling="false"\n\t\tstretch="{appView>/bPhoneSize}"\n\t\tshowHeader="true">\n\t\t<content>\n\t\t<VBox>\n\t\t\t<HBox justifyContent="SpaceBetween">\n\t\t\t\t<items>\n\t\t\t\t\t<Label text="How is your overall experience?" design="Bold" class="sapMFontMediumSize" required="true"/>\n\t\t\t\t\t<ObjectStatus id="ratingStatus" text="" state="None" class="sapMFontMediumSize"/>\n\t\t\t\t</items>\n\t\t\t</HBox>\n\t\t\t<HBox id="feedbackButtons" >\n\t\t\t\t<items>\n\t\t\t\t\t<ToggleButton id="excellent" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-very-happy" class="rateButton">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</ToggleButton>\n\t\t\t\t\t<ToggleButton id="good" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-happy" class="rateButton">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</ToggleButton>\n\t\t\t\t\t<ToggleButton id="average" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-neutral" class="rateButton">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</ToggleButton>\n\t\t\t\t\t<ToggleButton id="poor" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-bad" class="rateButton">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</ToggleButton>\n\t\t\t\t\t<ToggleButton id="veryPoor" width="100%" press="onPressRatingButton" icon="sap-icon://FeedbackRatingFaces/icon-face-very-bad" class="rateButton">\n\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t<FlexItemData growFactor="1" />\n\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t</ToggleButton>\n\t\t\t\t</items>\n\t\t\t</HBox>\n\n\t\t\t<Label text="What would you like to tell us?" design="Bold" class="sapUiTinyMarginTop"/>\n\n\t\t\t<TextArea id="feedbackInput" width="100%" placeholder="You can share your feedback for the overall Demo Kit experience or for the specific page you are currently viewing."\n\t\t\t\t\t\trows="7" class="sapMFontMediumSize sapUiFeedbackDialogTextArea"/>\n\n\t\t\t<CheckBox id="pageContext" text="Feedback is related to the current page" selected="true" class="sapMFontMediumSize contextCheckBoxAlign" select="onContextSelect"/>\n\n\t\t\t<FormattedText class="sapMLabel sapUiFeedbackDialogNoteLabel sapUiTinyMarginBottom"\n\t\t\t\t\t\t   htmlText="&lt;strong&gt;Note:&lt;/strong&gt; If you want to report a bug,\n\t\t\t{= ${versionData>/isOpenUI5} ?\n\t\t\t\' you can open a GitHub issue &lt;a href=&quot;https://github.com/SAP/openui5/issues/new&quot;&gt;here.&lt;/a&gt;\' :\n\t\t\t${versionData>/isSnapshotVersion} ?\n\t\t\t\' please open a BCP ticket on CA-UI5-CTR component.\' :\n\t\t\t\' you can report an Incident &lt;a href=&quot;https://launchpad.support.sap.com/#incident/solution&quot;&gt;here.&lt;/a&gt;\'\n\t\t\t}\n\t\t\tThis way we will be able to get back to you in case we have follow-up questions."/>\n\n\t\t\t<Link text="Show context Data" class="sapMFontMediumSize sapUiTinyMarginBottom" press="onShowHideContextData"/>\n\n\t\t\t<TextArea id="contextData" width="100%" value="Details/ descriptive text..." visible="false" editable="false" rows="3" class="sapUiBaseText sapMFontMediumSize sapUiTinyMarginBottom sapUiNoMarginTop"/>\n\n\t\t\t<MessageStrip text="Your feedback is anonymous, we do not collect any personal data" type="Information" showIcon="true"/>\n\t\t</VBox>\n\t\t</content>\n\t\t<beginButton>\n\t\t\t<Button id="sendButton" text="Send"  press="onFeedbackDialogSend" enabled="false"/>\n\t\t</beginButton>\n\t\t<endButton>\n\t\t\t<Button id="cancelButton" text="Cancel" press="onFeedbackDialogCancel"/>\n\t\t</endButton>\n\t</Dialog>\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Footer.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\t<l:BlockLayoutCell\tclass="demokitInitialPagesColorPatternFContrast">\n\t\t<FlexBox\n\t\t\t\talignItems="{= ${device>/system/phone} ? \'Start\' : \'Center\' }"\n\t\t\t\tjustifyContent="SpaceBetween"\n\t\t\t\tdirection ="{= ${device>/system/phone} ? \'Column\' : \'Row\' }"\n\t\t\t\twidth="100%">\n\t\t\t<items>\n\t\t\t\t<Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_sap.png"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\theight="2.5rem">\n\t\t\t\t</Image>\n\t\t\t\t<FlexBox\n\t\t\t\t\t\tdirection ="{= ${device>/system/phone} ? \'Column\' : \'Row\' }"\n\t\t\t\t\t\tclass="sapUiTinyMarginTop">\n\t\t\t\t\t<items>\n\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesBrightLink sapUiLargeMarginEnd sapUiTinyMarginBottom"\n\t\t\t\t\t\t\t\ttext="Legal Disclosure"\n\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/impressum.html"\n\t\t\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}"\n\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesBrightLink sapUiLargeMarginEnd sapUiTinyMarginBottom"\n\t\t\t\t\t\t\t\ttext="Privacy"\n\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/privacy.html"\n\t\t\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}"\n\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t<Link\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesBrightLink"\n\t\t\t\t\t\t\t\ttext="Terms of Use"\n\t\t\t\t\t\t\t\thref="https://www.sap.com/corporate/en/legal/terms-of-use.html"\n\t\t\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}"\n\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t</items>\n\t\t\t\t</FlexBox>\n\t\t\t</items>\n\t\t</FlexBox>\n\t</l:BlockLayoutCell>\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/Group.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Group"\n\t\txmlns="sap.uxap"\n\t\txmlns:m="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:controls="sap.ui.documentation.sdk.controls">\n\n\t<m:Page\n\t\t\tid="controlsDetailPage"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowHeader="{device>/orientation/portrait}"\n\t\t\tshowSubHeader="false"\n\t\t\tshowFooter="false"\n\t\t\tshowNavButton="{device>/system/phone}"\n\t\t\tbusy="{detailView>/busy}"\n\t\t\tbusyIndicatorDelay="{detailView>/delay}">\n\n\t\t<m:content>\n\n\n\t\t</m:content>\n\n\t</m:Page>\n\n</mvc:View>',
	"sap/ui/documentation/sdk/view/NotFound.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.BaseController"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m">\n\n\t<MessagePage\n\t\t\tid="page"\n\t\t\ttitle="Not Found"\n\t\t\ttext="The requested resource was not found"\n\t\t\ticon="{sap-icon://document}"\n\t\t\tdescription=""\n\t\t\tshowNavButton="{device>/system/phone}"\n\t\t\tnavButtonPress="onNavBack">\n\t</MessagePage>\n\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/ReleaseDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\t<Dialog\n\t\t\tid="releaseDialog"\n\t\t\tresizable="true"\n\t\t\tdraggable="true"\n\t\t\ttitle="Change log for: {/library}"\n\t\t\tcontentWidth="40%"\n\t\t\tcontentHeight="40%"\n\t\t\tstretch="{appView>/bPhoneSize}">\n\t\t\t<Text text="{/noDataMessage}" class="sapUiSmallMargin" visible="{=!!${/noDataMessage}}"/>\n\t\t<beginButton>\n\t\t\t<Button text="Close" press="onReleaseDialogClose"/>\n\t\t</beginButton>\n\t</Dialog>\n\n</core:FragmentDefinition>',
	"sap/ui/documentation/sdk/view/ReleaseNotes.view.xml":'<mvc:View controllerName="sap.ui.documentation.sdk.controller.ReleaseNotes"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.uxap"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:m="sap.m"\n\t\txmlns:html="http://www.w3.org/1999/xhtml"\n\n\t\theight="100%">\n\n\t\t\t<ObjectPageLayout\n\t\t\t\t\tid="releaseNotesObjectPage"\n\t\t\t\t\tbusy="true"\n\t\t\t\t\tenableLazyLoading="false"\n\t\t\t\t\tshowTitleInHeaderContent="false"\n\t\t\t\t\tsections="{/libs}"\n\t\t\t\t\tupperCaseAnchorBar="false">\n\n\t\t\t\t<headerTitle>\n\t\t\t\t\t<ObjectPageHeader objectTitle="Change Log"/>\n\t\t\t\t</headerTitle>\n\n\t\t\t\t<headerContent>\n\t\t\t\t\t<layout:VerticalLayout>\n\t\t\t\t\t\t<html:div class="sapUiCustomTitleText">\n\t\t\t\t\t\t\tThis log includes the library notes for the libraries listed below.\n\t\t\t\t\t\t\tThe change log for old version which are not patched anymore can be reviewed\n\t\t\t\t\t\t\t<m:Link text="here" href="docs/guide/relnotes/ReleaseNotes.html"/>.\n\t\t\t\t\t\t</html:div>\n\t\t\t\t\t\t<m:Select id="VersionSelect" items="{select>/items}" change="handleVersionChange" visible="false">\n\t\t\t\t\t\t\t<core:Item text="{select>value}" key="{select>key}"/>\n\t\t\t\t\t\t</m:Select>\n\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t</headerContent>\n\n\t\t\t\t<sections>\n\n\t\t\t\t\t<ObjectPageSection title="{library}" titleUppercase="false">\n\t\t\t\t\t\t<ObjectPageSubSection titleUppercase="false">\n\t\t\t\t\t\t\t<layout:VerticalLayout content="{path: \'versions\', templateShareable: false}" width="100%">\n\t\t\t\t\t\t\t\t<m:Panel headerText="{version}" content="{path: \'notes\', templateShareable: false}" expandable="true" expanded="true">\n\t\t\t\t\t\t\t\t\t<m:Text width="100%" text="[{type}] {text}"/>\n\t\t\t\t\t\t\t\t</m:Panel>\n\t\t\t\t\t\t\t</layout:VerticalLayout>\n\t\t\t\t\t\t</ObjectPageSubSection>\n\t\t\t\t\t</ObjectPageSection>\n\n\t\t\t\t</sections>\n\n\t\t\t</ObjectPageLayout>\n\n</mvc:View>',
	"sap/ui/documentation/sdk/view/Sample.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Sample"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:layout="sap.ui.layout"\n\t\txmlns:controls="sap.ui.documentation.sdk.controls">\n\t<Page\n\t\t\tid="page"\n\t\t\tshowNavButton="{/showNavButton}"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tbusyIndicatorDelay="0">\n\t\t<landmarkInfo>\n\t\t\t<PageAccessibleLandmarkInfo rootRole="Region" rootLabel="Details" headerRole="Region" headerLabel="Header" contentRole="Main" contentLabel="Content"></PageAccessibleLandmarkInfo>\n\t\t</landmarkInfo>\n\t\t<headerContent>\n\t\t\t<Button\n\t\t\t\t\tid="prevSample"\n\t\t\t\t\ticon="sap-icon://navigation-up-arrow"\n\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\ttooltip="Show previous sample"\n\t\t\t\t\tenabled="{= ${/previousSampleId} !== undefined }"\n\t\t\t\t\tpress="onPreviousSample"/>\n\t\t\t<Button\n\t\t\t\t\tid="nextSample"\n\t\t\t\t\ticon="sap-icon://navigation-down-arrow"\n\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\ttooltip="Show next sample"\n\t\t\t\t\tenabled="{= ${/nextSampleId} !== undefined }"\n\t\t\t\t\tpress="onNextSample"/>\n\t\t\t<Button\n\t\t\t\t\tid="toggleFullScreenBtn"\n\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\ttooltip="Show this sample in full screen mode"\n\t\t\t\t\tpress="onToggleFullScreen" />\n\t\t\t<Button\n\t\t\t\t\tid="toggleRTA"\n\t\t\t\t\ticon="sap-icon://wrench"\n\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\ttooltip="Adapt UI"\n\t\t\t\t\tpress="onToggleAdaptationMode"\n\t\t\t\t\tvisible="false" />\n\t\t\t<Button\n\t\t\t\t\tid="code"\n\t\t\t\t\ticon="sap-icon://syntax"\n\t\t\t\t\ttooltip="Show source code for this sample"\n\t\t\t\t\tpress="onNavToCode" />\n\t\t\t<Button visible="{/showNewTab}"\n\t\t\t\t\tid="newTab"\n\t\t\t\t\ttooltip="Open in new Tab"\n\t\t\t\t\ticon="sap-icon://inspect"\n\t\t\t\t\tpress="onNewTab" />\n\t\t</headerContent>\n\t</Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/SearchPage.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.SearchPage"\n\t\txmlns="sap.m"\n\t\txmlns:op="sap.uxap"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:app="http://schemas.sap.com/sapui5/extension/sap.ui.core.CustomData/1">\n\t\t<op:ObjectPageLayout id="searchPage"\n\t\t\t\t\t\t\tuseIconTabBar="true"\n\t\t\t\t\t\t\talwaysShowContentHeader="true"\n\t\t\t\t\t\t\tupperCaseAnchorBar="false">\n\t\t<op:headerTitle>\n\t\t\t<op:ObjectPageHeader objectTitle=\'Search Results for "{/searchTerm}"\'>\n\t\t\t</op:ObjectPageHeader>\n\t\t</op:headerTitle>\n\t\t<op:headerContent>\n\t\t\t<ObjectAttribute title="" text="Search results are displayed in categories."/>\n\t\t</op:headerContent>\n \t\t<op:sections>\n\t\t\t<op:ObjectPageSection title="All ({/AllLength})">\n\t\t\t<op:subSections>\n\t\t\t\t<op:ObjectPageSubSection>\n\t\t\t\t\t<op:blocks>\n\t\t\t\t\t\t<VBox>\n\t\t\t\t\t\t\t<OverflowToolbar design="Transparent" height="3rem">\n\t\t\t\t\t\t\t\t<Title text="ALL (1 - {/visibleAllLength} of {/AllLength})"/>\n\t\t\t\t\t\t\t</OverflowToolbar>\n\t\t\t\t\t\t\t<List\n\t\t\t\t\t\t\t\tid="allList"\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\tupdateFinished="onAllLoadMore"\n\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\tpath: \'/data\',\n\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\tpath: \'category\',\n\t\t\t\t\t\t\t\t\t\tdescending: false,\n\t\t\t\t\t\t\t\t\t\tgroup: true\n\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\tgroupHeaderFactory: \'.getGroupHeader\'\n\t\t\t\t\t\t\t\t}">\n\t\t\t\t\t\t\t\t<FeedListItem\n\t\t\t\t\t\t\t\t\tsender="{title}"\n\t\t\t\t\t\t\t\t\ttext="{summary}"\n\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\tapp:path="{path}"/>\n\t\t\t\t\t\t\t</List>\n\t\t\t\t\t\t</VBox>\n\t\t\t\t\t</op:blocks>\n\t\t\t\t</op:ObjectPageSubSection>\n\t\t\t</op:subSections>\n\t\t\t</op:ObjectPageSection>\n \t\t\t<op:ObjectPageSection title="API Reference ({/APILength})" visible="{=!!${/APILength}}">\n\t\t\t\t<op:subSections>\n\t\t\t\t\t<op:ObjectPageSubSection>\n\t\t\t\t\t\t<op:blocks>\n\t\t\t\t\t\t\t<VBox>\n\t\t\t\t\t\t\t\t<OverflowToolbar design="Transparent" height="3rem">\n\t\t\t\t\t\t\t\t\t<Title text="API Reference (1 - {/visibleAPILength} of {/APILength})"/>\n\t\t\t\t\t\t\t\t</OverflowToolbar>\n\t\t\t\t\t\t\t\t<List\n\t\t\t\t\t\t\t\t\tid="apiList"\n\t\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\t\tupdateFinished="onAPILoadMore"\n\t\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\t\tpath: \'/dataAPI\',\n\t\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\t\tpath: \'title\',\n\t\t\t\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}">\n\t\t\t\t\t\t\t\t\t<FeedListItem\n\t\t\t\t\t\t\t\t\t\tvisible="{path:\'category\', formatter:\'.categoryAPIFormatter\'}"\n\t\t\t\t\t\t\t\t\t\tsender="{title}"\n\t\t\t\t\t\t\t\t\t\ttext="{summary}"\n\t\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\t\tapp:path="{path}"/>\n\t\t\t\t\t\t\t\t</List>\n\t\t\t\t\t\t\t</VBox>\n\t\t\t\t\t\t</op:blocks>\n\t\t\t\t\t</op:ObjectPageSubSection>\n\t\t\t\t</op:subSections>\n\t\t\t</op:ObjectPageSection>\n\t\t\t<op:ObjectPageSection title="Documentation ({/DocLength})" visible="{=!!${/DocLength}}">\n\t\t\t\t<op:subSections>\n\t\t\t\t\t<op:ObjectPageSubSection>\n\t\t\t\t\t\t<op:blocks>\n\t\t\t\t\t\t\t<VBox>\n\t\t\t\t\t\t\t\t<OverflowToolbar design="Transparent" height="3rem">\n\t\t\t\t\t\t\t\t\t<Title text="Documentation (1 - {/visibleDocLength} of {/DocLength})"/>\n\t\t\t\t\t\t\t\t</OverflowToolbar>\n\t\t\t\t\t\t\t\t<List\n\t\t\t\t\t\t\t\t\tid="documentationList"\n\t\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\t\tupdateFinished="onDocLoadMore"\n\t\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\t\tpath: \'/dataDoc\',\n\t\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\t\tpath: \'title\',\n\t\t\t\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}">\n\t\t\t\t\t\t\t\t\t<FeedListItem\n\t\t\t\t\t\t\t\t\t\tvisible="{path:\'category\', formatter:\'.categoryDocFormatter\'}"\n\t\t\t\t\t\t\t\t\t\tsender="{title}"\n\t\t\t\t\t\t\t\t\t\ttext="{summary}"\n\t\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\t\tapp:path="{path}"/>\n\t\t\t\t\t\t\t\t</List>\n\t\t\t\t\t\t\t</VBox>\n\t\t\t\t\t\t</op:blocks>\n\t\t\t\t\t</op:ObjectPageSubSection>\n \t\t\t\t</op:subSections>\n\t\t\t</op:ObjectPageSection>\n\t\t\t<op:ObjectPageSection title="Samples ({/ExploredLength})" visible="{=!!${/ExploredLength}}">\n\t\t\t\t<op:subSections>\n\t\t\t\t\t<op:ObjectPageSubSection>\n\t\t\t\t\t\t<op:blocks>\n\t\t\t\t\t\t\t<VBox>\n\t\t\t\t\t\t\t\t<OverflowToolbar design="Transparent" height="3rem">\n\t\t\t\t\t\t\t\t\t<Title text="Samples (1 - {/visibleExploredLength} of {/ExploredLength})"/>\n\t\t\t\t\t\t\t\t</OverflowToolbar>\n\t\t\t\t\t\t\t\t<List\n\t\t\t\t\t\t\t\t\tid="samplesList"\n\t\t\t\t\t\t\t\t\tgrowing="true"\n\t\t\t\t\t\t\t\t\tgrowingThreshold="25"\n\t\t\t\t\t\t\t\t\tupdateFinished="onExploredLoadMore"\n\t\t\t\t\t\t\t\t\titems="{\n\t\t\t\t\t\t\t\t\t\tpath: \'/dataExplored\',\n\t\t\t\t\t\t\t\t\t\tsorter: {\n\t\t\t\t\t\t\t\t\t\t\tpath: \'title\',\n\t\t\t\t\t\t\t\t\t\t\tdescending: false\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}">\n\t\t\t\t\t\t\t\t\t<FeedListItem\n\t\t\t\t\t\t\t\t\t\tvisible="{path:\'category\', formatter:\'.categoryExploredFormatter\'}"\n\t\t\t\t\t\t\t\t\t\tsender="{title}"\n\t\t\t\t\t\t\t\t\t\ttext="{summary}"\n\t\t\t\t\t\t\t\t\t\tshowIcon="false"\n\t\t\t\t\t\t\t\t\t\tapp:path="{path}"/>\n\t\t\t\t\t\t\t\t</List>\n\t\t\t\t\t\t\t</VBox>\n\t\t\t\t\t\t</op:blocks>\n\t\t\t\t\t</op:ObjectPageSubSection>\n \t\t\t\t</op:subSections>\n\t\t\t</op:ObjectPageSection>\n\t\t</op:sections>\n\t</op:ObjectPageLayout>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/Tools.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Tools"\n\t\txmlns="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls">\n\n\t<Page showHeader="false"\n\t\t  class="sapUiNoContentPadding">\n\t\t<l:BlockLayout>\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell toolsImageCell">\n\t\t\t\t\t<Image\n\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Tools_S_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{device>/system/phone}"/>\n\t\t\t\t\t<Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Tools_M_and_L_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/>\n\t\t\t\t\t<Text id="landingImageHeadline"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\tclass="sapUiDocumentationToolsHeaderText"\n\t\t\t\t\t\ttext="Tools"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\ttextAlign="Left"/>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet6"\n\t\t\t\t\t\tbackgroundColorShade="ShadeB">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/WebIDE_logo_white_32x61.png"\n\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\t\t\t\tdensityAware="false"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="SAP Web IDE"\n\t\t\t\t\t\t\t\thref="https://help.sap.com/viewer/78bc6d19f2f44cb38fe9c50446592788/CF/en-US/51321a804b1a4935b0ab7255447f5f84.html"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"\n\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="SAP Web IDE on SAP CP is delivered on SAP Cloud Platform, SAP\'s public cloud,\n\t\t\t\t\t\t\t\tand is used to build modern UI apps for desktop and mobile devices with the latest\n\t\t\t\t\t\t\t\tSAPUI5 and SAP Fiori technologies."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Link text="View Documentation"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="https://help.sap.com/viewer/825270ffffe74d9f988a0f0066ad59f0/CF/en-US"\n\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t<Link text="SAP Web IDE SDK"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="https://sdk-sapwebide.dispatcher.hana.ondemand.com/index.html"\n\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t<Link text="Community"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="https://www.sap.com/developer/topics/sap-webide.html"\n\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://inspection"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="UI5 Inspector"\n\t\t\t\t\t\t\t\thref="https://chrome.google.com/webstore/detail/ui5-inspector/bebecogbafbighhaildooiibipcnbngo?hl=en"\n\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t<Text text="With the UI5 Inspector, you can easily debug and support your OpenUI5 or SAPUI5-based apps."\n\t\t\t\t\t\t\t  class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Link text="View Documentation"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="#/topic/b24e72443eb34d0fb7bf6940f2d697eb"/>\n\t\t\t\t\t\t<Link text="View Source Code"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="https://github.com/SAP/ui5-inspector"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternC" >\n\t\t\t\t\t<l:Grid width="100%"\n\t\t\t\t\t\t\t\tvSpacing="1"\n\t\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\t\tposition="Left"\n\t\t\t\t\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\t\t\t\t\tdefaultIndent="XL0 L0 M0 S0">\n\t\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://widgets"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="Icon Explorer"\n\t\t\t\t\t\t\t\t\thref="test-resources/sap/m/demokit/iconExplorer/webapp/index.html"\n\t\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\t\ttext="All our icons at your fingertips"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t<Link text="View Documentation"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="#/topic/21ea0ea94614480d9a910b2e93431291"/>\n\t\t\t\t\t\t\t<Link text="Run Integration Tests"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="test-resources/sap/m/demokit/iconExplorer/webapp/test/integration/opaTests.qunit.html"/>\n\t\t\t\t\t\t\t<Link text="Run Unit Tests"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="test-resources/sap/m/demokit/iconExplorer/webapp/test/unit/unitTests.qunit.html"\n\t\t\t\t\t\t\t\t  class="sapUiTinyMarginBottom"/>\n\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t<Panel headerText="Browse Hundreds of icons">\n\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://paper-plane"\n\t\t\t\t\t\t\t\t\t\tsize="1.5rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Neutral"/>\n\t\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://paper-plane"\n\t\t\t\t\t\t\t\t\t\tsize="2.5rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Neutral"/>\n\t\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://paper-plane"\n\t\t\t\t\t\t\t\t\t\tsize="4.5rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Neutral"/>\n\t\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://paper-plane"\n\t\t\t\t\t\t\t\t\t\tsize="6rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Neutral"/>\n\t\t\t\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t\t\t<Label text="Code:" design="Bold" class="sapUiTinyMarginEnd sapUiTinyMarginTopBottom"/>\n\t\t\t\t\t\t\t\t\t<Input type="text" value="sap-icon://paper-plane" enabled="false"/>\n\t\t\t\t\t\t\t\t\t<Button type="Emphasized" icon="sap-icon://copy" class="sapUiTinyMarginBegin"/>\n\t\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t</Panel>\n\t\t\t\t\t</l:Grid>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet6"\n\t\t\t\t\t\tbackgroundColorShade="ShadeC">\n\t\t\t\t\t\t<l:Grid width="100%"\n\t\t\t\t\t\t\t\tvSpacing="1"\n\t\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\t\tposition="Left"\n\t\t\t\t\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\t\t\t\t\tdefaultIndent="XL0 L0 M0 S0">\n\t\t\t\t\t\t\t<l:VerticalLayout>\n\t\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/build_logo__white_26x80.png"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"\n\t\t\t\t\t\t\t\t\tdensityAware="false"/>\n\t\t\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\t\ttext="Find Out About Build"\n\t\t\t\t\t\t\t\t\t\thref="https://www.build.me"\n\t\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t<Text text="Everything you need to design beautiful apps in one set of cloud-based tools."\n\t\t\t\t\t\t\t\t\t  class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t\t<Link text="View Documentation"\n\t\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t\t  href="http://sap.github.io/BUILD_User_Assistance/build/external/"\n\t\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t\t<Link text="View Source Code"\n\t\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t\t  href="https://www.github.com/SAP/BUILD"\n\t\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/build_illu_astronaut_320x235.png"\n\t\t\t\t\t\t\t\tdensityAware="false"/>\n\t\t\t\t\t\t</l:Grid>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet6"\n\t\t\t\t\t\tbackgroundColorShade="ShadeD" >\n\t\t\t\t\t<l:Grid width="100%"\n\t\t\t\t\t\t\tvSpacing="1"\n\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\tposition="Left"\n\t\t\t\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\t\t\t\tdefaultIndent="XL0 L0 M0 S0">\n\t\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://palette"\n\t\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\t\ttext="UI Theme Designer"\n\t\t\t\t\t\t\t\t\thref="https://themedesigner-themedesigner.dispatcher.hanatrial.ondemand.com/index.html"\n\t\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\t\ttext="Responsive controls for touch-enabled devices and desktop browsers"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t<Link text="View Documentation"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="https://help.sap.com/viewer/09f6818d8e064537973102d6289e2aca/Cloud/en-US"\n\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t\t<Link text="Community"\n\t\t\t\t\t\t\t\t  target="_blank"\n\t\t\t\t\t\t\t\t  href="https://www.sap.com/community/topic/ui-theme-designer.html"\n\t\t\t\t\t\t\t\t  class="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Theme_Designer_Image_350x197.jpg"\n\t\t\t\t\t\t\tdensityAware="false"/>\n\t\t\t\t\t</l:Grid>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass ="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://example"\n\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\tsize="2rem"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBottom"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\tlevel="H1"\n\t\t\t\t\t\t\t\ttitleStyle="H1"\n\t\t\t\t\t\t\t\ttext="Theme Parameter Toolbox"\n\t\t\t\t\t\t\t\thref="test-resources/sap/m/demokit/theming/webapp/index.html"\n\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t<Text text="Search, filter and preview semantic theme parameters"\n\t\t\t\t\t\t\t  class="sapUiSmallMarginBottom"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" />\n\t\t\t</l:BlockLayoutRow>\n\n\t\t</l:BlockLayout>\n\t</Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/TopicDetail.view.xml":'<mvc:View\n\t\theight="100%"\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.TopicDetail"\n\t\tid="sap.ui.documentation.sdk.controller.TopicDetail"\n\t\txmlns="sap.f"\n\t\txmlns:m="sap.m"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core">\n\t<DynamicPage\n\t\t\tid="topicDetailPage"\n\t\t\tpreserveHeaderStateOnScroll="true"\n\t\t\ttoggleHeaderOnTitleClick="false"\n\t\t\tfitContent="true">\n\t\t<title>\n\t\t\t<DynamicPageTitle class="sapUiDocumentationDynamicPageTitle">\n\t\t\t\t<heading>\n\t\t\t\t\t<m:Text text="{/topictitle1}" class="sapUiDocumentationTopicTitle" wrapping="true"/>\n\t\t\t\t</heading>\n\t\t\t\t<actions>\n\t\t\t\t\t<m:Button\n\t\t\t\t\t\t\tid="topicDetailBackToSearch"\n\t\t\t\t\t\t\ttext="Back to search results"\n\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\tpress="backToSearch"\n\t\t\t\t\t\t\tvisible="false"/>\n\t\t\t\t\t<m:Button\n\t\t\t\t\t\t\tclass="sapUiHideOnPhone"\n\t\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"\n\t\t\t\t\t\t\ticon="sap-icon://full-screen"\n\t\t\t\t\t\t\ttype="Transparent"\n\t\t\t\t\t\t\ttooltip="Show this document in full screen mode"\n\t\t\t\t\t\t\tpress="onToggleFullScreen"/>\n\t\t\t\t</actions>\n\t\t\t</DynamicPageTitle>\n\t\t</title>\n\n\t\t<header>\n\t\t\t<DynamicPageHeader pinnable="fale">\n\t\t\t\t<content>\n\t\t\t\t\t<m:Text text="{/shortdesc}"/>\n\t\t\t\t</content>\n\t\t\t</DynamicPageHeader>\n\t\t</header>\n\n\t\t<content>\n\t\t\t<core:HTML id="testHTML"\n\t\t\t\t\t   preferDOM="false"\n\t\t\t\t\t   content=\'&lt;div style="height:100%; overflow-x:auto;"&gt;&lt;iframe class="sapUiDocumentationTopicsIframe" name="content" src="{/topicURL}" frameborder="0""&gt;&lt;/iframe&gt;&lt;/div&gt;\'>\n\t\t\t</core:HTML>\n\t\t</content>\n\t</DynamicPage>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/TopicDetailInitial.view.xml":'<mvc:View\n\t\theight="100%"\n\t\twidth="100%"\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.TopicDetailInitial"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls">\n\t<Page id="topicDetailPage"\n\t\t  showHeader="false"\n\t\t  class="sapUiNoContentPadding">\n\t\t<l:BlockLayout>\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiNoContentPadding sapUiDemokitLandingImageCell sapUiNoContentPadding">\n\t\t\t\t\t<Image\n\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Docu_S_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{device>/system/phone}"/>\n\n\t\t\t\t\t<Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Docu_M_and_L_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="landingImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/>\n\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\tclass="sapUiDocumentationDocumentationHeading"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\ttext="Documentation"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttextAlign="Left"/>\n\t\t\t\t\t\t<Button\n\t\t\t\t\t\t\tclass="actionButton"\n\t\t\t\t\t\t\ttext="Download"\n\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\tpress="onDownloadButtonPress"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow visible="{versionData>/isInternal}">\n\t\t\t\t<l:BlockLayoutCell>\n\t\t\t\t\t<MessageStrip\n\t\t\t\t\t\tshowIcon="true"\n\t\t\t\t\t\ttext="This is the internal version of the documentation. It contains topics that are still under construction, as well as SAP-internal information that should not be passed on to anybody outside SAP."/>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow class="sapUiContentPadding">\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttext="What\'s New?"\n\t\t\t\t\t\t\thref="#/topic/99ac68a5b1c3416ab5c84c99fefa250d"\n\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttext="Read Me First"\n\t\t\t\t\t\t\thref="#/topic/167193ced54c41c3961d7df3479d7bbe"\n\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\twidth="2"\n\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet6"\n\t\t\t\t\t\tbackgroundColorShade="ShadeB">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="Get Started"\n\t\t\t\t\t\t\t\thref="#/topic/8b49fc198bf04b2d9800fc37fecbb218"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Setup and tutorials"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\twidth="2"\n\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet6"\n\t\t\t\t\t\tbackgroundColorShade="ShadeC">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="Developing Apps"\n\t\t\t\t\t\t\t\thref="#/topic/23cfd955f58142389fa7c9097e11559c"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Best practices and what pitfalls you should look out for"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="Extending Apps"\n\t\t\t\t\t\t\t\thref="#/topic/a264a9abf98d4caabbf9b027bc1005d8"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Adapt apps to your specific requirements"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="Developing Content"\n\t\t\t\t\t\t\t\thref="#/topic/8dcab0011d274051808f959800cabf9f"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Create custom controls or contribute to UI5"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternA"\n\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="SAP Fiori Elements"\n\t\t\t\t\t\t\t\thref="#/topic/03265b0408e2432c9571d6b3feb6b1fd"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="UI patterns and templates for commonly used application patterns"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternC"\n\t\t\t\t\t\tvisible="{=!${versionData>/isOpenUI5}}">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="Analysis Path Framework"\n\t\t\t\t\t\t\t\thref="#/topic/1c457c53595a6655e10000000a423f68"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Build and enhance interactive analytical web applications"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell"\n\t\t\t\t\t\tbackgroundColorSet="ColorSet6"\n\t\t\t\t\t\tbackgroundColorShade="ShadeD">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="Essentials"\n\t\t\t\t\t\t\t\thref="#/topic/ec699e0817fb46a0817b0fa276a249f8"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Development concepts, such as MVC, data binding, and components"\n\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="largeCell demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout width="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\t\ttext="More About Controls"\n\t\t\t\t\t\t\t\thref="#/topic/3ec6808ff0f34a75a9f40748cf9989b9"\n\t\t\t\t\t\t\t\ttitleStyle="H1"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Addition to the API reference"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" />\n\t\t\t</l:BlockLayoutRow>\n\t\t</l:BlockLayout>\n\t</Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/TopicMaster.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.TopicMaster"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core"\n\t\tclass="sapContrast sapContrastPlus">\n\n\t<Page\n\t\t\tid="page"\n\t\t\tenableScrolling="true"\n\t\t\tshowFooter="false"\n\t\t\tnavButtonPress="onNavBack"\n\t\t\tshowNavButton="false"\n\t\t\tclass="sapUiDocumentationMasterPage">\n\n\t\t<customHeader>\n\t\t\t<Toolbar width="100%">\n\t\t\t\t<SearchField placeholder="Filter" liveChange="onTreeFilter" class="sapUiDocumentationFilterField"></SearchField>\n\t\t\t\t<Button icon="sap-icon://expand-group" press="onTreeExpandAll"></Button>\n\t\t\t\t<Button icon="sap-icon://collapse-group" press="onTreeCollapseAll"></Button>\n\t\t\t</Toolbar>\n\t\t</customHeader>\n\n\t\t<content>\n\n\t\t\t<Tree\n\t\t\t\t\tid="tree"\n\t\t\t\t\tmode="SingleSelectMaster"\n\t\t\t\t\tselectionChange="onNodeSelect"\n\t\t\t\t\titems="{ path: \'/\' }">\n\t\t\t\t<StandardTreeItem\n\t\t\t\t\t\ttitle="{text}"\n\t\t\t\t\t\tselected="{isSelected}">\n\t\t\t\t\t<customData>\n\t\t\t\t\t\t<core:CustomData key="nodeId" value="{key}" />\n\t\t\t\t\t</customData>\n\t\t\t\t</StandardTreeItem>\n\t\t\t</Tree>\n\n\t\t</content>\n\n\t</Page>\n\n</mvc:View>\n',
	"sap/ui/documentation/sdk/view/Welcome.view.xml":'<mvc:View\n\t\tcontrollerName="sap.ui.documentation.sdk.controller.Welcome"\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core"\n\t\txmlns:mvc="sap.ui.core.mvc"\n\t\txmlns:custom="sap.ui.documentation.sdk.controls">\n\n\t<Page showHeader="false">\n\t\t<l:BlockLayout>\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell class="sapUiNoContentPadding sapUiDemokitLandingImageCell welcomeImageCell">\n\t\t\t\t\t<Image\n\t\t\t\t\t\tid="phoneImage"\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Home_S_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{device>/system/phone}"/>\n\t\t\t\t\t<Image\n\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Home_M_and_L_cropped.jpg"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\tclass="welcomeImage"\n\t\t\t\t\t\tload="handleLandingImageLoad"\n\t\t\t\t\t\tvisible="{=!${device>/system/phone}}"/>\n\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\tid="landingImageHeadline"\n\t\t\t\t\t\tvisible="false"\n\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\tclass="welcomeImageTextLayout">\n\t\t\t\t\t\t<Text class="welcomeImageTextHeadline"\n\t\t\t\t\t\t\ttext="Discover New Enterprise-Grade Horizons"\n\t\t\t\t\t\t\twidth="100%"\n\t\t\t\t\t\t\ttextAlign="Center"/>\n\t\t\t\t\t\t<Button\n\t\t\t\t\t\t\ttext="Get Started with UI5"\n\t\t\t\t\t\t\ttype="Emphasized"\n\t\t\t\t\t\t\tpress="onGetStarted"\n\t\t\t\t\t\t\tclass="actionButton"/>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternA sapUiDemokitLandingBlockHeadline"\n\t\t\t\t\t\ttitle="Key Features"\n\t\t\t\t\t\ttitleAlignment="Center"/>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\tbackgroundColorSet="ColorSet5"\n\t\t\t\t\tbackgroundColorShade="ShadeD">\n\t\t\t\t\t<l:Grid\n\t\t\t\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\tvSpacing="0">\n\t\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="#/topic/50eadaac8d2e49ee8996dc2b560cb76b"\n\t\t\t\t\t\t\t\t\ttext="Responsive Across Browsers and Devices"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText sapUiSmallMarginBottom "/>\n\t\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\t\ttext="No need to worry about device specifics! UI5 apps run on smartphones, tablets, and desktops. The UI controls automatically adapt themselves to each device\'s capabilities and make the most of the available real estate."\n\t\t\t\t\t\t\t\t\tclass="demokitInitialPagesWhiteText"/>\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Fiori_guidelines_image.png"\n\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t\t<l:GridData span="L6 M12 S12"/>\n\t\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t\t</Image>\n\t\t\t\t\t</l:Grid>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\ttext="Powerful Development Concepts"\n\t\t\t\t\t\t\t\thref="#/topic/ec699e0817fb46a0817b0fa276a249f8"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="The UI5 core offers a solid foundation that simplifies your work by managing many aspects of modern development behind the scenes. It comes with built-in support for architectural concepts like MVC, two-way data binding, and routing."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Includes standards like MVC and various data-binding types"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Choose between different view formats (XML, HTML, JavaScript, JSON)"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Binding with OData, JSON, XML and other data formats"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Built-in support tool for exploring the object tree and binding status"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="#/topic/23cfd955f58142389fa7c9097e11559c"\n\t\t\t\t\t\t\t\ttext="Enterprise-Ready Web Toolkit"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\ttitleStyle="H2"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Created by professionals, for modern developers building state of the art web applications. It comes with all features needed to cover most current application requirements, with standards high enough to be delivered in standard SAP solutions."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t\t<Text text="Translation and internationalization support"/>\n\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t\t<Text text="Extensibility concepts at code and application level"/>\n\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t\t<Text text="High Contrast theme to aid visually impaired users"/>\n\t\t\t\t\t\t\t</HBox>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternE">\n\t\t\t\t\t<l:Grid\n\t\t\t\t\t\t\tdefaultSpan="L6 M12 S12"\n\t\t\t\t\t\t\thSpacing="0"\n\t\t\t\t\t\t\tvSpacing="0">\n\t\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\t\thref="https://experience.sap.com/fiori-design/"\n\t\t\t\t\t\t\t\t\ttext="Award-Winning SAP Fiori Design in Action"\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"\n\t\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\t\ttarget="_blank"/>\n\t\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\t\ttext="UI5 applications benefit from a consistent design language and predefined UX patterns across all frontend features. Use a predefined theme or try our online theming tool to create a custom theme."\n\t\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/Fiori_design_examples.png"\n\t\t\t\t\t\t\t\tclass="sapUiSmallmarginBeginEnd"\n\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t\t<layoutData>\n\t\t\t\t\t\t\t\t<l:GridData span="L6 M12 S12"/>\n\t\t\t\t\t\t\t</layoutData>\n\t\t\t\t\t\t</Image>\n\t\t\t\t\t</l:Grid>\n\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternA sapUiDemokitLandingBlockHeadline"\n\t\t\t\t\t\ttitle="Choose Your Scenario"\n\t\t\t\t\t\ttitleAlignment="Center"/>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternD">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="https://www.sap.com/developer/tutorials/hcp-create-trial-account.html"\n\t\t\t\t\t\t\t\ttext="SAPUI5 on SAP Cloud Platform"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Sign up for the free SAP Cloud Platform developer edition to test the platform and build cloud-based UI5 apps."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Easy-to-use development environment with SAP Web IDE"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox class="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Free trial for development use"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="#/topic/91f346786f4d1014b6dd926db0e91070"\n\t\t\t\t\t\t\t\ttext="SAPUI5 On-Premise"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="SAPUI5 is part of the user interface technologies in SAP HANA, NetWeaver ABAP or Java systems."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="ready to use for SAP Customers"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox class="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Integrates with existing system landscapes"/>\n\t\t\t\t\t\t</HBox>\n\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternB">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="http://openui5.org"\n\t\t\t\t\t\t\t\ttext="OpenUI5 - Free and Open Source"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Try the open source variant of UI5. It contains all core UI5 features and is available on GitHub under the Apache 2.0 license."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Supported by the open source community"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox class="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Managed on GitHub - contributions welcome!"/>\n\t\t\t\t\t\t</HBox>\n\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternC">\n\t\t\t\t\t<l:VerticalLayout\n\t\t\t\t\t\t\twidth="100%">\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="#/topic/2d3eb2f322ea4a82983c1c62a33ec4ae"\n\t\t\t\t\t\t\t\ttext="UI5 on Content Delivery Network"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\t\t\t\t\t\t<Text\n\t\t\t\t\t\t\t\ttext="Develop and run UI5 apps with the flexibility of a robust CDN. Files are loaded from the location closest to the user for optimal performance."\n\t\t\t\t\t\t\t\tclass="sapUiSmallMarginBottom"/>\n\n\t\t\t\t\t\t<HBox>\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="Multi-version CDN to maintain a custom lifecycle"/>\n\t\t\t\t\t\t</HBox>\n\t\t\t\t\t\t<HBox class="sapUiSmallMarginBottom">\n\t\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\t\tsrc="sap-icon://accept"\n\t\t\t\t\t\t\t\t\tsize="0.875rem"\n\t\t\t\t\t\t\t\t\tcolor="Default"\n\t\t\t\t\t\t\t\t\tclass="sapUiTinyMarginBegin sapUiSmallMarginEnd"/>\n\t\t\t\t\t\t\t<Text text="For any on-premise and cloud development scenario"/>\n\t\t\t\t\t\t</HBox>\n\n\t\t\t\t\t</l:VerticalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="demokitInitialPagesColorPatternA sapUiDemokitLandingBlockHeadline"\n\t\t\t\t\t\ttitle="Join the Community"\n\t\t\t\t\t\ttitleAlignment="Center"/>\n\t\t\t</l:BlockLayoutRow>\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiBlockCenteredCell demokitInitialPagesColorPatternB communityLinkCell">\n\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t<core:Icon\n\t\t\t\t\t\t\t\tsrc="sap-icon://collaborate"\n\t\t\t\t\t\t\t\tsize="2.5rem"\n\t\t\t\t\t\t\t\tcolor="Default"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="https://www.sap.com/community/topic/ui5.html?"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\ttext="SAP Community"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom"/>\n\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiBlockCenteredCell demokitInitialPagesColorPatternC communityLinkCell">\n\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_stackoverflow.png"\n\t\t\t\t\t\t\t\twidth="2.5rem"\n\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="http://stackoverflow.com/search?q=sapui5"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\ttext="StackOverflow"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom"/>\n\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiBlockCenteredCell demokitInitialPagesColorPatternD communityLinkCell">\n\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_youtube.png"\n\t\t\t\t\t\t\t\twidth="2.5rem"\n\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="https://youtube.com/openui5videos"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\ttext="YouTube"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom"/>\n\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t\t<l:BlockLayoutCell\n\t\t\t\t\t\tclass="sapUiBlockCenteredCell demokitInitialPagesColorPatternE communityLinkCell">\n\t\t\t\t\t<l:HorizontalLayout>\n\t\t\t\t\t\t<Image\n\t\t\t\t\t\t\t\tsrc="./resources/sap/ui/documentation/sdk/images/logo_twitter.png"\n\t\t\t\t\t\t\t\twidth="2.5rem"\n\t\t\t\t\t\t\t\tdensityAware="false"\n\t\t\t\t\t\t\t\tclass="sapUiTinyMarginTop"/>\n\t\t\t\t\t\t<custom:TitleLink\n\t\t\t\t\t\t\t\thref="https://twitter.com/@openui5"\n\t\t\t\t\t\t\t\ttarget="_blank"\n\t\t\t\t\t\t\t\ttext="Twitter"\n\t\t\t\t\t\t\t\ttitleStyle="H2"\n\t\t\t\t\t\t\t\twrap="false"\n\t\t\t\t\t\t\t\tclass="sapUiSmallMargin sapUiNoMarginBottom"/>\n\t\t\t\t\t</l:HorizontalLayout>\n\t\t\t\t</l:BlockLayoutCell>\n\n\t\t\t</l:BlockLayoutRow>\n\n\n\t\t\t<l:BlockLayoutRow>\n\t\t\t\t<core:Fragment id="footerFragment" fragmentName="sap.ui.documentation.sdk.view.Footer" type="XML" />\n\t\t\t</l:BlockLayoutRow>\n\n\t\t</l:BlockLayout>\n\t</Page>\n</mvc:View>',
	"sap/ui/documentation/sdk/view/appSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:l="sap.ui.layout"\n\t\txmlns:core="sap.ui.core">\n\t<Dialog\n\t\t\ttitle="Settings"\n\t\t\tclass="sapUiPopupWithPadding"\n\t\t\tcontentWidth="350px"\n\t\t\tid="AppSettingsDialog">\n\t\t<content>\n\t\t\t<VBox class="sapUiTinyMarginTop">\n\t\t\t\t\t<Label text="Theme:" design="Standard" labelFor="ThemeSelect" />\n\t\t\t\t\t<Select id="ThemeSelect" width="100%">\n\t\t\t\t\t\t<core:Item key="sap_belize" text="Belize"/>\n\t\t\t\t\t\t<core:Item key="sap_belize_plus" text="Belize Deep"/>\n\t\t\t\t\t\t<core:Item key="sap_belize_hcb" text="High Contrast Black"/>\n\t\t\t\t\t\t<core:Item key="sap_belize_hcw" text="High Contrast White"/>\n\t\t\t\t\t</Select>\n\n\t\t\t\t\t<HBox class="sapUiTinyMarginTop" alignItems="Center" justifyContent="SpaceBetween">\n\t\t\t\t\t\t<Label text="Compact Content Density:" design="Standard"  labelFor="CompactModeSwitch" />\n\t\t\t\t\t\t<Switch id="CompactModeSwitch" state="false" />\n\t\t\t\t\t</HBox>\n\t\t\t\t\t<HBox class="sapUiTinyMarginTop" alignItems="Center" justifyContent="SpaceBetween">\n\t\t\t\t\t\t<Label text="Right To Left Mode:" design="Standard" labelFor="RTLSwitch" />\n\t\t\t\t\t\t<Switch id="RTLSwitch" state="false" />\n\t\t\t\t\t</HBox>\n\t\t\t</VBox>\n\t\t</content>\n\t\t<beginButton>\n\t\t\t<Button text="OK" press="handleSaveAppSettings"/>\n\t\t</beginButton>\n\t\t<endButton>\n\t\t\t<Button text="Cancel" press="handleCloseAppSettings"/>\n\t\t</endButton>\n\t</Dialog>\n</core:FragmentDefinition>\n\n',
	"sap/ui/documentation/sdk/view/viewSettingsDialog.fragment.xml":'<core:FragmentDefinition\n\t\txmlns="sap.m"\n\t\txmlns:core="sap.ui.core">\n\t<ViewSettingsDialog\n\t\t\tid="viewSettingsDialog"\n\t\t\tconfirm="onConfirmViewSettings">\n\t\t<groupItems>\n\t\t\t<ViewSettingsItem text="Alphabetically" key="name" selected="true" />\n\t\t\t<ViewSettingsItem text="Category" key="category" />\n\t\t\t<ViewSettingsItem text="Content Density" key="formFactors" />\n\t\t\t<ViewSettingsItem text="Namespace" key="namespace" />\n\t\t\t<ViewSettingsItem text="Release" key="since" />\n\t\t</groupItems>\n\t\t<filterItems>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\t\ttext="Category"\n\t\t\t\t\tkey="category"\n\t\t\t\t\tid="categoryFilter"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/category\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\t\ttext="Content Density"\n\t\t\t\t\tkey="formFactors"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/formFactors\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\t\ttext="Namespace"\n\t\t\t\t\tkey="namespace"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/namespace\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t\t<ViewSettingsFilterItem\n\t\t\t\t\ttext="Release"\n\t\t\t\t\tkey="since"\n\t\t\t\t\titems="{\n\t\t\t\t\tpath:\'filter>/since\',\n\t\t\t\t\tsorter: {\n\t\t\t\t\t\tpath: \'id\',\n\t\t\t\t\t\tdescending: false\n\t\t\t\t\t}\n\t\t\t\t}" >\n\t\t\t\t<items>\n\t\t\t\t\t<ViewSettingsItem text="{filter>id}" key="{filter>id}" />\n\t\t\t\t</items>\n\t\t\t</ViewSettingsFilterItem>\n\t\t</filterItems>\n\t</ViewSettingsDialog>\n</core:FragmentDefinition>',
/*!
 * @copyright@
 */
	"sap/ui/documentation/demoapps/all.js":function(){sap.ui.getCore().attachInit(function(){"use strict";jQuery.sap.includeStyleSheet(jQuery.sap.getResourcePath("sap/ui/documentation/demoapps/css/style.css"));sap.ui.require(["sap/ui/core/ComponentContainer"],function(C){new C({name:"sap.ui.documentation.demoapps"}).placeAt("content");});});
}
}});
//# sourceMappingURL=library-preload.js.map