// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.dt.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.dt.DOMUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.DOMUtil.
jQuery.sap.declare('sap.ui.dt.DOMUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/DOMUtil",[
	'jquery.sap.global'
],
function(
	jQuery
) {
	"use strict";

	/**
	 * Class for DOM Utils.
	 *
	 * @class
	 * Utility functionality for DOM
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.DOMUtil
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var DOMUtil = {};

	/**
	 *
	 */
	DOMUtil.getSize = function(oDomRef) {
		var oClientRec = oDomRef.getBoundingClientRect();
		return {
			width: oClientRec.width,
			height: oClientRec.height
		};
	};

	/**
	 *
	 */
	DOMUtil.getOffsetFromParent = function(oPosition, mParentOffset, scrollTop, scrollLeft) {
		var mOffset = {
			left : oPosition.left,
			top : oPosition.top
		};

		if (mParentOffset) {
			mOffset.left -= (mParentOffset.left - (scrollLeft ? scrollLeft : 0));
			mOffset.top -= (mParentOffset.top - (scrollTop ? scrollTop : 0));
		}
		return mOffset;
	};

	/**
	 *
	 */
	DOMUtil.getZIndex = function(oDomRef) {
		var zIndex;
		var $ElementDomRef = jQuery(oDomRef);
		if ($ElementDomRef.length) {
			zIndex = $ElementDomRef.zIndex() || $ElementDomRef.css("z-index");
		}
		return zIndex;
	};

	/**
	 * Checks whether DOM Element has vertical scrollbar
	 * @param oDomRef {HTMLElement} - DOM Element
	 * @return {boolean}
	 */
	DOMUtil.hasVerticalScrollBar = function(oDomRef) {
		var $DomRef = jQuery(oDomRef);
		var bOverflowYScroll = $DomRef.css("overflow-y") === "auto" || $DomRef.css("overflow-y") === "scroll";

		return bOverflowYScroll && $DomRef.get(0).scrollHeight > $DomRef.height();
	};

	/**
	 * Checks whether DOM Element has horizontal scrollbar
	 * @param oDomRef {HTMLElement} - DOM Element
	 * @return {boolean}
	 */
	DOMUtil.hasHorizontalScrollBar = function (oDomRef) {
		var $DomRef = jQuery(oDomRef);
		var bOverflowXScroll = $DomRef.css("overflow-x") === "auto" || $DomRef.css("overflow-x") === "scroll";

		return bOverflowXScroll && $DomRef.get(0).scrollWidth > $DomRef.width();
	};

	/**
	 * Checks whether DOM Element has vertical or horizontal scrollbar
	 * @param oDomRef {HTMLElement} - DOM Element
	 * @return {boolean}
	 */
	DOMUtil.hasScrollBar = function(oDomRef) {
		return DOMUtil.hasVerticalScrollBar(oDomRef) || DOMUtil.hasHorizontalScrollBar(oDomRef);
	};

	/**
	 * Gets scrollbar width in the running browser
	 * @return {number} - returns width in pixels
	 */
	DOMUtil.getScrollbarWidth = function() {
		if (typeof DOMUtil.getScrollbarWidth._cache === 'undefined') {
			// add outer div
			var oOuter = jQuery('<div/>')
				.css({
					position: 'absolute',
					top: '-9999px',
					left: '-9999px',
					width: '100px'
				})
				.appendTo('body');

			var iWidthNoScroll = oOuter.width();
			oOuter.css('overflow', 'scroll');

			// add inner div
			var oInner = jQuery('<div/>')
				.css('width', '100%')
				.appendTo(oOuter);

			var iWidthWithScroll = oInner.width();

			// clean up
			oOuter.remove();

			DOMUtil.getScrollbarWidth._cache = iWidthNoScroll - iWidthWithScroll;
		}

		return DOMUtil.getScrollbarWidth._cache;
	};


	/**
	 *
	 */
	DOMUtil.getOverflows = function(oDomRef) {
		var oOverflows;
		var $ElementDomRef = jQuery(oDomRef);
		if ($ElementDomRef.length) {
			oOverflows = {};
			oOverflows.overflowX = $ElementDomRef.css("overflow-x");
			oOverflows.overflowY = $ElementDomRef.css("overflow-y");
		}
		return oOverflows;
	};

	/**
	 *
	 */
	DOMUtil.getGeometry = function(oDomRef, bUseWindowOffset) {
		if (oDomRef) {
			var oOffset = jQuery(oDomRef).offset();
			if (bUseWindowOffset) {
				oOffset.left = oOffset.left - jQuery(window).scrollLeft();
				oOffset.top = oOffset.top - jQuery(window).scrollTop();
			}

			return {
				domRef : oDomRef,
				size : this.getSize(oDomRef),
				position :  oOffset,
				visible : this.isVisible(oDomRef)
			};
		}
	};

	/**
	 *
	 */
	DOMUtil.syncScroll = function(oSourceDom, oTargetDom) {
		var $target = jQuery(oTargetDom);
		var oTargetScrollTop = $target.scrollTop();
		var oTargetScrollLeft = $target.scrollLeft();

		var $source = jQuery(oSourceDom);
		var oSourceScrollTop = $source.scrollTop();
		var oSourceScrollLeft = $source.scrollLeft();

		if (oSourceScrollTop !== oTargetScrollTop) {
			$target.scrollTop(oSourceScrollTop);
		}
		if (oSourceScrollLeft !== oTargetScrollLeft) {
			$target.scrollLeft(oSourceScrollLeft);
		}
	};

	/**
	 * returns jQuery object found in oDomRef for sCSSSelector
	 * @param  {Element|jQuery} oDomRef to search in
	 * @param  {string} sCSSSelector jQuery (CSS-like) selector to look for
	 * @return {jQuery} found domRef
	 */
	DOMUtil.getDomRefForCSSSelector = function(oDomRef, sCSSSelector) {
		if (sCSSSelector && oDomRef) {
			var $domRef = jQuery(oDomRef);

			if (sCSSSelector === ":sap-domref") {
				return $domRef;
			}

			// ":sap-domref > sapMPage" scenario
			if (sCSSSelector.indexOf(":sap-domref") > -1) {
				return $domRef.find(sCSSSelector.replace(/:sap-domref/g, ""));
			}

			// normal selector
			return $domRef.find(sCSSSelector);
		} else {
			// empty jQuery object for typing
			return jQuery();
		}
	};

	/**
	 *
	 */
	DOMUtil.isVisible = function(oDomRef) {
		// mimic the jQuery 1.11.1 impl of the ':visible' selector as the jQuery 2.2.0 selector no longer reports empty SPANs etc. as 'hidden'
		return oDomRef ? oDomRef.offsetWidth > 0 || oDomRef.offsetHeight > 0 : false;
	};

	/**
	 *
	 */
	DOMUtil.getEscapedString = function(sString) {
		return sString.replace(/([;&,\.\+\*\~':"\!\^#$%@\[\]\(\)=>\|])/g, '\\$1');
	};

	/**
	 *
	 */
	DOMUtil.setDraggable = function(oElement, bValue) {
		oElement = jQuery(oElement);

		oElement.attr("draggable", bValue);
	};

	/**
	 * Copy the given styles object to a destination DOM node.
	 *
	 * @param {Object} oStyles A styles object, which is retrieved from window.getComputedStyle
	 * @param {Element} oDest The element to which the styles should be copied.
	 * @private
	 */
	DOMUtil._copyStylesTo = function(oStyles, oDest) {
		var sStyles = "";
		var sStyle = "";
		var iLength = oStyles.length;
		// Styles is an array, but has some special access functions
		for (var i = 0; i < iLength; i++) {
			sStyle = oStyles[i];
			sStyles = sStyles + sStyle + ":" + oStyles.getPropertyValue(sStyle) + ";";
		}

		oDest.style.cssText = sStyles;
	};

	DOMUtil._copyPseudoElement = function(sPseudoElement, oSrc, oDest) {
		var mStyles = window.getComputedStyle(oSrc, sPseudoElement);
		var sContent = mStyles.getPropertyValue("content");
		if (sContent && sContent !== "none") {
			sContent = jQuery.trim(sContent);
			if (sContent.indexOf("attr(") === 0) {
				sContent = sContent.replace("attr(", "");
				if (sContent.length) {
					sContent = sContent.substring(0, sContent.length - 1);
				}
				sContent = oSrc.getAttribute(sContent);
			}

			// due to a firefox bug sContent can be null after oSrc.getAttribute
			// sContent is requried for copy pseudo styling
			if (sContent === null || sContent === undefined) {
				sContent = "";
			}

			// pseudo elements can't be inserted via js, so we should create a real elements,
			// which copy pseudo styling
			var oPseudoElement = jQuery("<span></span>");
			if (sPseudoElement === ":after") {
				oPseudoElement.appendTo(oDest);
			} else {
				oPseudoElement.prependTo(oDest);
			}

			oPseudoElement.text(sContent.replace(/(^['"])|(['"]$)/g, ""));
			DOMUtil._copyStylesTo(mStyles, oPseudoElement.get(0));
			oPseudoElement.css("display", "inline");
		}
	};

	/**
	 *
	 */
	DOMUtil.copyComputedStyle = function(oSrc, oDest) {
		oSrc = jQuery(oSrc).get(0);
		oDest = jQuery(oDest).get(0);
		var mStyles = window.getComputedStyle(oSrc);

		if (mStyles.getPropertyValue("display") == "none") {
			oDest.style.display = "none";
			return;
		}

		DOMUtil._copyStylesTo(mStyles, oDest);

		this._copyPseudoElement(":after", oSrc, oDest);
		this._copyPseudoElement(":before", oSrc, oDest);
	};

	/**
	 *
	 */
	DOMUtil.copyComputedStyles = function(oSrc, oDest) {
		oSrc = jQuery(oSrc).get(0);
		oDest = jQuery(oDest).get(0);

		for (var i = 0; i < oSrc.children.length; i++) {
			this.copyComputedStyles(oSrc.children[i], oDest.children[i]);
		}

		// we shouldn't copy classes because they can affect styling
		jQuery(oDest).removeClass();
		// remove all special attributes, which can affect app behaviour
		jQuery(oDest).attr("id", "");
		jQuery(oDest).attr("role", "");
		jQuery(oDest).attr("data-sap-ui", "");
		jQuery(oDest).attr("for", "");

		jQuery(oDest).attr("tabIndex", -1);
		this.copyComputedStyle(oSrc, oDest);
	};

	/**
	 *
	 */
	DOMUtil.cloneDOMAndStyles = function(oNode, oTarget) {
		oNode = jQuery(oNode).get(0);

		var oCopy = oNode.cloneNode(true);
		this.copyComputedStyles(oNode, oCopy);

		jQuery(oTarget).append(oCopy);
	};

	/**
	 * Inserts <style/> tag width specified styles into #overlay-container
	 * @param {string} sStyles - string with plain CSS to be rendered into the page
	 */
	DOMUtil.insertStyles = function (sStyles) {
		var oStyle = document.createElement('style');
		oStyle.type = 'text/css';

		if (oStyle.styleSheet) {
			oStyle.styleSheet.cssText = sStyles;
		} else {
			oStyle.appendChild(document.createTextNode(sStyles));
		}

		// FIXME: we can't use Overlay module because of the cycled dependency
		jQuery('#overlay-container').prepend(oStyle);
	};

	return DOMUtil;
}, /* bExport= */ true);

}; // end of sap/ui/dt/DOMUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.ElementUtil.
jQuery.sap.declare('sap.ui.dt.ElementUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ElementUtil",['jquery.sap.global'],
		function(jQuery) {
			"use strict";

			/**
			 * Class for ElementUtil.
			 *
			 * @class Utility functionality to work with élements, e.g. iterate through aggregations, find parents, ...
			 *
			 * @author SAP SE
			 * @version 1.50.6
			 *
			 * @private
			 * @static
			 * @since 1.30
			 * @alias sap.ui.dt.ElementUtil
			 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API
			 *               might be changed in future.
			 */

			var ElementUtil = {};

			ElementUtil.sACTION_MOVE = 'move';
			ElementUtil.sACTION_CUT = 'cut';
			ElementUtil.sACTION_PASTE = 'paste';
			ElementUtil.sREORDER_AGGREGATION = 'reorder_aggregation';

			/**
			 *
			 */
			ElementUtil.iterateOverElements = function(vElement, fnCallback) {
				if (vElement && vElement.length) {
					for (var i = 0; i < vElement.length; i++) {
						var oElement = vElement[i];
						if (oElement instanceof sap.ui.base.ManagedObject) {
							fnCallback(oElement);
						}
					}
				} else if (vElement instanceof sap.ui.base.ManagedObject) {
					fnCallback(vElement);
				}
			};

			/**
			 *
			 */
			ElementUtil.iterateOverAllPublicAggregations = function(oElement, fnCallback) {
				var mAggregations = oElement.getMetadata().getAllAggregations();
				var aAggregationNames = Object.keys(mAggregations);

				aAggregationNames.forEach(function(sAggregationName) {
					var oAggregation = mAggregations[sAggregationName];
					var vAggregationValue = this.getAggregation(oElement, sAggregationName);

					fnCallback(oAggregation, vAggregationValue);
				}, this);
			};

			/**
			 *
			 */
			ElementUtil.getElementInstance = function(vElement) {
				if (typeof vElement === "string") {
					var oElement = sap.ui.getCore().byId(vElement);
					return oElement || sap.ui.getCore().getComponent(vElement);
				} else {
					return vElement;
				}
			};

			/**
			 *
			 */
			ElementUtil.hasAncestor = function(oElement, oAncestor) {
				oAncestor = this.fixComponentContainerElement(oAncestor);

				var oParent = this.fixComponentParent(oElement);
				while (oParent && oParent !== oAncestor) {
					oParent = oParent.getParent();
					oParent = this.fixComponentParent(oParent);
				}

				return !!oParent;
			};

			/**
			 *
			 */
			ElementUtil.getClosestElementForNode = function(oNode) {
				var $ClosestElement = jQuery(oNode).closest("[data-sap-ui]");
				return $ClosestElement.length ? sap.ui.getCore().byId($ClosestElement.data("sap-ui")) : undefined;
			};

			/**
			 * ! Please, use this method only if OverlayUtil.getClosestOverlayForType is not available in your case ! find the
			 * closest element of the given type
			 *
			 * @param {sap.ui.core.Element}
			 *          oSourceElement to start search for
			 * @param {string}
			 *          sType to check instance of
			 * @return {sap.ui.core.Element} element of the given type, if found
			 */
			ElementUtil.getClosestElementOfType = function(oSourceElement, sType) {
				var oElement = oSourceElement;

				while (oElement && !this.isInstanceOf(oElement, sType)) {
					oElement = oElement.getParent();
				}

				return oElement;
			};

			/**
			 *
			 */
			ElementUtil.fixComponentParent = function(oElement) {
				if (this.isInstanceOf(oElement, "sap.ui.core.UIComponent")) {
					var oComponentContainer = oElement.oContainer;
					if (oComponentContainer) {
						return oComponentContainer.getParent();
					}
				} else {
					return oElement;
				}
			};

			/**
			 *
			 */
			ElementUtil.fixComponentContainerElement = function(oElement) {
				if (this.isInstanceOf(oElement, "sap.ui.core.ComponentContainer")) {
					// This happens when the compontentContainer has not been rendered yet
					if (!oElement.getComponentInstance()) {
						return;
					}
					return oElement.getComponentInstance().getRootControl();
				} else {
					return oElement;
				}
			};

			/**
			 *
			 */
			ElementUtil.findAllPublicElements = function(oElement) {
				var aFoundElements = [];

				var internalFind = function (oElement) {
					oElement = this.fixComponentContainerElement(oElement);
					if (oElement) {
						aFoundElements.push(oElement);
						this.iterateOverAllPublicAggregations(oElement, function(oAggregation, vElements) {
							this.iterateOverElements(vElements, internalFind);
						}.bind(this));
					}
				}.bind(this);

				internalFind(oElement);

				return aFoundElements;
			};

			/**
			 *
			 */
			ElementUtil.getDomRef = function(oElement) {
				if (oElement) {
					var oDomRef;
					if (oElement.getDomRef) {
						oDomRef = oElement.getDomRef();
					}
					if (!oDomRef && oElement.getRenderedDomRef) {
						oDomRef = oElement.getRenderedDomRef();
					}
					return oDomRef;
				}
			};

			/**
			 *
			 */
			ElementUtil.findAllPublicChildren = function(oElement) {
				var aFoundElements = this.findAllPublicElements(oElement);
				var iIndex = aFoundElements.indexOf(oElement);
				if (iIndex > -1) {
					aFoundElements.splice(iIndex, 1);
				}
				return aFoundElements;

			};

			/**
			 * Check the ancestor hierarchy of an overlay for a given relevant container
			 * @param  {sap.ui.dt.Overlay} oOverlay overlay object which has to be checked
			 * @param  {sap.ui.core.Element} oRelevantContainer object
			 */
			ElementUtil.hasSameRelevantContainer = function(oOverlay, oRelevantContainer) {
				var oParentOverlay = oOverlay.getParent();
				if (!oRelevantContainer || !oParentOverlay.getElementInstance) {
					return false;
				}

				while (oParentOverlay && oParentOverlay.getElementInstance() !== oRelevantContainer) {
					oParentOverlay = oParentOverlay.getParent();
					if (!oParentOverlay.getElementInstance) {
						return false;
					}
				}

				return !!oParentOverlay;
			};

			/**
			 *
			 */
			ElementUtil.isElementFiltered = function(oControl, aType) {
				// TODO: Is this method still needed?
				aType = aType || this.getControlFilter();
				var bFiltered = false;

				aType.forEach(function(sType) {
					bFiltered = this.isInstanceOf(oControl, sType);
					if (bFiltered) {
						return false;
					}
				}, this);

				return bFiltered;
			};

			/**
			 *
			 */
			ElementUtil.findClosestControlInDom = function(oNode) {
				// TODO: Is this method still needed?
				if (oNode && oNode.getAttribute("data-sap-ui")) {
					return sap.ui.getCore().byId(oNode.getAttribute("data-sap-ui"));
				} else if (oNode.parentNode) {
					this.findClosestControlInDom(oNode.parentNode);
				} else {
					return null;
				}
			};

			/**
			 *
			 */
			ElementUtil.findAllSiblingsInContainer = function(oElement, oContainer) {
				var oParent = oElement.getParent();
				if (!oParent) {
					return [];
				}

				if (oParent !== oContainer){
					var aParents = ElementUtil.findAllSiblingsInContainer(oParent, oContainer);
					return aParents.map(function(oParent){
						return ElementUtil.getAggregation(oParent, oElement.sParentAggregationName);
					}).reduce(function(a, b) {
						return a.concat(b);
					}, []);
				}

				return ElementUtil.getAggregation(oParent, oElement.sParentAggregationName);
			};

			ElementUtil.getAggregationAccessors = function(oElement, sAggregationName) {
				var oMetadata = oElement.getMetadata();
				oMetadata.getJSONKeys();
				var oAggregationMetadata = oMetadata.getAggregation(sAggregationName);
				if (oAggregationMetadata) {
					var sGetter = oAggregationMetadata._sGetter;

					// altType getter returns not element (TODO: clarify if getAggregationNameControl getter is a convention)
					if (oAggregationMetadata.altTypes && oAggregationMetadata.altTypes.length
							&& oElement[oAggregationMetadata._sGetter + "Control"]) {
						sGetter = oAggregationMetadata._sGetter + "Control";
					}

					return {
						get : sGetter,
						add : oAggregationMetadata._sMutator,
						remove : oAggregationMetadata._sRemoveMutator,
						insert : oAggregationMetadata._sInsertMutator,
						removeAll : oAggregationMetadata._sRemoveAllMutator
					};
				} else {
					return {};
				}
			};

			ElementUtil.getAggregation = function(oElement, sAggregationName) {
				var oValue;

				var sGetter = this.getAggregationAccessors(oElement, sAggregationName).get;
				if (sGetter) {
					oValue = oElement[sGetter]();
				} else {
					oValue = oElement.getAggregation(sAggregationName);
				}
				// ATTENTION:
				// under some unknown circumstances the return oValue looks like an Array but jQuery.isArray() returned
				// undefined => false
				// that is why we use array ducktyping with a null check!
				// reproducible with Windows and Chrome (currently 35), when creating a project and opening WYSIWYG editor
				// afterwards on any file
				// sap.m.Panel.prototype.getHeaderToolbar() returns a single object but an array
				/* eslint-disable no-nested-ternary */
				oValue = oValue && oValue.splice ? oValue : (oValue ? [oValue] : []);
				/* eslint-enable no-nested-ternary */
				return oValue;
			};

			ElementUtil.getIndexInAggregation = function(oElement, oParent, sAggregationName) {
				return this.getAggregation(oParent, sAggregationName).indexOf(oElement);
			};

			/**
			 *
			 */
			ElementUtil.addAggregation = function(oParent, sAggregationName, oElement) {
				if (this.hasAncestor(oParent, oElement)) {
					throw new Error("Trying to add an element to itself or its successors");
				}
				var sAggregationAddMutator = this.getAggregationAccessors(oParent, sAggregationName).add;
				if (sAggregationAddMutator) {
					oParent[sAggregationAddMutator](oElement);
				} else {
					oParent.addAggregation("sAggregationName", oElement);
				}

			};

			/**
			 *
			 */
			ElementUtil.removeAggregation = function(oParent, sAggregationName, oElement, bSuppressInvalidate) {
				var sAggregationRemoveMutator = this.getAggregationAccessors(oParent, sAggregationName).remove;
				if (sAggregationRemoveMutator) {
					oParent[sAggregationRemoveMutator](oElement, bSuppressInvalidate);
				} else {
					oParent.removeAggregation(sAggregationName, oElement, bSuppressInvalidate);
				}
			};

			/**
			 *
			 */
			ElementUtil.insertAggregation = function(oParent, sAggregationName, oElement, iIndex) {
				if (this.hasAncestor(oParent, oElement)) {
					throw new Error("Trying to add an element to itself or its successors");
				}
				if (this.getIndexInAggregation(oElement, oParent, sAggregationName) !== -1) {
					// ManagedObject.insertAggregation won't reposition element, if it's already inside of same aggregation
					// therefore we need to remove the element and then insert it again. To prevent ManagedObjectObserver from
					// firing
					// setParent event with parent null, private flag is set.
					oElement.__bSapUiDtSupressParentChangeEvent = true;
					try {
						this.removeAggregation(oParent, sAggregationName, oElement, true);
					} finally {
						delete oElement.__bSapUiDtSupressParentChangeEvent;
					}
				}
				var sAggregationInsertMutator = this.getAggregationAccessors(oParent, sAggregationName).insert;
				if (sAggregationInsertMutator) {
					oParent[sAggregationInsertMutator](oElement, iIndex);
				} else {
					oParent.insertAggregation(sAggregationName, oElement, iIndex);
				}
			};

			/**
			 *
			 */
			ElementUtil.isValidForAggregation = function(oParent, sAggregationName, oElement) {
				var oAggregationMetadata = oParent.getMetadata().getAggregation(sAggregationName);

				// Make sure that the parent is not inside of the element, or is not the element itself,
				// e.g. insert a layout inside it's content aggregation.
				// This check needed as UI5 will have a maximum call stack error otherwise.
				if (this.hasAncestor(oParent, oElement)) {
					return false;
				}

				// only for public aggregations
				if (oAggregationMetadata) {
					// TODO : test altTypes
					var sTypeOrInterface = oAggregationMetadata.type;

					// if aggregation is not multiple and already has element inside, then it is not valid for element
					if (oAggregationMetadata.multiple === false && this.getAggregation(oParent, sAggregationName) &&
							this.getAggregation(oParent, sAggregationName).length > 0) {
						return false;
					}
					return this.isInstanceOf(oElement, sTypeOrInterface) || this.hasInterface(oElement, sTypeOrInterface);
				}

			};

			ElementUtil.getAssociationAccessors = function(oElement, sAggregationName) {
				var oMetadata = oElement.getMetadata();
				oMetadata.getJSONKeys();
				var oAssociationMetadata = oMetadata.getAssociation(sAggregationName);
				if (oAssociationMetadata) {
					return {
						get : oAssociationMetadata._sGetter,
						add : oAssociationMetadata._sMutator,
						remove : oAssociationMetadata._sRemoveMutator,
						insert : oAssociationMetadata._sInsertMutator,
						removeAll : oAssociationMetadata._sRemoveAllMutator
					};
				} else {
					return {};
				}
			};

			ElementUtil.getAssociation = function(oElement, sAssociationName) {
				var oValue;
				var sGetter = this.getAssociationAccessors(oElement, sAssociationName).get;
				if (sGetter) {
					oValue = oElement[sGetter]();
				}
				return oValue;
			};

			ElementUtil.getAssociationInstances = function(oElement, sAssociationName) {
				var vValue = this.getAssociation(oElement, sAssociationName);
				vValue = this.getElementInstance(vValue);
				if (vValue && vValue.length){
					vValue = vValue.map(function(sId){
						return this.getElementInstance(sId);
					});
				}

				return vValue;
			};

			/**
			 *
			 */
			ElementUtil.hasInterface = function(oElement, sInterface) {
				var aInterfaces = oElement.getMetadata().getInterfaces();
				return aInterfaces.indexOf(sInterface) !== -1;
			};

			/**
			 *
			 */
			ElementUtil.isInstanceOf = function(oElement, sType) {
				var oInstance = jQuery.sap.getObject(sType);
				if (typeof oInstance === "function") {
					return oElement instanceof oInstance;
				} else {
					return false;
				}
			};

			/**
			 *
			 */
			ElementUtil.loadDesignTimeMetadata = function(oElement) {
				return oElement ? oElement.getMetadata().loadDesignTime() : Promise.resolve({});
			};

			/**
			 * .* Executes an array of actions. An action is a JSON object having the following structure: .* .* <action> = { .*
			 * 'element' : <ui5 id of element to be moved>, .* 'source' : { .* 'index': <source index>, .* 'parent' : <ui5 id
			 * of element actual parent>, .* 'aggregation' : <name of aggregation> .* }, .* 'target' : { .* 'index': <target
			 * index>, .* 'parent' : <ui5 id of element future parent>, .* 'aggregation' : <name of aggregation> .* }, .*
			 * 'changeType' : <name of change type e.g "Move" .* })
			 */
			ElementUtil.executeActions = function(aActions) {
				var oTargetParent, oMovedElement;

				for (var i = 0; i < aActions.length; i++) {
					var oAction = aActions[i];
					switch (oAction.changeType) {
						case ElementUtil.sACTION_MOVE :
							oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
							oMovedElement = sap.ui.getCore().byId(oAction.element);
							ElementUtil.insertAggregation(oTargetParent, oAction.target.aggregation, oMovedElement,
									oAction.target.index);
							break;
						case ElementUtil.sACTION_CUT :
							oTargetParent = sap.ui.getCore().byId(oAction.source.parent);
							oMovedElement = sap.ui.getCore().byId(oAction.element);
							ElementUtil.removeAggregation(oTargetParent, oAction.source.aggregation, oMovedElement);
							break;
						case ElementUtil.sACTION_PASTE :
							oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
							oMovedElement = sap.ui.getCore().byId(oAction.element);
							ElementUtil.insertAggregation(oTargetParent, oAction.target.aggregation, oMovedElement,
									oAction.target.index);
							break;
						case ElementUtil.sREORDER_AGGREGATION :
							oTargetParent = sap.ui.getCore().byId(oAction.target.parent);
							var sAggregationRemoveAllMutator = this
									.getAggregationAccessors(oTargetParent, oAction.target.aggregation).removeAll;
							oTargetParent[sAggregationRemoveAllMutator]();
							var sAggregationAddMutator = this.getAggregationAccessors(oTargetParent, oAction.target.aggregation).add;
							for (var j = 0; j < oAction.source.elements.length; j++) {
								var oElement = sap.ui.getCore().byId(oAction.source.elements[j]);
								oTargetParent[sAggregationAddMutator](oElement);
							}
							break;
						default :
					}
				}

			};

			return ElementUtil;
		}, /* bExport= */true);

}; // end of sap/ui/dt/ElementUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ManagedObjectObserver') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ManagedObjectObserver.
jQuery.sap.declare('sap.ui.dt.ManagedObjectObserver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ManagedObjectObserver",[
	'sap/ui/base/ManagedObject', 'sap/ui/dt/ElementUtil'
], function(ManagedObject, ElementUtil) {
	"use strict";

	/**
	 * Constructor for a new ManagedObjectObserver.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The ManagedObjectObserver observes changes of a ManagedObject and propagates them via events.
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ManagedObjectObserver
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be modified in future.
	 */
	var ManagedObjectObserver = ManagedObject.extend("sap.ui.dt.ManagedObjectObserver", /** @lends sap.ui.dt.ManagedObjectObserver.prototype */
	{
		metadata: {
			"abstract": true,
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {

			},
			associations: {
				/**
				 * target ManagedObject to observe
				 */
				target: {
					type: "sap.ui.base.ManagedObject"
				}
			},
			events: {
				/**
				 * Event fired when the observed object is modified
				 */
				modified: {
					parameters: {
						type : "string",
						name : "string",
						value : "any",
						oldValue : "any",
						target : "sap.ui.core.Element"
					}
				},
				destroyed: {}
			}
		}
	});

	/**
	 * Called when the ManagedObjectObserver is created
	 *
	 * @protected
	 */
	ManagedObjectObserver.prototype.init = function() {
		this._fnFireModified = function() {
			this.fireModified();
		}.bind(this);
	};

	/**
	 * Called when the ManagedObjectObserver is destroyed
	 *
	 * @protected
	 */
	ManagedObjectObserver.prototype.exit = function() {
		this.unobserve();

		delete this._fnFireModified;
	};

	/**
	 * Sets a target ManagedObject to observe
	 *
	 * @param {string|sap.ui.base.ManagedObject} vTarget id or managed object to set
	 * @return {sap.ui.dt.ManagedObjectObserver} returns this
	 */
	ManagedObjectObserver.prototype.setTarget = function(vTarget) {
		this.unobserve();

		this.setAssociation("target", vTarget);

		var oTarget = this.getTargetInstance();
		if (oTarget) {
			this.observe(oTarget);
		}

		return this;
	};

	/**
	 * Starts observing the target object. Override this method in classes which extend ManagedObjectObserver.
	 *
	 * @param {sap.ui.base.ManagedObject} oTarget The target to observe
	 * @protected
	 */
	ManagedObjectObserver.prototype.observe = function(oTarget) {
		this._bIsObserved = true;

		// _change event is triggered on property change of UI5 managed object
		oTarget.attachEvent("_change", this._fnFireModified, this);

		// Wrapper for the destroy method to recognize changes
		this._fnOriginalDestroy = oTarget.destroy;
		oTarget.destroy = function() {
			this.unobserve();
			// Original destroy method was restored by unobserve() call above
			var vOriginalReturn = oTarget.destroy.apply(oTarget, arguments);
			this.fireDestroyed();

			return vOriginalReturn;
		}.bind(this);

		// Wrapper for the bindProperty method to recognize changes
		this._fnOriginalBindProperty = oTarget.bindProperty;
		oTarget.bindProperty = function() {
			var vOriginalReturn = this._fnOriginalBindProperty.apply(oTarget, arguments);
			this.fireModified();

			return vOriginalReturn;
		}.bind(this);

		// Wrapper for the unbindProperty method to recognize changes
		this._fnOriginalUnBindProperty = oTarget.unbindProperty;
		oTarget.unbindProperty = function() {
			var vOriginalReturn = this._fnOriginalUnBindProperty.apply(oTarget, arguments);
			this.fireModified();

			return vOriginalReturn;
		}.bind(this);

		// Wrapper for the bindAggregation method to recognize changes
		this._fnOriginalBindAggregation = oTarget.bindAggregation;
		oTarget.bindAggregation = function(sAggregationName) {
			var vOriginalReturn = this._fnOriginalBindAggregation.apply(oTarget, arguments);
			this.fireModified();

			return vOriginalReturn;
		}.bind(this);

		// Wrapper for the unbindAggregation method to recognize changes
		this._fnOriginalUnBindAggregation = oTarget.unbindAggregation;
		oTarget.unbindAggregation = function(sAggregationName) {
			var vOriginalReturn = this._fnOriginalUnBindAggregation.apply(oTarget, arguments);
			this.fireModified();

			return vOriginalReturn;
		}.bind(this);

		// We wrap the native setParent method of the control with our logic
		this._fnOriginalSetParent = oTarget.setParent;
		oTarget.setParent = function(oParent, sAggregationName, bSuppressInvalidate) {
			var bFireModified = false;
			if (!oTarget._bInSetParent) {
				bFireModified = true;
				oTarget._bInSetParent = true;
			}

			var oCurrentParent = oTarget.getParent();
			var vOriginalReturn = this._fnOriginalSetParent.apply(oTarget, arguments);
			if (bFireModified && !oTarget.__bSapUiDtSupressParentChangeEvent) {
				oTarget._bInSetParent = false;
				// "dependents" is used to store some removed elements (e.g. from Combine)
				if (oCurrentParent !== oParent || sAggregationName === "dependents") {
					this.fireModified({
						type: "setParent",
						value: oParent,
						oldValue: oCurrentParent,
						target: oTarget
					});
				}
			}

			return vOriginalReturn;
		}.bind(this);

		// We wrap the native addAggregation method of the control with our logic
		this._fnOriginalAddAggregation = oTarget.addAggregation;
		oTarget.addAggregation = function(sAggregationName, oObject, bSuppressInvalidate) {
			this._bAddOrSetAggregationCall = true;
			var vOriginalReturn = this._fnOriginalAddAggregation.apply(oTarget, arguments);
			this.fireModified({
				type: "addOrSetAggregation",
				name : sAggregationName,
				value: oObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native setAggregation method of the control with our logic
		this._fnOriginalSetAggregation = oTarget.setAggregation;
		oTarget.setAggregation = function(sAggregationName, oObject, bSuppressInvalidate) {
			// same mutator as addAggregation for multiple = false aggregations
			this._bAddOrSetAggregationCall = true;
			var vOriginalReturn = this._fnOriginalSetAggregation.apply(oTarget, arguments);
			this.fireModified({
				type: "addOrSetAggregation",
				name : sAggregationName,
				value: oObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native removeAggregation method of the control with our logic
		this._fnOriginalRemoveAggregation = oTarget.removeAggregation;
		oTarget.removeAggregation = function(sAggregationName, vObject, bSuppressInvalidate) {
			this._bRemoveAggregationCall = true;
			var vOriginalReturn = this._fnOriginalRemoveAggregation.apply(oTarget, arguments);
			this.fireModified({
				type: "removeAggregation",
				name : sAggregationName,
				value: vObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native insertAggregation method of the control with our logic
		this._fnOriginalInsertAggregation = oTarget.insertAggregation;
		oTarget.insertAggregation = function(sAggregationName, oObject, iIndex, bSuppressInvalidate) {
			this._bInsertAggregationCall = true;
			var vOriginalReturn = this._fnOriginalInsertAggregation.apply(oTarget, arguments);
			this.fireModified({
				type: "insertAggregation",
				name : sAggregationName,
				value: oObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native removeAllAggregations method of the control with our logic
		this._fnOriginalRemoveAllAggregation = oTarget.removeAllAggregation;
		oTarget.removeAllAggregation = function(sAggregationName, bSuppressInvalidate) {
			this._bRemoveAllAggregationCall = true;
			var aRemovedObjects = oTarget.getAggregation(sAggregationName);
			var vOriginalReturn = this._fnOriginalRemoveAllAggregation.apply(oTarget, arguments);
			this.fireModified({
				type: "removeAllAggregation",
				name : sAggregationName,
				value: aRemovedObjects,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native destroyAggregation method of the control with our logic
		this._fnOriginalDestroyAggregation = oTarget.destroyAggregation;
		oTarget.destroyAggregation = function(sAggregationName, bSuppressInvalidate) {
			this._bDestroyAggregationCall = true;
			var aRemovedObjects = oTarget.getAggregation(sAggregationName);
			var vOriginalReturn = this._fnOriginalDestroyAggregation.apply(oTarget, arguments);
			this.fireModified({
				type: "destroyAggregation",
				name : sAggregationName,
				value: aRemovedObjects,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native addAssociation method of the control with our logic
		this._fnOriginalAddAssociation = oTarget.addAssociation;
		oTarget.addAssociation = function(sAssociationName, oObject, bSuppressInvalidate) {
			this._bAddOrSetAssociationCall = true;
			var vOriginalReturn = this._fnOriginalAddAssociation.apply(oTarget, arguments);
			this.fireModified({
				type: "addOrSetAggregation",
				name : sAssociationName,
				value: oObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native setAssociation method of the control with our logic
		this._fnOriginalSetAssociation = oTarget.setAssociation;
		oTarget.setAssociation = function(sAssociationName, oObject, bSuppressInvalidate) {
			// same mutator as addAssociation for multiple = false associations
			this._bAddOrSetAssociationCall = true;
			var vOriginalReturn = this._fnOriginalSetAssociation.apply(oTarget, arguments);
			this.fireModified({
				type: "addOrSetAggregation",
				name : sAssociationName,
				value: oObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native removeAssociation method of the control with our logic
		this._fnOriginalRemoveAssociation = oTarget.removeAssociation;
		oTarget.removeAssociation = function(sAssociationName, vObject, bSuppressInvalidate) {
			this._bRemoveAssociationCall = true;
			var vOriginalReturn = this._fnOriginalRemoveAssociation.apply(oTarget, arguments);
			this.fireModified({
				type: "removeAggregation",
				name : sAssociationName,
				value: vObject,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		// We wrap the native removeAllAssociations method of the control with our logic
		this._fnOriginalRemoveAllAssociation = oTarget.removeAllAssociation;
		oTarget.removeAllAssociation = function(sAssociationName, bSuppressInvalidate) {
			this._bRemoveAllAssociationCall = true;
			var aRemovedObjects = oTarget.getAssociation(sAssociationName);
			var vOriginalReturn = this._fnOriginalRemoveAllAssociation.apply(oTarget, arguments);
			this.fireModified({
				type: "removeAllAggregation",
				name : sAssociationName,
				value: aRemovedObjects,
				target: oTarget
			});
			return vOriginalReturn;
		}.bind(this);

		this._aOriginalAddMutators = {};
		this._aOriginalInsertMutators = {};
		this._aOriginalRemoveMutators = {};
		this._aOriginalRemoveAllMutators = {};
		this._aOriginalDestructors = {};
		var mAllAggregations = oTarget.getMetadata().getAllAggregations();
		Object.keys(mAllAggregations).forEach(function(sAggregationName) {
			var oAggregation = mAllAggregations[sAggregationName];
			var _fnOriginalAddMutator = oTarget[oAggregation._sMutator];
			this._aOriginalAddMutators[oAggregation.name] = _fnOriginalAddMutator;
			oTarget[oAggregation._sMutator] = function(oObject) {
				this._bAddOrSetAggregationCall = false;
				// if addAggregation or setAggregation method wasn't called directly

				var vOriginalReturn;
				vOriginalReturn = _fnOriginalAddMutator.apply(oTarget, arguments);

				if (!this._bAddOrSetAggregationCall) {
					this.fireModified({
						type: "addOrSetAggregation",
						name : oAggregation.name,
						value: oObject,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

			var _fnOriginalInsertMutator = oTarget[oAggregation._sInsertMutator];
			this._aOriginalInsertMutators[oAggregation.name] = _fnOriginalInsertMutator;
			oTarget[oAggregation._sInsertMutator] = function(oObject, iIndex) {
				this._bInsertAggregationCall = false;

				var vOriginalReturn;
				vOriginalReturn = _fnOriginalInsertMutator.apply(oTarget, arguments);

				// if insertAggregation method wasn't called directly
				if (!this._bInsertAggregationCall) {
					this.fireModified({
						type: "insertAggregation",
						name : oAggregation.name,
						value: oObject,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

			var _fnOriginalRemoveMutator = oTarget[oAggregation._sRemoveMutator];
			this._aOriginalRemoveMutators[oAggregation.name] = _fnOriginalRemoveMutator;
			oTarget[oAggregation._sRemoveMutator] = function(vObject, bSuppressInvalidate) {
				this._bRemoveAggregationCall = false;
				var vOriginalReturn = _fnOriginalRemoveMutator.apply(oTarget, arguments);
				// if removeAggregation method wasn't called directly
				if (!this._bRemoveAggregationCall) {
					this.fireModified({
						type: "removeAggregation",
						name : oAggregation.name,
						value: vObject,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

			var _fnOriginalRemoveAllMutator = oTarget[oAggregation._sRemoveAllMutator];
			this._aOriginalRemoveAllMutators[oAggregation.name] = _fnOriginalRemoveAllMutator;
			oTarget[oAggregation._sRemoveAllMutator] = function(bSuppressInvalidate) {
				this._bRemoveAllAggregationCall = false;
				var aRemovedObjects = this.getAggregation(sAggregationName);
				var vOriginalReturn = _fnOriginalRemoveAllMutator.apply(oTarget, arguments);
				// if removeAllAggregation method wasn't called directly
				if (!this._bRemoveAllAggregationCall) {
					this.fireModified({
						type: "removeAllAggregation",
						name : oAggregation.name,
						value: aRemovedObjects,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

			var _fnOriginalDestructor = oTarget[oAggregation._sDestructor];
			this._aOriginalDestructors[oAggregation.name] = _fnOriginalDestructor;
			oTarget[oAggregation._sDestructor] = function(bSuppressInvalidate) {
				this._bDestroyAggregationCall = false;
				var aRemovedObjects = this.getAggregation(sAggregationName);
				var vOriginalReturn = _fnOriginalDestructor.apply(oTarget, arguments);
				// if destroyAggregation method wasn't called directly
				if (!this._bDestroyAggregationCall) {
					this.fireModified({
						type: "destroyAggregation",
						name : oAggregation.name,
						value: aRemovedObjects,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);
		}.bind(this), this);

		var mAllAssociations = oTarget.getMetadata().getAllAssociations();
		Object.keys(mAllAssociations).forEach(function(sAssociationName) {
			var oAssociation = mAllAssociations[sAssociationName];
			var _fnOriginalAddMutator = oTarget[oAssociation._sMutator];
			this._aOriginalAddMutators[oAssociation.name] = _fnOriginalAddMutator;
			oTarget[oAssociation._sMutator] = function(oObject) {
				this._bAddOrSetAssociationCall = false;
				// if addAssociation or setAssociation method wasn't called directly

				var vOriginalReturn;
				vOriginalReturn = _fnOriginalAddMutator.apply(oTarget, arguments);

				if (!this._bAddOrSetAssociationCall) {
					this.fireModified({
						type: "addOrSetAggregation",
						name : oAssociation.name,
						value: oObject,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

			var _fnOriginalRemoveMutator = oTarget[oAssociation._sRemoveMutator];
			this._aOriginalRemoveMutators[oAssociation.name] = _fnOriginalRemoveMutator;
			oTarget[oAssociation._sRemoveMutator] = function(vObject, bSuppressInvalidate) {
				this._bRemoveAssociationCall = false;
				var vOriginalReturn = _fnOriginalRemoveMutator.apply(oTarget, arguments);
				// if removeAssociation method wasn't called directly
				if (!this._bRemoveAssociationCall) {
					this.fireModified({
						type: "removeAggregation",
						name : oAssociation.name,
						value: vObject,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

			var _fnOriginalRemoveAllMutator = oTarget[oAssociation._sRemoveAllMutator];
			this._aOriginalRemoveAllMutators[oAssociation.name] = _fnOriginalRemoveAllMutator;
			oTarget[oAssociation._sRemoveAllMutator] = function(bSuppressInvalidate) {
				this._bRemoveAllAssociationCall = false;
				var aRemovedObjects = this.getAssociation(sAssociationName);
				var vOriginalReturn = _fnOriginalRemoveAllMutator.apply(oTarget, arguments);
				// if removeAllAssociation method wasn't called directly
				if (!this._bRemoveAllAssociationCall) {
					this.fireModified({
						type: "removeAllAggregation",
						name : oAssociation.name,
						value: aRemovedObjects,
						target: oTarget
					});
				}
				return vOriginalReturn;
			}.bind(this);

		}.bind(this), this);

	};

	/**
	 * Stops observing the target object. Override this method in classes which extend ManagedObjectObserver.
	 *
	 * @protected
	 */
	ManagedObjectObserver.prototype.unobserve = function() {
		var oTarget = this.getTargetInstance();

		if (this._bIsObserved && oTarget) {
			this._bIsObserved = false;
			oTarget.destroy = this._fnOriginalDestroy;
			oTarget.bindProperty = this._fnOriginalBindProperty;
			oTarget.unbindProperty = this._fnOriginalUnBindProperty;
			oTarget.bindAggregation = this._fnOriginalBindAggregation;
			oTarget.unbindAggregation = this._fnOriginalUnBindAggregation;
			oTarget.setParent = this._fnOriginalSetParent;

			oTarget.addAggregation = this._fnOriginalAddAggregation;
			oTarget.removeAggregation = this._fnOriginalRemoveAggregation;
			oTarget.insertAggregation = this._fnOriginalInsertAggregation;
			oTarget.setAggregation = this._fnOriginalSetAggregation;
			oTarget.removeAllAggregation = this._fnOriginalRemoveAllAggregation;
			oTarget.destroyAggregation = this._fnOriginalDestroyAggregation;

			oTarget.addAssociation = this._fnOriginalAddAssociation;
			oTarget.removeAssociation = this._fnOriginalRemoveAssociation;
			oTarget.setAssociation = this._fnOriginalSetAssociation;
			oTarget.removeAllAssociation = this._fnOriginalRemoveAllAssociation;

			var mAllAggregations = oTarget.getMetadata().getAllAggregations();
			Object.keys(mAllAggregations).forEach(function(sAggregationName) {
				var oAggregation = mAllAggregations[sAggregationName];
				oTarget[oAggregation._sMutator] = this._aOriginalAddMutators[oAggregation.name];
				oTarget[oAggregation._sInsertMutator] = this._aOriginalInsertMutators[oAggregation.name];
				oTarget[oAggregation._sRemoveMutator] = this._aOriginalRemoveMutators[oAggregation.name];
				oTarget[oAggregation._sRemoveAllMutator] = this._aOriginalRemoveAllMutators[oAggregation.name];
				oTarget[oAggregation._sDestructor] = this._aOriginalDestructors[oAggregation.name];
			}, this);

			var mAllAssociations = oTarget.getMetadata().getAllAssociations();
			Object.keys(mAllAssociations).forEach(function(sAssociationName) {
				var oAssociation = mAllAssociations[sAssociationName];
				oTarget[oAssociation._sMutator] = this._aOriginalAddMutators[oAssociation.name];
				oTarget[oAssociation._sRemoveMutator] = this._aOriginalRemoveMutators[oAssociation.name];
				oTarget[oAssociation._sRemoveAllMutator] = this._aOriginalRemoveAllMutators[oAssociation.name];
			}, this);
			oTarget.detachEvent("_change", this._fnFireModified, this);
		}

		delete this._fnOriginalDestroy;
		delete this._fnOriginalBindProperty;
		delete this._fnOriginalUnBindProperty;
		delete this._fnOriginalBindAggregation;
		delete this._fnOriginalUnBindAggregation;
		delete this._fnOriginalSetParent;
		delete this._fnOriginalAddAggregation;
		delete this._fnOriginalRemoveAggregation;
		delete this._fnOriginalInsertAggregation;
		delete this._fnOriginalSetAggregation;
		delete this._fnOriginalRemoveAllAggregations;
		delete this._fnOriginalDestroyAggregation;
		delete this._aOriginalAddMutators;
		delete this._aOriginalInsertMutators;
		delete this._aOriginalRemoveMutators;
		delete this._aOriginalRemoveAllMutators;
		delete this._aOriginalDestructors;

	};

	/**
	 * @protected
	 * @return {sap.ui.base.ManagedObject} The instance of the associated target to observe.
	 */
	ManagedObjectObserver.prototype.getTargetInstance = function() {
		return ElementUtil.getElementInstance(this.getTarget());
	};

	return ManagedObjectObserver;
}, /* bExport= */true);
}; // end of sap/ui/dt/ManagedObjectObserver.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.OverlayRegistry') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.OverlayRegistry.
jQuery.sap.declare('sap.ui.dt.OverlayRegistry'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/OverlayRegistry",[
	"sap/ui/base/ManagedObject",
	"sap/ui/dt/ElementUtil"
],
function(ManagedObject, ElementUtil) {
	"use strict";

	/**
	 * Class for OverlayRegistry.
	 *
	 * @class
	 * Static registry for Overlays
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.OverlayRegistry
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var OverlayRegistry = {};

	var mOverlays = {};

	/**
	 * Returns a registered Overlay by element instance or id
	 * @param {string|sap.ui.core.Element} vElementOrId element instance or id
	 * @return {sap.ui.dt.Overlay} found overlay or undefined
	 * @public
	 */
	OverlayRegistry.getOverlay = function(vElementOrId) {
		var oElement = ElementUtil.getElementInstance(vElementOrId);
		if (oElement) {
			var sId = oElement.getId();
			return mOverlays[sId];
		}
	};

	/**
	 * Registers an overlay for the element or element's id
	 * @param {string|sap.ui.core.Element} vElementOrId element instance or id
	 * @param {sap.ui.dt.Overlay} oOverlay overlay to register
	 * @public
	 */
	OverlayRegistry.register = function(vElementOrId, oOverlay) {
		var sId = getElementId(vElementOrId);
		mOverlays[sId] = oOverlay;
	};

	/**
	 * Deregisters an overlay for the given element or element's id
	 * @param {string|sap.ui.core.Element} vElementOrId element instance or id
	 * @public
	 */
	OverlayRegistry.deregister = function(vElementOrId) {
		var sId = getElementId(vElementOrId);
		delete mOverlays[sId];
	};

	/**
	 * Returns whether any overlay is registered in registry
	 * @return {boolean} whether any overlay is registered in registry
	 * @public
	 */
	OverlayRegistry.hasOverlays = function() {
		return !jQuery.isEmptyObject(mOverlays);
	};

	function getElementId (vElementOrId) {
		return (vElementOrId instanceof ManagedObject) ? vElementOrId.getId() : vElementOrId;
	}

	return OverlayRegistry;
}, /* bExport= */ true);

}; // end of sap/ui/dt/OverlayRegistry.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.OverlayUtil') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.OverlayUtil.
jQuery.sap.declare('sap.ui.dt.OverlayUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/OverlayUtil",[
	'jquery.sap.global',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/ElementUtil'
],
function(
	jQuery,
	OverlayRegistry,
	ElementUtil
) {
	"use strict";

	/**
	 * Class for Overlay Util.
	 *
	 * @class Utility functionality to work with overlays
	 * @author SAP SE
	 * @version 1.50.6
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.OverlayUtil
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var OverlayUtil = {};

	/**
	 * Check if the overlay is in target zone aggregation.
	 * @param  {sap.ui.dt.ElementOverlay}  oElementOverlay The overlay to be checked
	 * @return {boolean}                   Returns true if overlay is in target zone
	 * @private
	 */
	OverlayUtil.isInTargetZoneAggregation = function(oElementOverlay) {
		var oAggregationOverlay = oElementOverlay.getParent();
		return oAggregationOverlay && oAggregationOverlay.isTargetZone && oAggregationOverlay.isTargetZone();
	};

	/**
	 * Returns an object with public parent, aggregation in public parent and direct index.
	 * @param  {sap.ui.dt.ElementOverlay} oElementOverlay The overlay to get the information from
	 * @return {object}
	 *         {object.parent}            The overlay parent element
	 *         {object.aggregation}       The parent aggregation
	 *         {object.index}             Position of the parent element in the aggregation
	 * @private
	 */
	OverlayUtil.getParentInformation = function(oElementOverlay) {
		var oParentOverlay = oElementOverlay.getParentElementOverlay();
		if (oParentOverlay){
			//calculate index in direct (maybe in hidden tree) parent
			var oParent = oParentOverlay.getElementInstance();
			var sParentAggregationName = oElementOverlay.getParentAggregationOverlay().getAggregationName();
			var aChildren = ElementUtil.getAggregation(oParent, sParentAggregationName);
			var oElement = oElementOverlay.getElementInstance();
			var iIndex = aChildren.indexOf(oElement);

			return {
				parent: oParent,
				aggregation : sParentAggregationName,
				index: iIndex
			};
		} else {
			return {
				parent: null,
				aggregation: "",
				index: -1
			};
		}

	};

	/**
	 * Get the closest overlay to an element (moving up the tree).
	 * @param  {sap.ui.core.Element} oElement The element to be checked
	 * @return {sap.ui.dt.ElementOverlay} Returns the overlay that was found first
	 * @private
	 */
	OverlayUtil.getClosestOverlayFor = function(oElement) {
		if (!oElement) {
			return null;
		}

		var oParent = oElement;
		var oParentOverlay = OverlayRegistry.getOverlay(oParent);
		while (oParent && !oParentOverlay) {
			oParent = oParent.getParent();
			oParentOverlay = OverlayRegistry.getOverlay(oParent);
		}

		return oParentOverlay;
	};

	/**
	 * Get the Overlay geometry.
	 * @param  {array}  aGeometry Array with the element geometries
	 * @return {object} Returns geometry information: size (width, height), position (left, top) and visibility
	 * @private
	 */
	OverlayUtil.getGeometry = function(aGeometry) {
		var minLeft, maxRight, minTop, maxBottom;
		aGeometry.forEach(function(oElementGeometry) {
			if (oElementGeometry) {
				if (!minLeft || oElementGeometry.position.left < minLeft) {
					minLeft = oElementGeometry.position.left;
				}
				if (!minTop || oElementGeometry.position.top < minTop) {
					minTop = oElementGeometry.position.top;
				}

				var iRight = oElementGeometry.position.left + oElementGeometry.size.width;
				if (!maxRight || iRight > maxRight) {
					maxRight = iRight;
				}
				var iBottom = oElementGeometry.position.top + oElementGeometry.size.height;
				if (!maxBottom || iBottom > maxBottom) {
					maxBottom = iBottom;
				}
			}
		});

		if (typeof minLeft === "number") {
			return {
				size: {
					width: maxRight - minLeft,
					height: maxBottom - minTop
				},
				position: {
					left: minLeft,
					top: minTop
				},
				visible : true
			};
		}
	};

	/**
	 * Get the closest overlay to an overlay (moving up the tree) for a particular element type.
	 * @param  {string} sType The element type being searched
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay The source overlay
	 * @return {sap.ui.dt.ElementOverlay} Returns the overlay for that element type that was found first
	 * @private
	 */
	OverlayUtil.getClosestOverlayForType = function(sType, oOverlay) {
		while (oOverlay && !ElementUtil.isInstanceOf(oOverlay.getElementInstance(), sType)) {
			oOverlay = oOverlay.getParentElementOverlay();
		}

		return oOverlay;
	};

	/**
	 * Get the closest overlay (moving up the tree) that is scrollable.
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay The source overlay
	 * @return {sap.ui.dt.ElementOverlay} Returns the scrollable overlay that was found first
	 * @private
	 */
	OverlayUtil.getClosestScrollable = function(oOverlay) {
		if (!oOverlay) {
			return undefined;
		}

		oOverlay = oOverlay.getParent();
		while (oOverlay && oOverlay.isScrollable && !oOverlay.isScrollable()) {
			oOverlay = oOverlay.getParent();
		}

		return oOverlay && oOverlay.isScrollable ? oOverlay : null;
	};

	/**
	 * Returns first descendant of given ElementOverlay which fulfills
	 * the given condition. Recursive function.
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Source overlay object
	 * @param {function} fnCondition - condition to search
	 * @returns {sap.ui.dt.ElementOverlay} Returns the overlay which fulfills the condition, otherwise it returns 'undefined'
	 * @private
	 */
	OverlayUtil.getFirstDescendantByCondition = function(oOverlay, fnCondition) {
		if (!fnCondition) {
			throw new Error("expected condition is 'undefined' or not a function");
		}
		var aChildrenOverlays = OverlayUtil.getAllChildOverlays(oOverlay);
		for (var i = 0, n = aChildrenOverlays.length; i < n; i++) {
			var oChildOverlay = aChildrenOverlays[i];
			if (fnCondition(oChildOverlay)) {
				return oChildOverlay;
			}
			var oDescendantOverlay = this.getFirstDescendantByCondition(oChildOverlay, fnCondition);
			if (oDescendantOverlay) {
				return oDescendantOverlay;
			}
		}
		return undefined;
	};

	/**
	 * Returns all overlay children as ElementOverlay.
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Source overlay object
	 * @returns {array} Returns an array of child overlays {sap.ui.dt.ElementOverlay}
	 * @private
	 */
	OverlayUtil.getAllChildOverlays = function(oOverlay) {
		var aChildOverlays = [], aChildren = [];
		if (!oOverlay) {
			return aChildOverlays;
		}
		var aAggregationOverlays = oOverlay.getAggregationOverlays();
		for (var i = 0; i < aAggregationOverlays.length; i++) {
			aChildren = aAggregationOverlays[i].getChildren();
			if (aChildren && aChildren.length > 0) {
				aChildOverlays = aChildOverlays.concat(aChildren);
			}
		}
		return aChildOverlays;
	};

	/**
	 * Returns first child overlay.
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Source overlay object
	 * @returns {sap.ui.dt.ElementOverlay} Returns the first child overlay
	 * @private
	 */
	OverlayUtil.getFirstChildOverlay = function(oOverlay) {
		var aChildren = this.getAllChildOverlays(oOverlay);
		if (aChildren.length) {
			return aChildren[0];
		}
		return undefined;
	};

	/**
	 * Returns last child overlay.
	 *
	 * @param {sap.ui.dt.ElementOverlay} oOverlay - Source overlay object
	 * @returns {sap.ui.dt.ElementOverlay} Returns the last child overlay
	 * @private
	 */
	OverlayUtil.getLastChildOverlay = function(oOverlay) {
		var aChildren = this.getAllChildOverlays(oOverlay);
		if (aChildren.length) {
			return aChildren[aChildren.length - 1];
		}
		return undefined;
	};

	/**
	 * Returns next sibling overlay (going down the tree).
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay The source overlay
	 * @return {sap.ui.dt.ElementOverlay} Returns the next sibling overlay
	 * @private
	 */
	OverlayUtil.getNextSiblingOverlay = function(oOverlay) {
		if (!oOverlay) {
			return undefined;
		}

		var oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			var aAggregationOverlays = oParentAggregationOverlay.getChildren();
			var iIndex = aAggregationOverlays.indexOf(oOverlay);
			// get next sibling in the same aggregation
			if (iIndex !== aAggregationOverlays.length - 1) {
				return aAggregationOverlays[iIndex + 1];
			} else if (iIndex === aAggregationOverlays.length - 1) {
				// get next sibling from next aggregation in the same parent
				var oParent = oOverlay.getParentElementOverlay();
				aAggregationOverlays = oParent.getAggregationOverlays();
				for (iIndex = aAggregationOverlays.indexOf(oParentAggregationOverlay) + 1; iIndex < aAggregationOverlays.length; iIndex++) {
					var aOverlays = aAggregationOverlays[iIndex].getChildren();
					if (aOverlays.length) {
						return aOverlays[0];
					}
				}
			}
		}
	};

	/**
	 * Returns previous sibling overlay (going up the tree).
	 * @param  {sap.ui.dt.ElementOverlay} oOverlay The source overlay
	 * @return {sap.ui.dt.ElementOverlay} Returns the previous sibling overlay
	 * @private
	 */
	OverlayUtil.getPreviousSiblingOverlay = function(oOverlay) {
		if (!oOverlay) {
			return undefined;
		}

		var oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			var aAggregationOverlays = oParentAggregationOverlay.getChildren();
			var iIndex = aAggregationOverlays.indexOf(oOverlay);
			// get previous sibling from the same aggregation
			if (iIndex > 0) {
				return aAggregationOverlays[iIndex - 1];
			} else if (iIndex === 0) {
				// get previous sibling from previous aggregation in the same parent
				var oParent = oOverlay.getParentElementOverlay();
				aAggregationOverlays = oParent.getAggregationOverlays();
				for (iIndex = aAggregationOverlays.indexOf(oParentAggregationOverlay) - 1; iIndex >= 0; iIndex--) {
					var aOverlays = aAggregationOverlays[iIndex].getChildren();
					if (aOverlays.length) {
						return aOverlays[aOverlays.length - 1];
					}
				}
			}
		}
	};

	/**
	 * Get next overlay (look first in children, then next siblings).
	 * @param  {sap.ui.dt.Overlay} oOverlay The source overlay
	 * @return {sap.ui.dt.Overlay} Returns the overlay that was found first
	 * @private
	 */
	OverlayUtil.getNextOverlay = function(oOverlay) {
		if (!oOverlay) {
			return undefined;
		}

		var oFirstChildOverlay = this.getFirstChildOverlay(oOverlay);
		if (oFirstChildOverlay) {
			return oFirstChildOverlay;
		}

		var oNextSiblingOverlay = this.getNextSiblingOverlay(oOverlay);
		if (oNextSiblingOverlay) {
			return oNextSiblingOverlay;
		}

		do {
			oOverlay = oOverlay.getParentElementOverlay();
			oNextSiblingOverlay = this.getNextSiblingOverlay(oOverlay);
		} while (oOverlay && !oNextSiblingOverlay);

		return oNextSiblingOverlay;
	};

	/**
	 * Get next overlay (look first in parent, then previous siblings).
	 * @param  {sap.ui.dt.Overlay} oOverlay The source overlay
	 * @return {sap.ui.dt.Overlay} Returns the overlay that was found first
	 */
	OverlayUtil.getPreviousOverlay = function(oOverlay) {
		if (!oOverlay) {
			return undefined;
		}

		var oParentAggregationOverlay = oOverlay.getParentAggregationOverlay();
		if (!oParentAggregationOverlay) {
			return undefined;
		}

		var oPreviousSiblingOverlay = this.getPreviousSiblingOverlay(oOverlay);
		if (oPreviousSiblingOverlay) {
			var oLastChildOverlay = oPreviousSiblingOverlay;
			do {
				oPreviousSiblingOverlay = oLastChildOverlay;
				oLastChildOverlay = this.getLastChildOverlay(oPreviousSiblingOverlay);
			} while (oLastChildOverlay);

			return oPreviousSiblingOverlay;
		}

		return oOverlay.getParentElementOverlay();
	};

	/**
	 * Returns the root overlay of an overlay.
	 * @param  {sap.ui.dt.Overlay} oOverlay The source overlay
	 * @return {sap.ui.dt.Overlay} Returns the root overlay
	 */
	OverlayUtil.getRootOverlay = function(oOverlay) {
		var oParentOverlay = oOverlay;
		do {
			oOverlay = oParentOverlay;
			oParentOverlay = oOverlay.getParentElementOverlay();
		} while (oParentOverlay);

		return oOverlay;
	};

	/**
	 * Applies a function to every element in an overlay's element tree.
	 * @param  {sap.ui.dt.ElementOverlay} oElementOverlay The source overlay
	 * @param  {function} fnCallback The function to be applied
	 * @private
	 */
	OverlayUtil.iterateOverlayElementTree = function(oElementOverlay, fnCallback) {
		fnCallback(oElementOverlay);

		oElementOverlay.getAggregationOverlays().forEach(function(oAggregationOverlay) {
			oAggregationOverlay.getChildren().forEach(function(oChildOverlay) {
				this.iterateOverlayElementTree(oChildOverlay, fnCallback);
			}, this);
		}, this);
	};

	/**
	 * Applies a function to every 'aggregation-like' children (e.g. associations).
	 * @param  {sap.ui.dt.ElementOverlay} oElementOverlay  The source overlay
	 * @param  {string} sAggregationName The name of the aggregation
	 * @param  {function} fnCallback The function to be applied
	 * @private
	 */
	OverlayUtil.iterateOverAggregationLikeChildren = function(oElementOverlay, sAggregationName, fnCallback) {
		var oElement = oElementOverlay.getElementInstance();
		var vChildren;
		if (oElementOverlay.getAggregationOverlay(sAggregationName).isAssociation()){
			vChildren = ElementUtil.getAssociationInstances(oElement, sAggregationName);
		} else {
			vChildren = ElementUtil.getAggregation(oElement, sAggregationName);
		}
		ElementUtil.iterateOverElements(vChildren, fnCallback);
	};

	/**
	 * Applies a function to every overlay in the tree (going down the tree).
	 * @param  {sap.ui.dt.Overlay} oOverlay The source overlay
	 * @param  {function} fnCallback The function to be applied
	 * @private
	 */
	OverlayUtil.iterateOverlayTree = function(oOverlay, fnCallback) {
		fnCallback(oOverlay);

		oOverlay.getChildren().forEach(function(oChildOverlay) {
			this.iterateOverlayTree(oChildOverlay, fnCallback);
		}, this);
	};


	/**
	 * Checks if a DOM node is part of an overlay container.
	 * @param  {any}  oNode The node to be checked
	 * @return {boolean} Returns true if the node is part of an overlay container
	 * @private
	 */
	OverlayUtil.isInOverlayContainer = function(oNode) {
		if (oNode && jQuery(oNode).closest(".sapUiDtOverlay, #overlay-container").length) {
			return true;
		}
	};

	/**
	 * Returns the closest overlay to a given node.
	 * @param  {any} oNode The source node
	 * @return {sap.ui.dt.Overlay} Returns the closest overlay
	 * @private
	 */
	OverlayUtil.getClosestOverlayForNode = function(oNode) {
		var oElement = ElementUtil.getClosestElementForNode(oNode);
		return OverlayUtil.getClosestOverlayFor(oElement);
	};

	return OverlayUtil;
}, /* bExport= */true);

}; // end of sap/ui/dt/OverlayUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.Plugin') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.Plugin.
jQuery.sap.declare('sap.ui.dt.Plugin'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/Plugin",[
	'sap/ui/base/ManagedObject'
],
function(ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new Plugin.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Plugin allows to handle the overlays and aggregation overlays from the DesignTime
	 * The Plugin should be overriden by the real plugin implementations, which define some actions through events attached to an overlays
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.Plugin
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var Plugin = ManagedObject.extend("sap.ui.dt.Plugin", /** @lends sap.ui.dt.Plugin.prototype */ {
		metadata : {
			"abstract" : true,
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * DesignTime where this plugin will be used
				 */
				designTime : { // its defined as a property because spa.ui.dt.designTime is a managed object and UI5 only allows associations for elements
					type : "object",
					multiple : false
				}
			}
		}
	});

	/**
	 * Called when the Plugin is initialized
	 * @protected
	 */
	Plugin.prototype.init = function() {};

	/**
	 * Called when the Plugin is destroyed
	 * @protected
	 */
	Plugin.prototype.exit = function() {
		this.setDesignTime(null);
	};

	/**
	 * Function is called initially for every overlay in the DesignTime and then when any new overlay is created inside of the DesignTime
	 * This function should be overriden by the plugins to handle the overlays (attach events and etc.)
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.registerElementOverlay
	 * @param {sap.ui.dt.ElementOverlay} an oElementOverlay which should be registered
	 * @protected
	 */
	// Plugin.prototype.registerElementOverlay = function(oElementOverlay) {};

	/**
	 * Function is called for every overlay in the DesignTime when the Plugin is deactivated.
	 * This function should be overriden by the plugins to rollback the registration and cleanup attached event etc.
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.deregisterElementOverlay
	 * @param {sap.ui.dt.ElementOverlay} an oElementOverlay which should be deregistered
	 * @protected
	 */
	// Plugin.prototype.deregisterElementOverlay = function(oElementOverlay) {};

	/**
	 * Function is called initially for every aggregation overlay in the DesignTime and then when any new aggregation overlay is created inside of the DesignTime
	 * This function should be overriden by the plugins to handle the aggregation overlays (attach events and etc.)
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.registerAggregationOverlay
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay which should be registered
	 * @protected
	 */
	// Plugin.prototype.registerAggregationOverlay = function(oAggregationOverlay) {};

	/**
	 * Function is called for every aggregation overlay in the DesignTime when the Plugin is deactivated.
	 * This function should be overriden by the plugins to rollback the registration and cleanup attached event etc.
	 * @function
	 * @name sap.ui.dt.Plugin.prototype.deregisterAggregationOverlay
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay which should be deregistered
	 * @protected
	 */
	// Plugin.prototype.deregisterAggregationOverlay = function(oAggregationOverlay) {};

	/**
	 * Sets a DesignTime, where the plugin should be used. Automatically called by "addPlugin" into DesignTime
	 * @param {sap.ui.dt.DesignTime} oDesignTime to set
	 * @return {sap.ui.dt.Plugin} returns this
	 * @public
	 */
	Plugin.prototype.setDesignTime = function(oDesignTime) {
		var oOldDesignTime = this.getDesignTime();
		if (oOldDesignTime) {
			this._deregisterOverlays(oOldDesignTime);
		}

		this.setProperty("designTime", oDesignTime);

		if (oDesignTime) {
			this._registerOverlays(oDesignTime);
		}

		return this;
	};

	/**
	 * @param {sap.ui.dt.DesignTime} oDesignTime to register overlays for
	 * @private
	 */
	Plugin.prototype._registerOverlays = function(oDesignTime) {
		if (this.registerElementOverlay || this.registerAggregationOverlay) {
			var aElementOverlays = oDesignTime.getElementOverlays();
			aElementOverlays.forEach(this.callElementOverlayRegistrationMethods.bind(this));
		}
	};

	/**
	 * @param {sap.ui.dt.DesignTime} oDesignTime to register overlays for
	 * @private
	 */
	Plugin.prototype._deregisterOverlays = function(oDesignTime) {
		if (this.deregisterElementOverlay || this.deregisterAggregationOverlay) {
			var aOverlays = oDesignTime.getElementOverlays();
			aOverlays.forEach(this._callElementOverlayDeregestrationMethods.bind(this));
		}
	};

	/**
	 * @param {sap.ui.dt.Overlay} oElementOverlay to call registration methods for
	 * @protected
	 */
	Plugin.prototype.callAggregationOverlayRegistrationMethods = function(oElementOverlay) {
		if (this.registerAggregationOverlay) {
			var aAggregationOverlays = oElementOverlay.getAggregationOverlays();
			aAggregationOverlays.forEach(this.registerAggregationOverlay.bind(this));
		}
	};

	/**
	 * @param {sap.ui.dt.Overlay} oElementOverlay to call registration methods for
	 * @protected
	 */
	Plugin.prototype.callElementOverlayRegistrationMethods = function(oElementOverlay) {
		if (this.registerElementOverlay) {
			this.registerElementOverlay(oElementOverlay);
		}

		this.callAggregationOverlayRegistrationMethods(oElementOverlay);
	};

	/**
	 * @param {sap.ui.dt.Overlay} oOverlay to callde registration methods for
	 * @private
	 */
	Plugin.prototype._callElementOverlayDeregestrationMethods = function(oElementOverlay) {
		if (this.deregisterElementOverlay) {
			this.deregisterElementOverlay(oElementOverlay);
		}

		if (this.deregisterAggregationOverlay) {
			var aAggregationOverlays = oElementOverlay.getAggregationOverlays();
			aAggregationOverlays.forEach(this.deregisterAggregationOverlay.bind(this));
		}
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	Plugin.prototype._onElementOverlayCreated = function(oEvent) {
		var oOverlay = oEvent.getParameter("elementOverlay");

		this.callElementOverlayRegistrationMethods(oOverlay);
	};

	return Plugin;
}, /* bExport= */ true);

}; // end of sap/ui/dt/Plugin.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.RenderingUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.RenderingUtil.
jQuery.sap.declare('sap.ui.dt.RenderingUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/RenderingUtil",[
	'jquery.sap.global'
],
function(jQuery) {
	"use strict";

	/**
	 * Class for RenderingUtil.
	 *
	 * @class
	 * Utility functionality to work with élements, e.g. iterate through aggregations, find parents, ...
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @private
	 * @static
	 * @since 1.30
	 * @alias sap.ui.dt.RenderingUtil
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var RenderingUtil = {};

	/**
	 *
	 */
	RenderingUtil.renderOverlay = function(oRm, oOverlay, sClassName) {
		var oGeometry = oOverlay.getGeometry();
		var bGeometryVisible = oGeometry && oGeometry.visible;
		var bRenderOverlay = !oOverlay.getLazyRendering() || bGeometryVisible;

		if (oOverlay.isVisible() && bRenderOverlay) {
			if (oOverlay.getDomRef()) {
				this._triggerOnAfterRenderingWithoutRendering(oRm, oOverlay);

				return;
			}

			oRm.addClass("sapUiDtOverlay");
			oRm.addClass(sClassName);
			oRm.write("<div");
			oRm.writeControlData(oOverlay);
			var sAggregationName = oOverlay.getAggregationName && oOverlay.getAggregationName();
			if (sAggregationName) {
				oRm.write("data-sap-ui-dt-aggregation='" + oOverlay.getAggregationName() + "'");
			} else {
				oRm.write("data-sap-ui-dt-for='" + oOverlay.getElementInstance().getId() + "'");
			}
			oRm.writeClasses();

			oRm.writeStyles();
			oRm.write(">");

			oRm.write("<div");
			oRm.addClass("sapUiDtOverlayChildren");
			oRm.writeClasses();
			oRm.write(">");
			this._renderChildren(oRm, oOverlay);

			oRm.write("</div>");
			oRm.write("</div>");
		}

	};

	/**
	 */
	RenderingUtil._renderChildren = function(oRm, oOverlay) {
		var aChildrenOverlays = oOverlay.getChildren();
		if (oOverlay._aScrollContainers) {
			oOverlay._aScrollContainers.forEach(function(oScrollContainer, iIndex) {
				oRm.write("<div");
				oRm.addClass("sapUiDtOverlayScrollContainer");
				oRm.writeClasses();
				oRm.write("data-sap-ui-dt-scrollContainerIndex='" + iIndex + "'");
				oRm.write(">");

				if (oScrollContainer.aggregations) {
					oScrollContainer.aggregations.forEach(function(sAggregationName) {
						var oAggregationOverlay = oOverlay.getAggregationOverlay(sAggregationName);
						oRm.renderControl(oAggregationOverlay);
						aChildrenOverlays.splice(aChildrenOverlays.indexOf(oAggregationOverlay), 1);
					});
				}
				oRm.write("</div>");
			});
		}

		aChildrenOverlays.forEach(function(oChildOverlay) {
			oRm.renderControl(oChildOverlay);
		});
	};

	/**
	 */
	RenderingUtil._rerenderControls = function(oRm, oOverlay) {
		var aChildrenOverlays = oOverlay.getChildren();
		aChildrenOverlays.forEach(function(oChildOverlay) {
			oRm.renderControl(oChildOverlay);
		});
	};

	/**
	 */
	RenderingUtil._triggerOnAfterRenderingWithoutRendering = function(oRm, oOverlay) {
		// to trigger after rendering without rendering we need to write something in a renderManager buffer
		oRm.write("");
		this._rerenderControls(oRm, oOverlay);
	};

	return RenderingUtil;
}, /* bExport= */ true);

}; // end of sap/ui/dt/RenderingUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.dt.
 */
jQuery.sap.declare('sap.ui.dt.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/library",[
    'jquery.sap.global',
	'sap/ui/core/library'
], // library dependency
function(jQuery) {

	"use strict";

	/**
	 * DesignTime library.
	 *
	 * @namespace
	 * @name sap.ui.dt
	 * @author SAP SE
	 * @version 1.50.6
	 * @experimental This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 * @private
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.dt",
		version: "1.50.6",
		dependencies : ["sap.ui.core"],
		types: [
			"sap.ui.dt.SelectionMode"
		],
		interfaces: [],
		controls: [],
		elements: []
	});

	/**
	 * Selection mode of the tree
	 *
	 * @enum {string}
	 * @private
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.dt.SelectionMode = {

		/**
		 * Select multiple overlays at a time.
		 * @public
		 */
		Multi : "Multi",

		/**
		 * Select one overlay at a time.
		 * @public
		 */
		Single : "Single"

	};

	return sap.ui.dt;

}, /* bExport= */ true);

}; // end of sap/ui/dt/library.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.DragDrop') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.DragDrop.
jQuery.sap.declare('sap.ui.dt.plugin.DragDrop'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/DragDrop",[
	'sap/ui/dt/Plugin',
	'sap/ui/dt/DOMUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/ElementUtil'
],
function(Plugin, DOMUtil, OverlayUtil, ElementUtil) {
	"use strict";

	/**
	 * Constructor for a new DragDrop.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DragDrop plugin is an abstract plugin to enable drag and drop functionality of the Overlays
	 * This Plugin should be overwritten by the D&D plugin implementations, the abstract functions should be used to perform actions
	 * @extends sap.ui.dt.plugin.Plugin
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.plugin.DragDrop
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DragDrop = Plugin.extend("sap.ui.dt.plugin.DragDrop", /** @lends sap.ui.dt.plugin.DragDrop.prototype */ {
		metadata : {
			"abstract" : true,
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
			},
			associations : {
			},
			events : {
			}
		}
	});

	var I_TOUCH_DRAG_START_THRESHOLD_DISTANCE = 7;

	var bPreventScrollOnTouch = false;

	// previous target overlay drag enter was called for
	var oPreviosTargetOverlayForTouch;

	/*
	 * @private
	 */
	DragDrop.prototype._preventScrollOnTouch = function(oEvent) {
		if (bPreventScrollOnTouch) {
			oEvent.preventDefault();
		}
	};

	/*
	 * @private
	 */
	DragDrop.prototype.init = function() {
		Plugin.prototype.init.apply(this, arguments);

		// We want to prevent the page from scrolling before getting to its children (=> useCapture "true")
		document.addEventListener('touchmove', this._preventScrollOnTouch, true);

		this._mElementOverlayDelegate = {
			"onAfterRendering" : this._checkMovable
		};

		this._mAggregationOverlayDelegate = {
			"onAfterRendering" : this._attachDragScrollHandler,
			"onBeforeRendering" : this._removeDragScrollHandler
		};

		this._dragScrollHandler = this._dragScroll.bind(this);
		this._dragLeaveHandler = this._dragLeave.bind(this);
		this._mScrollIntervals = {};
	};


	/*
	 * @private
	 */
	DragDrop.prototype.exit = function() {
		Plugin.prototype.exit.apply(this, arguments);

		document.removeEventListener('touchmove', this._preventScrollOnTouch);

		delete this._mElementOverlayDelegate;
		delete this._mAggregationOverlayDelegate;
		delete this._dragScrollHandler;
	};

	/**
	 * @override
	 * @param {sap.ui.dt.Overlay} an Overlay which should be registered
	 */
	DragDrop.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.addEventDelegate(this._mElementOverlayDelegate, this);

		oOverlay.attachEvent("movableChange", this._onMovableChange, this);

		if (oOverlay.isMovable()) {
			this._attachDragEvents(oOverlay);
		}

		oOverlay.attachBrowserEvent("dragover", this._onDragOver, this);
		oOverlay.attachBrowserEvent("dragenter", this._onDragEnter, this);
		oOverlay.attachBrowserEvent("dragleave", this._onDragLeave, this);
	};

	/**
	 * @override
	 */
	DragDrop.prototype.registerAggregationOverlay = function(oAggregationOverlay) {
		oAggregationOverlay.attachTargetZoneChange(this._onAggregationTargetZoneChange, this);

		if (!sap.ui.Device.browser.webkit) {
			this._attachDragScrollHandler(oAggregationOverlay);
			oAggregationOverlay.addEventDelegate(this._mAggregationOverlayDelegate, this);
		}
	};

	/**
	 * @override
	 */
	DragDrop.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.removeEventDelegate(this._mElementOverlayDelegate, this);

		oOverlay.detachEvent("movableChange", this._onMovableChange, this);

		this._detachDragEvents(oOverlay);

		oOverlay.detachBrowserEvent("dragover", this._onDragOver, this);
		oOverlay.detachBrowserEvent("dragenter", this._onDragEnter, this);
		oOverlay.detachBrowserEvent("dragleave", this._onDragLeave, this);
	};

	/**
	 * @override
	 */
	DragDrop.prototype.deregisterAggregationOverlay = function(oAggregationOverlay) {
		oAggregationOverlay.detachTargetZoneChange(this._onAggregationTargetZoneChange, this);

		if (!sap.ui.Device.browser.webkit) {
			oAggregationOverlay.removeEventDelegate(this._mAggregationOverlayDelegate, this);
			this._removeDragScrollHandler(oAggregationOverlay);
			this._clearScrollIntervalFor(oAggregationOverlay.$().attr("id"));
		}
	};

	/**
	 * @private
	 * @param {sap.ui.dt.Overlay} an Overlay to attach events to
	 */
	DragDrop.prototype._attachDragEvents = function(oOverlay) {
		oOverlay.attachBrowserEvent("dragstart", this._onDragStart, this);
		oOverlay.attachBrowserEvent("drag", this._onDrag, this);
		oOverlay.attachBrowserEvent("dragend", this._onDragEnd, this);
		oOverlay.attachBrowserEvent("touchstart", this._onTouchStart, this);
	};

	/**
	 * @private
	 * @param {sap.ui.dt.Overlay} an Overlay to detach events from
	 */
	DragDrop.prototype._detachDragEvents = function(oOverlay) {
		oOverlay.detachBrowserEvent("dragstart", this._onDragStart, this);
		oOverlay.detachBrowserEvent("drag", this._onDrag, this);
		oOverlay.detachBrowserEvent("dragend", this._onDragEnd, this);
		oOverlay.detachBrowserEvent("touchstart", this._onTouchStart, this);
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.onMovableChange = function(oOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onDragStart = function(oDraggedOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onDragEnd = function(oDraggedOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onDrag = function(oDraggedOverlay) { };

	/**
	 * @return {boolean} return true to omit event.preventDefault
	 * @protected
	 */
	DragDrop.prototype.onDragEnter = function(oOverlay) { };

	/**
	 * @return {boolean} return true to omit event.preventDefault
	 * @protected
	 */
	DragDrop.prototype.onDragLeave = function(oOverlay) { };

	/**
	 * @return {boolean} return true to omit event.preventDefault
	 * @protected
	 */
	DragDrop.prototype.onDragOver = function(oOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDragEnter = function(oAggregationOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDragOver = function(oAggregationOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDragLeave = function(oAggregationOverlay) { };

	/**
	 * @protected
	 */
	DragDrop.prototype.onAggregationDrop = function(oAggregationOverlay) { };

	/**
	 * @private
	 */
	DragDrop.prototype._checkMovable = function(oEvent) {
		var oOverlay = oEvent.srcControl;
		if (oOverlay.isMovable()) {
			DOMUtil.setDraggable(oOverlay.$(), true);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onMovableChange = function(oEvent) {
		var oOverlay = oEvent.getSource();
		if (oOverlay.isMovable()) {
			this._attachDragEvents(oOverlay);
		} else {
			this._detachDragEvents(oOverlay);
		}

		this.onMovableChange(oOverlay);
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragStart = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		oEvent.stopPropagation();

		// Fix for Firfox - Firefox only fires drag events when data is set
		if (sap.ui.Device.browser.firefox && oEvent && oEvent.originalEvent && oEvent.originalEvent.dataTransfer && oEvent.originalEvent.dataTransfer.setData) {
			oEvent.originalEvent.dataTransfer.setData('text/plain', '');
		}

		this.showGhost(oOverlay, oEvent);
		this.onDragStart(oOverlay);
	};

	DragDrop.prototype._attachTouchDragEvents = function(oOverlay) {
		oOverlay.attachBrowserEvent("touchmove", this._onTouchMove, this);
		oOverlay.attachBrowserEvent("touchend", this._onTouchEnd, this);
	};

	DragDrop.prototype._detachTouchDragEvents = function(oOverlay) {
		oOverlay.detachBrowserEvent("touchmove", this._onTouchMove, this);
		oOverlay.detachBrowserEvent("touchend", this._onTouchEnd, this);
	};

	DragDrop.prototype._onTouchStart = function(oEvent) {

		var touchStartX = oEvent.touches[0].pageX;
		var touchStartY = oEvent.touches[0].pageY;

		var fnTouchMoveHandler, fnTouchEndHandler;

		var oTouchedOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

	    var fnDetachTouchHandlers = function() {
			oTouchedOverlay.detachBrowserEvent("touchmove", fnTouchMoveHandler, this);
			oTouchedOverlay.detachBrowserEvent("touchend", fnTouchEndHandler, this);
			oTouchedOverlay.detachBrowserEvent("contextmenu", fnTouchEndHandler, this);
	    };

	    var fnGetMoveDistance = function(touchMoveX, touchMoveY) {
			var distanceX = touchStartX - touchMoveX;
			var distanceY = touchStartY - touchMoveY;
	        return Math.sqrt((distanceX * distanceX) + (distanceY * distanceY));
	    };

	    fnTouchMoveHandler = function(oEvent) {
			var touchMoveX = oEvent.touches[0].pageX;
			var touchMoveY = oEvent.touches[0].pageY;
			var movedDistance = fnGetMoveDistance(touchMoveX, touchMoveY);

			if (movedDistance > I_TOUCH_DRAG_START_THRESHOLD_DISTANCE) {
				this.onDragStart(oTouchedOverlay);
				fnDetachTouchHandlers.call(this);
				this._attachTouchDragEvents(oTouchedOverlay);
			}
		};

	    fnTouchEndHandler = function(oEvent) {
			fnDetachTouchHandlers.call(this);
			bPreventScrollOnTouch = false;
		};

		bPreventScrollOnTouch = true;
		oEvent.stopPropagation();

		oTouchedOverlay.attachBrowserEvent("touchmove", fnTouchMoveHandler, this);
		oTouchedOverlay.attachBrowserEvent("contextmenu", fnTouchEndHandler, this);
		oTouchedOverlay.attachBrowserEvent("touchend", fnTouchEndHandler, this);
	};

	DragDrop.prototype._getTargetOverlay = function(oElement) {
		if (oElement && ElementUtil.isInstanceOf(oElement, "sap.ui.dt.Overlay")) {

			// target overlay is the overlay that we could drop on and therefore have to fire events for
			var oTargetOverlay;
			// is overlay a targetZone AggregationOverlay
			if (ElementUtil.isInstanceOf(oElement, "sap.ui.dt.AggregationOverlay") && oElement.getTargetZone()) {
				oTargetOverlay = oElement;
			} else if (OverlayUtil.isInTargetZoneAggregation(oElement)) {
				oTargetOverlay = oElement;
			}

			return oTargetOverlay ? oTargetOverlay : this._getTargetOverlay(oElement.getParent());
		}
	};

	DragDrop.prototype._findTargetOverlayFromCoordinates = function(pageX, pageY) {
		var oDomNode = document.elementFromPoint(pageX, pageY);

		var oElement = oDomNode ? sap.ui.getCore().byId(oDomNode.id) : undefined;

		return this._getTargetOverlay(oElement);

	};

	DragDrop.prototype._onTouchMove = function(oEvent) {
		var oDraggedOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		this.onDrag(oDraggedOverlay);

		// changedTouches will have the information related to the moved finger, because it’s what caused the event "touchmove"
		var aTouches = oEvent.touches || oEvent.changedTouches;

		var pageX = aTouches[0].pageX;
		var pageY = aTouches[0].pageY;

		var oTargetOverlay = this._findTargetOverlayFromCoordinates(pageX, pageY);

		if (!oTargetOverlay) {
			return;
		}

		if (oTargetOverlay !== oPreviosTargetOverlayForTouch) {
			if (oPreviosTargetOverlayForTouch) {
				if (ElementUtil.isInstanceOf(oPreviosTargetOverlayForTouch, "sap.ui.dt.AggregationOverlay")) {
					this.onAggregationDragLeave(oPreviosTargetOverlayForTouch);
				} else {
					this.onDragLeave(oPreviosTargetOverlayForTouch);
				}
			}
			oPreviosTargetOverlayForTouch = oTargetOverlay;

			if (ElementUtil.isInstanceOf(oTargetOverlay, "sap.ui.dt.AggregationOverlay")) {
				this.onAggregationDragEnter(oTargetOverlay);
			} else {
				this.onDragEnter(oTargetOverlay);
			}
		}

		if (ElementUtil.isInstanceOf(oTargetOverlay, "sap.ui.dt.AggregationOverlay")) {
			this.onAggregationDragOver(oTargetOverlay);
		} else {
			this.onDragOver(oTargetOverlay);
		}

		oEvent.stopPropagation();
	};

	DragDrop.prototype._getValidTargetZoneAggregationOverlay = function(oOverlay) {
		if (ElementUtil.isInstanceOf(oOverlay, "sap.ui.dt.AggregationOverlay") && oOverlay.getTargetZone()) {
			return oOverlay;
		} else {
			return this._getValidTargetZoneAggregationOverlay(oOverlay.getParent());
		}
	};

	DragDrop.prototype._onTouchEnd = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		var oAggregationOverlay = this._getValidTargetZoneAggregationOverlay(oOverlay);

		if (oAggregationOverlay) {
			this.onAggregationDrop(oAggregationOverlay);
		}

		this.onDragEnd(oOverlay);
		this._detachTouchDragEvents(oOverlay);

		oPreviosTargetOverlayForTouch = undefined;

		bPreventScrollOnTouch = false;
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.showGhost = function(oOverlay, oEvent) {
		// IE and Edge do no support dataTransfer.setDragImage on D&D event
		if (!sap.ui.Device.browser.internet_explorer && !sap.ui.Device.browser.edge && !sap.ui.Device.browser.msie &&
			oEvent && oEvent.originalEvent && oEvent.originalEvent.dataTransfer && oEvent.originalEvent.dataTransfer.setDragImage) {
			this._$ghost = this.createGhost(oOverlay, oEvent);

			// ghost should be visible to set it as dragImage
			this._$ghost.appendTo("#overlay-container");
			// if ghost will be removed without timeout, setDragImage won't work
			setTimeout(function() {
				this._removeGhost();
			}.bind(this), 0);
			oEvent.originalEvent.dataTransfer.setDragImage(
				this._$ghost.get(0),
				oEvent.originalEvent.pageX - oOverlay.$().offset().left,
				oEvent.originalEvent.pageY - oOverlay.$().offset().top
			);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._removeGhost = function() {
		this.removeGhost();
		delete this._$ghost;
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.removeGhost = function() {
		var $ghost = this.getGhost();
		if ($ghost) {
			$ghost.remove();
		}
	};

	/**
	 * @protected
	 */
	DragDrop.prototype.createGhost = function(oOverlay) {
		var $GhostDom = oOverlay.getAssociatedDomRef();
		var $ghost;
		if (!$GhostDom) {
			$GhostDom = this._getAssociatedDomCopy(oOverlay);
			$ghost = $GhostDom;
		} else {
			$ghost = jQuery("<div></div>");
			jQuery.makeArray($GhostDom).forEach(function(oNode) {
				DOMUtil.cloneDOMAndStyles(oNode, $ghost);
			});
		}

		var $ghostWrapper = jQuery("<div></div>").addClass("sapUiDtDragGhostWrapper");
		return $ghostWrapper.append($ghost.addClass("sapUiDtDragGhost"));
	};

	/**
	 * @private
	 */
	DragDrop.prototype._getAssociatedDomCopy = function(oOverlay) {
		var $DomCopy = jQuery("<div></div>");

		oOverlay.getAggregationOverlays().forEach(function(oAggregationOverlay) {
			oAggregationOverlay.getChildren().forEach(function(oChildOverlay) {
				var oChildDom = oChildOverlay.getAssociatedDomRef();
				if (oChildDom) {
					DOMUtil.cloneDOMAndStyles(oChildDom, $DomCopy);
				} else {
					DOMUtil.cloneDOMAndStyles(this._getAssociatedDomCopy(oChildOverlay), $DomCopy);
				}
			}, this);
		}, this);

		return $DomCopy;
	};

	/**
	 * @protected
	 * @return {jQuery} jQuery object drag ghost
	 */
	DragDrop.prototype.getGhost = function() {
		return this._$ghost;
	};


	/**
	 * @private
	 */
	DragDrop.prototype._onDragEnd = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this._removeGhost();

		this._clearAllScrollIntervals();
		this.onDragEnd(oOverlay);

		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDrag = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		this.onDrag(oOverlay);

		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragEnter = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		if (OverlayUtil.isInTargetZoneAggregation(oOverlay)) {
			//if "true" returned, propagation won't be canceled
			if (!this.onDragEnter(oOverlay)) {
				oEvent.stopPropagation();
			}
		}

		oEvent.preventDefault();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragLeave = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		if (OverlayUtil.isInTargetZoneAggregation(oOverlay)) {
			//if "true" returned, propagation won't be canceled
			if (!this.onDragLeave(oOverlay)) {
				oEvent.stopPropagation();
			}
		}

		oEvent.preventDefault();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onDragOver = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		if (OverlayUtil.isInTargetZoneAggregation(oOverlay)) {
			//if "true" returned, propagation won't be canceled
			if (!this.onDragOver(oOverlay)) {
				oEvent.stopPropagation();
			}
		}

		oEvent.preventDefault();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationTargetZoneChange = function(oEvent) {
		var oAggregationOverlay = oEvent.getSource();
		var bTargetZone = oEvent.getParameter("targetZone");

		if (bTargetZone) {
			this._attachAggregationOverlayEvents(oAggregationOverlay);
		} else {
			this._detachAggregationOverlayEvents(oAggregationOverlay);
		}

	};

	/**
	 * @private
	 */
	DragDrop.prototype._attachAggregationOverlayEvents = function(oAggregationOverlay) {

		oAggregationOverlay.attachBrowserEvent("dragenter", this._onAggregationDragEnter, this);
		oAggregationOverlay.attachBrowserEvent("dragover", this._onAggregationDragOver, this);
		oAggregationOverlay.attachBrowserEvent("dragleave", this._onAggregationDragLeave, this);
		oAggregationOverlay.attachBrowserEvent("drop", this._onAggregationDrop, this);
	};

	/**
	 * @private
	 */
	DragDrop.prototype._detachAggregationOverlayEvents = function(oAggregationOverlay) {
		oAggregationOverlay.detachBrowserEvent("dragenter", this._onAggregationDragEnter, this);
		oAggregationOverlay.detachBrowserEvent("dragover", this._onAggregationDragOver, this);
		oAggregationOverlay.detachBrowserEvent("dragleave", this._onAggregationDragLeave, this);
		oAggregationOverlay.detachBrowserEvent("drop", this._onAggregationDrop, this);
	};


	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDragEnter = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDragEnter(oAggregationOverlay);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDragOver = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDragOver(oAggregationOverlay);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDragLeave = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDragLeave(oAggregationOverlay);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	/**
	 * @private
	 */
	DragDrop.prototype._onAggregationDrop = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		this.onAggregationDrop(oAggregationOverlay);

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};


	/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
	 * Scroll ondrag enablement (only for non-webkit browsers) *
	 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

	var I_SCROLL_TRAP_SIZE = 100;
	var I_SCROLL_STEP = 20;
	var I_SCROLL_INTERVAL = 50;

	/**
	 * @private
	 */
	DragDrop.prototype._clearScrollInterval = function(sElementId, sDirection) {
		if (this._mScrollIntervals[sElementId]) {
			window.clearInterval(this._mScrollIntervals[sElementId][sDirection]);
			delete this._mScrollIntervals[sElementId][sDirection];
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._clearScrollIntervalFor = function(sElementId) {
		if (this._mScrollIntervals[sElementId]) {
			Object.keys(this._mScrollIntervals[sElementId]).forEach(function(sDirection) {
				this._clearScrollInterval(sElementId, sDirection);
			}, this);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._clearAllScrollIntervals = function() {
		Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));
	};

	/**
	 * @private
	 */
	DragDrop.prototype._checkScroll = function($element, sDirection, iEventOffset) {
		var iSize;
		var fnScrollFunction;
		var iScrollMultiplier = 1;

		if (sDirection === "top" || sDirection === "bottom") {
			iSize = $element.height();
			fnScrollFunction = $element.scrollTop.bind($element);
		} else {
			iSize = $element.width();
			fnScrollFunction = $element.scrollLeft.bind($element);
		}
		if (sDirection === "top" || sDirection === "left") {
			iScrollMultiplier = -1;
		}

		// ensure scroll trap size isn't be bigger then ¼ of the container size
		var iSizeQuarter = Math.floor(iSize / 4);
		var iTrapSize = I_SCROLL_TRAP_SIZE;
		if (iSizeQuarter < I_SCROLL_TRAP_SIZE) {
			iTrapSize = iSizeQuarter;
		}


		if (iEventOffset < iTrapSize) {
			this._mScrollIntervals[$element.attr("id")] = this._mScrollIntervals[$element.attr("id")] || {};
			if (!this._mScrollIntervals[$element.attr("id")][sDirection]) {
				this._mScrollIntervals[$element.attr("id")][sDirection] = window.setInterval(function() {
					var iInitialScrollOffset = fnScrollFunction();
					fnScrollFunction(iInitialScrollOffset + iScrollMultiplier * I_SCROLL_STEP);
				}, I_SCROLL_INTERVAL);
			}
		} else {
			this._clearScrollInterval($element.attr("id"), sDirection);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._dragLeave = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		this._clearScrollIntervalFor(oAggregationOverlay.$().attr("id"));
	};

	/**
	 * @private
	 */
	DragDrop.prototype._dragScroll = function(oEvent) {
		var oAggregationOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		var $aggregationOverlay = oAggregationOverlay.$();

		var iDragX = oEvent.clientX;
		var iDragY = oEvent.clientY;

		var oOffset = $aggregationOverlay.offset();
		var iHeight = $aggregationOverlay.height();
		var iWidth = $aggregationOverlay.width();

		var iTop = oOffset.top;
		var iLeft = oOffset.left;
		var iBottom = iTop + iHeight;
		var iRight = iLeft + iWidth;

		this._checkScroll($aggregationOverlay, "bottom", iBottom - iDragY);
		this._checkScroll($aggregationOverlay, "top", iDragY - iTop);
		this._checkScroll($aggregationOverlay, "right", iRight - iDragX);
		this._checkScroll($aggregationOverlay, "left", iDragX - iLeft);
	};

	/**
	 * @private
	 */
	DragDrop.prototype._attachDragScrollHandler = function(oEventOrAggregationOverlay) {
		var oAggregationOverlay;
		if (ElementUtil.isInstanceOf(oEventOrAggregationOverlay, "sap.ui.dt.AggregationOverlay")) {
			oAggregationOverlay = oEventOrAggregationOverlay;
		} else {
			oAggregationOverlay = oEventOrAggregationOverlay.srcControl;
		}

		if (DOMUtil.hasScrollBar(oAggregationOverlay.$())) {
			oAggregationOverlay.getDomRef().addEventListener("dragover", this._dragScrollHandler, true);
			oAggregationOverlay.getDomRef().addEventListener("dragleave", this._dragLeaveHandler, true);
		}
	};

	/**
	 * @private
	 */
	DragDrop.prototype._removeDragScrollHandler = function(oEventOrAggregationOverlay) {
		var oAggregationOverlay;
		if (ElementUtil.isInstanceOf(oEventOrAggregationOverlay, "sap.ui.dt.AggregationOverlay")) {
			oAggregationOverlay = oEventOrAggregationOverlay;
		} else {
			oAggregationOverlay = oEventOrAggregationOverlay.srcControl;
		}

		var oDomRef = oAggregationOverlay.getDomRef();

		if (oDomRef) {
			oDomRef.removeEventListener("dragover", this._dragScrollHandler, true);
		}
	};

	return DragDrop;
}, /* bExport= */ true);

}; // end of sap/ui/dt/plugin/DragDrop.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.ElementMover') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.ElementMover.
jQuery.sap.declare('sap.ui.dt.plugin.ElementMover'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/plugin/ElementMover",['sap/ui/base/ManagedObject', 'sap/ui/dt/ElementUtil', 'sap/ui/dt/OverlayUtil',
		'sap/ui/dt/OverlayRegistry'], function(ManagedObject, ElementUtil, OverlayUtil,
		OverlayRegistry) {
	"use strict";

	/**
	 * Constructor for a new ElementMover.
	 *
	 * @param {string}
	 *          [sId] id for the new object, generated automatically if no id is given
	 * @param {object}
	 *          [mSettings] initial settings for the new object
	 * @class The ElementMover enables movement of UI5 elements based on aggregation types, which can be used by drag and
	 *        drop or cut and paste behavior.
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.plugin.ElementMover
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var ElementMover = ManagedObject.extend("sap.ui.dt.plugin.ElementMover", /** @lends sap.ui.dt.plugin.ElementMover.prototype */
	{
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				movableTypes : {
					type : "string[]",
					defaultValue : ["sap.ui.core.Element"]
				}
			},
			associations : {}
		}
	});

	/**
	 * @private
	 */
	ElementMover.prototype._getMovableTypes = function() {
		return this.getProperty("movableTypes") || [];
	};

	/**
	 * Predicate to compute movability of a type
	 * @public
	 * @return true if type is movable, false otherwise
	 */
	ElementMover.prototype.isMovableType = function(oElement) {
		var aMovableTypes = this._getMovableTypes();

		return aMovableTypes.some(function(sType) {
			return ElementUtil.isInstanceOf(oElement, sType);
		});
	};

	/**
	 * @protected
	 */
	ElementMover.prototype.checkMovable = function(oOverlay) {
		return true;
	};

	/**
	 * returns the moved overlay (only during movements)
	 *
	 * @public
	 * @return {sap.ui.dt.Overlay} overlay which is moved
	 */
	ElementMover.prototype.getMovedOverlay = function() {
		return this._oMovedOverlay;
	};

	/**
	 * set the moved overlay (only during movements)
	 *
	 * @param {sap.ui.dt.Overlay}
	 *          [oMovedOverlay] overlay which is moved
	 */
	ElementMover.prototype.setMovedOverlay = function(oMovedOverlay) {
		if (oMovedOverlay) {
			this._source = OverlayUtil.getParentInformation(oMovedOverlay);
		} else {
			delete this._source;
		}
		this._oMovedOverlay = oMovedOverlay;
	};

	ElementMover.prototype._getSource = function() {
		return this._source;
	};

	/**
	 * @private
	 */
	ElementMover.prototype.activateAllValidTargetZones = function(oDesignTime, sAdditionalStyleClass) {
		this._iterateAllAggregations(oDesignTime, this._activateValidTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype._activateValidTargetZone = function(oAggregationOverlay, sAdditionalStyleClass) {
		if (this.checkTargetZone(oAggregationOverlay)) {
			oAggregationOverlay.setTargetZone(true);
			if (sAdditionalStyleClass) {
				oAggregationOverlay.addStyleClass(sAdditionalStyleClass);
			}
		}
	};

	/**
	 * @protected
	 */
	ElementMover.prototype.checkTargetZone = function(oAggregationOverlay) {
		if (!oAggregationOverlay.$().is(":visible")) {
			return false;
		}
		var oParentElement = oAggregationOverlay.getElementInstance();
		var oMovedElement = this.getMovedOverlay().getElementInstance();
		var sAggregationName = oAggregationOverlay.getAggregationName();

		if (ElementUtil.isValidForAggregation(oParentElement, sAggregationName, oMovedElement)) {
			return true;
		}
	};

	/**
	 * @private
	 */
	ElementMover.prototype._deactivateTargetZone = function(oAggregationOverlay, sAdditionalStyleClass) {
		oAggregationOverlay.setTargetZone(false);
		if (sAdditionalStyleClass) {
			oAggregationOverlay.removeStyleClass(sAdditionalStyleClass);
		}
	};

	/**
	 * @private
	 */
	ElementMover.prototype.activateTargetZonesFor = function(oOverlay, sAdditionalStyleClass) {
		this._iterateOverlayAggregations(oOverlay, this._activateValidTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype.deactivateTargetZonesFor = function(oOverlay, sAdditionalStyleClass) {
		this._iterateOverlayAggregations(oOverlay, this._deactivateTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype.deactivateAllTargetZones = function(oDesignTime, sAdditionalStyleClass) {
		this._iterateAllAggregations(oDesignTime, this._deactivateTargetZone.bind(this), sAdditionalStyleClass);
	};

	/**
	 * @private
	 */
	ElementMover.prototype._iterateAllAggregations = function(oDesignTime, fnStep, sAdditionalStyleClass) {
		var aOverlays = oDesignTime.getElementOverlays();
		aOverlays.forEach(function(oOverlay) {
			this._iterateOverlayAggregations(oOverlay, fnStep, sAdditionalStyleClass);
		}, this);
	};

	/**
	 * @private
	 */
	ElementMover.prototype._iterateOverlayAggregations = function(oOverlay, fnStep, sAdditionalStyleClass) {
		var aAggregationOverlays = oOverlay.getAggregationOverlays();
		aAggregationOverlays.forEach(function(oAggregationOverlay) {
			fnStep(oAggregationOverlay, sAdditionalStyleClass);
		});
	};

	/**
	 * Move an element inside the same container (reposition).
	 * In case of special handling required (e.g. SimpleForm), the methods "beforeMove" and "afterMove"
	 * are called before and after the reposition. They should be implemented on the control design time
	 * metadata for the relevant aggregation.
	 * @param  {sap.ui.dt.Overlay} oMovedOverlay The overlay of the element being moved
	 * @param  {sap.ui.dt.Overlay} oTargetElementOverlay The overlay of the target element for the move
	 */
	ElementMover.prototype.repositionOn = function(oMovedOverlay, oTargetElementOverlay) {
		var oMovedElement = oMovedOverlay.getElementInstance();
		var oTargetParentInformation = OverlayUtil.getParentInformation(oTargetElementOverlay);
		var oAggregationDesignTimeMetadata;

		var oParentAggregationOverlay = oMovedOverlay.getParentAggregationOverlay();
		var oRelevantContainerElement = oMovedOverlay.getRelevantContainer();
		var oParentElementOverlay = oMovedOverlay.getParentElementOverlay();

		if (oParentAggregationOverlay && oParentElementOverlay) {
			var sAggregationName = oParentAggregationOverlay.getAggregationName();
			oAggregationDesignTimeMetadata = oParentElementOverlay.getDesignTimeMetadata().getAggregation(sAggregationName);
		}

		if (oTargetParentInformation.index !== -1) {
			if (oAggregationDesignTimeMetadata && oAggregationDesignTimeMetadata.beforeMove){
				oAggregationDesignTimeMetadata.beforeMove(oRelevantContainerElement, oMovedElement);
			}
			ElementUtil.insertAggregation(oTargetParentInformation.parent, oTargetParentInformation.aggregation,
				oMovedElement, oTargetParentInformation.index);
			if (oAggregationDesignTimeMetadata && oAggregationDesignTimeMetadata.afterMove){
				oAggregationDesignTimeMetadata.afterMove(oRelevantContainerElement, oMovedElement);
			}
		}
	};

	/**
	 * Insert an element inside another container.
	 * In case of special handling required (e.g. SimpleForm), the methods "beforeMove" and "afterMove"
	 * are called before and after the insertion. They should be implemented on the control design time
	 * metadata for the relevant aggregation.
	 * @param  {sap.ui.dt.Overlay} oMovedOverlay The overlay of the element being moved
	 * @param  {sap.ui.dt.Overlay} oTargetAggregationOverlay The overlay of the target aggregation for the move
	 */
	ElementMover.prototype.insertInto = function(oMovedOverlay, oTargetAggregationOverlay) {
		var oMovedElement = oMovedOverlay.getElementInstance();
		var oTargetParentElement = oTargetAggregationOverlay.getElementInstance();
		var oAggregationDesignTimeMetadata;

		var oParentAggregationOverlay = oMovedOverlay.getParentAggregationOverlay();
		var oRelevantContainerElement = oMovedOverlay.getRelevantContainer();
		var oParentElementOverlay = oMovedOverlay.getParentElementOverlay();

		if (oParentAggregationOverlay && oParentElementOverlay) {
			var sAggregationName = oParentAggregationOverlay.getAggregationName();
			oAggregationDesignTimeMetadata = oParentElementOverlay.getDesignTimeMetadata().getAggregation(sAggregationName);
		}

		var aTargetAggregationItems = ElementUtil.getAggregation(oTargetAggregationOverlay.getElementInstance(), oTargetAggregationOverlay.getAggregationName());
		var iIndex = aTargetAggregationItems.indexOf(oMovedElement);
		// Don't do anything when the element is already in the aggregation and is the last element
		if (!(iIndex > -1 && iIndex === aTargetAggregationItems.length - 1)) {
			if (oAggregationDesignTimeMetadata && oAggregationDesignTimeMetadata.beforeMove){
				oAggregationDesignTimeMetadata.beforeMove(oRelevantContainerElement, oMovedElement);
			}
			var sTargetAggregationName = oTargetAggregationOverlay.getAggregationName();
			ElementUtil.addAggregation(oTargetParentElement, sTargetAggregationName, oMovedElement);
			if (oAggregationDesignTimeMetadata && oAggregationDesignTimeMetadata.afterMove){
				oAggregationDesignTimeMetadata.afterMove(oRelevantContainerElement, oMovedElement);
			}
		}
	};

	ElementMover.prototype._compareSourceAndTarget = function(oSource, oTarget) {
		var vProperty;
		for (vProperty in oSource) {
			switch (typeof (oSource[vProperty])) {
				case 'object':
					if (oSource[vProperty].getId() !== oTarget[vProperty].getId()) {return false;}
					break;
				default:
					if (oSource[vProperty] !== oTarget[vProperty]) {return false;}
			}
		}

		return true;
	};

	return ElementMover;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/ElementMover.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.MouseSelection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.MouseSelection.
jQuery.sap.declare('sap.ui.dt.plugin.MouseSelection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/MouseSelection",[
	'sap/ui/dt/Plugin'
],
function(Plugin) {
	"use strict";

	/**
	 * Constructor for a new MouseSelection.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The MouseSelection allows to select the Overlays with a mouse click
	 * @extends sap.ui.dt.Plugin
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.plugin.MouseSelection
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var MouseSelection = Plugin.extend("sap.ui.dt.plugin.MouseSelection", /** @lends sap.ui.dt.plugin.MouseSelection.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
			},
			associations : {
			},
			events : {
			}
		}
	});

	/*
	 * @private
	 */
	MouseSelection.prototype.init = function() {
		Plugin.prototype.init.apply(this, arguments);
		this._mEventDelegate = {
			"onclick" : this._onClick
		};
	};

	/*
	 * @override
	 */
	MouseSelection.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.setSelectable(true);
		oOverlay.addEventDelegate(this._mEventDelegate, oOverlay);
	};


	//  * @override

	MouseSelection.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.removeEventDelegate(this._mEventDelegate, oOverlay);
	};

	/*
	 * @private
	 */
	 MouseSelection.prototype._onClick = function(oEvent) {
		this.setSelected(!this.getSelected());

		oEvent.preventDefault();
		oEvent.stopPropagation();
	};

	return MouseSelection;
}, /* bExport= */ true);
}; // end of sap/ui/dt/plugin/MouseSelection.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.Element') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.dt.test.Element.
jQuery.sap.declare('sap.ui.dt.test.Element'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/Element",[
	'jquery.sap.global',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayRegistry'
],
function(jQuery, ElementUtil, OverlayRegistry) {
	"use strict";

	/**
	 * Class for Element tests.
	 *
	 * @class
	 * Utility functionality for Element tests
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @private
	 * @static
	 * @since 1.38
	 * @alias sap.ui.dt.test.Element
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */

	var MIN_SIZE = 5;
	var ElementTest = {};


	/**
	 * Returns all design time information of the element
	 * @param  {sap.ui.core.Element} oElement the element to test
	 * @return {map} result object
	 */
	ElementTest.getInfo = function(oElement) {
		var oMetadata = oElement.getMetadata();
		var oElementOverlay = OverlayRegistry.getOverlay(oElement);

		return {
			metadata : oMetadata,
			overlay : oElementOverlay
		};
	};


	/**
	 * Returns all aggregation infos of the element
	 * @param  {sap.ui.core.Element} oElement the element to test
	 * @return {map} result object
	 */
	ElementTest.getAggregationInfo = function(oElement, sAggregationName) {
		var mAggregationTest = {
			ignored : true,
			domRefDeclared : false,
			domRefFound : false,
			domRefVisible : false,
			overlayTooSmall : false,
			overlayGeometryCalculatedByChildren : false,
			overlayVisible : false
		};
		var oDesignTimeMetadata;

		var mElementInfo = this.getInfo(oElement);
		var oAggregationOverlay = mElementInfo.overlay.getAggregationOverlay(sAggregationName);
		if (oAggregationOverlay) {
			oDesignTimeMetadata = oAggregationOverlay.getDesignTimeMetadata();
		}

		if (oDesignTimeMetadata && !oDesignTimeMetadata.isIgnored(oElement)) {
			mAggregationTest.ignored = false;
			mAggregationTest.domRefDeclared = !!oDesignTimeMetadata.getDomRef();
			var oAggregationDomRef = oAggregationOverlay.getAssociatedDomRef();
			if (oAggregationDomRef) {
				mAggregationTest.domRefFound = true;
				mAggregationTest.domRefVisible = jQuery(oAggregationDomRef).is(":visible");
			}

			var mGeometry = oAggregationOverlay.getGeometry();
			if (mGeometry) {
				var mSize = mGeometry.size;
				mAggregationTest.overlayTooSmall = (mSize.width <= MIN_SIZE || mSize.height <= MIN_SIZE);
				mAggregationTest.overlayGeometryCalculatedByChildren = !mGeometry.domRef;
				mAggregationTest.overlayVisible = oAggregationOverlay.$().is(":visible");
			}
		}

		return mAggregationTest;
	};


	/**
	 * Returns all information of all aggregations of the element
	 * @param  {sap.ui.core.Element} oElement the element to test
	 * @return {map} result object
	 */
	ElementTest.getAggregationsInfo = function(oElement) {
		var mAggregationTests = {};

		ElementUtil.iterateOverAllPublicAggregations(oElement, function(oAggregation) {
			mAggregationTests[oAggregation.name] = this.getAggregationInfo(oElement, oAggregation.name);
		}.bind(this));

		return mAggregationTests;
	};

	return ElementTest;
}, /* bExport= */ true);

}; // end of sap/ui/dt/test/Element.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.ElementEnablementTest2') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.ElementEnablementTest.
jQuery.sap.declare('sap.ui.dt.test.ElementEnablementTest2'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.fl.registry.ChangeRegistry'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/ElementEnablementTest2",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject',
	'sap/ui/dt/test/Element',
	'sap/ui/fl/registry/ChangeRegistry'
],
function(jQuery, ManagedObject, ElementTest, ChangeRegistry) {
	"use strict";


	/**
	 * Constructor for an ElementEnablementTest.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementEnablementTest class allows to create a design time test
	 * which tests a given element on compatibility with the sap.ui.dt.DesignTime.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.dt.test.ElementEnablementTest2
	 * @experimental Since 1.48. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementEnablementTest2 = ManagedObject.extend("sap.ui.dt.test.ElementEnablementTest2", /** @lends sap.ui.dt.test.ElementEnablementTest.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				type : {
					type : "string"
				}
			}
		}
	});


	/**
	 * Called when the ElementEnablementTest is initialized
	 * @protected
	 */
	ElementEnablementTest2.prototype.init = function() {

	};


	/**
	 * Called when the ElementEnablementTest is destroyed
	 * @protected
	 */
	ElementEnablementTest2.prototype.exit = function() {

	};


	/**
	 * @return {Promise} A promise providing the test results.
	 * @override
	 */
	ElementEnablementTest2.prototype.run = function() {
		return this._setup().then(function(oData) {

			var sActions;
			this._mResult = {
					name : this.getType(),
					actions : undefined
			};

			if (!this._bError) {
				sActions = this._testActions(oData);
			}

			if (sActions) {
				this._mResult.actions = sActions;
			}

			return this._mResult;
		}.bind(this));
	};


	/**
	 * @private
	 */
	ElementEnablementTest2.prototype._setup = function() {
		window.clearTimeout(this._iTimeout);
		this._bNotSupported = false;
		this._bError = false;

		var oElement = jQuery.sap.getObject(this.getType());
		return oElement.getMetadata().loadDesignTime().catch(function(oError){
			this._bError = true;
		}.bind(this));
	};


	/**
	 * @private
	 */
	ElementEnablementTest2.prototype._testActions = function(oData) {

		var sActionsResult;
		var sPropagate;
		var mActions = [];
		var aActions = [];
		var bActions = false;
		var bAggregations = false;
		var i = 0;

		if (!oData || (!oData.actions && !oData.aggregations)) {
			this._bNotSupported = true;
		} else {
			if (oData.actions) {
				for (var sAction in oData.actions) {
					aActions[i] = sAction;
						mActions[i] = {
							action : sAction,
							aggregation : "self"
						};
					i = i + 1;
				}
				bActions = true;
			}

			if (oData.aggregations) {
				for (var sAggregation in oData.aggregations) {
					var oAggr = oData.aggregations[sAggregation];
					if (oAggr.propagateMetadata) {
						sPropagate = (sPropagate) ? sPropagate + ", " + sAggregation : "propagate (" + sAggregation;
					}
					for (var sAction in oAggr.actions) {
						i = aActions.indexOf(sAction);
						if (i === -1) {
							aActions.push(sAction);
							i = aActions.indexOf(sAction);
							mActions[i] = {
								action : sAction,
								aggregation : sAggregation
							};
						} else {
							mActions[i].aggregation = mActions[i].aggregation + ", " + sAggregation;
						}
						bAggregations = true;
					}
				}
			}

			if (!bActions && !bAggregations) {
				this._bNotSupported = true;
				return sActionsResult;
			}

			mActions.forEach(function(oAction) {
				sActionsResult = (sActionsResult) ? sActionsResult + ", " : "";
				sActionsResult = sActionsResult + oAction.action + " (" + oAction.aggregation + ")";
			});

			if (sPropagate) {
				sPropagate = sPropagate + ")";
				sActionsResult = sActionsResult + " + " + sPropagate;
			}

			return sActionsResult;
		}
	};


	return ElementEnablementTest2;
}, /* bExport= */ true);

}; // end of sap/ui/dt/test/ElementEnablementTest2.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.LibraryEnablementTest2') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.LibraryEnablementTest.
jQuery.sap.declare('sap.ui.dt.test.LibraryEnablementTest2'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/LibraryEnablementTest2",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject',
	'sap/ui/dt/test/ElementEnablementTest2'
],
function(jQuery, ManagedObject, ElementEnablementTest2) {
	"use strict";


	/**
	 * Constructor for a LibraryEnablementTest.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The LibraryEnablementTest class allows to create a design time test
	 * which tests a given library on compatibility with the sap.ui.dt.DesignTime.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.48
	 * @alias sap.ui.dt.test.LibraryEnablementTest2
	 * @experimental Since 1.48. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var LibraryEnablementTest2 = ManagedObject.extend("sap.ui.dt.test.LibraryEnablementTest2", /** @lends sap.ui.dt.test.LibraryEnablementTest2.prototype */ {
	});


	LibraryEnablementTest2.prototype._fillElementArray = function(sType) {
		var oElementTestData = {};
		if (["sap.ui.richtexteditor.RichTextEditor",
				 "sap.ui.ux3.QuickView",
				 "sap.uiext.inbox.SubstitutionRulesManager",
				 "sap.ui.codeeditor.CodeEditor"].indexOf(sType) === -1) {
			oElementTestData.type = sType;
			this.aElementEnablementTest.push(new ElementEnablementTest2(oElementTestData));
		}
	};


	/**
	 * @return {Promise} A promise providing the test results.
	 * @override
	 */
	LibraryEnablementTest2.prototype.run = function(aLibraries) {
		this._aResult = [];

		this.aElementEnablementTest = [];
		var aLibraryControls = [];
		this._aControlsCollection = [];

		if (aLibraries.length === 0) {
			var oVersionInfo = sap.ui.getVersionInfo();
			oVersionInfo.libraries.forEach(function(oLib) {
				if (oLib.name.indexOf("sap.ui.server") === -1 &&
						oLib.name.indexOf("themelib_") === -1 &&
						oLib.name.indexOf("sap.ui.dev") === -1 &&
						oLib.name !== "sap.ui.core" &&
						oLib.name !== "sap.ui.fl") {
					sap.ui.getCore().loadLibrary(oLib.name);
				}
			});
		} else {
			aLibraries.forEach(function(sLib) {
				sap.ui.getCore().loadLibrary(sLib);
			});
		}

		var oLoadedLibs = sap.ui.getCore().getLoadedLibraries();
		for (var sLibraryName in oLoadedLibs) {
			if (aLibraries.length > 0 && aLibraries.indexOf(sLibraryName) === -1) {
				continue;
			}
			var oLib = sap.ui.getCore().getLoadedLibraries()[sLibraryName];
			if (oLib && sLibraryName !== "sap.ui.core") {
				var aLibraryControls = oLib.controls;
				var aLibraryElements = oLib.elements;
				var aAllControls = aLibraryControls.concat(aLibraryElements).sort();
				aAllControls.forEach(this._fillElementArray, this);
			}
		}

		var aResults = [];
		var fnIterate = function(mResult) {
			if (mResult && mResult.actions) {
				aResults.push(mResult);
			}
			var oElementEnablementTest = this.aElementEnablementTest.shift();
			if (oElementEnablementTest) {
				return oElementEnablementTest.run().then(function(mResult) {
					oElementEnablementTest.destroy();
					return fnIterate(mResult);
				});
			} else {
				return Promise.resolve(aResults);
			}
		}.bind(this);


		return fnIterate().then(function(aResults) {
			var mResult = {
					results : []
			};

			aResults.forEach(function(mElementTestResult) {
				mResult.results.push(mElementTestResult);
			});


			return mResult;
		});


	};

	return LibraryEnablementTest2;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/LibraryEnablementTest2.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.Test') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.Test.
jQuery.sap.declare('sap.ui.dt.test.Test'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/Test",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject'
],
function(jQuery, ManagedObject) {
	"use strict";

	/**
	 * Constructor for a Test.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Test class allows to create design time tests.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.Test
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Test = ManagedObject.extend("sap.ui.dt.test.Test", /** @lends sap.ui.dt.test.Test.prototype */ {
		metadata : {
			"abstract" : true
		}
	});

	/**
	 * @type {map} Status Enum. Provides all availabe status.
	 * @static
	 */
	Test.STATUS = {
		"SUPPORTED" : {
			key: "SUPPORTED",
			text: "supported",
			value: 3
		},
		"PARTIAL_SUPPORTED" : {
			key: "PARTIAL_SUPPORTED",
			text: "partial supported",
			value: 2
		},
		"NOT_SUPPORTED" : {
			key: "NOT_SUPPORTED",
			text: "not supported",
			value: 1
		},
		"ERROR" : {
			key: "ERROR",
			text: "error",
			value: 0
		},
		"UNKNOWN" : {
			key: "UNKNOWN",
			text: "unknown",
			value: 0
		}
	};

	/**
	 * @type {map} Type Enum. Provides all availabe types.
	 * @static
	 */
	Test.TYPE = {
		"TEST" : "Test",
		"GROUP" : "Group",
		"SUITE" : "Suite"
	};


	/**
	 * Creates a new suite and returns it.
	 *
	 * @param {string} sName The name of the suite.
	 * @param {string} sMessage A message to display
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.createSuite = function(sName, sMessage) {
		return this.add(
			null,
			false,
			sName,
			sMessage,
			null,
			Test.TYPE.SUITE
		);
	};


	/**
	 * Adds a new group to an array.
	 *
	 * @param {object[]} aParentChildren the array to insert the group
	 * @param {string} sName The name of the group.
	 * @param {string} sMessage A message to display
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.addGroup = function(aParentChildren, sName, sMessage, sNamePostfix) {
		return this.add(aParentChildren,
			true,
			sName + (sNamePostfix ? (" (" + sNamePostfix + ")") : ""),
			sMessage,
			null,
			Test.TYPE.GROUP
		);
	};


	/**
	 * Adds a new test to an array.
	 *
	 * @param {object[]} aParentChildren the array to insert the test
	 * @param {boolean} bResult The result of the test.
	 * @param {string} sName The name of the test.
	 * @param {string} sMessage A message to display
	 * @param {map} status The status of the test.
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.addTest = function(aParentChildren, bResult, sName, sMessage, mStatus) {
		return this.add(aParentChildren,
			bResult,
			sName,
			sMessage,
			mStatus,
			Test.TYPE.TEST
		);
	};


	/**
	 * Adds a new entry to an array.
	 *
	 * @param {object[]} aParentChildren the array to insert the entry
	 * @param {boolean} bResult The result of the entry.
	 * @param {string} sName The name of the entry.
	 * @param {string} sMessage A message to display
	 * @param {map} mStatus The status of the entry.
	 * @param {string} sType The type of the entry.
	 * @return {map} the entry object
	 *
	 * @protected
	 */
	Test.prototype.add = function(aParentChildren, bResult, sName, sMessage, mStatus, sType) {

		if (!mStatus) {
			if (bResult) {
				mStatus = Test.STATUS.SUPPORTED;
			} else {
				mStatus = Test.STATUS.NOT_SUPPORTED;
			}
		}

		var mEntry = {
			name : sName,
			message : sMessage,
			result : bResult,
			status : mStatus,
			type : sType,
			statistic : {},
			children : []
		};

		if (aParentChildren) {
			aParentChildren.push(mEntry);
		}

		return mEntry;
	};


	/**
	 * Runs the tests.
	 *
	 * @public
	 */
	Test.prototype.run = function() {
		throw new Error("Abstract method");
	};


	/**
	 * Aggregates the tests results.
	 * @return {map} the aggregated result
	 *
	 * @protected
	 */
	Test.prototype.aggregate = function(mResult) {
		if (mResult.type != Test.TYPE.TEST && mResult.children.length > 0) {
			var aChildren = mResult.children;

			var aMappedResult = aChildren.map(function(mEntry) {
				var mChildResult = this.aggregate(mEntry);
				return {
					result : mChildResult.result,
					status : mChildResult.status
				};
			}, this);

			if (aMappedResult.length == 1) {
				aMappedResult.push(aMappedResult[0]);
			}

			var mReducedResult = aMappedResult.reduce(function(mPreviousValue, mCurrentValue) {
				return {
					result : this._getResult(mPreviousValue, mCurrentValue),
					status : this._getStatus(mPreviousValue, mCurrentValue),
					statistic : this._getStatistic(mPreviousValue, mCurrentValue)
				};
			}.bind(this));


			mResult.result = mReducedResult.result;
			mResult.status = mReducedResult.status;
			mResult.statistic = mReducedResult.statistic;
		}

		return mResult;
	};


	/**
	 * @private
	 */
	Test.prototype._getResult = function(mPreviousValue, mCurrentValue) {
		return !mPreviousValue.result ? false : mCurrentValue.result;
	};


	/**
	 * @private
	 */
	Test.prototype._getStatus = function(mPreviousValue, mCurrentValue) {
		return mPreviousValue.status.value < mCurrentValue.status.value ? mPreviousValue.status : mCurrentValue.status;
	};

	/**
	 * @private
	 */
	Test.prototype._getStatistic = function(mPreviousValue, mCurrentValue) {
		var mStatistic = this._getStatisticObjectForEntry(mPreviousValue);
		if (mPreviousValue !== mCurrentValue) {
			mStatistic[mCurrentValue.status.key]++;
		}
		return mStatistic;
	};


	/**
	 * @private
	 */
	Test.prototype._getStatisticObjectForEntry = function(mEntry) {
		var mStatistic = {};

		if (!mEntry.statistic) {
			for (var sStatus in Test.STATUS) {
				mStatistic[sStatus] = 0;
			}
			mStatistic[mEntry.status.key]++;
		} else {
			mStatistic = mEntry.statistic;
		}

		return mStatistic;
	};

	return Test;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/Test.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.QUnit') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* global QUnit, assert */

// Provides class sap.ui.dt.test.qunit.QUnit.
jQuery.sap.declare('sap.ui.dt.test.report.QUnit'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/QUnit",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject'
],
function(jQuery, ManagedObject) {
	"use strict";


	/**
	 * Constructor for a QUnit.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The QUnit report can be used to run qunit tests based on the design time test results.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.report.QUnit
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var QUnitReport = ManagedObject.extend("sap.ui.dt.test.report.QUnit", /** @lends sap.ui.dt.test.report.QUnit.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				data : {
					type : "object"
				}
			}
		},



		/**
		 * Called when the QUnit is initialized
		 * @protected
		 */
		init : function() {
			if (!QUnit) {
				throw new Error("QUnit is required for this report.");
			}
		},


		/**
		 * Sets the data to use as a base for the QUnit tests.
		 * @param {object} oData the data to display
		 *
		 * @public
		 */
		setData : function(oData) {
			if (oData) {
				var aChildren = oData.children;
				aChildren.forEach(function(oGroup) {
					this._createModule(oGroup);
				}, this);
			}
			this.setProperty("data", oData);
		},


		/**
		 * @private
		 */
		_createModule : function(oGroup) {
			QUnit.module(oGroup.message);
			oGroup.children.forEach(function(oGroup) {
				this._createTest(oGroup);
			}, this);
		},


		/**
		 * @private
		 */
		_createTest : function(oGroup) {
			QUnit.test(oGroup.name + ": " + oGroup.message, function(assert) {
				oGroup.children.forEach(function(oGroup) {
					this._createAssertion(oGroup);
				}, this);
			}.bind(this));
		},


		/**
		 * @private
		 */
		_createAssertion : function(oGroup) {
			if (oGroup.children.length > 0) {
				oGroup.children.forEach(function(oTest) {
					assert.ok(oTest.result, oGroup.name + ": " + oTest.message);
				});
			} else {
				assert.ok(true, oGroup.name + ": " + oGroup.message);
			}
		}
	});

	return QUnitReport;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/report/QUnit.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.Statistic') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.dt.test.report.Statistic.
jQuery.sap.declare('sap.ui.dt.test.report.Statistic'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.layout.form.SimpleForm'); // unlisted dependency retained
jQuery.sap.require('sap.m.Label'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/Statistic",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/model/json/JSONModel', 'sap/ui/layout/form/SimpleForm', "sap/m/Label", "sap/m/Text"],
	function(jQuery, Control, JSONModel, SimpleForm, Label, Text) {
	"use strict";



	/**
	 * Constructor for a new Statistic report.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Statistic report can be used to visualize the design time tests.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.report.Statistic
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var oStatistic = Control.extend("sap.ui.dt.test.report.Statistic", /** @lends sap.ui.dt.test.report.Statistic.prototype */ { metadata : {
		properties : {
			data : {
				type : "object"
			}
		},
		aggregations : {
			"_form" : {
				type : "sap.ui.layout.form.SimpleForm",
				hidden : true,
				multiple : false
			}
		}
	},


	init : function() {
		this._oModel = null;
		this.setAggregation("_form", this._createForm());
	},

	/**
	 * Called when the Statistic is destroyed
	 * @protected
	 */
	exit : function() {
		this.setData(null);
	},

	setData : function(oData) {
		if (this._oModel) {
			this._oModel.destroy();
			delete this._oModel;
		}
		if (oData) {
			this._oModel = new JSONModel(oData);
			this._getForm().setModel(this._oModel);
		} else {
			this._getForm().setModel(null);
		}
		this.setProperty("data", oData);
	},


	_createForm : function() {
		var oForm = new sap.ui.layout.form.SimpleForm(this.getId() + "--form", {
			editable : false,
			title : "Statistics",
			content : [
				new Label(this.getId() + "--form-supported-label", {text: "Supported"}),
				new Text(this.getId() + "--form-supported-value", {text: "{/statistic/SUPPORTED}"}),
				new Label(this.getId() + "--form-partial-supported-label", {text: "Partial Supported"}),
				new Text(this.getId() + "--form-partial-supported-value", {text: "{/statistic/PARTIAL_SUPPORTED}"}),
				new Label(this.getId() + "--form-not-supported-label", {text: "Not Supported"}),
				new Text(this.getId() + "--form-not-supported-value", {text: "{/statistic/NOT_SUPPORTED}"}),
				new Label(this.getId() + "--form-unknown-label", {text: "Unknown"}),
				new Text(this.getId() + "--form-unknown-value", {text: "{/statistic/UNKNOWN}"}),
				new Label(this.getId() + "--form-error-label", {text: "Error"}),
				new Text(this.getId() + "--form-error-value", {text: "{/statistic/ERROR}"})
			]
		});
		return oForm;
	},

	_getForm : function() {
		return this.getAggregation("_form");
	}
});

	return oStatistic;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/Statistic.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.StatisticRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.test.report.Statistic
jQuery.sap.declare('sap.ui.dt.test.report.StatisticRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/StatisticRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.50.6
	 * @namespace
	 */
	var StatisticRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oStatistic An object representation of the control that should be rendered.
	 */
	StatisticRenderer.render = function(rm, oStatistic) {
		rm.addClass("sapUiDtStatisticReport");

		rm.write("<div");
		rm.writeControlData(oStatistic);

		rm.writeStyles();

		rm.writeClasses();

		rm.write(">");

		rm.renderControl(oStatistic._getForm());

		rm.write("</div>");
	};

	return StatisticRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/StatisticRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.Table') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.dt.test.report.Table.
jQuery.sap.declare('sap.ui.dt.test.report.Table'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.table.TreeTable'); // unlisted dependency retained
jQuery.sap.require('sap.ui.table.Column'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.Title'); // unlisted dependency retained
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
jQuery.sap.require('sap.m.RatingIndicator'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/Table",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/model/json/JSONModel', 'sap/ui/table/TreeTable', 'sap/ui/table/Column', 'sap/m/Toolbar', 'sap/m/Title', 'sap/m/ToolbarSpacer', 'sap/m/Button', 'sap/m/SearchField', 'sap/m/Text', 'sap/m/RatingIndicator', 'sap/ui/model/Filter', 'sap/ui/model/FilterOperator'],
	function(jQuery, Control, JSONModel, TreeTable, Column, Toolbar, Title, ToolbarSpacer, Button, SearchField, Text, RatingIndicator, Filter, FilterOperator) {
	"use strict";



	/**
	 * Constructor for a new Table report.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The table report can be used to visualize the design time tests.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.report.Table
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var oTable = Control.extend("sap.ui.dt.test.report.Table", /** @lends sap.ui.dt.test.report.Table.prototype */ { metadata : {
		properties : {
			data : {
				type : "object"
			}
		},
		aggregations : {
			"_table" : {
				type : "sap.ui.table.TreeTable",
				hidden : true,
				multiple : false
			}
		}
	},


	/**
	 * Called when the Table is initialized
	 * @protected
	 */
	init : function() {
		this.setAggregation("_table", this._createTable());
	},


	/**
	 * Called when the Table is destroyed
	 * @protected
	 */
	exit : function() {
		clearTimeout(this._iFilterTimeout);
		this.setData(null);
	},


	/**
	 * Sets the data to display in the table
	 * @param {object} oData the data to display
	 *
	 * @public
	 */
	setData : function(oData) {
		if (this._oModel) {
			this._oModel.destroy();
			delete this._oModel;
		}
		if (oData) {
			this._oModel = new JSONModel(oData);
			this._getTable().setModel(this._oModel);
		} else {
			this._getTable().setModel(null);
		}
		this.setProperty("data", oData);
	},


	/**
	 * Filters the table.
	 *
	 * @param  {sString} sFilter The filter string.
	 *
	 * @public
	 */
	filter : function(sFilter) {
		var oModel = this._getTable().getModel();
		if (oModel) {
			if (sFilter.length > 0) {
				// As UI5 does not support filtering on first level, we have to do it on our own
				var aData = this.getData();
				var aFilteredData = aData.children.filter(function(oEntry) {

					if (sFilter.indexOf("status=") != -1) {
						return oEntry.status.value == sFilter.substring(sFilter.indexOf("=") + 1);
					} else {
						return oEntry.name.toLowerCase().indexOf(sFilter.toLowerCase()) != -1;
					}
				});
				oModel.setData(aFilteredData);
			} else {
				oModel.setData(this.getData());
			}
		}
	},


	/**
	 * @private
	 */
	_createTable : function() {
		var oTable = new TreeTable(this.getId() + "--table", {
			selectionMode : "MultiToggle",
			visibleRowCount: 20,
			enableSelectAll : false,
			ariaLabelledBy : "title",
			toolbar : this._createToolbar(),
			rows : "{path:'/', parameters: {arrayNames:['children']}}",
			columns : [
				this._createTextColumn("name", "Name", "{name}"),
				this._createRatingIndicatorColumn("value", "Status Values", "{status/value}", "{status/text} ({status/value})"),
				this._createTextColumn("status", "Status", "{status/text}"),
				this._createTextColumn("message", "Message", "{message}")
			]
		});

		return oTable;
	},


	/**
	 * @private
	 */
	_createToolbar : function() {
		return new Toolbar(this.getId() + "--toolbar", {
			content : [
				new ToolbarSpacer(this.getId() + "--toolbar-spacer"),
				new Button(this.getId() + "--toolbar-collapse-button", {
					text : "Collapse all",
					press : this._onCollapseAll.bind(this)
				}),
				new Button(this.getId() + "--toolbar-expand-button", {
					text : "Expand",
					press : this._onExpandSecondLevel.bind(this)
				}),
				new SearchField(this.getId() + "--toolbar-search-field", {
					liveChange:this._onSearch.bind(this)
				})
			]
		});
	},


	/**
	 * @private
	 */
	_onSearch : function(oEvt) {
		var sFilter = oEvt.getParameter('newValue');
		clearTimeout(this._iFilterTimeout);
		this._iFilterTimeout = setTimeout(function() {
			this.filter(sFilter);
		}.bind(this),100);
	},


	/**
	 * @private
	 */
	_createTextColumn : function(sId, sColumnText, sRowText) {
		return this._createColumn(sId, sColumnText,
			new Text({
				text : sRowText
			})
		);
	},


	/**
	 * @private
	 */
	_createRatingIndicatorColumn : function(sId, sColumnText, sRowText, sTooltip) {
		return this._createColumn(sId, sColumnText,
			new RatingIndicator({
				maxValue : 3,
				value : sRowText,
				enabled : false,
				tooltip : sTooltip
			})
		);
	},


	/**
	 * @private
	 */
	_createColumn : function(sId, sColumnText, oTemplate) {
		return new Column(this.getId() + "--table-column-" + sId, {
			label : sColumnText,
			width : "13em",
			template : oTemplate
		});
	},


	/**
	 * @private
	 */
	_getTable : function() {
		return this.getAggregation("_table");
	},


	/**
	 * @private
	 */
	_onCollapseAll : function(oEvt) {
		var oTable = this._getTable();
		oTable.collapseAll();
	},


	/**
	 * @private
	 */
	_onExpandSecondLevel : function(oEvt) {
		var oTable = this._getTable();
		oTable.expandToLevel(2);
	}
});

	return oTable;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/Table.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.report.TableRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.test.report.Table
jQuery.sap.declare('sap.ui.dt.test.report.TableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/report/TableRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.50.6
	 * @namespace
	 */
	var TableRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.core.Control} oTable An object representation of the control that should be rendered.
	 */
	TableRenderer.render = function(rm, oTable) {
		rm.addClass("sapUiDtTableReport");

		rm.write("<div");
		rm.writeControlData(oTable);

		rm.writeStyles();

		rm.writeClasses();

		rm.write(">");

		rm.renderControl(oTable._getTable());

		rm.write("</div>");
	};

	return TableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/test/report/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.AggregationOverlayRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.AggregationOverlay
jQuery.sap.declare('sap.ui.dt.AggregationOverlayRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/AggregationOverlayRenderer",['sap/ui/dt/RenderingUtil'],
	function(RenderingUtil) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.50.6
	 * @namespace
	 */
	var AggregationOverlayRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay An object representation of the control that should be rendered.
	 * @protected
	 */
	AggregationOverlayRenderer.render = function(oRm, oAggregationOverlay) {
		RenderingUtil.renderOverlay(oRm, oAggregationOverlay, "sapUiDtAggregationOverlay");
	};

	return AggregationOverlayRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/AggregationOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ContextMenuControl') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/* global Promise */
// Provides control sap.ui.rta.ContextMenuControl.
jQuery.sap.declare('sap.ui.dt.ContextMenuControl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ContextMenuControl",[
	'jquery.sap.global', './library', 'sap/ui/unified/Menu', 'sap/ui/unified/MenuItem'
], function(jQuery, library, Menu, MenuItem) {
	"use strict";

	/**
	 * Constructor for a new sap.ui.dt.ContextMenuControl control.
	 *
	 * @class Context - Menu for Design time
	 * @extends sap.ui.unified.Menu
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.ContextMenuControl
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ContextMenuControl = Menu.extend("sap.ui.dt.ContextMenuControl", {
		metadata: {
			library: "sap.ui.dt",
			properties: {},
			associations: {},
			events: {}
		},
		renderer: {}
	// Standard renderer method is not overridden
	});

	/**
	 * Initialize the context menu
	 *
	 * @private
	 */
	ContextMenuControl.prototype.init = function() {
		Menu.prototype.init.apply(this, arguments);
		this.addStyleClass("sapUiDtContextMenu");
		this._fnOnKeyDown = this._onKeyDown.bind(this);
		jQuery(document).keydown(this._fnOnKeyDown);
		this.attachBrowserEvent("contextmenu", this._onContextMenu, this);
		this._oOverlayDomRef = document.body;
	};

	/**
	 * Exit method. Called when the object gets destroyed
	 */
	ContextMenuControl.prototype.exit = function() {
		Menu.prototype.exit.apply(this, arguments);
		jQuery(document).off("keydown", this._fnOnKeyDown);
		delete this._fnOnKeyDown;
		this.detachBrowserEvent("contextmenu");
	};

	/**
	 * Set overlay which invoked the context menu
	 *
	 * @param {sap.ui.core.Element} oOverlay variable object instance of the overlay
	 */
	ContextMenuControl.prototype.setOverlayDomRef = function(oOverlay) {
		this._oOverlayDomRef = oOverlay.getDomRef();
	};

	/**
	 * Creates the context menu items based on the currently associated element
	 *
	 * @param {array} aMenuItems array with menu item settings
	 * @param {string} aMenuItems.id id, which corresponds to the text key
	 * @param {string} aMenuItems.text menu item text (translated)
	 * @param {function} aMenuItems.handler event handler if menu is selected, the element for which the menu was opened is passed to the handler
	 * @param {boolean|function} aMenuItems.startSection?, default false
	 * @param {function} aMenuItems.available? function to determine if the menu entry should be shown, the element for which the menu should be
	 *        opened is passed, default true
	 * @param {function} aMenuItems.enabled? function to determine if the menu entry should be enabled, the element for which the menu should be
	 *        opened is passed, default true
	 * @param {object} oTargetOverlay overlay for which the menu should be opened
	 * @private
	 */
	ContextMenuControl.prototype.setMenuItems = function(aMenuItems, oTargetOverlay) {
		this.destroyItems();

		aMenuItems.forEach(function(oItem) {
			if (!oItem.available || oItem.available(oTargetOverlay)) {
				var bEnabled = !oItem.enabled || oItem.enabled(oTargetOverlay);

				var sText = oItem.text;
				if (typeof oItem.text === "function") {
					sText = oItem.text(oTargetOverlay);
				}

				var oMenuItem = new MenuItem({
					text: sText,
					enabled: bEnabled
				});
				oMenuItem.data({
					id: oItem.id
				});
				if ((oItem.startSection && typeof (oItem.startSection) === "boolean" ) || (typeof (oItem.startSection) === "function" && oItem.startSection(oTargetOverlay.getElementInstance()))) {
					oMenuItem.setStartsSection(true);
				}
				this.addItem(oMenuItem);
			}
		}, this);
		return this;
	};

	/**
	 * Handler Method for event open menu
	 *
	 * @param {object} oOriginalEvent Original Event invoking Context menu
	 * @param {object} oTargetOverlay Overlay invoking the context menu
	 */
	ContextMenuControl.prototype.openMenu = function(oOriginalEvent, oTargetOverlay) {
		// first check if there are some context menu entries
		if (this.getItems().length === 0 || !oTargetOverlay.getDomRef()) {
			return;
		}
		this.openAsContextMenu(oOriginalEvent, oTargetOverlay);
	};

	/**
	 * Handle keydown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenuControl.prototype._onKeyDown = function(oEvent) {
		if (!this.bOpen) {
			jQuery(document).off("keydown", this._fnOnKeyDown);
			delete this._fnOnKeyDown;
			return;
		}
		if ((oEvent.keyCode === jQuery.sap.KeyCodes.F10) && (oEvent.shiftKey === true) && (oEvent.altKey === false) && (oEvent.ctrlKey === false)) {
			oEvent.preventDefault();
		}
	};

	/**
	 * Handle Context Menu
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenuControl.prototype._onContextMenu = function(oEvent) {
		if (!this.bOpen) {
			this.detachBrowserEvent("contextmenu");
			return;
		}
		if (oEvent.preventDefault) {
			oEvent.preventDefault();
		}
	};

	return ContextMenuControl;

}, /* bExport= */true);

}; // end of sap/ui/dt/ContextMenuControl.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ControlObserver') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ControlObserver.
jQuery.sap.declare('sap.ui.dt.ControlObserver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ControlObserver",[
	'jquery.sap.global',
	'sap/ui/dt/ManagedObjectObserver'
],
function(jQuery, ManagedObjectObserver) {
	"use strict";


	/**
	 * Constructor for a new ControlObserver.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ControlObserver observs changes of a control and propagates them via events.
	 * @extends sap.ui.dt.ManagedObjectObserver
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ControlObserver
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ControlObserver = ManagedObjectObserver.extend("sap.ui.dt.ControlObserver", /** @lends sap.ui.dt.ControlObserver.prototype */ {
		metadata : {

			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {

			},
			associations : {
				/**
				 * target Control to observe
				 */
				"target" : {
					"type" : "sap.ui.core.Control"
				}
			},
			/**
			 * Fired when the DOM of the observed control is changed
			 */
			events : {
				"afterRendering" : {}
			}
		}
	});

	/**
	 * @protected
	 */
	ControlObserver.prototype.init = function() {
		ManagedObjectObserver.prototype.init.apply(this, arguments);

		this._oControlDelegate = {
			onAfterRendering : this._onAfterRendering
		};
	};

	/**
	 * Starts observing the target control.
	 * @param {sap.ui.core.Control} oControl The target to observe
	 * @override
	 */
	ControlObserver.prototype.observe = function(oControl) {
		ManagedObjectObserver.prototype.observe.apply(this, arguments);

		oControl.addEventDelegate(this._oControlDelegate, this);
	};

	/**
	 * Stops observing the target control.
	 * @param {sap.ui.core.Control} oControl The target to unobserve
	 * @override
	 */
	ControlObserver.prototype.unobserve = function() {
		var oControl = this.getTargetInstance();
		if (oControl) {
			oControl.removeDelegate(this._oControlDelegate, this);
		}

		ManagedObjectObserver.prototype.unobserve.apply(this, arguments);
	};

	/**
	 * @private
	 */
	ControlObserver.prototype._onAfterRendering = function() {
		this.fireAfterRendering();

	};

	return ControlObserver;
}, /* bExport= */ true);
}; // end of sap/ui/dt/ControlObserver.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.DesignTimeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.DesignTimeMetadata.
jQuery.sap.declare('sap.ui.dt.DesignTimeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/DesignTimeMetadata",[
	'jquery.sap.global',
	'sap/ui/base/ManagedObject',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/DOMUtil'
],
function(jQuery, ManagedObject, ElementUtil, DOMUtil) {
	"use strict";


	/**
	 * Constructor for a new DesignTimeMetadata.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DesignTimeMetadata is a wrapper for the DesignTimeMetadata of the associated element
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.DesignTimeMetadata
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DesignTimeMetadata = ManagedObject.extend("sap.ui.dt.DesignTimeMetadata", /** @lends sap.ui.dt.DesignTimeMetadata.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Data to be used as DT metadata
				 */
				data : {
					type : "any"
				},
				/**
				* Name of the library the control belongs to
				*/
				libraryName : "string"
			}
		}
	});

	/**
	 * Sets the data as DT metadata, uses default settings, if some fields are not defined in oData
	 * @param {object} oData to set
	 * @return {sap.ui.dt.DesignTimeMetadata} returns this
	 * @protected
	 */
	DesignTimeMetadata.prototype.setData = function(oData) {

		var oMergedData = jQuery.extend(true, this.getDefaultData(), oData || {});

		this.setProperty("data", oMergedData);
		return this;
	};

	/**
	 * Returns data, if no data is set, creates a default data
	 * @return {object} returns data
	 * @public
	 */
	DesignTimeMetadata.prototype.getData = function() {
		var oData = this.getProperty("data");
		if (!oData) {
			this.setData({});
			oData = this.getProperty("data");
		}

		return oData;
	};

	/**
	 * Returns the default DT metadata
	 * @return {Object} default data
	 * @protected
	 */
	DesignTimeMetadata.prototype.getDefaultData = function() {
		return {
			ignore : false,
			domRef : undefined,
			cloneDomRef : false
		};
	};

	/**
	 * Returns property "ignore" of the DT metadata
	 * @param {Object} oElement Element instance
	 * @return {boolean} if ignored
	 * @public
	 */
	DesignTimeMetadata.prototype.isIgnored = function(oElement) {
		var vIgnore = this.getData().ignore;
		if (!vIgnore || (vIgnore && typeof vIgnore === "function" && !vIgnore(oElement))) {
			return false;
		} else {
			return true;
		}
	};

	/**
	 * Returns property "copyDom" of the DT metadata
	 * @return {boolean} if overlay should copy the DOM of its associated element
	 * @public
	 */
	DesignTimeMetadata.prototype.getCloneDomRef = function() {
		return this.getData().cloneDomRef;
	};

	/**
	 * Returns property "domRef" of the DT metadata
	 * @return {string|Element} Returns reference to the relevant DOM element or its selector
	 * @public
	 */
	DesignTimeMetadata.prototype.getDomRef = function() {
		return this.getData().domRef;
	};


	/**
	 * Returns a DOM representation for an Element or aggregation, if it can be found or undefined
	 * @param {Object} oElement Element we need DomRef for
	 * @param {String|Function} vDomRef Selector or Function for fetchting DomRef
	 * @param {String} sAggregationName Aggregation Name
	 * @return {jQuery} Returns associated DOM references wrapped by jQuery object
	 * @public
	 */
	DesignTimeMetadata.prototype.getAssociatedDomRef = function(oElement, vDomRef, sAggregationName) {
		var oElementDomRef = ElementUtil.getDomRef(oElement);
		var aArguments = [];
		aArguments.push(oElement);
		if (sAggregationName) {
			aArguments.push(sAggregationName);
		}

		if (typeof (vDomRef) === "function") {
			var vRes = vDomRef.apply(null, aArguments);

			return vRes ? jQuery(vRes) : vRes;
		} else if (oElementDomRef && typeof (vDomRef) === "string") {
			return DOMUtil.getDomRefForCSSSelector(oElementDomRef, vDomRef);
		}
	};

	/**
	 * Returns action sAction part of designTime metadata (object or changeType string)
	 * @param  {string} sAction action name
	 * @param  {object} oElement element instance
	 * @return {map} part of designTimeMetada, which describes sAction in a map format
	 * @public
	 */
	DesignTimeMetadata.prototype.getAction = function(sAction, oElement) {
		var mData = this.getData();
		if (mData.actions && mData.actions[sAction]) {
			var vAction = mData.actions[sAction];
			if (typeof (vAction) === "function" ) {
				vAction = vAction.call(null, oElement);
			}

			if (typeof (vAction) === "string" ) {
				return { changeType : vAction };
			} else {
				return vAction;
			}
		}
	};

	/**
	 * Returns a locale-specific string value for the given key sKey.
	 *
	 * The text is searched in this resource bundle according to the fallback chain described in
	 * {@link jQuery.sap.util.ResourceBundle}. If no text could be found, the key itself is used as text.
	 *
	 * If text parameters are given, then any occurrences of the pattern "{<i>n</i>}" with <i>n</i> being an integer
	 * are replaced by the parameter value with index <i>n</i>.  Note: This replacement is also applied if no text had been found (key).
	 * For more details on this replacement mechanism refer also:
	 * @see jQuery.sap.formatMessage
	 *
	 * @param {string} sKey Key
	 * @param {string[]} [aArgs] List of parameters which should replace the place holders "{n}" (n is the index) in the found locale-specific string value.
	 * @return {string} The value belonging to the key, if found; otherwise the key itself.
	 *
	 * @function
	 * @public
	 */
	DesignTimeMetadata.prototype.getLibraryText = function(sKey, aArgs) {
		var oLibResourceBundle = sap.ui.getCore().getLibraryResourceBundle(this.getLibraryName());
		return oLibResourceBundle.getText(sKey, aArgs);
	};

	/**
	 * Returns all available triggers from designtime metadata
	 * @return {Array.<Object>} array of available triggers
	 * @public
	 */
	DesignTimeMetadata.prototype.getTriggers = function() {
		var mData = this.getData();
		var aTriggers = [];

		if (mData && Array.isArray(mData.triggers)) {
			aTriggers = mData.triggers;
		}

		return aTriggers;
	};

	return DesignTimeMetadata;
}, /* bExport= */ true);

}; // end of sap/ui/dt/DesignTimeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementOverlayRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.dt.Overlay
jQuery.sap.declare('sap.ui.dt.ElementOverlayRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/ElementOverlayRenderer",['sap/ui/dt/RenderingUtil'],
	function(RenderingUtil) {
	"use strict";


	/**
	 * @author SAP SE
	 * @version 1.50.6
	 * @namespace
	 */
	var OverlayRenderer = {
	};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 * @param {sap.ui.core.RenderManager} oRm The RenderManager that can be used for writing to the render output buffer.
	 * @param {sap.ui.dt.Overlay} oOverlay An object representation of the control that should be rendered.
	 * @protected
	 */
	OverlayRenderer.render = function(oRm, oOverlay) {
		RenderingUtil.renderOverlay(oRm, oOverlay, "sapUiDtElementOverlay");
	};

	return OverlayRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/dt/ElementOverlayRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.MutationObserver') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.MutationObserver.
jQuery.sap.declare('sap.ui.dt.MutationObserver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/MutationObserver",[
	'jquery.sap.global',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/ElementUtil',
	'sap/ui/base/ManagedObject'
], function(jQuery, OverlayUtil, ElementUtil, ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new MutationObserver.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The MutationObserver observes changes of a ManagedObject and propagates them via events.
	 * @extends sap.ui.base.ManagedObject
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.MutationObserver
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be modified in future.
	 */
	var MutationObserver = ManagedObject.extend("sap.ui.dt.MutationObserver", /** @lends sap.ui.dt.MutationObserver.prototype */
	{
		metadata: {
			library: "sap.ui.dt",
			events: {
				/**
				 * Event fired when the observed object is modified or some changes which might affect dom position and styling of overlays happens
				 */
				domChanged: {
					parameters : {
						type : { type : "string" },
						elemenIds : { type : "string[]"},
						targetNodes : { type : "element[]" }
					}
				}
			}
		}
	});

	/**
	 * Called when the MutationObserver is created
	 *
	 * @protected
	 */
	MutationObserver.prototype.init = function() {
		this._fnFireDomChanged = function() {
			this.fireDomChanged();
		}.bind(this);
		this._onScroll = this._fireDomChangeOnScroll.bind(this);

		this._startMutationObserver();

		// after CSS transition / animation ends, domChanged event is triggered
		window.addEventListener("transitionend", this._fnFireDomChanged, true);
		window.addEventListener("webkitTransitionEnd", this._fnFireDomChanged, true);
		window.addEventListener("otransitionend", this._fnFireDomChanged, true);
		window.addEventListener("animationend", this._fnFireDomChanged, true);
		window.addEventListener("webkitAnimationEnd", this._fnFireDomChanged, true);
		window.addEventListener("oanimationend", this._fnFireDomChanged, true);

		jQuery(window).on("resize", this._fnFireDomChanged);

		window.addEventListener("scroll", this._onScroll, true);
		this._aIgnoredMutations = [];
	};

	/**
	 * Called when the MutationObserver is destroyed
	 *
	 * @protected
	 */
	MutationObserver.prototype.exit = function() {
		this._stopMutationObserver();

		window.removeEventListener("transitionend", this._fnFireDomChanged, true);
		window.removeEventListener("animationend", this._fnFireDomChanged, true);

		jQuery(window).off("resize", this._fnFireDomChanged);

		window.removeEventListener("scroll", this._onScroll, true);
	};

	/**
	 * Ignores a Mutation once
	 *
	 * @param {object} mParams
	 * @param {object} mParams.target domNode of the target
	 * @param {object} mParams.type type of the mutation
	 */
	MutationObserver.prototype.ignoreOnce = function(mParams) {
		this._aIgnoredMutations.push(mParams);
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._startMutationObserver = function() {
		if (this._oMutationObserver) {
			return;
		}

		var MutationObserver = window.MutationObserver || window.WebKitMutationObserver;
		if (MutationObserver) {
			this._oMutationObserver = new MutationObserver(function(aMutations) {
				var aTargetNodes = [];
				var aElementIds = [];
				aMutations.forEach(function(oMutation) {
					var oTarget = oMutation.target;

					// text mutations have no class list, so we use a parent node as a target
					if (oMutation.type === "characterData") {
						oTarget = oMutation.target.parentNode;
					}

					// TODO: ignore all RTA dom elements (dialogs, context menus, toolbars etc.)
					var bIsFromRTA = OverlayUtil.isInOverlayContainer(oTarget)
						|| jQuery(oTarget).closest(".sapUiDtContextMenu").length > 0
						|| jQuery(oTarget).closest(".sapUiRtaToolbar").length > 0;

					var bRelevantNode = jQuery.contains(document, oTarget)
						&& oTarget.id !== "sap-ui-static"
						&& jQuery(oTarget).closest("#sap-ui-preserve").length === 0;

					if (bRelevantNode && !bIsFromRTA) {
						var bIgnore = this._aIgnoredMutations.some(function(oIgnoredMutation, iIndex, aSource) {
							if (oIgnoredMutation.target === oMutation.target
									&& (oIgnoredMutation.type ? oIgnoredMutation.type === oMutation.type : true)) {
								aSource.splice(iIndex, 1);
								return true;
							}
						});


						if (!bIgnore) {
							aTargetNodes.push(oTarget);

							// define closest element to notify it's overlay about the dom mutation
							var oOverlay = OverlayUtil.getClosestOverlayForNode(oTarget);
							var sElementId = oOverlay ? oOverlay.getElementInstance().getId() : undefined;
							if (sElementId) {
								aElementIds.push(sElementId);
							}
						}
					}

				}.bind(this));

				if (aTargetNodes.length) {
					this.fireDomChanged({
						type : "mutation",
						elementIds : aElementIds,
						targetNodes : aTargetNodes
					});
				}
			}.bind(this));

			// we should observe whole DOM, otherwise position change of elements can be triggered via outter changes
			// (like change of body size, container insertions etc.)
			this._oMutationObserver.observe(window.document, {
				childList : true,
				subtree : true,
				attributes : true,
				attributeFilter : ["style", "class", "width", "height", "border"],
				characterData : true // also observe text node changes, see https://dom.spec.whatwg.org/#characterdata
			});
		} else {
			jQuery.sap.log.error("Mutation Observer is not available");
		}
	};


	/**
	 * @private
	 */
	MutationObserver.prototype._stopMutationObserver = function() {
		if (this._oMutationObserver) {
			this._oMutationObserver.disconnect();
			delete this._oMutationObserver;
		}
	};

	/**
	 * @private
	 */
	MutationObserver.prototype._fireDomChangeOnScroll = function(oEvent) {
		var oTarget = oEvent.target;
		if (!OverlayUtil.isInOverlayContainer(oTarget) &&
			!OverlayUtil.getClosestOverlayForNode(oTarget) &&
			oTarget !== document) {

			this.fireDomChanged({
				type : "scroll"
			});
		}
	};

	return MutationObserver;
}, /* bExport= */true);

}; // end of sap/ui/dt/MutationObserver.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.Overlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.Overlay.
jQuery.sap.declare('sap.ui.dt.Overlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.dom'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/Overlay",[
	'jquery.sap.global',
	'sap/ui/core/Control',
	'sap/ui/dt/MutationObserver',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/DOMUtil',
	'jquery.sap.dom'
],
function(jQuery, Control, MutationObserver, ElementUtil, OverlayUtil, DOMUtil) {
	"use strict";

	var sOverlayContainerId = "overlay-container";
	var oOverlayContainer;
	var oMutationObserver;

	/**
	 * Constructor for an Overlay.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Overlay allows to create an absolute positioned DIV above the associated element.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @abstract
	 * @since 1.30
	 * @alias sap.ui.dt.Overlay
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Overlay = Control.extend("sap.ui.dt.Overlay", /** @lends sap.ui.dt.Overlay.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Whether the overlay and it's descendants should be visible on a screen
				 * We are overriding Control's property to prevent RenderManager from rendering of an invisible placeholder
				 */
				visible : {
					type : "boolean",
					defaultValue : true
				},
				/**
				 * Render overlay only if associated element is visible
				 */
				lazyRendering : {
					type : "boolean",
					defaultValue : true
				},
				/**
				 * Whether the Overlay can get the browser focus (has tabindex)
				 */
				focusable : {
					type : "boolean",
					defaultValue : false
				}
			},
			associations : {
				/**
				 * Element associated with an overlay
				 */
				element : {
					type : "sap.ui.core.Element"
				}
			},
			aggregations : {
				/**
				 * DesignTime metadata for the associated Element
				 */
				designTimeMetadata : {
					type : "sap.ui.dt.DesignTimeMetadata",
					multiple : false
				}
			},
			events : {
				/**
				 * Event fired when the property "Focusable" is changed
				 */
				focusableChange : {
					parameters : {
						focusable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the Overlay is destroyed
				 */
				destroyed : {
					parameters : {}
				},
				/**
				 * Event fired when the Overlay visibility is changed
				 */
				visibleChanged : {
					parameters : {
						visible : "boolean"
					}
				}
			}
		}
	});

	/**
	 * Creates and/or returns an overlay container element, where all Overlays should be rendered (initially)
	 * @return {Element} overlay container
	 * @static
	 */
	Overlay.getOverlayContainer = function() {
		if (!oOverlayContainer) {
			oOverlayContainer = jQuery.sap.byId(sOverlayContainerId);
			if (!oOverlayContainer.length) {
				oOverlayContainer = jQuery("<div id='" + sOverlayContainerId + "'></div>").appendTo("body");
			}
		}
		return oOverlayContainer.get(0);
	};

	/**
	 * Removes an overlay container element from DOM
	 * @static
	 */
	Overlay.removeOverlayContainer = function() {
		if (oOverlayContainer) {
			oOverlayContainer.remove();
		}

		oOverlayContainer = null;
	};

	/**
	 * @static
	 */
	Overlay.getMutationObserver = function() {
		if (!oMutationObserver) {
			oMutationObserver = new MutationObserver();
		}
		return oMutationObserver;
	};

	/**
	 * @static
	 */
	Overlay.destroyMutationObserver = function() {
		if (oMutationObserver) {
			oMutationObserver.destroy();
			oMutationObserver = null;
		}
	};

	/**
	 * Called when the Overlay is initialized
	 * @protected
	 */
	Overlay.prototype.init = function() {
		this._bVisible = null;

		this._domRefScrollHandler = this._onSyncScrollWithDomRef.bind(this);

		this.attachBrowserEvent("scroll", this._onOverlayScroll, this);
	};

	/**
	 * Called when the Overlay is destroyed
	 * @protected
	 */
	Overlay.prototype.exit = function() {
		var oElementDomRef =  this._mGeometry ? this._mGeometry.domRef : null;
		if (oElementDomRef) {
			this._detachDomRefScrollHandler(oElementDomRef);
		}

		if (this._aScrollContainers) {
			this._aScrollContainers.forEach(function(oScrollContainer, iIndex) {
				if (this.getElementInstance()) {
					var $scrollContainerAssociatedDomRef = this.getDesignTimeMetadata().getAssociatedDomRef(this.getElementInstance(), oScrollContainer.domRef);
					if ($scrollContainerAssociatedDomRef && $scrollContainerAssociatedDomRef.length) {
						var oScrollContainerAssociatedDomRef = $scrollContainerAssociatedDomRef.get(0);
						this._detachDomRefScrollHandler(oScrollContainerAssociatedDomRef);
					}
				}
				window.cancelAnimationFrame(oScrollContainer._iSyncScrollWithDomRef);
			}.bind(this));
		}

		this._restoreVisibility();

		delete this._oDomRef;
		delete this._bVisible;
		window.clearTimeout(this._iCloneDomTimeout);
		window.cancelAnimationFrame(this._iSyncScrollWithDomRef);
		this.fireDestroyed();
	};

	/**
	 * Restore the visibility of the element which was set to "hidden" before DomRef cloning
	 * @private
	 */
	Overlay.prototype._restoreVisibility = function(){
		if (this._oCloneDomRefVisibility){
			sap.ui.dt.Overlay.getMutationObserver().ignoreOnce({
				target: jQuery(this._oCloneDomRefVisibility.domRef).get(0),
				type: "attributes"
			});
			jQuery(this._oCloneDomRefVisibility.domRef).css("visibility", this._oCloneDomRefVisibility.visibility);
			delete this._oCloneDomRefVisibility;
		}
	};

	/**
	 * this is needed to prevent UI5 renderManager from removing overlay's node from DOM in a rendering phase
	 * see RenderManager.js "this._fPutIntoDom" function
	 * @private
	 */
	Overlay.prototype._onChildRerenderedEmpty = function() {
		return true;
	};

	/**
	 * Called after Overlay rendering phase
	 * @protected
	 */
	Overlay.prototype.onAfterRendering = function() {
		if (this._aScrollContainers && !this._oDomRef) {
			this._aScrollContainers.forEach(function(oScrollContainer, iIndex) {
				if (!oScrollContainer.overlayDomRef) {
					oScrollContainer.overlayDomRef = this.$().find('> .sapUiDtOverlayChildren > [data-sap-ui-dt-scrollContainerIndex="' + iIndex + '"]');
				}
			}.bind(this));
		}

		this._oDomRef = this.getDomRef();

		if (this._oDomRef) {
			this._updateDom();
		}

		var bFocusable = this.isFocusable();
		if (bFocusable) {
			this.$().attr("tabindex", 0);
		} else {
			this.$().attr("tabindex", null);
		}
	};

	/**
	 * @return {Element} The Element's DOM Element sub DOM Element or null
	 * @override
	 */
	Overlay.prototype.getDomRef = function() {
		return this._oDomRef || Control.prototype.getDomRef.apply(this, arguments);
	};


	/**
	 * Returns a DOM reference for the associated Element or null, if it can't be found
	 * @public
	 */
	Overlay.prototype.getAssociatedDomRef = function() {
		throw new Error("This method is abstract and needs to be implemented");
	};

	/**
	 * Returns an instance of the Element, which is associated with this Overlay
	 * @return {sap.ui.Element} associated Element
	 * @public
	 */
	Overlay.prototype.getElementInstance = function() {
		return ElementUtil.getElementInstance(this.getElement());
	};

	/**
	 * @return {boolean} if the Overlay has focus
	 * @private
	 */
	Overlay.prototype.hasFocus = function() {
		return document.activeElement === this.getFocusDomRef();
	};

	/**
	 * Sets whether the Overlay can get the browser focus (tabindex)
	 * @param {boolean} bFocusable if the Overlay is focusable
	 * @returns {sap.ui.dt.Overlay} returns this
	 * @public
	 */
	Overlay.prototype.setFocusable = function(bFocusable) {
		bFocusable = !!bFocusable;
		if (this.isFocusable() !== bFocusable) {
			this.setProperty("focusable", bFocusable);
			this.toggleStyleClass("sapUiDtOverlayFocusable", bFocusable);
			this.fireFocusableChange({focusable : bFocusable});
		}

		return this;
	};

	/**
	 * Returns if the Overlay is can get the focus
	 * @public
	 * @return {boolean} if the Overlay is focusable
	 */
	Overlay.prototype.isFocusable = function() {
		return this.getFocusable();
	};

	/**
	 * Calculate and update CSS styles for the Overlay's DOM
	 * The calculation is based on original associated DOM state and parent overlays
	 * This method also calls "applyStyles" method for every child Overlay of this Overlay (cascade)
	 * @public
	 */
	Overlay.prototype.applyStyles = function() {

		// invalidate cached geometry
		delete this._mGeometry;

		if (!this._oDomRef) {
			return;
		}

		if (!this.isVisible()) {
			this.$().css("display", "none");
			return;
		}

		var oGeometry = this.getGeometry();

		if (oGeometry && oGeometry.visible) {
			this._ensureDomOrder();
			var $overlay = this.$();

			this._setOverlaySize($overlay, oGeometry, this.getParent());

			if (oGeometry.domRef) {
				this._handleOverflowScroll(oGeometry, $overlay, this.getParent());
				this._cloneDomRef(oGeometry.domRef);
			}

			if (this._aScrollContainers && this._aScrollContainers.length) {
				this._aScrollContainers.forEach(function(oScrollContainer, iIndex) {
					if (this.getDesignTimeMetadata().getAssociatedDomRef(this.getElementInstance(), oScrollContainer.domRef)) {
						var oScrollContainerDomRef = this.getDesignTimeMetadata().getAssociatedDomRef(this.getElementInstance(), oScrollContainer.domRef).get(0);
						this._setOverlaySize(oScrollContainer.overlayDomRef, DOMUtil.getGeometry(oScrollContainerDomRef), this);
						//sync scroll events from control to scroll container
						this._handleOverflowScroll(DOMUtil.getGeometry(oScrollContainerDomRef), oScrollContainer.overlayDomRef, this);
						// sync scroll events from scroll container to control
						this._attachDomRefScrollHandler(oScrollContainer.overlayDomRef, oScrollContainerDomRef);
					} else {
						this._deleteDummyContainer(oScrollContainer.overlayDomRef);
						oScrollContainer.scrollEvents = false;
						oScrollContainer.overlayDomRef.css("display", "none");
					}
				}.bind(this));
			}

			this.getChildren().forEach(function(oChild) {
				oChild.applyStyles();
			});

		} else {
			this.$().css("display", "none");
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._setOverlaySize = function($overlay, oGeometry, oOverlayParent) {
		// ensure visibility
		$overlay.css("display", "block");
		var $overlayParentDomRef = (oOverlayParent && oOverlayParent instanceof Overlay) ? oOverlayParent.$() : null;

		if (oOverlayParent._aScrollContainers && $overlay.attr("class") !== "sapUiDtOverlayScrollContainer") {

			var iScrollContainerIndex = this._getScrollContainerIndex(oOverlayParent);

			if (iScrollContainerIndex > -1) {
				var $scrollContainer = oOverlayParent.$().find('> .sapUiDtOverlayChildren > [data-sap-ui-dt-scrollContainerIndex="' + iScrollContainerIndex + '"]');
				$overlayParentDomRef = $scrollContainer;
			}
		}

		var iScrollingWidth = DOMUtil.getScrollbarWidth();
		var mSize = oGeometry.size;

		var iParentScrollTop = $overlayParentDomRef ? $overlayParentDomRef.scrollTop() : null;
		var iParentScrollLeft = $overlayParentDomRef ? $overlayParentDomRef.scrollLeft() : null;
		var mParentOffset = $overlayParentDomRef ? $overlayParentDomRef.offset() : null;

		if (mParentOffset && jQuery('html').attr('dir') === 'rtl' && DOMUtil.hasVerticalScrollBar(oOverlayParent.getDomRef())) {
			mParentOffset.left += iScrollingWidth;
		}

		var mPosition = DOMUtil.getOffsetFromParent(oGeometry.position, mParentOffset, iParentScrollTop, iParentScrollLeft);

		// OVERLAY SIZE
		$overlay.css("width", mSize.width + "px");
		$overlay.css("height", mSize.height + "px");
		$overlay.css("top", mPosition.top + "px");
		$overlay.css("left", mPosition.left + "px");
	};

	/**
	 * @private
	 */
	Overlay.prototype._deleteDummyContainer = function($overlay) {
		if ($overlay.find("> .sapUiDtDummyScrollContainer").length > 0) {
				$overlay.find("> .sapUiDtDummyScrollContainer").remove();
				if (this.getParent() && this.getParent().$) {
					var $parent = this.getParent().$();
					$parent.removeClass("sapUiDtOverlayWithScrollBar");
					$parent.removeClass("sapUiDtOverlayWithScrollBarVertical");
					$parent.removeClass("sapUiDtOverlayWithScrollBarHorizontal");
				}
			}
	};

	/**
	 * Handle overflow from controls and sync with overlay
	 * @private
	 */
	Overlay.prototype._handleOverflowScroll = function(oGeometry, $overlayDomRef, oOverlayParent) {
		var $originalDomRef = oGeometry.domRef;
		var mSize = oGeometry.size;
		var iZIndex = DOMUtil.getZIndex($originalDomRef);
		if (iZIndex) {
			$overlayDomRef.css("z-index", iZIndex);
		}

		// OVERFLOW & SCROLLING
		var oOverflows = DOMUtil.getOverflows($originalDomRef);
		if (oOverflows) {
			if (oOverflows.overflowX) {
				$overlayDomRef.css("overflow-x", oOverflows.overflowX);
			}
			if (oOverflows.overflowY) {
				$overlayDomRef.css("overflow-y", oOverflows.overflowY);
			}
			var iScrollHeight = $originalDomRef.scrollHeight;
			var iScrollWidth = $originalDomRef.scrollWidth;
			// Math.ceil is needed because iScrollHeight is an integer value, mSize not. To compare we should have an integer value for mSize too.
			// example: iScrollHeight = 24px, mSize.height = 23.98375. Both should be the same.
			if (iScrollHeight > Math.ceil(mSize.height) || iScrollWidth > Math.ceil(mSize.width)) {
				var oDummyScrollContainer = $overlayDomRef.find("> .sapUiDtDummyScrollContainer");
				if (!oDummyScrollContainer.length) {
					oDummyScrollContainer = jQuery("<div class='sapUiDtDummyScrollContainer' style='height: " + iScrollHeight + "px; width: " + iScrollWidth + "px;'></div>");
					if (oOverlayParent.$ && DOMUtil.hasVerticalScrollBar(oGeometry.domRef)) {
						oOverlayParent.$().addClass("sapUiDtOverlayWithScrollBar");
						oOverlayParent.$().addClass("sapUiDtOverlayWithScrollBarVertical");
					}
					if (oOverlayParent.$ && DOMUtil.hasHorizontalScrollBar(oGeometry.domRef)) {
						oOverlayParent.$().addClass("sapUiDtOverlayWithScrollBar");
						oOverlayParent.$().addClass("sapUiDtOverlayWithScrollBarHorizontal");
					}
					$overlayDomRef.append(oDummyScrollContainer);
				} else {
					oDummyScrollContainer.css({
						"height": iScrollHeight,
						"width" : iScrollWidth
					});
				}
			} else {
				this._deleteDummyContainer($overlayDomRef);
			}

			this._attachDomRefScrollHandler(oGeometry.domRef, $overlayDomRef);

			this._syncScrollWithDomRef(oGeometry.domRef, $overlayDomRef);
		}
	};

	/**
	 * Sync scroll events from controls domRef with overlay
	 * @private
	 */
	Overlay.prototype._attachDomRefScrollHandler = function(oDomRef, $overlayDomRef) {

		this._detachDomRefScrollHandler(oDomRef);
		if (oDomRef) {
			jQuery(oDomRef).on("scroll", null, [oDomRef, $overlayDomRef], this._domRefScrollHandler);
		}
	};

	/**
	 * @param {object} oDomRef element's DOM reference
	 * @private
	 */
	Overlay.prototype._detachDomRefScrollHandler = function(oDomRef) {
		if (oDomRef) {
			jQuery(oDomRef).off("scroll", this._domRefScrollHandler);
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._onSyncScrollWithDomRef = function(oEvent) {
		var oSourceDomRef = oEvent.data[0];
		var $targetDomRef = oEvent.data[1];
		var oScrollContainer;
		var sScrollContainerIndex = jQuery($targetDomRef).attr("data-sap-ui-dt-scrollcontainerindex") || jQuery(oSourceDomRef).attr("data-sap-ui-dt-scrollcontainerindex");

		if (sScrollContainerIndex) {
			oScrollContainer = this._aScrollContainers[sScrollContainerIndex];
		} else {
			oScrollContainer = this;
		}

		window.cancelAnimationFrame(oScrollContainer._iSyncScrollWithDomRef);
		// timeout needed so that scroll wheel in chrome windows works fast
		oScrollContainer._iSyncScrollWithDomRef = window.requestAnimationFrame(function() {
			this._syncScrollWithDomRef(oSourceDomRef, $targetDomRef);
			delete oScrollContainer._iSyncScrollWithDomRef;
		}.bind(this));
	};

	/**
	 * @private
	 */
	Overlay.prototype._syncScrollWithDomRef = function(oDomRef, oOverlayDomRef) {
		DOMUtil.syncScroll(oDomRef, oOverlayDomRef);
	};

	/**
	 * @private
	 * @returns index of the scroll container containing this aggregation, -1 if scroll container exist, but this aggregation is not included, undefined if no scroll container exist
	 */
	Overlay.prototype._getScrollContainerIndex = function(oOverlayParent, oOverlay) {};

	/**
	 * Returns an object, which describes the DOM geometry of the element associated with this overlay or null if it can't be found
	 * The geometry is calculated based on the associated element's DOM reference, if it exists or based on it's public children
	 * Object may contain following fields: position - absolute position of Element in DOM; size - absolute size of Element in DOM
	 * Object may contain domRef field, when the associated Element's DOM can be found
	 * @return {object} geometry object describing the DOM of the Element associated with this Overlay
	 * @public
	 */
	Overlay.prototype.getGeometry = function(bForceCalculation) {
		if (bForceCalculation || !this._mGeometry) {
			var $DomRef = this.getAssociatedDomRef();
			var aChildrenGeometry;

			// dom Ref is either jQuery object with one/multiple elements
			if ($DomRef) {
				var bIsRoot = this.isRoot();
				aChildrenGeometry = jQuery.makeArray($DomRef).map(function($element) {
					return DOMUtil.getGeometry($element, bIsRoot);
				});
			} else {
				aChildrenGeometry = this.getChildren().map(function(oChildOverlay) {
					return oChildOverlay.getGeometry(true);
				});
			}

			if (aChildrenGeometry.length) {
				// cache geometry
				this._mGeometry = aChildrenGeometry.length > 1 ? OverlayUtil.getGeometry(aChildrenGeometry) : aChildrenGeometry[0];
			} else {
				delete this._mGeometry;
			}
		}

		return this._mGeometry;
	};

	/**
	 * @param {object} oDomRef element's DOM reference to be cloned
	 * @private
	 */
	Overlay.prototype._cloneDomRef = function(oDomRef) {
		var $this = this.$();

		var $clonedDom = $this.find(">.sapUiDtClonedDom");
		var vCloneDomRef = this.getDesignTimeMetadata().getCloneDomRef();
		if (vCloneDomRef) {
			if (oDomRef) {
				var fnCloneDom = function() {
					if (vCloneDomRef !== true) {
						oDomRef = DOMUtil.getDomRefForCSSSelector(oDomRef, vCloneDomRef);
					}

					if (!$clonedDom.length) {
						$clonedDom = jQuery("<div class='sapUiDtClonedDom'></div>").prependTo($this);
					} else {
						$clonedDom.empty();
					}

					this._restoreVisibility();

					//TODO: disable update
					DOMUtil.cloneDOMAndStyles(oDomRef, $clonedDom);

					this._oCloneDomRefVisibility = {
						domRef: jQuery(oDomRef),
						visibility: jQuery(oDomRef).css("visibility")
					};
					sap.ui.dt.Overlay.getMutationObserver().ignoreOnce({
						target: jQuery(oDomRef).get(0),
						type: "attributes"
					});
					jQuery(oDomRef).css("visibility", "hidden");
				}.bind(this);

				if (!this._bClonedDom) {
					this._bClonedDom = true;
					fnCloneDom();
				} else {
					window.clearTimeout(this._iCloneDomTimeout);
					// cloneDom is expensive, therefore the call is delayed
					this._iCloneDomTimeout = window.setTimeout(fnCloneDom, 0);
				}
			}
		} else {
			$clonedDom.remove();
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._updateDom = function() {
		var bApplyStyles;
		if (!document.getElementById(this.getId()) && document.getElementById(this.getParent().getId())) {
			bApplyStyles = true;
		}

		if (this.isRoot()) {
			this._ensureIsInOverlayContainer();
			// apply styles propagated from root overlays to all their children
			this.applyStyles();
		} else if (bApplyStyles) {
			this.applyStyles();
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._ensureDomOrder = function() {
		var $this = this.$();

		var oParentOverlay = this.getParent();
		if (!oParentOverlay || !oParentOverlay.$) {
			return;
		}

		var $parentDomRef = oParentOverlay.$();
		var $parentContainer = $parentDomRef.find(">.sapUiDtOverlayChildren");
		var aSiblingOverlays = oParentOverlay.getChildren();

		var iScrollContainerIndex = this._getScrollContainerIndex(oParentOverlay);
		if (iScrollContainerIndex > -1) {
			//there are scroll containers and it contains the current aggregation overlay
			$parentContainer = $parentContainer.find('> [data-sap-ui-dt-scrollContainerIndex="' + iScrollContainerIndex + '"]');
			aSiblingOverlays = aSiblingOverlays.filter(function(oSibling) {
				return oParentOverlay._aScrollContainers[iScrollContainerIndex].aggregations.indexOf(oSibling.getAggregationName()) > -1;
			});
		}

		var bIsDomOrderCorrect;
		var iPreviousScrollContainerIndex;
		var $PreviousSiblingWithDom;
		var iPreviousSiblingWithDomIndex = aSiblingOverlays.indexOf(this) - 1;
		while (iPreviousSiblingWithDomIndex >= 0) {
			iPreviousScrollContainerIndex = this._getScrollContainerIndex(oParentOverlay, aSiblingOverlays[iPreviousSiblingWithDomIndex]);

			if (iPreviousScrollContainerIndex > -1) {
				$PreviousSiblingWithDom = jQuery($parentContainer.children()[iPreviousSiblingWithDomIndex]);
			} else {
				$PreviousSiblingWithDom = aSiblingOverlays[iPreviousSiblingWithDomIndex].$();
			}

			if ($PreviousSiblingWithDom.length) {
				break;
			}
			iPreviousSiblingWithDomIndex--;
		}

		// if our dom is already after our previous sibling
		if ($PreviousSiblingWithDom && $PreviousSiblingWithDom.length) {
			bIsDomOrderCorrect = $this.prev().get(0) === $PreviousSiblingWithDom.get(0);
		// .. or first in parent container
		} else {
			bIsDomOrderCorrect = $parentContainer.children().index($this) === 0;
		}

		if (!bIsDomOrderCorrect) {
			if ($PreviousSiblingWithDom && $PreviousSiblingWithDom.length) {
				$PreviousSiblingWithDom.after($this);
			} else {
				$parentContainer.prepend($this);
			}
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._ensureIsInOverlayContainer = function() {
		var $this = this.$();
		var $currentDomParent = $this.parent();
		// instead of adding the created DOM into the UIArea's DOM, we are adding it to overlay-container to avoid clearing of the DOM
		var oOverlayContainer = Overlay.getOverlayContainer();
		var oParentElement = $currentDomParent.length ? $currentDomParent.get(0) : null;
		if (oOverlayContainer !== oParentElement) {
			$this.appendTo(oOverlayContainer);
		}
	};

	/**
	 * @private
	 */
	Overlay.prototype._onOverlayScroll = function() {
		var oGeometry = this.getGeometry();
		var oDomRef = oGeometry ? oGeometry.domRef : null;
		if (oDomRef) {
			DOMUtil.syncScroll(this.$(), oDomRef);
		}
	};

	/**
	 * Sets whether the Overlay is visible
	 * @param {boolean} bVisible if the Overlay is visible
	 * @returns {sap.ui.dt.Overlay} returns this
	 * @public
	 */
	Overlay.prototype.setVisible = function(bVisible) {
		bVisible = !!bVisible;

		if (this.getVisible() !== bVisible) {
			if (!bVisible) {
				this._restoreVisibility();
			}
			this.setProperty("visible", bVisible);
			this._bVisible = bVisible;
			this.fireVisibleChanged({visible : bVisible});
		}

		return this;
	};

	/**
	 * Returns whether the Overlay is visible
	 * @return {boolean} if the Overlay is visible
	 * @public
	 */
	Overlay.prototype.getVisible = function() {

		if (this._bVisible === null) {
			if (!this.getLazyRendering()) {
				return true;
			}
			var oDesignTimeMetadata = this.getDesignTimeMetadata();
			return oDesignTimeMetadata ? !oDesignTimeMetadata.isIgnored(this.getElementInstance()) : false;
		} else {
			return this.getProperty("visible");
		}
	};

	/**
	 * Returns if the Overlay is visible
	 * @public
	 * @return {boolean} if the Overlay is visible
	 */
	Overlay.prototype.isVisible = function() {
		return this.getVisible();
	};

	/**
	 * Returns if overlay is root
	 * @public
	 * @return {boolean} if the Overlay is root
	 */
	Overlay.prototype.isRoot = function() {
		var oParent = this.getParent();
		if (oParent) {
			if (!oParent.getDomRef) {
				return true;
			}
		}
	};

	return Overlay;
}, /* bExport= */ true);

}; // end of sap/ui/dt/Overlay.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.Selection') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.Selection.
jQuery.sap.declare('sap.ui.dt.Selection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/Selection",[
	'sap/ui/base/ManagedObject',
	'./library'
],
function(ManagedObject) {
	"use strict";

	/**
	 * Constructor for a new Selection.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The Selection allows to create a set of Overlays above the root elements and
	 * theire public children and manage their events.
	 * @extends sap.ui.dt.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.Selection
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var Selection = ManagedObject.extend("sap.ui.dt.Selection", /** @lends sap.ui.dt.Selection.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				"mode" : {
					type : "sap.ui.dt.SelectionMode",
					defaultValue : sap.ui.dt.SelectionMode.Single
				}
			},
			associations : {},
			aggregations : {},
			events : {
				"change" : {
					parameters : {
						selection : { type : "sap.ui.dt.Overlay[]" }
					}
				}
			}
		}
	});

	/**
	 * @override
	 */
	Selection.prototype.init = function() {
		this._aSelection = [];
	};

	/**
	 * @override
	 */
	Selection.prototype.exit = function() {
		delete this._aSelection;
	};

	/**
	 * @public
	 * @return {sap.ui.dt.Overlay[]} selected overlays
	 */
	Selection.prototype.getSelection = function() {
		return this._aSelection;
	};

	/**
	 * @public
	 */
	Selection.prototype.set = function(oOverlay, bSelected) {
		if (bSelected) {
			this.add(oOverlay);
		} else {
			this.remove(oOverlay);
		}
	};

	/**
	 * @public
	 */
	Selection.prototype.add = function(oOverlay) {
		this._syncSelectionWithMode();

		this._aSelection = this._aSelection.concat(oOverlay);
		this.fireChange({
			selection : this.getSelection()
		});
	};

	/**
	 * @public
	 */
	Selection.prototype.remove = function(oOverlay) {
		this._syncSelectionWithMode();

		if (this._aSelection.indexOf(oOverlay) !== -1) {
			this._aSelection = this._aSelection.filter(function (oItem) {
				return oOverlay !== oItem;
			});
		}
		this.fireChange({
			selection : this.getSelection()
		});
	};

	/**
	 * @private
	 */
	Selection.prototype._isSingleMode = function() {
		return this.getMode() === sap.ui.dt.SelectionMode.Single;
	};


	Selection.prototype._syncSelectionWithMode = function() {
		if (this._isSingleMode()) {
			this._aSelection.forEach(function(oOverlay) {
				oOverlay.setSelected(false, true);
			});
			this._aSelection = [];
		}
	};

	return Selection;
}, /* bExport= */ true);
}; // end of sap/ui/dt/Selection.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.ContextMenu') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.rta.plugin.ContextMenu.
jQuery.sap.declare('sap.ui.dt.plugin.ContextMenu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/plugin/ContextMenu",[
	'jquery.sap.global', 'sap/ui/dt/Plugin', 'sap/ui/dt/ContextMenuControl'
], function(jQuery, Plugin, ContextMenuControl) {
	"use strict";

	/**
	 * Constructor for a new ContextMenu.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The ContextMenu registers event handler to open the context menu. Menu entries can dynamically be added
	 * @extends sap.ui.dt.Plugin
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.plugin.ContextMenu
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ContextMenu = Plugin.extend("sap.ui.dt.plugin.ContextMenu", /** @lends sap.ui.rta.plugin.ContextMenu.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {
				contextElement : {
					type : "object"
				},
				styleClass: {
					type: "string"
				}
			},
			associations: {},
			events: {
				openedContextMenu: {},
				// TODO check if needed and how contextMenuControl handles it...
				closedContextMenu: {}
			}
		}
	});

	/**
	 * Register an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	ContextMenu.prototype.registerElementOverlay = function(oOverlay) {
		oOverlay.attachBrowserEvent("contextmenu", this._onContextMenu, this);
		oOverlay.attachBrowserEvent("keydown", this._onKeyDown, this);
	};

	/**
	 * Additionally to super->deregisterOverlay this method detaches the browser events
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	ContextMenu.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.detachBrowserEvent("contextmenu", this._onContextMenu, this);
		oOverlay.detachBrowserEvent("keydown", this._onKeyDown, this);
	};

	ContextMenu.prototype.init = function() {
		this._aMenuItems = [];
	};

	ContextMenu.prototype.exit = function() {
		delete this._aMenuItems;
		if (this._oContextMenuControl) {
			this._oContextMenuControl.destroy();
			delete this._oContextMenuControl;
		}
	};

	/**
	 * Add menu items in the following format
	 *
	 * @param {object} mMenuItem json object with the menu item settings
	 * @param {string} mMenuItem.id id, which corresponds to the text key
	 * @param {string} aMenuItems.text menu item text (translated)
	 * @param {function} mMenuItem.handler event handler if menu is selected, the element for which the menu was opened is passed to the handler
	 * @param {function} mMenuItem.startSection? function to determine if a new section should be started, the element for which the menu was opened
	 *        is passed to the handler, default false
	 * @param {function} mMenuItem.available? function to determine if the menu entry should be shown, the element for which the menu should be opened
	 *        is passed, default true
	 * @param {function} mMenuItem.enabled? function to determine if the menu entry should be enabled, the element for which the menu should be opened
	 *        is passed, default true
	 */
	ContextMenu.prototype.addMenuItem = function(mMenuItem) {
		this._aMenuItems.push(mMenuItem);
	};

	ContextMenu.prototype.open = function(oOriginalEvent, oTargetOverlay) {
		this.setContextElement(oTargetOverlay.getElementInstance());

		this._oContextMenuControl = new ContextMenuControl();
		this._oContextMenuControl.addStyleClass(this.getStyleClass());
		this._oContextMenuControl.setMenuItems(this._aMenuItems, oTargetOverlay);
		this._oContextMenuControl.setOverlayDomRef(oTargetOverlay);
		this._oContextMenuControl.attachItemSelect(this._onItemSelected, this);
		this._oContextMenuControl.openMenu(oOriginalEvent, oTargetOverlay);
		this.fireOpenedContextMenu();
	};

	/**
	 * Called when a context menu item gets selected by user
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @override
	 * @private
	 */
	ContextMenu.prototype._onItemSelected = function(oEvent) {
		var aSelection = [];
		var sId = oEvent.getParameter("item").data("id");
		this._aMenuItems.some(function(oItem) {
			if (sId === oItem.id) {
				var oDesignTime = this.getDesignTime();
				aSelection = oDesignTime.getSelection();

				jQuery.sap.assert(aSelection.length > 0, "sap.ui.rta - Opening context menu, with empty selection - check event order");

				oItem.handler(aSelection);
				return true;
			}
		}, this);
	};

	/**
	 * Handle context menu event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenu.prototype._onContextMenu = function(oEvent) {
		// hide browser-context menu
		oEvent.preventDefault();
		document.activeElement.blur();

		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);
		var sTargetClasses = oEvent.target.className;

		if (oOverlay && oOverlay.isSelectable() && sTargetClasses.indexOf("sapUiDtOverlay") > -1) {
			if (!oOverlay.isSelected()) {
				oOverlay.setSelected(true);
			}

			this.open(oEvent, oOverlay);
			oEvent.stopPropagation();
		}
	};

	/**
	 * Handle keydown event
	 *
	 * @param {sap.ui.base.Event} oEvent event object
	 * @private
	 */
	ContextMenu.prototype._onKeyDown = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		if ((oEvent.keyCode === jQuery.sap.KeyCodes.F10) && (oEvent.shiftKey === true) && (oEvent.altKey === false) && (oEvent.ctrlKey === false)) {
			// hide browser-context menu
			oEvent.preventDefault();
			oEvent.stopPropagation();
			if (oOverlay && oOverlay.isSelectable()) {
				if (!oOverlay.isSelected()) {
					oOverlay.setSelected(true);
				}
				var iWidth = oOverlay.$().width() / 2;
				var iHeight = oOverlay.$().height() / 2;
				var iTop = oOverlay.$().offset().top;
				var iLeft = oOverlay.$().offset().left;

				this.open({
					pageX: iLeft + iWidth,
					pageY: iTop + iHeight
				}, oOverlay);
			}
		}
	};

	return ContextMenu;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/ContextMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.ControlDragDrop') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.ControlDragDrop.
jQuery.sap.declare('sap.ui.dt.plugin.ControlDragDrop'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/ControlDragDrop",['sap/ui/dt/plugin/DragDrop', 'sap/ui/dt/plugin/ElementMover', 'sap/ui/dt/ElementUtil'], function(
		DragDrop, ElementMover, ElementUtil) {
	"use strict";

	/**
	 * Constructor for a new ControlDragDrop.
	 *
	 * @param {string}
	 *          [sId] id for the new object, generated automatically if no id is given
	 * @param {object}
	 *          [mSettings] initial settings for the new object
	 * @class The ControlDragDrop enables D&D functionality for the overlays based on aggregation types
	 * @extends sap.ui.dt.plugin.DragDrop"
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.plugin.ControlDragDrop
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var ControlDragDrop = DragDrop.extend("sap.ui.dt.plugin.ControlDragDrop", /** @lends sap.ui.dt.plugin.ControlDragDrop.prototype */
	{
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				draggableTypes : {
					type : "string[]",
					defaultValue : ["sap.ui.core.Element"]
				},
				elementMover : {
					type : "any" // "sap.ui.dt.plugin.ElementMover"
				}
			},
			associations : {}
		}
	});

	var sDROP_ZONE_STYLE = "sapUiDtOverlayDropZone";

	ControlDragDrop.prototype.init = function() {
		DragDrop.prototype.init.apply(this, arguments);
		this.setElementMover(new ElementMover());
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.setElementMover = function(oNewElementMover) {
		var oOldMover = this.getElementMover();
		if (oOldMover !== oNewElementMover) {
			if (oOldMover) {
				oOldMover.destroy();
			}
			this.setProperty("elementMover", oNewElementMover);
		}
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.setDraggableTypes = function(aDraggableTypes) {
		this.getElementMover().setMovableTypes(aDraggableTypes);
		return this.setProperty("draggableTypes", aDraggableTypes);
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.registerElementOverlay = function(oOverlay) {
		DragDrop.prototype.registerElementOverlay.apply(this, arguments);
		var oElement = oOverlay.getElementInstance();
		if (this.getElementMover().isMovableType(oElement) && this.getElementMover().checkMovable(oOverlay)) {
			oOverlay.setMovable(true);
		}

		if (this.oDraggedElement) {
			this.getElementMover().activateTargetZonesFor(oOverlay, sDROP_ZONE_STYLE);
		}
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.deregisterElementOverlay = function(oOverlay) {
		DragDrop.prototype.deregisterElementOverlay.apply(this, arguments);
		oOverlay.setMovable(false);

		if (this.oDraggedElement) {
			this.getElementMover().deactivateTargetZonesFor(oOverlay, sDROP_ZONE_STYLE);
		}
	};

	/**
	 * returns the dragged overlay (only during drag&drop)
	 *
	 * @public
	 * @return {sap.ui.dt.Overlay} overlays which is dragged
	 */
	ControlDragDrop.prototype.getDraggedOverlay = function() {
		return this._oDraggedOverlay;
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onDragStart = function(oOverlay) {
		this._oDraggedOverlay = oOverlay;
		this.getElementMover().setMovedOverlay(oOverlay);

		this.getElementMover().activateAllValidTargetZones(this.getDesignTime(), sDROP_ZONE_STYLE);
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onDragEnd = function(oOverlay) {
		delete this._oPreviousTarget;
		this.getElementMover().deactivateAllTargetZones(this.getDesignTime(), sDROP_ZONE_STYLE);
		delete this._oDraggedOverlay;
		this.getElementMover().setMovedOverlay(null);
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onDragEnter = function(oTargetOverlay) {
		var oDraggedOverlay = this.getDraggedOverlay();
		if (oTargetOverlay.getElementInstance() !== oDraggedOverlay.getElementInstance()
				&& oTargetOverlay !== this._oPreviousTarget) {
			this.getElementMover().repositionOn(oDraggedOverlay, oTargetOverlay);
		}
		this._oPreviousTarget = oTargetOverlay;
	};

	/**
	 * @override
	 */
	ControlDragDrop.prototype.onAggregationDragEnter = function(oAggregationOverlay) {
		delete this._oPreviousTarget;

		var oDraggedOverlay = this.getDraggedOverlay();
		this.getElementMover().insertInto(oDraggedOverlay, oAggregationOverlay);
	};

	return ControlDragDrop;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/ControlDragDrop.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.CutPaste') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.plugin.CutPaste.
jQuery.sap.declare('sap.ui.dt.plugin.CutPaste'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/plugin/CutPaste",[
	'sap/ui/dt/Plugin',
	'sap/ui/dt/plugin/ElementMover',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/OverlayRegistry'
], function(Plugin, ElementMover, OverlayUtil, OverlayRegistry) {
	"use strict";

	/**
	 * Constructor for a new CutPaste.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The CutPaste enables Cut & Paste functionality for the overlays based on aggregation types
	 * @extends sap.ui.dt.Plugin"
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.34
	 * @alias sap.ui.dt.plugin.CutPaste
	 * @experimental Since 1.34. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var CutPaste = Plugin.extend("sap.ui.dt.plugin.CutPaste", /** @lends sap.ui.dt.plugin.CutPaste.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {
				movableTypes: {
					type: "string[]",
					defaultValue: [
						"sap.ui.core.Element"
					]
				},
				elementMover: {
					type: "any" // "sap.ui.dt.plugin.ElementMover"
				}
			},
			associations: {}
		}
	});

	CutPaste.prototype.init = function() {
		this.setElementMover(new ElementMover());
	};

	/**
	 * @override
	 */
	CutPaste.prototype.registerElementOverlay = function(oOverlay) {
		var oElement = oOverlay.getElementInstance();
		//Register key down so that ESC is possible on all overlays
		oOverlay.attachBrowserEvent("keydown", this._onKeyDown, this);
		if (this.getElementMover().isMovableType(oElement) && this.getElementMover().checkMovable(oOverlay)) {
			oOverlay.setMovable(true);
		}

		if (this.getElementMover().getMovedOverlay()) {
			this.getElementMover().activateTargetZonesFor(this.getElementMover().getMovedOverlay());
		}
	};

	/**
	 * @override
	 */
	CutPaste.prototype.deregisterElementOverlay = function(oOverlay) {
		oOverlay.setMovable(false);
		oOverlay.detachBrowserEvent("keydown", this._onKeyDown, this);

		if (this.getElementMover().getMovedOverlay()) {
			this.getElementMover().deactivateTargetZonesFor(this.getElementMover().getMovedOverlay());
		}
	};

	CutPaste.prototype.setMovableTypes = function(aMovableTypes) {
		this.getElementMover().setMovableTypes(aMovableTypes);
		return this.setProperty("movableTypes", aMovableTypes);
	};

	CutPaste.prototype.setElementMover = function(oElementMover) {
		oElementMover.setMovableTypes(this.getMovableTypes());
		return this.setProperty("elementMover", oElementMover);
	};

	CutPaste.prototype.getCuttedOverlay = function() {
		return this.getElementMover().getMovedOverlay();
	};

	CutPaste.prototype.isElementPasteable = function(oTargetOverlay) {
		var oTargetZoneAggregation = this._getTargetZoneAggregation(oTargetOverlay);
		if ((oTargetZoneAggregation) || (OverlayUtil.isInTargetZoneAggregation(oTargetOverlay))) {
			return true;
		} else {
			return false;
		}
	};

	CutPaste.prototype._onKeyDown = function(oEvent) {
		var oOverlay = sap.ui.getCore().byId(oEvent.currentTarget.id);

		// on macintosh os cmd-key is used instead of ctrl-key
		var bCtrlKey = sap.ui.Device.os.macintosh ? oEvent.metaKey : oEvent.ctrlKey;

		if ((oEvent.keyCode === jQuery.sap.KeyCodes.X) && (oEvent.shiftKey === false) && (oEvent.altKey === false) && (bCtrlKey === true)) {
			// CTRL+X
			this.cut(oOverlay);
			oEvent.stopPropagation();
		} else if ((oEvent.keyCode === jQuery.sap.KeyCodes.V) && (oEvent.shiftKey === false) && (oEvent.altKey === false) && (bCtrlKey === true)) {
			// CTRL+V
			if (this.getElementMover().getMovedOverlay()) {
				this.paste(oOverlay);
			}
			oEvent.stopPropagation();
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.ESCAPE) {
			// ESC
			this.stopCutAndPaste();
			oEvent.stopPropagation();
		}
	};

	CutPaste.prototype.cut = function(oOverlay) {
		this.stopCutAndPaste();

		if (oOverlay.isMovable()) {
			this.getElementMover().setMovedOverlay(oOverlay);
			oOverlay.addStyleClass("sapUiDtOverlayCutted");

			this.getElementMover().activateAllValidTargetZones(this.getDesignTime());
		}
	};

	/**
	 * The actual execution of paste. This method is additionally defined because
	 * there might be steps between the execution and finalization (stopCutAndPaste) of
	 * paste (for example in the RTA plugin that extends this one).
	 * @param  {sap.ui.dt.Overlay} oTargetOverlay The Overlay where the element will be pasted
	 * @return {boolean} Return true if paste was successfully executed
	 */
	CutPaste.prototype._executePaste = function(oTargetOverlay) {
		var oCutOverlay = this.getElementMover().getMovedOverlay();
		if (!oCutOverlay) {
			return false;
		}

		var bResult = false;
		if (!this._isForSameElement(oCutOverlay, oTargetOverlay)) {
			var oTargetZoneAggregation = this._getTargetZoneAggregation(oTargetOverlay);
			if (oTargetZoneAggregation) {
				this.getElementMover().insertInto(oCutOverlay, oTargetZoneAggregation);
				bResult = true;
			} else if (OverlayUtil.isInTargetZoneAggregation(oTargetOverlay)) {
				this.getElementMover().repositionOn(oCutOverlay, oTargetOverlay);
				bResult = true;
			}
		}

		// focus get invalidated, see BCP 1580061207
		if (bResult) {
			oCutOverlay.setSelected(true);
			setTimeout(function () {
				oCutOverlay.focus();
			}, 0);
		}

		return bResult;
	};

	/**
	 * Paste the element into the target overlay
	 * @param  {sap.ui.dt.Overlay} oTargetOverlay The Overlay where the element will be pasted
	 */
	CutPaste.prototype.paste = function(oTargetOverlay) {
		var bPasteExecuted = this._executePaste(oTargetOverlay);

		if (bPasteExecuted === true){
			this.stopCutAndPaste();
		}
	};

	/**
	 * Finalize cut&paste operation + cleanup
	 */
	CutPaste.prototype.stopCutAndPaste = function() {
		var oCutOverlay = this.getElementMover().getMovedOverlay();
		if (oCutOverlay) {
			oCutOverlay.removeStyleClass("sapUiDtOverlayCutted");
			this.getElementMover().setMovedOverlay(null);
			this.getElementMover().deactivateAllTargetZones(this.getDesignTime());
		}
	};

	CutPaste.prototype._isForSameElement = function(oCutOverlay, oTargetOverlay) {
		return oTargetOverlay.getElementInstance() === oCutOverlay.getElementInstance();
	};

	CutPaste.prototype._getTargetZoneAggregation = function(oTargetOverlay) {
		var aAggregationOverlays = oTargetOverlay.getAggregationOverlays();
		var aPossibleTargetZones = aAggregationOverlays.filter(function(oAggregationOverlay) {
			return oAggregationOverlay.isTargetZone();
		});
		if (aPossibleTargetZones.length > 0) {
			return aPossibleTargetZones[0];
		} else {
			return null;
		}
	};

	return CutPaste;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/CutPaste.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.plugin.TabHandling') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.dt.plugin.TabHandling'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/plugin/TabHandling",[
	'jquery.sap.global', 'sap/ui/dt/Plugin', 'sap/ui/dt/Overlay'
], function(jQuery, Plugin, Overlay) {
	"use strict";

	/**
	 * Constructor for a new TabHandling.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 * @class The TabHandling plugin adjusts the tabindex for the elements.
	 * @extends sap.ui.dt.Plugin
	 * @author SAP SE
	 * @version 1.50.6
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.plugin.TabHandling
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var TabHandling = Plugin.extend("sap.ui.dt.plugin.TabHandling", /** @lends sap.ui.dt.plugin.TabHandling.prototype */
	{
		metadata: {
			// ---- object ----

			// ---- control specific ----
			library: "sap.ui.dt",
			properties: {},
			associations: {},
			events: {}
		}
	});


	TabHandling.prototype.registerElementOverlay = function(oOverlay) {
		if (oOverlay.isRoot()) {
			this.removeTabIndex();
		}
	};

	/**
	 * Deregister an overlay
	 *
	 * @param {sap.ui.dt.Overlay} oOverlay overlay object
	 * @override
	 */
	TabHandling.prototype.deregisterElementOverlay = function(oOverlay) {
		if (oOverlay.isRoot()) {
			this.restoreTabIndex();
		}
	};

	TabHandling.prototype.setDesignTime = function(oDesignTime) {
		Plugin.prototype.setDesignTime.apply(this, arguments);
		if (oDesignTime) {
			if (!this._oMutationObserver) {
				this._oMutationObserver = Overlay.getMutationObserver();
				this._oMutationObserver.attachDomChanged(this._onDomChanged, this);
			}
		} else {
			this._oMutationObserver.detachDomChanged(this._onDomChanged, this);
			delete this._oMutationObserver;
			this.restoreTabIndex();
		}
	};

	/**
	 * Traverse the whole DOM tree and set tab indices to -1 for all elements
	 */
	TabHandling.prototype.removeTabIndex = function() {
		var oDesignTime = this.getDesignTime();
		var aRootElements = oDesignTime.getRootElements();
		aRootElements.forEach(function(sRootElement) {
			var oRootDom = sap.ui.getCore().byId(sRootElement).getDomRef();
			jQuery(oRootDom).find(":focusable:not([tabIndex=-1], #overlay-container *)").each(function(iIndex, oNode) {
				oNode.setAttribute("data-sap-ui-dt-tabindex", oNode.tabIndex);
				oNode.setAttribute("tabIndex", -1);
			});
		});
	};

	/**
	 * Restore the tab indices of all elements of the DOM tree
	 */
	TabHandling.prototype.restoreTabIndex = function() {
		jQuery("[data-sap-ui-dt-tabindex]").each(function(iIndex, oNode) {
			oNode.setAttribute("tabIndex", oNode.getAttribute("data-sap-ui-dt-tabindex"));
			oNode.removeAttribute("data-sap-ui-dt-tabindex");
		});
	};

	/**
	 * @private
	 */
	TabHandling.prototype._onDomChanged = function() {
		if (this.getDesignTime().getEnabled()) {
			this.removeTabIndex();
		}
	};

	return TabHandling;
}, /* bExport= */true);

}; // end of sap/ui/dt/plugin/TabHandling.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.AggregationDesignTimeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.AggregationDesignTimeMetadata.
jQuery.sap.declare('sap.ui.dt.AggregationDesignTimeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/AggregationDesignTimeMetadata",[
	'jquery.sap.global',
	'sap/ui/dt/DesignTimeMetadata'
],
function (jQuery, DesignTimeMetadata) {
	"use strict";


	/**
	 * Constructor for a new AggregationDesignTimeMetadata.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The AggregationDesignTimeMetadata is a wrapper for the AggregationDesignTimeMetadata of the associated element
	 * @extends sap.ui.core.DesignTimeMetadata
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.AggregationDesignTimeMetadata
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var AggregationDesignTimeMetadata = DesignTimeMetadata.extend("sap.ui.dt.AggregationDesignTimeMetadata", /** @lends sap.ui.dt.AggregationDesignTimeMetadata.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt"
		}
	});

	AggregationDesignTimeMetadata.prototype.getPropagation = function(oElement, callback) {
		var mData = this.getData();
		if (!mData.propagationInfos) {
			return false;
		}
		mData.propagationInfos.some(function(oPropagatedInfo){
			return callback(oPropagatedInfo);
		});
	};

	AggregationDesignTimeMetadata.prototype.getRelevantContainerForPropagation = function(oElement) {
		var mData = this.getData();
		var vRelevantContainerElement = false;
		if (!mData.propagationInfos) {
			return false;
		}

		this.getPropagation(oElement, function(oPropagatedInfo){
			if (oPropagatedInfo.relevantContainerFunction &&
				oPropagatedInfo.relevantContainerFunction(oElement)) {
				vRelevantContainerElement = oPropagatedInfo.relevantContainerElement;
				return true;
			}
		});

		return vRelevantContainerElement ? vRelevantContainerElement : false;
	};

	AggregationDesignTimeMetadata.prototype.getMetadataForPropagation = function(oElement) {
		var vReturnMetadata = false;

		this.getPropagation(oElement, function(oPropagatedInfo) {
			if (oPropagatedInfo.metadataFunction) {
				vReturnMetadata = oPropagatedInfo.metadataFunction(oElement, oPropagatedInfo.relevantContainerElement);
				return vReturnMetadata ? true : false;
			}
		});
		return vReturnMetadata ? vReturnMetadata : false;
	};

	return AggregationDesignTimeMetadata;
}, /* bExport= */ true);

}; // end of sap/ui/dt/AggregationDesignTimeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.AggregationOverlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.AggregationOverlay.
jQuery.sap.declare('sap.ui.dt.AggregationOverlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/AggregationOverlay",[
	'jquery.sap.global',
	'sap/ui/dt/Overlay'
],
function(jQuery, Overlay) {
	"use strict";


	/**
	 * Constructor for an AggregationOverlay.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The AggregationOverlay allows to create an absolute positioned DIV above the aggregation
	 * of an element.
	 * @extends sap.ui.core.Overlay
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.AggregationOverlay
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var AggregationOverlay = Overlay.extend("sap.ui.dt.AggregationOverlay", /** @lends sap.ui.dt.AggregationOverlay.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Name of aggregation to create the AggregationOverlay for
				 */
				aggregationName : {
					type : "string"
				},
				/**
				 * Whether the AggregationOverlay is e.g. a drop target
				 */
				targetZone : {
					type : "boolean",
					defaultValue : false
				}
			},
			aggregations : {
				/**
				 * Overlays for the elements, which are public children of this aggregation
				 */
				children : {
					type : "sap.ui.dt.Overlay",
					multiple : true
				},
				/**
				 * [designTimeMetadata description]
				 * @type {Object}
				 */
				designTimeMetadata : {
					type : "sap.ui.dt.AggregationDesignTimeMetadata",
					multiple : false
				}
			},
			events : {
				/**
				 * Event fired when the property "targetZone" was changed
				 */
				targetZoneChange : {
					parameters : {
						targetZone : { type : "boolean" }
					}
				}
			}
		}
	});

	/**
	 * Returns a DOM representation for an aggregation, associated with this AggregationOverlay, if it can be found or undefined
	 * Representation is searched in DOM based on DesignTimeMetadata defined for the parent Overlay
	 * @return {jQuery} Associated with this AggregationOverlay DOM Element or null, if it can't be found
	 * @public
	 */
	AggregationOverlay.prototype.getAssociatedDomRef = function() {
		var oElement = this.getElementInstance();
		var sAggregationName = this.getAggregationName();
		var oDesignTimeMetadata = this.getDesignTimeMetadata();

		return oDesignTimeMetadata.getAssociatedDomRef(
			oElement,
			oDesignTimeMetadata.getDomRef(),
			sAggregationName
		);
	};

	/**
	 * Sets a property "targetZone", toggles a CSS class for the DomRef based on a property's value and fires "targetZoneChange" event
	 * @param {boolean} bTargetZone state to set
	 * @returns {sap.ui.dt.AggregationOverlay} returns this
	 * @public
	 */
	AggregationOverlay.prototype.setTargetZone = function(bTargetZone) {
		if (this.getTargetZone() !== bTargetZone) {
			this.setProperty("targetZone", bTargetZone);
			this.toggleStyleClass("sapUiDtOverlayTargetZone", bTargetZone);

			this.fireTargetZoneChange({targetZone : bTargetZone});
		}

		return this;
	};

	/**
	 * Returns if the AggregationOverlay is a target zone
	 * @public
	 * @return {boolean} if the AggregationOverlay is a target zone
	 */
	AggregationOverlay.prototype.isTargetZone = function() {
		return this.getTargetZone();
	};

	/**
	 * Returns if the AggregationOverlay is an association
	 * @public
	 * @return {boolean} if the AggregationOverlay is an association
	 */
	AggregationOverlay.prototype.isAssociation = function() {
		return !!this.getDesignTimeMetadata().getData().aggregationLike;
	};

	/**
	 * Returns an array with Overlays for the public children of the aggregation, associated with this AggregationOverlay
	 * @return {sap.ui.dt.Overlay[]} children Overlays
	 * @public
	 */
	AggregationOverlay.prototype.getChildren = function() {
		return this.getAggregation("children") || [];
	};

	/**
	 * @inheritDoc
	 */
	AggregationOverlay.prototype._getScrollContainerIndex = function(oOverlayParent, oOverlay) {
		var iScrollContainerIndex;
		oOverlay = oOverlay || this;
		if (oOverlayParent._aScrollContainers) {
			iScrollContainerIndex = -1;
			oOverlayParent._aScrollContainers.some(function(oScrollContainer, iIndex) {
				if (oScrollContainer.aggregations) {
					return oScrollContainer.aggregations.some(function(sAggregationName) {
						if (oOverlay.getAggregationName() === sAggregationName) {
							iScrollContainerIndex = iIndex;
							return true;
						}
					});
				}
			});
		}
		return iScrollContainerIndex;
	};

	return AggregationOverlay;
}, /* bExport= */ true);

}; // end of sap/ui/dt/AggregationOverlay.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementDesignTimeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ElementDesignTimeMetadata.
jQuery.sap.declare('sap.ui.dt.ElementDesignTimeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/ElementDesignTimeMetadata",[
	'jquery.sap.global',
	'sap/ui/dt/DesignTimeMetadata',
	'sap/ui/dt/AggregationDesignTimeMetadata'
],
function(jQuery, DesignTimeMetadata, AggregationDesignTimeMetadata) {
	"use strict";


	/**
	 * Constructor for a new ElementDesignTimeMetadata.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementDesignTimeMetadata is a wrapper for the ElementDesignTimeMetadata of the associated element
	 * @extends sap.ui.core.DesignTimeMetadata
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ElementDesignTimeMetadata
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementDesignTimeMetadata = DesignTimeMetadata.extend("sap.ui.dt.ElementDesignTimeMetadata", /** @lends sap.ui.dt.ElementDesignTimeMetadata.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt"
		}
	});

	/**
	 * Returns the default DT metadata
	 * @return {Object} default data
	 * @override
	 */
	ElementDesignTimeMetadata.prototype.getDefaultData = function(oData) {
		var oDefaultData = DesignTimeMetadata.prototype.getDefaultData.apply(this, arguments);

		oDefaultData.aggregations  = {
			layout : {
				ignore : true
			},
			dependents : {
				ignore : true
			},
			customData : {
				ignore : true
			},
			layoutData : {
				ignore : true
			},
			tooltip: {
				ignore : true
			}
		};

		return oDefaultData;
	};

	/**
	 * Returns if the DT metadata for an aggregation name exists
	 * @param {string} sAggregationName an aggregation name
	 * @return {boolean} returns if the field for an aggregation with a given name exists in DT metadata
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.hasAggregation = function(sAggregationName) {
		return !!this.getAggregations()[sAggregationName];
	};

	/**
	 * Returns the plain DT metadata for an aggregation name,
	 * including also aggregation-like associations
	 * @param {string} sAggregationName an aggregation name
	 * @return {object} returns the DT metadata for an aggregation with a given name
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.getAggregation = function(sAggregationName) {
		return this.getAggregations()[sAggregationName];
	};

	/**
	 * Creates an aggregation DT metadata class for an aggregation,
	 * ensure to destroy it if it is no longer needed, otherwise you get memory leak.
	 * @param {string} sAggregationName an aggregation name
	 * @return {sap.ui.dt.AggregationDesignTimeMetadata} returns the aggregation DT metadata for an aggregation with a given name
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.createAggregationDesignTimeMetadata  = function(sAggregationName) {
		var oData =  this.getAggregation(sAggregationName);
		return new AggregationDesignTimeMetadata({
			libraryName : this.getLibraryName(),
			data : oData
		});
	};

	/**
	 * Returns the DT metadata for all aggregations,
	 * including also aggregation-like associations
	 * @return {map} returns the DT metadata for all aggregations
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.getAggregations = function() {
		var mAggregations = this.getData().aggregations;
		var mAssociations = this.getData().associations || {};
		Object.keys(mAssociations).forEach(function(sAssociation){
			var mAssociation = mAssociations[sAssociation];
			if (mAssociation.aggregationLike){
				mAggregations[sAssociation] = mAssociation;
			}
		});
		return mAggregations;
	};

	/**
	 * Returns the relevant container of an element
	 * This is usually the getParent or the value from a function in DTMetadata
	 * @param {object} oElement the element for which the relevant container has to be evaluated
	 * @return {object} returns the relevant container
	 * @public
	 */
	//TODO: Remove this method as soon as DTMetadata propagation is finalized
	ElementDesignTimeMetadata.prototype.getRelevantContainer = function(oElement) {
		var fnGetRelevantContainer = this.getData().getRelevantContainer;
		if (!fnGetRelevantContainer || typeof fnGetRelevantContainer !== "function") {
			return oElement.getParent();
		}
		return fnGetRelevantContainer(oElement);
	};

	ElementDesignTimeMetadata.prototype.getAggregationAction = function(sAction, oElement, aArgs) {
		var vAction;
		var oAggregations = this.getAggregations();
		var aActions = [];

		for (var sAggregation in oAggregations) {
			if (oAggregations[sAggregation].actions && oAggregations[sAggregation].actions[sAction]) {
				vAction = oAggregations[sAggregation].actions[sAction];
				if (typeof vAction === "function") {
					var aActionParameters = [oElement];
					if (aArgs){
						aActionParameters = aActionParameters.concat(aArgs);
					}
					vAction = vAction.apply(null, aActionParameters);
				} else if (typeof (vAction) === "string" ) {
					vAction = { changeType : vAction };
				}
				if (vAction) {
					vAction.aggregation = sAggregation;
				}
				aActions.push(vAction);
			}
		}
		return aActions;
	};

	ElementDesignTimeMetadata.prototype._getText = function(vName){
		if (typeof vName === "function") {
			return vName();
		} else {
			return this.getLibraryText(vName);
		}
	};

	ElementDesignTimeMetadata.prototype.getAggregationDescription = function(sAggregationName, oElement){
		var vChildNames = this.getAggregation(sAggregationName).childNames;
		if (typeof vChildNames === "function") {
			vChildNames = vChildNames.call(null, oElement);
		}
		if (vChildNames){
			return {
				singular : this._getText(vChildNames.singular),
				plural : this._getText(vChildNames.plural)
			};
		}
	};

	ElementDesignTimeMetadata.prototype.getName = function(oElement){
		var vName = this.getData().name;
		if (typeof vName === "function") {
			vName = vName.call(null, oElement);
		}
		if (vName){
			return {
				singular : this._getText(vName.singular),
				plural : this._getText(vName.plural)
			};
		}
	};

	/**
	 * Returns property "ignore" of aggregation DT metadata
	 * @param {Object} oElement Element whose aggregation has to be checked
	 * @param {String} sAggregationName Name of the Aggregation
	 * @return {boolean} if ignored
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.isAggregationIgnored = function(oElement, sAggregationName) {
		var mAggregations = this.getAggregations();
		var oAggregationMetadata = mAggregations[sAggregationName];
		var vIgnore = (oAggregationMetadata) ? oAggregationMetadata.ignore : false;
		if (!vIgnore || (vIgnore && typeof vIgnore === "function" && !vIgnore(oElement))) {
			return false;
		} else {
			return true;
		}
	};

	/**
	 * Returns the scroll containers or an empty array
	 *
	 * @return {array} scrollContainers or empty array
	 * @public
	 */
	ElementDesignTimeMetadata.prototype.getScrollContainers = function() {
		return this.getData().scrollContainers || [];
	};

	return ElementDesignTimeMetadata;
}, /* bExport= */ true);

}; // end of sap/ui/dt/ElementDesignTimeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.ElementOverlay') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.ElementOverlay.
jQuery.sap.declare('sap.ui.dt.ElementOverlay'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/dt/ElementOverlay",[
	'sap/ui/dt/Overlay',
	'sap/ui/dt/ControlObserver',
	'sap/ui/dt/ManagedObjectObserver',
	'sap/ui/dt/ElementDesignTimeMetadata',
	'sap/ui/dt/AggregationDesignTimeMetadata',
	'sap/ui/dt/AggregationOverlay',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/OverlayUtil',
	'sap/ui/dt/DOMUtil'
],
function(Overlay, ControlObserver, ManagedObjectObserver, ElementDesignTimeMetadata, AggregationDesignTimeMetadata, AggregationOverlay, OverlayRegistry, ElementUtil, OverlayUtil, DOMUtil) {
	"use strict";

	/**
	 * Constructor for an ElementOverlay.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementOverlay allows to create an absolute positioned DIV above the associated element.
	 * It also creates AggregationOverlays for every public aggregation of the associated element.
	 * @extends sap.ui.core.Control
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.ElementOverlay
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementOverlay = Overlay.extend("sap.ui.dt.ElementOverlay", /** @lends sap.ui.dt.ElementOverlay.prototype */ {
		metadata : {

			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			associations: {
				/**
				 * Array of plugins, that set editable to true
				 */
				editableByPlugins : {
					type : "any[]",
					multiple : true,
					singularName: "editableByPlugin"
				}
			},
			properties : {
				/**
				 * Whether the ElementOverlay is selected
				 */
				selected : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the ElementOverlay is selectable, per default this implicitly makes the overlay focusable (TODO discuss)
				 */
				selectable : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the ElementOverlay is movable
				 */
				movable : {
					type : "boolean",
					defaultValue : false
				},
				/**
				 * Whether the ElementOverlay is editable
				 */
				editable : {
					type : "boolean",
					defaultValue : false
				}
			},
			aggregations : {
				/**
				 * AggregationOverlays for the public aggregations of the associated Element
				 */
				aggregationOverlays : {
					type : "sap.ui.dt.AggregationOverlay",
					multiple : true
				},
				/**
				 * [designTimeMetadata description]
				 * @type {Object}
				 */
				designTimeMetadata : {
					type : "sap.ui.dt.ElementDesignTimeMetadata",
					altTypes : ["object"],
					multiple : false
				}
			},
			events : {
				/**
				 * Event fired when the property "Selection" is changed
				 */
				selectionChange : {
					parameters : {
						selected : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the property "Movable" is changed
				 */
				movableChange : {
					parameters : {
						movable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the property "Selectable" is changed
				 */
				selectableChange : {
					parameters : {
						selectable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the property "Editable" is changed
				 */
				editableChange : {
					parameters : {
						editable : { type : "boolean" }
					}
				},
				/**
				 * Event fired when the associated Element is modified
				 */
				elementModified : {
					parameters : {
						type : "string",
						name : "string",
						value : "any",
						oldValue : "any",
						target : "sap.ui.core.Element"
					}
				},
				/**
				 * TODO
				 */
				requestElementOverlaysForAggregation : {
					parameters : {
						name : { type : "string" }
					}
				}
			}
		}
	});

	/**
	 * Called when the ElementOverlay is initialized
	 * @protected
	 */
	ElementOverlay.prototype.init = function() {
		Overlay.prototype.init.apply(this, arguments);

		this._oMutationObserver = Overlay.getMutationObserver();
		this._oMutationObserver.attachDomChanged(this._onDomChanged, this);
	};

	/**
	 * Called when the ElementOverlay is destroyed
	 * @protected
	 */
	ElementOverlay.prototype.exit = function() {
		if (this._oMutationObserver) {
			this._oMutationObserver.detachDomChanged(this._onDomChanged, this);
			delete this._oMutationObserver;
		}

		Overlay.prototype.exit.apply(this, arguments);

		this._unobserve();
		OverlayRegistry.deregister(this._sElementId);

		if (!OverlayRegistry.hasOverlays()) {
			Overlay.destroyMutationObserver();
			Overlay.removeOverlayContainer();
		}

		delete this._sElementId;
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.applyStyles = function() {
		var oGeometry = this.getGeometry();
		if (oGeometry && oGeometry.visible) {
			this._sortAggregationOverlaysInDomOrder();
		}

		Overlay.prototype.applyStyles.apply(this, arguments);
	};

	/**
	 * Sorts aggregation overlays in there UI order
	 * @private
	 */
	ElementOverlay.prototype._sortAggregationOverlaysInDomOrder = function() {
		// compares two aggregations domRefs and returns 1, if first aggregation should be bellow in dom order
		var fnCompareAggregations = function(oAggregationOverlay1, oAggregationOverlay2) {
			var oGeometry1 = oAggregationOverlay1.getGeometry();
			var oGeometry2 = oAggregationOverlay2.getGeometry();
			var oPosition1 = oGeometry1 && oGeometry1.position;
			var oPosition2 = oGeometry2 && oGeometry2.position;

			if (oPosition1 && oPosition2) {
				var iBottom1 = oPosition1.top + oGeometry1.size.height;
				var iBottom2 = oPosition2.top + oGeometry2.size.height;

				if (oPosition1.top < oPosition2.top) {
					if (iBottom1 >= iBottom2 && oPosition2.left < oPosition1.left) {
						/*  Example:
							            +--------------+
							+------+    |              |
							|  2   |    |       1      |
							+------+    |              |
							            +--------------+
							Despites 1st overlay's top is above 2nd element,
							the order should be switched, since 2nd element
							is shorter and is more to the left
						 */
						return 1;
					} else {
						return -1; // do not switch order
					}
				} else

				if (oPosition1.top === oPosition2.top) {
					if (oPosition1.left === oPosition2.left) {
						return 0;
					} else if (oPosition1.left < oPosition2.left) {
						return -1; // order is correct
					} else {
						return 1; // switch order
					}
				} else

				// if (oPosition1.top > oPosition2.top)
				 if (iBottom1 <= iBottom2 && oPosition2.left > oPosition1.left) {
					/* see picture above, but switch 1 and 2 - order is correct */
					return -1;
				} else {
					/*  Example:
						            +--------------+
						+------+    |       2      |
						|  1   |    +--------------+
						|      |
						+------+

						Since 1st overlay's both top and bottom coordinates are
						bellow in dom, then top and bottom of 2nd, they should be switched
					 */
					return 1;
				}
			}
		};

		var aSortedAggregationOverlays = this.getAggregationOverlays().sort(fnCompareAggregations);

		var bOrderSwitched = this.getAggregationOverlays().some(function(oOverlay, index) {
			if (oOverlay.getId() !== aSortedAggregationOverlays[index].getId()) {
				return true;
			}
		});

		if (bOrderSwitched) {
			// insert in sorted order & suppress invalidate to prevent rerendering
			this.removeAllAggregation("aggregationOverlays", true);
			aSortedAggregationOverlays.forEach(function(oAggregationOverlay) {
				// suppress invalidate to prevent rerendering
				this.addAggregation("aggregationOverlays", oAggregationOverlay, true);
			}.bind(this));
		}
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.setLazyRendering = function(bLazyRendering) {
		Overlay.prototype.setLazyRendering.apply(this, arguments);

		if (!bLazyRendering) {
			this.placeInOverlayContainer();
		}
	};

	/**
	 * Places this ElementOverlay in an overlay container, which causes a rendering only if overlay wasn't rendered before
	 * Overlay won't be visible without a call of this method
	 * @public
	 */
	ElementOverlay.prototype.placeInOverlayContainer = function() {
		if (!this.getParent()) {
			this.placeAt(Overlay.getOverlayContainer());
			// this is needed to prevent UI5 renderManager from removing overlay's node from DOM in a rendering phase
			// see RenderManager.js "this._fPutIntoDom" function
			var oUIArea = this.getUIArea();
			oUIArea._onChildRerenderedEmpty = function() {
				return true;
			};
		}
	};

	/**
	 * Sets an associated Element to create an overlay for
	 * @param {string|sap.ui.core.Element} vElement element or element's id
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setElement = function(vElement) {
		var oOldElement = this.getElementInstance();
		if (oOldElement instanceof sap.ui.core.Element) {
			OverlayRegistry.deregister(oOldElement);
			this._unobserve();
		}

		this.setAssociation("element", vElement);
		var oElement = this.getElementInstance();

		this._sElementId = oElement.getId();
		OverlayRegistry.register(oElement, this);
		this._observe(oElement);

		if (this.getDesignTimeMetadata()) {
			this._renderAndCreateAggregation();
		}

		return this;
	};

	ElementOverlay.prototype._addPropagationInfos = function(oDesignTimeMetadata) {
		var oParentOverlay = this.getParentAggregationOverlay(),
			oParentElementOverlay;

		var oElement = this.getElementInstance();

		if (!oParentOverlay && oElement) {
			oParentElementOverlay = OverlayRegistry.getOverlay(oElement.getParent());
			if (oParentElementOverlay && oElement.sParentAggregationName) {
				oParentOverlay = oParentElementOverlay.getAggregationOverlay(oElement.sParentAggregationName);
			}
		}
		if (!oParentOverlay){
			return false;
		}

		var oParentDesignTimeMetadata = oParentOverlay.getDesignTimeMetadata();
		var vRelevantContainerElement = oParentDesignTimeMetadata.getRelevantContainerForPropagation(oElement);
		var vReturnMetadata = oParentDesignTimeMetadata.getMetadataForPropagation(oElement);
		if (!vRelevantContainerElement && !vReturnMetadata) {
			return false;
		}

		if (vRelevantContainerElement) {
			oDesignTimeMetadata.getData().relevantContainer = vRelevantContainerElement;
		}

		if (vReturnMetadata){
			var oData = oDesignTimeMetadata.getData();
			if (vReturnMetadata.actions === null) {
				var mAggregations = oElement.getMetadata().getAllAggregations();
				var aAggregationNames = Object.keys(mAggregations);
				aAggregationNames = aAggregationNames.concat(
					Object.keys(oData.aggregations).filter(function (sAggregationName) {
				    return aAggregationNames.indexOf(sAggregationName) < 0;
				}));

				aAggregationNames.forEach(function(sAggregationName) {
					if (oData.aggregations[sAggregationName] && oData.aggregations[sAggregationName].actions) {
						oData.aggregations[sAggregationName].actions = null;
					}
				});
			}
			jQuery.extend(true, oData, vReturnMetadata);
		}

		return true;
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.setDesignTimeMetadata = function(vDesignTimeMetadata) {
		var oDesignTimeMetadata;
		if (vDesignTimeMetadata instanceof ElementDesignTimeMetadata) {
			oDesignTimeMetadata = vDesignTimeMetadata;
		} else {
			oDesignTimeMetadata = new ElementDesignTimeMetadata({
				libraryName : this.getElementInstance().getMetadata().getLibraryName(),
				data : vDesignTimeMetadata
			});
		}
		if (!this._oOriginalDesignTimeMetadata){
			this._oOriginalDesignTimeMetadata = oDesignTimeMetadata;
		}
		this._addPropagationInfos(oDesignTimeMetadata);
		var oReturn = this.setAggregation("designTimeMetadata", oDesignTimeMetadata);

		if (this.getElementInstance()) {
			this._aScrollContainers = this.getDesignTimeMetadata().getScrollContainers();
			this._renderAndCreateAggregation();
		}

		return oReturn;
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._renderAndCreateAggregation = function() {
		// detach all children, so then they won't be destroyed
		this.getAggregationOverlays().forEach(function(oAggregationOverlay) {
			oAggregationOverlay.getChildren().forEach(function(oElementOverlay) {
				oElementOverlay.setParent(null);
			});
		});
		this.destroyAggregationOverlays();

		this._createAggregationOverlays();

		var oParentElementOverlay = OverlayUtil.getClosestOverlayFor(this.getElementInstance().getParent());
		if (oParentElementOverlay) {
			oParentElementOverlay.sync();
		}
	};

	/**
	 * Returns a jQuery Object reference for the associated Element or undefined, if it can't be found
	 * @return {jQuery} jQuery object or undefined
	 * @public
	 */
	ElementOverlay.prototype.getAssociatedDomRef = function() {
		var oDomRef = ElementUtil.getDomRef(this.getElementInstance());
		if (!oDomRef) {
			var oDesignTimeMetadata = this.getDesignTimeMetadata();
			if (!oDesignTimeMetadata) {
				return undefined;
			}
			var fnGetDomRef = oDesignTimeMetadata.getDomRef();
			if (typeof fnGetDomRef === "function") {
				oDomRef = fnGetDomRef(this.getElementInstance());
			}
		}

		if (oDomRef) {
			return jQuery(oDomRef);
		}
		return undefined;
	};

	/**
	 * Sets whether the ElementOverlay is selectable
	 * @param {boolean} bSelectable if the ElementOverlay is selectable
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setSelectable = function(bSelectable) {
		bSelectable = !!bSelectable;
		if (bSelectable !== this.isSelectable()) {

			if (!bSelectable) {
				this.setSelected(false);
			}

			this.toggleStyleClass("sapUiDtOverlaySelectable", bSelectable);
			this.setProperty("selectable", bSelectable);
			this.fireSelectableChange({selectable : bSelectable});
		}
		this.setFocusable(bSelectable);
		return this;
	};

	/**
	 * Sets whether the ElementOverlay is selected and toggles corresponding css class
	 * @param {boolean} bSelected if the ElementOverlay is selected
	 * @param {boolean} bSuppressEvent (internal use only) suppress firing "selectionChange" event
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setSelected = function(bSelected, bSuppressEvent) {
		bSelected = !!bSelected;
		if (this.isSelectable() && bSelected !== this.isSelected()) {
			this.setProperty("selected", bSelected);
			this.toggleStyleClass("sapUiDtOverlaySelected", bSelected);

			if (!bSuppressEvent) {
				this.fireSelectionChange({
					selected : bSelected
				});
			}
		}

		return this;
	};

	/**
	 * Sets whether the ElementOverlay is movable and toggles corresponding css class
	 * @param {boolean} bMovable if the ElementOverlay is movable
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setMovable = function(bMovable) {
		bMovable = !!bMovable;
		if (this.getMovable() !== bMovable) {
			this.toggleStyleClass("sapUiDtOverlayMovable", bMovable);

			this.setProperty("movable", bMovable);
			this.fireMovableChange({movable : bMovable});
		}

		return this;
	};

	/**
	 * Sets whether the ElementOverlay is editable and toggles corresponding css class
	 * @param {boolean} bEditable if the ElementOverlay is editable
	 * @returns {sap.ui.dt.ElementOverlay} returns this
	 * @public
	 */
	ElementOverlay.prototype.setEditable = function(bEditable) {
		bEditable = !!bEditable;
		if (this.getEditable() !== bEditable) {
			this.toggleStyleClass("sapUiDtOverlayEditable", bEditable);

			this.setProperty("editable", bEditable);
			this.fireEditableChange({editable : bEditable});
		}

		return this;
	};

	/**
	 * @public
	 */
	ElementOverlay.prototype.sync = function() {
		var aAggregationOverlays = this.getAggregationOverlays();
		aAggregationOverlays.forEach(function(oAggregationOverlay) {
			this._syncAggregationOverlay(oAggregationOverlay);
		}, this);
	};

	ElementOverlay.prototype._getParentRelevantContainerPropagation = function() {
		var oParentAggregationOverlay = this.getParent();
		var oCopyOfParentPropagation = [];

		if (oParentAggregationOverlay &&
			oParentAggregationOverlay.getAggregation("designTimeMetadata")) {
			jQuery.extend(oCopyOfParentPropagation, oParentAggregationOverlay.getDesignTimeMetadata().getData()["propagationInfos"]);
			return oCopyOfParentPropagation;
		}
		return false;
	};

	ElementOverlay.prototype._getCurrentRelevantContainerPropagation = function(oElementDtMetadataForAggregation, oNewPropagationInfo) {
		if (!oElementDtMetadataForAggregation.propagateRelevantContainer) {
			return false;
		} else if (typeof oElementDtMetadataForAggregation.propagateRelevantContainer === "function") {
			oNewPropagationInfo.relevantContainerFunction = oElementDtMetadataForAggregation.propagateRelevantContainer;
			oNewPropagationInfo.relevantContainerElement = this.getElementInstance();
		} else if (typeof oElementDtMetadataForAggregation.propagateRelevantContainer === "boolean" &&
			oElementDtMetadataForAggregation.propagateRelevantContainer) {
			oNewPropagationInfo.relevantContainerFunction = function() { return true; };
			oNewPropagationInfo.relevantContainerElement = this.getElementInstance();
		} else {
			throw new Error("wrong type: it should be either a function or a boolean value and it is:" +
				typeof oElementDtMetadataForAggregation.propagateRelevantContainer);
		}
		return true;
	};

	ElementOverlay.prototype._getCurrentDesigntimePropagation = function(oElementDtMetadataForAggregation, oNewPropagationInfo) {
		if (!oElementDtMetadataForAggregation.propagateMetadata) {
			return false;
		} else if (typeof oElementDtMetadataForAggregation.propagateMetadata === "function") {
			oNewPropagationInfo.relevantContainerElement = this.getElementInstance();
			oNewPropagationInfo.metadataFunction = oElementDtMetadataForAggregation.propagateMetadata;
		} else {
			throw new Error("wrong type: it should be a function and it is:",
				typeof oElementDtMetadataForAggregation.propagateMetadata);
		}
		return true;
	};

	ElementOverlay.prototype._propagateDesigntimeObj = function(oAggregationDtMetadata, oNewRelevantContainerPropagation, aPropagatedRelevantContainersFromParent) {
		var oAggregationData;

		if (!aPropagatedRelevantContainersFromParent &&
			!oNewRelevantContainerPropagation) {
			return false;
		}

		if (oNewRelevantContainerPropagation) {
			aPropagatedRelevantContainersFromParent = aPropagatedRelevantContainersFromParent ? aPropagatedRelevantContainersFromParent : [];
			aPropagatedRelevantContainersFromParent.push(oNewRelevantContainerPropagation);
		}

		// get designtime metadata data-object from current aggregation
		oAggregationData = oAggregationDtMetadata.getData();

		// add propagation array to current aggregation designtime-metadata
		oAggregationData.propagationInfos = aPropagatedRelevantContainersFromParent;

		// propagate relevant container
		oAggregationDtMetadata.setData(oAggregationData);

		return true;
	};

	ElementOverlay.prototype._handleDesigntimePropagation = function(oAggregationDtMetadata) {
		var oNewPropagationInfo = {
			relevantContainerFunction : null,
			relevantContainerElement : null,
			metadataFunction: null
		};
		var bNewContentAdded = false;

		var aPropagatedRelevantContainersFromParent = this._getParentRelevantContainerPropagation();

		var oDtMetadataForAggregation = oAggregationDtMetadata.getData();
		if (oDtMetadataForAggregation &&
			oDtMetadataForAggregation !== {}) {
			bNewContentAdded = (this._getCurrentRelevantContainerPropagation(oDtMetadataForAggregation, oNewPropagationInfo)
				|| bNewContentAdded);
			bNewContentAdded = (this._getCurrentDesigntimePropagation(oDtMetadataForAggregation, oNewPropagationInfo)
				|| bNewContentAdded);
		}

		if (bNewContentAdded === false) {
			oNewPropagationInfo = null;
		}

		if (aPropagatedRelevantContainersFromParent || oNewPropagationInfo) {
			return this._propagateDesigntimeObj(oAggregationDtMetadata, oNewPropagationInfo, aPropagatedRelevantContainersFromParent);
		} else {
			return false;
		}
	};

	/**
	 * @param {string} sAggregationName name of aggregation to be created
	 * @returns {object} aggregation overlay
	 * @private
	 */
	ElementOverlay.prototype._createAggregationOverlay = function(sAggregationName) {
		var oAggregationDesignTimeMetadata = this.getDesignTimeMetadata().createAggregationDesignTimeMetadata(sAggregationName);

		this._handleDesigntimePropagation(oAggregationDesignTimeMetadata);

		var oAggregationOverlay = new AggregationOverlay({
			aggregationName : sAggregationName,
			element : this.getElementInstance(),
			designTimeMetadata : oAggregationDesignTimeMetadata
		});
		this._mAggregationOverlays[sAggregationName] = oAggregationOverlay;
		this.addAggregation("aggregationOverlays", oAggregationOverlay);

		this._syncAggregationOverlay(oAggregationOverlay);

		oAggregationOverlay.attachVisibleChanged(this._onAggregationVisibleChanged, this);

		return oAggregationOverlay;
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._createAggregationOverlays = function() {
		this._mAggregationOverlays = {};

		var oElement = this.getElementInstance();
		var oDesignTimeMetadata = this.getDesignTimeMetadata();

		var mAggregationsWithOverlay = {};

		var mElementAggregations = oElement.getMetadata().getAllAggregations();
		var aElementAggregationNames = Object.keys(mElementAggregations);

		var bIgnored;
		aElementAggregationNames.forEach(function(sAggregationName) {
			bIgnored = oDesignTimeMetadata.isAggregationIgnored(oElement, sAggregationName);
			mAggregationsWithOverlay[sAggregationName] = !bIgnored;
			// create aggregation overlays which are not ignored in the DT Metadata
			if (!bIgnored) {
				this._createAggregationOverlay(sAggregationName);
			}
		}.bind(this));

		// create aggregation overlays also for a hidden aggregations and aggregation-like associations which are not ignored in the DT Metadata
		var mAggregationsMetadata = oDesignTimeMetadata.getAggregations();
		if (mAggregationsMetadata) {
			var aAggregationNames = Object.keys(mAggregationsMetadata);
			aAggregationNames.forEach(function (sAggregationName) {
				if (mAggregationsWithOverlay[sAggregationName] === undefined) {
					bIgnored = oDesignTimeMetadata.isAggregationIgnored(oElement, sAggregationName);
					if (!bIgnored) {
						this._createAggregationOverlay(sAggregationName);
					}
				}
			}, this);
		}

		this.sync();
	};

	/**
	 * @param {sap.ui.core.Element} oElement The element to observe
	 * @private
	 */
	ElementOverlay.prototype._observe = function(oElement) {
		if (oElement instanceof sap.ui.core.Control) {
			this._oObserver = new ControlObserver({
				target : oElement
			});
			this._oObserver.attachAfterRendering(this._onElementAfterRendering, this);
		} else {
			this._oObserver = new ManagedObjectObserver({
				target : oElement
			});
		}
		this._oObserver.attachModified(this._onElementModified, this);
		this._oObserver.attachDestroyed(this._onElementDestroyed, this);
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._unobserve = function() {
		if (this._oObserver) {
			this._oObserver.destroy();
		}
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	ElementOverlay.prototype._onAggregationVisibleChanged = function(oEvent) {
		var oAggregationOverlay = oEvent.getSource();
		this._syncAggregationOverlay(oAggregationOverlay);
	};

	/**
	 * @param {sap.ui.dt.AggregationOverlay} oAggregationOverlay to sync
	 * @private
	 */
	ElementOverlay.prototype._syncAggregationOverlay = function(oAggregationOverlay) {
		if (oAggregationOverlay.isVisible()) {
			var sAggregationName = oAggregationOverlay.getAggregationName();

			var bIsControl = this.getElementInstance() instanceof sap.ui.core.Control;
			// always create aggregations for Elements, because we can't check if they are visible correctly...
			if (!bIsControl || this._getElementInstanceVisible()) {
				if (!oAggregationOverlay.getChildren().length) {
					this.fireRequestElementOverlaysForAggregation({
						name : sAggregationName
					});
				}
			}

			OverlayUtil.iterateOverAggregationLikeChildren(this, sAggregationName, function(oAggregationElement) {
				var oChildElementOverlay = OverlayRegistry.getOverlay(oAggregationElement);
				if (oChildElementOverlay  && oChildElementOverlay.getParent() !== this) {
					oAggregationOverlay.addChild(oChildElementOverlay);
				}
			}.bind(this));
		}
	};


	/**
	 * @param {string} sAggregationName name of the aggregation
	 * @param {boolean} bSuppressInvalidate suppress invalidate
	 * @protected
	 */
	ElementOverlay.prototype.destroyAggregation = function(sAggregationName, bSuppressInvalidate) {
		Overlay.prototype.destroyAggregation.apply(this, arguments);

		if (sAggregationName === "aggregationOverlays") {
			delete this._mAggregationOverlays;
		}
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	ElementOverlay.prototype._onElementModified = function(oEvent) {
		var oParams = oEvent.getParameters();
		var sAggregationName = oEvent.getParameters().name;
		if (sAggregationName) {
			var oAggregationOverlay = this.getAggregationOverlay(sAggregationName);
			// private aggregations are also skipped
			if (oAggregationOverlay) {
				this.fireElementModified(oParams);
			}
		} else if (oEvent.getParameters().type === "setParent") {
			this.fireElementModified(oParams);
		}
		this.invalidate();
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	ElementOverlay.prototype._onDomChanged = function(oEvent) {
		var aIds = oEvent.getParameters().elementIds || [];
		var oElement = this.getElementInstance();
		if (oElement && aIds.indexOf(oElement.getId()) !== -1) {
			// if element's DOM turns visible (via DOM mutations, classes and so on)
			if (this._mGeometry && !this._mGeometry.visible) {
				delete this._mGeometry;
				this.invalidate();
			} else if (!this._mGeometry) {
				this.sync();
			}
		}

		// update styles (starting from root and update all overlay children)
		if (this.isRoot()) {
			this.applyStyles();
		}
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._onElementAfterRendering = function() {
		// initial rendering of a UI5 element is not catched with a mutation observer
		if (!this.getDomRef()) {
			this.invalidate();
		}
		// we should sync aggregations onAfterRendering, because elements (or aggregations) might be created invisible
		this.sync();
	};

	/**
	 * @private
	 */
	ElementOverlay.prototype._onElementDestroyed = function() {
		this.destroy();
	};

	/**
	 * Returns AggregationOverlays created for the public aggregations of the associated Element
	 * @return {sap.ui.dt.AggregationOverlay[]} array of the AggregationOverlays
	 * @public
	 */
	ElementOverlay.prototype.getAggregationOverlays = function() {
		return this.getAggregation("aggregationOverlays") || [];
	};

	/**
	 * @override
	 */
	ElementOverlay.prototype.getChildren = function() {
		return this.getAggregationOverlays();
	};

	/**
	 * Returns AggregationOverlay the public aggregations of the associated Element by aggregation name
	 * @param {string} sAggregationName name of the aggregation
	 * @return {sap.ui.dt.AggregationOverlay} AggregationOverlays for the aggregation
	 * @public
	 */
	ElementOverlay.prototype.getAggregationOverlay = function(sAggregationName) {
		if (this._mAggregationOverlays) {
			return this._mAggregationOverlays[sAggregationName];
		}
	};

	/**
	 * Returns closest ElementOverlay ancestor of this ElementOverlay or undefined, if no parent ElementOverlay exists
	 * @return {sap.ui.dt.ElementOverlay} ElementOverlay parent
	 * @public
	 */
	ElementOverlay.prototype.getParentElementOverlay = function() {
		var oParentAggregationOverlay = this.getParentAggregationOverlay();
		if (oParentAggregationOverlay) {
			return oParentAggregationOverlay.getParent();
		}
	};

	/**
	 * Returns closest AggregationOverlay ancestor of this ElementOverlay or null, if no parent AggregationOverlay exists
	 * @return {sap.ui.dt.AggregationOverlay} AggregationOverlay parent, which contains this ElementOverlay
	 * @public
	 */
	ElementOverlay.prototype.getParentAggregationOverlay = function() {
		var oParentAggregationOverlay = this.getParent();
		return oParentAggregationOverlay instanceof sap.ui.dt.AggregationOverlay ? oParentAggregationOverlay : null;
	};

	/**
	 * Returns if the ElementOverlay is selected
	 * @public
	 * @return {boolean} if the ElementOverlay is selected
	 */
	ElementOverlay.prototype.isSelected = function() {
		return this.getSelected();
	};

	/**
	 * Returns if the ElementOverlay is selectable
	 * @public
	 * @return {boolean} if the ElementOverlay is selectable
	 */
	ElementOverlay.prototype.isSelectable = function() {
		return this.getSelectable();
	};

	/**
	 * Returns if the ElementOverlay is movable
	 * @public
	 * @return {boolean} if the ElementOverlay is movable
	 */
	ElementOverlay.prototype.isMovable = function() {
		return this.getMovable();
	};

	/**
	 * Returns if the ElementOverlay is editable
	 * @public
	 * @return {boolean} if the ElementOverlay is editable
	 */
	ElementOverlay.prototype.isEditable = function() {
		return this.getEditable();
	};

	/**
	 * Returns if the overlay's elementInstance is visible in DOM (or is invisible, but consumes screen space, like opacity 0 or visibility hidden)
	 * @private
	 * @return {boolean} if the overlay's elementInstance is editable
	 */
	ElementOverlay.prototype._getElementInstanceVisible = function() {
		var oElement = this.getElementInstance();
		if (oElement) {
			var oGeometry = this.getGeometry();
			return oGeometry && oGeometry.visible;
		} else {
			return false;
		}

	};

	/**
	 * Returns the relevant container element for this overlay. As default the overlay parent element is returned
	 * @param {boolean} bForParent if true, the relevant container overlay is the overlay itself, if no relevant container is propagated in the designtime
	 * @return {sap.ui.core.Element} Relevant container element
	 * @public
	 */
	ElementOverlay.prototype.getRelevantContainer = function(bForParent) {
		var oDesignTimeMetadata = this.getDesignTimeMetadata();
		if (oDesignTimeMetadata &&
			oDesignTimeMetadata.getData().relevantContainer) {
			return oDesignTimeMetadata.getData().relevantContainer;
		} else if (bForParent) {
			return this.getElementInstance();
		}
		// setting the default value to direct parent
		var oParentOverlay = this.getParentElementOverlay();
		return oParentOverlay ? oParentOverlay.getElementInstance() : undefined;
	};

	return ElementOverlay;
}, /* bExport= */ true);

}; // end of sap/ui/dt/ElementOverlay.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.DesignTime') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.DesignTime.
jQuery.sap.declare('sap.ui.dt.DesignTime'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/DesignTime",[
	'sap/ui/base/ManagedObject',
	'sap/ui/dt/ElementOverlay',
	'sap/ui/dt/OverlayRegistry',
	'sap/ui/dt/Selection',
	'sap/ui/dt/ElementDesignTimeMetadata',
	'sap/ui/dt/ElementUtil',
	'sap/ui/dt/Overlay',
	'sap/ui/dt/OverlayUtil',
	'./library'
],
function(ManagedObject, ElementOverlay, OverlayRegistry, Selection, ElementDesignTimeMetadata, ElementUtil, Overlay, OverlayUtil) {
	"use strict";

	/**
	 * Constructor for a new DesignTime.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The DesignTime allows to create a set of Overlays above the root elements and
	 * their public children and manage theire events.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.30
	 * @alias sap.ui.dt.DesignTime
	 * @experimental Since 1.30. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var DesignTime = ManagedObject.extend("sap.ui.dt.DesignTime", /** @lends sap.ui.dt.DesignTime.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				/**
				 * Selection mode which should be used for overlays selection
				 */
				selectionMode : {
					type : "sap.ui.dt.SelectionMode",
					defaultValue : sap.ui.dt.SelectionMode.Single
				},

				/**
				 * DesignTime metadata for classses to use with overlays (will overwrite default DTMetadata fields)
				 * should have a map structure { "sClassName" : oDesignTimeMetadata, ... }
				 */
				 designTimeMetadata : {
					type : "object"
				 },

				/**
				 * Whether overlays of DT are enabled (shown on the screen). When 'false', DT is still
				 * working, but overlays do not recalculate their styles.
				 */
				 enabled: {
					type: "boolean",
					defaultValue: true
				 }
			},
			associations : {
				/**
				 * Root elements to create overlays for
				 */
				rootElements : {
					type : "sap.ui.core.Element",
					multiple : true
				}
			},
			aggregations : {
				/**
				 * Plugins to use with a design time
				 */
				plugins : {
					type : "sap.ui.dt.Plugin",
					multiple : true
				}
			},
			events : {
				/**
				 * Event fired when an ElementOverlay is created and its designTimeMetadata is loaded
				 */
				elementOverlayCreated : {
					parameters : {
						elementOverlay : { type : "sap.ui.dt.ElementOverlay" }
					}
				},
				/**
				 * Event fired when an ElementOverlay is destroyed
				 */
				elementOverlayDestroyed : {
					parameters : {
						elementOverlay : { type : "sap.ui.dt.ElementOverlay" }
					}
				},
				/**
				 * Event fired when an overlays selection is changed
				 */
				selectionChange : {
					parameters : {
						selection : { type : "sap.ui.dt.Overlay[]" }
					}
				},
				/**
				 * Event fired when DesignTime is syncing overlays with a ControlTree of root elements
				 */
				syncing : {},
				/**
				 * Event fired when DesignTime's overlays are in-sync with ControlTree of root elements and registered at all known plugins
				 */
				synced : {},
				/**
				 * Event fired when DesignTime's overlays are in-sync with ControlTree of root elements
				 */
				syncedPureOverlays : {},
				/**
				 * Event fired when DesignTime's overlays failed to sync with ControlTree of root elements
				 */
				syncFailed : {}
			}
		}
	});

	/**
	 * Called when the DesignTime is initialized
	 * @protected
	 */
	DesignTime.prototype.init = function() {
		// number of element overlays waiting for their designTimeMetadata
		this._iOverlaysPending = 0;

		this._oSelection = this.createSelection();
		this._oSelection.attachEvent("change", function(oEvent) {
			this.fireSelectionChange({selection: oEvent.getParameter("selection")});
		}, this);

		this._collectOverlaysDuringSyncing();
	};

	DesignTime.prototype._collectOverlaysDuringSyncing = function() {
		// array of element overlays created between syncing and synced event
		this._aOverlaysCreatedInLastBatch = [];

		this.attachSyncing(function(){
			this._aOverlaysCreatedInLastBatch = [];
		}.bind(this));

		this.attachElementOverlayCreated(function(oEvent){
			var oNewOverlay = oEvent.getParameter("elementOverlay");
			this._aOverlaysCreatedInLastBatch.push(oNewOverlay);
		}.bind(this));

		this.attachSyncedPureOverlays(function(){
			var aPlugins = this.getPlugins();
			this._aOverlaysCreatedInLastBatch.forEach(function(oOverlay) {
				aPlugins.forEach(function(oPlugin) {
					oPlugin.callElementOverlayRegistrationMethods(oOverlay);
				});
			});

			this.fireSynced();
			this._aOverlaysCreatedInLastBatch = [];
		}.bind(this));
	};

	/**
	 * Called when the DesignTime is destroyed
	 * @protected
	 */
	DesignTime.prototype.exit = function() {
		delete this._iOverlaysPending;
		delete this._aOverlaysCreatedInLastBatch;

		// The plugins need to be destroyed before the overlays in order to go through the deregisterElementOverlay Methods
		this.getPlugins().forEach(function(oPlugin) {
			oPlugin.destroy();
		});

		this._destroyAllOverlays();
		this._oSelection.destroy();
	};

	/**
	 * Creates an instance of a Selection to handle the overlays selection inside of the DesignTime
	 * @return {sap.ui.dt.Selection} the instance of the Selection
	 * @protected
	 */
	DesignTime.prototype.createSelection = function() {
		return new Selection();
	};

	/**
	 * Returns array with current selected overlays
	 * @return {sap.ui.dt.Overlay[]} selected overlays
	 * @public
	 */
	DesignTime.prototype.getSelection = function() {
		return this._oSelection.getSelection();
	};

	/**
	 * Sets selection mode to be used in the Selection inside of the DesignTime
	 * @param {sap.ui.dt.SelectionMode} oMode a selection mode to be used with the Selection
	 * @return {sap.ui.dt.DesignTime} this
	 * @public
	 */
	DesignTime.prototype.setSelectionMode = function(oMode) {
		this.setProperty("selectionMode", oMode);
		this._oSelection.setMode(oMode);

		return this;
	};

	/**
	 * Returns all plugins used with the DesignTime
	 * @return {sap.ui.dt.Plugin[]} an array of plugins
	 * @protected
	 */
	DesignTime.prototype.getPlugins = function() {
		return this.getAggregation("plugins") || [];
	};

	/**
	 * Adds new plugin to use with the DesignTime
	 * @param {sap.ui.dt.Plugin} oPlugin to add
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.addPlugin = function(oPlugin) {
		oPlugin.setDesignTime(this);

		this.addAggregation("plugins", oPlugin);

		return this;
	};

	/**
	 * Inserts new plugin to use with the DesignTime at a defined position
	 * @param {sap.ui.dt.Plugin} oPlugin to insert
	 * @param {int} iIndex a position to insert the plugin at
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.insertPlugin = function(oPlugin, iIndex) {
		oPlugin.setDesignTime(this);

		this.insertAggregation("plugins", oPlugin, iIndex);

		return this;
	};

	/**
	 * Removes a plugin from the DesignTime
	 * @param {sap.ui.dt.Plugin} oPlugin to remove
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removePlugin = function(oPlugin) {
		this.getPlugins().forEach(function(oCurrentPlugin) {
			if (oCurrentPlugin === oPlugin) {
				oPlugin.setDesignTime(null);
				return;
			}
		});

		this.removeAggregation("plugins", oPlugin);

		return this;
	};

	/**
	 * Removes all plugins from the DesignTime
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removeAllPlugins = function() {
		this.getPlugins().forEach(function(oPlugin) {
			oPlugin.setDesignTime(null);
		});

		this.removeAllAggregation("plugins");

		return this;
	};

	/**
	 * Returns all root elements from the DesignTime
	 * @return {sap.ui.core.Element[]} rootElements of the DesignTime
	 * @protected
	 */
	DesignTime.prototype.getRootElements = function() {
		return this.getAssociation("rootElements") || [];
	};

	/**
	 * Returns a designTimeMetadata
	 * @return {map} designTimeMetadata
	 * @protected
	 */
	DesignTime.prototype.getDesignTimeMetadata = function() {
		return this.getProperty("designTimeMetadata") || {};
	};

	/**
	 * Returns a designTimeMetadata for the element or className
	 * @param {string|sap.ui.core.Element} vElement element or string witch is needed to expect classname
	 * @return {object} designTimeMetadata for a specific element or className
	 * @protected
	 */
	DesignTime.prototype.getDesignTimeMetadataFor = function(vElement) {
		var sClassName = vElement;
		var mDesignTimeMetadata = this.getDesignTimeMetadata();
		if (vElement.getMetadata) {
			sClassName = vElement.getMetadata().getName();
		}
		return mDesignTimeMetadata[sClassName];
	};

	/**
	 * Adds a root element to the DesignTime and creates overlays for it and it's public descendants
	 * @param {string|sap.ui.core.Element} vRootElement element or elemet's id
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.addRootElement = function(vRootElement) {
		this.addAssociation("rootElements", vRootElement);

		var oRootOverlay = this._createElementOverlay(ElementUtil.getElementInstance(vRootElement));

		// trigger rendering of all overlays only once after DesignTime is synced
		// to prevent rerendering of UIArea during async loading process
		this.attachEventOnce("synced", function() {
			oRootOverlay.placeInOverlayContainer();
		}, this);

		return this;
	};

	/**
	 * Removes a root element from the DesignTime and destroys overlays for it and it's public descendants
	 * @param {string|sap.ui.core.Element} vRootElement element or elemet's id
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removeRootElement = function(vRootElement) {
		this.removeAssociation("rootElements", vRootElement);

		this._destroyOverlaysForElement(ElementUtil.getElementInstance(vRootElement));

		return this;
	};

	/**
	 * Removes all root elements from the DesignTime and destroys overlays for them and theire public descendants
	 * @return {sap.ui.dt.DesignTime} this
	 * @protected
	 */
	DesignTime.prototype.removeAllRootElement = function() {
		this.removeAssociation("rootElements");

		this._destroyAllOverlays();

		return this;
	};


	/**
	 * Creates and returns the created instance of ElementOverlay for an element
	 * @param {string|sap.ui.core.Element} oElement to create ElementOverlay for
	 * @return {sap.ui.dt.ElementOverlay} created ElementOverlay
	 * @protected
	 */
	DesignTime.prototype.createElementOverlay = function(oElement) {
		return new ElementOverlay({
			element : oElement
		});
	};

	/**
	 * Returns an array with all element overlays created, registered and handled by the DesignTime
	 * @return {sap.ui.dt.ElementOverlay[]} all element overlays created and handled by the DesignTime
	 * @public
	 */
	DesignTime.prototype.getElementOverlays = function() {
		var aElementOverlays = [];

		this._iterateRootElements(function(oRootElement) {
			aElementOverlays = aElementOverlays.concat(this._getAllElementOverlaysIn(oRootElement));
		}, this);

		return aElementOverlays;
	};

	/**
	 * @param {sap.ui.core.Element} oElement element
	 * @return {sap.ui.dt.ElementOverlay} created or already existing instance of ElementOverlay for oElement
	 * @private
	 */
	DesignTime.prototype._createElementOverlay = function(oElement) {
		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		if (oElement && !oElement.bIsDestroyed && !oElementOverlay) {
			if (this._iOverlaysPending === 0) {
				this.fireSyncing();
			}
			this._iOverlaysPending++;

			oElementOverlay = this.createElementOverlay(oElement);
			if (oElementOverlay) {
				oElementOverlay.attachRequestElementOverlaysForAggregation(this._onRequestElementOverlaysForAggregation, this);
				oElementOverlay.attachElementModified(this._onElementModified, this);
				oElementOverlay.attachDestroyed(this._onElementOverlayDestroyed, this);
				oElementOverlay.attachSelectionChange(this._onElementOverlaySelectionChange, this);
			}

			ElementUtil.loadDesignTimeMetadata(oElement).then(function(oDesignTimeMetadata) {
				// if oElement is already destroyed while designtime metadata is loading
				if (!oElement || oElement.bIsDestroyed) {
					return;
				}
				// merge the DTMetadata from the DesignTime and from UI5
				var oMergedDesignTimeMetadata = oDesignTimeMetadata || {};

				jQuery.extend(true, oMergedDesignTimeMetadata, this.getDesignTimeMetadataFor(oElement));
				var oElementDesignTimeMetadata = new ElementDesignTimeMetadata({
					libraryName : oElement.getMetadata().getLibraryName(),
					data : oMergedDesignTimeMetadata});

				oElementOverlay.setDesignTimeMetadata(oElementDesignTimeMetadata);
				this.fireElementOverlayCreated({elementOverlay : oElementOverlay});
			}.bind(this)).catch(function(oError) {
				jQuery.sap.log.error("exception occured in sap.ui.dt.DesignTime._createElementOverlay", oError.stack || oError);
				if (oError instanceof Error) {
					this.fireSyncFailed();
				}
			}.bind(this)).then(function() {
				this._iOverlaysPending--;
				if (this._iOverlaysPending === 0) {
					this.fireSyncedPureOverlays();
				}
			}.bind(this));
		}

		return oElementOverlay;
	};

	/**
	 * Create an overlay for an element and register it in the DesignTime
	 * @param {sap.ui.core.Element} oElement element
	 * @return {sap.ui.dt.ElementOverlay} created ElementOverlay
	 * @public
	 */
	DesignTime.prototype.createOverlay = function(oElement) {
		return this._createElementOverlay(oElement);
	};

	/**
	 * @param {sap.ui.core.Element} oElement element
	 * @private
	 */
	DesignTime.prototype._destroyOverlaysForElement = function(oElement) {
		var oOverlay = OverlayRegistry.getOverlay(oElement);
		if (oOverlay) {
			oOverlay.destroy();
		}
	};

	/**
	 * @private
	 */
	DesignTime.prototype._destroyAllOverlays = function() {
		this._iterateRootElements(function(oRootElement) {
			this._destroyOverlaysForElement(oRootElement);
		}, this);
	};

	/**
	 * @param {sap.ui.core.ElementOverlay} oElementOverlay element overlay
	 * @param {string} sAggregationName name of the aggregation for which element overlays has to be created
	 * @private
	*/
	DesignTime.prototype._createChildOverlaysForAggregation = function(oElementOverlay, sAggregationName) {
		OverlayUtil.iterateOverAggregationLikeChildren(oElementOverlay, sAggregationName, function(oChild) {
			this._createElementOverlay(oChild);
		}.bind(this));
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	*/
	DesignTime.prototype._onRequestElementOverlaysForAggregation = function(oEvent) {
		var oElementOverlay = oEvent.getSource();

		var sAggregationName = oEvent.getParameter("name");
		this._createChildOverlaysForAggregation(oElementOverlay, sAggregationName);
		// if aggregation overlay is created without element overlay being created (not syncing),
		// the aggregation overlay must be registered on the plugins
		if (this._iOverlaysPending === 0){
			var aPlugins = this.getPlugins();
			aPlugins.forEach(function(oPlugin) {
				oPlugin.callAggregationOverlayRegistrationMethods(oElementOverlay);
			});
		}
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	*/
	DesignTime.prototype._onElementOverlayDestroyed = function(oEvent) {
		var oElementOverlay = oEvent.getSource();

		if (oElementOverlay.getSelected()) {
			this._oSelection.remove(oElementOverlay);
		}
		this.fireElementOverlayDestroyed({overlay : oElementOverlay});
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	DesignTime.prototype._onElementOverlaySelectionChange = function(oEvent) {
		var oElementOverlay = oEvent.getSource();
		var bSelected = oEvent.getParameter("selected");

		this._oSelection.set(oElementOverlay, bSelected);
	};

	/**
	 * @param {sap.ui.baseEvent} oEvent event object
	 * @private
	 */
	DesignTime.prototype._onElementModified = function(oEvent) {
		var oParams = oEvent.getParameters();
		if (oParams.type === "addOrSetAggregation" || oParams.type === "insertAggregation") {
			this._onElementOverlayAddAggregation(oParams.value, oParams.target, oParams.name);
		} else if (oParams.type === "setParent") {
			// timeout is needed because UI5 controls & apps can temporary "dettach" controls from control tree
			// and add them again later, so the check if the control is dettached from root element's tree is delayed
			setTimeout(function() {
				if (!this.bIsDestroyed) {
					this._checkIfOverlayShouldBeDestroyed(oParams.target);
				}
			}.bind(this), 0);
		}
	};

	/**
	 * @param {sap.ui.core.Element} oChild which was added
	 * @private
	 */
	DesignTime.prototype._onElementOverlayAddAggregation = function(oChild, oParent, sAggregationName) {
		var oParentOverlay = OverlayRegistry.getOverlay(oParent);
		var oParentAggregationOverlay = oParentOverlay.getAggregationOverlay(sAggregationName);
		// oElement can be of an alternative type (setLabel(sText) for example)
		if (oChild instanceof sap.ui.base.ManagedObject) {
			var oChildElementOverlay = OverlayRegistry.getOverlay(oChild);
			if (!oChildElementOverlay) {
				oChildElementOverlay = this._createElementOverlay(oChild);
				oParentAggregationOverlay.addChild(oChildElementOverlay);
			} else {
				// element overlay needs to have a correct parent for propagation
				oParentAggregationOverlay.addChild(oChildElementOverlay);
				oChildElementOverlay.setDesignTimeMetadata(oChildElementOverlay._oOriginalDesignTimeMetadata);
			}
		}
	};

	/**
	 * @param {sap.ui.core.Element} oElement which was modified
	 * @private
	 */
	DesignTime.prototype._checkIfOverlayShouldBeDestroyed = function(oElement) {
		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		// Overlays of elements in "dependents" aggregation or not in root elements should be destroyed
		if (oElementOverlay &&
			(!this._isElementInRootElements(oElement) || oElement.sParentAggregationName === "dependents")) {
			oElementOverlay.destroy();
		}
	};

	/**
	 * @param {sap.ui.core.Element} oElement to check
	 * @return {boolean} returns if an element is a descendant of any of the root elements
	 * @private
	 */
	DesignTime.prototype._isElementInRootElements = function(oElement) {
		var bFoundAncestor = false;

		this._iterateRootElements(function(oRootElement) {
			if (ElementUtil.hasAncestor(oElement, oRootElement)) {
				bFoundAncestor = true;
				return false;
			}
		});

		return bFoundAncestor;
	};

	/**
	 * @param {function} fnStep function called with every root element
	 * @param {object} oScope provides scope object
	 * @private
	 */
	DesignTime.prototype._iterateRootElements = function(fnStep, oScope) {
		var aRootElements = this.getRootElements();
		aRootElements.forEach(function(sRootElementId) {
			var oRootElement = ElementUtil.getElementInstance(sRootElementId);
			fnStep.call(oScope || this, oRootElement);
		}, this);
	};

	/**
	 * @param {sap.ui.core.Element} oElement to search overlays for, also all children overlays will be found
	 * @return {sap.ui.dt.ElementOverlay[]} created element overlays for oElement and it's children
	 * @private
	 */
	DesignTime.prototype._getAllElementOverlaysIn = function(oElement) {
		var aElementOverlays = [];

		var oElementOverlay = OverlayRegistry.getOverlay(oElement);
		if (oElementOverlay) {
			OverlayUtil.iterateOverlayElementTree(oElementOverlay, function(oChildOverlay) {
				if (oChildOverlay.getDesignTimeMetadata()) {
					aElementOverlays.push(oChildOverlay);
				}
			});
		}

		return aElementOverlays;
	};

	/**
	 * Custom setter for property 'enabled'
	 * @public
	 */
	DesignTime.prototype.setEnabled = function (bValue) {
		var $OverlayContainer = jQuery(Overlay.getOverlayContainer());
		$OverlayContainer[bValue ? 'show' : 'hide']();

		this.getElementOverlays().forEach(function (oOverlay) {
			oOverlay.setVisible(bValue);
			oOverlay.getChildren().forEach(function (oOverlayChild) {
				oOverlayChild.setVisible(bValue);
			});
		});

		this.setProperty('enabled', bValue);
	};

	return DesignTime;
}, /* bExport= */ true);
}; // end of sap/ui/dt/DesignTime.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.ElementEnablementTest') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.ElementEnablementTest.
jQuery.sap.declare('sap.ui.dt.test.ElementEnablementTest'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/ElementEnablementTest",[
	'jquery.sap.global',
	'sap/ui/dt/test/Test',
	'sap/ui/dt/DesignTime',
	'sap/ui/dt/test/Element'
],
function(jQuery, Test, DesignTime, ElementTest) {
	"use strict";


	/**
	 * Constructor for an ElementEnablementTest.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The ElementEnablementTest class allows to create a design time test
	 * which tests a given element on compatibility with the sap.ui.dt.DesignTime.
	 * @extends sap.ui.dt.test.Test
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.ElementEnablementTest
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var ElementEnablementTest = Test.extend("sap.ui.dt.test.ElementEnablementTest", /** @lends sap.ui.dt.test.ElementEnablementTest.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				type : {
					type : "string"
				},
				create : {
					type : "any" //function
				},
				timeout : {
					type : "int",
					defaultValue : 0
				},
				groupPostfix : {
					type : "string"
				}
			}
		}
	});


	/**
	 * Called when the ElementEnablementTest is initialized
	 * @protected
	 */
	ElementEnablementTest.prototype.init = function() {
		this._aAggregatedTestResult = null;
		this._aAggregatedInfoResult = null;
		this._sAggregation = null;
		this._$TestAreaDomRef = null;
	};


	/**
	 * Called when the ElementEnablementTest is destroyed
	 * @protected
	 */
	ElementEnablementTest.prototype.exit = function() {
		if (this._oDesignTime) {
			this._oDesignTime.destroy();
		}
		window.clearTimeout(this._iTimeout);
		this._oElement.destroy();
		if (this._$TestAreaDomRef) {
			this._$TestAreaDomRef.remove();
			delete this._$TestAreaDomRef;
		}
	};


	/**
	 * @return {Promise} A promise providing the test results.
	 * @override
	 */
	ElementEnablementTest.prototype.run = function() {
		return this._setup().then(function() {

			this._mResult = this.createSuite("Element Enablement Test");

			var mElementTest = this.addGroup(
				this._mResult.children,
				this.getType(),
				"Given that a DesignTime is created for " + this.getType()
			);

			this._testAggregations(mElementTest.children);

			this._mResult = this.aggregate(this._mResult);

			return this._mResult;
		}.bind(this));
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._createElement = function() {
		var sType = this.getType();
		var fnCreate = this.getCreate();
		var Element = jQuery.sap.getObject(sType);

		var oElement;

		if (fnCreate) {
			oElement = fnCreate();
		} else {
			oElement = new Element();
		}

		if (oElement.addStyleClass) {
			oElement.addStyleClass("minSize");
		}

		return oElement;
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._getTestArea = function() {
		if (!this._$TestAreaDomRef) {
			this._$TestAreaDomRef =  jQuery("<div id='" + this.getId() + "--testArea" + "'></div>").css({
				height : "500px",
				width: "1000px"// test area needs a height, so that some controls render correctly
			}).appendTo("body");
		}
		return this._$TestAreaDomRef;
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._setup = function() {
		window.clearTimeout(this._iTimeout);
		this._bNoRenderer = false;
		this._bErrorDuringRendering = false;

		return new Promise(function(fnResolve, fnReject) {
			this._oElement = this._createElement();

			try {
				this._oElement.getRenderer();
			} catch (oError) {
				this._bNoRenderer = true;
			}

			if (!this._bNoRenderer) {
				try {
					this._oElement.placeAt(this._getTestArea().get(0));
					sap.ui.getCore().applyChanges();
				} catch (oError) {
					this._bErrorDuringRendering = true;
				}

				if (!this._bErrorDuringRendering) {
					this._oDesignTime = new DesignTime({
						rootElements : [this._oElement]
					});
					this._oDesignTime.attachEventOnce("synced", function() {
						sap.ui.getCore().applyChanges();
						if (this.getTimeout()) {
							this._iTimeout = window.setTimeout(function() {
								fnResolve();
							}, this.getTimeout());
						} else {
							fnResolve();
						}

					}, this);
				} else {
					fnResolve();
				}
			} else {
				fnResolve();
			}
		}.bind(this));
	};


	/**
	 * @private
	 */
	ElementEnablementTest.prototype._testAggregations = function(aTests) {

		var mAggregationsTests = this.addGroup(
			aTests,
			"Aggregations",
			"Each aggregation needs to be ignored or has a visible domRef maintained in the metadata",
			this.getGroupPostfix()
		);


		if (this._bNoRenderer) {
			this.addTest(mAggregationsTests.children,
				true,
				"Control has no renderer",
				"Control has no renderer, not supported by the element test (requires a special element test)",
				Test.STATUS.UNKNOWN
			);
		} else if (this._bErrorDuringRendering) {

			this.addTest(mAggregationsTests.children,
				true,
				"Error during rendering",
				 "Element can't be rendered, not supported by the DesignTime (please, provide a create method for this element)",
				Test.STATUS.ERROR
			);
		} else {
			var mAggregationsTestInfo = ElementTest.getAggregationsInfo(this._oElement);

			for (var sAggregationName in mAggregationsTestInfo) {

				var mAggregationTestInfo = mAggregationsTestInfo[sAggregationName];

				var mAggregationTest = this.addGroup(mAggregationsTests.children,
					sAggregationName,
					(mAggregationTestInfo.ignored ? "Aggregation ignored" : "Aggregation tests")
				);

				if (!mAggregationTestInfo.ignored) {
					this.addTest(mAggregationTest.children,
						mAggregationTestInfo.overlayVisible,
						"Overlay Visible",
						"Overlay domRef is visible in DOM"
					);

					if (mAggregationTestInfo.domRefDeclared){
						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.domRefDeclared,
							"Dom Ref Declared",
							"DomRef is declared in design time metadata"
						);

						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.domRefFound,
							"Dom Ref Found",
							"Declared DomRef is found in DOM"
						);

						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.domRefVisible,
							"Dom Ref Visible",
							"Declared DomRef is visible"
						);
					} else if (mAggregationTestInfo.overlayVisible) {
						this.addTest(mAggregationTest.children,
							mAggregationTestInfo.overlayGeometryCalculatedByChildren,
							"Overlay Geometry calculated by children",
							"Control might work based on DT Heuristic, but safer with domRefDeclared",
							Test.STATUS.PARTIAL_SUPPORTED
						);
					} else {
						this.addTest(mAggregationTest.children,
							false,
							"Overlay Dom Ref",
							"Overlay domRef is not declared and aggregation overlay is not visible (please, declare domRef for this aggregation)",
							Test.STATUS.PARTIAL_SUPPORTED
						);
					}
					if (mAggregationTestInfo.overlayTooSmall) {
						this.addTest(mAggregationTest.children,
							false,
							"Overlay too small",
							"Aggregation Overlay is too small to be accessible, please ensure to render it big enough that it can be reach by a user. If content is needed, provide a create method for this element",
							Test.STATUS.PARTIAL_SUPPORTED
						);
					}
				}
			}
		}
	};


	return ElementEnablementTest;
}, /* bExport= */ true);

}; // end of sap/ui/dt/test/ElementEnablementTest.js
if ( !jQuery.sap.isDeclared('sap.ui.dt.test.LibraryEnablementTest') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides class sap.ui.dt.test.LibraryEnablementTest.
jQuery.sap.declare('sap.ui.dt.test.LibraryEnablementTest'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/dt/test/LibraryEnablementTest",[
	'jquery.sap.global',
	'sap/ui/dt/test/Test',
	'sap/ui/dt/test/ElementEnablementTest'
],
function(jQuery, Test, ElementEnablementTest) {
	"use strict";


	/**
	 * Constructor for a LibraryEnablementTest.
	 *
	 * @param {string} [sId] id for the new object, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new object
	 *
	 * @class
	 * The LibraryEnablementTest class allows to create a design time test
	 * which tests a given library on compatibility with the sap.ui.dt.DesignTime.
	 * @extends sap.ui.dt.test.Test
	 *
	 * @author SAP SE
	 * @version 1.50.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @alias sap.ui.dt.test.LibraryEnablementTest
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var LibraryEnablementTest = Test.extend("sap.ui.dt.test.LibraryEnablementTest", /** @lends sap.ui.dt.test.LibraryEnablementTest.prototype */ {
		metadata : {
			// ---- object ----

			// ---- control specific ----
			library : "sap.ui.dt",
			properties : {
				libraryName : {
					type : "string"
				},
				testData : {
					type : "object"
				}
			}
		}
	});


	/**
	 * @return {Promise} A promise providing the test results.
	 * @override
	 */
	LibraryEnablementTest.prototype.run = function() {
		this._aResult = [];
		var oTestData = this.getTestData() || {};
		var sLibraryName = this.getLibraryName();
		var aElementEnablementTest = [];
		var oLib = sap.ui.getCore().getLoadedLibraries()[sLibraryName];
		if (oLib) {
			var aLibraryControls = oLib.controls;
			aLibraryControls.forEach(function(sType) {
				var oElementTestData = oTestData[sType];
				if (!oElementTestData && oElementTestData !== false) {
					oElementTestData = {};
				}

				if (oElementTestData !== false) {
					oElementTestData.type = sType;

					var oElementTestDataWithoutCreate = null;
					if (oElementTestData.create) {
						oElementTestDataWithoutCreate = jQuery.extend({}, oElementTestData);
						delete oElementTestDataWithoutCreate.create;
						oElementTestData.groupPostfix = "with create method";
					}

					aElementEnablementTest.push(new ElementEnablementTest(oElementTestData));

					if (oElementTestDataWithoutCreate) {
						aElementEnablementTest.push(new ElementEnablementTest(oElementTestDataWithoutCreate));
					}
				}
			});
		}

		var aResults = [];
		var fnIterate = function(mResult) {
			if (mResult) {
				aResults.push(mResult);
			}
			var oElementEnablementTest = aElementEnablementTest.shift();
			if (oElementEnablementTest) {
				return oElementEnablementTest.run().then(function(mResult) {
					oElementEnablementTest.destroy();
					return fnIterate(mResult);
				});
			} else {
				return Promise.resolve(aResults);
			}
		};


		return fnIterate().then(function(aResults) {
			var mResult = this.createSuite("Library Enablement Test");

			aResults.forEach(function(mElementTestResult) {
				var mChild = mElementTestResult.children[0];
				var mPreviousChild = mResult.children[mResult.children.length - 1];

				if (mPreviousChild && mChild.name == mPreviousChild.name) {
					mPreviousChild.children = mPreviousChild.children.concat(mChild.children);
				} else {
					mResult.children.push(mChild);
				}
			});

			mResult = this.aggregate(mResult);

			return mResult;
		}.bind(this));


	};

	return LibraryEnablementTest;
}, /* bExport= */ true);
}; // end of sap/ui/dt/test/LibraryEnablementTest.js
