/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter"],function($,C,J,a,S,E,I,c,f){"use strict";var i={severitytexts:{High:"High",Medium:"Medium",Low:"Low",All:"All Severities"},severitystates:{High:"Error",Medium:"Warning",Low:"None",All:"None"},severityicons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return C.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1000,formatter:f,onInit:function(){this.model=S;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.getView().byId("issuesList");this.issueTable=this.getView().byId("issueTable");},setCommunicationSubscriptions:function(){a.subscribe(c.ON_ANALYZE_FINISH,function(d){var t=this;var p={};t.data=d;d.issues.forEach(function(b){if(!b.context||!b.context.id){return;}if(!p[b.context.id]){p[b.context.id]=[b.name];}else{p[b.context.id].push(b.name);}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",d.issues);this.model.setProperty('/analyzePressed',true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue","");this.elementTree.setData({controls:d.elementTree,issuesIds:p});this.clearFilters();},this);a.subscribe(c.GET_ISSUES,function(d){this.structuredIssuesModel=d.groupedIssues;this.model.setProperty("/issues",d.issuesModel);if(d.issuesModel[0]){this._setSelectedRule(d.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0);}},this);},_initElementTree:function(){var t=this;this.elementTree=new E(null,{onIssueCountClicked:function(s){t.clearFilters();t.model.setProperty("/elementFilter",s);t.updateIssuesVisibility();},onHoverChanged:function(h){a.publish(c.TREE_ELEMENT_MOUSE_ENTER,h);},onMouseOut:function(){a.publish(c.TREE_ELEMENT_MOUSE_OUT);}});},onAfterRendering:function(){this.elementTree.setContainerId(this.getView().byId("elementTreeContainer").getId());},clearFilters:function(){this.model.setProperty("/severityFilter","All");this.model.setProperty("/categoryFilter","All");this.model.setProperty("/elementFilter","All");this.model.setProperty("/audienceFilter","All");if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight();}this.updateIssuesVisibility();},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection();},onIssuePressed:function(e){var s=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(s.context.id,false);},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();if(s.type==="rule"){this._setSelectedRule(s);}else{this.model.setProperty("/selectedIssue","");}if(s.issueCount<4){this._setPropertiesOfResponsiveDetailsAndTable("Fixed","inherit");this.model.setProperty("/visibleRowCount",4);}else{this._setPropertiesOfResponsiveDetailsAndTable("Auto","5rem");}}},openDocumentation:function(e){var l=sap.ui.getCore().byId(e.mParameters.id),u=l.getBindingContext().getProperty("href");a.publish(c.OPEN_URL,u);},updateIssuesVisibility:function(){if(this.data){var b=this.data.issues.filter(this.filterIssueListItems,this);a.publish(c.REQUEST_ISSUES,b);this.model.setProperty("/visibleIssuesCount",b.length);}this.setToolbarHeight();},filterIssueListItems:function(b){var s=this.model.getProperty("/severityFilter"),d=b.severity===s||s==='All',e=this.model.getProperty("/categoryFilter"),g=$.inArray(e,b.categories)>-1||e==='All',h=this.model.getProperty("/elementFilter"),j=h===b.context.id||h==='All',k=this.model.getProperty("/audienceFilter"),l=$.inArray(k,b.audiences)>-1||k==='All';return d&&g&&j&&l;},filterSevirityIcon:function(v){return i.severityicons[v];},filterSevirityState:function(v){return i.severitystates[v];},filterSevirityText:function(v){return i.severitytexts[v];},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem");},onReportPress:function(e){var o=e.getParameter("item"),b=o.getText(),d=this._getReportData();if(b==='View'){a.publish(c.ON_SHOW_REPORT_REQUEST,d);}else{a.publish(c.ON_DOWNLOAD_REPORT_REQUEST,d);}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")};},onRowSelection:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(s.context.id,false);this.model.setProperty("/selectedIssue/details",s.details);}},_setSelectedRule:function(s){var b,d;if(this.model.getProperty("/visibleIssuesCount")>0){b=this.structuredIssuesModel[s.ruleLibName][s.ruleId];d=jQuery.extend(true,{},s);d.issues=b;d.resolutionUrls=b[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",d.details);this.model.setProperty("/selectedIssue",d);}else{this.model.setProperty("/selectedIssue","");}},_setPropertiesOfResponsiveDetailsAndTable:function(v,h){this.model.setProperty("/visibleRowCountMode",v);this.model.setProperty("/heightDetailsArea",h);}});});
