/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend'],function(q,C,a,b){"use strict";var M={};M.render=function(r,m){var d=this.getStartDate(m);var t=m.getTooltip_AsString();var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+c.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+c.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+c.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,d);r.write("</div>");};M.getStartDate=function(m){return m._getDate();};M.getClass=function(m){var c="sapUiCalMonthView",s=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(s==sap.ui.core.CalendarType.Islamic||!S){c=c+" sapUiCalNoWeekNum";}return c;};M.renderMonth=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\">");this.renderDays(r,m,d);r.write("</div>");};M.renderHeader=function(r,m,d){var l=m._getLocaleData();var f=m._getFirstDayOfWeek();var i=m.getId();var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,l,d);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(c.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");this.renderDayNames(r,m,l,f,7,true,undefined);r.write("</div>");};M.renderHeaderLine=function(r,m,l,d){C._checkCalendarDate(d);if(m._getShowHeader()){var i=m.getId();var c=m.getPrimaryCalendarType();var e=l.getMonthsStandAlone("wide",c);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(e[d.getMonth()]);r.write("</div>");}};M.renderDayNames=function(r,m,l,s,d,D,w){var f=m._getFirstDayOfWeek();var I=m.getId();var c="";var e=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=l.getDaysStandAlone("abbreviated",e);}else{W=l.getDaysStandAlone("narrow",e);}var g=l.getDaysStandAlone("wide",e);for(var i=0;i<d;i++){r.write("<div");r.addClass("sapUiCalWH");if(D){c=I+"-WH"+((i+f)%7);}else{c=I+"-WH"+i;}r.writeAttribute("id",c);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:g[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};M.renderDays=function(r,m,d){var w,D,l,h,i,t,s;C._checkCalendarDate(d);if(!d){d=m._getFocusedDate();}t=d.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}h=this.getDayHelper(m,d);D=m._getVisibleDays(d,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==sap.ui.core.CalendarType.Islamic&&s;l=D.length;for(i=0;i<l;i++){this.renderDay(r,m,D[i],h,true,w,-1);}};M.getDayHelper=function(m,d){var l,L,o=m._getLocaleData(),h={sLocale:m._getLocale(),oLocaleData:o,iMonth:d.getMonth(),iYear:d.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:o.getWeekendStart(),iWeekendEnd:o.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:o.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};L=m.getLegend();if(L&&typeof L==="string"){l=sap.ui.getCore().byId(L);if(l){if(!(l instanceof b)){throw new Error(l+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=l;}else{q.sap.log.warning("CalendarLegend "+L+" does not exist!",m);}}return h;};M.renderDay=function(r,m,d,h,o,w,n,W,D){C._checkCalendarDate(d);var s=new a(d,h.sSecondaryCalendarType),A={role:"gridcell",selected:false,label:"",describedby:""},B=d._bBeforeFirstYear;var y=m._oFormatYyyymmdd.format(d.toUTCJSDate(),true);var c=d.getDay();var S=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkDateEnabled(d);var i=0;if(B){e=false;}var f=0;if(w){f=C.calculateWeekNumber(d.toUTCJSDate(),h.iYear,h.sLocale,h.oLocaleData);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+f;}if(!D){var g="";if(n<0){g=h.sId+"-WH"+c;}else{g=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+g;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+c);if(W){r.addStyle("width",W);}if(c==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(o&&h.iMonth!=d.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(d.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=sap.ui.unified.CalendarDayType.None){if(t.type===sap.ui.unified.CalendarDayType.NonWorking){r.addClass("sapUiCalItemWeekEnd");}else{r.addClass("sapUiCalItem"+t.type);if(t.tooltip){r.writeAttributeEscaped('title',t.tooltip);}}}if(m.getParent()&&m.getParent().getMetadata().getName()==="CalendarOneMonthInterval"&&d.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(c==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((c>=h.iWeekendStart&&c<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(c>=h.iWeekendStart||c<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(D){A["label"]=A["label"]+h.aWeekDaysWide[c]+" ";}A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=sap.ui.unified.CalendarDayType.None){var T,j;if(h.oLegend){var l=h.oLegend._getItemByType(t.type);if(l){T=l.getId()+"-Text";}}if(!T){j=b.getTypeAriaText(t.type);if(j){T=j.getId();}}if(T){A["describedby"]+=" "+T;}}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(d.getDate());}r.write("</span>");if(w&&c==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+f);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(f);r.write("</span>");}if(D){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[c]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};return M;},true);
