/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/CustomData","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./library"],function(q,C,G,a,O,b,B,c,D,S,d,l){"use strict";var e=l.ObjectPageSubSectionMode;var f=l.ObjectPageSubSectionLayout;var g=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:e.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designTime:true}});g.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;g.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._oObserver=new d(g.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._switchSubSectionMode(this.getMode());};g.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};g.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};g.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};g.prototype._observeChanges=function(o){var h=o.object,s=o.name,m=o.mutation,i=o.child,H;if(h===this){if(s==="actions"){if(m==="insert"){this._observeAction(i);}else if(m==="remove"){this._unobserveAction(i);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};g.prototype._observeAction=function(o){this._oObserver.observe(o,{properties:["visible"]});};g.prototype._unobserveAction=function(o){this._oObserver.unobserve(o,{properties:["visible"]});};g.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(o){o.setStashed(false);});};g.prototype.connectToModels=function(){var h=this.getBlocks()||[],m=this.getMoreBlocks()||[],s=this.getMode();this._unStashControls();h.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(s);}o.connectToModels();}});if(m.length>0&&s===e.Expanded){m.forEach(function(M){if(M instanceof B){if(!M.getMode()){M.setMode(s);}M.connectToModels();}});}};g.prototype._allowPropagationToLoadedViews=function(A){var h=this.getBlocks()||[],m=this.getMoreBlocks()||[];h.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});m.forEach(function(M){if(M instanceof B){M._allowPropagationToLoadedViews(A);}});};g.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return sap.ui.core.Control.prototype.clone.apply(this,arguments);};g.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(k){p[k].forEach(function(o){o.destroy();});});};g.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};g.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._synchronizeBlockLayouts();this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._$spacer=q.sap.byId(o.getId()+"-spacer");};g.prototype.onBeforeRendering=function(){if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(this._getObjectPageLayout());this.refreshSeeMoreVisibility();};g.prototype._applyLayout=function(L){var v,o=this._getGrid(),s=this.getMode(),h=L.getSubSectionLayout(),i=this._calculateLayoutConfiguration(h,L),j=this.getBlocks(),A=j.concat(this.getMoreBlocks());this._oLayoutConfig=i;this._resetLayoutData(A);if(s===e.Expanded){v=A;}else{v=j;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(k){this._setBlockMode(k,s);o.addAggregation("content",k,true);},this);}catch(E){q.sap.log.error("ObjectPageSubSection :: error while building layout "+h+": "+E);}return this;};g.prototype._calculateLayoutConfiguration=function(L,o){var h={M:2,L:3,XL:4},i=h.L,E=h.XL,t=(L===f.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){i-=1;E-=1;}if(u){i-=1;}h.L=i;h.XL=E;return h;};g.prototype.refreshSeeMoreVisibility=function(){var h=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),i=this.$();if(!h){h=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(i.length){i.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",h);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",h);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",h);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",h);return h;};g.prototype.setMode=function(m){if(this.getMode()!==m){this._switchSubSectionMode(m);if(this._bRenderedFirstTime){this.rerender();}}return this;};g.prototype.onkeydown=function(E){if(E.keyCode===q.sap.KeyCodes.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof g){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};g.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};g.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};g.prototype._calcBlockColumnLayout=function(h,o){var i=12,v,M,L,X,j;M={iRemaining:o.M,iColumnConfig:o.M};L={iRemaining:o.L,iColumnConfig:o.L};X={iRemaining:o.XL,iColumnConfig:o.XL};j=[X,L,M];v=h.filter(function(k){return k.getVisible&&k.getVisible();});v.forEach(function(k,I){j.forEach(function(m){m.iCalculatedSize=this._calculateBlockSize(k,m.iRemaining,v,I,m.iColumnConfig);},this);k.setLayoutData(new a(k.getId()+"-layoutData",{spanS:i,spanM:M.iCalculatedSize*(i/M.iColumnConfig),spanL:L.iCalculatedSize*(i/L.iColumnConfig),spanXL:X.iCalculatedSize*(i/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));j.forEach(function(m){m.iRemaining-=m.iCalculatedSize;if(m.iRemaining<1){m.iRemaining=m.iColumnConfig;}});},this);return v;};g.prototype._calculateBlockSize=function(o,r,v,i,m){var h,F=m,j;if(!this._hasAutoLayout(o)){return Math.min(m,parseInt(o.getColumnLayout(),10));}for(j=1;j<=F;j++){h=this._calcLayout(v[i+j]);if(h<r){r-=h;}else{break;}}return r;};g.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};g.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};g.prototype._onDesktopMediaRange=function(o){return this._onMediaRange(o,["LargeDesktop","Desktop"]);};g.prototype._onTabletMediaRange=function(o){return this._onMediaRange(o,["Tablet"]);};g.prototype._onPhoneMediaRange=function(o){return this._onMediaRange(o,["Phone"]);};g.prototype._onMediaRange=function(o,h){var m=o||this._getCurrentMediaContainerRange();return h.indexOf(m.name)>-1;};g.prototype._synchronizeBlockLayouts=function(o){if(this._getUseTitleOnTheLeft()){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(o));}this._toggleBlockLayoutResponsiveStyles(o);};g.prototype._toggleBlockLayoutResponsiveStyles=function(o){this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerDesktop",this._onDesktopMediaRange(o));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerTablet",this._onTabletMediaRange(o));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerPhone",this._onPhoneMediaRange(o));};g.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};g.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};g.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};g.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};g.prototype.addAggregation=function(A,o,s){var h;if(o instanceof b){o.getContent().forEach(function(i){this.addAggregation(A,i,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){h=this._getAggregation(A);h.push(o);this._setAggregation(A,h,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};g.prototype.insertBlock=function(o,i){q.sap.log.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};g.prototype.insertMoreBlock=function(o,i){q.sap.log.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};g.prototype.removeAllAggregation=function(A,s){var i;if(this.hasProxy(A)){i=this._getAggregation(A);this._setAggregation(A,[],s);return i.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};g.prototype.removeAggregation=function(A,o){var r=false,i;if(this.hasProxy(A)){i=this._getAggregation(A);i.forEach(function(h,I){if(h.getId()===o.getId()){i.splice(I,1);this._setAggregation(i);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};g.prototype.indexOfAggregation=function(A,o){var i=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(h,I){if(h.getId()===o.getId()){i=I;return true;}},this);return i;}return O.prototype.indexOfAggregation.apply(this,arguments);};g.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};g.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};g.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:sap.m.ButtonType.Transparent,iconFirst:false}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};g.prototype._seeMoreLessControlPressHandler=function(E){var s=this.getMode(),t,m=this.getMoreBlocks()||[];if(s===e.Expanded){t=e.Collapsed;}else{t=e.Expanded;m.forEach(function(o){if(o instanceof B){o.setMode(s);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};g.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===e.Collapsed){this.setProperty("mode",e.Collapsed,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",e.Expanded,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_LESS"));}};g.prototype._setBlockMode=function(o,m){if(o instanceof B){o.setMode(m);}else{q.sap.log.debug("ObjectPageSubSection :: cannot propagate mode "+m+" to "+o.getMetadata().getName());}};g.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabIndex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};g.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o.getSubSectionLayout()===f.TitleOnLeft;};g.prototype._resetLayoutData=function(h){h.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};g.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(m){if(m.getVisible&&!m.getVisible()){return true;}v++;});return v;};return g;});
