/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/f/DynamicPageTitle"],function(q,l,C,S,R,a,D,b){"use strict";var c=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},designTime:true}});function e(o){if(arguments.length===1){return o&&("length"in o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}function h(E){var o;if(!E){return false;}o=E.getBoundingClientRect();return!!(o.width&&o.height);}var u=sap.ui.getCore().getConfiguration().getAnimation();c.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;c.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;c.FOOTER_ANIMATION_DURATION=350;c.BREAK_POINTS={TABLET:1024,PHONE:600};c.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};c.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};c.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};c.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._bMSBrowser=D.browser.internet_explorer||D.browser.edge||false;this._oScrollHelper=new a(this,this.getId()+"-content",{horizontal:false,vertical:true});};c.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();this._detachScrollHandler();};c.prototype.onAfterRendering=function(){var s;if(this._preserveHeaderStateOnScroll()){q.sap.delayedCall(0,this,this._overridePreserveHeaderStateOnScroll);}this._bPinned=false;this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){this._setScrollPosition(this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();};c.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}};c.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};c.prototype.setHeaderExpanded=function(H){if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);return this;};c.prototype.setToggleHeaderOnTitleClick=function(t){var r=this.setProperty("toggleHeaderOnTitleClick",t,true);this.$().toggleClass("sapFDynamicPageTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();return r;};c.prototype.setFitContent=function(f){var r=this.setProperty("fitContent",f,true);if(e(this.$())){this._updateFitContainer();}return r;};c.prototype.getScrollDelegate=function(){return this._oScrollHelper;};c.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;if(this.getHeaderExpanded()){this._moveHeaderToContentArea(true);}else{this._adjustSnap();}this._updateScrollBar();};c.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};c.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(this.$())){return;}if(!e(f)){return;}f.toggleStyleClass("sapFDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapFDynamicPageActualFooterControlHide",!s);this._toggleFooterSpacer(s);if(u){if(!s){q.sap.delayedCall(c.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}q.sap.delayedCall(c.FOOTER_ANIMATION_DURATION,this,function(){f.removeStyleClass("sapFDynamicPageActualFooterControlShow");});}this._updateScrollBar();};c.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(e($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(e(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};c.prototype._snapHeader=function(A){var d=this.getTitle();if(this._bPinned){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(e(d)){d._toggleState(false);if(A&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);this.$titleArea.addClass("sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();};c.prototype._expandHeader=function(A){var d=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(d)){d._toggleState(true);if(A){this._moveHeaderToTitleArea(true);}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);this.$titleArea.removeClass("sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();};c.prototype._toggleHeaderVisibility=function(s){var E=this.getHeaderExpanded(),d=this.getTitle(),o=this.getHeader();if(this._bPinned){q.sap.log.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(e(d)){d._toggleState(E);}if(e(o)){o.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};c.prototype._moveHeaderToContentArea=function(o){var d=this.getHeader();if(e(d)){d.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;if(o){this._offsetContentOnMoveHeader();}}};c.prototype._moveHeaderToTitleArea=function(o){var d=this.getHeader();if(e(d)){d.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;if(o){this._offsetContentOnMoveHeader();}}};c.prototype._offsetContentOnMoveHeader=function(){var o=this.getHeader().$().outerHeight(),i=Math.ceil(this._getScrollPosition()),n;if(!o){return;}n=this._bHeaderInTitleArea?i-o:i+o;n=Math.max(n,0);this._setScrollPosition(n,true);};c.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(e($)){$.addClass("sapFDynamicPageHeaderPinned");}};c.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(e($)){$.removeClass("sapFDynamicPageHeaderPinned");}};c.prototype._togglePinButtonVisibility=function(t){var d=this.getHeader();if(e(d)){d._setShowPinBtn(t);}};c.prototype._togglePinButtonPressedState=function(p){var d=this.getHeader();if(e(d)){d._togglePinButton(p);}};c.prototype._togglePinButtonARIAState=function(p){var d=this.getHeader();if(e(d)){d._updateARIAPinButtonState(p);}};c.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};c.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};c.prototype._getScrollPosition=function(){return e(this.$wrapper)?this.$wrapper.scrollTop():0;};c.prototype._setScrollPosition=function(n,s){if(!e(this.$wrapper)){return;}if(this._getScrollPosition()===n){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,n);};c.prototype._shouldSnap=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};c.prototype._shouldExpand=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};c.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};c.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};c.prototype._canSnapHeaderOnScroll=function(){var m=this._getMaxScrollPosition(),t=this._bMSBrowser?1:0;if(this._bHeaderInTitleArea){m+=this._getHeaderHeight();m-=t;}return m>this._getSnappingHeight();};c.prototype._getSnappingHeight=function(){return this._getHeaderHeight()||this._getTitleHeight();};c.prototype._getMaxScrollPosition=function(){var $;if(e(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-$.clientHeight;}return 0;};c.prototype._needsVerticalScrollBar=function(){var t=this._bMSBrowser?1:0;return this._getMaxScrollPosition()>t;};c.prototype._getOwnHeight=function(){return this._getHeight(this);};c.prototype._getEntireHeaderHeight=function(){var t=0,H=0,d=this.getTitle(),o=this.getHeader();if(e(d)){t=d.$().outerHeight();}if(e(o)){H=o.$().outerHeight();}return t+H;};c.prototype._headerBiggerThanAllowedToPin=function(i){if(!(typeof i==="number"&&!isNaN(parseInt(i,10)))){i=this._getOwnHeight();}return this._getEntireHeaderHeight()>c.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*i;};c.prototype._headerBiggerThanAllowedToBeFixed=function(){var i=this._getOwnHeight();return this._getEntireHeaderHeight()>c.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*i;};c.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),d=this._bHeaderInTitleArea;if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();q.sap.log.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!e(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();q.sap.log.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(d);}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};c.prototype._updateScrollBar=function(){var s,d,n;if(!D.system.desktop||!e(this.$wrapper)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");d=this._needsVerticalScrollBar();n=this.bHasScrollbar!==d;if(n){s.toggleStyleClass("sapUiHidden",!d);this.toggleStyleClass("sapFDynamicPageWithScroll",d);this.bHasScrollbar=d;}q.sap.delayedCall(0,this,this._updateFitContainer);q.sap.delayedCall(0,this,this._updateScrollBarOffset);};c.prototype._updateFitContainer=function(n){var N=typeof n!=='undefined'?!n:!this._needsVerticalScrollBar(),f=this.getFitContent(),t=f||N;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};c.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.sap.scrollbarSize().width+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};c.prototype._updateHeaderARIAState=function(E){var d=this.getHeader();if(e(d)){d._updateARIAState(E);}};c.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(c.MEDIA.INVISIBLE);}else if(w<=c.BREAK_POINTS.PHONE){this._updateMediaStyle(c.MEDIA.PHONE);}else if(w<=c.BREAK_POINTS.TABLET){this._updateMediaStyle(c.MEDIA.TABLET);}else{this._updateMediaStyle(c.MEDIA.DESKTOP);}};c.prototype._updateMediaStyle=function(s){Object.keys(c.MEDIA).forEach(function(m){var E=s===c.MEDIA[m];this.toggleStyleClass(c.MEDIA[m],E);},this);};c.prototype._toggleExpandVisualIndicator=function(t){var d=this.getTitle();if(e(d)){d._toggleExpandButton(t);}};c.prototype._focusExpandVisualIndicator=function(){var d=this.getTitle();if(e(d)){d._focusExpandButton();}};c.prototype._toggleCollapseVisualIndicator=function(t){var d=this.getHeader();if(e(d)){d._toggleCollapseButton(t);}};c.prototype._focusCollapseVisualIndicator=function(){var d=this.getHeader();if(e(d)){d._focusCollapseButton();}};c.prototype._updateToggleHeaderVisualIndicators=function(){var H,d,E;if(!this.getToggleHeaderOnTitleClick()||this._bPinned){d=false;E=false;}else{H=this.getHeaderExpanded();d=H;E=!H;}this._toggleCollapseVisualIndicator(d);this._toggleExpandVisualIndicator(E);};c.prototype._getHeight=function(o){return!(o instanceof C)?0:o.$().outerHeight()||0;};c.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};c.prototype._getTitleAreaHeight=function(){return e(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};c.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};c.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};c.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};c.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};c.prototype._cacheDomElements=function(){var f=this.getFooter();if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this._cacheTitleDom();};c.prototype._cacheTitleDom=function(){var t=this.getTitle();if(e(t)){this.$title=t.$();}};c.prototype._adjustSnap=function(){var d,i,f,I,$=this.$();if(!e($)){return;}if(!h($[0])){return;}d=this.getHeader();i=!this.getHeaderExpanded();if(!d||!i){return;}f=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();I=i&&d.$().hasClass("sapFDynamicPageHeaderHidden");if(f&&I){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);}else if(!f&&!I){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);}};c.prototype.ontouchmove=function(E){E.setMarked();};c.prototype._onChildControlAfterRendering=function(E){if(E.srcControl instanceof b){this._cacheTitleDom();this._deRegisterResizeHandler(c.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(c.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}q.sap.delayedCall(0,this,this._updateScrollBar);};c.prototype._onChildControlsHeightChange=function(E){var n=this._needsVerticalScrollBar();if(n){this._updateFitContainer(n);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};c.prototype._onResize=function(E){var d=this.getTitle(),o=this.getHeader(),i=E.size.width;if(!this._preserveHeaderStateOnScroll()&&o){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}}if(e(d)){d._onResize(i);}this._adjustSnap();this._updateScrollBar();this._updateMedia(i);};c.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};c.prototype._toggleHeaderOnScroll=function(){if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnap()){this._snapHeader(true);this._updateHeaderARIAState(false);}else if(this._shouldExpand()){this._expandHeader();this._toggleHeaderVisibility(true);this._updateHeaderARIAState(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var d=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(d);}};c.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};c.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()){this._titleExpandCollapseWhenAllowed();}};c.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusCollapseVisualIndicator();};c.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};c.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(e($)){$.addClass("sapFDynamicPageTitleForceHovered");}};c.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(e($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};c.prototype._onTitleMouseOver=c.prototype._onVisualIndicatorMouseOver;c.prototype._onTitleMouseOut=c.prototype._onVisualIndicatorMouseOut;c.prototype._titleExpandCollapseWhenAllowed=function(){if(this._bPinned){return this;}if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false);this._toggleHeaderVisibility(true);}else{this._snapHeader(false);this._toggleHeaderVisibility(false);}}else if(!this.getHeaderExpanded()){this._bExpandingWithAClick=true;this._expandHeader(true);this._bExpandingWithAClick=false;}else{var m=this._bHeaderInTitleArea;this._snapHeader(m);if(!m){this._setScrollPosition(this._getSnappingHeight());}}};c.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);this._restorePinButtonFocus();}};c.prototype._attachResizeHandlers=function(){var f=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(c.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(e(this.$title)){this._registerResizeHandler(c.RESIZE_HANDLER_ID.TITLE,this.$title[0],f);}if(e(this.$contentFitContainer)){this._registerResizeHandler(c.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],f);}};c.prototype._registerResizeHandler=function(H,o,f){if(!this[H]){this[H]=R.register(o,f);}};c.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(c.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(c.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(c.RESIZE_HANDLER_ID.CONTENT);};c.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};c.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),o=this.getContent(),p={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(p);}if(e(o)){o.addEventDelegate(p);}if(e(H)){H.addEventDelegate(p);}};c.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(c.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};c.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(e(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(c.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};c.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(e(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(c.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(e(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(c.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};c.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(e(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(c.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(c.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};c.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(c.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(c.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};c.prototype._attachScrollHandler=function(){this.$wrapper.on("scroll",this._onWrapperScroll.bind(this));this.$wrapper.on("scroll",this._toggleHeaderOnScroll.bind(this));};c.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.unbind("scroll");}};return c;});
