/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/model/type/Date','sap/ui/model/type/Time','sap/ui/model/type/DateTime','sap/ui/model/odata/type/ODataType','sap/ui/core/library','sap/ui/Device'],function(q,C,l,D,T,a,O,c,b){"use strict";var d=l.DateTimeInputType;var e=c.TextDirection;var f=c.TextAlign;var V=c.ValueState;var g=C.extend("sap.m.DateTimeInput",{metadata:{library:"sap.m",properties:{value:{type:"string",group:"Data",defaultValue:null,bindable:"bindable"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},enabled:{type:"boolean",group:"Behavior",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:V.None},valueStateText:{type:"string",group:"Misc",defaultValue:null},showValueStateMessage:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},placeholder:{type:"string",group:"Misc",defaultValue:null},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:f.Initial},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:e.Inherit},type:{type:"sap.m.DateTimeInputType",group:"Data",defaultValue:d.Date},displayFormat:{type:"string",group:"Appearance",defaultValue:null},valueFormat:{type:"string",group:"Data",defaultValue:null},dateValue:{type:"object",group:"Data",defaultValue:null}},aggregations:{_picker:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{change:{parameters:{value:{type:"string"},dateValue:{type:"object"},valid:{type:"boolean"}}}}}});!(function(p,$,o){var i=l.getLocaleData();$.extend(p,{_types:{Date:{valueFormat:i.getDatePattern("short"),displayFormat:i.getDatePattern("medium")},Time:{valueFormat:i.getTimePattern("short"),displayFormat:i.getTimePattern("short")},DateTime:{valueFormat:i.getDateTimePattern("short"),displayFormat:i.getDateTimePattern("short")}}});["Time","Date"].forEach(function(t,n){["valueFormat","displayFormat"].forEach(function(F){var m=p._types;m.DateTime[F]=m.DateTime[F].replace("{"+n+"}",m[t][F]);});});}(g.prototype,q,b));g.prototype.init=function(){this.setType(d.Date);};g.prototype.onBeforeRendering=function(){j.call(this);};g.prototype.getFocusDomRef=function(){var p=_.call(this);return p.getFocusDomRef();};g.prototype.getIdForLabel=function(){var p=_.call(this);return p.getIdForLabel();};function h(t){var p;switch(t){case d.DateTime:q.sap.require("sap.m.DateTimePicker");p=new sap.m.DateTimePicker(this.getId()+"-Picker");break;case d.Time:q.sap.require("sap.m.TimePicker");p=new sap.m.TimePicker(this.getId()+"-Picker",{localeId:sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString()});break;default:q.sap.require("sap.m.DatePicker");p=new sap.m.DatePicker(this.getId()+"-Picker");break;}p.setDisplayFormat(this.getDisplayFormat()||this._types[t].displayFormat);p.setValueFormat(this.getValueFormat()||this._types[t].valueFormat);if(this.getDateValue()){p.setDateValue(this.getDateValue());}p.setEnabled(this.getEnabled());p.setEditable(this.getEditable());p.setValueState(this.getValueState());p.setValueStateText(this.getValueStateText());p.setShowValueStateMessage(this.getShowValueStateMessage());p.setName(this.getName());p.setPlaceholder(this.getPlaceholder());p.setTextAlign(this.getTextAlign());p.setTextDirection(this.getTextDirection());p.setWidth("100%");p.attachChange(k,this);var A=this.getAriaLabelledBy();for(var i=0;i<A.length;i++){p.addAriaLabelledBy(A[i]);}return p;}g.prototype.setType=function(t){if(t==this.getType()&&_.call(this)){return this;}this.destroyAggregation("_picker");var p=h.call(this,t);this.setAggregation("_picker",p);this.setProperty("type",t);return this;};g.prototype.setWidth=function(w){this.setProperty("width",w);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};g.prototype.setValue=function(v){j.call(this);v=this.validateProperty("value",v);if(v.toLowerCase()=="now"){return this.setDateValue(new Date());}if(v===this.getValue()){return this;}this.setProperty("value",v,true);var p=_.call(this);p.setValue(v);var o=p.getDateValue();this.setProperty("dateValue",o,true);return this;};g.prototype.setDateValue=function(o){if(this._isValidDate(o)){throw new Error("Date must be a JavaScript date object; "+this);}j.call(this);this.setProperty("dateValue",o,true);var p=_.call(this);p.setDateValue(o);var v=p.getValue();this.setProperty("value",v,true);return this;};g.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var p=_.call(this);p.setDisplayFormat(s||this._types[this.getType()].displayFormat);return this;};g.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);var p=_.call(this);p.setValueFormat(v||this._types[this.getType()].ValueFormat);return this;};g.prototype.setEnabled=function(E){this.setProperty("enabled",E,true);var p=_.call(this);p.setEnabled(E);return this;};g.prototype.setEditable=function(E){this.setProperty("editable",E,true);var p=_.call(this);p.setEditable(E);return this;};g.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var p=_.call(this);p.setValueState(v);return this;};g.prototype.setValueStateText=function(v){this.setProperty("valueStateText",v,true);var p=_.call(this);p.setValueStateText(v);return this;};g.prototype.setShowValueStateMessage=function(s){this.setProperty("showValueStateMessage",s,true);var p=_.call(this);p.setShowValueStateMessage(s);return this;};g.prototype.setName=function(n){this.setProperty("name",n,true);var p=_.call(this);p.setName(n);return this;};g.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);var P=_.call(this);P.setPlaceholder(p);return this;};g.prototype.setTextAlign=function(t){this.setProperty("textAlign",t,true);var p=_.call(this);p.setTextAlign(t);return this;};g.prototype.setTextDirection=function(t){this.setProperty("textDirection",t,true);var p=_.call(this);p.setTextDirection(t);return this;};g.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.addAriaLabelledBy(i);return this;};g.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var p=_.call(this);p.removeAriaLabelledBy(i);return this;};g.prototype.removeAllAriaLabelledBy=function(){this.removeAssociation("ariaLabelledBy",true);var p=_.call(this);p.removeAllAriaLabelledBy();return this;};g.prototype.getAccessibilityInfo=function(){var p=_.call(this);return p&&p.getAccessibilityInfo?p.getAccessibilityInfo():null;};g.prototype._getPickerByTypeAndPattern=function(t,p,i){var r=/[DdYyMLWwGQUur]/,R=/[HhKkmsa]/,m=R.test(i),n=r.test(i),o=m&&!n,s=n&&!m,u=n&&m,N,v;switch(t){case d.Time:case d.Date:case d.DateTime:if(o&&p.getMetadata().getName()!=="sap.m.TimePicker"){N=d.Time;}else if(s&&p.getMetadata().getName()!=="sap.m.DatePicker"){N=d.Date;}else if(u&&p.getMetadata().getName()!=="sap.m.DateTimePicker"){N=d.DateTime;}break;default:{throw"Invalid type: "+t+". Expected is one of the sap.m.DateTimeInputType";}}if(N){this.destroyAggregation("_picker");v=h.call(this,N);this.setAggregation("_picker",v);}return v||p;};g.prototype._getBoundValueTypePattern=function(){var B=this.getBinding("value"),o=B&&B.getType()&&B.getType();if(o instanceof D||o instanceof T||o instanceof a){return o.getOutputPattern();}if(o instanceof O&&o.oFormat){return o.oFormat.oFormatOptions.pattern;}return undefined;};function _(){return this.getAggregation("_picker");}g.prototype._isValidDate=function(o){return o&&q.type(o)!=="date";};function j(){if(this._getBoundValueTypePattern()){var p=this._getBoundValueTypePattern();var P=_.call(this);P=this._getPickerByTypeAndPattern(this.getType(),P,p);if(P.getValueFormat()!=p){P.setValueFormat(p);}if(P.getDisplayFormat()!=p){P.setDisplayFormat(p);}}}function k(E){var v=E.getParameter("value");var o;var i=E.getParameter("valid");this.setProperty("value",v,true);if(i){o=E.oSource.getDateValue();this.setProperty("dateValue",o,true);}this.fireChange({value:v,newValue:v,valid:i,dateValue:o,newDateValue:o});}return g;});
