/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text','sap/ui/core/HTML','sap/ui/core/Icon','sap/ui/core/IconPool','sap/m/Button','sap/m/GenericTileRenderer','sap/m/GenericTileLineModeRenderer','sap/ui/Device','sap/ui/core/ResizeHandler','jquery.sap.events'],function(q,l,C,T,H,I,a,B,G,L,D,R){"use strict";var b=l.GenericTileScope;var c=l.LoadState;var F=l.FrameType;var S=l.Size;var d=l.GenericTileMode;var e=C.extend("sap.m.GenericTile",{metadata:{library:"sap.m",properties:{"mode":{type:"sap.m.GenericTileMode",group:"Appearance",defaultValue:d.ContentMode},"header":{type:"string",group:"Appearance",defaultValue:null},"subheader":{type:"string",group:"Appearance",defaultValue:null},"failedText":{type:"string",group:"Appearance",defaultValue:null},"size":{type:"sap.m.Size",group:"Misc",defaultValue:S.Auto},"frameType":{type:"sap.m.FrameType",group:"Misc",defaultValue:F.OneByOne},"backgroundImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"headerImage":{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},"state":{type:"sap.m.LoadState",group:"Misc",defaultValue:c.Loaded},"imageDescription":{type:"string",group:"Accessibility",defaultValue:null},"scope":{type:"sap.m.GenericTileScope",group:"Misc",defaultValue:b.Display},"ariaLabel":{type:"string",group:"Accessibility",defaultValue:null}},defaultAggregation:"tileContent",aggregations:{"tileContent":{type:"sap.m.TileContent",multiple:true,bindable:"bindable"},"icon":{type:"sap.ui.core.Control",multiple:false},"_titleText":{type:"sap.m.Text",multiple:false,visibility:"hidden"},"_failedMessageText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{parameters:{"scope":{type:"sap.m.GenericTileScope"},"action":{type:"string"},"domRef":{type:"any"}}}}},renderer:function(r,o){if(o.getMode()===l.GenericTileMode.LineMode){L.render(r,o);}else{G.render(r,o);}}});e._Action={Press:"Press",Remove:"Remove"};e.LINEMODE_SIBLING_PROPERTIES=["state","subheader","header","scope"];e.prototype.init=function(){this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");D.media.initRangeSet("GenericTileDeviceSet",[450],"px",["small","large"]);this._oTitle=new T(this.getId()+"-title");this._oTitle.addStyleClass("sapMGTTitle");this._oTitle.cacheLineHeight=false;this.setAggregation("_titleText",this._oTitle,true);this._sFailedToLoad=this._oRb.getText("INFOTILE_CANNOT_LOAD_TILE");this._sLoading=this._oRb.getText("INFOTILE_LOADING");this._oFailedText=new T(this.getId()+"-failed-txt",{maxLines:2});this._oFailedText.cacheLineHeight=false;this._oFailedText.addStyleClass("sapMGTFailed");this.setAggregation("_failedMessageText",this._oFailedText,true);this._oWarningIcon=new I(this.getId()+"-warn-icon",{src:"sap-icon://notification",size:"1.375rem"});this._oWarningIcon.addStyleClass("sapMGTFtrFldIcnMrk");this._oBusy=new H(this.getId()+"-overlay");this._oBusy.setBusyIndicatorDelay(0);this._bTilePress=true;this._bThemeApplied=true;if(!sap.ui.getCore().isInitialized()){this._bThemeApplied=false;sap.ui.getCore().attachInit(this._handleCoreInitialized.bind(this));}else{this._handleCoreInitialized();}};e.prototype._handleCoreInitialized=function(){this._bThemeApplied=sap.ui.getCore().isThemeApplied();if(!this._bThemeApplied){sap.ui.getCore().attachThemeChanged(this._handleThemeApplied,this);}};e.prototype._handleThemeApplied=function(){this._bThemeApplied=true;this._oTitle.clampHeight();sap.ui.getCore().detachThemeChanged(this._handleThemeApplied,this);};e.prototype._initScopeContent=function(t){switch(this.getScope()){case l.GenericTileScope.Actions:if(this.getState&&this.getState()===l.LoadState.Disabled){break;}this._oMoreIcon=this._oMoreIcon||a.createControlByURI({id:this.getId()+"-action-more",size:"1rem",useIconTooltip:false,src:"sap-icon://overflow"}).addStyleClass("sapMPointer").addStyleClass(t+"MoreIcon");this._oRemoveButton=this._oRemoveButton||new B({id:this.getId()+"-action-remove",icon:"sap-icon://decline",tooltip:this._oRb.getText("GENERICTILE_REMOVEBUTTON_TEXT")}).addStyleClass("sapUiSizeCompact").addStyleClass(t+"RemoveButton");this._oRemoveButton._bExcludeFromTabChain=true;break;default:}};e.prototype.exit=function(){if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,"GenericTileDeviceSet");if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());this._$RootNode=null;}this._clearAnimationUpdateQueue();this._oWarningIcon.destroy();if(this._oImage){this._oImage.destroy();}this._oBusy.destroy();if(this._oMoreIcon){this._oMoreIcon.destroy();}if(this._oRemoveButton){this._oRemoveButton.destroy();}};e.prototype.onBeforeRendering=function(){var s=!!this.getSubheader();if(this.getMode()===l.GenericTileMode.HeaderMode){this._applyHeaderMode(s);}else{this._applyContentMode(s);}var t=this.getTileContent().length;for(var i=0;i<t;i++){this.getTileContent()[i].setDisabled(this.getState()===l.LoadState.Disabled);}this._initScopeContent("sapMGT");this._generateFailedText();this.$().unbind("mouseenter",this._updateAriaAndTitle);this.$().unbind("mouseleave",this._removeTooltipFromControl);if(this._sParentResizeListenerId){R.deregister(this._sResizeListenerId);this._sParentResizeListenerId=null;}D.media.detachHandler(this._handleMediaChange,this,"GenericTileDeviceSet");if(this._$RootNode){this._$RootNode.off(this._getAnimationEvents());}if(this.getFrameType()===l.FrameType.Auto){this.setProperty("frameType",l.FrameType.OneByOne,true);}};e.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._updateAriaAndTitle.bind(this));this.$().bind("mouseleave",this._removeTooltipFromControl.bind(this));var m=this.getMode();if(m===l.GenericTileMode.LineMode&&this._isScreenLarge()){this.$().parent().addClass("sapMGTLineModeContainer");this._updateHoverStyle(true);if(this.getParent()instanceof C){this._sParentResizeListenerId=R.register(this.getParent(),this._handleResize.bind(this));}else{this._sParentResizeListenerId=R.register(this.$().parent(),this._handleResize.bind(this));}}if(m===l.GenericTileMode.LineMode&&this._bUpdateLineTileSiblings){this._updateLineTileSiblings();this._bUpdateLineTileSiblings=false;}if(m===l.GenericTileMode.LineMode){D.media.attachHandler(this._handleMediaChange,this,"GenericTileDeviceSet");}};e.prototype._handleResize=function(){if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&this.getParent()){this._queueAnimationEnd();}};e.prototype._isCompact=function(){return q("body").hasClass("sapUiSizeCompact")||this.$().is(".sapUiSizeCompact")||this.$().closest(".sapUiSizeCompact").length>0;};e.prototype._calculateStyleData=function(){this.$("lineBreak").remove();if(!this._isScreenLarge()||!this.getDomRef()||this.$().is(":hidden")){return null;}var $=this.$(),E=this.$("endMarker"),s=this.$("startMarker");if(E.length===0||s.length===0){return null;}var f=this._getLineCount(),g,h,j=Math.ceil(L._getCSSPixelValue(this,"margin-top")),k,A=this.$().parent().innerWidth(),m=Math.ceil(L._getCSSPixelValue(this,"min-height")),n=L._getCSSPixelValue(this,"line-height"),o=this.$().is(":not(:first-child)")&&f>1,p=q("<span><br /></span>"),i=0,r=sap.ui.getCore().getConfiguration().getRTL(),t=E.position();if(o){p.attr("id",this.getId()+"-lineBreak");$.prepend(p);f=this._getLineCount();t=E.position();}var u={rtl:r,lineBreak:o,startOffset:s.offset(),endOffset:E.offset(),availableWidth:A,lines:[]};var v;if(D.browser.msie||D.browser.edge){v=p.find("br").position();}else{v=p.position();}var w=v;if(!(D.browser.mozilla||D.browser.msie||D.browser.edge)&&v.left<t.left){w=t;}u.positionLeft=o?v.left:$.position().left;u.positionRight=o?$.width()-w.left:u.availableWidth-$.position().left;if(!o&&f>1){u.positionRight=s.parent().innerWidth()-(s.position().left+s.width());}for(i;i<f;i++){if(o&&i===0){continue;}if(f===1){g=r?u.availableWidth-u.positionLeft:u.positionLeft;k=$.width();}else if(i===f-1){g=0;k=r?$.width()-t.left:t.left;}else if(o&&i===1){g=0;k=A;}else{g=0;k=A;}h=i*n+j;u.lines.push({offset:{x:g,y:h},width:k,height:m});}return u;};e.prototype._getStyleData=function(){var s=this._calculateStyleData();if(!q.sap.equal(this._oStyleData,s)){delete this._oStyleData;this._oStyleData=s;return true;}return false;};e.prototype._getAnimationEvents=function(){return"transitionend.sapMGT$id animationend.sapMGT$id".replace(/\$id/g,q.sap.camelCase(this.getId()));};e.prototype._updateHoverStyle=function(f){if(!this._getStyleData()&&!f){return;}this._clearAnimationUpdateQueue();this._cHoverStyleUpdates=-1;this._oAnimationEndCallIds={};if(this._oStyleData&&this._oStyleData.lineBreak&&this.getUIArea()){this._$RootNode=q(this.getUIArea().getRootNode());this._$RootNode.on(this._getAnimationEvents(),this._queueAnimationEnd.bind(this));}this._queueAnimationEnd();};e.prototype._queueAnimationEnd=function(E){if(E){var t=q(E.target);if(t.is(".sapMGT, .sapMGT *")){return false;}}if(typeof this._cHoverStyleUpdates!=="number"){this._cHoverStyleUpdates=-1;}if(!this._oAnimationEndCallIds){this._oAnimationEndCallIds={};}this._cHoverStyleUpdates++;this._oAnimationEndCallIds[this._cHoverStyleUpdates]=q.sap.delayedCall(10,this,this._handleAnimationEnd,[this._cHoverStyleUpdates]);};e.prototype._handleAnimationEnd=function(h){delete this._oAnimationEndCallIds[h];if(this._cHoverStyleUpdates===h){this._getStyleData();L._updateHoverStyle.call(this);}};e.prototype._clearAnimationUpdateQueue=function(){for(var k in this._oAnimationEndCallIds){q.sap.clearDelayedCall(this._oAnimationEndCallIds[k]);delete this._oAnimationEndCallIds[k];}};e.prototype._getLineCount=function(){var o=this.getDomRef().getBoundingClientRect(),f=L._getCSSPixelValue(this,"line-height");return Math.round(o.height/f);};e.prototype.getBoundingRects=function(){var p=this.$().offset();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()){this._getStyleData();var r=[],s,o;this.$().find(".sapMGTLineStyleHelper").each(function(){s=q(this);o=s.offset();r.push({offset:{x:o.left,y:o.top},width:s.width(),height:s.height()});});return r;}else{return[{offset:{x:p.left,y:p.top},width:this.$().width(),height:this.$().height()}];}};e.prototype._updateLineTileSiblings=function(){var p=this.getParent();if(this.getMode()===l.GenericTileMode.LineMode&&this._isScreenLarge()&&p){var i=p.indexOfAggregation(this.sParentAggregationName,this);var s=p.getAggregation(this.sParentAggregationName).splice(i+1);for(i=0;i<s.length;i++){var o=s[i];if(o instanceof l.GenericTile&&o.getMode()===l.GenericTileMode.LineMode){o._updateHoverStyle();}}}};e.prototype.ontouchstart=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.addStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==l.LoadState.Disabled){this.$().focus();}};e.prototype.ontouchcancel=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}};e.prototype.ontouchend=function(){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}if(this.getMode()===l.GenericTileMode.LineMode){this.removeStyleClass("sapMGTLineModePress");}if(D.browser.internet_explorer&&this.getState()!==l.LoadState.Disabled){this.$().focus();}};e.prototype.ontap=function(f){var p;if(this._bTilePress&&this.getState()!==l.LoadState.Disabled){this.$().focus();p=this._getEventParams(f);this.firePress(p);f.preventDefault();}};e.prototype.onkeydown=function(f){if(q.sap.PseudoEvents.sapselect.fnCheck(f)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").addClass("sapMGTPressActive");}f.preventDefault();}};e.prototype._updateAriaLabel=function(){var A=this._getAriaText(),t=this.$(),i=false;if(t.attr("aria-label")!==A){t.attr("aria-label",A);i=true;}return i;};e.prototype.onkeyup=function(f){var p,g=false,s=this.getScope(),A=s===l.GenericTileScope.Actions;if(A&&(q.sap.PseudoEvents.sapdelete.fnCheck(f)||q.sap.PseudoEvents.sapbackspace.fnCheck(f))){p={scope:s,action:e._Action.Remove,domRef:this._oRemoveButton.getPopupAnchorDomRef()};g=true;}if(q.sap.PseudoEvents.sapselect.fnCheck(f)&&this.getState()!==l.LoadState.Disabled){if(this.$("hover-overlay").length>0){this.$("hover-overlay").removeClass("sapMGTPressActive");}p=this._getEventParams(f);g=true;}if(g){this.firePress(p);f.preventDefault();}this._updateAriaLabel();};e.prototype.setProperty=function(p){C.prototype.setProperty.apply(this,arguments);if(this.getMode()===l.GenericTileMode.LineMode&&e.LINEMODE_SIBLING_PROPERTIES.indexOf(p)!==-1){this._bUpdateLineTileSiblings=true;}return this;};e.prototype.getHeader=function(){return this._oTitle.getText();};e.prototype.setHeader=function(t){this._oTitle.setText(t);return this;};e.prototype.setHeaderImage=function(u){var v=!q.sap.equal(this.getHeaderImage(),u);if(v){if(this._oImage){this._oImage.destroy();this._oImage=undefined;}if(u){this._oImage=a.createControlByURI({id:this.getId()+"-icon-image",src:u},l.Image);this._oImage.addStyleClass("sapMGTHdrIconImage");}}return this.setProperty("headerImage",u);};e.prototype._applyHeaderMode=function(s){if(s){this._oTitle.setMaxLines(4);}else{this._oTitle.setMaxLines(5);}this._changeTileContentContentVisibility(false);};e.prototype._applyContentMode=function(s){if(s){this._oTitle.setMaxLines(2);}else{this._oTitle.setMaxLines(3);}this._changeTileContentContentVisibility(true);};e.prototype._changeTileContentContentVisibility=function(v){var t;t=this.getTileContent();for(var i=0;i<t.length;i++){t[i].setRenderContent(v);}};e.prototype._getHeaderAriaAndTooltipText=function(){var t="";var i=true;if(this.getHeader()){t+=this.getHeader();i=false;}if(this.getSubheader()){t+=(i?"":"\n")+this.getSubheader();i=false;}if(this.getImageDescription()){t+=(i?"":"\n")+this.getImageDescription();}return t;};e.prototype._getContentAriaAndTooltipText=function(){var t="";var f=true;var g=this.getTileContent();for(var i=0;i<g.length;i++){if(q.isFunction(g[i]._getAriaAndTooltipText)){t+=(f?"":"\n")+g[i]._getAriaAndTooltipText();}else if(g[i].getTooltip_AsString()){t+=(f?"":"\n")+g[i].getTooltip_AsString();}f=false;}return t;};e.prototype._getAriaAndTooltipText=function(){var A=(this.getTooltip_AsString()&&!this._isTooltipSuppressed())?this.getTooltip_AsString():(this._getHeaderAriaAndTooltipText()+"\n"+this._getContentAriaAndTooltipText());switch(this.getState()){case l.LoadState.Disabled:return"";case l.LoadState.Loading:return A+"\n"+this._sLoading;case l.LoadState.Failed:return A+"\n"+this._oFailedText.getText();default:if(q.trim(A).length===0){return"";}else{return A;}}};e.prototype._getAriaText=function(){var A=this.getTooltip_Text();var s=this.getAriaLabel();if(!A||this._isTooltipSuppressed()){A=this._getAriaAndTooltipText();}if(this.getScope()===l.GenericTileScope.Actions){A=this._oRb.getText("GENERICTILE_ACTIONS_ARIA_TEXT")+" "+A;}if(s){A=s+" "+A;}return A;};e.prototype._getTooltipText=function(){var t=this.getTooltip_Text();if(this._isTooltipSuppressed()===true){t=null;}return t;};e.prototype._checkFooter=function(t,f){var s=f.getState();var A=this.getScope()===l.GenericTileScope.Actions||this._bShowActionsView===true;if(s===l.LoadState.Failed||A&&s!==l.LoadState.Disabled){t.setRenderFooter(false);}else{t.setRenderFooter(true);}};e.prototype._generateFailedText=function(){var s=this.getFailedText();var f=s?s:this._sFailedToLoad;this._oFailedText.setText(f);this._oFailedText.setTooltip(f);};e.prototype._isTooltipSuppressed=function(){var t=this.getTooltip_Text();if(t&&t.length>0&&q.trim(t).length===0){return true;}else{return false;}};e.prototype._isHeaderTextTruncated=function(){var o,m,h,w;if(this.getMode()===l.GenericTileMode.LineMode){h=this.$("hdr-text");if(h.length>0){w=Math.ceil(h[0].getBoundingClientRect().width);return(h[0]&&w<h[0].scrollWidth);}else{return false;}}else{o=this.getAggregation("_titleText").getDomRef("inner");m=this.getAggregation("_titleText").getClampHeight(o);return(m<o.scrollHeight);}};e.prototype._isSubheaderTextTruncated=function(){var s=this.$("subHdr-text"),w;if(s.length>0){w=Math.ceil(s[0].getBoundingClientRect().width);return(s[0]&&w<s[0].scrollWidth);}else{return false;}};e.prototype._setTooltipFromControl=function(){var o,t="";var f=true;var g=this.getTileContent();if(this._isHeaderTextTruncated()){t=this._oTitle.getText();f=false;}if(this._isSubheaderTextTruncated()){t+=(f?"":"\n")+this.getSubheader();f=false;}if(this.getScope()!==l.GenericTileScope.Actions){for(var i=0;i<g.length;i++){o=g[i].getContent();if(o&&o.getMetadata().getLibraryName()==="sap.suite.ui.microchart"){t+=(f?"":"\n")+o.getTooltip_AsString();}f=false;}}if(t&&!this._getTooltipText()&&!this._isTooltipSuppressed()){this.$().attr("title",t);this._bTooltipFromControl=true;}};e.prototype._updateAriaAndTitle=function(){var A=this._getAriaAndTooltipText();var s=this._getAriaText();var t=this.$();if(t.attr("title")!==A){t.attr("aria-label",s);}if(this.getScope()===l.GenericTileScope.Actions){t.find('*:not(.sapMGTRemoveButton)').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}else{t.find('*').removeAttr("aria-label").removeAttr("title").unbind("mouseenter");}this._setTooltipFromControl();};e.prototype._removeTooltipFromControl=function(){if(this._bTooltipFromControl){this.$().removeAttr("title");this._bTooltipFromControl=false;}};e.prototype._isScreenLarge=function(){return this._getCurrentMediaContainerRange("GenericTileDeviceSet").name==="large";};e.prototype._getEventParams=function(E){var p,A=e._Action.Press,s=this.getScope(),o=this.getDomRef();if(s===l.GenericTileScope.Actions&&E.target.id.indexOf("-action-remove")>-1){A=e._Action.Remove;o=this._oRemoveButton.getPopupAnchorDomRef();}else if(s===l.GenericTileScope.Actions){o=this._oMoreIcon.getDomRef();}p={scope:s,action:A,domRef:o};return p;};e.prototype._handleMediaChange=function(){this._bUpdateLineTileSiblings=true;this.invalidate();};e.prototype.setPressEnabled=function(v){this._bTilePress=v;};e.prototype.showActionsView=function(v){if(this._bShowActionsView!==v){this._bShowActionsView=v;this.invalidate();}};return e;});
