/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','sap/ui/core/format/NumberFormat','sap/m/library','sap/ui/model/ChangeReason','sap/ui/base/ManagedObjectMetadata'],function(q,B,N,l,C,M){"use strict";var L=l.ListType;var a=l.ListGrowingDirection;var G=B.extend("sap.m.GrowingEnablement",{constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iLastItemsCount=0;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},render:function(r){r.write("<div");r.addClass("sapMListUl");r.addClass("sapMGrowingList");r.writeAttribute("id",this._oControl.getId()+"-triggerList");r.addStyle("display","none");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(this._getTrigger());r.write("</div>");},onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=l.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection());}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(!this._bLoading){this._updateTriggerDelayed(false);}},setTriggerText:function(t){this._oControl.$("triggerText").text(t);},reset:function(){this._iLimit=0;},shouldReset:function(c){var m=C;return c==m.Sort||c==m.Filter||c==m.Context;},getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},onScrollToLoad:function(){if(!this._bLoading&&this._oControl.getGrowingDirection()==a.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var b=this._oControl.getBinding("items");if(b&&!b.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){if(this._oControl.getMetadata().hasProperty("enableBusyIndicator")){this._bParentEnableBusyIndicator=this._oControl.getEnableBusyIndicator();this._oControl.setEnableBusyIndicator(false);}this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);if(this._oControl.setEnableBusyIndicator){this._oControl.setEnableBusyIndicator(this._bParentEnableBusyIndicator);}},_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new sap.m.CustomListItem({id:t,busyIndicatorDelay:0,type:L.Active,content:new sap.ui.core.HTML({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLITitleDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+q.sap.encodeHTML(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addEventDelegate({onsapenter:function(e){this.requestNewPage();e.preventDefault();},onsapspace:function(e){this.requestNewPage();e.preventDefault();},onAfterRendering:function(e){this._oTrigger.$().attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},_getListItemInfo:function(){this._iLastItemsCount=this._oControl.getItems(true).length;return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},_getGroupingPath:function(b){var s=b.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>80;},destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},addListItem:function(c,b,s){var o=this._oControl,d=b.binding,i=this.createListItem(c,b);if(d.isGrouped()){var I=o.getItems(true),e=I[I.length-1],m=b.model,g=d.getGroup(i.getBindingContext(m));if(e&&e.isGroupHeader()){o.removeAggregation("items",e,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,e,s);e=I[I.length-1];}if(!e||g.key!==d.getGroup(e.getBindingContext(m)).key){var f=(b.groupHeaderFactory)?b.groupHeaderFactory(g):null;if(o.getGrowingDirection()==a.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,f,s);}else{this.appendGroupItem(g,f,s);}}}o.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},createListItem:function(c,b){this._iRenderedDataItems++;var i=b.factory(M.uid("clone"),c);return i.setBindingContext(c,b.model);},updateItemsBindingContext:function(b,m){if(!b.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(b[c++],m);}}},applyChunk:function(I,d){this.applyPendingGroupItem();var b=this._aChunk.length;if(!b){return;}if(this._oControl.getGrowingDirection()==a.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-b-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<b;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},addListItems:function(c,b,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],b,s);}},rebuildListItems:function(c,b,s){this.destroyListItems(s);this.addListItems(c,b,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},insertListItem:function(c,b,i){var I=this.createListItem(c,b);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},updateItems:function(c){var o=this._oControl,b=o.getBinding("items"),d=o.getBindingInfo("items"),I=o.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=o.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var e=b.getContexts(0,this._iLimit)||[];if(e.dataRequested){this._bDataRequested=true;if(e.diff&&!e.diff.length){return;}}this._oContainerDomRef=o.getItemsContainerDomRef();var D=e.diff,f=false,v;if(!e.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(e,d);}else if(!D||!I.length&&D.length){this.rebuildListItems(e,d,true);}else if(b.isGrouped()||o.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(b)){f=true;}else{for(var i=0;i<D.length;i++){var g=D[i],h=e[g.index];if(g.type=="delete"){f=true;break;}else if(g.index!=this._iRenderedDataItems){f=true;break;}else{this.addListItem(h,d,true);v=true;}}}}else{if(this._sGroupingPath){o.removeGroupHeaders(true);}v=-1;var j=-1;for(var i=0;i<D.length;i++){var g=D[i],k=g.index,h=e[k];if(g.type=="delete"){if(v!=-1){this.applyChunk(v);j=-1;v=-1;}this.deleteListItem(k);}else{if(v==-1){v=k;}else if(j>-1&&k!=j+1){this.applyChunk(v);v=k;}this.insertListItem(h,d,k);j=k;}}}if(f){this.rebuildListItems(e,d,true);}else if(this._oContainerDomRef&&D){this.updateItemsBindingContext(e,d.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(b);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},_updateTriggerDelayed:function(b){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,b));}else{this._updateTrigger(b);}},_updateTrigger:function(b){var t=this._oTrigger,c=this._oControl;if(!t||!c||!c.shouldRenderItems()||!c.getDomRef()){return;}var o=c.getBinding("items");if(!o){return;}t.setBusy(b);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",b);if(b){t.setActive(false);c.$("triggerList").css("display","");}else{var i=c.getItems(true),I=i.length,d=o.getLength()||0,e=o.isLengthFinal(),h=c.getGrowingScrollToLoad(),T=t.getDomRef();if(T&&T.contains(document.activeElement)){(i[this._iLastItemsCount]||c).focus();}if(!I||!this._iLimit||(e&&this._iLimit>=d)||(h&&this._getHasScrollbars())){c.$("triggerList").css("display","none");}else{if(e){c.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");c.$("triggerList").css("display","");}if(h&&this._oScrollPosition===undefined&&c.getGrowingDirection()==a.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}}});return G;});
