/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,D,N,L,P,M,U,a,E){"use strict";var b=l.ListType;var c=l.ListMode;var d=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});E.call(d.prototype);d.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';d.UNFIFIED_MENU_ITEMS_PROPS=sap.ui.unified.MenuItem.getMetadata().getAllProperties();d.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';d.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();d.prototype.init=function(){if(a.system.phone){this._initDialog();}this._bIsInitialized=false;};d.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};d.prototype.invalidate=function(){};d.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};d.prototype.openBy=function(o,w){if(a.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var g=sap.ui.core.Popup.Dock;this._getMenu().open(w,o,g.BeginTop,g.BeginBottom,o,"0 -2");}};d.prototype.close=function(){if(a.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};d.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.removeStyleClass("sapUiPopupWithPadding");this.setAggregation("_dialog",o,true);};d.prototype._getDialog=function(){return this.getAggregation("_dialog");};d.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};d.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};d.prototype._initMenuForItems=function(i,p){var m=new U();m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};d.prototype._menuClosed=function(){this.fireClosed();};d.prototype._getMenu=function(){return this.getAggregation("_menu");};d.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:f.bind(this)});};function f(){this._getDialog().close();}d.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};d.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};d.prototype._initAllPages=function(){this._initPageForParent(this);};d.prototype._initPageForParent=function(p){var i=p.getItems(),g=p instanceof d,s=g?p.getTitle():p.getText(),o=new L({mode:c.None}),h=new P({title:s,showNavButton:!g,content:o});if(!g){this._setBackButtonTooltipForPageWithParent(p,h);}h.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(h);i.forEach(function(I){this._addListItemFromItem(I,h);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return h;};d.prototype._handleListItemPress=function(o){var g=o.getParameter("listItem"),m=sap.ui.getCore().byId(g.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};d.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var g=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=g instanceof d?g.getTitle():g.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};d.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:b.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};d.prototype._createVisualMenuItemFromItem=function(i){return new sap.ui.unified.MenuItem({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection(),tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()});};d.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var g=['aggregationChanged','propertyChanged'];g.forEach(function(s){var h='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[h],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};d.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var g=['aggregationChanged','propertyChanged'];g.forEach(function(s){var h='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[h],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};d.prototype._addVisualItemFromItem=function(i,o,I){if(!o){return;}if(a.system.phone){this._addListItemFromItem(i,o,I);var g=o.getContent()[0];this._updateListInset(g);}else{this._addVisualMenuItemFromItem(i,o,I);}};d.prototype._updateListInset=function(o){var h=false,I="sapMListIcons",g=o.getItems();for(var i=0;i<g.length;i++){if(g[i].getIcon()){h=true;break;}}if(h){o.addStyleClass(I);}else{o.removeStyleClass(I);}};d.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};d.prototype._generateListItemId=function(m){return m+d.LIST_ITEMS_ID_SUFFIX;};d.prototype._generateUnifiedMenuItemId=function(m){return m+d.UNIFIED_MENU_ITEMS_ID_SUFFIX;};d.prototype._findMenuItemByUnfdMenuItem=function(u){var g=[],o=u,I,h,i;do{g.push(o.getId());o=o.getParent().getParent();}while(o instanceof sap.ui.unified.MenuItem);I=this.getItems();do{h=g.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===h){if(g.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(g.length);return null;};d.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(e(m.oOpenerRef)){return true;}return false;};function e(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}d.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._addVisualItemFromItem(o,this._getVisualParent());}return this;};d.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._addVisualItemFromItem(o,this._getVisualParent(),i);}return this;};d.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};d.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};d.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(a.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}v.destroy();}};d.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};d.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};d.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};d.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),g=o.getParameter("propertyValue"),t=a.system.phone?d.MENU_LIST_ITEMS_PROPS:d.UNFIFIED_MENU_ITEMS_PROPS,G=a.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(a.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,g);if(a.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};d.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;}};d.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),g=o.getParameter("methodParams"),h;if(m==="add"||m==="insert"){if(m==="insert"){h=g.index;}this._addOrInsertItem(I,g.item,h);}if(m==="remove"){this._removeVisualItem(g.item,I);}if(m==="removeall"){for(var i=0;i<g.items.length;i++){this._removeVisualItem(g.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};d.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._addVisualItemFromItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(a.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};d.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};d.prototype.getDomRefId=function(){if(a.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};d.prototype.openAsContextMenu=function(o,O){if(a.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){d.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return d;});
