/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/Device','sap/ui/base/ManagedObject'],function(l,C,I,a,c,D,M){"use strict";var T=c.TextDirection;var O=C.extend("sap.m.ObjectIdentifier",{metadata:{library:"sap.m",designTime:true,properties:{title:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Misc",defaultValue:null},badgeNotes:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgePeople:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},badgeAttachments:{type:"boolean",group:"Misc",defaultValue:null,deprecated:true},visible:{type:"boolean",group:"Appearance",defaultValue:true},titleActive:{type:"boolean",group:"Misc",defaultValue:false},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:T.Inherit}},aggregations:{_titleControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_textControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{titlePress:{parameters:{domRef:{type:"object"}}}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});O.prototype.init=function(){var L=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(sap.ui.getCore().getConfiguration().getAccessibility()){O.OI_ARIA_ROLE=L.getText("OI_ARIA_ROLE");this._createAriaInfoTextControl();}};O.prototype.exit=function(){if(this._attachmentsIcon){this._attachmentsIcon.destroy();this._attachmentsIcon=null;}if(this._peopleIcon){this._peopleIcon.destroy();this._peopleIcon=null;}if(this._notesIcon){this._notesIcon.destroy();this._notesIcon=null;}if(this._oAriaCustomRole){this._oAriaCustomRole.destroy();this._oAriaCustomRole=null;}};O.prototype._getAttachmentsIcon=function(){if(!this._attachmentsIcon){this._attachmentsIcon=this._getIcon(I.getIconURI("attachment"),this.getId()+"-attachments");}return this._attachmentsIcon;};O.prototype._getPeopleIcon=function(){if(!this._peopleIcon){this._peopleIcon=this._getIcon(I.getIconURI("group"),this.getId()+"-people");}return this._peopleIcon;};O.prototype._getNotesIcon=function(){if(!this._notesIcon){this._notesIcon=this._getIcon(I.getIconURI("notes"),this.getId()+"-notes");}return this._notesIcon;};O.prototype._getIcon=function(u,i){var s=D.system.phone?"1em":"1em";var o;o=this._icon||I.createControlByURI({src:u,id:i+"-icon",size:s,useIconTooltip:false},sap.m.Image);o.setSrc(u);return o;};O.prototype._getTitleControl=function(){var t=this.getAggregation("_titleControl");if(!t){if(this.getProperty("titleActive")){t=new sap.m.Link({id:this.getId()+"-link",text:M.escapeSettingsValue(this.getProperty("title")),ariaLabelledBy:this._oAriaCustomRole});}else{t=new sap.m.Text({id:this.getId()+"-txt",text:M.escapeSettingsValue(this.getProperty("title"))});}this.setAggregation("_titleControl",t,true);}t.setVisible(!!this.getTitle());return t;};O.prototype._updateTitleControl=function(i){var r,t=this._getTitleControl();if(i&&t instanceof sap.m.Text){this.destroyAggregation("_titleControl",true);t=new sap.m.Link({id:this.getId()+"-link",text:M.escapeSettingsValue(this.getProperty("title")),ariaLabelledBy:this._oAriaCustomRole});this.setAggregation("_titleControl",t,true);}else if(!i&&t instanceof sap.m.Link){this.destroyAggregation("_titleControl",true);t=new sap.m.Text({id:this.getId()+"-txt",text:M.escapeSettingsValue(this.getProperty("title"))});this.setAggregation("_titleControl",t,true);}if(this.$("title").children().length>0){t.setProperty("text",this.getProperty("title"),true);r=sap.ui.getCore().createRenderManager();r.renderControl(t);r.flush(this.$("title")[0]);r.destroy();}return t;};O.prototype._getTextControl=function(){var t=this.getAggregation("_textControl");if(!t){t=new sap.m.Text({text:M.escapeSettingsValue(this.getProperty("text"))});this.setAggregation("_textControl",t,true);}t.setTextDirection(this.getTextDirection());t.setVisible(!!this.getText());return t;};O.prototype.setTitle=function(t){var o=this._getTitleControl();o.setProperty("text",t,false);o.setVisible(!!t);this.setProperty("title",t,true);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};O.prototype.setText=function(t){this.setProperty("text",t,true);var o=this._getTextControl();o.setProperty("text",t,false);this.$("text").toggleClass("sapMObjectIdentifierTextBellow",!!this.getProperty("text")&&!!this.getProperty("title"));return this;};O.prototype.setTitleActive=function(v){var p=this.getProperty("titleActive");if(p!=v){this.setProperty("titleActive",v,true);this._updateTitleControl(v);}return this;};O.prototype._handlePress=function(e){var o=e.target;if(this.getTitleActive()&&this.$("title")[0].firstChild==o){this.fireTitlePress({domRef:o});e.setMarked();}};O.prototype.onsapenter=function(e){O.prototype._handlePress.apply(this,arguments);};O.prototype.onsapspace=function(e){O.prototype._handlePress.apply(this,arguments);};O.prototype.ontap=function(e){O.prototype._handlePress.apply(this,arguments);};O.prototype.addAssociation=function(A,i,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.addAssociation("ariaLabelledBy",i,true);}}return C.prototype.addAssociation.apply(this,arguments);};O.prototype.removeAssociation=function(A,o,s){var t=this.getAggregation("_titleControl");if(A==="ariaLabelledBy"){if(this.getTitleActive()&&t instanceof sap.m.Link){t.removeAssociation("ariaLabelledBy",o,true);}}return C.prototype.removeAssociation.apply(this,arguments);};O.prototype._createAriaInfoTextControl=function(){if(!this._oAriaCustomRole){this._oAriaCustomRole=new a(this.getId()+"-oIHiddenText",{text:O.OI_ARIA_ROLE});}return this._oAriaCustomRole;};return O;});
