/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls","sap/ui/core/IconPool","sap/m/SearchField","sap/ui/Device"],function(q,l,T,I,a,b,O,c,d,e,S,D){"use strict";var P=l.PlacementType;var B=l.ButtonType;var f=l.OverflowToolbarPriority;var g=a.extend("sap.m.OverflowToolbar",{metadata:{aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}}}});g.prototype._callToolbarMethod=function(F,A){return a.prototype[F].apply(this,A);};g.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bNestedInAPopover=null;this._bListenForControlPropertyChanges=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;if(!g._sAriaOverflowButtonLabelId){var C=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");g._sAriaOverflowButtonLabelId=new I({text:C.getText("Icon.overflow")}).toStatic().getId();}this._aControlSizes={};};g.prototype.exit=function(){var p=this.getAggregation("_popover");if(p){p.destroy();}};g.prototype.onAfterRendering=function(){if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;}if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){this.$().lastFocusableDomRef().focus();this._bOverflowButtonWasFocused=false;}this._getOverflowButton().$().attr("aria-haspopup","true");this._doLayout();};g.prototype._doLayout=function(){var C=sap.ui.getCore();if(!C.isThemeApplied()){q.sap.log.debug("OverflowToolbar: theme not applied yet, skipping calculations",this);return;}var w=this.$().width();this._bListenForControlPropertyChanges=false;this._deregisterToolbarResize();this._polyfillFlexboxSupport();if(w>0){if(!this._isControlsInfoCached()){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==w){this._iPreviousToolbarWidth=w;this._setControlsOverflowAndShrinking(w);this.fireEvent("_controlWidthChanged");}}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;};g.prototype._polyfillFlexboxSupport=function(){if(a.hasNewFlexBoxSupport){return;}var t=this.$();var o=t[0]||{};t.removeClass("sapMTBOverflow");var h=o.scrollWidth>o.clientWidth;h&&t.addClass("sapMTBOverflow");};g.prototype._cacheControlsInfo=function(){var p,C,A;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aActionSheetOnlyControls=[];this._iOldContentSize=this._iContentSize;this._iContentSize=0;this.getContent().forEach(function(o){p=g._getControlPriority(o);C=p!==f.NeverOverflow;A=p===f.AlwaysOverflow;var i=g._getOptimalControlWidth(o,this._aControlSizes[o.getId()]);this._aControlSizes[o.getId()]=i;if(d.supportsControl(o)&&A){this._aActionSheetOnlyControls.push(o);}else{this._iContentSize+=i;if(d.supportsControl(o)&&C&&o.getVisible()){this._aMovableControls.push(o);}else{this._aToolbarOnlyControls.push(o);}}},this);if(D.system.phone){this._iContentSize-=1;}this._bControlsInfoCached=true;if(this._iOldContentSize!==this._iContentSize){this.fireEvent("_contentSizeChange",{contentSize:this._iContentSize});}};g.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached;};g.prototype._setControlsOverflowAndShrinking=function(t){var C=this._iContentSize,h=[],s,i,A,F=function(p){p.forEach(function(r){this._moveButtonToActionSheet(r);},this);},j=function(H){if(typeof H==="undefined"||this._getPopover()._getContentIdsHash()!==H){this.invalidate();if(this._getControlsIds().indexOf(sap.ui.getCore().getCurrentFocusedControlId())!==-1){this._bControlWasFocused=true;}if(sap.ui.getCore().getCurrentFocusedControlId()===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;}}},k=function(C){if(!this._getOverflowButtonNeeded()){C+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}return C;},m=function(M){var G={},p=[];M.forEach(function(r){var u=g._getControlGroup(r),v=g._oPriorityOrder,w,x,y;if(u){w=g._getControlPriority(r);x=this._getControlIndex(r);G[u]=G[u]||[];y=G[u];y.push(r);if(!y._priority||v[y._priority]<v[w]){y._priority=w;}if(!y._index||y._index<x){y._index=x;}}else{p.push(r);}},this);Object.keys(G).forEach(function(r){p.push(G[r]);});return p;},E=function(M){if(M.length){M.forEach(o,this);}else{o.call(this,M);}if(C<=t){return true;}},n=function(v,p){var r=g._oPriorityOrder,u=g._getControlPriority(v),w=g._getControlPriority(p),x=r[u]-r[w];if(x!==0){return x;}else{return this._getControlIndex(p)-this._getControlIndex(v);}},o=function(p){h.unshift(p);C-=this._aControlSizes[p.getId()];};if(this._bSkipOptimization){this._bSkipOptimization=false;}else{s=this._getPopover()._getContentIdsHash();}this._resetToolbar();if(this._aActionSheetOnlyControls.length){for(i=this._aActionSheetOnlyControls.length-1;i>=0;i--){if(this._aActionSheetOnlyControls[i].getVisible()){h.unshift(this._aActionSheetOnlyControls[i]);}}if(h.length>0){C=k.call(this,C);}}if(C<=t){F.call(this,h);j.call(this,s);return;}if(this._aMovableControls.length){C=k.call(this,C);A=m.call(this,this._aMovableControls);A.sort(n.bind(this));A.some(E,this);}F.call(this,h);if(C>t){this._checkContents();}j.call(this,s);};g.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(function(o){this._restoreButtonInToolbar(o);},this);this._setOverflowButtonNeeded(false);this.getContent().forEach(function(C){C.removeStyleClass(a.shrinkClass);});};g.prototype._moveButtonToActionSheet=function(o){this._getPopover().addAssociatedContent(o);};g.prototype._restoreButtonInToolbar=function(v){if(typeof v==="object"){v=v.getId();}this._getPopover().removeAssociatedContent(v);};g.prototype._resetAndInvalidateToolbar=function(h){if(this._bIsBeingDestroyed){return;}this._resetToolbar();for(var C in this._aControlSizes){if(this._aControlSizes.hasOwnProperty(C)){this._aControlSizes[C]=0;}}this._bControlsInfoCached=false;this._bNestedInAPopover=null;this._iPreviousToolbarWidth=null;if(h){this._bSkipOptimization=true;}if(this.$().length){this.invalidate();}};g.prototype._getVisibleContent=function(){var t=this.getContent(),A=this._getPopover()._getAllContent();return t.filter(function(C){return A.indexOf(C)===-1;});};g.prototype._getVisibleAndNonOverflowContent=function(){return this._getVisibleContent().filter(function(C){return C.getVisible();});};g.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=new T({id:this.getId()+"-overflowButton",icon:e.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),ariaLabelledBy:this._sAriaOverflowButtonLabelId,type:B.Transparent});this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};g.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),s=this._getBestActionSheetPlacement();if(p.getPlacement()!==s){p.setPlacement(s);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};g.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new c(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:D.system.phone?false:true,contentWidth:D.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset()});p._adaptPositionParams=function(){c.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"];};if(D.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};g.prototype._shiftPopupShadow=function(){var p=this._getPopover(),s=p.getCurrentPosition();if(s===P.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(s===P.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};g.prototype._popOverClosedHandler=function(){var w=D.os.windows_phone||D.browser.edge&&D.browser.mobile;this._getOverflowButton().setPressed(false);this._getOverflowButton().$().focus();if(this._isNestedInsideAPopup()||w){return;}this._getOverflowButton().setEnabled(false);q.sap.delayedCall(0,this,function(){this._getOverflowButton().setEnabled(true);q.sap.delayedCall(0,this,function(){this._getOverflowButton().$().focus();});});};g.prototype._isNestedInsideAPopup=function(){var s;if(this._bNestedInAPopover!==null){return this._bNestedInAPopover;}s=function(C){if(!C){return false;}if(C.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(C.getParent());};this._bNestedInAPopover=s(this);return this._bNestedInAPopover;};g.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};g.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};g.prototype.onLayoutDataChange=function(){this._resetAndInvalidateToolbar(true);};g.prototype.addContent=function(C){this._registerControlListener(C);this._preProcessControl(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("addContent",arguments);};g.prototype.insertContent=function(C,i){this._registerControlListener(C);this._preProcessControl(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("insertContent",arguments);};g.prototype.removeContent=function(C){var v=this._callToolbarMethod("removeContent",arguments);if(v){this._getPopover().removeAssociatedContent(v.getId());}this._resetAndInvalidateToolbar(false);this._postProcessControl(v);this._deregisterControlListener(v);return v;};g.prototype.removeAllContent=function(){var C=this._callToolbarMethod("removeAllContent",arguments);C.forEach(function(o){this._deregisterControlListener(o);this._postProcessControl(o);},this);this._resetAndInvalidateToolbar(false);return C;};g.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);q.sap.delayedCall(0,this,function(){this._resetAndInvalidateToolbar(false);});return this._callToolbarMethod("destroyContent",arguments);};g.prototype._registerControlListener=function(C){if(C){C.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};g.prototype._deregisterControlListener=function(C){if(C){C.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};g.prototype._onContentPropertyChangedOverflowToolbar=function(E){if(!this._bListenForControlPropertyChanges){return;}var s=E.getSource();var C=d.getControlConfig(s);var p=E.getParameter("name");if(typeof C!=="undefined"&&C.noInvalidationProps.indexOf(p)!==-1){return;}this._resetAndInvalidateToolbar(true);};g.prototype._getOverflowButtonSize=function(){var i=parseInt(l.BaseFontSize,10),C=this.$().parents().hasClass('sapUiSizeCompact')?2.5:3;return parseInt(i*C,10);};g.prototype._getBestActionSheetPlacement=function(){var h=this.getHTMLTag();if(h==="Footer"){return P.Top;}else if(h==="Header"){return P.Bottom;}return P.Vertical;};g.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};g.prototype._preProcessControl=function(C){if(!(C instanceof S)){return;}if(C.getSelectOnFocus()){C.setProperty("selectOnFocus",false,true);C._origSelectOnFocus=true;}};g.prototype._postProcessControl=function(C){if(!(C instanceof S)){return;}if(typeof C._origSelectOnFocus!=="undefined"){C.setProperty("selectOnFocus",C._origSelectOnFocus,true);delete C._origSelectOnFocus;}};g.prototype._getControlIndex=function(C){return C.length?C._index:this.indexOfContent(C);};g._getOptimalControlWidth=function(C,o){var i;if(C instanceof b){i=parseInt(C.$().css('min-width'),10)||0+C.$().outerWidth(true)-C.$().outerWidth();}else{i=C.getVisible()?C.$().outerWidth(true):0;}if(i===null){i=typeof o!=="undefined"?o:0;}return i;};g._getControlPriority=function(C){if(C.length){return C._priority;}var L=C.getLayoutData&&C.getLayoutData();if(L&&L instanceof O){if(L.getMoveToOverflow()===false){return f.NeverOverflow;}if(L.getStayInOverflow()===true){return f.AlwaysOverflow;}var p=L.getPriority();if(p===f.Never){return f.NeverOverflow;}if(p===f.Always){return f.AlwaysOverflow;}return p;}return f.High;};g._getControlGroup=function(C){var L=C.getLayoutData();if(L instanceof O){return L.getGroup();}};g._oPriorityOrder=(function(){var p={};p[f.Disappear]=1;p[f.Low]=2;p[f.High]=3;return p;})();g.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass('sapUiSizeCompact')?2:3;};g.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();};g.prototype.closeOverflow=function(){this._getPopover().close();};return g;});
