/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/IconPool'],function(l,C,I){"use strict";var P=l.PanelAccessibleRole;var B=l.BackgroundDesign;var a=C.extend("sap.m.Panel",{metadata:{library:"sap.m",properties:{headerText:{type:"string",group:"Data",defaultValue:""},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"100%"},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"auto"},expandable:{type:"boolean",group:"Appearance",defaultValue:false},expanded:{type:"boolean",group:"Appearance",defaultValue:false},expandAnimation:{type:"boolean",group:"Behavior",defaultValue:true},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent},accessibleRole:{type:"sap.m.PanelAccessibleRole",group:"Accessibility",defaultValue:P.Form}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false}},events:{expand:{parameters:{expand:{type:"boolean"},triggeredByInteraction:{type:"boolean"}}}},designTime:true}});a.prototype.init=function(){this._bInteractiveExpand=false;this.data("sap-ui-fastnavgroup","true",true);};a.prototype.setWidth=function(w){this.setProperty("width",w,true);var d=this.getDomRef();if(d){d.style.width=w;}return this;};a.prototype.setHeight=function(h){this.setProperty("height",h,true);var d=this.getDomRef();if(d){d.style.height=h;if(parseFloat(h)!=0){d.querySelector(".sapMPanelContent").style.height=h;}this._setContentHeight();}return this;};a.prototype.onThemeChanged=function(){this._setContentHeight();};a.prototype.setExpandable=function(e){this.setProperty("expandable",e,false);if(e&&!this.oIconCollapsed){this.oIconCollapsed=this._createIcon();}return this;};a.prototype.setExpanded=function(e){if(e===this.getExpanded()){return this;}this.setProperty("expanded",e,true);if(!this.getExpandable()){return this;}this._getIcon().$().attr("aria-expanded",this.getExpanded());this._toggleExpandCollapse();this._toggleCssClasses();this.fireExpand({expand:e,triggeredByInteraction:this._bInteractiveExpand});this._bInteractiveExpand=false;return this;};a.prototype.setAccessibleRole=function(r){if(r===this.getAccessibleRole()){return this;}this.setProperty("accessibleRole",r,true);if(sap.ui.getCore().getConfiguration().getAccessibility()){this.$().attr("role",this.getAccessibleRole().toLowerCase());}return this;};a.prototype.onBeforeRendering=function(){this._updateIconAriaLabelledBy();};a.prototype.onAfterRendering=function(){var $=this.$(),b;this._setContentHeight();if(this.getExpandable()){b=this.oIconCollapsed.$();if(this.getExpanded()){b.attr("aria-expanded","true");}else{$.children(".sapMPanelExpandablePart").hide();b.attr("aria-expanded","false");}}};a.prototype.exit=function(){if(this.oIconCollapsed){this.oIconCollapsed.destroy();this.oIconCollapsed=null;}};a.prototype._createIcon=function(){var t=this,c=I.getIconURI("navigation-right-arrow");return I.createControlByURI({id:t.getId()+"-CollapsedImg",src:c,decorative:false,useIconTooltip:false,press:function(){t._bInteractiveExpand=true;t.setExpanded(!t.getExpanded());}}).addStyleClass("sapMPanelExpandableIcon");};a.prototype._getIcon=function(){return this.oIconCollapsed;};a.prototype._setContentHeight=function(){var A,t=this.getDomRef(),p=t&&t.querySelector(".sapMPanelContent");if(this.getHeight()==="auto"||!p){return;}A='calc('+this.getHeight()+' - '+p.offsetTop+'px)';p.style.height=A;};a.prototype._toggleExpandCollapse=function(){var o={};if(!this.getExpandAnimation()){o.duration=0;}this.$().children(".sapMPanelExpandablePart").slideToggle(o);};a.prototype._toggleCssClasses=function(){var $=this.$();$.children(".sapMPanelWrappingDiv").toggleClass("sapMPanelWrappingDivExpanded");$.children(".sapMPanelWrappingDivTb").toggleClass("sapMPanelWrappingDivTbExpanded");$.find(".sapMPanelExpandableIcon").first().toggleClass("sapMPanelExpandableIconExpanded");};a.prototype._updateIconAriaLabelledBy=function(){var L,A;if(!this.oIconCollapsed){return;}L=this._getLabellingElementId();A=this.oIconCollapsed.getAriaLabelledBy();if(A.indexOf(L)===-1){this.oIconCollapsed.removeAllAssociation("ariaLabelledBy");this.oIconCollapsed.addAriaLabelledBy(L);}};a.prototype._getLabellingElementId=function(){var h=this.getHeaderToolbar(),i;if(h){i=h.getTitleId();}else{i=this.getId()+"-header";}return i;};return a;});
