/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/base/ManagedObjectObserver','./PlanningCalendarRow','./library','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/DateRange','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Item','jquery.sap.events'],function(q,C,M,P,l,u,a,b,D,c,d,e,f,R,I){"use strict";var g=u.CalendarDayType;var L=l.ListMode;var T=l.ToolbarDesign;var B=l.ButtonType;var h=l.PlanningCalendarBuiltInView;var S=l.ScreenSize;var k=u.CalendarAppointmentVisualization;var G=u.GroupAppointmentsMode;var m=u.CalendarIntervalType;var n=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:m.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:G.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:k.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:false},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:false},builtInViews:{type:"string[]",group:"Appearance",defaultValue:[]}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"},domRefId:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}}}});var o=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],p={};p[m.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:c};p[m.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:d};p[m.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:e};var A=S.Desktop;var K=[h.Hour,h.Day,h.Month,h.Week,h.OneMonth];var r=C.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(i,j){i.write("<div");i.writeControlData(j);i.addClass("sapMPlanCalHead");i.writeClasses();i.write(">");var W=j.getToolbar();if(W){i.renderControl(W);}var X=j.getAllCheckBox();if(X){i.renderControl(X);}i.write("</div>");}});n.prototype.init=function(){this._iBreakPointTablet=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=f.media._predefinedRangeSets[f.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(f.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(f.system.tablet||q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new sap.m.Select(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",_,this);this._oTodayButton=new sap.m.Button(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:B.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new sap.m.Toolbar(i+"-HeaderToolbar",{design:T.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new r(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new sap.m.Toolbar(i+"-InfoToolbar",{height:"auto",design:T.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var j=new sap.m.Table(i+"-Table",{infoToolbar:this._oInfoToolbar,mode:L.SingleSelectMaster,columns:[new sap.m.Column({styleClass:"sapMPlanCalRowHead"}),new sap.m.Column({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:A,demandPopin:true})],ariaLabelledBy:i+"-Descr"});j.attachEvent("selectionChange",x,this);j.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=j.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(W){var X=q(W.currentTarget).control(0),Y=sap.ui.getCore().byId(X.getAssociation("parentRow"));this.fireRowHeaderClick({row:Y});}.bind(this));}},false,this);this.setAggregation("table",j,true);this.setStartDate(new Date());this._resizeProxy=q.proxy(v,this);};n.prototype.exit=function(){if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var i=this.getAggregation("table");i.removeAllItems();o.forEach(function(W){if(this[W]){this[W]._oPlanningCalendar=undefined;this[W].destroy();this[W]=undefined;}},this);if(this._oViews){for(var j in this._oViews){this._oViews[j].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};n.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}F.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();this._bBeforeRendering=undefined;};n.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};n.prototype._dateMatchesVisibleRange=function(i,j){var W=this._getView(j,!this._bBeforeRendering);if(!W){return false;}var X=W.getIntervalType(),Y=p[X],Z=Y?this[Y.sInstanceName]:null,$=false;if(Z&&Z._dateMatchesVisibleRange){$=Z._dateMatchesVisibleRange(i);}return $;};n.prototype.onAfterRendering=function(i){i.size={width:this.getDomRef().offsetWidth};v.call(this,i,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._updateCurrentTimeVisualization(false);};n.prototype.setStartDate=function(i){var j,W;if(!i){i=new Date();}else{a._checkJSDateObject(i);}if(this.getViewKey()===h.Week){j=a.getFirstDateOfWeek(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(j,true).getTime());}if(this.getViewKey()===h.OneMonth){W=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));i.setTime(a._createLocalDate(W,true).getTime());}if(q.sap.equal(i,this.getStartDate())){this._updateTodayButtonState();return this;}var Y=i.getFullYear();a._checkYearInValidRange(Y);var X=this.getMinDate();if(X&&X.getTime()>i.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);i=new Date(X.getTime());}else{var Z=this.getMaxDate();if(Z&&Z.getTime()<i.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(X){i=new Date(X.getTime());}else{i=new Date(1,0,1);i.setFullYear(1);}}}this.setProperty("startDate",i,true);o.forEach(function($){if(this[$]){this[$].setStartDate(new Date(i.getTime()));}},this);this._setRowsStartDate(new Date(i.getTime()));if(this.getViewKey()===h.Week||this.getViewKey()===h.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};n.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}var j=this.getMaxDate();if(i){a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);this.setProperty("minDate",i,true);this._bNoStartDateChange=true;o.forEach(function(Z){if(this[Z]){this[Z].setMinDate(new Date(i.getTime()));}},this);if(j&&j.getTime()<i.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);j=new Date(i.getTime());j.setMonth(j.getMonth()+1,0);j.setHours(23);j.setMinutes(59);j.setSeconds(59);j.setMilliseconds(0);this.setMaxDate(j);}this._bNoStartDateChange=undefined;var W=this.getStartDate();if(W&&W.getTime()<i.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);W=new Date(i.getTime());this.setStartDate(W);}}else{this.setProperty("minDate",undefined,true);o.forEach(function(Z){if(this[Z]){this[Z].setMinDate();}},this);}var X=new Date();if(i&&X.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||X.getTime()<j.getTime()){this._oTodayButton.setVisible(true);}return this;};n.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}var j=this.getMinDate();if(i){a._checkJSDateObject(i);var Y=i.getFullYear();a._checkYearInValidRange(Y);this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;o.forEach(function(Z){if(this[Z]){this[Z].setMaxDate(new Date(i.getTime()));}},this);if(j&&j.getTime()>i.getTime()){q.sap.log.warning("maxDate < minDate -> maxDate set to begin of the month",this);j=new Date(i.getTime());j.setDate(1);j.setHours(0);j.setMinutes(0);j.setSeconds(0);j.setMilliseconds(0);this.setMinDate(j);}this._bNoStartDateChange=undefined;var W=this.getStartDate();if(W&&W.getTime()>i.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(j){W=new Date(j.getTime());}else{W=new Date(1,0,1);W.setFullYear(1);}this.setStartDate(W);}}else{this.setProperty("maxDate",undefined,true);o.forEach(function(Z){if(this[Z]){this[Z].setMaxDate();}},this);}var X=new Date();if(i&&X.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!j||X.getTime()>j.getTime()){this._oTodayButton.setVisible(true);}return this;};n.prototype.setViewKey=function(j){var W,X,Y,Z=this.getViewKey(),$;this.setProperty("viewKey",j,true);this._oIntervalTypeSelect.setSelectedKey(j);if(this._oInfoToolbar.getContent().length>1){this._oInfoToolbar.removeContent(1);}if(j===h.Week||j===h.OneMonth){X=this.getStartDate();this.setStartDate(new Date(X.getTime()));if(X.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var a1=this.getStartDate();var b1=this.getMinDate();var c1=this.getMaxDate();var d1=this._getView(j,!this._bBeforeRendering);if(!d1){this._bCheckView=true;this.invalidate();}else{var e1=d1.getIntervalType();var f1=this._getIntervals(d1);this._bCheckView=false;switch(e1){case m.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(a1.getTime()),items:f1,pickerPopup:true,legend:this.getLegend()});this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(b1){this._oTimeInterval.setMinDate(new Date(b1.getTime()));}if(c1){this._oTimeInterval.setMaxDate(new Date(c1.getTime()));}}else if(this._oTimeInterval.getItems()!=f1){this._oTimeInterval.setItems(f1);}this._oInfoToolbar.addContent(this._oTimeInterval);break;case m.Day:case m.Week:case m.OneMonth:Y=p[e1];W=this[Y.sInstanceName];if(!W){W=new Y.oClass(this.getId()+Y.sIdSuffix,{startDate:new Date(a1.getTime()),days:f1,showDayNamesLine:this.getShowDayNamesLine(),pickerPopup:true,legend:this.getLegend(),showWeekNumbers:this.getShowWeekNumbers()});W.attachEvent("startDateChange",this._handleStartDateChange,this);W.attachEvent("select",this._handleCalendarSelect,this);if(j===h.OneMonth){W._setRowsStartDate=this._setRowsStartDate.bind(this);}W._oPlanningCalendar=this;W.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(b1){W.setMinDate(new Date(b1.getTime()));}if(c1){W.setMaxDate(new Date(c1.getTime()));}}else if(W.getDays()!==f1){W.setDays(f1);}this._oInfoToolbar.addContent(W);this[Y.sInstanceName]=W;break;case m.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(a1.getTime()),months:f1,pickerPopup:true,legend:this.getLegend()});this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(b1){this._oMonthInterval.setMinDate(new Date(b1.getTime()));}if(c1){this._oMonthInterval.setMaxDate(new Date(c1.getTime()));}}else if(this._oMonthInterval.setMonths()!=f1){this._oMonthInterval.setMonths(f1);}this._oInfoToolbar.addContent(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+e1+"; "+this);}var g1=this.getRows();for(var i=0;i<g1.length;i++){var h1=g1[i];var i1=h1.getCalendarRow();i1.setIntervalType(e1);i1.setIntervals(f1);i1.setShowSubIntervals(d1.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);t.call(this,this.getShowWeekNumbers(),this._viewAllowsWeekNumbers(j));}}if(this._oOneMonthInterval&&j===h.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(X));if(this._iSize<2){this._setRowsStartDate(X);}}else if(this._oOneMonthInterval&&Z===h.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){$=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if($){this.setStartDate($);}}this._updateTodayButtonState();return this;};n.prototype._viewAllowsWeekNumbers=function(i){var j=this._getView(i).getIntervalType(),W=p[j];return!!W&&!!W.oClass.prototype.setShowWeekNumbers;};n.prototype._getIntervalInstanceByViewKey=function(i){var j=this._getView(i).getIntervalType(),W=p[j],X;if(W){X=this[W.sInstanceName];}return X;};n.prototype.setShowWeekNumbers=function(i){this.setProperty("showWeekNumbers",i,true);this._getViews().forEach(function(j){var W=j.getKey(),X=this._viewAllowsWeekNumbers(W),Y=this._getIntervalInstanceByViewKey(W);if(Y&&X){this._getIntervalInstanceByViewKey(W).setShowWeekNumbers(i);}if(this.getDomRef()&&this.getViewKey()===W){t.call(this,i,X);}},this);return this;};n.prototype.setShowIntervalHeaders=function(j){this.setProperty("showIntervalHeaders",j,true);var W=this.getRows();for(var i=0;i<W.length;i++){var X=W[i];X.getCalendarRow().setShowIntervalHeaders(j);}return this;};n.prototype.setShowEmptyIntervalHeaders=function(j){this.setProperty("showEmptyIntervalHeaders",j,true);var W=this.getRows();for(var i=0;i<W.length;i++){var X=W[i];X.getCalendarRow().setShowEmptyIntervalHeaders(j);}return this;};n.prototype.setGroupAppointmentsMode=function(j){this.setProperty("groupAppointmentsMode",j,true);var W=this.getRows();for(var i=0;i<W.length;i++){var X=W[i];X.getCalendarRow().setGroupAppointmentsMode(j);}return this;};n.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var W=this.getRows();for(var i=0;i<W.length;i++){var X=W[i];X.getCalendarRow().setAppointmentsReducedHeight(j);}return this;};n.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var W=this.getRows();for(var i=0;i<W.length;i++){var X=W[i];X.getCalendarRow().setAppointmentsVisualization(j);}return this;};n.prototype.setShowRowHeaders=function(i){this.setProperty("showRowHeaders",i,true);var j=this.getAggregation("table");j.getColumns()[0].setVisible(i);this._toggleAppointmentsColumnPopinState(i);this.$().toggleClass("sapMPlanCalNoHead",!i);O.call(this);U.call(this);return this;};n.prototype.setShowDayNamesLine=function(i){var j,W,X;for(j in p){W=p[j].sInstanceName;if(this[W]){X=this[W];X.setShowDayNamesLine(i);}}return this.setProperty("showDayNamesLine",i,false);};n.prototype.addRow=function(i){this.addAggregation("rows",i,true);i.attachEvent("_change",Q,this);var j=this.getAggregation("table");j.addItem(i.getColumnListItem());var W=i.getCalendarRow();W.setStartDate(this.getStartDate());W.setShowIntervalHeaders(this.getShowIntervalHeaders());W.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());W.setGroupAppointmentsMode(this.getGroupAppointmentsMode());W.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());W.setLegend(this.getLegend());W.setAppointmentsVisualization(this.getAppointmentsVisualization());W.attachEvent("select",w,this);W.attachEvent("startDateChange",this._handleStartDateChange,this);W.attachEvent("leaveRow",J,this);W.attachEvent("intervalSelect",s,this);N.call(this);if(V.call(this)){var X=this.getViewKey();var Y=this._getView(X);var Z=Y.getIntervalType();var $=this._getIntervals(Y);W.setIntervalType(Z);W.setIntervals($);W.setShowSubIntervals(Y.getShowSubIntervals());}U.call(this);return this;};n.prototype.insertRow=function(i,j){this.insertAggregation("rows",i,j);i.attachEvent("_change",Q,this);var W=this.getAggregation("table");W.insertItem(i.getColumnListItem(),j,true);var X=i.getCalendarRow();X.setStartDate(this.getStartDate());X.setShowIntervalHeaders(this.getShowIntervalHeaders());X.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());X.setGroupAppointmentsMode(this.getGroupAppointmentsMode());X.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());X.setLegend(this.getLegend());X.setAppointmentsVisualization(this.getAppointmentsVisualization());X.attachEvent("select",w,this);X.attachEvent("startDateChange",this._handleStartDateChange,this);X.attachEvent("leaveRow",J,this);X.attachEvent("intervalSelect",s,this);N.call(this);if(V.call(this)){var Y=this.getViewKey();var Z=this._getView(Y);var $=Z.getIntervalType();var a1=this._getIntervals(Z);X.setIntervalType($);X.setIntervals(a1);X.setShowSubIntervals(Z.getShowSubIntervals());}U.call(this);return this;};n.prototype.removeRow=function(i){var j=this.removeAggregation("rows",i,true);j.detachEvent("_change",Q,this);var W=this.getAggregation("table");W.removeItem(j.getColumnListItem(),true);var X=j.getCalendarRow();X.detachEvent("select",w,this);X.detachEvent("startDateChange",this._handleStartDateChange,this);X.detachEvent("leaveRow",J,this);X.detachEvent("intervalSelect",s,this);N.call(this);U.call(this);return j;};n.prototype.removeAllRows=function(){var j=this.removeAllAggregation("rows",true);var W=this.getAggregation("table");W.removeAllItems(true);for(var i=0;i<j.length;i++){var X=j[i];X.detachEvent("_change",Q,this);var Y=X.getCalendarRow();Y.detachEvent("select",w,this);Y.detachEvent("startDateChange",this._handleStartDateChange,this);Y.detachEvent("leaveRow",J,this);Y.detachEvent("intervalSelect",s,this);}N.call(this);U.call(this);return j;};n.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var j=this.getAggregation("table");j.destroyItems(true);N.call(this);U.call(this);return i;};n.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);y.call(this);return this;};n.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);y.call(this);return this;};n.prototype.removeToolbarContent=function(i){var j=this.removeAggregation("toolbarContent",i,true);y.call(this);return j;};n.prototype.removeAllToolbarContent=function(){var i=this.removeAllAggregation("toolbarContent",true);y.call(this);return i;};n.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);y.call(this);return i;};n.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};n.prototype.setSingleSelection=function(i){this.setProperty("singleSelection",i,true);O.call(this);U.call(this);if(i){this.selectAllRows(false);}else{N.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!i);return this;};n.prototype.setNoDataText=function(i){this.setProperty("noDataText",i,true);var j=this.getAggregation("table");j.setNoDataText(i);return this;};n.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var W=this.getRows(),X=this.getLegend()&&sap.ui.getCore().byId(this.getLegend()),Y;for(var i=0;i<W.length;i++){var Z=W[i];Z.getCalendarRow().setLegend(j);}o.forEach(function($){if(this[$]){this[$].setLegend(j);}},this);if(X){Y=new M(function($){this.invalidate();}.bind(this));Y.observe(X,{destroy:true});}return this;};n.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.addAriaLabelledBy(i);return this;};n.prototype.removeAriaLabelledBy=function(i){this.removeAssociation("ariaLabelledBy",i,true);var j=this.getAggregation("table");j.removeAriaLabelledBy(i);return this;};n.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var i=this.getAggregation("table");i.removeAllAriaLabelledBy();i.addAriaLabelledBy(this.getId()+"-Descr");return this;};n.prototype.invalidate=function(i){var j=i&&i instanceof D;if(!this._bIsBeingDestroyed&&(this._bDateRangeChanged||j)){if(this.getDomRef()){var W=this.getViewKey();var X=this._getView(W);var Y=X.getIntervalType();switch(Y){case m.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case m.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case m.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case m.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case m.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+Y+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(i&&i instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};n.prototype.addSpecialDate=function(i){this._bDateRangeChanged=true;if(i.getType()===g.NonWorking){this.getAggregation("rows").forEach(function(j){j.addAggregation("_nonWorkingDates",this._buildPCRowDateRange(i));},this);}return C.prototype.addAggregation.call(this,"specialDates",i);};n.prototype.insertSpecialDate=function(i,j){this._bDateRangeChanged=true;if(i.getType()===g.NonWorking){this.getAggregation("rows").forEach(function(W){W.insertAggregation("_nonWorkingDates",this._buildPCRowDateRange(i),j);},this);}return C.prototype.insertAggregation.call(this,"specialDates",i,j);};n.prototype.removeSpecialDate=function(i){var j;if(typeof i==="string"){i=sap.ui.getCore().byId(i);}this._bDateRangeChanged=true;if(i&&i.getType()===g.NonWorking){this.getAggregation("rows").forEach(function(W){if(W.getAggregation("_nonWorkingDates")){j=W.getAggregation("_nonWorkingDates").filter(function(X){return X.data(P.PC_FOREIGN_KEY_NAME)===i.getId();});if(j.length){W.removeAggregation("_nonWorkingDates",j[0]);}}});}return C.prototype.removeAggregation.call(this,"specialDates",i);};n.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;if(this.getAggregation("rows")){this.getAggregation("rows").forEach(function(i){i.removeAllAggregation("_nonWorkingDates");});}return this.removeAllAggregation("specialDates");};n.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;this.getAggregation("rows").forEach(function(i){i.destroyAggregation("_nonWorkingDates");});return this.destroyAggregation("specialDates");};n.prototype.removeAllViews=function(){this._bCheckView=true;var i=this.removeAllAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(K[0]);}return i;};n.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views"),j=this.getBuiltInViews();if(j.length){this.setViewKey(j[0]);}else{this.setViewKey(K[0]);}return i;};n.prototype.getSelectedRows=function(){return this.getRows().filter(function(i){return i.getSelected();});};n.prototype.selectAllRows=function(j){var W=this.getRows();if(!(j&&this.getSingleSelection())){for(var i=0;i<W.length;i++){var X=W[i];X.setSelected(j);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(j);}}return this;};n.prototype.onsaphomemodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var W=j[0];var X=new q.Event("saphome");X._bPlanningCalendar=true;W.getCalendarRow().onsaphome(X);i.preventDefault();i.stopPropagation();}};n.prototype.onsapendmodifiers=function(i){if((i.metaKey||i.ctrlKey)&&!i.altKey&&!i.shiftKey){var j=this.getRows();var W=j[j.length-1];var X=new q.Event("sapend");X._bPlanningCalendar=true;W.getCalendarRow().onsapend(X);i.preventDefault();i.stopPropagation();}};n.prototype.setBuiltInViews=function(i){this.setProperty("builtInViews",i);this.setViewKey(this._getViews()[0].getKey());return this;};n.prototype.removeView=function(i){var j=this.removeAggregation("views",i);if(!this.getViews().length){this.setViewKey(this._getViews()[0].getKey());}return j;};n.prototype._getIntervals=function(i){var j=0;switch(this._iSize){case 0:j=i.getIntervalsS();break;case 1:j=i.getIntervalsM();break;default:j=i.getIntervalsL();break;}return j;};n.prototype._getView=function(j,W){var X=this._getViews();var Y;for(var i=0;i<X.length;i++){Y=X[i];if(Y.getKey()!=j){Y=undefined;}else{break;}}if(!Y&&!W){throw new Error("PlanningCalendarView with key "+j+"not assigned "+this);}return Y;};n.prototype._changeStartDate=function(i){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(i.getTime()));this.fireStartDateChange();};n.prototype._updateCurrentTimeVisualization=function(j){if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(j){var W=this.getRows();for(var i=0;i<W.length;i++){var X=W[i];X.getCalendarRow().updateCurrentTimeVisualization();}}var Y=new Date();var Z=this.getStartDate();var $=this.getViewKey();var a1=this._getView($);var b1=a1.getIntervalType();var c1=this._getIntervals(a1);var d1=0;var e1=0;var f1=0;switch(b1){case m.Hour:d1=60000;e1=Z.getTime()-3600000;f1=Z.getTime()+c1*3600000;break;case m.Day:case m.Week:case m.OneMonth:d1=1800000;e1=Z.getTime()-3600000;f1=Z.getTime()+c1*86400000;break;default:d1=-1;break;}if(Y.getTime()<=f1&&Y.getTime()>=e1&&d1>0){this._sUpdateCurrentTime=q.sap.delayedCall(d1,this,'_updateCurrentTimeVisualization',[true]);}};function _(i){this.setViewKey(i.getParameter("selectedItem").getKey());this.fireViewChange();}n.prototype._handleTodayPress=function(i){var j=new Date(),W,X=this.getViewKey();if(X===h.OneMonth){W=a.getFirstDateOfMonth(a._createUniversalUTCDate(j,undefined,true));this._oOneMonthInterval._adjustSelectedDate(b.fromLocalJSDate(j),false);j=a._createLocalDate(W,true);}if(X===h.Week){W=this.getStartDate();j.setHours(W.getHours());j.setMinutes(W.getMinutes());j.setSeconds(W.getSeconds());}this.setStartDate(j);this.fireStartDateChange();};n.prototype._handleStartDateChange=function(i){var j=i.oSource.getStartDate();this._changeStartDate(j);};n.prototype._handleCalendarSelect=function(i){var j=i.oSource.getSelectedDates();var W=new Date(j[0].getStartDate());var X=a._createUniversalUTCDate(W,undefined,true);var Y=this.getViewKey();var Z=this._getView(Y);var $=Z.getIntervalType();if($!==m.OneMonth||this._iSize>1){j[0].setStartDate();}switch($){case m.Hour:X.setUTCHours(X.getUTCHours()+1);break;case m.Day:case m.Week:X.setUTCDate(X.getUTCDate()+1);break;case m.OneMonth:if(this._iSize<2){var a1=new Date(W.getTime());if(a.monthsDiffer(this.getStartDate(),W)){this.setStartDate(W);}this._setRowsStartDate(a1);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(b.fromLocalJSDate(a1),true);}else if(a._isNextMonth(W,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}X.setUTCDate(X.getUTCDate()+1);break;case m.Month:X.setUTCMonth(X.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+$+"; "+this);}X.setUTCMilliseconds(X.getUTCMilliseconds()-1);X=a._createLocalDate(X,true);this.fireIntervalSelect({startDate:W,endDate:X,subInterval:false,row:undefined});};n.prototype._buildPCRowDateRange=function(i){var j=new D();if(i.getStartDate()){j.setStartDate(new Date(i.getStartDate().getTime()));}if(i.getEndDate()){j.setEndDate(new Date(i.getEndDate().getTime()));}j.data(P.PC_FOREIGN_KEY_NAME,i.getId());return j;};function s(i){var j=i.getParameter("startDate");var W=this.getViewKey();var X=this._getView(W);var Y=X.getIntervalType();if(Y===m.OneMonth&&a._isNextMonth(j,this.getStartDate())){this._oOneMonthInterval._handleNext();return;}var Z=i.getParameter("endDate");var $=i.getParameter("subInterval");var a1=i.oSource._oPlanningCalendarRow;this.fireIntervalSelect({startDate:j,endDate:Z,subInterval:$,row:a1});}n.prototype._applyContextualSettings=function(){return C.prototype._applyContextualSettings.call(this,{contextualWidth:this.$().width()});};function t(i,j){this.$().toggleClass("sapMPlanCalWithWeekNumbers",i&&j);}function v(j,W){this._applyContextualSettings();if(j.size.width<=0){return;}var X=this.getRows();var Y;var i=0;var Z=this._iSize;z.call(this,j.size.width);if(Z!=this._iSize){E.call(this,this._iSize);var $=this.getViewKey();var a1=this._getView($);var b1=a1.getIntervalType();var c1=this._getIntervals(a1);for(i=0;i<X.length;i++){Y=X[i];var d1=Y.getCalendarRow();if(c1!=d1.getIntervals()){d1.setIntervals(c1);}else{d1.handleResize();}}switch(b1){case m.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=c1){this._oTimeInterval.setItems(c1);}break;case m.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=c1){this._oDateInterval.setDays(c1);}break;case m.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=c1){this._oMonthInterval.setMonths(c1);}break;case m.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=c1){this._oWeekInterval.setDays(c1);}break;case m.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=c1){this._oOneMonthInterval.setDays(c1);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+b1+"; "+this);}O.call(this);}else if(!W){for(i=0;i<X.length;i++){Y=X[i];Y.getCalendarRow().handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}}function w(W){var X=W.getParameter("appointment"),Y=W.getParameter("multiSelect"),Z=W.getParameter("appointments"),$=W.getParameter("domRefId"),a1,b1,c1,d1,e1,f1,i,j;if(!Y){b1=this.getRows();for(i=0;i<b1.length;i++){c1=b1[i];d1=c1.getCalendarRow();if(W.oSource!=d1){e1=c1.getAppointments();for(j=0;j<e1.length;j++){f1=e1[j];f1.setSelected(false);}}}}a1={appointment:X,appointments:Z,multiSelect:Y,domRefId:$};this.fireAppointmentSelect(a1);}n.prototype._setRowsStartDate=function(j){var W=this.getRows(),X,i;for(i=0;i<W.length;i++){X=W[i];X.getCalendarRow().setStartDate(j);}};n.prototype._toggleAppointmentsColumnPopinState=function(i){var j=this.getAggregation("table"),W=j.getColumns()[1];W.setDemandPopin(i);W.setMinScreenWidth(i?A:"");};n.prototype._getViews=function(){var i=this.getViews(),j=this.getBuiltInViews(),W,X=[],Y=h,Z=m;if(!this._oViews){this._oViews={};}if(j.length){X=j;}else{X=i.length?[]:K;}W=X.map(function(a1){switch(a1){case Y.Hour:return this._oViews[Y.Hour]||(this._oViews[Y.Hour]=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:Y.Hour,intervalType:Z.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12}));case Y.Day:return this._oViews[Y.Day]||(this._oViews[Y.Day]=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:Y.Day,intervalType:Z.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14}));case Y.Month:return this._oViews[Y.Month]||(this._oViews[Y.Month]=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:Y.Month,intervalType:Z.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12}));case Y.Week:return this._oViews[Y.Week]||(this._oViews[Y.Week]=new sap.m.PlanningCalendarView(this.getId()+"-WeekView",{key:Y.Week,intervalType:Z.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7}));case Y.OneMonth:return this._oViews[Y.OneMonth]||(this._oViews[Y.OneMonth]=new sap.m.PlanningCalendarView(this.getId()+"-OneMonthView",{key:Y.OneMonth,intervalType:Z.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31}));default:q.sap.log.error("Cannot get PlanningCalendar views. Invalid view key "+a1);break;}},this);for(var $ in this._oViews){if(X.indexOf($)<0){this._oViews[$].destroy();delete this._oViews[$];}}if(i.length){W=W.concat(i);}return W;};function x(j){var W=[];var X=this.getRows();for(var i=0;i<X.length;i++){var Y=X[i];var Z=Y.getColumnListItem();var $=Z.getSelected();if(Y.getSelected()!=$){Y.setProperty("selected",$,true);W.push(Y);}}if(!this.getSingleSelection()){N.call(this);}if(W.length>0){this.fireRowSelectionChange({rows:W});}}function y(){var i=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:T.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!i.getHeaderToolbar()){i.setHeaderToolbar(this._oToolbar);}}else if(i.getHeaderToolbar()){i.setHeaderToolbar();}this._oToolbar.invalidate();}function z(W){if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(q('html').hasClass("sapUiMedia-Std-Phone")){this._iSizeScreen=0;}else if(q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function E(j){var W='sapMSize'+j,X=this.$(),i,Y;if(X){for(i=0;i<3;i++){Y='sapMSize'+i;if(Y===W){X.addClass(Y);}else{X.removeClass(Y);}}}}function F(){var j=this._getViews();this._oIntervalTypeSelect.destroyItems();var i;var W;for(i=0;i<j.length;i++){var X=j[i];W=new I(this.getId()+"-"+i,{key:X.getKey(),text:X.getDescription(),tooltip:X.getTooltip()});this._oIntervalTypeSelect.addItem(W);}this._oIntervalTypeSelect.setVisible(!(j.length===1));}function H(i){var j=i.getParameter("selected");var W=this.getRows();if(j){W=this.getRows().filter(function(X){return!X.getSelected();});}this.selectAllRows(j);this.fireRowSelectionChange({rows:W});}function J(j){var W=j.oSource;var X=j.getParameter("type");var Y=this.getRows();var Z;var $;var a1;var b1;var i=0;var c1=0;var d1;for(i=0;i<Y.length;i++){Z=Y[i];if(Z.getCalendarRow()==W){c1=i;break;}}switch(X){case"sapup":a1=W.getFocusedAppointment();b1=a1.getStartDate();if(c1>0){c1--;}$=Y[c1];$.getCalendarRow().focusNearestAppointment(b1);break;case"sapdown":a1=W.getFocusedAppointment();b1=a1.getStartDate();if(c1<Y.length-1){c1++;}$=Y[c1];$.getCalendarRow().focusNearestAppointment(b1);break;case"saphome":if(c1>0){$=Y[0];d1=new q.Event(X);d1._bPlanningCalendar=true;$.getCalendarRow().onsaphome(d1);}break;case"sapend":if(c1<Y.length-1){$=Y[Y.length-1];d1=new q.Event(X);d1._bPlanningCalendar=true;$.getCalendarRow().onsapend(d1);}break;default:break;}}function N(){if(this._oSelectAllCheckBox){var i=this.getRows();var j=this.getSelectedRows();if(i.length==j.length&&j.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function O(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",H,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function Q(i){if(i.getParameter("name")=="selected"){N.call(this);}}function U(){var i=this.getAggregation("table");var j=i.getMode();var W;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){W=L.None;}else{W=L.SingleSelectMaster;}}else{W=L.MultiSelect;}if(j!=W){i.setMode(W);}}function V(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return n;});
