/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./TimePickerSlidersRenderer','./TimePickerSlider','./VisibleItem','sap/ui/core/LocaleData','sap/ui/Device','sap/ui/core/Locale'],function(q,C,S,T,V,L,D,a){"use strict";var b=C.extend("sap.m.TimePickerSliders",{metadata:{library:"sap.m",properties:{format:{name:"format",type:"string"},labelText:{name:"labelText",type:"string"},minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1}},aggregations:{_columns:{type:"sap.m.TimePickerSlider",multiple:true,visibility:"hidden"}},associations:{invokedBy:{type:"sap.m.TimePicker",multiple:false}}},renderer:S.render});b.prototype.init=function(){var l=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),p=L.getInstance(l).getDayPeriods("abbreviated");this._fnLayoutChanged=q.proxy(this._onOrientationChanged,this);D.resize.attachHandler(this._fnLayoutChanged);this._sAM=p[0];this._sPM=p[1];};b.prototype.exit=function(){this.$().off(!!D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);D.resize.detachHandler(this._fnOrientationChanged);};b.prototype.onAfterRendering=function(){this.$().off(!!D.browser.firefox?"DOMMouseScroll":"mousewheel",this._onmousewheel);this.$().on(!!D.browser.firefox?"DOMMouseScroll":"mousewheel",q.proxy(this._onmousewheel,this));if(!D.browser.msie){this._initFocus(true);}};b.prototype.setInvokedBy=function(i){var l,p,c;this.setAssociation("invokedBy",i);if(sap.ui.getCore().byId(i)){l=new a(sap.ui.getCore().byId(i).getLocaleId());p=L.getInstance(l).getDayPeriods("abbreviated");this._sAM=p[0];this._sPM=p[1];c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(this.getFormat());}return this;};b.prototype.setLabelText=function(l){var c;this.setProperty("labelText",l,true);if(!D.system.desktop){c=q(this.getDomRef("label"));if(c){c.html(l);}}return this;};b.prototype.setFormat=function(f){this.setProperty("format",f,true);var c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(f);return this;};b.prototype.setMinutesStep=function(v){this.setProperty("minutesStep",v,true);var c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(this.getFormat());return this;};b.prototype.setSecondsStep=function(v){this.setProperty("secondsStep",v,true);var c=this.getAggregation("_columns");if(c){this.destroyAggregation("_columns");}this._setupLists(this.getFormat());return this;};b.prototype.getTimeValues=function(){var c=sap.ui.getCore(),l=c.byId(this.getId()+"-listHours"),o=c.byId(this.getId()+"-listMins"),d=c.byId(this.getId()+"-listSecs"),e=c.byId(this.getId()+"-listFormat"),h=null,A=null,f=new Date();if(l){h=parseInt(l.getSelectedValue(),10);}if(e){A=e.getSelectedValue();}if(A==="am"&&h===12){h=0;}else if(A==="pm"&&h!==12){h+=12;}if(h!==null){f.setHours(h.toString());}if(o){f.setMinutes(o.getSelectedValue());}if(d){f.setSeconds(d.getSelectedValue());}return f;};b.prototype.setTimeValues=function(d){var c=sap.ui.getCore(),l=c.byId(this.getId()+"-listHours"),o=c.byId(this.getId()+"-listMins"),e=c.byId(this.getId()+"-listSecs"),f=c.byId(this.getId()+"-listFormat"),h,A=null;d=d||new Date();h=d.getHours();if(f){A=h>=12?"pm":"am";h=(h>12)?h-12:h;h=(h===0?12:h);}l&&l.setSelectedValue(h.toString());o&&o._updateStepAndValue(d.getMinutes(),this.getMinutesStep());e&&e._updateStepAndValue(d.getSeconds(),this.getSecondsStep());f&&f.setSelectedValue(A);};b.prototype.collapseAll=function(){var s=this.getAggregation("_columns");if(s){for(var i=0;i<s.length;i++){if(s[i].getIsExpanded()){s[i].setIsExpanded(false);}}}};b.prototype.updateSlidersValues=function(){var s=this.getAggregation("_columns");if(s){for(var i=0;i<s.length;i++){s[i]._updateScroll();}}};b.prototype.onsaphome=function(e){var c=this._getCurrentSlider();if(c&&document.activeElement===c.getDomRef()){this.getAggregation("_columns")[0].focus();}};b.prototype.onsapend=function(e){var c=this._getCurrentSlider();if(c&&document.activeElement===c.getDomRef()){var s=this.getAggregation("_columns");s[s.length-1].focus();}};b.prototype.onsapleft=function(e){var c=this._getCurrentSlider(),i=-1,n=-1,s=this.getAggregation("_columns");if(c&&document.activeElement===c.getDomRef()){i=s.indexOf(c);n=i>0?i-1:s.length-1;s[n].focus();}};b.prototype.onsapright=function(e){var c=this._getCurrentSlider(),i=-1,n=-1,s=this.getAggregation("_columns");if(c&&document.activeElement===c.getDomRef()){i=s.indexOf(c);n=i<s.length-1?i+1:0;s[n].focus();}};b.prototype._onmousewheel=function(e){var c=this._getCurrentSlider();if(c){c._onmousewheel(e);}};b.prototype._onOrientationChanged=function(){var s=this.getAggregation("_columns");if(!s){return;}for(var i=0;i<s.length;i++){if(s[i].getIsExpanded()){s[i]._updateSelectionFrameLayout();}}};b.prototype._initFocus=function(s){if(D.system.desktop&&!s){this.getAggregation("_columns")[0].focus();}else{this.getAggregation("_columns")[0].setIsExpanded(true);}};b.prototype._generatePickerListValues=function(f,t,s,l){var v=[],c;for(var i=f;i<=t;i+=1){if(i<10&&l){c="0"+i.toString();}else{c=i.toString();}var I=new V({key:i.toString(),text:c});if(i%s!==0){I.setVisible(false);}v.push(I);}return v;};b.prototype._setupLists=function(f){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),l=r.getText("TIMEPICKER_LBL_HOURS"),s=r.getText("TIMEPICKER_LBL_MINUTES"),c=r.getText("TIMEPICKER_LBL_SECONDS"),d=r.getText("TIMEPICKER_LBL_AMPM"),m=this.getMinutesStep(),e=this.getSecondsStep();if(f===undefined){return;}var h=false,H=false,F,t;if(f.indexOf("HH")!==-1){h=true;F=0;t=23;H=true;}else if(f.indexOf("H")!==-1){h=true;F=0;t=23;}else if(f.indexOf("hh")!==-1){h=true;F=1;t=12;H=true;}else if(f.indexOf("h")!==-1){h=true;F=1;t=12;}if(h){this.addAggregation("_columns",new T(this.getId()+"-listHours",{items:this._generatePickerListValues(F,t,1,H),expanded:q.proxy(o,this),label:l}));}if(f.indexOf("m")!==-1){var v=this._generatePickerListValues(0,59,m,true);this.addAggregation("_columns",new T(this.getId()+"-listMins",{items:v,expanded:q.proxy(o,this),label:s}));}if(f.indexOf("s")!==-1){var v=this._generatePickerListValues(0,59,e,true);this.addAggregation("_columns",new T(this.getId()+"-listSecs",{items:v,expanded:q.proxy(o,this),label:c}));}if(f.indexOf("a")!==-1){this.addAggregation("_columns",new T(this.getId()+"-listFormat",{items:[{key:"am",text:this._sAM},{key:"pm",text:this._sPM}],expanded:q.proxy(o,this),label:d,isCyclic:false}).addStyleClass("sapMTimePickerSliderShort"));}this.getAggregation("_columns")[0].setIsExpanded(true);function o(E){var g=this.getAggregation("_columns");for(var i=0;i<g.length;i++){if(g[i]!==E.oSource&&g[i].getIsExpanded()){g[i].setIsExpanded(false);}}}};b.prototype._getCurrentSlider=function(){var s=this.getAggregation("_columns");if(s){for(var i=0;i<s.length;i++){if(s[i].getIsExpanded()){return s[i];}}}return null;};return b;});
