/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./library","sap/ui/core/Control","sap/ui/core/IconPool","./SegmentedButton","./Page","./NavContainer","./ViewSettingsItem","sap/ui/base/ManagedObject","sap/ui/Device","sap/ui/core/InvisibleText"],function(q,R,B,T,a,b,L,S,l,C,I,c,P,N,V,M,D,d){"use strict";var e=l.VerticalPlacementType;var f=l.ListType;var g=l.ListMode;var h='-toolbar';var k='-segmented';var m='-listitem';var n='-group';var o='-filter';var p='-sort';var F='-filterdetailItem';var r='-navContainer';var s='-mainPage';var t='-detailspage';var u='-backbutton';var v='-title';var w='-searchfield';var x='-selectall';var y='-custom-button';var z=C.extend("sap.m.ViewSettingsPopover",{metadata:{library:"sap.m",aggregations:{sortItems:{type:"sap.ui.core.Item",multiple:true,singularName:"sortItem"},filterItems:{type:"sap.ui.core.Item",multiple:true,singularName:"filterItem"},filterDetailItems:{type:"sap.ui.core.Item",multiple:true,singularName:"filterDetailItem"},groupItems:{type:"sap.ui.core.Item",multiple:true,singularName:"groupItem"},customTabs:{type:"sap.m.ViewSettingsCustomTab",multiple:true,singularName:"customTab",bindable:"bindable"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},sortSelected:{allowPreventDefault:true,parameters:{items:{type:"array"}}},filterSelected:{allowPreventDefault:true,parameters:{items:{type:"array"}}},groupSelected:{allowPreventDefault:true,parameters:{items:{type:"array"}}},afterFilterDetailPageOpened:{parameters:{parentFilterItem:{type:"sap.m.ViewSettingsFilterItem"}}}}},constructor:function(i,j){this._stashedItems={};if(!j&&i&&typeof i==='object'){j=i;}this._stashItems(j);if(j&&Array.isArray(j['sortItems'])){j['sortItems']=null;}if(j&&Array.isArray(j['filterItems'])){j['filterItems']=null;}if(j&&Array.isArray(j['groupItems'])){j['groupItems']=null;}M.prototype.constructor.apply(this,arguments);this._getPopover().addContent(this._getNavContainer());this._addStashedItems();}});z.prototype.init=function(){this._tabMap={sort:'sort',filter:'filter',filterDetail:'filterDetail',group:'group'};};z.prototype.openBy=function(i){var j=this._getPopover(i),E=this._determinePageToOpen();j.openBy(i);if(E){if(D.system.phone){this._showContentFor(E);}else{this._removeSegmentedButtonSelection();this._adjustInitialWidth();}}this._initialHeight=this._getPopover().getContentHeight();if(this._getSegmentedButton().getItems()&&this._getSegmentedButton().getItems().length===1&&E){this._showContentFor(E);}if(j.getAriaLabelledBy()&&j.getAriaLabelledBy().indexOf(this._getPopoverAriaLabel())===-1){j.addAriaLabelledBy(this._getPopoverAriaLabel());}};z.prototype._removeSegmentedButtonSelection=function(){this._getSegmentedButton().setProperty('selectedKey','',true).removeAllAssociation('selectedButton',true);this._getSegmentedButton().setAssociation("selectedButton","no_selected_button",true);this._getSegmentedButton().getButtons().forEach(function(i){i.$().removeClass("sapMSegBBtnSel").attr("aria-checked",false);});};z.prototype.toggle=function(i){if(this.isOpen()){this.close();}else{this.openBy(i);}return this;};z.prototype.isOpen=function(){return this._getPopover().isOpen();};z.prototype.close=function(){this._getPopover().close();this._cleanAfterClose();return this;};z.prototype._determinePageToOpen=function(){var i,j,E,G,H,J,K,O,Q=this.getCustomTabs();for(E in this._tabMap){G=this._tabMap[E];G=G.slice(0,1).toUpperCase()+G.slice(1);H=this['_get'+G+'List']().getItems();if(H.length===1){return;}else if(H.length>1){return this._tabMap[E];}}if(Q){J=this._getSegmentedButton().getItems();for(i=0;i<Q.length;i++){K=Q[i];O=this.getId()+K.getId()+y;if(!this._isEmptyCustomTab(K)){for(j=0;j<J.length;j++){if(O===J[j].getId()){return K.getId();}}}}}return this._tabMap['sort'];};z.prototype._removeFooter=function(){if(this._getPopover()._oFooter){this._getPopover()._oFooter.destroy();this._getPopover()._oFooter=null;}this._getPopover().destroyAggregation('beginButton');this._getPopover().destroyAggregation('endButton');};z.prototype._showContentFor=function(i,j,E){var G=sap.ui.getCore().byId(this._getPopoverAriaLabel()),H;this._getPopover().setContentHeight('300px');this._getPopover().setContentWidth('300px');this._removePageContents(i);this._addPageContents(i);if(i===this._tabMap['filterDetail']){H=this._getText('VIEWSETTINGS_TITLE_FILTERBY')+this._updateTitleText(j.getTitle(),true);this._goToDetailsPage(j,E);}else{if(i in this._tabMap){H=this._updateTitleText(i);if(i===this._tabMap['filter']){this._updateFilterListItemsCount();}}this._goToMainPage();}G.setText(H);this._getSegmentedButton().setSelectedKey(i);this._currentPageId=i;};z.prototype._updateTitleText=function(i,j){var E,G=i;if(!j){E=i;if(E=='filterDetail'){E='filter';}E="VIEWSETTINGS_TITLE_"+E.toUpperCase();G=this._getText(E);}if(j&&this._getDetailsPage().getHeaderContent()[0].getContentMiddle()){this._getDetailsPage().getHeaderContent()[0].getContentMiddle()[0].setText(G);}else{this._getTitle().setText(G);}return G;};z.prototype._goToDetailsPage=function(i,j){var E=this._findViewSettingsItemFromListItem(i).getMultiSelect();if(E){this._getSearchField().setValue('');this._getDetailsPage().insertAggregation('content',new T({content:[this._getSearchField().addStyleClass('sapMVSDFilterSearchField'),this._getShowSelectedOnlyButton()]}),0);this._getFilterDetailList().setHeaderToolbar(new T({content:[this._getSelectAllCheckbox(this._findViewSettingsItemFromListItem(i).getItems(),this._getFilterDetailList())]}).addStyleClass('sapMVSDFilterHeaderToolbar'));}else{this._getFilterDetailList().removeAllAggregation('headerToolbar');}this._updateFilterDetailListFor(i);this._navigateToPage('Details',j);this._addFooterButtons();this._updateSelectAllCheckBoxState();if(D.system.phone){this._hideToolbarButtons();}this._lastViewedFilterParent=i;this._oPreviousSelectedFilters={selectedItemIds:this._getFilterDetailList().getSelectedItems().map(function(G){return G.getId();})};this.fireAfterFilterDetailPageOpened({parentFilterItem:i});};z.prototype._getShowSelectedOnlyButton=function(){var i=false;if(!this._oShowSelectedOnlyButton){this._oShowSelectedOnlyButton=new B({icon:I.getIconURI("multiselect-all"),tooltip:this._getText('SHOW_SELECTED_ONLY'),press:function(E){i=!i;if(i){E.getSource().$("inner").addClass('sapMBtnActive');}this._getFilterDetailList().getItems().forEach(function(j){if(i){if(!j.getSelected()){j.setVisible(false);}}else if(!i){this._filterItemsBy(this._getSearchField().getValue());}},this);this._updateSelectAllCheckBoxState();}.bind(this)});}return this._oShowSelectedOnlyButton;};z.prototype._updateSelectAllCheckBoxState=function(){var j=sap.ui.getCore().byId(this.getId()+x),E=this._getFilterDetailList().getItems()||[],G=true,H=0,i;for(i=0;i<E.length;i++){if(E[i].getVisible()){H++;if(!E[i].getSelected()){G=false;}}}if(j){j.setSelected(G&&H);}};z.prototype._addFooterButtons=function(){var i=new B({text:this._getText("VIEWSETTINGS_ACCEPT"),press:this._confirmFilterDetail.bind(this)}),j=new B({text:this._getText("VIEWSETTINGS_CANCEL"),press:this._cancel.bind(this)});this._getPopover().setBeginButton(i);this._getPopover().setEndButton(j);};z.prototype._confirmFilterDetail=function(){var i=this._getFilterDetailList().getItems().filter(function(j){return j.getSelected();});this.fireFilterSelected({items:i.map(function(j){return this._findViewSettingsItemFromListItem(j);}.bind(this))});this.close();};z.prototype._cancel=function(){this._restorePreviousState();this._updateFilterListItemsCount();this.close();};z.prototype._restorePreviousState=function(){var j;if(this._oPreviousSelectedFilters){j=function(E,G,H){var i;for(i=0;i<E.length;i++){if(G.getId()===E[i]){H.setProperty('selected',true,true);break;}}};this._getFilterDetailList().getItems().forEach(function(i){var E=this._findViewSettingsItemFromListItem(i);E.setProperty('selected',false,true);j(this._oPreviousSelectedFilters.selectedItemIds,i,E);},this);this._updateSelectAllCheckBoxState();}};z.prototype._hideToolbarButtons=function(){this._getPopover().setShowHeader(false);q.sap.delayedCall(0,this,function(){if(this._getPopover().getAggregation('_popup')._internalHeader){this._getPopover().getAggregation('_popup')._internalHeader.$().hide();}});};z.prototype._goToMainPage=function(){this._getPopover().setShowHeader(true);this._getPopover().setCustomHeader(this._getToolbar());this._oPreviousSelectedFilters=null;this._navigateToPage('Main');};z.prototype._adjustInitialWidth=function(){var i,j,E,G,H=this._getSegmentedButton(),J=H&&H.getButtons();if(!J||!J[0]){return;}i=J[0].$().width();j=parseInt(J[0].$().css('margin-right'),10);E=J.length;if(l._bSizeCompact||!!document.querySelector('.sapUiSizeCompact')){i=i*2;}G=(i+j)*(E+1.6);this._getPopover().setContentWidth(G+"px");};z.prototype._navigateToPage=function(i,j){var E;if(this._getNavContainer().getCurrentPage().getId()!==this['_get'+i+'PageId']()){if(i==='Details'){if(j){this._getNavContainer().to(this['_get'+i+'Page'](),'show');E=sap.ui.getCore().byId(this.getId()+u);E&&E.destroy();E=null;}else{q.sap.delayedCall(0,this._getNavContainer(),"to",[this['_get'+i+'Page'](),"slide"]);}}else{q.sap.delayedCall(0,this._getNavContainer(),'back');}}this._getNavContainer().attachEventOnce("afterNavigate",function(){if(this._currentPageId!==this._tabMap['filterDetail']){this._removeFooter();if(D.system.desktop&&this._lastViewedFilterParent&&this._lastViewedFilterParent.getFocusDomRef()){this._lastViewedFilterParent.getFocusDomRef().focus();}}else{if(D.system.desktop&&this._getFilterDetailList().getItems()[0]&&this._getFilterDetailList().getItems()[0].getFocusDomRef()){this._getFilterDetailList().getItems()[0].getFocusDomRef().focus();}}}.bind(this));};z.prototype._updateFilterListItemsCount=function(){var i,j,E=this._getFilterList().getItems();E.forEach(function(G){if(G.getId().indexOf('nofiltering')===-1){j=this._findViewSettingsItemFromListItem(G);if(j instanceof sap.m.ViewSettingsCustomItem){i=j.getFilterCount();}else if(j instanceof sap.m.ViewSettingsFilterItem){i=j.getItems().filter(function(H){return H.getSelected();}).length;}G.setCounter(i);}},this);};z.prototype._updateFilterDetailListFor=function(i){var j=this._findViewSettingsItemFromListItem(i).getMultiSelect();var E=sap.ui.getCore().byId(i.getId().split(m).shift());var G=E&&E.getItems()||[];var H=this._getFilterDetailList();H.destroyAggregation("items");if(j){H.setIncludeItemInSelection(true);H.setMode(g.MultiSelect);}else{H.setMode(g.SingleSelectLeft);}G.forEach(function(J){H.addItem(new S({id:J.getId()+F,title:J.getText(),type:f.Active,selected:J.getSelected()}));},this);};z.prototype._removePageContents=function(i){var j,E,G,H,J='_getMainPage';if(i==='filterDetail'){J='_getDetailsPage';}G=this[J]().getContent();H=G[0];for(j in this._tabMap){E=this._tabMap[j];if(H){if(H.getId()===E+'list'){this['_'+E+'List']=H;}}}if(!(i in this._tabMap)||A.call(this)){this.getCustomTabs().forEach(function(K){if(this._currentPageId===K.getId()){G.forEach(function(O){K.addAggregation('content',O,true);});}},this);}this[J]().removeAllContent();};z.prototype._addPageContents=function(i){var j,E,G,H=this.getCustomTabs(),J='_getMainPage';if(i==='filterDetail'){J='_getDetailsPage';}for(j in this._tabMap){E=this._tabMap[j];if(E===i){E=E.slice(0,1).toUpperCase()+E.slice(1);G=this['_get'+E+'List']();this[J]().addContent(G);}}if(!(i in this._tabMap)){H.forEach(function(K){if(K.getId()===i){K.getContent().forEach(function(O){this[J]().addContent(O);},this);}},this);}};z.prototype._stashItems=function(i){var j=['sort','filter','group'];j.forEach(function(E){if(i&&Array.isArray(i[E+'Items'])){this._stashedItems[E]=i[E+'Items'];}},this);};z.prototype._addStashedItems=function(i){var j,E,G,H;for(j in this._tabMap){var H=this._tabMap[j];E=this._stashedItems[H];for(G in E){var J=E[G];this.addAggregation(H+'Items',J);}}};z.prototype._handleBack=function(E){if(this._currentPageId==='filterDetail'){this._showContentFor('filter');}};z.prototype._getSelectAllCheckbox=function(i,j){var E=sap.ui.getCore().byId(this.getId()+x);if(E){return E;}return new sap.m.CheckBox({id:this.getId()+x,text:'Select All',selected:i&&i.every(function(G){return G&&G.getSelected();}),select:function(G){var H=G.getParameter('selected');j.getItems().filter(function(J){return J.getVisible();}).forEach(function(J){var K=this._findViewSettingsItemFromListItem(J);K.setProperty('selected',H,true);}.bind(this));this._toggleRemoveFilterItem();}.bind(this)});};z.prototype._createList=function(i){var j,E=i.slice(0,1).toUpperCase()+i.slice(1),G=new L({id:this.getId()+'-'+i+'list',itemPress:function(H){j=this._findViewSettingsItemFromListItem(H.getParameter('listItem'));if(i==='group'||i==='sort'){this['fire'+E+'Selected']({items:[j]});this.close();}}.bind(this),selectionChange:function(H){var J;var K;var O=[];this._updateSelectAllCheckBoxState();j=this._findViewSettingsItemFromListItem(H.getParameter('listItem'));j.setProperty('selected',H.getParameter('selected'),true);if(G.getMode()!==g.MultiSelect){J=this.getFilterItems();if(J){J.forEach(function(Q){K=Q.getItems();if(K){O=O.concat(K);}});}O.forEach(function(Q){if(Q.getParent().getId()===j.getParent().getId()&&Q.getSelected(true)&&Q.getId()!==j.getId()){Q.setProperty('selected',false,true);}});}if(i==='filterDetail'){E='Filter';}else{this['fire'+E+'Selected']({items:[j]});this.close();}switch(i){case'group':this._getGroupList().addItem(this._getRemoveGroupingItem());break;}}.bind(this)});if(i!=='filter'){G.setMode(g.SingleSelectMaster);}this['_'+i+'List']=G;};z.prototype._getRemoveGroupingItem=function(){if(!this._removeGroupingItem){this._removeGroupingItem=new S({id:this.getId()+'-nogrouping',title:this._getText('NO_GROUPING'),type:f.Active});}return this._removeGroupingItem;};z.prototype._getRemoveFilterItem=function(){if(!this._removeFilteringItem){this._removeFilteringItem=new S({id:this.getId()+'-nofiltering',title:this._getText('REMOVE_FILTER'),type:f.Active,press:function(){this.getFilterItems().forEach(function(i){i.getItems().forEach(function(j){j.setProperty('selected',false,true);});});this.close();this._removeFilteringItem.destroy();this._removeFilteringItem=null;}.bind(this)});}return this._removeFilteringItem;};z.prototype._getTabButtonItem=function(i){var j=this.getId()+i.getId()+y,E=sap.ui.getCore().byId(j);if(E){return E;}else{return new sap.m.SegmentedButtonItem({key:j,id:j,icon:i.getIcon(),tooltip:i.getTooltip()});}};z.prototype._addPredefinedTab=function(i){var j=this._tabMap[i];switch(j){case'group':j=j+'-2';break;}var E=new sap.m.SegmentedButtonItem({key:i,icon:I.getIconURI(j),tooltip:this._getText("VIEWSETTINGS_TITLE_"+i.toUpperCase()),press:function onTabPress(G){var H=G.getSource().getProperty('key');var J=this['get'+H.slice(0,1).toUpperCase()+H.slice(1)+'Items']();if(this._currentPageId===H||this._currentPageId===this._tabMap['filterDetail']&&J&&J.length>1){if(D.system.phone){this._cancel();}else{this._hideContent();}}else{if(J&&J.length===1){if(H!=='filter'){J.forEach(function(K){K.setSelected(!K.getSelected());});this['fire'+H.slice(0,1).toUpperCase()+H.slice(1)+'Selected']({items:J});this.close();}else{this._showContentFor('filterDetail',this._findListItemFromViewSettingsItem(J[0]),true);}}else{this._showContentFor(H);}}}.bind(this)});switch(i){case'sort':this._getSegmentedButton().insertItem(E,0);break;case'filter':this._getSegmentedButton().insertItem(E,1);break;case'group':this._getSegmentedButton().insertItem(E,2);break;}};z.prototype.addCustomTab=function(i){var j=i.getId();if(j==='sort'||j==='filter'||j==='group'){throw new Error('Id "'+j+'" is reserved and cannot be used as custom tab id.');}this.addAggregation('customTabs',i);if(!this._isEmptyCustomTab(i)){var E=this._getTabButtonItem(i);E.attachEvent("press",this._handleCustomTabPress,this);this._getSegmentedButton().addItem(E);}return this;};z.prototype._handleCustomTabPress=function(E){var i,j,G,H,J=this.getCustomTabs(),K=J.length,O=E.getParameter('id');for(i=0;i<K;i++){j=J[i];G=this.getId()+j.getId()+y;H=this.getId()+this._currentPageId+y;if(H===O){if(D.system.phone){this._cancel();break;}else{this._hideContent();break;}}else{if(!this._isEmptyCustomTab(j)&&O===G){this._showContentFor(j.getId());break;}}}};z.prototype._hideContent=function(){this._removeSegmentedButtonSelection();this._cleanAfterClose();q.sap.delayedCall(0,this,'_adjustInitialWidth');};z.prototype._cleanAfterClose=function(){this._removePageContents(this._currentPageId);this._getPopover().setContentHeight(this._initialHeight);this._removeFooter();this._navigateToPage('Main');this._currentPageId=null;};z.prototype._removePredefinedTab=function(i){var j=this._getSegmentedButton().getItems();j.forEach(function(E){if(E.getKey()===i.toLowerCase()){this._getSegmentedButton().removeItem(E);}},this);if(this._currentPageId===i.toLowerCase()){this._showContentFor(this._determinePageToOpen());}};z.prototype._removeCustomTab=function(O){var i,j,E=this.getId()+this._currentPageId+y,G=false,H=this._getSegmentedButton().getItems();H.forEach(function(J){if(J.getKey().indexOf(y)!==-1){if(O){i=(this._currentPageId===O.getId());j=this.getId()+O.getId()+y;G=(O&&j===J.getId());}else{i=(E===J.getId());}if(!O||G){this._getSegmentedButton().removeItem(J);}if(i){this._showContentFor(this._determinePageToOpen());}}},this);};z.prototype._getPopoverAriaLabel=function(){var i=this.getAssociation("ariaLabelledBy");if(!i){i=new d({text:this._getText("ARIA_LABELLED_BY_POPOVER")}).toStatic().getId();this.setAssociation("ariaLabelledBy",i,true);}return i;};z.prototype._isItemsAggregation=function(i){var j=[];var E;for(E in this._tabMap){j.push(E+'Items');}if(j.indexOf(i)===-1){return false;}return true;};z.prototype.addAggregation=function(i,O,j){if(this._isItemsAggregation(i)){(!this.getAggregation(i)||this.getAggregation(i).length===0)&&this._addPredefinedTab(i.replace('Items',''));this._handleItemsAggregation.call(this,['addAggregation',i,O,j],true);}return C.prototype.addAggregation.call(this,i,O,j);};z.prototype.insertAggregation=function(i,O,j,E){if(this._isItemsAggregation(i)){(!this.getAggregation(i)||this.getAggregation(i).length===0)&&this._addPredefinedTab(i.replace('Items',''));this._handleItemsAggregation.call(this,['insertAggregation',i,O,j,E],true);}return C.prototype.insertAggregation.call(this,i,O,j,E);};z.prototype.removeAggregation=function(i,O,j){if(this._isItemsAggregation(i)){this._handleItemsAggregation.call(this,['removeAggregation',i,O,j]);if(!this['getAggregation'](i)){this._removePredefinedTab(i.replace('Items',''));}}else{this._removeCustomTab(O);}return C.prototype.removeAggregation.call(this,i,O,j);};z.prototype.removeAllAggregation=function(i,j){if(this._isItemsAggregation(i)){this._handleItemsAggregation.call(this,['removeAllAggregation',i,null,j]);this._removePredefinedTab(i.replace('Items',''));}else{this._removeCustomTab();}return C.prototype.removeAllAggregation.call(this,i,j);};z.prototype.destroyAggregation=function(i,j){if(this._isItemsAggregation(i)){var E=i.replace('Items','');this._handleItemsAggregation.call(this,['destroyAggregation',i,j]);this._removePredefinedTab(E.slice(0,1).toUpperCase()+E.slice(1));}else if(this._segmentedButton){this._removeCustomTab();}return C.prototype.destroyAggregation.call(this,i,j);};z.prototype._handleItemsAggregation=function(i,j){var E=i[0],G=i[1],O=i[2],H=i.slice(1);if(!this._isItemsAggregation(G)){return this;}if(j){this._attachItemEventListeners(O);}else{this._detachItemEventListeners(O);}this._handleListItemsAggregation(H,j,E,O);return this;};z.prototype._handleListItemsAggregation=function(i,j,E,O){var G,H,J,K,Q,U=i[0],W=false;switch(U){case'sortItems':G=this._getSortList();break;case'groupItems':G=this._getGroupList();break;case'filterItems':G=this._getFilterList();break;case'filterDetailItems':G=this._getFilterDetailList();break;}if(E==='destroyAggregation'&&!G){return;}if(O===null||typeof O!=='object'){return G[E]['apply'](G,i);}if(j){W=U==='filterItems'&&O.getItems;J=this._createListItemFromViewSettingsItem(O,U.replace("Items",""),W);}else{J=this._findListItemFromViewSettingsItem(O);}i.forEach(function(X,Y){if(X&&typeof X==='object'){i[Y]=J;}});for(K in this._tabMap){Q=this._tabMap[K];i[0]=i[0].replace(Q+'I','i');}H=G[E].apply(G,i);if(E=='removeAggregation'){H.destroy();}switch(U){case'filterItems':this._toggleRemoveFilterItem();break;}return H;};z.prototype._toggleRemoveFilterItem=function(){var H=false;this.getFilterItems().forEach(function(i){if(i.getItems){i.getItems().forEach(function(j){if(j.getSelected()){H=true;}});}});if(H){if(!this._getRemoveFilterItem().getParent()){this._getFilterList().addItem(this._getRemoveFilterItem());}}else{if(this._removeFilteringItem){this._removeFilteringItem.destroy();this._removeFilteringItem=null;}}};z.prototype._attachItemEventListeners=function(O){if(O instanceof V&&O.getId().indexOf('nogrouping')===-1){O.detachItemPropertyChanged(this._handleViewSettingsItemPropertyChanged.bind(this));O.attachItemPropertyChanged(this._handleViewSettingsItemPropertyChanged.bind(this));}if(O instanceof sap.m.ViewSettingsFilterItem){O.detachFilterDetailItemsAggregationChange(this._handleFilterDetailItemsAggregationChange.bind(this));O.attachFilterDetailItemsAggregationChange(this._handleFilterDetailItemsAggregationChange.bind(this));}};z.prototype._handleViewSettingsItemPropertyChanged=function(E){var i=E.getParameter('changedItem');var j=this._findListItemFromViewSettingsItem(i);var G=E.getParameter('propertyKey');var H=E.getParameter('propertyValue');if(G==='text'){G='title';}if(j&&['key','multiSelect'].indexOf(G)==-1){j.setProperty(G,H);}};z.prototype._handleFilterDetailItemsAggregationChange=function(E){var i=E.getParameters(),j=i.item||i.changedItem;if(j&&j.getParent&&j.getParent()instanceof V){this._updateFilterDetailListFor(j.getParent());}};z.prototype._detachItemEventListeners=function(O){};z.prototype._createListItemFromViewSettingsItem=function(i,j,H){var E,G=m;if(!i&&!(i instanceof V)){q.sap.log.error('Expecting instance of "sap.m.ViewSettingsItem": instead of '+i+' given.');return;}switch(j){case"group":G+=n;break;case"filter":G+=o;break;case"sort":G+=p;break;}E=new S({id:i.getId()+G,title:i.getText(),type:f.Active});H&&E.attachPress(this._showContentFor.bind(this,'filterDetail',E,false))&&E.setType(f.Navigation);return E;};z.prototype._findViewSettingsItemFromListItem=function(i){var j=m;if(i.getId().indexOf('filterdetail')!==-1){j=F;}return sap.ui.getCore().byId(i.getId().split(j).shift());};z.prototype._findListItemFromViewSettingsItem=function(i){var j=i.getId()+m,E=sap.ui.getCore().byId(j+n)||sap.ui.getCore().byId(j+o)||sap.ui.getCore().byId(j+p);if(!E){E=sap.ui.getCore().byId(i.getId()+F);}return E;};z.prototype._getMainPage=function(){if(!this._mainPage){this._mainPage=new P({showHeader:false,id:this._getMainPageId()});}return this._mainPage;};z.prototype._getDetailsPage=function(){var i,j;if(!this._detailsPage){this._detailsPage=new P({showHeader:true,id:this._getDetailsPageId()});var E=new sap.m.Label({text:this._getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");j=new b({contentMiddle:[E]}).addStyleClass("sapMVSPCompactHeaderBar");this._getDetailsPage().addHeaderContent(j);i=new B(this.getId()+u,{icon:I.getIconURI("nav-back"),press:this._handleBack.bind(this)});j.addContentLeft(i);}return this._detailsPage;};z.prototype._getMainPageId=function(){return this.getId()+s;};z.prototype._getDetailsPageId=function(){return this.getId()+t;};z.prototype._getPopover=function(O){if(!this._popover){this._popover=new R({showHeader:true,contentWidth:"300px",placement:e.Vertical,showCloseButton:false,modal:false,afterOpen:function(E){this.fireAfterOpen({openBy:E.getParameter("openBy")});this.$().attr("aria-labelledby",this._getPopoverAriaLabel());this._getSegmentedButton().getFocusDomRef().focus();}.bind(this),afterClose:function(E){this._cleanAfterClose();this.fireAfterClose({openBy:E.getParameter("openBy")});}.bind(this),beforeOpen:function(E){this.fireBeforeOpen({openBy:E.getParameter("openBy")});}.bind(this),beforeClose:function(E){this.fireBeforeClose({openBy:E.getParameter("openBy")});}.bind(this)}).addStyleClass('sapMVSPopover');this._popover.setCustomHeader(this._getToolbar());if(this._popover.getAggregation('_popup').setShowArrow){this._popover.getAggregation('_popup').setShowArrow(false);}}if(O&&O.$()){this._popover.setOffsetY(-O.$().outerHeight());}return this._popover;};z.prototype._getNavContainer=function(){if(!this._navContainer){this._navContainer=new N(this.getId()+r,{initialPage:this._getMainPageId(),pages:[this._getMainPage(),this._getDetailsPage()]});}return this._navContainer;};z.prototype._getSortList=function(){if(!this._sortList){this._createList('sort');}return this._sortList;};z.prototype._getGroupList=function(){if(!this._groupList){this._createList('group');}return this._groupList;};z.prototype._getFilterList=function(){if(!this._filterList){this._createList('filter');}return this._filterList;};z.prototype._getFilterDetailList=function(){if(!this._filterDetailList){this._createList('filterDetail');this._filterDetailList.attachEvent('selectionChange',function(){this._toggleRemoveFilterItem();}.bind(this));}return this._filterDetailList;};z.prototype._getToolbar=function(){if(!this._toolbar){var i;this._toolbar=new T({id:this.getId()+h});this._oCloseBtnARIAInvText=new d({text:this._getText("MESSAGEPOPOVER_CLOSE")});i=new B({icon:I.getIconURI("decline"),ariaLabelledBy:this._oCloseBtnARIAInvText.toStatic().getId(),press:this._cancel.bind(this)}).addStyleClass('sapMVSPCloseBtn');this._toolbar.addContent(this._getSegmentedButton());this._toolbar.addContent(new a());this._toolbar.addContent(i);}return this._toolbar;};z.prototype._getTitle=function(){if(!this._title){this._title=new sap.m.Label(this.getId()+"-title",{id:this.getId()+v,text:this._getText("VIEWSETTINGS_TITLE")}).addStyleClass("sapMVSDTitle");}return this._title;};z.prototype._getSearchField=function(){if(!this._filterSearchField){this._filterSearchField=new sap.m.SearchField({id:this.getId()+w,liveChange:function(E){this._filterItemsBy(E.getParameter('newValue').toLowerCase());}.bind(this)});this._updateSelectAllCheckBoxState();}return this._filterSearchField;};z.prototype._filterItemsBy=function(Q){this._getFilterDetailList().getItems().forEach(function(i){var j=i.getTitle().toLowerCase().indexOf(Q)===0;i.setVisible(j);});this._updateSelectAllCheckBoxState();};z.prototype._getSegmentedButton=function(){if(!this._segmentedButton){this._segmentedButton=new c(this.getId()+k);}return this._segmentedButton;};z.prototype._getText=function(K){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText(K);};z.prototype.getDomRef=function(i){return this._popover&&this._popover.getAggregation("_popup").getDomRef(i);};["invalidate","close","isOpen","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","setBindingContext","getBindingContext","getBinding","getBindingInfo","getBindingPath","setBusy","getBusy","setBusyIndicatorDelay","getBusyIndicatorDelay"].forEach(function(i){z.prototype[i]=function(){if(this._popover&&this._popover[i]){var j=this._popover[i].apply(this._popover,arguments);return j===this._popover?this:j;}};});z.prototype.exit=function(){if(this._sortList){this._sortList.destroy();this._sortList=null;}if(this._filterList){this._filterList.destroy();this._filterList=null;}if(this._filterDetailList){this._filterDetailList.destroy();this._filterDetailList=null;}if(this._groupList){this._groupList.destroy();this._groupList=null;}this._popover.destroy();this._popover=null;this._oCloseBtnARIAInvText.destroy();this._oCloseBtnARIAInvText=null;this._title=null;this._navContainer=null;this._mainPage=null;this._detailsPage=null;this._toolbar=null;this._segmentedButton=null;this._currentPageId=null;this._tabMap=null;this._oPreviousSelectedFilters=null;var i=sap.ui.getCore().byId(this.getAssociation("ariaLabelledBy"));if(i&&i.destroy&&!i.bIsDestroyed){i.destroy();i=null;}if(this._removeFilteringItem){this._removeFilteringItem.destroy();this._removeFilteringItem=null;}};z.prototype._isEmptyCustomTab=function(i){var j=i.getContent().length,E=this._currentPageId===i.getId()&&this._getMainPage().getContent().length;return!(j||E);};function A(){return(this._getMainPage().getContent().length&&!(this._currentPageId in this._tabMap));}return z;});
