/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/m/semantic/SegmentedContainer','sap/m/semantic/SemanticConfiguration','sap/m/Button','sap/m/Title','sap/m/Page','sap/m/OverflowToolbar','sap/m/ToolbarSpacer','sap/m/Bar','sap/ui/core/CustomData','sap/ui/base/ManagedObject','sap/m/PageAccessibleLandmarkInfo','sap/ui/base/ManagedObjectObserver','sap/ui/core/Control','sap/ui/core/library','sap/m/library'],function(q,S,a,B,T,P,O,b,c,C,M,d,e,f,g,l){"use strict";var h=l.ButtonType;var i=l.PageBackgroundDesign;var j=l.semantic.SemanticRuleSetType;var k=g.TitleLevel;var m=f.extend("sap.m.semantic.SemanticPage",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:k.Auto},showNavButton:{type:"boolean",group:"Appearance",defaultValue:false},showSubHeader:{type:"boolean",group:"Appearance",defaultValue:true},enableScrolling:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Appearance",defaultValue:true},floatingFooter:{type:"boolean",group:"Appearance",defaultValue:false},semanticRuleSet:{type:"sap.m.semantic.SemanticRuleSetType",group:"Misc",defaultValue:j.Classic},backgroundDesign:{type:"sap.m.PageBackgroundDesign",group:"Appearance",defaultValue:i.Standard}},defaultAggregation:"content",aggregations:{subHeader:{type:"sap.m.IBar",multiple:false},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},customHeaderContent:{type:"sap.m.Button",multiple:true,singularName:"customHeaderContent"},customFooterContent:{type:"sap.m.Button",multiple:true,singularName:"customFooterContent"},landmarkInfo:{type:"sap.m.PageAccessibleLandmarkInfo",multiple:false},_page:{type:"sap.m.Page",multiple:false,visibility:"hidden"}},events:{navButtonPress:{}},designTime:true}});m.prototype.init=function(){this._oHeaderObserver=new e(m.prototype._updateHeaderVisibility.bind(this));this._currentMode=a._PageMode.display;this._getPage().setCustomHeader(this._getInternalHeader());this._getPage().setFooter(new O(this.getId()+"-footer"));this._getPage().setLandmarkInfo(new d());this._getPage().setShowHeader(false);};m.prototype.exit=function(){if(this._oInternalHeader){this._oInternalHeader.destroy();this._oInternalHeader=null;}if(this._oWrappedFooter){this._oWrappedFooter.destroy();this._oWrappedFooter=null;}if(this._oTitle){this._oTitle.destroy();this._oTitle=null;}if(this._oNavButton){this._oNavButton.destroy();this._oNavButton=null;}if(this._oHeaderObserver){this._oHeaderObserver.disconnect();this._oHeaderObserver=null;}this._oPositionsMap=null;};m.prototype.setSubHeader=function(o,p){this._getPage().setSubHeader(o,p);return this;};m.prototype.getSubHeader=function(){return this._getPage().getSubHeader();};m.prototype.destroySubHeader=function(o){this._getPage().destroySubHeader(o);return this;};m.prototype.getShowSubHeader=function(){return this._getPage().getShowSubHeader();};m.prototype.setShowSubHeader=function(o,p){this._getPage().setShowSubHeader(o,p);this.setProperty("showSubHeader",o,true);return this;};m.prototype.getShowFooter=function(){return this._getPage().getShowFooter();};m.prototype.setShowFooter=function(o,p){this._getPage().setShowFooter(o,p);this.setProperty("showFooter",o,true);return this;};m.prototype.setFloatingFooter=function(F,o){this._getPage().setFloatingFooter(F,o);this.setProperty("floatingFooter",F,true);return this;};m.prototype.getContent=function(){return this._getPage().getContent();};m.prototype.addContent=function(o,p){this._getPage().addContent(o,p);return this;};m.prototype.indexOfContent=function(o){return this._getPage().indexOfContent(o);};m.prototype.insertContent=function(o,I,p){this._getPage().insertContent(o,I,p);return this;};m.prototype.removeContent=function(o,p){return this._getPage().removeContent(o,p);};m.prototype.removeAllContent=function(o){return this._getPage().removeAllContent(o);};m.prototype.destroyContent=function(o){this._getPage().destroyContent(o);return this;};m.prototype.setTitle=function(t){var o=this._getTitle();if(o){o.setText(t);if(!o.getParent()){this._getInternalHeader().addContentMiddle(o);}}this.setProperty("title",t,true);return this;};m.prototype.setTitleLevel=function(t){this.setProperty("titleLevel",t,true);this._getTitle().setLevel(t);return this;};m.prototype.setShowNavButton=function(o){var p=this._getNavButton();if(p){p.setVisible(o);if(!p.getParent()){this._getInternalHeader().addContentLeft(p);}}this.setProperty("showNavButton",o,true);return this;};m.prototype.setEnableScrolling=function(E){this._getPage().setEnableScrolling(E);this.setProperty("enableScrolling",E,true);return this;};m.prototype.setLandmarkInfo=function(L){return this._getPage().setLandmarkInfo(L);};m.prototype.getLandmarkInfo=function(){return this._getPage().getLandmarkInfo();};m.prototype.destroyLandmarkInfo=function(){return this._getPage().destroyLandmarkInfo();};m.prototype.setBackgroundDesign=function(o){this.setProperty("backgroundDesign",o,true);this._getPage().setBackgroundDesign(o);return this;};m.prototype.getCustomFooterContent=function(){return this._getSegmentedFooter().getSection("customRight").getContent();};m.prototype.addCustomFooterContent=function(o,p){this._getSegmentedFooter().getSection("customRight").addContent(o,p);return this;};m.prototype.indexOfCustomFooterContent=function(o){return this._getSegmentedFooter().getSection("customRight").indexOfContent(o);};m.prototype.insertCustomFooterContent=function(o,I,p){this._getSegmentedFooter().getSection("customRight").insertContent(o,I,p);return this;};m.prototype.removeCustomFooterContent=function(o,p){return this._getSegmentedFooter().getSection("customRight").removeContent(o,p);};m.prototype.removeAllCustomFooterContent=function(o){return this._getSegmentedFooter().getSection("customRight").removeAllContent(o);};m.prototype.destroyCustomFooterContent=function(o){var p=this.getCustomFooterContent();if(!p){return this;}if(o){this.iSuppressInvalidate++;}this._getSegmentedFooter().getSection("customRight").destroy(o);if(!this.isInvalidateSuppressed()){this.invalidate();}if(o){this.iSuppressInvalidate--;}return this;};m.prototype.getCustomHeaderContent=function(){return this._getSegmentedHeader().getSection("customRight").getContent();};m.prototype.addCustomHeaderContent=function(o,p){this._getSegmentedHeader().getSection("customRight").addContent(o,p);return this;};m.prototype.indexOfCustomHeaderContent=function(o){return this._getSegmentedHeader().getSection("customRight").indexOfContent(o);};m.prototype.insertCustomHeaderContent=function(o,I,p){this._getSegmentedHeader().getSection("customRight").insertContent(o,I,p);return this;};m.prototype.removeCustomHeaderContent=function(o,p){return this._getSegmentedHeader().getSection("customRight").removeContent(o,p);};m.prototype.removeAllCustomHeaderContent=function(o){return this._getSegmentedHeader().getSection("customRight").removeAllContent(o);};m.prototype.destroyCustomHeaderContent=function(o){var p=this.getCustomHeaderContent();if(!p){return this;}if(o){this.iSuppressInvalidate++;}this._getSegmentedHeader().getSection("customRight").destroy(o);if(!this.isInvalidateSuppressed()){this.invalidate();}if(o){this.iSuppressInvalidate--;}return this;};m.prototype.setAggregation=function(A,o,p){var r=this.mAggregations[A];if(r===o){return this;}o=this.validateAggregation(A,o,false);var t=this.getMetadata().getManagedAggregation(A).type;if(a.isKnownSemanticType(t)){if(r){this._stopMonitor(r);this._removeFromInnerAggregation(r._getControl(),a.getPositionInPage(t),p);}if(o){this._initMonitor(o);this._addToInnerAggregation(o._getControl(),a.getPositionInPage(t),a.getSequenceOrderIndex(t),p);}return M.prototype.setAggregation.call(this,A,o,true);}return M.prototype.setAggregation.call(this,A,o,p);};m.prototype.destroyAggregation=function(A,o){var p=this.getMetadata().getAggregations()[A];if(p&&a.isKnownSemanticType(p.type)){var r=M.prototype.getAggregation.call(this,A);if(r){this._stopMonitor(r);if(!r._getControl().bIsDestroyed){this._removeFromInnerAggregation(r._getControl(),a.getPositionInPage(p.type),o);}}}return M.prototype.destroyAggregation.call(this,A,r,o);};m.prototype._updateHeaderVisibility=function(){var H=this._getInternalHeader();var E=(H.getContentLeft().length===0)&&(H.getContentMiddle().length===0)&&(H.getContentRight().length===0);this._getPage().setShowHeader(!E);};m.prototype._getTitle=function(){if(!this._oTitle){this._oTitle=new T(this.getId()+"-title",{text:this.getTitle()});}return this._oTitle;};m.prototype._getNavButton=function(){if(!this._oNavButton){this._oNavButton=new B(this.getId()+"-navButton",{type:h.Up,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PAGE_NAVBUTTON_TEXT"),press:q.proxy(this.fireNavButtonPress,this)});}return this._oNavButton;};m.prototype._initMonitor=function(o){var p=o._getConfiguration();if(p.triggers){o.attachEvent("press",this._updateCurrentMode,this);}var r=p.states,t=this;if(r){q.each(a._PageMode,function(u,v){if(r[u]){t.attachEvent(u,o._onPageStateChanged,o);}});}};m.prototype._stopMonitor=function(o){o.detachEvent("press",this._updateCurrentMode,this);var p=o._getConfiguration();var r=p.states,t=this;if(r){q.each(a._PageMode,function(u,v){if(r[u]){t.detachEvent(u,o._onPageStateChanged,o);}});}};m.prototype._updateCurrentMode=function(E){var o=E.oSource._getConfiguration();if(typeof o.triggers==='string'){this._currentMode=o.triggers;}else{var L=o.triggers.length;if(L&&L>0){for(var I=0;I<L;I++){var t=o.triggers[I];if(t&&(t.inState===this._currentMode)){this._currentMode=t.triggers;break;}}}}this.fireEvent(this._currentMode);};m.prototype._removeFromInnerAggregation=function(o,p,r){var t=this._getSemanticPositionsMap()[p];if(t&&t.oContainer&&t.sAggregation){t.oContainer["remove"+n(t.sAggregation)](o,r);}};m.prototype._addToInnerAggregation=function(o,p,r,t){if(!o||!p){return;}var u=this._getSemanticPositionsMap()[p];if(!u||!u.oContainer||!u.sAggregation){return;}if(typeof r!=='undefined'){o.addCustomData(new C({key:"sortIndex",value:r}));}return u.oContainer["add"+n(u.sAggregation)](o,t);};m.prototype._getSemanticPositionsMap=function(o,p){if(!this._oPositionsMap){this._oPositionsMap={};this._oPositionsMap[a.prototype._PositionInPage.headerLeft]={oContainer:this._getInternalHeader(),sAggregation:"contentLeft"};this._oPositionsMap[a.prototype._PositionInPage.headerRight]={oContainer:this._getSegmentedHeader().getSection("semanticRight"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.headerMiddle]={oContainer:this._getInternalHeader(),sAggregation:"contentMiddle"};this._oPositionsMap[a.prototype._PositionInPage.footerLeft]={oContainer:this._getSegmentedFooter().getSection("semanticLeft"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.footerRight_IconOnly]={oContainer:this._getSegmentedFooter().getSection("semanticRight_IconOnly"),sAggregation:"content"};this._oPositionsMap[a.prototype._PositionInPage.footerRight_TextOnly]={oContainer:this._getSegmentedFooter().getSection("semanticRight_TextOnly"),sAggregation:"content"};}return this._oPositionsMap;};m.prototype._getPage=function(){var p=this.getAggregation("_page");if(!p){this.setAggregation("_page",new P(this.getId()+"-page"));p=this.getAggregation("_page");}return p;};m.prototype._getInternalHeader=function(){if(!this._oInternalHeader){this._oInternalHeader=new c(this.getId()+"-intHeader");if(this._oHeaderObserver){this._oHeaderObserver.observe(this._oInternalHeader,{aggregations:["contentLeft","contentMiddle","contentRight"]});}}return this._oInternalHeader;};m.prototype._getAnyHeader=function(){return this._getInternalHeader();};m.prototype._getSegmentedHeader=function(){if(!this._oWrappedHeader){var H=this._getInternalHeader();if(!H){q.sap.log.error("missing page header",this);return null;}this._oWrappedHeader=new S(H,"contentRight");this._oWrappedHeader.addSection({sTag:"customRight"});this._oWrappedHeader.addSection({sTag:"semanticRight"});}return this._oWrappedHeader;};m.prototype._getSegmentedFooter=function(){if(!this._oWrappedFooter){var F=this._getPage().getFooter();if(!F){q.sap.log.error("missing page footer",this);return null;}this._oWrappedFooter=new S(F);this._oWrappedFooter.addSection({sTag:"semanticLeft"});this._oWrappedFooter.addSection({sTag:"spacer",aContent:[new b()]});this._oWrappedFooter.addSection({sTag:"semanticRight_TextOnly",fnSortFunction:s});this._oWrappedFooter.addSection({sTag:"customRight"});this._oWrappedFooter.addSection({sTag:"semanticRight_IconOnly",fnSortFunction:s});}return this._oWrappedFooter;};function n(N){return N.substring(0,1).toUpperCase()+N.substring(1);}function s(o,p){var r=o.data("sortIndex");var t=p.data("sortIndex");if((typeof r==='undefined')||(typeof t==='undefined')){q.sap.log.warning("sortIndex missing",this);return null;}return(r-t);}return m;});
