/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/base/Object','sap/ui/base/ObjectPool','./Control','./IntervalTrigger','./RenderManager','./Element','./ResizeHandler','jquery.sap.script'],function(q,D,M,B,O,C,I,R,E,a){"use strict";var P=M.extend("sap.ui.core.Popup",{constructor:function(c,m,s,A){M.apply(this);this._popupUID=q.sap.uid();this.bOpen=false;this.eOpenState=sap.ui.core.OpenState.CLOSED;this._mEvents={};this._mEvents["sap.ui.core.Popup.addFocusableContent-"+this._popupUID]=this._addFocusableArea;this._mEvents["sap.ui.core.Popup.removeFocusableContent-"+this._popupUID]=this._removeFocusableArea;this._mEvents["sap.ui.core.Popup.closePopup-"+this._popupUID]=this._closePopup;this._mEvents["sap.ui.core.Popup.onFocusEvent-"+this._popupUID]=this.onFocusEvent;this._mEvents["sap.ui.core.Popup.increaseZIndex-"+this._popupUID]=this._increaseMyZIndex;this._mEvents["sap.ui.core.Popup.contains-"+this._popupUID]=this._containsEventBusWrapper;if(c){this.setContent(c);}this._oDefaultPosition={my:P.Dock.CenterCenter,at:P.Dock.CenterCenter,of:document,offset:"0 0",collision:"flip"};this._oPosition=q.extend({},this._oDefaultPosition);this._bModal=!!m;this._oPreviousFocus=null;this._sInitialFocusId=null;this._bShadow=typeof(s)==="boolean"?s:true;this._bAutoClose=!!A;this._animations={open:null,close:null};this._durations={open:"fast",close:"fast"};this._iZIndex=-1;this._oBlindLayer=null;this.setNavigationMode();if(this.touchEnabled){this._fAutoCloseHandler=function(e){if(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose")){return;}if(this.eOpenState===sap.ui.core.OpenState.CLOSING||this.eOpenState===sap.ui.core.OpenState.CLOSED){return;}if(!this._contains(e.target)){this.close();}};}this._F6NavigationHandler=function(e){var S={},b=this._sF6NavMode,d;if(b=="DOCK"){if(this._bModal){b="NONE";}else if(this._oLastPosition&&this._oLastPosition.of){d=this._getOfDom(this._oLastPosition.of);if(!d||d===document){d=null;b="NONE";}}}switch(b){case"SCOPE":S.scope=this._$()[0];break;case"DOCK":S.target=d;var $=q(d).parents("[data-sap-ui-popup]");S.scope=$.length?$[0]:null;break;default:S.skip=true;}q.sap.handleF6GroupNavigation(e,S);};},metadata:{library:"sap.ui.core",publicMethods:["open","close","setContent","getContent","setPosition","setShadow","setModal","getModal","setAutoClose","setAutoCloseAreas","isOpen","getAutoClose","getOpenState","setAnimations","setDurations","attachOpened","attachClosed","detachOpened","detachClosed"],associations:{"childPopups":{type:"sap.ui.core.Popup",multiple:true,visibility:"hidden"}},events:{"opened":{},"closed":{}}}});P._activateBlindLayer=true;P.blStack=[];P.Dock={BeginTop:"begin top",BeginCenter:"begin center",BeginBottom:"begin bottom",LeftTop:"left top",LeftCenter:"left center",LeftBottom:"left bottom",CenterTop:"center top",CenterCenter:"center center",CenterBottom:"center bottom",RightTop:"right top",RightCenter:"right center",RightBottom:"right bottom",EndTop:"end top",EndCenter:"end center",EndBottom:"end bottom"};P.prototype.touchEnabled=D.support.touch||q.sap.simulateMobileOnDesktop;P.prototype.preventBrowserFocus=(D.support.touch||q.sap.simulateMobileOnDesktop)&&!D.system.combi;B.extend("sap.ui.core.Popup.Layer",{constructor:function(){var d=this.getDomString();this._$Ref=q(d).appendTo(sap.ui.getCore().getStaticAreaRef());}});P.Layer.prototype.init=function(o,z){this._$Ref.css({"visibility":"visible","z-index":z});this.update(o,z);this._$Ref.insertAfter(o).show();};P.Layer.prototype.update=function(o,z){if(o.length){var b=o.rect();this._$Ref.css({"left":b.left,"top":b.top});if(o.css("right")!="auto"&&o.css("right")!="inherit"){this._$Ref.css({"right":o.css("right"),"width":"auto"});}else{this._$Ref.css({"width":b.width,"right":"auto"});}if(o.css("bottom")!="auto"&&o.css("bottom")!="inherit"){this._$Ref.css({"bottom":o.css("bottom"),"height":"auto"});}else{this._$Ref.css({"height":b.height,"bottom":"auto"});}if(typeof(z)==="number"){this._$Ref.css("z-index",z);}}};P.Layer.prototype.reset=function(){if(this._$Ref.length){this._$Ref[0].style.display="none";this._$Ref[0].style.visibility="hidden";this._$Ref.appendTo(sap.ui.getCore().getStaticAreaRef());}};P.Layer.prototype.getDomString=function(){q.sap.log.error("sap.ui.core.Popup.Layer: getDomString function must be overwritten!");return"";};P.Layer.extend("sap.ui.core.Popup.BlindLayer",{constructor:function(){P.Layer.apply(this);}});P.BlindLayer.prototype.getDomString=function(){return"<div class=\"sapUiBliLy\" id=\"sap-ui-blindlayer-"+q.sap.uid()+"\"><iframe scrolling=\"no\" tabIndex=\"-1\"></iframe></div>";};P.prototype.oBlindLayerPool=new O(P.BlindLayer);P.Layer.extend("sap.ui.core.Popup.ShieldLayer",{constructor:function(){P.Layer.apply(this);}});P.ShieldLayer.prototype.getDomString=function(){return"<div class=\"sapUiPopupShield\" id=\"sap-ui-shieldlayer-"+q.sap.uid()+"\"></div>";};P.prototype.oShieldLayerPool=new O(P.ShieldLayer);(function(){var l=0;var m=Math.pow(2,32)-1;P.setInitialZIndex=function(i){if(i>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}l=Math.max(i,this.getLastZIndex());};P.getLastZIndex=function(){return l;};P.prototype.getLastZIndex=function(){return P.getLastZIndex();};P.getNextZIndex=function(){l+=10;if(l>=m){throw new Error("Z-index can't be higher than Number.MAX_SAFE_INTEGER");}return l;};P.prototype.getNextZIndex=function(){return P.getNextZIndex();};}());var r=function(o,b){var p=3;var l=Math.abs(o.left-b.left);var t=Math.abs(o.top-b.top);var w=Math.abs(o.width-b.width);var h=Math.abs(o.height-b.height);if(l>p||t>p||w>p||h>p){return false;}return true;};P.prototype.open=function(d,m,b,o,c,f,g){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){return;}this.eOpenState=sap.ui.core.OpenState.OPENING;var s;try{s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);}catch(e){q.sap.log.error(e);throw new Error("Popup cannot be opened because static UIArea cannot be determined.");}this._bContentAddedToStatic=false;if(this.oContent instanceof C&&!this.oContent.getParent()){s.addContent(this.oContent,true);this._bContentAddedToStatic=true;}if(this.oContent.getUIArea){var A=this.oContent.getUIArea();if(A===null){q.sap.log.warning("The Popup content is NOT connected with a UIArea and may not work properly!");}else if(P._bEnableUIAreaCheck&&A.getRootNode().id!==s.getRootNode().id){q.sap.log.warning("The Popup content is NOT connected with the static-UIArea and may not work properly!");}}if(typeof(d)=="string"){g=f;f=c;c=o;o=b;b=m;m=d;d=-1;}if(d===undefined){d=-1;}this._oPreviousFocus=P.getCurrentFocusInfo();if(this.isInPopup(o)||this.isInPopup(this._oPosition.of)){var p=this.getParentPopupId(o)||this.getParentPopupId(this._oPosition.of);var h="";var i=this.getContent();if(i instanceof E){h=i.getId();}else if(typeof i==="object"){h=i.id;}this.addChildToPopup(p,h);this.addChildToPopup(p,this._popupUID);}var $=this._$(true);var j="fast";if((d===0)||(d>0)){j=d;}else if((this._durations.open===0)||(this._durations.open>0)){j=this._durations.open;}var _;if(m||b||o||c||f){_=this._createPosition(m,b,o,c,f);this._oPosition=_;}else{_=this._oPosition;}if(!_.of){_.of=this._oPosition.of||document;}this._iZIndex=this._iZIndex===this.getLastZIndex()?this._iZIndex:this.getNextZIndex();var S=sap.ui.getCore().getStaticAreaRef();$.css({"position":"absolute","visibility":"hidden"});if(!($[0].parentNode==S)){$.appendTo(S);}$.css("z-index",this._iZIndex);q.sap.log.debug("position popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(_.at):String(_.at)));this._applyPosition(_);if(g!==undefined){this.setFollowOf(g);}$.toggleClass("sapUiShd",this._bShadow);var k=$[0];if(k){k.style.display="none";k.style.visibility="visible";}this._duringOpen();if(j==0){this._opened();}else if(this._animations.open){this._animations.open.call(null,$,j,this._opened.bind(this));}else{$.fadeIn(j,this._opened.bind(this));}};P.prototype._opened=function(){if(this.eOpenState!==sap.ui.core.OpenState.OPENING){return;}this.bOpen=true;var $=this._$(false,true);if($[0]&&$[0].style){$[0].style.display="block";}if(this._bModal||this._bAutoClose||this._sInitialFocusId){var d=null;if(this._sInitialFocusId){var c=sap.ui.getCore().byId(this._sInitialFocusId);if(c){d=c.getFocusDomRef();}d=d||q.sap.domById(this._sInitialFocusId);}q.sap.focus(d||$.firstFocusableDomRef());var o=this._getOfDom(this._oLastPosition.of);var b=q(o).rect();if(this._oLastOfRect&&b&&!r(this._oLastOfRect,b)){this._applyPosition(this._oLastPosition);}}this.eOpenState=sap.ui.core.OpenState.OPEN;if(this.getFollowOf()){P.DockTrigger.addListener(P.checkDocking,this);}this._updateBlindLayer();this.fireOpened();};P.prototype._duringOpen=function(){var $=this._$(false,true);if(q.sap.isMouseEventDelayed){if(this._oTopShieldLayer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this._iTopShieldRemoveTimer=null;}else{this._oTopShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex+1);}this._iTopShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;});}if(!!D.browser.msie&&!D.os.windows_phone&&P._activateBlindLayer){this._oBlindLayer=this.oBlindLayerPool.borrowObject($,this._iZIndex-1);}if(this._bModal){this._showBlockLayer();}if(this.oContent instanceof E){this.oContent.addDelegate(this);}this.bOpen=true;this._activateFocusHandle();this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}};P.prototype._contains=function(d){var p=this._$().get(0);if(!p){return false;}var c=q.sap.containsOrEquals(p,d);var b;if(!c){b=this.getChildPopups();c=b.some(function(s){var o=q.sap.domById(s);var c=q.sap.containsOrEquals(o,d);if(!c){var e="sap.ui.core.Popup.contains-"+s;var f={domRef:d};sap.ui.getCore().getEventBus().publish("sap.ui",e,f);c=f.contains;}return c;});}return c;};P.prototype._containsEventBusWrapper=function(c,e,d){d.contains=this._contains(d.domRef);};P.prototype.onFocusEvent=function(b){var e=q.event.fix(b);if(arguments.length>1&&arguments[1]==="sap.ui.core.Popup.onFocusEvent-"+this._popupUID){e=q.event.fix(arguments[2]);}var t=(e.type=="focus"||e.type=="activate")?"focus":"blur";var c=false;if(t=="focus"){var d=this._$().get(0);if(d){c=this._contains(e.target);q.sap.log.debug("focus event on "+e.target.id+", contains: "+c);if(this._bModal&&!c){var T=P.blStack.length>0&&P.blStack[P.blStack.length-1].popup===this;if(T){if(D.system.desktop||q(e.target).is(":input")){if(this.oLastBlurredElement){q.sap.delayedCall(0,this,function(){q.sap.focus(this.oLastBlurredElement);});}else{q.sap.focus(d);}}}}else if(this._bAutoClose&&c&&this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;}}}else if(t=="blur"){q.sap.log.debug("blur event on "+e.target.id);if(this._bModal){this.oLastBlurredElement=e.target;}else if(this._bAutoClose){if(!this.touchEnabled&&!this._sTimeoutId){if(e.target===document.activeElement){return;}var i=typeof this._durations.close==="string"?0:this._durations.close;this._sTimeoutId=q.sap.delayedCall(i,this,function(){this.close(i,"autocloseBlur");var o=this._oLastPosition&&this._oLastPosition.of;if(o){var p=this.getParentPopupId(o);if(p){var s="sap.ui.core.Popup.onFocusEvent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",s,e);}}});}}}};P.prototype.setInitialFocusId=function(i){this._sInitialFocusId=i;};P.prototype.close=function(d){if(P._autoCloseDebug){return;}if(this._sTimeoutId){q.sap.clearDelayedCall(this._sTimeoutId);this._sTimeoutId=null;if(arguments.length>1){var A=arguments[1];if(typeof A=="string"&&A=="autocloseBlur"&&this._isFocusInsidePopup()){return;}}}if(this.eOpenState==sap.ui.core.OpenState.CLOSED||this.eOpenState==sap.ui.core.OpenState.CLOSING){return;}var i="fast";if((d===0)||(d>0)){i=d;}else if((this._durations.close===0)||(this._durations.close>0)){i=this._durations.close;}this.eOpenState=sap.ui.core.OpenState.CLOSING;if(this.getFollowOf()){P.DockTrigger.removeListener(P.checkDocking,this);}if(this.oContent&&this._bContentAddedToStatic){sap.ui.getCore().getEventBus().publish("sap.ui","__beforePopupClose",{domNode:this._$().get(0)});var s=sap.ui.getCore().getStaticAreaRef();s=sap.ui.getCore().getUIArea(s);s.removeContent(s.indexOfContent(this.oContent),true);}this._bContentAddedToStatic=false;this._sTimeoutId=null;this._deactivateFocusHandle();this._$(false,true).off("keydown",this._F6NavigationHandler);if(this.oContent instanceof E){this.oContent.removeDelegate(this);}var $=this._$();if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._oBlindLayer){this.oBlindLayerPool.returnObject(this._oBlindLayer);}this._oBlindLayer=null;if(q.sap.isMouseEventDelayed){if(this._oBottomShieldLayer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this._iBottomShieldRemoveTimer=null;}else{this._oBottomShieldLayer=this.oShieldLayerPool.borrowObject($,this._iZIndex-3);}this._iBottomShieldRemoveTimer=q.sap.delayedCall(500,this,function(){this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;});}if(this.isInPopup(this._oLastPosition.of)){var p=this.getParentPopupId(this._oLastPosition.of);var c="";var o=this.getContent();if(o instanceof E){c=o.getId();}else if(typeof o==="object"){c=o.id;}this.removeChildFromPopup(p,c);this.removeChildFromPopup(p,this._popupUID);}if(this._bModal&&this.preventBrowserFocus){$.one("mousedown",function(e){e.preventDefault();});}this._duringClose();if(i==0){this._closed();}else if(this._animations.close){this._animations.close.call(null,$,i,this._closed.bind(this));}else{$.fadeOut(i,this._closed.bind(this));}};P.prototype._closed=function(){if(this._bModal){this._hideBlockLayer();}var $=this._$(false,true);if($.length){var d=$.get(0);if(d){d.style.display="none";d.style.visibility="hidden";d.style.left="0px";d.style.top="0px";d.style.right="";}$=this._$(false,true);d=$.length?$[0]:null;if(d){d.style.display="none";d.style.visibility="hidden";d.style.left="0px";d.style.top="0px";d.style.right="";}}if(this._bModal){P.applyFocusInfo(this._oPreviousFocus);this._oPreviousFocus=null;this.oLastBlurredElement=null;}this.bOpen=false;this.eOpenState=sap.ui.core.OpenState.CLOSED;var c=this.getChildPopups();for(var j=0,l=c.length;j<l;j++){this.closePopup(c[j]);}this.fireClosed();};P.prototype._duringClose=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}};P.getCurrentFocusInfo=function(){var _=null;var f=sap.ui.getCore().getCurrentFocusedControlId();if(f){var F=sap.ui.getCore().byId(f);_={'sFocusId':f,'oFocusInfo':F?F.getFocusInfo():{}};}else{try{var e=document.activeElement;if(e&&e.nodeName){_={'sFocusId':e.id,'oFocusedElement':e,'oFocusInfo':{}};}}catch(b){_=null;}}if(_){_.popup=this;}return _;};P.applyFocusInfo=function(p){if(p){var f=sap.ui.getCore().byId(p.sFocusId);if(f){f.applyFocusInfo(p.oFocusInfo);}else{var e=q.sap.domById(p.sFocusId)||p.oFocusedElement;q.sap.focus(e);}}};P.prototype.setContent=function(c){this.oContent=c;return this;};P.prototype.getContent=function(){return this.oContent;};P.prototype.setPosition=function(m,b,o,c,d){this._oPosition=this._createPosition(m,b,o,c,d);if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){this._applyPosition(this._oPosition);this._oBlindLayer&&this._oBlindLayer.update(this._$());}return this;};P.prototype._createPosition=function(m,b,o,c,d){var n=false;if(m&&(m.indexOf("+")>=0||m.indexOf("-")>=0)){n=true;if(c&&c!="0 0"){q.sap.log.warning("offset used in my and in offset, the offset value will be ignored","sap.ui.core.Popup","setPosition");}c=null;}var p=q.extend({},this._oDefaultPosition,{"my":m||this._oDefaultPosition.my,"at":b||this._oDefaultPosition.at,"of":o,"offset":c,"collision":d});if(!q.ui.version){if(P._bNewOffset==null){P._bNewOffset=true;var $=q(document.createElement("div"));$.position({of:window,using:function(g,h){P._bNewOffset=(h!==undefined);}});}}var e=[];var f=[];if(P._bNewOffset||q.sap.Version(q.ui.version).compareTo("1.8.23")>0){if(c&&c!="0 0"){e=p.my.split(" ");f=c.split(" ");var s=[parseInt(f[0],10)<0?"":"+",parseInt(f[1],10)<0?"":"+"];p.my=e[0]+s[0]+f[0]+" "+e[1]+s[1]+f[1];p.offset=null;}}else if(n){e=p.my.split(" ");f=["",""];var i=e[0].indexOf("+");if(i<0){i=e[0].indexOf("-");}if(i>=0){f[0]=e[0].slice(i);e[0]=e[0].slice(0,i);}i=e[1].indexOf("+");if(i<0){i=e[1].indexOf("-");}if(i>=0){f[1]=e[1].slice(i);e[1]=e[1].slice(0,i);}p.my=e[0]+" "+e[1];p.offset=f[0]+" "+f[1];}return p;};P.prototype._getPositionOffset=function(){var o=[];if(this._oPosition.my&&(this._oPosition.my.indexOf("+")>=0||this._oPosition.my.indexOf("-")>=0)){var m=this._oPosition.my.split(" ");var i=m[0].indexOf("+");if(i<0){i=m[0].indexOf("-");}if(i>=0){o[0]=m[0].slice(i);}i=m[1].indexOf("+");if(i<0){i=m[1].indexOf("-");}if(i>=0){o[1]=m[1].slice(i);}}else if(this._oPosition.offset){o=this._oPosition.offset.split(" ");}return o;};P.prototype._applyPosition=function(p){var b=sap.ui.getCore().getConfiguration().getRTL();var $=this._$();if($.length){var A=p.at;var d=$.get(0);if(typeof(A)==="string"){d.style.display="block";d.style.left="";d.style.right="";$.position(this._resolveReference(this._convertPositionRTL(p,b)));this._fixPositioning(p,b);}else if(sap.ui.core.CSSSize.isValid(A.left)&&sap.ui.core.CSSSize.isValid(A.top)){$.css({"left":A.left,"top":A.top});}else if(sap.ui.core.CSSSize.isValid(A.right)&&sap.ui.core.CSSSize.isValid(A.top)){$.css({"right":A.right,"top":A.top});}else if(typeof(A.left)==="number"&&typeof(A.top)==="number"){var c=$[0];if(c&&c.style.right){var w=$.outerWidth();$.css({"right":(document.documentElement.clientWidth-(A.left+w))+"px","top":A.top+"px"});}else{$.css({"left":A.left+"px","top":A.top+"px"});}}this._oLastPosition=p;this._oLastOfRect=this._calcOfRect(p.of);}};P.prototype._calcOfRect=function(o){var b=this._getOfDom(o);if(b){return q(b).rect();}return null;};P.prototype._getOfDom=function(o){if(o instanceof q.Event){return null;}var $;if(typeof(o)==="string"){$=q.sap.byId(o);}else if(o instanceof q){$=o;}else{$=q(o instanceof E?o.getDomRef():o);}return $[0];};P.prototype._convertPositionRTL=function(p,b){var f=q.extend({},p);if(b){var n=false;if(f.my&&(f.my.indexOf("+")>=0||f.my.indexOf("-")>=0)){n=true;}if((f.offset||n)&&((f.my.indexOf("begin")>-1)||(f.my.indexOf("end")>-1))&&((f.at.indexOf("begin")>-1)||(f.at.indexOf("end")>-1))){if(n){var m=f.my.split(" ");if(m.length==2){f.my="";if(m[0]){if(m[0].indexOf("begin")>-1||m[0].indexOf("end")>-1){if(m[0].indexOf("+")>-1){m[0]=m[0].replace("+","-");}else if(m[0].indexOf("-")>-1){m[0]=m[0].replace("-","+");}}f.my=m[0];}if(m[1]){if(m[1].indexOf("begin")>-1||m[1].indexOf("end")>-1){if(m[1].indexOf("+")>-1){m[1]=m[1].replace("+","-");}else if(m[1].indexOf("-")>-1){m[1]=m[1].replace("-","+");}}if(m[0]){f.my=f.my+" ";}f.my=f.my+m[1];}}}else{f.offset=this._mirrorOffset(f.offset);}}f.my=f.my.replace("begin","right").replace("end","left");f.at=f.at.replace("begin","right").replace("end","left");}else{f.my=f.my.replace("end","right").replace("begin","left");f.at=f.at.replace("end","right").replace("begin","left");}return f;};P.prototype._mirrorOffset=function(o){var b=q.trim(o).split(/\s/);var p=parseInt(b[0],10);return(-p)+" "+b[b.length-1];};P.prototype._fixPositioning=function(p,b){var m=p.my;var $=this._$();var c=0;if(typeof(m)==="string"){if(b&&((m.indexOf("right")>-1)||(m.indexOf("begin")>-1)||(m.indexOf("center")>-1))){$=this._$();c=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":c+"px","left":""});}else if((m.indexOf("right")>-1)||(m.indexOf("end")>-1)){$=this._$();c=q(window).width()-$.outerWidth()-$.offset().left;$.css({"right":c+"px","left":""});}}};P.prototype._resolveReference=function(p){var o=p;if(p.of instanceof E){o=q.extend({},p,{of:p.of.getDomRef()});}return o;};P.prototype.setShadow=function(s){this._bShadow=s;if(this.eOpenState!=sap.ui.core.OpenState.CLOSED){this._$().toggleClass("sapUiShd",s);}return this;};P.prototype.setModal=function(m,s){var o=this._bModal;this._bModal=m;this._sModalCSSClass=s;if(this.isOpen()){if(o!==m){if(m){this._showBlockLayer();}else{this._hideBlockLayer();}if(this.touchEnabled&&this._bAutoClose){if(!m){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}}return this;};P.prototype.getModal=function(){return this._bModal;};P.prototype.setNavigationMode=function(m){if(m!="NONE"&&m!="DOCK"&&m!="SCOPE"){this._sF6NavMode="NONE";}this._sF6NavMode=m;};P.prototype.setAutoClose=function(A){if(this.touchEnabled&&this.isOpen()&&this._bAutoClose!==A){if(!this._bModal){if(A){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}else{q(document).off("touchstart mousedown",this._fAutoCloseHandler);}}}this._bAutoClose=A;return this;};P.prototype.setAutoCloseAreas=function(A){if(!this._aAutoCloseAreas){this._aAutoCloseAreas=[];}var c=function(e){return{onBeforeRendering:function(){var f=o.getDomRef();if(f&&this.isOpen()){if(D.browser.msie){q(f).unbind("deactivate."+this._popupUID,this.fEventHandler);}else{f.removeEventListener("blur",this.fEventHandler,true);}}},onAfterRendering:function(){var f=o.getDomRef();if(f&&this.isOpen()){if(D.browser.msie){q(f).bind("deactivate."+this._popupUID,this.fEventHandler);}else{f.addEventListener("blur",this.fEventHandler,true);}}}};};var s,o,d,b;for(var i=0,l=A.length;i<l;i++){o=A[i];if(o instanceof E){s=o.getId();}else if(typeof o==="object"){s=o.id;}else if(typeof o==="string"){s=o;}if(this.getChildPopups().indexOf(s)===-1){this.addChildPopup(s);b={id:s};if(o instanceof E){d=c(o);o.addEventDelegate(d,this);b.delegate=d;}this._aAutoCloseAreas.push(b);}}return this;};P.prototype.setAnimations=function(o,c){if(o&&(typeof(o)=="function")){this._animations.open=o;}if(c&&(typeof(c)=="function")){this._animations.close=c;}return this;};P.prototype.setDurations=function(o,c){if((o>0)||(o===0)){this._durations.open=o;}if((c>0)||(c===0)){this._durations.close=c;}return this;};P.CLOSE_ON_SCROLL="close_Popup_if_of_is_moved";P.prototype._fnCloseOnScroll=function(e){this.close();};P.prototype.setFollowOf=function(f){P.DockTrigger.removeListener(P.checkDocking,this);var u=false;this._bFollowOf=true;this._followOfHandler=null;if(typeof(f)==="function"){this._followOfHandler=f;u=true;}else if(typeof(f)==="boolean"){u=f;}else if(f===P.CLOSE_ON_SCROLL){this._followOfHandler=this._fnCloseOnScroll;u=true;}else{this._bFollowOf=false;if(f!==null){q.sap.log.error("Trying to set an invalid type to 'followOf: "+f);}}if(u&&this._oLastPosition){this._oLastOfRect=this._calcOfRect(this._oLastPosition.of);}if(this._bFollowOf&&this.getOpenState()===sap.ui.core.OpenState.OPEN){P.DockTrigger.addListener(P.checkDocking,this);}};P.prototype.getAutoClose=function(){return this._bAutoClose;};P.prototype.getFollowOf=function(){if(this._bFollowOf){return typeof(this._followOfHandler)==="function"?this._followOfHandler:true;}return false;};P.prototype.isOpen=function(){return this.bOpen;};P.prototype.getOpenState=function(){return this.eOpenState;};P.prototype.destroy=function(){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}this.close(0);this.oContent=null;if(this._bFollowOf){this.setFollowOf(null);}if(this._bEventBusEventsRegistered){this._unregisterEventBusEvents();}if(this._iTopShieldRemoveTimer){q.sap.clearDelayedCall(this._iTopShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oTopShieldLayer);this._oTopShieldLayer=null;this._iTopShieldRemoveTimer=null;}if(this._iBottomShieldRemoveTimer){q.sap.clearDelayedCall(this._iBottomShieldRemoveTimer);this.oShieldLayerPool.returnObject(this._oBottomShieldLayer);this._oBottomShieldLayer=null;this._iBottomShieldRemoveTimer=null;}if(this._aAutoCloseAreas){var e;this._aAutoCloseAreas.forEach(function(A){if(A.delegate){e=q.sap.byId(A.id).control(0);if(e){e.removeEventDelegate(A.delegate);}}});}M.prototype.destroy.apply(this,arguments);};P.prototype.exit=function(){delete this._mEvents;};P.prototype._addFocusEventListeners=function(c,e,o){if(!this.fEventHandler){this.fEventHandler=q.proxy(this.onFocusEvent,this);}var p=this._$();var b=this.getChildPopups();var d={};var i=0,l=0;if(p.length){if(document.addEventListener&&!D.browser.msie){document.addEventListener("focus",this.fEventHandler,true);p.get(0).addEventListener("blur",this.fEventHandler,true);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){d.addEventListener("blur",this.fEventHandler,true);}}}else{q(document).bind("activate."+this._popupUID,this.fEventHandler);p.bind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){q(d).bind("deactivate."+this._popupUID,this.fEventHandler);}}}}};P.prototype._removeFocusEventListeners=function(c,e,o){var p=this._$(false,true);if(!p.length){return;}var b=this.getChildPopups();var d={};var i=0,l=0;if(document.removeEventListener&&!D.browser.msie){document.removeEventListener("focus",this.fEventHandler,true);p.get(0).removeEventListener("blur",this.fEventHandler,true);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){d.removeEventListener("blur",this.fEventHandler,true);}this.closePopup(b[i]);}}else{q(document).unbind("activate."+this._popupUID,this.fEventHandler);p.unbind("deactivate."+this._popupUID,this.fEventHandler);for(i=0,l=b.length;i<l;i++){d=q.sap.domById(b[i]);if(d){q(d).unbind("deactivate."+this._popupUID,this.fEventHandler);}}}this.fEventHandler=null;};P.prototype._activateFocusHandle=function(){if(this._bModal||this._bAutoClose){this._addFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).on("touchstart mousedown",q.proxy(this._fAutoCloseHandler,this));}};P.prototype._deactivateFocusHandle=function(){if(this.fEventHandler){this._removeFocusEventListeners();}if(this.touchEnabled&&!this._bModal&&this._bAutoClose){q(document).off("touchstart mousedown",this._fAutoCloseHandler);}};P.prototype._registerEventBusEvents=function(c,e,o){var t=this;q.each(t._mEvents,function(s,l){sap.ui.getCore().getEventBus().subscribe("sap.ui",s,l,t);});this._bEventBusEventsRegistered=true;};P.prototype._unregisterEventBusEvents=function(c,e,o){var t=this;q.each(t._mEvents,function(s,l){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",s,l,t);});delete this._bEventBusEventsRegistered;};P.prototype._addFocusableArea=function(c,e,o){if(this.getChildPopups().indexOf(o.id)===-1){this.addChildPopup(o.id);}};P.prototype._removeFocusableArea=function(c,e,o){this.removeChildPopup(o.id);};P.prototype._closePopup=function(c,e,o){this.close(typeof this._durations.close==="string"?0:this._durations.close);};P.prototype._setIdentity=function($){if(typeof $==="object"){$.attr("data-sap-ui-popup",this._popupUID);}else{q.sap.log.warning("Incorrect DomRef-type for 'setIdentity': "+$,this);return;}if(!this._bEventBusEventsRegistered){this._registerEventBusEvents();}};P.prototype._$=function(f,g){var c;if(this.oContent instanceof C){c=this.oContent.$();if(f||(c.length===0&&!g)){q.sap.log.info("Rendering of popup content: "+this.oContent.getId());if(c.length>0){R.preserveContent(c[0],true,false);}sap.ui.getCore().getRenderManager().render(this.oContent,sap.ui.getCore().getStaticAreaRef());c=this.oContent.$();}}else if(this.oContent instanceof E){c=this.oContent.$();}else{c=q(this.oContent);}this._setIdentity(c);return c;};P.prototype._showBlockLayer=function(){var b=q("#sap-ui-blocklayer-popup"),c="sapUiBLy"+(this._sModalCSSClass?" "+this._sModalCSSClass:"");if(b.length===0){b=q('<div id="sap-ui-blocklayer-popup" tabindex="0" class="'+c+'"></div>');b.appendTo(sap.ui.getCore().getStaticAreaRef());}else{b.removeClass().addClass(c);}P.blStack.push({zIndex:this._iZIndex-2,popup:this});b.css({"z-index":this._iZIndex-2,"visibility":"visible"}).show();q("html").addClass("sapUiBLyBack");};P.prototype._hideBlockLayer=function(){P.blStack.pop();var $=q("#sap-ui-blocklayer-popup");if($.length){var b=$.get(0);if(P.blStack.length>0){b.style.zIndex=P.blStack[P.blStack.length-1].zIndex;b.style.visibility="visible";b.style.display="block";}else{b.style.visibility="hidden";b.style.display="none";q("html").removeClass("sapUiBLyBack");}}};P.prototype._isFocusInsidePopup=function(){var d=this._$(false).get(0);if(d&&q.sap.containsOrEquals(d,document.activeElement)){return true;}return false;};P.DockTrigger=new I(200);P.checkDocking=function(){if(this.getOpenState()===sap.ui.core.OpenState.OPEN){var c=this._getOfDom(this._oLastPosition.of),o=q(c).rect();if(!o){this.close();return;}else if(o.left===0&&o.top===0&&o.height===0&&o.height===0&&this._oLastPosition.of.id){this._oLastPosition.of=q.sap.domById(this._oLastPosition.of.id);c=this._getOfDom(this._oLastPosition.of);o=q(c).rect();if(!o){this.close();return;}}if(!q.sap.containsOrEquals(document.documentElement,c)){if(c.id&&c.id!==""){var n=q.sap.domById(c.id);var N=q(n).rect();if(N&&!r(o,N)){o=N;delete this._oLastPosition.of;this._oLastPosition.of=n;}}}if(this._oLastOfRect){if(!r(this._oLastOfRect,o)){if(this._followOfHandler){var l=q.extend(true,{},this._oLastPosition),L=q.extend(true,{},this._oLastOfRect);this._followOfHandler({lastPosition:l,lastOfRect:L,currentOfRect:o});}else{this._applyPosition(this._oLastPosition);}}}}};P.prototype.ontouchstart=function(e){this.onmousedown(e,true);this._bMousedownCalled=true;};P.prototype.onmousedown=function(e,s){if(this._bMousedownCalled&&!s){this._bMousedownCalled=false;return;}if(this._iZIndex===this.getLastZIndex()||this.getModal()){return;}this._increaseMyZIndex("","mousedown",e);};P.prototype._increaseMyZIndex=function(c,e,o){var p=this.getParentPopup(this._oLastPosition.of);if(o&&o.type==="mousedown"||o&&o.isFromParentPopup||p.length===0){this._iZIndex=this.getNextZIndex();var $=this._$(false,true);$.css("z-index",this._iZIndex);if(this._oBlindLayer){this._oBlindLayer.update($,this._iZIndex-1);}if(o&&!o.type||o&&o.type!="mousedown"||e==="mousedown"){var b=this.getChildPopups();for(var i=0,l=b.length;i<l;i++){this.increaseZIndex(b[i],true);}}}else if(p.length>0){var s=q(p.get(0)).attr("data-sap-ui-popup");this.increaseZIndex(s,false);}};P.prototype.onAfterRendering=function(e){var c=this.getContent();var $=c instanceof E?c.$():q(c);$.toggleClass("sapUiShd",this._bShadow);$.css("position","absolute");this._setIdentity($);var b=$[0];var l=b.style.left;var d=b.style.right;var t=b.style.top;var f=b.style.bottom;if(!(l&&l!="auto"||d&&d!="auto"||t&&t!="auto"||f&&f!="auto")){q.sap.log.debug("reposition popup content "+$.attr("id")+" at "+(window.JSON?JSON.stringify(this._oLastPosition.at):String(this._oLastPosition.at)));this._applyPosition(this._oLastPosition);}$.show().css({"visibility":"visible","z-index":this._iZIndex});if(this._oBlindLayer){this._resizeListenerId=a.register(this._$().get(0),q.proxy(this.onresize,this));}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._addFocusEventListeners();}this._$(false,true).on("keydown",q.proxy(this._F6NavigationHandler,this));};P.prototype.onBeforeRendering=function(e){if(this._resizeListenerId){a.deregister(this._resizeListenerId);this._resizeListenerId=null;}if(this.isOpen()&&(this.getModal()||this.getAutoClose())){this._removeFocusEventListeners();}this._$(false,true).off("keydown",this._F6NavigationHandler);};P.prototype.onresize=function(e){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED&&this._oBlindLayer){var t=this;setTimeout(function(){t._updateBlindLayer();},0);}};P.prototype._updateBlindLayer=function(){if(this.eOpenState!=sap.ui.core.OpenState.CLOSED&&this._oBlindLayer){this._oBlindLayer.update(this._$(false,true));}};P.prototype.isInPopup=function(t){var p=this.getParentPopup(t);return p&&p.length>0;};P.prototype.getParentPopup=function(t){var T=t?t:this;var $=q(T instanceof E?T.getDomRef():T);return $.closest("[data-sap-ui-popup]");};P.prototype.getParentPopupId=function(t){var p=this.getParentPopup(t);return p.attr("data-sap-ui-popup");};P.prototype.addChildToPopup=function(p,c){var e="sap.ui.core.Popup.addFocusableContent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{id:c});};P.prototype.removeChildFromPopup=function(p,c){var e="sap.ui.core.Popup.removeFocusableContent-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{id:c});};P.prototype.closePopup=function(p){var e="sap.ui.core.Popup.closePopup-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e);};P.prototype.increaseZIndex=function(p,i){var e="sap.ui.core.Popup.increaseZIndex-"+p;sap.ui.getCore().getEventBus().publish("sap.ui",e,{isFromParentPopup:i?i:false});};P.prototype.focusTabChain=function(p){var s=p.event.target,n=p.that.getMetadata().getName(),f;if((!p.$FocusablesContent||!p.$FocusablesFooter)||(!p.$FocusablesContent.length&&!p.$FocusablesFooter.length)){return;}if(s.id===p.firstFocusable){q.sap.log.debug("First dummy focus element was focused","",n);if(p.$FocusablesFooter.length>0){q.sap.log.debug("Last footer element will be focused","",n);f=p.$FocusablesFooter[p.$FocusablesFooter.length-1];}else{q.sap.log.debug("Last content element will be focused","",n);f=p.$FocusablesContent[p.$FocusablesContent.length-1];}}else if(s.id===p.lastFocusable){q.sap.log.debug("Last dummy focus element was focues","",n);if(p.$FocusablesContent.length>0){q.sap.log.debug("First content element will be focused","",n);f=p.$FocusablesContent[0];}else{q.sap.log.debug("First footer element will be focused","",n);f=p.$FocusablesFooter[0];}}if(f){q.sap.delayedCall(0,this,function(){var c=sap.ui.getCore().byId(f.id);if(c instanceof C){q.sap.log.debug("Focus will be handled by "+c.getMetadata().getName(),"",n);}else{q.sap.log.debug("oFocusDomRef will be focused","",n);}q.sap.focus(c?c:f);return c?c.getId():f.id;});}};return P;});
