/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/IconPool','sap/ui/core/library','sap/ui/layout/HorizontalLayout','sap/ui/layout/VerticalLayout','sap/ui/layout/form/SimpleForm','sap/ui/layout/form/SimpleFormLayout','sap/ui/commons/Button','sap/ui/commons/CheckBox','sap/ui/commons/FormattedTextView','sap/ui/commons/Label','sap/ui/commons/Link','sap/ui/commons/SegmentedButton','sap/ui/commons/TextArea','sap/ui/commons/TextView','sap/ui/ux3/ToolPopup'],function(q,I,c,H,V,S,a,B,C,F,L,b,d,T,e,f){"use strict";var g=c.ValueState;var h=function(){};h.prototype.updateFeedbackContextText=function(){if(this._oIncludeFeedbackContextCB.getChecked()){u.call(this);}else{i.call(this);}function u(){this._oFeedbackContextText.setText("Location: "+this._getCurrentPageRelativeURL()+"\n"+this._getUI5Distribution()+" Version: "+sap.ui.getVersionInfo().version);}function i(){this._oFeedbackContextText.setText(this._getUI5Distribution()+" Version: "+sap.ui.getVersionInfo().version);}};h.prototype._getUI5Distribution=function(){var v=sap.ui.getVersionInfo();var u="SAPUI5";if(v&&v.gav&&/openui5/i.test(v.gav)){u="OpenUI5";}return u;};h.prototype._getCurrentPageRelativeURL=function(){var p=window.location;return p.pathname+p.hash+p.search;};h.prototype.createFeedbackPopup=function(){this._oFeedbackContextText=new e("oFeedbackContextText");this._oIncludeFeedbackContextCB=new C("includePageCB");var t=this;var o=q.sap.loadResource('sap/ui/demokit/configuration/properties.json');var s=o["FeedbackServiceURL"];var i='Describe what you like or what needs to be improved. You can share your feedback for the overall Demokit experience or for the specific page you are currently viewing.';var j,k,l,m,r,n,p,u,v,w;function x(Q){z();Q.addContent(v);j.removeAllContent();j.addContent(Q);}function y(){j.setBusyIndicatorDelay(0);j.setBusy(true);p.setValueState(g.None);p.setPlaceholder(i);}function z(){j.setBusy(false);m.setText("");n.setSelectedButton();p.setValue('');t._oIncludeFeedbackContextCB.setChecked(false);t._oIncludeFeedbackContextCB.fireChange();t._oFeedbackContextText.setVisible(false);u.setText("Show context data");u.setTooltip("Show context data");w.setEnabled(false);}function A(){I.addIcon("icon-face-very-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E086",suppressMirroring:true});I.addIcon("icon-face-bad","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E087",suppressMirroring:true});I.addIcon("icon-face-neutral","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E089",suppressMirroring:true});I.addIcon("icon-face-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08B",suppressMirroring:true});I.addIcon("icon-face-very-happy","FeedbackRatingFaces",{fontFamily:"FeedbackRatingFaces",content:"E08C",suppressMirroring:true});}function D(){var R=new F("feedbackRateYourExperienceLabel");R.setHtmlText("<span class='feedbackAsterisk'>*</span>Rate your experience:");m=new L("feedbackRatingLabel",{});return new H('feedbackRatingHeader',{content:[R,m]});}function E(){A();n=new d({id:"feedbackRatingButton",buttons:[Q("icon-face-very-bad","Very Poor",1),Q("icon-face-bad","Poor",2),Q("icon-face-neutral","Average",3),Q("icon-face-happy","Good",4),Q("icon-face-very-happy","Excellent",5)]});function Q(U,W,X){var Y="sap-icon://FeedbackRatingFaces/"+U;return new B({icon:Y,width:"20%",press:R.bind(this,W,X)});}function R(U,W){m.setText(U);r=W;w.setEnabled(true);}return n;}function G(){p=new T("demokitFeedbackInput",{rows:13});p.setPlaceholder(i);return p;}function J(){t._oIncludeFeedbackContextCB.setText('Feedback is related to the current page');t._oIncludeFeedbackContextCB.attachChange(t.updateFeedbackContextText.bind(t));u=new b("feedbackContextDataLink",{wrapping:"false",text:"Show context data",tooltip:"Show context data",press:function(){if(t._oFeedbackContextText.getVisible()===false){u.setText("Hide context data");u.setTooltip("Hide context data");t._oFeedbackContextText.setVisible(true);}else{u.setText("Show context data");u.setTooltip("Show context data");t._oFeedbackContextText.setVisible(false);}}});return new H("feedbackContextButtons",{content:[t._oIncludeFeedbackContextCB,u]});}function K(){t._oFeedbackContextText.addStyleClass("feedbackContextData");t._oFeedbackContextText.setVisible(false);t.updateFeedbackContextText();return t._oFeedbackContextText;}function M(){var Q=new b({text:"Privacy",tooltip:"Privacy",target:"_blank",href:"https://help.hana.ondemand.com/privacy.htm"});var R=new b({text:"Terms of Use",tooltip:"Terms of Use",target:"_blank",href:"https://help.hana.ondemand.com/terms_of_use.html"});var U=new b({text:"Legal Agreement",tooltip:"Legal Agreement",target:"_blank",href:"./legal_agreement_with_privacy.html"});var W=new F();var X='Your feedback is anonymous, we do not collect any personal data. For more information see <embed data-index=\"0\">, <embed data-index=\"1\"> & <embed data-index=\"2\">.';W.addStyleClass("feedbackLicenseText");W.setHtmlText(X);W.addControl(Q);W.addControl(R);W.addControl(U);return W;}function N(){var Q=new B({text:"Cancel",tooltip:"Cancel",press:function(){z();j.close();}});v=new B('closeBtn',{text:"Close",tooltip:"Close",press:function(){j.close();}});w=new B('sendBtn',{text:"Send",tooltip:"Send feedback",enabled:false,press:function(){var R={};if(t._oIncludeFeedbackContextCB.getChecked()){R={"texts":{"t1":p.getValue()},"ratings":{"r1":{"value":r}},"context":{"page":t._getCurrentPageRelativeURL(),"attr1":t._getUI5Distribution()+":"+sap.ui.version}};}else{R={"texts":{"t1":p.getValue()},"ratings":{"r1":{"value":r}},"context":{"attr1":t._getUI5Distribution()+":"+sap.ui.version}};}y();q.ajax({url:s,type:"POST",contentType:"application/json",data:JSON.stringify(R)}).done(function(){x(k);}).fail(function(){x(l);});}});k=new V({content:[new F('successMsg',{htmlText:'<h4>Your feedback was sent successfully.</h4>'})]});l=new V({content:[new F('errorMsg',{htmlText:'<h4>Your feedback was not sent.</h4>'})]});return new H('feedbackButtons',{content:[w,Q]});}var O=new S({maxContainerCols:1,width:'400px',editable:true,layout:a.ResponsiveGridLayout,content:[new L({text:'Send us your feedback!'}),D(),E(),G(),J(),K(),M(),N()]});var P="theme/img/themeswitch_";j=new f('feedBackPopup',{icon:'sap-icon://comment',iconHover:P+'hover.png',iconSelected:P+'selected.png',content:[O],defaultButton:w,closed:function(){this.removeAllContent();this.addContent(O);}});j.setTooltip("Send us your feedback!");return j;};return h;});
