/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","sap/ui/core/Component","sap/ui/core/UIComponent","sap/ui/core/routing/History","sap/ui/model/json/JSONModel","sap/ui/demokit/EntityInfo","sap/ui/demokit/util/JSDocUtil","../util/ObjectSearch","../util/ToggleFullScreenHandler","../data","sap/ui/demokit/explored/view/base.controller"],function(q,D,C,U,H,J,E,a,O,T,d,B){"use strict";return B.extend("sap.ui.demokit.explored.view.entity",{descriptionText:function(t){var h;if(t){h="<span>"+t+"</span>";}return h;},onInit:function(){this.router=U.getRouterFor(this);this.router.attachRoutePatternMatched(this.onRouteMatched,this);this._component=C.getOwnerComponentFor(this.getView());this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);this.getView().addEventDelegate({onBeforeFirstShow:q.proxy(this._applyViewConfigurations,this)});},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onTypeLinkPress:function(e){var t=e.getSource().data("type");this.router.navTo("entity",{id:t,part:"samples"},false);this._component.getEventBus().publish("app","selectEntity",{id:t});},onJSDocLinkClick:function(e){var t=e.target.getAttribute("data-sap-ui-target");if(t&&t.indexOf('#')>=0){t=t.slice(0,t.indexOf('#'));}if(t){this.router.navTo("entity",{id:t,part:"samples"},false);this._component.getEventBus().publish("app","selectEntity",{id:t});e.preventDefault();}},onIntroLinkPress:function(e){var p=document.location.pathname.split("/"),b=document.location.origin+p.splice(0,p.length-1).join("/")+"/";window.open(b+this.getView().getModel().getProperty("/docuLink"),"_blank");},onTabSelect:function(e){var t=e.getParameter("key");this.router.navTo("entity",{id:this._sId,part:t},true);},onNavBack:function(e){this.router.myNavBack("home",{});},onNavToSample:function(e){var p=e.getSource().getBindingContext("entity").getPath();var s=this.getView().getModel("entity").getProperty(p);this.router.navTo("sample",{id:s.id});},_TAB_KEYS:["samples","about","properties","aggregations","associations","events","methods"],onRouteMatched:function(e){var r=e.getParameter("name"),n=e.getParameter("arguments").id,N=e.getParameter("arguments").part;if(r!=="entity"){return;}var o=this.getView().getModel("entity");var p=O.getEntityPath(o.getData(),n);var b=(p)?o.getProperty(p):null;var c=!!p;var h=H.getInstance();var P=h.getPreviousHash();var s=D.system.phone||(!c&&!!P);this.getView().byId("page").setShowNavButton(s);var m,f;if(this._sId!==n){var g=E.getEntityDocu(n);if(!b&&!g){this.router.myNavToWithoutHash("sap.ui.demokit.explored.view.notFound","XML",false,{path:n});return;}f=this._getViewData(n,g,b);m=new J(f);this.getView().setModel(m);this.getView().bindElement("entity>"+p);this._sId=n;}else{m=this.getView().getModel();m.refresh(true);f=m.getData();}if(this._TAB_KEYS.indexOf(N)===-1){N="samples";}if(!f.show[N]){N="samples";}var t=this.getView().byId("tabBar");if(N!==t.getSelectedKey()&&t.getExpanded()){t.setSelectedKey(N);}},onToggleFullScreen:function(e){T.updateMode(e,this.getView());},_getViewData:function(i,o,e){var b=this._convertEntityInfo(i,o),s=false,S=0;if(e){if(!b.shortDescription&&e.description){b.shortDescription=e.description;}if(e.docuLink){b.show.introLink=true;b.docuLink=e.docuLink;}s=e.samples.length>0;S=e.samples.length;}b.show.samples=s;b.count.samples=S;return b;},_convertEntityInfo:function(I,o){var b={name:I,deprecated:(o)?this._formatDeprecated(o.deprecation):null,deprecatedMark:(o)?this._createDeprecatedMark(o.deprecation):null,baseType:(o)?this._formatType(o.baseType):null,baseTypeText:(o)?this._formatTypeText(o.baseType):"-",baseTypeNav:(o)?this._formatTypeNav(o.baseType):null,shortDescription:(o)?this._formatDeprecatedDescription(o.deprecation):null,description:(o)?this._wrapInSpanTag(o.doc):null,docuLink:null,properties:[],events:[],methods:[],aggregations:[],associations:[],values:[],show:{baseType:(o)?!!o.baseType:false,about:!!o,properties:false,events:false,methods:false,aggregations:false,associations:false,values:false,introActive:false},count:{properties:0,events:0,methods:0,aggregations:0,associations:0},appComponent:this._takeControlComponent(I)};var m=0,e=0;var s=I.slice(I.lastIndexOf('.')+1);if(!o){return b;}var k=null;for(k in o.properties){if(o.properties.hasOwnProperty(k)&&k.indexOf("_")!==0){var P=o.properties[k];P.name=k;P.deprecatedDescription=this._formatDeprecatedSinceDescription(P.deprecation,P.deprecationSince);P.deprecated=this._formatDeprecated(P.deprecation);P.doc=this._wrapInSpanTag(P.doc);P.typeText=this._formatTypeText(P.type);P.typeNav=this._formatTypeNav(P.type);P.type=this._formatType(P.type);P.defaultValue=(P.defaultValue)?String(P.defaultValue).replace("empty/undefined","-"):"";b.properties.push(P);}}for(k in o.events){if(o.events.hasOwnProperty(k)&&k.indexOf("_")!==0){var c=o.events[k];c.name=k;c.deprecatedDescription=this._formatDeprecatedDescription(c.deprecation);c.deprecated=this._formatDeprecated(c.deprecation);c.doc=this._wrapInSpanTag(c.doc);b.events.push(c);e++;for(var p in c.parameters){if(c.parameters.hasOwnProperty(p)&&p.indexOf("_")!==0){b.events.push({param:p,since:c.parameters[p].since,typeText:this._formatTypeText(c.parameters[p].type),typeNav:this._formatTypeNav(c.parameters[p].type),type:this._formatType(c.parameters[p].type),doc:this._wrapInSpanTag(c.parameters[p].doc),deprecatedDescription:this._formatDeprecatedDescription(c.parameters[p].deprecation),deprecated:this._formatDeprecated(c.parameters[p].deprecation)});}}}}for(k in o.methods){if(o.methods.hasOwnProperty(k)&&k.indexOf("_")!==0&&!o.methods[k].synthetic){var M=o.methods[k];M.name=o.methods[k].static?s+"."+k:k;M.deprecatedDescription=this._formatDeprecatedDescription(M.deprecation);M.deprecated=this._formatDeprecated(M.deprecation);M.doc=this._wrapInSpanTag(M.doc);M.param="returnValue";M.typeText=this._formatTypeText(M.type);M.typeNav=this._formatTypeNav(M.type);M.type=this._formatType(M.type);b.methods.push(M);m++;for(var i=0;i<M.parameters.length;i++){var f=M.parameters[i].name;if(f.indexOf("_")!==0){b.methods.push({param:f,since:M.parameters[i].since,typeText:this._formatTypeText(M.parameters[i].type),typeNav:this._formatTypeNav(M.parameters[i].type),type:this._formatType(M.parameters[i].type),doc:this._wrapInSpanTag(M.parameters[i].doc),deprecatedDescription:this._formatDeprecatedDescription(M.parameters[i].deprecation),deprecated:this._formatDeprecated(M.parameters[i].deprecation)});}}}}for(k in o.aggregations){var A=o.aggregations[k];var n=(!A.hasOwnProperty("visibility")||A.visibility!=="hidden");if(o.aggregations.hasOwnProperty(k)&&k.indexOf("_")!==0&&n){A.name=k;A.deprecated=this._formatDeprecated(A.deprecation);A.deprecatedDescription=this._formatDeprecatedDescription(A.deprecation);A.doc=this._wrapInSpanTag(A.doc);A.typeText=this._formatTypeText(A.type);A.typeNav=this._formatTypeNav(A.type);A.type=this._formatType(A.type);b.aggregations.push(A);}}for(k in o.associations){if(o.associations.hasOwnProperty(k)&&k.indexOf("_")!==0){var g=o.associations[k];g.name=k;g.deprecatedDescription=this._formatDeprecatedDescription(g.deprecation);g.deprecated=this._formatDeprecated(g.deprecation);g.doc=this._wrapInSpanTag(g.doc);g.typeText=this._formatTypeText(g.type);g.typeNav=this._formatTypeNav(g.type);g.type=this._formatType(g.type);b.associations.push(g);}}for(k in o.values){if(o.values.hasOwnProperty(k)&&k.indexOf("_")!==0){var v=o.values[k];v.name=k;v.deprecatedDescription=this._formatDeprecatedDescription(v.deprecation);v.deprecated=this._formatDeprecated(v.deprecation);b.values.push(v);}}b.show.properties=b.properties.length>0;b.show.events=e>0;b.show.methods=m>0;b.show.aggregations=b.aggregations.length>0;b.show.associations=b.associations.length>0;b.show.values=b.values.length>0;b.count.properties=b.properties.length;b.count.events=e;b.count.methods=m;b.count.aggregations=b.aggregations.length;b.count.associations=b.associations.length;return b;},_wrapInSpanTag:function(t){return'<span class="fs0875">'+a.formatTextBlock(t,{linkFormatter:function(b,c){var p;b=b.trim().replace(/\.prototype\./g,"#");p=b.indexOf("#");if(p===0){return"<code>"+b.slice(1)+"</code>";}if(p>0){c=c||b;b=b.slice(0,p);}return"<a class=\"jsdoclink\" href=\"#\" data-sap-ui-target=\""+b+"\">"+(c||b)+"</a>";}})+'</span>';},_formatDeprecated:function(s){return(s&&s.length>0)?"true":"false";},_formatDeprecatedDescription:function(s){return(this._isDeprecated(s))?(this._createDeprecatedMark(s)+": "+s):null;},_formatDeprecatedSinceDescription:function(s,b){return(this._isDeprecated(s))?(this._createDeprecatedSinceMark()+" "+b+": "+s):null;},_isDeprecated:function(s){return(s&&s.length>0);},_formatType:function(t){if(!t){return null;}else{return t.replace("[]","");}},_formatTypeText:function(t){if(!t){return null;}else{t=t.replace("sap.ui.core.","");var i=t.lastIndexOf(".");return(i!==-1)?t.substr(i+1):t;}},_createDeprecatedMark:function(s){return(s)?this._getI18nModel().getProperty("deprecated"):"";},_createDeprecatedSinceMark:function(){return this._getI18nModel().getProperty("deprecatedSince");},_getI18nModel:function(){return this.getView().getModel("i18n");},_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","any","object","function","float","int","boolean","string"],_formatTypeNav:function(t){return this._baseTypes.indexOf(t)===-1;},_takeControlComponent:function(c){var l=d.libComponentInfos;q.sap.require("sap.ui.core.util.LibraryInfo");var L=sap.ui.require("sap/ui/core/util/LibraryInfo");var o=new L();var A=o._getActualComponent(l,c);return A;}});});
