/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/documentation/sdk/controller/BaseController","sap/ui/model/json/JSONModel","sap/ui/documentation/sdk/controller/util/ControlsInfo","sap/ui/documentation/sdk/util/ToggleFullScreenHandler","sap/uxap/ObjectPageSubSection","sap/ui/documentation/sdk/controller/util/JSDocUtil","sap/ui/documentation/sdk/controller/util/APIInfo"],function(q,B,J,C,T,O,a,A){"use strict";return B.extend("sap.ui.documentation.sdk.controller.ApiDetail",{METHOD:'method',EVENT:'event',PARAM:'param',NOT_AVAILABLE:'N/A',NOT_FOUND:'Not found',ANNOTATIONS_LINK:'http://docs.oasis-open.org/odata/odata/v4.0/odata-v4.0-part3-csdl.html',ANNOTATIONS_NAMESPACE_LINK:'http://docs.oasis-open.org/odata/odata/v4.0/errata02/os/complete/vocabularies/',ANNOTATION_DESCRIPTION_STRIP_REGEX:/<i>XML[\s\S].*Example/,_baseTypes:["sap.ui.core.any","sap.ui.core.object","sap.ui.core.function","sap.ui.core.number","sap.ui.core.float","sap.ui.core.int","sap.ui.core.boolean","sap.ui.core.string","sap.ui.core.URI","sap.ui.core.ID","sap.ui.core.void","sap.ui.core.CSSSize","null","any","any[]","array","element","object","object[]","object|object[]","function","float","int","boolean","string","string[]","number","map","promise","undefined"],onInit:function(){this._objectPage=this.byId("apiDetailObjectPage");this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched,this);this._oLibsModel=new J();this._oLibsModel.setSizeLimit(1000000);this.setModel(new J(),"topics");this.setModel(new J(),"constructorParams");this.setModel(new J(),'methods');this.setModel(new J(),'events');this.setModel(new J(),"entity");this.setModel(new J(),"borrowedMethods");this.setModel(new J(),"borrowedEvents");this._objectPage.attachEvent("_sectionChange",function(e){var s=e.getParameter("section").getTitle().toLowerCase(),S=(e.getParameter("subsection")&&e.getParameter("subsection").getTitle()!=='Overview')?e.getParameter("subsection").getTitle():'';if(s==='properties'){s='controlProperties';}if(s==='fields'){s='properties';}this.getRouter().stop();this.getRouter().navTo("apiId",{id:this._sTopicid,entityType:s,entityId:S},true);this.getRouter().initialize(true);},this);},onAfterRendering:function(){this._createMethodsSummary();this._createEventsSummary();this._createAnnotationsSummary();this.getView().attachBrowserEvent("click",this.onJSDocLinkClick,this);},onExit:function(){this.getView().detachBrowserEvent("click",this.onJSDocLinkClick,this);},onToggleFullScreen:function(e){T.updateMode(e,this.getView(),this);},onJSDocLinkClick:function(e){var c=e.target.classList,j=c.contains("jsdoclink"),E;if(!j){return;}if(c.contains("scrollToMethod")){E="methods";}else if(c.contains("scrollToEvent")){E="events";}else{return;}this._scrollToEntity(E,e.target.getAttribute("data-sap-ui-target"));},_onTopicMatched:function(e){var c=this.getOwnerComponent();this._objectPage.setBusy(true);this._sTopicid=e.getParameter("arguments").id;this._sEntityType=e.getParameter("arguments").entityType;this._sEntityId=e.getParameter("arguments").entityId;c.loadVersionInfo().then(c.fetchAPIIndex.bind(c)).then(function(d){var E,f=false,l,i;this._aApiIndex=d;for(i=0,l=d.length;i<l;i++){if(d[i].name===this._sTopicid||d[i].name.indexOf(this._sTopicid)===0){E=d[i];this._oEntityData=E;f=true;break;}}if(f){return A.getLibraryElementsJSONPromise(E.lib).then(function(d){this._aLibsData=d;return Promise.resolve();}.bind(this));}return Promise.reject(this.NOT_FOUND);}.bind(this)).then(function(){var l=this._aLibsData,o,L,i;for(i=0,L=l.length;i<L;i++){if(l[i].name===this._sTopicid){o=l[i];break;}}this._aAllowedMembers=this.getModel("versionData").getProperty("/allowedMembers");this.buildBorrowedModel(o).then(function(d){this.getModel('borrowedMethods').setData(d.methods,false);this.getModel('borrowedEvents').setData(d.events,false);}.bind(this)).then(function(){this._bindData(this._sTopicid);this._bindEntityData(this._sTopicid);this._createMethodsSummary();this._createEventsSummary();this._createAnnotationsSummary();if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}else{this._scrollContentToTop();}q.sap.delayedCall(0,this,function(){this._prettify();this._objectPage.setBusy(false);q.sap.delayedCall(0,this,function(){if(this._sEntityType){this._scrollToEntity(this._sEntityType,this._sEntityId);}});});this.searchResultsButtonVisibilitySwitch(this.getView().byId("apiDetailBackToSearch"));}.bind(this));}.bind(this)).catch(function(r){if(r===this.NOT_FOUND){this._objectPage.setBusy(false);this.getRouter().myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound","XML",false);}}.bind(this));},_prettify:function(){q('pre').addClass('prettyprint');window.prettyPrint();},_createMethodsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-methodsSummary","sap.ui.documentation.sdk.view.ApiDetailMethodsSummary",this),S=this.getView().byId("methods"),b=S.getSubSections(),c=this.getModel("topics").getData(),d=c.hasMethods&&!c.hasOwnMethods;if(b.length>0&&(b[0].getTitle()==="Summary"||b[0].getTitle()==="Methods"||d)){b[0].setTitle(d?"Methods":"Summary");return;}S.insertSubSection(new O({title:d?"Methods":"Summary",blocks:[s]}),0);},_createEventsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-eventsSummary","sap.ui.documentation.sdk.view.ApiDetailEventsSummary",this),S=this.getView().byId("events"),b=S.getSubSections(),c=this.getModel("topics").getData(),d=c.hasEvents&&!c.hasOwnEvents;if(b.length>0&&(b[0].getTitle()==="Summary"||b[0].getTitle()==="Events"||d)){b[0].setTitle(d?"Events":"Summary");return;}S.insertSubSection(new O({title:d?"Events":"Summary",blocks:[s]}),0);},_createAnnotationsSummary:function(){var s=sap.ui.xmlfragment(this.getView().getId()+"-annotationsSummary","sap.ui.documentation.sdk.view.ApiDetailAnnotationsSummary",this);var S=this.getView().byId("annotations");var b=S.getSubSections();if(b.length>0&&b[0].getTitle()==="Summary"){return;}S.insertSubSection(new O({title:"Summary",blocks:[s]}),0);},scrollToMethod:function(e){this._scrollToEntity("methods",e.getSource().getText());},scrollToEvent:function(e){this._scrollToEntity("events",e.getSource().getText());},scrollToAnnotation:function(e){this._scrollToEntity("annotations",e.getSource().getText());},_scrollToEntity:function(s,S){var f,b,o;if(!s){return;}s=s.toLowerCase();o=this.getView().byId(s);if(!o){return;}if(S){S=S.toLowerCase();b=o.getSubSections();f=b.filter(function(c){return c.getTitle().toLowerCase()===S;});if(f.length){this.getRouter().stop();q.sap.delayedCall(0,this,function(){this.getRouter().initialize(true);});this.getView().byId("apiDetailObjectPage").scrollToSection(f[0].getId(),250);}}else{this.getView().byId("apiDetailObjectPage").scrollToSection(o.getId(),250);}},_scrollContentToTop:function(){if(this._objectPage&&this._objectPage.$().length>0){this._objectPage.getScrollDelegate().scrollTo(0,0);}},_bindEntityData:function(t){C.loadData().then(function(c){var e,E=this._getEntitySampleData(t,c);e=q.extend({},this._oEntityData,E);this.getModel("entity").setData(e,false);this._buildHeaderLayout(this.getModel("topics").getData(),e);}.bind(this));},_bindData:function(t){var l=this._aLibsData,c,b=this.getOwnerComponent().getModel("treeData").getData(),d=this._getControlChildren(b,t),m,o={parameters:[]},e,M={methods:[]},f,E={events:[]},u,L,i;for(i=0,L=l.length;i<L;i++){if(l[i].name===this._sTopicid){c=l[i];break;}}if(d){if(!c){c={};}c.controlChildren=d;this._addChildrenDescription(l,c.controlChildren);}u=c['ui5-metadata'];if(c.controlChildren){c.hasChildren=true;}else{c.hasChildren=false;}if(c.hasOwnProperty('properties')&&this.hasVisibleElement(c.properties)){c.hasProperties=true;}else{c.hasProperties=false;}c.hasConstructor=c.hasOwnProperty('constructor');if(u&&u.properties&&this.hasVisibleElement(u.properties)){c.hasControlProperties=true;}else{c.hasControlProperties=false;}if(c&&c.events){c.hasOwnEvents=true;}else{c.hasOwnEvents=false;}c.hasOwnMethods=c.hasOwnProperty('methods')&&this.hasVisibleElement(c.methods);c.hasEvents=c.hasOwnEvents||this.getModel("borrowedEvents").getData().length>0;c.hasMethods=c.hasOwnMethods||this.getModel("borrowedMethods").getData().length>0;if(u&&u.associations&&this.hasVisibleElement(u.associations)){c.hasAssociations=true;}else{c.hasAssociations=false;}if(u&&u.aggregations&&this.hasVisibleElement(u.aggregations)){c.hasAggregations=true;}else{c.hasAggregations=false;}if(u&&u.specialSettings&&this.hasVisibleElement(u.specialSettings)){c.hasSpecialSettings=true;}else{c.hasSpecialSettings=false;}if(u&&u.annotations&&Object.keys(u.annotations).length>0){if(!c.hasAnnotations){u.annotations.unshift({});}c.hasAnnotations=true;}else{c.hasAnnotations=false;}if(c.hasConstructor&&c.constructor.parameters){for(i=0;i<c.constructor.parameters.length;i++){this.subParamPhoneName=c.constructor.parameters[i].name;o.parameters=o.parameters.concat(this._getParameters(c.constructor.parameters[i]));}this.subParamPhoneName='';}if(c.hasOwnMethods){M.methods=this.buildMethodsModel(c.methods);}if(c.hasOwnEvents){E.events=this.buildEventsModel(c.events);}if(c.implements&&c.implements.length){c.implementsParsed=c.implements.map(function(g,h,j){var D=g.split("."),s=D[D.length-1];return{href:g,name:s,isLast:h===j.length-1};});c.hasImplementsData=true;}else{c.hasImplementsData=false;}c.isClass=c.kind==="class";c.isDerived=!!c.extends;c.extendsText=c.extends||this.NOT_AVAILABLE;c.sinceText=c.since||this.NOT_AVAILABLE;c.module=c.module||this.NOT_AVAILABLE;this._modifyReferences(c);f=this.getModel("methods");e=this.getModel("borrowedMethods");f.setSizeLimit(1000);e.setSizeLimit(1000);this.getModel("topics").setSizeLimit(1000);this.getModel("topics").setData(c,false);this.getModel("constructorParams").setData(o,false);f.setData(M,false);f.setDefaultBindingMode("OneWay");this.getModel('events').setData(E,false);this.getModel('events').setDefaultBindingMode("OneWay");if(this.extHookbindData){this.extHookbindData(t,m);}},_modifyReferences:function(c){var h=false,r=c.constructor.references,R,p,l,i;c.references=[];if(r){for(i=0,l=r.length;i<l;i++){R=r[i];if(!h){p=R.match(/^{@link\s+topic:(\w{32})(\s.+)?}$|^topic:(\w{32})$/);if(p){if(p[3]){c.docuLink=p[3];c.docuLinkText=c.basename;}else if(p[1]){c.docuLink=p[1];c.docuLinkText=p[2]?p[2]:c.basename;}h=true;}else{c.references.push(R);}}else{c.references.push(R);}}}},_getHeaderLayoutUtil:function(){if(!this._oHeaderLayoutUtil){var _=function(t,s){return new sap.m.ObjectAttribute({title:t,text:s}).addStyleClass("sapUiTinyMarginBottom");},b=function(o){return new sap.m.Link(o||{});},c=function(o){return new sap.m.Text(o||{});},d=function(o){return new sap.m.Label(o||{});},e=function(o,f){var h=new sap.m.HBox(o||{});if(f){h.addStyleClass("sapUiDocumentationHeaderNavLinks sapUiTinyMarginBottom");}return h;};this._oHeaderLayoutUtil={_getControlSampleBlock:function(o,E){return e({items:[d({design:"Bold",text:"Control Sample:"}),b({emphasized:true,text:E.sample,visible:E.hasSample,href:"#/entity/"+o.name}),c({text:E.sample,visible:!E.hasSample})]},true);},_getDocumentationBlock:function(o,E){return e({items:[d({design:"Bold",text:"Documentation:"}),b({emphasized:true,text:o.docuLinkText,href:"#/topic/"+o.docuLink})]},true);},_getExtendsBlock:function(o,E){return e({items:[d({text:"Extends:"}),b({text:o.extendsText,href:"#/api/"+o.extendsText,visible:o.isDerived}),c({text:o.extendsText,visible:!o.isDerived})]},true);},_getSubclassesBlock:function(o,E){var s=E.extendedBy||E.implementedBy,S;this._aSubClasses=s;if(s.length===1){S=b({text:s[0],href:"#/api/"+s[0]});}else{S=b({text:o.isClass?"View subclasses":"View implementations",press:this._openSubclassesImplementationsPopover.bind(this)});}return e({items:[d({text:o.isClass?"Known direct subclasses:":"Known direct implementations:"}),S]},true);},_getImplementsBlock:function(o,E){var i=[];o.implementsParsed.forEach(function(f){i.push(e({items:[b({text:f.name,href:"#/api/"+f.href}),c({text:",",visible:!f.isLast})]}));});return e({items:[d({text:"Implements:"}),new sap.m.HBox({items:i})]},true);},_getModuleBlock:function(o,E){return _("Module",o.module);},_getLibraryBlock:function(o,E){return _("Library",E.lib);},_getVisibilityBlock:function(o,E){return _("Visibility",o.visibility);},_getAvailableSinceBlock:function(o,E){return _("Available since",o.sinceText);},_getApplicationComponentBlock:function(o,E){return _("Application Component",E.appComponent);}};}return this._oHeaderLayoutUtil;},_openSubclassesImplementationsPopover:function(e){var p=this._aSubClasses.map(function(E){return new sap.m.Link({text:E,href:"#/api/"+E}).addStyleClass("sapUiTinyMarginBottom sapUiTinyMarginEnd");}),P=this._getSubClassesAndImplementationsPopover(p);P.openBy(e.getSource());},_getSubClassesAndImplementationsPopover:function(c){var p=this._getPopover();if(p.getContent().length>0){p.destroyContent();}(c||[]).forEach(p.addContent,p);return p;},_getPopover:function(){if(!this._oPopover){this._oPopover=new sap.m.Popover({placement:"Bottom",showHeader:false}).addStyleClass("sapUiDocumentationSubclassesPopover");}return this._oPopover;},_buildHeaderLayout:function(c,e){var h=[[],[],[]],H=this._getHeaderLayoutUtil(),s=e.extendedBy||e.implementedBy||[],b=[{creator:"_getControlSampleBlock",exists:c.isClass},{creator:"_getDocumentationBlock",exists:c.docuLink!==undefined},{creator:"_getExtendsBlock",exists:c.isClass},{creator:"_getSubclassesBlock",exists:s.length>0},{creator:"_getImplementsBlock",exists:c.hasImplementsData},{creator:"_getModuleBlock",exists:true},{creator:"_getLibraryBlock",exists:c.kind==="namespace"&&e.lib},{creator:"_getVisibilityBlock",exists:c.visibility},{creator:"_getAvailableSinceBlock",exists:true},{creator:"_getApplicationComponentBlock",exists:true}],f=function(){var i=0,I,g=function(i){if(i<=3){return 0;}else if(i<=6){return 1;}return 2;};b.forEach(function(o){var d;if(o.exists){d=H[o.creator].call(this,c,e);I=g(++i);h[I].push(d);}},this);}.bind(this);f();h.forEach(function(d,i){var v=this.byId("headerColumn"+i);v.removeAllContent();if(d.length>0){v.setVisible(true);d.forEach(v.addContent,v);}},this);},_getControlChildren:function(t,s){for(var i=0;i<t.length;i++){if(t[i].name===s){return t[i].nodes;}}},_addChildrenDescription:function(l,c){function g(n){var L,i;for(i=0,L=l.length;i<L;i++){if(l[i].name===n){return l[i];}}return false;}for(var i=0;i<c.length;i++){c[i].description=g(c[i].name).description;c[i].link="{@link "+c[i].name+"}";}},_getEntitySampleData:function(e,c){var f=c.entities.filter(function(b){return b.id===e;});var E=f.length?f[0]:undefined;var s=this._getControlComponent(e,c);return{appComponent:s||this.NOT_AVAILABLE,sample:(E&&e)||this.NOT_AVAILABLE,hasSample:!!(E&&E.sampleCount>0)};},buildMethodsModel:function(m){var I=this.getModel("versionData").getProperty("/isInternal");if(!m.length){return m;}var r=m.filter(function(b){return I?true:b.visibility!=="restricted";}).map(function(b){var s=[];b.parameters=b.parameters||[];b.parameters=b.parameters.map(function(p){var c,d;var t=(p.type||"").split("|");p.types=[];for(var i=0;i<t.length;i++){p.types.push({value:t[i],isLast:i===t.length-1});}if(p.parameterProperties&&!b.subParametersInjected){c=p.parameterProperties;for(var e in c){d=(c[e].type||"").split("|");c[e].types=[];c[e].types=d.map(function(f,g,h){return{value:f,isLast:g===h.length-1};});c[e].isSubProperty=true;c[e].phoneName=p.name+'.'+c[e].name;s.push(c[e]);}}return p;});if(b.returnValue){var t=(b.returnValue.type||"").split("|");b.returnValue.types=[];for(var i=0;i<t.length;i++){b.returnValue.types.push({value:t[i],isLast:i===t.length-1});}}if(!b.subParametersInjected){b.parameters=b.parameters.concat(s);b.subParametersInjected=true;}return b;});r.unshift({});return r;},buildBorrowedModel:function(c){var b,d,s,e,m,M,I,r=[],o,i;if(!c){return Promise.resolve({events:[],methods:[]});}e={methods:[],events:[]};s=c.extends;var v=function(g){return this._aAllowedMembers.indexOf(g.visibility)!==-1;}.bind(this);m=c.aMethods||[];M=m.map(function(g){return g.name;});var f=function(g){return M.indexOf(g.name)===-1;};I=[s];while(s){i=this._aApiIndex.length;while(i--){o=this._aApiIndex[i];if(o.name===s){s=o.extends;if(s){I.push(s);}if(r.indexOf(o.lib)===-1){r.push(o.lib);}break;}}if(i===-1){break;}}var p=r.map(function(l){return A.getLibraryElementsJSONPromise(l);});return Promise.all(p).then(function(R){var g=[];R.forEach(function(S){g=g.concat(S);});I.forEach(function(s){var h,i=g.length;while(i--){if(g[i].name===s){h=g[i];break;}}var j=function(k){return{name:k.name,link:"#/api/"+s+"/methods/"+k.name};};var E=function(k){return{name:k.name,link:"#/api/"+s+"/events/"+k.name};};if(h){b=(h.methods||[]).filter(v).filter(f).map(j);if(b.length){e.methods.push({name:s,methods:b});}d=(h.events||[]).filter(v).map(E);if(d.length){e.events.push({name:s,events:d});}}});return e;});},buildEventsModel:function(e){if(e.length===0){return e;}var r=e.map(function(b){if(b.parameters&&!b.subParametersInjected){var p=[];b.parameters.map(function(P){this.subParamPhoneName=P.name;p=p.concat(this._getParameters(P));},this);this.subParamPhoneName='';b.parameters=p;b.subParametersInjected=true;}return b;},this);r.unshift({});return r;},subParamLevel:0,subParamPhoneName:'',_getParameters:function(p){var r=[p];var t=(p.type||"").split("|"),b;p.types=[];for(var i=0;i<t.length;i++){p.types.push({value:t[i],isLast:i===t.length-1});}if(p.parameterProperties){this.subParamLevel++;for(var s in p.parameterProperties){var c='is';for(var i=0;i<this.subParamLevel;i++){c+='Sub';}c+='Property';this.subParamPhoneName+='.'+s;p.parameterProperties[s][c]=true;p.parameterProperties[s].phoneName=this.subParamPhoneName;b=(p.parameterProperties[s].type||"").split("|");p.parameterProperties[s].types=[];p.parameterProperties[s].types=b.map(function(d,e,f){return{value:d,isLast:e===f.length-1};});r=r.concat(this._getParameters(p.parameterProperties[s]));if(this.subParamPhoneName.indexOf('.')>-1){this.subParamPhoneName=this.subParamPhoneName.substring(0,this.subParamPhoneName.lastIndexOf('.'));}else{this.subParamPhoneName='';}}this.subParamLevel--;}return r;},formatSubtitle:function(d){var r="";if(d){r+="Deprecated in version: "+d.since;}return r;},formatConstructor:function(n,p){var r='<pre class="sapUiDocumentationAPICode">new ';if(n){r+=n+'(';}if(p){p.forEach(function(e,i,b){r+=e.name;if(e.optional){r+='?';}if(i<b.length-1){r+=', ';}});}if(n){r+=')</pre>';}return r;},_formatChildDescription:function(d){if(d){d=this._extractFirstSentence(d);d=this._wrapInSpanTag(d);return"<div>"+d+"<\div>";}},_extractFirstSentence:function(d){var b=d.slice(),s;if(d.lastIndexOf("}")>d.lastIndexOf(".")){return"";}b=this._sliceSpecialTags(b,"{","}");b=this._sliceSpecialTags(b,"<code>","</code>");s=d.length-b.length;d=d.slice(0,b.indexOf(".")+".".length+s);return d;},_sliceSpecialTags:function(d,s,e){var b,c;while(d.indexOf(s)!==-1&&d.indexOf(s)<d.indexOf(".")){b=d.indexOf(s);c=d.indexOf(e);d=d.slice(0,b)+d.slice(c+e.length,d.length);}return d;},formatDefaultValue:function(d){switch(d){case null:return'';case undefined:return'';case'':return'empty string';default:return d;}},formatEntityName:function(n,c,s){return(s===true)?c+"."+n:n;},formatDeprecated:function(s,d,e){var r;if(d){d=d.replace(/{@link\s+([^}\s]+)(?:\s+([^}]*))?}|<code>(\S+)<\/code>/gi,function(m,E,n,c){var t;if(c){return['<em>',c,'</em>'].join("");}else{if(e){E=E[0]==="#"?E.substring(1,E.length):E;t=[this._sTopicid,"/",e,"/",E].join("");}else{t=E;}return['<a href="#/api/',t,'">',(n?n:E),'</a>'].join("");}}.bind(this));}r=["Deprecated"];if(s){r.push(" since "+s);}if(d){r.push(". "+d);}return r.join("");},formatMethodDeprecated:function(s,d){return this.formatDeprecated(s,d,"methods");},formatEventDeprecated:function(s,d){return this.formatDeprecated(s,d,"events");},formatExample:function(c,t){return this.formatDescription(["<span><strong>Example: </strong>",c,"<pre class='sapUiSmallMarginTop'>",t,"</pre></span>"].join(""));},formatOverviewDescription:function(d,r){var l,i;if(r&&r.length>0){d+="<br/><br/><span>Documentation links:</span><ul>";l=r.length;for(i=0;i<l;i++){if(/{@link.*}/.test(r[i])){d+="<li>"+r[i]+"</li>";}else{d+="<li>{@link "+r[i]+"}</li>";}}d+="</ul>";}return this.formatDescription(d);},formatDescription:function(d,b,c){if(!d&&!b&&!c){return"<span/>";}var r=d||"";if(c||b){r+="<span class=\"sapUiDocumentationDeprecated\">";if(c){r+='<br/>Deprecated since version '+c+'.';}if(b){if(c){r+=' '+b;}else{r+='<br/>'+b;}}r+="</span>";}r=this._wrapInSpanTag(r);return r;},formatDescriptionSince:function(d,s){var r=d||"";if(s){r+='<br/><br/><i>Since: '+s+'.</i>';}r=this._wrapInSpanTag(r);return r;},formatAnnotationDescription:function(d,s){var r=d||"";r+='<br/>For more information, see '+'<a target="_blank" href="'+this.ANNOTATIONS_LINK+'">OData v4 Annotations</a>';if(s){r+='<br/><br/><i>Since: '+s+'.</i>';}r=this._wrapInSpanTag(r);return r;},formatAnnotationDescriptionSummary:function(d){var r=d||"";r=r.split(this.ANNOTATION_DESCRIPTION_STRIP_REGEX)[0];r=this._wrapInSpanTag(r);return r;},formatAnnotationTarget:function(t){var r="";if(t){t.forEach(function(e){r+=e+'<br/>';});}r=this._wrapInSpanTag(r);return r;},formatAnnotationNamespace:function(n){var r,N=n.split(".");if(N[0]==="Org"&&N[1]==="OData"){r='<a target="_blank" href="'+this.ANNOTATIONS_NAMESPACE_LINK+n+'.xml">'+n+'</a>';}else{r=n;}r=this._wrapInSpanTag(r);return r;},hasVisibleElement:function(e){for(var i=0;i<e.length;i++){if(this._aAllowedMembers.indexOf(e[i].visibility)!==-1){return true;}}return false;},formatEventsName:function(e){return e?e.name:"";},formatEventsParam:function(e){if(e&&e.type!=this.EVENT){return e.name;}else{return"";}},formatMethodCode:function(n,p,r){var b='<pre class="sapUiDocumentationAPICode">'+n+'(';if(p&&p.length>0){p.forEach(function(e,i,c){if(e.isSubProperty||e.isSubSubProperty){return;}b+=e.name;if(e.optional){b+='?';}if(i<c.length-1){b+=', ';}});}b+=') : ';if(r){b+=r.type;}else{b+='void';}b+="</pre>";return b;},formatMethodsParam:function(m){if(m&&m.type!=this.METHOD){return m.name;}else{return"";}},formatLinkEnabled:function(l){return this._baseTypes.indexOf(l.toLowerCase())===-1;},formatExceptionLink:function(l){l=l||'';return l.indexOf('sap.ui.')!==-1;},formatEventClassName:function(i,b,p){if(p&&(i||b)){return"sapUiDocumentationParamPhone";}else if(b){return"sapUiDocumentationParamSubSub";}else if(i){return"sapUiDocumentationParamSub";}else{return"sapUiDocumentationParamBold";}},formatMethodClassName:function(i,p){if(p&&i){return"sapUiDocumentationParamPhone";}else if(i){return"sapUiDocumentationParamSub";}else{return"sapUiDocumentationParamBold";}},onAnnotationsLinkPress:function(e){this._scrollToEntity("annotations","Summary");},backToSearch:function(){this.onNavBack();},_wrapInSpanTag:function(t){var b=this.getModel('topics').oData,c=b.name||"",d=b.methods||[];var f=a.formatTextBlock(t,{linkFormatter:function(e,g){var h,H,i,m,r="api",s,S="scrollToMethod",E,l;g=g||e;if(e.match("://")){return'<a target="_blank" href="'+e+'">'+g+'</a>';}e=e.trim().replace(/\.prototype\./g,"#");h=e.indexOf('#');H=e.indexOf('#.');i=e.indexOf('#event:');if(h===-1){var j=e.lastIndexOf('.'),k=E=e.substring(j+1),n=d.filter(function(o){if(o.name===k){return o;}})[0];if(n){if(n.static===true){E=e;s=e.replace("."+k,"");if(s.length>0&&s!==c){e=s+"/methods/"+e;S=false;}else{e=c+'/methods/'+e;}}else{e=c+'/methods/'+k;}}else{m=e.match(/^topic:(\w{32})$/);if(m){e=E=m[1];r="topic";}}}if(H===0){e=e.slice(2);e=c+'/methods/'+c+'.'+e;}else if(i===0){e=e.slice('#event:'.length);E=e;e=c+'/events/'+e;S="scrollToEvent";}else if(h===0){e=e.slice(1);E=e;e=c+'/methods/'+e;}if(h>0){e=e.replace('#','/methods/');E=e;}l='<a class="jsdoclink';if(S){l+=' '+S;}l+='" href="#/'+r+'/'+e+'" data-sap-ui-target="'+E+'">'+g+'</a>';return l;}});return'<span class="sapUiDocumentationJsDoc">'+f+'</span>';}});});
