/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/dt/Overlay','sap/ui/dt/ControlObserver','sap/ui/dt/ManagedObjectObserver','sap/ui/dt/ElementDesignTimeMetadata','sap/ui/dt/AggregationDesignTimeMetadata','sap/ui/dt/AggregationOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil'],function(O,C,M,E,A,a,b,c,d,D){"use strict";var e=O.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]}},aggregations:{aggregationOverlays:{type:"sap.ui.dt.AggregationOverlay",multiple:true},designTimeMetadata:{type:"sap.ui.dt.ElementDesignTimeMetadata",altTypes:["object"],multiple:false}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},requestElementOverlaysForAggregation:{parameters:{name:{type:"string"}}}}}});e.prototype.init=function(){O.prototype.init.apply(this,arguments);this._oMutationObserver=O.getMutationObserver();this._oMutationObserver.attachDomChanged(this._onDomChanged,this);};e.prototype.onAfterRendering=function(){var o=!this._oDomRef;O.prototype.onAfterRendering.apply(this,arguments);if(o&&this._oDomRef){var p={id:this.getId(),type:"overlayRendered"};this.fireElementModified(p);}};e.prototype.exit=function(){if(this._oMutationObserver){this._oMutationObserver.detachDomChanged(this._onDomChanged,this);delete this._oMutationObserver;}O.prototype.exit.apply(this,arguments);this._unobserve();b.deregister(this._sElementId);if(!b.hasOverlays()){O.destroyMutationObserver();O.removeOverlayContainer();}delete this._sElementId;};e.prototype.applyStyles=function(){var g=this.getGeometry();if(g&&g.visible){this._sortAggregationOverlaysInDomOrder();}O.prototype.applyStyles.apply(this,arguments);};e.prototype._sortAggregationOverlaysInDomOrder=function(){var f=function(g,h){var G=g.getGeometry();var i=h.getGeometry();var p=G&&G.position;var P=i&&i.position;if(p&&P){var B=p.top+G.size.height;var j=P.top+i.size.height;if(p.top<P.top){if(B>=j&&P.left<p.left){return 1;}else{return-1;}}else if(p.top===P.top){if(p.left===P.left){return 0;}else if(p.left<P.left){return-1;}else{return 1;}}else if(B<=j&&P.left>p.left){return-1;}else{return 1;}}};var s=this.getAggregationOverlays().sort(f);var o=this.getAggregationOverlays().some(function(g,i){if(g.getId()!==s[i].getId()){return true;}});if(o){this.removeAllAggregation("aggregationOverlays",true);s.forEach(function(g){this.addAggregation("aggregationOverlays",g,true);}.bind(this));}};e.prototype.setLazyRendering=function(l){O.prototype.setLazyRendering.apply(this,arguments);if(!l){this.placeInOverlayContainer();}};e.prototype.placeInOverlayContainer=function(){if(!this.getParent()){this.placeAt(O.getOverlayContainer());var u=this.getUIArea();u._onChildRerenderedEmpty=function(){return true;};}};e.prototype.setElement=function(v){var o=this.getElementInstance();if(o instanceof sap.ui.core.Element){b.deregister(o);this._unobserve();}this.setAssociation("element",v);var f=this.getElementInstance();this._sElementId=f.getId();b.register(f,this);this._observe(f);if(this.getDesignTimeMetadata()){this._renderAndCreateAggregation();}return this;};e.prototype._addPropagationInfos=function(o){var p=this.getParentAggregationOverlay(),P;var f=this.getElementInstance();if(!p&&f){P=b.getOverlay(f.getParent());if(P&&f.sParentAggregationName){p=P.getAggregationOverlay(f.sParentAggregationName);}}if(!p){return false;}var g=p.getDesignTimeMetadata();var r=g.getRelevantContainerForPropagation(f);var R=g.getMetadataForPropagation(f);if(!r&&!R){return false;}if(r){o.getData().relevantContainer=r;}if(R){var h=o.getData();if(R.actions===null){var m=f.getMetadata().getAllAggregations();var i=Object.keys(m);i=i.concat(Object.keys(h.aggregations).filter(function(s){return i.indexOf(s)<0;}));i.forEach(function(s){if(h.aggregations[s]&&h.aggregations[s].actions){h.aggregations[s].actions=null;}});}jQuery.extend(true,h,R);}return true;};e.prototype.setDesignTimeMetadata=function(v){var o;if(v instanceof E){o=v;}else{o=new E({libraryName:this.getElementInstance().getMetadata().getLibraryName(),data:v});}if(!this._oOriginalDesignTimeMetadata){this._oOriginalDesignTimeMetadata=o;}this._addPropagationInfos(o);var r=this.setAggregation("designTimeMetadata",o);if(this.getElementInstance()){this._aScrollContainers=this.getDesignTimeMetadata().getScrollContainers();this._renderAndCreateAggregation();}return r;};e.prototype._renderAndCreateAggregation=function(){this.getAggregationOverlays().forEach(function(o){o.getChildren().forEach(function(f){f.setParent(null);});});this.destroyAggregationOverlays();this._createAggregationOverlays();var p=d.getClosestOverlayFor(this.getElementInstance().getParent());if(p){p.sync();}};e.prototype.getAssociatedDomRef=function(){var o=c.getDomRef(this.getElementInstance());if(!o){var f=this.getDesignTimeMetadata();if(!f){return undefined;}var g=f.getDomRef();if(typeof g==="function"){o=g(this.getElementInstance());}}if(o){return jQuery(o);}return undefined;};e.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};e.prototype.setSelected=function(s,S){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);if(!S){this.fireSelectionChange({selected:s});}}return this;};e.prototype.setMovable=function(m){m=!!m;if(this.getMovable()!==m){this.toggleStyleClass("sapUiDtOverlayMovable",m);this.setProperty("movable",m);this.fireMovableChange({movable:m});}return this;};e.prototype.setEditable=function(f){f=!!f;if(this.getEditable()!==f){this.toggleStyleClass("sapUiDtOverlayEditable",f);this.setProperty("editable",f);this.fireEditableChange({editable:f});}return this;};e.prototype.sync=function(){var f=this.getAggregationOverlays();f.forEach(function(o){this._syncAggregationOverlay(o);},this);};e.prototype._getParentRelevantContainerPropagation=function(){var p=this.getParent();var o=[];if(p&&p.getAggregation("designTimeMetadata")){jQuery.extend(o,p.getDesignTimeMetadata().getData()["propagationInfos"]);return o;}return false;};e.prototype._getCurrentRelevantContainerPropagation=function(o,n){if(!o.propagateRelevantContainer){return false;}else if(typeof o.propagateRelevantContainer==="function"){n.relevantContainerFunction=o.propagateRelevantContainer;n.relevantContainerElement=this.getElementInstance();}else if(typeof o.propagateRelevantContainer==="boolean"&&o.propagateRelevantContainer){n.relevantContainerFunction=function(){return true;};n.relevantContainerElement=this.getElementInstance();}else{throw new Error("wrong type: it should be either a function or a boolean value and it is:"+typeof o.propagateRelevantContainer);}return true;};e.prototype._getCurrentDesigntimePropagation=function(o,n){if(!o.propagateMetadata){return false;}else if(typeof o.propagateMetadata==="function"){n.relevantContainerElement=this.getElementInstance();n.metadataFunction=o.propagateMetadata;}else{throw new Error("wrong type: it should be a function and it is:",typeof o.propagateMetadata);}return true;};e.prototype._propagateDesigntimeObj=function(o,n,p){var f;if(!p&&!n){return false;}if(n){p=p?p:[];p.push(n);}f=o.getData();f.propagationInfos=p;o.setData(f);return true;};e.prototype._handleDesigntimePropagation=function(o){var n={relevantContainerFunction:null,relevantContainerElement:null,metadataFunction:null};var N=false;var p=this._getParentRelevantContainerPropagation();var f=o.getData();if(f&&f!=={}){N=(this._getCurrentRelevantContainerPropagation(f,n)||N);N=(this._getCurrentDesigntimePropagation(f,n)||N);}if(N===false){n=null;}if(p||n){return this._propagateDesigntimeObj(o,n,p);}else{return false;}};e.prototype._createAggregationOverlay=function(s){var o=this.getDesignTimeMetadata().createAggregationDesignTimeMetadata(s);this._handleDesigntimePropagation(o);var f=new a({aggregationName:s,element:this.getElementInstance(),designTimeMetadata:o});this._mAggregationOverlays[s]=f;this.addAggregation("aggregationOverlays",f);this._syncAggregationOverlay(f);f.attachVisibleChanged(this._onAggregationVisibleChanged,this);return f;};e.prototype._createAggregationOverlays=function(){this._mAggregationOverlays={};var o=this.getElementInstance();var f=this.getDesignTimeMetadata();var m={};var g=o.getMetadata().getAllAggregations();var h=Object.keys(g);var i;h.forEach(function(s){i=f.isAggregationIgnored(o,s);m[s]=!i;if(!i){this._createAggregationOverlay(s);}}.bind(this));var j=f.getAggregations();if(j){var k=Object.keys(j);k.forEach(function(s){if(m[s]===undefined){i=f.isAggregationIgnored(o,s);if(!i){this._createAggregationOverlay(s);}}},this);}this.sync();};e.prototype._observe=function(o){if(o instanceof sap.ui.core.Control){this._oObserver=new C({target:o});this._oObserver.attachAfterRendering(this._onElementAfterRendering,this);}else{this._oObserver=new M({target:o});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};e.prototype._unobserve=function(){if(this._oObserver){this._oObserver.destroy();}};e.prototype._onAggregationVisibleChanged=function(o){var f=o.getSource();this._syncAggregationOverlay(f);};e.prototype._syncAggregationOverlay=function(o){if(o.isVisible()){var s=o.getAggregationName();var i=this.getElementInstance()instanceof sap.ui.core.Control;if(!i||this._getElementInstanceVisible()){if(!o.getChildren().length){this.fireRequestElementOverlaysForAggregation({name:s});}}d.iterateOverAggregationLikeChildren(this,s,function(f){var g=b.getOverlay(f);if(g&&g.getParent()!==this){o.addChild(g);}}.bind(this));}};e.prototype.destroyAggregation=function(s,S){O.prototype.destroyAggregation.apply(this,arguments);if(s==="aggregationOverlays"){delete this._mAggregationOverlays;}};e.prototype._onElementModified=function(o){var p=o.getParameters();var n=p.name;if(p.type==="propertyChanged"&&n==="visible"){this.setRelevantOverlays([]);this.fireElementModified(p);}else if(n){var f=this.getAggregationOverlay(n);if(f){this.setRelevantOverlays([]);this.fireElementModified(p);}}else if(o.getParameters().type==="setParent"){this.fireElementModified(p);}this.invalidate();};e.prototype._onDomChanged=function(o){var i=o.getParameters().elementIds||[];var f=this.getElementInstance();if(f&&i.indexOf(f.getId())!==-1){if(this._mGeometry&&!this._mGeometry.visible){delete this._mGeometry;this.invalidate();}else if(!this._mGeometry){this.sync();}}if(this.isRoot()){this.applyStyles();}};e.prototype._onElementAfterRendering=function(){if(!this.getDomRef()){this.invalidate();}this.sync();};e.prototype._onElementDestroyed=function(){this.destroy();};e.prototype.getAggregationOverlays=function(){return this.getAggregation("aggregationOverlays")||[];};e.prototype.getChildren=function(){return this.getAggregationOverlays();};e.prototype.getAggregationOverlay=function(s){if(this._mAggregationOverlays){return this._mAggregationOverlays[s];}};e.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};e.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};e.prototype.isSelected=function(){return this.getSelected();};e.prototype.isSelectable=function(){return this.getSelectable();};e.prototype.isMovable=function(){return this.getMovable();};e.prototype.isEditable=function(){return this.getEditable();};e.prototype._getElementInstanceVisible=function(){var o=this.getElementInstance();if(o){var g=this.getGeometry();return g&&g.visible;}else{return false;}};e.prototype.getElementVisibility=function(){var o=this.getElementInstance();if(o instanceof sap.ui.core.Control){return o.getVisible();}var f=this.getDesignTimeMetadata();var g=f&&f.getData().isVisible;if(!g){return undefined;}return g(this.getElementInstance());};e.prototype.getRelevantContainer=function(f){var o=this.getDesignTimeMetadata();if(o&&o.getData().relevantContainer){return o.getData().relevantContainer;}else if(f){return this.getElementInstance();}var p=this.getParentElementOverlay();return p?p.getElementInstance():undefined;};return e;},true);
