/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/dt/Plugin','sap/ui/dt/ContextMenuControl'],function(q,P,C){"use strict";var a=P.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{library:"sap.ui.dt",properties:{contextElement:{type:"object"},styleClass:{type:"string"}},associations:{},events:{openedContextMenu:{},closedContextMenu:{}}}});a.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("contextmenu",this._onContextMenu,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);};a.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("contextmenu",this._onContextMenu,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);};a.prototype.init=function(){this._aMenuItems=[];};a.prototype.exit=function(){delete this._aMenuItems;if(this._oContextMenuControl){this._oContextMenuControl.destroy();delete this._oContextMenuControl;}};a.prototype.addMenuItem=function(m,r){var M={menuItem:m,fromPlugin:!!r};this._aMenuItems.push(M);};a.prototype.open=function(o,t){this.setContextElement(t.getElementInstance());this._aMenuItems=this._aMenuItems.filter(function(M){return!M.fromPlugin;});var p=this.getDesignTime().getPlugins();p.forEach(function(b){var c=b.getMenuItems(t)||[];c.forEach(function(M){this.addMenuItem(M,true);}.bind(this));}.bind(this));var m=this._aMenuItems.map(function(M){return M.menuItem;});m=this._sortMenuItems(m);this._oContextMenuControl=new C();this._oContextMenuControl.addStyleClass(this.getStyleClass());this._oContextMenuControl.setMenuItems(m,t);this._oContextMenuControl.setOverlayDomRef(t);this._oContextMenuControl.attachItemSelect(this._onItemSelected,this);this._oContextMenuControl.openMenu(o,t);this.fireOpenedContextMenu();};a.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};a.prototype._onItemSelected=function(e){var s=[],E=e.getParameter("item"),c=this.getContextElement(),i=E.data("id");var m=this._aMenuItems.map(function(M){return M.menuItem;});m.some(function(I){if(i===I.id){var d=this.getDesignTime();s=d.getSelection();if(!E.getSubmenu()){var p={};p.eventITem=E;p.contextElement=c;I.handler(s,p);}return true;}},this);};a.prototype._onContextMenu=function(e){e.preventDefault();document.activeElement.blur();var o=sap.ui.getCore().byId(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1){if(!o.isSelected()){o.setSelected(true);}this.open(e,o);e.stopPropagation();}};a.prototype._onKeyDown=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if((e.keyCode===q.sap.KeyCodes.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){e.preventDefault();e.stopPropagation();if(o&&o.isSelectable()){if(!o.isSelected()){o.setSelected(true);}var w=o.$().width()/2;var h=o.$().height()/2;var t=o.$().offset().top;var l=o.$().offset().left;this.open({pageX:l+w,pageY:t+h},o);}}};return a;},true);
