/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/dt/Plugin','sap/ui/dt/DOMUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/ElementUtil'],function(P,D,O,E){"use strict";var a=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});var I=7;var p=false;var o;a.prototype._preventScrollOnTouch=function(e){if(p){e.preventDefault();}};a.prototype.init=function(){P.prototype.init.apply(this,arguments);document.addEventListener('touchmove',this._preventScrollOnTouch,true);this._mElementOverlayDelegate={"onAfterRendering":this._checkMovable};this._mAggregationOverlayDelegate={"onAfterRendering":this._attachDragScrollHandler,"onBeforeRendering":this._removeDragScrollHandler};this._dragScrollHandler=this._dragScroll.bind(this);this._dragLeaveHandler=this._dragLeave.bind(this);this._mScrollIntervals={};};a.prototype.exit=function(){P.prototype.exit.apply(this,arguments);document.removeEventListener('touchmove',this._preventScrollOnTouch);delete this._mElementOverlayDelegate;delete this._mAggregationOverlayDelegate;delete this._dragScrollHandler;};a.prototype.registerElementOverlay=function(e){e.addEventDelegate(this._mElementOverlayDelegate,this);e.attachEvent("movableChange",this._onMovableChange,this);if(e.isMovable()){this._attachDragEvents(e);}e.attachBrowserEvent("dragover",this._onDragOver,this);e.attachBrowserEvent("dragenter",this._onDragEnter,this);e.attachBrowserEvent("dragleave",this._onDragLeave,this);};a.prototype.registerAggregationOverlay=function(A){A.attachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){this._attachDragScrollHandler(A);A.addEventDelegate(this._mAggregationOverlayDelegate,this);}};a.prototype.deregisterElementOverlay=function(e){e.removeEventDelegate(this._mElementOverlayDelegate,this);e.detachEvent("movableChange",this._onMovableChange,this);this._detachDragEvents(e);e.detachBrowserEvent("dragover",this._onDragOver,this);e.detachBrowserEvent("dragenter",this._onDragEnter,this);e.detachBrowserEvent("dragleave",this._onDragLeave,this);};a.prototype.deregisterAggregationOverlay=function(A){A.detachTargetZoneChange(this._onAggregationTargetZoneChange,this);if(!sap.ui.Device.browser.webkit){A.removeEventDelegate(this._mAggregationOverlayDelegate,this);this._removeDragScrollHandler(A);this._clearScrollIntervalFor(A.$().attr("id"));}};a.prototype._attachDragEvents=function(e){e.attachBrowserEvent("dragstart",this._onDragStart,this);e.attachBrowserEvent("drag",this._onDrag,this);e.attachBrowserEvent("dragend",this._onDragEnd,this);e.attachBrowserEvent("touchstart",this._onTouchStart,this);};a.prototype._detachDragEvents=function(e){e.detachBrowserEvent("dragstart",this._onDragStart,this);e.detachBrowserEvent("drag",this._onDrag,this);e.detachBrowserEvent("dragend",this._onDragEnd,this);e.detachBrowserEvent("touchstart",this._onTouchStart,this);};a.prototype.onMovableChange=function(e){};a.prototype.onDragStart=function(e){};a.prototype.onDragEnd=function(e){};a.prototype.onDrag=function(e){};a.prototype.onDragEnter=function(e){};a.prototype.onDragLeave=function(e){};a.prototype.onDragOver=function(e){};a.prototype.onAggregationDragEnter=function(A){};a.prototype.onAggregationDragOver=function(A){};a.prototype.onAggregationDragLeave=function(A){};a.prototype.onAggregationDrop=function(A){};a.prototype._checkMovable=function(e){var f=e.srcControl;if(f.isMovable()||D.getDraggable(f.$())!==undefined){D.setDraggable(f.$(),f.isMovable());}};a.prototype._onMovableChange=function(e){var f=e.getSource();if(f.isMovable()){this._attachDragEvents(f);}else{this._detachDragEvents(f);}this.onMovableChange(f);};a.prototype._onDragStart=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);e.stopPropagation();if(sap.ui.Device.browser.firefox&&e&&e.originalEvent&&e.originalEvent.dataTransfer&&e.originalEvent.dataTransfer.setData){e.originalEvent.dataTransfer.setData('text/plain','');}this.showGhost(f,e);this.onDragStart(f);};a.prototype._attachTouchDragEvents=function(e){e.attachBrowserEvent("touchmove",this._onTouchMove,this);e.attachBrowserEvent("touchend",this._onTouchEnd,this);};a.prototype._detachTouchDragEvents=function(e){e.detachBrowserEvent("touchmove",this._onTouchMove,this);e.detachBrowserEvent("touchend",this._onTouchEnd,this);};a.prototype._onTouchStart=function(e){var t=e.touches[0].pageX;var f=e.touches[0].pageY;var T,g;var h=sap.ui.getCore().byId(e.currentTarget.id);var i=function(){h.detachBrowserEvent("touchmove",T,this);h.detachBrowserEvent("touchend",g,this);h.detachBrowserEvent("contextmenu",g,this);};var G=function(j,k){var l=t-j;var m=f-k;return Math.sqrt((l*l)+(m*m));};T=function(e){var j=e.touches[0].pageX;var k=e.touches[0].pageY;var m=G(j,k);if(m>I){this.onDragStart(h);i.call(this);this._attachTouchDragEvents(h);}};g=function(e){i.call(this);p=false;};p=true;e.stopPropagation();h.attachBrowserEvent("touchmove",T,this);h.attachBrowserEvent("contextmenu",g,this);h.attachBrowserEvent("touchend",g,this);};a.prototype._getTargetOverlay=function(e){if(e&&E.isInstanceOf(e,"sap.ui.dt.Overlay")){var t;if(E.isInstanceOf(e,"sap.ui.dt.AggregationOverlay")&&e.getTargetZone()){t=e;}else if(O.isInTargetZoneAggregation(e)){t=e;}return t?t:this._getTargetOverlay(e.getParent());}};a.prototype._findTargetOverlayFromCoordinates=function(e,f){var g=document.elementFromPoint(e,f);var h=g?sap.ui.getCore().byId(g.id):undefined;return this._getTargetOverlay(h);};a.prototype._onTouchMove=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);this.onDrag(f);var t=e.touches||e.changedTouches;var g=t[0].pageX;var h=t[0].pageY;var T=this._findTargetOverlayFromCoordinates(g,h);if(!T){return;}if(T!==o){if(o){if(E.isInstanceOf(o,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragLeave(o);}else{this.onDragLeave(o);}}o=T;if(E.isInstanceOf(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragEnter(T);}else{this.onDragEnter(T);}}if(E.isInstanceOf(T,"sap.ui.dt.AggregationOverlay")){this.onAggregationDragOver(T);}else{this.onDragOver(T);}e.stopPropagation();};a.prototype._getValidTargetZoneAggregationOverlay=function(e){if(E.isInstanceOf(e,"sap.ui.dt.AggregationOverlay")&&e.getTargetZone()){return e;}else{return this._getValidTargetZoneAggregationOverlay(e.getParent());}};a.prototype._onTouchEnd=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);var A=this._getValidTargetZoneAggregationOverlay(f);if(A){this.onAggregationDrop(A);}this.onDragEnd(f);this._detachTouchDragEvents(f);o=undefined;p=false;};a.prototype.showGhost=function(e,f){if(!sap.ui.Device.browser.internet_explorer&&!sap.ui.Device.browser.edge&&!sap.ui.Device.browser.msie&&f&&f.originalEvent&&f.originalEvent.dataTransfer&&f.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(e,f);this._$ghost.appendTo("#overlay-container");setTimeout(function(){this._removeGhost();}.bind(this),0);f.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),f.originalEvent.pageX-e.$().offset().left,f.originalEvent.pageY-e.$().offset().top);}};a.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};a.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};a.prototype.createGhost=function(e){var g=e.getAssociatedDomRef();var $;if(!g){g=this._getAssociatedDomCopy(e);$=g;}else{$=jQuery("<div></div>");jQuery.makeArray(g).forEach(function(n){D.cloneDOMAndStyles(n,$);});}var f=jQuery("<div></div>").addClass("sapUiDtDragGhostWrapper");return f.append($.addClass("sapUiDtDragGhost"));};a.prototype._getAssociatedDomCopy=function(e){var $=jQuery("<div></div>");e.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(C){var f=C.getAssociatedDomRef();if(f){D.cloneDOMAndStyles(f,$);}else{D.cloneDOMAndStyles(this._getAssociatedDomCopy(C),$);}},this);},this);return $;};a.prototype.getGhost=function(){return this._$ghost;};a.prototype._onDragEnd=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);this._removeGhost();this._clearAllScrollIntervals();this.onDragEnd(f);e.stopPropagation();};a.prototype._onDrag=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);this.onDrag(f);e.stopPropagation();};a.prototype._onDragEnter=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragEnter(f)){e.stopPropagation();}}e.preventDefault();};a.prototype._onDragLeave=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragLeave(f)){e.stopPropagation();}}e.preventDefault();};a.prototype._onDragOver=function(e){var f=sap.ui.getCore().byId(e.currentTarget.id);if(O.isInTargetZoneAggregation(f)){if(!this.onDragOver(f)){e.stopPropagation();}}e.preventDefault();};a.prototype._onAggregationTargetZoneChange=function(e){var A=e.getSource();var t=e.getParameter("targetZone");if(t){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};a.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};a.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};a.prototype._onAggregationDragEnter=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDragEnter(A);e.preventDefault();e.stopPropagation();};a.prototype._onAggregationDragOver=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDragOver(A);e.preventDefault();e.stopPropagation();};a.prototype._onAggregationDragLeave=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDragLeave(A);e.preventDefault();e.stopPropagation();};a.prototype._onAggregationDrop=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDrop(A);e.preventDefault();e.stopPropagation();};var b=100;var c=20;var d=50;a.prototype._clearScrollInterval=function(e,s){if(this._mScrollIntervals[e]){window.clearInterval(this._mScrollIntervals[e][s]);delete this._mScrollIntervals[e][s];}};a.prototype._clearScrollIntervalFor=function(e){if(this._mScrollIntervals[e]){Object.keys(this._mScrollIntervals[e]).forEach(function(s){this._clearScrollInterval(e,s);},this);}};a.prototype._clearAllScrollIntervals=function(){Object.keys(this._mScrollIntervals).forEach(this._clearScrollIntervalFor.bind(this));};a.prototype._checkScroll=function($,s,e){var S;var f;var i=1;if(s==="top"||s==="bottom"){S=$.height();f=$.scrollTop.bind($);}else{S=$.width();f=$.scrollLeft.bind($);}if(s==="top"||s==="left"){i=-1;}var g=Math.floor(S/4);var t=b;if(g<b){t=g;}if(e<t){this._mScrollIntervals[$.attr("id")]=this._mScrollIntervals[$.attr("id")]||{};if(!this._mScrollIntervals[$.attr("id")][s]){this._mScrollIntervals[$.attr("id")][s]=window.setInterval(function(){var h=f();f(h+i*c);},d);}}else{this._clearScrollInterval($.attr("id"),s);}};a.prototype._dragLeave=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this._clearScrollIntervalFor(A.$().attr("id"));};a.prototype._dragScroll=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);var $=A.$();var i=e.clientX;var f=e.clientY;var g=$.offset();var h=$.height();var w=$.width();var t=g.top;var l=g.left;var B=t+h;var r=l+w;this._checkScroll($,"bottom",B-f);this._checkScroll($,"top",f-t);this._checkScroll($,"right",r-i);this._checkScroll($,"left",i-l);};a.prototype._attachDragScrollHandler=function(e){var A;if(E.isInstanceOf(e,"sap.ui.dt.AggregationOverlay")){A=e;}else{A=e.srcControl;}if(D.hasScrollBar(A.$())){A.getDomRef().addEventListener("dragover",this._dragScrollHandler,true);A.getDomRef().addEventListener("dragleave",this._dragLeaveHandler,true);}};a.prototype._removeDragScrollHandler=function(e){var A;if(E.isInstanceOf(e,"sap.ui.dt.AggregationOverlay")){A=e;}else{A=e.srcControl;}var f=A.getDomRef();if(f){f.removeEventListener("dragover",this._dragScrollHandler,true);}};return a;},true);
