/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/layout/AlignedFlowLayout',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/ResizeHandler'],function(q,C,l,R){"use strict";
var A=C.extend("sap.ui.layout.AlignedFlowLayout",{metadata:{library:"sap.ui.layout",properties:{minItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"12rem"},maxItemWidth:{type:"sap.ui.core.AbsoluteCSSSize",defaultValue:"24rem"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true},endContent:{type:"sap.ui.core.Control",multiple:true}}}});
A.prototype.init=function(){this._iEndItemWidth=-1;this._sResizeListenerId=R.register(this,this._onResize.bind(this));};
A.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId="";}};
A.prototype._onRenderingOrThemeChanged=function(){var d=this.getDomRef(),e=this.getDomRef("endItem"),E=this.getContent().length&&d&&e;if(E){var L=window.getComputedStyle(d,null),i=L.getPropertyValue("padding-top"),m=e.style;if(sap.ui.getCore().getConfiguration().getRTL()){m.left=L.getPropertyValue("padding-left");}else{m.right=L.getPropertyValue("padding-right");}m.bottom=i;}this._onResize(null,d,e);if(E){d.lastElementChild.style.width=this._iEndItemWidth+"px";}};
A.prototype.onAfterRendering=A.prototype._onRenderingOrThemeChanged;A.prototype.onThemeChanged=A.prototype._onRenderingOrThemeChanged;
A.prototype._onResize=function(e,d,E){if((e&&(e.size.width===e.oldSize.width))||(this.getContent().length===0)){return;}d=d||this.getDomRef();if(!d){return;}var a=this.getRenderer().CSS_CLASS+"OneLine",b=true;E=E||this.getDomRef("endItem");if(E){var L=d.lastElementChild.style;L.height="";L.display="";d.classList.remove(a);var o=this.getLastItemDomRef(),i=E.offsetHeight,c=E.offsetWidth,f=o.offsetLeft,g;if(sap.ui.getCore().getConfiguration().getRTL()){g=f;}else{var r=f+o.offsetWidth;g=d.offsetWidth-r;}this._iEndItemWidth=c;b=g>=c;if(b){if(this.checkItemsWrapping(d)){if(E.offsetTop<o.offsetTop){L.height=i+"px";L.display="block";}else{L.height="0";L.display="";}}else{if(E.offsetTop<o.offsetTop){L.height=i+"px";}L.display="block";}}else{L.height=i+"px";L.display="block";}}if(!this.checkItemsWrapping(d)&&b){d.classList.add(a);}else{d.classList.remove(a);}};
A.prototype.checkItemsWrapping=function(d){d=d||this.getDomRef();if(!d){return false;}var f=d.firstElementChild,L=this.getLastItemDomRef();if(!f||!L){return false;}var F=f.offsetTop,i=L.offsetTop,a=f.offsetHeight;if(i>=(F+a)){return true;}L=this.getDomRef("endItem");return!!L&&(i>=(F+a));};
A.prototype.getLastItemDomRef=function(){var c=this.getContent(),i=c.length;if(i){var o=c[i-1],a=o.getDomRef();if(a){return a.parentElement;}}return null;};
A.prototype.getLastVisibleDomRef=function(){return this.getDomRef("endItem")||this.getLastItemDomRef();};
A.prototype.getNumberOfSpacers=function(){var c=this.getContent().length;if(c===0){return 0;}var s=c,m=this.getMinItemWidth(),M;if(m.lastIndexOf("rem")!==-1){M=q.sap.remToPx(m);}else if(m.lastIndexOf("px")!==-1){M=parseFloat(m);}if(M){s=Math.abs(document.documentElement.clientWidth/M);}s=Math.min(s,c-2);s=Math.max(1,s);return Math.floor(s);};
return A;});
sap.ui.predefine('sap/ui/layout/AlignedFlowLayoutRenderer',['./library'],function(l){"use strict";var A={};A.CSS_CLASS="sapUiAFLayout";
A.render=function(r,c){var C=c.getContent();r.write("<ul");r.writeControlData(c);r.addClass(A.CSS_CLASS);r.writeClasses();r.write(">");this.renderItems(r,c,C);this.renderEndItem(r,c);this.renderSpacers(r,c);r.write("</ul>");};
A.renderItems=function(r,c,C){C=C||c.getContent();for(var i=0;i<C.length;i++){this.renderItem(r,c,C[i]);}};
A.renderItem=function(r,c,C){r.write("<li");r.addClass(A.CSS_CLASS+"Item");r.addStyle("flex-basis",c.getMinItemWidth());r.addStyle("max-width",c.getMaxItemWidth());r.writeClasses();r.writeStyles();r.write(">");r.renderControl(C);r.write("</li>");};
A.renderEndItem=function(r,c,e){e=e||c.getEndContent();if(e.length){r.write("<li");r.writeAttribute("id",c.getId()+"-endItem");r.addClass(A.CSS_CLASS+"End");if(c.getContent().length){r.addStyle("flex-basis",c.getMinItemWidth());}r.writeClasses();r.writeStyles();r.write(">");for(var i=0;i<e.length;i++){this.renderEndContent(r,c,e[i]);}r.write("</li>");}};
A.renderEndContent=function(r,c,C){r.renderControl(C);};
A.renderSpacers=function(r,c){var s=c.getNumberOfSpacers(),m=c.getMinItemWidth(),M=c.getMaxItemWidth(),C=A.CSS_CLASS;for(var i=0;i<s;i++){r.write("<li");if(i===(s-1)){r.writeAttribute("id",c.getId()+"-last");}r.addClass(C+"Item");r.addClass(C+"Spacer");r.addStyle("flex-basis",m);r.addStyle("max-width",M);r.writeClasses();r.writeStyles();r.write("></li>");}};
return A;},true);
sap.ui.predefine('sap/ui/layout/AssociativeSplitter',['./Splitter','./SplitterRenderer','jquery.sap.global'],function(S,a,q){"use strict";
var A=S.extend("sap.ui.layout.AssociativeSplitter",{
metadata:{associations:{associatedContentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"associatedContentArea"}}},
renderer:a
});
A.prototype.init=function(){S.prototype.init.call(this);this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",1),decrease:this._onKeyboardResize.bind(this,"dec",1),increaseMore:this._onKeyboardResize.bind(this,"incMore",2),decreaseMore:this._onKeyboardResize.bind(this,"decMore",2),max:this._onKeyboardResize.bind(this,"max",1),min:this._onKeyboardResize.bind(this,"min",1)};this._enableKeyboardListeners();};
A.prototype._enableKeyboardListeners=function(){S.prototype._enableKeyboardListeners.call(this);this.onsaprightmodifiers=this._keyListeners.increase;this.onsapleftmodifiers=this._keyListeners.decrease;this.onsapupmodifiers=this._keyListeners.decrease;this.onsapdownmodifiers=this._keyListeners.increase;this.onsapright=this._keyListeners.increaseMore;this.onsapdown=this._keyListeners.increaseMore;this.onsapleft=this._keyListeners.decreaseMore;this.onsapup=this._keyListeners.decreaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};
A.prototype.addAssociatedContentArea=function(c){this._needsInvalidation=true;_(c);return this.addAssociation("associatedContentAreas",c);};
A.prototype.indexOfAssociatedContentArea=function(c){var d=this._getContentAreas();for(var i=0;i<d.length;i++){if(c==d[i]){return i;}}return-1;};
A.prototype.insertAssociatedContentArea=function(c,I){var d=c.getId();this._needsInvalidation=true;_(c);var e=this.getAssociatedContentAreas();for(var i=0;i<e.length;i++){if(e[i]===d){e.splice(i,1);}}e.splice(I,0,d);this.setAssociation("associatedContentAreas",null);var t=this;e.forEach(function(d){t.addAssociation("associatedContentAreas",d);});};
A.prototype.removeAssociatedContentArea=function(c){this.removeAssociation("associatedContentAreas",c);};
A.prototype._getContentAreas=function(){var c=this.getAssociatedContentAreas()||[];var C=this.getContentAreas();var v=c.map(function(i){return sap.ui.getCore().byId(i);}).filter(function(o){return o;});return C.concat(v);};
A.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}if(q(j.target).hasClass("sapUiLoSplitterBarIcon")){j.target=j.target.parentElement;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!==0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);this._oLastDOMclicked=j.target;};
A.prototype.ondblclick=function(e){var i=this.getId(),B,c;if(!(e.target.contains(this._oLastDOMclicked)&&(this._oLastDOMclicked.id.indexOf(i+"-splitbar")>-1))){return;}B=parseInt(this._oLastDOMclicked.id.substr((i+"-splitbar-").length),10);c=this._getContentAreas()[B];c._currentPosition=this.getCalculatedSizes()[B];c._lastPosition=c._lastPosition||c._currentPosition;if(c._currentPosition===c._lastPosition){this._resizeContents(B,(this.getCalculatedSizes()[B])*-1,true);}else{this._resizeContents(B,c._lastPosition,true);c._lastPosition=null;}};
A.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}if(q(j.target).hasClass("sapUiLoSplitterBarIcon")){j.target=j.target.parentElement;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!==0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};
A.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var s=parseInt(j.target.id.substr((I+"-splitbar-").length),10);var c=parseInt(j.target.parentElement.id.substr((I+"-splitbar-").length),10);var B=(s+1)?s:c;var $=q(j.target);if($.attr("class")==="sapUiLoSplitterBarIcon"){$=$.parent();}var C=this.getCalculatedSizes();var d=this._bHorizontal?$.innerWidth():$.innerHeight();var e=this._getContentAreas();var l=e[B].getLayoutData();var L=e[B+1].getLayoutData();if(!l.getResizable()||!L.getResizable()){b(t);return;}var r=0-d;for(var i=0;i<=B;++i){r+=C[i]+d;}this._move={start:p,relStart:r,barNum:B,bar:q(j.target),c1Size:C[B],c1MinSize:l?parseInt(l.getMinSize(),10):0,c2Size:C[B+1],c2MinSize:L?parseInt(L.getMinSize(),10):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};
A.prototype._resizeContents=function(l,p,f){var c,L,o,s,d,C,$,n,N,m,M,O,i,F,e,D,g=parseFloat(this._move.c1Size).toFixed(5),h=parseFloat(this._move.c2Size).toFixed(5),j=parseFloat(g),k=parseFloat(h);if(isNaN(p)){q.sap.log.warning("Splitter: Received invalid resizing values - resize aborted.");return;}c=this._getContentAreas();L=c[l].getLayoutData();o=c[l+1].getLayoutData();s=L.getSize();d=o.getSize();C=this.$("content-"+l);$=this.$("content-"+(l+1));n=j+p;N=k-p;m=parseInt(L.getMinSize(),10);M=parseInt(o.getMinSize(),10);O=this.getOrientation();i=O==="Horizontal"?this.$().width():this.$().height();if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&d!=="auto"){e=this._pxToPercent(N,i);o.setSize(e);}else if(s!=="auto"&&d==="auto"){F=this._pxToPercent(n,i);L.setSize(F);}else{F=this._pxToPercent(n,i);e=this._pxToPercent(N,i);L.setSize(F);o.setSize(e);}}else{F=this._pxToPercent(n,i);e=this._pxToPercent(N,i);C.css(this._sizeType,F);$.css(this._sizeType,e);}};
A.prototype._pxToPercent=function(p,f){return(p*100)/f+"%";};
A.prototype._recalculateSizes=function(){var i,s,l,c,d,e;var f=[];var C=this._getContentAreas();var o=this.getOrientation();var g=[];var h=[];var p=[];for(i=0;i<C.length;++i){l=C[i].getLayoutData();s=l?l.getSize():"auto";f.push(s);}var j=this._calculateAvailableContentSize(f)+1;this._calculatedSizes=[];for(i=0;i<f.length;++i){s=f[i];if(s.indexOf("px")>-1){e=parseInt(s,10);j-=e;this._calculatedSizes[i]=e;}else if(s.indexOf("%")>-1){p.push(i);}else if(s==="auto"){l=C[i].getLayoutData();if(l&&parseInt(l.getMinSize(),10)!==0){h.push(i);}else{g.push(i);}}else{q.sap.log.error("Illegal size value: "+f[i]);}}var w=false;if(j<0){w=true;j=0;}var r=j;j=o==="Horizontal"?this.$().width():this.$().height();var P=p.length;for(i=0;i<P;++i){d=p[i];if(P===1&&C.length===1){c=j;}else{c=parseFloat(f[d])/100*j;}this._calculatedSizes[d]=c;r-=c;}j=r;if(j<0){w=true;j=0;}c=Math.floor(j/(h.length+g.length),0);var k=h.length;for(i=0;i<k;++i){d=h[i];var m=parseInt(C[d].getLayoutData().getMinSize(),10);if(m>c){this._calculatedSizes[d]=m;j-=m;}else{this._calculatedSizes[d]=c;j-=c;}}if(j<0){w=true;j=0;}r=j;var n=g.length;c=Math.floor(j/n,0);for(i=0;i<n;++i){d=g[i];this._calculatedSizes[d]=c;r-=c;}if(w){q.sap.log.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}this._calculatedSizes=this._calculatedSizes;};
A.prototype._ensureAllSplittersCollapsed=function(B){var c=this._getContentAreas();var d=false;for(var i=0;i<c.length;i++){var s=c[i].getLayoutData().getSize().slice(0,-2);if(s==="0"||s==="au"){d=true;continue;}else if(i===(c.length-1)&&d){this._getContentAreas()[B+1].setLayoutData(new sap.ui.layout.SplitterLayoutData({size:"100%"}));}}};
function _(c){var l=c.getLayoutData();if(l&&(!l.getResizable||!l.getSize||!l.getMinSize)){q.sap.log.warning("Content \""+c.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");l=null;}if(!l){c.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}
function b(t){var p=function(e){e.preventDefault();};var f=null;f=function(){document.removeEventListener("touchend",f);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",f);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",f);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",f);document.addEventListener("mousemove",p);}}
return A;});
sap.ui.predefine('sap/ui/layout/BlockLayout.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref",actions:{move:"moveControls"}}}};},false);
sap.ui.predefine('sap/ui/layout/BlockLayout',['sap/ui/core/Control','./library','jquery.sap.global','sap/ui/core/ResizeHandler'],function(C,l,q,R){"use strict";
var B=C.extend("sap.ui.layout.BlockLayout",{metadata:{library:"sap.ui.layout",properties:{background:{type:"sap.ui.layout.BlockBackgroundType",group:"Appearance",defaultValue:"Default"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutRow",multiple:true}},designTime:true}});
B.CONSTANTS={SIZES:{S:600,M:1024,L:1440,XL:null}};
B.prototype.init=function(){this._currentBreakpoint=null;};
B.prototype.onBeforeRendering=function(){this._detachResizeHandler();};
B.prototype.onAfterRendering=function(){this._onParentResize();this._notifySizeListeners();};
B.prototype.setBackground=function(n){var c=this.getBackground(),o=C.prototype.setProperty.apply(this,["background"].concat(Array.prototype.slice.call(arguments)));if(this.hasStyleClass("sapUiBlockLayoutBackground"+c)){this.removeStyleClass("sapUiBlockLayoutBackground"+c,true);}n=n?n:"Default";this.addStyleClass("sapUiBlockLayoutBackground"+n,true);this.invalidate();return o;};
B.prototype._onParentResize=function(){var p,d=this.getDomRef(),w=d.clientWidth,s=B.CONSTANTS.SIZES;this._detachResizeHandler();if(w>0){this._removeBreakpointClasses();for(p in s){if(s.hasOwnProperty(p)&&(s[p]===null||s[p]>w)){if(this._currentBreakpoint!=p){this._currentBreakpoint=p;this._notifySizeListeners();}this.addStyleClass("sapUiBlockLayoutSize"+p,true);break;}}}this._attachResizeHandler();};
B.prototype._notifySizeListeners=function(){var t=this;this.getContent().forEach(function(r){r._onParentSizeChange(t._currentBreakpoint);});};
B.prototype._removeBreakpointClasses=function(){var s=B.CONSTANTS.SIZES;for(var p in s){if(s.hasOwnProperty(p)){this.removeStyleClass("sapUiBlockLayoutSize"+p,true);}}};
B.prototype._attachResizeHandler=function(){if(!this._parentResizeHandler){this._parentResizeHandler=R.register(this,this._onParentResize.bind(this));}};
B.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){R.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};
B.prototype.exit=function(){this._detachResizeHandler();};
return B;});
sap.ui.predefine('sap/ui/layout/BlockLayoutCell.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref",actions:{move:"moveControls"}}},actions:{remove:{changeType:"hideControl"},rename:{changeType:"rename",domRef:function(c){return c.$().find(".sapUiBlockCellTitle")[0];}},reveal:{changeType:"unhideControl"}}};},false);
sap.ui.predefine('sap/ui/layout/BlockLayoutCell',['sap/ui/core/Control','./library'],function(C,l){"use strict";
var B=C.extend("sap.ui.layout.BlockLayoutCell",{metadata:{library:"sap.ui.layout",properties:{title:{type:"string",group:"Appearance",defaultValue:null},titleAlignment:{type:"sap.ui.core.HorizontalAlign",group:"Appearance",defaultValue:"Begin"},titleLevel:{type:"sap.ui.core.TitleLevel",group:"Appearance",defaultValue:"Auto"},width:{type:"int",group:"Appearance",defaultValue:0},backgroundColorSet:{type:"sap.ui.layout.BlockLayoutCellColorSet",group:"Appearance"},backgroundColorShade:{type:"sap.ui.layout.BlockLayoutCellColorShade",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designTime:true}});
B.prototype.setLayoutData=function(L){this.setAggregation("layoutData",L,true);var r=this.getParent();if(r){var e=jQuery.Event("LayoutDataChange");e.srcControl=this;r._handleEvent(e);}if(this.getWidth()!=0){this.getLayoutData().setSize(this.getWidth());}return this;};
B.prototype._setParentRowScrollable=function(s){this._parentRowScrollable=s;};
B.prototype._getParentRowScrollable=function(){return this._parentRowScrollable;};
B.prototype._setFlexWidth=function(f){this._flexWidth=f;};
B.prototype._getFlexWidth=function(){return this._flexWidth;};
return B;});
sap.ui.predefine('sap/ui/layout/BlockLayoutCellData',['sap/ui/core/LayoutData','./library'],function(L,l){"use strict";
var B=L.extend("sap.ui.layout.BlockLayoutCellData",{metadata:{library:"sap.ui.layout",properties:{sSize:{type:"int",group:"Appearance",defaultValue:1},mSize:{type:"int",group:"Appearance",defaultValue:1},lSize:{type:"int",group:"Appearance",defaultValue:1},xlSize:{type:"int",group:"Appearance",defaultValue:1}}}});
B.prototype.breakRowOnSSize=true;B.prototype.breakRowOnMSize=false;B.prototype.breakRowOnLSize=false;B.prototype.breakRowOnXlSize=false;
B.prototype.setSize=function(v){this.setProperty("mSize",v);this.setProperty("lSize",v);this.setProperty("xlSize",v);var r=this.getParent();if(r&&r.getParent()){r.getParent().invalidate();}return this;};
return B;});
sap.ui.predefine('sap/ui/layout/BlockLayoutCellRenderer',['jquery.sap.global','./library','sap/ui/core/library'],function(q,l,c){"use strict";var T=c.TitleLevel;var B={};
B.render=function(r,b){this.startCell(r,b);this.addContent(r,b);this.endCell(r);};
B.startCell=function(r,b){var C=this.getCellColor(r,b);r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayoutCell");C&&r.addClass(C);this.setWidth(r,b);r.writeStyles();r.writeClasses();r.write(">");};
B.getCellColor=function(r,b){var C=b.getBackgroundColorSet(),s=b.getBackgroundColorShade();if(!C&&!s){return"";}else if((C&&!s)||(!C&&s)){q.sap.log.warning("Both, backgroundColorSet and backgroundColorShade should be defined. ColoSet is not applied to "+b.getId()+".");return"";}C=C.replace("ColorSet","");s=s.replace("Shade","");return"sapUiBlockLayoutCellColor"+C+s;};
B.setWidth=function(r,b){if(b._getParentRowScrollable()){var w=b.getWidth();if(w!==0){r.addStyle("width",w+"%");}}else{this.addFlex(r,b._getFlexWidth());}};
B.addFlex=function(r,f){r.addStyle("-webkit-flex",f);r.addStyle("-ms-flex",f);r.addStyle("flex",f);};
B.addTitle=function(r,b){if(b.getTitle()){var a="sapUiBlockCell"+b.getTitleAlignment(),t="sapUiBlockCellTitle "+a;if(b.getContent().length===0){t+=" sapUiBlockCellTitleNoContent";}var d=b.getTitleLevel(),e=d===T.Auto,f=e?"h2":d;r.write("<"+f+" id='"+this.getTitleId(b)+"' class='"+t+"'>");r.writeEscaped(b.getTitle());r.write("</"+f+">");}};
B.getTitleId=function(b){return b.getId()+"-Title";};
B.addContent=function(r,b){var a=b.getContent(),d="sapUiBlockCellContent ";if(b.getTitleAlignment()==="Center"){d+="sapUiBlockCellCenteredContent";}r.write("<div class='"+d+"' aria-labelledby='"+this.getTitleId(b)+"' >");this.addTitle(r,b);a.forEach(r.renderControl);r.write("</div>");};
B.endCell=function(r){r.write("</div>");};
return B;},true);
sap.ui.predefine('sap/ui/layout/BlockLayoutRenderer',['./library'],function(l){"use strict";var B=l.BlockRowColorSets;var a={};
a.render=function(r,b){this.startLayout(r,b);this.addContent(r,b);this.endLayout(r);};
a.startLayout=function(r,b){var c=b.getBackground();b.addStyleClass("sapUiBlockLayoutBackground"+c);r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayout");r.writeStyles();r.writeClasses();r.write(">");};
a.addContent=function(r,b){var c=b.getContent(),o=B,t=Object.keys(o).map(function(k){return o[k];}),n=t.length;c.forEach(function(d,i,R){var T=d.getRowColorSet()||t[i%n],C="sapUiBlockLayoutBackground"+T,p=(i&&R[i-1])||null;if(p&&p.hasStyleClass(C)){d.removeStyleClass(C);C+="Inverted";}if(C){d.addStyleClass(C);}r.renderControl(d);});};
a.endLayout=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/layout/BlockLayoutRow.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref",actions:{move:"moveControls"}}},actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}}};},false);
sap.ui.predefine('sap/ui/layout/BlockLayoutRow',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/layout/BlockLayoutCellData'],function(q,C,l,B){"use strict";var a=l.BlockBackgroundType;var b=l.BlockRowColorSets;
var c=C.extend("sap.ui.layout.BlockLayoutRow",{metadata:{library:"sap.ui.layout",properties:{scrollable:{type:"boolean",group:"Appearance",defaultValue:false},rowColorSet:{type:"sap.ui.layout.BlockRowColorSets",group:"Appearance"}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"content"}},associations:{accentCells:{type:"sap.ui.layout.BlockLayoutCell",multiple:true,singularName:"accentCell"}},designTime:true}});
c.prototype.init=function(){this._applyLayoutData={};};
c.prototype.addContent=function(o){this._ensureLayoutData(o);return this.addAggregation("content",o);};
c.prototype.insertContent=function(o,i){this._ensureLayoutData(o);return this.insertAggregation("content",o,i);};
c.prototype.onBeforeRendering=function(){var d=this.getContent(),t=this;d.forEach(function(o,i){o._setParentRowScrollable(t.getScrollable());});this._calculateBreakpointRendering();};
c.prototype.setRowColorSet=function(t){var A=Array.prototype.slice.call(arguments),o=C.prototype.setProperty.apply(this,["rowColorSet"].concat(A)),s="sapUiBlockLayoutBackground"+t,d=this.getParent(),e=d&&d.getBackground(),T=d&&d.indexOfAggregation("content",this),p=d&&d.getContent(),P=(T&&p[T-1])||null,n=(p&&p[T+1])||null,f=b,g=Object.keys(f).map(function(k){return f[k];}),i=false;if(P&&P._hasStyleClass(s,e,i,t)){s+="Inverted";i=true;}g.forEach(function(h){var j="sapUiBlockLayoutBackground"+h,I=j+"Inverted";if(this._hasStyleClass(j,e,false,h)){this.removeStyleClass(j,true);}else if(this._hasStyleClass(I,e,true,h)){this.removeStyleClass(I,true);}},this);this.addStyleClass(s,true);if(n&&n._hasStyleClass(s,e,i,t)){n.setRowColorSet.apply(n,A);}this.invalidate();return o;};
c.prototype.addAccentCell=function(i){var o,I=i&&i.getId?i.getId():i,d=Array.prototype.slice.call(arguments),e=a,f=this.getParent(),L=f&&(f.getBackground()||"");o=this.addAssociation.apply(this,["accentCells"].concat(d));if(!f){return this;}if([e.Accent,e.Mixed].indexOf(L)===-1){q.sap.log.warning(I+" was not se as accent cell. Accent cells could be set only for 'Accent' and 'Mixed' layout backgrounds.");return this;}if(e.Mixed===L){this._processMixedCellStyles(I,this.getContent());}else if(e.Accent===L){this._processAccentCellStyles(this.getAccentCells(),this.getContent());}return o;};
c.prototype._ensureLayoutData=function(o){var O=o.getLayoutData();if(!O||!(O instanceof B)){o.setLayoutData(new B());}};
c.prototype._onParentSizeChange=function(d){this._currentSize=d;this._calculateBreakpointRendering();this.invalidate();};
c.prototype._getCellArangementForCurrentSize=function(){if(!this._arrangements||!this._currentSize){return null;}return this._arrangements[this._currentSize];};
c.prototype._calculateBreakpointRendering=function(){if(!this._currentSize){return;}this._arrangements={"S":this._calcArrangementForSize("S"),"M":this._calcArrangementForSize("M"),"L":this._calcArrangementForSize("L"),"XL":this._calcArrangementForSize("Xl")};};
c.prototype._calcArrangementForSize=function(s){var d=this.getContent();if(d.length>=3&&s==="M"&&d.length<5){return this._generateArrangementForMCase();}else{return this._generateArrangement(s);}};
c.prototype._generateArrangement=function(s){var L,I=0,f=[],d=[],A=[[]],e=this.getContent();e.forEach(function(o){L=o.getLayoutData();d.push(L["breakRowOn"+s+"Size"]);f.push(L["get"+s+"Size"]());});f.forEach(function(D,i){A[I].push(D);if(d[i+1]){I++;A[I]=[];}});return A;};
c.prototype._generateArrangementForMCase=function(){var d=this.getContent();if(d.length===3&&this._isAllCellsHasSameWidth("M")){return[[1,1,1]];}else if(d.length===3){return[[1,1],[1]];}else if(d.length===4){return[[1,1],[1,1]];}};
c.prototype._isAllCellsHasSameWidth=function(s){var d,e=this.getContent(),f=e[0].getLayoutData()["get"+s+"Size"]();for(var i=1;i<e.length;i++){d=e[i].getLayoutData()["get"+s+"Size"]();if(d!==f){return false;}}return true;};
c.prototype._processMixedCellStyles=function(i,d){var o,p;if(!d||!d.length){q.sap.log.warning("No accent cells were set");return this;}o=this.getParent();p=o&&(o.hasStyleClass("sapUiBlockLayoutSizeL")||o.hasStyleClass("sapUiBlockLayoutSizeXL"));d.forEach(function(e){var f,u;if(p&&e.getId()===i&&e.getWidth()===1){e.addStyleClass("sapContrast").addStyleClass("sapContrastPlus");f=b;u=this._hasStyleClass("sapUiBlockLayoutBackground"+f.ColorSet1,a.Mixed,false,f.ColorSet1)||this._hasStyleClass("sapUiBlockLayoutBackground"+f.ColorSet1,a.Mixed,true,f.ColorSet1);if(u){e.addStyleClass("sapUiBlockLayoutBackgroundContrast2");}}else if((!p||e.getId()!==i)&&(e.hasStyleClass("sapContrast")||e.hasStyleClass("sapContrastPlus"))){e.removeStyleClass("sapContrast").removeStyleClass("sapContrastPlus").removeStyleClass("sapUiBlockLayoutBackgroundContrast2");this.removeAssociation("accentCells",e);q.sap.log.warning(i+" was removed as accent cell. Only one cell at a time could be accented for Mixed layout background");}},this);return this;};
c.prototype._processAccentCellStyles=function(A,r){var o,s,d,i=0,I=0,e=Array.prototype.slice.call(A);if(!A||!A.length){q.sap.log.warning("No accent cells were set");return this;}for(i=0;i<r.length;i++){o=r[i];s=o.getId();if(!e.length){break;}if(e.indexOf(s)>-1){I++;d="sapUiBlockLayoutBackgroundColorSetGray"+((I%2)+1);if(o.hasStyleClass(d)){continue;}e.splice(e.indexOf(s),1);o.removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray1").removeStyleClass("sapUiBlockLayoutBackgroundColorSetGray2").addStyleClass(d);}}return this;};
c.prototype._hasStyleClass=function(s,L,I,t){var o=a,d=b,i,S,e;if([o.Light,o.Mixed].indexOf(L)===-1){return this.hasStyleClass(s);}else if(this.hasStyleClass(s)){return true;}e=[[d.ColorSet1,d.ColorSet3],[d.ColorSet2,d.ColorSet4]];for(i=0;i<=e.length;i++){if(e[i]&&e[i].indexOf(t)>-1){break;}}if(!e[i]){return false;}S=e[i].map(function(f){return"sapUiBlockLayoutBackground"+f+(I?"Inverted":"");});return S.some(this.hasStyleClass,this);};
return c;});
sap.ui.predefine('sap/ui/layout/BlockLayoutRowRenderer',['./library'],function(l){"use strict";var B=l.BlockBackgroundType;var a={};
a.render=function(r,b){this.startRow(r,b);this.renderContent(r,b);this.endRow(r,b);};
a.startRow=function(r,b){r.write("<div");r.writeControlData(b);r.addClass("sapUiBlockLayoutRow");this.addRowRenderingClass(r,b);r.writeStyles();r.writeClasses();r.write(">");};
a.addRowRenderingClass=function(r,b){if(b.getScrollable()){r.addClass("sapUiBlockScrollingRow");if(b.getContent().length>=6){r.addClass("sapUiBlockScrollingNarrowCells");}}else{r.addClass("sapUiBlockHorizontalCellsRow");}};
a.renderContent=function(r,b){var c=b.getContent(),s=b.getScrollable(),o=B,L=b.getParent().getBackground(),A=b.getAccentCells(),C=0,f;c.forEach(function(e,g){(g%2)==0?e.addStyleClass("sapUiBlockLayoutOddCell"):e.addStyleClass("sapUiBlockLayoutEvenCell");if(s){e.addStyleClass("sapUiBlockScrollableCell");}else{e.addStyleClass("sapUiBlockHorizontalCell");}});switch(L){case o.Mixed:b._processMixedCellStyles(A[0],c);break;case o.Accent:b._processAccentCellStyles(A,c);break;}var d=b._getCellArangementForCurrentSize();if(s){c.forEach(r.renderControl);}else if(d){for(var i=0;i<d.length;i++){var S=d[i];r.write("<div ");r.addStyle("display","flex");r.writeStyles();r.write(">");for(var j=0;j<S.length;j++){f=S[j];c[C]._setFlexWidth(f);r.renderControl(c[C]);C++;}r.write("</div>");}}};
a.endRow=function(r){r.write("</div>");};
return a;},true);
sap.ui.predefine('sap/ui/layout/DynamicSideContent',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','sap/ui/layout/library'],function(q,C,R,l){"use strict";var a=l.SideContentPosition;var b=l.SideContentFallDown;var c=l.SideContentVisibility;
var D=C.extend("sap.ui.layout.DynamicSideContent",{metadata:{library:"sap.ui.layout",properties:{showSideContent:{type:"boolean",group:"Appearance",defaultValue:true},showMainContent:{type:"boolean",group:"Appearance",defaultValue:true},sideContentVisibility:{type:"sap.ui.layout.SideContentVisibility",group:"Appearance",defaultValue:c.ShowAboveS},sideContentFallDown:{type:"sap.ui.layout.SideContentFallDown",group:"Appearance",defaultValue:b.OnMinimumWidth},equalSplit:{type:"boolean",group:"Appearance",defaultValue:false},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false},sideContentPosition:{type:"sap.ui.layout.SideContentPosition",group:"Appearance",defaultValue:a.End}},defaultAggregation:"mainContent",events:{breakpointChanged:{parameters:{currentBreakpoint:{type:"string"}}}},aggregations:{mainContent:{type:"sap.ui.core.Control",multiple:true},sideContent:{type:"sap.ui.core.Control",multiple:true}}}});
var S="S",M="M",L="L",X="XL",H="sapUiHidden",d="sapUiDSCSpan12",e="sapUiDSCMCFixed",f="sapUiDSCSCFixed",g=3,h=4,i=6,j=8,k=9,m=12,I="Invalid Breakpoint. Expected: S, M, L or XL",n="SCGridCell",o="MCGridCell",p=720,r=1024,s=1440;
D.prototype.init=function(){this._bSuppressInitialFireBreakPointChange=true;};
D.prototype.setSideContentVisibility=function(v,t){this.setProperty("sideContentVisibility",v,true);if(!t&&this.$().length){this._setResizeData(this.getCurrentBreakpoint());this._changeGridState();}return this;};
D.prototype.setShowSideContent=function(v,t){this.setProperty("showSideContent",v,true);this._SCVisible=v;if(!t&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._MCVisible=true;}this._changeGridState();}return this;};
D.prototype.setShowMainContent=function(v,t){this.setProperty("showMainContent",v,true);this._MCVisible=v;if(!t&&this.$().length){this._setResizeData(this.getCurrentBreakpoint(),this.getEqualSplit());if(this._currentBreakpoint===S){this._SCVisible=true;}this._changeGridState();}return this;};
D.prototype.getShowSideContent=function(){if(this._currentBreakpoint===S){return this._SCVisible&&this.getProperty("showSideContent");}else{return this.getProperty("showSideContent");}};
D.prototype.getShowMainContent=function(){if(this._currentBreakpoint===S){return this._MCVisible&&this.getProperty("showMainContent");}else{return this.getProperty("showMainContent");}};
D.prototype.setEqualSplit=function(t){this._MCVisible=true;this._SCVisible=true;this.setProperty("equalSplit",t,true);if(this._currentBreakpoint){this._setResizeData(this._currentBreakpoint,t);this._changeGridState();}return this;};
D.prototype.addSideContent=function(t){this.addAggregation("sideContent",t,true);this._rerenderControl(this.getAggregation("sideContent"),this.$(n));return this;};
D.prototype.addMainContent=function(t){this.addAggregation("mainContent",t,true);this._rerenderControl(this.getAggregation("mainContent"),this.$(o));return this;};
D.prototype.toggle=function(){if(this._currentBreakpoint===S){if(!this.getProperty("showMainContent")){this.setShowMainContent(true,true);this._MCVisible=false;}if(!this.getProperty("showSideContent")){this.setShowSideContent(true,true);this._SCVisible=false;}if(this._MCVisible&&!this._SCVisible){this._SCVisible=true;this._MCVisible=false;}else if(!this._MCVisible&&this._SCVisible){this._MCVisible=true;this._SCVisible=false;}this._changeGridState();}return this;};
D.prototype.getCurrentBreakpoint=function(){return this._currentBreakpoint;};
D.prototype.onBeforeRendering=function(){this._detachContainerResizeListener();this._SCVisible=this.getProperty("showSideContent");this._MCVisible=this.getProperty("showMainContent");if(!this.getContainerQuery()){this._iWindowWidth=q(window).width();this._setBreakpointFromWidth(this._iWindowWidth);this._setResizeData(this._currentBreakpoint,this.getEqualSplit());}};
D.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._attachContainerResizeListener();this._adjustToScreenSize();}else{var t=this;q(window).resize(function(){t._adjustToScreenSize();});}this._changeGridState();this._initScrolling();};
D.prototype.exit=function(){this._detachContainerResizeListener();if(this._oSCScroller){this._oSCScroller.destroy();this._oSCScroller=null;}if(this._oMCScroller){this._oMCScroller.destroy();this._oMCScroller=null;}};
D.prototype._rerenderControl=function(t,$){if(this.getDomRef()){var u=sap.ui.getCore().createRenderManager();this.getRenderer().renderControls(u,t);u.flush($[0]);u.destroy();}return this;};
D.prototype._initScrolling=function(){var t=this.getId(),u=t+"-"+n,v=t+"-"+o;if(!this._oSCScroller&&!this._oMCScroller){q.sap.require("sap.ui.core.delegate.ScrollEnablement");this._oSCScroller=new sap.ui.core.delegate.ScrollEnablement(this,null,{scrollContainerId:u,horizontal:false,vertical:true});this._oMCScroller=new sap.ui.core.delegate.ScrollEnablement(this,null,{scrollContainerId:v,horizontal:false,vertical:true});}};
D.prototype._attachContainerResizeListener=function(){if(!this._sContainerResizeListener){this._sContainerResizeListener=R.register(this,q.proxy(this._adjustToScreenSize,this));}};
D.prototype._detachContainerResizeListener=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}};
D.prototype._getBreakPointFromWidth=function(w){if(w<=p&&this._currentBreakpoint!==S){return S;}else if((w>p)&&(w<=r)&&this._currentBreakpoint!==M){return M;}else if((w>r)&&(w<=s)&&this._currentBreakpoint!==L){return L;}else if(w>s&&this._currentBreakpoint!==X){return X;}return this._currentBreakpoint;};
D.prototype._setBreakpointFromWidth=function(w){this._currentBreakpoint=this._getBreakPointFromWidth(w);if(this._bSuppressInitialFireBreakPointChange){this._bSuppressInitialFireBreakPointChange=false;}else{this.fireBreakpointChanged({currentBreakpoint:this._currentBreakpoint});}};
D.prototype._adjustToScreenSize=function(){if(this.getContainerQuery()){this._iWindowWidth=this.$().parent().width();}else{this._iWindowWidth=q(window).width();}if(this._iWindowWidth!==this._iOldWindowWidth){this._iOldWindowWidth=this._iWindowWidth;this._oldBreakPoint=this._currentBreakpoint;this._setBreakpointFromWidth(this._iWindowWidth);if((this._oldBreakPoint!==this._currentBreakpoint)||(this._currentBreakpoint===M&&this.getSideContentFallDown()===b.OnMinimumWidth)){this._setResizeData(this._currentBreakpoint,this.getEqualSplit());this._changeGridState();}}};
D.prototype._setResizeData=function(t,u){var v=this.getSideContentVisibility(),w=this.getSideContentFallDown();if(!u){switch(t){case S:this._setSpanSize(m,m);if(this.getProperty("showSideContent")&&this.getProperty("showMainContent")){this._SCVisible=v===c.AlwaysShow;}this._bFixedSideContent=false;break;case M:var x=Math.ceil((33.333/100)*this._iWindowWidth);if(w===b.BelowL||w===b.BelowXL||(x<=320&&w===b.OnMinimumWidth)){this._setSpanSize(m,m);this._bFixedSideContent=false;}else{this._setSpanSize(h,j);this._bFixedSideContent=true;}this._SCVisible=v===c.ShowAboveS||v===c.AlwaysShow;this._MCVisible=true;break;case L:if(w===b.BelowXL){this._setSpanSize(m,m);}else{this._setSpanSize(h,j);}this._SCVisible=v===c.ShowAboveS||v===c.ShowAboveM||v===c.AlwaysShow;this._MCVisible=true;this._bFixedSideContent=false;break;case X:this._setSpanSize(g,k);this._SCVisible=v!==c.NeverShow;this._MCVisible=true;this._bFixedSideContent=false;break;default:throw new Error(I);}}else{switch(t){case S:this._setSpanSize(m,m);this._SCVisible=false;break;default:this._setSpanSize(i,i);this._SCVisible=true;this._MCVisible=true;}this._bFixedSideContent=false;}return this;};
D.prototype._shouldSetHeight=function(){var t,B,O,u,v,F,w;t=(this._iScSpan+this._iMcSpan)===m;B=this._MCVisible&&this._SCVisible;O=!this._MCVisible&&this._SCVisible;u=this._MCVisible&&!this._SCVisible;v=O||u;F=this._fixedSideContent;w=this.getSideContentVisibility()===c.NeverShow;return((t&&B)||v||F||w);};
D.prototype._changeGridState=function(){var $=this.$(n),t=this.$(o),u=this.getProperty("showMainContent"),v=this.getProperty("showSideContent");if(this._bFixedSideContent){$.removeClass().addClass(f);t.removeClass().addClass(e);}else{$.removeClass(f);t.removeClass(e);}if(this._SCVisible&&this._MCVisible&&v&&u){if(!this._bFixedSideContent){t.removeClass().addClass("sapUiDSCSpan"+this._iMcSpan);$.removeClass().addClass("sapUiDSCSpan"+this._iScSpan);}if(this._shouldSetHeight()){$.css("height","100%").css("float","left");t.css("height","100%").css("float","left");}else{$.css("height","auto").css("float","none");t.css("height","auto").css("float","none");}}else if(!this._SCVisible&&!this._MCVisible){t.addClass(H);$.addClass(H);}else if(this._MCVisible&&u){t.removeClass().addClass(d);$.addClass(H);}else if(this._SCVisible&&v){$.removeClass().addClass(d);t.addClass(H);}else if(!u&&!v){t.addClass(H);$.addClass(H);}};
D.prototype._setSpanSize=function(t,u){this._iScSpan=t;this._iMcSpan=u;};
return D;});
sap.ui.predefine('sap/ui/layout/DynamicSideContentRenderer',["sap/ui/layout/library","sap/ui/Device"],function(l,D){"use strict";var S=l.SideContentPosition;var a="SIDE_CONTENT_LABEL";var b={};
b.render=function(r,s){r.write("<div");r.writeControlData(s);r.addClass("sapUiDSC");r.writeClasses();r.addStyle("height","100%");r.writeStyles();r.write(">");this.renderSubControls(r,s);r.write("</div>");};
b.renderSubControls=function(r,s){var i=s.getId(),c=s._shouldSetHeight(),p=sap.ui.getCore().getConfiguration().getRTL(),d=s.getSideContentPosition();if((d===S.Begin&&!p)||(p&&d===S.End)){this._renderSideContent(r,s,i,c);this._renderMainContent(r,s,i,c);}else{this._renderMainContent(r,s,i,c);this._renderSideContent(r,s,i,c);}};
b.renderControls=function(r,c){var L=c.length,i=0;for(;i<L;i++){r.renderControl(c[i]);}};
b._renderMainContent=function(r,s,i,c){r.write("<div id='"+i+"-MCGridCell'");if(s._iMcSpan){r.addClass("sapUiDSCSpan"+s._iMcSpan);r.writeClasses();}if(c){r.addStyle("height","100%");r.writeStyles();}r.write(">");this.renderControls(r,s.getMainContent());r.write("</div>");};
b._renderSideContent=function(r,s,i,c){var d=D.browser.firefox?"div":"aside";r.write("<"+d+" id='"+i+"-SCGridCell'");var m=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");r.writeAttribute("aria-label",m.getText(a));r.writeAccessibilityState(s,{role:"complementary"});if(s._iScSpan){r.addClass("sapUiDSCSpan"+s._iScSpan);r.writeClasses();}if(c){r.addStyle("height","100%");r.writeStyles();}r.write(">");this.renderControls(r,s.getSideContent());r.write("</"+d+">");};
return b;},true);
sap.ui.predefine('sap/ui/layout/FixFlex.designtime',[],function(){"use strict";return{aggregations:{fixContent:{domRef:":sap-domref > .sapUiFixFlexFixed",actions:{move:"moveControls"}},flexContent:{domRef:":sap-domref > .sapUiFixFlexFlexible"}},actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}}};},false);
sap.ui.predefine('sap/ui/layout/FixFlex',["jquery.sap.global","sap/ui/core/Control","sap/ui/core/EnabledPropagator","sap/ui/core/ResizeHandler","./library","sap/ui/core/delegate/ScrollEnablement"],function(q,C,E,R,l,S){"use strict";
var F=C.extend("sap.ui.layout.FixFlex",{metadata:{library:"sap.ui.layout",properties:{vertical:{type:"boolean",group:"Appearance",defaultValue:true},fixFirst:{type:"boolean",group:"Misc",defaultValue:true},fixContentSize:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"auto"},minFlexSize:{type:"int",defaultValue:0}},aggregations:{fixContent:{type:"sap.ui.core.Control",multiple:true,singularName:"fixContent"},flexContent:{type:"sap.ui.core.Control",multiple:false}},designTime:true}});
E.call(F.prototype);
F.prototype.init=function(){this._scroller=new S(this,null,{scrollContainerId:this.getId()});this._innerScroller=new S(this,this.getId()+"-FlexibleContainer",{scrollContainerId:this.getId()+"-Flexible"});};
F.prototype.getScrollDelegate=function(){return this._innerScroller;};
F.prototype._handlerResizeNoFlexBoxSupport=function(){var c=this.$(),f,$;if(!c.is(":visible")){return;}f=this.$("Fixed");$=this.$("Flexible");f.removeAttr("style");$.removeAttr("style");if(this.getVertical()){if(this.getFixContentSize()!=='auto'){f.height(this.getFixContentSize());}$.height(Math.floor(c.height()-f.height()));}else{if(this.getFixContentSize()!=='auto'){f.width(this.getFixContentSize());$.width(Math.floor(c.width()-f.width()));}else{$.width(Math.floor(c.width()-f.width()));f.width(Math.floor(f.width()));}}};
F.prototype._deregisterControl=function(){if(this.sResizeListenerNoFlexBoxSupportId){R.deregister(this.sResizeListenerNoFlexBoxSupportId);this.sResizeListenerNoFlexBoxSupportId=null;}if(this.sResizeListenerNoFlexBoxSupportFixedId){R.deregister(this.sResizeListenerNoFlexBoxSupportFixedId);this.sResizeListenerNoFlexBoxSupportFixedId=null;}if(this.sResizeListenerFixFlexScroll){R.deregister(this.sResizeListenerFixFlexScroll);this.sResizeListenerFixFlexScroll=null;}if(this.sResizeListenerFixFlexScrollFlexPart){R.deregister(this.sResizeListenerFixFlexScrollFlexPart);this.sResizeListenerFixFlexScrollFlexPart=null;}if(this.sResizeListenerFixFlexContainerScroll){R.deregister(this.sResizeListenerFixFlexContainerScroll);this.sResizeListenerFixFlexContainerScroll=null;}};
F.prototype._changeScrolling=function(){var n,d,$=this.$(),a=this.getMinFlexSize(),i=this.getVertical();if(i){n=this.$().height()-this.$("Fixed").height();d="height";}else{n=this.$().width()-this.$("Fixed").width();d="width";}if(n<=parseInt(this.getMinFlexSize(),10)){$.addClass("sapUiFixFlexScrolling");$.removeClass("sapUiFixFlexInnerScrolling");if(i){this._scroller.setVertical(true);this._innerScroller.setVertical(false);}else{this._scroller.setHorizontal(true);this._innerScroller.setHorizontal(false);}if(this.$("FlexibleContainer").children().height()>a){this.$("Flexible").attr("style","min-"+d+":"+a+"px");}else{this.$("Flexible").attr("style",d+":"+a+"px");}}else{$.addClass("sapUiFixFlexInnerScrolling");$.removeClass("sapUiFixFlexScrolling");if(i){this._scroller.setVertical(false);this._innerScroller.setVertical(true);}else{this._scroller.setHorizontal(false);this._innerScroller.setHorizontal(true);}this._changeFlexibleContainerScroll();this.$("Flexible").removeAttr("style");}};
F.prototype._changeFlexibleContainerScroll=function(){var $=this.$("FlexibleContainer"),c=$.height(),a=$.children().height();if(c==a){return;}if(c>a){$.removeClass('sapUiFixFlexFlexibleContainerGrowing');}else{$.addClass('sapUiFixFlexFlexibleContainerGrowing');}};
F.prototype.exit=function(){this._deregisterControl();if(this._scroller){this._scroller.destroy();this._scroller=null;}if(this._innerScroller){this._innerScroller.destroy();this._innerScroller=null;}};
F.prototype.onBeforeRendering=function(){var s=this._scroller,i=this._innerScroller,b=this.getMinFlexSize()!=0;this._deregisterControl();s.setVertical(false);s.setHorizontal(false);i.setVertical(b);i.setHorizontal(b);};
F.prototype.onAfterRendering=function(){if(!q.support.hasFlexBoxSupport){this.sResizeListenerNoFlexBoxSupportFixedId=R.register(this.getDomRef("Fixed"),q.proxy(this._handlerResizeNoFlexBoxSupport,this));this.sResizeListenerNoFlexBoxSupportId=R.register(this.getDomRef(),q.proxy(this._handlerResizeNoFlexBoxSupport,this));this._handlerResizeNoFlexBoxSupport();}if(this.getMinFlexSize()!==0){this.sResizeListenerFixFlexScroll=R.register(this.getDomRef(),q.proxy(this._changeScrolling,this));this.sResizeListenerFixFlexScrollFlexPart=R.register(this.getDomRef("Fixed"),q.proxy(this._changeScrolling,this));var f=this.$("FlexibleContainer").children()[0];if(f){this.sResizeListenerFixFlexContainerScroll=R.register(f,q.proxy(this._changeFlexibleContainerScroll,this));}this._changeScrolling();}};
return F;});
sap.ui.predefine('sap/ui/layout/FixFlexRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){r.write('<div');r.writeControlData(c);r.addClass('sapUiFixFlex');if(c.getMinFlexSize()!==0){r.addClass('sapUiFixFlexInnerScrolling');}if(!c.getVertical()){r.addClass('sapUiFixFlexRow');}if(!q.support.hasFlexBoxSupport){r.addClass('sapUiFixFlex-Legacy');}r.writeClasses();r.write('>');if(c.getFixFirst()){this.renderFixChild(r,c);this.renderFlexChild(r,c);}else{this.renderFlexChild(r,c);this.renderFixChild(r,c);}r.write('</div>');};
F.renderFixChild=function(r,c){var f=c.getFixContent();r.write('<div id="'+c.getId()+'-Fixed" class="sapUiFixFlexFixed"');if(c.getFixContentSize()!=='auto'){if(c.getVertical()){r.addStyle('height',c.getFixContentSize());}else{r.addStyle('width',c.getFixContentSize());}r.writeStyles();}r.write('>');for(var i=0;i<f.length;i++){r.renderControl(f[i]);}r.write('</div>');};
F.renderFlexChild=function(r,c){var f=c.getFlexContent();r.write('<div id="'+c.getId()+'-Flexible" class="sapUiFixFlexFlexible">');r.write('<div id="'+c.getId()+'-FlexibleContainer" class="sapUiFixFlexFlexibleContainer"');if(c.getMinFlexSize()!==0){if(c.getVertical()){r.write('style="min-height:'+c.getMinFlexSize()+'px"');}else{r.write('style="min-width:'+c.getMinFlexSize()+'px"');}}r.write('>');r.renderControl(f);r.write('</div>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/layout/Grid.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},aggregations:{content:{domRef:":sap-domref",actions:{move:"moveControls"}}},name:{singular:"GRID_CONTROL_NAME",plural:"GRID_CONTROL_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/ui/layout/Grid',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/Device','sap/ui/core/ResizeHandler'],function(q,C,l,D,R){"use strict";
var G=C.extend("sap.ui.layout.Grid",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},vSpacing:{type:"float",group:"Dimension",defaultValue:1},hSpacing:{type:"float",group:"Dimension",defaultValue:1},position:{type:"sap.ui.layout.GridPosition",group:"Dimension",defaultValue:"Left"},defaultSpan:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:"XL3 L3 M6 S12"},defaultIndent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:"XL0 L0 M0 S0"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});
(function(){
G.prototype.init=function(){this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._indentXLChanged=false;this._spanXLChanged=false;};
G.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this,q.proxy(this._onParentResize,this));this._onParentResize();}else{this._attachMediaContainerWidthChange(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD_EXTENDED);}};
G.prototype.onBeforeRendering=function(){this._cleanup();};
G.prototype.exit=function(){this._cleanup();};
G.prototype._cleanup=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}this._detachMediaContainerWidthChange(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD_EXTENDED);};
G.prototype._handleMediaChange=function(p){this._toggleClass(p.name);};
G.prototype._setBreakPointTablet=function(b){this._iBreakPointTablet=b;};
G.prototype._setBreakPointDesktop=function(b){this._iBreakPointDesktop=b;};
G.prototype._setBreakPointLargeDesktop=function(b){this._iBreakPointLargeDesktop=b;};
G.prototype.setDefaultIndent=function(d){if(/XL/gi.test(d)){this._setIndentXLChanged(true);}return this.setProperty("defaultIndent",d);};
G.prototype._setIndentXLChanged=function(c){this._indentXLChanged=c;};
G.prototype._getIndentXLChanged=function(){return this._indentXLChanged;};
G.prototype.setDefaultSpan=function(d){if(/XL/gi.test(d)){this._setSpanXLChanged(true);}return this.setProperty("defaultSpan",d);};
G.prototype._setSpanXLChanged=function(c){this._spanXLChanged=c;};
G.prototype._getSpanXLChanged=function(){return this._spanXLChanged;};
G.prototype._onParentResize=function(){var d=this.getDomRef();if(!d){this._cleanup();return;}if(!q(d).is(":visible")){return;}var c=d.clientWidth;if(c<=this._iBreakPointTablet){this._toggleClass("Phone");}else if((c>this._iBreakPointTablet)&&(c<=this._iBreakPointDesktop)){this._toggleClass("Tablet");}else if((c>this._iBreakPointDesktop)&&(c<=this._iBreakPointLargeDesktop)){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}};
G.prototype._toggleClass=function(m){var d=this.$();if(!d){return;}if(d.hasClass("sapUiRespGridMedia-Std-"+m)){return;}d.toggleClass("sapUiRespGridMedia-Std-"+m,true);if(m==="Phone"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="Tablet"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="LargeDesktop"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false);}else{d.toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}this.fireEvent("mediaChanged",{media:m});};
G.prototype._getLayoutDataForControl=function(c){var L=c.getLayoutData();if(!L){return undefined;}else if(L instanceof sap.ui.layout.GridData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var a=L.getMultipleLayoutData();for(var i=0;i<a.length;i++){var o=a[i];if(o instanceof sap.ui.layout.GridData){return o;}}}};
G.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};
G.prototype._getAccessibleRole=function(){return null;};
G.prototype.getAccessibilityInfo=function(){return{children:this.getContent().filter(function(c){return c.$().is(':visible');})};};
}());return G;});
sap.ui.predefine('sap/ui/layout/GridData',['jquery.sap.global','sap/ui/core/LayoutData','./library'],function(q,L,l){"use strict";
var G=L.extend("sap.ui.layout.GridData",{metadata:{library:"sap.ui.layout",properties:{span:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:null},spanXL:{type:"int",group:"Behavior",defaultValue:null},spanL:{type:"int",group:"Behavior",defaultValue:null},spanM:{type:"int",group:"Behavior",defaultValue:null},spanS:{type:"int",group:"Behavior",defaultValue:null},indent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:null},indentXL:{type:"int",group:"Behavior",defaultValue:null},indentL:{type:"int",group:"Behavior",defaultValue:null},indentM:{type:"int",group:"Behavior",defaultValue:null},indentS:{type:"int",group:"Behavior",defaultValue:null},visibleXL:{type:"boolean",group:"Behavior",defaultValue:true},visibleL:{type:"boolean",group:"Behavior",defaultValue:true},visibleM:{type:"boolean",group:"Behavior",defaultValue:true},visibleS:{type:"boolean",group:"Behavior",defaultValue:true},moveBackwards:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},moveForward:{type:"sap.ui.layout.GridIndent",group:"Misc",defaultValue:null},linebreak:{type:"boolean",group:"Misc",defaultValue:false},linebreakXL:{type:"boolean",group:"Misc",defaultValue:false},linebreakL:{type:"boolean",group:"Misc",defaultValue:false},linebreakM:{type:"boolean",group:"Misc",defaultValue:false},linebreakS:{type:"boolean",group:"Misc",defaultValue:false},spanLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},spanSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentLarge:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentMedium:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},indentSmall:{type:"int",group:"Behavior",defaultValue:null,deprecated:true},visibleOnLarge:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnMedium:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true},visibleOnSmall:{type:"boolean",group:"Behavior",defaultValue:true,deprecated:true}}}});
(function(){
G.prototype._setStylesInternal=function(s){if(s&&s.length>0){this._sStylesInternal=s;}else{this._sStylesInternal=undefined;}};
G.prototype._getEffectiveSpanXLarge=function(){var s=this.getSpanXL();if(s&&(s>0)&&(s<13)){return s;}var S=/XL([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,2)==="XL"){return parseInt(b.substr(2),10);}}}return undefined;};
G.prototype._getEffectiveSpanLarge=function(){var s=this.getSpanL();if(s&&(s>0)&&(s<13)){return s;}var S=/\bL([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,1)==="L"){return parseInt(b.substr(1),10);}}}return undefined;};
G.prototype._getEffectiveSpanMedium=function(){var s=this.getSpanM();if(s&&(s>0)&&(s<13)){return s;}var S=/M([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,1)==="M"){return parseInt(b.substr(1),10);}}}return undefined;};
G.prototype._getEffectiveSpanSmall=function(){var s=this.getSpanS();if(s&&(s>0)&&(s<13)){return s;}var S=/S([1-9]|1[0-2])(?:\s|$)/i;var a=S.exec(this.getSpan());if(a){var b=a[0];if(b){b=b.toUpperCase();if(b.substr(0,1)==="S"){return parseInt(b.substr(1),10);}}}return undefined;};
G.prototype.init=function(){this._bLinebreakXLChanged=false;};
G.prototype.setLinebreakXL=function(b){this.setProperty("linebreakXL",b);this._bLinebreakXLChanged=true;return this;};
G.prototype._getLinebreakXLChanged=function(){return this._bLinebreakXLChanged;};
G.prototype.setSpanLarge=function(s){this.setSpanL(s);q.sap.log.warning("Deprecated property spanLarge is used, please use spanL instead.");return this;};
G.prototype.setSpanMedium=function(s){q.sap.log.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.setSpanM(s);};
G.prototype.setSpanSmall=function(s){q.sap.log.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.setSpanS(s);};
G.prototype.setIndentLarge=function(i){q.sap.log.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.setIndentL(i);};
G.prototype.setIndentMedium=function(i){q.sap.log.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.setIndentM(i);};
G.prototype.setIndentSmall=function(i){q.sap.log.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.setIndentS(i);};
G.prototype.setVisibleOnLarge=function(v){q.sap.log.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.setVisibleL(v);};
G.prototype.setVisibleOnMedium=function(v){q.sap.log.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.setVisibleM(v);};
G.prototype.setVisibleOnSmall=function(v){q.sap.log.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.setVisibleS(v);};
G.prototype.getSpanLarge=function(){q.sap.log.warning("Deprecated property spanLarge is used, please use spanL instead.");return this.getSpanL();};
G.prototype.getSpanMedium=function(){q.sap.log.warning("Deprecated property spanMedium is used, please use spanM instead.");return this.getSpanM();};
G.prototype.getSpanSmall=function(){q.sap.log.warning("Deprecated property spanSmall is used, please use spanS instead.");return this.getSpanS();};
G.prototype.getIndentLarge=function(){q.sap.log.warning("Deprecated property indentLarge is used, please use indentL instead.");return this.getIndentL();};
G.prototype.getIndentMedium=function(){q.sap.log.warning("Deprecated property indentMedium is used, please use indentM instead.");return this.getIndentM();};
G.prototype.getIndentSmall=function(){q.sap.log.warning("Deprecated property indentSmall is used, please use indentS instead.");return this.getIndentS();};
G.prototype.getVisibleOnLarge=function(){q.sap.log.warning("Deprecated property visibleOnLarge is used, please use visibleL instead.");return this.getVisibleL();};
G.prototype.getVisibleOnMedium=function(){q.sap.log.warning("Deprecated property visibleOnMedium is used, please use visibleM instead.");return this.getVisibleM();};
G.prototype.getVisibleOnSmall=function(){q.sap.log.warning("Deprecated property visibleOnSmall is used, please use visibleS instead.");return this.getVisibleS();};
}());return G;},true);
sap.ui.predefine('sap/ui/layout/GridRenderer',["sap/ui/Device","sap/ui/layout/library"],function(D,a){"use strict";var G=a.GridPosition;var b={};
b.render=function(r,c){var I=/^([X][L](?:[0-9]|1[0-1]))? ?([L](?:[0-9]|1[0-1]))? ?([M](?:[0-9]|1[0-1]))? ?([S](?:[0-9]|1[0-1]))?$/i;var S=/^([X][L](?:[1-9]|1[0-2]))? ?([L](?:[1-9]|1[0-2]))? ?([M](?:[1-9]|1[0-2]))? ?([S](?:[1-9]|1[0-2]))?$/i;r.write("<div");r.writeControlData(c);r.addClass("sapUiRespGrid");var M=c._getCurrentMediaContainerRange(D.media.RANGESETS.SAP_STANDARD_EXTENDED).name;r.addClass("sapUiRespGridMedia-Std-"+M);var h=c.getHSpacing();if(h==0.5){h="05";}else if((h!==0)&&(h!==1)&&(h!==2)){h=1;}r.addClass("sapUiRespGridHSpace"+h);var v=c.getVSpacing();if(v==0.5){v="05";}else if((v!==0)&&(v!==1)&&(v!==2)){v=1;}r.addClass("sapUiRespGridVSpace"+v);var p=c.getPosition();if(p){p=p.toUpperCase();if(p===G.Center.toUpperCase()){r.addClass("sapUiRespGridPosCenter");}else if(p===G.Right.toUpperCase()){r.addClass("sapUiRespGridPosRight");}}r.writeClasses();var w=c.getWidth();if(w!=="100%"&&w!=="auto"&&w!=="inherit"){if(h==0){w="width: "+w;}else{w="width: -webkit-calc("+w+" - "+h+"rem); width: calc("+w+" - "+h+"rem); ";}r.writeAttribute("style",w);}var R=c._getAccessibleRole();var A;if(R){A={role:R};}r.writeAccessibilityState(c,A);r.write(">");var d=c.getContent();var e=c.getDefaultSpan();var f=["","XL3","L3","M6","S12"];var g=["","XL0","L0","M0","S0"];var k=S.exec(e);var n=c._getSpanXLChanged();var o=c._getIndentXLChanged();var q=c.getDefaultIndent();var t=I.exec(q);for(var i=0;i<d.length;i++){r.write("<div");var L=c._getLayoutDataForControl(d[i]);var C=false;if(L){var B=false;if(L.getLinebreak()===true){r.addClass("sapUiRespGridBreak");}else{if(L.getLinebreakXL()===true){B=true;r.addClass("sapUiRespGridBreakXL");}if(L.getLinebreakL()===true){if(!B&&!L._getLinebreakXLChanged()){r.addClass("sapUiRespGridBreakXL");}r.addClass("sapUiRespGridBreakL");}if(L.getLinebreakM()===true){r.addClass("sapUiRespGridBreakM");}if(L.getLinebreakS()===true){r.addClass("sapUiRespGridBreakS");}}var u;var x;var y=L.getSpan();if(!y||!y.lenght==0){u=k;}else{u=S.exec(y);if(/XL/gi.test(y)){C=true;}}if(u){for(var j=1;j<u.length;j++){var z=u[j];if(!z){z=k[j];if(!z){z=f[j];}}if(z.substr(0,1)==="L"){x=z.substr(1,2);}var E=L.getSpanXL();var F=L.getSpanL();var H=L.getSpanM();var J=L.getSpanS();z=z.toUpperCase();if((z.substr(0,2)==="XL")&&(E>0)&&(E<13)){r.addClass("sapUiRespGridSpanXL"+E);C=true;}else if((z.substr(0,1)==="L")&&(F>0)&&(F<13)){r.addClass("sapUiRespGridSpanL"+F);x=F;}else if((z.substr(0,1)==="M")&&(H>0)&&(H<13)){r.addClass("sapUiRespGridSpanM"+H);}else if((z.substr(0,1)==="S")&&(J>0)&&(J<13)){r.addClass("sapUiRespGridSpanS"+J);}else{if((z.substr(0,2)!=="XL")||n||C){r.addClass("sapUiRespGridSpan"+z);}}}if(!n&&!C){r.addClass("sapUiRespGridSpanXL"+x);}}var K;var N;var O=L.getIndent();if(!O||O.length==0){K=t;}else{K=I.exec(O);if(/XL/gi.test(O)){o=true;}}if(!K){K=t;if(!K){K=undefined;}}var P=L.getIndentXL();var Q=L.getIndentL();var T=L.getIndentM();var U=L.getIndentS();if(K){for(var j=1;j<K.length;j++){var V=K[j];if(!V){if(t&&t[j]){V=t[j];}else{V=g[j];}}if(V){V=V.toUpperCase();if(V.substr(0,1)==="L"){N=V.substr(1,2);}if((V.substr(0,2)==="XL")&&(P>0)&&(P<12)){r.addClass("sapUiRespGridIndentXL"+P);o=true;}else if((V.substr(0,1)==="L")&&(Q>0)&&(Q<12)){r.addClass("sapUiRespGridIndentL"+Q);N=Q;}else if((V.substr(0,1)==="M")&&(T>0)&&(T<12)){r.addClass("sapUiRespGridIndentM"+T);}else if((V.substr(0,1)==="S")&&(U>0)&&(U<12)){r.addClass("sapUiRespGridIndentS"+U);}else{if(!(/^(XL0)? ?(L0)? ?(M0)? ?(S0)?$/.exec(V))){r.addClass("sapUiRespGridIndent"+V);}}}}if(!o){if(N&&N>0){r.addClass("sapUiRespGridIndentXL"+N);}}}var l=L.getVisibleL(),m=L.getVisibleM(),s=L.getVisibleS();if(!l&&m&&s){r.addClass("sapUiRespGridHiddenL");r.addClass("sapUiRespGridHiddenXL");}else if(!l&&!m&&s){r.addClass("sapUiRespGridVisibleS");}else if(l&&!m&&!s){r.addClass("sapUiRespGridVisibleL");r.addClass("sapUiRespGridVisibleXL");}else if(!l&&m&&!s){r.addClass("sapUiRespGridVisibleM");}else if(l&&!m&&s){r.addClass("sapUiRespGridHiddenM");}else if(l&&m&&!s){r.addClass("sapUiRespGridHiddenS");}var W=L.getMoveBackwards();if(W&&W.length>0){var X=I.exec(W);if(X){for(var j=1;j<X.length;j++){var Y=X[j];if(Y){r.addClass("sapUiRespGridBwd"+Y.toUpperCase());}}}}var Z=L.getMoveForward();if(Z&&Z.length>0){var $=I.exec(Z);if($){for(var j=1;j<$.length;j++){var _=$[j];if(_){r.addClass("sapUiRespGridFwd"+_.toUpperCase());}}}}if(L._sStylesInternal){r.addClass(L._sStylesInternal);}}if(!L){var z="";if(k){for(var j=1;j<k.length;j++){z=k[j];if(!z){if((j==1)&&(k[j+1])){z="X"+k[j+1];}else{z=f[j];}}r.addClass("sapUiRespGridSpan"+z.toUpperCase());}}else{for(var j=1;j<f.length;j++){z=f[j];r.addClass("sapUiRespGridSpan"+z.toUpperCase());}}var V="";if(t){for(var j=1;j<t.length;j++){V=t[j];if(!V){if((j==1)&&(t[j+1])){V="X"+t[j+1];}else{V=g[j];}}if(((V.substr(0,1)!=="X")&&(V.substr(1,1)!=="0"))||((V.substr(0,1)=="X")&&(V.substr(2,1)!=="0"))){r.addClass("sapUiRespGridIndent"+V.toUpperCase());}}}}r.writeClasses();r.write(">");r.renderControl(d[i]);r.write("</div>");}r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/ui/layout/HorizontalLayout.designtime',[],function(){"use strict";return{aggregations:{content:{domRef:":sap-domref",actions:{move:"moveControls"}}},actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},name:{singular:"HORIZONTAL_LAYOUT_CONTROL_NAME",plural:"HORIZONTAL_LAYOUT_CONTROL_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/ui/layout/HorizontalLayout',['sap/ui/core/Control','./library'],function(C,l){"use strict";
var H=C.extend("sap.ui.layout.HorizontalLayout",{metadata:{library:"sap.ui.layout",properties:{allowWrapping:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designTime:true}});
H.prototype.getAccessibilityInfo=function(){return{children:this.getContent()};};
return H;});
sap.ui.predefine('sap/ui/layout/HorizontalLayoutRenderer',[],function(){"use strict";var H={};
H.render=function(r,c){var a=r;var n=!c.getAllowWrapping();a.write("<div");a.writeControlData(c);a.addClass("sapUiHLayout");if(n){a.addClass("sapUiHLayoutNoWrap");}a.writeClasses();a.write(">");var C=c.getContent();for(var i=0;i<C.length;i++){if(n){a.write("<div class='sapUiHLayoutChildWrapper'>");}a.renderControl(C[i]);if(n){a.write("</div>");}}a.write("</div>");};
return H;},true);
sap.ui.predefine('sap/ui/layout/PaneContainer',['./library','sap/ui/core/Element','./AssociativeSplitter','sap/ui/core/library'],function(l,E,A,c){"use strict";var O=c.Orientation;
var P=E.extend("sap.ui.layout.PaneContainer",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal}},defaultAggregation:"panes",aggregations:{panes:{type:"sap.ui.core.Element",multiple:true,singularName:"pane"}}}});
P.prototype.init=function(){this._oSplitter=new A({orientation:this.getOrientation(),height:"100%"});this._oSplitter._bUseIconForSeparator=false;};
P.prototype.setOrientation=function(o){this._oSplitter.setOrientation(o);return this.setProperty("orientation",o,true);};
P.prototype._getPanesInInterval=function(f){return this.getPanes().filter(function(p){return p instanceof sap.ui.layout.SplitPane&&p._isInInterval(f);});};
P.prototype.setLayoutData=function(L){return this._oSplitter.setLayoutData(L);};
P.prototype.insertPane=function(o,i){var r=this.insertAggregation("panes",o,i),e={onAfterRendering:function(){this.triggerResize();this.removeEventDelegate(e);}};if(o instanceof P&&o._oSplitter){o._oSplitter.addEventDelegate(e,o._oSplitter);}return r;};
P.prototype.removePane=function(o){var r=this.removeAggregation("panes",o),e={onAfterRendering:function(){this.triggerResize();this.removeEventDelegate(e);}};this.getPanes().forEach(function(p){if(p instanceof P&&p._oSplitter){p._oSplitter.addEventDelegate(e,p._oSplitter);}});return r;};
return P;});
sap.ui.predefine('sap/ui/layout/ResponsiveFlowLayout',['jquery.sap.global','sap/ui/core/Control','./ResponsiveFlowLayoutData','./library','sap/ui/core/ResizeHandler','sap/ui/Device'],function(q,C,R,l,a,D){"use strict";
var b=C.extend("sap.ui.layout.ResponsiveFlowLayout",{metadata:{library:"sap.ui.layout",properties:{responsive:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}}}});
(function(){
b.prototype.init=function(){this._rows=[];this._bIsRegistered=false;this._proxyComputeWidths=q.proxy(e,this);this._iRowCounter=0;};
b.prototype.exit=function(){delete this._rows;if(this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}if(this._resizeHandlerComputeWidthsID){a.deregister(this._resizeHandlerComputeWidthsID);}delete this._resizeHandlerComputeWidthsID;delete this._proxyComputeWidths;if(this.oRm){this.oRm.destroy();delete this.oRm;}delete this._$DomRef;delete this._oDomRef;delete this._iRowCounter;};
var u=function(t){var f=t.getContent();var r=[];var h=-1;var I={},L={};var s="";var o;var m=0,w=0,j=0;var B=false,M=false,k=false;for(var i=0;i<f.length;i++){m=R.MIN_WIDTH;w=R.WEIGHT;B=R.LINEBREAK;M=R.MARGIN;k=R.LINEBREAKABLE;o=_(f[i]);if(o instanceof R){B=o.getLinebreak();m=o.getMinWidth();w=o.getWeight();M=o.getMargin();k=o.getLinebreakable();}if(h<0||B){h++;r.push({height:-1,cont:[]});}j=r[h].cont.length;s=f[i].getId()+"-cont"+h+"_"+j;I={minWidth:m,weight:w,linebreakable:k,padding:M,control:f[i],id:s,breakWith:[]};var p=false;if(!k){for(var n=j;n>0;n--){L=r[h].cont[n-1];if(L.linebreakable){L.breakWith.push(I);p=true;break;}}}if(!p){r[h].cont.push(I);}}t._rows=r;};var g=function(o,$,t){var r=[];var f=10000000;var h=-1;var k=function(j){var m=q.sap.byId(o.cont[j].id);if(m.length>0){var n=m[0].offsetLeft;if(f>=n){r.push({cont:[]});h++;}f=n;r[h].cont.push(o.cont[j]);}};if(sap.ui.getCore().getConfiguration().getRTL()){for(var i=o.cont.length-1;i>=0;i--){k(i);}}else{for(var i=0;i<o.cont.length;i++){k(i);}}return r;};var c=function(o,w){var r=[];var f=-1;var h=0;var t=0;var i=0;var m=0,n=0;var j=0,k=0;for(j=0;j<o.cont.length;j++){h=0;t=0;for(k=i;k<=j;k++){t=t+o.cont[k].weight;}for(k=i;k<=j;k++){m=w/t*o.cont[k].weight;m=Math.floor(m);n=o.cont[k].minWidth;h+=Math.max(m,n);}if(f==-1||h>w){r.push({cont:[]});if(f!==-1){i=j;}f++;}r[f].cont.push(o.cont[j]);}return r;};var d=function(w,f){if(w.length!=f.length){return true;}for(var i=0;i<w.length;i++){if(w[i].cont.length!=f[i].cont.length){return true;}}return false;};
b.prototype.renderContent=function(t,w){var r=t,f=0,W=[],i=0,h=0,j=0,k=0,m=0,p=0,o,n=0,s=0,B=[],v=[],I=this.getId(),H="",x=this._getRenderManager();for(i=0;i<r.length;i++){p=0;W.length=0;f=100;v.length=0;v.push("sapUiRFLRow");if(r[i].cont.length<=1){v.push("sapUiRFLCompleteRow");}var y=I+"-row"+this._iRowCounter;var S={};x.writeHeader(y,S,v);m=0;for(h=0;h<r[i].cont.length;h++){m+=r[i].cont[h].weight;}for(j=0;j<r[i].cont.length;j++){o=r[i].cont[j];n=0;s=0;if(o.breakWith.length>0){n=o.weight;s=o.minWidth;for(var z=0;z<o.breakWith.length;z++){n+=o.breakWith[z].weight;s+=o.breakWith[z].minWidth;}}H=r[i].cont[j].id;v.length=0;S={"min-width":o.breakWith.length>0?s:o.minWidth};p=100/m*o.weight;var P=S["min-width"]/w*100;var A=Math.ceil(P);var E=Math.floor(p);if(E!==100&&A>E){p=A;}else{p=E;}p=f<p?f:p;f-=p;W.push(p);if(f>0&&j===(r[i].cont.length-1)){p+=f;}v.push("sapUiRFLContainer");S["width"]=p+"%";S["min-width"]=S["min-width"]+"px";x.writeHeader(H,S,v);v.length=0;v.push("sapUiRFLContainerContent");if(o.breakWith.length>0){v.push("sapUiRFLMultiContainerContent");}if(o.padding){v.push("sapUiRFLPaddingClass");}var F=this._addContentClass(o.control,j);if(F){v.push(F);}S={};x.writeHeader("",S,v);if(o.breakWith.length>0){H=r[i].cont[j].id+"-multi0";v.length=0;S={"min-width":s+"px"};var G=100/n*o.weight;G=Math.floor(G);B.push(G);v.push("sapUiRFLMultiContent");S["width"]=G+"%";if(r[i].cont[j].padding){v.push("sapUiRFLPaddingClass");}x.writeHeader(H,S,v);var J=G;x.renderControl(o.control);x.write("</div>");for(k=0;k<o.breakWith.length;k++){H=o.breakWith[k].id+'-multi'+(k+1);v.length=0;S={"min-width":o.breakWith[k].minWidth+"px"};G=100/n*o.breakWith[k].weight;G=Math.floor(G);B.push(G);J+=G;if(J<100&&k===(o.breakWith.length-1)){G+=100-J;}v.push("sapUiRFLMultiContent");S["width"]=G+"%";if(o.breakWith[k].padding){v.push("sapUiRFLPaddingClass");}x.writeHeader(H,S,v);x.renderControl(o.breakWith[k].control);x.write("</div>");}}else{x.renderControl(o.control);}x.write("</div>");x.write("</div>");}x.write("</div>");this._iRowCounter++;}};
var e=function(I){this._iRowCounter=0;this._oDomRef=this.getDomRef();if(this._oDomRef){var s=this.getId();var f=q(this._oDomRef).width();var r=false;if(this._rows){for(var i=0;i<this._rows.length;i++){var $=this._$DomRef.find("#"+s+"-row"+i);var t=c(this._rows[i],f);var o=g(this._rows[i],$,this);r=d(o,t);var h=this._getElementRect($);var p=this._rows[i].oRect;if(h&&p){r=r||(h.width!==p.width)&&(h.height!==p.height);}r=r||(typeof(I)==="boolean"&&I);if(this._bLayoutDataChanged||r){if(D.browser.internet_explorer){q(this._oDomRef).empty();}else{this._oDomRef.innerHTML="";}this._bLayoutDataChanged=false;this.renderContent(t,f);}}if(this._oDomRef.innerHTML===""){this._getRenderManager().flush(this._oDomRef);for(var i=0;i<this._rows.length;i++){var T=this._getElementRect(q.sap.byId(s+"-row"+i));this._rows[i].oRect=T;}}if(this._rows.length===0){if(this._resizeHandlerComputeWidthsID){a.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID;}}}}};
b.prototype.onBeforeRendering=function(){u(this);if(this._resizeHandlerFullLengthID){a.deregister(this._resizeHandlerFullLengthID);delete this._resizeHandlerFullLengthID;}};
b.prototype.onAfterRendering=function(E){this._oDomRef=this.getDomRef();this._$DomRef=q(this._oDomRef);this._proxyComputeWidths(true);if(this.getResponsive()){if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=a.register(this,this._proxyComputeWidths);}}else{if(this._resizeHandlerComputeWidthsID){a.deregister(this._resizeHandlerComputeWidthsID);delete this._resizeHandlerComputeWidthsID;}}};
b.prototype.onThemeChanged=function(E){if(E.type==="LayoutDataChange"){this._bLayoutDataChanged=true;}if(!this._resizeHandlerComputeWidthsID){this._resizeHandlerComputeWidthsID=a.register(this,this._proxyComputeWidths);}u(this);this._proxyComputeWidths();};
b.prototype.onLayoutDataChange=b.prototype.onThemeChanged;var _=function(o){var L=o.getLayoutData();if(!L){return undefined;}else if(L instanceof R){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var f=L.getMultipleLayoutData();for(var i=0;i<f.length;i++){var h=f[i];if(h instanceof R){return h;}}}};
b.prototype.addContent=function(o){if(o&&this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}this.addAggregation("content",o);};
b.prototype.insertContent=function(o,i){if(o&&this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}this.insertAggregation("content",o,i);};
b.prototype.removeContent=function(o){if(o&&this._IntervalCall){q.sap.clearDelayedCall(this._IntervalCall);this._IntervalCall=undefined;}this.removeAggregation("content",o);};
b.prototype._getAccessibleRole=function(){return null;};
b.prototype._addContentClass=function(o,i){return null;};
b.prototype._getElementRect=function(E){var r=E&&E.rect();if(r){r.height=r.height.toFixed(1);r.width=r.width.toFixed(1);}return r;};
b.prototype._getRenderManager=function(){if(!this.oRm){this.oRm=sap.ui.getCore().createRenderManager();this.oRm.writeStylesAndClasses=function(){this.writeStyles();this.writeClasses();};this.oRm.writeHeader=function(I,s,f){this.write('<div id="'+I+'"');if(s){for(var k in s){if(k==="width"&&s[k]==="100%"){this.addClass("sapUiRFLFullLength");}this.addStyle(k,s[k]);}}for(var i=0;i<f.length;i++){this.addClass(f[i]);}this.writeStylesAndClasses();this.write(">");};}return this.oRm;};
}());return b;});
sap.ui.predefine('sap/ui/layout/ResponsiveFlowLayoutData',['jquery.sap.global','sap/ui/core/LayoutData','./library'],function(q,L,l){"use strict";
var R=L.extend("sap.ui.layout.ResponsiveFlowLayoutData",{metadata:{library:"sap.ui.layout",properties:{minWidth:{type:"int",group:"Misc",defaultValue:100},weight:{type:"int",group:"Misc",defaultValue:1},linebreak:{type:"boolean",group:"Misc",defaultValue:false},margin:{type:"boolean",group:"Misc",defaultValue:true},linebreakable:{type:"boolean",group:"Misc",defaultValue:true}}}});
R.MIN_WIDTH=100;R.WEIGHT=1;R.LINEBREAK=false;R.MARGIN=true;R.LINEBREAKABLE=true;
R.prototype.setWeight=function(w){if(w>=1){this.setProperty("weight",w);}else{q.sap.log.warning("Values smaller than 1 are invalid. Default value '1' is used instead",this);this.setProperty("weight",R.WEIGHT);}return this;};
R.prototype.setLinebreak=function(b){if(this.getLinebreakable()==false&&b){q.sap.log.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this);}else{this.setProperty("linebreak",b);}return this;};
R.prototype.setLinebreakable=function(b){if(this.getLinebreak()===true&&b===false){q.sap.log.warning("Setting 'linebreak' AND 'linebreakable' doesn't make any sense. Please set either 'linebreak' or 'linebreakable'",this);}else{this.setProperty("linebreakable",b);}return this;};
return R;});
sap.ui.predefine('sap/ui/layout/ResponsiveFlowLayoutRenderer',[],function(){"use strict";var R={};(function(){
R.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiRFL");r.writeClasses();var s=c._getAccessibleRole();var a;if(s){a={role:s};}r.writeAccessibilityState(c,a);r.write(">");r.write("</div>");};
}());return R;},true);
sap.ui.predefine('sap/ui/layout/ResponsiveSplitter',["jquery.sap.global","./library","sap/ui/core/Control","./ResponsiveSplitterUtilities","./ResponsiveSplitterPage","./PaneContainer","./SplitPane","sap/ui/core/delegate/ItemNavigation","sap/ui/core/ResizeHandler"],function(q,l,C,R,c,P,S,I,d){"use strict";
var e=C.extend("sap.ui.layout.ResponsiveSplitter",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"rootPaneContainer",aggregations:{rootPaneContainer:{type:"sap.ui.layout.PaneContainer",multiple:false},_pages:{type:"sap.ui.layout.ResponsiveSplitterPage",multiple:true,visibility:"hidden"}},associations:{defaultPane:{type:"sap.ui.layout.SplitPane",multiple:false}},events:{}}});
var f={MAX_VISIBLE_BUTTONS:7};
e.prototype.init=function(){this._aPaneContainers=[];this._aPanes=[];this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");this.addEventDelegate({onAfterRendering:function(){this._initItemNavigation();}},this);};
e.prototype.onBeforeRendering=function(){var r=this.getRootPaneContainer();if(r){r._oSplitter.addEventDelegate({onAfterRendering:function(){this._setSplitterBarsTooltips(r._oSplitter);this._updatePaginatorButtonsTooltips();}},this);this._createWidthIntervals();this._createPages();this._detachResizeHandler();}};
e.prototype.onAfterRendering=function(){this._parentResizeHandler=d.register(this,this._onParentResize.bind(this));var r=this.getRootPaneContainer();if(r){this._onParentResize();}};
e.prototype.exit=function(){this._detachResizeHandler();};
e.prototype._setSplitterBarsTooltips=function(o,p){var s=o.$().find(" > .sapUiLoSplitterBar"),a=o.$().find(" > .sapUiLoSplitterContent"),b=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_RESIZE")+" ",t=b,g,n,A,h;for(var i=0;i<a.length;i++){h=a[i].childNodes[0].id;A=sap.ui.getCore().byId(h);g=i+1;n=i+2;if(p){t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_PANES",[p+"."+g,p+"."+n]);}else{t+=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_PANES",[g,n]);}if(s[i]){s[i].setAttribute("title",t);t=b;}if(A instanceof sap.ui.layout.Splitter){this._setSplitterBarsTooltips(A,g);}}};
e.prototype._updatePaginatorButtonsTooltips=function(){var v=Array.prototype.slice.call(this._getVisibleButtons()),h=this.getRootPaneContainer()._oSplitter.getAssociatedContentAreas().length,H=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_HOME")+" ",a=this._oResourceBundle.getText("RESPONSIVE_SPLITTER_AND"),t="",b=this,o;if(v.length>0){o=v.shift();for(var i=1;i<=h;i++){H+=i;if(i<(h-1)){H+=", ";}else if(i===h-1){H+=" "+a+" ";}}o.setAttribute("title",H);[].forEach.call(v,function(B){t=b._oResourceBundle.getText("RESPONSIVE_SPLITTER_GOTO")+" "+(h+1);h+=1;B.setAttribute("title",t);});}};
e.prototype._handlePaginatorButtonTap=function(E){var o=this._oItemNavigation.getFocusedIndex();if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorButton")){q(E.target).attr("tabindex",0);var p=parseInt(q(E.target).attr("page-index"),10);this.getAggregation("_pages").forEach(function(a){a.setVisible(false);});if(p!==0){var D=this._currentInterval.aPages.filter(function(a){return a.demandPane;});p=this._currentInterval.aPages.indexOf(D[p-1]);}this._activatePage(p,parseInt(q(E.target).attr("page-index"),10));}if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorNavButton")){if(q(E.target).hasClass("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}this._setItemNavigation();this._oItemNavigation.focusItem(o);}this._setItemNavigation();};
e.prototype.ontap=e.prototype._handlePaginatorButtonTap;e.prototype.onsapenter=e.prototype._handlePaginatorButtonTap;e.prototype.onsapspace=e.prototype._handlePaginatorButtonTap;
e.prototype.onsapright=function(E){this._handleArrowNavigation(6,"Forward",E);};
e.prototype.onsapleft=function(E){this._handleArrowNavigation(0,"Back",E);};
e.prototype._initItemNavigation=function(){if(this._oItemNavigation){this._bPrevItemNavigation=true;this._clearItemNavigation();}this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this._setItemNavigation();if(this._bPrevItemNavigation){this._oItemNavigation.focusItem(0);}};
e.prototype._setItemNavigation=function(){var b=this._getVisibleButtons(),D=[];this._oItemNavigation.setRootDomRef(this.$().find(".sapUiResponsiveSplitterPaginator")[0]);for(var i=0;i<b.length;i++){if(b[i]){D.push(b[i]);}}this._oItemNavigation.setItemDomRefs(D);};
e.prototype._clearItemNavigation=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;};
e.prototype._handleArrowNavigation=function(b,D,E){if(E.target===this._getVisibleButtons()[b]){this["_handlePaginator"+D](E);this._setItemNavigation();}else{return;}};
e.prototype._onParentResize=function(){var i=this._intervalHasChanged(),r=this.getRootPaneContainer();if(i&&r){this._arrangeContent();this._setPaginatorVisibility();}};
e.prototype._detachResizeHandler=function(){if(this._parentResizeHandler){d.deregister(this._parentResizeHandler);this._parentResizeHandler=null;}};
e.prototype._createWidthIntervals=function(){var B=[];this._aIntervals=[];R.visitPanes(this.getRootPaneContainer(),function(p){var r=p.getRequiredParentWidth();if(q.inArray(r,B)==-1){B.push(r);}});B.push(Number.NEGATIVE_INFINITY);B.push(Number.POSITIVE_INFINITY);B.sort(function(a,b){return a-b;});for(var i=0;i<B.length-1;i++){var o=new R.splitterInterval(B[i],B[i+1],this.getRootPaneContainer());this._aIntervals.push(o);}};
e.prototype._createPages=function(){var m=this._getMaxPageCount();this.destroyAggregation("_pages",true);for(var i=0;i<m;i++){var p=new c();this.addAggregation("_pages",p,true);}};
e.prototype._intervalHasChanged=function(){var w=this.getDomRef().clientWidth,o=null,a=this._aIntervals;for(var i=0;i<a.length;i++){if(a[i].iFrom<w&&w<=a[i].iTo){o=a[i];break;}}if(this._currentInterval!==o){this._currentInterval=o;return true;}return false;};
e.prototype._setPaginatorVisibility=function(){var b=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),n=this.$().find(".sapUiResponsiveSplitterPaginatorNavButton"),p=this.$().find(".sapUiResponsiveSplitterPaginator"),i=(this._getHiddenPanes().length+1),s=i<f.MAX_VISIBLE_BUTTONS;b.addClass("sapUiResponsiveSplitterHiddenElement");if(i>1){this.getDomRef().classList.add("sapUiRSVisiblePaginator");b=b.slice(0,s?i:f.MAX_VISIBLE_BUTTONS);b.removeClass("sapUiResponsiveSplitterHiddenElement");b.removeClass("sapUiResponsiveSplitterHiddenPaginatorButton");n.toggleClass("sapUiResponsiveSplitterHiddenPaginatorButton",s);p.toggleClass("sapUiResponsiveSplitterWithNavButtons",!s);}else{this.getDomRef().classList.remove("sapUiRSVisiblePaginator");}};
e.prototype._getMaxPageCount=function(){var t=0;this._aIntervals.forEach(function(i){if(i.iPagesCount>t){t=i.iPagesCount;}});return t;};
e.prototype._arrangeContent=function(){var p=this.getAggregation("_pages")||[];this._clearContent();p.forEach(function(o){o.setVisible(false);});this._fillPageContent(this.getRootPaneContainer());this._activatePage(0);};
e.prototype._activatePage=function(p){var $=this.$().find(".sapUiResponsiveSplitterPaginatorButton"),o=this.$().find(".sapUiResponsiveSplitterPaginatorSelectedButton"),O=$.index(o),a=this.getAggregation("_pages")||[];a[O]&&a[O].setVisible(false);a[p]&&a[p].setVisible(true);o.removeClass("sapUiResponsiveSplitterPaginatorSelectedButton");$.eq(p).addClass("sapUiResponsiveSplitterPaginatorSelectedButton");o.attr("aria-checked",false);$.eq(p).attr("aria-checked",true);};
e.prototype._fillPageContent=function(s){var b=s instanceof P,a=s instanceof S,o=s.getParent(),g=o instanceof P,p=this.getAggregation("_pages"),h,H,j,D,k,m;if(b&&p){this._aPaneContainers.push(s);H=this._getAllPanesInInterval(s,this._currentInterval.iFrom).length>0;j=s._oSplitter;if(g&&H){o._oSplitter.addAssociatedContentArea(j);}else if(!g){p[0].setContent(j);}s.getPanes().forEach(function(n){this._fillPageContent(n);},this);}else if(a&&p){this._assignDefault(s);this._aPanes.push(s);D=s.getDemandPane();h=this._getHiddenPanes();k=h.length;m=this._getMaxPageCount();var i;if(s._isInInterval(this._currentInterval.iFrom)){o._oSplitter.addAssociatedContentArea(s.getContent());}else if(D&&(k<m)){for(i=0;i<k;i++){p[i+1].setContent(h[i].getContent());}}else if(D&&k===m){for(i=0;i<k;i++){p[i].setContent(h[i].getContent());}}else if(this._isDefault(s)){p[0].setContent(s.getContent());}}};
e.prototype._isDefault=function(p){return this.getDefaultPane()===p.getId();};
e.prototype._assignDefault=function(p){var D=this.getDefaultPane();this.setDefaultPane(D||p);};
e.prototype._getAllPanesInInterval=function(p,F){var a=[];function v(p){p.getPanes().forEach(function(o){if(o instanceof P){v(o);}else if(o._isInInterval(F)){a.push(o);}});return a;}return v(p,F);};
e.prototype._getHiddenPanes=function(){return this._aPanes.filter(function(p){return p.getDemandPane()&&!p._isInInterval(this._currentInterval.iFrom);},this);};
e.prototype._clearContent=function(){this._aPaneContainers.forEach(function(p){p._oSplitter.removeAllAssociatedContentArea();});this._aPaneContainers=[];this._aPanes=[];};
e.prototype._getVisibleButtons=function(){return this.$().find(".sapUiResponsiveSplitterPaginatorButton:not(.sapUiResponsiveSplitterHiddenElement, .sapUiResponsiveSplitterHiddenPaginatorButton)");};
e.prototype._handlePaginatorButtonTap=function(E){var t=E.target,T=E.target.classList,p;if(T.contains("sapUiResponsiveSplitterPaginatorButton")){p=t.getAttribute("page-index");this._activatePage(p);}else if(T.contains("sapUiResponsiveSplitterPaginatorNavButton")){if(T.contains("sapUiResponsiveSplitterPaginatorButtonForward")){this._handlePaginatorForward(E);}else{this._handlePaginatorBack(E);}}};
e.prototype._handlePaginatorForward=function(E){var v=this._getVisibleButtons(),h=this._getHiddenPanes().length,H=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),$=H.filter(function(){return this.getAttribute("page-index")>=f.MAX_VISIBLE_BUTTONS&&this.getAttribute("page-index")<=h;});if($.length>0){v.first().addClass("sapUiResponsiveSplitterHiddenElement");$.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};
e.prototype._handlePaginatorBack=function(E){var v=this._getVisibleButtons(),m=this._getMaxPageCount()-f.MAX_VISIBLE_BUTTONS,h=this.$().find(".sapUiResponsiveSplitterPaginatorButton.sapUiResponsiveSplitterHiddenElement"),H=h.filter(function(){return this.getAttribute("page-index")<m;});if(H.length>0){v.last().addClass("sapUiResponsiveSplitterHiddenElement");H.last().removeClass("sapUiResponsiveSplitterHiddenElement");}};
e.prototype.ontap=e.prototype._handlePaginatorButtonTap;e.prototype.onsapenter=e.prototype._handlePaginatorButtonTap;e.prototype.onsapspace=e.prototype._handlePaginatorButtonTap;return e;});
sap.ui.predefine('sap/ui/layout/ResponsiveSplitterPage',["./library","sap/ui/core/Control"],function(l,C){"use strict";
var R=C.extend("sap.ui.layout.ResponsiveSplitterPage",{
metadata:{library:"sap.ui.layout",associations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}}},
getContent:function(){return sap.ui.getCore().byId(this.getAssociation("content"));},
renderer:function(r,c){r.write("<div");r.addClass("sapUiResponsiveSplitterPage");r.writeControlData(c);r.writeClasses();r.write(">");var a=c.getContent();if(a){r.renderControl(a);}r.write("</div>");}
});
return R;});
sap.ui.predefine('sap/ui/layout/ResponsiveSplitterRenderer',['sap/ui/core/IconPool'],function(I){"use strict";var R={};I.insertFontFaceStyle();
R.render=function(r,c){r.write("<div ");r.addClass("sapUiResponsiveSplitter");r.writeControlData(c);r.addStyle("width",c.getWidth());r.addStyle("height",c.getHeight());r.writeStyles();r.writeClasses();r.write(">");var p=c.getAggregation("_pages");if(p){c.getAggregation("_pages").forEach(r.renderControl);this.renderPaginator(r,c);}r.write("</div>");};
R.renderPaginator=function(r,c){var b=c._getMaxPageCount(),p=c.getAggregation("_pages")||[],B=sap.ui.getCore().getLibraryResourceBundle('sap.ui.layout');r.write("<div ");r.writeAttribute("role","navigation");r.addClass("sapUiResponsiveSplitterPaginator");r.writeClasses();r.write(">");r.write("<div ");r.addClass("sapUiResponsiveSplitterPaginatorNavButton");r.addClass("sapUiResponsiveSplitterHiddenPaginatorButton");r.addClass("sapUiResponsiveSplitterPaginatorButtonBack");r.writeClasses();r.write("></div>");r.write("<div ");r.addClass("sapUiResponsiveSplitterPaginatorButtons");r.writeClasses();r.writeAttribute("role","radiogroup");r.writeAttributeEscaped("aria-label",B.getText("RESPONSIVE_SPLITTER_ARIA_PAGINATOR_LABEL"));if(p.length>0){r.writeAttribute("aria-controls",p[0].getParent().getId());}r.write(">");for(var i=0;i<b;i++){r.write("<div tabindex='0' ");r.write("page-index='"+i+"'");if(i===0){r.addClass("sapUiResponsiveSplitterPaginatorSelectedButton");}r.addClass("sapUiResponsiveSplitterHiddenElement");r.addClass("sapUiResponsiveSplitterPaginatorButton");r.writeClasses();r.writeAttribute("role","radio");r.writeAttribute("aria-checked",false);r.write("></div>");}r.write("</div>");r.write("<div ");r.addClass("sapUiResponsiveSplitterPaginatorNavButton");r.addClass("sapUiResponsiveSplitterHiddenPaginatorButton");r.addClass("sapUiResponsiveSplitterPaginatorButtonForward");r.writeClasses();r.write("></div>");r.write("</div>");};
return R;},true);
sap.ui.predefine('sap/ui/layout/ResponsiveSplitterUtilities',[],function(){"use strict";var R={};
R.visitPanes=function(p,c){var P,o;if(!p){return;}P=p.getPanes();for(var i=0;i<P.length;i++){o=P[i];if(o instanceof sap.ui.layout.SplitPane){c(o);}else{R.visitPanes(o,c);}}};
R.splitterInterval=function(f,t,p){this.iFrom=f;this.iTo=t;this.iPagesCount=0;var m=[],P=[m];R.visitPanes(p,function(a){var w=a.getRequiredParentWidth();var b={demandPane:a.getDemandPane()};if(w<=f){m.push(b);}else{P.push(b);}});if(m.length==0){P.splice(0,1);}this.iPagesCount=P.length;this.aPages=P;};
return R;},true);
sap.ui.predefine('sap/ui/layout/SplitPane',['./library','sap/ui/core/Element'],function(l,E){"use strict";
var S=E.extend("sap.ui.layout.SplitPane",{metadata:{library:"sap.ui.layout",properties:{demandPane:{type:"boolean",group:"Behavior",defaultValue:true},requiredParentWidth:{type:"int",defaultValue:800}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:false,singularName:"content"}}}});
S.prototype.setLayoutData=function(L){var c=this.getContent();if(c){return c.setLayoutData(L);}else{return this;}};
S.prototype.onLayoutDataChange=function(){var p=this.getParent();if(p){p._oSplitter._delayedResize();}};
S.prototype._isInInterval=function(f){return this.getRequiredParentWidth()<=f;};
return S;});
sap.ui.predefine('sap/ui/layout/Splitter.designtime',[],function(){"use strict";return{aggregations:{contentAreas:{domRef:":sap-domref",actions:{move:"moveControls"}}},actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}}};},false);
sap.ui.predefine('sap/ui/layout/Splitter',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/library','sap/ui/core/ResizeHandler'],function(q,C,l,c,R){"use strict";var O=c.Orientation;
var S=C.extend("sap.ui.layout.Splitter",{metadata:{library:"sap.ui.layout",properties:{orientation:{type:"sap.ui.core.Orientation",group:"Behavior",defaultValue:O.Horizontal},width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'100%'}},defaultAggregation:"contentAreas",aggregations:{contentAreas:{type:"sap.ui.core.Control",multiple:true,singularName:"contentArea"}},events:{resize:{parameters:{id:{type:"string"},oldSizes:{type:"int[]"},newSizes:{type:"int[]"}}}},designTime:true}});
var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");
S.prototype.init=function(){this._needsInvalidation=false;this._liveResize=true;this._keyboardEnabled=true;this._bHorizontal=true;this._calculatedSizes=[];this._move={};this._resizeTimeout=null;this._resizeCallback=this._delayedResize.bind(this);this._resizeHandlerId=null;this._autoResize=true;this.enableAutoResize();this._boundBarMoveEnd=this._onBarMoveEnd.bind(this);this._boundBarMove=this._onBarMove.bind(this);this._switchOrientation();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._keyListeners={increase:this._onKeyboardResize.bind(this,"inc",20),decrease:this._onKeyboardResize.bind(this,"dec",20),increaseMore:this._onKeyboardResize.bind(this,"incMore",20),decreaseMore:this._onKeyboardResize.bind(this,"decMore",20),max:this._onKeyboardResize.bind(this,"max",20),min:this._onKeyboardResize.bind(this,"min",20)};this._enableKeyboardListeners();this._isPreserved=false;sap.ui.getCore().getEventBus().subscribe("sap.ui","__preserveContent",this._preserveHandler,this);this._bUseIconForSeparator=true;};
S.prototype.exit=function(){sap.ui.getCore().getEventBus().unsubscribe("sap.ui","__preserveContent",this._preserveHandler,this);this.disableAutoResize();delete this._resizeCallback;delete this._boundBarMoveEnd;delete this._boundBarMove;delete this._$SplitterOverlay;delete this._$SplitterOverlayBar;};
S.prototype.triggerResize=function(f){if(f){this._resize();}else{this._delayedResize();}};
S.prototype.getCalculatedSizes=function(){return this._calculatedSizes;};
S.prototype.enableAutoResize=function(t){if(t&&!this._autoResize){return;}this._autoResize=true;var d=this;sap.ui.getCore().attachInit(function(){d._resizeHandlerId=R.register(d,d._resizeCallback);});this._delayedResize();};
S.prototype.disableAutoResize=function(t){R.deregister(this._resizeHandlerId);if(!t){this._autoResize=false;}};
S.prototype.enableLiveResize=function(){this._liveResize=true;this.$().toggleClass("sapUiLoSplitterAnimated",false);};
S.prototype.disableLiveResize=function(){this._liveResize=false;this.$().toggleClass("sapUiLoSplitterAnimated",true);};
S.prototype.enableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","0");this._enableKeyboardListeners();};
S.prototype.disableKeyboardSupport=function(){var B=this.$().find(".sapUiLoSplitterBar");B.attr("tabindex","-1");this._disableKeyboardListeners();};
S.prototype.onBeforeRendering=function(){this._switchOrientation();};
S.prototype.onAfterRendering=function(){this._$SplitterOverlay=this.$("overlay");this._$SplitterOverlayBar=this.$("overlayBar");this._$SplitterOverlay.detach();this._isPreserved=false;this._resize();};
S.prototype.onLayoutDataChange=function(){this._delayedResize();};
S.prototype.ontouchstart=function(j){if(this._ignoreTouch){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}if(!j.changedTouches||!j.changedTouches[0]){return;}this._ignoreMouse=true;this._onBarMoveStart(j.changedTouches[0],true);};
S.prototype.onmousedown=function(j){if(this._ignoreMouse){return;}var i=this.getId();if(!j.target.id||j.target.id.indexOf(i+"-splitbar")!=0){return;}this._ignoreTouch=true;this._onBarMoveStart(j);};
S.prototype._onBarMoveStart=function(j,t){var I=this.getId();this.disableAutoResize(true);var p=j[this._moveCord];var B=parseInt(j.target.id.substr((I+"-splitbar-").length),10);var $=q(j.target);var m=this.getCalculatedSizes();var d=this._bHorizontal?$.innerWidth():$.innerHeight();var e=this._getContentAreas();var L=e[B].getLayoutData();var o=e[B+1].getLayoutData();if(!L.getResizable()||!o.getResizable()){a(t);return;}var f=0-d;for(var i=0;i<=B;++i){f+=m[i]+d;}this._move={start:p,relStart:f,barNum:B,bar:q(j.target),c1Size:m[B],c1MinSize:L?parseInt(L.getMinSize(),10):0,c2Size:m[B+1],c2MinSize:o?parseInt(o.getMinSize(),10):0};if(t){document.addEventListener("touchend",this._boundBarMoveEnd);document.addEventListener("touchmove",this._boundBarMove);}else{document.addEventListener("mouseup",this._boundBarMoveEnd);document.addEventListener("mousemove",this._boundBarMove);}this._$SplitterOverlay.css("display","block");this._$SplitterOverlay.appendTo(this.getDomRef());this._$SplitterOverlayBar.css(this._sizeDirNot,"");this._move["bar"].css("visibility","hidden");this._onBarMove(j);};
S.prototype._onBarMove=function(j){if(j.preventDefault){j.preventDefault();}var e=j;if(j.changedTouches&&j.changedTouches[0]){e=j.changedTouches[0];}var p=e[this._moveCord];var d=(p-this._move.start);if(this.getOrientation()==O.Horizontal&&this._bRtl){d=-d;}var f=this._move.c1Size+d;var g=this._move.c2Size-d;var i=(f>=0&&g>=0&&f>=this._move.c1MinSize&&g>=this._move.c2MinSize);if(i){this._$SplitterOverlayBar.css(this._sizeDir,this._move.relStart+d);if(this._liveResize){var m=(this._move["start"]-e[this._moveCord]);if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,false);}}};
S.prototype._onBarMoveEnd=function(j){this._ignoreMouse=false;this._ignoreTouch=false;var e=j;if(j.changedTouches&&j.changedTouches[0]){e=j.changedTouches[0];}var p=e[this._moveCord];var m=this._move["start"]-p;if(this.getOrientation()==O.Horizontal&&this._bRtl){m=-m;}this._resizeContents(this._move["barNum"],-m,true);this._move["bar"].css("visibility","");this._$SplitterOverlay.css("display","");document.removeEventListener("mouseup",this._boundBarMoveEnd);document.removeEventListener("mousemove",this._boundBarMove);document.removeEventListener("touchend",this._boundBarMoveEnd);document.removeEventListener("touchmove",this._boundBarMove);this.enableAutoResize(true);q.sap.focus(this._move.bar);};
S.prototype._resizeContents=function(L,p,f){if(isNaN(p)){q.sap.log.warning("Splitter: Received invalid resizing values - resize aborted.");return;}var d=this._getContentAreas();var o=d[L].getLayoutData();var e=d[L+1].getLayoutData();var s=o.getSize();var g=e.getSize();var $=this.$("content-"+L);var h=this.$("content-"+(L+1));var n=this._move.c1Size+p;var N=this._move.c2Size-p;var m=parseInt(o.getMinSize(),10);var M=parseInt(e.getMinSize(),10);var D;if(n<m){D=m-n;p+=D;n=m;N-=D;}else if(N<M){D=M-N;p-=D;N=M;n-=D;}if(f){if(s==="auto"&&g!=="auto"){e.setSize(N+"px");}else if(s!=="auto"&&g==="auto"){o.setSize(n+"px");}else{o.setSize(n+"px");e.setSize(N+"px");}}else{$.css(this._sizeType,n+"px");h.css(this._sizeType,N+"px");}};
S.prototype._preserveHandler=function(s,e,d){var D=this.getDomRef();if(D&&q.contains(d.domNode,D)){this._isPreserved=true;}};
S.prototype._delayedResize=function(d){if(d===undefined){d=0;}if(this.getDomRef()){q.sap.clearDelayedCall(this._resizeTimeout);q.sap.delayedCall(d,this,"_resize",[]);}};
S.prototype._resizeBars=function(d){var i,B;var $=this.$();for(i=0;i<d.length-1;++i){B=this.$("splitbar-"+i);B.css(this._sizeTypeNot,"");}for(i=0;i<d.length-1;++i){B=this.$("splitbar-"+i);var s=this._bHorizontal?$.height():$.width();B.css(this._sizeType,"");B.css(this._sizeTypeNot,s+"px");}};
S.prototype._resize=function(){if(this._isPreserved){return;}var i=0,B;var d=this._getContentAreas();this._resizeBars(d);var o=this.getCalculatedSizes();this._recalculateSizes();var n=this.getCalculatedSizes();var s=false;for(i=0;i<n.length;++i){if(n[i]!==0){s=true;break;}}if(!s){this._delayedResize(100);return;}var L=true;for(i=0;i<d.length;++i){var $=this.$("content-"+i);var e=d[i];$.css(this._sizeType,n[i]+"px");$.css(this._sizeTypeNot,"");var f=e.getLayoutData();var g=f&&f.getResizable();if(i>0){var h=g&&L;B=this.$("splitbar-"+(i-1));B.toggleClass("sapUiLoSplitterNoResize",!h);B.attr("tabindex",h&&this._keyboardEnabled?"0":"-1");}L=g;}this._resizeBars(d);if(_(o,n)){this.fireResize({oldSizes:o,newSizes:n});}};
S.prototype._calculateAvailableContentSize=function(s){var i=0;var $=this.$();var f=this._bHorizontal?$.innerWidth():$.innerHeight();var A=0;var h=false;for(i=0;i<s.length;++i){var d=s[i];if(d.indexOf("%")>-1){A++;}if(s[i]=="auto"){h=true;}}A+=h?1:0;f-=A;var e=s.length-1;var g=0;for(i=0;i<e;++i){g+=this._bHorizontal?this.$("splitbar-"+i).innerWidth():this.$("splitbar-"+i).innerHeight();}return f-g;};
S.prototype._recalculateSizes=function(){var i,s,L,d,e;var f=[];var g=this._getContentAreas();for(i=0;i<g.length;++i){L=g[i].getLayoutData();s=L?L.getSize():"auto";f.push(s);}this._calculatedSizes=[];var A=this._calculateAvailableContentSize(f);var h=[];var j=[];var p=[];var k=A;for(i=0;i<f.length;++i){s=f[i];var m;if(s.indexOf("px")>-1){m=parseInt(s,10);k-=m;this._calculatedSizes[i]=m;}else if(s.indexOf("%")>-1){p.push(i);}else if(f[i]=="auto"){L=g[i].getLayoutData();if(L&&parseInt(L.getMinSize(),10)!=0){j.push(i);}else{h.push(i);}}else{q.sap.log.error("Illegal size value: "+f[i]);}}var w=false;if(k<0){w=true;k=0;}var P=p.length;for(i=0;i<P;++i){e=p[i];d=Math.floor((parseFloat(f[e])/100)*A);this._calculatedSizes[e]=d;k-=d;}A=k;if(A<0){w=true;A=0;}d=Math.floor(A/(j.length+h.length),0);var n=j.length;for(i=0;i<n;++i){e=j[i];var M=parseInt(g[e].getLayoutData().getMinSize(),10);if(M>d){this._calculatedSizes[e]=M;A-=M;}else{this._calculatedSizes[e]=d;A-=d;}}if(A<0){w=true;A=0;}k=A;var o=h.length;d=Math.floor(A/o,0);for(i=0;i<o;++i){e=h[i];this._calculatedSizes[e]=d;k-=d;}if(w){q.sap.log.info("[Splitter] The set sizes and minimal sizes of the splitter contents are bigger "+"than the available space in the UI.");}};
S.prototype._switchOrientation=function(){this._bHorizontal=this.getOrientation()===O.Horizontal;if(this._bHorizontal){this._sizeDirNot="top";this._sizeTypeNot="height";this._sizeType="width";this._moveCord="pageX";if(this._bRtl){this._sizeDir="right";}else{this._sizeDir="left";}}else{this._moveCord="pageY";this._sizeType="height";this._sizeTypeNot="width";this._sizeDir="top";this._sizeDirNot="left";}var t=this.$();t.toggleClass("sapUiLoSplitterH",this._bHorizontal);t.toggleClass("sapUiLoSplitterV",!this._bHorizontal);};
S.prototype._onKeyboardResize=function(t,s,e){var B=this.getId()+"-splitbar-";if(!e||!e.target||!e.target.id||e.target.id.indexOf(B)!==0){return;}var i=999999;var d=parseInt(e.target.id.substr(B.length),10);var m=this.getCalculatedSizes();this._move.c1Size=m[d];this._move.c2Size=m[d+1];var f=0;switch(t){case"inc":f=s;break;case"incMore":f=s*10;break;case"dec":f=0-s;break;case"decMore":f=0-s*10;break;case"max":f=i;break;case"min":f=0-i;break;default:q.sap.log.warn("[Splitter] Invalid keyboard resize type");break;}this._resizeContents(d,f,true);};
S.prototype._enableKeyboardListeners=function(){this.onsapright=this._keyListeners.increase;this.onsapdown=this._keyListeners.increase;this.onsapleft=this._keyListeners.decrease;this.onsapup=this._keyListeners.decrease;this.onsappageup=this._keyListeners.decreaseMore;this.onsappagedown=this._keyListeners.increaseMore;this.onsapend=this._keyListeners.max;this.onsaphome=this._keyListeners.min;this._keyboardEnabled=true;};
S.prototype._disableKeyboardListeners=function(){delete this.onsapincreasemodifiers;delete this.onsapdecreasemodifiers;delete this.onsapendmodifiers;delete this.onsaphomemodifiers;this._keyboardEnabled=false;};
S.prototype._getText=function(k,A){return(r?r.getText(k,A):k);};
function _(s,d){if(s===d){return false;}if(!s||!d||s.length===undefined||d.length===undefined){return true;}if(s.length!=d.length){return true;}for(var i=0;i<s.length;++i){if(s[i]!==d[i]){return true;}}return false;}
function a(t){var p=function(e){e.preventDefault();};var A=null;A=function(){document.removeEventListener("touchend",A);document.removeEventListener("touchmove",p);document.removeEventListener("mouseup",A);document.removeEventListener("mousemove",p);};if(t){this._ignoreMouse=true;document.addEventListener("touchend",A);document.addEventListener("touchmove",p);}else{document.addEventListener("mouseup",A);document.addEventListener("mousemove",p);}}
function b(o){var L=o.getLayoutData();if(L&&(!L.getResizable||!L.getSize||!L.getMinSize)){q.sap.log.warning("Content \""+o.getId()+"\" for the Splitter contained wrong LayoutData. "+"The LayoutData has been replaced with default values.");L=null;}if(!L){o.setLayoutData(new sap.ui.layout.SplitterLayoutData());}}
S.prototype.invalidate=function(o){var f=(o&&this.indexOfContentArea(o)!=-1)||(o&&o instanceof sap.ui.core.CustomData&&o.getWriteToDom())||(o===undefined);if(f||this._needsInvalidation){this._needsInvalidation=false;C.prototype.invalidate.apply(this,arguments);}};
S.prototype.setOrientation=function(o){var v=this.setProperty("orientation",o,true);this._switchOrientation();this._delayedResize();this.$().find(".sapUiLoSplitterBar").attr("aria-orientation",this._bHorizontal?"vertical":"horizontal");return v;};
S.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",this.getProperty("width"));return this;};
S.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",this.getProperty("height"));return this;};
S.prototype.addContentArea=function(o){this._needsInvalidation=true;b(o);return this.addAggregation("contentAreas",o);};
S.prototype.removeContentArea=function(o){this._needsInvalidation=true;return this.removeAggregation("contentAreas",o);};
S.prototype.removeAllContentArea=function(){this._needsInvalidation=true;return this.removeAllAggregation("contentAreas");};
S.prototype.destroyContentArea=function(){this._needsInvalidation=true;return this.destroyAggregation("contentAreas");};
S.prototype.insertContentArea=function(o,i){this._needsInvalidation=true;b(o);return this.insertAggregation("contentAreas",o,i);};
S.prototype._getContentAreas=function(){return this.getContentAreas();};
return S;});
sap.ui.predefine('sap/ui/layout/SplitterLayoutData',['sap/ui/core/LayoutData','./library'],function(L,l){"use strict";
var S=L.extend("sap.ui.layout.SplitterLayoutData",{metadata:{library:"sap.ui.layout",properties:{resizable:{type:"boolean",group:"Behavior",defaultValue:true},size:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},minSize:{type:"int",group:"Dimension",defaultValue:0}}}});
return S;});
sap.ui.predefine('sap/ui/layout/SplitterRenderer',["sap/ui/core/library"],function(c){"use strict";var O=c.Orientation;var S={};
S.render=function(r,C){var h=C.getOrientation()===O.Horizontal;var o=h?"sapUiLoSplitterH":"sapUiLoSplitterV";var a=sap.ui.getCore().getConfiguration().getAnimation();r.write("<div");r.writeControlData(C);r.addClass("sapUiLoSplitter");r.addClass(o);if(a&&!C._liveResize){r.addClass("sapUiLoSplitterAnimated");}r.writeClasses();r.addStyle("width",C.getWidth());r.addStyle("height",C.getHeight());r.writeStyles();r.write(">");this.renderInitialContent(r,C);r.write("</div>");};
S.renderInitialContent=function(r,C){var I=C.getId();var h=C.getOrientation()===O.Horizontal;var s=h?"width":"height";var g="sap-icon://"+(h?"horizontal":"vertical")+"-grip";var a=C._getContentAreas();var l=a.length;var b=C.getCalculatedSizes();for(var i=0;i<l;++i){var L=a[i].getLayoutData();var d="0";if(b[i]){d=b[i]+"px";}else if(L){d=L.getSize();}r.write("<section "+"id=\""+I+"-content-"+i+"\" "+"style=\""+s+": "+d+";\" "+"class=\"sapUiLoSplitterContent\">");r.renderControl(a[i]);r.write("</section>");if(i<l-1){r.write("<div id=\""+I+"-splitbar-"+i+"\" "+"role=\"separator\" "+"title=\""+C._getText("SPLITTER_MOVE")+"\" "+"class=\"sapUiLoSplitterBar\" "+"aria-orientation=\""+(h?"vertical":"horizontal")+"\" "+"tabindex=\"0\">");if(C._bUseIconForSeparator){r.writeIcon(g,"sapUiLoSplitterBarIcon",{"id":I+"-splitbar-"+i+"-icon","title":null,"aria-label":null});}else{r.write("<span class='sapUiLoSplitterBarIcon'></span>");}r.write("</div>");}}r.write("<div id=\""+I+"-overlay\" class=\"sapUiLoSplitterOverlay\" style=\"display: none;\">"+"<div id=\""+I+"-overlayBar\" class=\"sapUiLoSplitterOverlayBar\">");if(C._bUseIconForSeparator){r.writeIcon(g,"sapUiLoSplitterBarIcon",{"id":I+"-splitbar-Overlay-icon","title":null,"aria-label":null});}else{r.write("<span class=\"sapUiLoSplitterBarIcon\"></span>");}r.write("</div>"+"</div>");};
return S;},true);
sap.ui.predefine('sap/ui/layout/VerticalLayout.designtime',[],function(){"use strict";return{actions:{remove:{changeType:"hideControl"},reveal:{changeType:"unhideControl"}},aggregations:{content:{domRef:":sap-domref",actions:{move:"moveControls"}}},name:{singular:"VERTICAL_LAYOUT_CONTROL_NAME",plural:"VERTICAL_LAYOUT_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/ui/layout/VerticalLayout',['sap/ui/core/Control','sap/ui/core/EnabledPropagator','./library'],function(C,E,l){"use strict";
var V=C.extend("sap.ui.layout.VerticalLayout",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},designTime:true}});
V.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){this.getDomRef().style.width=this.getWidth();}return this;};
V.prototype.getAccessibilityInfo=function(){return{children:this.getContent()};};
E.call(V.prototype);return V;});
sap.ui.predefine('sap/ui/layout/VerticalLayoutRenderer',[],function(){"use strict";var V={};
V.render=function(r,v){var a=r;a.write("<DIV");a.writeControlData(v);a.addClass("sapUiVlt");a.addClass("sapuiVlt");if(v.getWidth()&&v.getWidth()!=''){a.addStyle("width",v.getWidth());}a.writeStyles();a.writeClasses();a.write(">");var c=v.getContent();for(var i=0;i<c.length;i++){a.write("<DIV class=\"sapUiVltCell sapuiVltCell\">");a.renderControl(c[i]);a.write("</DIV>");}a.write("</DIV>");};
return V;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddFormContainer',["sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/JsControlTreeModifier"],function(F,q,B,J){"use strict";var A={};
A.applyChange=function(c,f,p){var m=p.modifier,a=p.appComponent,v=p.view,C=c.getDefinition();if(C.texts&&C.texts.groupLabel&&C.texts.groupLabel.value&&C.content&&C.content.group&&(C.content.group.selector||C.content.group.id)){var t=C.texts.groupLabel.value,i=C.content.group.index,n=C.content.group.selector||{id:C.content.group.id},N=q.extend({},n);N.id=N.id+"--title";var T=m.createControl("sap.ui.core.Title",a,v,N),g=m.createControl("sap.ui.layout.form.FormContainer",a,v,n);m.setProperty(T,"text",t);m.insertAggregation(g,"title",T,0,v);m.insertAggregation(f,"formContainers",g,i,v);}else{F.log.error("Change does not contain sufficient information to be applied: ["+C.layer+"]"+C.namespace+"/"+C.fileName+"."+C.fileType);}};
A.completeChangeContent=function(c,s,p){var C=c.getDefinition(),a=p.appComponent;if(s.newLabel){B.setTextInChange(C,"groupLabel",s.newLabel,"XFLD");}else{throw new Error("Cannot create a new group: oSpecificChangeInfo.groupLabel attribute required");}if(!C.content){C.content={};}if(!C.content.group){C.content.group={};}if(s.index===undefined){throw new Error("Cannot create a new group: oSpecificChangeInfo.index attribute required");}else{C.content.group.index=s.index;}if(s.newControlId){C.content.group.selector=J.getSelector(s.newControlId,a);}else{throw new Error("Cannot create a new group: oSpecificChangeInfo.newControlId attribute required");}};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddFormField',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/ChangeHandlerMediator"],function(U,C){"use strict";var A={};
A.applyChange=function(c,f,p){var o=c.getDefinition();var v=p.view;var i=o.content.newFieldIndex;var m=p.modifier;var P=c.getDependentControl("parentFormContainer",p);var a=C.getChangeHandlerSettings({"scenario":"addODataFieldWithLabel","oDataServiceVersion":o.content&&o.content.oDataServiceVersion});var b=a&&a.content&&a.content.createFunction;var d=function(o){var k=o.content;var M=false;if(k){M=o.content.newFieldSelector&&(o.content.newFieldIndex!==undefined)&&o.content.bindingPath&&o.content.oDataServiceVersion&&b;}return k&&M;};if(d(o)){var e=o.content;var F=e.newFieldSelector;var s=jQuery.extend({},e.newFieldSelector);s.id=s.id+"-field";var B=e.bindingPath;var g={"appComponent":p.appComponent,"view":p.view,"fieldSelector":s,"bindingPath":B};var h=b(m,g),j=m.createControl("sap.ui.layout.form.FormElement",p.appComponent,v,F);m.insertAggregation(j,"label",h.label,0,v);m.insertAggregation(j,"fields",h.control,0,v);m.insertAggregation(P,"formElements",j,i,v);return true;}else{U.log.error("Change does not contain sufficient information to be applied or ChangeHandlerMediator could not be retrieved: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
A.completeChangeContent=function(c,s,p){var a=p.appComponent;var o=c.getDefinition();if(!o.content){o.content={};}if(s.parentId){c.addDependentControl(s.parentId,"parentFormContainer",p);}else{throw new Error("oSpecificChangeInfo.parentId attribute required");}if(s.bindingPath){o.content.bindingPath=s.bindingPath;}else{throw new Error("oSpecificChangeInfo.bindingPath attribute required");}if(s.newControlId){o.content.newFieldSelector=p.modifier.getSelector(s.newControlId,a);}else{throw new Error("oSpecificChangeInfo.newControlId attribute required");}if(s.index===undefined){throw new Error("oSpecificChangeInfo.targetIndex attribute required");}else{o.content.newFieldIndex=s.index;}if(s.oDataServiceVersion===undefined){throw new Error("oSpecificChangeInfo.oDataServiceVersion attribute required");}else{o.content.oDataServiceVersion=s.oDataServiceVersion;}};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddSimpleFormField',["sap/ui/fl/Utils","sap/ui/fl/changeHandler/ChangeHandlerMediator"],function(U,C){"use strict";var A={};var t="sap.ui.core.Title";var T="sap.m.Toolbar";var s="sap.m.Label";var a="sap.ui.comp.smartfield.SmartLabel";
A.applyChange=function(c,S,p){var o=c.getDefinition();var b=c.getDependentControl("targetContainerHeader",p);var m=C.getChangeHandlerSettings({"scenario":"addODataFieldWithLabel","oDataServiceVersion":o.content&&o.content.oDataServiceVersion});var f=m&&m.content&&m.content.createFunction;var d=function(o){var v=o.content;var w=false;if(v){w=o.content.newFieldSelector&&(o.content.newFieldIndex!==undefined)&&o.content.bindingPath&&o.content.oDataServiceVersion&&f;}return v&&w;};var M=p.modifier;if(d(o)){var e=o.content;var F=e.newFieldSelector;var B=e.bindingPath;var g=e.newFieldIndex;var h=M.getAggregation(S,"content");var k=h.slice();var I=h.indexOf(b);var n=0;var l=0;if(h.length===1||h.length===I+1){n=h.length;}else{var j=0;for(j=I+1;j<h.length;j++){var q=M.getControlType(h[j]);if(q===s||q===a){if(l==g){n=j;break;}l++;}if(q===t||q===T){n=j;break;}if(j===(h.length-1)){n=h.length;}}}var r={"appComponent":p.appComponent,"view":p.view,"fieldSelector":F,"bindingPath":B};var u=f(M,r);k.splice(n,0,u.label,u.control);M.removeAllAggregation(S,"content");for(var i=0;i<k.length;++i){M.insertAggregation(S,"content",k[i],i,p.view);}return true;}else{U.log.error("Change does not contain sufficient information to be applied or ChangeHandlerMediator could not be retrieved: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
A.completeChangeContent=function(c,S,p){var o=p.appComponent;var v=p.view;var b=c.getDefinition();if(!b.content){b.content={};}if(S.parentId){var f=p.modifier.bySelector(S.parentId,o,v);var d=f.getTitle()||f.getToolbar();if(d){c.addDependentControl(d.getId(),"targetContainerHeader",p);}}else{throw new Error("oSpecificChangeInfo.parentId attribute required");}if(S.bindingPath){b.content.bindingPath=S.bindingPath;}else{throw new Error("oSpecificChangeInfo.bindingPath attribute required");}if(S.newControlId){b.content.newFieldSelector=p.modifier.getSelector(S.newControlId,o);}else{throw new Error("oSpecificChangeInfo.newControlId attribute required");}if(S.index===undefined){throw new Error("oSpecificChangeInfo.targetIndex attribute required");}else{b.content.newFieldIndex=S.index;}if(S.oDataServiceVersion===undefined){throw new Error("oSpecificChangeInfo.oDataServiceVersion attribute required");}else{b.content.oDataServiceVersion=S.oDataServiceVersion;}};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/AddSimpleFormGroup',['sap/ui/fl/Utils','sap/ui/fl/changeHandler/Base','sap/ui/fl/changeHandler/JsControlTreeModifier'],function(U,B,J){"use strict";var A={};A.CONTENT_AGGREGATION="content";var f=function(M,s,c){for(var i=0;i<c.length;i++){var t=M.getControlType(c[i]);if(s.indexOf(t)===-1){if(M.getVisible(c[i])){return true;}}else{return false;}}};var m=function(M,s,c,g){var r;var C=-1;if(g===0){return g;}if(f(M,s,c)){C++;}for(var i=0;i<c.length;i++){var t=M.getControlType(c[i]);if(s.indexOf(t)>-1){C++;if(C===g){r=c[i];return c.indexOf(r);}}}return c.length;};
A.applyChange=function(c,F,p){var M=p.modifier;var v=p.view;var a=p.appComponent;var C=c.getDefinition();if(C.texts&&C.texts.groupLabel&&C.texts.groupLabel.value&&C.content&&C.content.group&&(C.content.group.selector||C.content.group.id)){var g=C.content.group.selector;var G;if(g){if(g.idIsLocal){G=a.createId(g.id);}else{G=g.id;}}else{G=C.content.group.id;}var l=C.texts.groupLabel.value;var b=M.getAggregation(F,A.CONTENT_AGGREGATION);var i;var r;if(typeof C.content.group.index==="number"){i=C.content.group.index;}else{r=C.content.group.relativeIndex;i=m(M,["sap.ui.core.Title","sap.m.Title","sap.m.Toolbar","sap.m.OverflowToolbar"],b,r);}var t=M.createControl("sap.ui.core.Title",a,v,G);M.setProperty(t,"text",l);M.insertAggregation(F,"content",t,i,v);}else{U.log.error("Change does not contain sufficient information to be applied: ["+C.layer+"]"+C.namespace+"/"+C.fileName+"."+C.fileType);}return true;};
A.completeChangeContent=function(c,s,p){var C=c.getDefinition();var a=p.appComponent;if(s.newLabel){B.setTextInChange(C,"groupLabel",s.newLabel,"XFLD");}else{throw new Error("oSpecificChangeInfo.newLabel attribute required");}if(!C.content){C.content={};}if(!C.content.group){C.content.group={};}if(s.newControlId){C.content.group.selector=J.getSelector(s.newControlId,a);}else{throw new Error("oSpecificChangeInfo.newControlId attribute required");}if(s.index===undefined){throw new Error("oSpecificChangeInfo.index attribute required");}else{C.content.group.relativeIndex=s.index;}};
A.getControlIdFromChangeContent=function(c){var C;if(c&&c._oDefinition){C=c._oDefinition.content.group.id;}return C;};
return A;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/HideSimpleForm',['sap/ui/fl/changeHandler/JsControlTreeModifier'],function(J){"use strict";var H={};var I=function(c,m){var C=m.getControlType(c);return(C==="sap.ui.core.Title")||(C==="sap.m.Title")||(C==="sap.m.Toolbar")||(C==="sap.m.OverflowToolbar");};var g=function(c,m){var i;for(i=0;i<c.length;++i){if(I(c[i],m)){return c[i];}}};
H.applyChange=function(c,C,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var r=m.bySelector(o.content.elementSelector||o.content.sHideId,a,v);var b=m.getAggregation(C,"content");var s=-1;m.removeAllAggregation(C,"content");for(var i=0;i<b.length;++i){m.insertAggregation(C,"content",b[i],i,v);}if(o.changeType==="hideSimpleFormField"){b.some(function(F,d){if(F===r){s=d;m.setVisible(F,false);}if(s>=0&&d>s){if((m.getControlType(F)==="sap.m.Label")||(m.getControlType(F)==="sap.ui.comp.smartfield.SmartLabel")||I(F,m)){return true;}else{m.setVisible(F,false);}}});}else if(o.changeType==="removeSimpleFormGroup"){var t=g(b,m);var f=t&&!r;b.some(function(F,d){if(!t){m.setVisible(F,false);}else if(f){s=0;m.setVisible(F,false);f=false;}else{if(F===r){s=d;}if(s>=0&&d>s){if(I(F,m)){if(s===0){m.removeAggregation(C,"content",F,v);m.insertAggregation(C,"content",F,0,v);}return true;}else{m.setVisible(F,false);}}}});if(r){m.removeAggregation(C,"content",r,v);}}return true;};
H._getStableElement=function(e){if(e.getMetadata().getName()==="sap.ui.layout.form.FormContainer"){return e.getTitle()||e.getToolbar();}else if(e.getMetadata().getName()==="sap.ui.layout.form.FormElement"){return e.getLabel();}else{return e;}};
H.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(s.removedElement&&s.removedElement.id){var S=this._getStableElement(sap.ui.getCore().byId(s.removedElement.id));C.content.elementSelector=J.getSelector(S,p.appComponent);c.addDependentControl(S,"elementSelector",p);}else{throw new Error("oSpecificChangeInfo.removedElement.id attribute required");}};
return H;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/MoveSimpleForm',["jquery.sap.global","sap/ui/fl/changeHandler/JsControlTreeModifier"],function(q,J){"use strict";var M={};M.CHANGE_TYPE_MOVE_FIELD="moveSimpleFormField";M.CHANGE_TYPE_MOVE_GROUP="moveSimpleFormGroup";M.sTypeTitle="sap.ui.core.Title";M.sTypeMTitle="sap.m.Title";M.sTypeToolBar="sap.m.Toolbar";M.sTypeOverflowToolBar="sap.m.OverflowToolbar";M.sTypeLabel="sap.m.Label";M.sTypeSmartLabel="sap.ui.comp.smartfield.SmartLabel";M.CONTENT_AGGREGATION="content";var f=function(o,s,C){for(var i=0;i<C.length;i++){var t=o.getControlType(C[i]);if(s.indexOf(t)===-1){if(o.getVisible(C[i])){return true;}}else{return false;}}};var a=function(o,C,s,p,S){if(f(o,S,C)){var v=p.view;var h=p.appComponent;var i=h.createId(q.sap.uid());var t=o.createControl("sap.ui.core.Title",h,v,i);o.setProperty(t,"text","");o.insertAggregation(s,"content",t,0,v);}return o.getAggregation(s,"content");};var m=function(o,s,C,h){var R;var j=-1;if(f(o,s,C)){j++;}for(var i=0;i<C.length;i++){var t=o.getControlType(C[i]);if(s.indexOf(t)>-1){j++;if(j===h){R=C[i];break;}}}return C.indexOf(R);};var I=function(E,i,o){if(i>=E.length||i===-1){return true;}var t=o.getControlType(E[i]);return(M.sTypeTitle===t||M.sTypeToolBar===t||M.sTypeMTitle===t||M.sTypeOverflowToolBar===t);};var b=function(o,h,C,s){var i=0;for(i=h+1;i<C.length;++i){var t=o.getControlType(C[i]);if(s.indexOf(t)>-1){break;}}return i-h;};var g=function(o,E,i){return b(o,i,E,[M.sTypeTitle,M.sTypeMTitle,M.sTypeToolBar,M.sTypeOverflowToolBar,M.sTypeLabel,M.sTypeSmartLabel]);};var c=function(o,C,i,F,u){if(!I(C,i,o)){q.sap.log.error("Illegal argument. iIndex has to point to a Label.");}else{F=u?F+1:F;var h=0;var j=i;var k;while(j<C.length&&h<F){++h;k=g(o,C,j);j+=k;}return j;}};var A=function(s,S,t,T,h){var R=t;for(var i=0;i<h;i++){R.splice(T+i,0,s[S+i]);}return R;};var G=function(h){var R=h.getTitle();if(!R){R=h.getToolbar();}return R;};var d=function(s,h,S,t,p){var o=G(h.element);var i=J.getSelector(s,p.appComponent);var j={elementSelector:J.getSelector(o,p.appComponent),source:{groupIndex:h.sourceIndex},target:{groupIndex:h.targetIndex}};return{changeType:M.CHANGE_TYPE_MOVE_GROUP,targetSelector:i,movedControl:o,movedElements:[j]};};var e=function(s,h,S,t,p){var o=J.getSelector(s,p.appComponent);var l=h.element.getLabel();var L=J.getSelector(l,p.appComponent);var T=G(t.parent);var i=G(S.parent);var j=J.getSelector(T,p.appComponent);var k=J.getSelector(i,p.appComponent);var n={elementSelector:L,source:{groupSelector:k,fieldIndex:h.sourceIndex},target:{groupSelector:j,fieldIndex:h.targetIndex}};return{changeType:M.CHANGE_TYPE_MOVE_FIELD,targetSelector:o,target:T,source:i,movedControl:l,movedElements:[n]};};var r=function(o,s,M,C,v){o.removeAllAggregation(s,M.CONTENT_AGGREGATION);for(var i=0;i<C.length;++i){o.insertAggregation(s,M.CONTENT_AGGREGATION,C[i],i,v);}};
M.applyChange=function(C,s,p){var o=p.modifier;var v=p.view;var h=p.appComponent;var t,i;var j=C.getContent();var k=j.movedElements[0];var l=o.getAggregation(s,M.CONTENT_AGGREGATION);if(C.getChangeType()===M.CHANGE_TYPE_MOVE_FIELD){var S=o.bySelector(k.elementSelector||k.element,h,v);var n=l.indexOf(S);var u=g(o,l,n);t=o.bySelector(k.target.groupSelector||k.target.groupId,h,v);var T=l.indexOf(t);var w=o.bySelector(k.source.groupSelector||k.source.groupId,h,v);var x=l.indexOf(w);var y=c(o,l,T,k.target.fieldIndex,(x===T)&&(k.source.fieldIndex<k.target.fieldIndex));var z=g(o,l,y);i=l.slice();var F=i.slice(n,n+u);var B,D,E,H;if(n<y){B=i.slice(0,n);E=i.slice(n+u,y+z);H=i.slice(y+z,i.length);i=B.concat(E.concat(F.concat(H)));}else if(n>y){D=i.slice(0,y+z);E=i.slice(y+z,n);H=i.slice(n+u,i.length);i=D.concat(F.concat(E.concat(H)));}if(n!=y){r(o,s,M,i,v);}}else if(C.getChangeType()===M.CHANGE_TYPE_MOVE_GROUP){var K=[M.sTypeTitle,M.sTypeToolBar,M.sTypeMTitle,M.sTypeOverflowToolBar];var L=o.bySelector(k.elementSelector||k.element,h,v);if(k.target.groupIndex===0||!L){l=a(o,l,s,p,K,j.newControlId);}var N=L?l.indexOf(L):0;var O=m(o,K,l,k.target.groupIndex);t=l[O];var P=b(o,O,l,K);var Q=b(o,N,l,K);i=l.slice();i.splice(N,Q);O=i.indexOf(t);var R=k.source.groupIndex<k.target.groupIndex?P:0;i=A(l,N,i,O+R,Q);r(o,s,M,i,v);}else{q.sap.log.warning("Unknown change type detected. Cannot apply to SimpleForm");}return true;};
M.completeChangeContent=function(C,s,p){var S;var o=p.modifier;var v=p.view;var h=p.appComponent;var i=o.bySelector(s.selector,h,v);var j=s.movedElements;if(j.length>1){q.sap.log.warning("Moving more than 1 Formelement is not yet supported.");}var k=j[0];k.element=sap.ui.getCore().byId(k.id);var l=q.extend({},s.source);var t=q.extend({},s.target);if(!t.parent){t.parent=sap.ui.getCore().byId(t.id);}if(!l.parent){l.parent=sap.ui.getCore().byId(l.id);}if(i&&k.element&&t.parent){if(s.changeType==="moveSimpleFormGroup"){S=d(i,k,l,t,p);}else if(s.changeType==="moveSimpleFormField"){S=e(i,k,l,t,p);}}else{q.sap.log.error("Element not found. This may caused by an instable id!");}var n=C.getDefinition();n.content.targetSelector=S.targetSelector;n.content.movedElements=S.movedElements;if(S.source&&S.target){C.addDependentControl(S.source,"sourceParent",p);C.addDependentControl(S.target,"targetParent",p);}C.addDependentControl([S.movedControl],"movedElements",p);};
return M;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/RenameFormContainer',["sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(B,U){"use strict";var R={};var _={TARGET_ALIAS:"target"};
R.applyChange=function(c,C,p){var m=p.modifier,o=c.getDefinition(),r=c.getDependentControl(_.TARGET_ALIAS,p),t=m.getAggregation(r,"title");if(o.texts&&o.texts.formText&&this._isProvided(o.texts.formText.value)){var v=o.texts.formText.value;if(typeof t==="string"){m.setProperty(r,"title",v);}else{m.setProperty(t,"text",v);}return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(!(s.renamedElement&&s.renamedElement.id)){throw new Error("Rename of the group cannot be executed: oSpecificChangeInfo.renamedElement attribute required");}if(!this._isProvided(s.value)){throw new Error("Rename of the group cannot be executed: oSpecificChangeInfo.value attribute required");}c.addDependentControl(s.renamedElement.id,_.TARGET_ALIAS,p);B.setTextInChange(C,"formText",s.value,"XGRP");};
R._isProvided=function(s){return typeof(s)==="string";};
return R;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/RenameSimpleForm',["sap/ui/fl/changeHandler/Base","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/fl/Utils"],function(B,J,U){"use strict";var R={};
R.applyChange=function(c,C,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var s=o.content.elementSelector||o.content.sRenameId;var r=m.bySelector(s,a,v);if(o.texts&&o.texts.formText&&this._isProvided(o.texts.formText.value)){if(!C){throw new Error("no Control provided for renaming");}var V=o.texts.formText.value;m.setProperty(r,"text",V);return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}};
R.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(!s.changeType){throw new Error("oSpecificChangeInfo.changeType attribute required");}if(s.renamedElement&&s.renamedElement.id){var r=sap.ui.getCore().byId(s.renamedElement.id);var S;if(s.changeType==="renameLabel"){S=r.getLabel();}else if(s.changeType==="renameTitle"){S=r.getTitle();}C.content.elementSelector=J.getSelector(S,p.appComponent);c.addDependentControl(S,"elementSelector",p);}else{throw new Error("oSpecificChangeInfo.renamedElement attribute required");}if(this._isProvided(s.value)){B.setTextInChange(C,"formText",s.value,"XFLD");}else{throw new Error("oSpecificChangeInfo.value attribute required");}};
R._isProvided=function(s){return typeof(s)==="string";};
return R;},true);
sap.ui.predefine('sap/ui/layout/changeHandler/UnhideSimpleForm',["sap/ui/fl/changeHandler/JsControlTreeModifier"],function(J){"use strict";var U={};
U.applyChange=function(c,C,p){var m=p.modifier;var v=p.view;var a=p.appComponent;var o=c.getDefinition();var b=m.bySelector(o.content.elementSelector||o.content.sUnhideId,a,v);var d=m.getAggregation(C,"content");var s=-1;if(o.changeType==="unhideSimpleFormField"){d.some(function(f,i){if(f===b){s=i;m.setVisible(f,true);}if(s>=0&&i>s){if((m.getControlType(f)==="sap.m.Label")||(m.getControlType(f)==="sap.ui.comp.smartfield.SmartLabel")||(m.getControlType(f)==="sap.ui.core.Title")||(m.getControlType(f)==="sap.m.Title")||(m.getControlType(f)==="sap.m.Toolbar")||(m.getControlType(f)==="sap.m.OverflowToolbar")){return true;}else{m.setVisible(f,true);}}});}return true;};
U.completeChangeContent=function(c,s,p){var C=c.getDefinition();if(s.sUnhideId){var u=sap.ui.getCore().byId(s.sUnhideId);C.content.elementSelector=J.getSelector(u,p.appComponent);c.addDependentControl(u,"elementSelector",p);}else if(s.revealedElementId){var f=sap.ui.getCore().byId(s.revealedElementId||s.sUnhideId);var l=f.getLabel();C.content.elementSelector=J.getSelector(l,p.appComponent);c.addDependentControl(l,"elementSelector",p);}else{throw new Error("oSpecificChangeInfo.revealedElementId attribute required");}};
return U;},true);
sap.ui.predefine('sap/ui/layout/flexibility/BlockLayoutCell.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","moveControls":"default","rename":B.createRenameChangeHandler({propertyName:"title",translationTextType:"XTIT"}),"unhideControl":"default"};},false);
sap.ui.predefine('sap/ui/layout/flexibility/Form.flexibility',["sap/ui/layout/changeHandler/AddFormContainer","sap/ui/layout/changeHandler/AddFormField"],function(A,a){"use strict";return{"moveControls":"default","addGroup":A,"addFormField":a};},true);
sap.ui.predefine('sap/ui/layout/flexibility/FormContainer.flexibility',["sap/ui/layout/changeHandler/RenameFormContainer","sap/ui/layout/changeHandler/AddFormField"],function(R,A){"use strict";return{"hideControl":"default","renameGroup":R,"moveControls":"default","addFormField":A};},true);
sap.ui.predefine('sap/ui/layout/flexibility/FormElement.flexibility',["sap/ui/fl/changeHandler/BaseRename"],function(B){"use strict";return{"hideControl":"default","unhideControl":"default","renameField":B.createRenameChangeHandler({propertyName:"label",translationTextType:"XFLD",changePropertyName:"fieldLabel"})};},true);
sap.ui.predefine('sap/ui/layout/flexibility/SimpleForm.flexibility',["sap/ui/layout/changeHandler/RenameSimpleForm","sap/ui/layout/changeHandler/MoveSimpleForm","sap/ui/layout/changeHandler/HideSimpleForm","sap/ui/layout/changeHandler/UnhideSimpleForm","sap/ui/layout/changeHandler/AddSimpleFormGroup","sap/ui/layout/changeHandler/AddSimpleFormField"],function(R,M,H,U,A,a){"use strict";return{"renameLabel":R,"renameTitle":R,"moveSimpleFormField":M,"moveSimpleFormGroup":M,"hideSimpleFormField":H,"unhideSimpleFormField":U,"removeSimpleFormGroup":H,"addSimpleFormGroup":A,"addSimpleFormField":a};},true);
sap.ui.predefine('sap/ui/layout/form/Form.designtime',[],function(){"use strict";return{aggregations:{title:{ignore:true},toolbar:{ignore:function(f){return!f.getToolbar();},domRef:function(f){return f.getToolbar().getDomRef();}},formContainers:{childNames:{singular:"GROUP_CONTROL_NAME",plural:"GROUP_CONTROL_NAME_PLURAL"},domRef:":sap-domref",actions:{move:"moveControls",createContainer:{changeType:"addGroup",isEnabled:true,getCreatedContainerId:function(n){return n;}}}}}};},false);
sap.ui.predefine('sap/ui/layout/form/Form',['sap/ui/core/Control','sap/ui/layout/library'],function(C,l){"use strict";
var F=C.extend("sap.ui.layout.form.Form",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"formContainers",aggregations:{formContainers:{type:"sap.ui.layout.form.FormContainer",multiple:true,singularName:"formContainer"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},layout:{type:"sap.ui.layout.form.FormLayout",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});
F.prototype.toggleContainerExpanded=function(c){var L=this.getLayout();if(L){L.toggleContainerExpanded(c);}};
F.prototype.contentOnAfterRendering=function(f,c){var L=this.getLayout();if(L&&L.contentOnAfterRendering){L.contentOnAfterRendering(f,c);}};
F.prototype.onLayoutDataChange=function(e){var L=this.getLayout();if(L&&L.onLayoutDataChange){L.onLayoutDataChange(e);}};
F.prototype.onBeforeFastNavigationFocus=function(e){var L=this.getLayout();if(L&&L.onBeforeFastNavigationFocus){L.onBeforeFastNavigationFocus(e);}};
F.prototype.setEditable=function(e){var o=this.getEditable();this.setProperty("editable",e,true);if(e!=o&&this.getDomRef()){if(e){this.$().addClass("sapUiFormEdit").addClass("sapUiFormEdit-CTX");this.$().removeAttr("aria-readonly");}else{this.$().removeClass("sapUiFormEdit").removeClass("sapUiFormEdit-CTX");this.$().attr("aria-readonly","true");}var f=this.getFormContainers();for(var i=0;i<f.length;i++){var a=f[i];a.invalidateLabels();}}return this;};
F.prototype.setToolbar=function(t){t=l.form.FormHelper.setToolbar.call(this,t);this.setAggregation("toolbar",t);return this;};
F.prototype.invalidate=function(o){if(!this._bNoInvalidate){C.prototype.invalidate.apply(this,arguments);}};
F.prototype.getContainerRenderedDomRef=function(c){var L=this.getLayout();if(L&&L.getContainerRenderedDomRef){return L.getContainerRenderedDomRef(c);}else{return null;}};
F.prototype.getElementRenderedDomRef=function(e){var L=this.getLayout();if(L&&L.getElementRenderedDomRef){return L.getElementRenderedDomRef(e);}else{return null;}};
return F;});
sap.ui.predefine('sap/ui/layout/form/FormContainer.designtime',['sap/ui/fl/changeHandler/ChangeHandlerMediator'],function(C){"use strict";
function _(f){return f.getFormElements().every(function(F){return F.getVisible()===false;});}
return{isVisible:function(f){return f.isVisible();},actions:{remove:{changeType:"hideControl"},rename:{changeType:"renameGroup",domRef:function(f){return jQuery(f.getRenderedDomRef()).find(".sapUiFormTitle")[0];},isEnabled:function(f){return!(f.getToolbar()||!f.getTitle());}}},aggregations:{formElements:{childNames:{singular:"FIELD_CONTROL_NAME",plural:"FIELD_CONTROL_NAME_PLURAL"},domRef:function(f){var d=f.getDomRef();var h=f.getTitle()||f.getToolbar();if(!d&&(f.getFormElements().length===0||_(f))&&h instanceof sap.ui.core.Element){return h.getDomRef();}else if(typeof h==="string"){return jQuery(d).find(".sapUiFormTitle").get(0);}else{return d;}},actions:{move:"moveControls",addODataProperty:function(f){var c=C.getAddODataFieldWithLabelSettings(f);if(c){return{changeType:"addFormField",changeOnRelevantContainer:true,changeHandlerSettings:c};}}}},toolbar:{domRef:function(f){var t=f.getToolbar();if(t){return t.getDomRef();}}}},name:{singular:"GROUP_CONTROL_NAME",plural:"GROUP_CONTROL_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/ui/layout/form/FormContainer',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/theming/Parameters','sap/ui/layout/library'],function(q,E,P,l){"use strict";
var F=E.extend("sap.ui.layout.form.FormContainer",{metadata:{library:"sap.ui.layout",properties:{expanded:{type:"boolean",group:"Misc",defaultValue:true},expandable:{type:"boolean",group:"Misc",defaultValue:false},visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"formElements",aggregations:{formElements:{type:"sap.ui.layout.form.FormElement",multiple:true,singularName:"formElement"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false},_expandButton:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});
F.prototype.init=function(){this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");};
F.prototype.exit=function(){if(this._oExpandButton){delete this._oExpandButton;}this._rb=undefined;};
F.prototype.setExpandable=function(e){this.setProperty("expandable",e);if(e){if(!this._oExpandButton){if(!this._bExpandButtonRequired){this._bExpandButtonRequired=true;l.form.FormHelper.createButton.call(this,this.getId()+"--Exp",b,_);}}else{a.call(this);}}return this;};
function _(B){if(!this._bIsBeingDestroyed){this._oExpandButton=B;this.setAggregation("_expandButton",this._oExpandButton);a.call(this);}}
F.prototype.setExpanded=function(e){this.setProperty("expanded",e,true);a.call(this);var f=this.getParent();if(f&&f.toggleContainerExpanded){f.toggleContainerExpanded(this);}return this;};
F.prototype.setToolbar=function(t){t=l.form.FormHelper.setToolbar.call(this,t);this.setAggregation("toolbar",t);return this;};
F.prototype.contentOnAfterRendering=function(f,c){var p=this.getParent();if(p&&p.contentOnAfterRendering){p.contentOnAfterRendering(f,c);}};
F.prototype.onLayoutDataChange=function(e){var p=this.getParent();if(p&&p.onLayoutDataChange){p.onLayoutDataChange(e);}};
F.prototype._checkProperties=function(){var r=0;if(this.getExpandable()&&(!this.getTitle()||this.getToolbar())){q.sap.log.warning("Expander only displayed if title is set",this.getId(),"FormContainer");r=1;}return r;};
F.prototype.getRenderedDomRef=function(){var t=this;var f=this.getParent();if(f&&f.getContainerRenderedDomRef){return f.getContainerRenderedDomRef(t);}else{return null;}};
F.prototype.getElementRenderedDomRef=function(e){var f=this.getParent();if(f&&f.getElementRenderedDomRef){return f.getElementRenderedDomRef(e);}else{return null;}};
F.prototype.invalidateLabels=function(){var f=this.getFormElements();for(var i=0;i<f.length;i++){var o=f[i];o.invalidateLabel();}};
F.prototype.isVisible=function(){return this.getVisible();};
function a(){if(!this._oExpandButton){return;}var i,I,t,T;if(this.getExpanded()){i=P._getThemeImage('_sap_ui_layout_Form_FormContainerColImageURL');I=P._getThemeImage('_sap_ui_layout_Form_FormContainerColImageDownURL');t="-";T=this._rb.getText("FORM_COLLAPSE");}else{i=P._getThemeImage('_sap_ui_layout_Form_FormContainerExpImageURL');I=P._getThemeImage('_sap_ui_layout_Form_FormContainerExpImageDownURL');t="+";T=this._rb.getText("FORM_EXPAND");}if(i){t="";}l.form.FormHelper.setButtonContent(this._oExpandButton,t,T,i,I);}
function b(e){this.setExpanded(!this.getExpanded());}
return F;});
sap.ui.predefine('sap/ui/layout/form/FormElement.designtime',['sap/ui/layout/form/Form','sap/ui/layout/form/FormContainer','sap/ui/layout/form/ResponsiveGridLayout'],function(F,a,R){"use strict";return{isVisible:function(f){return f.isVisible();},domRef:function(f){var p=f.getParent();if(p instanceof a){p=p.getParent();if(p instanceof F){var l=p.getLayout();if(l instanceof R){var b=f.getFields();var L=f.getLabelControl();if(L){b.unshift(L);}return b.filter(function(e){return e.getDomRef&&e.getDomRef();}).map(function(e){var d=e.getDomRef();return d.parentNode;});}}}},actions:{remove:{changeType:"hideControl"},rename:{changeType:"renameField",domRef:function(c){return c.getLabelControl().getDomRef();}},reveal:{changeType:"unhideControl"}},name:{singular:"FIELD_CONTROL_NAME",plural:"FIELD_CONTROL_NAME_PLURAL"}};},false);
sap.ui.predefine('sap/ui/layout/form/FormElement',['jquery.sap.global','sap/ui/core/Element','sap/ui/base/ManagedObjectObserver','sap/ui/layout/library'],function(q,E,M,l){"use strict";
var F=E.extend("sap.ui.layout.form.FormElement",{metadata:{library:"sap.ui.layout",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"fields",aggregations:{label:{type:"sap.ui.core.Label",altTypes:["string"],multiple:false},_label:{type:"sap.ui.core.Label",multiple:false,visibility:"hidden"},fields:{type:"sap.ui.core.Control",multiple:true,singularName:"field"}},designTime:true}});
F.prototype.init=function(){this._oFieldDelegate={oElement:this,onAfterRendering:h};this._oObserver=new M(this._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["fields"]});};
F.prototype.exit=function(){if(this._oLabel){delete this._oLabel;}this._oFieldDelegate=undefined;this._oObserver.disconnect();this._oObserver=undefined;};
F.prototype.setLabel=function(A){if(!this._oLabel){var o=this.getLabel();if(o){if(o.setAlternativeLabelFor){o.setAlternativeLabelFor(null);}if(o.isRequired){o.isRequired=o._sapuiIsRequired;o._sapuiIsRequired=undefined;o.disableRequiredChangeCheck(false);}if(o.isDisplayOnly){o.isDisplayOnly=o._sapuiIsDisplayOnly;o._sapuiIsDisplayOnly=undefined;}}}this.setAggregation("label",A);var L=A;if(typeof L==="string"){if(!this._oLabel){this._oLabel=l.form.FormHelper.createLabel(L);this.setAggregation("_label",this._oLabel,true);this._oLabel.disableRequiredChangeCheck(true);if(this._oLabel.isRequired){this._oLabel.isRequired=c;}if(this._oLabel.isDisplayOnly){this._oLabel.isDisplayOnly=d;}}else{this._oLabel.setText(L);}}else{if(this._oLabel){this._oLabel.destroy();delete this._oLabel;}if(L&&L.isRequired){L._sapuiIsRequired=L.isRequired;L.isRequired=c;L.disableRequiredChangeCheck(true);}if(L&&L.isDisplayOnly){L._sapuiIsDisplayOnly=L.isDisplayOnly;L.isDisplayOnly=d;}}e.call(this);return this;};
F.prototype.destroyLabel=function(){this.destroyAggregation("label");if(this._oLabel){this._oLabel.destroy();delete this._oLabel;}return this;};
F.prototype.getLabelControl=function(){if(this._oLabel){return this._oLabel;}else{return this.getLabel();}};
F.prototype.updateFields=function(){var j=this.getFields();var o;var i=0;for(i=0;i<j.length;i++){o=j[i];g.call(this,o);}this.updateAggregation("fields");j=this.getFields();for(i=0;i<j.length;i++){o=j[i];f.call(this,o);}e.call(this);return this;};
F.prototype.enhanceAccessibilityState=function(o,A){var L=this.getLabelControl();if(L&&L!=o){var s=A["labelledby"];if(!s){s=L.getId();}else{var i=s.split(" ");if(q.inArray(L.getId(),i)<0){i.splice(0,0,L.getId());s=i.join(" ");}}A["labelledby"]=s;}return A;};
F.prototype.onLayoutDataChange=function(o){var p=this.getParent();if(p&&p.onLayoutDataChange){p.onLayoutDataChange(o);}};
F.prototype.getRenderedDomRef=function(){var t=this;var C=this.getParent();if(C&&C.getElementRenderedDomRef){return C.getElementRenderedDomRef(t);}else{return null;}};
F.prototype.invalidateLabel=function(){var L=this.getLabelControl();if(L){L.invalidate();}};
F.prototype.isVisible=function(){return this.getVisible();};
F.prototype._observeChanges=function(C){if(C.object==this){if(C.name=="fields"){_.call(this,C);}}else{b.call(this,C);}};
function _(C){if(C.child){a.call(this,C.child,C.mutation);}else if(C.children){for(var i=0;i<C.chlidren.length;i++){a.call(this,C.children[i],C.mutation);}}e.call(this);}
function a(o,m){if(m=="insert"){if(!o.getMetadata().isInstanceOf("sap.ui.core.IFormContent")){q.sap.log.warning(o+" is not valid Form content",this);}f.call(this,o);}else{g.call(this,o);}}
function b(C){if(C.name=="required"){this.invalidateLabel();}}
function c(){if(this.getRequired&&this.getRequired()){return true;}var o=this.getParent();var j=o.getFields();for(var i=0;i<j.length;i++){var k=j[i];if(k.getRequired&&k.getRequired()===true&&(!k.getEditable||k.getEditable())){return true;}}return false;}
function d(){if(this.getDisplayOnly){if(!this.isPropertyInitial("displayOnly")){return this.getDisplayOnly();}var o=this.getParent();var i=o.getParent();if(i){var j=i.getParent();if(j){return!j.getEditable();}}}return false;}
function e(){var i=this.getFields();var o=i.length>0?i[0]:null;var L=this._oLabel;if(L){L.setLabelFor(o);}else{L=this.getLabel();if(L instanceof sap.ui.core.Control){L.setAlternativeLabelFor(o);}}}
function f(o){o.addDelegate(this._oFieldDelegate);if(!this._bNoObserverChange&&o.getMetadata().getProperty("required")){this._oObserver.observe(o,{properties:["required"]});}}
function g(o){o.removeDelegate(this._oFieldDelegate);if(!this._bNoObserverChange){this._oObserver.unobserve(o);}}
function h(o){var p=this.oElement.getParent();if(p&&p.contentOnAfterRendering){p.contentOnAfterRendering(this.oElement,o.srcControl);}}
return F;});
sap.ui.predefine('sap/ui/layout/form/FormLayout',['jquery.sap.global','sap/ui/core/Control','./Form','sap/ui/layout/library'],function(q,C,F,l){"use strict";var B=l.BackgroundDesign;
var a=C.extend("sap.ui.layout.form.FormLayout",{metadata:{library:"sap.ui.layout",properties:{backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}}}});
a.prototype.contentOnAfterRendering=function(f,c){if(l.form.FormHelper.bArrowKeySupport){q(c.getFocusDomRef()).data("sap.InNavArea",true);}};
a.prototype.toggleContainerExpanded=function(c){var e=c.getExpanded();if(this.getDomRef()){if(e){c.$("content").css("display","");}else{c.$("content").css("display","none");}}};
a.prototype.getLayoutDataForElement=function(e,t){var L=e.getLayoutData();var c=q.sap.getObject(t);if(!L){return undefined;}else if(L instanceof c){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var b=L.getMultipleLayoutData();for(var i=0;i<b.length;i++){var o=b[i];if(o instanceof c){return o;}}}};
a.prototype.onsapright=function(e){if(l.form.FormHelper.bArrowKeySupport){var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this.navigateForward(e);}else{this.navigateBack(e);}}};
a.prototype.onsapleft=function(e){if(l.form.FormHelper.bArrowKeySupport){var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){this.navigateBack(e);}else{this.navigateForward(e);}}};
a.prototype.onsapdown=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){n=this.findFieldBelow(c,E);}else if(E&&E instanceof sap.ui.layout.form.FormContainer){n=this.findFirstFieldOfNextElement(E,0);}if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.onsapup=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){n=this.findFieldAbove(c,E);}else if(E&&E instanceof sap.ui.layout.form.FormContainer){var f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.onsaphome=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;var o=E.getParent();var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i);if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.onsaptop=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();n=this.findFirstFieldOfForm(f);if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.onsapend=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;var o=E.getParent();var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,i);if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.onsapbottom=function(e){if(l.form.FormHelper.bArrowKeySupport){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();var b=f.getFormContainers();var L=b.length;n=this.findLastFieldOfLastElementInPrevContainer(f,L-1);if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.onsapexpand=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var o;if(E instanceof sap.ui.layout.form.FormContainer){o=E;}else{o=E.getParent();}if(o.getExpandable()&&c===o._oExpandButton){o.setExpanded(true);}};
a.prototype.onsapcollapse=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;var o;if(E instanceof sap.ui.layout.form.FormContainer){o=E;}else{o=E.getParent();}if(o.getExpandable()&&c===o._oExpandButton){o.setExpanded(false);}};
a.prototype.onsapskipforward=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;c=r.rootControl;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();var i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);if(n){q.sap.focus(n);e.preventDefault();}};
a.prototype.onsapskipback=function(e){var c=e.srcControl;var r=this.findElement(c);var E=r.element;c=r.rootControl;var n;var o;if(E&&E instanceof sap.ui.layout.form.FormElement){o=E.getParent();}else if(E&&E instanceof sap.ui.layout.form.FormContainer){o=E;}var f=o.getParent();var b=f.getFormContainers();var i=f.indexOfFormContainer(o);while(!n&&i>0){var p=b[i-1];if(!p.getExpandable()||p.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(f,i-1);}i=i-1;}if(n){q.sap.focus(n);e.preventDefault();}};
a.prototype.onBeforeFastNavigationFocus=function(e){if(q.contains(this.getDomRef(),e.source)){e.srcControl=q(e.source).control(0);if(e.forward){this.onsapskipforward(e);}else{this.onsapskipback(e);}}else{var n=e.forward?this.findFirstFieldOfForm(this.getParent()):this.findFirstFieldOfLastContainerOfForm(this.getParent());if(n){q.sap.focus(n);e.preventDefault();}}};
a.prototype.findElement=function(c){var e=c.getParent();var r=c;while(e&&!(e instanceof sap.ui.layout.form.FormElement)&&!(e&&e instanceof sap.ui.layout.form.FormContainer)&&!(e&&e instanceof F)){r=e;e=e.getParent();}return({rootControl:r,element:e});};
a.prototype.navigateForward=function(e){var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=-1;}else{i=E.indexOfField(c);}n=this.findNextFieldOfElement(E,i+1);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findFirstFieldOfNextElement(o,i+1);if(!n){var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){n=this.findFirstFieldOfNextElement(E,0);}if(n){q.sap.focus(n);e.preventDefault();}};
a.prototype.tabForward=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=-1;}else{i=E.indexOfField(c);}n=this.findNextFieldOfElement(E,i+1,true);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findFirstFieldOfNextElement(o,i+1,true);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1,true);}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){n=this.findFirstFieldOfNextElement(E,0,true);if(!n){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1,true);}}if(n){q.sap.focus(n);e.preventDefault();}};
a.prototype.findNextFieldOfElement=function(e,s,t){var f=e.getFields();var L=f.length;var n;for(var i=s;i<L;i++){var o=f[i];var d=this._getDomRef(o);if(t==true){if((!o.getEditable||o.getEditable())&&(!o.getEnabled||o.getEnabled())&&d){n=d;break;}}else{if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}}return n;};
a.prototype.findFirstFieldOfNextElement=function(c,s,t){var e=c.getFormElements();var L=e.length;var n;var i=s;while(!n&&i<L){var E=e[i];if(t==true){n=this.findNextFieldOfElement(E,0,true);}else{n=this.findNextFieldOfElement(E,0);}i++;}return n;};
a.prototype.findFirstFieldOfForm=function(f){var c=f.getFormContainers();var n;var o=c[0];if(!o.getExpandable()||o.getExpanded()){n=this.findFirstFieldOfNextElement(o,0);}return n;};
a.prototype.findFirstFieldOfLastContainerOfForm=function(f){var n;var c=f.getFormContainers();var i=c.length;while(!n&&i>=0){var p=c[i-1];if(!p.getExpandable()||p.getExpanded()){n=this.findFirstFieldOfFirstElementInPrevContainer(f,i-1);}i=i-1;}return n;};
a.prototype.findFirstFieldOfFirstElementInNextContainer=function(f,s,t){var c=f.getFormContainers();var L=c.length;var n;var i=s;while(!n&&i<L){var o=c[i];if(o.getExpandable()&&t){n=o._oExpandButton.getFocusDomRef();if(n){break;}}if(!o.getExpandable()||o.getExpanded()){if(t==true){n=this.findFirstFieldOfNextElement(o,0,true);}else{n=this.findFirstFieldOfNextElement(o,0);}}i++;}return n;};
a.prototype.findFirstFieldOfFirstElementInPrevContainer=function(f,s){var c=f.getFormContainers();var L=c.length;var n;var i=s;while(!n&&i<L&&i>=0){var o=c[i];if(!o.getExpandable()||o.getExpanded()){n=this.findFirstFieldOfNextElement(o,0);}i++;}return n;};
a.prototype.navigateBack=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=0;}else{i=E.indexOfField(c);}n=this.findPrevFieldOfElement(E,i-1);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findLastFieldOfPrevElement(o,i-1);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1);}if(n){q.sap.focus(n);e.preventDefault();}};
a.prototype.tabBack=function(e){var f;var c=e.srcControl;var i=0;var n;var r=this.findElement(c);var E=r.element;c=r.rootControl;if(E&&E instanceof sap.ui.layout.form.FormElement){if(c==E.getLabelControl()){i=0;}else{i=E.indexOfField(c);}n=this.findPrevFieldOfElement(E,i-1,true);if(!n){var o=E.getParent();i=o.indexOfFormElement(E);n=this.findLastFieldOfPrevElement(o,i-1,true);if(!n){f=o.getParent();i=f.indexOfFormContainer(o);if(o.getExpandable()){n=o._oExpandButton.getFocusDomRef();}if(!n){n=this.findLastFieldOfLastElementInPrevContainer(f,i-1,true);}}}}else if(E&&E instanceof sap.ui.layout.form.FormContainer){f=E.getParent();i=f.indexOfFormContainer(E);n=this.findLastFieldOfLastElementInPrevContainer(f,i-1,true);}if(n){q.sap.focus(n);e.preventDefault();}};
a.prototype.findPrevFieldOfElement=function(e,s,t){var f=e.getFields();var n;for(var i=s;i>=0;i--){var o=f[i];var d=this._getDomRef(o);if(t==true){if((!o.getEditable||o.getEditable())&&(!o.getEnabled||o.getEnabled())&&d){n=d;break;}}else{if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}}return n;};
a.prototype.findLastFieldOfPrevElement=function(c,s,t){var e=c.getFormElements();var n;var i=s;while(!n&&i>=0){var E=e[i];var L=E.getFields().length;if(t==true){n=this.findPrevFieldOfElement(E,L-1,true);}else{n=this.findPrevFieldOfElement(E,L-1);}i--;}return n;};
a.prototype.findLastFieldOfLastElementInPrevContainer=function(f,s,t){var c=f.getFormContainers();var n;var i=s;while(!n&&i>=0){var o=c[i];if(o.getExpandable()&&!o.getExpanded()&&t){n=o._oExpandButton.getFocusDomRef();if(n){break;}}if(!o.getExpandable()||o.getExpanded()){var L=o.getFormElements().length;if(t==true){n=this.findLastFieldOfPrevElement(o,L-1,true);}else{n=this.findLastFieldOfPrevElement(o,L-1,0);}}i--;}return n;};
a.prototype.findFieldBelow=function(c,e){var o=e.getParent();var i=o.indexOfFormElement(e);var n=this.findFirstFieldOfNextElement(o,i+1);if(!n){var f=o.getParent();i=f.indexOfFormContainer(o);n=this.findFirstFieldOfFirstElementInNextContainer(f,i+1);}return n;};
a.prototype.findFieldAbove=function(c,e){var o=e.getParent();var b=o.indexOfFormElement(e);var E=o.getFormElements();var n;var i=b-1;while(!n&&i>=0){var m=E[i];n=this.findPrevFieldOfElement(m,0);i--;}if(!n){var f=o.getParent();b=f.indexOfFormContainer(o);n=this.findLastFieldOfLastElementInPrevContainer(f,b-1);}return n;};
a.prototype._getDomRef=function(c){var d=c.getFocusDomRef();if(!q(d).is(":sapFocusable")){d=undefined;}return d;};
a.prototype.getContainerRenderedDomRef=function(c){if(this.getDomRef()){return q.sap.domById(c.getId());}else{return null;}};
a.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){return q.sap.domById(e.getId());}else{return null;}};
return a;});
sap.ui.predefine('sap/ui/layout/form/FormLayoutRenderer',["sap/ui/layout/library","sap/ui/core/library"],function(l,c){"use strict";var T=c.TitleLevel;var B=l.BackgroundDesign;var F={};
F.render=function(r,L){var a=r;var f=L.getParent();if(f&&f instanceof sap.ui.layout.form.Form){this.renderForm(a,L,f);}};
F.renderForm=function(r,L,f){var t=f.getToolbar();r.write("<div");r.writeControlData(L);r.addClass(this.getMainClass());if(t){r.addClass("sapUiFormToolbar");}this.addBackgroundClass(r,L);r.writeClasses();r.write(">");if(t){r.renderControl(t);}else{var s=sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize');this.renderTitle(r,f.getTitle(),undefined,false,s,f.getId());}this.renderContainers(r,L,f);r.write("</div>");};
F.getMainClass=function(){return"sapUiFormLayout";};
F.addBackgroundClass=function(r,L){var b=L.getBackgroundDesign();if(b!=B.Transparent){r.addClass("sapUiFormBackgr"+b);}};
F.renderContainers=function(r,L,f){var C=f.getFormContainers();for(var i=0,a=C.length;i<a;i++){var o=C[i];if(o.isVisible()){this.renderContainer(r,L,o);}}};
F.renderContainer=function(r,L,C){var e=C.getExpandable();var t=C.getToolbar();var o=C.getTitle();r.write("<section");r.writeElementData(C);r.addClass("sapUiFormContainer");if(t){r.addClass("sapUiFormContainerToolbar");}else if(o){r.addClass("sapUiFormContainerTitle");}if(C.getTooltip_AsString()){r.writeAttributeEscaped('title',C.getTooltip_AsString());}r.writeClasses();this.writeAccessibilityStateContainer(r,C);r.write(">");if(t){r.renderControl(t);}else{this.renderTitle(r,o,C._oExpandButton,e,T.H4,C.getId());}if(e){r.write("<div id='"+C.getId()+"-content'");if(!C.getExpanded()){r.addStyle("display","none");r.writeStyles();}r.write(">");}var E=C.getFormElements();for(var j=0,a=E.length;j<a;j++){var b=E[j];if(b.isVisible()){this.renderElement(r,L,b);}}if(e){r.write("</div>");}r.write("</section>");};
F.renderElement=function(r,L,e){var o=e.getLabelControl();r.write("<div");r.writeElementData(e);r.addClass("sapUiFormElement");if(o){r.addClass("sapUiFormElementLbl");}r.writeClasses();r.write(">");if(o){r.renderControl(o);}var f=e.getFields();if(f&&f.length>0){for(var k=0,a=f.length;k<a;k++){var b=f[k];r.renderControl(b);}}r.write("</div>");};
F.renderTitle=function(r,t,e,E,L,C){if(t){var s=sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormSubTitleSize');if(L){s=L;}if(typeof t!=="string"&&t.getLevel()!=T.Auto){s=t.getLevel();}r.write("<"+s+" ");r.addClass("sapUiFormTitle");r.addClass("sapUiFormTitle"+s);if(typeof t!=="string"){r.writeElementData(t);if(t.getTooltip_AsString()){r.writeAttributeEscaped('title',t.getTooltip_AsString());}if(t.getEmphasized()){r.addClass("sapUiFormTitleEmph");}}else{r.writeAttribute("id",C+"--title");}r.writeClasses();r.write(">");if(E&&e){r.renderControl(e);}if(typeof t==="string"){r.writeEscaped(t,true);}else{var i=t.getIcon();if(i){var a=[];var A={"title":null};A["id"]=t.getId()+"-ico";r.writeIcon(i,a,A);}r.writeEscaped(t.getText(),true);}r.write("</"+s+">");}};
F.writeAccessibilityStateContainer=function(r,C){var a={};var t=C.getTitle();var o=C.getToolbar();if(o){if(!C.getAriaLabelledBy()||C.getAriaLabelledBy().length==0){a["labelledby"]={value:o.getId(),append:true};}}else if(t){var i="";if(typeof t=="string"){i=C.getId()+"--title";}else{i=t.getId();}a["labelledby"]={value:i,append:true};}if(a["labelledby"]||C.getAriaLabelledBy().length>0){a["role"]="form";}r.writeAccessibilityState(C,a);};
return F;},true);
sap.ui.predefine('sap/ui/layout/form/FormRenderer',['jquery.sap.global','sap/ui/layout/library'],function(q,l){"use strict";var F={};
F.render=function(r,f){var a=r;var L=f.getLayout();a.write("<div");a.writeControlData(f);a.addClass("sapUiForm");a.addClass("sapUiFormLblColon");a.writeAttribute("data-sap-ui-customfastnavgroup","true");var c=l.form.FormHelper.addFormClass();if(c){a.addClass(c);}if(f.getEditable()){a.addClass("sapUiFormEdit");a.addClass("sapUiFormEdit-CTX");}if(f.getWidth()){a.addStyle("width",f.getWidth());}if(f.getTooltip_AsString()){a.writeAttributeEscaped('title',f.getTooltip_AsString());}a.writeClasses();a.writeStyles();var A={role:"form"};var t=f.getTitle();var T=f.getToolbar();if(T){if(!f.getAriaLabelledBy()||f.getAriaLabelledBy().length==0){A["labelledby"]=T.getId();}}else if(t){var i="";if(typeof t=="string"){i=f.getId()+"--title";}else{i=t.getId();}A["labelledby"]={value:i,append:true};}a.writeAccessibilityState(f,A);a.write(">");if(L){a.renderControl(L);}else{q.sap.log.warning("Form \""+f.getId()+"\" - Layout missing!","Renderer","Form");}a.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/layout/form/GridContainerData',['sap/ui/core/LayoutData','sap/ui/layout/library'],function(L,l){"use strict";
var G=L.extend("sap.ui.layout.form.GridContainerData",{metadata:{library:"sap.ui.layout",properties:{halfGrid:{type:"boolean",group:"Misc",defaultValue:false}}}});
return G;});
sap.ui.predefine('sap/ui/layout/form/GridElementData',['sap/ui/core/LayoutData','sap/ui/layout/library'],function(L,l){"use strict";
var G=L.extend("sap.ui.layout.form.GridElementData",{metadata:{library:"sap.ui.layout",properties:{hCells:{type:"sap.ui.layout.form.GridElementCells",group:"Appearance",defaultValue:'auto'},vCells:{type:"int",group:"Appearance",defaultValue:1}}}});
return G;});
sap.ui.predefine('sap/ui/layout/form/GridLayout',['jquery.sap.global','./FormLayout','./GridContainerData','./GridElementData','sap/ui/layout/library'],function(q,F,G,a,l){"use strict";
var b=F.extend("sap.ui.layout.form.GridLayout",{metadata:{library:"sap.ui.layout",properties:{singleColumn:{type:"boolean",group:"Misc",defaultValue:false}}}});
b.prototype.toggleContainerExpanded=function(c){this.invalidate();};
b.prototype.onAfterRendering=function(){var f=this.getParent();if(f){var c=f.getFormContainers();for(var i=0;i<c.length;i++){var C=c[i];if(C.getExpandable()&&C._oExpandButton){C._oExpandButton.$().attr("tabindex","-1");}}}};
b.prototype.contentOnAfterRendering=function(f,c){F.prototype.contentOnAfterRendering.apply(this,arguments);if(!c.getFormDoNotAdjustWidth||!c.getFormDoNotAdjustWidth()){c.$().css("width","100%");}};
b.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};
b.prototype.onsaptabnext=function(e){this.tabForward(e);};
b.prototype.onsaptabprevious=function(e){this.tabBack(e);};
b.prototype.findFieldOfElement=function(e,s,L){if(!L){return F.prototype.findPrevFieldOfElement.apply(this,arguments);}if(!e.isVisible()){return null;}var f=e.getFields();var n;var I=f.length;s=I-1;for(var i=s;i>=0;i--){var o=f[i];var c=o.$().offset().left;if(L<c&&i!=0){continue;}var d=this._getDomRef(o);if((!o.getEnabled||o.getEnabled())&&d){n=d;break;}}return n;};
b.prototype.findFieldBelow=function(c,e){var C=e.getParent();var d=C.indexOfFormElement(e);var n;if(C.isVisible()){var E=C.getFormElements();var m=E.length;var i=d+1;var L=c.$().offset().left;while(!n&&i<m){var N=E[i];n=this.findFieldOfElement(N,0,L);i++;}}if(!n){var f=C.getParent();d=f.indexOfFormContainer(C);n=this.findFirstFieldOfFirstElementInNextContainer(f,d+1);}return n;};
b.prototype.findFieldAbove=function(c,e){var C=e.getParent();var d=C.indexOfFormElement(e);var n;if(C.isVisible()){var E=C.getFormElements();var i=d-1;var L=c.$().offset().left;while(!n&&i>=0){var N=E[i];n=this.findFieldOfElement(N,0,L);i--;}}if(!n){var f=C.getParent();d=f.indexOfFormContainer(C);n=this.findLastFieldOfLastElementInPrevContainer(f,d-1);}return n;};
b.prototype.getContainerRenderedDomRef=function(c){return null;};
b.prototype.getElementRenderedDomRef=function(e){if(this.getDomRef()){var s=this.getSingleColumn();var c=e.getParent();var C=this.getLayoutDataForElement(c,"sap.ui.layout.form.GridContainerData");if((s||!C||!C.getHalfGrid())&&!this.getRenderer().checkFullSizeElement(this,e)){return q.sap.domById(e.getId());}}return null;};
return b;});
sap.ui.predefine('sap/ui/layout/form/GridLayoutRenderer',['jquery.sap.global','sap/ui/core/Renderer','./FormLayoutRenderer'],function(q,R,F){"use strict";var G=R.extend(F);
G.renderForm=function(r,l,f){var s=l.getSingleColumn();var c=16;var S=false;var C=0;var a=f.getFormContainers();var b=a.length;var i=0;var o;var d;var t=f.getToolbar();var T=f.getTitle();if(s){c=c/2;C=c;}else{C=c/2;for(i=0;i<b;i++){d=this.getContainerData(l,a[i]);if(d&&d.getHalfGrid()){S=true;break;}}}r.write("<table role=\"presentation\"");r.writeControlData(l);r.write(" cellpadding=\"0\" cellspacing=\"0\"");r.addStyle("border-collapse","collapse");r.addStyle("table-layout","fixed");r.addStyle("width","100%");r.addClass("sapUiGrid");this.addBackgroundClass(r,l);if(t){r.addClass("sapUiFormToolbar");}r.writeStyles();r.writeClasses();r.write(">");r.write("<colgroup>");r.write("<col span="+C+">");if(S){r.write("<col class = \"sapUiGridSpace\"span=1>");}if(!s){r.write("<col span="+C+">");}r.write("</colgroup><tbody>");if(t||T){var e=c;if(S){e++;}r.write("<tr class=\"sapUiGridTitle\"><th colspan="+e+">");if(t){r.renderControl(t);}else{var g=sap.ui.core.theming.Parameters.get('sap.ui.layout.FormLayout:_sap_ui_layout_FormLayout_FormTitleSize');this.renderTitle(r,T,undefined,false,g,f.getId());}r.write("</th></tr>");}i=0;var h;var j;while(i<b){o=a[i];o._checkProperties();if(o.isVisible()){d=this.getContainerData(l,o);if(d&&d.getHalfGrid()&&!s){h=a[i+1];j=undefined;if(h&&h.isVisible()){j=this.getContainerData(l,h);}if(j&&j.getHalfGrid()){h._checkProperties();this.renderContainerHalfSize(r,l,o,h,c);i++;}else{this.renderContainerHalfSize(r,l,o,undefined,c);}}else{this.renderContainerFullSize(r,l,o,c,S);}}i++;}r.write("</tbody></table>");};
G.renderContainerFullSize=function(r,l,c,C,s){var e=c.getExpandable();var t=c.getTooltip_AsString();var T=c.getToolbar();var o=c.getTitle();if(T||o){var a=C;if(s){a++;}r.write("<tr class=\"sapUiGridConteinerFirstRow sapUiGridConteinerHeaderRow\"><td colspan="+a);r.addClass("sapUiGridHeader");if(t){r.writeAttributeEscaped('title',t);}if(T){r.addClass("sapUiFormContainerToolbar");}else if(o){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(T){r.renderControl(T);}else{this.renderTitle(r,c.getTitle(),c._oExpandButton,e,false,c.getId());}r.write("</td></tr>");}if(!e||c.getExpanded()){var E=c.getFormElements();var b;var d=[];var f;var g=false;for(var j=0,h=E.length;j<h;j++){b=E[j];if(b.isVisible()){f=d[0]&&(d[0][0]==C);r.write("<tr");if(!g){g=true;if(!T&&!o){r.addClass("sapUiGridConteinerFirstRow");}}if(!this.checkFullSizeElement(l,b)&&d[0]!="full"&&!f){r.writeElementData(b);r.addClass("sapUiFormElement");}r.writeClasses();r.write(">");if(!f){d=this.renderElement(r,l,b,false,C,s,d);}else{d.splice(0,1);}r.write("</tr>");if(d[0]=="full"||f){j=j-1;}}}if(d.length>0){for(var i=0;i<d.length;i++){r.write("<tr></tr>");}}}};
G.renderContainerHalfSize=function(r,l,c,C,a){var b=a/2;var e=c.getExpandable();var t=c.getTooltip_AsString();var T;var o=c.getTitle();var d;var f=c.getToolbar();var g;var E=[];if(!e||c.getExpanded()){E=c.getFormElements();}var L=E.length;var h=[];var j=0;var k=false;if(C){k=C.getExpandable();T=C.getTooltip_AsString();d=C.getTitle();g=C.getToolbar();if(!k||C.getExpanded()){h=C.getFormElements();}j=h.length;}if(o||d||f||g){r.write("<tr class=\"sapUiGridConteinerFirstRow sapUiGridConteinerHeaderRow\"><td colspan="+b);r.addClass("sapUiGridHeader");if(t){r.writeAttributeEscaped('title',t);}if(f){r.addClass("sapUiFormContainerToolbar");}else if(o){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(f){r.renderControl(f);}else if(o){this.renderTitle(r,o,c._oExpandButton,e,false,c.getId());}r.write("</td><td></td><td colspan="+b);r.addClass("sapUiGridHeader");if(T){r.writeAttributeEscaped('title',T);}if(g){r.addClass("sapUiFormContainerToolbar");}else if(d){r.addClass("sapUiFormContainerTitle");}r.writeClasses();r.write(">");if(g){r.renderControl(g);}else if(d){this.renderTitle(r,d,C._oExpandButton,k,false,C.getId());}r.write("</td></tr>");}if((!e||c.getExpanded())||(!k||C.getExpanded())){var m=[],n=[];var p=0,s=0;var u;var v;var w;var x;var y=false;while(p<L||s<j){u=E[p];v=h[s];w=m[0]&&(m[0][0]==b);x=n[0]&&(n[0][0]==b);if((u&&u.isVisible())||(v&&v.isVisible())||w||x){r.write("<tr");if(!y){y=true;if(!f&&!o&&!g&&!d){r.addClass("sapUiGridConteinerFirstRow");}}r.writeClasses();r.write(">");if(!w){if(u&&u.isVisible()&&(!e||c.getExpanded())){m=this.renderElement(r,l,u,true,b,false,m);}else{r.write("<td colspan="+b+"></td>");}if(m[0]!="full"){p++;}}else{if(m[0][2]>0){r.write("<td colspan="+m[0][2]+"></td>");}m.splice(0,1);}r.write("<td></td>");if(!x){if(v&&v.isVisible()&&(!k||C.getExpanded())){n=this.renderElement(r,l,v,true,b,false,n);}else{r.write("<td colspan="+b+"></td>");}if(n[0]!="full"){s++;}}else{if(n[0][2]>0){r.write("<td colspan="+n[0][2]+"></td>");}n.splice(0,1);}r.write("</tr>");}else{p++;s++;}}if(m.length>0||n.length>0){for(var i=0;i<m.length||i<n.length;i++){r.write("<tr></tr>");}}}};
G.renderElement=function(r,l,e,h,c,s,a){var L=e.getLabelControl();var b=0;var f=e.getFields();var C=0;var A=0;var m=false;var d=1;var g=1;var x=0;if(this.checkFullSizeElement(l,e)){if(a.length>0&&a[0]!="full"){q.sap.log.error("Element \""+e.getId()+"\" - Too much fields for one row!","Renderer","GridLayout");return a;}if(s){c=c+1;}if(L&&a[0]!="full"){r.write("<td colspan="+c+" class=\"sapUiFormElementLbl sapUiGridLabelFull\">");r.renderControl(L);r.write("</td>");return["full"];}else{a.splice(0,1);g=this.getElementData(l,f[0]).getVCells();r.write("<td colspan="+c);if(g>1&&h){r.write(" rowspan="+g);for(x=0;x<g-1;x++){a.push([c,undefined,false]);}}r.write(" >");r.renderControl(f[0]);r.write("</td>");return a;}}if(a.length>0&&a[0][0]>0){c=c-a[0][0]+a[0][2];m=a[0][1];b=a[0][2];a.splice(0,1);}var j=b;var E;var k="";if(L||b>0){j=3;if(L&&b==0){E=this.getElementData(l,L);if(E){k=E.getHCells();if(k!="auto"&&k!="full"){j=parseInt(k,10);}}}r.write("<td colspan="+j+" class=\"sapUiFormElementLbl\">");if(L){r.renderControl(L);}c=c-j;r.write("</td>");}if(f&&f.length>0){var n=c;var o=f.length;var p;var i=0;var t=0;for(i=0,t=f.length;i<t;i++){p=f[i];E=this.getElementData(l,p);if(E&&E.getHCells()!="auto"){n=n-parseInt(E.getHCells(),10);o=o-1;}}var u=0;for(i=0,u=0,t=f.length;i<t;i++){p=f[i];E=this.getElementData(l,p);k="auto";d=1;g=1;if(E){k=E.getHCells();g=E.getVCells();}if(k=="auto"){if(n>0){d=Math.floor(n/o);if(d<1){d=1;}u++;A=A+d;if((u==o)&&(n>A)){d=d+(n-A);}}else{d=1;}}else{d=parseInt(k,10);}C=C+d;if(C>c){q.sap.log.error("Element \""+e.getId()+"\" - Too much fields for one row!","Renderer","GridLayout");C=C-d;break;}if(g>1){for(x=0;x<g-1;x++){if(L){b=j;}if(a.length>x){a[x][0]=a[x][0]+d;a[x][2]=b;}else{a.push([j+d,undefined,b]);}}}if(s&&C>=Math.floor(c/2)&&!m){d=d+1;m=true;if(g>1){for(x=0;x<g-1;x++){a[x][1]=true;}}}r.write("<td");if(d>1){r.write(" colspan="+d);}if(g>1){r.write(" rowspan="+g);}r.write(" >");r.renderControl(p);r.write("</td>");}}if(C<c){var v=c-C;if(!h&&s&&!m){v++;}r.write("<td colspan="+v+" ></td>");}return a;};
G.checkFullSizeElement=function(l,e){var f=e.getFields();if(f.length==1&&this.getElementData(l,f[0])&&this.getElementData(l,f[0]).getHCells()=="full"){return true;}else{return false;}};
G.getContainerData=function(l,c){return l.getLayoutDataForElement(c,"sap.ui.layout.form.GridContainerData");};
G.getElementData=function(l,c){return l.getLayoutDataForElement(c,"sap.ui.layout.form.GridElementData");};
return G;},true);
sap.ui.predefine('sap/ui/layout/form/ResponsiveGridLayout',['jquery.sap.global','sap/ui/layout/Grid','sap/ui/layout/GridData','./FormLayout','sap/ui/layout/library','sap/ui/core/Control','sap/ui/core/ResizeHandler'],function(q,G,a,F,l,C,R){"use strict";
var b=F.extend("sap.ui.layout.form.ResponsiveGridLayout",{metadata:{library:"sap.ui.layout",properties:{labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600}}}});
var P=C.extend("sap.ui.layout.form.ResponsiveGridLayoutPanel",{
metadata:{aggregations:{"content":{type:"sap.ui.layout.Grid",multiple:false}},associations:{"container":{type:"sap.ui.layout.form.FormContainer",multiple:false},"layout":{type:"sap.ui.layout.form.ResponsiveLayout",multiple:false}}},
getLayoutData:function(){var o=sap.ui.getCore().byId(this.getContainer());var L=sap.ui.getCore().byId(this.getLayout());var i;if(L&&o){i=L.getLayoutDataForElement(o,"sap.ui.layout.GridData");}if(i){return i;}else{return this.getAggregation("layoutData");}},
getCustomData:function(){var o=sap.ui.getCore().byId(this.getContainer());if(o){return o.getCustomData();}},
refreshExpanded:function(){var o=sap.ui.getCore().byId(this.getContainer());if(o){if(o.getExpanded()){this.$().removeClass("sapUiRGLContainerColl");}else{this.$().addClass("sapUiRGLContainerColl");}}},
renderer:function(r,p){var o=sap.ui.getCore().byId(p.getContainer());var L=sap.ui.getCore().byId(p.getLayout());var i=p.getContent();var E=o.getExpandable();var t=o.getTooltip_AsString();var T=o.getToolbar();var j=o.getTitle();r.write("<div");r.writeControlData(p);r.addClass("sapUiRGLContainer");if(E&&!o.getExpanded()){r.addClass("sapUiRGLContainerColl");}if(T){r.addClass("sapUiFormContainerToolbar");}else if(j){r.addClass("sapUiFormContainerTitle");}if(t){r.writeAttributeEscaped('title',t);}r.writeClasses();L.getRenderer().writeAccessibilityStateContainer(r,o);r.write(">");if(T){r.renderControl(T);}else if(o.getTitle()){L.getRenderer().renderTitle(r,j,o._oExpandButton,E,false,o.getId());}if(i){r.write("<div");r.addClass("sapUiRGLContainerCont");r.writeClasses();r.write(">");r.renderControl(i);r.write("</div>");}r.write("</div>");}
});
b.prototype.init=function(){this.mContainers={};this.oDummyLayoutData=new a(this.getId()+"--Dummy");};
b.prototype.exit=function(){for(var s in this.mContainers){k.call(this,s);}if(this._mainGrid){this._mainGrid.destroy();delete this._mainGrid;}this.oDummyLayoutData.destroy();this.oDummyLayoutData=undefined;};
b.prototype.onBeforeRendering=function(E){var o=this.getParent();if(!o||!(o instanceof sap.ui.layout.form.Form)){return;}o._bNoInvalidate=true;_.call(this,o);m.call(this,o);o._bNoInvalidate=false;};
b.prototype.onAfterRendering=function(E){if(this._mainGrid&&this._mainGrid.__bIsUsed){for(var s in this.mContainers){if(this.mContainers[s][1]._sContainerResizeListener){R.deregister(this.mContainers[s][1]._sContainerResizeListener);this.mContainers[s][1]._sContainerResizeListener=null;}}}};
b.prototype.contentOnAfterRendering=function(o,i){F.prototype.contentOnAfterRendering.apply(this,arguments);if(i.getWidth&&(!i.getWidth()||i.getWidth()=="auto")&&(!i.getFormDoNotAdjustWidth||!i.getFormDoNotAdjustWidth())){i.$().css("width","100%");}};
b.prototype.toggleContainerExpanded=function(o){var s=o.getId();if(this.mContainers[s]&&this.mContainers[s][0]){var p=this.mContainers[s][0];p.refreshExpanded();}};
b.prototype.onLayoutDataChange=function(E){var s=E.srcControl;if(s instanceof sap.ui.layout.form.FormContainer){if(this._mainGrid){this._mainGrid.onLayoutDataChange(E);this.invalidate();}}else if(!(s instanceof sap.ui.layout.form.FormElement)){var p=s.getParent();if(p instanceof sap.ui.layout.form.FormElement){var o=p.getParent();var i=o.getId();if(this.mContainers[i]&&this.mContainers[i][1]){this.mContainers[i][1].onLayoutDataChange(E);}}}};
b.prototype.onsapup=function(E){this.onsapleft(E);};
b.prototype.onsapdown=function(E){this.onsapright(E);};
b.prototype.getContainerRenderedDomRef=function(o){if(this.getDomRef()){var s=o.getId();if(this.mContainers[s]){if(this.mContainers[s][0]){var p=this.mContainers[s][0];return p.getDomRef();}else if(this.mContainers[s][1]){var i=this.mContainers[s][1];return i.getDomRef();}}}return null;};
b.prototype.getElementRenderedDomRef=function(E){return null;};
function _(o){var j=o.getFormContainers();var L=j.length;var v=0;var V=0;var n=[];var p;var r;var s;var t;var i=0;for(i=0;i<L;i++){s=j[i];s._checkProperties();if(s.isVisible()){v++;n.push(s);}}for(i=0;i<v;i++){s=n[i];if(s.isVisible()){V++;t=s.getId();p=undefined;r=undefined;var u=n[i+1];if(this.mContainers[t]&&this.mContainers[t][1]){r=this.mContainers[t][1];}else{r=e.call(this,s);}var T=s.getTitle();var w=s.getToolbar();if(w||T||s.getExpandable()){if(this.mContainers[t]&&this.mContainers[t][0]){p=this.mContainers[t][0];}else{p=c.call(this,s,r);g(r,true);}h(p,s,V,u,v);}else{if(this.mContainers[t]&&this.mContainers[t][0]){d(this.mContainers[t][0]);}g(r,false);h(r,s,V,u,v);}this.mContainers[t]=[p,r];}}var O=Object.keys(this.mContainers).length;if(v<O){for(t in this.mContainers){var x=false;for(i=0;i<L;i++){s=j[i];if(t==s.getId()&&s.isVisible()){x=true;break;}}if(!x){k.call(this,t);}}}}
function c(o,i){var s=o.getId();var p=new P(s+"---Panel",{container:o,layout:this,content:i});return p;}
function d(p){p.setContent("");p.setLayout("");p.setContainer("");p.destroy();}
function e(o){var I=o.getId()+"--Grid";var n=new G(I,{vSpacing:0,hSpacing:0,containerQuery:true});n.__myParentLayout=this;n.__myParentContainerId=o.getId();n.addStyleClass("sapUiFormResGridCont");n.getContent=function(){var o=sap.ui.getCore().byId(this.__myParentContainerId);if(o){var r=[];var E=o.getFormElements();var s;var t;for(var i=0;i<E.length;i++){var u=E[i];if(u.isVisible()){t=u.getLabelControl();if(t){r.push(t);}s=u.getFields();for(var j=0;j<s.length;j++){r.push(s[j]);}}}return r;}else{return false;}};n.getAriaLabelledBy=function(){var o=sap.ui.getCore().byId(this.__myParentContainerId);if(o&&!o.getToolbar()&&!o.getTitle()&&!o.getExpandable()){return o.getAriaLabelledBy();}return[];};var B={labelSpan:0,span:0,firstField:false,defaultFields:0,row:0,myRow:false,freeFields:0,finished:false};var x={id:"XL",getEffectiveSpan:function(i){var s=i._getEffectiveSpanXLarge();if(!s){s=i._getEffectiveSpanLarge();}return s;},getEmptySpan:function(i){var E=i.getEmptySpanXL();if(E<0){E=i.getEmptySpanL();}return E;},getLabelSpan:function(i){return i.getLabelSpanXL();},setIndent:function(i,j){i.setIndentXL(j);},setLinebreak:function(i,j){i.setLinebreakXL(j);}};q.extend(x,B);var L={id:"L",getEffectiveSpan:function(i){return i._getEffectiveSpanLarge();},getEmptySpan:function(i){return i.getEmptySpanL();},getLabelSpan:function(i){return i.getLabelSpanL();},setIndent:function(i,j){i.setIndentL(j);},setLinebreak:function(i,j){i.setLinebreakL(j);}};q.extend(L,B);var M={id:"M",getEffectiveSpan:function(i){return i._getEffectiveSpanMedium();},getEmptySpan:function(i){return i.getEmptySpanM();},getLabelSpan:function(i){return i.getLabelSpanM();},setIndent:function(i,j){i.setIndentM(j);},setLinebreak:function(i,j){i.setLinebreakM(j);}};q.extend(M,B);var S={id:"S",getEffectiveSpan:function(i){return i._getEffectiveSpanSmall();},getEmptySpan:function(i){return i.getEmptySpanS();},getLabelSpan:function(i){return i.getLabelSpanS();},setIndent:function(i,j){i.setIndentS(j);},setLinebreak:function(i,j){i.setLinebreakS(j);}};q.extend(S,B);var p=[x,L,M,S];n._getLayoutDataForControl=function(j){var r=this.__myParentLayout;var t=r.getLayoutDataForElement(j,"sap.ui.layout.GridData");var E=j.getParent();var u=E.getLabelControl();if(t){if(u==j){t._setStylesInternal("sapUiFormElementLbl");}return t;}else{var o=sap.ui.getCore().byId(this.__myParentContainerId);var v=r.getLayoutDataForElement(o,"sap.ui.layout.GridData");var w=o.getParent();var y;var s=0;for(s=0;s<p.length;s++){y=p[s];q.extend(y,B);y.labelSpan=y.getLabelSpan(r);}if(r.getAdjustLabelSpan()){if(w.getFormContainers().length>=1&&r.getColumnsM()>1){M.labelSpan=r.getLabelSpanL();}if(v){if(v._getEffectiveSpanLarge()==12){L.labelSpan=r.getLabelSpanM();M.labelSpan=r.getLabelSpanM();}}if(w.getFormContainers().length==1||r.getColumnsL()==1){L.labelSpan=r.getLabelSpanM();M.labelSpan=r.getLabelSpanM();}}if(x.labelSpan<0){x.labelSpan=L.labelSpan;}if(u==j){r.oDummyLayoutData.setSpan("XL"+x.labelSpan+" L"+L.labelSpan+" M"+M.labelSpan+" S"+S.labelSpan);r.oDummyLayoutData.setLinebreak(true);r.oDummyLayoutData.setIndentXL(0).setIndentL(0).setIndentM(0).setIndentS(0);r.oDummyLayoutData._setStylesInternal("sapUiFormElementLbl");return r.oDummyLayoutData;}else{var z;if(u){z=r.getLayoutDataForElement(u,"sap.ui.layout.GridData");}var A=E.getFields();var D=A.length;var H;var J;var K=1;var N=false;var O;var i=0;for(s=0;s<p.length;s++){y=p[s];y.span=12-y.getEmptySpan(r);if(u){if(z){O=y.getEffectiveSpan(z);if(O){y.labelSpan=O;}}if(y.labelSpan<12){y.span=y.span-y.labelSpan;}}y.spanFields=y.span;}for(i=0;i<D;i++){H=A[i];if(H!=j){J=r.getLayoutDataForElement(H,"sap.ui.layout.GridData");if(J){for(s=0;s<p.length;s++){y=p[s];O=y.getEffectiveSpan(J);if(O&&O<y.span){y.span=y.span-O;}}}else{K++;}}else{if(K==1){N=true;}}}var Q=[];for(s=0;s<p.length;s++){y=p[s];y.firstField=N;y.defaultFields=K;if(y.span<K){y.defaultFields=0;y.row=0;y.myRow=false;y.freeFields=y.spanFields;y.span=y.spanFields;y.finished=false;Q.push(y);}}if(Q.length>0){for(i=0;i<D;i++){H=A[i];J=undefined;if(H!=j){J=r.getLayoutDataForElement(H,"sap.ui.layout.GridData");}for(s=0;s<Q.length;s++){y=Q[s];if(y.finished){continue;}if(J){O=y.getEffectiveSpan(J);y.span=y.span-O;}else{O=1;}if(y.freeFields>=O){y.freeFields=y.freeFields-O;if(!J){y.defaultFields++;}}else{if(y.myRow){y.finished=true;}else{y.freeFields=y.spanFields-O;y.row++;if(J){y.defaultFields=0;y.span=y.spanFields-O;}else{y.defaultFields=1;y.span=y.spanFields;}if(H==j){y.firstField=true;}}}if(H==j){y.myRow=true;}}}}var T=0;var U="";var V;for(s=0;s<p.length;s++){y=p[s];if(y.id!="S"||y.labelSpan<12){if(y.firstField){T=y.span-Math.floor(y.span/y.defaultFields)*y.defaultFields;V=Math.floor(y.span/y.defaultFields)+T;}else{V=Math.floor(y.span/y.defaultFields);}}else{V=12;}if(U){U=U+" ";}U=U+y.id+V;y.setLinebreak(r.oDummyLayoutData,y.firstField&&(y.row>0));y.setIndent(r.oDummyLayoutData,y.firstField&&(y.row>0)?y.labelSpan:0);}r.oDummyLayoutData.setSpan(U);r.oDummyLayoutData.setLinebreak(N&&!u);r.oDummyLayoutData._setStylesInternal(undefined);return r.oDummyLayoutData;}return t;}};n._onParentResizeOrig=n._onParentResize;n._onParentResize=function(){if(!this.getDomRef()){this._cleanup();return;}if(!q(this.getDomRef()).is(":visible")){return;}var j=this.__myParentLayout;if(!j._mainGrid||!j._mainGrid.__bIsUsed){var r=j.getParent().getFormContainers();var s;for(var i=0;i<r.length;i++){if(r[i].isVisible()){s=r[i];break;}}if(!s||!j.mContainers[s.getId()]||s.getId()!=this.__myParentContainerId){return;}if(j.mContainers[this.__myParentContainerId][0]){var D=j.mContainers[this.__myParentContainerId][0].getDomRef();var t=D.clientWidth;if(t<=j.getBreakpointM()){this._toggleClass("Phone");}else if((t>j.getBreakpointM())&&(t<=j.getBreakpointL())){this._toggleClass("Tablet");}else if((t>j.getBreakpointL())&&(t<=j.getBreakpointXL())){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}}else{this._setBreakPointTablet(j.getBreakpointM());this._setBreakPointDesktop(j.getBreakpointL());this._setBreakPointLargeDesktop(j.getBreakpointXL());this._onParentResizeOrig();}}else{var $=j._mainGrid.$();if($.hasClass("sapUiRespGridMedia-Std-Phone")){this._toggleClass("Phone");}else if($.hasClass("sapUiRespGridMedia-Std-Tablet")){this._toggleClass("Tablet");}else if($.hasClass("sapUiRespGridMedia-Std-Desktop")){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}}};n._getAccessibleRole=function(){var o=sap.ui.getCore().byId(this.__myParentContainerId);var i=this.__myParentLayout;if(i._mainGrid&&i._mainGrid.__bIsUsed&&!o.getToolbar()&&!o.getTitle()&&!o.getExpandable()&&o.getAriaLabelledBy().length>0){return"form";}};n.getUIArea=function(){var i=this.__myParentLayout;if(i){return i.getUIArea();}else{return null;}};return n;}
function f(o){if(o.__myParentContainerId){o.__myParentContainerId=undefined;}o.__myParentLayout=undefined;o.destroy();}
function g(o,O){if(O){if(o.__originalGetLayoutData){o.getLayoutData=o.__originalGetLayoutData;delete o.__originalGetLayoutData;}}else if(!o.__originalGetLayoutData){o.__originalGetLayoutData=o.getLayoutData;o.getLayoutData=function(){var L=this.__myParentLayout;var i=sap.ui.getCore().byId(this.__myParentContainerId);var j;if(i){j=L.getLayoutDataForElement(i,"sap.ui.layout.GridData");}if(j){return j;}else{return this.getAggregation("layoutData");}};}}
function h(o,i,v,j,V){var L;if(o instanceof sap.ui.layout.form.ResponsiveGridLayoutPanel){L=sap.ui.getCore().byId(o.getLayout());}else{L=o.__myParentLayout;}var n=L.getLayoutDataForElement(i,"sap.ui.layout.GridData");if(!n){var p=L.getColumnsM();var r=L.getColumnsL();var s=L.getColumnsXL();var t=(v%r)==1;var u=(v%r)==0;var w=v>(r*(Math.ceil(V/r)-1));var x=v<=r;var y=(v%p)==1;var z=(v%p)==0;var A=v>(p*(Math.ceil(V/p)-1));var B=v<=p;var D=false;var E=u;var H=w;var I=x;if(s>0){D=(v%s)==1;E=(v%s)==0;H=v>(s*(Math.ceil(V/s)-1));I=v<=s;}if(j){var J=L.getLayoutDataForElement(j,"sap.ui.layout.GridData");if(J&&(J.getLinebreak()||J.getLinebreakXL())){E=true;H=false;}if(J&&(J.getLinebreak()||J.getLinebreakL())){u=true;w=false;}if(J&&(J.getLinebreak()||J.getLinebreakM())){z=true;A=false;}}var S="";if(E){S="sapUiFormResGridLastContXL";}if(u){if(S){S=S+" ";}S=S+"sapUiFormResGridLastContL";}if(z){if(S){S=S+" ";}S=S+"sapUiFormResGridLastContM";}if(H){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowXL";}if(w){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowL";}if(A){if(S){S=S+" ";}S=S+"sapUiFormResGridLastRowM";}if(I){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowXL";}if(x){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowL";}if(B){if(S){S=S+" ";}S=S+"sapUiFormResGridFirstRowM";}n=o.getLayoutData();if(!n){n=new a(o.getId()+"--LD",{linebreakL:t,linebreakM:y});o.setLayoutData(n);}else{n.setLinebreakL(t);n.setLinebreakM(y);}if(s>0){n.setLinebreakXL(D);}n._setStylesInternal(S);}}
function k(s){var i=this.mContainers[s];var o=i[1];if(o){f(o);}var p=i[0];if(p){d(p);}delete this.mContainers[s];}
function m(o){var n=o.getFormContainers();var v=[];var p;var L=0;var r=0;var i=0;var j=0;for(i=0;i<n.length;i++){p=n[i];if(p.isVisible()){L++;v.push(p);}}if(L>1||!this.getSingleContainerFullSize()){var s=Math.floor(12/this.getColumnsM());var S=Math.floor(12/this.getColumnsL());var t;var D="";var u=this.getColumnsXL();if(u>=0){t=Math.floor(12/u);D=D+"XL"+t+" ";}D=D+"L"+S+" M"+s+" S12";if(!this._mainGrid){this._mainGrid=new G(o.getId()+"--Grid",{defaultSpan:D,hSpacing:0,vSpacing:0,containerQuery:true}).setParent(this);this._mainGrid.addStyleClass("sapUiFormResGridMain");this._mainGrid._onParentResizeOrig=this._mainGrid._onParentResize;this._mainGrid._onParentResize=function(){this._onParentResizeOrig();var B=this.getParent();for(var A in B.mContainers){B.mContainers[A][1]._onParentResize();}};}else{this._mainGrid.setDefaultSpan(D);var w=this._mainGrid.getContent();r=w.length;var E=false;for(i=0;i<r;i++){var x=w[i];p=undefined;if(x.getContainer){p=sap.ui.getCore().byId(x.getContainer());}else{p=sap.ui.getCore().byId(x.__myParentContainerId);}if(p&&p.isVisible()){var V=v[j];if(p!=V){E=true;break;}var y=this.mContainers[p.getId()];if(y[0]&&y[0]!=x){E=true;break;}if(!y[0]&&y[1]&&y[1]!=x){E=true;break;}j++;}else{this._mainGrid.removeContent(x);}}if(E){this._mainGrid.removeAllContent();r=0;}}this._mainGrid._setBreakPointTablet(this.getBreakpointM());this._mainGrid._setBreakPointDesktop(this.getBreakpointL());this._mainGrid._setBreakPointLargeDesktop(this.getBreakpointXL());this._mainGrid.__bIsUsed=true;if(r<L){var z=0;if(r>0){z=r--;}for(i=z;i<n.length;i++){p=n[i];if(p.isVisible()){var A=p.getId();if(this.mContainers[A]){if(this.mContainers[A][0]){this._mainGrid.addContent(this.mContainers[A][0]);}else if(this.mContainers[A][1]){this._mainGrid.addContent(this.mContainers[A][1]);}}}}}}else if(this._mainGrid){this._mainGrid.__bIsUsed=false;}}
return b;});
sap.ui.predefine('sap/ui/layout/form/ResponsiveGridLayoutRenderer',['sap/ui/core/Renderer','./FormLayoutRenderer'],function(R,F){"use strict";var a=R.extend(F);
a.getMainClass=function(){return"sapUiFormResGrid";};
a.renderContainers=function(r,l,f){var c=f.getFormContainers();var v=[];var L=0;for(var i=0;i<c.length;i++){var C=c[i];if(C.isVisible()){L++;v.push(C);}}if(L>0){if(L>1||!l.getSingleContainerFullSize()){r.renderControl(l._mainGrid);}else if(l.mContainers[v[0].getId()][0]){r.renderControl(l.mContainers[v[0].getId()][0]);}else{r.renderControl(l.mContainers[v[0].getId()][1]);}}};
return a;},true);
sap.ui.predefine('sap/ui/layout/form/ResponsiveLayout',['jquery.sap.global','sap/ui/layout/ResponsiveFlowLayout','sap/ui/layout/ResponsiveFlowLayoutData','./FormLayout','sap/ui/layout/library','sap/ui/core/Control'],function(q,R,a,F,l,C){"use strict";
var b=F.extend("sap.ui.layout.form.ResponsiveLayout",{metadata:{library:"sap.ui.layout"}});
var P=C.extend("sap.ui.layout.form.ResponsiveLayoutPanel",{
metadata:{aggregations:{"content":{type:"sap.ui.layout.ResponsiveFlowLayout",multiple:false}},associations:{"container":{type:"sap.ui.layout.form.FormContainer",multiple:false},"layout":{type:"sap.ui.layout.form.ResponsiveLayout",multiple:false}}},
getLayoutData:function(){var i=sap.ui.getCore().byId(this.getContainer());var L=sap.ui.getCore().byId(this.getLayout());var j;if(L&&i){j=L.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");}return j;},
getCustomData:function(){var i=sap.ui.getCore().byId(this.getContainer());if(i){return i.getCustomData();}},
refreshExpanded:function(){var i=sap.ui.getCore().byId(this.getContainer());if(i){if(i.getExpanded()){this.$().removeClass("sapUiRLContainerColl");}else{this.$().addClass("sapUiRLContainerColl");}}},
renderer:function(r,p){var i=sap.ui.getCore().byId(p.getContainer());var L=sap.ui.getCore().byId(p.getLayout());var j=p.getContent();if(!i||!L){return;}var E=i.getExpandable();var t=i.getTooltip_AsString();var T=i.getToolbar();var s=i.getTitle();r.write("<div");r.writeControlData(p);r.addClass("sapUiRLContainer");if(E&&!i.getExpanded()){r.addClass("sapUiRLContainerColl");}if(T){r.addClass("sapUiFormContainerToolbar");}else if(s){r.addClass("sapUiFormContainerTitle");}if(t){r.writeAttributeEscaped('title',t);}r.writeClasses();L.getRenderer().writeAccessibilityStateContainer(r,i);r.write(">");if(T){r.renderControl(T);}else if(i.getTitle()){L.getRenderer().renderTitle(r,s,i._oExpandButton,E,false,i.getId());}if(j){r.write("<div");r.addClass("sapUiRLContainerCont");r.writeClasses();r.write(">");r.renderControl(j);r.write("</div>");}r.write("</div>");}
});
b.prototype.init=function(){this.mContainers={};this._defaultLayoutData=new a({margin:false});};
b.prototype.exit=function(){for(var s in this.mContainers){m.call(this,s);}if(this._mainRFLayout){this._mainRFLayout.destroy();delete this._mainRFLayout;}this._defaultLayoutData.destroy();delete this._defaultLayoutData;};
b.prototype.onBeforeRendering=function(E){var i=this.getParent();if(!i||!(i instanceof sap.ui.layout.form.Form)){return;}i._bNoInvalidate=true;_.call(this,i);o.call(this,i);i._bNoInvalidate=false;};
b.prototype.contentOnAfterRendering=function(i,j){F.prototype.contentOnAfterRendering.apply(this,arguments);if(j.getWidth&&(!j.getWidth()||j.getWidth()=="auto")&&(!j.getFormDoNotAdjustWidth||!j.getFormDoNotAdjustWidth())){j.$().css("width","100%");}};
b.prototype.toggleContainerExpanded=function(i){var s=i.getId();if(this.mContainers[s]&&this.mContainers[s][0]){var p=this.mContainers[s][0];p.refreshExpanded();}};
b.prototype.onLayoutDataChange=function(E){var s=E.srcControl;var i;var j;var p;if(s instanceof sap.ui.layout.form.FormContainer){if(this._mainRFLayout){this._mainRFLayout.onLayoutDataChange(E);}}else if(s instanceof sap.ui.layout.form.FormElement){j=s.getParent().getId();if(this.mContainers[j]&&this.mContainers[j][1]){this.mContainers[j][1].onLayoutDataChange(E);}}else{var r=s.getParent();if(r instanceof sap.ui.layout.form.FormElement){i=r.getParent();j=i.getId();p=r.getId();if(this.mContainers[j]&&this.mContainers[j][2]&&this.mContainers[j][2][p]){if(this.mContainers[j][2][p][1]){var t=r.getFields();h.call(this,this.mContainers[j][2][p][1],t);}this.mContainers[j][2][p][0].onLayoutDataChange(E);}}}};
b.prototype.onsapup=function(E){this.onsapleft(E);};
b.prototype.onsapdown=function(E){this.onsapright(E);};
b.prototype.getContainerRenderedDomRef=function(i){if(this.getDomRef()){var s=i.getId();if(this.mContainers[s]){if(this.mContainers[s][0]){var p=this.mContainers[s][0];return p.getDomRef();}else if(this.mContainers[s][1]){var r=this.mContainers[s][1];return r.getDomRef();}}}return null;};
b.prototype.getElementRenderedDomRef=function(E){if(this.getDomRef()){var i=E.getParent();var s=E.getId();var j=i.getId();if(this.mContainers[j]){if(this.mContainers[j][2]){var r=this.mContainers[j][2];if(r[s]){var p=r[s][0];return p.getDomRef();}}}}return null;};
function _(j){var p=j.getFormContainers();var r;var s;var L=p.length;var v=0;var t;var u;var i=0;for(i=0;i<L;i++){r=p[i];r._checkProperties();if(r.isVisible()){v++;s=r.getId();t=undefined;u=undefined;if(this.mContainers[s]&&this.mContainers[s][1]){u=this.mContainers[s][1];}else{u=f.call(this,r,undefined);}var T=r.getTitle();var w=r.getToolbar();if(w||T||r.getExpandable()){if(this.mContainers[s]&&this.mContainers[s][0]){t=this.mContainers[s][0];}else{t=c.call(this,r,u);g(u,true);}u.removeStyleClass("sapUiRLContainer");}else{if(this.mContainers[s]&&this.mContainers[s][0]){d(this.mContainers[s][0]);g(u,false);}u.addStyleClass("sapUiRLContainer");}var x=e.call(this,r,u);this.mContainers[s]=[t,u,x];}}var O=Object.keys(this.mContainers).length;if(v<O){for(s in this.mContainers){var y=false;for(i=0;i<L;i++){r=p[i];if(s==r.getId()&&r.isVisible()){y=true;break;}}if(!y){m.call(this,s);}}}}
function c(i,r){var s=i.getId();var p=new P(s+"--Panel",{container:i,layout:this,content:r});return p;}
function d(p){p.setContent("");p.setLayout("");p.setContainer("");p.destroy();}
function e(j,p){var s=j.getId();var E=j.getFormElements();var L=E.length;var v=0;var r={};if(this.mContainers[s]&&this.mContainers[s][2]){r=this.mContainers[s][2];}var t;var u;var w=-1;var x;var y;var i=0;for(i=0;i<L;i++){x=E[i];if(x.isVisible()){y=x.getId();n.call(this,j,x,r,p,i);if(r[y]){t=r[y][0];w=p.indexOfContent(t);if(w!=v){p.removeContent(t);p.insertContent(t,v);w=v;}}else{t=f.call(this,j,x);t.addStyleClass("sapUiRLElement");if(x.getLabel()){t.addStyleClass("sapUiRLElementWithLabel");}r[y]=[t,undefined];w++;p.insertContent(t,w);}var z=x.getFields();if(x.getLabel()&&z.length>1){if(r[y][1]){u=r[y][1];}else{u=f.call(this,j,x,true);u.addStyleClass("sapUiRLElementFields");r[y][1]=u;}h.call(this,u,z);}else{if(r[y][1]){u=r[y][1];k(u);r[y][1]=undefined;}}v++;}}var O=Object.keys(r).length;if(v<O){for(y in r){var A=false;for(i=0;i<L;i++){x=E[i];if(y==x.getId()&&x.isVisible()){A=true;break;}}if(!A){if(r[y][1]){u=r[y][1];k(u);}t=r[y][0];p.removeContent(t);k(t);delete r[y];}}}return r;}
function f(i,E,j){var I;if(E&&!j){I=E.getId()+"--RFLayout";}else if(E&&j){I=E.getId()+"--content--RFLayout";}else if(i){I=i.getId()+"--RFLayout";}else{return false;}var r=new R(I);r.__myParentLayout=this;r.__myParentContainerId=i.getId();if(E){r.__myParentElementId=E.getId();if(!j){r.getContent=function(){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){var p=[];var L=E.getLabelControl();var s=E.getFields();if(!L||s.length<=1){p=s;if(L){p.unshift(L);}}else{var t=this.__myParentLayout;var u=this.__myParentContainerId;var v=E.getId();if(L){p.push(L);}if(t.mContainers[u]&&t.mContainers[u][2]&&t.mContainers[u][2][v]&&t.mContainers[u][2][v][1]){p.push(t.mContainers[u][2][v][1]);}}return p;}else{return false;}};r._addContentClass=function(p,s){if(s==0){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){var L=E.getLabelControl();if(p==L){return"sapUiFormElementLbl";}}}return null;};}else{r.getContent=function(){var E=sap.ui.getCore().byId(this.__myParentElementId);if(E){return E.getFields();}else{return false;}};}}else if(i){r._getAccessibleRole=function(){var i=sap.ui.getCore().byId(this.__myParentContainerId);var L=this.__myParentLayout;if(L._mainRFLayout&&!i.getToolbar()&&!i.getTitle()&&!i.getExpandable()&&i.getAriaLabelledBy().length>0){return"form";}};r.getAriaLabelledBy=function(){var i=sap.ui.getCore().byId(this.__myParentContainerId);if(i&&!i.getToolbar()&&!i.getTitle()&&!i.getExpandable()){return i.getAriaLabelledBy();}return[];};}if((E&&!j)||(!E&&!i.getToolbar()&&!i.getTitle()&&!i.getExpandable())){g(r,false);}else{r.setLayoutData(new a({margin:false}));}return r;}
function g(r,O){if(O){if(r.__originalGetLayoutData){r.getLayoutData=r.__originalGetLayoutData;delete r.__originalGetLayoutData;}}else if(!r.__originalGetLayoutData){r.__originalGetLayoutData=r.getLayoutData;r.getLayoutData=function(){var L=this.__myParentLayout;var i=sap.ui.getCore().byId(this.__myParentContainerId);var E=sap.ui.getCore().byId(this.__myParentElementId);var j;if(E){j=L.getLayoutDataForElement(E,"sap.ui.layout.ResponsiveFlowLayoutData");}else if(i){j=L.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");}if(j){return j;}else if(E){return L._defaultLayoutData;}};}}
function h(r,j){var L;var w=0;for(var i=0;i<j.length;i++){var p=j[i];L=this.getLayoutDataForElement(p,"sap.ui.layout.ResponsiveFlowLayoutData");if(L){w=w+L.getWeight();}else{w++;}}L=r.getLayoutData();if(L){L.setWeight(w);}else{r.setLayoutData(new a({weight:w}));}}
function k(r){if(r.__myParentContainerId){r.__myParentContainerId=undefined;}if(r.__myParentElementId){r.__myParentElementId=undefined;}r.__myParentLayout=undefined;r.destroy();}
function m(s){var i=this.mContainers[s];var r;var E=i[2];if(E){for(var j in E){if(E[j][1]){k(E[j][1]);}r=E[j][0];k(r);delete E[j];}}r=i[1];if(r){r.removeAllContent();k(r);}var p=i[0];if(p){d(p);}delete this.mContainers[s];}
function n(i,E,r,j,I){var s=E.getId();var p=s+"--RFLayout";var t=sap.ui.getCore().byId(p);if(!r[s]&&t){var O=t.__myParentContainerId;r[s]=this.mContainers[O][2][s];j.insertContent(t,I);t.__myParentContainerId=i.getId();if(r[s][1]){r[s][1].__myParentContainerId=i.getId();}delete this.mContainers[O][2][s];}}
function o(p){var r=p.getFormContainers();var v=[];var s;var L=0;var t=0;var i=0;var j=0;for(i=0;i<r.length;i++){s=r[i];if(s.isVisible()){L++;v.push(s);}}if(L>1){if(!this._mainRFLayout){this._mainRFLayout=new R(p.getId()+"--RFLayout").setParent(this);}else{var u=this._mainRFLayout.getContent();t=u.length;var E=false;for(i=0;i<t;i++){var w=u[i];s=undefined;if(w.getContainer){s=sap.ui.getCore().byId(w.getContainer());}else{s=sap.ui.getCore().byId(w.__myParentContainerId);}if(s&&s.isVisible()){var V=v[j];if(s!=V){E=true;break;}var x=this.mContainers[s.getId()];if(x[0]&&x[0]!=w){E=true;break;}if(!x[0]&&x[1]&&x[1]!=w){E=true;break;}j++;}else{this._mainRFLayout.removeContent(w);}}if(E){this._mainRFLayout.removeAllContent();t=0;}}if(t<L){var S=0;if(t>0){S=t--;}for(i=S;i<L;i++){s=v[i];var y=s.getId();if(this.mContainers[y]){if(this.mContainers[y][0]){this._mainRFLayout.addContent(this.mContainers[y][0]);}else if(this.mContainers[y][1]){this._mainRFLayout.addContent(this.mContainers[y][1]);}}}}}}
return b;});
sap.ui.predefine('sap/ui/layout/form/ResponsiveLayoutRenderer',['sap/ui/core/Renderer','./FormLayoutRenderer'],function(R,F){"use strict";var a=R.extend(F);
a.getMainClass=function(){return"sapUiFormResLayout";};
a.renderContainers=function(r,l,f){var c=f.getFormContainers();var v=[];var L=0;for(var i=0;i<c.length;i++){var C=c[i];if(C.isVisible()){L++;v.push(C);}}if(L>0){if(L>1){r.renderControl(l._mainRFLayout);}else if(l.mContainers[v[0].getId()][0]){r.renderControl(l.mContainers[v[0].getId()][0]);}else{r.renderControl(l.mContainers[v[0].getId()][1]);}}};
return a;},true);
sap.ui.predefine('sap/ui/layout/form/SimpleForm.designtime',["sap/ui/fl/changeHandler/ChangeHandlerMediator"],function(C){"use strict";var g=function(e){var s=[];var l;var t;if(e.getMetadata().getName()==="sap.ui.layout.form.FormElement"){l=e.getLabel();if(l){s.push(l);}s=s.concat(e.getFields());}else if(e.getMetadata().getName()==="sap.ui.layout.form.FormContainer"){t=e.getTitle()||e.getToolbar();if(t){s[0]=t;}e.getFormElements().forEach(function(a){l=a.getLabel();if(l){s.push(l);}s=s.concat(a.getFields());});}return s;};var f={aggregations:{formContainers:{childNames:{singular:"GROUP_CONTROL_NAME",plural:"GROUP_CONTROL_NAME_PLURAL"},getIndex:function(a,b){var c=a.getFormContainers();if(b){return c.indexOf(b)+1;}if(c.length>0&&c[0].getFormElements().length===0&&c[0].getTitle()===null){return 0;}return c.length;},beforeMove:function(s){if(s){s._bChangedByMe=true;}},afterMove:function(s){if(s){s._bChangedByMe=false;}},actions:{move:{changeType:"moveSimpleFormGroup"},createContainer:{changeType:"addSimpleFormGroup",changeOnRelevantContainer:true,isEnabled:function(a){var b=a.getFormContainers();for(var i=0;i<b.length;i++){if(b[i].getToolbar&&b[i].getToolbar()){return false;}}return true;},getCreatedContainerId:function(n){var t=sap.ui.getCore().byId(n);var p=t.getParent().getId();return p;}}}}},getStableElements:g};var F={name:{singular:"GROUP_CONTROL_NAME",plural:"GROUP_CONTROL_NAME_PLURAL"},aggregations:{formElements:{childNames:{singular:"FIELD_CONTROL_NAME",plural:"FIELD_CONTROL_NAME_PLURAL"},beforeMove:function(s){if(s){s._bChangedByMe=true;}},afterMove:function(s){if(s){s._bChangedByMe=false;}},actions:{move:{changeType:"moveSimpleFormField"},addODataProperty:function(a){var c=C.getAddODataFieldWithLabelSettings(a);if(c){return{changeType:"addSimpleFormField",changeOnRelevantContainer:true,changeHandlerSettings:c};}}}}},actions:{rename:function(r){return{changeType:"renameTitle",changeOnRelevantContainer:true,isEnabled:!(r.getToolbar()||!r.getTitle()),domRef:function(c){if(c.getTitle&&c.getTitle()){return c.getTitle().getDomRef();}}};},remove:function(r){return{changeType:"removeSimpleFormGroup",changeOnRelevantContainer:true,isEnabled:!!(r.getToolbar()||r.getTitle()),getConfirmationText:function(r){var c=false;if(r.getMetadata().getName()==="sap.ui.layout.form.FormContainer"&&r.getToolbar&&r.getToolbar()){var t=r.getToolbar().getContent();if(t.length>1){c=true;}else if((t.length===1)&&(!t[0].getMetadata().isInstanceOf("sap.ui.core.Label")&&!t[0]instanceof sap.ui.core.Title&&!t[0]instanceof sap.m.Title)){c=true;}}if(c){var T=sap.ui.getCore().getLibraryResourceBundle("sap.ui.layout");return T.getText("MSG_REMOVING_TOOLBAR");}},getState:function(s){var c=s.getContent();return{content:c.map(function(e){return{element:e,visible:e.getVisible?e.getVisible():undefined,index:c.indexOf(e)};})};},restoreState:function(s,S){s.removeAllContent();S.content.forEach(function(e){s.insertContent(e.element,e.index);if(e.element.setVisible){e.element.setVisible(e.visible);}});}};}},getStableElements:g};var o={name:{singular:"FIELD_CONTROL_NAME",plural:"FIELD_CONTROL_NAME_PLURAL"},actions:{rename:{changeType:"renameLabel",changeOnRelevantContainer:true,domRef:function(c){return c.getLabel().getDomRef();}},remove:{changeType:"hideSimpleFormField",changeOnRelevantContainer:true,getState:function(s){var c=s.getContent();return{content:c.map(function(e){return{element:e,visible:e.getVisible?e.getVisible():undefined,index:c.indexOf(e)};})};},restoreState:function(s,S){s.removeAllContent();S.content.forEach(function(e){s.insertContent(e.element,e.index);if(e.element.setVisible){e.element.setVisible(e.visible);}});}},reveal:{changeType:"unhideSimpleFormField",changeOnRelevantContainer:true}},getStableElements:g};return{aggregations:{content:{ignore:true},title:{ignore:true},toolbar:{ignore:function(s){return!s.getToolbar();},domRef:function(s){return s.getToolbar().getDomRef();}},form:{ignore:false,propagateMetadata:function(e){var t=e.getMetadata().getName();if(t==="sap.ui.layout.form.Form"){return f;}else if(t==="sap.ui.layout.form.FormContainer"){return F;}else if(t==="sap.ui.layout.form.FormElement"){return o;}else{return{actions:null};}},propagateRelevantContainer:true}}};},false);
sap.ui.predefine('sap/ui/layout/form/SimpleForm',['jquery.sap.global','sap/ui/core/Control','./Form','./FormContainer','./FormElement','./FormLayout','sap/ui/base/ManagedObjectObserver','sap/ui/layout/library','sap/ui/core/ResizeHandler'],function(q,C,F,a,b,c,M,l,R){"use strict";var B=l.BackgroundDesign;var S=l.form.SimpleFormLayout;var d;var e;var f;var G;var g;var h;
var m=C.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:S.ResponsiveLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designTime:true}});
m.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var i=new F(this.getId()+"--Form");i.getTitle=function(){return this.getParent().getTitle();};i._origInvalidate=i.invalidate;i.invalidate=function(j){if(this.bOutput){this._origInvalidate(j);}if(this._bIsBeingDestroyed){return;}var k=this.getParent();if(k){k._formInvalidated(j);}};i.getAriaLabelledBy=function(){var j=this.getParent();if(j){return j.getAriaLabelledBy();}else{return null;}};i._origOnLayoutDataChange=i.onLayoutDataChange;i.onLayoutDataChange=function(j){this._origOnLayoutDataChange(j);var k=this.getParent();if(k){k._onLayoutDataChange(j);}};this.setAggregation("form",i);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];this._oObserver=new M(Q.bind(this));};
m.prototype.exit=function(){var j=this.getAggregation("form");j.invalidate=j._origInvalidate;O.call(this);for(var i=0;i<this._aLayouts.length;i++){var k=sap.ui.getCore().byId(this._aLayouts[i]);if(k&&k.destroy){k.destroy();}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];this._oObserver.disconnect();this._oObserver=undefined;};
m.prototype.onBeforeRendering=function(){O.call(this);var i=this.getAggregation("form");if(!this._bResponsiveLayoutRequested&&!this._bGridLayoutRequested&&!this._bResponsiveGridLayoutRequested){var j=true;if(!i.getLayout()){j=_.call(this);}if(j){u.call(this);}}};
m.prototype.onAfterRendering=function(){if(this.getLayout()==S.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._resize,this));this._bChangedByMe=false;}};
m.prototype.setEditable=function(i){this._bChangedByMe=true;this.setProperty("editable",i,true);var j=this.getAggregation("form");j.setEditable(i);this._bChangedByMe=false;return this;};
m.prototype.setToolbar=function(i){this._bChangedByMe=true;var j=this.getAggregation("form");j.setToolbar(i);this._bChangedByMe=false;return this;};
m.prototype.getToolbar=function(){var i=this.getAggregation("form");return i.getToolbar();};
m.prototype.destroyToolbar=function(){this._bChangedByMe=true;var i=this.getAggregation("form");i.destroyToolbar();this._bChangedByMe=false;return this;};
m.prototype.setLabelMinWidth=function(j){this.setProperty("labelMinWidth",j,true);if(this.getLayout()==S.ResponsiveLayout){this._bLayoutDataChangedByMe=true;var k=this.getContent();for(var i=0;i<k.length;i++){var V=k[i];if(V.getMetadata().isInstanceOf("sap.ui.core.Label")){var W=x.call(this,V);if(U(W,"sap/ui/layout/ResponsiveFlowLayoutData")&&v.call(this,W)){W.setMinWidth(j);}}}this._bLayoutDataChangedByMe=false;}return this;};
m.prototype.indexOfContent=function(j){var k=this._aElements;if(k){for(var i=0;i<k.length;i++){if(k[i]==j){return i;}}}return-1;};
m.prototype.addContent=function(i){i=this.validateAggregation("content",i,true);if(this.indexOfContent(i)>=0){q.sap.log.warning("SimpleForm.addContent: Content element '"+i+"' already assigned. Please remove before adding!",this);this.removeContent(i);}if(!this._aElements){this._aElements=[];}this._bChangedByMe=true;var j=this._aElements.length;var k;var V=this.getAggregation("form");var W;var X;var Y;var Z;if(i instanceof sap.ui.core.Title||i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){W=K.call(this,i);V.addFormContainer(W);this._changedFormContainers.push(W);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Label")){if(j>0){k=this._aElements[j-1];Y=k.getParent();if(Y instanceof b){W=Y.getParent();}else if(Y instanceof a){W=Y;}}if(!W){W=K.call(this);V.addFormContainer(W);this._changedFormContainers.push(W);}X=H.call(this,W,i);}else{if(j>0){k=this._aElements[j-1];Y=k.getParent();if(Y instanceof b){W=Y.getParent();X=Y;Z=x.call(this,i);if(U(Z,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,Z)&&Z.getLinebreak()){X=H.call(this,W);}}else if(Y instanceof a){W=Y;X=H.call(this,W);}}else{W=K.call(this);V.addFormContainer(W);this._changedFormContainers.push(W);X=H.call(this,W);}z.call(this,i,5,false,true);X.addField(i);P(this._changedFormElements,X);}this._aElements.push(i);this._oObserver.observe(i,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};
m.prototype.insertContent=function(j,k){j=this.validateAggregation("content",j,true);if(this.indexOfContent(j)>=0){q.sap.log.warning("SimpleForm.insertContent: Content element '"+j+"' already assigned. Please remove before insert!",this);this.removeContent(j);}if(!this._aElements){this._aElements=[];}var V=this._aElements.length;var W;if(k<0){W=0;}else if(k>V){W=V;}else{W=k;}if(W!==k){q.sap.log.warning("SimpleForm.insertContent: index '"+k+"' out of range [0,"+V+"], forced to "+W);}if(W==V){this.addContent(j);return this;}this._bChangedByMe=true;var X=this._aElements[W];var Y=this.getAggregation("form");var Z;var $;var a1;var b1;var c1;var d1=0;var e1;var f1;var g1;var h1;var i=0;var i1;var j1;if(j instanceof sap.ui.core.Title||j.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){if(k==0&&!(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar"))){Z=X.getParent().getParent();if(j instanceof sap.ui.core.Title){Z.setTitle(j);}else{Z.setToolbar(j);}}else{Z=K.call(this,j);if(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){a1=X.getParent();c1=Y.indexOfFormContainer(a1);}else{b1=X.getParent();a1=b1.getParent();c1=Y.indexOfFormContainer(a1)+1;d1=a1.indexOfFormElement(b1);if(!X.getMetadata().isInstanceOf("sap.ui.core.Label")){e1=b1.indexOfField(X);if(e1>0||b1.getLabel()){$=H.call(this,Z);this._changedFormElements.push($);P(this._changedFormElements,b1);f1=b1.getFields();for(i=e1;i<f1.length;i++){i1=f1[i];$.addField(i1);}d1++;}}g1=a1.getFormElements();for(i=d1;i<g1.length;i++){Z.addFormElement(g1[i]);}}Y.insertFormContainer(Z,c1);}this._changedFormContainers.push(Z);}else if(j.getMetadata().isInstanceOf("sap.ui.core.Label")){if(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){a1=X.getParent();c1=Y.indexOfFormContainer(a1);h1=Y.getFormContainers();if(c1==0){Z=K.call(this);Y.insertFormContainer(Z,c1);this._changedFormContainers.push(Z);}else{Z=h1[c1-1];}$=H.call(this,Z,j);}else if(X.getMetadata().isInstanceOf("sap.ui.core.Label")){a1=X.getParent().getParent();d1=a1.indexOfFormElement(X.getParent());$=I.call(this,a1,j,d1);}else{b1=X.getParent();a1=b1.getParent();d1=a1.indexOfFormElement(b1)+1;e1=b1.indexOfField(X);if(e1==0&&!b1.getLabel()){$=b1;$.setLabel(j);z.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}else{$=I.call(this,a1,j,d1);P(this._changedFormElements,b1);f1=b1.getFields();for(i=e1;i<f1.length;i++){i1=f1[i];$.addField(i1);}}}this._changedFormElements.push($);}else{j1=x.call(this,j);if(X instanceof sap.ui.core.Title||X.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){a1=X.getParent();c1=Y.indexOfFormContainer(a1);if(c1==0){Z=K.call(this);Y.insertFormContainer(Z,c1);this._changedFormContainers.push(Z);}else{h1=Y.getFormContainers();Z=h1[c1-1];}g1=Z.getFormElements();if(g1.length==0){$=H.call(this,Z);}else if(U(j1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,j1)&&j1.getLinebreak()){$=H.call(this,Z);}else{$=g1[g1.length-1];}$.addField(j);}else if(X.getMetadata().isInstanceOf("sap.ui.core.Label")){b1=X.getParent();Z=b1.getParent();d1=Z.indexOfFormElement(b1);if(d1==0){$=I.call(this,Z,null,0);}else if(U(j1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,j1)&&j1.getLinebreak()){$=I.call(this,Z,null,d1);}else{g1=Z.getFormElements();$=g1[d1-1];}$.addField(j);}else{$=X.getParent();e1=$.indexOfField(X);if(U(j1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,j1)&&j1.getLinebreak()&&e1>0){Z=$.getParent();d1=Z.indexOfFormElement($);P(this._changedFormElements,$);f1=$.getFields();$=I.call(this,Z,undefined,d1+1);$.addField(j);for(i=e1;i<f1.length;i++){i1=f1[i];$.addField(i1);}}else{$.insertField(j,e1);}}P(this._changedFormElements,$);z.call(this,j,5,false,true);}this._aElements.splice(W,0,j);this._oObserver.observe(j,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};
m.prototype.removeContent=function(j){var k=null;var V=-1;var i=0;if(this._aElements){if(typeof(j)=="string"){j=sap.ui.getCore().byId(j);}if(typeof(j)=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==j){j=i;break;}}}if(typeof(j)=="number"){if(j<0||j>=this._aElements.length){q.sap.log.warning("Element.removeAggregation called with invalid index: Items, "+j);}else{V=j;k=this._aElements[V];}}}if(k){this._bChangedByMe=true;var W=this.getAggregation("form");var X;var Y;var Z;var $;if(k instanceof sap.ui.core.Title||k.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){X=k.getParent();X.setTitle(null);X.setToolbar(null);if(V>0){Z=X.getFormElements();var a1=W.indexOfFormContainer(X);var b1=W.getFormContainers()[a1-1];if(Z.length>0&&!Z[0].getLabel()){var c1=b1.getFormElements();var d1=c1[c1.length-1];$=Z[0].getFields();for(i=0;i<$.length;i++){d1.addField($[i]);}P(this._changedFormElements,d1);X.removeFormElement(Z[0]);Z[0].destroy();Z.splice(0,1);}for(i=0;i<Z.length;i++){b1.addFormElement(Z[i]);}P(this._changedFormContainers,b1);W.removeFormContainer(X);X.destroy();}else if(X.getFormElements().length==0){W.removeFormContainer(X);X.destroy();}}else if(k.getMetadata().isInstanceOf("sap.ui.core.Label")){Y=k.getParent();X=Y.getParent();Y.setLabel(null);var e1=X.indexOfFormElement(Y);if(e1==0){if(Y.getFields().length==0){X.removeFormElement(Y);Y.destroy();if(X.getFormElements().length==0&&!X.getTitle()&&!X.getToolbar()){W.removeFormContainer(X);X.destroy();}}else{P(this._changedFormElements,Y);}}else{Z=X.getFormElements();var f1=Z[e1-1];$=Y.getFields();for(i=0;i<$.length;i++){f1.addField($[i]);}P(this._changedFormElements,f1);X.removeFormElement(Y);Y.destroy();}}else{Y=k.getParent();Y.removeField(k);if(Y.getFields().length==0&&!Y.getLabel()){X=Y.getParent();X.removeFormElement(Y);Y.destroy();if(X.getFormElements().length==0&&!X.getTitle()&&!X.getToolbar()){W.removeFormContainer(X);X.destroy();}}else{P(this._changedFormElements,Y);}}this._aElements.splice(V,1);k.setParent(null);this._oObserver.unobserve(k);E.call(this,k);this.invalidate();this._bChangedByMe=false;return k;}return null;};
m.prototype.removeAllContent=function(){var i=0;if(this._aElements){this._bChangedByMe=true;var k=this.getAggregation("form");var V=k.getFormContainers();for(i=0;i<V.length;i++){var W=V[i];W.setTitle(null);W.setToolbar(null);var X=W.getFormElements();for(var j=0;j<X.length;j++){var Y=X[j];Y.setLabel(null);Y.removeAllFields();}W.destroyFormElements();}k.destroyFormContainers();for(i=0;i<this._aElements.length;i++){var Z=this._aElements[i];E.call(this,Z);this._oObserver.unobserve(Z);}var $=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return $;}else{return[];}};
m.prototype.destroyContent=function(){var j=this.removeAllContent();if(j){this._bChangedByMe=true;for(var i=0;i<j.length;i++){j[i].destroy();}this.invalidate();this._bChangedByMe=false;}return this;};
m.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[]);}return this._aElements.slice();};
m.prototype.setLayout=function(i){var j=this.getLayout();if(i!=j){s.call(this);}this.setProperty("layout",i);if(i!=j){var k=_.call(this);if(k){t.call(this);}}return this;};
m.prototype.clone=function(k){this._bChangedByMe=true;var V=C.prototype.clone.apply(this,arguments);var W=this.getContent();for(var i=0;i<W.length;i++){var X=W[i];var Y=X.getLayoutData();this._oObserver.unobserve(X);var Z=X.clone(k);this._oObserver.observe(X,{properties:["visible"]});if(Y){if(U(Y,"sap/ui/core/VariantLayoutData")){var $=Y.getMultipleLayoutData();for(var j=0;j<$.length;j++){if(v.call(this,$[j])){V._aLayouts.push(Z.getLayoutData().getMultipleLayoutData()[j].getId());}}}else if(v.call(this,Y)){V._aLayouts.push(Z.getLayoutData().getId());}}V.addContent(Z);}this._bChangedByMe=false;return V;};
function _(){var i=this.getAggregation("form");if(i.getLayout()){this._bChangedByMe=true;i.destroyLayout();O.call(this);this._bChangedByMe=false;}var j;switch(this.getLayout()){case S.ResponsiveLayout:if((!d||!e)&&!this._bResponsiveLayoutRequested){d=sap.ui.require("sap/ui/layout/form/ResponsiveLayout");e=sap.ui.require("sap/ui/layout/ResponsiveFlowLayoutData");if(!d||!e){sap.ui.require(["sap/ui/layout/form/ResponsiveLayout","sap/ui/layout/ResponsiveFlowLayoutData"],n.bind(this));this._bResponsiveLayoutRequested=true;}}if(d&&e){j=new d(this.getId()+"--Layout");}break;case S.GridLayout:if((!G||!g||!h)&&!this._bGridLayoutRequested){G=sap.ui.require("sap/ui/layout/form/GridLayout");g=sap.ui.require("sap/ui/layout/form/GridContainerData");h=sap.ui.require("sap/ui/layout/form/GridElementData");if(!G||!g||!h){sap.ui.require(["sap/ui/layout/form/GridLayout","sap/ui/layout/form/GridContainerData","sap/ui/layout/form/GridElementData"],o.bind(this));this._bGridLayoutRequested=true;}}if(G&&g&&h){j=new G(this.getId()+"--Layout");}break;case S.ResponsiveGridLayout:if(!f&&!this._bResponsiveGridLayoutRequested){f=sap.ui.require("sap/ui/layout/form/ResponsiveGridLayout");if(!f){sap.ui.require(["sap/ui/layout/form/ResponsiveGridLayout"],p.bind(this));this._bResponsiveGridLayoutRequested=true;}}if(f){j=new f(this.getId()+"--Layout");}break;}if(j){this._bChangedByMe=true;i.setLayout(j);this._bChangedByMe=false;return true;}return false;}
function n(i,j){d=i;e=j;this._bResponsiveLayoutRequested=false;if(this.getLayout()==S.ResponsiveLayout){r.call(this);}}
function o(i,j,k){G=i;g=j;h=k;this._bGridLayoutRequested=false;if(this.getLayout()==S.GridLayout){r.call(this);}}
function p(i){f=i;this._bResponsiveGridLayoutRequested=false;if(this.getLayout()==S.ResponsiveGridLayout){r.call(this);}}
function r(){if(!this._bIsBeingDestroyed){_.call(this);t.call(this);if(this.getDomRef()){u.call(this);}}}
function s(){this._bChangedByMe=true;var V=this.getAggregation("form");var W=V.getFormContainers();for(var i=0;i<W.length;i++){var X=W[i];P(this._changedFormContainers,X);if(X.getLayoutData()){X.destroyLayoutData();}var Y=X.getFormElements();for(var j=0;j<Y.length;j++){var Z=Y[j];P(this._changedFormElements,Z);if(Z.getLayoutData()){Z.destroyLayoutData();}var $=Z.getLabel();if($){E.call(this,$);}var a1=Z.getFields();for(var k=0;k<a1.length;k++){var b1=a1[k];E.call(this,b1);}}}this._bChangedByMe=false;}
function t(){this._bChangedByMe=true;var V=this.getAggregation("form");var W=V.getFormContainers();for(var i=0;i<W.length;i++){var X=W[i];P(this._changedFormContainers,X);D.call(this,X);var Y=X.getFormElements();for(var j=0;j<Y.length;j++){var Z=Y[j];P(this._changedFormElements,Z);A.call(this,Z);var $=Z.getLabel();if($){z.call(this,$,this._iLabelWeight,false,true,this.getLabelMinWidth());}var a1=Z.getFields();for(var k=0;k<a1.length;k++){var b1=a1[k];z.call(this,b1,5,false,true);}}}this._bChangedByMe=false;}
function u(){this._bChangedByMe=true;this._changedFormContainers=[];var j=this.getLayout();var k=this.getAggregation("form").getLayout();k.setBackgroundDesign(this.getBackgroundDesign());switch(j){case S.ResponsiveLayout:this._applyLinebreaks();for(var i=0;i<this._changedFormElements.length;i++){var V=this._changedFormElements[i];L.call(this,V);}break;case S.GridLayout:N.call(this);break;case S.ResponsiveGridLayout:k.setLabelSpanXL(this.getLabelSpanXL());k.setLabelSpanL(this.getLabelSpanL());k.setLabelSpanM(this.getLabelSpanM());k.setLabelSpanS(this.getLabelSpanS());k.setAdjustLabelSpan(this.getAdjustLabelSpan());k.setEmptySpanXL(this.getEmptySpanXL());k.setEmptySpanL(this.getEmptySpanL());k.setEmptySpanM(this.getEmptySpanM());k.setEmptySpanS(this.getEmptySpanS());k.setColumnsXL(this.getColumnsXL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setSingleContainerFullSize(this.getSingleContainerFullSize());k.setBreakpointXL(this.getBreakpointXL());k.setBreakpointL(this.getBreakpointL());k.setBreakpointM(this.getBreakpointM());break;}this._changedFormElements=[];this._bChangedByMe=false;}
function v(i){var j=i.getId(),k=" "+this._aLayouts.join(" ")+" ";return k.indexOf(" "+j+" ")>-1;}
function w(W,i,j,k){var V=new e({weight:W,linebreak:i===true,linebreakable:j===true});if(k){V.setMinWidth(k);}this._aLayouts.push(V.getId());return V;}
function x(i){var j;switch(this.getLayout()){case S.ResponsiveLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");break;case S.GridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.GridElementData");break;case S.ResponsiveGridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.GridData");break;}return j;}
function y(){if(this._bResponsiveLayoutRequested||this._bGridLayoutRequested||this._bResponsiveGridLayoutRequested){return false;}if(!this.getAggregation("form").getLayout()){var i=this._bChangedByMe;var j=_.call(this);this._bChangedByMe=i;if(!j){return false;}}return true;}
function z(i,W,j,k,V){if(this.getLayout()!=S.ResponsiveLayout){return;}if(!y.call(this)){return;}this._bLayoutDataChangedByMe=true;var X=x.call(this,i);if(!X||!v.call(this,X)){X=i.getLayoutData();if(U(X,"sap/ui/core/VariantLayoutData")){X.addMultipleLayoutData(w.call(this,W,j,k,V));}else if(!X){i.setLayoutData(w.call(this,W,j,k,V));}else{q.sap.log.warning("ResponsiveFlowLayoutData can not be set on Field "+i.getId(),"_createFieldLayoutData","SimpleForm");}}this._bLayoutDataChangedByMe=false;}
function A(i){if(this.getLayout()!=S.ResponsiveLayout){return;}if(!y.call(this)){return;}this._bLayoutDataChangedByMe=true;i.setLayoutData(new e({linebreak:true,margin:false}));this._bLayoutDataChangedByMe=false;}
function D(i){var j=this.getLayout();if(j!=S.ResponsiveLayout&&j!=S.GridLayout){return;}if(!y.call(this)){return;}this._bLayoutDataChangedByMe=true;switch(j){case S.ResponsiveLayout:i.setLayoutData(new e({minWidth:280}));break;case S.GridLayout:if(this.getMaxContainerCols()>1){i.setLayoutData(new g({halfGrid:true}));}else{i.setLayoutData(new g({halfGrid:false}));}break;}this._bLayoutDataChangedByMe=false;}
function E(j){this._bLayoutDataChangedByMe=true;var k=x.call(this,j);if(k){var V=k.getId();for(var i=0;i<this._aLayouts.length;i++){var W=this._aLayouts[i];if(V==W){k.destroy();this._aLayouts.splice(i,1);break;}}}this._bLayoutDataChangedByMe=false;}
function H(i,j){var k=J.call(this,j);i.addFormElement(k);return k;}
function I(i,j,k){var V=J.call(this,j);i.insertFormElement(V,k);return V;}
function J(j){var k=new b();A.call(this,k);if(j){j.addStyleClass("sapUiFormLabel-CTX");k.setLabel(j);if(!x.call(this,j)){z.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}}k.isVisible=function(){var V=this.getFields();var W=false;for(var i=0;i<V.length;i++){var X=V[i];if(X.getVisible()){W=true;break;}}return W;};return k;}
function K(i){var j=new a();D.call(this,j);j.getAriaLabelledBy=function(){var k=this.getToolbar();if(k){return k.getAriaLabelledBy();}else{return[];}};if(i){if(i instanceof sap.ui.core.Title){j.setTitle(i);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){j.setToolbar(i);}}return j;}
function L(j){var k=this._iMaxWeight;var V=j.getFields();var W;var X=V.length;var Y=j.getLabel();var Z;var i=0;this._bLayoutDataChangedByMe=true;if(Y&&x.call(this,Y)){k=k-x.call(this,Y).getWeight();}for(i=0;i<V.length;i++){W=V[i];Z=x.call(this,W);if(U(Z,"sap/ui/layout/ResponsiveFlowLayoutData")&&!v.call(this,Z)){k=k-Z.getWeight();X--;}}var $=Math.floor(k/X);var a1=k%X;for(i=0;i<V.length;i++){W=V[i];Z=x.call(this,W);var b1=$;if(!Z){z.call(this,W,b1,false,i==0);}else if(v.call(this,Z)&&U(Z,"sap/ui/layout/ResponsiveFlowLayoutData")){if(a1>0){b1++;a1--;}Z.setWeight(b1);}}this._bLayoutDataChangedByMe=false;}
m.prototype._applyLinebreaks=function(){if(!d||this._bResponsiveLayoutRequested){return;}this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form"),k=j.getFormContainers();var V=this.getDomRef();var W=this.$();for(var i=1;i<k.length;i++){var X=k[i],Y=X.getLayoutData();if(!V||W.outerWidth(true)>this.getMinWidth()){if(i%this.getMaxContainerCols()==0){Y.setLinebreak(true);}else{Y.setLinebreak(false);}}else{Y.setLinebreak(true);}}if(V&&W.css("visibility")=="hidden"){var Z=this;setTimeout(function(){if(Z.getDomRef()){Z.$().css("visibility","");}},10);}this._bLayoutDataChangedByMe=false;};
function N(){this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form");var k=j.getFormContainers();var V=k.length;for(var i=0;i<V;i++){var W=k[i];if((this.getMaxContainerCols()<=1)||((i==V-1)&&(V%2>0))){W.getLayoutData().setHalfGrid(false);}else if(!W.getLayoutData().getHalfGrid()){W.getLayoutData().setHalfGrid(true);}}this._bLayoutDataChangedByMe=false;}
m.prototype._resize=function(i){this._bChangedByMe=true;if(this._iCurrentWidth==i.size.width){return;}this._iCurrentWidth=i.size.width;this._applyLinebreaks();this._bChangedByMe=false;};
function O(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}}
function P(j,k){var V=false;for(var i=0;i<j.length;i++){var W=j[i];if(W==k){V=true;break;}}if(!V){j.push(k);}}
function Q(i){if(i.name=="visible"){var j=i.object.getParent();j.invalidate();}}
function T(V){var W=[];var X=V.getFormContainers();for(var i=0;i<X.length;i++){var Y=X[i];var Z=Y.getTitle();if(Z){W.push(Z);}else{var $=Y.getToolbar();if($){W.push($);}}var a1=Y.getFormElements();for(var j=0;j<a1.length;j++){var b1=a1[j];var c1=b1.getLabel();if(c1){W.push(c1);}var d1=b1.getFields();for(var k=0;k<d1.length;k++){var e1=d1[k];W.push(e1);}}}return W;}
m.prototype._formInvalidated=function(k){if(!this._bChangedByMe){var V=T(this.getAggregation("form"));var i=0;var j=0;var W=false;if(!this._aElements||V.length<this._aElements.length){W=true;}else{for(i=0;i<V.length;i++){var X=V[i];var Y=this._aElements[j];if(X===Y){j++;}else{var Z=V[i+1];if(Z===Y){this.insertContent(X,i);break;}Z=this._aElements[j+1];if(Z===X){W=true;break;}break;}}}if(W){this.removeAllContent();for(i=0;i<V.length;i++){var $=V[i];this.addContent($);}}}};
m.prototype._onLayoutDataChange=function(i){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed){switch(this.getLayout()){case S.ResponsiveLayout:var j=i.srcControl;var k=j.getParent();if(k instanceof b){var V=this.indexOfContent(j);this.removeContent(j);this.insertContent(j,V);}break;}}};
function U(i,j){var k=sap.ui.require(j);return i&&typeof k==='function'&&(i instanceof k);}
return m;});
sap.ui.predefine('sap/ui/layout/form/SimpleFormRenderer',[],function(){"use strict";var S={};
S.render=function(r,c){c._bChangedByMe=true;r.write("<div");r.writeControlData(c);r.addClass("sapUiSimpleForm");if(c.getWidth()){r.addStyle("width",c.getWidth());}r.writeStyles();r.writeClasses();r.write(">");var f=c.getAggregation("form");r.renderControl(f);r.write("</div>");c._bChangedByMe=false;};
return S;},true);
sap.ui.predefine('sap/ui/layout/library',['sap/ui/base/DataType','sap/ui/core/library'],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.layout",version:"1.52.12",dependencies:["sap.ui.core"],types:["sap.ui.layout.BackgroundDesign","sap.ui.layout.GridIndent","sap.ui.layout.GridPosition","sap.ui.layout.GridSpan","sap.ui.layout.BlockBackgroundType","sap.ui.layout.form.GridElementCells","sap.ui.layout.form.SimpleFormLayout"],interfaces:[],controls:["sap.ui.layout.AlignedFlowLayout","sap.ui.layout.DynamicSideContent","sap.ui.layout.FixFlex","sap.ui.layout.Grid","sap.ui.layout.HorizontalLayout","sap.ui.layout.ResponsiveFlowLayout","sap.ui.layout.ResponsiveSplitter","sap.ui.layout.ResponsiveSplitterPage","sap.ui.layout.Splitter","sap.ui.layout.VerticalLayout","sap.ui.layout.BlockLayoutCell","sap.ui.layout.BlockLayoutRow","sap.ui.layout.BlockLayout","sap.ui.layout.form.Form","sap.ui.layout.form.FormLayout","sap.ui.layout.form.GridLayout","sap.ui.layout.form.ResponsiveGridLayout","sap.ui.layout.form.ResponsiveLayout","sap.ui.layout.form.SimpleForm"],elements:["sap.ui.layout.GridData","sap.ui.layout.ResponsiveFlowLayoutData","sap.ui.layout.SplitterLayoutData","sap.ui.layout.form.FormContainer","sap.ui.layout.form.FormElement","sap.ui.layout.form.GridContainerData","sap.ui.layout.PaneContainer","sap.ui.layout.SplitPane","sap.ui.layout.form.GridElementData"],extensions:{flChangeHandlers:{"sap.ui.layout.BlockLayout":{"moveControls":"default"},"sap.ui.layout.BlockLayoutRow":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.BlockLayoutCell":"sap/ui/layout/flexibility/BlockLayoutCell","sap.ui.layout.form.SimpleForm":"sap/ui/layout/flexibility/SimpleForm","sap.ui.layout.Grid":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.FixFlex":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.form.Form":"sap/ui/layout/flexibility/Form","sap.ui.layout.form.FormContainer":"sap/ui/layout/flexibility/FormContainer","sap.ui.layout.form.FormElement":"sap/ui/layout/flexibility/FormElement","sap.ui.layout.HorizontalLayout":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.Splitter":{"moveControls":"default","hideControl":"default","unhideControl":"default"},"sap.ui.layout.VerticalLayout":{"moveControls":"default","hideControl":"default","unhideControl":"default"}}}});sap.ui.layout.BackgroundDesign={Solid:"Solid",Transparent:"Transparent",Translucent:"Translucent"};sap.ui.layout.GridIndent=D.createType('sap.ui.layout.GridIndent',{isValid:function(v){return/^(([Xx][Ll](?:[0-9]|1[0-1]))? ?([Ll](?:[0-9]|1[0-1]))? ?([Mm](?:[0-9]|1[0-1]))? ?([Ss](?:[0-9]|1[0-1]))?)$/.test(v);}},D.getType('string'));sap.ui.layout.GridPosition={Left:"Left",Right:"Right",Center:"Center"};sap.ui.layout.GridSpan=D.createType('sap.ui.layout.GridSpan',{isValid:function(v){return/^(([Xx][Ll](?:[1-9]|1[0-2]))? ?([Ll](?:[1-9]|1[0-2]))? ?([Mm](?:[1-9]|1[0-2]))? ?([Ss](?:[1-9]|1[0-2]))?)$/.test(v);}},D.getType('string'));sap.ui.layout.BlockBackgroundType={Default:"Default",Light:"Light",Mixed:"Mixed",Accent:"Accent",Dashboard:"Dashboard"};sap.ui.layout.BlockRowColorSets={ColorSet1:"ColorSet1",ColorSet2:"ColorSet2",ColorSet3:"ColorSet3",ColorSet4:"ColorSet4"};sap.ui.layout.BlockLayoutCellColorSet={ColorSet1:"ColorSet1",ColorSet2:"ColorSet2",ColorSet3:"ColorSet3",ColorSet4:"ColorSet4",ColorSet5:"ColorSet5",ColorSet6:"ColorSet6",ColorSet7:"ColorSet7",ColorSet8:"ColorSet8",ColorSet9:"ColorSet9",ColorSet10:"ColorSet10",ColorSet11:"ColorSet11"};sap.ui.layout.BlockLayoutCellColorShade={ShadeA:"ShadeA",ShadeB:"ShadeB",ShadeC:"ShadeC",ShadeD:"ShadeD"};sap.ui.layout.form=sap.ui.layout.form||{};sap.ui.layout.form.GridElementCells=D.createType('sap.ui.layout.form.GridElementCells',{isValid:function(v){return/^(auto|full|([1-9]|1[0-6]))$/.test(v);}},D.getType('string'));sap.ui.layout.form.SimpleFormLayout={ResponsiveLayout:"ResponsiveLayout",GridLayout:"GridLayout",ResponsiveGridLayout:"ResponsiveGridLayout"};sap.ui.layout.SideContentVisibility={AlwaysShow:"AlwaysShow",ShowAboveL:"ShowAboveL",ShowAboveM:"ShowAboveM",ShowAboveS:"ShowAboveS",NeverShow:"NeverShow"};sap.ui.layout.SideContentFallDown={BelowXL:"BelowXL",BelowL:"BelowL",BelowM:"BelowM",OnMinimumWidth:"OnMinimumWidth"};sap.ui.layout.SideContentPosition={End:"End",Begin:"Begin"};if(!sap.ui.layout.form.FormHelper){sap.ui.layout.form.FormHelper={createLabel:function(t){throw new Error("no Label control available!");},createButton:function(i,p,c){throw new Error("no Button control available!");},setButtonContent:function(b,t,T,i,I){throw new Error("no Button control available!");},addFormClass:function(){return null;},setToolbar:function(t){return t;},bArrowKeySupport:true,bFinal:false};}return sap.ui.layout;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/layout/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/layout/manifest.json":'{\n  "_version": "1.9.0",\n  "sap.app": {\n    "id": "sap.ui.layout",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.52.12"\n    },\n    "title": "SAPUI5 library with layout controls.",\n    "description": "SAPUI5 library with layout controls.",\n    "ach": "CA-UI5-CTR",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "dependencies": {\n      "minUI5Version": "1.52",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.52.12"\n        }\n      }\n    },\n    "library": {\n      "i18n": "messagebundle.properties",\n      "content": {\n        "controls": [\n          "sap.ui.layout.AlignedFlowLayout",\n          "sap.ui.layout.DynamicSideContent",\n          "sap.ui.layout.FixFlex",\n          "sap.ui.layout.Grid",\n          "sap.ui.layout.HorizontalLayout",\n          "sap.ui.layout.ResponsiveFlowLayout",\n          "sap.ui.layout.ResponsiveSplitter",\n          "sap.ui.layout.ResponsiveSplitterPage",\n          "sap.ui.layout.Splitter",\n          "sap.ui.layout.VerticalLayout",\n          "sap.ui.layout.BlockLayoutCell",\n          "sap.ui.layout.BlockLayoutRow",\n          "sap.ui.layout.BlockLayout",\n          "sap.ui.layout.form.Form",\n          "sap.ui.layout.form.FormLayout",\n          "sap.ui.layout.form.GridLayout",\n          "sap.ui.layout.form.ResponsiveGridLayout",\n          "sap.ui.layout.form.ResponsiveLayout",\n          "sap.ui.layout.form.SimpleForm"\n        ],\n        "elements": [\n          "sap.ui.layout.GridData",\n          "sap.ui.layout.ResponsiveFlowLayoutData",\n          "sap.ui.layout.SplitterLayoutData",\n          "sap.ui.layout.form.FormContainer",\n          "sap.ui.layout.form.FormElement",\n          "sap.ui.layout.form.GridContainerData",\n          "sap.ui.layout.PaneContainer",\n          "sap.ui.layout.SplitPane",\n          "sap.ui.layout.form.GridElementData"\n        ],\n        "types": [\n          "sap.ui.layout.BackgroundDesign",\n          "sap.ui.layout.GridIndent",\n          "sap.ui.layout.GridPosition",\n          "sap.ui.layout.GridSpan",\n          "sap.ui.layout.BlockBackgroundType",\n          "sap.ui.layout.form.GridElementCells",\n          "sap.ui.layout.form.SimpleFormLayout"\n        ],\n        "interfaces": []\n      }\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map