/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/ContextBinding","./Context","./lib/_Cache","./lib/_Helper","./lib/_SyncPromise","./ODataParentBinding"],function(q,B,C,a,b,_,c,d,e){"use strict";var s="sap.ui.model.odata.v4.ODataContextBinding",S={change:true,dataReceived:true,dataRequested:true};var O=a.extend("sap.ui.model.odata.v4.ODataContextBinding",{constructor:function(m,p,o,P){var i=p.indexOf("(...)");a.call(this,m,p);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.mAggregatedQueryOptions={};this.oCachePromise=d.resolve();this.mCacheByContext=undefined;this.sGroupId=undefined;this.oOperation=undefined;this.aChildCanUseCachePromises=[];this.sRefreshGroupId=undefined;this.sUpdateGroupId=undefined;if(i>=0){this.oOperation={bAction:undefined,oMetadataPromise:undefined,mParameters:{},sResourcePath:undefined};if(i!==this.sPath.length-5){throw new Error("The path must not continue after a deferred operation: "+this.sPath);}}this.applyParameters(q.extend(true,{},P));this.oElementContext=this.bRelative?null:b.create(this.oModel,this,p);this.setContext(o);m.bindingCreated(this);},metadata:{publicMethods:[]}});e(O.prototype);O.prototype._delete=function(g,E){var t=this;if(this.sPath===""&&this.oContext["delete"]){return this.oContext["delete"](g);}if(this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(g,E,"",function(){t.oElementContext.destroy();t.oElementContext=null;t._fireChange({reason:C.Remove});});};O.prototype._fetchOperationMetadata=function(){var m=this.oModel.getMetaModel(),o,p;if(!this.oOperation.oMetadataPromise){p=this.sPath.lastIndexOf("/");o=this.sPath.slice(p+1,-5);this.oOperation.oMetadataPromise=m.fetchObject("/"+o).then(function(M){if(!M){throw new Error("Unknown operation: "+o);}if(Array.isArray(M)&&M[0].$kind==="Action"){return M;}if(Array.isArray(M)&&M[0].$kind==="Function"){throw new Error("Functions without import not supported: "+o);}if(M.$kind==="ActionImport"){return m.fetchObject("/"+M.$Action);}if(M.$kind==="FunctionImport"){return m.fetchObject("/"+M.$Function);}throw new Error("Not an operation: "+o);}).then(function(f){if(f.length!==1){throw new Error("Unsupported operation overloading: "+o);}return f[0];});}return this.oOperation.oMetadataPromise;};O.prototype.applyParameters=function(p,f){var o;this.mQueryOptions=this.oModel.buildQueryOptions(p,true);o=this.oModel.buildBindingParameters(p,["$$groupId","$$updateGroupId"]);this.sGroupId=o.$$groupId;this.sUpdateGroupId=o.$$updateGroupId;this.mParameters=p;if(!this.oOperation){this.fetchCache(this.oContext);if(f){this.refreshInternal(undefined,true);}else{this.checkUpdate();}}else if(this.oOperation.bAction===false){this.execute();}};O.prototype.attachEvent=function(E){if(!(E in S)){throw new Error("Unsupported event '"+E+"': v4.ODataContextBinding#attachEvent");}return a.prototype.attachEvent.apply(this,arguments);};O.prototype.deregisterChange=function(p,l){var o;if(!this.oCachePromise.isFulfilled()){return;}o=this.oCachePromise.getResult();if(o){o.deregisterChange(p,l);}else if(this.oContext){this.oContext.deregisterChange(c.buildPath(this.sPath,p),l);}};O.prototype.destroy=function(){if(this.oElementContext){this.oElementContext.destroy();}this.oModel.bindingDestroyed(this);this.oCachePromise=undefined;this.oContext=undefined;a.prototype.destroy.apply(this);};O.prototype.doCreateCache=function(r,Q){return _.createSingle(this.oModel.oRequestor,r,Q,this.oModel.bAutoExpandSelect);};O.prototype.doFetchQueryOptions=function(){return d.resolve(this.mQueryOptions);};O.prototype.execute=function(g){var t=this;function f(o,p){var h,i,j,k,P,l,Q=q.extend({},t.oModel.mUriParameters,t.mQueryOptions);g=g||t.getGroupId();t.oOperation.bAction=o.$kind==="Action";if(t.oOperation.bAction){h=_.createSingle(t.oModel.oRequestor,(p+t.sPath).slice(1,-5),Q,t.oModel.bAutoExpandSelect,true);if(t.bRelative&&t.oContext.getBinding){i=t.sPath.lastIndexOf("/");l=t.oContext.fetchValue(i>=0?t.sPath.slice(0,i):"").then(function(E){return E["@odata.etag"];});}else{l=d.resolve();}l=l.then(function(E){return h.post(g,t.oOperation.mParameters,E);});}else{j=o.$Parameter;P=[];if(j){j.forEach(function(m){var n=m.$Name;if(n in t.oOperation.mParameters){if(m.$IsCollection){throw new Error("Unsupported: collection parameter");}P.push(encodeURIComponent(n)+"="+encodeURIComponent(c.formatLiteral(t.oOperation.mParameters[n],m.$Type)));}});}k=(p+t.sPath.replace("...",P.join(','))).slice(1);h=_.createSingle(t.oModel.oRequestor,k,Q,t.oModel.bAutoExpandSelect);l=h.fetchValue(g);}t.oCachePromise=d.resolve(h);return l;}this.oModel.checkGroupId(g);if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(this.bRelative){if(!this.oContext){throw new Error("Unresolved binding: "+this.sPath);}if(this.oContext.isTransient&&this.oContext.isTransient()){throw new Error("Execute for transient context not allowed: "+this.oModel.resolve(this.sPath,this.oContext));}if(this.oContext.getPath().indexOf("(...)")>=0){throw new Error("Nested deferred operation bindings not supported: "+this.oModel.resolve(this.sPath,this.oContext));}}return this._fetchOperationMetadata().then(function(o){if(t.bRelative){if(!t.oContext.getBinding){return f(o,t.oContext.getPath()==="/"?"/":t.oContext.getPath()+"/");}return t.getContext().fetchCanonicalPath().then(function(p){return f(o,p+"/");});}return f(o,"");}).then(function(r){t._fireChange({reason:C.Change});t.oModel.getDependentBindings(t).forEach(function(D){D.refreshInternal(g,true);});})["catch"](function(E){t.oModel.reportError("Failed to execute "+t.sPath,s,E);throw E;});};O.prototype.fetchValue=function(p,l){var t=this;return this.oCachePromise.then(function(o){var D=false,g,r;if(o){r=t.getRelativePath(p);if(r!==undefined){g=t.sRefreshGroupId||t.getGroupId();t.sRefreshGroupId=undefined;return o.fetchValue(g,r,function(){D=true;t.fireDataRequested();},l).then(function(v){if(D){t.fireDataReceived();}return v;},function(E){if(D){t.oModel.reportError("Failed to read path "+t.sPath,s,E);t.fireDataReceived(E.canceled?undefined:{error:E});}throw E;});}}if(!t.oOperation&&t.oContext&&t.oContext.fetchValue){return t.oContext.fetchValue(p,l);}});};O.prototype.refreshInternal=function(g,f){var t=this;this.oCachePromise.then(function(o){if(!t.oElementContext){t.oElementContext=b.create(t.oModel,t,t.oModel.resolve(t.sPath,t.oContext));if(!o){t._fireChange({reason:C.Refresh});}}if(!t.oOperation){if(o){t.fetchCache(t.oContext);t.sRefreshGroupId=g;t.mCacheByContext=undefined;}t.oModel.getDependentBindings(t).forEach(function(D){D.refreshInternal(g,f);});}else if(t.oOperation.bAction===false){t.execute(g);}});};O.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative&&(this.oContext||o)){if(this.oElementContext){this.oElementContext.destroy();this.oElementContext=null;}this.fetchCache(o);if(o){this.oElementContext=b.create(this.oModel,this,this.oModel.resolve(this.sPath,o));}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};O.prototype.setParameter=function(p,v){if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(v===undefined){throw new Error("Missing value for parameter: "+p);}this.oOperation.mParameters[p]=v;this.oOperation.bAction=undefined;return this;};O.prototype.toString=function(){return s+": "+(this.bRelative?this.oContext+"|":"")+this.sPath;};return O;});
