/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["./_Helper"],function(_){"use strict";var M,a={"AnnotationPath":{__postProcessor:t},"Binary":{__postProcessor:t},"Bool":{__postProcessor:t},"Date":{__postProcessor:t},"DateTimeOffset":{__postProcessor:t},"Decimal":{__postProcessor:t},"Duration":{__postProcessor:t},"EnumMember":{__postProcessor:t},"Float":{__postProcessor:t},"Guid":{__postProcessor:t},"Int":{__postProcessor:t},"LabeledElementReference":{__postProcessor:s},"NavigationPropertyPath":{__postProcessor:t},"Path":{__postProcessor:t},"PropertyPath":{__postProcessor:t},"String":{__postProcessor:t},"TimeOfDay":{__postProcessor:t}},e=[a],A={"Annotation":{__processor:C,__postProcessor:l,__include:e}},b=[a,A],o={__processor:B,__postProcessor:y,__include:b},c={"And":o,"Apply":{__processor:B,__postProcessor:m,__include:b},"Cast":{__processor:B,__postProcessor:n,__include:b},"Collection":{__postProcessor:q,__include:e},"Eq":o,"Ge":o,"Gt":o,"If":o,"IsOf":{__processor:B,__postProcessor:n,__include:b},"LabeledElement":{__processor:B,__postProcessor:r,__include:b},"Le":o,"Lt":o,"Ne":o,"Null":{__processor:B,__postProcessor:v,__include:[A]},"Not":{__processor:B,__postProcessor:u,__include:b},"Or":o,"Record":{__processor:B,__postProcessor:x,__include:[A],"PropertyValue":{__processor:E,__postProcessor:w,__include:b}},"UrlRef":{__postProcessor:z,__include:e}},d={"Annotations":{__processor:D,__include:[A]}};e.push(c);b.push(c);A.Annotation.Annotation=A.Annotation;function g(T,V,j){var i,F,G;switch(T){case"AnnotationPath":case"NavigationPropertyPath":case"Path":case"PropertyPath":V=M.resolveAliasInPath(V,j);case"Binary":case"Date":case"DateTimeOffset":case"Decimal":case"Duration":case"Guid":case"TimeOfDay":case"UrlRef":F={};F["$"+T]=V;return F;case"Bool":return V==="true";case"EnumMember":G=V.trim().replace(/ +/g," ").split(" ");for(i=0;i<G.length;i++){G[i]=M.resolveAliasInPath(G[i],j);}return{$EnumMember:G.join(" ")};case"Float":if(V==="NaN"||V==="INF"||V==="-INF"){return{$Float:V};}return parseFloat(V);case"Int":F=parseInt(V,10);return _.isSafeInteger(F)?F:{$Int:V};case"String":return V;default:return undefined;}}function f(j,F){var G,H=j.attributes,i,V;for(i=H.length-1;i>=0;i--){G=H.item(i);V=g(G.name,G.value,F);if(V!==undefined){return V;}}return true;}function p(i,j){var I=M.getOrCreateArray(j.reference,"$Include");I.push(i.getAttribute("Namespace")+".");}function h(i,j){var R=j.reference,I={"$TermNamespace":i.getAttribute("TermNamespace")+"."},F=M.getOrCreateArray(R,"$IncludeAnnotations");M.processAttributes(i,I,{"TargetNamespace":function setValue(V){return V?V+".":V;},"Qualifier":M.setValue});F.push(I);}function k(i,j){var R=M.getOrCreateObject(j.result,"$Reference");j.reference=R[i.getAttribute("Uri")]={};M.annotatable(j,j.reference);}function l(i,R,j){var F=j.annotatable.parent;F.target[F.qualifiedName]=R.length?R[0]:f(i,j);}function m(i,R,j){var F=j.annotatable.target;F.$Apply=R;F.$Function=M.resolveAlias(i.getAttribute("Function"),j);return F;}function n(i,R,j){var N=i.localName,F=j.annotatable.target;F["$"+N]=R[0];j.processTypedCollection(i.getAttribute("Type"),F,j);j.processFacetAttributes(i,F);return F;}function q(i,R,j){return R;}function r(i,R,j){var F=j.annotatable.target;F.$LabeledElement=R.length?R[0]:f(i,j);F.$Name=i.getAttribute("Name");return F;}function s(i,R,j){return{"$LabeledElementReference":M.resolveAlias(i.textContent,j)};}function t(i,R,j){return g(i.localName,i.textContent,j);}function u(i,R,j){var F=j.annotatable.target;F.$Not=R[0];return F;}function v(i,R,j){var F=j.annotatable,G=null;if(F.qualifiedName){G=F.target;G.$Null=null;}return G;}function w(i,R,j){return{property:i.getAttribute("Property"),value:R.length?R[0]:f(i,j)};}function x(j,R,F){var i,P,G=F.annotatable.target,T=j.getAttribute("Type");if(T){G.$Type=M.resolveAlias(T,F);}for(i=0;i<R.length;i++){P=R[i];G[P.property]=P.value;}return G;}function y(i,R,j){var F=j.annotatable.target;F["$"+i.localName]=R;return F;}function z(i,R){return{$UrlRef:R[0]};}function B(i,j){M.annotatable(j,{});}function C(i,j){var F=j.annotatable,G,Q=F.prefix+"@"+M.resolveAlias(i.getAttribute("Term"),j),H=F.qualifier||i.getAttribute("Qualifier");if(H){Q+="#"+H;}if(typeof F.target==="string"){G=M.getOrCreateObject(j.schema,"$Annotations");F.target=G[F.target]={};}F.qualifiedName=Q;F.target[Q]=true;M.annotatable(j,F.target,Q);}function D(i,j){M.annotatable(j,M.resolveAliasInPath(i.getAttribute("Target"),j),undefined,i.getAttribute("Qualifier"));}function E(i,j){M.annotatable(j,j.annotatable.target,i.getAttribute("Property"));}M={oAnnotationConfig:A,oAnnotationsConfig:d,oReferenceInclude:{"Reference":{__processor:k,__include:[A],"Include":{__processor:p},"IncludeAnnotations":{__processor:h}}},rCollection:/^Collection\((.*)\)$/,annotatable:function(i,T,P,Q){var j,F,G;if(typeof T==="string"){j=i.annotatable;T=_.buildPath(j.path,T);G=T;F=i.schema.$Annotations;if(F&&F[T]){T=F[T];}}i.annotatable={parent:i.annotatable,path:G,prefix:P||"",qualifiedName:undefined,qualifier:Q,target:T};},getOrCreateArray:function(P,i){var R=P[i];if(!R){R=P[i]=[];}return R;},getOrCreateObject:function(P,i){var R=P[i];if(!R){R=P[i]={};}return R;},processAlias:function(i,j){var F=i.getAttribute("Alias");if(F){j.aliases[F]=i.getAttribute("Namespace")+".";}},processAttributes:function(i,T,j){var P;for(P in j){var V=j[P](i.getAttribute(P));if(V!==undefined&&V!==null){T["$"+P]=V;}}},processSchema:function(i,j){j.namespace=i.getAttribute("Namespace")+".";j.result[j.namespace]=j.schema={"$kind":"Schema"};M.annotatable(j,j.schema);},resolveAlias:function(N,i){var j=N.indexOf("."),F;if(j>=0&&N.indexOf(".",j+1)<0){F=i.aliases[N.slice(0,j)];if(F){return F+N.slice(j+1);}}return N;},resolveAliasInPath:function(P,j){var F,i,S,T="";if(P.indexOf(".")<0){return P;}F=P.indexOf("@");if(F>=0){T="@"+M.resolveAlias(P.slice(F+1),j);P=P.slice(0,F);}S=P.split("/");for(i=0;i<S.length;i++){S[i]=M.resolveAlias(S[i],j);}return S.join("/")+T;},resolveTargetPath:function(P,i){var S;if(!P){return P;}P=M.resolveAliasInPath(P,i);S=P.indexOf("/");if(S>=0&&P.indexOf("/",S+1)<0){if(P.slice(0,S)===i.result.$EntityContainer){return P.slice(S+1);}}return P;},setIfFalse:function(V){return V==="false"?false:undefined;},setIfTrue:function(V){return V==="true"?true:undefined;},setNumber:function(V){return V?parseInt(V,10):undefined;},setValue:function(V){return V;},traverse:function(F,G,H){var I=G.annotatable,J,K=F.childNodes,L,N,i,O,j,P,R,Q=[];if(H.__processor){H.__processor(F,G);}for(i=0;i<K.length;i++){L=K.item(i);if(L.nodeType===1){P=L.localName;J=H[P];if(!J&&H.__include){O=H.__include;for(j=0;j<O.length;j++){J=O[j][P];if(J){break;}}}if(J){N=M.traverse(L,G,J);if(N!==undefined&&H.__postProcessor){Q.push(N);}}}}if(H.__postProcessor){R=H.__postProcessor(F,Q,G);}G.annotatable=I;return R;}};return M;},false);
