/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject'],function(M){"use strict";var S=M.extend("sap.ui.rta.command.Stack",{metadata:{library:"sap.ui.rta",properties:{},aggregations:{commands:{type:"sap.ui.rta.command.BaseCommand",multiple:true}},events:{modified:{},commandExecuted:{parameters:{command:{type:"object"},undo:{type:"boolean"}}}}}});S.prototype._toBeExecuted=-1;S.prototype._oLastCommand=Promise.resolve();S.prototype._getCommandToBeExecuted=function(){return this.getCommands()[this._toBeExecuted];};S.prototype.pushExecutedCommand=function(c){this.push(c,true);};S.prototype.push=function(c,e){if(this._bUndoneCommands){this._bUndoneCommands=false;while(this._toBeExecuted>-1){this.pop();}}this.insertCommand(c,0);if(!e){this._toBeExecuted++;}this.fireModified();};S.prototype.top=function(){return this.getCommands()[0];};S.prototype.pop=function(){if(this._toBeExecuted>-1){this._toBeExecuted--;}return this.removeCommand(0);};S.prototype.removeCommand=function(o,s){var r=this.removeAggregation("commands",o,s);this.fireModified();return r;};S.prototype.removeAllCommands=function(s){var c=this.removeAllAggregation("commands",s);this._toBeExecuted=-1;this.fireModified();return c;};S.prototype.isEmpty=function(){return this.getCommands().length===0;};S.prototype.execute=function(){this._oLastCommand=this._oLastCommand.catch(function(){}).then(function(){var c=this._getCommandToBeExecuted();if(c){return c.execute().then(function(){this._toBeExecuted--;this.fireCommandExecuted({command:c,undo:false});this.fireModified();}.bind(this)).catch(function(e){this.pop();return Promise.reject(e);}.bind(this));}}.bind(this));return this._oLastCommand;};S.prototype._unExecute=function(){if(this.canUndo()){this._bUndoneCommands=true;this._toBeExecuted++;var c=this._getCommandToBeExecuted();if(c){return c.undo().then(function(){this.fireCommandExecuted({command:c,undo:true});this.fireModified();}.bind(this));}else{return Promise.resolve();}}else{return Promise.resolve();}};S.prototype.canUndo=function(){return(this._toBeExecuted+1)<this.getCommands().length;};S.prototype.undo=function(){return this._unExecute();};S.prototype.canRedo=function(){return!!this._getCommandToBeExecuted();};S.prototype.redo=function(){return this.execute();};S.prototype.pushAndExecute=function(c){this.push(c);return this.execute();};S.prototype.getAllExecutedCommands=function(){var a=[];var c=this.getCommands();for(var i=c.length-1;i>this._toBeExecuted;i--){var s=this.getSubCommands(c[i]);a=a.concat(s);}return a;};S.prototype.getSubCommands=function(c){var C=[];if(c.getCommands){c.getCommands().forEach(function(s){var a=this.getSubCommands(s);C=C.concat(a);},this);}else{C.push(c);}return C;};return S;},true);
