/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/UIComponent","sap/ui/core/ComponentContainer","sap/ui/core/mvc/XMLView","sap/ui/rta/command/CommandFactory","sap/ui/dt/DesignTime","sap/ui/dt/ElementUtil","sap/ui/dt/OverlayRegistry","sap/ui/dt/ElementDesignTimeMetadata","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence","sap/ui/model/Model",'sap/ui/fl/FlexControllerFactory','sap/ui/rta/ControlTreeModifier',"sap/ui/fl/library",'sap/ui/thirdparty/sinon','sap/ui/thirdparty/sinon-ie','sap/ui/thirdparty/sinon-qunit'],function(U,C,X,a,D,E,O,b,c,d,M,F,e){"use strict";var f=function(m,o){if(f._only&&(m.indexOf(f._only)<0)){return;}QUnit.module(m,{});QUnit.test("When using the 'controlEnablingCheck' function to test if your control is ready for UI adaptation at runtime",function(k){k.ok(o.afterAction,"then you implement a function to check if your action has been successful: See the afterAction parameter.");k.ok(o.afterUndo,"then you implement a function to check if the undo has been successful: See the afterUndo parameter.");k.ok(o.afterRedo,"then you implement a function to check if the redo has been successful: See the afterRedo parameter.");k.ok(o.xmlView,"then you provide an XML view to test on: See the.xmlView parameter.");var x=new DOMParser().parseFromString(o.xmlView,"application/xml").documentElement;k.ok(x.tagName.match("View$"),"then you use the sap.ui.core.mvc View tag as the first tag in your view");k.ok(o.action,"then you provide an action: See the action parameter.");k.ok(o.action.name,"then you provide an action name: See the action.name parameter.");k.ok(o.action.controlId,"then you provide the id of the control to operate the action on: See the action.controlId.");});var g="sap.ui.rta.control.enabling.comp";var S=false;var A=true;var h=U.extend(g,{metadata:{manifest:{"sap.app":{"id":g,"type":"application"}}},createContent:function(){var v=sap.ui.xmlview({id:this.createId("view"),viewContent:o.xmlView,async:this.getComponentData().async||false});return v;}});function i(k){this.oUiComponent=new h({id:"comp",componentData:{async:k}});this.oUiComponentContainer=new C({component:this.oUiComponent});this.oUiComponentContainer.placeAt(o.placeAt||"content");this.oView=this.oUiComponent.getRootControl();if(o.model instanceof M){this.oView.setModel(o.model);}sap.ui.getCore().applyChanges();}function j(k){this.oControl=this.oView.byId(o.action.controlId);return E.loadDesignTimeMetadata(this.oControl).then(function(l){var p;if(o.action.parameter){if(typeof o.action.parameter==="function"){p=o.action.parameter(this.oView);}else{p=o.action.parameter;}}else{p={};}sap.ui.getCore().applyChanges();this.oDesignTime=new D({rootElements:[this.oView]});return new Promise(function(r){this.oDesignTime.attachEventOnce("synced",function(){this.oControlOverlay=O.getOverlay(this.oControl);var n=new a({flexSettings:{layer:o.layer||"CUSTOMER"}});var q=this.oControlOverlay.getDesignTimeMetadata();if(o.action.name==="move"){var s=O.getOverlay(p.movedElements[0].element);var R=s.getRelevantContainer();this.oControl=R;q=s.getParentAggregationOverlay().getDesignTimeMetadata();}else if(o.action.name==="addODataProperty"){var t=q.getAggregationAction("addODataProperty",this.oControl);k.equal(t.length,1,"there should be only one aggregation with the possibility to do addODataProperty action");var u=this.oControlOverlay.getAggregationOverlay(t[0].aggregation);q=u.getDesignTimeMetadata();}this.oCommand=n.getCommandFor(this.oControl,o.action.name,p,q);k.ok(this.oCommand,"then the registration for action to change type, the registration for change and control type to change handler is available and "+o.action.name+" is a valid action");r();}.bind(this));}.bind(this));}.bind(this));}if(!o.jsOnly){QUnit.module(m+" on async views",{afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();this.oCommand.destroy();}});QUnit.test("When applying the change directly on the XMLView",function(k){var l=[];this.stub(d.prototype,"getChangesForComponent").returns(Promise.resolve(l));this.stub(d.prototype,"getCacheKey").returns(Promise.resolve("etag-123"));i.call(this,S);return j.call(this,k).then(function(){var n=this.oCommand.getPreparedChange();l.push(n);this.oUiComponentContainer.destroy();i.call(this,A);}.bind(this)).then(function(){return this.oView.loaded();}.bind(this)).then(function(v){o.afterAction(this.oUiComponent,v,k);}.bind(this));});}QUnit.module(m,{beforeEach:function(k){i.call(this,S);return j.call(this,k);},afterEach:function(){this.oUiComponentContainer.destroy();this.oDesignTime.destroy();this.oCommand.destroy();}});QUnit.test("When executing the underlying command on the control at runtime",function(k){var l=k.async();this.oCommand.execute().then(function(){sap.ui.getCore().applyChanges();o.afterAction(this.oUiComponent,this.oView,k);l();}.bind(this));});QUnit.test("When executing and undoing the command",function(k){var l=k.async();this.oCommand.execute().then(this.oCommand.undo.bind(this.oCommand)).then(function(){var n=this.oCommand.getPreparedChange();if(this.oCommand.getAppComponent){var p=this.oCommand.getAppComponent();var q=e.bySelector(n.getSelector(),p);var r=F.createForControl(p);r.removeFromAppliedChangesOnControl(n,p,q);}}.bind(this)).then(function(){sap.ui.getCore().applyChanges();o.afterUndo(this.oUiComponent,this.oView,k);l();}.bind(this));});QUnit.test("When executing, undoing and redoing the command",function(k){var l=k.async();this.oCommand.execute().then(this.oCommand.undo.bind(this.oCommand)).then(function(){var n=this.oCommand.getPreparedChange();if(this.oCommand.getAppComponent){var p=this.oCommand.getAppComponent();var q=e.bySelector(n.getSelector(),p);var r=F.createForControl(p);return r.removeFromAppliedChangesOnControl(n,p,q);}}.bind(this)).then(this.oCommand.execute.bind(this.oCommand)).then(function(){sap.ui.getCore().applyChanges();o.afterRedo(this.oUiComponent,this.oView,k);l();}.bind(this));});};f.skip=function(){};f.only=function(m){f._only=m;};return f;});
