/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ui/external/ElementTree","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/ui/models/formatter","sap/ui/support/supportRules/Constants"],function($,C,J,a,S,E,I,c,f,b){"use strict";var i={severityIcons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return C.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1000,formatter:f,onInit:function(){this.model=S;this.setCommunicationSubscriptions();this.getView().setModel(this.model);this.clearFilters();this._initElementTree();this.treeTable=this.getView().byId("issuesList");this.issueTable=this.getView().byId("issueTable");},setCommunicationSubscriptions:function(){a.subscribe(c.ON_ANALYZE_FINISH,function(d){var t=this;var p={};t.data=d;d.issues.forEach(function(e){if(!e.context||!e.context.id){return;}if(!p[e.context.id]){p[e.context.id]=[e.name];}else{p[e.context.id].push(e.name);}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",d.issues);this.model.setProperty('/analyzePressed',true);this.model.setProperty("/issuesCount",this.data.issues.length);this.model.setProperty("/selectedIssue","");this.elementTree.setData({controls:d.elementTree,issuesIds:p});this.clearFilters();},this);a.subscribe(c.GET_ISSUES,function(d){this.structuredIssuesModel=d.groupedIssues;this.model.setProperty("/issues",d.issuesModel);if(d.issuesModel[0]){this._setSelectedRule(d.issuesModel[0][0]);this.treeTable.setSelectedIndex(1);this.issueTable.setSelectedIndex(0);}},this);},_initElementTree:function(){var t=this;this.elementTree=new E(null,{onIssueCountClicked:function(s){t.clearFilters();t.model.setProperty("/elementFilter",s);t.updateIssuesVisibility();},onHoverChanged:function(h){a.publish(c.TREE_ELEMENT_MOUSE_ENTER,h);},onMouseOut:function(){a.publish(c.TREE_ELEMENT_MOUSE_OUT);}});},onAfterRendering:function(){this.elementTree.setContainerId(this.getView().byId("elementTreeContainer").getId());},clearFilters:function(){this.model.setProperty("/severityFilter","All");this.model.setProperty("/categoryFilter","All");this.model.setProperty("/elementFilter","All");this.model.setProperty("/audienceFilter","All");if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight();}this.updateIssuesVisibility();},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection();},onIssuePressed:function(e){var s=this.model.getProperty("/selectedIssue");this.elementTree.setSelectedElement(s.context.id,false);},onRowSelectionChanged:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();if(s.type==="rule"){this._setSelectedRule(s);}else{this.model.setProperty("/selectedIssue","");}if(s.issueCount<4){this._setPropertiesOfResponsiveDetailsAndTable("Fixed","inherit");this.model.setProperty("/visibleRowCount",4);}else{this._setPropertiesOfResponsiveDetailsAndTable("Auto","5rem");}}},openDocumentation:function(e){var l=sap.ui.getCore().byId(e.mParameters.id),u=l.getBindingContext().getProperty("href");a.publish(c.OPEN_URL,u);},updateIssuesVisibility:function(){if(this.data){var d=this.data.issues.filter(this.filterIssueListItems,this);a.publish(c.REQUEST_ISSUES,d);this.model.setProperty("/visibleIssuesCount",d.length);}this.setToolbarHeight();},filterIssueListItems:function(d){var s=this.model.getProperty("/severityFilter"),e=d.severity===s||s==='All',g=this.model.getProperty("/categoryFilter"),h=$.inArray(g,d.categories)>-1||g==='All',j=this.model.getProperty("/elementFilter"),k=j===d.context.id||j==='All',l=this.model.getProperty("/audienceFilter"),m=$.inArray(l,d.audiences)>-1||l==='All';return e&&h&&k&&m;},setToolbarHeight:function(){this.model.setProperty("/filterBarHeight","4rem");},onReportPress:function(e){var o=e.getParameter("item"),d=o.getText(),g=this._getReportData();if(d==='View'){a.publish(c.ON_SHOW_REPORT_REQUEST,g);}else{a.publish(c.ON_DOWNLOAD_REPORT_REQUEST,g);}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")};},onRowSelection:function(e){if(e.getParameter("rowContext")){var s=e.getParameter("rowContext").getObject();this.elementTree.setSelectedElement(s.context.id,false);this.model.setProperty("/selectedIssue/details",s.details);}},_setSelectedRule:function(s){var d,e;if(this.model.getProperty("/visibleIssuesCount")>0){d=this.structuredIssuesModel[s.ruleLibName][s.ruleId];e=jQuery.extend(true,{},s);e.issues=d;e.resolutionUrls=d[0].resolutionUrls;this.issueTable.setSelectedIndex(0);this.model.setProperty("/selectedIssue/details",e.details);this.model.setProperty("/selectedIssue",e);this._setIconAndColorToIssue(e.issues);}else{this.model.setProperty("/selectedIssue","");}},_setIconAndColorToIssue:function(d){d.forEach(function(e){switch(e.severity){case b.SUPPORT_ASSISTANT_ISSUE_SEVERITY_LOW:e.severityIcon=i.severityIcons.Low;e.severityColor=b.SUPPORT_ASSISTANT_SEVERITY_LOW_COLOR;break;case b.SUPPORT_ASSISTANT_ISSUE_SEVERITY_MEDIUM:e.severityIcon=i.severityIcons.Medium;e.severityColor=b.SUPPORT_ASSISTANT_SEVERITY_MEDIUM_COLOR;break;case b.SUPPORT_ASSISTANT_ISSUE_SEVERITY_HIGH:e.severityIcon=i.severityIcons.High;e.severityColor=b.SUPPORT_ASSISTANT_SEVERITY_HIGH_COLOR;break;}});},_setPropertiesOfResponsiveDetailsAndTable:function(v,h){this.model.setProperty("/visibleRowCountMode",v);this.model.setProperty("/heightDetailsArea",h);}});});
