/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/Icon','sap/ui/unified/Menu','sap/ui/core/Popup','jquery.sap.keycodes'],function(q,C,l,I,M,P){"use strict";var R=C.extend("sap.ui.table.RowAction",{metadata:{library:"sap.ui.table",properties:{visible:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.table.RowActionItem",multiple:true},_icons:{type:"sap.ui.core.Icon",multiple:true,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{}}});R.prototype.init=function(){var s=function(T){this.setAggregation("tooltip",T,true);this.setSrc(this.getSrc());return this;};var o=function(e){this._bKeyboard=e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER;I.prototype.onkeyup.apply(this,arguments);};var t=this;var i=new I(this.getId()+"-icon0",{decorative:false,press:function(e){t._handlePress(e,true);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);i=new I(this.getId()+"-icon1",{decorative:false,press:function(e){t._handlePress(e,false);}});i.addStyleClass("sapUiTableActionIcon");i.setTooltip=s;i.onkeyup=o;this.addAggregation("_icons",i);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");this._iLen=0;this._iCount=2;this._aActions=["",""];this._iLastCloseTime=0;};R.prototype.onAfterRendering=function(){this._updateIcons();};R.prototype.setVisible=function(v){this.setProperty("visible",v,true);this.$().toggleClass("sapUiTableActionHidden",!v);return this;};R.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);var T=this.getTooltip_AsString();if(!T){this.$().removeAttr("title");}else{this.$().attr("title",T);}return this;};R.prototype.insertItem=function(i,a){this.insertAggregation("items",i,a,true);this._updateIcons(true);return this;};R.prototype.addItem=function(i){this.addAggregation("items",i,true);this._updateIcons(true);return this;};R.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);this._updateIcons(true);return r;};R.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",true);this._updateIcons(true);return r;};R.prototype.destroyItems=function(){this.destroyAggregation("items",true);this._updateIcons(true);return this;};R.prototype.getAccessibilityInfo=function(){var p=this.$().parent();var a=this.getVisible()&&this._iLen>0&&this._iCount>0&&!p.hasClass("sapUiTableRowHidden")&&!p.hasClass("sapUiTableGroupHeader")&&!p.hasClass("sapUiAnalyticalTableSum");var t;if(a){t=this._oResBundle.getText(this._iLen==1?"TBL_ROW_ACTION_SINGLE_ACTION":"TBL_ROW_ACTION_MULTIPLE_ACTION",[this._iLen]);}else{t=this._oResBundle.getText("TBL_ROW_ACTION_NO_ACTION");}return{focusable:a,enabled:a,description:t};};R.prototype._getVisibleItems=function(f){if(!this._aVisibleItems||f){this._aVisibleItems=[];this._iLen=0;var a=this.getItems();for(var i=0;i<a.length;i++){if(a[i].getVisible()){this._aVisibleItems.push(a[i]);this._iLen++;}}}return this._aVisibleItems;};R.prototype._getRow=function(){return this.getParent();};R.prototype._getCount=function(){return this._iCount;};R.prototype._setCount=function(c){if(c<0){this._iCount=0;}else if(c>=0){this._iCount=Math.min(c,2);}this._updateIcons();};R.prototype._setFixedLayout=function(f){this._bFixedLayout=!!f;this._updateIcons();};R.prototype._setIconLabel=function(L){var a=this.getAggregation("_icons");for(var i=0;i<a.length;i++){a[i].removeAllAriaLabelledBy();if(L){a[i].addAriaLabelledBy(L);}}};R.prototype._handlePress=function(e,f){var a=f?0:1;var o=this.getAggregation("_icons")[a];var A=this._aActions[a];var k=o._bKeyboard;o._bKeyboard=false;if(A=="action"){this._getVisibleItems()[a]._doFirePress();}else if(A=="action_fixed"){this._getVisibleItems()[0]._doFirePress();}else if(A=="menu"){var m=this.getAggregation("_menu");if(!m){m=new M();this.setAggregation("_menu",m,true);m.getPopup().attachClosed(function(){this._iLastCloseTime=Date.now();},this);}m.removeAllItems();if(Date.now()-this._iLastCloseTime<500){return;}var b=this.getItems();for(var i=f?0:1;i<b.length;i++){m.addItem(b[i]._getMenuItem());}m.open(!!k,o,P.Dock.EndTop,P.Dock.EndBottom,o);}};R.prototype._updateIcons=function(f){var i=this._getVisibleItems(f);var a=this.getAggregation("_icons");var $=this.$().children();function s(b){a[0].$()[b==0?"attr":"removeAttr"]("aria-haspopup",b==0?"true":undefined);a[1].$()[b==1?"attr":"removeAttr"]("aria-haspopup",b==1?"true":undefined);}if(this._bFixedLayout&&this._iLen==1&&this._iCount==2){var A=this.getItems();if(A.length>1&&i[0]===A[1]){i[0]._syncIcon(a[1]);q($.get(0)).toggleClass("sapUiTableActionHidden",true);q($.get(1)).toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["","action_fixed"];return;}}if(this._iLen==0||this._iCount==0){$.toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["",""];}else if(this._iLen==1&&this._iCount>0){i[0]._syncIcon(a[0]);q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(-1);this._aActions=["action",""];}else if(this._iLen==2&&this._iCount==2){i[0]._syncIcon(a[0]);i[1]._syncIcon(a[1]);$.toggleClass("sapUiTableActionHidden",false);s(-1);this._aActions=["action","action"];}else if(this._iLen>2&&this._iCount==2){i[0]._syncIcon(a[0]);a[1].setSrc("sap-icon://overflow");a[1].setTooltip(this._oResBundle.getText("TBL_ROW_ACTION_MORE"));$.toggleClass("sapUiTableActionHidden",false);s(1);this._aActions=["action","menu"];}else{a[0].setSrc("sap-icon://overflow");a[0].setTooltip(this._oResBundle.getText("TBL_ROW_ACTION_MORE"));q($.get(0)).toggleClass("sapUiTableActionHidden",false);q($.get(1)).toggleClass("sapUiTableActionHidden",true);s(0);this._aActions=["menu",""];}};return R;});
