/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/core/Element','./library','sap/ui/unified/MenuItem'],function(E,l,M){"use strict";var R=l.RowActionType;var I=E.extend("sap.ui.table.RowActionItem",{metadata:{library:"sap.ui.table",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Misc",defaultValue:true},text:{type:"string",group:"Misc",defaultValue:""},type:{type:"sap.ui.table.RowActionType",group:"Behavior",defaultValue:R.Custom}},events:{press:{item:{type:"sap.ui.table.RowActionItem"},row:{type:"sap.ui.table.Row"}}}}});I.prototype.exit=function(){if(this._menuItem){this._menuItem.destroy();this._menuItem=null;}};I.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._updateRowAction();return this;};I.prototype.setText=function(t){this.setProperty("text",t,true);this._updateRowAction();return this;};I.prototype.setType=function(t){this.setProperty("type",t,true);this._updateRowAction();return this;};I.prototype.setVisible=function(v){this.setProperty("visible",v,true);this._updateRowAction(true);return this;};I.prototype.setTooltip=function(t){this.setAggregation("tooltip",t,true);this._updateRowAction();return this;};I.prototype._doFirePress=function(){var p=this.getParent();this.firePress({item:this,row:p&&p._getRow?p._getRow():null});};I.prototype._getMenuItem=function(){if(!this._menuItem){var t=this;this._menuItem=new M({select:function(e){t._doFirePress();}});}this._menuItem.setIcon(this._getIcon());this._menuItem.setVisible(this.getVisible());this._menuItem.setText(this._getText(false));return this._menuItem;};I.prototype._getIcon=function(){var i=this.getIcon();if(i){return i;}if(this.getType()==R.Navigation){return"sap-icon://navigation-right-arrow";}if(this.getType()==R.Delete){return"sap-icon://sys-cancel";}return null;};I.prototype._getText=function(p){var t=p?(this.getTooltip_AsString()||this.getText()):(this.getText()||this.getTooltip_AsString());if(t){return t;}if(this.getType()==R.Navigation){return this.getParent()._oResBundle.getText("TBL_ROW_ACTION_NAVIGATE");}if(this.getType()==R.Delete){return this.getParent()._oResBundle.getText("TBL_ROW_ACTION_DELETE");}return null;};I.prototype._syncIcon=function(i){i.setSrc(this._getIcon());i.setTooltip(this._getText(true));};I.prototype._updateRowAction=function(f){var p=this.getParent();if(p&&p._updateIcons){p._updateIcons(f);}};return I;});
