/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/Device'],function(q,C,a,D,M,Y,b,l,c){"use strict";var d=a.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{calendarPicker:{type:"sap.ui.unified.Calendar",multiple:false,visibility:"hidden"}}}});d.prototype.init=function(){a.prototype.init.apply(this,arguments);this._iDaysMonthHead=35;};d.prototype._initilizeMonthPicker=function(){this.setAggregation("monthPicker",this._createMonthPicker());};d.prototype._initilizeYearPicker=function(){this.setAggregation("yearPicker",this._createYearPicker());};d.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var h=this.getAggregation("header"),m,y;if(p){if(this.getAggregation("monthPicker")){this.getAggregation("monthPicker").destroy();}if(this.getAggregation("yearPicker")){this.getAggregation("yearPicker").destroy();}h.setVisibleButton2(false);h.detachEvent("pressButton2",this._handleButton2,this);this._setHeaderText(this._getFocusedDate(true));}else{if(!this.getAggregation("monthPicker")){this.setAggregation("monthPicker",this._createMonthPicker());}if(!this.getAggregation("yearPicker")){this.setAggregation("yearPicker",this._createYearPicker());}m=this.getAggregation("monthPicker");y=this.getAggregation("yearPicker");m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);y._oMinDate.setYear(this._oMinDate.getYear());y._oMaxDate.setYear(this._oMaxDate.getYear());h.setVisibleButton2(true);h.detachEvent("pressButton2",this._handleButton2,this);h.attachEvent("pressButton2",this._handleButton2,this);}return this;};d.prototype._createMonthPicker=function(){var m=new M(this.getId()+"--MP");m.attachEvent("select",this._selectMonth,this);m._bNoThemeChange=true;m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",_,this);return m;};d.prototype._createYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",e,this);return y;};d.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new a(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",this._handleCalendarPickerDateSelect,this);o.attachEvent("cancel",function(E){this._closeCalendarPicker();},this);this.setAggregation("calendarPicker",o);}return o;};d.prototype._handleButton1=function(E){if(this.getPickerPopup()){this._showCalendarPicker();}else{if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}}};d.prototype._setHeaderText=function(o){var t=a.prototype._setHeaderText.apply(this,arguments);var T,A,h=this.getAggregation("header");var L=this._getLocaleData();if(this.getPickerPopup()){if(L.oLocale.sLanguage.toLowerCase()==="ja"||L.oLocale.sLanguage.toLowerCase()==="zh"){T=t.sYear+" "+t.sMonth;A=t.sYear+t.sAriaLabel;}else{T=t.sMonth+" "+t.sYear;A=t.sAriaLabel+t.sYear;}h.setTextButton1(T,true);if(t.bShort){h.setAriaLabelButton1(A);}}};d.prototype._showCalendarPicker=function(){var s=this.getStartDate(),o=this._getCalendarPicker(),S=new sap.ui.unified.DateRange(),E=new Date(s.getTime());E.setDate(E.getDate()+this._getDays()-1);S.setStartDate(s);S.setEndDate(E);o.displayDate(this._getFocusedDate().toLocalJSDate());o.removeAllSelectedDates();o.addSelectedDate(S);o.setMinDate(this.getMinDate());o.setMaxDate(this.getMaxDate());this._openPickerPopup(o);this._showOverlay();};d.prototype._handleCalendarPickerDateSelect=function(E){var o=this._getCalendarPicker(),n=new b(o._getFocusedDate());this._setStartDate(n);this._setFocusedDate(n);this._closeCalendarPicker();};d.prototype._closeCalendarPicker=function(s){if(this._oPopup&&this._oPopup.isOpen()){this._oPopup.close();}this._hideOverlay();if(!s){this._renderMonth();var m=this.getAggregation("month");for(var i=0;i<m.length;i++){var o=m[i];q(o._oItemNavigation.getItemDomRefs()[o._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}};d.prototype._getDaysLarge=function(){return 10;};d.prototype._createMonth=function(i){var m=new D(i);return m;};d.prototype.setStartDate=function(s){C._checkJSDateObject(s);if(q.sap.equal(this.getStartDate(),s)){return this;}var y=s.getFullYear();C._checkYearInValidRange(y);var o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(C._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var f=this.getMaxDate();if(f&&s.getTime()>f.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(f.getTime());}this.setProperty("startDate",s,true);o=b.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var g=this.getAggregation("month")[0];g.setStartDate(s);this._updateHeader(o);var h=this._getFocusedDate(true).toLocalJSDate();if(!g.checkDateFocusable(h)){this._setFocusedDate(o);g.displayDate(s);}return this;};d.prototype.getStartDate=function(){return this.getProperty("startDate");};d.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var f=Math.ceil(i/3);if(f>12){f=12;}m.setMonths(f);var y=this.getAggregation("yearPicker");var g=Math.floor(i/2);if(g>20){g=20;}y.setYears(g);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};d.prototype._getDays=function(){var i=this.getDays();if(c.system.phone&&i>8){return 8;}else{return i;}};d.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};d.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};d.prototype._getFocusedDate=function(f){if(!this._oFocusedDate||f){this._oFocusedDate=null;a.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};d.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};d.prototype.setFirstDayOfWeek=function(f){if(f==-1){return this.setProperty("firstDayOfWeek",f,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};d.prototype.focusDate=function(o){var f=this.getAggregation("month")[0];if(!f.checkDateFocusable(o)){this._focusDateExtend(b.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}a.prototype.focusDate.apply(this,arguments);return this;};d.prototype._shouldFocusB2OnTabNext=function(E){var h=this.getAggregation("header");return(!this.getPickerPopup()&&E.target.id==h.getId()+"-B1");};d.prototype._focusOnShiftTab=function(){var h=this.getAggregation("header");if(this.getPickerPopup()){q.sap.focus(h.getDomRef("B1"));}else{q.sap.focus(h.getDomRef("B2"));}};d.prototype.onsapescape=function(E){if(this.getPickerPopup()){this._closeCalendarPicker();this.fireCancel();}else{if(this._iMode===0){this.fireCancel();}this._closedPickers();}};d.prototype._focusDateExtend=function(o,O,n){if(O){var f=this._getFocusedDate();var g=this._getStartDate();var i=C._daysBetween(f,g);var N=new b(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-i);this._setStartDate(N,false,true);if(!n){return true;}}return false;};d.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new b(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new b(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){q.sap.log.warning("end date > maxDate -> start date will be changed",this);var s=new b(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};d.prototype._togglePrevNext=function(o,f){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return a.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var i=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var g=this._oMinDate.getMonth();var h=this._oMinDate.getDate();var j=this._oMaxDate.getDate();var H=this.getAggregation("header");var k=this._getDays();var n;var s;var E;var p;var r;if(this._iMode==1&&!f){var t=this.getAggregation("monthPicker");var u=t.getMonths();var S=t.getStartMonth();var v=S+u-1;n=o.getYear();if(S==0||(n==i&&S<=g)){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}if(v>10||(n==y&&v>=m)){H.setEnabledNext(false);}else{H.setEnabledNext(true);}return;}s=this._getStartDate();E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+k-1);if(C._isOutside(o,s,E)){s=new b(o,this.getPrimaryCalendarType());E=new b(s,this.getPrimaryCalendarType());E.setDate(E.getDate()+k-1);}n=s.getYear();p=s.getMonth();r=s.getDate();if(n<i||(n==i&&(!f||p<g||(p==g&&r<=h)))){H.setEnabledPrevious(false);}else{H.setEnabledPrevious(true);}n=E.getYear();p=E.getMonth();r=E.getDate();if(n>y||(n==y&&(!f||p>m||(p==m&&r>=j)))){H.setEnabledNext(false);}else{H.setEnabledNext(true);}};d.prototype._shiftStartFocusDates=function(s,f,i){s.setDate(s.getDate()+i);f.setDate(f.getDate()+i);this._setFocusedDate(f);this._setStartDate(s,true);};d.prototype._handlePrevious=function(E){var f=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,f,(i*-1));break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.previousPage();this._togglePrevNext(f);}else{f.setYear(f.getYear()-1);var F=this._focusDateExtend(f,true,false);this._setFocusedDate(f);this._updateHeader(f);this._setDisabledMonths(f.getYear());if(F){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.previousPage();this._togglePrevNexYearPicker();}break;}};d.prototype._handleNext=function(E){var f=new b(this._getFocusedDate(),this.getPrimaryCalendarType()),m,y,s,i;switch(this._iMode){case 0:s=new b(this._getStartDate(),this.getPrimaryCalendarType());i=this._getDays();this._shiftStartFocusDates(s,f,i);break;case 1:if(!this.getPickerPopup()){m=this.getAggregation("monthPicker");if(m.getMonths()<12){m.nextPage();this._togglePrevNext(f);}else{f.setYear(f.getYear()+1);var F=this._focusDateExtend(f,true,false);this._setFocusedDate(f);this._updateHeader(f);this._setDisabledMonths(f.getYear());if(F){this.fireStartDateChange();}}}break;case 2:if(!this.getPickerPopup()){y=this.getAggregation("yearPicker");y.nextPage();this._togglePrevNexYearPicker();}break;}};d.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var f=this._getDays();m.push(i);if(f>this._getDaysLarge()){var E=new b(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+f-1);var g=E.getMonth();while(i!=g){i=(i+1)%12;m.push(i);}}return m;};d.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new b(this._getStartDate(),s);var f=S.getMonth();var E=new b(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new b(E,s);var g=E.getMonth();return{start:f,end:g};};d.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(function(){this._closeCalendarPicker(true);},this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var f=sap.ui.core.Popup.Dock;this._oPopup.open(0,f.CenterTop,f.CenterTop,h,null,"flipfit",true);};d.prototype._setStartDate=function(s,S,n){var m=new b(this._oMaxDate,this.getPrimaryCalendarType());m.setDate(m.getDate()-this._getDays()+1);if(m.isBefore(this._oMinDate)){m=new b(this._oMinDate);m.setDate(m.getDate()+this._getDays()-1);}if(s.isBefore(this._oMinDate)){s=new b(this._oMinDate,this.getPrimaryCalendarType());}else if(s.isAfter(m)){s=m;}var L=s.toLocalJSDate();this.setProperty("startDate",L,true);this._oStartDate=s;var o=this.getAggregation("month")[0];o.setStartDate(L);this._updateHeader(s);if(S){var f=this._getFocusedDate().toLocalJSDate();if(!o.checkDateFocusable(f)){this._setFocusedDate(s);o.setDate(L);}else{o.setDate(f);}}if(!n){this.fireStartDateChange();}};d.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};function _(E){var f=new b(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(f);}function e(E){this._togglePrevNexYearPicker();}return d;});
