/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/m/Button","sap/m/library","sap/m/Popover","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","./HierarchicalSelect","./library","jquery.sap.keycodes"],function(q,B,m,P,T,I,a,R,S,H,D,C,b,l){"use strict";var c=m.SelectType;var d=m.PlacementType;var A=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_popovers:{type:"sap.m.Popover",multiple:true,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});A.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=parseInt(q("body").css("font-size"),10);this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;this._sResizeListenerId=undefined;}this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();this.setDesign("Transparent");};A.SCROLL_STEP=250;A.SCROLL_DURATION=500;A.DOM_CALC_DELAY=200;A.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),e,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var f=o.data("sectionId");this._sSelectedKey=f;if(f&&h){this._oSelect.setSelectedKey(f);}if(this._bHasButtonsBar){e=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(e,false);this._toggleSelectionStyleClass(o,true);if(f){this.scrollToSection(f,A.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}}return this.setAssociation("selectedButton",o,true);};A.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}var e,n=!q.isEmptyObject(this._oPressHandlers);if(n){var f=this.getContent()||[];e=this.getSelectedButton();f.forEach(this._detachPopoverHandler,this);}this.setProperty("showPopover",v,true);if(n){this.rerender();if(e){this.setSelectedButton(e);}}return this;};A.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};A.prototype.onBeforeRendering=function(){if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var e=this.getContent()||[],u=this.getUpperCase(),p={oLastFirstLevelButton:null,oCurrentPopover:null};this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);e.forEach(function(o){this._createSelectItem(o);if(this._bHasButtonsBar){this._createPopoverSubMenu(o,p);}},this);if(e.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};A.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};A.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}};A.prototype._createPopoverSubMenu=function(o,p){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true",f=null;if(i){if(p.oLastFirstLevelButton&&p.oCurrentPopover){if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=q.proxy(this._handlePopover,{oCurrentPopover:p.oCurrentPopover,oLastFirstLevelButton:p.oLastFirstLevelButton});p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}p.oCurrentPopover.addContent(o);}else if(this.getShowPopover()){q.sap.log.error("sapUxApAnchorBar :: missing parent first level for item "+o.getText());}else{this.removeContent(o);o.destroy();}}else{p.oLastFirstLevelButton=o;if(this.getShowPopover()){p.oCurrentPopover=new P({placement:d.Bottom,showHeader:false,verticalScrolling:true,horizontalScrolling:false,contentWidth:"auto",showArrow:false});p.oCurrentPopover.addStyleClass("sapUxAPAnchorBarPopover");this._addKeyboardHandling(p.oCurrentPopover);this.addAggregation('_popovers',p.oCurrentPopover);}else if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=q.proxy(this._handleDirectScroll,this);p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}}};A.prototype._toggleSelectionStyleClass=function(o,e){if(o){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",e);o.$().attr("aria-checked",e);}};A.prototype._addKeyboardHandling=function(o){o.onsapdown=function(e){if(e.target.nextSibling){e.target.nextSibling.focus();}};o.onsapright=function(e){o.onsapdown(e);};o.onsapup=function(e){if(e.target.previousSibling){e.target.previousSibling.focus();}};o.onsapleft=function(e){o.onsapup(e);};o.onsaphome=function(e){if(e.target.parentElement.firstChild){e.target.parentElement.firstChild.focus();}};o.onsapend=function(e){if(e.target.parentElement.lastChild){e.target.parentElement.lastChild.focus();}};o.onsappageup=this._handlePageUp.bind(o);o.onsappagedown=this._handlePageDown.bind(o);};A.prototype._detachPopoverHandler=function(o){if(this._oPressHandlers[o.getId()]){o.detachPress(this._oPressHandlers[o.getId()]);this._oPressHandlers[o.getId()]=null;}};A.prototype._handlePopover=function(e){var p=this.oCurrentPopover.getContent()||[];if(this.oLastFirstLevelButton.$().is(":visible")){if(p.length==1){p[0].firePress({});}else{this.oCurrentPopover.openBy(this.oLastFirstLevelButton);}}};A.prototype._handleDirectScroll=function(e){if(e.getSource().getParent()instanceof P){e.getSource().getParent().close();}this._requestScrollToSection(e.getSource().data("sectionId"));};A.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),e=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&e instanceof l.ObjectPageSection){n=e.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&e instanceof l.ObjectPageSection){e.setAssociation("selectedSubSection",o,true);}};A.prototype._onSelectChange=function(e){var s=e.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{q.sap.log.error("AnchorBar :: cannot find corresponding section",s.getKey());}};A.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new b({width:"100%",icon:"sap-icon://overflow",change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};A.prototype._createScrollArrow=function(L){var s,i,e,f,o,t=this,g=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(L){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";e="anchorBarArrowLeft";f=this._bRtl?h:g;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";e="anchorBarArrowRight";f=this._bRtl?g:h;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(L);},tooltip:f});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(e);};A.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};A.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};A._hierarchicalSelectModes={"Icon":"icon","Text":"text"};A.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(c.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(c.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon);};A.prototype._adjustSize=function(){var n=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())?A._hierarchicalSelectModes.Text:A._hierarchicalSelectModes.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),e=$.find(".sapUxAPAnchorBarScrollContainer"),N,f,i;i=e.width();if(this._bRtlScenario){if(D.browser.firefox){f=Math.abs(e.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(e.scrollLeft())>=this._iTolerance;}else{f=Math.abs(e.scrollLeft())>=this._iTolerance;N=Math.abs(e.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{f=e.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=e.scrollLeft()>=this._iTolerance;}q.sap.log.debug("AnchorBar :: scrolled at "+e.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(f?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",f);}};A.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,A.SCROLL_DURATION*3);};A.prototype.scrollToSection=function(i,e){if(this._bHasButtonsBar){var f=e||A.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}q.sap.log.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){q.sap.clearDelayedCall(this._iCurrentScrollTimeout);q.sap.byId(this.getId()+"-scroll").parent().stop(true,false);}this._iCurrentScrollTimeout=q.sap.delayedCall(e,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});this._oScroller.scrollTo(s,0,f);}}else{q.sap.log.debug("AnchorBar :: no need to scroll to "+i);}}};A.prototype.getScrollDelegate=function(){return this._oScroller;};A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;A.prototype.onsapdown=function(e){e.preventDefault();if(e.target.nextSibling){e.target.nextSibling.focus();}};A.prototype.onsapright=function(e){var M=this._bRtl?"onsapup":"onsapdown";this[M](e);};A.prototype.onsapup=function(e){e.preventDefault();if(e.target.previousSibling){e.target.previousSibling.focus();}};A.prototype.onsapleft=function(e){var M=this._bRtl?"onsapdown":"onsapup";this[M](e);};A.prototype.onsaphome=function(e){e.preventDefault();if(e.target.parentElement.firstChild){e.target.parentElement.firstChild.focus();}};A.prototype.onsapend=function(e){e.preventDefault();if(e.target.parentElement.lastChild){e.target.parentElement.lastChild.focus();}};A.prototype.onsappageup=function(e){this._handlePageUp(e);};A.prototype.onsappagedown=function(e){this._handlePageDown(e);};A.prototype._handlePageUp=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(o.getId()===e.target.id){n=i-(A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};A.prototype._handlePageDown=function(e){e.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(o.getId()===e.target.id){n=i+A.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};A.prototype._setAnchorButtonsTabFocusValues=function(s){var e=this.getContent()||[],$,f='0',n='-1',t="tabIndex";e.forEach(function(o){$=o.$();if(o.sId===s.sId){$.attr(t,f);}else{$.attr(t,n);}});};A.prototype.onsapskipforward=function(e){this._handleGroupNavigation(e,false);};A.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown"),o={},O=this.getParent(),u=O.getUseIconTabBar(),f=O.getSelectedSection(),g=O.getSections(),h=[this.getDomRef()],i;if(u){i=sap.ui.getCore().byId(f).getSubSections().map(function(j){return j.$().attr("tabindex",-1)[0];});}else{g.forEach(function(j){i=j.getSubSections().map(function(k){return k.$().attr("tabindex",-1)[0];});});}h=h.concat(i);o.scope=h;e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=q.sap.KeyCodes.F6;E.shiftKey=s;q.sap.handleF6GroupNavigation(E,o);};A.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);this._setAnchorButtonsTabFocusValues(s);}if(this._bHasButtonsBar){q.sap.delayedCall(A.DOM_CALC_DELAY,this,function(){if(this._sHierarchicalSelectMode===A._hierarchicalSelectModes.Icon){this._computeBarSectionsInfo();}this._adjustSize();});}};A.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=q.sap.delayedCall(A.SCROLL_DURATION,this,function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();});}};A.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var e=this.getContent()||[];e.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){e.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};A.prototype._computeNextSectionInfo=function(o){if(o.data("bHasSubMenu")){o.$().attr("aria-haspopup","true");}o.$().attr("aria-controls",o.data("sectionId"));var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};A.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};A.prototype._destroyPopoverContent=function(){var p=this.getAggregation("_popovers");if(Array.isArray(p)){p.forEach(function(e){e.destroyContent();});}};A.prototype._resetControl=function(){this._destroyPopoverContent();this.getContent().forEach(this._detachPopoverHandler,this);this.destroyAggregation('content',true);return this;};A.prototype.enhanceAccessibilityState=function(e,f){var o=this.getContent(),i=o.indexOf(e);if(i!==-1){f.role="menuitemradio";f.type="button";f.setsize=o.length;f.posinset=i+1;}};A.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};return A;});
