/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/m/Link","sap/m/Select","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ItemNavigation","sap/ui/core/Item","sap/ui/core/Icon","sap/ui/Device","./library","sap/ui/core/InvisibleText"],function(L,S,C,R,I,a,b,D,l,c){"use strict";var B=C.extend("sap.uxap.BreadCrumbs",{metadata:{library:"sap.uxap",properties:{showCurrentLocation:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"links",aggregations:{links:{type:"sap.m.Link",multiple:true,singularName:"link"},currentLocation:{type:"sap.m.Text",multiple:false},_tubeIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowSelect:{type:"sap.m.Select",multiple:false,visibility:"hidden"}}}});B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;B.prototype.init=function(){this._iREMSize=parseInt(jQuery("body").css("font-size"),10);this._iContainerMaxHeight=this._iREMSize*2;};B.prototype.onBeforeRendering=function(){this._bOnPhone=D.system.phone;this._resetControl();};B.prototype.onAfterRendering=function(){this._handleInitialModeSelection();};B.prototype._handleInitialModeSelection=function(){if(this._bOnPhone){this._setSelectVisible(true);return this;}this._configureKeyboardHandling();if(!this._iContainerHeight){this._iContainerHeight=this.$().outerHeight();}if(this._iContainerHeight>this._iContainerMaxHeight){this._toggleOverflowMode(true);return this;}this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};B.prototype._toggleOverflowMode=function(u){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}this._setSelectVisible(u);this._setBreadcrumbsVisible(!u);this._sResizeListenerId=R.register(this,this._handleScreenResize.bind(this));return this;};B.prototype._getTubeIcon=function(){if(!this.getAggregation("_tubeIcon")){this.setAggregation("_tubeIcon",new b({"src":"sap-icon://slim-arrow-right","color":"#bfbfbf","size":"1rem","useIconTooltip":false}).addStyleClass("sapUxAPTubeIcon"));}return this.getAggregation("_tubeIcon");};B.prototype._getOverflowSelect=function(){var o,s;if(!this.getAggregation("_overflowSelect")){s=this.getLinks().reverse()||[];s.unshift(this.getCurrentLocation());o=new S({items:s.map(this._createSelectItem),autoAdjustWidth:true});o.attachChange(this._overflowSelectChangeHandler);this.setAggregation("_overflowSelect",o);}return this.getAggregation("_overflowSelect");};B.prototype._createSelectItem=function(i){return new a({key:i.getId(),text:i.getText()});};B.prototype._overflowSelectChangeHandler=function(e){var s=e.getParameter("selectedItem").getKey(),o=sap.ui.getCore().byId(s),d,f;if(o instanceof L){d=o.getHref();o.firePress();if(d){f=o.getTarget();if(f){window.open(d,f);}else{window.location.href=d;}}}return this;};B.prototype._handleScreenResize=function(e){var s=this._shouldOverflow(),u=this._getUsingOverflowSelect();if(s&&!u){this._toggleOverflowMode(true);}else if(!s&&u){this._toggleOverflowMode(false);}return this;};B.prototype._shouldOverflow=function(){var $=this._getBreadcrumbsAsJQueryObject(),s,u=this._getUsingOverflowSelect();if(u){this._setBreadcrumbsVisible(true);}$.addClass("sapUxAPInvisible");s=$.outerHeight()>this._iContainerMaxHeight;$.removeClass("sapUxAPInvisible");if(u){this._setBreadcrumbsVisible(false);}return s;};B.prototype._getBreadcrumbsAsJQueryObject=function(){if(!this._$breadcrumbs){this._$breadcurmbs=this.$("breadcrumbs");}return this._$breadcurmbs;};B.prototype._getOverflowSelectAsJQueryObject=function(){if(!this._$select){this._$select=this.$("select");}return this._$select;};B.prototype._setBreadcrumbsVisible=function(v){var $=this.$(),d=this._getBreadcrumbsAsJQueryObject(),f="sapUxAPFullWidth",s="sapUiHidden";if(v){d.removeClass(s);$.removeClass(f);}else{d.addClass(s);$.addClass(f);}return $;};B.prototype._setSelectVisible=function(v){var $=this._getOverflowSelectAsJQueryObject(),s="sapUiHidden";if(v){$.removeClass(s);}else{$.addClass(s);}return this;};B.prototype._resetControl=function(){this._iContainerHeight=null;this._$select=null;this._$breadcrumbs=null;this.setAggregation("_overflowSelect",null,true);if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);}return this;};B.prototype._getAriaLabelledBy=function(){if(!this._oAriaLabelledBy){B.prototype._oAriaLabelledBy=new c({text:l.i18nModel.getResourceBundle().getText("BREADCRUMB_TRAIL_LABEL")}).toStatic();}return this._oAriaLabelledBy;};B.prototype._getItemNavigation=function(){if(!this._ItemNavigation){this._ItemNavigation=new I();}return this._ItemNavigation;};B.prototype._getItemsToNavigate=function(){var i=this.getLinks(),o=this.getCurrentLocation(),s=this.getShowCurrentLocation();if(s&&o){i.push(o);}return i;};B.prototype._configureKeyboardHandling=function(){var i=this._getItemNavigation(),h=this._getBreadcrumbsAsJQueryObject()[0],s=-1,d=this._getItemsToNavigate(),n=[];d.forEach(function(o){o.$().attr("tabIndex","-1");n.push(o.getDomRef());});this.addDelegate(i);i.setCycling(false);i.setRootDomRef(h);i.setItemDomRefs(n);i.setSelectedIndex(s);this._getBreadcrumbsAsJQueryObject().attr("tabindex","-1");d[0].$().attr("tabindex","0");return this;};B.prototype.onsappageup=function(e){this._handlePageKeys(e,false);};B.prototype.onsappagedown=function(e){this._handlePageKeys(e,true);};B.prototype._handlePageKeys=function(e,m){var n,d=this._getItemsToNavigate(),E=0,i=m?d.length-1:0;e.preventDefault();d.some(function(o,f){if(o.getId()===e.target.id){E=f;return true;}});if(m){n=E+B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}else{n=E-B.PAGEUP_AND_PAGEDOWN_JUMP_SIZE;}if(n&&d[n]){d[n].focus();}else if(d[i]){d[i].focus();}};B.prototype._getUsingOverflowSelect=function(){return!this._getOverflowSelectAsJQueryObject().hasClass("sapUiHidden");};B.prototype.exit=function(){if(this._ItemNavigation){this.removeDelegate(this._ItemNavigation);this._ItemNavigation.destroy();this._ItemNavigation=null;}this._resetControl();};return B;});
