/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/layout/Grid","sap/ui/layout/GridData","./ObjectPageSectionBase","./ObjectPageLazyLoader","./BlockBase","sap/m/Button","sap/ui/Device","sap/ui/core/StashedControlSupport","sap/ui/base/ManagedObjectObserver","./library","sap/m/library","jquery.sap.keycodes"],function(q,G,a,O,b,B,c,D,S,d,l,m){"use strict";var e=m.ButtonType;var f=l.ObjectPageSubSectionMode;var g=l.ObjectPageSubSectionLayout;var h=O.extend("sap.uxap.ObjectPageSubSection",{metadata:{library:"sap.uxap",properties:{mode:{type:"sap.uxap.ObjectPageSubSectionMode",group:"Appearance",defaultValue:f.Collapsed},titleUppercase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"blocks",aggregations:{_grid:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},blocks:{type:"sap.ui.core.Control",multiple:true,singularName:"block"},moreBlocks:{type:"sap.ui.core.Control",multiple:true,singularName:"moreBlock"},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"}},designTime:true}});h.MEDIA_RANGE=D.media.RANGESETS.SAP_STANDARD;h.prototype.init=function(){O.prototype.init.call(this);this._bRenderedFirstTime=false;this._aAggregationProxy={blocks:[],moreBlocks:[]};this._$spacer=[];this._sContainerSelector=".sapUxAPBlockContainer";this._oObserver=new d(h.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["actions"]});this._switchSubSectionMode(this.getMode());};h.prototype._expandSection=function(){O.prototype._expandSection.call(this);var p=this.getParent();p&&typeof p._expandSection==="function"&&p._expandSection();return this;};h.prototype._getGrid=function(){if(!this.getAggregation("_grid")){this.setAggregation("_grid",new G({id:this.getId()+"-innerGrid",defaultSpan:"XL12 L12 M12 S12",hSpacing:1,vSpacing:1,width:"100%",containerQuery:true}),true);}return this.getAggregation("_grid");};h.prototype._hasVisibleActions=function(){var A=this.getActions()||[];if(A.length===0){return false;}return A.filter(function(o){return o.getVisible();}).length>0;};h.prototype._observeChanges=function(C){var o=C.object,s=C.name,M=C.mutation,i=C.child,H;if(o===this){if(s==="actions"){if(M==="insert"){this._observeAction(i);}else if(M==="remove"){this._unobserveAction(i);}}}else if(s==="visible"){H=this._getInternalTitleVisible()&&this.getTitle().trim()!=="";if(!H){this.$("header").toggleClass("sapUiHidden",!this._hasVisibleActions());}}};h.prototype._observeAction=function(C){this._oObserver.observe(C,{properties:["visible"]});};h.prototype._unobserveAction=function(C){this._oObserver.unobserve(C,{properties:["visible"]});};h.prototype._unStashControls=function(){S.getStashedControls(this.getId()).forEach(function(C){C.setStashed(false);});};h.prototype.connectToModels=function(){var i=this.getBlocks()||[],M=this.getMoreBlocks()||[],C=this.getMode();this._unStashControls();i.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});if(M.length>0&&C===f.Expanded){M.forEach(function(o){if(o instanceof B){if(!o.getMode()){o.setMode(C);}o.connectToModels();}});}};h.prototype._allowPropagationToLoadedViews=function(A){var i=this.getBlocks()||[],M=this.getMoreBlocks()||[];i.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});M.forEach(function(o){if(o instanceof B){o._allowPropagationToLoadedViews(A);}});};h.prototype.clone=function(){Object.keys(this._aAggregationProxy).forEach(function(A){var o=this.mAggregations[A];if(!o||o.length===0){this.mAggregations[A]=this._aAggregationProxy[A];}},this);return O.prototype.clone.apply(this,arguments);};h.prototype._cleanProxiedAggregations=function(){var p=this._aAggregationProxy;Object.keys(p).forEach(function(k){p[k].forEach(function(o){o.destroy();});});};h.prototype.exit=function(){if(this._oSeeMoreButton){this._oSeeMoreButton.destroy();this._oSeeMoreButton=null;}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._cleanProxiedAggregations();if(O.prototype.exit){O.prototype.exit.call(this);}};h.prototype.onAfterRendering=function(){var o=this._getObjectPageLayout();if(O.prototype.onAfterRendering){O.prototype.onAfterRendering.call(this);}if(!o){return;}this._synchronizeBlockLayouts();this._attachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._$spacer=q.sap.byId(o.getId()+"-spacer");};h.prototype.onBeforeRendering=function(){if(O.prototype.onBeforeRendering){O.prototype.onBeforeRendering.call(this);}this._detachMediaContainerWidthChange(this._synchronizeBlockLayouts,this);this._setAggregationProxy();this._getGrid().removeAllContent();this._applyLayout(this._getObjectPageLayout());this.refreshSeeMoreVisibility();};h.prototype._applyLayout=function(L){var v,o=this._getGrid(),C=this.getMode(),s=L.getSubSectionLayout(),i=this._calculateLayoutConfiguration(s,L),j=this.getBlocks(),A=j.concat(this.getMoreBlocks());this._oLayoutConfig=i;this._resetLayoutData(A);if(C===f.Expanded){v=A;}else{v=j;}this._calcBlockColumnLayout(v,this._oLayoutConfig);try{v.forEach(function(k){this._setBlockMode(k,C);o.addAggregation("content",k,true);},this);}catch(E){q.sap.log.error("ObjectPageSubSection :: error while building layout "+s+": "+E);}return this;};h.prototype._calculateLayoutConfiguration=function(L,o){var i={M:2,L:3,XL:4},j=i.L,E=i.XL,t=(L===g.TitleOnLeft),u=o.getUseTwoColumnsForLargeScreen();if(t){j-=1;E-=1;}if(u){j-=1;}i.L=j;i.XL=E;return i;};h.prototype.refreshSeeMoreVisibility=function(){var i=!!this.getMoreBlocks().length,s=this._getSeeMoreButton(),$=s.$(),j=this.$();if(!i){i=this.getBlocks().some(function(o){if(o instanceof B&&o.getVisible()&&o.getShowSubSectionMore()){return true;}});}if(j.length){j.toggleClass("sapUxAPObjectPageSubSectionWithSeeMore",i);}this.toggleStyleClass("sapUxAPObjectPageSubSectionWithSeeMore",i);if($.length){$.toggleClass("sapUxAPSubSectionSeeMoreButtonVisible",i);}s.toggleStyleClass("sapUxAPSubSectionSeeMoreButtonVisible",i);return i;};h.prototype.setMode=function(M){if(this.getMode()!==M){this._switchSubSectionMode(M);if(this._bRenderedFirstTime){this.rerender();}}return this;};h.prototype.onkeydown=function(E){if(E.keyCode===q.sap.KeyCodes.F7){E.stopPropagation();var t=sap.ui.getCore().byId(E.target.id);if(t instanceof h){this._handleSubSectionF7();}else{this._handleInteractiveElF7();this._oLastFocusedControlF7=t;}}};h.prototype._handleInteractiveElF7=function(){if(this.getParent().getSubSections().length>1){this.$().focus();}else{this.getParent().$().focus();}};h.prototype._handleSubSectionF7=function(E){if(this._oLastFocusedControlF7){this._oLastFocusedControlF7.$().focus();}else{this.$().firstFocusableDomRef().focus();}};h.prototype._calcBlockColumnLayout=function(i,C){var j=12,v,M,L,X,k;M={iRemaining:C.M,iColumnConfig:C.M};L={iRemaining:C.L,iColumnConfig:C.L};X={iRemaining:C.XL,iColumnConfig:C.XL};k=[X,L,M];v=i.filter(function(o){return o.getVisible&&o.getVisible();});v.forEach(function(o,I){k.forEach(function(n){n.iCalculatedSize=this._calculateBlockSize(o,n.iRemaining,v,I,n.iColumnConfig);},this);o.setLayoutData(new a(o.getId()+"-layoutData",{spanS:j,spanM:M.iCalculatedSize*(j/M.iColumnConfig),spanL:L.iCalculatedSize*(j/L.iColumnConfig),spanXL:X.iCalculatedSize*(j/X.iColumnConfig),linebreakM:(I>0&&M.iRemaining===M.iColumnConfig),linebreakL:(I>0&&L.iRemaining===L.iColumnConfig),linebreakXL:(I>0&&X.iRemaining===X.iColumnConfig)}));k.forEach(function(n){n.iRemaining-=n.iCalculatedSize;if(n.iRemaining<1){n.iRemaining=n.iColumnConfig;}});},this);return v;};h.prototype._calculateBlockSize=function(o,r,v,C,M){var i,F=M,j;if(!this._hasAutoLayout(o)){return Math.min(M,parseInt(o.getColumnLayout(),10));}for(j=1;j<=F;j++){i=this._calcLayout(v[C+j]);if(i<r){r-=i;}else{break;}}return r;};h.prototype._calcLayout=function(o){var L=1;if(!o){L=0;}else if(o instanceof B&&o.getColumnLayout()!="auto"){L=parseInt(o.getColumnLayout(),10);}return L;};h.prototype._hasAutoLayout=function(o){return!(o instanceof B)||o.getColumnLayout()=="auto";};h.prototype._onDesktopMediaRange=function(C){return this._onMediaRange(C,["LargeDesktop","Desktop"]);};h.prototype._onTabletMediaRange=function(C){return this._onMediaRange(C,["Tablet"]);};h.prototype._onPhoneMediaRange=function(C){return this._onMediaRange(C,["Phone"]);};h.prototype._onMediaRange=function(C,i){var M=C||this._getCurrentMediaContainerRange();return i.indexOf(M.name)>-1;};h.prototype._synchronizeBlockLayouts=function(C){if(this._getUseTitleOnTheLeft()){this.$("header").toggleClass("titleOnLeftLayout",this._onDesktopMediaRange(C));}this._toggleBlockLayoutResponsiveStyles(C);};h.prototype._toggleBlockLayoutResponsiveStyles=function(C){this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerDesktop",this._onDesktopMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerTablet",this._onTabletMediaRange(C));this.$().find(".sapUxAPBlockContainer").toggleClass("sapUxAPBlockContainerPhone",this._onPhoneMediaRange(C));};h.prototype._getMediaString=function(C){if(this._onPhoneMediaRange(C)){return"Phone";}if(this._onTabletMediaRange(C)){return"Tablet";}return"Desktop";};h.prototype._setAggregationProxy=function(){if(this._bRenderedFirstTime){return;}q.each(this._aAggregationProxy,q.proxy(function(A,v){this._setAggregation(A,this.removeAllAggregation(A,true),true);},this));this._bRenderedFirstTime=true;};h.prototype.hasProxy=function(A){return this._bRenderedFirstTime&&this._aAggregationProxy.hasOwnProperty(A);};h.prototype._getAggregation=function(A){return this._aAggregationProxy[A];};h.prototype._setAggregation=function(A,v,s){this._aAggregationProxy[A]=v;if(s!==true){this._notifyObjectPageLayout();this.invalidate();}return this._aAggregationProxy[A];};h.prototype.addAggregation=function(A,o,s){var i;if(o instanceof b){o.getContent().forEach(function(C){this.addAggregation(A,C,true);},this);o.removeAllContent();o.destroy();this.invalidate();return this;}if(this.hasProxy(A)){i=this._getAggregation(A);i.push(o);this._setAggregation(A,i,s);if(o instanceof B||o instanceof b){o.setParent(this);}return this;}return O.prototype.addAggregation.apply(this,arguments);};h.prototype.insertBlock=function(o,i){q.sap.log.warning("ObjectPageSubSection :: usage of insertBlock is not supported - addBlock is performed instead.");return this.addAggregation("blocks",o);};h.prototype.insertMoreBlock=function(o,i){q.sap.log.warning("ObjectPageSubSection :: usage of insertMoreBlock is not supported - addMoreBlock is performed instead.");return this.addAggregation("moreBlocks",o);};h.prototype.removeAllAggregation=function(A,s){var i;if(this.hasProxy(A)){i=this._getAggregation(A);this._setAggregation(A,[],s);return i.slice();}return O.prototype.removeAllAggregation.apply(this,arguments);};h.prototype.removeAggregation=function(A,o){var r=false,i;if(this.hasProxy(A)){i=this._getAggregation(A);i.forEach(function(j,I){if(j.getId()===o.getId()){i.splice(I,1);this._setAggregation(A,i);r=true;}return!r;},this);return(r?o:null);}return O.prototype.removeAggregation.apply(this,arguments);};h.prototype.indexOfAggregation=function(A,o){var i=-1;if(this.hasProxy(A)){this._getAggregation(A).some(function(j,I){if(j.getId()===o.getId()){i=I;return true;}},this);return i;}return O.prototype.indexOfAggregation.apply(this,arguments);};h.prototype.getAggregation=function(A){if(this.hasProxy(A)){return this._getAggregation(A);}return O.prototype.getAggregation.apply(this,arguments);};h.prototype.destroyAggregation=function(A){if(this.hasProxy(A)){this._getAggregation(A).forEach(function(o){o.destroy();});this._setAggregation(A,[]);return this;}return O.prototype.destroyAggregation.apply(this,arguments);};h.prototype._getSeeMoreButton=function(){if(!this._oSeeMoreButton){this._oSeeMoreButton=new c(this.getId()+"--seeMore",{type:e.Transparent,iconFirst:false}).addStyleClass("sapUxAPSubSectionSeeMoreButton").attachPress(this._seeMoreLessControlPressHandler,this);}return this._oSeeMoreButton;};h.prototype._seeMoreLessControlPressHandler=function(E){var C=this.getMode(),t,M=this.getMoreBlocks()||[];if(C===f.Expanded){t=f.Collapsed;}else{t=f.Expanded;M.forEach(function(o){if(o instanceof B){o.setMode(C);o.connectToModels();}},this);}this._switchSubSectionMode(t);if(this._$spacer.length>0){this._$spacer.height(this._$spacer.height()+this.$().height());}this.rerender();};h.prototype._switchSubSectionMode=function(s){s=this.validateProperty("mode",s);if(s===f.Collapsed){this.setProperty("mode",f.Collapsed,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_MORE"));}else{this.setProperty("mode",f.Expanded,true);this._getSeeMoreButton().setText(l.i18nModel.getResourceBundle().getText("SEE_LESS"));}};h.prototype._setBlockMode=function(o,M){if(o instanceof B){o.setMode(M);}else{q.sap.log.debug("ObjectPageSubSection :: cannot propagate mode "+M+" to "+o.getMetadata().getName());}};h.prototype._setToFocusable=function(F){var s='0',n='-1',t="tabIndex";if(F){this.$().attr(t,s);}else{this.$().attr(t,n);}return this;};h.prototype._getUseTitleOnTheLeft=function(){var o=this._getObjectPageLayout();return o.getSubSectionLayout()===g.TitleOnLeft;};h.prototype._resetLayoutData=function(i){i.forEach(function(o){if(o.getLayoutData()){o.destroyLayoutData();}},this);};h.prototype.getVisibleBlocksCount=function(){var v=S.getStashedControls(this.getId()).length;(this.getBlocks()||[]).forEach(function(o){if(o.getVisible&&!o.getVisible()){return true;}v++;});(this.getMoreBlocks()||[]).forEach(function(M){if(M.getVisible&&!M.getVisible()){return true;}v++;});return v;};return h;});
