/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/library','sap/ui/thirdparty/mobify-carousel','sap/ui/core/IconPool','jquery.sap.keycodes'],function(q,l,C,D,R,c){"use strict";var B=c.BusyIndicatorSize;var I=l.ImageHelper;var a=l.CarouselArrowsPlacement;var P=l.PlacementType;var b=C.extend("sap.m.Carousel",{metadata:{library:"sap.m",properties:{height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},loop:{type:"boolean",group:"Misc",defaultValue:false},showPageIndicator:{type:"boolean",group:"Appearance",defaultValue:true},pageIndicatorPlacement:{type:"sap.m.PlacementType",group:"Appearance",defaultValue:P.Bottom},showBusyIndicator:{type:"boolean",group:"Appearance",defaultValue:true,deprecated:true},arrowsPlacement:{type:"sap.m.CarouselArrowsPlacement",group:"Appearance",defaultValue:a.Content}},defaultAggregation:"pages",aggregations:{pages:{type:"sap.ui.core.Control",multiple:true,singularName:"page"}},associations:{activePage:{type:"sap.ui.core.Control",multiple:false}},events:{loadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},unloadPage:{deprecated:true,parameters:{pageId:{type:"string"}}},pageChanged:{parameters:{oldActivePageId:{type:"string"},newActivePageId:{type:"string"}}}}}});b._INNER_SELECTOR=".sapMCrslInner";b._PAGE_INDICATOR_SELECTOR=".sapMCrslBulleted";b._PAGE_INDICATOR_ARROWS_SELECTOR=".sapMCrslIndicatorArrow";b._CONTROLS=".sapMCrslControls";b._ITEM_SELECTOR=".sapMCrslItem";b._LEFTMOST_CLASS="sapMCrslLeftmost";b._RIGHTMOST_CLASS="sapMCrslRightmost";b._LATERAL_CLASSES="sapMCrslLeftmost sapMCrslRightmost";b._MODIFIERNUMBERFORKEYBOARDHANDLING=10;b._BULLETS_TO_NUMBERS_THRESHOLD=9;b.prototype.init=function(){this._aScrollContainers=[];this._fnAdjustAfterResize=q.proxy(function(){var $=this.$().find(b._INNER_SELECTOR);this._oMobifyCarousel.resize($);},this);this.data("sap-ui-fastnavgroup","true",true);};b.prototype.exit=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.destroy();delete this._oMobifyCarousel;}if(this._oArrowLeft){this._oArrowLeft.destroy();delete this._oArrowLeft;}if(this._oArrowRight){this._oArrowRight.destroy();delete this._oArrowRight;}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.$().off('afterSlide');this._cleanUpScrollContainer();this._fnAdjustAfterResize=null;this._aScrollContainers=null;this._$InnerDiv=null;};b.prototype._cleanUpScrollContainer=function(){var s;while(this._aScrollContainers&&this._aScrollContainers.length>0){s=this._aScrollContainers.pop();s.removeAllContent();if(s&&typeof s.destroy==='function'){s.destroy();}}};b.prototype.ontouchstart=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchstart(e);}};b.prototype.ontouchmove=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchmove(e);}};b.prototype.ontouchend=function(e){if(this._oMobifyCarousel){this._oMobifyCarousel.touchend(e);}};b.prototype.onBeforeRendering=function(){var A=this.getActivePage();if(!A&&this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);}if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}return this;};b.prototype.onAfterRendering=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.unbind();}this.$().carousel();this._oMobifyCarousel=this.getDomRef()._carousel;this._oMobifyCarousel.setLoop(this.getLoop());this._oMobifyCarousel.setRTL(sap.ui.getCore().getConfiguration().getRTL());var A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(isNaN(i)||i==0){if(this.getPages().length>0){this.setAssociation("activePage",this.getPages()[0].getId(),true);this._adjustHUDVisibility(1);}}else{var o=sap.ui.getCore();if(o.isThemeApplied()){this._moveToPage(i+1);}else{o.attachThemeChanged(this._handleThemeLoad,this);}if(sap.zen&&sap.zen.commons&&this.getParent()instanceof sap.zen.commons.layout.PositionContainer){if(this._isCarouselUsedWithCommonsLayout===undefined){q.sap.delayedCall(0,this,"invalidate");this._isCarouselUsedWithCommonsLayout=true;}}}}this.$().on('afterSlide',q.proxy(function(e,d,n){if(e.target!==this.getDomRef()){return;}if(n>0){this._changePage(n);}},this));this._$InnerDiv=this.$().find(b._INNER_SELECTOR)[0];this._sResizeListenerId=R.register(this._$InnerDiv,this._fnAdjustAfterResize);this.$().find('.sapMCrslItemTableCell').focus(function(e){e.preventDefault();q(e.target).parents('.sapMCrsl').focus();return false;});var s='sap.m.IconTabBar';var p=this.getParent();while(p){if(p.getMetadata().getName()==s){var t=this;p.attachExpand(function(e){var E=e.getParameter('expand');if(E&&i>0){t._moveToPage(i+1);}});break;}p=p.getParent();}};b.prototype._handleThemeLoad=function(){var o,A=this.getActivePage();if(A){var i=this._getPageNumber(A);if(i>0){this._moveToPage(i+1);}}o=sap.ui.getCore();o.detachThemeChanged(this._handleThemeLoad,this);};b.prototype._moveToPage=function(i){this._oMobifyCarousel.changeAnimation('sapMCrslNoTransition');this._oMobifyCarousel.move(i);this._changePage(i);};b.prototype._changePage=function(n){this._adjustHUDVisibility(n);var o=this.getActivePage();var N=this.getPages()[n-1].getId();this.setAssociation("activePage",N,true);var t=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("CAROUSEL_PAGE_INDICATOR_TEXT",[n,this.getPages().length]);q.sap.log.debug("sap.m.Carousel: firing pageChanged event: old page: "+o+", new page: "+N);if(!D.system.desktop){q(document.activeElement).blur();}this.firePageChanged({oldActivePageId:o,newActivePageId:N});this.$('slide-number').text(t);};b.prototype._adjustHUDVisibility=function(n){if(D.system.desktop&&!this.getLoop()&&this.getPages().length>1){var h=this.$('hud');h.removeClass(b._LATERAL_CLASSES);if(n===1){h.addClass(b._LEFTMOST_CLASS);}else if(n===this.getPages().length){h.addClass(b._RIGHTMOST_CLASS);}}};b.prototype.setActivePage=function(p){var s=null;if(typeof(p)=='string'){s=p;}else if(p instanceof C){s=p.getId();}if(s){if(s===this.getActivePage()){return this;}var i=this._getPageNumber(s);if(!isNaN(i)){if(this._oMobifyCarousel){this._oMobifyCarousel.move(i+1);}}}this.setAssociation("activePage",s,true);return this;};b.prototype.setHeight=function(h){this.setProperty("height",h,true);this.$().css("height",h);return this;};b.prototype.setWidth=function(w){this.setProperty("width",w,true);this.$().css("width",w);return this;};b.prototype.setLoop=function(L){this.setProperty("loop",L,true);if(this._oMobifyCarousel){this._oMobifyCarousel.setLoop(L);}return this;};b.prototype._getNavigationArrow=function(n){var p={src:"sap-icon://slim-arrow-"+n,useIconTooltip:false};if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=I.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p);}return this._oArrowLeft;}else if(n==="right"){if(!this._oArrowRight){this._oArrowRight=I.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p);}return this._oArrowRight;}};b.prototype._createScrollContainer=function(p){var i;var s=D.system.desktop&&this.getArrowsPlacement()===a.PageIndicator;if(s){i="sapMCrslImg";}else{i="sapMCrslImgNoArrows";}var d=p instanceof sap.m.Image?"sapMCrslItemTableCell "+i:"sapMCrslItemTableCell",o=new sap.ui.core.HTML({content:"<div class='sapMCrslItemTable'>"+"<div class='"+d+"'></div>"+"</div>",afterRendering:function(e){var r=sap.ui.getCore().createRenderManager();r.render(p,this.getDomRef().firstChild);r.destroy();p=null;}});var S=new sap.m.ScrollContainer({horizontal:false,vertical:false,content:[o],width:'100%',height:'100%'});S.setParent(this,null,true);this._aScrollContainers.push(S);return S;};b.prototype.previous=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.prev();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.previous: carousel must be rendered first.");}return this;};b.prototype.next=function(){if(this._oMobifyCarousel){this._oMobifyCarousel.next();}else{q.sap.log.warning("Unable to execute sap.m.Carousel.next: carousel must be rendered first.");}return this;};b.prototype._getPageNumber=function(p){var i,r;for(i=0;i<this.getPages().length;i++){if(this.getPages()[i].getId()==p){r=i;break;}}return r;};b.prototype.onsaptabprevious=function(e){this._bDirection=false;this._fnOnTabPress(e);};b.prototype.onsaptabnext=function(e){this._bDirection=true;this._fnOnTabPress(e);};b.prototype.onfocusin=function(e){this.saveLastFocusReference(e);this._bDirection=undefined;};b.prototype.onsapskipforward=function(e){e.preventDefault();this._handleGroupNavigation(e,false);};b.prototype.onsapskipback=function(e){e.preventDefault();this._handleGroupNavigation(e,true);};b.prototype.onkeydown=function(e){if(e.keyCode==q.sap.KeyCodes.F7){this._handleF7Key(e);return;}if(e.target!=this.getDomRef()){return;}switch(e.keyCode){case 189:case q.sap.KeyCodes.NUMPAD_MINUS:this._fnSkipToIndex(e,-1);break;case q.sap.KeyCodes.PLUS:case q.sap.KeyCodes.NUMPAD_PLUS:this._fnSkipToIndex(e,1);break;}};b.prototype.onsapescape=function(e){var d;if(e.target===this.$()[0]&&this._lastActivePageNumber){d=this._lastActivePageNumber+1;this._oMobifyCarousel.move(d);this._changePage(d);}};b.prototype.onsapright=function(e){this._fnSkipToIndex(e,1);};b.prototype.onsapup=function(e){this._fnSkipToIndex(e,-1);};b.prototype.onsapleft=function(e){this._fnSkipToIndex(e,-1);};b.prototype.onsapdown=function(e){this._fnSkipToIndex(e,1);};b.prototype.onsaphome=function(e){this._fnSkipToIndex(e,0);};b.prototype.onsapend=function(e){this._fnSkipToIndex(e,this.getPages().length);};b.prototype.onsaprightmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,b._MODIFIERNUMBERFORKEYBOARDHANDLING);}};b.prototype.onsapupmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,b._MODIFIERNUMBERFORKEYBOARDHANDLING);}};b.prototype.onsappageup=function(e){this._fnSkipToIndex(e,b._MODIFIERNUMBERFORKEYBOARDHANDLING);};b.prototype.onsapleftmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-b._MODIFIERNUMBERFORKEYBOARDHANDLING);}};b.prototype.onsapdownmodifiers=function(e){if(e.ctrlKey){this._fnSkipToIndex(e,-b._MODIFIERNUMBERFORKEYBOARDHANDLING);}};b.prototype.onsappagedown=function(e){this._fnSkipToIndex(e,-b._MODIFIERNUMBERFORKEYBOARDHANDLING);};b.prototype._fnOnTabPress=function(e){if(e.target===this.$()[0]){this._lastActivePageNumber=this._getPageNumber(this.getActivePage());}};b.prototype._handleGroupNavigation=function(e,s){var E=q.Event("keydown");e.preventDefault();this.$().focus();E.target=e.target;E.keyCode=q.sap.KeyCodes.F6;E.shiftKey=s;q.sap.handleF6GroupNavigation(E);};b.prototype.saveLastFocusReference=function(e){if(this._bDirection===undefined){return;}if(this._lastFocusablePageElement===undefined){this._lastFocusablePageElement={};}this._lastFocusablePageElement[this.getActivePage()]=e.target;};b.prototype._getActivePageLastFocusedElement=function(){if(this._lastFocusablePageElement){return this._lastFocusablePageElement[this.getActivePage()];}};b.prototype._fnSkipToIndex=function(e,n){var d=n;if(e.target!==this.getDomRef()){return;}e.preventDefault();if(n!==0){d=this._getPageNumber(this.getActivePage())+1+n;}this._oMobifyCarousel.move(d);};b.prototype._handleF7Key=function(e){var A;e.preventDefault();A=this._getActivePageLastFocusedElement();if(e.target===this.$()[0]&&A){A.focus();}else{this.$().focus();}};b.prototype.setShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'setShowBusyIndicator' called. Does nothing.");return this;};b.prototype.getShowBusyIndicator=function(){q.sap.log.warning("sap.m.Carousel: Deprecated function 'getShowBusyIndicator' called. Does nothing.");return false;};b.prototype.setBusyIndicatorSize=function(s){if(!(s in B)){s=B.Medium;}return C.prototype.setBusyIndicatorSize.call(this,s);};return b;});
