/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Label','./library','sap/ui/Device','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/EnabledPropagator','sap/ui/core/library'],function(q,L,l,D,C,I,E,c){"use strict";var V=c.ValueState;var T=c.TextAlign;var a=c.TextDirection;var b=C.extend("sap.m.CheckBox",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.m",properties:{selected:{type:"boolean",group:"Data",defaultValue:false},enabled:{type:"boolean",group:"Behavior",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:null},text:{type:"string",group:"Appearance",defaultValue:null},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:''},useEntireWidth:{type:"boolean",group:"Appearance",defaultValue:false},activeHandling:{type:"boolean",group:"Misc",defaultValue:true},editable:{type:"boolean",group:"Behavior",defaultValue:true},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:V.None}},aggregations:{_label:{type:"sap.m.Label",group:"Behavior",multiple:false,visibility:"hidden"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{selected:{type:"boolean"}}}},designTime:true}});E.call(b.prototype);b.prototype.init=function(){this.addActiveState(this);I.insertFontFaceStyle();};b.prototype.exit=function(){this._oLabel=null;delete this._iTabIndex;};b.prototype.setSelected=function(s){s=!!s;if(s==this.getSelected()){return this;}this.$("CbBg").toggleClass("sapMCbMarkChecked",s);this.$().attr("aria-checked",s);var o=this.getDomRef("CB");if(o){s?o.setAttribute('checked','checked'):o.removeAttribute('checked');}this.setProperty("selected",s,true);return this;};b.prototype.setText=function(t){var o=this._getLabel(),h=!!t;this.setProperty("text",t,true);o.setText(t);this.$().toggleClass("sapMCbHasLabel",h);return this;};b.prototype.setWidth=function(w){this.setProperty("width",w,true);this._setWidth();return this;};b.prototype.setUseEntireWidth=function(u){this.setProperty("useEntireWidth",u,true);this._setWidth();return this;};b.prototype.setTextDirection=function(d){var o=this._getLabel();this.setProperty("textDirection",d,true);o.setTextDirection(d);return this;};b.prototype.setTextAlign=function(A){var o=this._getLabel();this.setProperty("textAlign",A,true);o.setTextAlign(A);return this;};b.prototype.addActiveState=function(o){if(D.os.blackberry){o.addDelegate({ontouchstart:function(e){q(o.getDomRef()).addClass("sapMActive");},ontouchend:function(e){q(o.getDomRef()).removeClass("sapMActive");}});}};b.prototype.ontouchstart=function(e){e.originalEvent._sapui_handledByControl=true;};b.prototype.ontap=function(e){if(this.getEnabled()&&this.getEditable()){this.$().focus();var s=!this.getSelected();this.setSelected(s);this.fireSelect({selected:s});e&&e.setMarked();}};b.prototype.onsapspace=function(e){this.ontap(e);if(e){e.preventDefault();e.stopPropagation();}};b.prototype.onsapenter=function(e){this.ontap(e);};b.prototype.setTabIndex=function(t){this._iTabIndex=t;this.$("CbBg").attr("tabindex",t);return this;};b.prototype.getTabIndex=function(){if(this.hasOwnProperty("_iTabIndex")){return this._iTabIndex;}return this.getEnabled()?0:-1;};b.prototype._getLabel=function(){if(!this._oLabel){this._oLabel=new L(this.getId()+"-label",{labelFor:this.getId()}).addStyleClass("sapMCbLabel");this.setAggregation("_label",this._oLabel,true);}return this.getAggregation("_label");};b.prototype._setWidth=function(){var o=this._getLabel(),$=this.$(),w=this.getWidth();if(this.getUseEntireWidth()){o.setWidth("");$.outerWidth(w);}else{$.outerWidth("");o.setWidth(w);}};b.prototype.getAccessibilityInfo=function(){var B=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{role:"checkbox",type:B.getText("ACC_CTR_TYPE_CHECKBOX"),description:(this.getText()||"")+(this.getSelected()?(" "+B.getText("ACC_CTR_STATE_CHECKED")):""),focusable:this.getEnabled(),enabled:this.getEnabled(),editable:this.getEditable()};};b.prototype.getFormDoNotAdjustWidth=function(){return this.getText()?false:true;};return b;});
