/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ComboBoxTextField','./ComboBoxBase','./Popover','./SelectList','./library','sap/ui/Device','sap/ui/core/Item','jquery.sap.keycodes'],function(q,C,a,P,S,l,D,I){"use strict";var b=a.extend("sap.m.ComboBox",{metadata:{library:"sap.m",properties:{selectedKey:{type:"string",group:"Data",defaultValue:""},selectedItemId:{type:"string",group:"Misc",defaultValue:""},showSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},filterSecondaryValues:{type:"boolean",group:"Misc",defaultValue:false}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false}},events:{change:{parameters:{value:{type:"string"},itemPressed:{type:"boolean"}}},selectionChange:{parameters:{selectedItem:{type:"sap.ui.core.Item"}}}}}});function h(c,i){if(!i){return;}var d=c.getFocusDomRef(),e=d.selectionStart,g=d.selectionEnd,j=e!==g,t=d.value.substring(0,d.selectionStart),o=this.getSelectedItem();if(i!==o){c.updateDomValue(i.getText());this.setSelection(i);this.fireSelectionChange({selectedItem:i});i=this.getSelectedItem();if(!q.sap.startsWithIgnoreCase(i.getText(),t)||!j){e=0;}c.selectText(e,d.value.length);}this.scrollToItem(i);}function s(i,e){if(document.activeElement===this.getFocusDomRef()){this.selectText(i,e);}}function f(i){var o=this.getSelectedItem(),c=o&&o.getDomRef(),d=o&&c.offsetTop,e=o&&c.offsetHeight,p=this.getPicker(),g=p.getDomRef("cont"),j=g.clientHeight;if(o&&((d+e)>(j))){if(!i){this.getList().$().css("visibility","hidden");}else{g.scrollTop=d-e/2;this.getList().$().css("visibility","visible");}}}b.prototype._handleAriaActiveDescendant=function(i){var d=this.getFocusDomRef(),A="aria-activedescendant";if(d){if(i&&i.getDomRef()&&this.isOpen()){d.setAttribute(A,i.getId());}else{d.removeAttribute(A);}}};b.prototype._getSelectedItemText=function(i){i=i||this.getSelectedItem();if(!i){i=this.getDefaultSelectedItem();}if(i){return i.getText();}return"";};b.prototype._callMethodInControl=function(F,A){var L=this.getList();if(A[0]==="items"){if(L){return S.prototype[F].apply(L,A);}}else{return a.prototype[F].apply(this,A);}};b.prototype._setItemVisibility=function(i,v){var o=i&&i.$(),c="sapMSelectListItemBaseInvisible";if(v){i.bVisible=true;o.length&&o.removeClass(c);}else{i.bVisible=false;o.length&&o.addClass(c);}};b.prototype._highlightList=function(v){var i=this.getVisibleItems(),c=v.length,v=v.replace(/[-[\]{}()*+?.,\\^$|#\s]/g,'\\$&'),r=new RegExp("^"+v,"i");i.forEach(function(o){var d=o.getDomRef(),e,g;if(d===null){return;}e=d.children[1];g=Array.prototype.filter.call(d.children,function(j){return j.tagName.toLowerCase()!=="b";})[0]||d;g.innerHTML=this._boldItemRef(o.getText(),r,c);if(e&&o.getAdditionalText){e.innerHTML=this._boldItemRef(o.getAdditionalText(),r,c);}},this);};b.prototype._boldItemRef=function(i,r,c){var R;var t="<b>"+q.sap.encodeHTML(i.slice(0,c))+"</b>";var p=i.split(r);if(p.length===1){R=q.sap.encodeHTML(i);}else{R=p.map(function(d){return q.sap.encodeHTML(d);}).join(t);}return R;};b.prototype.setSelectedIndex=function(i,_){var o;_=_||this.getItems();i=(i>_.length-1)?_.length-1:Math.max(0,i);o=_[i];if(o){this.setSelection(o);}};b.prototype.createDropdown=function(){var t=this;var d=new P(this.getDropdownSettings());d.setInitialFocus(this);d.open=function(){return this.openBy(t);};return d;};b.prototype.createPickerTextField=function(){var t=new C({width:"100%",showValueStateMessage:false,showButton:false}).addEventDelegate({onsapenter:function(){this.updateDomValue(t.getValue());this.onChange();}},this);return t;};b.prototype.revertSelection=function(){var p,o=this.getPickerTextField();this.setSelectedItem(this._oSelectedItemBeforeOpen);this.setValue(this._sValueBeforeOpen);if(this.getSelectedItem()===null){p=this._sValueBeforeOpen;}else{p=this._oSelectedItemBeforeOpen.getText();}o&&o.setValue(p);};b.prototype.filterItems=function(o,c){var p=o.properties,v=o.value,e=v==="",m=false,t=false,M=[],F=[],d=null;this._oFirstItemTextMatched=null;p.forEach(function(g){M.push("get"+g.charAt(0).toUpperCase()+g.slice(1));});c=c||this.getItems();for(var i=0;i<c.length;i++){d=c[i];m=e;for(var j=0;j<M.length;j++){if(q.sap.startsWithIgnoreCase(d[M[j]](),v)){m=true;if(M[j]==="getText"){t=true;}}}if(m){F.push(d);}if(!this._oFirstItemTextMatched&&t){this._oFirstItemTextMatched=d;}this._setItemVisibility(d,m);}return F;};b.prototype._getFilters=function(){return this.getFilterSecondaryValues()?["text","additionalText"]:["text"];};b.prototype.init=function(){a.prototype.init.apply(this,arguments);this.bOpenValueStateMessage=true;this._sValueBeforeOpen="";this._sInputValueBeforeOpen="";this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};b.prototype.onBeforeRendering=function(){a.prototype.onBeforeRendering.apply(this,arguments);this.synchronizeSelection();};b.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._oSelectedItemBeforeOpen=null;this._oFirstItemTextMatched=null;};b.prototype.onBeforeRenderingPicker=function(){var o=this["onBeforeRendering"+this.getPickerType()];o&&o.call(this);};b.prototype.onBeforeRenderingDropdown=function(){var p=this.getPicker(),w=(this.$().outerWidth()/parseFloat(l.BaseFontSize))+"rem";if(p){p.setContentMinWidth(w);}};b.prototype.onBeforeRenderingList=function(){if(this.bProcessingLoadItemsEvent){var L=this.getList(),F=this.getFocusDomRef();if(L){L.setBusy(true);}if(F){F.setAttribute("aria-busy","true");}}};b.prototype.onAfterRenderingPicker=function(){var o=this["onAfterRendering"+this.getPickerType()];o&&o.call(this);f.call(this,false);};b.prototype.onAfterRenderingList=function(){if(this.bProcessingLoadItemsEvent&&(this.getItems().length===0)){return;}var L=this.getList(),F=this.getFocusDomRef();this._highlightList(this._sInputValueBeforeOpen);if(L){L.setBusy(false);}if(F){F.removeAttribute("aria-busy");}};b.prototype.oninput=function(e){a.prototype.oninput.apply(this,arguments);if(e.isMarked("invalid")){return;}var t=(this.getPickerType()==="Dropdown");this.loadItems(function(){var o=this.getSelectedItem(),v=e.target.value,E=v==="",c=e.srcControl,V;if(E&&!this.bOpenedByKeyboardOrButton){V=this.getItems();}else{V=this.filterItems({properties:this._getFilters(),value:v});}var i=!!V.length;var F=V[0];var T=(F&&q.sap.startsWithIgnoreCase(F.getText(),v));var d=this.getFilterSecondaryValues();var g=D.system.desktop;if(!E&&F&&F.getEnabled()){if(c._bDoTypeAhead){if(d&&this._oFirstItemTextMatched){c.updateDomValue(this._oFirstItemTextMatched.getText());this.setSelection(this._oFirstItemTextMatched);}else if(d){if(T){c.updateDomValue(F.getText());}else{c.updateDomValue(F.getAdditionalText());}this.setSelection(F);}else{c.updateDomValue(F.getText());this.setSelection(F);}}if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}if(c._bDoTypeAhead){if(g){s.call(c,v.length,c.getValue().length);}else{setTimeout(s.bind(c,v.length,c.getValue().length),0);}}}if(E||!i||(!c._bDoTypeAhead&&(this._getSelectedItemText()!==v))){this.setSelection(null);if(o!==this.getSelectedItem()){this.fireSelectionChange({selectedItem:this.getSelectedItem()});}}this._sInputValueBeforeOpen=v;if(this.isOpen()){this._highlightList(v);}if(i){if(E&&!this.bOpenedByKeyboardOrButton){this.close();}else if(t){this.open();this.scrollToItem(this.getSelectedItem());}}else if(this.isOpen()){if(t&&!this.bOpenedByKeyboardOrButton){this.close();}}else{this.clearFilter();}},{name:"input",busyIndicator:false});if(this.bProcessingLoadItemsEvent&&t){this.open();}};b.prototype.onSelectionChange=function(c){var i=c.getParameter("selectedItem"),p=this.getChangeEventParams(),d=(i!==this.getSelectedItem());this.setSelection(i);this.fireSelectionChange({selectedItem:this.getSelectedItem()});if(d){p.itemPressed=true;this.onChange(null,p);}};b.prototype.onItemPress=function(c){var i=c.getParameter("item"),t=i.getText(),p=this.getChangeEventParams(),d=(i!==this.getSelectedItem());this.updateDomValue(t);if(this.getPickerType()==="Dropdown"&&!d){p.itemPressed=true;this.onChange(null,p);}this.close();this.setProperty("value",i.getText(),true);setTimeout(this.selectText.bind(this,this.getValue().length,this.getValue().length),0);};b.prototype.onBeforeOpen=function(){var p=this["onBeforeOpen"+this.getPickerType()],d=this.getFocusDomRef();if(this.hasLoadItemsEventListeners()&&!this.bProcessingLoadItemsEvent){this.loadItems();}this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");if(d){d.setAttribute("aria-owns",this.getList().getId());}this.addContent();p&&p.call(this);};b.prototype.onBeforeOpenDropdown=function(){};b.prototype.onBeforeOpenDialog=function(){var p=this.getPickerTextField();this._oSelectedItemBeforeOpen=this.getSelectedItem();this._sValueBeforeOpen=this.getValue();if(this.getSelectedItem()){this.filterItems({properties:this._getFilters(),value:""});}p.setValue(this._sValueBeforeOpen);};b.prototype.onAfterOpen=function(){var d=this.getFocusDomRef(),i=this.getSelectedItem();if(d){d.setAttribute("aria-expanded","true");i&&d.setAttribute("aria-activedescendant",i.getId());}f.call(this,true);};b.prototype.onBeforeClose=function(){a.prototype.onBeforeClose.apply(this,arguments);var d=this.getFocusDomRef();if(d){d.removeAttribute("aria-owns");d.removeAttribute("aria-activedescendant");}this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");};b.prototype.onAfterClose=function(){var d=this.getFocusDomRef();if(d){d.setAttribute("aria-expanded","false");}this.clearFilter();this._sInputValueBeforeOpen="";if(this.shouldValueStateMessageBeOpened()&&(document.activeElement===d)){this.openValueStateMessage();}};b.prototype.onItemChange=function(c){var d=this.getAssociation("selectedItem"),n=c.getParameter("newValue"),p=c.getParameter("name");if(d===c.getParameter("id")){switch(p){case"text":if(!this.isBound("value")){this.setValue(n);}break;case"key":if(!this.isBound("selectedKey")){this.setSelectedKey(n);}break;}}};b.prototype.onkeydown=function(e){var c=e.srcControl;a.prototype.onkeydown.apply(c,arguments);if(!c.getEnabled()||!c.getEditable()){return;}var k=q.sap.KeyCodes;c._bDoTypeAhead=(e.which!==k.BACKSPACE)&&(e.which!==k.DELETE);};b.prototype.oncut=function(e){var c=e.srcControl;a.prototype.oncut.apply(c,arguments);c._bDoTypeAhead=false;};b.prototype.onsapenter=function(e){var c=e.srcControl,i=c.getSelectedItem();if(i&&this.getFilterSecondaryValues()){c.updateDomValue(i.getText());}a.prototype.onsapenter.apply(c,arguments);if(!c.getEnabled()||!c.getEditable()){return;}if(c.isOpen()){c.close();}};b.prototype.onsapdown=function(e){var c=e.srcControl;if(!c.getEnabled()||!c.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToNextSelectableItem(){var d=this.getSelectableItems();var n=d[d.indexOf(this.getSelectedItem())+1];h.call(this,c,n);});};b.prototype.onsapup=function(e){var c=e.srcControl;if(!c.getEnabled()||!c.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToPrevSelectableItem(){var d=this.getSelectableItems();var p=d[d.indexOf(this.getSelectedItem())-1];h.call(this,c,p);});};b.prototype.onsaphome=function(e){var c=e.srcControl;if(!c.getEnabled()||!c.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToFirstSelectableItem(){var F=this.getSelectableItems()[0];h.call(this,c,F);});};b.prototype.onsapend=function(e){var c=e.srcControl;if(!c.getEnabled()||!c.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function navigateToLastSelectableItem(){var L=this.findLastEnabledItem(this.getSelectableItems());h.call(this,c,L);});};b.prototype.onsappagedown=function(e){var c=e.srcControl;if(!c.getEnabled()||!c.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())+10,o;i=(i>d.length-1)?d.length-1:Math.max(0,i);o=d[i];h.call(this,c,o);});};b.prototype.onsappageup=function(e){var c=e.srcControl;if(!c.getEnabled()||!c.getEditable()){return;}e.setMarked();e.preventDefault();this.loadItems(function(){var d=this.getSelectableItems(),i=d.indexOf(this.getSelectedItem())-10,o;i=(i>d.length-1)?d.length-1:Math.max(0,i);o=d[i];h.call(this,c,o);});};b.prototype.onsapshow=function(e){var c,i;a.prototype.onsapshow.apply(this,arguments);if(!this.getValue()){c=this.getSelectableItems();i=c[0];if(i){this.setSelection(i);this.updateDomValue(i.getText());this.fireSelectionChange({selectedItem:i});setTimeout(function(){this.selectText(0,i.getText().length);}.bind(this),0);}}};b.prototype.onsaphide=b.prototype.onsapshow;b.prototype.onfocusin=function(e){var d=this.getPickerType()==="Dropdown";if(e.target===this.getOpenArea()){this.bOpenValueStateMessage=false;if(d&&!this.isPlatformTablet()){this.focus();}}else{if(d){setTimeout(function(){if(document.activeElement===this.getFocusDomRef()&&!this.bFocusoutDueRendering&&!this.getSelectedText()){this.selectText(0,this.getValue().length);}}.bind(this),0);}if(!this.isOpen()&&this.bOpenValueStateMessage&&this.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}this.bOpenValueStateMessage=true;}this.$().addClass("sapMFocus");};b.prototype.onsapfocusleave=function(e){var t,p,r,F,c=e.srcControl,i=c.getSelectedItem();if(i&&this.getFilterSecondaryValues()){c.updateDomValue(i.getText());}a.prototype.onsapfocusleave.apply(this,arguments);if(this.isPickerDialog()){return;}p=this.getAggregation("picker");if(!e.relatedControlId||!p){return;}t=this.isPlatformTablet();r=sap.ui.getCore().byId(e.relatedControlId);F=r&&r.getFocusDomRef();if(q.sap.containsOrEquals(p.getFocusDomRef(),F)&&!t){this.focus();}};b.prototype.setSelection=function(i){var L=this.getList(),k;if(L){L.setSelection(i);}this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",(i instanceof I)?i.getId():i,true);if(typeof i==="string"){i=sap.ui.getCore().byId(i);}k=i?i.getKey():"";this.setProperty("selectedKey",k,true);this._handleAriaActiveDescendant(i);this.toggleStyleClass(this.getRenderer().CSS_CLASS_COMBOBOX+"SelectionActive",!!k);};b.prototype.isSelectionSynchronized=function(){var i=this.getSelectedItem();return this.getSelectedKey()===(i&&i.getKey());};b.prototype.synchronizeSelection=function(){if(this.isSelectionSynchronized()){return;}var k=this.getSelectedKey(),i=this.getItemByKey(""+k);if(i&&(k!=="")){this.setAssociation("selectedItem",i,true);this.setProperty("selectedItemId",i.getId(),true);if(this._sValue===this.getValue()){this.setValue(i.getText());this._sValue=this.getValue();}}};b.prototype.isFiltered=function(){var L=this.getList();return L&&(L.getVisibleItems().length!==L.getItems().length);};b.prototype.isItemVisible=function(i){return i&&(i.bVisible===undefined||i.bVisible);};b.prototype.createPicker=function(p){var o=this.getAggregation("picker");if(o){return o;}o=this["create"+p]();this.setAggregation("picker",o,true);var c=this.getRenderer().CSS_CLASS_COMBOBOXBASE;o.setHorizontalScrolling(false).addStyleClass(c+"Picker").addStyleClass(c+"Picker-CTX").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachBeforeClose(this.onBeforeClose,this).attachAfterClose(this.onAfterClose,this).addEventDelegate({onBeforeRendering:this.onBeforeRenderingPicker,onAfterRendering:this.onAfterRenderingPicker},this).addContent(this.createList());return o;};b.prototype.createList=function(){var r=this.getRenderer();this._oList=new S({width:"100%",busyIndicatorDelay:0}).addStyleClass(r.CSS_CLASS_COMBOBOXBASE+"List").addStyleClass(r.CSS_CLASS_COMBOBOX+"List").addEventDelegate({ontap:function(e){this.close();},onBeforeRendering:this.onBeforeRenderingList,onAfterRendering:this.onAfterRenderingList},this).attachSelectionChange(this.onSelectionChange,this).attachItemPress(this.onItemPress,this);return this._oList;};b.prototype.isItemSelected=function(i){return i&&(i.getId()===this.getAssociation("selectedItem"));};b.prototype.getDefaultSelectedItem=function(){return null;};b.prototype.getChangeEventParams=function(){return{itemPressed:false};};b.prototype.clearSelection=function(){this.setSelection(null);};b.prototype.selectText=function(i,c){a.prototype.selectText.apply(this,arguments);this.textSelectionStart=i;this.textSelectionEnd=c;return this;};b.prototype.addAggregation=function(A,o,c){this._callMethodInControl("addAggregation",arguments);if(A==="items"&&!c&&!this.isInvalidateSuppressed()){this.invalidate(o);}return this;};b.prototype.getAggregation=function(){return this._callMethodInControl("getAggregation",arguments);};b.prototype.setAssociation=function(A,i,c){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.setAssociation.apply(L,arguments);}return a.prototype.setAssociation.apply(this,arguments);};b.prototype.indexOfAggregation=function(){return this._callMethodInControl("indexOfAggregation",arguments);};b.prototype.insertAggregation=function(){this._callMethodInControl("insertAggregation",arguments);return this;};b.prototype.removeAggregation=function(){return this._callMethodInControl("removeAggregation",arguments);};b.prototype.removeAllAggregation=function(){return this._callMethodInControl("removeAllAggregation",arguments);};b.prototype.destroyAggregation=function(A,c){this._callMethodInControl("destroyAggregation",arguments);return this;};b.prototype.setProperty=function(p,v,c){var L=this.getList();if(/selectedKey|selectedItemId/.test(p)){L&&S.prototype.setProperty.apply(L,arguments);}return a.prototype.setProperty.apply(this,arguments);};b.prototype.removeAllAssociation=function(A,c){var L=this.getList();if(L&&(A==="selectedItem")){S.prototype.removeAllAssociation.apply(L,arguments);}return a.prototype.removeAllAssociation.apply(this,arguments);};b.prototype.clone=function(c){var o=a.prototype.clone.apply(this,arguments),L=this.getList();if(!this.isBound("items")&&L){for(var i=0,d=L.getItems();i<d.length;i++){o.addItem(d[i].clone());}o.setSelectedIndex(this.indexOfItem(this.getSelectedItem()));}return o;};b.prototype.findAggregatedObjects=function(){var L=this.getList();if(L){return S.prototype.findAggregatedObjects.apply(L,arguments);}return[];};b.prototype.setShowSecondaryValues=function(A){this.setProperty("showSecondaryValues",A,true);var L=this.getList();if(L){L.setShowSecondaryValues(A);}return this;};b.prototype.getItems=function(){var L=this.getList();return L?L.getItems():[];};b.prototype.setSelectedItem=function(i){if(typeof i==="string"){this.setAssociation("selectedItem",i,true);i=sap.ui.getCore().byId(i);}if(!(i instanceof I)&&i!==null){return this;}if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);this.setValue(this._getSelectedItemText(i));return this;};b.prototype.setSelectedItemId=function(i){i=this.validateProperty("selectedItemId",i);if(!i){i=this.getDefaultSelectedItem();}this.setSelection(i);i=this.getSelectedItem();this.setValue(this._getSelectedItemText(i));return this;};b.prototype.setSelectedKey=function(k){k=this.validateProperty("selectedKey",k);var d=(k===""),c=this.isBound("selectedKey")&&this.isBound("value")&&this.getBindingInfo("selectedKey").skipModelUpdate;if(d){this.setSelection(null);if(!c){this.setValue("");}return this;}var i=this.getItemByKey(k);if(i){this.setSelection(i);if(!c){this.setValue(this._getSelectedItemText(i));}return this;}this._sValue=this.getValue();return this.setProperty("selectedKey",k);};b.prototype.getSelectedItem=function(){var v=this.getAssociation("selectedItem");return(v===null)?null:sap.ui.getCore().byId(v)||null;};b.prototype.updateItems=function(){var r,o=this.getSelectedItem(),r=a.prototype.updateItems.apply(this,arguments);q.sap.clearDelayedCall(this._debounceItemsUpdate);this._debounceItemsUpdate=q.sap.delayedCall(0,this,"_syncItemsSelection",[o]);return r;};b.prototype._syncItemsSelection=function(o){var H,n,c=this.getSelectedKey();if(!o||o===this.getSelectedItem()){return;}n=this.getItems();H=n.some(function(i){return c===i.getKey();});this.setSelectedItem(H&&c?this.getItemByKey(c):null);};b.prototype.removeItem=function(i){i=a.prototype.removeItem.apply(this,arguments);var o;if(this.isBound("items")&&!this.bItemsUpdated){return i;}var v=this.getValue();if(this.getItems().length===0){this.clearSelection();}else if(this.isItemSelected(i)){o=this.getDefaultSelectedItem();this.setSelection(o);this.setValue(v);}return i;};return b;});
