/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./ComboBoxTextField','./Toolbar','./Button','./Bar','./Text','./Title','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ValueStateSupport','./library','sap/ui/Device','sap/ui/core/library','jquery.sap.keycodes'],function(q,D,C,T,B,a,b,c,I,d,V,l,e,f){"use strict";var P=l.PlacementType;var g=f.ValueState;var h=C.extend("sap.m.ComboBoxBase",{metadata:{library:"sap.m","abstract":true,defaultAggregation:"items",aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item",bindable:"bindable"},picker:{type:"sap.ui.core.PopupInterface",multiple:false,visibility:"hidden"}},events:{loadItems:{}}}});var p;h.prototype.updateItems=function(r){this.bItemsUpdated=false;this.destroyItems();this.updateAggregation("items");this.bItemsUpdated=true;if(this.hasLoadItemsEventListeners()){this.onItemsLoaded();}};h.prototype.refreshItems=function(){this.bItemsUpdated=false;this.refreshAggregation("items");};h.prototype.loadItems=function(i,o){var j=typeof i==="function";if(this.hasLoadItemsEventListeners()&&(this.getItems().length===0)){this._bOnItemsLoadedScheduled=false;if(j){o=q.extend({action:i,busyIndicator:true,busyIndicatorDelay:300},o);this.aMessageQueue.push(o);if((this.iLoadItemsEventInitialProcessingTimeoutID===-1)&&(o.busyIndicator)){this.iLoadItemsEventInitialProcessingTimeoutID=setTimeout(function onItemsNotLoadedAfterDelay(){this.setInternalBusyIndicatorDelay(0);this.setInternalBusyIndicator(true);}.bind(this),o.busyIndicatorDelay);}}if(!this.bProcessingLoadItemsEvent){this.bProcessingLoadItemsEvent=true;this.fireLoadItems();}}else if(j){i.call(this);}};h.prototype.onItemsLoaded=function(){this.bProcessingLoadItemsEvent=false;clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);if(this.bInitialBusyIndicatorState!==this.getBusy()){this.setInternalBusyIndicator(this.bInitialBusyIndicatorState);}if(this.iInitialBusyIndicatorDelay!==this.getBusyIndicatorDelay()){this.setInternalBusyIndicatorDelay(this.iInitialBusyIndicatorDelay);}for(var i=0,m,n,j;i<this.aMessageQueue.length;i++){m=this.aMessageQueue.shift();i--;j=(i+1)===this.aMessageQueue.length;n=j?null:this.aMessageQueue[i+1];if(typeof m.action==="function"){if((m.name==="input")&&!j&&(n.name==="input")){continue;}m.action.call(this);}}};h.prototype.hasLoadItemsEventListeners=function(){return this.hasListeners("loadItems");};h.prototype._scheduleOnItemsLoadedOnce=function(){if(!this._bOnItemsLoadedScheduled&&!this.isBound("items")&&this.hasLoadItemsEventListeners()&&this.bProcessingLoadItemsEvent){this._bOnItemsLoadedScheduled=true;setTimeout(this.onItemsLoaded.bind(this),0);}};h.prototype.getPickerInvisibleTextId=function(){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return"";}var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!p){p=new I({text:r.getText("COMBOBOX_AVAILABLE_OPTIONS")}).toStatic().getId();}return p;};h.prototype.init=function(){C.prototype.init.apply(this,arguments);this.setPickerType(e.system.phone?"Dialog":"Dropdown");if(e.system.phone){this.attachEvent("_change",this.onPropertyChange,this);}this.createPicker(this.getPickerType());this.bItemsUpdated=false;this.bOpenedByKeyboardOrButton=false;this._oPickerValueStateText=null;this.bProcessingLoadItemsEvent=false;this.iLoadItemsEventInitialProcessingTimeoutID=-1;this.aMessageQueue=[];this.bInitialBusyIndicatorState=this.getBusy();this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();this._bOnItemsLoadedScheduled=false;this._bDoTypeAhead=true;};h.prototype.onBeforeRendering=function(){var n=this.getValueState()===g.None;C.prototype.onBeforeRendering.apply(this,arguments);if(!this.isPickerDialog()&&n){this._showValueStateText(false);}};h.prototype.exit=function(){C.prototype.exit.apply(this,arguments);if(this.getList()){this.getList().destroy();this._oList=null;}if(this._oPickerValueStateText){this._oPickerValueStateText.destroy();}clearTimeout(this.iLoadItemsEventInitialProcessingTimeoutID);this.aMessageQueue=null;};h.prototype.ontouchstart=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(this.isOpenArea(E.target)){this.addStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};h.prototype.ontouchend=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(!this.isOpen()&&this.isOpenArea(E.target)){this.removeStyleClass(this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Pressed");}};h.prototype.ontap=function(E){C.prototype.ontap.apply(this,arguments);var i=this.getRenderer().CSS_CLASS_COMBOBOXBASE,o=E.srcControl,j;if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(o.isOpenArea&&o.isOpenArea(E.target)){if(this.isOpen()){this.close();this.removeStyleClass(i+"Pressed");return;}this.loadItems();this.bOpenedByKeyboardOrButton=true;if(this.isPlatformTablet()){j=this.getPicker();j.setInitialFocus(j);}this.open();}if(this.isOpen()){this.addStyleClass(i+"Pressed");}};h.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()){return;}E.setMarked();if(E.keyCode===q.sap.KeyCodes.F4){this.onF4(E);}if(this.isOpen()){this.close();return;}this.selectText(0,this.getValue().length);this.loadItems();this.bOpenedByKeyboardOrButton=true;this.open();};h.prototype.onF4=function(E){E.preventDefault();};h.prototype.onsapescape=function(E){if(this.getEnabled()&&this.getEditable()&&this.isOpen()){E.setMarked();E.preventDefault();this.close();}else{C.prototype.onsapescape.apply(this,arguments);}};h.prototype.onsaphide=h.prototype.onsapshow;h.prototype.onsapfocusleave=function(E){if(!E.relatedControlId){C.prototype.onsapfocusleave.apply(this,arguments);return;}var r=sap.ui.getCore().byId(E.relatedControlId);if(r===this){return;}var o=this.getAggregation("picker"),F=r&&r.getFocusDomRef();if(o&&q.sap.containsOrEquals(o.getFocusDomRef(),F)){return;}C.prototype.onsapfocusleave.apply(this,arguments);};h.prototype.getPopupAnchorDomRef=function(){return this.getDomRef();};h.prototype.addContent=function(o){};h.prototype.getList=function(){if(this.bIsDestroyed){return null;}return this._oList;};h.prototype.setPickerType=function(s){this._sPickerType=s;};h.prototype.getPickerType=function(){return this._sPickerType;};h.prototype.setValueState=function(v){var A,s=this.getValueStateText(),S=(v===g.None?false:this.getShowValueStateMessage());this._sOldValueState=this.getValueState();C.prototype.setValueState.apply(this,arguments);this._showValueStateText(S);if(s){this._setValueStateText(s);}else{A=V.getAdditionalText(this);this._setValueStateText(A);}this._alignValueStateStyles();return this;};h.prototype.setValueStateText=function(t){C.prototype.setValueStateText.apply(this,arguments);this._setValueStateText(this.getValueStateText());return this;};h.prototype.setShowValueStateMessage=function(s){C.prototype.setShowValueStateMessage.apply(this,arguments);this._showValueStateText(this.getShowValueStateMessage());return this;};h.prototype._showValueStateText=function(s){var o;if(this.isPickerDialog()){if(this._oPickerValueStateText){this._oPickerValueStateText.setVisible(s);}}else{o=this._getPickerCustomHeader();if(o){o.setVisible(s);}}};h.prototype._setValueStateText=function(t){var H;if(this.isPickerDialog()){this._oPickerValueStateText=this.getPickerValueStateText();this._oPickerValueStateText.setText(t);}else{H=this._getPickerCustomHeader();if(H){H.getContentLeft()[0].setText(t);}}};h.prototype._getPickerCustomHeader=function(){var i,o,j=this.getPicker(),s=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"PickerTitle";if(!j){return null;}if(j.getCustomHeader()){return j.getCustomHeader();}i=new c({textAlign:"Left"}).addStyleClass(s);o=new a({visible:false,contentLeft:i});j.setCustomHeader(o);return o;};h.prototype._alignValueStateStyles=function(){var o=this._sOldValueState,i=this.getRenderer().CSS_CLASS_COMBOBOXBASE+"Picker",s=i+"ValueState",O=i+o+"State",j=i+this.getValueState()+"State",k;if(this.isPickerDialog()&&this._oPickerValueStateText){this._oPickerValueStateText.addStyleClass(s);this._oPickerValueStateText.removeStyleClass(O);this._oPickerValueStateText.addStyleClass(j);}else{k=this._getPickerCustomHeader();if(k){k.addStyleClass(s);k.removeStyleClass(O);k.addStyleClass(j);}}};h.prototype.shouldValueStateMessageBeOpened=function(){var s=C.prototype.shouldValueStateMessageBeOpened.apply(this,arguments);return(s&&!this.isOpen());};h.prototype.onPropertyChange=function(o,i){var n=o.getParameter("newValue"),s=o.getParameter("name"),m="set"+s.charAt(0).toUpperCase()+s.slice(1),j=(i&&i.srcControl)||this.getPickerTextField();if(/\bvalue\b|\benabled\b|\bname\b|\bplaceholder\b|\beditable\b|\btextAlign\b|\btextDirection\b|\bvalueState\b/.test(s)&&j&&(typeof j[m]==="function")){j[m](n);}};h.prototype.isPickerDialog=function(){return this.getPickerType()==="Dialog";};h.prototype.isPlatformTablet=function(){var n=!e.system.combi,t=e.system.tablet&&n;return t;};h.prototype.getDropdownSettings=function(){return{showArrow:false,placement:P.VerticalPreferredBottom,offsetX:0,offsetY:0,bounce:false,ariaLabelledBy:this.getPickerInvisibleTextId()||undefined};};h.prototype.getPickerValueStateText=function(){var o=this.getPicker();if(!this._oPickerValueStateText){this._oPickerValueStateText=new b({width:"100%"});o.insertContent(this._oPickerValueStateText,0);}return this._oPickerValueStateText;};h.prototype.createPicker=function(s){};h.prototype.onBeforeClose=function(){this.bOpenedByKeyboardOrButton=false;};h.prototype.getPicker=function(){if(this.bIsDestroyed){return null;}return this.createPicker(this.getPickerType());};h.prototype.getPickerTextField=function(){var o=this.getPicker(),s=o.getSubHeader();return s&&s.getContent()[0]||null;};h.prototype.getPickerTitle=function(){var o=this.getPicker(),H=o&&o.getCustomHeader();if(this.isPickerDialog()&&H){return H.getContentMiddle()[0];}return null;};h.prototype.createDialog=function(){var t=this,o=this.createPickerTextField(),i=o._handleEvent;o._handleEvent=function(E){i.apply(this,arguments);if(/keydown|sapdown|sapup|saphome|sapend|sappagedown|sappageup|input/.test(E.type)){t._handleEvent(E);}};return new D({stretch:true,customHeader:t.createPickerHeader(),buttons:this.createPickerCloseButton(),subHeader:new T({content:o}),beforeOpen:function(){t.updatePickerHeaderTitle();},ariaLabelledBy:t.getPickerInvisibleTextId()||undefined});};h.prototype.createPickerHeader=function(){var t=this,i=d.getIconURI("decline");return new a({contentMiddle:new c(),contentRight:new B({icon:i,press:function(){t.close();t.revertSelection();}})});};h.prototype.revertSelection=function(){};h.prototype.updatePickerHeaderTitle=function(){var o=this.getPicker(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),L,i;if(!o){return;}i=this.getLabels();if(i.length){L=i[0];if(L&&(typeof L.getText==="function")){this.getPickerTitle().setText(L.getText());}}else{this.getPickerTitle().setText(r.getText("COMBOBOX_PICKER_TITLE"));}};h.prototype.createPickerCloseButton=function(){var t=this,o,r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("COMBOBOX_CLOSE_BUTTON"),press:function(){o=t.getPickerTextField();t.updateDomValue(o.getValue());t.onChange();t.close();}});};h.prototype.hasContent=function(){return this.getItems().length>0;};h.prototype.findFirstEnabledItem=function(i){var L=this.getList();return L?L.findFirstEnabledItem(i):null;};h.prototype.findLastEnabledItem=function(i){var L=this.getList();return L?L.findLastEnabledItem(i):null;};h.prototype.open=function(){var o=this.getPicker();if(o){o.open();}return this;};h.prototype.getVisibleItems=function(){var L=this.getList();return L?L.getVisibleItems():[];};h.prototype.isItemSelected=function(){};h.prototype.getKeys=function(j){j=j||this.getItems();for(var i=0,k=[];i<j.length;i++){k[i]=j[i].getKey();}return k;};h.prototype.getSelectableItems=function(){var L=this.getList();return L?L.getSelectableItems():[];};h.prototype.findItem=function(s,v){var L=this.getList();return L?L.findItem(s,v):null;};h.prototype.getItemByText=function(t){return this.findItem("text",t);};h.prototype.scrollToItem=function(i){var o=this.getPicker(),j=o.getDomRef("cont"),k=i&&i.getDomRef();if(!o||!j||!k){return;}var m=j.scrollTop,n=k.offsetTop,r=j.clientHeight,s=k.offsetHeight;if(m>n){j.scrollTop=n;}else if((n+s)>(m+r)){j.scrollTop=Math.ceil(n+s-r);}};h.prototype.clearFilter=function(){for(var i=0,j=this.getItems();i<j.length;i++){j[i].bVisible=true;}};h.prototype.onItemChange=function(o){};h.prototype.clearSelection=function(){};h.prototype.setInternalBusyIndicator=function(i){this.bInitialBusyIndicatorState=this.getBusy();return this.setBusy.apply(this,arguments);};h.prototype.setInternalBusyIndicatorDelay=function(i){this.iInitialBusyIndicatorDelay=this.getBusyIndicatorDelay();return this.setBusyIndicatorDelay.apply(this,arguments);};h.prototype.addItem=function(i){this.addAggregation("items",i);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};h.prototype.insertItem=function(i,j){this.insertAggregation("items",i,j,true);if(i){i.attachEvent("_change",this.onItemChange,this);}this._scheduleOnItemsLoadedOnce();return this;};h.prototype.getItemAt=function(i){return this.getItems()[+i]||null;};h.prototype.getFirstItem=function(){return this.getItems()[0]||null;};h.prototype.getLastItem=function(){var i=this.getItems();return i[i.length-1]||null;};h.prototype.getEnabledItems=function(i){var L=this.getList();return L?L.getEnabledItems(i):[];};h.prototype.getItemByKey=function(k){var L=this.getList();return L?L.getItemByKey(k):null;};h.prototype.isOpen=function(){var o=this.getAggregation("picker");return!!(o&&o.isOpen());};h.prototype.close=function(){var o=this.getAggregation("picker");if(o){o.close();}return this;};h.prototype.removeItem=function(i){var L=this.getList();i=L?L.removeItem(i):null;if(i){i.detachEvent("_change",this.onItemChange,this);}return i;};h.prototype.removeAllItems=function(){var L=this.getList(),j=L?L.removeAllItems():[];this.clearSelection();for(var i=0;i<j.length;i++){j[i].detachEvent("_change",this.onItemChange,this);}return j;};h.prototype.destroyItems=function(){var L=this.getList();if(L){L.destroyItems();}return this;};return h;});
