/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Icon'],function(q,l,C,E,I,a,S,b,B,R,c,D,d,e){"use strict";var t=l.touch;var f=l.ImageHelper;var P=l.PlacementType;var g=l.ButtonType;var h=l.BackgroundDesign;var j=l.IconTabHeaderMode;var k=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:j.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:h.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});E.apply(k.prototype,[true]);k.ANIMATION_DURATION=sap.ui.getCore().getConfiguration().getAnimation()?200:0;k.SCROLL_STEP=264;k.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};k.prototype.isTouchScrollingDisabled=function(){return this.getShowOverflowSelectList()&&this.getParent().getMetadata().getName()=='sap.tnt.ToolHeader';};k.prototype._getSelectList=function(){var i=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(o){var T=o.getParameter('selectedItem');i.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};k.prototype._getOverflowButton=function(){if(!this._oOverflowButton){this._oOverflowButton=new B({id:this.getId()+'-overflow',icon:"sap-icon://overflow",type:g.Transparent,press:this._overflowButtonPress.bind(this)});}return this._oOverflowButton;};k.prototype._overflowButtonPress=function(i){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:P.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};k.prototype._createPopoverCloseButton=function(){var i=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("SELECT_CANCEL_BUTTON"),press:function(){i._closeOverflow();}});};k.prototype._closeOverflow=function(){if(!D.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};k.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,T,o=this._getSelectList(),m=this.getTabFilters();o.removeAllItems();for(var i=0;i<m.length;i++){T=m[i];s=T.clone();s._tabFilter=T;o.addItem(s);if(T==this.oSelectedItem){o.setSelectedItem(s);}}};k.prototype._findSelectItem=function(T){var s=this._getSelectList(),m=s.getItems(),o;for(var i=0;i<m.length;i++){o=m[i];if(o._tabFilter==T){return o;}}};k.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var m=this.getItems();var n=-1;var o;for(var i=0;i<m.length;i++){o=m[i];if(o instanceof c==false){continue;}n++;if(this.oSelectedItem==o){break;}}this._oItemNavigation.setFocusedIndex(n);};k.prototype._onItemNavigationAfterFocus=function(o){var H=this.getDomRef("head"),i=o.getParameter("index"),$=o.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=H.scrollLeft;this._checkOverflow();if(i!==null&&i!==undefined){this._scrollIntoView(this.getTabFilters()[i],0);}};k.prototype.getTabFilters=function(){var i=this.getItems();var T=[];i.forEach(function(o){if(o instanceof c){T.push(o);}});return T;};k.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oOverflowButton){this._oOverflowButton.destroy();this._oOverflowButton=null;}};k.prototype.onBeforeRendering=function(){var m=this.getItems(),s=this.getSelectedKey(),i=0,p=this.getParent(),n=p instanceof sap.m.IconTabBar,o=p&&p.getMetadata().getName()=='sap.tnt.ToolHeader';if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(m.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<m.length;i++){if(!(m[i]instanceof sap.m.IconTabSeparator)&&m[i]._getNonEmptyKey()===s){this.oSelectedItem=m[i];break;}}}if(!this.oSelectedItem&&(n||!s)){for(i=0;i<m.length;i++){if(!(m[i]instanceof sap.m.IconTabSeparator)&&m[i].getVisible()){this.oSelectedItem=m[i];break;}}}}if(!o&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<m.length;i++){if(!(m[i]instanceof sap.m.IconTabSeparator)&&m[i].getVisible()){this.oSelectedItem=m[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}this._isTouchScrollingDisabled=this.isTouchScrollingDisabled();this._oScroller.setHorizontal(!this._isTouchScrollingDisabled);if(this._sResizeListenerNoFlexboxSupportId){d.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};k.prototype.setSelectedKey=function(K){var m=this.getTabFilters(),i=0,p=this.getParent(),n=p instanceof sap.m.IconTabBar,s;if(m.length>0){K=K||m[0]._getNonEmptyKey();}if(this.$().length){for(;i<m.length;i++){if(m[i]._getNonEmptyKey()===K){this.setSelectedItem(m[i],true);s=true;break;}}if(!s&&!n&&K){this.setSelectedItem(null);}}this.setProperty("selectedKey",K,true);return this;};k.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this.oSelectedItem.$().removeClass("sapMITBSelected");this.oSelectedItem=null;}return this;}if(!i.getEnabled()){return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var p=this.getParent();var m=p instanceof sap.m.IconTabBar;var n=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){n=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&m&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&m&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(m){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!m){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(m&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var o=this.oSelectedItem.getContent();if(o.length>0){p._rerenderContent(o);}else{if(!n){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}this.oSelectedItem=i;var r=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",r,true);if(m){p.setProperty("selectedKey",r,true);}if(!A){if(m){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:r,item:this.oSelectedItem,key:r});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:r,item:this.oSelectedItem,key:r});}}return this;};k.prototype.getVisibleTabFilters=function(){var m=this.getTabFilters(),v=[],o;for(var i=0;i<m.length;i++){o=m[i];if(o.getVisible()){v.push(o);}}return v;};k.prototype._getFirstVisibleItem=function(m){for(var i=0;i<m.length;i++){if(m[i].getVisible()){return m[i];}}return null;};k.prototype._initItemNavigation=function(){var i=this,H=this.getDomRef("head"),m=this.getItems(),T=[],s=-1;m.forEach(function(o){if(o instanceof c){var n=i.getFocusDomRef(o);q(n).attr("tabindex","-1");T.push(n);if(o===i.oSelectedItem){s=T.indexOf(n);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(H);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setSelectedIndex(s);};k.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=p instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}q.sap.delayedCall(350,this,"_checkOverflow");if(this.oSelectedItem){this._scrollIntoView(this.oSelectedItem,500);}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=d.register(this.getDomRef(),q.proxy(this._fnResize,this));if(!q.support.newFlexBoxLayout&&i&&p.getStretchContentHeight()){this._sResizeListenerNoFlexboxSupportId=d.register(p.getDomRef(),q.proxy(this._fnResizeNoFlexboxSupport,this));this._fnResizeNoFlexboxSupport();}this._bCheckIfIntoView=true;};k.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};k.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.addAggregation("items",i);};k.prototype.insertItem=function(i,m){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.insertAggregation("items",i,m);};k.prototype.removeAllItems=function(){this._aTabKeys=[];this.removeAllAggregation("items");};k.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(K),1);}return i;};k.prototype.updateAggregation=function(){this.oSelectedItem=null;return C.prototype.updateAggregation.apply(this,arguments);};k.prototype.removeAggregation=function(A,o,s){var i=this.getTabFilters();var m=C.prototype.removeAggregation.apply(this,arguments);if(this._oDragContext){return m;}if(m&&m==this.oSelectedItem&&A=='items'){var n=q.inArray(m,i);i=this.getTabFilters();n=Math.max(0,Math.min(n,i.length-1));var p=i[n];if(p){this.setSelectedItem(p,true);}else{var r=this.getParent();if(r instanceof sap.m.IconTabBar&&r.getExpanded()){r.$("content").children().remove();}}}return m;};k.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};k.prototype._getDisplayText=function(i){var T=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){T='('+s+') '+T;}else{T+=' ('+s+')';}}}return T;};k.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==j.Inline;};k.prototype._checkTextOnly=function(m){if(m.length>0){for(var i=0;i<m.length;i++){if(!(m[i]instanceof sap.m.IconTabSeparator)){if(m[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};k.prototype._checkNoText=function(m){if(m.length>0){for(var i=0;i<m.length;i++){if(!(m[i]instanceof sap.m.IconTabSeparator)){if(m[i].getText().length>0){return false;}}}}return true;};k.prototype._checkInLine=function(m){var o;if(m.length>0){for(var i=0;i<m.length;i++){o=m[i];if(!(o instanceof sap.m.IconTabSeparator)){if(o.getIcon()||o.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};k.prototype._checkScrolling=function(H){var $=this.$();var s=false;var i=this.getDomRef("scrollContainer");var m=this.getDomRef("head");if(m&&i){if(m.offsetWidth>i.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}this._setTabsVisibility();return s;};k.prototype._getScrollingArrow=function(n){var s=a.getIconURI("slim-arrow-"+n);var p={src:s,useIconTooltip:false};var i=this._bTextOnly?"TextOnly":"";var L="sapMITBArrowScrollLeft"+i;var r="sapMITBArrowScrollRight"+i;var m=["sapMITBArrowScroll",L];var o=["sapMITBArrowScroll",r];if(this._bInLine){m.push('sapMITBArrowScrollLeftInLine');o.push('sapMITBArrowScrollRightInLine');}if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=f.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,m);}return this._oArrowLeft;}if(n==="right"){if(!this._oArrowRight){this._oArrowRight=f.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,o);}return this._oArrowRight;}};k.prototype._checkOverflow=function(){var o=this.getDomRef("head");var $=this.$();if(this._checkScrolling(o)&&o){var s=false;var i=false;var m=this.getDomRef("scrollContainer");var n=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+m.offsetWidth)<n.offsetWidth){i=true;}if((i!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=i;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",i);$.toggleClass("sapMITBNoScrollForward",!i);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};k.prototype._handleActivation=function(o){var T=o.target.id,i=o.srcControl,s;if(this._oDragContext&&this._oDragContext.movedTabIndexes.length){return;}if(i instanceof B){return;}var $=q.sap.byId(T);if(q.inArray(this.$("content")[0],$.parents())>-1){}else{if(T){var m=this.getId();o.preventDefault();if(T==m+"-arrowScrollLeft"&&D.system.desktop){var n=this._oScroller.getScrollLeft()-k.SCROLL_STEP;if(n<0){n=0;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[n,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else if(T==m+"-arrowScrollRight"&&D.system.desktop){var n=this._oScroller.getScrollLeft()+k.SCROLL_STEP;var p=this.$("scrollContainer").width();var H=this.$("head").width();if(n>(H-p)){n=H-p;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[n,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else{if(i instanceof e||i instanceof sap.m.Image){s=o.srcControl.getId().replace(/-icon$/,"");i=sap.ui.getCore().byId(s);if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof sap.m.IconTabSeparator)){this.setSelectedItem(i);}}else if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof sap.m.IconTabSeparator)){this.setSelectedItem(i);}}}else{if(i.getMetadata().isInstanceOf("sap.m.IconTab")&&!(i instanceof sap.m.IconTabSeparator)){this.setSelectedItem(i);}}}};k.prototype._scrollIntoView=function(i,m){var $=i.$(),s,n,o;if($.length>0){var p=this.$('head');var H=p.innerWidth()-p.width();var r=$.outerWidth(true);var u=$.position().left-H/2;s=this._oScroller.getScrollLeft();o=this.$("scrollContainer").width();n=0;if(u-s<0||u-s>o-r){if(u-s<0){n+=u;}else{n+=Math.min(u,u+r-o);}this._scrollPreparation();this._iCurrentScrollLeft=n;q.sap.delayedCall(0,this._oScroller,"scrollTo",[n,0,m]);q.sap.delayedCall(m,this,"_afterIscroll");}}return this;};k.prototype._scroll=function(i,m){this._scrollPreparation();var o=this.getDomRef("head");var s=o.scrollLeft;var n=D.browser.msie||D.browser.edge;if(!n&&this._bRtl){i=-i;}var p=s+i;q(o).stop(true,true).animate({scrollLeft:p},m,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=p;};k.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(D.system.desktop){this._checkOverflow();}};k.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};k.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();this._setTabsVisibility();};k.prototype._fnResize=function(){this._checkOverflow();if(this.oSelectedItem&&this._bCheckIfIntoView){this._scrollIntoView(this.oSelectedItem,0);if(!this._isTouchScrollingDisabled){this._bCheckIfIntoView=false;}}this._setTabsVisibility();};k.prototype._fnResizeNoFlexboxSupport=function(){var $=this.getParent().$("containerContent"),i=$.outerHeight(true)-$.height();$.height(this.getParent().$().height()-$.position().top-i);};k.prototype._setTabsVisibility=function(){if(!this._isTouchScrollingDisabled){return;}var T=this.getItems(),o,$,H,i;for(i=0;i<T.length;i++){o=T[i];$=o.$();if(!$.hasClass('sapMITBSelected')&&!this._isTabIntoView($)){$.addClass('sapMITBFilterHidden');}else{H=true;$.removeClass('sapMITBFilterHidden');}}if(!H){for(i=0;i<T.length;i++){o=T[i];$=o.$();if(this._isTabIntoView($,true)){$.removeClass('sapMITBFilterHidden');break;}}}this._moveVisibleTabs();};k.prototype._isTabIntoView=function($,s){if(!$.length){return false;}var i=this._oScroller.getScrollLeft(),m=this.$("scrollContainer").width(),n=this.$('head'),H=n.innerWidth()-n.width(),o=$.css('margin-left'),p=$.outerWidth()+parseFloat(o),r=Math.ceil($.position().left-H/2);if(r-i<0||(!s&&(r+p-i>m))){return false;}return true;};k.prototype._moveVisibleTabs=function(){if(!this._oScroller){return;}var s=this._oScroller.getScrollLeft(),$=this.$('head'),H=$.innerWidth()-$.width(),i=this.$().find('.sapMITBFilter:not(.sapMITBFilterHidden)').first(),m,n;if(!i.length){return;}n=i.position().left-H/2;if(!this._bRtl&&n-s>2){m=s-n;$.css('transform','translate('+m+'px)');}else{$.css('transform','');}return true;};k.prototype.onExit=function(){if(this._sResizeListenerNoFlexboxSupportId){d.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};k.prototype.getFocusDomRef=function(F){var T=F||this.oSelectedItem;if(!T){return null;}return T.getDomRef();};k.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).focus();}};k.prototype.ontouchstart=function(o){var T=o.targetTouches[0];this._iActiveTouch=T.identifier;this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;this._iTouchDragX=0;this._iTouchDragY=0;var $=q(o.target);if($.hasClass('sapMITBArrowScroll')){o.preventDefault();}if(D.browser.msie){if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){o.preventDefault();}}};k.prototype.ontouchmove=function(o){if(this._iActiveTouch===undefined){return;}var T=t.find(o.changedTouches,this._iActiveTouch);if(!T||T.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-T.pageX);this._iTouchDragY+=Math.abs(this._iTouchStartPageY-T.pageY);this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;};k.prototype.ontouchend=function(o){if(this._iActiveTouch===undefined){return;}var m=D.system.desktop?5:15;if((this._scrollable&&this._iTouchDragX>m)||this._iTouchDragY>m){return;}var M=0;var L=1;var i;if(o.which===i||o.which===M||o.which===L){this._handleActivation(o);}this._iActiveTouch=undefined;};k.prototype.ontouchcancel=k.prototype.ontouchend;k.prototype.onsapselect=function(o){this._handleActivation(o);};k.prototype.onmousedown=function(o){if(!this.getEnableTabReordering()){return;}var i=!!o.originalEvent["touches"];if(i){return;}var $=q(o.target);var m=$.closest(".sapMITBFilter, .sapMITBAll");if(m.length===1){this._onTabMoveStart(m,o);}};k.prototype._onTabMoveStart=function($,o){var i=this._getItemIndex($),m=this.$().find('.sapMITBHead').children(),w=$.outerWidth(true),n=q(document);o.preventDefault();$.zIndex(this.$().zIndex()+10);this._oDragContext={index:q.inArray($[0],m),tabIndex:i,startX:o.pageX,$tab:$,tab:this.getItems()[i],tabWidth:w,tabCenter:$.position().left+w/2,movedTabIndexes:[]};this._oScroller.setHorizontal(false);n.mousemove(q.proxy(this._onTabMove,this));n.mouseup(q.proxy(this._onTabMoved,this));};k.prototype._onTabMove=function(o){var m=this._oDragContext;if(!m){return;}var p=o.pageX,n=p-m.startX,$,x,O,r,s=this.$().find('.sapMITBHead').children(),M=m.movedTabIndexes,u=sap.ui.getCore().getConfiguration().getRTL();m.$tab.css({left:n});for(var i=0;i<s.length;i++){if(i==m.index){continue;}$=q(s[i]);x=$.position().left;O=parseFloat($.css('left'));if(!isNaN(O)){x-=O;}if(i<m.index!=u){r=x+$.outerWidth(true)>m.tabCenter+n;this._onAnimateTab($,m.tabWidth,r,M,i);}else{r=x<m.tabCenter+n;this._onAnimateTab($,-m.tabWidth,r,M,i);}}};k.prototype._onAnimateTab=function($,i,r,m,n){var o=q.inArray(n,m),p=o!=-1;if(r&&!p){$.stop(true,true);$.animate({left:i},k.ANIMATION_DURATION);m.push(n);}else if(!r&&p){$.stop(true,true);$.animate({left:0},k.ANIMATION_DURATION);m.splice(o,1);}};k.prototype._onTabMoved=function(o){var i=this._oDragContext;if(!i){return;}var m=i.movedTabIndexes;if(m.length>0){var $=i.$tab,n=this.$().find('.sapMITBHead').children(),N=m[m.length-1],p=this._getItemIndex(q(n[N]));this.removeAggregation('items',i.tab,true);this.insertAggregation('items',i.tab,p,true);if(N>i.index){$.insertAfter(q(n[N]));}else{$.insertBefore(q(n[N]));}this._initItemNavigation();q.sap.delayedCall(100,this,function(){$.focus();});}this._stopMoving();};k.prototype._stopMoving=function(){var o=this._oDragContext,$=o.$tab,i=this.$().find('.sapMITBHead').children();$.css('z-index','');i.stop(true,true);i.css('left','');this._oDragContext=null;var m=q(document);m.off("mousemove",this._onTabMove);m.off("mouseup",this._onTabMoved);this._oScroller.setHorizontal(true);this._enableTextSelection();};k.prototype._getItemIndex=function($){var s=$.attr('id'),T=this.getItems();for(var i=0;i<T.length;i++){if(T[i].getId()==s){return i;}}return-1;};k.prototype._disableTextSelection=function(o){q(o||document.body).attr("unselectable","on").addClass('sapMITBNoSelection').bind("selectstart",function(i){i.preventDefault();return false;});};k.prototype._enableTextSelection=function(o){q(o||document.body).attr("unselectable","off").removeClass('sapMITBNoSelection').unbind("selectstart");};return k;});
