/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Bar','./Dialog','./InputBase','./List','./Popover','sap/ui/core/Item','./ColumnListItem','./StandardListItem','./DisplayListItem','sap/ui/core/ListItem','./Table','./Toolbar','./ToolbarSpacer','./library','sap/ui/core/IconPool','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Control'],function(q,B,D,I,L,P,a,C,S,b,c,T,d,e,l,f,g,h,R,j){"use strict";var k=l.ListMode;var m=l.PlacementType;var n=l.ListType;var o=l.InputTextFormatMode;var p=l.InputType;var r=I.extend("sap.m.Input",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.InputType",group:"Data",defaultValue:p.Text},maxLength:{type:"int",group:"Behavior",defaultValue:0},dateFormat:{type:"string",group:"Misc",defaultValue:'YYYY-MM-dd',deprecated:true},showValueHelp:{type:"boolean",group:"Behavior",defaultValue:false},showSuggestion:{type:"boolean",group:"Behavior",defaultValue:false},valueHelpOnly:{type:"boolean",group:"Behavior",defaultValue:false},filterSuggests:{type:"boolean",group:"Behavior",defaultValue:true},maxSuggestionWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null},startSuggestion:{type:"int",group:"Behavior",defaultValue:1},showTableSuggestionValueHelp:{type:"boolean",group:"Behavior",defaultValue:true},description:{type:"string",group:"Misc",defaultValue:null},fieldWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'50%'},valueLiveUpdate:{type:"boolean",group:"Behavior",defaultValue:false},selectedKey:{type:"string",group:"Data",defaultValue:""},textFormatMode:{type:"sap.m.InputTextFormatMode",group:"Misc",defaultValue:o.Value},textFormatter:{type:"any",group:"Misc",defaultValue:""},suggestionRowValidator:{type:"any",group:"Misc",defaultValue:""},enableSuggestionsHighlighting:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"suggestionItems",aggregations:{suggestionItems:{type:"sap.ui.core.Item",multiple:true,singularName:"suggestionItem"},suggestionColumns:{type:"sap.m.Column",multiple:true,singularName:"suggestionColumn",bindable:"bindable"},suggestionRows:{type:"sap.m.ColumnListItem",multiple:true,singularName:"suggestionRow",bindable:"bindable"},_valueHelpIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.core.Item",multiple:false},selectedRow:{type:"sap.m.ColumnListItem",multiple:false}},events:{liveChange:{parameters:{value:{type:"string"},escPressed:{type:"boolean"},previousValue:{type:"string"}}},valueHelpRequest:{parameters:{fromSuggestions:{type:"boolean"}}},suggest:{parameters:{suggestValue:{type:"string"},suggestionColumns:{type:"sap.m.ListBase"}}},suggestionItemSelected:{parameters:{selectedItem:{type:"sap.ui.core.Item"},selectedRow:{type:"sap.m.ColumnListItem"}}},submit:{parameters:{value:{type:"string"}}}}}});f.insertFontFaceStyle();r._wordStartsWithValue=function(t,v){var i;while(t){if(q.sap.startsWithIgnoreCase(t,v)){return true;}i=t.indexOf(' ');if(i==-1){break;}t=t.substring(i+1);}return false;};r._DEFAULTFILTER=function(v,i){if(i instanceof c&&r._wordStartsWithValue(i.getAdditionalText(),v)){return true;}return r._wordStartsWithValue(i.getText(),v);};r._DEFAULTFILTER_TABULAR=function(v,s){var t=s.getCells(),i=0;for(;i<t.length;i++){if(t[i].getText){if(r._wordStartsWithValue(t[i].getText(),v)){return true;}}}return false;};r._DEFAULTRESULT_TABULAR=function(s){var t=s.getCells(),i=0;for(;i<t.length;i++){if(t[i].getText){return t[i].getText();}}return"";};r.prototype.init=function(){I.prototype.init.call(this);this._fnFilter=r._DEFAULTFILTER;this._bUseDialog=h.system.phone;this._bFullScreen=h.system.phone;this._iSetCount=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(!r._sAriaPopupLabelId){r._sAriaPopupLabelId=new g({text:this._oRb.getText("INPUT_AVALIABLE_VALUES")}).toStatic().getId();}};r.prototype.exit=function(){this._deregisterEvents();this.cancelPendingSuggest();if(this._iRefreshListTimeout){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=null;}if(this._oSuggestionPopup){this._oSuggestionPopup.destroy();this._oSuggestionPopup=null;}if(this._oList){this._oList.destroy();this._oList=null;}if(this._oSuggestionTable){this._oSuggestionTable.destroy();this._oSuggestionTable=null;}if(this._oButtonToolbar){this._oButtonToolbar.destroy();this._oButtonToolbar=null;}if(this._oShowMoreButton){this._oShowMoreButton.destroy();this._oShowMoreButton=null;}};r.prototype._resizePopup=function(F){var t=this;if(F){this._shouldResizePopup=true;}if(this._oList&&this._oSuggestionPopup&&this._shouldResizePopup){if(this.getMaxSuggestionWidth()){this._oSuggestionPopup.setContentWidth(this.getMaxSuggestionWidth());}else{this._oSuggestionPopup.setContentWidth((this.$().outerWidth())+"px");}setTimeout(function(){if(t._oSuggestionPopup&&t._oSuggestionPopup.isOpen()&&t._oSuggestionPopup.$().outerWidth()<t.$().outerWidth()){t._oSuggestionPopup.setContentWidth((t.$().outerWidth())+"px");}},0);}};r.prototype.onBeforeRendering=function(){var s=this.getSelectedKey();I.prototype.onBeforeRendering.call(this);this._deregisterEvents();if(s){this.setSelectedKey(s);}if(this.getShowSuggestion()){if(this.getShowTableSuggestionValueHelp()){this._addShowMoreButton();}else{this._removeShowMoreButton();}}};r.prototype.onAfterRendering=function(){var t=this;I.prototype.onAfterRendering.call(this);if(!this._bFullScreen){this._sPopupResizeHandler=R.register(this.getDomRef(),function(){t._resizePopup();});}if(this._bUseDialog&&this.getEditable()&&this.getEnabled()){this.$().on("click",q.proxy(function(E){if(this._onclick){this._onclick(E);}if(this.getShowSuggestion()&&this._oSuggestionPopup&&E.target.id!=this.getId()+"-vhi"){this._resizePopup(true);this._oSuggestionPopup.open();}},this));}};r.prototype._getDisplayText=function(i){var t=this.getTextFormatter();if(t){return t(i);}var s=i.getText(),K=i.getKey(),u=this.getTextFormatMode();switch(u){case o.Key:return K;case o.ValueKey:return s+' ('+K+')';case o.KeyValue:return'('+K+') '+s;default:return s;}};r.prototype._onValueUpdated=function(i){if(this._bSelectingItem||i===this._sSelectedValue){return;}var K=this.getSelectedKey(),H;if(K===''){return;}if(this._hasTabularSuggestions()){H=!!this._oSuggestionTable.getSelectedItem();}else{H=!!this._oList.getSelectedItem();}if(H){return;}this.setProperty("selectedKey",'',true);this.setAssociation("selectedRow",null,true);this.setAssociation("selectedItem",null,true);this.fireSuggestionItemSelected({selectedItem:null,selectedRow:null});};r.prototype._updateSelectionFromList=function(){if(this._iPopupListSelectedIndex<0){return false;}var s=this._oList.getSelectedItem();if(s){if(this._hasTabularSuggestions()){this.setSelectionRow(s,true);}else{this.setSelectionItem(s._oItem,true);}}return true;};r.prototype.setSelectionItem=function(i,s){if(!i){this.setAssociation("selectedItem",null,true);this.setProperty("selectedKey",'',true);this.setValue('');return;}this._bSelectingItem=true;var t=this._iSetCount,N;this.setAssociation("selectedItem",i,true);this.setProperty("selectedKey",i.getKey(),true);if(s){this.fireSuggestionItemSelected({selectedItem:i});}if(t!==this._iSetCount){N=this.getValue();}else{N=this._getDisplayText(i);}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!h.support.touch){this._doSelect();}this._bSelectingItem=false;};r.prototype.setSelectedItem=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof a)){return this;}this.setSelectionItem(i);return this;};r.prototype.setSelectedKey=function(K){K=this.validateProperty("selectedKey",K);if(this._hasTabularSuggestions()){this.setProperty("selectedKey",K,true);return this;}if(!K){this.setSelectionItem();return this;}var i=this.getSuggestionItemByKey(K);if(i){this.setSelectionItem(i);}else{this.setProperty("selectedKey",K,true);}return this;};r.prototype.getSuggestionItemByKey=function(K){var s=this.getSuggestionItems()||[],t,i;for(i=0;i<s.length;i++){t=s[i];if(t.getKey()===K){return t;}}};r.prototype.setSelectionRow=function(i,s){if(!i){this.setAssociation("selectedRow",null,true);this.setProperty("selectedKey",'',true);this.setValue('');return;}this._bSelectingItem=true;var t,u=this.getSuggestionRowValidator();if(u){t=u(i);if(!(t instanceof a)){t=null;}}var v=this._iSetCount,K="",N;this.setAssociation("selectedRow",i,true);if(t){K=t.getKey();}this.setProperty("selectedKey",K,true);if(s){this.fireSuggestionItemSelected({selectedRow:i});}if(v!==this._iSetCount){N=this.getValue();}else{if(t){N=this._getDisplayText(t);}else{N=this._fnRowResultFilter?this._fnRowResultFilter(i):r._DEFAULTRESULT_TABULAR(i);}}this._sSelectedValue=N;this.updateInputField(N);this._iPopupListSelectedIndex=-1;if(!(this._bUseDialog&&this instanceof sap.m.MultiInput&&this._isMultiLineMode)){this._closeSuggestionPopup();}if(!h.support.touch){this._doSelect();}this._bSelectingItem=false;};r.prototype.setSelectedRow=function(i){if(typeof i==="string"){i=sap.ui.getCore().byId(i);}if(i!==null&&!(i instanceof C)){return this;}this.setSelectionRow(i);return this;};r.prototype._getValueHelpIcon=function(){var t=this,v=this.getAggregation("_valueHelpIcon"),u;if(v){return v;}u=f.getIconURI("value-help");v=f.createControlByURI({id:this.getId()+"-vhi",src:u,useIconTooltip:false,noTabStop:true});v.addStyleClass("sapMInputValHelpInner");v.attachPress(function(i){if(!t.getValueHelpOnly()){this.getParent().focus();t.fireValueHelpRequest({fromSuggestions:false});}});this.setAggregation("_valueHelpIcon",v);return v;};r.prototype._fireValueHelpRequestForValueHelpOnly=function(){if(this.getEnabled()&&this.getEditable()&&this.getShowValueHelp()&&this.getValueHelpOnly()){this.fireValueHelpRequest({fromSuggestions:false});}};r.prototype.ontap=function(E){I.prototype.ontap.call(this,E);this._fireValueHelpRequestForValueHelpOnly();};r.prototype.setWidth=function(w){return I.prototype.setWidth.call(this,w||"100%");};r.prototype.getWidth=function(){return this.getProperty("width")||"100%";};r.prototype.setFilterFunction=function(F){if(F===null||F===undefined){this._fnFilter=r._DEFAULTFILTER;return this;}this._fnFilter=F;return this;};r.prototype.setRowResultFunction=function(F){var s;if(F===null||F===undefined){this._fnRowResultFilter=r._DEFAULTRESULT_TABULAR;return this;}this._fnRowResultFilter=F;s=this.getSelectedRow();if(s){this.setSelectedRow(s);}return this;};r.prototype.closeSuggestions=function(){this._closeSuggestionPopup();};r.prototype.setShowValueHelp=function(s){this.setProperty("showValueHelp",s);if(s&&!r.prototype._sAriaValueHelpLabelId){r.prototype._sAriaValueHelpLabelId=new g({text:this._oRb.getText("INPUT_VALUEHELP")}).toStatic().getId();}return this;};r.prototype.setValueHelpOnly=function(v){this.setProperty("valueHelpOnly",v);if(v&&!r.prototype._sAriaInputDisabledLabelId){r.prototype._sAriaInputDisabledLabelId=new g({text:this._oRb.getText("INPUT_DISABLED")}).toStatic().getId();}return this;};r.prototype._doSelect=function(s,E){if(h.support.touch){return;}var i=this._$input[0];if(i){var $=this._$input;i.focus();$.selectText(s?s:0,E?E:$.val().length);}return this;};r.prototype._scrollToItem=function(i){var s=this._oSuggestionPopup,t=this._oList,u,v,w,x,y;if(!(s instanceof P)||!t){return;}u=s.getScrollDelegate();if(!u){return;}var z=t.getItems()[i],A=z&&z.getDomRef();if(!A){return;}v=s.getDomRef("cont").getBoundingClientRect();w=A.getBoundingClientRect();x=v.top-w.top;y=w.bottom-v.bottom;if(x>0){u.scrollTo(u._scrollX,Math.max(u._scrollY-x,0));}else if(y>0){u.scrollTo(u._scrollX,u._scrollY+y);}};r.prototype._isSuggestionItemSelectable=function(i){return i.getVisible()&&(this._hasTabularSuggestions()||i.getType()!==n.Inactive);};r.prototype._isIncrementalType=function(){var t=this.getType();if(t==="Number"||t==="Date"||t==="Datetime"||t==="Month"||t==="Time"||t==="Week"){return true;}return false;};r.prototype._onsaparrowkey=function(E,s,i){if(!this.getEnabled()||!this.getEditable()){return;}if(s!=="up"&&s!=="down"){return;}if(this._isIncrementalType()){E.setMarked();}if(!this._oSuggestionPopup||!this._oSuggestionPopup.isOpen()){return;}E.preventDefault();E.stopPropagation();var F=false,t=this._oList,u=this.getSuggestionItems(),v=t.getItems(),w=this._iPopupListSelectedIndex,N,O=w;if(s==="up"&&w===0){return;}if(s=="down"&&w===v.length-1){return;}var x;if(i>1){if(s=="down"&&w+i>=v.length){s="up";i=1;v[w].setSelected(false);x=w;w=v.length-1;F=true;}else if(s=="up"&&w-i<0){s="down";i=1;v[w].setSelected(false);x=w;w=0;F=true;}}if(w===-1){w=0;if(this._isSuggestionItemSelectable(v[w])){O=w;F=true;}else{s="down";}}if(s==="down"){while(w<v.length-1&&(!F||!this._isSuggestionItemSelectable(v[w]))){v[w].setSelected(false);w=w+i;F=true;i=1;if(x===w){break;}}}else{while(w>0&&(!F||!v[w].getVisible()||!this._isSuggestionItemSelectable(v[w]))){v[w].setSelected(false);w=w-i;F=true;i=1;if(x===w){break;}}}if(!this._isSuggestionItemSelectable(v[w])){if(O>=0){v[O].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",v[O].getId());}return;}else{v[w].setSelected(true).updateAccessibilityState();this.$("inner").attr("aria-activedescendant",v[w].getId());}if(h.system.desktop){this._scrollToItem(w);}if(C&&v[w]instanceof C){N=this._getInputValue(this._fnRowResultFilter(v[w]));}else{var y=(u[0]instanceof c?true:false);if(y){N=this._getInputValue(v[w].getLabel());}else{N=this._getInputValue(v[w].getTitle());}}this.setDOMValue(N);this._sSelectedSuggViaKeyboard=N;this._doSelect();this._iPopupListSelectedIndex=w;};r.prototype.onsapup=function(E){this._onsaparrowkey(E,"up",1);};r.prototype.onsapdown=function(E){this._onsaparrowkey(E,"down",1);};r.prototype.onsappageup=function(E){this._onsaparrowkey(E,"up",5);};r.prototype.onsappagedown=function(E){this._onsaparrowkey(E,"down",5);};r.prototype.onsaphome=function(E){if(this._oList){this._onsaparrowkey(E,"up",this._oList.getItems().length);}};r.prototype.onsapend=function(E){if(this._oList){this._onsaparrowkey(E,"down",this._oList.getItems().length);}};r.prototype.onsapescape=function(E){var i;if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){E.originalEvent._sapui_handledByControl=true;this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();if(this._sBeforeSuggest!==undefined){if(this._sBeforeSuggest!==this.getValue()){i=this._lastValue;this.setValue(this._sBeforeSuggest);this._lastValue=i;}this._sBeforeSuggest=undefined;}return;}if(I.prototype.onsapescape){I.prototype.onsapescape.apply(this,arguments);}};r.prototype.onsapenter=function(E){if(I.prototype.onsapenter){I.prototype.onsapenter.apply(this,arguments);}this.cancelPendingSuggest();if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){if(!this._updateSelectionFromList()){this._closeSuggestionPopup();}}if(this.getEnabled()&&this.getEditable()&&!(this.getValueHelpOnly()&&this.getShowValueHelp())){this.fireSubmit({value:this.getValue()});}};r.prototype.onsapfocusleave=function(E){var i=this._oSuggestionPopup;if(i instanceof P){if(E.relatedControlId&&q.sap.containsOrEquals(i.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this._bPopupHasFocus=true;this.focus();}else{if(this.getDOMValue()===this._sSelectedSuggViaKeyboard){this._sSelectedSuggViaKeyboard=null;}}}var F=sap.ui.getCore().byId(E.relatedControlId);if(!(i&&F&&q.sap.containsOrEquals(i.getDomRef(),F.getFocusDomRef()))){I.prototype.onsapfocusleave.apply(this,arguments);}};r.prototype.onmousedown=function(E){var i=this._oSuggestionPopup;if((i instanceof P)&&i.isOpen()){E.stopPropagation();}};r.prototype._deregisterEvents=function(){if(this._sPopupResizeHandler){R.deregister(this._sPopupResizeHandler);this._sPopupResizeHandler=null;}if(this._bUseDialog&&this._oSuggestionPopup){this.$().off("click");}};r.prototype.updateSuggestionItems=function(){this._bSuspendInvalidate=true;this.updateAggregation("suggestionItems");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();this._bSuspendInvalidate=false;return this;};r.prototype.invalidate=function(){if(!this._bSuspendInvalidate){j.prototype.invalidate.apply(this,arguments);}};r.prototype.cancelPendingSuggest=function(){if(this._iSuggestDelay){q.sap.clearDelayedCall(this._iSuggestDelay);this._iSuggestDelay=null;}};r.prototype._triggerSuggest=function(v){this.cancelPendingSuggest();this._bShouldRefreshListItems=true;if(!v){v="";}if(v.length>=this.getStartSuggestion()){this._iSuggestDelay=q.sap.delayedCall(300,this,function(){if(this._sPrevSuggValue!==v){this._bBindingUpdated=false;this.fireSuggest({suggestValue:v});if(!this._bBindingUpdated){this._refreshItemsDelayed();}this._sPrevSuggValue=v;}});}else if(this._bUseDialog){if(this._oList instanceof T){this._oList.addStyleClass("sapMInputSuggestionTableHidden");}else if(this._oList&&this._oList.destroyItems){this._oList.destroyItems();}}else if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){q.sap.delayedCall(0,this,function(){var N=this.getDOMValue()||'';if(N<this.getStartSuggestion()){this._iPopupListSelectedIndex=-1;this._closeSuggestionPopup();}});}};(function(){r.prototype.setShowSuggestion=function(V){this.setProperty("showSuggestion",V,true);this._iPopupListSelectedIndex=-1;if(V){this._lazyInitializeSuggestionPopup(this);}else{u(this);}return this;};r.prototype.setShowTableSuggestionValueHelp=function(V){this.setProperty("showTableSuggestionValueHelp",V,true);if(!this._oSuggestionPopup){return this;}if(V){this._addShowMoreButton();}else{this._removeShowMoreButton();}return this;};r.prototype._getShowMoreButton=function(){var i=this,M=this._oRb;return this._oShowMoreButton||(this._oShowMoreButton=new sap.m.Button({text:M.getText("INPUT_SUGGESTIONS_SHOW_ALL"),press:function(){if(i.getShowTableSuggestionValueHelp()){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();}}}));};r.prototype._getButtonToolbar=function(){var i=this._getShowMoreButton();return this._oButtonToolbar||(this._oButtonToolbar=new d({content:[new e(),i]}));};r.prototype._addShowMoreButton=function(i){if(!this._oSuggestionPopup||!i&&!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){var x=this._getShowMoreButton();this._oSuggestionPopup.setEndButton(x);}else{var y=this._getButtonToolbar();this._oSuggestionPopup.setFooter(y);}};r.prototype._removeShowMoreButton=function(){if(!this._oSuggestionPopup||!this._hasTabularSuggestions()){return;}if(this._oSuggestionPopup instanceof D){this._oSuggestionPopup.setEndButton(null);}else{this._oSuggestionPopup.setFooter(null);}};r.prototype.oninput=function(E){I.prototype.oninput.call(this,E);if(E.isMarked("invalid")){return;}var i=this.getDOMValue();if(this.getValueLiveUpdate()){this.setProperty("value",i,true);this._onValueUpdated(i);}this.fireLiveChange({value:i,newValue:i});if(this.getShowSuggestion()&&!this._bUseDialog){this._triggerSuggest(i);}};r.prototype.getValue=function(){return this.getDomRef("inner")&&this._$input?this.getDOMValue():this.getProperty("value");};r.prototype._refreshItemsDelayed=function(){q.sap.clearDelayedCall(this._iRefreshListTimeout);this._iRefreshListTimeout=q.sap.delayedCall(0,this,w,[this]);};r.prototype.addSuggestionItem=function(i){this.addAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();t(this);return this;};r.prototype.insertSuggestionItem=function(i,x){this.insertAggregation("suggestionItems",x,i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();t(this);return this;};r.prototype.removeSuggestionItem=function(i){var x=this.removeAggregation("suggestionItems",i,true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return x;};r.prototype.removeAllSuggestionItems=function(){var i=this.removeAllAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};r.prototype.destroySuggestionItems=function(){this.destroyAggregation("suggestionItems",true);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};r.prototype.addSuggestionRow=function(i){i.setType(n.Active);this.addAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();t(this);return this;};r.prototype.insertSuggestionRow=function(i,x){i.setType(n.Active);this.insertAggregation("suggestionRows",i,x);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();t(this);return this;};r.prototype.removeSuggestionRow=function(i){var x=this.removeAggregation("suggestionRows",i);this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return x;};r.prototype.removeAllSuggestionRows=function(){var i=this.removeAllAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return i;};r.prototype.destroySuggestionRows=function(){this.destroyAggregation("suggestionRows");this._bShouldRefreshListItems=true;this._refreshItemsDelayed();return this;};r.prototype.bindAggregation=function(){var i=Array.prototype.slice.call(arguments);if(i[0]==="suggestionRows"||i[0]==="suggestionColumns"||i[0]==="suggestionItems"){t(this,i[0]==="suggestionRows"||i[0]==="suggestionColumns");this._bBindingUpdated=true;}this._callMethodInManagedObject.apply(this,["bindAggregation"].concat(i));return this;};r.prototype.unbindAggregation=function(){var i=Array.prototype.slice.call(arguments);this._callMethodInManagedObject.apply(this,["unbindAggregation"].concat(i));return this;};r.prototype._lazyInitializeSuggestionPopup=function(){if(!this._oSuggestionPopup){s(this);}};r.prototype._closeSuggestionPopup=function(){if(this._oSuggestionPopup){this._bShouldRefreshListItems=false;this.cancelPendingSuggest();this._oSuggestionPopup.close();if(!this._bUseDialog&&this.$().hasClass("sapMInputFocused")){this.openValueStateMessage();}this.$("SuggDescr").text("");this.$("inner").removeAttr("aria-haspopup");this.$("inner").removeAttr("aria-activedescendant");this._sPrevSuggValue=null;}};function s(i){var M=i._oRb;if(i._bUseDialog){i._oPopupInput=new r(i.getId()+"-popup-input",{width:"100%",valueLiveUpdate:true,showValueHelp:i.getShowValueHelp(),valueHelpRequest:function(E){i.fireValueHelpRequest({fromSuggestions:true});i._iPopupListSelectedIndex=-1;i._closeSuggestionPopup();},liveChange:function(E){var V=E.getParameter("newValue");i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i._triggerSuggest(V);i.fireLiveChange({value:V,newValue:V});}}).addStyleClass("sapMInputSuggInDialog");}i._oSuggestionPopup=!i._bUseDialog?(new P(i.getId()+"-popup",{showArrow:false,showHeader:false,placement:m.Vertical,initialFocus:i,horizontalScrolling:true}).attachAfterClose(function(){i._updateSelectionFromList();if(i._oList instanceof T){i._oList.removeSelections(true);}else{i._oList.destroyItems();}i._shouldResizePopup=false;}).attachBeforeOpen(function(){i._sBeforeSuggest=i.getValue();})):(new D(i.getId()+"-popup",{beginButton:new sap.m.Button(i.getId()+"-popup-closeButton",{text:M.getText("MSGBOX_CLOSE"),press:function(){i._closeSuggestionPopup();}}),stretch:i._bFullScreen,contentHeight:i._bFullScreen?undefined:"20rem",customHeader:new B(i.getId()+"-popup-header",{contentMiddle:i._oPopupInput.addEventDelegate({onsapenter:function(){if(!(sap.m.MultiInput&&i instanceof sap.m.MultiInput)){i._closeSuggestionPopup();}}},this)}),horizontalScrolling:false,initialFocus:i._oPopupInput}).attachBeforeOpen(function(){i._oPopupInput.setPlaceholder(i.getPlaceholder());i._oPopupInput.setMaxLength(i.getMaxLength());}).attachBeforeClose(function(){i.setDOMValue(i._getInputValue(i._oPopupInput.getValue()));i.onChange();if(i instanceof sap.m.MultiInput&&i._bUseDialog){i._onDialogClose();}}).attachAfterClose(function(){if(i instanceof sap.m.MultiInput&&i._isMultiLineMode){i._showIndicator();}if(i._oList){if(T&&!(i._oList instanceof T)){i._oList.destroyItems();}else{i._oList.removeSelections(true);}}}).attachAfterOpen(function(){var V=i.getValue();i._oPopupInput.setValue(V);i._triggerSuggest(V);w(i);}));i._oSuggestionPopup.addStyleClass("sapMInputSuggestionPopup");i._oSuggestionPopup.addAriaLabelledBy(r._sAriaPopupLabelId);i.addDependent(i._oSuggestionPopup);if(!i._bUseDialog){v(i._oSuggestionPopup,i);}if(i._oList){i._oSuggestionPopup.addContent(i._oList);}if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton();}}function t(i,x){if(i._oList){return;}if(!i._hasTabularSuggestions()&&!x){i._oList=new L(i.getId()+"-popup-list",{showNoData:false,mode:k.SingleSelectMaster,rememberSelections:false,itemPress:function(E){var A=E.getParameter("listItem");i.setSelectionItem(A._oItem,true);}});i._oList.addEventDelegate({onAfterRendering:i._highlightListText.bind(i)});}else{if(i._fnFilter===r._DEFAULTFILTER){i._fnFilter=r._DEFAULTFILTER_TABULAR;}if(!i._fnRowResultFilter){i._fnRowResultFilter=r._DEFAULTRESULT_TABULAR;}i._oList=i._getSuggestionsTable();if(i.getShowTableSuggestionValueHelp()){i._addShowMoreButton(x);}}if(i._oSuggestionPopup){if(i._bUseDialog){i._oSuggestionPopup.addAggregation("content",i._oList,true);var y=i._oSuggestionPopup.$("scrollCont")[0];if(y){var z=sap.ui.getCore().createRenderManager();z.renderControl(i._oList);z.flush(y);z.destroy();}}else{i._oSuggestionPopup.addContent(i._oList);}}}function u(i){if(i._oSuggestionPopup){if(i._oList instanceof T){i._oSuggestionPopup.removeAllContent();i._removeShowMoreButton();}i._oSuggestionPopup.destroy();i._oSuggestionPopup=null;}if(i._oList instanceof L){i._oList.destroy();i._oList=null;}}function v(i,x){i.open=function(){this.openBy(x,false,true);};i.oPopup.setAnimations(function($,y,O){O();},function($,y,z){z();});}function w(x){var y=x.getShowSuggestion();var z=x._oRb;x._iPopupListSelectedIndex=-1;if(!y||!x._bShouldRefreshListItems||!x.getDomRef()||(!x._bUseDialog&&!x.$().hasClass("sapMInputFocused"))){return false;}var A,E=x.getSuggestionItems(),F=x.getSuggestionRows(),G=x.getDOMValue()||"",H=x._oList,J=x.getFilterSuggests(),K=[],M=0,N=x._oSuggestionPopup,O={ontouchstart:function(W){(W.originalEvent||W)._sapui_cancelAutoClose=true;}},Q,i;if(x._oList){if(x._oList instanceof T){H.removeSelections(true);}else{H.destroyItems();}}if(G.length<x.getStartSuggestion()){if(!x._bUseDialog){x._iPopupListSelectedIndex=-1;this.cancelPendingSuggest();N.close();}else{if(x._hasTabularSuggestions()&&x._oList){x._oList.addStyleClass("sapMInputSuggestionTableHidden");}}x.$("SuggDescr").text("");x.$("inner").removeAttr("aria-haspopup");x.$("inner").removeAttr("aria-activedescendant");return false;}if(x._hasTabularSuggestions()){if(x._bUseDialog&&x._oList){x._oList.removeStyleClass("sapMInputSuggestionTableHidden");}for(i=0;i<F.length;i++){if(!J||x._fnFilter(G,F[i])){F[i].setVisible(true);K.push(F[i]);}else{F[i].setVisible(false);}}x._oSuggestionTable.invalidate();}else{var U=(E[0]instanceof c?true:false);for(i=0;i<E.length;i++){A=E[i];if(!J||x._fnFilter(G,A)){if(U){Q=new b(A.getId()+"-dli");Q.setLabel(A.getText());Q.setValue(A.getAdditionalText());}else{Q=new S(A.getId()+"-sli");Q.setTitle(A.getText());}Q.setType(A.getEnabled()?n.Active:n.Inactive);Q._oItem=A;Q.addEventDelegate(O);K.push(Q);}}}M=K.length;var V="";if(M>0){if(M==1){V=z.getText("INPUT_SUGGESTIONS_ONE_HIT");}else{V=z.getText("INPUT_SUGGESTIONS_MORE_HITS",M);}x.$("inner").attr("aria-haspopup","true");if(!x._hasTabularSuggestions()){for(i=0;i<M;i++){H.addItem(K[i]);}}if(!x._bUseDialog){if(x._sCloseTimer){clearTimeout(x._sCloseTimer);x._sCloseTimer=null;}if(!N.isOpen()&&!x._sOpenTimer&&(this.getValue().length>=this.getStartSuggestion())){x._sOpenTimer=setTimeout(function(){x._resizePopup(true);x._sOpenTimer=null;N.open();},0);}}}else{V=z.getText("INPUT_SUGGESTIONS_NO_HIT");x.$("inner").removeAttr("aria-haspopup");x.$("inner").removeAttr("aria-activedescendant");if(!x._bUseDialog){if(N.isOpen()){x._sCloseTimer=setTimeout(function(){x._iPopupListSelectedIndex=-1;x.cancelPendingSuggest();N.close();},0);}}else{if(x._hasTabularSuggestions()&&x._oList){x._oList.addStyleClass("sapMInputSuggestionTableHidden");}}}x.$("SuggDescr").text(V);}})();r.prototype._createHighlightedText=function(i){var t=i.innerText,v=this.getValue().toLowerCase(),s=v.length,u=t.toLowerCase(),w,x='';if(!r._wordStartsWithValue(t,v)){return q.sap.encodeHTML(t);}var y=u.indexOf(v);if(y>0){y=u.indexOf(' '+v)+1;}if(y>-1){x+=q.sap.encodeHTML(t.substring(0,y));w=t.substring(y,y+s);x+='<span class="sapMInputHighlight">'+q.sap.encodeHTML(w)+'</span>';x+=q.sap.encodeHTML(t.substring(y+s));}else{x=q.sap.encodeHTML(t);}return x;};r.prototype._highlightListText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,s,t=this._oList.$().find('.sapMDLILabel, .sapMSLITitleOnly, .sapMDLIValue');for(i=0;i<t.length;i++){s=t[i];s.innerHTML=this._createHighlightedText(s);}};r.prototype._highlightTableText=function(){if(!this.getEnableSuggestionsHighlighting()){return;}var i,s,t=this._oSuggestionTable.$().find('tbody .sapMLabel');for(i=0;i<t.length;i++){s=t[i];s.innerHTML=this._createHighlightedText(s);}};r.prototype.onfocusin=function(E){I.prototype.onfocusin.apply(this,arguments);this.$().addClass("sapMInputFocused");if(!this._bUseDialog&&this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()){this.closeValueStateMessage();}if(!this._bPopupHasFocus&&!this.getStartSuggestion()&&!this.getValue()){this._triggerSuggest(this.getValue());}this._bPopupHasFocus=undefined;this._sPrevSuggValue=null;};r.prototype.onsapshow=function(E){if(!this.getEnabled()||!this.getEditable()||!this.getShowValueHelp()){return;}this.fireValueHelpRequest({fromSuggestions:false});E.preventDefault();E.stopPropagation();};r.prototype.onsaphide=r.prototype.onsapshow;r.prototype.onsapselect=function(E){this._fireValueHelpRequestForValueHelpOnly();};r.prototype.onfocusout=function(E){I.prototype.onfocusout.apply(this,arguments);this.$().removeClass("sapMInputFocused");this.closeValueStateMessage(this);};r.prototype._hasTabularSuggestions=function(){return!!(this.getAggregation("suggestionColumns")&&this.getAggregation("suggestionColumns").length);};r.prototype._getSuggestionsTable=function(){if(this._bIsBeingDestroyed){return;}var t=this;if(!this._oSuggestionTable){this._oSuggestionTable=new T(this.getId()+"-popup-table",{mode:k.SingleSelectMaster,showNoData:false,showSeparators:"All",width:"100%",enableBusyIndicator:false,rememberSelections:false,selectionChange:function(E){var s=E.getParameter("listItem");t.setSelectionRow(s,true);}});this._oSuggestionTable.addEventDelegate({onAfterRendering:this._highlightTableText.bind(this)});if(this._bUseDialog){this._oSuggestionTable.addStyleClass("sapMInputSuggestionTableHidden");}this._oSuggestionTable.updateItems=function(){T.prototype.updateItems.apply(this,arguments);t._refreshItemsDelayed();return this;};}return this._oSuggestionTable;};r.prototype._fireSuggestionItemSelectedEvent=function(){if(this._iPopupListSelectedIndex>=0){var s=this._oList.getItems()[this._iPopupListSelectedIndex];if(s){if(C&&s instanceof C){this.fireSuggestionItemSelected({selectedRow:s});}else{this.fireSuggestionItemSelected({selectedItem:s._oItem});}}this._iPopupListSelectedIndex=-1;}};r.prototype._callMethodInManagedObject=function(F,A){var i=Array.prototype.slice.call(arguments),s;if(A==="suggestionColumns"){s=this._getSuggestionsTable();if(!s){return null;}return s[F].apply(s,["columns"].concat(i.slice(2)));}else if(A==="suggestionRows"){s=this._getSuggestionsTable();if(!s){return null;}return s[F].apply(s,["items"].concat(i.slice(2)));}else{return j.prototype[F].apply(this,i.slice(1));}};r.prototype.validateAggregation=function(A,O,M){return this._callMethodInManagedObject("validateAggregation",A,O,M);};r.prototype.setAggregation=function(A,O,s){this._callMethodInManagedObject("setAggregation",A,O,s);return this;};r.prototype.getAggregation=function(A,i){return this._callMethodInManagedObject("getAggregation",A,i);};r.prototype.indexOfAggregation=function(A,O){return this._callMethodInManagedObject("indexOfAggregation",A,O);};r.prototype.insertAggregation=function(A,O,i,s){this._callMethodInManagedObject("insertAggregation",A,O,i,s);return this;};r.prototype.addAggregation=function(A,O,s){this._callMethodInManagedObject("addAggregation",A,O,s);return this;};r.prototype.removeAggregation=function(A,O,s){return this._callMethodInManagedObject("removeAggregation",A,O,s);};r.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};r.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};r.prototype.getBinding=function(A){return this._callMethodInManagedObject("getBinding",A);};r.prototype.getBindingInfo=function(A){return this._callMethodInManagedObject("getBindingInfo",A);};r.prototype.getBindingPath=function(A){return this._callMethodInManagedObject("getBindingPath",A);};r.prototype.clone=function(){var i=j.prototype.clone.apply(this,arguments),s;s=this.getBindingInfo("suggestionColumns");if(s){i.bindAggregation("suggestionColumns",q.extend({},s));}else{this.getSuggestionColumns().forEach(function(t){i.addSuggestionColumn(t.clone(),true);});}s=this.getBindingInfo("suggestionRows");if(s){i.bindAggregation("suggestionRows",q.extend({},s));}else{this.getSuggestionRows().forEach(function(t){i.addSuggestionRow(t.clone(),true);});}i.setRowResultFunction(this._fnRowResultFilter);return i;};r.prototype.setValue=function(v){this._iSetCount++;I.prototype.setValue.call(this,v);this._onValueUpdated(v);return this;};r.prototype.setDOMValue=function(v){this._$input.val(v);};r.prototype.getDOMValue=function(){return this._$input.val();};r.prototype.updateInputField=function(N){if(this._oSuggestionPopup&&this._oSuggestionPopup.isOpen()&&this._bUseDialog){this._oPopupInput.setValue(N);this._oPopupInput._doSelect();}else{N=this._getInputValue(N);this.setDOMValue(N);this.onChange(null,null,N);}};r.prototype.getAccessibilityInfo=function(){var i=I.prototype.getAccessibilityInfo.apply(this,arguments);i.description=((i.description||"")+" "+this.getDescription()).trim();return i;};return r;});
