/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./ResponsivePopover","./Button","./Toolbar","./Bar","sap/ui/core/Control","sap/ui/core/IconPool","./semantic/SemanticPage","./Popover","./MessageView","sap/ui/Device"],function(q,R,B,T,a,C,I,S,P,M,D){"use strict";var b=C.extend("sap.m.MessagePopover",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},placement:{type:"sap.m.VerticalPlacementType",group:"Behavior",defaultValue:"Vertical"},initiallyExpanded:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",altTypes:["sap.m.MessagePopoverItem"],multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},afterClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},beforeClose:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessagePopoverItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}var d="sapMMsgPopover",e="320px",f="440px",g={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")},A=["asyncDescriptionHandler","asyncURLHandler"],h={asyncDescriptionHandler:function(i){var l=i.item.getLongtextUrl();if(l){q.ajax({type:"GET",url:l,success:function(j){i.item.setDescription(j);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+l;q.sap.log.error(E);i.promise.reject(E);}});}}};b.setDefaultHandlers=function(m){A.forEach(function(F){if(m.hasOwnProperty(F)){h[F]=m[F];}});};b.prototype.init=function(){var t=this;var p;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oMessageView=this._initMessageView();this._oMessageView.addEventDelegate({onBeforeRendering:function(){var s=t._oMessageView._oSegmentedButton.getVisible(),i=!t.getInitiallyExpanded()||s;t._oMessageView._oSegmentedButton.setVisible(i);t._oMessageView._listPage.setShowHeader(true);}});this._insertCloseBtn(this._oMessageView._oListHeader);this._insertCloseBtn(this._oMessageView._oDetailsHeader);this._oMessageView._oSegmentedButton.attachEvent("select",this._onSegButtonSelect,this);this._oPopover=new R(this.getId()+"-messagePopover",{showHeader:false,contentWidth:f,contentHeight:e,placement:this.getPlacement(),showCloseButton:false,verticalScrolling:false,horizontalScrolling:false,modal:false,afterOpen:function(E){t.fireAfterOpen({openBy:E.getParameter("openBy")});},afterClose:function(E){t._oMessageView._navContainer.backToTop();t.fireAfterClose({openBy:E.getParameter("openBy")});},beforeOpen:function(E){t.fireBeforeOpen({openBy:E.getParameter("openBy")});},beforeClose:function(E){t.fireBeforeClose({openBy:E.getParameter("openBy")});}}).addStyleClass(d);this._oPopover.addContent(this._oMessageView);this._oPopover.addAssociation("ariaLabelledBy",this.getId()+"-messageView-HeadingDescr",true);p=this._oPopover.getAggregation("_popup");p.oPopup.setAutoClose(false);p.addEventDelegate({onBeforeRendering:this.onBeforeRenderingPopover,onAfterRendering:this.onAfterRenderingPopover},this);if(D.system.phone){this._oPopover.setBeginButton(new B({text:this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),press:this.close.bind(this)}));}A.forEach(function(F){if(h.hasOwnProperty(F)){this['set'+c(F)](h[F]);}},this);};b.prototype.onBeforeRendering=function(){if(this.getDependents().indexOf(this._oPopover)===-1){this.addDependent(this._oPopover);}};b.prototype.onBeforeRenderingPopover=function(){if(this._bItemsChanged){var i=this.getItems();var t=this;this._oMessageView.destroyItems();i.forEach(function(j){j._updateProperties(function(){t._bItemsChanged=true;});this._oMessageView.addItem(j.clone("","",{cloneChildren:true,cloneBinding:true}));},this);this._bItemsChanged=false;}this._setInitialFocus();};b.prototype.onAfterRenderingPopover=function(){if(this._oPopover._oControl._sFocusControlId){this._oPopover._oControl._sFocusControlId=null;}};b.prototype.exit=function(){this._oResourceBundle=null;if(this._oMessageView){this._oMessageView.destroy();this._oMessageView=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}};b.prototype.openBy=function(o){var r=this._oPopover.getAggregation("_popup"),p=o.getParent();if(r instanceof P){if((p instanceof T||p instanceof a||p instanceof S)){r.setShowArrow(false);r.setResizable(true);}else{r.setShowArrow(true);}}if(this._oPopover){this._restoreExpansionDefaults();this._oPopover.openBy(o);}return this;};b.prototype.close=function(){if(this._oPopover){this._oPopover.close();}return this;};b.prototype.isOpen=function(){return this._oPopover.isOpen();};b.prototype.toggle=function(o){if(this.isOpen()){this.close();}else{this.openBy(o);}return this;};b.prototype.setPlacement=function(p){this.setProperty("placement",p,true);this._oPopover.setPlacement(p);return this;};b.prototype.getDomRef=function(s){return this._oPopover&&this._oPopover.getAggregation("_popup").getDomRef(s);};b.prototype._initMessageView=function(){var t=this,m;m=new M(this.getId()+"-messageView",{listSelect:function(E){t.fireListSelect({messageTypeFilter:E.getParameter('messageTypeFilter')});},itemSelect:function(E){t.fireItemSelect({messageTypeFilter:E.getParameter('messageTypeFilter'),item:E.getParameter('item')});},longtextLoaded:function(){t.fireLongtextLoaded();},urlValidated:function(){t.fireUrlValidated();}});return m;};b.prototype._onSegButtonSelect=function(){if(this.isOpen()&&!this.getInitiallyExpanded()&&this._oPopover.hasStyleClass(d+"-init")){this._expandMsgPopover();}};b.prototype._restoreExpansionDefaults=function(){if(!this.getInitiallyExpanded()){this._collapseMsgPopover();this._oMessageView._oSegmentedButton.setSelectedButton("none");}else{this._expandMsgPopover();}};b.prototype._expandMsgPopover=function(){var s,H=e,s=this._oPopover.$("cont").css("height");if(this.getInitiallyExpanded()&&s!=="0px"){H=parseFloat(s)?s:H;}this._oPopover.setContentHeight(H).removeStyleClass(d+"-init");};b.prototype._collapseMsgPopover=function(){this._oPopover.addStyleClass(d+"-init").setContentHeight("auto");};b.prototype._insertCloseBtn=function(i){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE"),o=new B({icon:g["close"],visible:!D.system.phone,tooltip:s,press:this.close.bind(this)}).addStyleClass(d+"CloseBtn");i.insertContent(o,3,true);};b.prototype._setInitialFocus=function(){if(this._oMessageView._isListPage()&&this.getInitiallyExpanded()){this._oPopover.setInitialFocus(this._oMessageView._oLists[this._sCurrentList||'all']);}};b.prototype._afterNavigate=function(){q.sap.delayedCall(0,this,"_restoreFocus");};b.prototype._restoreFocus=function(){if(this._oMessageView._isListPage()){var r=this._oRestoreFocus&&this._oRestoreFocus.control(0);r&&r.focus();}else{this._oMessageView._oBackButton.focus();}};b.prototype.setAsyncDescriptionHandler=function(i){this.setProperty('asyncDescriptionHandler',i,true);this._oMessageView.setProperty('asyncDescriptionHandler',i,true);return this;};b.prototype.setAsyncURLHandler=function(i){this.setProperty('asyncURLHandler',i,true);this._oMessageView.setProperty('asyncURLHandler',i,true);return this;};b.prototype.setHeaderButton=function(o){this._oMessageView.setHeaderButton(o);return this;};b.prototype.getHeaderButton=function(){return this._oMessageView.getHeaderButton();};b.prototype.setModel=function(m,n){this._oMessageView.setModel(m,n);return C.prototype.setModel.apply(this,arguments);};["invalidate","addStyleClass","removeStyleClass","toggleStyleClass","hasStyleClass","getBusyIndicatorDelay","setBusyIndicatorDelay","getVisible","setVisible","getBusy","setBusy"].forEach(function(n){b.prototype[n]=function(){if(this._oPopover&&this._oPopover[n]){var p=this._oPopover;var r=p[n].apply(p,arguments);return r===p?this:r;}};});["setModel","bindAggregation","setAggregation","insertAggregation","addAggregation","removeAggregation","removeAllAggregation","destroyAggregation"].forEach(function(F){b.prototype["_"+F+"Old"]=b.prototype[F];b.prototype[F]=function(){var r=b.prototype["_"+F+"Old"].apply(this,arguments);this._bItemsChanged=true;if(this._oPopover){this._oPopover.invalidate();}if(["removeAggregation","removeAllAggregation"].indexOf(F)!==-1){return r;}return this;};});return b;});
