/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','./NotificationListBase','sap/ui/core/InvisibleText','sap/ui/core/IconPool','sap/ui/core/ResizeHandler','sap/m/Button'],function(l,N,I,a,R,B){'use strict';var b=l.ButtonType;var c=N.extend('sap.m.NotificationListItem',{metadata:{library:'sap.m',properties:{description:{type:'string',group:'Appearance',defaultValue:''},truncate:{type:'boolean',group:'Appearance',defaultValue:true},hideShowMoreButton:{type:'boolean',group:'Appearance',defaultValue:false}},aggregations:{processingMessage:{type:'sap.m.MessageStrip',multiple:false},_bodyText:{type:'sap.m.Text',multiple:false,visibility:"hidden"}}}});c.prototype.init=function(){N.prototype.init.call(this);var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');this._expandText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_MORE');this._collapseText=r.getText('NOTIFICATION_LIST_ITEM_SHOW_LESS');this._closeText=r.getText('NOTIFICATION_LIST_BASE_CLOSE');this.setType('Active');var _=new B(this.getId()+'-closeButton',{type:b.Transparent,icon:a.getIconURI('decline'),tooltip:this._closeText,press:function(){this.close();}.bind(this)});this.setAggregation("_closeButton",_,true);var d=new B({type:b.Transparent,text:this.getTruncate()?this._expandText:this._collapseText,id:this.getId()+'-expandCollapseButton',press:function(){this._deregisterResize();this.setProperty("truncate",!this.getTruncate(),true);d.setText(this.getTruncate()?this._expandText:this._collapseText);this.$().find('.sapMNLI-Header').toggleClass('sapMNLI-TitleWrapper--is-expanded');this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());this._registerResize();}.bind(this)});this.setAggregation("_collapseButton",d,true);this._ariaDetailsText=new I({id:this.getId()+'-info'}).toStatic();};c.prototype.setDescription=function(d){var r=this.setProperty('description',d);this._getDescriptionText().setText(d);return r;};c.prototype.setDatetime=function(d){var r=N.prototype.setDatetime.call(this,d);this._updateAriaAdditionalInfo();return r;};c.prototype.setUnread=function(u){var r=this.setProperty('unread',u,true);var t=this.getAggregation('_headerTitle');if(t){t.toggleStyleClass('sapMNLI-Unread',this.getUnread());}return r;};c.prototype.setPriority=function(p,s){var r=this.setProperty('priority',p,s);this._updateAriaAdditionalInfo();return r;};c.prototype.setAuthorPicture=function(d,s){var r=this.setProperty('authorPicture',d,s);this._getAuthorImage().setSrc(d);return r;};c.prototype.clone=function(){return N.prototype.clone.apply(this,arguments);};c.prototype.onBeforeRendering=function(){this._updateAriaAdditionalInfo();this._deregisterResize();};c.prototype.onAfterRendering=function(){this._registerResize();};c.prototype.exit=function(){this._deregisterResize();if(this._ariaDetailsText){this._ariaDetailsText.destroy();this._ariaDetailsText=null;}};c.prototype._getDescriptionText=function(){var d=this.getAggregation('_bodyText');if(!d){d=new sap.m.Text({id:this.getId()+'-body',text:this.getDescription(),maxLines:2}).addStyleClass('sapMNLI-Text');this.setAggregation("_bodyText",d,true);}return d;};c.prototype._activeHandling=function(){this.$().toggleClass("sapMNLIActive",this._active);};c.prototype._updateAriaAdditionalInfo=function(){var r=sap.ui.getCore().getLibraryResourceBundle('sap.m');var d=this.getUnread()?r.getText('NOTIFICATION_LIST_ITEM_UNREAD'):r.getText('NOTIFICATION_LIST_ITEM_READ');var e=r.getText('NOTIFICATION_LIST_ITEM_DATETIME_PRIORITY',[this.getDatetime(),this.getPriority()]);var f=this.getAuthorName();var g=d+' ';if(f){g+=r.getText('NOTIFICATION_LIST_ITEM_CREATED_BY')+' '+this.getAuthorName()+' ';}g+=e;this._ariaDetailsText.setText(g);};c.prototype._canTruncate=function(){var t=this.getDomRef('title').offsetHeight;var d=this.getDomRef('title').parentElement.offsetHeight;var e;var f;if(this._getDescriptionText().getText()){e=this.getDomRef("body").offsetHeight;f=this.getDomRef("body").parentElement.offsetHeight;}return e>f||t>d;};c.prototype._showHideTruncateButton=function(){var n=this.getDomRef();if(this._canTruncate()&&(!this.getHideShowMoreButton())){this.getDomRef('expandCollapseButton').classList.remove('sapMNLI-CollapseButtonHide');if(this.getTruncate()){this.getAggregation('_collapseButton').setText(this._expandText);n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');}}else{this.getAggregation('_collapseButton').setText(this._collapseText);this.$().find('.sapMNLI-TextWrapper').toggleClass('sapMNLI-TextWrapper--is-expanded',this.getDescription());n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--is-expanded');}}else{this.getDomRef('expandCollapseButton').classList.add('sapMNLI-CollapseButtonHide');}if(this.getDescription()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--initial-overwrite');}if(this.getTitle()){n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--initial-overwrite');}};c.prototype._deregisterResize=function(){if(this._sNotificationResizeHandler){R.deregister(this._sNotificationResizeHandler);this._sNotificationResizeHandler=null;}};c.prototype._registerResize=function(){var t=this;var n=this.getDomRef();if(!n){return;}t._resizeNotification();this._sNotificationResizeHandler=R.register(n,function(){t._resizeNotification();});};c.prototype._resizeNotification=function(){var n=this.getDomRef();var d=sap.ui.getCore();if(n.offsetWidth>=640){n.classList.add('sapMNLI-LSize');}else{n.classList.remove('sapMNLI-LSize');}if(this._getDescriptionText().getText()){n.querySelector('.sapMNLI-TextWrapper').classList.remove('sapMNLI-TextWrapper--is-expanded');n.querySelector('.sapMNLI-TextWrapper').classList.add('sapMNLI-TextWrapper--initial-overwrite');}n.querySelector('.sapMNLI-Header').classList.remove('sapMNLI-TitleWrapper--is-expanded');n.querySelector('.sapMNLI-Header').classList.add('sapMNLI-TitleWrapper--initial-overwrite');if(d.isThemeApplied()){this._showHideTruncateButton();}else{d.attachThemeChanged(this._showHideTruncateButton,this);}};return c;});
