/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control",'sap/ui/core/Renderer',"sap/ui/Device","sap/m/library","sap/ui/core/library","sap/ui/core/Icon"],function(C,R,D,l,c,I){"use strict";var T=c.TextAlign;var O=l.ObjectMarkerVisibility;var a=C.extend("sap.m.ObjectMarker",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ObjectMarkerType",group:"Misc"},visibility:{type:"sap.m.ObjectMarkerVisibility",group:"Misc"},additionalInfo:{type:"string",group:"Misc",defaultValue:""}},aggregations:{_innerControl:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{press:{type:{type:"sap.m.ObjectMarkerType"}}}}});var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");a.M_PREDEFINED_TYPES={Flagged:{icon:{src:"sap-icon://flag",visibility:{small:true,large:true}},text:{value:r.getText("OM_FLAG"),visibility:{small:false,large:false}}},Favorite:{icon:{src:"sap-icon://favorite",visibility:{small:true,large:true}},text:{value:r.getText("OM_FAVORITE"),visibility:{small:false,large:false}}},Draft:{icon:{src:"sap-icon://request",visibility:{small:false,large:false}},text:{value:r.getText("OM_DRAFT"),visibility:{small:true,large:true}}},Locked:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:r.getText("OM_LOCKED"),visibility:{small:false,large:true}}},Unsaved:{icon:{src:"sap-icon://user-edit",visibility:{small:true,large:true}},text:{value:r.getText("OM_UNSAVED"),visibility:{small:false,large:true}}},LockedBy:{icon:{src:"sap-icon://private",visibility:{small:true,large:true}},text:{value:r.getText("OM_LOCKED_BY"),visibility:{small:false,large:true}}},UnsavedBy:{icon:{src:"sap-icon://user-edit",visibility:{small:true,large:true}},text:{value:r.getText("OM_UNSAVED_BY"),visibility:{small:false,large:true}}}};a.prototype.init=function(){D.media.initRangeSet("DeviceSet",[600],"px",["small","large"]);};a.prototype.onAfterRendering=function(){this._attachMediaContainerWidthChange(this._handleMediaChange,this,"DeviceSet");};a.prototype.onBeforeRendering=function(){this._cleanup();this._adjustControl();};a.prototype.exit=function(){this._cleanup();};a.prototype.attachPress=function(){var i=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")&&i&&i instanceof d){i.destroy();this.setAggregation("_innerControl",this._createCustomLink(),true);this._adjustControl();}return this;};a.prototype.detachPress=function(){var i=this._getInnerControl();Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")&&i&&i instanceof f){i.destroy();this.setAggregation("_innerControl",this._createCustomText(),true);this._adjustControl();}return this;};a.prototype._cleanup=function(){this._detachMediaContainerWidthChange(this._handleMediaChange,this,"DeviceSet");};a.prototype._handleMediaChange=function(){this._adjustControl();};a.prototype._adjustControl=function(){var t=a.M_PREDEFINED_TYPES[this.getType()],i=this._getInnerControl(),A=this.getAdditionalInfo(),s=this.getType(),g;if(!i){return false;}if(t){g=this._getMarkerText(t,s,A);}if(this._isIconVisible()){i.setIcon(t.icon.src);this.addStyleClass("sapMObjectMarkerIcon");}else{i.setIcon(null);this.removeStyleClass("sapMObjectMarkerIcon");}if(this._isTextVisible()){i.setTooltip(null);i.setText(g);this.addStyleClass("sapMObjectMarkerText");}else{if(i.getIcon()){i.setTooltip(g);}i.setText(null);this.removeStyleClass("sapMObjectMarkerText");}return true;};a.prototype._getMarkerText=function(t,s,A){switch(s){case"LockedBy":return(A==="")?r.getText('OM_LOCKED_BY_ANOTHER_USER'):r.getText('OM_LOCKED_BY',[A]);case"UnsavedBy":return(A==="")?r.getText('OM_UNSAVED_BY_ANOTHER_USER'):r.getText('OM_UNSAVED_BY',[A]);default:return(A==="")?t.text.value:t.text.value+" "+A;}};a.prototype._isIconVisible=function(){var t=a.M_PREDEFINED_TYPES[this.getType()],v=this.getVisibility(),s=this._getDeviceType(),g=t&&t.icon.visibility[s]||false;return v===O.IconOnly||v===O.IconAndText||(v!==O.TextOnly&&g);};a.prototype._isTextVisible=function(){var t=a.M_PREDEFINED_TYPES[this.getType()],v=this.getVisibility(),s=this._getDeviceType(),g=t&&t.text.visibility[s]||false;return v===O.TextOnly||v===O.IconAndText||(v!==O.IconOnly&&g);};a.prototype._getDeviceType=function(){return this._getCurrentMediaContainerRange("DeviceSet").name.toLowerCase();};a.prototype._getInnerControl=function(){var i=this.getAggregation("_innerControl");if(!i&&this.getType()){i=this._createInnerControl();this.setAggregation("_innerControl",i,true);this._adjustControl();}return i;};a.prototype._createInnerControl=function(){if(this.hasListeners("press")){return this._createCustomLink();}else{return this._createCustomText();}};a.prototype._createCustomLink=function(){var o=new f(this.getId()+"-link",{wrapping:true});o.attachPress(function(E){this.firePress({type:this.getType()});},this);return o;};a.prototype._createCustomText=function(){return new d(this.getId()+"-text",{textAlign:T.Initial});};var b=R.extend(sap.m.TextRenderer);b.renderText=function(o,g){o.renderControl(g._getIconAggregation());sap.m.TextRenderer.renderText(o,g);};var d=sap.m.Text.extend("CustomText",{metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},renderer:b});d.prototype.setIcon=function(i){var o=this._getIconAggregation();this.setProperty("icon",i,false);o.setSrc(i);};d.prototype._getIconAggregation=function(){var i=this.getAggregation("_iconControl");if(!i){i=new I();this.setAggregation("_iconControl",i);}return i;};d.prototype.setText=function(t){this.setProperty("text",t,true);};var e=R.extend(sap.m.LinkRenderer);e.renderText=function(o,g){o.renderControl(g._getIconAggregation());sap.m.LinkRenderer.renderText(o,g);};var f=sap.m.Link.extend("CustomLink",{metadata:{properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null}},aggregations:{_iconControl:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}}},renderer:e});f.prototype.setIcon=function(i){var o=this._getIconAggregation();this.setProperty("icon",i,false);o.setSrc(i);};f.prototype._getIconAggregation=function(){var i=this.getAggregation("_iconControl");if(!i){i=new I();this.setAggregation("_iconControl",i);}return i;};f.prototype.setText=function(t){this.setProperty("text",t,true);};return a;});
