/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./library','sap/ui/core/EnabledPropagator','sap/m/DialogRenderer','sap/ui/core/library','sap/ui/Device'],function(q,D,l,E,a,c,b){"use strict";var O=l.OverflowToolbarPriority;var L=l.ListType;var P=l.P13nPanelType;var d=l.ListMode;var M=c.MessageType;var B=l.ButtonType;var e=D.extend("sap.m.P13nDialog",{metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},renderer:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var p=C.getVisiblePanel();if(i&&p){r.write("<div");r.writeAttribute("id",i);r.write(">");r.renderControl(p);r.write("</div>");}}});E.apply(e.prototype,[true]);e.prototype.init=function(o){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._oResetButton=null;this._mValidationListener={};this._createDialog();};e.prototype.setShowReset=function(s){this.setProperty("showReset",s);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setVisible(s);}return this;};e.prototype.setShowResetEnabled=function(f){this.setProperty("showResetEnabled",f);if(this.getButtons()&&this.getButtons()[2]){this.getButtons()[2].setEnabled(f);}return this;};e.prototype.addPanel=function(p){this.addAggregation("panels",p);var n=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",n);var N=this._getNavigationControl();if(N){b.system.phone?N.addItem(n):N.addButton(n);}this._setVisibilityOfPanel(p);this._setDialogTitleFor(p);return this;};e.prototype.insertPanel=function(p,i){this.insertAggregation("panels",p,i);var n=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",n);var N=this._getNavigationControl();if(N){b.system.phone?N.insertItem(n):N.insertButton(n);}this._setVisibilityOfPanel(p);this._setDialogTitleFor(p);return this;};e.prototype.removePanel=function(p){p=this.removeAggregation("panels",p);var n=this._getNavigationControl();if(n){b.system.phone?n.removeItem(p&&this._getNavigationItemByPanel(p)):n.removeButton(p&&this._getNavigationItemByPanel(p));}return p;};e.prototype.removeAllPanels=function(){var p=this.removeAllAggregation("panels");var n=this._getNavigationControl();if(n){b.system.phone?n.removeAllItems():n.removeAllButtons();}return p;};e.prototype.destroyPanels=function(){this.destroyAggregation("panels");var n=this._getNavigationControl();if(n){b.system.phone?n.destroyItems():n.destroyButtons();}return this;};e.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new sap.m.Bar({contentLeft:new sap.m.Button({visible:false,type:B.Back,press:function(o){t._backToList();}}),contentMiddle:new sap.m.Title({text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H1"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};e.prototype._getNavigationControl=function(){if(this.getPanels().length<2){return null;}var t=this;if(b.system.phone){if(!this.getContent().length){this.addContent(new sap.m.List({mode:d.None,itemPress:function(o){if(o){t._switchPanel(o.getParameter("listItem"));}}}));this.getContent()[0].addItem(this._getNavigationItemByPanel(this.getPanels()[0]));}return this.getContent()[0];}else{if(!this.getSubHeader()||!this.getSubHeader().getContentLeft().length){this.setSubHeader(new sap.m.Bar({contentLeft:[new sap.m.SegmentedButton({select:function(o){t._switchPanel(o.getParameter("button"));},width:'100%'})]}));this.getSubHeader().getContentLeft()[0].addButton(this._getNavigationItemByPanel(this.getPanels()[0]));}return this.getSubHeader().getContentLeft()[0];}};e.prototype._showValidationDialog=function(C,f,v){var w=[];var g=[];this._prepareMessages(f,v,w,g);q.sap.require("sap.m.MessageBox");var m="";if(g.length){g.forEach(function(o,i,h){m=(h.length>1?"• ":"")+o.messageText+"\n"+m;});sap.m.MessageBox.show(m,{icon:sap.m.MessageBox.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[sap.m.MessageBox.Action.CLOSE],styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(o,i,h){m=(h.length>1?"• ":"")+o.messageText+"\n"+m;});m=m+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");sap.m.MessageBox.show(m,{icon:sap.m.MessageBox.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),sap.m.MessageBox.Action.IGNORE],onClose:function(A){if(A===sap.m.MessageBox.Action.IGNORE){C();}},styleClass:!!this.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}};e.prototype._prepareMessages=function(f,v,w,g){if(!f.length&&!v.length){return;}f.forEach(function(p){switch(p){case P.filter:v.push({messageType:M.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:M.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;case P.dimeasure:v.push({messageType:M.Error,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_CHARTTYPE")});break;}});var u=v.filter(function(m,I,h){for(var i=++I;i<h.length;i++){if(m.messageText===h[i].messageText){return false;}}return true;});u.forEach(function(m){if(m.messageType===M.Warning){w.push(m);}else if(m.messageType===M.Error){g.push(m);}});};e.prototype._mapPanelToNavigationItem=function(p){if(!p){return null;}var n=null;if(b.system.phone){n=new sap.m.StandardListItem({type:L.Navigation,title:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});}else{n=new sap.m.Button({type:B.Default,text:p.getBindingPath("title")?q.extend(true,{},p.getBindingInfo("title")):p.getTitle()});}p.setValidationExecutor(q.proxy(this._callValidationExecutor,this));p.setValidationListener(q.proxy(this._registerValidationListener,this));p.setChangeNotifier(q.proxy(this._callChangeNotifier,this));return n;};e.prototype._switchPanel=function(n){var p=this._getPanelByNavigationItem(n);this.setVerticalScrolling(p.getVerticalScrolling());if(b.system.phone){var N=this._getNavigationControl();if(N){N.setVisible(false);p.beforeNavigationTo();p.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(p.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(o){if(o===p){o.beforeNavigationTo();o.setVisible(true);}else{o.setVisible(false);}},this);}this.invalidate();this.rerender();};e.prototype._backToList=function(){var n=this._getNavigationControl();if(n){n.setVisible(true);var p=this.getVisiblePanel();p.setVisible(false);this._setDialogTitleFor(p);this.getCustomHeader().getContentLeft()[0].setVisible(false);}};e.prototype.getVisiblePanel=function(){var p=null;this.getPanels().some(function(o){if(o.getVisible()){p=o;return true;}});return p;};e.prototype._getPanelByNavigationItem=function(n){for(var i=0,p=this.getPanels(),f=p.length;i<f;i++){if(p[i].data("sapMP13nDialogNavigationItem")===n){return p[i];}}return null;};e.prototype._getNavigationItemByPanel=function(p){if(!p){return null;}return p.data("sapMP13nDialogNavigationItem");};e.prototype._setVisibilityOfOtherPanels=function(p,v){for(var i=0,f=this.getPanels(),g=f.length;i<g;i++){if(f[i]===p){continue;}f[i].setVisible(v);}};e.prototype._setVisibilityOfPanel=function(p){var v;if(b.system.phone){v=this.getPanels().length===1;if(v){p.beforeNavigationTo();if(!this.getModel()){this.setModel(p.getModel("$sapmP13nPanel"),"$sapmP13nDialog");}}p.setVisible(v);this._setVisibilityOfOtherPanels(p,false);}else{v=this.getInitialVisiblePanelType()===p.getType()||this.getPanels().length===1;if(v){p.beforeNavigationTo();if(!this.getModel()){this.setModel(p.getModel("$sapmP13nPanel"),"$sapmP13nDialog");}}p.setVisible(v);if(v){this._setVisibilityOfOtherPanels(p,false);this.setVerticalScrolling(p.getVerticalScrolling());var o=this._getNavigationItemByPanel(p);var n=this._getNavigationControl();if(n){n.setSelectedButton(o);}}}};e.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var p=q.find("#"+i);q(p).appendTo(q(C));}};e.prototype._getVisiblePanelID=function(){var p=this.getVisiblePanel();if(p){return this.getId()+"-panel_"+p.getId();}return null;};e.prototype._setDialogTitleFor=function(p){var t;if(this.getPanels().length>1){t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}else{switch(p.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=p.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};e.prototype._registerValidationListener=function(p,C){if(this.getPanels().indexOf(p)&&C&&this._mValidationListener[p.getType()]===undefined){this._mValidationListener[p.getType()]=C;}};e.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!q.isEmptyObject(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var T in t._mValidationListener){var C=t._mValidationListener[T];C(r[T]||[]);}});}};e.prototype._callChangeNotifier=function(p){if(this.getShowReset()){this.setShowResetEnabled(true);}};e.prototype._distributeValidationResult=function(r){var o={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(o[t]===undefined){o[t]=[];}o[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return o;};e.prototype._createOKButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow}),press:function(){t.setBusy(true);var p=t._getPayloadOfPanels();var f=function(){t.setBusy(false);t.fireOk({payload:p});};var F=[];var C=function(){t.getPanels().forEach(function(o){if(F.indexOf(o.getType())>-1){o.onAfterNavigationFrom();}});f();};t.getPanels().forEach(function(o){if(!o.onBeforeNavigationFrom()){F.push(o.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(p).then(function(v){if(F.length||v.length){t.setBusy(false);t._showValidationDialog(C,F,v);}else{f();}});}else{if(F.length||v.length){t.setBusy(false);t._showValidationDialog(C,F,v);}else{f();}}}});};e.prototype._createCancelButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow}),press:function(){t.fireCancel();}});};e.prototype._createResetButton=function(){var t=this;return new sap.m.Button({text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){t.setShowResetEnabled(false);var p={};t.getPanels().forEach(function(o){p[o.getType()]=o.getResetPayload();});t.fireReset({payload:p});}});};e.prototype._getPayloadOfPanels=function(){var p={};this.getPanels().forEach(function(o){p[o.getType()]=o.getOkPayload();});return p;};e.prototype.exit=function(){D.prototype.exit.apply(this,arguments);};return e;});
