/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['./library','sap/ui/core/Control','sap/ui/core/library','sap/ui/Device'],function(l,C,c,D){"use strict";var T=c.TextAlign;var a=c.TextDirection;var b=C.extend("sap.m.Text",{metadata:{interfaces:["sap.ui.core.IShrinkable","sap.ui.core.IFormContent"],library:"sap.m",properties:{text:{type:"string",defaultValue:'',bindable:"bindable"},textDirection:{type:"sap.ui.core.TextDirection",group:"Appearance",defaultValue:a.Inherit},wrapping:{type:"boolean",group:"Appearance",defaultValue:true},textAlign:{type:"sap.ui.core.TextAlign",group:"Appearance",defaultValue:T.Begin},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},maxLines:{type:"int",group:"Appearance",defaultValue:null},renderWhitespace:{type:"boolean",group:"Appearance",defaultValue:false}},designTime:true}});b.prototype.normalLineHeight=1.2;b.prototype.cacheLineHeight=true;b.prototype.ellipsis='...';b.hasNativeLineClamp=(function(){return typeof document.documentElement.style.webkitLineClamp!="undefined"&&D.browser.chrome;})();b.setNodeValue=function(d,n){n=n||"";var e=d.childNodes;if(e.length===1&&e[0].nodeType===window.Node.TEXT_NODE){e[0].nodeValue=n;}else{d.textContent=n;}};b.prototype.setText=function(t){this.setProperty("text",t,true);var d=this.getTextDomRef();if(d){b.setNodeValue(d,this.getText(true));if(this.getWrapping()){if(t&&!/\s/.test(t)){this.$().addClass("sapMTextBreakWord");}else{this.$().removeClass("sapMTextBreakWord");}}}return this;};b.prototype.getText=function(n){var t=this.getProperty("text");if(n){return t.replace(/\\r\\n|\\n/g,"\n");}return t;};b.prototype.onAfterRendering=function(){if(this.getVisible()&&this.hasMaxLines()&&!this.canUseNativeLineClamp()){this.clampHeight();}};b.prototype.hasMaxLines=function(){return(this.getWrapping()&&this.getMaxLines()>1);};b.prototype.getTextDomRef=function(){if(!this.getVisible()){return null;}if(this.hasMaxLines()){return this.getDomRef("inner");}return this.getDomRef();};b.prototype.canUseNativeLineClamp=function(){if(!b.hasNativeLineClamp){return false;}if(this.getTextDirection()==a.RTL){return false;}if(this.getTextDirection()==a.Inherit&&sap.ui.getCore().getConfiguration().getRTL()){return false;}return true;};b.prototype.getLineHeight=function(d){if(this.cacheLineHeight&&this._fLineHeight){return this._fLineHeight;}d=d||this.getTextDomRef();if(!d){return 0;}var s=window.getComputedStyle(d),L=s.lineHeight,f;if(/px$/i.test(L)){f=parseFloat(L);}else if(/^normal$/i.test(L)){f=parseFloat(s.fontSize)*this.normalLineHeight;}else{f=parseFloat(s.fontSize)*parseFloat(L);}if(!D.browser.firefox){f=Math.floor(f);}if(this.cacheLineHeight&&f){this._fLineHeight=f;}return f;};b.prototype.getClampHeight=function(d){d=d||this.getTextDomRef();return this.getMaxLines()*this.getLineHeight(d);};b.prototype.clampHeight=function(d){d=d||this.getTextDomRef();if(!d){return 0;}var m=this.getClampHeight(d);if(m){d.style.maxHeight=m+"px";}return m;};b.prototype.clampText=function(d,s,e){d=d||this.getTextDomRef();if(!d){return;}var E;var t=this.getText(true);var m=this.getClampHeight(d);s=s||0;e=e||t.length;b.setNodeValue(d,t.slice(0,e));if(d.scrollHeight>m){var S=d.style,h=S.height,f=this.ellipsis,i=f.length;S.height=m+"px";while((e-s)>i){E=(s+e)>>1;b.setNodeValue(d,t.slice(0,E-i)+f);if(d.scrollHeight>m){e=E;}else{s=E;}}if(d.scrollHeight>m&&s>0){E=s;d.textContent=t.slice(0,E-i)+f;}S.height=h;}return E;};b.prototype.getAccessibilityInfo=function(){return{description:this.getText()};};return b;});
