/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/m/library","sap/m/MessageBox","sap/m/Dialog","sap/ui/core/Control","sap/ui/core/Icon","sap/ui/core/IconPool","sap/m/Image","sap/m/Text","sap/m/Title","sap/m/Button","sap/m/List","sap/m/StandardListItem","sap/ui/unified/FileUploaderParameter","sap/ui/unified/FileUploader","sap/ui/core/format/FileSizeFormat","sap/m/OverflowToolbar","sap/m/ToolbarSpacer","sap/m/ObjectAttribute","sap/m/UploadCollectionItem","sap/m/UploadCollectionParameter","sap/m/UploadCollectionToolbarPlaceholder","sap/ui/core/HTML","sap/m/CustomListItem","sap/ui/core/ResizeHandler","sap/ui/Device","jquery.sap.keycodes"],function(q,L,M,a,D,C,I,b,c,T,d,B,f,S,F,g,h,O,k,l,U,m,n,H,o,R,p){"use strict";var r=C.extend("sap.m.UploadCollection",{constructor:function(i,s){var j;if(s&&s.instantUpload===false){j=s.instantUpload;delete s.instantUpload;}else if(i&&i.instantUpload===false){j=i.instantUpload;delete i.instantUpload;}if(s&&s.mode===L.ListMode.MultiSelect&&j===false){s.mode=L.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}else if(i&&i.mode===L.ListMode.MultiSelect&&j===false){i.mode=L.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}try{C.apply(this,arguments);if(j===false){this.bInstantUpload=j;this._oFormatDecimal=h.getInstance({binaryFilesize:false,maxFractionDigits:1,maxIntegerDigits:3});}}catch(e){this.destroy();throw e;}},metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null},noDataDescription:{type:"string",group:"Appearance",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:"All"},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"},instantUpload:{type:"boolean",group:"Behavior",defaultValue:true},numberOfAttachmentsText:{type:"string",group:"Appearance",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:"None"},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},terminationEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item",bindable:"bindable"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"},toolbar:{type:"sap.m.OverflowToolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},_list:{type:"sap.m.List",multiple:false,visibility:"hidden"},_noDataIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{change:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileDeleted:{parameters:{documentId:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"},files:{type:"object[]"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"},files:{type:"object[]"}}},uploadTerminated:{parameters:{fileName:{type:"string"},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},beforeUploadStarts:{parameters:{fileName:{type:"string"},addHeaderParameter:{type:"function",parameters:{headerParameter:{type:"sap.m.UploadCollectionParameter"}}},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},selectionChange:{parameters:{selectedItem:{type:"sap.m.UploadCollectionItem"},selectedItems:{type:"sap.m.UploadCollectionItem[]"},selected:{type:"boolean"}}}}}});r._uploadingStatus="uploading";r._displayStatus="display";r._toBeDeletedStatus="toBeDeleted";r._pendingUploadStatus="pendingUploadStatus";r._placeholderCamera="sap-icon://card";r._markerMargin=8;if(p.system.phone){r._resizeTimeoutInterval=500;}else{r._resizeTimeoutInterval=100;}r.prototype.init=function(){r.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._headerParamConst={requestIdName:"requestId"+q.now(),fileNameRequestIdName:"fileNameRequestId"+q.now()};this._requestIdValue=0;this._iFUCounter=0;this._oList=new f(this.getId()+"-list",{selectionChange:[this._handleSelectionChange,this]});this.setAggregation("_list",this._oList,true);this._oList.addStyleClass("sapMUCList");this.setAggregation("_noDataIcon",new I(this.getId()+"-no-data-icon",{src:"sap-icon://document",size:"6rem",noTabStop:true}),true);this.setAggregation("_dragDropIcon",new I(this.getId()+"-drag-drop-icon",{src:"sap-icon://upload-to-cloud",size:"4rem",noTabStop:true}),true);this.setAggregation("_dragDropText",new T(this.getId()+"-drag-drop-text",{text:this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR")}),true);this._iUploadStartCallCounter=0;this.aItems=[];this._aDeletedItemForPendingUpload=[];this._aFileUploadersForPendingUpload=[];this._aFilesFromDragAndDropForPendingUpload=[];this._iFileUploaderPH=null;this._oListEventDelegate=null;this._oItemToUpdate=null;this._sReziseHandlerId=null;};r.prototype.setFileType=function(e){if(!e){return this;}if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change fileType at runtime.");}else{var j=e.length;for(var i=0;i<j;i++){e[i]=e[i].toLowerCase();}if(this.getFileType()!==e){this.setProperty("fileType",e,true);this._getFileUploader().setFileType(e);}}return this;};r.prototype.setMaximumFilenameLength=function(i){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFilenameLength at runtime.");}else if(this.getMaximumFilenameLength()!==i){this.setProperty("maximumFilenameLength",i,true);this._getFileUploader().setMaximumFilenameLength(i);}return this;};r.prototype.setMaximumFileSize=function(i){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFileSize at runtime.");}else if(this.getMaximumFileSize()!==i){this.setProperty("maximumFileSize",i,true);this._getFileUploader().setMaximumFileSize(i);}return this;};r.prototype.setMimeType=function(e){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change mimeType at runtime.");}else if(this.getMimeType()!==e){this.setProperty("mimeType",e,true);this._getFileUploader().setMimeType(e);}return this;};r.prototype.setMultiple=function(e){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change multiple at runtime.");}else if(this.getMultiple()!==e){this.setProperty("multiple",e);this._getFileUploader().setMultiple(e);}return this;};r.prototype.setShowSeparators=function(s){if(this.getShowSeparators()!==s){this.setProperty("showSeparators",s);this._oList.setShowSeparators(s);}return this;};r.prototype.setUploadEnabled=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadEnabled at runtime.");}else if(this.getUploadEnabled()!==u){this.setProperty("uploadEnabled",u);this._getFileUploader().setEnabled(u);}return this;};r.prototype.setUploadUrl=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadUrl at runtime.");}else if(this.getUploadUrl()!==u){this.setProperty("uploadUrl",u);this._getFileUploader().setUploadUrl(u);}return this;};r.prototype.setInstantUpload=function(){q.sap.log.error("It is not supported to change the behavior at runtime.");return this;};r.prototype.setMode=function(e){if(e===L.ListMode.Delete){this._oList.setMode(L.ListMode.None);q.sap.log.info("sap.m.ListMode.Delete is not supported by UploadCollection. Value has been resetted to 'None'");}else if(e===L.ListMode.MultiSelect&&!this.getInstantUpload()){this._oList.setMode(L.ListMode.None);q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Pending Upload. Value has been resetted to 'None'");}else{this._oList.setMode(e);}return this;};r.prototype.getMode=function(){return this._oList.getMode();};r.prototype.getToolbar=function(){return this._oHeaderToolbar;};r.prototype.getInfoToolbar=function(){return this._oList.getAggregation("infoToolbar");};r.prototype.getNoDataText=function(){var N=this.getProperty("noDataText");N=N||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_TEXT");return N;};r.prototype.getNoDataDescription=function(){var N=this.getProperty("noDataDescription");N=N||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_DESCRIPTION");return N;};r.prototype.setInfoToolbar=function(i){if(this.getInfoToolbar()!==i){this._oList.setAggregation("infoToolbar",i,false);}};r.prototype.setUploadButtonInvisible=function(u){if(this.getUploadButtonInvisible()===u){return this;}this.setProperty("uploadButtonInvisible",u,true);if(this.getInstantUpload()){this._getFileUploader().setVisible(!u);}else{this._setFileUploaderVisibility(u);}if(this._bDragDropEnabled){this._unbindDragEnterLeave();this._bDragDropEnabled=false;}else{this._bindDragEnterLeave();}return this;};r.prototype.getInternalRequestHeaderNames=function(){return[this._headerParamConst.fileNameRequestIdName,this._headerParamConst.requestIdName];};r.prototype.upload=function(){if(this.getInstantUpload()){q.sap.log.error("Not a valid API call. 'instantUpload' should be set to 'false'.");}var e=this._aFileUploadersForPendingUpload.length;for(var i=0;i<e;i++){this._iUploadStartCallCounter=0;if(this._aFileUploadersForPendingUpload[i].getValue()){this._aFileUploadersForPendingUpload[i].upload();}}if(this._aFilesFromDragAndDropForPendingUpload.length>0){this._oFileUploader._sendFilesFromDragAndDrop(this._aFilesFromDragAndDropForPendingUpload);this._aFilesFromDragAndDropForPendingUpload=[];}};r.prototype.getSelectedItems=function(){var s=this._oList.getSelectedItems();return this._getUploadCollectionItemsByListItems(s);};r.prototype.getSelectedItem=function(){var s=this._oList.getSelectedItem();if(s){return this._getUploadCollectionItemByListItem(s);}return null;};r.prototype.setSelectedItemById=function(i,s){this._oList.setSelectedItemById(i+"-cli",s);this._setSelectedForItems([this._getUploadCollectionItemById(i)],s);return this;};r.prototype.setSelectedItem=function(u,s){return this.setSelectedItemById(u.getId(),s);};r.prototype.selectAll=function(){var s=this._oList.selectAll();if(s.getItems().length!==this.getItems().length){q.sap.log.info("Internal 'List' and external 'UploadCollection' are not in sync.");}this._setSelectedForItems(this.getItems(),true);return this;};r.prototype.downloadItem=function(u,e){if(!this.getInstantUpload()){q.sap.log.info("Download is not possible on Pending Upload mode");return false;}else{return u.download(e);}};r.prototype.openFileDialog=function(i){if(this._oFileUploader){if(i){if(!this._oFileUploader.getMultiple()){this._oItemToUpdate=i;this._oFileUploader.$().find("input[type=file]").trigger("click");}else{q.sap.log.warning("Version Upload cannot be used in multiple upload mode");}}else{this._oFileUploader.$().find("input[type=file]").trigger("click");}}return this;};r.prototype.removeAggregation=function(A,v,s){var e,i,j;if(!this.getInstantUpload()&&A==="items"&&v){e=v._internalFileIdWithinDragDropArray;if(e){i=this._aFilesFromDragAndDropForPendingUpload.indexOf(e);if(i!==-1){this._aFilesFromDragAndDropForPendingUpload.splice(i,1);}}else if(q.isNumeric(v)){j=this.getItems();this._aDeletedItemForPendingUpload.push(j[v]);}else{this._aDeletedItemForPendingUpload.push(v);}}return C.prototype.removeAggregation.apply(this,arguments);};r.prototype.removeAllAggregation=function(A,s){if(!this.getInstantUpload()&&A==="items"){if(this._aFileUploadersForPendingUpload){for(var i=0;i<this._aFileUploadersForPendingUpload.length;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=[];}}return C.prototype.removeAllAggregation.apply(this,arguments);};r.prototype.onBeforeRendering=function(){this._RenderManager=this._RenderManager||sap.ui.getCore().createRenderManager();var i,e;if(this._oListEventDelegate){this._oList.removeEventDelegate(this._oListEventDelegate);this._oListEventDelegate=null;}this._deregisterSizeHandler();this._unbindDragEnterLeave();j.bind(this)();if(!this.getInstantUpload()){this.aItems=this.getItems();this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this._oHeaderToolbar);return;}if(this.aItems.length>0){e=this.aItems.length;var u=[];for(i=0;i<e;i++){if(this.aItems[i]&&this.aItems[i]._status===r._uploadingStatus){u.push(this.aItems[i]);}else if(this.aItems[i]&&this.aItems[i]._status!==r._uploadingStatus&&this.aItems[i]._percentUploaded===100&&this.getItems().length===0){u.push(this.aItems[i]);}}if(u.length!==0){this.aItems=[];this.aItems=this.getItems();this.aItems=u.concat(this.aItems);}else{this.aItems=this.getItems();}}else{this.aItems=this.getItems();}this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setAggregation("headerToolbar",this._oHeaderToolbar,true);if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!==this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled());}}else{this._oFileUploader.setEnabled(false);}if(this.sDeletedItemId){q(document.activeElement).blur();}function j(){if(this.bInstantUpload===false){this.setProperty("instantUpload",this.bInstantUpload,true);delete this.bInstantUpload;}}};r.prototype.onAfterRendering=function(){this._bindDragEnterLeave();if(this.getInstantUpload()){if(this.aItems||(this.aItems===this.getItems())){if(this.editModeItem){var $=q.sap.byId(this.editModeItem+"-ta_editFileName-inner");if($){var i=this.editModeItem;if(!p.os.ios){$.focus(function(){$.selectText(0,$.val().length);});}$.focus();this._oListEventDelegate={onclick:function(e){this._handleClick(e,i);}.bind(this)};this._oList.addDelegate(this._oListEventDelegate);}}else if(this.sFocusId){this._setFocusToLineItem(this.sFocusId);this.sFocusId=null;}else if(this.sDeletedItemId){this._setFocusAfterDeletion();}}}else if(this.sFocusId){this._setFocusToLineItem(this.sFocusId);this.sFocusId=null;}};r.prototype.exit=function(){var i,P,e;this._unbindDragEnterLeave();if(this._$RootNode){this._$RootNode=null;}if(this._oFileUploader){this._oFileUploader.destroy();this._oFileUploader=null;}if(this._oHeaderToolbar){this._oHeaderToolbar.destroy();this._oHeaderToolbar=null;}if(this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle.destroy();this._oNumberOfAttachmentsTitle=null;}if(this._RenderManager){this._RenderManager.destroy();}if(this._aFileUploadersForPendingUpload){P=this._aFileUploadersForPendingUpload.length;for(i=0;i<P;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=null;}for(i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===r._uploadingStatus){e=this.aItems.splice(i,1)[0];if(e.destroy){e.destroy();}}}this._deregisterSizeHandler();};r.prototype._bindDragEnterLeave=function(){this._bDragDropEnabled=this._isDragAndDropAllowed();if(!this._bDragDropEnabled){return;}if(!this._oDragDropHandler){this._oDragDropHandler={dragEnterUIArea:this._onDragEnterUIArea.bind(this),dragLeaveUIArea:this._onDragLeaveUIArea.bind(this),dragOverUIArea:this._onDragOverUIArea.bind(this),dropOnUIArea:this._onDropOnUIArea.bind(this),dragEnterUploadCollection:this._onDragEnterUploadCollection.bind(this),dragLeaveUploadCollection:this._onDragLeaveUploadCollection.bind(this),dragOverUploadCollection:this._onDragOverUploadCollection.bind(this),dropOnUploadCollection:this._onDropOnUploadCollection.bind(this)};}this._$RootNode=q(document.body);this._$RootNode.bind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.bind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.bind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.bind("drop",this._oDragDropHandler.dropOnUIArea);this._$DragDropArea=this.$("drag-drop-area");this.$().bind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().bind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().bind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().bind("drop",this._oDragDropHandler.dropOnUploadCollection);};r.prototype._unbindDragEnterLeave=function(){if(!this._bDragDropEnabled&&!this._oDragDropHandler){return;}if(this._$RootNode){this._$RootNode.unbind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.unbind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.unbind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.unbind("drop",this._oDragDropHandler.dropOnUIArea);}this.$().unbind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().unbind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().unbind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().unbind("drop",this._oDragDropHandler.dropOnUploadCollection);};r.prototype._onDragEnterUIArea=function(e){if(!this._checkForFiles(e)){return;}this._oLastEnterUIArea=e.target;this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");this._adjustDragDropIcon();};r.prototype._onDragOverUIArea=function(e){e.preventDefault();if(!this._checkForFiles(e)){return;}this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");};r.prototype._onDragLeaveUIArea=function(e){if(this._oLastEnterUIArea===e.target){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");}};r.prototype._onDropOnUIArea=function(e){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");};r.prototype._onDragEnterUploadCollection=function(e){if(!this._checkForFiles(e)){return;}if(e.target===this._$DragDropArea[0]){this._$DragDropArea.addClass("sapMUCDropIndicator");this._adjustDragDropIcon();this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DROP_FILE_INDICATOR"));}};r.prototype._onDragOverUploadCollection=function(e){e.preventDefault();};r.prototype._onDragLeaveUploadCollection=function(e){if(e.target===this._$DragDropArea[0]){this._$DragDropArea.removeClass("sapMUCDropIndicator");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));}};r.prototype._checkForFiles=function(e){var t=e.originalEvent.dataTransfer.types;if(t){for(var i=0;i<t.length;i++){if(t[i]==="Files"){return true;}}}return false;};r.prototype._isDragAndDropAllowed=function(){return this.getUploadEnabled()&&!this.getUploadButtonInvisible();};r.prototype._onDropOnUploadCollection=function(e){if(!this._checkForFiles(e)){e.preventDefault();return;}if(e.target===this._$DragDropArea[0]){e.preventDefault();this._$DragDropArea.removeClass("sapMUCDropIndicator");this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));var j=e.originalEvent.dataTransfer.files;if(j.length>1&&!this.getMultiple()){var s=this._oRb.getText("UPLOADCOLLECTION_MULTIPLE_FALSE");a.error(s);return;}if(!this._oFileUploader._areFilesAllowed(j)){return;}if(!this.getInstantUpload()){for(var i=0;i<j.length;i++){this._oFileUploader.fireChange({files:[j[i]],fromDragDrop:true});this._aFilesFromDragAndDropForPendingUpload.push(j[i]);}}else{this._oFileUploader.fireChange({files:j});this._oFileUploader._sendFilesFromDragAndDrop(j);}}};r.prototype._adjustDragDropIcon=function(){if(this._$DragDropArea[0].offsetHeight<160){this.getAggregation("_dragDropIcon").$().hide();}};r.prototype._deregisterSizeHandler=function(){p.orientation.detachHandler(this._onResize,this);R.deregister(this._sReziseHandlerId);};r.prototype._hideFileUploaders=function(){var t,i;if(!this.getInstantUpload()){t=this._oHeaderToolbar.getContent().length;if(this._aFileUploadersForPendingUpload.length){for(i=0;i<t;i++){if(this._oHeaderToolbar.getContent()[i]instanceof g){if(i===this._iFileUploaderPH&&this._bFocusFileUploader){this._oHeaderToolbar.getContent()[i].$().find("button").focus();}else{this._oHeaderToolbar.getContent()[i].$().hide();}}}}}};r.prototype._truncateFileName=function(e){if(!e){return;}if(e._status==="Edit"){var s=e.getId()+"-cli";this.$().find("#"+s).find(".sapMUCObjectMarkerContainer").attr("style","display: none");return;}var j=0;var t=e.getMarkers();var u;for(var i=0;i<t.length;i++){j=j+t[i].$().width()+r._markerMargin;}if(j>0){var $=this.$().find("#"+e.getId()+"-ta_filenameHL");if($){u="max-width: calc(100% - "+j+"px)";if($.attr("style")!==u){$.attr("style",u);}}}};r.prototype._getListHeader=function(e){var j,i;this._setNumberOfAttachmentsTitle(e);if(!this._oHeaderToolbar){if(!!this._oFileUploader&&!this.getInstantUpload()){this._oFileUploader.destroy();}j=this._getFileUploader();this._oHeaderToolbar=this.getAggregation("toolbar");if(!this._oHeaderToolbar){this._oHeaderToolbar=new O(this.getId()+"-toolbar",{content:[this._oNumberOfAttachmentsTitle,new k(),j]}).addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=2;}else{this._oHeaderToolbar.addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=this._getFileUploaderPlaceHolderPosition(this._oHeaderToolbar);if(this._oHeaderToolbar&&this._iFileUploaderPH>-1){this._setFileUploaderInToolbar(j);}else{q.sap.log.info("A place holder of type 'sap.m.UploadCollectionPlaceholder' needs to be provided.");}}}else if(!this.getInstantUpload()){var P=this._aFileUploadersForPendingUpload.length;for(i=P-1;i>=0;i--){if(this._aFileUploadersForPendingUpload[i].getId()===this._oFileUploader.getId()){j=this._getFileUploader();this._oHeaderToolbar.insertAggregation("content",j,this._iFileUploaderPH,true);break;}}}};r.prototype._getFileUploaderPlaceHolderPosition=function(t){for(var i=0;i<t.getContent().length;i++){if(t.getContent()[i]instanceof n){return i;}}return-1;};r.prototype._setFileUploaderInToolbar=function(e){this._oHeaderToolbar.getContent()[this._iFileUploaderPH].setVisible(false);this._oHeaderToolbar.insertContent(e,this._iFileUploaderPH);};r.prototype._mapItemToListItem=function(i){if(!i||(this._oItemToUpdate&&i.getId()===this._oItemToUpdate.getId())){return null;}var s,e,j,t,u,v,$,w,x;s=i.getId();e=i._status;j=i.getFileName();if(e===r._uploadingStatus){t=i._getBusyIndicator?i._getBusyIndicator():i._getControl("sap.m.BusyIndicator",{id:s+"-ia_indicator"},"BusyIndicator").addStyleClass("sapMUCloadingIcon");}else{x=this._createIcon(i,s,j);}v=s+"-container";$=q.sap.byId(v);if($){$.remove();$=null;}w=new H({content:"<span id="+v+" class='sapMUCTextButtonContainer'></span>",afterRendering:this._renderContent.bind(this,i,v)});u=new o(s+"-cli",{content:[t,x,w],selected:i.getSelected()});u._oUploadCollectionItem=i;u._status=e;u.addStyleClass("sapMUCItem");u.setTooltip(i.getTooltip_Text());return u;};r.prototype._renderContent=function(e,j){var s,i,A,t,u,P,v,w,x,y,z;P=e._percentUploaded;v=e.getAllAttributes();w=e.getStatuses();z=e.getMarkers();s=e.getId();A=v.length;t=w.length;u=z.length;y=e._status;x=this._RenderManager;x.write("<div class=\"sapMUCTextContainer ");if(y==="Edit"){x.write("sapMUCEditMode ");}x.write("\" >");x.renderControl(this._getFileNameControl(e));if(y===r._uploadingStatus){x.renderControl(this._createProgressLabel(e,P));}else{if(u>0){x.write("<div class=\"sapMUCObjectMarkerContainer\">");for(i=0;i<u;i++){x.renderControl(z[i].addStyleClass("sapMUCObjectMarker"));}x.write("</div>");}if(A>0){x.write("<div class=\"sapMUCAttrContainer\">");for(i=0;i<A;i++){v[i].addStyleClass("sapMUCAttr");x.renderControl(v[i]);if((i+1)<A){x.write("<div class=\"sapMUCSeparator\">&nbsp&#x00B7&#160</div>");}}x.write("</div>");}if(t>0){x.write("<div class=\"sapMUCStatusContainer\">");for(i=0;i<t;i++){w[i].detachBrowserEvent("hover");x.renderControl(w[i]);if((i+1)<t){x.write("<div class=\"sapMUCSeparator\">&nbsp&#x00B7&#160</div>");}}x.write("</div>");}}x.write("</div>");this._renderButtons(x,e,y,s);x.flush(q.sap.byId(j)[0],true);this._truncateFileName(e);this._sReziseHandlerId=R.register(this,this._onResize.bind(this));p.orientation.attachHandler(this._onResize,this);};r.prototype._renderButtons=function(e,j,s,t){var u,v;u=this._getButtons(j,s,t);if(u){v=u.length;}if(v>0){e.write("<div class=\"sapMUCButtonContainer\">");for(var i=0;i<v;i++){if((i+1)<v){u[i].addStyleClass("sapMUCFirstButton");}e.renderControl(u[i]);}e.write("</div>");}};r.prototype._getFileNameControl=function(i){var e,j,s,t,u,v,w,V,x,y,z;t=i.getFileName();u=i.getId();v=i._status;if(v!=="Edit"){e=i._getFileNameLink?i._getFileNameLink():i._getControl("sap.m.Link",{id:u+"-ta_filenameHL",press:[i,this._onItemPressed,this]},"FileNameLink");e.setEnabled(this._getItemPressEnabled(i));e.addStyleClass("sapMUCFileName");e.setModel(i.getModel());e.setText(t);return e;}else{j=r._splitFilename(t);w=this.getMaximumFilenameLength();V="None";x=false;s=j.name;if(i.errorState==="Error"){x=true;V="Error";s=i.changedFileName;if(s.length===0){z=this._oRb.getText("UPLOADCOLLECTION_TYPE_FILENAME");}else{z=this._oRb.getText("UPLOADCOLLECTION_EXISTS");}}y=i._getFileNameEditBox?i._getFileNameEditBox():i._getControl("sap.m.Input",{id:u+"-ta_editFileName",type:L.InputType.Text},"FileNameEditBox");y.addStyleClass("sapMUCEditBox");y.setModel(i.getModel());y.setValue(s);y.setValueState(V);y.setFieldWidth("75%");y.setValueStateText(z);y.setDescription(j.extension);y.setShowValueStateMessage(x);if((w-j.extension.length)>0){y.setProperty("maxLength",w-j.extension.length,true);}return y;}};r.prototype._getItemPressEnabled=function(i){return i._getPressEnabled()&&this.sErrorState!=="Error";};r.prototype._onItemPressed=function(e,i){if(i.hasListeners("press")){i.firePress();}else if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){this._triggerLink(e);}};r.prototype._createProgressLabel=function(i,e){var P,s=i.getId();P=i._getProgressLabel?i._getProgressLabel():i._getControl("sap.m.Label",{id:s+"-ta_progress"},"ProgressLabel").addStyleClass("sapMUCProgress");P.setText(this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[e]));return P;};r.prototype._createIcon=function(i,e,j){var t,s,u,v;t=i.getThumbnailUrl();if(t){u=b.createControlByURI({id:e+"-ia_imageHL",src:this._getThumbnail(t,j),decorative:false},c).addStyleClass("sapMUCItemImage sapMUCItemIcon");u.setAlt(this._getAriaLabelForPicture(i));}else{s=this._getThumbnail(undefined,j);u=new I(e+"-ia_iconHL",{src:s,decorative:false,useIconTooltip:false});u.setAlt(this._getAriaLabelForPicture(i));if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){v="sapMUCItemIcon";}else{v="sapMUCItemIconInactive";}if(s===r._placeholderCamera){if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){v=v+" sapMUCItemPlaceholder";}else{v=v+" sapMUCItemPlaceholderInactive";}}u.addStyleClass(v);}if(this._getItemPressEnabled(i)){u.attachPress(i,this._onItemPressed,this);}return u;};r.prototype._getButtons=function(i,s,e){var j,t,u,v,w,E,x;j=[];if(!this.getInstantUpload()){v="deleteButton";w=this._createDeleteButton(e,v,i,this.sErrorState);j.push(w);return j;}if(s==="Edit"){t=i._getOkButton?i._getOkButton():i._getControl("sap.m.Button",{id:e+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_RENAMEBUTTON_TEXT"),type:L.ButtonType.Transparent},"OkButton").addStyleClass("sapMUCOkBtn");u=i._getCancelButton?i._getCancelButton():i._getControl("sap.m.Button",{id:e+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:L.ButtonType.Transparent},"CancelButton").addStyleClass("sapMUCCancelBtn");j.push(t);j.push(u);}else if(s===r._uploadingStatus){v="terminateButton";w=this._createDeleteButton(e,v,i,this.sErrorState);j.push(w);}else{E=i.getEnableEdit();if(this.sErrorState==="Error"){E=false;}if(i.getVisibleEdit()){x=i._getEditButton?i._getEditButton():i._getControl("sap.m.Button",{id:e+"-editButton",icon:"sap-icon://edit",type:L.ButtonType.Standard,tooltip:this._oRb.getText("UPLOADCOLLECTION_EDITBUTTON_TEXT"),press:[i,this._handleEdit,this]},"EditButton").addStyleClass("sapMUCEditBtn");x.setEnabled(E);x.setVisible(i.getVisibleEdit());j.push(x);}v="deleteButton";if(i.getVisibleDelete()){w=this._createDeleteButton(e,v,i,this.sErrorState);j.push(w);}}return j;};r.prototype._createDeleteButton=function(i,e,j,s){var E,t,G,u,v,V,P;E=j.getEnableDelete();if(s==="Error"){E=false;}if(e==="deleteButton"){G="DeleteButton";v=j._getDeleteButton;u=this._oRb.getText("UPLOADCOLLECTION_DELETEBUTTON_TEXT");V=j.getVisibleDelete();P=[this,this._handleDelete,this];}else{G="TerminateButton";v=j._getTerminateButton;u=this._oRb.getText("UPLOADCOLLECTION_TERMINATEBUTTON_TEXT");V=this.getTerminationEnabled();P=[j,this._handleTerminate,this];}t=v?v():j._getControl("sap.m.Button",{id:i+"-"+e,icon:"sap-icon://sys-cancel",type:L.ButtonType.Standard,press:P},G).addStyleClass("sapMUCDeleteBtn");t.setVisible(V);t.setEnabled(E);t.setTooltip(u);return t;};r.prototype._fillList=function(i){var t=this,e=i.length-1,j=this.getBinding("items"),G=false,s,u=this.getBindingInfo("items")?this.getBindingInfo("items").groupHeaderFactory:null;var v=function(x){return x.getBindingContext()?j.getGroup(x.getBindingContext()):null;};var w=function(x){return v(x)&&v(x).key;};q.each(i,function(x,y){if(j&&j.isGrouped()&&y){if(!G||s!==w(y)){if(u){t._oList.addItemGroup(v(y),u(v(y)),true);}else if(v(y)){t._oList.addItemGroup(v(y),null,true);}G=true;s=w(y);}}if(!y._status){y._status=r._displayStatus;}else if(t.getInstantUpload()&&t._oItemForDelete&&t._oItemForDelete._status===r._toBeDeletedStatus&&y.getDocumentId()===t._oItemForDelete.documentId){return false;}if(!y._percentUploaded&&y._status===r._uploadingStatus){y._percentUploaded=0;}var z=t._mapItemToListItem(y);if(z){if(x===0&&e===0){z.addStyleClass("sapMUCListSingleItem");}else if(x===0){z.addStyleClass("sapMUCListFirstItem");}else if(x===e){z.addStyleClass("sapMUCListLastItem");}else{z.addStyleClass("sapMUCListItem");}t._oList.addAggregation("items",z,true);y.attachEvent("selected",t._handleItemSetSelected,t);}return true;});};r.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true);}};r.prototype._setNumberOfAttachmentsTitle=function(e){var i=e||0;var t;if(this._oItemToUpdate){i--;}if(this.getNumberOfAttachmentsText()){t=this.getNumberOfAttachmentsText();}else{t=this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[i]);}if(!this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle=new d(this.getId()+"-numberOfAttachmentsTitle",{text:t});}else{this._oNumberOfAttachmentsTitle.setText(t);}};r.prototype._setFileUploaderVisibility=function(u){var t=this._oHeaderToolbar.getContent();if(t){var P=t[this._iFileUploaderPH];if(P instanceof g){P.setVisible(!u);}}};r.prototype._handleDelete=function(e){var P=e.getParameters();var j=this.getItems();var s=P.id.split("-deleteButton")[0];var t;var u;var v="";var w;var x;for(var i=0;i<j.length;i++){if(j[i].sId===s){u=i;t={documentId:j[i].getDocumentId(),_iLineNumber:u};break;}}if(j[u].hasListeners("deletePress")){j[u].fireDeletePress();return;}this.sDeletedItemId=s;if(q.sap.byId(this.sId).hasClass("sapUiSizeCompact")){v="sapUiSizeCompact";}if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return;}}if(j[u]&&j[u].getEnableDelete()){w=j[u].getFileName();if(!w){x=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT");}else{x=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",w);}this._oItemForDelete=t;a.show(x,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[a.Action.OK,a.Action.CANCEL],onClose:this._onCloseMessageBoxDeleteItem.bind(this),dialogId:"messageBoxDeleteFile",styleClass:v});}};r.prototype._onCloseMessageBoxDeleteItem=function(e){var j=this.getItems();var s;if(this.getInstantUpload()){for(var i=0;i<j.length;i++){if(j[i].getDocumentId()===this._oItemForDelete.documentId){s=j[i];}}}else{s=j[this._oItemForDelete._iLineNumber];}if(e===a.Action.OK){this._oItemForDelete._status=r._toBeDeletedStatus;if(this.getInstantUpload()){this.fireFileDeleted({documentId:this._oItemForDelete.documentId,item:s});this._oItemForDelete=null;}else{if(this.aItems.length===1){if(!this.getUploadButtonInvisible()){this.sFocusId=this._oFileUploader.$().find(":button")[0].id;}}else if(this._oItemForDelete._iLineNumber<this.aItems.length-1){this.sFocusId=this.aItems[this._oItemForDelete._iLineNumber+1].getId()+"-cli";}else{this.sFocusId=this.aItems[0].getId()+"-cli";}this._aDeletedItemForPendingUpload.push(s);this.aItems.splice(this._oItemForDelete._iLineNumber,1);this.removeAggregation("items",s,false);}}};r.prototype._handleTerminate=function(e,j){var s,t;s=new f({items:[new S({title:j.getFileName(),icon:this._getIconFromFilename(j.getFileName())})]});t=new D({id:this.getId()+"deleteDialog",title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new T({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),s],buttons:[new B({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:[u,this]}),new B({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){t.close();}})],afterClose:function(){t.destroy();}}).open();function u(){var A=false;for(var i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===r._uploadingStatus&&this.aItems[i]._requestIdName===j._requestIdName){this.aItems[i]._status=r._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];A=true;break;}else if(j.getFileName()===this.aItems[i].getFileName()&&this.aItems[i]._status===r._displayStatus){this.aItems[i]._status=r._toBeDeletedStatus;this._oItemForDelete=this.aItems[i];this.fireFileDeleted({documentId:this.aItems[i].getDocumentId(),item:this.aItems[i]});break;}}if(A){this._getFileUploader().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(j.getFileName())+this._oItemForDelete._requestIdName);}t.close();this.invalidate();}};r.prototype._handleEdit=function(e,j){var i,s=j.getId(),t=this.aItems.length;if(this.editModeItem){this._handleOk(e,this.editModeItem,false);}if(this.sErrorState!=="Error"){for(i=0;i<t;i++){if(this.aItems[i].getId()===s){this.aItems[i]._status="Edit";break;}}j._status="Edit";this.editModeItem=e.getSource().getId().split("-editButton")[0];this.invalidate();}};r.prototype._handleClick=function(e,i){var $=q(e.target).closest("button");var s="";if($.length){s=$.prop("id");}if(s.lastIndexOf("editButton")===-1){if(s.lastIndexOf("cancelButton")!==-1){this._handleCancel(e,i);}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName-inner")<0){if(e.target.id.lastIndexOf("cli")>0){this.sFocusId=e.target.id;}this._handleOk(e,i,true);}}};r.prototype._handleOk=function(e,i,j){var E=document.getElementById(i+"-ta_editFileName-inner");var N;var s=r._findById(i,this.aItems);var t=s.getProperty("fileName");var u=r._splitFilename(t);var v=sap.ui.getCore().byId(i+"-ta_editFileName");var w=s.errorState;var x=s.changedFileName;if(E!==null){N=E.value.replace(/^\s+/,"");}this.sFocusId=i+"-cli";if(!N||N.length===0){if(E!==null){this._setErrorStateOnItem(this,s,N,x,w);}return;}s._status=r._displayStatus;if(u.name===N){this._removeErrorStateFromItem(this,s);if(j){this.invalidate();}return;}if(this.getSameFilenameAllowed()){this._removeErrorStateFromItem(this,s);this._oItemForRename=s;this._onEditItemOk.bind(this)(N+u.extension);return;}if(r._checkDoubleFileName(N+u.extension,this.aItems)){v.setProperty("valueState","Error",true);this._setErrorStateOnItem(this,s,N,x,w);}else{v.setProperty("valueState","None",true);s.changedFileName=null;this._removeErrorStateFromItem(this,s);if(j){this.invalidate();}this._oItemForRename=s;this._onEditItemOk.bind(this)(N+u.extension);}};r.prototype._setErrorStateOnItem=function(e,s,N,i,E){s._status="Edit";s.errorState="Error";e.sErrorState="Error";s.changedFileName=N;if(E!=="Error"||i!==N){e.invalidate();}};r.prototype._removeErrorStateFromItem=function(e,i){i.errorState=null;e.sErrorState=null;e.editModeItem=null;};r.prototype._onEditItemOk=function(N){if(this._oItemForRename){this._oItemForRename.setFileName(N);this.fireFileRenamed({documentId:this._oItemForRename.getProperty("documentId"),fileName:N,item:this._oItemForRename});}delete this._oItemForRename;};r.prototype._handleCancel=function(e,i){var j=r._findById(i,this.aItems);j._status=r._displayStatus;j.errorState=null;j.changedFileName=j._getFileNameEditBox().getValue();this.sFocusId=this.editModeItem+"-cli";this.sErrorState=null;this.editModeItem=null;this.invalidate();};r.prototype._onChange=function(e){if(e){var s,j=e.getParameter("files").length,i,t,u,v,A;if(j===0){return;}this._oFileUploader.removeAllAggregation("headerParameters",true);this.removeAllAggregation("headerParameters",true);this._oFileUploader.removeAllAggregation("parameters",true);this.removeAllAggregation("parameters",true);this.fireChange({getParameter:function(x){if(x){return e.getParameter(x);}return null;},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:e.getParameter("files")});var P=this.getAggregation("parameters");if(P){q.each(P,function(x,y){var z=new F({name:y.getProperty("name"),value:y.getProperty("value")});this._oFileUploader.addParameter(z);}.bind(this));}if(!this.getInstantUpload()){this._bFocusFileUploader=true;u=r._pendingUploadStatus;}else{u=r._uploadingStatus;}this._requestIdValue++;s=this._requestIdValue.toString();var w=this.getAggregation("headerParameters");if(!this.getInstantUpload()){this._aFileUploadersForPendingUpload.push(this._oFileUploader);}for(i=0;i<j;i++){t=new U({fileName:e.getParameter("files")[i].name});if(e.getParameter("fromDragDrop")){t._internalFileIdWithinDragDropArray=e.getParameter("files")[i];}t._status=u;t._internalFileIndexWithinFileUploader=i+1;t._requestIdName=s;if(!this.getInstantUpload()){t.setAssociation("fileUploader",this._oFileUploader,true);v=this._oFormatDecimal.format(e.getParameter("files")[i].size);A=new l({text:v});t.insertAggregation("attributes",A,true);this.insertItem(t);}else{t._percentUploaded=0;}this.aItems.unshift(t);}if(w){q.each(w,function(x,y){this._oFileUploader.addHeaderParameter(new F({name:y.getProperty("name"),value:y.getProperty("value")}));}.bind(this));}this._oFileUploader.addHeaderParameter(new F({name:this._headerParamConst.requestIdName,value:s}));}};r.prototype._onFilenameLengthExceed=function(e){var i={name:e.getParameter("fileName")};var j=[i];this.fireFilenameLengthExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:j});};r.prototype._onFileSizeExceed=function(e){var i={name:e.getParameter("fileName"),fileSize:e.getParameter("fileSize")};this.fireFileSizeExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:[i]});};r.prototype._onTypeMissmatch=function(e){var i={name:e.getParameter("fileName"),fileType:e.getParameter("fileType"),mimeType:e.getParameter("mimeType")};var j=[i];this.fireTypeMissmatch({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:j});};r.prototype._onUploadTerminated=function(e){var i;var s=this._getRequestId(e);var j=e.getParameter("fileName");var t=this.aItems.length;for(i=0;i<t;i++){if(this.aItems[i]&&this.aItems[i].getFileName()===j&&this.aItems[i]._requestIdName===s&&(this.aItems[i]._status===r._uploadingStatus||this.aItems[i]._status===r._toBeDeletedStatus)){this.aItems.splice(i,1);this.removeItem(i);break;}}this.fireUploadTerminated({fileName:j,getHeaderParameter:this._getHeaderParameterWithinEvent.bind(e)});};r.prototype._onUploadComplete=function(e){if(e){var i,s=this._getRequestId(e),u=e.getParameter("fileName"),j,t,v,w=x();j=this.aItems.length;v=[r._uploadingStatus,r._pendingUploadStatus];for(i=0;i<j;i++){if((!s||this.aItems[i]._requestIdName===s)&&this.aItems[i].getProperty("fileName")===u&&(v.indexOf(this.aItems[i]._status)>=0)){if(w&&this.aItems[i]._status!==r._pendingUploadStatus){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=r._displayStatus;}t=this.aItems.splice(i,1)[0];if(t.destroy){t.destroy();}this._oItemToUpdate=null;break;}}this.fireUploadComplete({getParameter:e.getParameter,getParameters:e.getParameters,mParameters:e.getParameters(),files:[{fileName:e.getParameter("fileName")||u,responseRaw:e.getParameter("responseRaw"),reponse:e.getParameter("response"),response:e.getParameter("response"),status:e.getParameter("status"),headers:e.getParameter("headers")}]});}this.invalidate();function x(){var y=e.getParameter("status").toString()||"200";return y[0]==="2"||y[0]==="3";}};r.prototype._onUploadProgress=function(e){if(!e||!this.getInstantUpload()){return;}var u=e.getParameter("fileName"),P,j=Math.round(e.getParameter("loaded")/e.getParameter("total")*100),s=this._getRequestId(e),t=this.aItems.length,v,$,w;if(j===100){P=this._oRb.getText("UPLOADCOLLECTION_UPLOAD_COMPLETED");}else{P=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[j]);}for(var i=0;i<t;i++){w=this.aItems[i];if(w.getProperty("fileName")===u&&w._requestIdName===s&&w._status===r._uploadingStatus){v=w._getProgressLabel?w._getProgressLabel():w._getControl("sap.m.Label",{id:w.getId()+"-ta_progress"},"ProgressLabel");if(v){v.setText(P);w._percentUploaded=j;$=q.sap.byId(w.getId()+"-ia_indicator");if(j===100){$.attr("aria-label",P);}else{$.attr("aria-valuenow",j);}break;}}}};r.prototype._getRequestId=function(e){var i;i=e.getParameter("requestHeaders");if(!i){return null;}for(var j=0;j<i.length;j++){if(i[j].name===this._headerParamConst.requestIdName){return i[j].value;}}return null;};r.prototype._getFileUploader=function(){var u=this.getInstantUpload();if(!u||!this._oFileUploader){var t=this.getInstantUpload()?this._oRb.getText("UPLOADCOLLECTION_UPLOAD"):this._oRb.getText("UPLOADCOLLECTION_ADD");this._iFUCounter=this._iFUCounter+1;this._oFileUploader=new g(this.getId()+"-"+this._iFUCounter+"-uploader",{buttonOnly:true,buttonText:t,tooltip:t,iconOnly:true,enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"sap-icon://add",iconFirst:false,style:"Transparent",maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:this.getMultiple(),name:"uploadCollection",uploadOnChange:u,sameFilenameAllowed:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:true,change:[this._onChange,this],filenameLengthExceed:[this._onFilenameLengthExceed,this],fileSizeExceed:[this._onFileSizeExceed,this],typeMissmatch:[this._onTypeMissmatch,this],uploadAborted:[this._onUploadTerminated,this],uploadComplete:[this._onUploadComplete,this],uploadProgress:[this._onUploadProgress,this],uploadStart:[this._onUploadStart,this],visible:!this.getUploadButtonInvisible()});}return this._oFileUploader;};r.prototype._onUploadStart=function(e){var j,i,s,P,t,G;this._iUploadStartCallCounter++;P=e.getParameter("requestHeaders").length;for(i=0;i<P;i++){if(e.getParameter("requestHeaders")[i].name===this._headerParamConst.requestIdName){s=e.getParameter("requestHeaders")[i].value;break;}}t=e.getParameter("fileName");j={name:this._headerParamConst.fileNameRequestIdName,value:this._encodeToAscii(t)+s};e.getParameter("requestHeaders").push(j);for(i=0;i<this._aDeletedItemForPendingUpload.length;i++){if(this._aDeletedItemForPendingUpload[i].getAssociation("fileUploader")===e.oSource.sId&&this._aDeletedItemForPendingUpload[i].getFileName()===t&&this._aDeletedItemForPendingUpload[i]._internalFileIndexWithinFileUploader===this._iUploadStartCallCounter){e.getSource().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(t)+s);return;}}this.fireBeforeUploadStarts({fileName:t,addHeaderParameter:u,getHeaderParameter:v.bind(this)});if(q.isArray(G)){for(i=0;i<G.length;i++){if(e.getParameter("requestHeaders")[i].name===G[i].getName()){e.getParameter("requestHeaders")[i].value=G[i].getValue();}}}else if(G instanceof m){for(i=0;i<e.getParameter("requestHeaders").length;i++){if(e.getParameter("requestHeaders")[i].name===G.getName()){e.getParameter("requestHeaders")[i].value=G.getValue();break;}}}function u(w){var j={name:w.getName(),value:w.getValue()};e.getParameter("requestHeaders").push(j);}function v(w){G=this._getHeaderParameterWithinEvent.bind(e)(w);return G;}};r.prototype._getIconFromFilename=function(s){var e=r._splitFilename(s).extension;if(q.type(e)==="string"){e=e.toLowerCase();}switch(e){case".bmp":case".jpg":case".jpeg":case".png":return r._placeholderCamera;case".csv":case".xls":case".xlsx":return"sap-icon://excel-attachment";case".doc":case".docx":case".odt":return"sap-icon://doc-attachment";case".pdf":return"sap-icon://pdf-attachment";case".ppt":case".pptx":return"sap-icon://ppt-attachment";case".txt":return"sap-icon://document-text";default:return"sap-icon://document";}};r.prototype._getThumbnail=function(t,s){if(t){return t;}else{return this._getIconFromFilename(s);}};r.prototype._triggerLink=function(e){var i,j;if(this.editModeItem){this._handleOk(e,this.editModeItem,true);if(this.sErrorState==="Error"){return;}this.sFocusId=e.getParameter("id");}j=e.oSource.getId().split("-");i=j[j.length-2];M.URLHelper.redirect(this.aItems[i].getProperty("url"),true);};r.prototype.onkeydown=function(e){switch(e.keyCode){case q.sap.KeyCodes.F2:this._handleF2(e);break;case q.sap.KeyCodes.ESCAPE:this._handleESC(e);break;case q.sap.KeyCodes.DELETE:this._handleDEL(e);break;case q.sap.KeyCodes.ENTER:this._handleENTER(e);break;default:return;}e.setMarked();};r.prototype._setFocusAfterDeletion=function(){var i=this.aItems.length;var s;if(i===0){this._oFileUploader.focus();}else{var e=this.sDeletedItemId.split("-").pop();if(e<=i-1){s=this.sDeletedItemId+"-cli";}else{s=this.aItems[this.aItems.length-1].sId+"-cli";}this._setFocusToLineItem(s);}this.sDeletedItemId=null;};r.prototype._setFocusToLineItem=function(i){q.sap.byId(i).focus();};r.prototype._handleENTER=function(e){var t,s,i,j;if(this.editModeItem){t=e.target.id.split(this.editModeItem).pop();}else{t=e.target.id.split("-").pop();}switch(t){case"-ta_editFileName-inner":case"-okButton":this._handleOk(e,this.editModeItem,true);break;case"-cancelButton":e.preventDefault();this._handleCancel(e,this.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":j=this.editModeItem.split("-").pop();M.URLHelper.redirect(this.aItems[j].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":case"cli":s=e.target.id.split(t)[0]+"ta_filenameHL";i=sap.ui.getCore().byId(s);if(i.getEnabled()){j=e.target.id.split("-")[2];M.URLHelper.redirect(this.aItems[j].getProperty("url"),true);}break;default:break;}};r.prototype._handleDEL=function(e){if(!this.editModeItem){var t=e.target.id.slice(0,-4),i=sap.ui.getCore().byId(t),j=i&&i._getDeleteButton&&i._getDeleteButton();if(j){j.firePress();}}};r.prototype._handleESC=function(e){if(this.editModeItem){this.sFocusId=this.editModeItem+"-cli";this.aItems[this.editModeItem.split("-").pop()]._status=r._displayStatus;this._handleCancel(e,this.editModeItem);}};r.prototype._handleF2=function(e){var i=sap.ui.getCore().byId(e.target.id);if(i!==undefined){if(i._status===r._displayStatus){var j=q.sap.byId(e.target.id);var s=j.find("[id$='-editButton']");var E=sap.ui.getCore().byId(s[0].id);if(E.getEnabled()){if(this.editModeItem){this._handleClick(e,this.editModeItem);}if(this.sErrorState!=="Error"){E.firePress();}}}else{this._handleClick(e,this.editModeItem);}}else if(e.target.id.search(this.editModeItem)===0){this._handleOk(e,this.editModeItem,true);}};r._checkDoubleFileName=function(e,j){if(j.length===0||!e){return false;}var s=j.length;e=e.replace(/^\s+/,"");for(var i=0;i<s;i++){if(e===j[i].getProperty("fileName")){return true;}}return false;};r._splitFilename=function(e){var i={};var N=e.split(".");if(N.length===1){i.extension="";i.name=N.pop();return i;}i.extension="."+N.pop();i.name=N.join(".");return i;};r.prototype._getAriaLabelForPicture=function(i){var t;t=(i.getAriaLabelForPicture()||i.getFileName());return t;};r.prototype._getHeaderParameterWithinEvent=function(s){var u=[];var e=this.getParameter("requestHeaders");var P=e.length;var i;if(e&&s){for(i=0;i<P;i++){if(e[i].name===s){return new m({name:e[i].name,value:e[i].value});}}return null;}else if(e){for(i=0;i<P;i++){u.push(new m({name:e[i].name,value:e[i].value}));}return u;}};r.prototype._encodeToAscii=function(v){var e="";for(var i=0;i<v.length;i++){e=e+v.charCodeAt(i);}return e;};r.prototype._onResize=function(){var e=this._oList.getItems();for(var i=0;i<e.length;i++){q.sap.delayedCall(r._resizeTimeoutInterval,this,this._truncateFileName.bind(this),[e[i]._oUploadCollectionItem]);}};r.prototype._getUploadCollectionItemByListItem=function(e){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===e.getId().replace("-cli","")){return A[i];}}return null;};r.prototype._getUploadCollectionItemById=function(u){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===u){return A[i];}}return null;};r.prototype._getUploadCollectionItemsByListItems=function(e){var u=[];var s=this.getItems();if(e){for(var i=0;i<e.length;i++){for(var j=0;j<s.length;j++){if(e[i].getId().replace("-cli","")===s[j].getId()){u.push(s[j]);break;}}}return u;}return null;};r.prototype._setSelectedForItems=function(u,s){if(this.getMode()!==L.ListMode.MultiSelect&&s){var e=this.getItems();for(var j=0;j<e.length;j++){e[j].setSelected(false);}}for(var i=0;i<u.length;i++){u[i].setSelected(s);}};r.prototype._handleItemSetSelected=function(e){var i=e.getSource();if(i instanceof U){var j=this._getListItemById(i.getId()+"-cli");if(j){j.setSelected(i.getSelected());}}};r.prototype._handleSelectionChange=function(e){var i=e.getParameter("listItem");var s=e.getParameter("selected");var u=this._getUploadCollectionItemsByListItems(e.getParameter("listItems"));var j=this._getUploadCollectionItemByListItem(i);if(j&&i&&u){this.fireSelectionChange({selectedItem:j,selectedItems:u,selected:s});j.setSelected(i.getSelected());}};r.prototype._getListItemById=function(e){var i=this._oList.getItems();return r._findById(e,i);};r._findById=function(e,j){for(var i=0;i<j.length;i++){if(j[i].getId()===e){return j[i];}}return null;};return r;});
