/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Popover','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText'],function(q,l,C,P,I,a){"use strict";var N=C.extend("sap.tnt.NavigationList",{metadata:{library:"sap.tnt",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension"},expanded:{type:"boolean",group:"Misc",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.tnt.NavigationListItem",multiple:true,singularName:"item"}},associations:{ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},selectedItem:{type:"sap.tnt.NavigationListItem",multiple:false}},events:{itemSelect:{parameters:{item:{type:"sap.ui.core.Item"}}}}}});N.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);this._itemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this._resourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.core");if(sap.ui.getCore().getConfiguration().getAccessibility()&&!N._sAriaPopupLabelId){N._sAriaPopupLabelId=new a({text:''}).toStatic().getId();}};N.prototype.onAfterRendering=function(){this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(this._getDomRefs());if(this._selectedItem){this._selectedItem._select();}};N.prototype._updateNavItems=function(){this._itemNavigation.setItemDomRefs(this._getDomRefs());};N.prototype._getDomRefs=function(){var d=[];var b=this.getItems();for(var i=0;i<b.length;i++){q.merge(d,b[i]._getDomRefs());}return d;};N.prototype._adaptPopoverPositionParams=function(){if(this.getShowArrow()){this._marginLeft=10;this._marginRight=10;this._marginBottom=10;this._arrowOffset=18;this._offsets=["0 -18","18 0","0 18","-18 0"];this._myPositions=["center bottom","begin top","center top","end top"];this._atPositions=["center top","end top","center bottom","begin top"];}else{this._marginTop=0;this._marginLeft=0;this._marginRight=0;this._marginBottom=0;this._arrowOffset=0;this._offsets=["0 0","0 0","0 0","0 0"];this._myPositions=["begin bottom","begin top","begin top","end top"];this._atPositions=["begin top","end top","begin bottom","begin top"];}};N.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();}};N.prototype._selectItem=function(p){this.fireItemSelect(p);var i=p.item;if(this._selectedItem){this._selectedItem._unselect();}i._select();this._selectedItem=i;this.setAssociation('selectedItem',i,true);};N.prototype.getSelectedItem=function(){var s=this.getAssociation('selectedItem');if(!s){return null;}return sap.ui.getCore().byId(s);};N.prototype.setSelectedItem=function(s,b){q.sap.require('sap.tnt.NavigationListItem');var n;if(this._selectedItem){this._selectedItem._unselect();}if(!s){this._selectedItem=null;return sap.ui.core.Control.prototype.setAssociation.call(this,'selectedItem',s,b);}if(typeof s!=='string'&&!(s instanceof sap.tnt.NavigationListItem)){q.sap.log.warning('Type of selectedItem association should be string or instance of sap.tnt.NavigationListItem. New value was not set.');return this;}if(typeof s==='string'){n=sap.ui.getCore().byId(s);}else{n=s;}if(n instanceof sap.tnt.NavigationListItem){n._select();this._selectedItem=n;return sap.ui.core.Control.prototype.setAssociation.call(this,'selectedItem',s,b);}else{q.sap.log.warning('Type of selectedItem association should be a valid NavigationListItem object or ID. New value was not set.');return this;}};N.prototype._openPopover=function(s,b){var t=this;var c=b.getSelectedItem();if(c&&b.isGroupSelected){c=null;}var p=this._popover=new P({showHeader:false,horizontalScrolling:false,verticalScrolling:true,initialFocus:c,afterClose:function(){if(t._popover){t._popover.destroy();t._popover=null;}},content:b,ariaLabelledBy:[N._sAriaPopupLabelId]}).addStyleClass('sapContrast sapContrastPlus');p._adaptPositionParams=this._adaptPopoverPositionParams;p.openBy(s);};N.prototype._closePopover=function(){if(this._popover){this._popover.close();}};return N;},true);
